
/*

  SmartClient Ajax RIA system
  Version v9.0p_2021-05-01/EVAL Deployment (2021-05-01)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

var isc = window.isc ? window.isc : {};if(window.isc&&!window.isc.module_Core){isc.module_Core=1;isc._moduleStart=isc._Core_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'Core load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (!window.isc || typeof isc.Packager != "object") {

//> @class isc
// The <code>isc</code> object contains global methods and objects of the Isomorphic SmartClient
// framework.
// <P>
// See also +link{group:simpleNamesMode,Simple Names mode}.
//
// @treeLocation Client Reference/System
// @visibility external
//<

//> @groupDef simpleNamesMode
// When SmartClient runs in "simple names" mode (the default), all ISC Classes and several
// global methods are installed as JavaScript global variables, that is, properties of the
// browser's "window" object.  When simple names mode is disabled (called "portal mode"),
// the framework uses only the global variable: "isc" and global variables prefixed with
// "isc_".
// <P>
// Portal mode is intended for applications which must integrate with fairly arbitrary
// JavaScript code written by third-party developers, and/or third party JavaScript frameworks,
// where it is important that each framework stays within it's own namespace.
// <P>
// <var class="smartclient">
// In portal mode, all references to ISC classes and global functions must be prefixed with
// "isc.", for example:<pre>
//
//      Canvas.create(addProperties({}, myDefaults))
//
// </pre>would become<pre>
//
//      isc.Canvas.create(isc.addProperties({}, myDefaults));
//
// </pre>
// </var>
// Portal mode is enabled by setting <code>window.isc_useSimpleNames = false</code> <b>before</b>
// SmartClient is loaded, generally inside the &lt;head&gt; element.
//
// @treeLocation Client Reference/System
// @title Simple Names mode
// @visibility external
//<





var isc = window.isc ? window.isc : {};
isc._start = new Date().getTime();

// versioning - values of the form ${value} are replaced with user-provided values at build time.
// Valid values are: version, date, project (not currently used)
isc.version = "v9.0p_2021-05-01/EVAL Deployment";
isc.versionNumber = "v9.0p_2021-05-01";
isc.buildDate = "2021-05-01";
isc.expirationDate = "2021.06.30_12.34.01";

// license template data
isc.licenseType = "Eval";
isc.licenseCompany = "Isomorphic Software";
isc.licenseSerialNumber = "ISC_EVAL_NIGHTLY";
isc.licensingPage = "http://smartclient.com/product/";

isc._$debugModules = "debugModules";
isc._$nonDebugModules = "nonDebugModules";
isc.checkForDebugAndNonDebugModules = function () {
    if (isc.checkForDebugAndNonDebugModules._loggedWarning) return;
    var debugModules = isc['_' + this._$debugModules],
        haveDebugModules = debugModules != null && debugModules.length > 0,
        nonDebugModules = isc['_' + this._$nonDebugModules],
        haveNonDebugModules = nonDebugModules != null && nonDebugModules.length > 0;

    if (haveDebugModules && haveNonDebugModules) {
        isc.logWarn("Both Debug and non-Debug modules were loaded; the Debug versions of '" +
        debugModules.join("', '") + "' and the non-Debug versions of '" + nonDebugModules.join("', '") +
        "' were loaded. Mixing Debug and non-Debug modules is not supported and may lead to " +
        "JavaScript errors and/or unpredictable behavior. " +
        "To fix, ensure that only modules in the modules/ folder or the modules-debug/ " +
        "folder are loaded and clear the browser cache. If using Smart GWT, also clear the " +
        "GWT unit cache and recompile.");
        isc.checkForDebugAndNonDebugModules._loggedWarning = true;
    }
};

isc._optionalModules = {
    SCServer: {present: "true", name: "SmartClient Server", serverOnly: true, isPro: true},
    Drawing: {present: "true", name: "Drawing Module"},
    PluginBridges: {present: "true", name: "PluginBridges Module"},
    RichTextEditor: {present: "true", name: "RichTextEditor Module"},
    Calendar: {present: "true", name: "Calendar Module"},
    Analytics: {present: "true", name: "Analytics Module"},
    Charts: {present: "true", name: "Charts Module"},
    Tools: {present: "${includeTools}", name: "Portal and Tools Module"},
    NetworkPerformance: {present: "true", name: "Network Performance Module"},
    // alias for NetworkPerformance
    FileLoader: {present: "true", name: "Network Performance Module"},
    RealtimeMessaging: {present: "true", name: "RealtimeMessaging Module"},
    // Enterprise Features
    serverCriteria: {present: "true", name: "Server Advanced Filtering", serverOnly: true, isFeature: true},
    customSQL: {present: "true", name: "SQL Templating", serverOnly: true, isFeature: true},
    chaining: {present: "true", name: "Transaction Chaining", serverOnly: true, isFeature: true},
    batchDSGenerator: {present: "true", name: "Batch DS-Generator", serverOnly: true, isFeature: true},
    batchUploader: {present: "true", name: "Batch Uploader", serverOnly: true, isFeature: true},
    transactions: {present: "true", name: "Automatic Transaction Management", serverOnly: true, isFeature: true}
};
isc.canonicalizeModules = function (modules) {
    if (!modules) return null;

    // canonicalize to Array, split on comma
    if (isc.isA.String(modules)) {
        if (modules.indexOf(",") != -1) {
            modules = modules.split(",");
            var trimLeft = /^\s+/, trimRight = /\s+$/;
            for (var i=0; i<modules.length; i++) {
                modules[i] = modules[i].replace(trimLeft, "").replace(trimRight, "");
            }
        } else modules = [modules];
    }
    return modules;
};
isc.hasOptionalModules = function (modules) {
    // ease of use shortcut, null value means no optional module requirements
    if (!modules) return true;

    modules = isc.canonicalizeModules(modules);

    for (var i = 0; i < modules.length; i++) if (!isc.hasOptionalModule(modules[i])) return false;
    return true;
};
isc.getMissingModules = function (requiredModules) {
    var result = [];
    requiredModules = isc.canonicalizeModules(requiredModules);
    for (var i = 0; i < requiredModules.length; i++) {
        var module = requiredModules[i];
        if (!isc.hasOptionalModule(module)) result.add(isc._optionalModules[module]);
    }
    return result;
};
isc.hasOptionalModule = function (module) {
    var v = isc._optionalModules[module];
    if (!v) {
        if(isc.Log) isc.Log.logWarn("isc.hasOptionalModule - unknown module: " + module);
        return false;
    }
    // has module or devenv
    return v.present == "true" || v.present.charAt(0) == "$";
};
isc.getOptionalModule = function (module) {
    return isc._optionalModules[module];
};

// default to "simple names" mode, where all ISC classes are defined as global variables
isc._useSimpleNames = window.isc_useSimpleNames;
if (isc._useSimpleNames == null) isc._useSimpleNames = true;

// register with the OpenAjax hub, if present
if (window.OpenAjax) {
    // OpenAjax insists on only numbers and dots.  This regex will convert eg 5.6b3 to 5.6.03,
    // which is not really accurate
    isc._numericVersion = isc.versionNumber.replace(/[a-zA-Z_]+/, ".0");
    OpenAjax.registerLibrary("SmartClient", "http://smartclient.com/SmartClient",
                             isc._numericVersion,
                             { namespacedMode : !isc._useSimpleNames,
                               iscVersion : isc.version,
                               buildDate : isc.buildDate,
                               licenseType : isc.licenseType,
                               licenseCompany : isc.licenseCompany,
                               licenseSerialNumber : isc.licenseSerialNumber });
    OpenAjax.registerGlobals("SmartClient", ["isc"]);
}


isc._longDOMIds = window.isc_useLongDOMIDs;

// add a property to global scope.  This property will always be available as "isc[propName]" and
// will also be available as "window[propName]" if we are in "simpleNames" mode.
// NOTE: even in simpleNames mode, where we assume it's OK to put things into global scope, we
// should still think carefully about creating globals.  Eg a variable like "params" which holds the
// current URL parameters (which we used to have) could easily get clobbered by some sloppy global
// JS, causing mysterious crashes.  Consider creating a class method (eg Page.getWidth()) or class
// property (Log.logViewer) instead, or making the variable isc.myMethod() or isc.myProperty.
isc._$iscPrefix = "isc.";
isc.addGlobal = function (propName, propValue) {
    if (propName.indexOf(isc._$iscPrefix) == 0) propName = propName.substring(4);
    isc[propName] = propValue;
    if (isc._useSimpleNames) window[propName] = propValue;
}





//>Offline

//XXX need to determine this flag correctly at load time
isc.onLine = true;

isc.isOffline = function () {
    return !isc.onLine;
};
isc.goOffline = function () { isc.onLine = false; };
isc.goOnline = function () { isc.onLine = true; };
if (window.addEventListener) {
    window.addEventListener("online", isc.goOnline, false);
    window.addEventListener("offline", isc.goOffline, false);
}
//<Offline


}



// =================================================================================================
// IMPORTANT :If you update this file, also update FileLoader.js that has a subset of these checks
// =================================================================================================



if (typeof isc.Browser != "object") {




//>    @object    Browser
// Object containing flags indicating basic attributes of the browser.
// @treeLocation Client Reference/Foundation
// @visibility external
//<
isc.addGlobal("Browser", {
    isSupported:false
});


// ----------------------------------------------------------------
// Detecting browser type
// ----------------------------------------------------------------

//>    @classAttr    Browser.isOpera        (boolean : ? : R)
//        Are we in Opera ?
//<
isc.Browser.isOpera = (navigator.appName == "Opera" ||
                    navigator.userAgent.indexOf("Opera") != -1);

//>    @classAttr    Browser.isNS (boolean : ? : R)
//        Are we in Netscape (including Navigator 4+, NS6 & 7, and Mozilla)
//      Note: Safari also reports itself as Netscape, so isNS is true for Safari.
//<
isc.Browser.isNS = (navigator.appName == "Netscape" && !isc.Browser.isOpera);

//>    @classAttr    Browser.isIE        (boolean : ? : R)
//        Are we in Internet Explorer?
//<
isc.Browser.isIE = (navigator.appName == "Microsoft Internet Explorer" &&
                    !isc.Browser.isOpera) ||
                   navigator.userAgent.indexOf("Trident/") != -1;

//>    @classAttr    Browser.isMSN        (boolean : ? : R)
//      Are we in the MSN browser (based on MSIE, so isIE will be true in this case)
//<
isc.Browser.isMSN = (isc.Browser.isIE && navigator.userAgent.indexOf("MSN") != -1);


//>    @classAttr    Browser.isMoz        (boolean : ? : R)
//        Are we in any Mozilla-derived browser, that is, a browser based on Netscape's Gecko
//      engine? (includes Mozilla and Netscape 6+)
//<
isc.Browser.isMoz = (navigator.userAgent.indexOf("Gecko") != -1) &&
    // NOTE: Safari sends "(like Gecko)", but behaves differently from Moz in many ways

    (navigator.userAgent.indexOf("Safari") == -1) &&
    (navigator.userAgent.indexOf("AppleWebKit") == -1) &&
    !isc.Browser.isIE;

//>    @classAttr    Browser.isCamino (boolean : false : R)
//  Are we in Mozilla Camino?
//<
isc.Browser.isCamino = (isc.Browser.isMoz && navigator.userAgent.indexOf("Camino/") != -1);

//>    @classAttr    Browser.isFirefox (boolean : false : R)
//  Are we in Mozilla Firefox?
//<
isc.Browser.isFirefox = (isc.Browser.isMoz && navigator.userAgent.indexOf("Firefox/") != -1);


//> @classAttr  Browser.isAIR    (boolean : ? : R)
// Is this application running in the Adobe AIR environment?
//<
isc.Browser.isAIR = (navigator.userAgent.indexOf("AdobeAIR") != -1);

//>    @classAttr    Browser.isWebKit (boolean : ? : R)
// Are we in a WebKit-based browser (Safari, Chrome, mobile Safari and Android, others).
//<
isc.Browser.isWebKit = navigator.userAgent.indexOf("WebKit") != -1;

//>    @classAttr    Browser.isSafari (boolean : ? : R)
// Are we in Apple's "Safari" browser? Note that this property will also be set for other
// WebKit based browsers (such as Google Chrome).
//<
// As far as we know all "true" Safari implementations idenify themselves in the userAgent with
// the string "Safari".
// However the GWT hosted mode browser on OSX is also based on apple webkit and should be treated
// like Safari but is not a Safari browser and doesn't identify itself as such in the useragent
// Reported UserAgent:
//  Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; en-us) AppleWebKit/525.18 (KHTML, like Gecko)
isc.Browser.isSafari = isc.Browser.isAIR || navigator.userAgent.indexOf("Safari") != -1 ||
                        navigator.userAgent.indexOf("AppleWebKit") != -1;


//> @classAttr Browser.isEdge (boolean : ? : R)
// Are we in the Microsoft Edge browser?
//<
// Behaves like Safari in most ways
isc.Browser.isEdge = isc.Browser.isSafari && (navigator.userAgent.indexOf("Edge/") != -1);

//> @classAttr Browser.isChrome (boolean : ? : R)
// Are we in the Google Chrome browser?
//<
// Behaves like Safari in most ways.  Note: do not detect Edge as Chrome - causes odd scrollbar
// misrenderings.  As of 7/30/2015 appears to work better with the isSafari codepaths
isc.Browser.isChrome = isc.Browser.isSafari && !isc.Browser.isEdge && (navigator.userAgent.indexOf("Chrome/") != -1);



if (!isc.Browser.isIE && !isc.Browser.isOpera && !isc.Browser.isMoz &&
    !isc.Browser.isAIR && !isc.Browser.isWebkit && !isc.Browser.isSafari)
{
    if (navigator.appVersion.indexOf("MSIE") != -1) {
        isc.Browser.isIE = true;
    }
}

// ----------------------------------------------------------------
// END Detecting browser type
// ----------------------------------------------------------------


//>    @classAttr Browser.minorVersion        (number : ? : R)
//        Browser version, with minor revision included (4.7, 5.5, etc).
//
// NOTE: In Firefox 16+, Browser.minorVersion will equal Browser.version by design. See
// Firefox +externalLink{https://bugzilla.mozilla.org/show_bug.cgi?id=728831,Bug 728831}.
//<
if (navigator.userAgent.indexOf("Trident/") >= 0 &&
    navigator.userAgent.lastIndexOf("rv:") >= 0)
{

    isc.Browser.minorVersion = parseFloat(navigator.userAgent.substring(navigator.userAgent.lastIndexOf("rv:") + "rv:".length));
} else {
    isc.Browser.minorVersion = parseFloat(isc.Browser.isIE
                                      ? navigator.appVersion.substring(navigator.appVersion.indexOf("MSIE") + 5)
                                      : navigator.appVersion );
}
if (!isc.Browser.isIE) (function () {


    var needle, pos;
    if (navigator.appVersion) {
        // Safari
        needle = "Version/";
        pos = navigator.appVersion.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(navigator.appVersion.substring(pos + needle.length));
            return;
        }
    }

    var ua = navigator.userAgent;

    needle = "Chrome/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    // Handle Camino before Firefox because Camino includes "(like Firefox/x.x.x)" in the UA.
    needle = "Camino/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    needle = "Firefox/";
    pos = ua.indexOf(needle);
    if (pos >= 0) {
        isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
        return;
    }

    if (ua.indexOf("Opera/") >= 0) {
        needle = "Version/";
        pos = ua.indexOf(needle);
        if (pos >= 0) {
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        } else {
            // Opera 9.64
            needle = "Opera/";
            pos = ua.indexOf(needle);
            isc.Browser.minorVersion = parseFloat(ua.substring(pos + needle.length));
            return;
        }
    }
})();

//>    @classAttr    Browser.version        (number : ? : R)
//        Browser major version number (integer: 4, 5, etc).
//<
isc.Browser.version = parseInt(isc.Browser.minorVersion);

// actually means IE6 or earlier, which requires radically different optimization techniques
isc.Browser.isIE6 = isc.Browser.isIE && isc.Browser.version <= 6;


//>    @classAttr    Browser.caminoVersion (string : ? : R)
//        For Camino-based browsers, the Camino version number.
//<
if (isc.Browser.isCamino) {
    // Camino Version is the last thing in the userAgent
    isc.Browser.caminoVersion =
        navigator.userAgent.substring(navigator.userAgent.indexOf("Camino/") +7);
}

if (isc.Browser.isFirefox) {
//>    @classAttr    Browser.firefoxVersion (string : ? : R)
//        For Firefox-based browsers, the Firefox version number.
//          - 0.10.1    is Firefox PR 1
//      After this the version numbers reported match those in the about dialog
//          - 1.0       is Firefox 1.0
//          - 1.0.2     is Firefox 1.0.2
//          - 1.5.0.3   is Firefox 1.5.0.3
//<
    var userAgent = navigator.userAgent,
        firefoxVersion = userAgent.substring(userAgent.indexOf("Firefox/")+ 8),
        majorMinorVersion = firefoxVersion.replace(/([^.]+\.[^.]+)\..*/, "$1");
    isc.Browser.firefoxVersion          = firefoxVersion;
    isc.Browser.firefoxMajorMinorNumber = parseFloat(majorMinorVersion);
}

//>    @classAttr    Browser.geckoVersion (integer : ? : R)
//        For Gecko-based browsers, the Gecko version number.
//      Looks like a datestamp:
//          - 20011019 is Netscape 6.2
//          - 20020530 is Mozilla 1.0
//          - 20020823 is Netscape 7.0
//          - 20020826 is Mozilla 1.1
//          - 20021126 is Mozilla 1.2
//          - 20030312 is Mozilla 1.3
//          - 20030624 is Mozilla 1.4
//          - 20031007 is Mozilla 1.5
//          - 20031120 is Mozilla 1.5.1 (Mac only release)
//          - 20040113 is Mozilla 1.6
//          - 20040616 is Mozilla 1.7
//          - 20040910 is Mozilla 1.73
//          - 20041001 is Mozilla Firefox PR1 (-- also see firefox version)
//          - 20041107 is Mozilla Firefox 1.0
//          - 20050915 is Mozilla Firefox 1.0.7
//          - 20051107 is Mozilla Firefox 1.5 RC2
//          - 20051111 is Mozilla Firefox 1.5 final
//          - 20060426 is Mozilla Firefox 1.5.0.3
//          - 20061010 is Mozilla Firefox 2.0
//          - 20070321 is Netscape 8.1.3 - LIES - really based on Firefox 1.0 codebase
//          - 20071109 is Firefox 3.0 beta 1
//          - 20080529 is Firefox 3.0
//          - 20100101 is Firefox 4.0.1
//<

if (isc.Browser.isMoz) {
    isc.Browser._geckoVIndex = navigator.userAgent.indexOf("Gecko/") + 6;
    // The 'parseInt' actually means we could just grab everything from the
    // end of "Gecko/" on, as we know that even if the gecko version is followed
    // by something, there will be a space before the next part of the UA string
    // However, we know the length, so just use it
    isc.Browser.geckoVersion = parseInt(
        navigator.userAgent.substring(
            isc.Browser._geckoVIndex, isc.Browser._geckoVIndex+8
        )
    );



    if (isc.Browser.isFirefox) {
        // clamp 1.0.x series to last known pre 1.5 version (1.0.7)
        if (isc.Browser.firefoxVersion.match(/^1\.0/)) isc.Browser.geckoVersion = 20050915;
        // clamp 2.0.x series to one day before near-final FF3 beta
        else if (isc.Browser.firefoxVersion.match(/^2\.0/)) isc.Browser.geckoVersion = 20071108;
    }


    if (isc.Browser.version >= 17) isc.Browser.geckoVersion = 20121121;
}

// Doctypes
//  Are we in strict standards mode.  This applies to IE6+ and all Moz 1.0+.
//
//  In strict mode, browsers attempt to behave in a more standards-compliant manner.  Of course,
//  standards interpretation varies pretty drastically between browser makers, so this is in effect
//  just another fairly arbitrary set of behaviors which continues to vary across browser makers,
//  and now also across modes within the same browser.
//
// Traditionally, we have essentially 3 cases to consider:
// - BackCompat / Quirks mode. This is the rendering used if docType is not specified, or if
//   specified as 'Transitional' or 'Frameset' / with no URI
//   (EG: <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">)
//   This is the default mode.
// - Strict. Completely standards complient.
//   Triggered by
//   <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
// - "Almost Strict" (AKA Transitional).
//   In IE this matches Strict mode completely.
//   In Moz it matches strict mode except for rendering of images within tables - see
//   http://developer.mozilla.org/en/docs/Images%2C_Tables%2C_and_Mysterious_Gaps
//   Triggered "transitional" doctype with URI
//   Reports document.compatMode as "CSS1Compat"
// - http://developer.mozilla.org/en/docs/Gecko%27s_%22Almost_Standards%22_Mode
// - http://www.htmlhelp.com/reference/html40/html/doctype.html
// - http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
//
// - we also have the HTML5 doctype to consider - <!DOCTYPE html>. Only applies to modern
//   browsers, and required for some of our more recent features (EG some drawing approaches)
//   We don't explicitly have a flag to differentiate between this and "isStrict"

//> @classAttr  Browser.isStrict    (boolean : ? : R)
//  Are we in strict standards mode.
//<
// HACK: Netscape6 does not report document.compatMode, so we can't tell that a DOCTYPE has been
// specified, but Netscape6 IS affected by a DOCTYPE.  So, in Netscape6, assume we're always in
// strict mode.  At the moment (3/30/03) all strict mode workarounds have identical behavior in
// normal mode.

isc.Browser.isStrict = document.compatMode == "CSS1Compat";
if (isc.Browser.isStrict && isc.Browser.isMoz) {

    isc.Browser._docTypePublicID = document.doctype.publicId;
    isc.Browser._docTypeSystemID = document.doctype.systemId;

}

// See http://developer.mozilla.org/en/docs/Mozilla%27s_DOCTYPE_sniffing
// See Drawing.test.html for some test cases
isc.Browser.isTransitional = /.*(Transitional|Frameset)/.test((document.all && document.all[0] && document.all[0].nodeValue) || (document.doctype && document.doctype.publicId));

isc.Browser.isIE7 = isc.Browser.isIE && isc.Browser.version == 7;

//> @classAttr Browser.isIE8 (boolean : ? : R)
// Returns true if we're running IE8 and we're in IE8 mode
// IE8 has a 'back-compat' type mode whereby it can run using IE7 rendering logic.
// This is explicitly controlled via the meta tags:
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
// or
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// In beta versions IE8 reported itself version 7 and ran in IE7 mode unless the explicit IE8
// tag was present
// In final versions (observed on 8.0.6001.18702) it reports a browser version of 8 and runs
// in IE8 mode by default - but can be switched into IE7 mode via the explicit IE=7 tag.
//
// We therefore want to check the document.documentMode tag rather than just the standard
// browser version when checking for IE8
//<
isc.Browser.isIE8 = isc.Browser.isIE && isc.Browser.version>=8 && document.documentMode == 8;

//<
//> @classAttr Browser.isIE8Strict (boolean : ? : R)
// Are we in IE8 [or greater] strict mode.
// <P>
// In IE8 when the meta tag is present to trigger IE7 / IE8 mode the document is in
//
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=8" /&gt;
//    &lt;meta http-equiv="X-UA-Compatible" content="IE=7" /&gt;
//
// If this tag is present, the document is in strict mode even if no DOCTYPE was present.
// The presence of this tag can be detected as document.documentMode being 8 rather than 7.
// document.compatMode still reports "CSS1Compat" as with earlier IE.
//<
// IE9 running in IE9 mode will report as IE8Strict:true. This makes sense since rendering quirks
// introduced in IE8 Strict, such as requiring explicit "overflow:hidden" in addition
// to table-layout-fixed in order to clip cells horizontally in tables apply in both places.
// For cases where we really need to distinguish we can check isc.Browser.version or isc.Browser.isIE9

isc.Browser.isIE8Strict = isc.Browser.isIE &&
                            (isc.Browser.isStrict && document.documentMode ==8) ||
                            document.documentMode > 8;

//> @classAttr Browser.isIE9 (boolean : ? : R)
// Returns true if we're running IE9, running as IE9
//<

isc.Browser.isIE9 = isc.Browser.isIE && isc.Browser.version>=9 && document.documentMode >= 9;

isc.Browser.isIE10 = isc.Browser.isIE && isc.Browser.version >= 10;

isc.Browser.isIE11 = isc.Browser.isIE && isc.Browser.version >= 11;

//> @classAttr  Browser.AIRVersion (string : ? : R)
// If this application running in the Adobe AIR environment, what version of AIR is
// running. Will be a string, like "1.0".
//<
isc.Browser.AIRVersion = (isc.Browser.isAIR ? navigator.userAgent.substring(navigator.userAgent.indexOf("AdobeAir/") + 9) : null);


//>    @classAttr    Browser.safariVersion (number : ? : R)
//        in Safari, what is is the reported version number
//<

if (isc.Browser.isSafari) {

    if (isc.Browser.isAIR) {

        isc.Browser.safariVersion = 530;
    } else {
        if (navigator.userAgent.indexOf("Safari/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("Safari/") + 7
            );
        } else if (navigator.userAgent.indexOf("AppleWebKit/") != -1) {
            isc.Browser.rawSafariVersion = navigator.userAgent.substring(
                        navigator.userAgent.indexOf("AppleWebKit/") + 12
            );

        } else {
            isc.Browser.rawSafariVersion = "530"
        }



        isc.Browser.safariVersion = (function () {
            var rawVersion = isc.Browser.rawSafariVersion,
                currentDot = rawVersion.indexOf(".");

            if (currentDot == -1) return parseInt(rawVersion);
            var version = rawVersion.substring(0,currentDot+1),
                nextDot;
            while (currentDot != -1) {
                // Check AFTER the dot
                currentDot += 1;
                nextDot = rawVersion.indexOf(".", currentDot);
                version += rawVersion.substring(currentDot,
                                                (nextDot == -1 ? rawVersion.length: nextDot));
                currentDot = nextDot;
            }
            return parseFloat(version);
        })();
    }
}

// -------------------------------------------------------------------
// Platform information
// -------------------------------------------------------------------

//>    @classAttr    Browser.isWin        (boolean : ? : R)
//        Is this a Windows computer ?
//<
isc.Browser.isWin = navigator.platform.toLowerCase().indexOf("win") > -1;
// NT 5.0 is Win2k, NT5.0.1 is Win2k SP1
isc.Browser.isWin2k = navigator.userAgent.match(/NT 5.01?/) != null;

//>    @classAttr    Browser.isMac        (boolean : ? : R)
//        Is this a Macintosh computer ?
//<
isc.Browser.isMac = navigator.platform.toLowerCase().indexOf("mac") > -1;

isc.Browser.isUnix = (!isc.Browser.isMac &&! isc.Browser.isWin);

//> @groupDef mobileDevelopment
// SmartClient supports building web applications that can be accessed by mobile devices that
// support modern web browsers, specifically:
// <ul>
// <li> Safari on iOS devices (iPad, iPhone, iPod Touch)
// <li> Android's default (WebKit-based) browser
// <li> Windows Phone 7 (future, for 'Mango' and up)
// <li> Blackberry devices that use a WebKit-based browser (future)
// </ul>
// Via "packaging" technologies such as Titanium and PhoneGap, a SmartClient web application
// can be packaged as an installable native application that can be delivered via the "App Store"
// for the target mobile platform.  Applications packaged in this way have access to phone-specific
// data and services such as contacts stored on the phone, or the ability to invoke the device's camera.
// <P>
// Both Titanium and PhoneGap are open source mobile development frameworks which provide access to the
// underlying native device APIs such as the accelerometer, geolocation, and UI. Both frameworks enable
// application development using only JavaScript, CSS and HTML. Additionally they provide development environments
// that work across a wide variety of devices.
// <P>
// PhoneGap has good support for native device APIs as noted +externalLink{http://www.phonegap.com/about/feature,here}.
// Titanium has similar support. There are differences between the two environments and how they
// expose their APIs, though both provide Xcode-compatible projects that can be compiled and run from the Xcode IDE.
// See +link{titaniumIntegration,Integration with Titanium} and +link{phonegapIntegration,Integration with PhoneGap}
// for more information.
// <P>
// <h3>Finger / touch events</h3>
// <P>
// Mobile and touch devices support "touch events" that correspond to finger actions on the
// screen.  By default, SmartClient simply sends touch events to UI components as normal mouse
// events.  Specifically:
// <ul>
// <li> a finger tap gesture will trigger mouseDown, mouseUp and click events
// <li> a touch-and-slide interaction will trigger drag and drop, firing the normal SmartClient
//      sequence of dragStart, dragMove, and dragStop
// <li> a touch-and-hold interaction will trigger a contextMenu event, and will trigger a hover
//      if no contextMenu is shown
// </ul>
// This means that most applications that are written initially to target desktop computers
// need little or no modification in order be able to run on tablet-sized devices (eg the
// iPad).  For handset-sized devices (phones, iPod touch), conditional logic may need to be
// added to make different use of the screen real estate.
// <P>
// <h3>Mobile look and feel</h3>
// <P>
// The "Mobile" skin should be used whenever mobile devices are detected.  This skin roughly
// mimics the appearance of the iOS default widgets wherever there is an iOS widget that
// corresponds closely to a given SmartClient widget.  It also makes extensive use of CSS3 to
// minimize the use of images while still providing an attractive look and feel.
// <P>
// In addition, this skin also changes the behavior of some SmartClient widgets to match the
// UI idioms common on mobile devices.  For example, the TabSet component switches to
// bottom-oriented tabs, which are flush together (no gaps).  If there are more than a certain
// number of tabs, a special "More" tab appears which lists other remaining tabs.  Among other
// examples, this is the behavior of the "iPad" application on iOS devices, and is an efficient
// use of minimal screen real estate which feels natural when used on a mobile device.
// <P>
// In order to detect whether to use the Mobile skin, because of the rapid proliferation of
// mobile devices, we recommend using server-side detection based on the User-Agent HTTP
// header, and using conditional logic (such as logic in a .jsp) to load the "Mobile" skin
// specifically for these devices.
// <P>
// <h3>Adapting to Screen Size and Orientation Change</h3>
// <P>
// Safari on the Apple iPod/iPhone supports explicitly configuring the viewport as detailed here:
// +externalLink{http://developer.apple.com/safari/library/documentation/AppleApplications/Reference/SafariWebContent/UsingtheViewport/UsingtheViewport.html}.
// Including these meta tags in your bootstrap HTML file will allow you to set
// a default "zoom level" - how many pixels show up on the screen in landscape or portrait
// mode as well as disabling the user's standard zoom interactions. We also have
// +link{Page.updateViewport(),an API} to configure the viewport programmatically at runtime.
// <P>
// Note that the +link{Page.getOrientation()} API may be used to determine the current
// orientation of the application, and +link{pageEvent,the page orientationChange event} will fire
// whenever the user rotates the screen allowing applications to directly respond to the user
// pivoting their device.
//
// @title Mobile Application Development
// @treeLocation Concepts
// @visibility external
//<


//> @groupDef titaniumIntegration
// Titanium provides an extensive Javascript API to access a native device's UI, phone, camera, geolocation, etc.
// Documentation, getting started, programming guides are +externalLink{http://developer.appcelerator.com/documentation,here}.
// Titanium provides a consistent API across devices including the ability to mix webviews with native controls.
// <P>
// The Titanium sample application provides an example of accessing a device's Contacts db using SmartClient.
// The application presents 2 tabs 'Customers' and 'Contacts' and allows the user to import Customer contacts into
// his/her contacts db resident on the device. Selecting a Customer's Contact address will show a map of the contact.
// Selecting a Customer's phone number will call the customer or prompt to import the contact into the user's
// contacts. The latter option is default behavior on the iPad. Calling the customer contact is default behavior for
// devices such as the iPhone or Android.
// <P>
// The Titanium Contact object holds the following properties:
// <ul>
// <li>URL</li>
// <li>address</li>
// <li>birthday</li>
// <li>created</li>
// <li>date</li>
// <li>department</li>
// <li>email</li>
// <li>firstName</li>
// <li>firstPhonetic</li>
// <li>fullName</li>
// <li>image</li>
// <li>instantMessage</li>
// <li>jobTitle</li>
// <li>kind</li>
// <li>lastName</li>
// <li>lastPhonetic</li>
// <li>middleName</li>
// <li>middlePhonetic</li>
// <li>modified</li>
// <li>nickname</li>
// <li>note</li>
// <li>organization</li>
// <li>phone</li>
// <li>prefix</li>
// <li>relatedNames</li>
// <li>suffix</li>
// </ul>
// <P>
// The following Titanium API's are used:
// <ul>
// <li>Titanium.App.addEventListener</li>
// <li>Titanium.App.fireEvent</li>
// <li>Titanium.Contacts.getAllPeople</li>
// <li>Titanium.Geolocation.forwardGeocoder</li>
// <li>Titanium.Map.STANDARD_TYPE,</li>
// <li>Titanium.Map.createView</li>
// <li>Titanium.UI.createTab</li>
// <li>Titanium.UI.createTabGroup</li>
// <li>Titanium.UI.createWebView</li>
// <li>Titanium.UI.createWindow</li>
// <li>Titanium.UI.setBackgroundColor</li>
// </ul>
// <P>
// The following SmartClient Components are used
// <ul>
// <li>isc.DataSource</li>
// <li>isc.ListGrid</li>
// </ul>
// <P>
// The following SmartClient Resources are bundled in the Titanium application
// <ul>
// <li>ISC_Containers.js</li>
// <li>ISC_Core.js</li>
// <li>ISC_DataBinding.js</li>
// <li>ISC_Foundation.js</li>
// <li>ISC_Grids.js</li>
// <li>load_skin.js</li>
// <li>skins/Mobile/images/black.gif</li>
// <li>skins/Mobile/images/blank.gif</li>
// <li>skins/Mobile/images/checked.png</li>
// <li>skins/Mobile/images/formula_menuItem.png</li>
// <li>skins/Mobile/images/grid.gif</li>
// <li>skins/Mobile/images/group_closed.gif</li>
// <li>skins/Mobile/images/group_opened.gif</li>
// <li>skins/Mobile/images/headerMenuButton_icon.gif</li>
// <li>skins/Mobile/images/loading.gif</li>
// <li>skins/Mobile/images/loadingSmall.gif</li>
// <li>skins/Mobile/images/opacity.png</li>
// <li>skins/Mobile/images/pinstripes.png</li>
// <li>skins/Mobile/images/row_collapsed.gif</li>
// <li>skins/Mobile/images/row_expanded.gif</li>
// <li>skins/Mobile/images/sort_ascending.gif</li>
// <li>skins/Mobile/images/sort_descending.gif</li>
// <li>skins/Mobile/skin_styles.css</li>
// </ul>
//
// @title Integration with Titanium
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

//> @groupDef phonegapIntegration
// <P>
// PhoneGap documentation, quick start information, and programming guides are available at +externalLink{http://www.phonegap.com/,http://www.phonegap.com/}.
// <P>
// PhoneGap exposes a Contacts API which allows one to find, create and remove contacts from the device's contacts database.
// Unlike Titanium, which provides many native UI components, PhoneGap relies on 3rd party frameworks for
// UI components. Additionally, PhoneGap provides no transitions or other animation effects normally
// accessible in native applications.
// <P>
// In the following guide, the name "MyMobileApp" refers to a <!--<var class="smartclient">-->SmartClient<!--</var>--><!--<var class="smartgwt">-->Smart&nbsp;GWT<!--</var>-->
// mobile application. The instructions are intended to be general, and applicable to other apps by simply substituting the application name
// and the few other app-specific details.
//
// <h3>General Instructions</h3>
// For each target that PhoneGap supports, there is a special <code>www/</code> folder which contains
// the application JavaScript code and other assets. If the <code>www/</code> folder was created for you,
// the only file that is needed within is <code>cordova-x.x.x.js</code>. All other files can be deleted.
//
// <p>Copy your <!--<var class="smartclient">-->SmartClient<!--</var>--><!--<var class="smartgwt">-->compiled Smart&nbsp;GWT<!--</var>-->
// application into the <code>www/</code> folder. You will need to open the application's main HTML
// file in a text editor to make a few changes:
// <ul>
//   <li>Change the DOCTYPE to the HTML5 DOCTYPE: <code>&lt;!DOCTYPE html&gt;</code></li>
//   <li>Add a <code>&lt;script&gt;</code> tag to the <code>&lt;head&gt;</code> element to load <code>cordova-x.x.x.js</code>:
//       <pre>    &lt;script type="text/javascript" charset="UTF-8" language="JavaScript" src="cordova-x.x.x.js"&gt;&lt;/script&gt;</pre>
//
//       <p><b>NOTE:</b> There is a <code>cordova-x.x.x.js</code> for each target that PhoneGap
//       supports; they are different scripts. To set up a single codebase for multiple
//       targets, see the section titled <b>Multi-Target Codebase</b> below.</li>
//   <li>Ensure that the following <code>&lt;meta&gt;</code> tags are used, also in the <code>&lt;head&gt;</code> element:
//       <pre>    &lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;
//    &lt;meta name="format-detection" content="telephone=no"&gt;
//    &lt;meta name="viewport" content="user-scalable=no, initial-scale=1, minimum-scale=1, maximum-scale=1, width=device-width"&gt;</pre></li>
// </ul>
//
// <p>After making those changes, you will need to defer starting the application until the
//    <code>+externalLink{http://docs.phonegap.com/en/edge/cordova_events_events.md.html#deviceready,deviceready}</code> event has fired,
//    particularly if your application invokes any PhoneGap API function.
//
//        <!--<var class="smartclient">-->In SmartClient, deferring the application can be accomplished by wrapping all application code within a 'deviceready' listener:
//        <pre class="sourcefile">&lt;script type="text/javascript" language="JavaScript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    // application code goes here
//}, false);
//&lt;/script&gt;</pre><!--</var>-->
//
//        <!--<var class="smartgwt">-->To accomplish this in Smart&nbsp;GWT, it is helpful to use a utility class together with a bit of JavaScript.
//
// <p>The following utility class can be used to defer the <code>onModuleLoad</code> code until PhoneGap is ready:
//
// <pre class="sourcefile">package com.mycompany.client;
//
//import com.google.gwt.core.client.EntryPoint;
//
//public abstract class CordovaEntryPoint implements EntryPoint {
//
//    &#x40;Override
//    public final native void onModuleLoad() &#x2F;*-{
//        var self = this;
//        if ($wnd.isDeviceReady) self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//        else {
//            var listener = $entry(function () {
//                $doc.removeEventListener("deviceready", listener, false);
//                self.&#x40;com.mycompany.client.CordovaEntryPoint::onDeviceReady()();
//            });
//            $doc.addEventListener("deviceready", listener, false);
//        }
//    }-*&#x2F;;
//
//    protected abstract void onDeviceReady();
//}</pre>
//
// <p>The <code>CordovaEntryPoint</code> class is used in conjunction with the following JavaScript,
//        which should be added before the closing <code>&lt/body&gt;</code> tag:
//
//     <pre class="sourcefile">&lt;script type="text/javascript" language="JavaScript"&gt;
//document.addEventListener("deviceready", function onDeviceReady() {
//    window.isDeviceReady = true;
//    document.removeEventListener("deviceready", arguments.callee, false);
//}, false);
//&lt;/script&gt;</pre><!--</var>-->
//
// <h3>iOS Targets (iPhone &amp; iPad)</h3>
// Beginning with PhoneGap / Cordova 2.0.0, special command-line tooling +externalLink{http://phonegap.com/2012/07/20/adobe-phonegap-2-0-released.md/,has been introduced}
// which replaces the custom Xcode project templates. To create a new project, the
// +externalLink{http://docs.phonegap.com/en/edge/guide_command-line_index.md.html#Command-Line%20Usage_ios,<code>create</code> program}
// located at <code>$PHONEGAP_SDK/lib/ios/bin/create</code> is used:
//
// <pre>$PHONEGAP_SDK/lib/ios/bin/create path/to/my_cordova_project com.MyCompany.ProjectName ProjectName</pre>
//
// <ol>
// <li>Open <b>Terminal</b> and run <code>$PHONEGAP_SDK/lib/ios/bin/create MyMobileApp-iOS com.mycompany.MyMobileApp MyMobileApp</code></li>
// <li>Within the newly-created <code>MyMobileApp-iOS/</code> folder, open the Xcode project <code>MyMobileApp.xcodeproj</code>.</li>
// <li>Follow the General Instructions above.</li>
// <li>In Xcode, using the scheme selector toolbar, set the Scheme to <b>MyMobileApp &gt; iPhone 6.0 Simulator</b> or some other simulator destination.
//     Then click the <b>Run</b> button. Xcode will start the iOS Simulator and run the app.</li>
// <li>When you are finished testing the application in the simulator, click the <b>Stop</b> button.</li>
// </ol>
//
// <p>It is helpful to pay attention to the output window when testing the app within iOS Simulator.
// The output window contains all logs to <code>+externalLink{https://developer.mozilla.org/en/DOM/console,window.console}</code> and messages from the Cordova
// framework itself. One common issue is <code>ERROR whitelist rejection: url='SOMEURL'</code>,
// which means that SOMEURL has not been added to <code>&lt;access origin="..."/&gt;</code> in <code>config.xml</code>.
// Refer to the +externalLink{http://docs.phonegap.com/en/edge/guide_whitelist_index.md.html#Domain%20Whitelist%20Guide,Domain Whitelist Guide}
// for more information.
//
// <p>You can make changes to your application and re-run it in the simulator without needing to close Xcode:
// <ol>
// <li>Stop the application if running.</li>
// <li>Select <b>Product -&gt; Clean</b></li>
// <li>Click the <b>Run</b> button.</li>
// </ol>
//
// <p>Once you have completely tested the application within the simulator, you should test the app on
// real hardware. Refer to Apple's +externalLink{https://developer.apple.com/library/ios/#documentation/Xcode/Conceptual/ios_development_workflow/00-About_the_iOS_Application_Development_Workflow/introduction.html,Tools Workflow Guide for iOS} for complete instructions on provisioning the app for testing devices, in particular, the section titled
// +externalLink{https://developer.apple.com/library/ios/#documentation/Xcode/Conceptual/ios_development_workflow/35-Distributing_Applications/distributing_applications.html#//apple_ref/doc/uid/TP40007959-CH10-SW4,Sending Your App to Testers}.
// Note that you will need to set the Scheme destination to <b>MyMobileApp &gt; iOS Device</b> for the <b>Product -&gt; Archive</b> menu option to be available.
// <!-- The previous note should help SC devs get past this common sticking point: http://stackoverflow.com/questions/3087089/xcode-build-and-archive-menu-item-disabled -->
//
// <h3>Android Targets</h3>
// To begin targeting Android devices, follow the instructions on the
// +externalLink{http://docs.phonegap.com/en/edge/guide_getting-started_android_index.md.html#Getting%20Started%20with%20Android,Getting Started with Android guide}.
// After creating the new Android app project, follow the General Instructions above.
//
// <p>It is helpful to monitor the LogCat in Eclipse to verify that your application is working correctly.
// Common errors include:
// <ul>
// <li><code>Application Error The protocol is not supported. (gap://ready)</code>
//     <p>This means that the incorrect <code>cordova-x.x.x.js</code> script is being used. You
//     must use the <code>cordova-x.x.x.js</code> for Android.<!-- http://community.phonegap.com/nitobi/topics/error_starting_app_on_android -->
//     </li>
// <li><code>Data exceeds UNCOMPRESS_DATA_MAX</code>
//     <p>There is a limit to the size of individual Android app assets, typically 1 Megabyte. This
//        error message means that one asset file exceeds this limit. You should see a popup alert
//        dialog containing the name of the problematic file, and then the app will crash.
//     <!--<var class="smartgwt">--><p>The "Data exceeds UNCOMPRESS_DATA_MAX" error can be seen if, for example, the Smart&nbsp;GWT application
//        was compiled in DETAILED or PRETTY mode.<!--</var>-->
//     </li>
// </ul>
//
// <h3>Multi-Target Codebase</h3>
// There is a <code>cordova-x.x.x.js</code> for each target that PhoneGap supports; they are
// different scripts. To target multiple platforms using a single codebase, it can be useful to
// employ a "script changer" to load the correct <code>cordova-x.x.x.js</code>:
//
// <!--<var class="smartclient">--><pre class="sourcefile">&lt;script type="text/javascript" language="JavaScript"&gt;var isomorphicDir="./";&lt;/script&gt;
//&lt;script type="text/javascript" charset="UTF-8" language="JavaScript" src="ISC_Core.js"&gt;&lt;/script&gt;
//&lt;script type="text/javascript" language="JavaScript"&gt;
//    var scriptName;
//    if (isc.Browser.isAndroid) {
//        scriptName = "cordova-2.3.0-android.js";
//    } else if (isc.Browser.isIPad || isc.Browser.isIPhone) {
//        scriptName = "cordova-2.3.0-iOS.js";
//    }
//    if (scriptName) document.write("&lt;script type='text/javascript' charset='UTF-8' " +
//                                   "language='JavaScript' src='" + encodeURI(scriptName) + "'&gt;&lt;" + "/script&gt;");
//&lt;/script&gt;</pre><!--</var>-->
// <!--<var class="smartgwt">--><pre class="sourcefile">&lt;script type="text/javascript" language="JavaScript"&gt;
//    var scriptName;
//    if (navigator.userAgent.indexOf("Android") &gt; -1) {
//        scriptName = "cordova-2.3.0-android.js";
//    } else if (navigator.userAgent.indexOf("iPhone") &gt; -1 || navigator.userAgent.indexOf("iPad") &gt; -1) {
//        scriptName = "cordova-2.3.0-iOS.js";
//    }
//    if (scriptName) document.write("&lt;script type='text/javascript' charset='UTF-8' " +
//                                   "language='JavaScript' src='" + encodeURI(scriptName) + "'&gt;&lt;" + "/script&gt;");
//&lt;/script&gt;</pre><!--</var>-->
//
// <h3>Samples</h3>
// <!--<var class="smartclient">-->
// <p>The SmartClient SDK package has a sample application called MyContacts which demonstrates how
// to work with the PhoneGap API in a SmartClient app. The main SmartClient code is located in
// <code>smartclientSDK/examples/phonegap/MyContacts</code>. An Xcode project used to package the app for iOS
// devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-iOS</code>. An Eclipse project used
// to package the app for Android devices is located at <code>smartclientSDK/examples/phonegap/MyContacts-Android</code>.
//
// <p>This sample application utilizes the script changer technique to load the correct <code>cordova-x.x.x.js</code>.
// <!--</var>--><!--<var class="smartgwt">-->
// <p>The Smart&nbsp;GWT Google Code project has a sample application called +externalLink{http://code.google.com/p/smartgwt/source/browse/#svn%2Ftrunk%2Fsamples%2Fphonegap%2FMyContacts,MyContacts} which demonstrates how
// to work with the PhoneGap API in a Smart&nbsp;GWT app. The main Smart&nbsp;GWT code is located at
// <code>+externalLink{http://code.google.com/p/smartgwt/source/browse/#svn%2Ftrunk%2Fsamples%2Fphonegap%2FMyContacts,trunk/samples/phonegap/MyContacts}</code>. An Xcode project used to package the app for iOS
// devices is located at <code>+externalLink{http://code.google.com/p/smartgwt/source/browse/#svn%2Ftrunk%2Fsamples%2Fphonegap%2FMyContacts-iOS,trunk/samples/phonegap/MyContacts-iOS}</code>. An Eclipse project used
// to package the app for Android devices is located at <code>+externalLink{http://code.google.com/p/smartgwt/source/browse/#svn%2Ftrunk%2Fsamples%2Fphonegap%2FMyContacts-Android,trunk/samples/phonegap/MyContacts-Android}</code>.
//
// <p>This sample application utilizes the script changer technique to load the correct <code>cordova-x.x.x.js</code>.
// Additionally, GWT's +externalLink{http://developers.google.com/web-toolkit/doc/latest/DevGuideCodingBasicsOverlay,JavaScript overlay types}
// feature is used to easily wrap the PhoneGap Contacts API for use by the Smart&nbsp;GWT app.
// <!--</var>-->
//
// @title Integration with PhoneGap
// @treeLocation Concepts/Mobile Application Development
// @visibility external
//<

isc.Browser.isAndroid = navigator.userAgent.indexOf("Android") > -1;


isc.Browser.isRIM = isc.Browser.isBlackBerry =
    navigator.userAgent.indexOf("BlackBerry") > -1 || navigator.userAgent.indexOf("PlayBook") > -1;


isc.Browser.isMobileWebkit = (isc.Browser.isSafari && navigator.userAgent.indexOf(" Mobile/") > -1
    || isc.Browser.isAndroid
    || isc.Browser.isBlackBerry);

// intended for general mobile changes (performance, etc)
isc.Browser.isMobile = (isc.Browser.isMobileWebkit);

// browser has a touch interface (iPhone, iPad, Android device, etc)

isc.Browser.isTouch = (isc.Browser.isMobileWebkit);

// iPhone OS including iPad.  Search for iPad or iPhone.

isc.Browser.isIPhone = (isc.Browser.isMobileWebkit &&
                        (navigator.userAgent.indexOf("iPhone") > -1 ||
                         navigator.userAgent.indexOf("iPad") > -1));

// iPad.  Checks for "iPhone" OS + "iPad" in UA String.
isc.Browser.isIPad = (isc.Browser.isIPhone &&
                        navigator.userAgent.indexOf("iPad") > -1);

// tablet.  assumes isIPad for now, or non-mobile Android

isc.Browser.isTablet = (isc.Browser.isIPad) ||
                (isc.Browser.isRIM && navigator.userAgent.indexOf("Tablet") > -1) ||
                (isc.Browser.isAndroid && navigator.userAgent.indexOf("Mobile") == -1);

// specifically a handset-sized device, with an assumed screen width of 3-4 inches, implying
// the application will be working with only 300-400 pixels at typical DPI
isc.Browser.isHandset = (isc.Browser.isTouch && !isc.Browser.isTablet);

//> @classAttr  Browser.isBorderBox    (boolean : ? : R)
// Do divs render out with "border-box" sizing by default.
//<
// See comments in Canvas.adjustHandleSize() for a discussion of border-box vs content-box sizing

isc.Browser.isBorderBox = (isc.Browser.isIE && !isc.Browser.isStrict);

//>    @classAttr    Browser.lineFeed    (string : ? : RA)
//        Linefeed for this platform
//<
isc.Browser.lineFeed = (isc.Browser.isWin ? "\r\n" : "\r");

//>    @classAttr    Browser._supportsMethodTimeout    (string : ? : RA)
//        setTimeout() requires text string parameter in MacIE or IE 4
//<
isc.Browser._supportsMethodTimeout = false;//!(isc.Browser.isIE && (isc.Browser.isMac || isc.Browser.version == 4));

//>    @classAttr    Browser.isDOM (string : ? : RA)
//        Whether this is a DOM-compliant browser.  Indicates general compliance with DOM standards,
//      not perfect compliance.
//<
isc.Browser.isDOM = (isc.Browser.isMoz || isc.Browser.isOpera ||
                     isc.Browser.isSafari || (isc.Browser.isIE && isc.Browser.version >= 5));

//> @classAttr Browser.isSupported (boolean : varies by browser : R)
// Whether SmartClient supports the current browser.
// <P>
// Note that this flag will only be available on browsers that at least support basic
// JavaScript.
//
// @visibility external
//<
isc.Browser.isSupported = (
    // we support all versions of IE 5.5 and greater on Windows only
    (isc.Browser.isIE && isc.Browser.minorVersion >= 5.5 && isc.Browser.isWin) ||
    // Mozilla and Netscape 6, all platforms
    isc.Browser.isMoz ||
    isc.Browser.isOpera ||
    // Safari (only available on Mac)
    isc.Browser.isSafari ||
    isc.Browser.isAIR
);


isc.Browser.nativeMouseMoveOnCanvasScroll =
    !isc.Browser.isTouch && (isc.Browser.isSafari || isc.Browser.isChrome);

//> @classAttr Browser.seleniumPresent (boolean : varies : R)
// Whether current page has been loaded by Selenium RC/WebDriver.
//<
isc.Browser.seleniumPresent = (function () {
    var match = location.href.match(/[?&](?:sc_selenium)=([^&#]*)/);
    return match && match.length > 1 && "true" == match[1];
})();

//> @type Autotest
// @value Browser.SHOWCASE autotest is targeting SmartClient or SGWT showcases
isc.Browser.SHOWCASE = "showcase";
// @value Browser.RUNNER autotest is targeting TestRunner-based JS tests
isc.Browser.RUNNER = "runner";
//<

//> @classAttr Browser.autotest (Autotest : varies : R)
// The current mode of the autotest system (null if not in autotest mode)
//<
isc.Browser.autotest = (function () {
    var match = location.href.match(/[?&](?:autotest)=([^&#]*)/);
    return match && match.length > 1 ? match[1] : null;
})();

//>    @classAttr    Browser.allowsXSXHR    (boolean : ? : RA)
//    Traditionally, web browsers reject attempts to make an XmlHttpRequest of a server other than the origin
//  server. However, some more recent browsers allow cross-site XmlHttpRequests to be made, relying on the
//  server to accept or reject them depending on what the origin server is.
//<
isc.Browser.allowsXSXHR = (
    (isc.Browser.isFirefox && isc.Browser.firefoxMajorMinorNumber >= 3.5) ||
    // Chrome auto-updates to latest stable version every time you start it, and there is no option to prevent
    // this from happening, so there's no point in querying version
    (isc.Browser.isChrome) ||
    (isc.Browser.isSafari && isc.Browser.safariVersion >= 531)
);

//> @classAttr Browser.useCSSFilters (boolean : ? : R)
// Whether the current browser supports gradients and whether SmartClient is
// configured to use gradients (via the setting of window.isc_useGradientsPreIE9).
//<


var isc_useGradientsPreIE9 = window.isc_useGradientsPreIE9;
isc.Browser.useCSSFilters =
    !isc.Browser.isIE || isc.Browser.isIE9 || isc_useGradientsPreIE9 != false;

//> @classAttr Browser.isSGWT (boolean : ? : RA)
// Are we running in SGWT.
// This is set up by SmartGWT wrapper code in JsObject.init().
// Obviously only applies to internal SmartClient code since developer code for an SGWT app
// would be written in Java and there'd be no need to check this var!
// @visibility internal
//<

//> @classAttr Browser.useCSS3 (boolean : ? : R)
// Whether the current browser supports CSS3 and whether SmartClient is configured to use
// CSS3 features (via the setting of window.isc_css3Mode).
// <P>
// If isc_css3Mode is "on" then useCSS3 is set to true.  If isc_css3Mode is set to
// "supported", "partialSupport", or is unset, then useCSS3 is set to true only if the browser
// is a WebKit-based browser, Firefox, IE 9 in standards mode, or IE 10+.  If isc_css3Mode is set
// to "off" then useCSS3 is set to false.
//<
var isc_css3Mode = window.isc_css3Mode;
if (isc_css3Mode == "on") {
    isc.Browser.useCSS3 = true;
} else if (isc_css3Mode == "off") {
    isc.Browser.useCSS3 = false;
} else if (isc_css3Mode == "supported" ||
           isc_css3Mode == "partialSupport" ||
           isc_css3Mode === undefined)
{
    isc.Browser.useCSS3 = isc.Browser.isWebKit ||
                          isc.Browser.isFirefox ||
                          (isc.Browser.isIE && (isc.Browser.isIE9 || isc.Browser.version >= 10));
} else {
    isc.Browser.useCSS3 = false;
}

var isc_spriting = window.isc_spriting;
if (isc_spriting == "off") {
    isc.Browser.useSpriting = false;
} else {
    isc.Browser.useSpriting = (!isc.Browser.isIE || isc.Browser.version >= 7);
}

isc.Browser.useInsertAdjacentHTML = !!document.documentElement.insertAdjacentHTML;

// Test for availability of the Range.getBoundingClientRect() method which was added to
// CSSOM View as of the 04 August 2009 Working Draft.
// http://www.w3.org/TR/2009/WD-cssom-view-20090804/

isc.Browser.hasNativeGetRect = (!isc.Browser.isIE &&
                                (!isc.Browser.isSafari || !isc.Browser.isMac || isc.Browser.version >= 6) &&
                                !!document.createRange &&
                                !!(document.createRange().getBoundingClientRect));

isc.Browser.useClipDiv = (isc.Browser.isMoz || isc.Browser.isSafari || isc.Browser.isOpera);


isc.Browser._useNewSingleDivSizing = !((isc.Browser.isIE && isc.Browser.version < 10 && !isc.Browser.isIE9) ||
                                       (isc.Browser.isWebKit && !(parseFloat(isc.Browser.rawSafariVersion) >= 532.3)));

isc.Browser.useCreateContextualFragment = !!document.createRange && !!document.createRange().createContextualFragment;


isc.Browser.hasTextOverflowEllipsis = (!isc.Browser.isMoz || isc.Browser.version >= 7) &&
                                      (!isc.Browser.isOpera || isc.Browser.version >= 9);

// https://developer.mozilla.org/en-US/docs/CSS/text-overflow
isc.Browser._textOverflowPropertyName = (!isc.Browser.isOpera || isc.Browser.version >= 11 ? "text-overflow" : "-o-text-overflow");


isc.Browser._hasGetBCR = !isc.Browser.isSafari || isc.Browser.version >= 4;

// http://dom.spec.whatwg.org/#ranges
isc.Browser._hasDOMRanges = !!(window.getSelection && document.createRange && window.Range);

// Whether the browser supports the CSS `background-size' property.
// https://developer.mozilla.org/en-US/docs/Web/CSS/background-size
isc.Browser._supportsBackgroundSize = "backgroundSize" in document.documentElement.style;


isc.Browser._svgElementsHaveParentElement = (document.createElementNS && "parentElement" in document.createElementNS("http://www.w3.org/2000/svg", "svg"));
if (!isc.Browser._svgElementsHaveParentElement && window.SVGElement != null && Object.defineProperty) {
    Object.defineProperty(SVGElement.prototype, "parentElement", {
        enumerable: true,
        "get" : function () {
            var parentElement = this.parentNode;
            while (parentElement != null && parentElement.nodeType != 1) {
                parentElement = parentElement.parentNode;
            }
            return parentElement;
        }
    });
}

isc.Browser._supportsIOSTabs = isc.Browser.isMobileWebkit && "webkitMaskBoxImage" in document.documentElement.style;

}



isc.noOp = function () {};
isc.emptyObject = {};
isc._emptyArray = [];
// normal and obfuscatable name
isc.emptyString = isc._emptyString = "";
isc.space = " ";
isc.dot = ".";
isc.semi = ";";
isc.colon = ":";
isc.slash = "/";
isc.star = "*";
isc.apos = "'";
isc.auto = "auto";
isc.px = "px";
isc.nbsp = "&nbsp;";
isc.xnbsp = "&amp;nbsp;"; // XHTML
isc._false = "false";
isc._falseUC = "FALSE";
isc._underscore = "_";
isc._dollar = "$";
isc._obsPrefix = "_$observed_";
isc._superProtoPrefix = "_$SuperProto_";

isc.gwtRef = "__ref";
isc.gwtModule = "__module";

//> @classMethod isc.logWarn()
// Same as +link{classMethod:Log.logWarn}.
//
// @param message    (String)  message to log
// @param [category]   (String)  category to log in, defaults to "Log"
//
// @visibility external
//<
isc.logWarn = function (message, category) { isc.Log.logWarn(message, category) }

//> @classMethod isc.echo()
// Same as +link{classMethod:Log.echo}.
//
// @param value    (any)  object to echo
// @return (string) a short string representation of the object
//
// @visibility external
//<
isc.echo = function (value) { return isc.Log.echo(value) }

//> @classMethod isc.echoAll()
// Same as +link{classMethod:Log.echoAll}.
//
// @param value    (any)  object to echo
// @return (string) a short string representation of the object
//
// @visibility external
//<
isc.echoAll = function (value) { return isc.Log.echoAll(value) }

//> @classMethod isc.echoLeaf()
// Same as +link{classMethod:Log.echoLeaf}.
//
// @param value    (any)  object to echo
// @return (string) a short string representation of the object
//
// @visibility external
//<
isc.echoLeaf = function (value) { return isc.Log.echoLeaf(value) }

isc.echoFull = function (value) { return isc.Log.echoFull(value) }

//> @classMethod isc.logEcho()
// Logs the echoed object (using +link{classMethod:isc.echo}) as a warning, prefixed with an
// optional message.
//
//     @param value    (any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEcho = function (value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echo(value))
}

//> @classMethod isc.logEchoAll()
// Logs the echoed object (using +link{classMethod:isc.echoAll}) as a warning, prefixed with an
// optional message.
//
//     @param value    (any)  object to echo
//     @param message    (String)  message to log
//
// @see Log.logWarn() for logging info
// @visibility external
//<
isc.logEchoAll = function (value, message) {
    if (message) message += ": ";
    isc.Log.logWarn((message || isc._emptyString) + isc.echoAll(value))
}

// OutputAsString / StackWalking / Tracing
// ---------------------------------------------------------------------------------------





isc._makeFunction = function (args, script) {
    var code = script || args;

    var returnVal;
    if (script == null) {
        returnVal = new Function(code);
        returnVal._argString = isc._emptyString;
    } else {
        returnVal = new Function(args, code);
    }
    return returnVal;
};


isc.doEval = function (code) {
    // transform code and eval inline
    if (isc.Browser.isMoz) return isc._transformCode(code);
    //return isc._transformCode(code);

    if (!isc._evalSet) isc._evalSet = [];
    isc._evalSet[isc._evalSet.length] = code;
    return null;
}
// called at module end
isc.finalEval = function () {
    //!OBFUSCATEOK
    if (isc._evalSet) {
        if (isc.Browser.isMoz) {
            for (var i = 0; i < isc._evalSet.length; i++) {
                isc.eval(isc._evalSet[i]);
            }
        }
        var code = isc._evalSet.join("");

        if (isc.Browser.isSafari) code = isc._transformCode(code);
        // uncomment to use catch/rethrow stacks in IE as well
        //else if (isc.Browser.isIE) code = isc._transformCode(code);

        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }

        // Init pipelining: set a timeout to eval so that the module init time takes place
        // while the next module is being downloaded (except for the last module)
        // Can't be used for real until
        /*
        var evalFunc = function () {
        if (isc.Browser.isIE) {
            if (window.execScript != null) {
                window.execScript(code, "javascript");
            } else {
                window.eval(code);
            }

        // Safari
        } else {
            isc.eval(code);
        }
        };

        if (isc.module_DataBinding != 1) {
            //if (isc.Log) isc.Log.logWarn("delaying eval");
            setTimeout(evalFunc, 0)
        } else {
            evalFunc();
        }
        */
    }
    isc._evalSet = null;
}

//isc._eitherMarker = /\/\/\$[01]/;
isc._startMarker = "//$0";
isc._endMarker = "//$1";
isc._totalTransformTime = 0;
// code transform time, all modules
//    - Moz: about 140ms
//      - NOTE: overall init time rises by about 400ms, the balance is due to slower parsing
//        because of the added try/catch constructs.  This can be demonstrated by doing the
//        split/join, but just restoring the markers
//    - Safari: about 300ms
//    - IE: 266ms
// - NOTE: some key advantages of this approach as compared to server-side generation *aside
//   from* not hosing IE's ability to do full stack traces w/o try/catch:
//    - allows arbitrary start/end code to be added with only client-side changes
//    - can be conditional per load
//    - much smaller code size impact: could ship w/o local vars for production use

isc._addCallouts = true;
isc._transformCode = function (code) {
    // set flag indicating stack walking is enabled so that we will also add try..catch to
    // generated functions
    isc._stackWalkEnabled = true;

    var start = isc.timeStamp ? isc.timeStamp() : new Date().getTime();

    var startCode = isc._tryBlock, endCode = isc._evalFromCatchBlock;
    if (isc._addCallouts) startCode = isc._methodEnter + startCode;

    var chunks = code.split(isc._eitherMarker),
        finalCode = [];

    var chunks = code.split(isc._startMarker);
    code = chunks.join(startCode);
    chunks = code.split(isc._endMarker);
    code = chunks.join(endCode);

    if (isc._addCallouts) {
        chunks = code.split("//$2");
        code = chunks.join(isc._methodExit);
    }

    /*
    // approach of single split and join to cut down on String churn.
    // Problem is that because of nested functions, markers do not alternate.  Would need to
    // detect which kind of marker is needed for a given slot, by eg checking the next char
    // over, which might be expensive enough to wipe out any advantage; untested.
    var pos = 0;
    for (var i = 0; i < chunks.length; i++) {
        finalCode[pos++] = chunks[i];
        if (i < chunks.length-1) {
            finalCode[pos++] = i % 2 == 0 ? isc._tryBlock : isc._evalFromCatchBlock;
        }
    }
    finalCode = finalCode.join("");

    try {
        window.isc.eval(finalCode);
    } catch (e) {
        //if (!this._alerted) alert(finalCode.substring(0,5000));
        //this._alerted = true;
        document.write("chunks<br><TEXTAREA style='width:760px;height:400px'>" +
                        chunks.join("\n***") + "</" + "TEXTAREA>");
        document.write("finalCode<br><TEXTAREA style='width:760px;height:400px'>" +
                        finalCode + "</" + "TEXTAREA>");
        throw e;
    }
    //return finalCode;
    */

    var end = isc.timeStamp ? isc.timeStamp() : new Date().getTime();
    isc._totalTransformTime += (end-start);
    return code;
}

isc._evalFromCatchBlock = "}catch(_e){isc.eval(isc._handleError(";
isc._handleError = function (varList) {
    var code = "var _ = {";
    if (varList != "") {
        var varNames = varList.split(",");
        for (var i = 0; i < varNames.length; i++) {
            var varName = varNames[i];
            code += varName + ":" + varName;
            if (i < varNames.length-1) code += ",";
        }
    }
    code += "};";
    code += "if(isc.Log)isc.Log._reportJSError(_e,arguments,this,_);throw _e;";
    return code;
}



// fillList - utility to concat a number of individual arguments into an array
// ---------------------------------------------------------------------------------------
isc.fillList = function (array, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z) {

    if (array == null) array = [];
    else array.length = 0;

    var undef;
    // avoid touching the arguments object if possible

    if (X === undef && Y === undef && Z === undef) {
        array[0] = A;
        array[1] = B;
        array[2] = C;
        array[3] = D;
        array[4] = E;
        array[5] = F;
        array[6] = G;
        array[7] = H;
        array[8] = I;
        array[9] = J;
        array[10] = K;
        array[11] = L;
        array[12] = M;
        array[13] = N;
        array[14] = O;
        array[15] = P;
        array[16] = Q;
        array[17] = R;
        array[18] = S;
        array[19] = T;
        array[20] = U;
        array[21] = V;
        array[22] = W;
    } else {
        for (var i = 1; i < arguments.length; i++) {
            array[i-1] = arguments[i];
        }
    }

    return array;
}



//>    @classMethod isc.addProperties()
//
// Add all properties and methods from any number of objects to a destination object,
// overwriting properties in the destination object.
// <p>
// Common uses of <code>addProperties</code> include creating a shallow copy of an object:<pre>
//
//     isc.addProperties({}, someObject);
//
// </pre>Combining settings in order of precedence:<pre>
//
//     isc.addProperties({}, defaults, overrides, skinOverrides);
//
// </pre>
// <P>
// <b>NOTE</b>: do not use <code>addProperties</code> to add defaults to an ISC class.  Use
// <code>Class.addProperties()</code>, as in: <i>MyClassName</i><code>.addProperties()</code>.
//
// @see Class.addProperties()
//
//    @param    destination            (object)    object to add properties to
//    @param    [(arguments 1-N)]    (object)    objects to obtain properties from.  Properties of all
//                                            arguments other than destination are applied in turn.
// @return (object) returns the destination object
// @visibility external
//<

/*
// code to count all methods according to what they are added to
isc.methodCount = 0;
isc.classMethodCount = 0;
isc.otherMethods = 0;
isc.otherMethodTargets = [];
*/

isc._sourceList = [];
isc._inAddProps = 0;

isc.addGlobal("addProperties", function isc_addProperties(destination, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z) {

    // count recursive calls and avoid reusing the global isc._sourceList in this case.  Recursive calls
    // can happen if addPropertyList() logs something.
    var undef,
        sourceList = isc._inAddProps ? [] : isc._sourceList;
    isc._inAddProps++;

    if (X === undef && Y=== undef && Z === undef) {
        isc.fillList(sourceList, A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z);
    } else {
        sourceList.length = 0;
        for (var i = 1; i < arguments.length; i++) {
            sourceList[i -1] = arguments[i];
        }
    }


    var result = isc.addPropertyList(destination, sourceList);
    // reset the sourceList so we don't hang onto the objects in memory unnecessarily
    sourceList.length = 0;
    isc._inAddProps--;
    return result;

});


isc._interfaceInstanceProps = {};
isc._interfaceClassProps = {};
isc._getInterfaceProps = function (destination) {
    var className = destination.Class,
        props;
    if (isc.isA.ClassObject(destination)) {
        props = isc._interfaceClassProps[className] =
                    isc._interfaceClassProps[className] || [];
    } else if (isc.isAn.InstancePrototype(destination)) {
        props = isc._interfaceInstanceProps[className] =
                    isc._interfaceInstanceProps[className] || [];
    }
    return props;
}

//>    @method ClassFactory.addPropertyList() or isc.addPropertyList()
//
// Add all properties from any number of objects to a destination object.
//
// This differs from addProperties() in that it takes an array as it's second argument,
// applying each object in the array as properties in turn.
//
//    @param    destination            (object)    object to add properties to
//    @param    sourceList            (array)        array of objects with properties to add
//  @return                     (object)    the object after properties have been added to it
//<
isc.addPropertyList = function (destination, sourceList) {
    // Don't JS error if passed a null destination

    if (destination == null) {
        if (isc.Log) isc.Log.logWarn("Attempt to add properties to a null object. " +
                                     "Creating a new object for the list of properties."

                                     );
        destination = {};
    }

    var methods,
        // detect functions being added as properties.  Doesn't work until after "isA" has
        // initialized
        checkFunctions = (isc.isA != null),
        // get the registry of string methods on the destination object
        registry = (isc.isAn && isc.isAn.Instance(destination) ?
                    destination.getClass()._stringMethodRegistry :
                    destination._stringMethodRegistry);
    if (registry == null) registry = isc.emptyObject;

    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    var undef;
    for (var i = 0, l = sourceList.length; i < l; i++) {

        // add it's properties to the destination
        var source = sourceList[i];
        // if <code>source</code> is null, skip it.
        if (source == null) continue;

        // copy properties from source to destination
        for (var propName in source) {

            var propValue = source[propName];
            // if any of source's properties are functions
            // or any of the source's properties are registered as stringMethods on the
            //          destination object
            // use addMethods to copy these properties


            var propIsAFunction = checkFunctions && isc.isA.Function(propValue);
            // Check for functions / stringMethods as appropriate.

            if (registry[propName] !== undef || propIsAFunction)
            {
                if (methods == null) methods = {};
                methods[propName] = propValue;

            // don't copy an identical property
            // NOTE: unsafe: a subclass may wish to set a property to the same value as the
            //       default for its superclass, and have the subclass value remain unchanged
            //       if the superclass default is changed.
            //} else if (!(source[property] === destination[property])) {
            } else {
                // property is not a function and this slot is not a StringMethod

                // for Interfaces, keep track of all properties added to them
                if (props != null) props[props.length] = propName;

                // check for clobbering a function with a non-function value, eg setting
                // Canvas.enable:false.
                var destinationProp = destination[propName];
                if (!propIsAFunction && destinationProp != null &&
                    isc.isA.Function(destinationProp) && !isc._allowDeleteFuncProperty)
                {
                    if (isc.Log != null) {
                        isc.Log.logWarn("method " + propName + " on " + destination +
                                        " overridden with non-function: '" + propValue + "'");
                    }
                }

                destination[propName] = propValue;

            /*
            } else {

                if (destination.Class && isc.Log &&
                    (!isc.isAn.Instance(destination) ||
                     destination._scPrototype === destination))
                {
                    isc.Log.logWarn("needless override on class: " + destination.Class +
                                    ": " + propName + "->" + propValue);
                }

            */
            }
        }
    }
    if (methods != null) isc.addMethods(destination, methods);
    return destination;
}

//>    @method isc.addMethods()
//
//    Add all named methods from <code>source</code> to <code>destination</code>
//
//    @see addProperties()
//
//    @param    destination    (object)    object to add methods to
//    @param    source        (object)    object to get methods from
//  @return             (object)    the object after methods have been added to it
//
//<
// NOTE: not externally documented since there is essentially no legitimate reason for author
// code to use this instead of Class.addMethods().

isc._$string = "string";
isc._$function = "function";
isc._$constructor = "constructor";
isc._$object = "object";
isc.addGlobal("addMethods", function (destination, source) {
    if (!destination || !source) return destination;



    var props = destination._isInterface ? isc._getInterfaceProps(destination) : null;

    if (!isc.__remap) isc.__remap = {};

    for (var name in source) {

        if (props != null) props[props.length] = name;
        var method = source[name];

        // if a method was specified as a string or an action-object, see if the
        // destination defines this as a legal string method.
        // NOTE: check typeof object to support Actions, but check non-null because
        // typeof null == "object" and null specified for a method should wipe it out.
        if (isc.isA.instanceMethodsAdded && method != null &&
            (typeof method == isc._$string || typeof method == isc._$object))
        {
            var registry = (isc.isAn.Instance(destination) ?
                                (destination.getClass != null ?
                                    destination.getClass()._stringMethodRegistry : null) :
                            destination._stringMethodRegistry);
            var undefined; // check for undefined rather than null
            if (registry && !(registry[name]===undefined) &&

                name != isc._$constructor)
            {
                method = isc.Func.expressionToFunction(registry[name], source[name]);
            }
            // XXX If it's not a function or a stringMethod, assume it's ok to add it using the
            // addMethods logic rather than booting back to addProperties
        }

        // If someone's observing this method, the actual method will be stored under a different
        // name
        var observers = destination._observers,
            finalName = (observers != null && observers[name] != null ? isc._obsPrefix + name : name);

        // If the method is already in the correct slot, we're done.
        if (method !== destination[finalName]) {

            if (method != null) {
                //>DEBUG take the opportunity to label the function with a name for debug
                // purposes.
                this._nameMethod(method, name, destination) //<DEBUG




            }

            destination[finalName] = method;

            if (method != null) {



                // if the method was previously assigned an obfuscated name, make sure the function is
                // available under the obfuscated name in the object it's being mixed into
                if (isc.__remap[name]) {
                    // same check for observation applies here
                    var finalObfName = (destination._observers != null &&
                                        destination._observers[isc.__remap[name]] != null ?
                                        isc._obsPrefix + isc.__remap[name] : isc.__remap[name]);
                    destination[finalObfName] = method;
                }
            }
        //} else {
        //    alert("skipped identical assignment in slot: " + finalName + " of " + method);
        }
    }

    return destination;
});

// Function naming
// ---------------------------------------------------------------------------------------
//>DEBUG _nameMethod: labels a function with a name for debug purposes.



isc._allFuncs = []
isc._allFuncs._maxIndex = 0;
isc._funcClasses = new Array(5000);

isc._nameMethod = function (method, name, destination) {

    if (typeof method != isc._$function) return;

    // if not being added to a class, just use the property name as the function name
    if (destination.Class == null) return method._name = name;

    // destination is either:
    // - a class Object (eg isc.ListGrid)
    // - an instancePrototype (isc.ListGrid._instancePrototype)
    // - an instance
    // - a handful of other objects on which we've added the Class property, including isc.isA,
    //   ClassFactory, and native prototypes (eg window.Array)


    // only for instance prototypes and class objects, not for instances
    if (isc.isA != null && isc.isA.instanceMethodsAdded &&
        (isc.isAn.InstancePrototype(destination) || isc.isA.ClassObject(destination)))
    {
        var allFuncs = isc._allFuncs;
        // NOTE: functions installed twice, eg interface methods, will appear twice with
        // different classnames, but the first entry will be the one used, so interface methods
        // retain the interface name even when added to other classes.
        allFuncs[allFuncs._maxIndex] = method;
        isc._funcClasses[allFuncs._maxIndex] = destination.Class;
        allFuncs._maxIndex++;
        return;
    }

    // debug: capture all non-Class/Instance methods (eg isA, String extensions, ClassFactory
    // and other bootstrap)
    //if (isc._otherFuncs == null) isc._otherFuncs = [];
    //isc._otherFuncs[isc._otherFuncs.length] = method;

    // special case isA because isA.Class is a method which detects class objects!
    // We need to use a property other than Class for the className.
    var className = (destination == isc.isA ? "isA" : destination.Class);

    method._className = className;


    if (isc[destination.Class] == null) method._name = name;

    if (isc.isA != null && isc.isA.instanceMethodsAdded && isc.isAn.Instance(destination) &&
        !isc.isAn.InstancePrototype(destination))
    {
        // instance methods need to be labelled with their name since we don't want to store a
        // list of instance IDs for function name lookups (it would grow indefinitely)
        method._name = name;
        // this method is an instance-specific override (using an instance as an anonymous
        // class).  Mark it as such.
        method._instanceSpecific = true;
        // if there's already a method on the destination with the same name,
        // this is also an override (as opposed to just a method that was added)
        if (destination[name] != null) method._isOverride = true;
    }
    // XXX Note: we could use a check like the following to detect and label class
    // methods vs instance methods
    // if (ClassFactroy.getClass(destination.Class) === destination) {
}

//<DEBUG










//> @type Object
// An ordinary JavaScript as obtained by "new Object()" or via
// +link{type:ObjectLiteral,Object Literal} syntax.
// <P>
// Methods that return Objects or take Objects as parameters make use of the ability of a
// JavaScript Object to contain an arbitrary set of named properties, without requiring
// declaration in advance.  This capability makes it possible to use a JavaScript Object much
// like a HashMap in Java or .NET, but without the need to call get() or set() to create and
// retrieve properties.
// <P>
// For example if you created an Object using +link{type:ObjectLiteral,Object Literal} syntax
// like so:
// <pre>
//    var request = {
//        actionURL : "/foo.do",
//        showPrompt:false
//    };
// </pre>
// You could then access it's properties like so:
// <pre>
//    var myActionURL = request.actionURL;
//    var myShowPrompt = request.showPrompt;
// </pre>
// .. and you could assign new values to those properties like so:
// <pre>
//    request.actionURL = "<i>newActionURL</i>";
//    request.showPrompt = <i>newShowPromptSetting</i>;
// </pre>
// Note that while JavaScript allows you to get and set properties in this way on any Object,
// SmartClient components require that if a setter or getter exists, it must be called, or no
// action will occur.  For example, if you had a +link{ListGrid} and you wanted to change the
// +link{listGrid.showHeader,showHeader} property:
// <pre>
//     myListGrid.setShowHeader(false); // correct
//     myListGrid.showHeader = false; // incorrect (nothing happens)
// </pre>
// All documented attributes have +link{group:flags,flags} (eg IRW) that indicate when direct
// property access is allowed or not.
//
// @visibility external
//<


// Utility methods for any JavaScript Object
// ---------------------------------------------------------------------------------------

//>    @classMethod isc.getKeys()
//
//    Return all keys (property names) of a given object
//
//    @param    object            (object)    object to get properties from
//    @return                    (Array) String names of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getKeys", function (object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = key;
        }
    }
    return list;
});

//> @classMethod isc.firstKey()
// Return the first property name in a given Object, according to for..in iteration order.
//
// @param object (Object) Object to get properties from
// @return (String) first property name, or null if Object has no properties
// @visibility external
//<
isc.addGlobal("firstKey", function (object) {
    for (var key in object) return key;
});

//>    @classMethod isc.getValues()
//
//    Return all values of a given object
//
//    @param    object            (object) object to get properties from
//    @return                    (Array) values of all properties.  NOTE: never null
// @visibility external
//<
isc.addGlobal("getValues", function (object) {
    var list = [];
    if (object != null) {
        for (var key in object) {
            list[list.length] = object[key];
        }
    }
    return list;
});

//> @classMethod isc.sortObject()
// Given a simple javascript object, return that object sorted by keys, such that when iterating
// through the properties of the object, they will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object.
// @param object (object) Object to sort
// @param [comparator] (function) Comparator function to use when sorting the objects keys
// @return (object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObject", function (object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var keys = isc.getKeys(object);
    keys = (sortComparator == null ? keys.sort() : keys.sort(sortComparator));
    var sortedObject = {};
    for (var i = 0; i < keys.length; i++) {
        sortedObject[keys[i]] = object[keys[i]];

    }
    return sortedObject
});

//> @classMethod isc.sortObjectByProperties()
// Given a simple javascript object, return that object sorted by properties, such that when
// iterating through the properties of the object, values will show up in sorted order.<br>
// Usage example - may be used to sort a +link{FormItem.valueMap, formItem valueMap} defined
// as an object by display value.
// @param object (object) Object to sort
// @param [comparator] (function) Comparator function to use when sorting the object properties
// @return (object) sorted version of the object passed in.
// @visibility external
//<
isc.addGlobal("sortObjectByProperties", function (object, sortComparator) {
    if (!isc.isA.Object(object)) return object;
    if (isc.isAn.Array(object)) {
        if (sortComparator != null) return object.sort(sortComparator);
        return object.sort();
    }
    var values = isc.getValues(object);
    values = (sortComparator == null ? values.sort() : values.sort(sortComparator));
    var sortedObject = {};

    for (var i = 0; i < values.length; i++) {
        var value = values[i];
        for (var key in object) {
            if (object[key] === value) {
                sortedObject[key] = object[key];
                continue;
            }
        }
    }
    return sortedObject
});

//> @classMethod isc.addDefaults()
//
// Copy any properties that do not already have a value in destination.  Null and zero values
// are not overwritten, but 'undef' values will be.
//
// @param destination (Object) Object to which properties will be added.
// @param source (Object) Object from which properties will be added.
// @return (Object) The destination object is returned.
// @visibility external
//<
isc.addGlobal("addDefaults", function (destination, source) {
    if (destination == null) return;
    var undef;
    for (var propName in source) {
        if (destination[propName] === undef) destination[propName] = source[propName];
    }
    return destination;
});


//>    @classMethod isc.propertyDefined()
//
//    Is some property specified on the object passed in?  This will return true if
//  <code>object[propertyName]</code> has ever been set to any value, and not deleted.<br>
//  May return true even if <code>object[propertyName] === undefined</code> if the property
//  is present on the object and has been explicitly set to undefined.
//
// @param object (object) Object to test
// @param propertyName (string) Which property is being tested for?
// @return (boolean) true if property is defined
//  @visibility external
//<
isc.addGlobal("propertyDefined", function (object, propertyName) {
    if (object == null) return false;

    var undefined;
    if (object[propertyName] !== undefined) return true;


    var properties = isc.getKeys(object);
    return (properties.contains(propertyName));
});

isc.addGlobal("objectsAreEqual", function (object1, object2) {
    // match -> return true

    if (object1 === object2) return true;

    else if (isc.isAn.Object(object1) && isc.isAn.Object(object2)) {
        if (isc.isA.Date(object1)) {
            return isc.isA.Date(object2) && (Date.compareDates(object1,object2) == 0);
        } else if (isc.isAn.Array(object1)) {
            if (isc.isAn.Array(object2) && object1.length == object2.length) {
                for (var i = 0; i < object1.length; i++) {
                    if (!isc.objectsAreEqual(object1[i], object2[i])) return false;
                }
                return true;
            }
            return false;
        } else {
            if (isc.isAn.Array(object2)) return false;
            var numProps = 0;
            for (var prop in object1) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                if (!isc.objectsAreEqual(object1[prop],object2[prop])) return false;
                numProps ++;
            }
            var numProps2 = 0;
            for (var prop2 in object2) {
                if (prop == isc.gwtRef || prop == isc.gwtModule) continue;
                numProps2++;
                if (numProps2 > numProps) return false;
            }
            if (numProps2 != numProps) return false;

            return true;
        }
    } else {
        return false;
    }
});


// combineObject() - like addProperties() except it handles nested object data structures
// so if an attribute of the source is an object, properties from that object will be
// combined across to the destination, rather than simply clobbering the previous attribute value
// for the field.
// Note the goal here isn't to avoid the destination pointing to the same objects as the source
// (like a duplicate), it's just to merge field values in for nested objects
isc.addGlobal("combineObjects", function (destination, source) {
    if (destination == null || !isc.isAn.Object(destination)) return source;
    if (source == null || !isc.isAn.Object(source)) return destination;

    for (var prop in source) {
        var destProp = destination[prop],
            sourceProp = source[prop];
        // If both the source and destination contain simple objects, iterate through the
        // attributes on the source property object and copy them across to the destination property
        // object
        if (isc.isAn.Object(destProp) && !isc.isAn.Array(destProp) && !isc.isA.Date(destProp)
            && isc.isAn.Object(sourceProp) && !isc.isAn.Array(sourceProp) &&
            !isc.isA.Date(sourceProp))
        {
            isc.combineObjects(destProp, sourceProp);
        // Otherwise we can just copy the value across as with standard addProperties
        } else {
            destination[prop] = sourceProp;
        }

    }
});


//> @method isc.applyMask()
// Create a copy of an Object or Array of Objects that has been trimmed to a specified set of
// properties.
// <p>
// <code>mask</code> is the list of properties to return.  Can be an array of strings or an object.
// If an object, the properties returned will be those that are present in the object.  NOTE: this
// includes properties that exist because they've been explicitly set to null.
// <p>
// If no mask is specified, returns a duplicate of the input
// If no inputs are specified, returns an empty object.
//
// @param input   (Object or Array)   object to be masked
// @param mask    (Object or Array)   set of properties to limit output to
//
//<
// NOTE: not external because behavior is a little odd:
// - returns non-null for null input
// - if mask is null and provided an Array, returns an Object instead of a dup'd Array
// we need to check out the framework uses of applyMask and makes sure changing the behavior is
// OK
//
// XXX if applyMask with the input as an empty Array, you will get an empty Array as output.
// So applyMask cannot be used to filter properties that exist on an Array instance.
isc.applyMask = function (input, mask) {
    var output = {};

    // if no input passed in, return empty output
    if (input == null) return output;

    // if no mask passed in, return all fields from input
    if (mask == null) {
        return isc.addProperties(output, input);
    }

    var inputWasSingle = false;
    if (!isc.isAn.Array(input)) {
        inputWasSingle = true;
        input = [input];
    }

    // convert the mask to an Array of property names if it's an object
    if (!isc.isAn.Array(mask)) mask = isc.getKeys(mask);

    var output = [],
        inputObj, outputObj,
        key, undef;
    for (var i = 0; i < input.length; i++) {
        inputObj = input[i];
        outputObj = output[i] = {};
        // return only the specified properties
        for (var j = 0; j < mask.length; j++) {
            key = mask[j];
            if (inputObj[key] === undef) continue;
            outputObj[key] = inputObj[key];
        }
    }
    return (inputWasSingle ? output[0] : output);
}

isc.getProperties = function (input, propertyList) {
    if (input == null) return null;

    var output = {};
    if (propertyList == null) return output;
    for (var i = 0; i < propertyList.length; i++) {
        var propName = propertyList[i];
        output[propName] = input[propName];
    }
    return output;
}

isc._digits = {};
isc._floor = Math.floor;
isc._$minus = "-";

for (isc._iterator = 0; isc._iterator < 10; isc._iterator++)
    isc._digits[isc._iterator] = isc._iterator.toString();

isc._fillNumber = function (template, number, startSlot, numSlots, nullRemainingSlots) {



    var lastSlot = startSlot + numSlots - 1,
        origNumber = number,
        didntFit = false,
        negative;

    if (number < 0) {
        negative = true;
        number = -number;
        template[startSlot] = this._$minus;
        startSlot += 1;
        numSlots -= 1;
    }

    while (number > 9) {
        // reduce by 10x, round off last digit and subtract to find what it was
        var newNumber = this._floor(number/10),
            lastDigit = number - (newNumber*10);
        // fill slots last first
        template[lastSlot] = this._digits[lastDigit];
        number = newNumber;

        if (lastSlot == (startSlot+1) && number > 9) {
            // number to large for allocated number of slots
            isc.Log.logWarn("fillNumber: number too large: " + origNumber +
                            isc.Log.getStackTrace());
            didntFit = true;
            break;
        }
        lastSlot -= 1;
    }

    if (didntFit) {

        lastSlot = startSlot + numSlots - 1
        template[lastSlot--] = (!negative ? origNumber : -origNumber);
    } else {
        template[lastSlot--] = this._digits[number];
    }

    // null out remaining slots
    for (var i = lastSlot; i >= startSlot; i--) {
        template[i] = null;
    }
};
if (!isc.Browser.isIE || isc.Browser.version > 7) {

    isc._fillNumber = function (template, number, startSlot, numSlots, nullRemainingSlots) {
        template[startSlot] = number;
        if (nullRemainingSlots) {
            var endI = startSlot + numSlots;
            for (var i = startSlot + 1; i < endI; ++i) {
                template[i] = null;
            }
        }
    };
}


// try to interpolate different types as a boolean
//
// returns default if value is undefined or null
// returns false if value is
//   - the string "false" or "FALSE"
//   - the number 0
//   - the boolean value false
// otherwise returns true
isc.booleanValue = function (value, def) {
    // if the value is unset, return the specified default (so,
    if (value == null) return def;

    if (isc.isA.String(value)) return value != isc._false && value != isc._falseUC;
    return value ? true : false;
}

// isc.objectToLocaleString()
// Centralized, customizable toLocaleString() formatter for objects.
isc.iscToLocaleString = function (object) {
    if (object != null) {
        return object.iscToLocaleString ? object.iscToLocaleString() :
                    (object.toLocaleString ? object.toLocaleString() :
                        (object.toString ? object.toString() : isc.emptyString + object));
    }
    return isc.emptyString + object;
}

isc._$toolSkinNames = ["ToolSkin","ToolSkinNative"];

isc.setCurrentSkin = function (skinName) {
    // store the current skin so we can detect multiple skins being loaded
    if (isc.currentSkin && !isc._$toolSkinNames.contains(skinName)) {
        isc.logWarn("Detected loading of more than one skin - '" + skinName + "' was loaded " +
            "when '" + isc.currentSkin + "' was already loaded.  See the QuickStart Guide " +
            "for instructions on correctly changing the current skin");
    }
    isc.currentSkin = skinName;
}










//>    @object    isA
//
//    A library of functions for determining the types of other objects.<br><br>
//
//  The "isA" methods for the basic JavaScript types are much faster and more consistent across
//  platforms than JavaScript's "typeof" operator.<br><br>
//
//  An isA method is automatically created for every ISC Class and Interface definition, for
//  example, isA.Canvas().<br><br>
//
//    @example    <code>if (isA.Number(myVariable)) ...</code>
//
//    Note: <code>is</code> and <code>isAn</code> are synonyms of <code>isA</code> and can be used
//            interchangably when it looks better syntactically, eg:
//                <code>if (myObject == null) ...</code>
//            or
//                <code>if (isAn.Array(myObject)) ...</code>
// @treeLocation Client Reference/System
// @visibility external
//<
// create the "isA", "isAn" and "is" objects
isc.addGlobal("isA", {});
isc.addGlobal("isAn", isc.isA);
isc.addGlobal("is", isc.isA);

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.isA.Class = "isA";
  //<DEBUG

isc.isA.isc = isc.isA; // so you can do isc.isA.isc.Canvas(object)


Function.__nativeType = 1;
Array.__nativeType = 2;
Date.__nativeType = 3;
String.__nativeType = 4;
Number.__nativeType = 5;
Boolean.__nativeType = 6;
RegExp.__nativeType = 7;
Object.__nativeType = 8;



Function.prototype.__nativeType = 1;


// add methods to determine the type of various simple objects
isc.addMethods(isc.isA, {
    useTypeOf : isc.Browser.isMoz || isc.Browser.isSafari,

    //>    @classMethod isA.emptyString()
    //
    //    Is <code>object</code> the empty string?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.emptyString()</code>
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a null string
    //    @visibility external
    //<
    emptyString : function (object) {return isc.isA.String(object) && object == isc.emptyString},


    //>    @classMethod isA.nonemptyString()
    //
    //    Is <code>object</code> a non-empty String?<br><br>
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a non-empty string
    //    @visibility external
    //<
    nonemptyString : function (object) {return isc.isA.String(object) && object != isc.emptyString},


    //>    @classMethod isA.Object()
    // Returns whether the passed value is a non-null Object.
    // <p>
    // Returns false for values that are Numbers, Strings, Booleans, Functions or are null or
    // undefined.
    // <p>
    // Returns true for Object, Array, Regular Expression, Date and other kinds of
    // native objects which are considered to extend from window.Object.
    //
    // @param object (any) value to test for whether it's an object
    // @return (boolean) whether passed value is an Object
    // @visibility external
    //<
    //  With the exception of returning false for the null value, this function's return value
    //  matches the ECMA spec for the typeof operator.  It also seems to be a reasonable expected
    //  implementation of this method as it guarantees the programmer can work with properties of
    //  the object as with a standard Object returned by "new Object()".
    _$object:"object",
    _$String :"String",
    Object : function (object) {
        if (object == null) return false;


        if (isc.Browser.isIE && typeof object == this._$function) return false;


        if (this.useTypeOf) {
            var objType = typeof object;
            return (objType == "object" || objType == "array" || objType == "date" ||

                    (isc.Browser.isMoz && objType == "function" && isc.isA.RegularExpression(object)));
        }

        if (object.constructor && object.constructor.__nativeType != null) {
            var type = object.constructor.__nativeType;
            if (type == 1) {

            } else {
                // Object, RegExp, Date, Array
                return (type == 8 || type == 7 || type == 3 || type == 2);
            }
        }

        // Workaround for a core GWT bug, fixed as of GWT 2.5.
        // http://code.google.com/p/google-web-toolkit/issues/detail?id=4301
        if (object.Class != null && object.Class == this._$String) return false;


        if (typeof object == this._$object) {
            if (isc.Browser.isIE && isc.isA.Function(object)) return false;
            else return true;
        } else return false;
    },

    //>    @classMethod isA.emptyObject()
    //
    // Is <code>object</code> an object with no properties (i.e.: <code>{}</code>)?
    // <P>
    // Note that an object that has properties with null values is considered non-empty, eg
    // <code>{ propName:null }</code> is non-empty.
    // <P>
    // NOTE: if you prefer, you can call this as <code>isAn.emptyObject()</code>
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is the empty object
    //    @visibility external
    //<
    emptyObject : function (object) {
        if (!isc.isAn.Object(object)) return false;
        for (var i in object) {
            // if we have a single property we're non-empty!
            return false;
        }
        return true;
    },

    //>    @classMethod isA.emptyArray()
    //
    // Is <code>object</code> an Array with no items?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an empty array
    //    @visibility external
    //<
    emptyArray : function (object) {
        return isc.isAn.Array(object) && object.length == 0;
    },

    //>    @classMethod    isA.String()
    //
    //    Is <code>object</code> a String object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a String
    //    @visibility external
    //<
    // ==========================================================================================
    // IMPORTANT: If you update this function, also update its copy in FileLoader.js
    // ==========================================================================================
    String : function (object) {
        if (object == null) return false;


        if (this.useTypeOf) {
            return typeof object == "string" ||
                (object.Class != null && object.Class == this._$String);
        }


        //if (typeof object == this._$function) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 4;
        }

        // Workaround for a core GWT bug
        // http://code.google.com/p/google-web-toolkit/issues/detail?id=4301
        if (object.Class != null && object.Class == this._$String) return true;

        return typeof object == "string";
    },

    //>    @classMethod    isA.Array()
    //
    //    Is <code>object</code> an Array object?<br><br>
    //
    //    NOTE: if you prefer, you can call this as <code>isAn.Array()</code>
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an Array
    //    @visibility external
    //<
    Array : function (object) {
        if (object == null) return false;


        if (this.useTypeOf && typeof object == "array") return true;


        if (typeof object == this._$function) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 2;
        }



        if (isc.Browser.isSafari) {
            var spliceString = "" + object.splice;
            return (spliceString ==  "function splice() {\n    [native code]\n}" ||
                    spliceString == "(Internal function)");
        }
        return ""+object.constructor == ""+Array;
    },

    //>    @classMethod    isA.Function()
    //
    //    Is <code>object</code> a Function object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Function
    //    @visibility external
    //<
    _$function : "function",
    Function : function (object) {
        if (object == null) return false;


        if (isc.Browser.isIE && typeof object == this._$function) return true;

        // In IE9, attempting to access the "constructor" attribute of a window
        // can lead to an odd crash. If we're passed a native window, return false immediately.

        if (isc.Browser.isIE && (
                (object == window) ||
                (object.document != null && (object.toString != null) &&
                    object.toString().contains("Window") )
            )
           )
        {
            return false;
        }

        var cons = object.constructor;
        if (cons && cons.__nativeType != null) {
            // eliminate known non-functions from an ISC frame
            if (cons.__nativeType != 1) return false;
            // eliminate functions from this frame
            if (cons === Function) return true;

        }


        //if (!object.constructor) isc.Log.logWarn("obj without cons: " + isc.Log.echo(object));
//        isc.logWarn("obj:" + object + "cons:" + isc.emptyString + object.constructor);

        return isc.Browser.isIE ? (isc.emptyString+object.constructor == Function.toString()) :
                                  (typeof object == this._$function);
    },

    //>    @classMethod    isA.Number()
    //
    //    Is <code>object</code> a Number object?<br><br>
    //
    //    NOTE: this returns false if <code>object</code> is an invalid number (<code>isNaN(object) == true</code>)
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Number
    //    @visibility external
    //<
    Number : function (object) {
        if (object == null) return false;


        if (this.useTypeOf && typeof object == "number") {
            // it's a number, now check if it's a valid number
            return !isNaN(object) &&
                object != Number.POSITIVE_INFINITY &&
                object != Number.NEGATIVE_INFINITY;
        }

        if (object.constructor && object.constructor.__nativeType != null) {
            if (object.constructor.__nativeType != 5) return false;
        } else {
            if (typeof object != "number") return false;
        }
        // it's a number, now check if it's a valid number
        return !isNaN(object) &&
            object != Number.POSITIVE_INFINITY &&
            object != Number.NEGATIVE_INFINITY;
    },

    SpecialNumber : function (object) {
        // NOTE: we do need to first determine if it's a number because isNaN({}) is true
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            if (object.constructor.__nativeType != 5) return false;
        } else {
            if (typeof object != "number") return false;
        }
        return (isNaN(object) || object == Number.POSITIVE_INFINITY ||
                object == Number.NEGATIVE_INFINITY);
    },

    //>    @classMethod    isA.Boolean()
    //
    //    Is <code>object</code> a Boolean object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Boolean
    //    @visibility external
    //<
    Boolean    : function (object) {
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 6;
        }
        return typeof object == "boolean";
    },

    //>    @classMethod    isA.Date()
    //
    //    Is <code>object</code> a Date object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Date
    //    @visibility external
    //<
    Date : function (object) {
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 3;
        }
        return (""+object.constructor) == (""+Date) &&
                // if the Date constructor is passed a string it doesn't understand, it returns a
                // sort of pseudo date object, which returns bad values from getYear(), etc.
                object.getDate && isc.isA.Number(object.getDate());
    },

    //>    @classMethod    isA.RegularExpression()
    //
    //    Is <code>object</code> a Regular Expression (RegExp) object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Boolean
    //    @visibility external
    //<
    RegularExpression : function (object) {
        if (object == null) return false;
        if (object.constructor && object.constructor.__nativeType != null) {
            return object.constructor.__nativeType == 7;
        }
        return (""+object.constructor) == (""+RegExp);
    },


    _$textXML : "text/xml",
    XMLNode : function (object) {
        if (object == null) return false;
        if (isc.Browser.isIE) {
            return object.specified != null && object.parsed != null &&
                   object.nodeType != null && object.hasChildNodes != null;
        }
        var doc = object.ownerDocument;
        if (doc == null) return false;
        return doc.contentType == this._$textXML;
    },


    // ---------------------------------------------------------------------------------------
    // NOTE: the following few functions are used strictly in expressionToFunction(), are not
    // i18n-safe, and should not be externally visible
    // ---------------------------------------------------------------------------------------

     //> @classMethod isA.AlphaChar()
     //
     //  Is the character passed in an alpha character?
     //
     //  @param  char    (string)        character to test
     //  @return                 (boolean)       true == character is alpha
     //<
     AlphaChar : function (character) {
         // XXX: does not yet deal with unicode characters or extended ASCII characters.
         var code = character.charCodeAt(0)
         return ((code >= 65 &&
                  code <= 90) ||
                 (code >= 97 &&
                  code <= 122))
     },

     //> @classMethod isA.NumChar()
     //
     //  Is the character passed in a Decimal (0-9) character?
     //
     //  @param  char    (string)        character to test
     //  @return                 (boolean)       true == character is a decimal character
     //<
     NumChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 48 &&
                 code <= 57)
     },

     //> @classMethod isA.AlphaNumericChar()
     //
     //  Is the character passed in alphanumeric?
     //
     //  @param  char    (string)        character to test
     //  @return                 (boolean)       true == character is alphanumeric
     //<
     AlphaNumericChar : function (character) {
        return (isc.isA.AlphaChar(character) || isc.isA.NumChar(character))
    },

     //> @classMethod isA.WhitespaceChar()
     //
     //  Is the character passed in a whitespace character?
     //  This method considers any ascii character from 0-32 to be a whitespace character.
     //
     //  @param  char    (string)        character to test
     //  @return                 (boolean)       true == character is a whitespace character
     //<
     WhitespaceChar : function (character) {
         // XXX: does not yet deal with unicode characters
         var code = character.charCodeAt(0)
         return (code >= 0 &&
                code <= 32)
     },

    //>@classMethod isA.color
    //  Is this a valid css color.  Used by the isColor() validator
    //<

    color : function (object) {
        if (!isc.isA.String(object)) return false;

        if (!this._cssColorRegexp) {
            this._cssColorRegexp = new RegExp(
                            // hex:         "#D3D3D3", etc
                            "^(#([\\dA-F]{2}){3}|" +
                            // rgb:         "rgb(255,255,255)", etc.

                                "rgb\\((\\s*[\\d]{1,3}\\s*,\\s*){2}\\s*[\\d]{1,3}\\s*\\)|" +
                            // colorname:   "white", "black", "pink", etc.

                                "[a-z]+)$",

                            // Case insensitive
                            "i"
            );
        }

        return this._cssColorRegexp.test(object);
    },

    // Module Dependencies:
    // ResultSet / ResultTree are both defined as part of the Databinding module but are frequently
    // checked for within grids.
    // Implement default isA functions for these classes so we can check isc.isA.ResultSet() without
    // needing an explicit check for the function being present
    ResultSet : function (data) {
        return false;
    },
    ResultTree : function (data) {
        return false;
    },

    // Overridding isA.className methods:
    // We provide custom isc.isA implementations for the following class names which we don't
    // want to be clobberred when the class method is defined

    _customClassIsA:{
        SelectItem:true,
        Time:true
    },

    // SelectItem IsA Overrides
    // ---------------------------------------------------------------------------------------

    // isc.isA.SelectItem() default implementation would come from the definition of the
    // selectItem class.
    // However we want this method to return true for NativeSelectItems (not a subclass of
    // SelectItem).
    SelectItem : function (item) {
        if (!item || !isc.isA.FormItem(item)) return false;
        var itemClass = item.getClass();
        return (itemClass == isc.SelectItem || itemClass == isc.NativeSelectItem);
    },

    // Support 'isA.SelectOtherItem()' to test for SelectItems or NativeSelectItems where
    // isSelectOther is true.
    SelectOtherItem : function (item) {
        if (!item || !isc.isA.FormItem(item)) return false;
        var itemClass = item.getClass();
        return ((itemClass == isc.SelectItem || itemClass == isc.NativeSelectItem)
                && item.isSelectOther);
    },

    // SmartClient stores Times in JavaScript Date objects so make isA.Time a synonym for isA.Date
    Time : function (object) {
        return isc.isA.Date(object);
    }

});

if (Array.isArray) {
    isc.addMethods(isc.isA, {

        Array : Array.isArray
    });
}


//    @end @object isA









//>    @object    ClassFactory
//
//    Sets up a real inheritance structure for Javascript objects.
//    We separate out class objects from prototypes, so each gets its own inheritance chain.
//    This allows us to set up superclass calls, maintain class vs. instance variables and more!
//
//    The ClassFactory is a singleton object that holds the miscellaneous pieces of our inheritance
//    mechanism.
//
//    Your main interaction with the ClassFactory is to create new classes:
//        <code>ClassFactory.defineClass("MyClass", "mySuperClass");</code>
//
//    @see class:Class
//
//    @visibility external
// @treeLocation Client Reference/System
//<

//
//    create the ClassFactory singleton object
//
//
isc.addGlobal("ClassFactory", {});

  //>DEBUG
// give it a class name so that methods added to it get labelled
isc.ClassFactory.Class = "ClassFactory";
  //<DEBUG

// ClassFactory defines the notion of an "Instance", "ClassObject" and an "Interface".  Add methods
// to isA for recognizing these objects.
isc.addMethods(isc.isA, {
    //>    @classMethod    isA.Instance()
    //
    //    Is <code>object</code> an instance of some class?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is an instance of some class
    //    @visibility external
    //<
    Instance : function (object) {    return (object != null && object._scPrototype != null)},

    //>    @classMethod    isA.ClassObject()
    //
    //    Is <code>object</code> a class object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Class Object
    //    @visibility external
    //<
    ClassObject : function (object) {    return (object != null && object._isClassObject == true)},

    //>    @classMethod    isA.Interface()
    //
    //    Is <code>object</code> an interface object?
    //
    //    @param    object    (object)    object to test
    //    @return            (boolean)    true == <code>object</code> is a Interface Object
    //    @visibility external
    //<
    Interface : function (object) {    return (object != null && object._isInterface == true)},

    InstancePrototype : function (object) {
        return (isc.isAn.Instance(object) && object._scPrototype == object)
    }
});


isc.isA.instanceMethodsAdded = true;

//
// add methods to the ClassFactory
//
isc.addMethods(isc.ClassFactory, {
    //>    @classMethod    ClassFactory.defineClass()
    //
    // Create a new SmartClient class, which can then be used to create instances of this
    // object type, via +link{Class.create()}.
    // <P>
    // The new Class is returned by <code>defineClass</code>, is available as
    // <code>isc.<i>ClassName</i></code> and is also available in global scope if not in
    // +link{class:isc,portal mode}.  Typically, +link{classMethod:class.addProperties()} is then
    // called to establish different defaults in the new class, or to add methods.  For
    // example:
    // <pre>
    //    isc.defineClass("MyListGrid", "ListGrid").addProperties({
    //        headerHeight : 40, // change default for listGrid.headerHeight
    //
    //        // override listGrid.recordClick
    //        recordClick : function (viewer, record) {
    //           isc.say(record.description);
    //        }
    //    })
    //    isc.MyListGrid.create(); // create an instance of the new class
    // </pre>
    // <P>
    // See also +link{class.Super,Super()} for calling superclass methods.
    // <P>
    // NOTE: <code>isc.defineClass()</code> also creates a new function
    // <code>+link{isA,class:isA}.<i>ClassName()</i></code> object for identifying instances of
    // this Class.
    //
    //    @param    className        (string)    Name for the new class.
    //    @param    [superClass]    (Class)        Optional SuperClass Class object or name
    //    @return                    (Class)        Returns the new Class object.
    //
    //    @visibility external
    //<
    // Internal notes:
    //  Every ClassObject has:
    //  {
    //     Class : [string classname],
    //     _isClassObject : true,
    //     _instancePrototype : [instance prototype for class],
    //
    //     _superClass : [pointer to superClass ClassObject (if this class is not a root class)]
    //
    //     _subClassConstructor : [constructor function that creates subclass ClassObjects]
    //  }
    //
    //  Every InstancePrototype (and Instance) has:
    //  {
    //     Class : [string classname]
    //     _instanceConstructor : [constructor function that creates instances]
    //     _classObject : [ClassObject for this class]
    //    ._scPrototype : [the instance prototype (this same object)]
    //  }
    defineClass : function (className, superClass, interfaces, suppressSimpleNames) {
        return this._defineNonRootClass(className, superClass, interfaces, null, suppressSimpleNames);
    },

    //>    @classMethod    ClassFactory.overwriteClass()
    //
    // Intentionally clobber an existing SmartClient Class, if it already exists.  Works
    // identically to +link{ClassFactory.defineClass}, except that no warning is logged to the
    // console.
    //
    // @visibility external
    //<
    overwriteClass : function (className, superClass, interfaces, suppressSimpleNames) {
        return this._defineNonRootClass(className, superClass, interfaces, null, suppressSimpleNames, true);
    },

    //>    @classMethod    ClassFactory.defineInterface()
    //
    //    An "Interface" is an API definition plus a skeletal implementation of that API.
    //
    //  Interfaces are "mixed in" to another class in order to allow the target class to "support"
    //  the interface.  Interfaces typically require the target class to provide one or two core
    //  methods, and then the interface itself provides the many convenience methods and method
    //  variations that can be written in terms of the core methods.
    //
    //  For example, a List interface could require only get(index) and getLength() from the target
    //  class, and could provide getRange(), indexOf() and other standard List operations.  If the
    //  target class has a more efficient way of supporting getRange() than the generic
    //  implementation in the List interface, the target class can directly implement getRange(),
    //  and the target class' version of getRange() takes precedence.
    //
    //  Comparison to other languages:
    //  - in Java, an "interface" is just an API definition, with no implementation.  The SmartClient
    //    notion of interfaces is closer to an "abstract class", except that in Java you can only
    //    inherit from one abstract class, whereas in SmartClient you can mixin as many Interfaces
    //    as you want.  Also, in SmartClient an Interface can contain both instance and class (aka
    //    "static") methods.
    //  - in Ruby, a Mix-in module corresponds exactly to the SmartClient Interface concept.
    //
    //  Writing Interfaces:
    //  - If you are writing an interface and want to indicate that a method must be implemented in
    //      the target class in order for your interface to work, use addMethods to add a method with
    //      the special value ClassFactory.TARGET_IMPLEMENTS.  If the target class does not
    //      implement the method and it gets called, an error will be logged.
    //  - you can subclass an interface to create another interface, but you can't use Super to
    //      call superclass methods within the interface inheritance chain
    //  - you can define a special initInterface method and it will be called just prior to the
    //    init method on the class that the interface is mixed into
    //  - you can define a special destroyInterface method and it will be called by the destroy
    //    method on the class that the interface is mixed into.  Note that unlike other
    //    languages, javascript does not have a concept of a destructor.  You have to
    //    explicitly call destroy() in order for this logic to run.  But in many cases you
    //    don't have to worry about this because Canvas subclasses cascade the destroy() call
    //    automatically to all children/members/etc.
    //    - if you declare a method in an interface, and mix the interface into a class, you can't
    //      call Super() and get the interface method -- the one you place in your instance will
    //      override the one from the interface.
    //
    //      To make this work, you have to create an intermediate class, then subclass that.  Eg:
    //
    //        CF.defineInterface("face1");
    //        face1.addMethods({ foo:function() {} });
    //
    //        CF.defineClass("class1");
    //        CF.mixInInterface("class1", "face1");
    //
    //        class1.addMethods({
    //            foo : function () {
    //                // NOTE: a Super() call here will NOT go to the face1.foo method
    //            }
    //        })
    //
    //        CF.defineClass("class2", "class1");
    //        class2.addMethods({
    //            foo : function () {
    //                // NOTE: a Super() call WOULD go to the face1.foo method
    //                //             (assuming class1.foo was not present)
    //            }
    //        })
    //
    //<
    defineInterface : function (className, superClass) {
        return this._defineNonRootClass(className, superClass, null, true);
    },

    //>    @classMethod    ClassFactory.defineRootClass()
    //
    //     Variant of defineClass for creating a root class (a class with no superclass).
    //
    //    @param    className        (string)    Name for the new class
    //<
    defineRootClass : function (className) {
        return this._defineClass(className, null);
    },

    //>    @classMethod    ClassFactory._defineNonRootClass()
    //
    //  Define a class or interface which is assumed not to be a root class, that is, either the
    //  superclass must be valid or there must be a valid ClassFactory.defaultSuperClass.
    //<
    _defineNonRootClass : function (className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite) {
        // if no superClass was specified, use the default rootClass
        superClass = (superClass || isc.ClassFactory.defaultSuperClass);
        // if we didn't find a superClass, something went wrong -- bail
        if (!superClass) {
            //>DEBUG
            isc.Log.logWarn("isc.ClassFactory.defineClass(" + className + ") called with null"
                        + " superClass and no ClassFactory.defaultRootClass is defined.");
            //<DEBUG
            return null;
        }
        return this._defineClass(className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite);
    },

    //>    @classMethod    ClassFactory._defineClass()
    //
    // Internal method to actually create a class or interface.  <code>superclass</code> must
    // already be valid.
    //<
    _$iscPrefix : "isc.",
    _$Window : "Window",
    _$Selection : "Selection",
    _classTimes : {},
    _defineClass : function (className, superClass, interfaces, asInterface, suppressSimpleNames, overwrite)
    {


        // If we have an ID collision, and the caller didn't pass true for the "overwrite"
        // param, warn the user before clobbering the existing object

        var ignoreGlobalOverride =
            ((isc.Browser.isMoz || isc.Browser.isChrome) &&
                (className == this._$Window || className == this._$Selection)) ||
            ((isc.Browser.isChrome || isc.Browser.isSafari) && className == "DataView");

        var existingObject, inISCSpace,
            useSimpleNames = (isc._useSimpleNames && !suppressSimpleNames);
        existingObject = isc[className];
        if (existingObject != null) inISCSpace = true
        else if (useSimpleNames && !ignoreGlobalOverride)  {
            existingObject = window[className];
        }

        if (existingObject != null

            && className != "IButton"
            && overwrite != true
            )
        {
            var errorString = "New Class ID: '" + className + "' collides with ID of existing " +
                                // NOTE: this check is required in case there is a collision on
                                // window.Class.  At that moment, isc.isA.Class is not a
                                // function, but the String "isA"
                                (isc.isA && isc.isA.Function(isc.isA.Class) && isc.isA.Class(existingObject) ?
                                    "Class object '" :
                                    "object with value '") +
                                existingObject + "'.  Existing object will be replaced.";
            if (!inISCSpace) errorString += "\nThis conflict would be avoided by disabling " +
                                             "ISC Simple Names mode.  See documentation for " +
                                             "further information."

            // Note: If the Log class hasn't loaded yet, we don't warn about this collision.
            // This should be ok in almost every case as Log loads early during the smartClient
            // libs, but if this proves to be an issue, we could hang onto the error string and
            // wait until after Log has loaded to log a warning.
            if (window.isc.Log) isc.Log.logWarn(errorString);
        }

        // accept superClasses defined as strings rather than references to the class object
        superClass = this.getClass(superClass);

        // create a new instance of the superClass to use as a prototype for this new class
        //    note: instancePrototype.init() is deliberately not called here
        var instancePrototype =
            (superClass ? new superClass._instancePrototype._instanceConstructor() : {});

        // create the class object for the new class: an object whose lookup pointer is the
        // superclass' ClassObject.
        var classObject = this._makeSubClass(superClass);

        // a constructor function that creates objects whose lookup pointer will be
        // instancePrototype.  These created objects are instances of "subClass"
        instancePrototype._instanceConstructor =
                this._getConstructorFunction(instancePrototype);

        // setup the class object
        classObject.Class = className;
        classObject._isClassObject = true;

        // Is this a core ISC class (defined during standard SmartClient init) or is this
        // a class added after the SC libraries have been loaded?
        // Useful for debugging / AutoTest locator APIs

        if (isc.definingFramework == true) classObject.isFrameworkClass = true;
        else classObject.isFrameworkClass = false;
        if (!classObject.isFrameworkClass) {
            var scClass = superClass;
            while (scClass && !scClass.isFrameworkClass) {
                scClass = scClass.getSuperClass();
            }
            if (scClass) classObject._scClass = scClass.Class;
        }

        if (!classObject._scClass) classObject._scClass = classObject.Class;

        // NOTE: important that we always assign _isInterface so that concrete subclasses of
        // interfaces have _isInterface:false
        classObject._isInterface = instancePrototype._isInterface = !!asInterface;
        classObject._superClass = superClass;
        // crosslink the instance prototype and class object
        classObject._instancePrototype = instancePrototype;

        // setup the instance prototype: these properties appear on all instances
        instancePrototype.Class = className;
        // crosslink the instance prototype and class object
        instancePrototype._classObject = classObject;
        // this exists mostly so that instances can reference their prototype
        instancePrototype._scPrototype = instancePrototype;

        // copy the scClass information across too
        instancePrototype.isFrameworkClass = classObject.isFrameworkClass;
        instancePrototype._scClass = classObject._scClass;

        // put all Classes in the special "isc" object
        isc[className] = classObject;
        // if we're in simple names mode (eg, not worried about name collisions), make the class
        // available as a global variable
        if (useSimpleNames) window[className] = classObject;

        this.classList[this.classList.length] = className

        // create a function in the isA singleton object to tell if an object is an instance of
        // this Class, eg, isA.ListGrid()
        // Exception - the _customClassIsA object is used to track cases where we isc.isA has
        // already been given a custom method which we don't want to clobber
        if (!(isc.isA._customClassIsA[className] && isc.isA[className])) {
            isc.isA[className] = this.makeIsAFunc(className);
        }

        // as a convenience, mix in a list of interfaces as part of the class definition
        if (interfaces != null) {
            if (!isc.isAn.Array(interfaces)) interfaces = [interfaces];
            for (var i = 0; i < interfaces.length; i++) {
                //alert("Mixing " + interfaces[i] + " into " + className);
                this.mixInInterface(className, interfaces[i]);
            }
        }

        return classObject;
    },


    makeIsAFunc : function (className) {
        if (this.isFirefox2 == null) {
            this.isFirefox2 = (isc.Browser.isFirefox && isc.Browser.geckoVersion >= 20061010);
        }

        if (this.isFirefox2) {
            return function (object) {
                        if (object==null || object.isA==null || object.isA == isc.isA) return false;
                        return object.isA(className);
                   }
        } else {
            var template = this._isAFuncTemplate;
            template[1] = className;

            return new Function (this._objectString, template.join(isc._emptyString));
        }
    },

    // variables for creating "isA" functions for each class
    _objectString : "object",
    _isAFuncTemplate : [

        "if(object==null||object.isA==null||object.isA==isc.isA)return false;return object.isA(isc.",
        null, // className
        ")"
    ],

    // make a class object for a new subclass of superClass
    _makeSubClass : function (superClass) {
        if (!superClass) return {};

        // get the superClass' subclass constructor.  The subclass constructor creates objects
        // whose lookup pointer will be superClass.  It is created on the fly the first time a
        // class acquires a subclass (otherwise all leaf classes would have unnecessary
        // subclass constructors)
        var superSuperClass = superClass._superClass,
            subClassConstructor = superClass._subClassConstructor;
        if (!
            // if the superClass already has a subClassConstructor that differs from the
            // super-super class, use it
            (subClassConstructor &&
             (superSuperClass == null ||
              subClassConstructor !== superSuperClass._subClassConstructor))
            )
        {
            // otherwise we make it
            subClassConstructor = superClass._subClassConstructor =
                    this._getConstructorFunction(superClass);
        }
        return new subClassConstructor();
    },

    //>    @classMethod    ClassFactory.getClass()
    //
    //    Given a class name, return a pointer to the Class object for that class
    //
    //    @param    className    (string)    name of a class
    //    @return                (Class)        Class object, or null if not found
    //    @visibility external
    //<
    getClass : function (className) {
        // if it's a string, assume it's a className
        if (isc.isA.String(className)) {
            // see if isc[className] holds a ClassObject or an SGWTFactory
            var classObject = isc[className];
            if (classObject) {
                if (isc.isA.ClassObject(classObject)) return classObject;
                // SGWTFactory might not be defined yet ...
                if (isc.isA.SGWTFactory && isc.isA.SGWTFactory(classObject)) return classObject;
            }
        }
        // if it's a class object or an SGWTFactory, just return it
        if (isc.isA.ClassObject(className)) return className;
        // SGWTFactory might not be defined yet ...
        if (isc.isA.SGWTFactory && isc.isA.SGWTFactory(className)) return className;

        // if it's an instance of some class, return the class object for the class
        if (isc.isAn.Instance(className)) return className._classObject;
        //if (isc.Log) {
        //    isc.Log.logWarn("couldn't find class: " + className +
        //                    ", defined classes are: " + this.classList);
        //}
        return null;
    },

    //>    @classMethod    ClassFactory.newInstance
    //
    // Given the name of a class, create an instance of that class.
    //
    //        @param    className    (string)        Name of a class.
    //                            (ClassObject)    Actual class object to use.
    //        @param    [props]        (object)        Properties to apply to the instance.
    //        @param    [props2]    (object)        More properties to apply to the instance.
    //        @param    [props3]    (object)        Yet more properties to apply to the instance.
    //
    //    @return                (class)        Pointer to the new class.
    //    @visibility external
    //<
    // NOTE: ability to pass _constructor not documented until we have a more reasonable name for
    // this property.
    newInstance : function (className, props, props2, props3, props4, props5) {

        var classObject = this.getClass(className);

        // if we didn't get a classObject from getClass above,
        // and the first parameter is an object,
        // see if any of the properties objects passed have a ._constructor property,
        // which we'll treat as the classname
        if (classObject == null && isc.isAn.Object(className)) {

            var cons;
            for (var i = 0; i < arguments.length; i++) {
                var propsObj = arguments[i];
                // Note: ._constructor is used rather than .constructor to resolve a
                // number of JS issues, as constructor is present by default on native
                // JS objects.
                // In the long run we want to rename this to something more elegant, like 'class'
                // and modify the css class-specific code to look for 'style' or 'baseStyle' rather
                // than className (or even getClass()).
                if (propsObj != null && propsObj._constructor != null)
                {
                    cons = propsObj._constructor;
                }
            }

            // now fix up the props objects to include the first object
            //    as a set of properties instead of just the class name
            props5 = props4;
            props4 = props3;
            props3 = props2;
            props2 = props;
            props = className;

            className = cons;

            // Safari and Mozilla both JS Error if the 'constructor' property set to a string
            // (typically because a user is trying to specify the className to use. (it's ok in IE)
            // Note: the 'constructor' property exists as a native function on a number of standard
            // JS objects, so we can't just check for constructor == null
            if (isc.isA.String(props.constructor)) {
                // If we don't yet have a constructor className, make use of this property - then
                // log a warning and remove it.
                if (className == null) className = props.constructor;
                isc.Log.logWarn("ClassFactory.newInstance() passed an object with illegal 'constructor' " +
                             "property - removing this property from the final object. " +
                             "To avoid seeing this message in the future, " +
                             "specify the object's class using '_constructor'.", "ClassFactory");
                props.constructor = null;
            }

            classObject = this.getClass(cons);
        }

        if (classObject == null) {
            //>DEBUG
            isc.Log.logWarn("newInstance(" + className + "): class not found", "ClassFactory");
            if (isc.isA.String(className) && className.contains(".")) {
                isc.Log.logWarn("Did you make the SmartGWT class reflectable? See http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Reflection.html", "ClassFactory");
            }
            //<DEBUG
            return null;
        }

        return classObject.newInstance(props, props2, props3, props4, props5);
    },

    //>    @classMethod    ClassFactory._getConstructorFunction
    //
    //    Given a <code>prototype</code> object, create a new constructor function that will
    //    reference this prototype.  This allows us to say <code>new constructor()</code> to
    //    create a new object that is effectively a subclass of the original <code>prototype</code>.
    //
    //    @param    proto    (object)    Object to use as the prototype for new objects.
    //    @return            (function)    Function that can be used to create new objects
    //                                based on the prototype.
    //<
    _getConstructorFunction : function (proto) {

        var cons = (isc.Browser.isSafari ? function () {} : new Function());
        cons.prototype = proto;
        return cons;
    },



    //>    @classMethod    ClassFactory.addGlobalID()
    //
    // Given an <code>object</code>, declare a unique global variable and link it to object so
    // object can be addressed in the global scope.<br><br>
    // <P>
    // If the object already has an 'ID' property, it will be used. Note that if you pass an
    // object.ID, it's up to you to ensure it is unique in the global scope. If window[<i>ID</i>]
    // is already assigned to something else a warning will be logged using the developer console,
    // and the existing reference will be replaced.
    // <P>
    // If the object does not have an explicitly specified ID property already, one will be
    // automatically generated. Note that automatically generated global IDs may be reused if
    // the instance they originally referenced has been +link{Class.destroy(),destroyed}.
    //
    //    @param    object    (object)    Object to add global ID to.
    //<
    _reservedWords:{
        toolbar:true,
        parent:true,
        window:true,
        top:true,
        opener:true,
        event:true // due to window.event in IE
    },
    addGlobalID : function (object, ID, dontWarn) {
        // if an ID was passed, use that
        object.ID = ID || object.ID;

        var wd = this.getWindow();

        // in keepGlobals mode only certain objects are allowed to actually keep their declared
        // global IDs.  Anything else is given the declared global ID temporarily, then retains
        // only its auto-generated global ID after the eval ends.
        if (isc.keepGlobals && object.ID != null) {
            if (!isc.keepGlobals.contains(object.ID) &&
                !(isc.DataSource && isc.isA.DataSource(object)))
            {
                var tempID = object.ID;
                object.ID = null;
                isc.globalsSnapshot[tempID] = wd[tempID];
                wd[tempID] = object;
            }
        }

        if (object.ID == null) {
            object.ID = this.getNextGlobalID(object);
            object._autoAssignedID = true;
        }


        // if the ID is already taken, log a warning
        var isKeyword, checkForKeyword;
        if (wd[object.ID] != null) {
            var instance = isc.isA.Canvas(wd[object.ID]);

            if (!dontWarn) {
                isc.Log.logWarn("ClassFactory.addGlobalID: ID:'" + object.ID +
                                "' for object '" + object +
                                "' collides with ID of existing object '" + wd[object.ID] + "'." +
                                (instance ? " The pre-existing widget will be destroyed." :
                                            " The global reference to this object will be replaced"));
            }
            if (instance) wd[object.ID].destroy();
            // If the attribute is not a pointer to a widget instance it may be a
            // a reserved browser keyword or native window attribute which may be non overrideable.
            // Catch the cases we know about (stored in an explicit list)
            // Otherwise use a try...catch block when assigning the property to ensure we don't
            // crash

            if (!instance) {
                if (this._reservedWords[ID]) isKeyword = true;
                else checkForKeyword = true;
            }
        }

        // now assign the object under that ID globally so anyone can call it
        if (!isKeyword) {
            if (checkForKeyword) {
                try {
                    wd[object.ID] = object;
                } catch (e) {
                    isKeyword = true;
                }
                // attempting to override some keywords (for example window.document) will not
                // throw an error but simply fail to pick up the new value - catch this case as
                // well
                if (wd[object.ID] != object) {
                    isKeyword = true;
                }
            } else {
                wd[object.ID] = object;
            }
        }
        // simple mechanism for instrumenting globals capture.  Simply set isc.globalsSnapshot to an
        // array and we'll fill it here.

        if (isc.globalsSnapshot) {
            if (isc.isAn.Array(isc.globalsSnapshot)) {
                // just store all globals that are established
                isc.globalsSnapshot.add(object.ID);
            } else {
                // store a mapping from new globals to original value to allow them to be
                // restored
                isc.globalsSnapshot[object.ID] = wd[object.ID];
            }
        }

        // refuse to use keywords and log a warning
        if (isKeyword) {
            var newID = this.getNextGlobalID(object);
            isc.logWarn("ClassFactory.addGlobalID: ID specified as:"+  object.ID +
                         ". This is a reserved word in Javascript or a native property of the" +
                         " browser window object and can not be used as an ID." +
                         " Setting ID to " + newID + " instead.");
            object.ID = newID;
            object._autoAssignedID = true;
            wd[object.ID] = object;
        }

    },

    _$isc_OID_ : "isc_OID_",
    _$isc_ : "isc_",
    _$underscore : "_",
    _joinBuffer : [],

    _perClassIDs:{},

    getNextGlobalID : function (object) {
        var classString = object != null && isc.isA.String(object.Class) ? object.Class : null;
        return this.getNextGlobalIDForClass(classString);

    },
    getNextGlobalIDForClass : function (classString) {

        if (classString) {
            var freed = this._freedGlobalIDs[classString]
            if (freed && freed.length > 0) {
                var ID = freed[freed.length-1];
                freed.length = freed.length-1;
                return ID;
            }
            var idCount;
            if (this._perClassIDs[classString] == null) this._perClassIDs[classString] = 0;
            idCount = this._perClassIDs[classString]++;

            var buffer = this._joinBuffer;
            buffer[0] = this._$isc_;
            buffer[1] = classString;
            buffer[2] = this._$underscore;
            isc._fillNumber(buffer, idCount, 3,5);

            var result = buffer.join(isc.emptyString);
            return result;
        }
        return this._$isc_OID_ + this._globalObjectID++;
    },
    // dereferenceGlobalID()
    // - frees the window[ID] pointer to an object
    // - allows the global ID to be re-used within this page
    dereferenceGlobalID : function (object) {
        // remove the window.ID pointer to the object.
        // NOTE: don't destroy the global variable if it no longer points to this widget
        // (this might happen if you create a new widget with the same ID)
        if (window[object.ID] == object) {
            window[object.ID] = null;

            if (object.Class != null && object._autoAssignedID) {
                this.releaseGlobalID(object.Class, object.ID);
            }

            // Don't actually delete the object.ID property - This method is typically called
            // as part of destroy() and if for some reason we have a pointer to a destroyed object
            // it's helpful to know the ID for debugging.
        }
    },

    // Maintain a pool of global IDs that are no longer in use due to destroy() calls
    // and reuse them rather than creating new IDs where possible


    // GlobalIDs are of the form isc_ClassName_int (isc_StaticTextItem_24, etc)
    // We maintain a cache of previously used global IDs indexed by className, set up each time we
    // call dereferenceGlobalID(). Then autoAssignGlobalID() can re-use IDs from the cache for
    // the appropriate object className
    reuseGlobalIDs:true,
    globalIDClassPoolSize:1000,
    _freedGlobalIDs:{
    },
    releaseGlobalID : function (className, ID) {

        if (!this.reuseGlobalIDs) return;
        var freed = this._freedGlobalIDs[className];
        if (!freed) this._freedGlobalIDs[className] = [ID];
        else if (freed.length <= this.globalIDClassPoolSize) {
            if (!freed.contains(ID)) freed[freed.length] = ID;
        }
    },

    _domIDCount:0,
    _$isc_:"isc_",
    _simpleDOMIDTemplate:[null, "_", null],

    // DOM ID Cacheing logic

    // Maintain a cache of generated DOM ID strings that are no longer in use and re-use them when
    // we need a new arbitrary DOM ID.
    // Canvii may notify us when DOM IDs are no longer in use by calling releaseDOMID()
    // Behavior may be disabled by setting reuseDOMIDs to false
    // Note that reuseDOMIDs may also be set to false on individual Canvii - see
    // Canvas._releaseDOMIDs
    reuseDOMIDs:false,
    DOMIDPoolSize:10000,
    _freedDOMIDs:[],
    releaseDOMID : function (ID) {
        if (!this.reuseDOMIDs || this._freedDOMIDs.length > this.DOMIDPoolSize) return;
        this._freedDOMIDs[this._freedDOMIDs.length] = ID;
    },

    // getDOMID() - return a unique string to be used as a DOM Id.
    //
    // Has 2 modes:
    // If isc._longDOMIds is false (production mode), the returned IDs are arbitrary short
    // strings
    // If isc._longDOMIds is true (development mode), the IDs will be generated based on the
    // ID and suffix passed into this method - useful for debugging as the DOM IDs obviously relate
    // to the canvases that created them.
    getDOMID  : function (ID, suffix) {

        // By default we return a unique but uninformative ID like "isc_1A"

        if (!isc._longDOMIds || !ID || !suffix) {

            // by preference we'll reuse a DOM ID we know has been freed
            var freedIDs = this._freedDOMIDs.length
            if (freedIDs > 0) {
                var ID = this._freedDOMIDs[freedIDs-1];
                this._freedDOMIDs.length = freedIDs-1;
                return ID;
            }

            var number = this._domIDCount++;
            return this._convertToBase36(number, this._$isc_);
        }



        // In simpleDOMIDMode, create an ID that incorporates the ID / suffix passed to us
        // We're making an assumption that the ID / suffix passed in is already unique

        this._simpleDOMIDTemplate[0] = ID;
        this._simpleDOMIDTemplate[2] = suffix;
        return this._simpleDOMIDTemplate.join(isc.emptyString);
    },

    _base36Digits:["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K",
                   "L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"],
    _base36Arr:[],
    _convertToBase36 : function (number, prefix) {
        var digits = this._base36Digits,
            resultsArr = this._base36Arr;

        resultsArr.length = 0;

        // We use this to prefix with "isc_"
        if (prefix) resultsArr[0] = prefix;

        var totalDigits = 3;

        if (number > 46655) {
            while (Math.pow(36,totalDigits) <= number) totalDigits += 1;
        }

        // convert number to base 36
        while (number >= 36) {
            var remainder = number % 36;
            // always add to the end slot, so we get 100 rather than 001
            resultsArr[totalDigits-(prefix ? 0 : 1)] = digits[remainder];
            totalDigits -=1;

            number = Math.floor(number / 36);
        }
        resultsArr[totalDigits-(prefix ? 0 : 1)] = digits[number];

        return resultsArr.join(isc.emptyString);

    },

    //>    @classMethod    ClassFactory.mixInInterface()    (A)
    //
    // Add the methods of a given Interface to a Class so the class implements the methods.
    // If the class has already defined a method with the same name as the one specified
    // in the interface, the class' method will be retained.
    //
    //    @param    className        (String)    Name of the Class to add methods to.
    //    @param    interfaceName    (String)    Name of the Interface to get methods from.
    //<
    mixInInterface : function (className, interfaceName) {
        var theInterface = this.getClass(interfaceName),
            theClass = this.getClass(className)
        ;
        if (!theInterface || !theClass) return null;

        if (!theInterface._isInterface) {
            //>DEBUG
            isc.Log.logWarn("ClassFactory.mixInInterface asked to mixin a class which was not"
                        + " declared as an Interface: "+interfaceName+ " onto "+className);
            //<DEBUG
            return;
        }

        // mark the class as implementing the interface
        if (!theClass._implements) theClass._implements = [];
        // ensure the interface doesn't apply to a superClass
        else theClass._implements = theClass._implements.duplicate();

        // install all properties and methods added to this interface, and any superInterfaces
        while (theInterface) {
            // mix in class properties and methods
            this._mixInProperties(theInterface, theClass, true);
            // mix in instance properties and methods
            this._mixInProperties(theInterface, theClass);

            theClass._implements[theClass._implements.length] = interfaceName;

            theInterface = theInterface.getSuperClass();
            if (theInterface && !theInterface._isInterface) break;
        }
    },

    _initInterfaceMethodName: "initInterface",
    _destroyInterfaceMethodName: "destroyInterface",
    _mixInProperties : function (source, destination, asClassProperties) {
        var props,
             destinationClass = destination
        ;
        if (asClassProperties) {
            props = isc._interfaceClassProps[source.Class];
        } else {
            props = isc._interfaceInstanceProps[source.Class];
            source = source.getPrototype();
            destination = destination.getPrototype();
        }

        if (props == null) return;

        for (var i = 0; i < props.length; i++) {
            var propName = props[i];

            // skip any properties already defined in the target
            if (destination[propName] != null) continue;

            var propValue = source[propName];

            // the interface declared that the target class must implement a method, and it's not
            // there
            if (isc.isA.String(propValue) && propValue == this.TARGET_IMPLEMENTS) {
                //>DEBUG
                var message = (asClassProperties ? "Class" : "Instance") + " method "
                    + propName + " of Interface " + source.Class + " must be implemented by "
                    + "class " + destination.Class;
                // Don't complain about interface methods not being implemented b/c it's
                // perfectly normal to mix in interfaces before adding properties to the
                // class.  In fact that may be the case most of the time b/c showing the
                // interfaces at class definition is very useful
                // (e.g: defineClass("Foo", "Bar", "SomeInterface")
                //
                //isc.Log.logWarn(message + ", is not yet implemented");

                // but it will be an error if this method is ever called, so install a function
                // that will complain
                destination[propName] = new Function('this.logError("' + message + '")');
                //<DEBUG
            } else if (propName == this._initInterfaceMethodName && !asClassProperties) {
                // patch any initInterface() methods onto a special array on the classObject to
                // be called at class creation.
                if (destinationClass._initInterfaceMethods == null) destinationClass._initInterfaceMethods = [];
                destinationClass._initInterfaceMethods[destinationClass._initInterfaceMethods.length] = propValue;
            } else if (propName == this._destroyInterfaceMethodName && !asClassProperties) {
                // patch any destroyInterface() methods onto a special array on the classObject to
                // be called at class destruction.
                if (destinationClass._destroyInterfaceMethods == null) destinationClass._destroyInterfaceMethods = [];
                destinationClass._destroyInterfaceMethods[destinationClass._destroyInterfaceMethods.length] = propValue;
            } else {
                //isc.Log.logWarn("adding property " + propName +
                //                " from interface " + source.Class);
                destination[propName] = propValue;
            }
        }
    },

    //>    @classMethod    ClassFactory.makePassthroughMethods()    (A)
    //
    // Create methods that call through to a related object stored under property
    // <code>propName</code>.  This enables easy implementation of the Delegate design
    // pattern, where one object implements part of its APIs by having another object respond
    // to them.
    //
    //    @param    methodNames    (array of strings)    list of methods names
    //    @param    propName    (string)            Property name where the target object is stored.
    //<
    _$argList : "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p",
    makePassthroughMethods : function (methodNames, propName, addNullCheck, nullCheckWarning,
                                       inheritedProperty)
    {
        if (!propName) propName = "parentElement";

        var funcTemplate;
        if (!addNullCheck) {
            funcTemplate = this._funcTemplate;
            if (funcTemplate == null) {
                funcTemplate = this._funcTemplate = ["return this.",,".",,"("+this._$argList+")"];
            }
        } else {
            funcTemplate = this._nullCheckFuncTemplate;
            if (funcTemplate == null) {
                funcTemplate = this._nullCheckFuncTemplate =
                    ["if(this.",,"==null){\n",
                     ,// optionally log a warning
                     "return;}\n",,"return this.",,".",,"("+this._$argList+")"];
            }
        }

        var methods = {};

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i];

            // create a function that routes a function call to the target object
            if (addNullCheck) {
                funcTemplate[1] = propName;
                if (nullCheckWarning != null) {
                    var messageArgs = {
                        methodName:methodName,
                        propName:propName
                    };
                    var warning = nullCheckWarning.evalDynamicString(this, messageArgs);

                    funcTemplate[3] = "isc.logWarn(\"" + warning + "\");";
                }
                if (inheritedProperty != null) {
                    funcTemplate[5] = "this." + propName + "." + inheritedProperty + "=" +
                                      "this." +                  inheritedProperty + ";\n";
                }
                funcTemplate[7] = propName;
                funcTemplate[9] = methodName;

            } else {
                funcTemplate[1] = propName;
                funcTemplate[3] = methodName;
            }
            methods[methodName] =
                new Function(this._$argList, funcTemplate.join(isc.emptyString));
        }

        return methods;
    },

    //>    @classMethod    ClassFactory.writePassthroughFunctions()    (A)
    //
    // Install methods in <code>destinationClass</code> which will call the same-named function
    // on a related object stored under the property name <code>memberName</code> on instances
    // of <code>destinationClass</code>.
    //
    //    @example    <code>ClassFactory.writePassthroughFunctions(
    //                    ListGrid, "selection", ["select","selectAll",..."]
    //                );</code>
    //
    //                after this, you can call
    //                    listGrid.selectRecord()
    //                rather than
    //                    listGrid.selection.selectRecord()
    //<
    writePassthroughFunctions : function (destinationClass, memberName, methodNames) {
        var methods = this.makePassthroughMethods(methodNames, memberName);
        destinationClass.addMethods(methods);
    }

});    // END isc.addMethods(isc.ClassFactory)

//
// add properties to the ClassFactory object
//
isc.addProperties(isc.ClassFactory, {
    // when defining interfaces, use this constant as a marker value indicating that a method
    // must be implemented by any class your interface is mixed in to
    TARGET_IMPLEMENTS : "TARGET_IMPLEMENTS",

    //>    @attr    ClassFactory.defaultSuperClass  (Class : null : [IA])
    // Class to use as the default superClass if none is specified
    //<

    // Counter which is used to generate unique object IDs
    _globalObjectID : 0,

    // Classes created with ClassFactory.defineClass
    classList : []
});

//> @classMethod isc.defineClass
// Shortcut for <code>isc.ClassFactory.defineClass()</code>.
// @include classMethod:ClassFactory.defineClass
// @see ClassFactory.defineClass()
// @visibility external
//<
isc.defineClass = function (className, superClass, interfaces, suppressSimpleName) {
    return isc.ClassFactory.defineClass(className, superClass, interfaces, suppressSimpleName);
}

//> @classMethod isc.overwriteClass
// Shortcut for <code>isc.ClassFactory.overwriteClass()</code>.
// @include classMethod:ClassFactory.overwriteClass
// @see ClassFactory.overwriteClass()
// @visibility external
//<
isc.overwriteClass = function (className, superClass, interfaces, suppressSimpleName) {
    return isc.ClassFactory.overwriteClass(className, superClass, interfaces, suppressSimpleName);
}

isc.defineInterface = function (className, superClass) {
    return isc.ClassFactory.defineInterface(className, superClass);
}

//> @type SCClassName
// Name of a SmartClient Class, that is, a Class that has been created via
// +link{classMethod:isc.defineClass()}, including Classes built into SmartClient, such as "ListGrid".
//
// @visibility external
//<

isc.defer = function (code) {
    var lastClass = isc.ClassFactory.getClass(isc.ClassFactory.classList.last()),
        existingCode = lastClass._deferredCode;
    isc.Log.logDebug("deferred code being placed on class: " + lastClass);
    // first time
    if (!existingCode) lastClass._deferredCode = [code];
    // more times
    else existingCode.add(code);
}






if (!isc.Browser.isSafari) {
    isc._window = window;
    isc._document = window.document;
}


if (window.isc_enableCrossWindowCallbacks && isc.Browser.isIE) {
   isc.enableCrossWindowCallbacks = true;
   Object._window = window;
}



//>    @class    Class
//
// The Class object is root of the Isomorphic SmartClient inheritance tree -- it includes
// functionality for creating instances, adding methods and properties, getting prototypes,
// etc.<br><br>
//
// To add functionality to ALL classes, add them to Class.<br><br>
//
// To create a Class, call <code>ClassFactory.defineClass("MyClass", "MySuperClass")</code>
// <P>
// <code>defineClass</code> will return the created class, and make it available as
// <code>isc.MyClass</code>, and as the global variable <code>MyClass</code> if not in
// +link{class:isc,portal mode}.
// <P>
// You can then:
// <UL>
//        <LI>add class-level (static) properties and methods to the class:
//                <code>MyClass.addClassProperties()</code>
//            these methods and properties are accessed through the Class variable itself, eg:
//                <code>MyClass.someStaticMethod()</code> or <code>MyClass.someStaticProperty</code>
//
//        <LI>add default instance properties and methods to the class:
//                <code>MyClass.addProperties()</code>
//            these methods and properties are accessed through a class instance, eg:
//                <code>var myInstance = MyClass.create();</code>
//                <code>myInstance.someInstanceMethod()</code>
//
//        <LI>create new instances of this class:
//                <code>var myInstance = MyClass.create()</code>
// </UL>
// NOTE: as a convention, all class names begin with a capital letter and all instances begin
// with a lower case letter.
//
//  @treeLocation Client Reference/System
//    @visibility external
//<
isc.ClassFactory.defineRootClass('Class');

//
// set Class as the default superclass for classes defined by ClassFactory.defineClass()
//
isc.ClassFactory.defaultSuperClass = isc.Class;

//
//    add static methods to all classes defined with our system
//
//    call on the Class object itself, as:   Class.method()
//

//  First we install the methods that allow us to addMethods to a class as a method call on the
//  class (eg Class.addClassMethods(methods) rather than addMethods(Class, methods);.
isc.addMethods(isc.Class, {

    //>    @classMethod    Class.addClassMethods()
    //
    //    Add static (Class-level) methods to this object.<br><br>
    //
    //    These methods can then be called as MyClass.method().  The value for "this" will be the
    //    class object for the class.
    //
    //    @param    [arguments 0-N] (object)    objects with methods to add (think named parameters).
    //                                        all the methods of each argument will be applied
    //                                        as class-level methods.
    //    @visibility internal
    //<

    addClassMethods : function () {
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this, arguments[i]);
    }

});

isc.Class.addClassMethods({

    //>    @classMethod Class.create()
    //
    // Create an instance of this class.
    // <P>
    // All arguments passed to this method are passed on to the +link{Class.init()} instance
    // method.  Unless +link{class.addPropertiesOnCreate} is set to <code>false</code>, all
    // arguments passed to this method must be Objects and all properties on those
    // objects will be copied to the newly created instance before +link{Class.init()} is
    // called.  If there are overlapping properties in the passed arguments, the last wins.
    // <p>
    // Any return value from +link{Class.init()} is thrown away.
    // <p>
    // Note: Generally, you would not override this method.  If you want to specify a
    // constructor for your class, provide an override for +link{Class.init()} for generic
    // classes or +link{canvas.initWidget()} for any subclasses of UI components
    // (i.e. descendants of +link{Canvas}.
    //
    //    @param    [arguments 0-N]    (any)
    //      Any arguments passed will be passed along to the init() routine of the instance.
    //      Unless +link{class.addPropertiesOnCreate} is set to false, any arguments passed to
    //      this method must be of type Object.
    //    @return                     (object)
    //      New instance of this class, whose init() routine has already been called
    //
    //    @example    <code>var myInstance = MyClass.create()</code>
    //  @example    create
    //    @visibility external
    //<
    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var newInstance = this.createRaw();

        newInstance = newInstance.completeCreation(A,B,C,D,E,F,G,H,I,J,K,L,M);

        // return the new instance
        return newInstance
    },


    _initializedClasses : {},
    createRaw : function () {
        if (!this.initialized()) this.init();

        // create a new instance based on the class's instanceProtoype
        var newInstance = new this._instancePrototype._instanceConstructor();

        // install the appropriate namespace on the instance
        newInstance.ns = this.ns;

        return newInstance;
    },

    // class-level init
    init : function () {
        //this.logWarn("uninitialized class");

        // init superclass chain
        var superClass = this.getSuperClass();
        if (superClass && !superClass.initialized()) superClass.init();

        // execute any deferred class definition
        var deferredCode = this._deferredCode;
        if (deferredCode) {
            //this.logWarn("eval'ing deferred code");
            this._deferredCode = null;
            deferredCode.map(function (expression) {
                isc.eval(expression);
            });
        }



        if (this.autoDupMethods) {
            isc.Class.duplicateMethods(this, this.autoDupMethods);
        }

        this._initializedClasses[this.Class] = true;
    },

    // to get around native browser limitations with stack traces being unable to proceed
    // through recursively called methods, create duplicates of certain key functions on every
    // class and instance.

    duplicateMethods : function (target, methodNames) {
        // skip certain ultralight classes
        if (target.Class && this.dontDup[target.Class]) return;

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i];

            this.duplicateMethod(methodName, target);
        }
    },
    duplicateMethod : function (methodName, target) {
        if (!target) target = this;

        var method = target[methodName];

        if (method == null) return;

        // avoid duplicating a duplicate, which would force Super() to follow multiple
        // _originalMethod links to discover the true original method.
        if (method._originalMethod) {
            while (method._originalMethod) method = method._originalMethod;
            //this.logWarn("double dup: " + methodName + " on target: " + target);
        }

        //!DONTOBFUSCATE
        var dup;
        if (method.toSource == null) { // IE, Safari
            dup = eval("dup = " + method.toString());
        } else {
            dup = eval(method.toSource());
        }

        // figure out the method's name
        if (!method._fullName) isc.Func.getName(method, true);
            /*
            name = (isc.isA.ClassObject(target) ? "[c]" : "") +
                    (target.Class ? target.Class : "") +
                    "." + methodName + "[d]";
            */
        dup._fullName = method._fullName + "[d]";

        // to allow Super() to do correct comparisons with superclass implementations
        dup._originalMethod = method;

        target[methodName] = dup;

        return dup;
    },
    dontDup : {
        StringBuffer : true,
        Action : true,
        MathFunction : true,
        JSONEncoder : true
    },
    // class-level auto-dups
    //autoDupMethods: [ "fireCallback" ],

    // NOTE: we have to use a structure like this instead of just checking a property on the
    // class object (eg this._initialized) because any property would be inherited from
    // superclass class objects.
    initialized : function () { return this._initializedClasses[this.Class] },

    //>    @classMethod Class.getClassName()
    //
    //    Gets the name of this class as a string.
    //
    //    @return (string)    name of the class
    //    @visibility external
    //<
    getClassName : function () {
        return this.Class;
    },

    //> @classMethod Class.getScClassName()
    //
    //  Gets the name of this class as a string, if the class is a SmartClient Framework class.
    //  Otherwise, gets the name of the SmartClient Framework class which this class extends.
    //
    //  @return (string) name of the SmartClient Framework class
    //<
    getScClassName : function () {
        return this.isFrameworkClass ? this.Class : this._scClass;
    },

    //>    @classMethod Class.getSuperClass()
    //
    //    Gets a pointer to the superClass' Class object.
    //
    //    @return (Class)        Class object for superclass.
    //    @visibility external
    //<
    getSuperClass : function () {
        return this._superClass;
    },

    //>    @classMethod Class.getPrototype
    //
    //    Gets a pointer to the prototype object for this class.
    //
    //    This is the object that you should install methods/properties into
    //    to have them apply to each instance.  Generally, you should use
    //    +link{Class.addProperties()} to do this
    //    rather than affecting the prototype directly
    //
    //    @return    (object)    Prototype for all objects instances.
    //<
    // NOTE: not external because customers shouldn't muck with the prototype directly
    getPrototype : function () {
        return this._instancePrototype;
    },

    //> @classMethod Class.addMethods()
    //
    // Helper method for adding method definitions to all instances of this class.<P>
    //
    // The added methods can be called as myInstance.method().<P>
    //
    // Functionally equivalent to +link{class.addProperties}, which works with both properties
    // and methods.
    //
    // @param [arguments 0-N] (object) objects with methods to add (think named parameters).
    //                                  all the methods of each argument will be applied
    //                                  as instance-level methods.
    // @return (object) the class after methods have been added to it
    // @visibility external
    //<

    addMethods : function () {
        if (this._isInterface) {
            this.logWarn("Use addInterfaceMethods() to add methods to interface " + this);
        }
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this._instancePrototype, arguments[i]);
        return this._instancePrototype;
    },

    addInterfaceMethods : function () {
        for (var i = 0; i < arguments.length; i++)
            isc.addMethods(this._instancePrototype, arguments[i]);
    },
    addInterfaceProperties : function () {
        isc.addPropertyList(this._instancePrototype, arguments);
    },


    //>    @classMethod Class.registerStringMethods()
    //
    //    Register a method, or set of methods, that can be provided to instances of this class as
    //    Strings (containing a JavaScript expression) and will be automatically converted into
    //    functions.
    //  <p>
    //  For example:
    //  <pre>
    //  isc.MyClass.registerStringMethods({
    //      myStringMethod: "arg1, arg2"
    //  });
    //  </pre>
    //
    //    @param    methodName (object)        If this is a string, name of the property to register
    //                                  If this is an object, assume passing in a set of name/value
    //                                  pairs to register
    //  @param  argumentString (string) named arguments for the property in a comma separated string
    //                                  (not used if methodName is an object)
    // @see group:stringMethods
    //    @visibility external
    //<
    registerStringMethods : function (methodName, argumentString) {

        // If we haven't already done so, override the method argument registry
        // from the super class (otherwise we'll affect other classes with our changes)
        var registry = this._stringMethodRegistry;
        if (!this.isOverridden("_stringMethodRegistry")) {

            //if (registry._entries != null) {
            //    this.logWarn("Methods being registered on: " + this.Class +
            //                 " causing copy of superclass " + this._superClass.Class +
            //                 " registry");
            //}
            var registryClone = {},
                entries = registryClone._entries = (registry._entries ?
                                                    registry._entries.duplicate() : []);
            for (var i = 0; i < entries.length; i++) {
                registryClone[entries[i]] = registry[entries[i]];
            }
            this._stringMethodRegistry = registry = registryClone;
        }

        // If it's an object, rather than a string, assume it's a list of multiple methodName
        // to argument mappings to register at once.
        if (!isc.isA.String(methodName)) {
            var newMethods = methodName;

            // if it's not an object, bail - we don't know how to deal with this
            if (!isc.isAn.Object(newMethods)) {
                this.logWarn("registerStringMethods() called with a bad argument: " +
                             methodName);
                return false;
            }

            for (var methodName in newMethods) {
                registry[methodName] = newMethods[methodName]
                registry._entries.add(methodName);
            }

        } else {
            // in the registry, the distinction between null and undefined is important.
            // If the second parameter is currently undefined, set it to null
            // (this allows the second param. to be optional).
            if (argumentString == null) argumentString = null;

            registry[methodName] = argumentString;
            registry._entries.add(methodName);
        }

        // return true for success
        return true;
    },

    //> @classMethod Class.registerDupProperties() [A]
    // A common requirement in SmartClient development is to the ability have an attribute
    // be set to a "standard" type of object or array for every instance of a class.
    // <P>
    // An example might be a special subclass of TabSet which always shows a particular set
    // of tabs.<br>
    // In this case the most convenient approach would be to simply call
    // <P>
    // <code>setProperties({  tabs: <i>[array of standard tab object]</i> });</code>
    // <P>
    // However the developer does not want each instance he creates to point to <b>the same</b>
    // array of objects - instead each instance should have a separate array containing separate
    // objects with the same set of standard attributes.
    // <P>
    // This method provides an easy way to handle this case. By calling
    // +link{registerDupProperties()} the developer is notifying a class that every time
    // a new instance is generated via a call to +link{Class.create()}, the attribute
    // in question should be cloned onto the generated instance.
    // <P>
    // The <code>AutoChild</code> subsystem also respects registered properties for duplication.
    // When +link{class.addAutoChild()} or +link{class.createAutoChild()} is called, if
    // a property is set in the <code><i>autoChild</i>Defaults</code> block for the auto child,
    // that property will be cloned onto the instance rather than copied over by reference if
    // it's registered as a property for duplication via this method.
    // <P>
    // NOTE: This subsystem will only handle cloning simple javascript objects and arrays.
    // If an attribute name has been registered via this method, calling
    // <code>addProperties()</code> on the class object and passing in a live SmartClient
    // widget is not supported. If you need a standard SmartClient component to show up
    // in a class we recommend you use the +link{group:autoChildUsage,AutoChild subsystem} to
    // define a constructor and defaults for the widget and then set the attribute to
    // <code>"autoChild:<i>&lt;autoChildName&gt;</i>"</code>.
    //
    // @param attributeName (string)
    //    attribute name to register for duplication on instance creation for this class
    // @param [subAttributes] (Array of string)
    //    This parameter allows targetted support for deeper cloning.
    //    The issue is that for some attributes - for example sectionStack.sections, we know
    //    certain properties will also need cloning (sectionStack section.items).
    //    We want to use 'shallowClone()' to duplicate the objects on init rather than clone
    //    as clone is dangerous and can lead to stack overflow errors if the target happens
    //    to point to certain objects.
    //    Therefore allow developers to register properties of an attr value to also be
    //    cloned.
    //    To use this feature a developer would pass in an array of sub-properties
    //    as a second param (EG registerDupProperties("sections", ["items"]);
    // @visibility dupProperties
    //<
    registerDupProperties : function (attributeName, subAttributes) {


        if (this._dupAttrs == null || this._dupAttrs._className != this.getClassName()) {
            if (this._dupAttrs != null) {
                var dupAttrs = this._dupAttrs;
                this._dupAttrs = this._dupAttrs.duplicate();
                if (dupAttrs._subAttrs != null) {
                    this._dupAttrs._subAttrs = isc.shallowClone(dupAttrs._subAttrs);
                }
            } else {
                this._dupAttrs = [];
            }

            this._dupAttrs._className = this.getClassName();
        }
        if (!this._dupAttrs.contains(attributeName)) {
            this._dupAttrs.add(attributeName);
        }

        // support targetted deep-cloning.
        // (See JS Doc for subAttributes param)
        //
        // When given a sub attribute to explicitly dup, store it directly on the
        // registered dupAttrs array in an object of the format:
        // {attributeName:[ Array of sub attributes for cloning ] }
        if (subAttributes != null) {

            //this.logWarn("sub attribute! " + subAttr);

            var dupSubAttrs = this._dupAttrs._subAttrs || {};
            dupSubAttrs[attributeName] = subAttributes;

            this._dupAttrs._subAttrs = dupSubAttrs;
        }

    },

    //> @classMethod Class.isDupProperty()
    // Returns true if the specified attribute was registered as a property for duplication
    // at the instance level via +link{Class.registerDupProperties()}
    // @param attributeName
    // @visibility dupProperties
    //<
    isDupProperty : function (attributeName) {
        return this._dupAttrs != null && this._dupAttrs.contains(attributeName);
    },

    cloneDupPropertyValue : function (attributeName, value) {

        // We want to warn if the property is set to a Canvas instance which we can't readily
        // clone.
        // Explicitly catch arrays and run each entry through this method to also warn in the
        // case where we have an array containing live canvii.


        if (isc.isA.Array(value)) {
            var newArr = [];
            for (var i = 0; i < value.length; i++) {
                newArr[i] = this.cloneDupPropertyValue(attributeName, value[i]);
            }
            return newArr;
        }

        if (isc.Canvas && isc.isA.Canvas(value)) {
            this.logWarn("Default value for property '" + attributeName
                + "' is set to a live Canvas (with ID '"+value.getID()+"') at the Class or AutoChild-defaults level. "
                + "SmartClient cannot clone a live widget, so each instance of this "
                + "class may end up pointing to the same live component. "
                + "To avoid unpredictable behavior and suppress this warning, use the "
                + "AutoChild subsystem to set up re-usable default properties for sub-components.");
            return value;
        }

        var clonedVal = isc.shallowClone(value);

        // Support also cloning certain attribute values - see 'subAttrs' param of
        // registerDupProperties
        var dupArr = this._dupAttrs;
        if (dupArr._subAttrs != null && dupArr._subAttrs[attributeName] != null &&
            clonedVal != null)
        {
            //this.logWarn("iteratin?:" + dupArr._subAttrs[attributeName]);

            for (var i = 0; i < dupArr._subAttrs[attributeName].length; i++) {
                var subAttrName = dupArr._subAttrs[attributeName][i];
                //this.logWarn("Name:" + subAttrName + ", val:" + clonedVal[subAttrName]);
                if (clonedVal[subAttrName] != null) {
                    clonedVal[subAttrName] = isc.shallowClone(clonedVal[subAttrName]);
                }
            }
        }
        return clonedVal;
    },



    //>    @classMethod Class.evaluate()
    // Evaluate a string of script and return the result.
    // <P>
    // This method is a wrapper around the native javascript method <code>eval()</code>. It
    // papers over some native issues to ensure evaluation of script behaves consistently across
    // browsers
    //
    // @param expression (string) the expression to be evaluated
    // @param evalArgs (object) Optional mapping of argument names to values - each key will
    //      be available as a local variable when the script is executed.
    // @return (any) the result of the eval
    // @visibility external
    //<

    evaluate : function (expression, evalArgs, globalScope, hiddenIFrameEval, strictJSON, reviverFunction) {
        //!OBFUSCATEOK


        if (strictJSON) {
            //this.logWarn("is strict");
            return this.parseStrictJSON(expression, reviverFunction);
        }

        // Set a flag so we know an eval is executing

        if (!isc._evalRunning) isc._evalRunning = 0;
        isc._evalRunning ++;
        var returnVal;

        if (hiddenIFrameEval && isc.Browser.isIE && !globalScope && isc.Page.isLoaded()) {

            returnVal = this.evalInIFrame(expression, evalArgs);
        } else {
            //this.logWarn("args and stuff");


            if (evalArgs) {
                with (evalArgs) {
                    if (globalScope) returnVal = window.eval(expression)
                    else returnVal = eval(expression);
                }
            } else {
                if (globalScope) returnVal = window.eval(expression)
                else returnVal = eval(expression);
            }
        }

        // Decrement / clear the evalRunning flag

        if (isc._evalRunning != null) isc._evalRunning --;
        if (isc._evalRunning == 0) delete isc._evalRunning;
        return returnVal;
    },


    parseStrictJSON : function (script, reviverFunction, suppressNativeMethod, allowLoose) {

        var parseFunc;
        if (suppressNativeMethod || allowLoose ||
            window.JSON == null || window.JSON.parse == null)
        {
            parseFunc = this.getJSONParseFunc();
        } else {
            parseFunc = window.JSON.parse;
        }
        return parseFunc(script, reviverFunction, allowLoose);
    },


    // Helper - create a JSON parsing function for browsers that don't natively
    // have support for JSON.parse
    // Note that this has the same restrictions on format as true JSON.parse() - otherwise
    // we'd have browser inconsistency over whether strict JSON response format was
    // required. We also will need to use the "reviver" function if specified to handle
    // custom conversions.
    _cx:/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,


    useHiddenFrameInJSONParseFunction:true,
    getJSONParseFunc : function () {

        if (this._jsonParseFunc) return this._jsonParseFunc;

        this.logInfo("No native JSON.parse() available in this browser." +
            " Creating strict JSON parsing function.", "jsonEval");


        var _this = this,
            cx = this._cx;

        this._walkFunc = function (holder, key, reviver, objRefs, objPath) {

            // The walk method is used to recursively walk the resulting structure so
            // that modifications can be made.

            var k, v, value = holder[key];
            // Don't drill into objects we know aren't simple JSON
            // window
            // isc
            // instance or class objects
            if (value && typeof value === 'object' && value != window &&
                value != window.isc && !isc.isA.Class(value) && !isc.isAn.Instance(value))
            {

                // Infinite loops can of course cause a crash here.
                // We already have logic to avoid this in the JSONEncoder class
                // so let's use the same approach.

                var alreadySeen = false;
                var prevPath = isc.JSONEncoder._serialize_alreadyReferenced(objRefs, value);
                if (prevPath != null && objPath.contains(prevPath)) {
                    var nextChar = objPath.substring(prevPath.length, prevPath.length+1);
                    //this.logWarn("backref: prevPath: " + prevPath + ", current: " + context.objPath +
                    //             ", char after prevPath: " + nextChar);
                    if (nextChar == "." || nextChar == "[" || nextChar == "]") {
                        alreadySeen = true;
                    }
                }
                if (!alreadySeen) {

                    isc.JSONEncoder._serialize_remember(objRefs, value, objPath);

                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {

                            var objPath = isc.JSONEncoder._serialize_addToPath(objPath, k);
                            v = _this._walkFunc(value, k, reviver, objRefs, objPath);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
            }
            return reviver.call(holder, key, value);
        };

        this._jsonParseFunc = function (text, reviver, loose) {
        //!OBFUSCATEOK

            // The parse method takes a text and an optional reviver function, and returns
            // a JavaScript value if the text is a valid JSON text.

            var j;

            // Parsing happens in four stages. In the first stage, we replace certain
            // Unicode characters with escape sequences. JavaScript handles many characters
            // incorrectly, either silently deleting them, or treating them as line endings.

            // Skip this if we're not enforcing script JSON format

            var invalidExpression = false;
            if (loose == null) loose = isc.Class._useLooseJSONParsePatch;
            if (!loose) {
                text = String(text);
                cx.lastIndex = 0;
                if (cx.test(text)) {
                    text = text.replace(cx, function (a) {
                        return '\\u' +
                            ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                    });
                }

                // In the second stage, we run the text against regular expressions that look
                // for non-JSON patterns. We are especially concerned with '()' and 'new'
                // because they can cause invocation, and '=' because it can cause mutation.
                // But just to be safe, we want to reject all unexpected forms.

                // Also skip this for the mode where we're not enforcing script JSON Format

                // We split the second stage into 4 regexp operations in order to work around
                // crippling inefficiencies in IE's and Safari's regexp engines. First we
                // replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
                // replace all simple value tokens with ']' characters. Third, we delete all
                // open brackets that follow a colon or comma or that begin the text. Finally,
                // we look to see that the remaining characters are only whitespace or ']' or
                // ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.
                if (!(/^[\],:{}\s]*$/
                        .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                            .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                            .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) )
                {
                    invalidExpression = true;
                }
            }
            if (invalidExpression) {
                // If the text is not JSON parseable, then a SyntaxError is thrown.
                throw new SyntaxError('JSON.parse error');
            }

            // In the third stage we use the eval function to compile the text into a
            // JavaScript structure. The '{' operator is subject to a syntactic ambiguity
            // in JavaScript: it can begin a block or an object literal. We wrap the text
            // in parens to eliminate the ambiguity.

            // Note - we're evaluating in a hidden frame by default to avoid
            // IE9's memory leaks.
            // This should never lead to the classic "Can't execute code from a freed script"
            // javascript error since strict JSON will never directly create any
            // Date or function objects. (See comments around isc.RPCManager.allowIE9Leak
            // for more on that error).
            //
            // Exceptions
            // - In "loose" mode we may be parsing code which includes method calls etc, so
            //   don't attempt to evaluate in an iframe.
            // - Have a flag to disable trying to eval in an iframe in case we hit any
            //   edge cases that trip the JS error (or other issues such as performance
            //   concerns, etc)
            j = isc.eval('(' + text + ')',
                         !loose && isc.Class.useHiddenFrameInJSONParseFunction);

            // In the optional fourth stage, we recursively walk the new structure, passing
            // each name/value pair to a reviver function for possible transformation.
            return typeof reviver === 'function'
                ? _this._walkFunc({'':j}, '', reviver, {obj:[],path:[]}, "")
                : j;
        }

        return this._jsonParseFunc;
    },


    evalFrameResetInterval: 100,
    evalInIFrame : function (expression, evalArgs) {
        if (this.logIsDebugEnabled("iframeEval")) {
            this.logDebug("Using iframe for evaluation:\n" + expression, "iframeEval");
        }

        if (this.evalFrame == null || this._domain != document.domain) {
            this.makeEvalFrame();
        }

        if (this.evalFrame.evalCount > this.evalFrameResetInterval ||
            this.evalFrame.frame == null) {
            this.resetEvalFrame();
        }

        if (this.evalFrame.frame == null) this.logInfo("Temporarily unable to " +
            "evaluate in a HiddenFrame for domain " + document.domain + "; " +
            "falling back to a simpler evaluate that may leak memory");
        return this.evalFrame.frame == null ? this.evaluate(expression, evalArgs) :
                                      this.evalFrame.doEval(expression, evalArgs);
    },

    makeEvalFrame : function () {
        this.evalFrame = isc.HiddenFrame.create(this.evalFrameDefaults);
        // we'll rebuild if document.domain mismatches
        this._domain = document.domain;
        // Draw should be synchronous (not loading any content)
        this.evalFrame.draw();

        if (document.domain == location.hostname && this.evalFrame.getFrameDocument() == null)
        {
            var props = isc.addProperties({ location: isc.Page.getURL("[HELPERS]empty.html")},
                                          this.evalFrameDefaults);
            this.evalFrame = isc.HiddenFrame.create(props);
            this.evalFrame.draw();
        }
    },

    evalFrameDefaults: {
        useHtmlfile: false,
        doEval : function (expression, evalArgs) {
            this.evalCount++;
            return this.getHandle().doEval(expression, evalArgs);
        }
    },

    evalFrameHTML: [
                  "<html><body><script>" +
                  // Apply native object class extensions
                  "var nativeObjTypes = ['Array', 'String', 'Date'];",
                  "for (var i = 0; i < nativeObjTypes.length; i++) {" +
                    "var proto = window[nativeObjTypes[i]].prototype," +
                        "sourceProto = window.parent[nativeObjTypes[i]].prototype;" +
                  // Only attributes we've added are iterable, so just copy them
                  // across.
                    "for (var attr in sourceProto) {" +
                        "proto[attr] = sourceProto[attr];" +
                    "}" +

                  "}" +
                  // Copy ISC across so anything called directly from there is available
                  // here too.
                  "window.isc = window.parent.isc;" +

                  // Eval function to actually evaluate expression.
                  "function doEval(exp, args) {" +
                    "try{" +
                        // Use a try...catch block - if the eval fails, attempt in the main
                        // frame - there may have been an issue with scoping after all.
                        "if (args) {" +
                            "with (args) { " +
                                "return eval(exp);" +
                            "}" +
                        "} else {" +
                            "return eval(exp);" +
                        "}" +
                    "} catch (e) {" +
                        "window.parent.isc.Log.logInfo(" +
                            "'Attempt to evaluate in eval-frame threw error:' + e " +
                            "+ '. Attempting eval in main window.'," +
                            "'iframeEval');" +
                        "if (args) {" +
                            "with (args) { " +
                                "return window.parent.eval(exp);" +
                            "}" +
                        "} else {" +
                            "return window.parent.eval(exp);" +
                        "}" +
                    "}" +
                  "}" +
                  "</script></body></html>"
    ],

    resetEvalFrame : function () {
        if (this.logIsInfoEnabled("iframeEval")) {
            this.logInfo("Using iframe for evaluation - resetting iframe.", "iframeEval");
        }
        this.evalFrame.evalCount = 0;


        var frame = this.evalFrame.frame = this.evalFrame.getFrameDocument();
        if (frame != null) {
            frame.open();
            var domainString = this.evalFrame._domain ?
                "document.domain = '" + this.evalFrame._domain + "';" : "";
            frame.write(this.evalFrameHTML[0] + domainString + this.evalFrameHTML[1]);
            frame.close();
        } else {
            this.evalFrame._domain = document.domain;
        }
    },

    //>    @classMethod Class.addClassProperties()
    //
    //    Add static (Class-level) properties and methods to this object<br><br>
    //
    //    These properties can then be accessed as MyClass.property, or for functions, called as
    //  MyClass.methodName()
    //
    //    @param    [arguments 0-N] (object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied
    //                                        as class-level properties.
    //  @return                 (object)    the class after properties have been added to it
    //    @visibility external
    //<
    addClassProperties : function () {
        isc.addPropertyList(this, arguments);
        return this;
    },


    //> @classAttr Class.isFrameworkClass (boolean : varies : RWA)
    // Is this a core SmartClient class (part of the SmartClient framework)?
    // This attribute may be used for debugging, and by the AutoTest subsystem to
    // differentiate between SmartClient classes (part of the smartClient framework) and
    // subclasses created by specific applications
    // @setter Class.markAsFrameworkClass()
    // @visibility external
    // @group autoTest
    //<
    // Usually set at init time as part of ClassFactory.defineClass but we need to be able
    // to also set this at runtime for the cases where we replace core smartclient classes -
    // for example IButton

    //>    @classMethod Class.markAsFrameworkClass()
    // Mark this class as a framework class (member of the SmartClient framework).
    // Sets +link{Class.isFrameworkClass}. May be used in debugging and by the
    // AutoTest subsystem
    // @visibility external
    // @group autoTest
    //<
    markAsFrameworkClass : function () {
        this.isFrameworkClass = true;
        this._instancePrototype.isFrameworkClass = true;
        this._scClass = this.Class;
        this._instancePrototype._scClass = this.Class;
    },

    //>    @classMethod Class.addProperties()
    //
    //    Add default properties and methods to all instances of this class.<br><br>
    //
    //    These properties can then be accessed as <code>myInstance.property</code>,
    //  and methods can be called via <code>myInstance.methodName()</code>
    //
    //    @param    [arguments 0-N] (object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied
    //                                        as instance-level property defaults.
    //  @return                 (object)    the class after properties have been added to it
    //    @visibility external
    //<
    _deferredDefaults : {},
    addProperties : function () {

        if (this._isInterface) {
            this.logWarn("Use addInterfaceProperties() to add methods to interface " + this);
        }
        isc.addPropertyList(this._instancePrototype, arguments);
        return this;
    },

    //>    @classMethod Class.addPropertyList()
    //
    //    Add default properties to all instances of this class
    //
    //    @param    list (object[])        array of objects with properties to add
    //  @return      (object)       the class after properties have been added to it
    //
    //    @visibility external
    //<
    addPropertyList : function (list) {
        isc.addPropertyList(this._instancePrototype, list);
        return this;
    },

    //> @classMethod Class.changeDefaults() (A)
    //
    // Changes a set of defaults defined as a JavaScript Object.  For these kind of properties,
    // simply calling +link{Class.addProperties()} would replace the original Object
    // with yours, wiping out settings required for the basic functionality of the component.
    // This method instead applies your overrides over the existing properties, without
    // destroying non-overridden properties.
    // <p>
    // For example let's say you have a component that's defined as follows
    // <pre>
    // isc.defineClass("MyComponent");
    // isc.MyComponent.addProperties({
    //     simpleProperty: "some value",
    //     propertyBlock : {
    //       foo: "bar",
    //       zoo: "moo"
    //     }
    // }
    // </pre>
    // If you wanted to override simpleProperty, you can just call +link{Class.addProperties()}
    // like this:
    // <pre>
    // isc.MyComponent.addProperties({
    //     simpleProperty: "my override"
    // });
    // </pre>
    // If you want to override the value of <code>propertyBlock.moo</code> above,
    // but you don't want to clobber the value of <code>propertyBlock.zoo</code>.  If you use
    // the above pattern like so:
    // <pre>
    // isc.MyComponent.addProperties({
    //     propertyBlock: {
    //         foo: "new value",
    //         zoo: "moo"
    //     }
    // });
    // </pre>
    // You need to re-specify the value of <code>propertyBlock.zoo</code> which you didn't want
    // to override.  Failing to re-specify it would destroy the value.
    // <p>
    // Instead of re-specifying the value, you can use this method to modify the value of
    // <code>foo</code> - like this:
    // <pre>
    // isc.MyComponent.changeDefaults("propertyBlock", {
    //     foo: "new value"
    // });
    // </pre>
    // <p>
    // See also the +link{AutoChild} system for information about standard sets of defaults
    // that are available for customization.
    //
    // @param defaultsName (String) name of the property to change
    // @param newDefaults (Object) overrides for defaults
    //
    // @visibility external
    //<
    changeDefaults : function (defaultsName, newDefaults) {
        // get existing defaults
        var defaults = this._getDefaults(defaultsName),
            mustAssign = false;

        // if we have a superclass with the same defaults, copy them so the superclass is not
        // affected
        var mySuper = this.getSuperClass();
        if (mySuper) {
            var superDefaults = mySuper._getDefaults(defaultsName);
            if (superDefaults != null && superDefaults == defaults) {
                //this.logWarn("copying defaults for property: " + defaultsName +
                //             " on class: " + this);
                defaults = isc.addProperties({}, defaults);
                mustAssign = true;
            }
        }

        // if defaults don't exist, create an empty object for them
        if (defaults == null) {
            defaults = newDefaults || {};
            mustAssign = true;
        } else {
            // otherwise add the specified defaults to the existing defaults
            isc.addProperties(defaults, newDefaults);
        }

        // if we created a new defaults object (because there were no existing defaults, or we
        // had to duplicate a superclass' defaults) override the slot on this class
        if (mustAssign) {
            //this.logWarn("had to assign when overriding property: " + defaultsName +
            //             " on class: " + this);
            var props = {};
            props[defaultsName] = defaults;
            this.addProperties(props);
        }
    },

    _getDefaults : function (defaultsName) {
        var deferredDefaults = this._deferredDefaults[this.Class],
            defaults = this.getInstanceProperty(defaultsName) ||
                        (deferredDefaults ? deferredDefaults[defaultsName] : null);
        return defaults;
    },

    // backcompat: briefly exposed as visibility external in 5.5 beta builds
    replaceDefaults : function (defaultsName, newDefaults) {
        this.changeDefaults(defaultsName, newDefaults);
    },

    //>    @classMethod Class.setProperties()
    //    Apply a set of properties to a class object, calling the appropriate setter class methods if
    //    any are found.
    //
    //    @param    [arguments 0-N] (object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied one after another
    //                                        so later properties will override
    //    @visibility external
    //<
    setProperties : function () {

        var propertyBlock;

        // If passed multiple arguments, combine them down to a single object.
        // (Step required as setProperties() on this instance prototype doesn't take an array,
        // and we don't know how many arguments we have).
        if (arguments.length == 1) {
            propertyBlock = arguments[0];
        } else {
            propertyBlock = {};

            for (var i = 0; i < arguments.length; i++) {
                isc.addProperties(propertyBlock, arguments[i]);
            }
        }

        // set properties on the instance prototype
        this._instancePrototype.setProperties(propertyBlock);
    },

    //>    @classMethod Class.isOverridden()
    //    Determine whether we've overridden a specified class property or method from our superClass
    //
    //    @param    property    (string)    property to check
    //
    //  @return             (boolean)   true if the property has been overridden
    //<
    isOverridden : function (property) {
        // XXX Note - need another function to check for a class overriding the properties of the
        // instance prototype
        return (!(this[property] === this._superClass[property]));
    },

    //> @classMethod Class.isA()
    //
    // Returns whether this class object is the provided class or is a subclass of the provided
    // class, or implements the provided interface.
    //
    // @param  className (string)        Class name to test against
    //
    // @return           (boolean)       true == this Class is a subclass of the provided classname
    // @visibility external
    //<
    isA : function (className) {
        if (className == null) return false;

        // handle being passed Class Objects and instances of classes
        if (!isc.isA.String(className)) {
            className = className.Class;
            if (!isc.isA.String(className)) return false;
        }

        if (isc.startsWith(className, isc.ClassFactory._$iscPrefix)) {
            className = className.substring(4);
        }
        // walk the class object inheritance chain
        var superClass = this;
        while (superClass) {
            if (superClass.Class == className) return true;
            superClass = superClass._superClass;
        }

        // walk the interface inheritance chain
        if (this._implements) {
            for (var i = 0; i < this._implements.length; i++) {
                var superInterface = isc.ClassFactory.getClass(this._implements[i]);
                while (superInterface) {
                    if (superInterface.Class == className) return true;
                    superInterface = superInterface._superClass;
                }
            }
        }

        return false;
    },

    _getNextImplementingSuper : function (methodCallingSuper, superClassProto, methodName,
                                          staticSuper)
    {
        var superClassImpl;
        for (;;) {
            if (superClassProto == null) {
                // no superclass provides a differing implementation - error
                superClassImpl = null;
                break;
            }


            var superClassImpl = isc.Class._getOriginalMethod(methodName, superClassProto);

            // function is not defined in any superclass further up the chain - error
            if (superClassImpl == null) break;

            // found a superclass implementation that differs - success!
            if (methodCallingSuper != superClassImpl) {
                //this.logWarn("found differing superClass implementation: " +
                //             this.echoLeaf(superClassImpl) +
                //             " on prototype: " + superClassProto);
                break;
            }

            // go up the chain to the prototype of the superClass
            if (staticSuper) {
                superClassProto = superClassProto._superClass;
            } else {
                superClassProto = superClassProto._classObject._superClass._instancePrototype;
            }
        }
        if (superClassImpl != null) return superClassProto;
        return null;
    },

    //>    @classMethod Class.Super()
    //
    //    Call the SuperClass implementation of a class method.
    //
    //    @param methodName   (string)    name of the superclass method to call
    //    @param args         (arguments or Array) native "arguments" object, or array of
    //                                           arguments to pass to the Super call
    //    @param [nativeArgs] (arguments) native "arguments" object, required if an Array is
    //                                  passed for the "args" parameter in lieu of the native
    //                                  arguments object
    //
    //    @return                    (any)        return value of the superclass call
    //
    // @visibility external
    //<
    //    @param     [nativeArguments] (Arguments) native "arguments" object.  Required only if
    //                                        calling Super() with a substitute set of
    //                                        arguments

    Super : function (methodName, args, nativeArguments) {
        if (isc._traceMarkers) arguments.__this = this;

        // see Class.duplicateMethods() - Super is dup'd once at init, then dup'd on the fly
        // each time it's called so that recursive super calls on the same instance can be
        // traced through
        if (this.autoDupMethods && isc.isAn.Instance(this)) {
            this.duplicateMethod("Super");
        }

        // if args is clearly not an Array or Arguments object, make it an Array.  NOTE: you
        // can still fool us by passing an object with a .length property which is neither an
        // Array or Arguments object - to avoid this we'd have to be able to reliably
        // cross-platform tell the difference between an Arguments object and a normal Object.
        // The simplest way to do this would probably be to check the callee property, which is
        // very unlikely to be set to a function on some random object being passed as params.
        if (args != null && (args.length == null || isc.isA.String(args))) args = [args];

        if (args == null) args = isc._emptyArray;


        this._nativeArguments = nativeArguments || args;
        this._argsToSuper = args;
        //if (nativeArguments == null && nativeArguments != false && args && args.constructor &&
        //    args.constructor.nativeType == 2)
        //{
        //    this.logWarn("substitute arguments passed, but native arguments object " +
        //                 "not passed as third parameter");
        //}

        // overall plan: look through the inheritance chain for a method that differs from the
        // implementation in this instance, and call that

        // get the prototype for the last method of this name that called Super().  Null for
        // the first call to Super
        this._lastProto = isc.Class._getLastProto(methodName, this);
        // set flag to tell invokeSuper it's being called by external Super and needs to pick
        // up extra arguments from instance flags
        this._externalSuper = true;

        return this.invokeSuper(null, methodName);
    },


    _delayedSuper : function (methodName, args, nativeArguments, delay, delayUnits) {
        if (args != null && (args.length == null || isc.isA.String(args))) args = [args];

        if (args == null) args = isc._emptyArray;

        nativeArguments = nativeArguments || args;
        var argsToSuper = args;
        var lastProto = isc.Class._getLastProto(methodName, this);

        var self = this;
        return isc.Timer.setTimeout(function () {
            if (isc._traceMarkers) arguments.__this = self;

            if (self.autoDupMethods && isc.isAn.Instance(self)) {
                self.duplicateMethod("Super");
            }

            self._nativeArguments = nativeArguments;
            self._argsToSuper = argsToSuper;
            self._lastProto = lastProto;
            self._externalSuper = true;

            self.invokeSuper(null, methodName);
        }, delay, delayUnits);
    },

    // observation and timers may replace a function with a generated function, storing the
    // original function in another slot.  We need to find the original function because
    // otherwise, when we look up the superclass chain to find a differing implementation, we'd
    // be using the auto-generated function, and so think all superclasses had differing
    // implementations.
    // Note that both observation and timing indirects can be installed on classes as well as
    // instances.
    _getOriginalMethod : function (methodName, theProto) {
        var method = theProto[methodName];

        while (method != null && method._origMethodSlot) {
            //this.logWarn("indirect installed on: " + theProto + ": " + this.echoLeaf(method));
            method = theProto[method._origMethodSlot];
        }


        if (method != null && method._originalMethod != null) method = method._originalMethod;

        return method;
    },

    // high speed implementation of Super used by internal callers, where the class and method
    // of the calling function are directly passed in.  Calls to external Super can be freely
    // mixed with calls to invokeSuper because they store the same state.
    //
    // Extremely critical path code sometimes calls Super like so:
    //    isc.StatefulCanvas._instancePrototype.initWidget.call(this);
    // This is safe only if there are no calls to external Super() in any superclass
    // implementations.  If there are, with the lack of any stored lastProto, inter-recursion
    // will be falsely detected and the leaf implementation will be called.
    invokeSuper : function (clazz, methodName, a,b,c,d,e,f,g,h) {

        if (this.autoDupMethods && isc.isAn.Instance(this)) {
            this.duplicateMethod("invokeSuper");
        }

        // static mode (class methods calling Super)
        var staticSuper = this._isClassObject;


        var externalSuper = this._externalSuper;
        this._externalSuper = null;
        var nativeArguments = this._nativeArguments;
        this._nativeArguments = null;
        var argsToSuper = this._argsToSuper;
        this._argsToSuper = null;


        var lastProto;
        if (externalSuper) {
            lastProto = this._lastProto;
            this._lastProto == null;
        } else {
            // for framework code calling invokeSuper, null indicates instance override
            if (clazz != null) {
                // in static mode, protos are class objects
                lastProto = staticSuper ? clazz : clazz._instancePrototype;
            }
        }

        // figure out the method that is calling Super in order to compare the implementation
        // against superclass implementation to find out when a superclass implementation differs
        var methodCallingSuper, nextProto;
        if (lastProto == null) {

            methodCallingSuper = isc.Class._getOriginalMethod(methodName, this);

            // in static mode, there's no such thing as an instance override
            nextProto = staticSuper ? this : this.getPrototype();
            //if (methodName == "draw") {
            //    this.logWarn("new Super call, method calling super: " +
            //                 this.echoLeaf(methodCallingSuper));
            //}
        } else {

            methodCallingSuper = isc.Class._getOriginalMethod(methodName, lastProto);

            if (staticSuper) {
                // static mode - get superclass classObject
                nextProto = lastProto._superClass;
            } else {
                // instance mode - get superclass instancePrototype
                nextProto = lastProto._classObject._superClass._instancePrototype;
            }


            if (nativeArguments && nativeArguments.callee != null &&
                nativeArguments.callee != methodCallingSuper)
            {
                //this.logWarn("recursion detected: to continue current super chain caller" +
                //             " should be: " + this.echoLeaf(methodCallingSuper) +
                //             " but caller is: " + this.echoLeaf(nativeArguments.callee));
                methodCallingSuper = isc.Class._getOriginalMethod(methodName, this);
                nextProto = staticSuper ? this : this.getPrototype();
            }
        }

        // count all calls to externalSuper
        //if (externalSuper) {
        //    var callCounts = isc._superCallCount = isc._superCallCount || [],
        //        fullName = isc.Func.getName(methodCallingSuper);
        //
        //    var record = callCounts.find("fullName", fullName);
        //    if (record) record.callCount++;
        //    else callCounts.add({fullName:fullName, callCount:1});
        //}

        //this.logWarn("methodCallingSuper: " + this.echoLeaf(methodCallingSuper) +
        //             ", lastProto: " + lastProto +
        //             ", nextProto: " + nextProto);

        // find the next superclass implementation
        nextProto = isc.Class._getNextImplementingSuper(methodCallingSuper, nextProto,
                                                        methodName, staticSuper);

        if (nextProto == null) {
            // failed to find a superclass implementation
            if (isc.Log) isc.Log.logWarn("Call to Super for method: " + methodName +
                                         " failed on: " + this +
                                         ": couldn't find a superclass implementation of : " +
                                         (lastProto ? lastProto.Class : this.Class) +
                                         "." + methodName +
                                         this.getStackTrace());
            return null;
        }

        // we found a superclass implementation
        var superClassImpl = nextProto[methodName];

        //if (methodName == "draw") {
        //    this.logWarn("about to call: " + this.echoLeaf(superClassImpl) +
        //                 ", call chain: " + superCallChains);
        //}


        isc.Class._addProto(methodName, nextProto, this);

        // NOTE: it's normal that we're invoke an indirect (an observation or timer for
        // instance), which will invoke the original method for us - it's just when comparing
        // methods that we have to avoid using the indirects
        //if (superClassImpl._origMethodSlot) {
        //    this.logWarn("invoking indirect: " + this.echoLeaf(superClassImpl) +
        //                 " found on prototype: " + nextProto);
        //}

        // call the superclass implementation on "this"
        var returnVal;
        if (externalSuper) {
            // for external callers, use apply() in order to preserve arguments.length just in
            // case external code contains a function that uses arguments.length and gets
            // called as Super
            if (argsToSuper != null || nativeArguments != null) {
                returnVal = superClassImpl.apply(this, argsToSuper == null ?
                                                       nativeArguments : argsToSuper);
            } else {
                returnVal = superClassImpl.apply(this);
            }
        } else {
            returnVal = superClassImpl.call(this, a,b,c,d,e,f,g,h);
        }

        isc.Class._clearLastProto(methodName, this);

        // and return the value returned from the apply
        return returnVal;
    },

    _getLastProto : function (methodName, obj) {
        var superCalls = obj._superCalls,
            protoList = superCalls == null ? null : superCalls[methodName];

        //this.logWarn("for method: " + methodName + " chain is: " + protoList);

        if (isc.isAn.Array(protoList)) return protoList.last();
        return protoList;
    },

    _clearLastProto : function (methodName, obj) {
        var superCalls = obj._superCalls,
            protoList = superCalls[methodName];
        if (protoList == null) {

            return;
        }
        // clear single item
        if (!protoList.__isArray) {

            superCalls[methodName] = null;
        } else {
            // shorten array, then remove if zero length
            protoList.length = Math.max(0, protoList.length-1);
            if (protoList.length == 0) superCalls[methodName] = null;
        }
    },

    _addProto : function (methodName, newProto, obj) {
        var superCalls = obj._superCalls = obj._superCalls || {},
            protoList = superCalls[methodName];
        if (protoList == null) {
            superCalls[methodName] = newProto;
        } else {
            if (isc.isAn.Array(protoList)) protoList.add(newProto);
            else {
                superCalls[methodName] = [protoList, newProto];

                superCalls[methodName].__isArray = true;
            }
        }
    },

    //>    @classMethod Class.map()
    //
    // Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.
    //
    //    @param    methodName (string)
    //      Name of the method on this instance which should be called on each element of the Array
    //    @param    items      (Array)
    //      Array of items to call the method on
    //
    //    @return            (Array) Array of results, one per element in the passed "items" Array
    // @visibility external
    //<
    map : function (methodName, items, arg1, arg2, arg3, arg4, arg5) {
        if (methodName == null) return items;
        var results = [];
        for (var i = 0; i < items.length; i++) {
            results.add(this[methodName](items[i], arg1, arg2, arg3, arg4, arg5));
        }
        return results;
    },

    //>    @classMethod Class.getInstanceProperty()
    //
    //    Gets a named property from the instance defaults for this object.
    //
    //    @param property    (string)    name of the property to return
    // @visibility external
    //<
    getInstanceProperty : function (property) {
        var value = this._instancePrototype[property];

        return value;
    },

    //>    @classMethod Class.setInstanceProperty()
    //
    //    Sets a named property from the instance defaults for this object.
    //
    //    @param property    (string)    name of the property to return
    //    @param value    (any)        value to set to
    // @visibility external
    //<
    setInstanceProperty : function (property, value) {
        this._instancePrototype[property] = value;
    },

    getArgString : function (methodName) {
        // check for a string method definition
        var argString = this._stringMethodRegistry[methodName];
        var undef;
        if (argString !== undef) return argString || isc.emptyString;

        // get the arguments from the method definition (very very slow!)
        var method = this.getInstanceProperty(methodName);
        //if (method == null || !isc.isA.Function(method)) return "";
        if (method == null) return "";
        return isc.Func.getArgString(method);
    },

    // Callbacks and eval()ing
    // ---------------------------------------------------------------------------------------

    //> @type Callback
    // A <code>Callback</code> is an arbitrary action to be fired - usually passed into a
    // method to be fired asynchronously as a notificaction of some event.<br>
    // The <code>callback</code> can be defined in the following formats:<ul>
    // <li>a function</li>
    // <li>A string containing an expression to evaluate</li>
    // <li>An object with the following properties:<br>
    //     - target: fire in the scope of this target - when the action fires,
    //       the target will be available as <code>this</code>.<br>
    //     - methodName: if specified we'll check for a method on the target object with this
    //       name.<br>
    //  </li></ul>
    // <code>Callbacks</code> are fired via the +link{classMethod:Class.fireCallback()} method, which allows
    // named parameters to be passed into the callback at runtime. If the Callback was specified
    // as a string of script, these parameters are available as local variables at eval time.<br>
    // For specific SmartClient methods that make use of <code>Callback</code> objects, see
    // local documentation for information on parameters and scope.
    // @visibility external
    //<


    //>    @classMethod    Class.fireCallback()
    //
    // Fire some arbitrary action specified as a +link{type:Callback}.
    // Returns the value returned by the action.
    //
    // @param callback (Callback) Action to fire.
    // @param [argNames] (string) Comma separated string of variable names. If the callback
    //                            passed in was a string of script, any arguments passed to the
    //                            callback will be available as local variables with these names.
    // @param [args] (array)    Array of arguments to pass to the method. Note that the number
    //                          of arguments should match the number of argNames.
    // @param [target] (object) If specified the callback will be evaluated in the scope of this
    //                          object - the <code>this</code> keyword will be a pointer to this
    //                          target when the callback is fired.
    // @return (any)   returns the value returned by the callback method passed in.
    // @visibility external
    //<

    fireCallback : function (callback, argNames, args, target, catchErrors) {
        arguments.__this = this;
        if (callback == null) return;


        var undef;
        if (argNames == null) argNames = undef;

        var method = callback;
        if (isc.isA.String(callback)) {
            // callback specified as the name of a method on a known target
            if (target != null && isc.isA.Function(target[callback])) method = target[callback];
            // callback is a String expression
            else method = this._makeCallbackFunction(callback, argNames);

        } else if (isc.isAn.Object(callback) && !isc.isA.Function(callback)) {
            // Object containing (possibly) target, and either methodName or action to fire

            if (callback.caller != null) target = callback.caller;
            else if (callback.target != null) target = callback.target;

            // Pick up arguments from the callback directly, if passed that way.
            if (callback.args) args = callback.args;
            if (callback.argNames) argNames = callback.argNames;

            if (callback.method) method = callback.method;


            else if (callback.methodName && target != null) method = target[callback.methodName];
            else if (callback.action)
                method = this._makeCallbackFunction(callback.action, argNames);
        }

        // At this point the target (if one was passed in) is available under 'target', and
        // we've converted the callback to a function, if possible.
        if (!isc.isA.Function(method)) {
            this.logWarn("fireCallback() unable to convert callback: " + this.echo(callback) +
                         " to a function.  target: " + target + ", argNames: " + argNames +
                         ", args: " + args);
            return;
        }

        // If no target was specified, fire it in the global scope

        if (target == null) target = window;
        // If the target has been destroyed, abort!
        else if (target.destroyed) {
            // NOTE: this isn't a warning scenario: destruction is normal, and callbacks are
            // commonly timers to do visual refreshes which don't matter if a component is
            // destroyed
            if (this.logIsInfoEnabled("callbacks")) {
                this.logInfo("aborting attempt to fire callback on destroyed target:"+ target +
                             ". Callback:"+ isc.Log.echo(callback) +
                              ",\n stack:" + this.getStackTrace());
            }
            return;
        }

        // this causes anonymous callback functions to be labelled "callback" in stack traces.
        // Non-anonymous callbacks still show their usual name
        method._isCallback = true;

        if (args == null) args = [];



        if (isc.enableCrossWindowCallbacks && isc.Browser.isIE) {
            var targetWindow = target.constructor ? target.constructor._window : target;
            if (targetWindow && targetWindow != window && targetWindow.isc) {
                var newArgs = targetWindow.Array.newInstance();
                for (var i = 0; i < args.length; i++) newArgs[i] = args[i];
                args = newArgs;
            }
        }

        var returnVal;

        if (!catchErrors || isc.Log.supportsOnError) {
            returnVal = method.apply(target, args);
        } else {
            try {
                returnVal = method.apply(target, args);
            } catch (e) {
                isc.Log._reportJSError(e);

                throw e;;
            }
        }

        return returnVal;
    },

    //> @classMethod Class.delayCall()
    //  This is a helper to delay a call to a method on some target by a specified
    //  amount of time.  Can be used to delay a call to a static method on this class by
    //  omitting the <code>target</code> parameter.
    // @param methodName (string) name of the method to call
    // @param [arrayArgs] (array) array of arguments to pass to the method in question
    // @param [time] (number) Number of ms to delay the call by - defaults to zero (so just pulls
    //                        execution of the method out of the current execution thread.
    // @param [target] (object) Target to fire the method on - if unspecified assume this is
    //                          a call to a classMethod on this Class.
    // @return (string) Timer ID for the delayed call - can be passed to
    //                      +link{Timer.clear()} to cancel the call before it executes
    // @visibility external
    //<
    delayCall : function (methodName, arrayArgs, time, target) {
        if (target == null) target = this;
        if (time == null) time = 0;

        return isc.Timer.setTimeout({target:target, methodName:methodName, args:arrayArgs}, time);
    },


    _makeCallbackFunction : function (callback, argNames) {


        //return isc.Func.expressionToFunction(argNames, callback);

        if (argNames == null) {
            var undef;
            argNames = undef;
        }
        var func = isc._makeFunction(argNames, callback);
        func._showBodyInTrace = true;
        return func;
    },

    // Fire on Pause
    // ---------------------------------------------------------------------------------------

    //> @classMethod Class.fireOnPause()
    // Given some repeatedly performed event (EG keypress, scroll, etc), set up an action
    // to fire when the events have stopped occurring for some set period.
    // @param id (string) arbitrary identifier for the action
    // @param callback (callback) action to fire on quiescence
    // @param [delay] (number) delay in ms - defaults to 200ms
    // @param [target] (object) if passed, the callback will be fired in this target's scope
    //<
    // additional instanceID parameter passed from instance method to support instance-level IDs
    fireOnPauseDelay:200,
    _$_fireActionsOnPause:"_fireActionsOnPause",
    _actionsOnPause:{},
    _actionOnPauseTimers:{},
    fireOnPause : function (id, callback, delay, target, instanceID) {

        if (!id) return;
        if (!delay) delay = this.fireOnPauseDelay;
        // class _fireOnPause on the Class object

        return isc.Class._fireOnPause(id, callback, delay, target, instanceID);
    },
    _fireOnPause : function (id, callback, delay, target, instanceID) {

        // Note: If we have two separate instances calling the fireOnPause instance method with
        // the same ID, both actions need to fire -- the ID is essentially unique within the
        // instance only.
        // We use the instanceID parameter to create separate callbacks for the same ID used
        // on different instances.
        // If unset, default to this.getClassName() [not legal to have any instance with the
        // same ID as a SmartClient class].
        if (instanceID == null) instanceID = this.getClassName();

        if (!this._actionsOnPause[id]) {
            this._actionsOnPause[id] = {};
        }

        this._actionsOnPause[id][instanceID] =
            {fireTime:delay, callback:callback, target:target};

        var stamp = isc.timeStamp(),
            elapsed = this._lastFireOnPause ? stamp - this._lastFireOnPause : null;
        this._lastFireOnPause = stamp;

        // If we're going to fire queue of actions before the delay passed in, we're done
        // Check for this._fireActionsOnPauseRunning -- if a callback from an existing
        // 'fireOnPause' sets up a new 'fireOnPause' we need to set a timer to execute it
        // as a separate flow.
        if (!this._fireActionsOnPauseRunning &&
            elapsed && this._fireOnPauseDelay != null &&
            delay >= (this._fireOnPauseDelay - elapsed))
        {
            return;
        }
        if (this._fireOnPauseTimer) isc.Timer.clearTimeout(this._fireOnPauseTimer);
        this._fireOnPauseTimer = this.delayCall(this._$_fireActionsOnPause,null, delay);

        this._fireOnPauseDelay = delay;
    },

    _fireActionsOnPause : function () {
        this._fireActionsOnPauseRunning = true;
        var fireAgainTime;
        // In theory this._fireOnPausedDelay ms have elapsed since the call to fireOnPause
        // (or the last call to this method).
        // In practice it's probably more accurate to check the elapsed time by comparing
        // timestamps
        var elapsed = isc.timeStamp() - this._lastFireOnPause,
            fireAgainTime;
        for (var id in this._actionsOnPause) {
            var actions = this._actionsOnPause[id];
            // Get the timer-id's now so if any callback sets up a new fireOnPause
            // and changes the 'actions' object we won't worry about it as part of this flow
            var iids = isc.getKeys(actions);
            for (var i = 0; i < iids.length; i++) {
                var iid = iids[i];
                var action = actions[iid];
                if (action.fireTime <= elapsed) {
                    // Wipe the action off the actions object before firing the callback
                    // in case the callback sets up a new fireOnPause with the same ID.
                    delete this._actionsOnPause[id][iid];
                    this.fireCallback(action.callback, null, null, action.target);
                } else {
                    action.fireTime -= elapsed;
                    if (fireAgainTime == null) fireAgainTime = action.fireTime;
                    else fireAgainTime = Math.min(fireAgainTime, action.fireTime);
                }
            }
            if (isc.isAn.emptyObject(this._actionsOnPause[id])) delete this._actionsOnPause[id];
        }
        if (fireAgainTime != null) {
            this._fireOnPauseDelay = fireAgainTime;
            this._lastFireOnPause = isc.timeStamp();
            this.delayCall(this._$_fireActionsOnPause, null, fireAgainTime);
        } else {
            this._fireOnPauseDelay = null;
            this._lastFireOnPause = null;
        }
        this._fireActionsOnPauseRunning = null;

    },

    // Eval() wrappers including globals capture
    // ---------------------------------------------------------------------------------------

    //>    @classMethod    Class.evalWithVars()
    //
    // Evaluates the given string with an arbitrary number of arguments on the specified target.
    // evalVars and target are optional.
    //
    // @param   evalString  the string to evaluate
    // @param   evalVars    Map of key-value pairs.  The keys are treated as argument names that are
    //                      then made available inside the eval body as variables.  The values of
    //                      these variables are the values assigned to the keys in evalVars.
    // @param   target      the target on which to apply the eval - it will be available as the
    //                      'this' variable inside the eval block.  If not specified, the evalString
    //                      is evaluated in global context.
    // @return  (any)       returns the result of eval(evalString)
    //<
    useFastEvalWithVars : isc.Browser.isMoz && isc.Browser.geckoVersion >= 20061010,
    evalWithVars : function (evalString, evalVars, target) {
        //!OBFUSCATEOK
        // if no target specified, eval in global scope
        if (!target) target = window;


        if (this.useFastEvalWithVars) {
            return this.evaluate.call(target, evalString, evalVars);
        }

        // create two arrays of the keys and values of the evalVars map
        var evalStringVarName = "_1";
        // Ensure that we don't step on any of the vars passed in in the evalVars object
        while (evalVars && isc.propertyDefined(evalVars, evalStringVarName)) {
            evalStringVarName += "1"
        }
        var argNames = [evalStringVarName];
        var argValues = [evalString];
        if (evalVars) {
            for (var argName in evalVars) {
                argNames.push(argName);
                argValues.push(evalVars[argName]);
            }
        }

        // make a function with argNames as arguments that evals evalString

        var theFunc = isc._makeFunction(argNames.join(","),
                                        "return eval(" + evalStringVarName + ")");

        // call the function on the target
        return theFunc.apply(target, argValues);
    },

    // calls evalWithVars(jsSrc, evalVars, target), and returns all globals created via
    // addGlobalID().  All other non-explicit globals are captured by the function body that's
    // created around the jsSrc.
    evalWithCapture : function (jsSrc, evalVars, target) {
        var globals = isc.globalsSnapshot = [];
        //
        // we need to create a function with the jsSrc as the body to avoid creating extraneous
        // globals - conveniently evalWithVars already does this for us.
        this.evalWithVars(jsSrc, evalVars, target);
        isc.globalsSnapshot = null;
        return globals;
    },

    // takes a list of global IDs and destroys them
    destroyGlobals : function (globals) {
        // avoid setting `undefined' to `null' in IE6, 7, and 8
        if (globals == null) return;

        if (!isc.isAn.Array(globals)) globals = [globals];

        for (var i = 0; i < globals.length; i++) {
            var global = globals[i];

            var val = window[global];
            // if the value is not already null (or a logical false value such as undefined)
            if (val) {
                // call destroy() on the global if it's defined
                if (isc.isA.Function(val.destroy)) val.destroy();
                else window[global] = null; // otherwise just null out the global ref
            }
        }
    },

    // Provides 'true' global eval - i.e. global vars actually stick to the window object when
    // eval'd in this manner vs a plain eval() which does not do that.
    //
    // Note: the eval logic here (separate approaches to actually perform the eval per browser)
    // duplicates FileLoader.delayedEval() - if you change this code, be sure to update that
    // method.
    // reportErrors optional param defaults to true
    globalEvalWithCapture : function (evalString, callback, evalVars, reportErrors) {
        if (reportErrors == null) reportErrors = true;
        //!OBFUSCATEOK

        // store these on these object - really for Safari's benefit, since it's the only one
        // requiring async execution.  This makes the Safari case below easier.
        this._globalEvalVars = evalVars;
        this._globalEvalCallback = callback;


        /*if ((isc.Browser.isSafari && isc.Browser.safariVersion<533.16) || (isc.Browser.isChrome && isc.Browser.safariVersion<537.4)) {

            evalString = "isc.Class._globalEvalWithCaptureStart();try {\n"
                         + "eval(" + evalString.asSource() +
                            ");\n} catch (e) { window._evalError = e; }\n"
                         +"isc.Class._globalEvalWithCaptureEnd("
                         +"window._evalError," + !!reportErrors + ");";
            window.setTimeout(evalString,0);
            return;
        }*/

        this._globalEvalWithCaptureStart();

        // If an error occurs during eval, capture it and pass it to the completion block to be
        // provided to the user callback.
        var error;
        try {
            if (isc.Browser.isIE) {
                // execScript() - Special IE only function that exports to global scope -
                // can also be used to execute VBScript code. Before IE 9 no other mechanism
                // is known to work to evaluate code in the global scope. Starting
                // with IE 9, an indirect eval executes properly in the global
                // scope: http://msdn.microsoft.com/en-us/library/ie/gg622934.aspx
                // Also, execScript() is unavailable in IE11+:
                // http://msdn.microsoft.com/en-us/library/ie/ms536420.aspx
                if (window.execScript != null) {
                    window.execScript(evalString, "javascript");

                // Indirect eval
                // http://perfectionkills.com/global-eval-what-are-the-options/#windoweval
                } else {
                    window.eval(evalString);
                }
            } else {
                // pass in the 'globalScope' parameter so any defined vars get retained in global
                // scope after the eval
                isc.Class.evaluate(evalString, null, true);
            }
        } catch (e) {
            // If we have been asked to report errors, do so - also hang onto the error so
            // the callback can make use of it if necessary
            if (reportErrors) isc.Log._reportJSError(e, null, null, null,
                                                     "Problem during global eval()");
            error = e;
        }

        return this._globalEvalWithCaptureEnd(error);
    },

    _globalEvalWithCaptureStart : function (evalVars, keepGlobals) {
        // evalVars must go onto the window object - make sure we don't overwrite existing
        // values by holding on to any conflicting refs so we can restore later
        var undef, evalVars = this._globalEvalVars;
        this._restoreGlobals = {};
        if (evalVars) {
            for (var evalVar in evalVars) {
                var globalValue = window[evalVar];
                // need to be careful to preserve nulls, zeroes - so check that the value is
                // actually undefined.
                if (globalValue !== undef) this._restoreGlobals[evalVar] = globalValue;
                window[evalVar] = evalVars[evalVar];
            }
        }

        // start globals capture.  See globalEvalAndRestore for 'keepGlobals' purpose
        isc.globalsSnapshot = isc.keepGlobals ? {} : [];
    },

    _globalEvalWithCaptureEnd : function (error, reportErrors) {
        //!OBFUSCATEOK
        if (error != null && reportErrors) isc.Log._reportJSError(error, null, null, null,
                                                 "Problem during global eval()");
        // restore any conflicting globals and undefine any evalVars we set on the window object
        var undef, evalVars = this._globalEvalVars;
        if (evalVars) {
            for (var evalVar in evalVars) {
                var globalValue = this._restoreGlobals[evalVar];
                if (globalValue !== undef) window[evalVar] = this._restoreGlobals[evalVar];
                else window[evalVar] = undef; // can't delete window[evalVar] in IE!
            }
        }
        var callback = this._globalEvalCallback;
        var globals = isc.globalsSnapshot;

        isc.globalsSnapshot = this._globalEvalCallback = this._globalEvalVars =
            this._restoreGlobals = window._evalError = null;
        this.fireCallback(callback, "globals,error", [globals, error]);

        return {globals: globals, error: error}
    },

    // eval code in the global scope, where only the listed IDs are allowed to become global.
    // Other widgets obtain a global ID only for the duration of the eval(), then become no
    // longer global.
    //
    // This allows widgets that interlink by global ID (eg layout.members) to find each other,
    // specifically, any inter-reference that is resolved either directly when the code eval()s
    // or by the time init()/initWidget() completes will work.
    //
    // Any code that tries to resolve an ID reference sometime after init, or stores the global
    // ID of a component during init (rather than a live reference) won't work with
    // globalEvalAndRestore().
    //
    // globalEvalAndRestore() does not prevent DataSources from registering such that they are
    // available from DataSource.get(), so in effect, all DataSources behave as if
    // dataSource.addGlobalId were false.
    //
    // Likewise globalEvalAndRestore() does not prevent other global registrations not related
    // to global IDs, such as SimpleType registration or WSDL / XML schema registrations by
    // namespace.

    globalEvalAndRestore : function (evalString, keepGlobals, callback, evalVars, reportErrors, updateLocalIds)
    {
        if (keepGlobals == null) keepGlobals = [];
        isc.keepGlobals = keepGlobals;

        return this.globalEvalWithCapture(evalString, function (globals, error) {

            isc.keepGlobals = null;


            var suppressedGlobals = {},
                topLevel = isc.Canvas._getTopLevelWidget(globals);

            // restore all captured globals to their original values, except the keepGlobals
            for (var globalId in globals) {
                if (keepGlobals.contains(globalId)) continue;

                // save the object temporarily ocuppied this global id, so we can pass it later
                // to the callback
                suppressedGlobals[globalId] = window[globalId];

                if (updateLocalIds) {
                    var obj = window[globalId];

                    if (obj && isc.isA.Canvas(obj)) {

                        if (topLevel) {
                            if (!topLevel._localIds) {
                                topLevel._localIds = {};
                            }
                            topLevel._localIds[globalId] = obj;
                            obj.setProperty("_screen", topLevel);
                        } else {
                            // Could happen in case of potential error in evaluated code. For
                            // example if topElement or masterElement was explicitely defined
                            // for object that otherwise should be topLevel object or overridden
                            // Canvas class were used which sets topElement or masterElement
                            // property during init method.
                            if (obj.topElement || obj.masterElement) {
                                isc.logWarn("Cannot find top level of " + obj);
                            }
                        }
                    }
                }

                window[globalId] = globals[globalId];
            }

            isc.Class.fireCallback(callback, "globals,error,suppressedGlobals",
                                   [globals, error, suppressedGlobals]);

        }, evalVars, reportErrors);
    },

    // ---------------------------------------------------------------------------------------

    // _notifyFunctionComplete
    // Static method called when the notification function for some observed method completes.
    _notifyFunctionComplete : function (object, methodName, queue) {
        // Decrement the 'notifyStack' flag.
        // This flag tracks whether the observed function is currently being run.  We implement
        // this as a number indicating the depth of stacked calls to this method.

        queue._notifyStack -= 1;
        // if the notifyStack is greater than zero the top level notificationFunction hasn't
        // yet exited, so don't proceed to modify observers.
        if (queue._notifyStack) return;

        for (var i = 0; i < queue.length; i++) {
            var q = queue[i];
            // Clear any items that were 'ignored' while the notification function was running
            if (q._removedWhileNotificationRunning) {
                queue.removeItem(i);
                i--;
                continue;
            }

            // Clear any temp flags denoting observations set up while the notification function
            // was firing.
            if (q._addedWhileNotificationRunning) {
                delete q._addedWhileNotificationRunning;
            }
        }

        if (queue.length == 0) {
            var saveMethodName = isc._obsPrefix + methodName;
            // restore the original function to its original name
            object[methodName] = object[saveMethodName];
            // clear the new method slot
            delete object[saveMethodName];
            // remove the observer queue
            delete object._observers[methodName];
        }
    },

    // Arrays of definitions (TabBar tabs, Layout members, SectionStack sections, Wizard pages..)
    // ---------------------------------------------------------------------------------------
    _$ID : "ID",
    getArrayItem : function (id, array, idProperty) {
        if (array == null) return null;



        // Number: assume index.
        if (isc.isA.Number(id)) return array[id];

        // Object: return unchanged
        if (isc.isAn.Object(id)) return id;

        // String: assume id property of section descriptor object
        if (isc.isA.String(id)) return array.find(idProperty || this._$ID, id);


        // otherwise invalid
        return null;
    },

    getArrayItemIndex : function (id, array, idProperty) {
        if (isc.isA.Number(id)) return id;

        var item = isc.Class.getArrayItem(id, array, idProperty);

        return array.indexOf(item);
    },

    // Getting DOM objects (going through these APIs makes cross-frame installation possible)
    // ---------------------------------------------------------------------------------------

    getWindow : (
        isc.Browser.isSafari ? function () {
            return window;
        } : function () {
            return this.ns._window;
        }
    ),
    getDocument : (
        isc.Browser.isSafari ? function () {
            return window.document;
        } : function () {
            return this.ns._document;
        }
    ),


    getDocumentBody : function (suppressDocElement) {
        var getDocElement = (!suppressDocElement && isc.Browser.isIE && isc.Browser.isStrict);
        var body = (getDocElement ? this.ns._documentElement : this.ns._documentBody);
        if (body != null) return body;

        var doc = this.getDocument();
        if (getDocElement) {
            this.ns._documentElement = doc.documentElement;
            return this.ns._documentElement;
        }

        if (isc.Browser.isIE) {
            body = doc.body;
        } else {
            if (doc.body != null) body = doc.body;
            else {
                // XHTML: body not available via document.body (at least in FF 1.5)
                // Using the documentElement namespace future proofs us against future XHTML
                // versions
                var documentNS = doc.documentElement.namespaceURI;
                body = doc.getElementsByTagNameNS(documentNS, "body")[0];
                if (body == null) {
                    // XHTML: body not available via getElementsByTagNameNS() before page load
                    // in FF 1.5 (possibly others), but is available via DOM navigation
                    body = doc.documentElement.childNodes[1];
                    if (body != null && body.tagName != "body") body = null;
                }
                //this.logWarn("fetching body element: " + body);
                // don't cache failure to retrieve body, it should be available later until the
                // document is completely hosed
                if (!body) return null;
            }
        }
        this.ns._documentBody = body;
        return body;
    },
    getActiveElement : function () {

        try {
            return this.getDocument().activeElement;
        } catch (e) {
            this.logWarn("error accessing activeElement: " + e.message);
        }
        return null;
    },

    //> @classMethod class._makeNotifyFunction() (A)
    // Make a function to call the original method, then each recipient in turn.
    // @param methodName (string) name of the method to observe
    // @return (function) new function to call when method is fired
    // @group observation
    //<
    _actionRunnerCache: {},
    _makeNotifyFunction : function (methodName) {
        var notifyFunc = function observation() {
            if (isc._traceMarkers) arguments.__this = this;

            var returnVal = this[arguments.callee._origMethodSlot].apply(this, arguments);

            var queue = this._observers[methodName];

            // HACK: avoid crashing if we end up with an observation installed on an object
            // without the corresponding list of observers.  This can happen when we trace a
            // method on an entire class, in which case we install the observation method on
            // the instance prototype, but when the observation fires, it fires with each
            // individual instance's list of observers.
            if (!queue) return returnVal;

            queue._notifyStack = queue._notifyStack ? queue._notifyStack + 1 : 1;

            // call each observer
            var q,
                action;
            for (var i = 0, len = queue.length; i < len; ++i) {
                q = queue[i];

                // skip if the observer was added while this notify function is running.
                if (q._addedWhileNotificationRunning) continue;

                action = q.action;
                action._observer = q.target;
                action._observed = this;
                action._returnVal = returnVal;
                try {
                    action.apply(q.target, arguments);
                } finally {
                    action._observer = null;
                    action._observed = null;
                    action._returnVal = null;
                }

                if (q._ignoreAfterNotify) {
                    // ignore this observer now that call has been made
                    q.target.ignore(this, methodName);
                }
            }

            // Fire the 'complete' function - this will update any changes to observation made while
            // the notification function was running.

            if (isc.Browser.isSafari) {
                arguments.callee._ns.Class._notifyFunctionComplete(this, methodName, queue);
            } else {
                isc.Class._notifyFunctionComplete(this, methodName, queue);
            }

            // return the value returned by the original function
            return returnVal;
        };

        notifyFunc._isObservation = true;
        notifyFunc._fullName = methodName + "Observation";
        notifyFunc._origMethodSlot = isc._obsPrefix + methodName;

        // hang a pointer to the correct isc object onto the function in Safari.
        if (isc.Browser.isSafari) notifyFunc._ns = isc;

        return notifyFunc;
    },

    _makeThunkFunction : function (argString, action) {
        if (argString == null) argString = isc._emptyString;

        var code = "var observer = arguments.callee.caller._observer, it = observer, observed = this, returnVal = arguments.callee.caller._returnVal;\n";
        code += action;

        var cache = isc.Class._actionRunnerCache[argString];
        if (cache == null) cache = isc.Class._actionRunnerCache[argString] = {};
        var actionRunner = cache[action];
        if (actionRunner == null) {
            actionRunner = cache[action] = isc._makeFunction(argString, code);
            actionRunner._argString = argString;
        }

        return function thunk() {
            actionRunner.apply(arguments.callee._observed, arguments);
        };
    },

    _assert : function (b, message) {
        if (!b) {
            throw (message || "assertion failed");
        }
    }

});    // END addClassMethods(isc.Class)

isc.Class.addClassMethods({
    // synonym for backwards compatibility
    newInstance : isc.Class.create
});

// make the isc namespace available on all Class objects
isc.Class.ns = isc;

// retrofit the ClassFactory
isc.addProperties(isc.ClassFactory, {
    ns : isc,
    getWindow : isc.Class.getWindow,
    getDocument : isc.Class.getDocument
});

//
//    add methods to all instances of any Class or subclass
//
isc.Class.addMethods({
    //>    @method    class.init()    (A)
    //
    // Initialize a new instance of this Class.  This method is called automatically by
    // +link{Class.create()}.
    // <p>
    // Override this method to provide initialization logic for your class.  If your class is
    // a subclass of a UI component (i.e. descendant of +link{Canvas}), override
    // +link{canvas.initWidget()} instead.
    //
    // @param    [arguments 0-N] (any)    All arguments initially passed to +link{Class.create()}
    //
    // @visibility external
    //<
    init : function () {},

    // class-level destructor - call via Super() from any subclass
    destroy : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var classObj = this.getClass();

        this._clearObservationsForDestroy();

        // call destroyInterface() on any member interfaces that define the method
        if (classObj._destroyInterfaceMethods) {
            for (var i = 0; i < classObj._destroyInterfaceMethods.length; i++) {
                classObj._destroyInterfaceMethods[i].call(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
            }
        }

        // destroy any SGWT object wrapping this JS object

        var sgwtDestroy = this.__sgwtDestroy;
        if (sgwtDestroy) {
            delete this.__sgwtDestroy;
            sgwtDestroy.apply(this);
        }
    },

    //> @attr class.addPropertiesOnCreate (Boolean : undefined : RA)
    // Controls whether arguments passed to +link{classMethod:Class.create()} are assumed to be
    // Objects containing properties that should be added to the newly created instance.  This
    // behavior is how <code>create()</code> works with almost all SmartClient widgets and
    // other components, allowing the convenient shorthand of setting a batch of properties via
    // an +link{type:ObjectLiteral,JavaScript Object Literal} passed to create().
    // <P>
    // The setting defaults to true if unset.  To disable this behavior for a custom class,
    // such that <code>create()</code> works more like typical constructors found in Java and
    // other languages, use:
    // <pre>
    //     isc.[i]ClassName[/i].addProperties({ addPropertiesOnCreate:false })
    // </pre>
    // <P>
    // Note that it is not valid to disable this behavior for any subclass of +link{Canvas}
    // (Canvas relies on this property).
    // <p>
    // Regardless of the setting for <code>addPropertiesOnCreate</code>, all arguments passed to
    // +link{Class.create()} are still passed on to +link{Class.init()}.
    //
    // @visibility external
    //<


    completeCreation : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        //!OBFUSCATEOK
        if (this.addPropertiesOnCreate != false) {
            //>EditMode capture clean initialization data, and don't construct the actual
            // instance.  This is used to load a set of components for editing.  NOTE:
            // currently only applies to classes that addPropertiesOnCreate (which includes
            // all Canvas subclasses)
            if (isc.captureInitData) {
                var component = {
                    className : this.Class,
                    defaults : isc.addProperties({}, A,B,C,D,E,F,G,H,I,J,K,L,M)
                }
                if (!isc.capturedComponents) isc.capturedComponents = [];
                isc.capturedComponents.add(component);
                if (component.defaults.ID) {
                    isc.ClassFactory.addGlobalID(component, component.defaults.ID);
                    //isc.Log.logWarn("adding global component: " + component.defaults.ID);
                }
                return component;
            }
            //<EditMode

            isc.addProperties(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
        }

        var classObj = this.getClass(),
            dupProps = classObj._dupAttrs || [];
        for (var i = 0; i < dupProps.length; i++) {
            var prop = dupProps[i];
            if (this[prop] == classObj._instancePrototype[prop])
            {
                this[prop] = classObj.cloneDupPropertyValue(prop, this[prop]);
            }
        }

        // call initInterface() on any member interfaces that define the method
        if (classObj._initInterfaceMethods) {
            for (var i = 0; i < classObj._initInterfaceMethods.length; i++) {
                classObj._initInterfaceMethods[i].call(this, A,B,C,D,E,F,G,H,I,J,K,L,M);
            }
        }

        // call the init() routine on the new instance
        this.init(A,B,C,D,E,F,G,H,I,J,K,L,M);

        if (this.autoDupMethods) {
            isc.Class.duplicateMethods(this, this.autoDupMethods);
        }
        return this;
    },

    // instance-level auto-dups
    //autoDupMethods: [ "fireCallback", "Super", "invokeSuper", "getInnerHTML" ],
    duplicateMethod : function (methodName) {
        isc.Class.duplicateMethod(methodName, this);
    },

    //>    @method    class.getUniqueProperties
    //
    //    Gets all non-internal properties that are the different between this object and its
    //  prototype and returns a new object with those properties.
    //
    //    NOTE: this will also skip an object ID (object.ID)
    //        if it starts with our auto-generated ID string ("isc_OID_")
    //
    //    NOTE: if your object points to some complex object, the clone will pick that up... :-(
    //
    //    @param    [returnProperties]    (object)    If passed in, properties will be added to this object.
    //                                            If not passed, a new object will be created.
    //    @return (Object)    unique properties for this object
    //<
    // NOTE: not external because lots of random state is picked up, and lots of important
    // state is discarded.
    getUniqueProperties : function (returnProperties) {
        if (returnProperties == null) returnProperties = {};

        var proto = this.getPrototype();

        for (var property in this) {
            // ignore internal properties
            if (property.startsWith("_")) continue;

            // ignore the namespace pointer installed on every instance
            if (property == "ns") continue;

            // ignore ID if it's auto-generated
            if (property == "ID" && this.ID.startsWith("isc_OID_")) continue;

            var value = this[property];

            // don't pick up functions (NOTE: we probably don't want to try to serialize
            // functions in general, or at least, that would be a very advanced and separate
            // serialization system.  Also, note that if we don't ignore functions, we'd pick
            // up observations since observations replace the original function)
            if (isc.isA.Function(value)) continue;

            // if the property still has the default value for the class, ignore it
            if (value != proto[property]) {
                /*
                if (proto[property] != null) {
                    this.logWarn("property: " + property + ": value " +
                                 this.echoLeaf(this[property]) +
                                 " !== proto value " +
                                 this.echoLeaf(proto[property]));
                }
                */
                returnProperties[property] = this[property];
            }
        }
        return returnProperties;
    },

    //>    @method    class.clone
    //
    // Make a clone of this instance.
    // Gets all non-internal properties that are the different between this object and its
    // prototype and creates a new instance with those properties
    //
    //    NOTE: if your object points to some complex object, the clone will pick that up... :-(
    //
    //    @return (Class)    clone of this class
    //<
    // NOTE: not external because this doesn't work for almost all widgets and has many issues
    // before it could be supported (eg what to do with shared data models?)
    clone : function () {
        return this.getClass().create(this.getUniqueProperties());
    },

    // NOTE: not external.  Need to define what this should do, eg, just a dump of state for
    // debugging vs recreate component in current state / transmit between browsers
    serialize : function (indent) {
        return isc.Comm.serialize(this, indent);
    },

    xmlSerialize : function (indent) {
        return isc.Comm.xmlSerialize(this.getClassName(), this, indent);
    },

    // get the fields
    getSerializeableFields : function (removeFields, keepFields) {
        // see if we can obtain a schema for this class.  If a schema is available,
        // we'll use it to filter the set of fields that are serializeable.
        var schema = isc.DS ? isc.DS.getNearestSchema(this) : null;

        var uniqueProperties = this.getUniqueProperties();

        // instead of bailing out limit to simple types only?
        if (schema == null) {
            this.logDebug("No schema available for class" + this.getClassName());
            return uniqueProperties;
        } else {
            this.logDebug("Constraining serializeable fields for class: " + this.getClassName()
                          + " with schema : " + schema.ID);
        }

        // the list of valid fields is the intersection of datasource-declared fields and unique
        // properties.  This ensures that we don't pick up fields that are really internal
        // (e.g. starting with underscore)
        var serializeableFields = isc.applyMask(uniqueProperties, schema.getFields());

        // removeFields and keepFields are Arrays of fieldNames that subclasses can modify
        // before calling Super in order to suppress or keep fields
        removeFields = removeFields || [];
        keepFields = keepFields || [];

        // strip removeFields from the set of serializeable fields.
        removeFields.map(function(arg) { delete serializeableFields[arg]; });

        // ensure that the fields that specifically requested are in
        for (var i = 0; i < keepFields.length; i++) {
            serializeableFields[keepFields[i]] = this[keepFields[i]];
        }

        return serializeableFields;
    },

    //>    @method    class.getID()
    //            Return the global identifier for this object.
    //
    //        @return    (string)    global identifier for this canvas
    // @visibility external
    //<
    getID : function () {
        return this.ID;
    },

    //>    @method    class.getClass()
    //
    //    Gets a pointer to the class object for this instance
    //
    //    @return (Class)        Class object that was used to construct this object
    // @visibility external
    //<
    getClass : function () {
        return this._classObject;
    },


    //>    @method    class.getSuperClass()
    //
    //    Gets a pointer to the class object for this instance's superclass.
    //
    //    @return (Class)        Class object for superclass.
    // @visibility external
    //<
    getSuperClass : function () {
        return this._classObject._superClass;
    },


    //>    @method    class.getClassName()
    //
    //    Gets the name of this class as a string.
    //
    //    @return    (string)    String name of this instance's Class object.
    // @visibility external
    //<
    getClassName : function () {
        return this.getClass().getClassName();
    },

    //> @method Class.getScClassName()
    //
    //  Gets the name of this class as a string, if the class is a SmartClient Framework class.
    //  Otherwise, gets the name of the SmartClient Framework class which this class extends.
    //
    //  @return (string) name of the SmartClient Framework class
    //<
    getScClassName : function () {
        return this.getClass().getScClassName();
    },

    //>    @method    class.getPrototype()    (A)
    //
    //    Gets a pointer to the prototype of this instance.
    //
    //    @return (object)    prototype object for this instance
    //<
    getPrototype : function () {
        return this._scPrototype;
    },


    //>    @method    class.getGlobalReference()    (A)
    //
    //    Evaluate a reference in the global scope.  Within the eval,
    //        "this" will be a pointer to this instance.
    //
    //    @param    reference    (string)    String to get the reference from.  If anything other than
    //                                     a string is passed in, simply returns reference.
    //    @return (reference)        reference to evaluate
    //<
    getGlobalReference : function (reference) {
        //!OBFUSCATEOK
        if (typeof reference == "string") return this.evaluate(reference);
        return reference;
    },

    //>    @method    class.addMethods()
    //
    //    Add methods to this specific instance.  These can either be completely new methods or can
    //    have the same name as existing methods, in which case the new methods will override the
    //    existing methods.
    //
    // @param [arguments 0-N] (object)    Object containing name:method pairs to be added to this object
    // @return                (object)  the object after methods have been added to it
    // @visibility internal
    //<

    addMethods : function () {

        for (var i = 0; i < arguments.length; i++) {
            // call global addMethods()
            return isc.addMethods(this, arguments[i]);
        }
    },

    //>    @method    class.addProperties()
    //
    //     Add properties or methods to this specific instance.
    //    Properties with the same name as existing properties will override.
    //
    //    @param    [arguments 0-N] (object)    Object containing name:value pairs to be added to this object
    //  @return                 (object)    the object after properties have been added to it
    // @visibility external
    //<
    addProperties : function () {
        return isc.addPropertyList(this, arguments);
    },

    //>    @method    class.addPropertyList()
    //
    //    Add properties to this instance.
    //
    //    @param    list (object[])        array of objects with properties to add
    //  @return                 (object)    the object after properties have been added to it
    // @visibility external
    //<
    addPropertyList : function (list) {
        return isc.addPropertyList(this, list);
    },

    // Get / Set with automatic getter/setter
    // ---------------------------------------------------------------------------------------

    //>    @method    class._getSetter()    (A)
    //
    //    Get the setter for a particular property, if one exists
    //
    //    @param    propertyName (string)    name of the property to find the setter for
    //                                    eg: if propertyName == "contents", setter == "setContents"
    //
    //    @return    (string)                name of the setter for the property, or null if none found
    //
    //<
    _getSetter : function (propertyName) {
        var functionName = "set" + propertyName.substring(0,1).toUpperCase() + propertyName.substring(1);
        return (isc.isA.Function(this[functionName]) ? functionName : null);
    },

    //>    @method    class._getGetter()    (A)
    //
    //    Get the getter for a particular property, if one exists
    //
    //    @param    propertyName (string)    name of the property to find the getter for
    //                                    eg: if propertyName == "contents", getter == "getContents"
    //
    //    @return    (string)                name of the getter for the property, or null if none found
    //
    //<
    _getGetter : function (propertyName) {
        var functionName = "get" + propertyName.substring(0,1).toUpperCase() + propertyName.substring(1);
        return (isc.isA.Function(this[functionName]) ? functionName : null);
    },

    //>    @method    class.setProperty()
    // Set a property on this object, calling the setter method if it exists.
    // <p>
    // Whenever you set a property on an ISC component, you should call either the specific setter
    // for that property, or <code>setProperty()/setProperties()</code> if it doesn't have one.
    // This future-proofs your code against the later addition of required setters.
    //
    // @param propertyName (String) name of the property to set
    // @param newValue (any) new value for the property
    // @see method:class.setProperties()
    // @visibility external
    //<
    setProperty : function (propertyName, newValue) {
        // NOTE: this is inefficient but unlikely to be called very often, and doing it this way
        // means subclasses can override just setProperties()
        var props = {};
        props[propertyName] = newValue;
        this.setProperties(props);
    },

    //>    @method    class.setProperties()
    // Set multiple properties on an object, calling the appropriate setter methods if any are
    // found.
    // <p>
    // Whenever you set a property on an ISC component, you should call either the specific setter
    // for that property, or <code>setProperty()/setProperties()</code> if it doesn't have one.
    // This future-proofs your code against the later addition of required setters.
    // <p>
    // With <code>setProperties()</code> in particular, some classes may be able to take shortcuts
    // and be more efficient when 2 or more related properties are set at the same time.
    //
    //    @param    [arguments 0-N] (object)    objects with properties to add (think named parameters).
    //                                        all the properties of each argument will be applied one
    //                                        after another so later properties will override
    // @see method:class.setProperty()
    //  @visibility external
    //<
    setProperties : function () {

        var isA = isc.isA,
            propertyBlock,
            additionalProps = {};

        // if not passed any properties arguments, just bail
        if (arguments.length < 1) return;

        // Iterate through the (possibly just one) properties, combining them into a single
        // object.  We do this to avoid duplicate calls to setters, although another approach
        // would be to keep a mask of the properties we've set, starting from the last argument
        // to the first.
        if (arguments.length == 1) {
            propertyBlock = arguments[0];
            if (propertyBlock == null) return;
        } else {
            propertyBlock = {};

            for (var i = 0; i< arguments.length; i++) {
                isc.addProperties(propertyBlock, arguments[i]);
            }
        }

        for (var propertyName in propertyBlock) {
            var value = propertyBlock[propertyName],
                setter = this._getSetter(propertyName);
            if (isc.isA.StringMethod(value)) value = value.getValue();
            //this.logWarn("setting property: " + propertyName +
            //             " to value: " + this.echoLeaf(value) +
            //             " via setter: " + this.echoLeaf(setter));
            if (setter) {
                this[setter](value);
                if (this.propertyChanged) this.propertyChanged(propertyName, value);
            } else {
                additionalProps[propertyName] = value;
            }
        }
        // add any remaining properties via addProperties (will fall through to addMethods if
        // necessary)
        this.addProperties(additionalProps)

        // Fire the notification function for any properties that didn't have an explicit
        // setter
        if (this.propertyChanged) {
            for (var propertyName in additionalProps) {
                this.propertyChanged(propertyName, additionalProps[propertyName]);
            }
        }

        // Fire any "doneSettingProperties()" - allows the instance to respond to multiple
        // related properties being set without having to respond to each one.
        if (this.doneSettingProperties) this.doneSettingProperties(propertyBlock);
    },

    getProperty : function (propName) {
        var getter = this._getGetter(propName);
        if (getter) return this[getter]();
        return this[propName];
    },

    //> @type Properties
    // When the type for a parameter mentions "properties" as in "ListGrid Properties" or
    // "RPCRequest Properties", it means that the expected value is a JavaScript Object
    // containing any set of properties generally legal when creating an object of that type.
    // <P>
    // For example, the first parameter of +link{RPCManager.sendRequest()} is of type
    // "RPCRequest Properties".  This means it should be called like:
    // <pre>
    //    isc.RPCManager.sendRequest({
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    });</pre>
    // +link{rpcRequest.actionURL,actionURL} and +link{rpcRequest.showPrompt,showPrompt} are
    // properties of +link{RPCRequest}.
    // <P>
    // Note that the notation shown above is an example of a
    // +link{type:ObjectLiteral,JavaScript object literal}.
    //
    // @visibility external
    //<

    //> @type ObjectLiteral
    // An "Object literal" is JavaScript shorthand for defining a JavaScript Object with a set
    // of properties.  For example, code like this:
    // <pre>
    //    var request = {
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    };</pre>
    // .. is equivalent to ..
    // <pre>
    //    var request = new Object();
    //    request.actionURL = "/foo.do";
    //    request.showPrompt = false;</pre>
    // In situations where a set of +link{type:Properties,properties} may be passed to a
    // method, the Object literal notation is much more compact.  For example:
    // <pre>
    //    isc.RPCManager.sendRequest({
    //        actionURL : "/foo.do",
    //        showPrompt:false
    //    });</pre>
    // <b>NOTE:</b> if you have a 'trailing comma' in an object literal, like so:
    // <pre>
    //    var request = {
    //        actionURL : "/foo.do",
    //        showPrompt:false, // TRAILING COMMA
    //    };</pre>
    // This is considered a syntax error by Internet Explorer, but not by Firefox.  This is by
    // far the #1 cause of Internet Explorer-specific errors that do not occur in other
    // browsers.  Pay special attention to this error, and, if you can, install the
    // JSSyntaxScannerFilter into your development environment (as described in the
    // +link{group:iscInstall,deployment instructions}).
    //
    // @visibility external
    //<

    // ---------------------------------------------------------------------------------------

    // useful for cascading defaults where 0 or "" is allowed so the pattern of
    // "value1 || value2 || value3" won't work.

    _firstNonNull : function (a,b,c,d,e,f) {
        return a != null ? a :
                (b != null ? b :
                    (c != null ? c :
                        (d != null ? d :
                            (e != null ? e : f)
                        )
                    )
                );
    },

    //>    @method    class.isA()
    //
    //    Returns whether this object is of a particular class by class name, either as a direct
    //    instance of that class or as subclass of that class, or by implementing an interface
    //  that has been mixed into the class.<br><br>
    //
    //    NOTE: this only applies to ISC's class system, eg:  <code>myInstance.isA("Object")</code> will be
    //    false.
    //
    //    @param    className    (string)    Class name to test against
    //
    //    @return                (boolean)    whether this object is of that Class
    //                                  or a subClass of that Class
    // @visibility external
    //<
    isA : function (className) {
        return this.getClass().isA(className);
    },



    //> @groupDef stringMethods
    //
    // A method flagged as a String Method can be specified as a String containing a valid
    // JavaScript expression.  This expression will automatically be converted to a function with a
    // return value matching the value of the last statement.  Providing a String is not required -
    // you may use a real function instead.
    // <p>
    // For example - suppose you wanted to override the <code>leafClick()</code> method on
    // the TreeGrid.  Normally you would do so as follows:<br>
    //
    // <pre>
    // TreeGrid.create({
    //     ...
    //     leafClick : function(viewer, leaf, recordNum) {
    //         if(leaf.name == 'zoo') {
    //             alert(1);
    //         } else {
    //             alert(2);
    //         }
    //     }
    // });
    // </pre>
    //
    // Since leafClick is a stringMethod, however, you can shorten this to:<br>
    // <pre>
    // TreeGrid.create({
    //     ...
    //     leafClick : "if(leaf.name == 'zoo') { alert(1); } else { alert(2); }";
    // });
    // </pre>
    //
    // @title String Methods Overview
    // @treeLocation Client Reference/System
    //<

    //> @groupDef flags
    //
    // <ul>
    // <li> <b>I</b>: property can be initialized (provided in constructor block)
    // <li> <b>R</b>: property can be read.  If a getter method exists, it must be called.
    // <li> <b>W</b>: property can be written to after initialization.  If a setter method
    // exists, it must be called.  If no setter method exists,
    // +link{Class.setProperty,setProperty()} must be called.
    // </ul>
    //
    // @title Flag Abbreviations
    //<



    // Observation
    // ---------------------------------------------------------------------------------------

    //> @groupDef observation
    // Observation is the ability to take an action whenever a method is called.
    // @title Observation
    //<

    //>    @method        class.observe()
    // Take an arbitrary action whenever a method is called on an instance.<br><br>
    //
    // When you observe some method of another object, eg:<br>
    //            <code>thisObject.observe(thatObject, "someMethod", "observer.foo()")</code><br><br>
    //
    // When <code>thatObject.someMethod()</code> is called,<br>
    //            <code>thisObject.foo()</code> <br>
    // will be called automatically, after the observed method completes.<br><br>
    //
    // Action is typically a string expression.  Available variables:
    // <ul>
    //    <li> observed: target of the observation, that is, object passed to observe()
    //    <li> observer: object that observes, that is, object that observe() was called on
    //    <li> returnVal: return value of observed function
    // </ul>
    //
    // An unlimited number of observers can observe any message, they will all be notified
    // automatically in the order that the observations were set up.<br><br>
    //
    // NOTES:
    // - observation also works on JavaScript Array objects
    // - a method may trigger an observation of itself by another object, either through code
    //   within the method itself or within an observer's action.  In this case the observation
    //   will be set up, but the new observation action will not fire as part of this thread.
    //   When the method is called again in the future the newly added observer will be fired.
    //
    //
    //        @param    object        (object)    object to observe
    //        @param    methodName    (string)    name of the method to observe
    //        @param    [action]    (string)    String for the function to call.
    //                                        In this string,
    //                                            <code>observer</code> is the object that is observing,
    //                                            <code>this</code> is the object that is being observed
    //
    //                                        If <code>action</code> is not specified,
    //                                            <code>observer.methodName()</code> will be called.
    //
    //        @return    (boolean)    true == observation set up, false == observation not set up
    //      @see Class.ignore()
    //        @group    observation
    // @visibility external
    //<



    observe : function (object, methodName, action) {
        // if the object doesn't exist or doesn't implement a method with this name, return false to
        // indicate that the observation isn't going to work
        if (object == null) {
            //>DEBUG
            this.logWarn("Invalid observation: Target is not an object.  target: " + object +
                         ", methodName: " + methodName + ", action: '" + action + "'");
            //<DEBUG
            return false;
        }

        // If this property is not a method, or a methodString, log a warning and return false
        //  Note: we're calling the static isc.Func.convertToMethod(...) as we know this
        //  function exists and will return false if the object's class, and the object have
        //   no methodStringRegistry.
        if (!isc.Func.convertToMethod(object, methodName)) {
            //>DEBUG
            this.logWarn("Invalid observation: property: '" + methodName +
                         "' is not a method on " + object);
            //<DEBUG
            return false;
        }
        //this.logWarn("observing: " + methodName + " on " + object + " with action: " + action);

        // If this function has an obfuscated version, observe that also
        var obName = isc.__remap[methodName];
        if (object[obName]) this.observe(object, obName, action)

        // Now we're definitely working with a method
        var oldMethod = object[methodName], argStr;
        if (isc.isAn.Instance(object) && object.getClass().getInstanceProperty(methodName)) {
            argStr = object.getClass().getArgString(methodName);
        // NOTE: currently, there's no such thing as a classMethod that is a stringMethod
        } else {
            // this code path is needed for two cases:
            // * methods set in autoChildDefaults (caught by getInstanceProperty)
            // * class methods (caught by isAn.Instance())
            argStr = isc.Func.getArgString(oldMethod);
        }
        var args = argStr.split(",");

        // if no action was defined, set it to call the method on the target
        if (action == null || isc.is.emptyString(action)) {
            if (!this[methodName] || !this.convertToMethod(methodName)){
                //>DEBUG
                this.logWarn("Invalid Observation - no action specified, and observer: " + this +
                            " has no method '" + methodName + "', ignoring");
                //<DEBUG
                return false;
            }
            action = "it." + methodName + "(" + argStr + ")";
        }

        if (!isc.isA.Function(action)) {
            action = isc.Class._makeThunkFunction(argStr, action);
        }

        action._argString = argStr;

        //
        // add the observer and action to the object's observers list
        //

        // if there is no observers registry set up, create it.
        // object._observers is { methodName :
        //                           [{target:observingObject, action:codeString}]
        //                      }
        if (!object._observers) object._observers = {};

        // if there is not an observer queue for the method, create it
        if (!object._observers[methodName]) {
            var queue = object._observers[methodName] = [];
            if (args.length > 0) {
                // remember the args to the function for later
                queue.argStr = argStr;
            }
        // otherwise
        } else {
            // get the observer queue: the list of existing observers of this method
            var queue = object._observers[methodName];
            // see if this object is already observing this method
            for (var i = 0, len = queue.length; i < len; i++) {
                var q = queue[i];
                // if this object is found in the queue, return false since we're already observing
                // this method
                if (q.target == this) {
                    if (q._removedWhileNotificationRunning) {
                        // special case: this observation was already ignored, but a re-
                        // observation is being done from inside the notified function.
                        // Disable _removedWhileNotificationRunning and update the
                        // action.
                        q._removedWhileNotificationRunning = false;
                        q._addedWhileNotificationRunning = true;
                        q.action = action;
                        return true;
                    }
                    //>DEBUG
                    this.logWarn("Observer: " + this + " is already observing method '" +
                                 methodName + "' on object '" + object + "', ignoring");
                    //<DEBUG
                    return false;
                }
            }
        }

        // Note whether we're currently running the notification function.

        var notificationRunning = !!queue._notifyStack;

        // add a reference to the observer to the observer queue for the method
        var q = {
            target: this,
            action: action,
            // Track whether this method was added while the notification function was
            // running - this allows us to avoid running this observer action until
            // after the method has completed.
            _addedWhileNotificationRunning: notificationRunning
        };
        queue.add(q);

        // get the name we're going to hide the original method under.  NOTE: important to name
        // this with a leading underscore, so getUniqueProperties ignores it.
        var saveMethodName = isc._obsPrefix + methodName;
        // if the object already has a method by that name, the same method we're trying to
        // observe is being observed by someone else.  We'll both call the original method by
        // the same name.
        if (object[saveMethodName] == null) {
            object[saveMethodName] = oldMethod;

        // If we are already observing the method,
        // if the slot contains a method that isn't a notification method, log a warning and
        // copy the new method into the 'saveMethodName' slot. This will happen if a developer
        // does someObject.methodName = function () {...} rather than using addProperties on
        // a method that is already being observed.
        } else if (!object[methodName]._isObservation) {
            this.logWarn("Observation error: method " + methodName
                + " is being observed on object " + object + " but the function appears to have "
                + "been directly overridden. This may lead to unexpected behavior - to avoid "
                + "seeing this message in the future, ensure the addMethods() or addProperties() "
                + "API is used to modify methods on live SmartClient instances, rather than simply "
                + "reassigning the method name to a new function instance.");
            object[saveMethodName] = object[methodName];
        }

        // replace the observed method with a new function that will call the original method
        // then call all the observers
        if (!notificationRunning && !object[methodName]._isObservation) {
            object[methodName] = isc.Class._makeNotifyFunction(methodName);
        }

        // track our observations so we can clear them on destroy()
        if (!this._observations) this._observations = [];
        this._observations.push({object : object, methodName: methodName, action: action});

        // return true that everything went OK
        return true;
    },

    _clearObservationsForDestroy : function () {
        // Clear this objects' observations - i.e. observations this objects has on other objects
        if (this._observations) {
            // Use a copy of the internal _observations array because ignore() will modify the original.
            var observations = this._observations.duplicate();
            while (observations.length) {
                var observation = observations.pop();
                this.ignore(observation.object, observation.methodName);
            }
        }

        // Clear others' observations of me
        if (this._observers) {
            var methodNames = isc.getKeys(this._observers);
            while (methodNames.length) {
                var methodName = methodNames.pop();
                // Use a copy of array because ignore() will modify the original.
                var observersOfMethod = this._observers[methodName].duplicate();
                while (observersOfMethod.length) {
                    var observer = observersOfMethod.pop();

                    if ("destroy" == methodName) {
                        // defer ignore until notification completes
                        observer._ignoreAfterNotify = true;
                    } else {
                        observer.target.ignore(this, methodName);
                    }
                }
            }
        }
    },

    //>    @method        class.ignore()    (A)
    //        Stop observing a method on some other object.
    //
    //        @param    object        (object)    object to observe
    //        @param    methodName    (string)    name of the method to ignore
    //
    //        @return    (boolean)    true == observation stopped, false == no change made
    //      @see Class.observe()
    //        @group    observation
    // @visibility external
    //<
    ignore : function (object, methodName) {
        var undef;
        // also ignore the obfuscated version if present
        var obName = isc.__remap[methodName];
        if (obName !== undef && object[obName]) this.ignore(object, obName);

        // get the name we would have squirreled the original method under
        var saveMethodName = isc._obsPrefix+methodName;
        // and if we can't find a method with that name, or the object has no observers
        //    return false to indicate that the object isn't currently being observed on this method
        if (!object[saveMethodName] || !object._observers) return false;

        // get a pointer to the message queue for the method
        var queue = object._observers[methodName],

            // Note: if the the observed function is currently being run, we want the observer
            // action to fire as normal in response to this thread, but not for subsequent
            // calls to the observed method.
            // To achieve this, we flag the observer action, then clear it out of the queue
            // when the observed method (actually the notification method) completes.

            notificationRunning = queue._notifyStack;


        // remove the object in the queue that points to this object
        var q;
        for (var i = 0, len = queue.length; i < len; i++) {
            q = queue[i];
            if (q.target == this) {
                if (notificationRunning) {
                    q._removedWhileNotificationRunning = true;
                } else {
                    queue.removeAt(i);
                }

                break;
            }
        }

        // if we've removed everything from the queue
        // restore the original method

        // Note - if the slot contains a non-notification function we're in an invalid state.
        // Basically this implies the developer clobbered the notification function by going
        //  someObject.methodName = function () {...}
        // on a method that was currently being observed.
        // Warn when we see this case, and assume the current function should be preserved if
        // possible.
        if (!object[methodName] || !object[methodName]._isObservation) {
            this.logWarn("Observation error caught in ignore(): Method " + methodName
                + " was being observed on object " + object + " but the function appears to have "
                + "been directly overridden. This may lead to unexpected behavior - to avoid "
                + "seeing this message in the future, ensure the addMethods() or addProperties() "
                + "API is used to modify methods on live SmartClient instances, rather than simply "
                + "reassigning the method name to a new function instance.");
            object[saveMethodName] = object[methodName];
        }

        if (queue.length == 0) {
            // restore the original function to its original name
            object[methodName] = object[saveMethodName];
            // clear the new method slot
            delete object[saveMethodName];
            // remove the observer queue
            delete object._observers[methodName];
        }

        // unregister from this._observations
        this._observations && this._observations.removeWhere({object: object, methodName: methodName});

        // return true that everything went OK
        return true;
    },

    //>    @method        class.getObserversOf()    (A)
    //        @group    observation
    //            Return all targets observing a message of this object
    //
    //        @param    methodName    (string)    name of the method to observed
    //
    //        @return    (object[])    array of observing objects
    //<
    getObserversOf : function (methodName) {
        if (!this._observers || !this._observers[methodName]) return null;
        var queue = this._observers[methodName];
        for (var observers = [], i = 0; i < queue.length; i++) {
            observers[i] = (queue[i] ? queue[i].target : null);
        }
        return observers;
    },

    //>    @method        class.isObserving()    (A)
    //        @group    observation
    //        Return true if this object is already observing a method of another object
    //
    //        @param    object        (object)    object we may be observing
    //        @param    methodName    (string)    name of the method to observed
    //
    //        @return    (boolean)    true == already observing that method
    // @visibility external
    //<
    isObserving : function (object, methodName) {
        // if nothing is being observed on the object at all, forget it
        if (!object._observers) return false;

        // get the queue of observers of that method, bailing if none found
        var queue = object._observers[methodName];
        if (!queue) return false;

        // return true if we are one of the observers
        for (var i = 0; i < queue.length; i++) {
            if (queue[i].target == this) return true;
        }
        // otherwise return false 'cause we're not observing
        return false;
    },

    //>    @method    class.convertToMethod()
    //
    //    This takes the name of an instance property as a parameter, and (if legal) attempts to
    //  convert the property to a function.
    //  If the property's value is a function already, or the property is registered via
    //  class.registerStringMethods() as being a legitimate target to convert to a function,
    //  return true.
    //  Otherwise return false
    //
    //    @param    functionName     (string)    name of the property to convert to a string.
    //
    //    @return                    (boolean)   false if this is not a function and cannot be converted
    //                                      to one
    //
    //<
    convertToMethod : function (methodName) {
        // accessor for isc.Func.convertToMethod, rather than duplicating that code
        return isc.Func.convertToMethod(this, methodName);
    },

    //> @method class.evaluate()
    //
    // Evaluate a string of script in the scope of this instance (so <code>this</code>
    // is available as a pointer to the instance).
    //
    // @param expression (string) the expression to be evaluated
    // @param evalArgs (object) Optional mapping of argument names to values - each key will
    //      be available as a local variable when the script is executed.
    // @return (any) the result of the eval
    // @see classMethod:Class.evaluate
    // @visibility external
    //<
    evaluate : function (expression, evalVars) {
        return isc.Class.evaluate.apply(this, [expression, evalVars]);
    },


    //>    @method    class.fireCallback()
    //
    //    Method to fire a callback. Callback will be fired in the scope of the object on
    //  which this method is called.<br>
    //  Falls through to +link{classMethod:Class.fireCallback()}
    //
    //    @param    callback    (Callback) Callback to fire
    //  @param  [argNames]        (string)    comma separated string of variables
    //  @param  [args]            (array)     array of arguments to pass to the method
    //
    //  @return (any)   returns the value returned by the callback method passed in.
    //  @visibility external
    //<

    fireCallback : function (callback, argNames, args, catchErrors) {

        return this.getClass().fireCallback(callback, argNames, args, this, catchErrors);
    },

    //> @method class.delayCall()
    //  This is a helper to delay a call to some method on this object by some specified
    //  amount of time.
    // @param methodName (string) name of the method to call
    // @param [arrayArgs] (array) array of arguments to pass to the method in question
    // @param [time] (number) Number of ms to delay the call by - defaults to zero (so just pulls
    //                        execution of the method out of the current execution thread.
    // @return (string) Timer ID for the delayed call - can be passed to
    //                      +link{Timer.clear()} to cancel the call before it executes
    // @visibility external
    //<
    delayCall : function (methodName, arrayArgs, time) {
        return this.getClass().delayCall(methodName, arrayArgs, time, this);
    },


    //> @method Class.fireOnPause()
    // Given some repeatedly performed event (EG keypress, scroll, etc), set up an action
    // to fire when the events have stopped occurring for some set period.
    // @param id (string) arbitrary identifier for the action
    // @param callback (callback) action to fire on quiescence
    // @param [delay] (number) delay in ms - defaults to 200ms
    //<
    fireOnPause : function (id, callback, delay) {
        return this.getClass().fireOnPause(id, callback, delay, this, this.getID());
    },

    //> @method Class.pendingActionOnPause()
    // Returns true iff an action has been scheduled by fireOnPause() to fire when
    // events have stopped occurring for some set period,
    // @param id (string) arbitrary identifier for the action
    //<
    pendingActionOnPause : function (id) {
        var actions = this.getClass()._actionsOnPause[id];
        return actions ? !!actions[this.getID()] : false;
    },

    //>    @method    class.evalWithVars()
    //
    // Same as the class method evalWithVars, but implicitly assigns the class on which this method
    // is called as the target.
    //
    // @see classMethod:Class.evalWithVars()
    //<
    evalWithVars : function (evalString, evalVars) {
        return isc.Class.evalWithVars(evalString, evalVars, this);
    },

    getWindow : (
        isc.Browser.isSafari ? function () {
            return window;
        } : function () {
            return this.ns._window;
        }
    ),
    getDocument : (
        isc.Browser.isSafari ? function () {
            return window.document;
        } : function () {
            return this.ns._document;
        }
    ),
    getDocumentBody : function () { return isc.Class.getDocumentBody(); },
    getActiveElement : function () { return isc.Class.getActiveElement(); },

    // Auto Generated Named Children
    // ---------------------------------------------------------------------------------------
    // Subsystem for handling automatically creating the standard children of a compound widget
    // like a Window, which must create header, resizer, etc components.
    //
    // Not fully worked out or mechanisms not documented:
    // - dynamic defaults
    //   - creation via Arrays of String like (window.headerControls) prevents dynamic defaults
    //     from being passed
    //     - could be solved by a registerDynamicDefaults(autoChildName, defaults)
    //   - no way for subclasses to override dynamically provided defaults
    //     - could be solved by a registerDynamicDefaults(autoChildName, defaults, this.Class),
    //       where addAutoChild would traverse registered defaults in className order?
    //   - passthrough properties that are just renames should be declarative, not dynamic
    //     defaults.  Could have a special syntax, valid only for defaults, like:
    //        blahDefaults : {
    //           dataSource:"$creator.hiliteDS"
    //        }
    //     .. these defaults could be "compiled" to speed this up (cache prop names and
    //     assignment function).
    //   - super high-speed (createRaw()) creation
    //     - needs to be overridable (as with other dynamicDefaults), so not just a method in
    //       autoChildDefaults()
    //     - when overriding, don't want to have call Super
    //     - could use a pattern like [className]_configure_autoChildName(autoChild)?
    //     - _completeCreationWithDefaults() is an imperfect implementation of this.
    // - tabs and sections
    //   - "autoChild:blah" achieves lazy creation, but not lazy creation of a hierarchy of
    //     components
    //     - NOTE: edge case: when a tabSet sees "autoChild:blah", the use case may be:
    //       - subclassing TabSet and adding autoChildren, in which case the defaults are found
    //         on the TabSet itself OR
    //       - using a TabSet as one of your autoChildren and creating tab.panes as other
    //         autoChildren, in which case the defaults are on the TabSet's creator.
    //       The TabSet tries to "guess" by looking at whichever widget has [autoChild]Defaults
    //   - tabs, fields, items, sections etc out of reach of autoChild-based configuration
    // - plug-ins
    //   - want
    // - requirement of calling changeDefaults() awkward
    //   - class.init would keep changeDefaults() calls from having to be done in global scope
    //   - could have a specially interpreted property like autoChildDefaults
    // - default way of adding children
    //   - we could have a property like "defaultAutoParent" in order to allow eg Window to
    //     specify that autoChildren are added to the body instead.  If so, we'd need
    //     autoParent:"creator" to mean add to creator despite defaultAutoParent.
    // - for high performance creation of many similar objects, need an API that you can call
    //   that collapses properties and then re-uses then, or possibly even dynamically creates
    //   an ISC Class
    //
    // Internal (for now) usages
    // - providing dynamic properties via an override of
    //   getDynamicDefaults(autoChildName) in order to avoid manual calls to addAutoChild()
    // - widget.autoChildren can be an Array of autoChildren which will be created and added
    //   after initWidget().  This can be handy, but doesn't cleanly allow further subclassing
    //   as is
    //
    // - other best practices:
    //   - when defaults objects get very large consider replacing them with a class definition.
    //     This makes code faster since less properties are added on create(), however, it does
    //     make it less likely that application or patch code that tries to use a different
    //     constructor for that autoChild will succeed.  Splitting skinning-related properties
    //     into a class while retaining behavioral properties (like method overrides) is a good
    //     hedge.
    //
    // - cleanup
    //   - autoChildParentMap is obsoleted by autoParent setting and should be removed
    //   - _autoMaker functionality is probably obsoleted by getDynamicDefaults() and needs to
    //     be removed
    //   - several classes used the autoChild system before it was fully complete, and so have
    //     manual calls to createAutoChild() which are probably unnecessary
    //
    // - notes on design of this system
    //   - considered accepting just simple Strings as autoChild names anywhere Canvii are
    //     normally expected, eg tab.pane and section.items, but:
    //     - this conflicts with allowing globals to be specified as just a String in these
    //       spots.  Specifying strings for globals is actually useful for out-of-order
    //       creation, and when coming from XML, and is a likely newbie error when attempting
    //       to specify a global reference.  If we try to disambiguate via a check for eg
    //       [childName]Defaults and/or whether there is a global Canvas by that name, we still
    //       end up with weird cases where a global might surpress an autoChild or vice versa,
    //       like finding "footer" in window.items
    //     - the String isn't a complete definition of the autoChild anwyay, as in the case of
    //       section.items, the appropriate creator may be the SectionStack or some yet higher
    //       level parent

    //> @groupDef autoChildUsage
    // An AutoChild is an automatically generated subcomponent that a parent component creates to
    // handle part of its presentation or functionality.  An example is the +link{Window} component and
    // its subcomponent the +link{Window.header,header}.
    //
    // <!--<var class="smartclient">-->
    // <p>
    // AutoChildren support a standard set of properties that can be used to customize or skin
    // them.  The names of these properties are derived from the name of the AutoChild itself.
    // These properties will generally not be separately documented for every AutoChild unless
    // there are special usage instructions; the existence of the properties is implied whenever
    // you see an AutoChild documented.
    // <P>
    // The properties affecting AutoChildren are:
    // <dl>
    //
    // <dt> <b>"show" + name</b> (eg showHeader)
    // <dd> Controls whether the AutoChild should be created and shown at all. Note that the
    // first letter of the AutoChild name is uppercased for this property ("header" -> "Header").
    //
    // <dt> <b>name + "Properties"</b> (eg headerProperties)
    // <dd> Properties to apply to the autoChild created by this particular instance of the
    // parent component.  For example:
    // <pre>
    //        isc.Window.create({
    //            ID: "myWindow",
    //            headerProperties: { layoutMargin: 10 }
    //        });
    // </pre>
    // The above applies a +link{layout.layoutMargin,layoutMargin} of 10 to the header of <code>myWindow</code>,
    // increasing the empty space around the subcomponents of the header (buttons, title label,
    // etc).
    // <P>
    // Generally, *Properties is null.  <b>Do not</b> use the *Properties mechanism for
    // skinning.  See *Defaults next.
    //
    // <dt> <b>name + "Defaults"</b> (eg headerDefaults)
    // <dd> Defaults that will be applied to the AutoChild created by any instance of the
    // parent class.  *Defaults is used for skinning.  This property should never be set when
    // creating an instance of the parent component, as it will generally wipe out defaults
    // required for the component's operation.  Use +link{class.changeDefaults,changeDefaults()}
    // to alter defaults instead. This is generally as part of a custom skin and/or custom component
    // creation - see the +link{group:autoChildren,overview of AutoChildren for component development}
    // for details and examples.
    //
    // <dt> <b>name + "Constructor"</b> (eg headerConstructor)
    // <dd> SmartClient Class of the component to be created.  An advanced option, this
    // property should generally only be used when there is documentation encouraging you to do
    // so.  For example, +link{ListGrid} offers the ability to use simple CSS-based headers or
    // more complex +link{StretchImg} based headers via +link{listGrid.headerButtonConstructor}.
    // The constructor can also be specified using the <code>_constructor</code> property in the
    // defaults for the AutoChild.
    // </dl>
    // <!--</var>--><!--<var class="smartgwt">-->
    // <p>
    // AutoChildren support four standard configuration mechanisms that can be used to customize or skin
    // them. Note, however, that configuring AutoChildren in Smart&nbsp;GWT is advanced usage.
    // <p>
    // To determine which AutoChildren exist for a particular component type, search the class' Javadocs
    // for "AutoChild" as there is a getter for each AutoChild that is supported. In the case
    // of a +link{group:multiAutoChildren,MultiAutoChild}, the getter is non-functional (always
    // returns null) and exists only to make you aware that the MultiAutoChild exists.
    // <p>
    // The four different ways to configure AutoChildren in Smart&nbsp;GWT are:
    // <dl>
    // <dt> <b>Visibility</b>
    // <dd> Controls whether the AutoChild should be created and shown at all.  The
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildVisibility(String, boolean)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildVisibility(String, boolean)} API
    // as appropriate is used to change this property for the named AutoChild.
    //
    // <dt> <b>Properties</b>
    // <dd> Properties to apply to the AutoChild created by a particular instance of the
    // parent component. In the case of a +link{MultiAutoChild}, the properties are applied to each
    // instance created by the parent.
    // <P>
    // To change the properties of an AutoChild of a widget, the
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildProperties(String, Canvas)} or
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildProperties(String, FormItem)} API
    // is used. To change the properties of an AutoChild of a form item, the
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildProperties(String, Canvas)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildProperties(String, FormItem)}
    // API is used. For example:
    // <pre>
    //        final Window myWindow = new Window();
    //        final Layout headerProperties = new Layout();
    //        headerProperties.setLayoutMargin(10);
    //        myWindow.setAutoChildProperties("header", headerProperties);
    // </pre>
    // The above applies a +link{layout.layoutMargin,layoutMargin} of 10 to the header of <code>myWindow</code>,
    // increasing the empty space around the subcomponents of the header (buttons, title label,
    // etc).
    // <P>
    // <b>Do not</b> use the Properties mechanism for skinning.  See Defaults next.
    //
    // <dt> <b>Defaults</b>
    // <dd> Defaults that will be applied to the AutoChild created by any instance of the
    // parent class.  Changing the defaults is used for skinning.  The <code>changeAutoChildDefaults()</code>
    // static method of the target Smart&nbsp;GWT class is used to change the defaults for all
    // instances of the class.  For example, to change the +link{Window.header,Window.header}
    // defaults, the {@link com.smartgwt.client.widgets.Window#changeAutoChildDefaults(String, Canvas)}
    // API is used passing "header" for the <code>autoChildName</code>.
    // <p>
    // <code>changeAutoChildDefaults()</code> must be called before any
    // components are created, and will generally be the first thing in your module's
    // <code>onModuleLoad()</code> function.  Alternatively, you can use the JavaScript equivalent
    // <code>Class.changeDefaults()</code> inside of a load_skin.js file - see <i>Skinning
    // AutoChildren</i> below.
    //
    // <dt> <b>Constructor</b>
    // <dd> &#83;martClient Class of the component to be created.  An advanced option, the
    // AutoChild constructor should generally only be changed when there is documentation encouraging
    // you to do so.  For example, +link{ListGrid} offers the ability to use simple CSS-based headers or
    // more complex +link{StretchImg} headers via
    // <code>listGridInstance.setAutoChildConstructor("headerButton", "StretchImg")</code>.
    // To change the constructor of AutoChildren, the
    // {@link com.smartgwt.client.widgets.Canvas#setAutoChildConstructor(String, String)} or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#setAutoChildConstructor(String, String)}
    // API is used.
    // <p>
    // For some drastic customizations of an AutoChild where the constructor is changed, the
    // signature of the <code>get[AutoChild]()</code> method may have too specific a return type and the
    // {@link com.smartgwt.client.widgets.Canvas#getCanvasAutoChild(String)},
    // {@link com.smartgwt.client.widgets.Canvas#getFormItemAutoChild(String)},
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#getCanvasAutoChild(String)}, or
    // {@link com.smartgwt.client.widgets.form.fields.FormItem#getFormItemAutoChild(String)} API
    // as appropriate would need to be used instead to retrieve the AutoChild instance.
    // </dl>
    // <p>
    // <b>NOTE:</b> When setting Properties or Defaults in Smart&nbsp;GWT, attributes and event
    // handlers can be set, but override points are not supported.
    // <!--</var>-->
    //
    // <p>
    // The AutoChild system can be used to create both +link{canvas.children,direct children}
    // and indirect children (children of children).  For example, the
    // +link{window.minimizeButton,minimizeButton} of the Window is also an autoChild, even
    // though it is actually located within the window header.
    // <P>
    // <h4>Skinning AutoChildren</h4>
    // <P>
    // Skinning AutoChildren by changing the AutoChild defaults is typically done for two purposes:
    // <ul>
    // <li> Changing the default appearance or behavior of a component, for example, making all
    // Window headers shorter
    // <li> Creating a customized variation of an existing component <i>while retaining the
    // base component unchanged</i>.  For example, creating a subclass of Window called
    // "PaletteWindow" with a very compact appearance, while leaving the base Window class
    // unchanged so that warning dialogs and other core uses of Windows do not look like
    // PaletteWindows.
    // </ul>
    // The best code examples for skinning are in the load_skin.js file for the "&#83;martClient"
    // skin, in <code>isomorphic/skins/&#83;martClient/load_skin.js</code>.
    // <P>
    // <h4>Passthroughs (eg window.headerStyle)</h4>
    // <P>
    // In many cases a component will provide shortcuts to skinning or customizing its
    // AutoChildren, such as +link{window.headerStyle}, which becomes header.styleName.  When
    // these shortcuts exist, they must be used instead of the more general AutoChild skinning
    // system.
    // <P>
    // <h4>Safe Skinning</h4>
    // <P>
    // Before skinning an AutoChild consider the +link{group:safeSkinning,safe skinning guidelines}.
    // <P>
    // <h4>Accessing AutoChildren Dynamically</h4>
    // <P>
    // For a component "Window" with an AutoChild named "header", if you create a Window
    // called <code>myWindow</code>, the header AutoChild is available
    // <var class="smartclient">as <code>myWindow.header</code></var>
    // <var class="smartgwt">via <code>myWindow.getHeader()</code></var>.
    // <P>
    // Unless documented otherwise, an AutoChild should be considered an internal part of a
    // component.  Always configure AutoChildren by APIs on the parent component when they
    // exist.  It makes sense to access an AutoChild for troubleshooting purposes or for
    // workarounds, but in general, an AutoChild's type, behavior, and internal structure are
    // subject to change without notice in future SmartClient versions.
    // <P>
    // Accessing an AutoChild may give you a way to make a dynamic change to a component that
    // is not otherwise supported by the parent component (for example, changing a text label
    // where there is no setter on the parent).  Before using this approach, consider whether
    // simply recreating the parent component from scratch is a viable option. This approach
    // is more than fast enough for most smaller components, and will not create a reliance on
    // unsupported APIs.
    //
    // @title Using AutoChildren
    // @treeLocation Concepts
    // @visibility external
    //<

    //> @type AutoChild
    // An autoChild is an automatically generated subcomponent that a component creates to
    // handle part of its presentation or functionality.  An example is the Window component and
    // its subcomponent the "header".
    // <P>
    // See +link{autoChildUsage,Using AutoChildren} for more information.
    //
    // @group autoChildren
    // @visibility external
    //<

    //> @type MultiAutoChild
    // @see group:multiAutoChildren
    // @visibility external
    //<

    // NOTE: the following groupDef appears only in SmartClient, not SmartGWT.
    //> @groupDef autoChildren
    // An autoChild is an automatically generated subcomponent that a component creates to
    // handle part of its presentation or functionality.
    // <P>
    // An example is the Window component and its subcomponent the "header".
    // <P>
    // AutoChildren support a standard set of properties that can be used to customize or skin
    // them.
    // <P>
    // This topic explains how to use the autoChild system when creating custom components in
    // order to create maximum flexibility.  To learn how to use the autoChild system with
    // pre-existing components, +link{group:autoChildUsage,go here}.
    // <P>
    // Before reading this topic, be sure you have read the +docTreeLink{QuickStart Guide}
    // material on creating custom components and have reviewed the provided examples.
    // <P>
    // <h3>Basics</h3>
    // <P>
    // The following is an example of creating subcomponents <b>without</b> using the AutoChild
    // pattern.  In this case a fictitious "Portlet" class is being created, which uses an
    // instance of isc.Label to serve as it's header.
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.headerLabel = isc.Label.create({
    //             autoDraw:false,
    //             contents: this.title,
    //             styleName: this.titleStyleName,
    //             portlet:this,
    //             click : function () { this.portlet.bringToFront() },
    //             wrap:false,
    //             overflow:"hidden",
    //             width:"100%"
    //         });
    //         this.addMember(this.headerLabel);
    //         ...
    // </pre>
    // While straightforward, this approach provides limited flexibility to someone using the
    // "Portlet" class.  There is no way to:
    // <ol>
    // <li> avoid creating the headerLabel, for a "headerless" portlet
    // <li> use a different, more advanced class as a header (eg, StretchImgButton or a custom
    // class)
    // <li> skin the headerLabel, other than CSS (rounded corners, animations, etc, wouldn't be
    // possible)
    // <li> change it's layout behavior (eg enable autoSize)
    // <li> add or override event handlers
    // </ol>
    // Let's imagine we wanted to add some of the above features.  We could change the code
    // like so:
    // <P>
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     <b>showHeaderLabel:true,</b>
    //     <b>headerLabelConstructor:isc.Label,</b>
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         <b>if (this.showHeaderLabel) {</b>
    //             this.headerLabel = this.headerLabelConstructor.create({
    //                 autoDraw:false,
    //                 contents: this.title,
    //                 styleName: this.titleStyleName,
    //                 portlet:this,
    //                 click : function () { this.portlet.bringToFront() },
    //                 wrap:false,
    //                 overflow:"hidden",
    //                 width:"100%"
    //             }<b>, this.headerLabelProperties</b>);
    //             this.addMember(this.headerLabel);
    //         <b>}</b>
    //         ...
    // </pre>
    // Our additions solve our initial concerns:
    // <ul>
    // <li> <code>showHeaderLabel:false</code> can be set to suppress the header label
    // <li> <code>headerLabelConstructor</code> allows you to switch to a different class
    // <li> <code>headerLabelProperties</code> give you a means to add arbitrary properties
    // (skinning properties, sizing properties, event handlers, etc)
    // </ul>
    // However, the code is becoming more verbose and repetitive, and we've created a few
    // additional properties that now need documentation and testing.  This extra work is going
    // to be multiplied by every subcomponent we create where we want this kind of flexibility.
    // <P>
    // Enter the AutoChild system: the purpose of the AutoChild system is to define a standard
    // pattern for creating subcomponents with maximum flexibility.  This means:
    // <ul>
    // <li> developers creating custom components write less code, have less to test and less
    // to document
    // <li> developers can more easily understand each other's code for custom components,
    // because it follows a standard pattern
    // <li> developers <b>using</b> custom components have a standard pattern for
    // customization, instead of learning customization APIs for every component separately
    // </ul>
    // The code below uses the autoChild system to create the "headerLabel" subcomponent.  This
    // version of the code would still respect all of the customization properties from earlier
    // examples (<code>headerLabelProperties</code> et al) and offers several additional degrees
    // of flexibility still to be explained, yet it's significantly shorter.  More importantly,
    // this code is less redundant; the "boilerplate" code is gone and what's left is just the
    // actual settings for the headerLabel subcomponent.
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     headerLabelDefaults : {
    //         _constructor:isc.Label,
    //         click : function () { this.creator.bringToFront() },
    //         wrap:false,
    //         overflow:"hidden",
    //         width:"100%"
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.addAutoChild("headerLabel", {
    //             contents: this.title,
    //             styleName: this.titleStyleName
    //         });
    //         ...
    // </pre>
    // <P>
    // The documentation for +link{class.addAutoChild,addAutoChild()} explains why this code
    // will still respect the <code>showHeaderLabel</code> flag and other customization
    // properties even though they aren't mentioned specifically.
    // <P>
    // <h3>AutoChildren lifecycle</h3>
    // <P>
    // By default any auto-children created by +link{class.addAutoChild()} or
    // +link{class.createAutoChild()} will be +link{canvas.destroy(),destroyed} when the
    // canvas that created them is destroyed. You can suppress this behavior by setting
    // <code>dontAutoDestroy</code> to <code>true</code> on the auto child. To do this you
    // could add the property to the defaults or properties block for the autoChild, or
    // pass it into the creating method in the dynamic set of properties.
    // <p>
    // <h3>Subclassing a component with autoChildren</h3>
    // <P>
    // If you are subclassing a component that has an autoChild and you want to change
    // defaults for that autoChild, the correct way to do so is to use
    // +link{Class.changeDefaults,changeDefaults()}:
    // <pre>
    // isc.defineClass("MyWindow", "Window");
    // isc.MyWindow.changeDefaults("headerDefaults", { layoutMargin:10 });
    // isc.MyWindow.addProperties({
    //    ...
    // </pre>
    // <P>
    // <code>changeDefaults()</code> creates a copy of the superclass defaults and applies your
    // changes, which is important because you want to inherit the superclass behavior without
    // affecting the superclass, and yet apply overrides.
    // <P>
    // The following code sample indicates two common
    // <span style="color:red;font-weight:bold">incorrect</span> patterns for working with
    // defaults, and the consequences of each:
    // <pre>
    // isc.defineClass("MyWindow", "Window").addProperties({
    //     // NO.  Superclass behavior / settings for autoChild
    //     // won't be inherited.  Use changeDefaults() instead.
    //     headerDefaults : { ... },
    //
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         // NO.  "headerDefaults" object is shared across the class,
    //         // changing it affects all instances created from here on.
    //         // Pass dynamic defaults to addAutoChild() instead
    //         this.headerDefaults.myProperty = this.newValue;
    //         ...
    // });
    // </pre>
    // <b>defaults vs properties</b>
    // <P>
    // For AutoChildren, defaults and properties both provide similar means of adding
    // properties to an AutoChild, and the distinction between them is primarily one of
    // convention: a class that uses AutoChildren should never define a default value for
    // <i>autoChildName</i>Properties, so that instances can freely specify
    // <i>autoChildName</i>Properties without overriding built-in behavior.
    // <pre>
    // isc.defineClass("MyWindow", "Window").addProperties({
    //     // NO.  Any further use of "headerProperties", in
    //     // instances or in subclasses, would wipe out behavior
    //     headerProperties : { ... },
    // </pre>
    // <P>
    // By consistently using +link{Class.changeDefaults()} whenever you override autoChild
    // defaults in a subclass, you ensure that your classes can in turn be subclassed and
    // extended uniformly.
    // <P>
    // <h3>autoParents and creation order</h3>
    // <P>
    // The AutoChild pattern can create an entire hierarchy of generated subcomponents.  For
    // example, the +link{Window} class included with SmartClient uses several AutoChildren as
    // part of the overall header structure: separate autoChildren for the minimize button,
    // close button, and then the header itself, a Layout-derived class that contains all other
    // header controls.
    // <P>
    // To facilitate construction of hierarchies of autoChildren, the special
    // <code>autoParent</code> property may appear in either defaults or properties for an
    // autoChild, and indicates the name of another autoChild that should used as a parent.
    // For example, to create a "closeButton" autoChild that will be a member of the "header"
    // autoChild:
    // <P>
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     headerDefaults : {
    //         _constructor:isc.HLayout,
    //         ...
    //     },
    //     closeButtonDefaults : {
    //         <b>autoParent:"header",</b>
    //         _constructor:isc.ImgButton,
    //         ...
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         this.addAutoChild("header");
    //         this.addAutoChild("closeButton");
    //         ...
    // </pre>
    // <P>
    // In addition to cutting down on code and making inter-autoChild relationships clearer,
    // using <code>autoParent</code> rather than manual calls to addMember() allows a
    // subclass of your component to potentially completely rearrange the autoChildren you have
    // defined, while retaining their behavior.
    // <P>
    // When using <code>autoParent</code> to arrange autoChildren, create parents first, then
    // children.
    // <P>
    // <b>Tip:</b> if you want all of the behaviors of
    // +link{class.addAutoChild(),addAutoChild()} <i>except</i> automatically adding the
    // autoChild to a parent, set <code>autoParent:"none"</code>.
    // <P>
    // <b>special case: TabSets and SectionStacks</b>
    // <p>
    // An autoChild that appears as a +link{tab.pane} or
    // +link{SectionStackSection.items,section item} does not have a clear way to refer to it's
    // tab or section via the <code>autoParent</code> property.  For this special case, the
    // TabSet and SectionStack components allow tab.pane / section.items to contain the special
    // string "autoChild:<i>autoChildName</i>".  This will cause the corresponding autoChild to be
    // automatically created when the tab is selected or section expanded.
    // <P>
    // For example:
    // <pre>
    // isc.defineClass("Portlet", "VLayout").addProperties({
    //     ...
    //     mainTabsDefaults : {
    //         _constructor:isc.TabSet,
    //         tabs : [
    //             { title:"First Pane", pane:"autoChild:firstPane" }
    //         ]
    //     },
    //     firstPaneDefaults : {
    //         ...
    //     },
    //     initWidget : function () {
    //         this.Super("initWidget", arguments);
    //
    //         // this automatically creates firstPane as an autoChild
    //         this.addAutoChild("mainTabs");
    //         ...
    // </pre>
    //
    // @visibility external
    //<

    //> @groupDef multiAutoChildren
    // A MultiAutoChild is an +link{AutoChild} where the creating component usually creates more than
    // one, hence, unlike a normal AutoChild, the AutoChild is not accessible as <code>creator.[autoChildName]</code>.
    // <P>
    // See +link{autoChildUsage,Using AutoChildren} for more information on configuring a
    // MultiAutoChild.
    // @see Class.createAutoChild()
    // @visibility external
    //<

    // break this discussion into safe skinning (visuals only) and safe customization
    // (subclasses and autoChildren)?
    //> @groupDef safeSkinning
    // The skinning mechanism is extremely powerful and gives you the ability to change
    // internal functionality of components.  While this is useful for workarounds, you should
    // think through any properties you override, considering what will happen with future
    // versions of SmartClient, where the defaults may change or be expanded.
    // <P>
    // The following kinds of overrides are generally very safe:
    // <ul>
    // <li> Change +link{canvas.styleName,styleName} or +link{button.baseStyle,baseStyle} to
    // provide a custom CSS style or series of styles
    // <li> Change a media path such as the +link{Img.src,src} of the
    // +link{Window.minimizeButton}.
    // <li> Change the size of any part of the UI that has a fixed pixel size, such as
    // the height and width of the +link{Window.minimizeButton}, especially when this is done
    // to match the size of media you have created
    // <li> Set properties such as +link{button.showRollOver} that cause a component to
    // visually react to more or fewer UI states (disabled, over, down, etc)
    // </ul>
    // The following should be very carefully considered:
    // <ul>
    // <li> Adding custom behaviors by passing in event handlers such as
    // (eg +link{canvas.showContextMenu,showContextMenu()}).  If future versions of the
    // component add more functionality, you may prevent new features from functioning, cause
    // them to function only partially, or break.
    // <P>
    // If you want to ensure that you do not break new functionality added in future SmartClient
    // versions, be sure to call +link{class.Super,Super()} for methods you override, and do not
    // prevent events from bubbling.
    // <P>
    // If you want to ensure that <b>only</b> your custom behavior is used if a future version
    // of a SmartClient component adds functionality, override all methods involved in the
    // interaction, even if your methods do nothing.  For example, for a custom drop
    // interaction, override dropOver, dropMove, dropOut and drop, even if you do nothing on
    // dropMove().  Then, do not call Super() if there is no superclass behavior required for
    // the interaction you've implemented.  Also, for any event handlers (such as drop())
    // return false if you consider your code to have completely handled the event (no
    // parent component should react).
    // </ul>
    // The following are not recommended:
    // <ul>
    // <li> Providing a global +link{Canvas.ID,ID} to a subcomponent (only works once).
    // <li> Overriding +link{canvas.backgroundColor}, +link{canvas.border,border},
    // +link{canvas.margin,margin}, +link{canvas.padding,padding}, or in general any single
    // attribute otherwise controlled by CSS.  Future SmartClient versions may change the base
    // CSS style, rendering your single-property customization senseless.  Change the entire
    // CSS style via +link{canvas.styleName,styleName} instead.
    // </ul>
    //
    // @title Safe Skinning
    // @visibility external
    //<

    addAutoChildren : function (children, parent, position) {
        if (children == null) return;
        if (!isc.isAn.Array(children)) children = [children];
        for (var i = 0; i < children.length; i++) {
            var child = children[i];
            if (isc.isA.Canvas(child)) {
                parent = parent || this;
                this._addAutoChildToParent(child, parent, position);
                continue;
            }
            // string name, or block of properties specifying an autoChild
            this.addAutoChild(child, null, null, parent, position);
        }
    },

    //> @method class.addAutoChild()
    // Creates a component according to the "AutoChild" pattern, and adds it to this component.
    // <P>
    // See the +link{group:autoChildren,AutoChild usage overview} to understand the general
    // purpose and usage of this method.
    // <P>
    // <code>addAutoChild()</code> takes the following actions:
    // <ol>
    // <li> checks whether this.<i>autoChildName</i> is already populated, and returns it if so
    // <li> checks when there is a show<i>AutoChildName</i> with the value false, and if so
    // returns without creating a component
    // <li> calls +link{createAutoChild()} to create the component
    // <li> sets this.<i>autoChildName</i> to the created component
    // <li> adds the component either to this component, or to some other parent, specified
    // by the "autoParent" property in the autoChild's defaults.  The "autoParent" property may
    // be "none" indicating the autoChild should not be automatically added.
    // </ol>
    // <P>
    // When adding an autoChild to a +link{Layout} subclass,
    // +link{layout.addMember,addMember()} will be called instead of the normal
    // +link{Canvas.addChild,addChild()}.  To prevent this behavior,
    // <code>addAsChild:true</code> can be set in the autoChild defaults.  Similarly,
    // <code>addAsPeer:true</code> may be set to add an autoChild as a peer.
    // <P>
    // <b>Tip:</b> because <code>addAutoChild()</code>
    // checks specifically for show<i>AutoChildName</i>:false, you do not have to add
    // show<i>AutoChildName</i>:true in order for an autoChild to be shown by default; leaving
    // the property undefined is sufficient.
    // <P>
    // Note that by default the child created by this method will be destroyed when
    // +link{canvas.destroy(),destroy()} is called on this instance. To disable this behavior,
    // set <code>dontAutoDestroy</code> to true on the auto child.
    //
    // @param childName (String) name of the autoChild
    // @param defaults (Properties) dynamic properties for the autoChild
    // @return (Class) created autoChild
    //
    // @group autoChildren
    // @visibility external
    //<
    _$maker:"_autoMaker",
    addAutoChild : function (childName, dynamicProperties, defaultConstructor, parent, position) {
        var childValue = this[childName];
        // already created
        if (isc.isAn.Instance(childValue)) return childValue;


        // allow a properties object with autoChildName etc
        if (isc.isAn.Object(childName) && childName.autoChildName) {
            dynamicProperties = childName;
            defaultConstructor = dynamicProperties._constructor || defaultConstructor;
            childName = dynamicProperties.autoChildName;
        }

        // check to see if the value of the childName property is a string that is the global
        // ID of an existing instance (like { header : "myPreviouslyCreatedHeader" })
        if (isc.isA.String(childValue) && window[childValue]) {
            this[childName] = window[childValue];
            return this[childName];
        }

        // check flags, and existence of parents, before proceeding to create the child
        // NOTE: null check allows constructor blocks for unnamed autoChildren (automatically
        // created, but not skinnable)
        if (childName != null && !this.shouldCreateChild(childName)) return;

        // create the child
        // XXX autoMaker functionality is considered legacy; getDynamicDefaults() is believed
        // to handle all cases for which autoMaker was intended, and more cleanly
        // If this[childName]_autoMaker() is defined, call that to make the child, rather than
        // 'createAutoChild()'

        var child,
            makerName = childName + this._$maker;

        if (childName != null && this[makerName]) child = this[makerName](dynamicProperties);
        else {
            child = this.createAutoChild(childName, dynamicProperties, defaultConstructor, true);
        }
        // createAutoChild() may return null if we're not configured to create this child.
        // A custom maker function may return null if it wants to handle adding the child to
        // the appropriate parent itself (and assinging the child to the appropriate property
        // name)
        if (!child) return;

        // If we went through createAutoChild with the assignToSlot parameter, this is unnecessary
        // but if we ran the maker method, we have to actually assign this[childName] to the
        // generated object
        this[childName] = child;

        this._addToParent(childName, child, parent, position);

        return child;
    },

    _$creator:"creator",
    _addToParent : function (childName, child, parent, position) {
        // ways of specifying parent, in order of preference
        // - pass into addAutoChild / createAutoChild (becomes parent param here)
        // - as child.autoParent, for any source of properties
        // - define this.autoChildParentMap
        // - finally, "this" assumed
        if (parent == null) {
            parent = child.autoParent || this.getAutoChildParent(childName);
        }
        if (isc.isA.String(parent)) {
            // constant meaning no parent, eg, pop-up dialog
            if (parent == isc.Canvas.NONE) {
                if (this.isDrawn()) child.draw();
                return;
            }

            var canvasParent = this[parent] || window[parent] || parent;
            if (!isc.isA.Canvas(canvasParent)) {
                this.logWarn("no valid parent could be found for String '" + parent + "'");
            } else parent = canvasParent;
        }

        // do nothing if the created child is not a Canvas or derived parent isn't a canvas.
        if (!isc.isA.Canvas(child) || !isc.isA.Canvas(parent)) return;

        this._addAutoChildToParent(child, parent, position);
    },

    _addAutoChildToParent : function (child, parent, position) {
        // add to parent, as member or child
        if (child.addAsPeer || child.snapEdge) parent.addPeer(child);
        else if (isc.isA.Layout(parent) && !child.addAsChild && !child.snapTo) parent.addMember(child, position);
        else if (isc.TileLayout && isc.isA.TileLayout(parent) && !child.addAsChild && !child.snapTo) parent.addTile(child, position);

        else parent.addChild(child);
    },

    // defaults to creating child if this.show[ChildName] isn't explicitly set to false.  If the
    // child is declared to have a named parent, checks that the parent will be created too
    _$show : "show",
    shouldCreateChild : function (childName) {
        var showProperty = this._$show + childName.charAt(0).toUpperCase() + childName.substring(1);
        if (this[showProperty] != null && this[showProperty] == false) return false;

        // check whether the parent will be created
        var parentName = this._getAutoChildParentName(childName);
        if (parentName == null) return true;
        return (this.shouldCreateChild(parentName));
    },

    _$Constructor: "Constructor",
    // Determine what class the child should be.
    // - If there is an explicit [childName]Constructor property, use that specified class
    // - If the properties include an _constructor attribute, use that class
    // - Otherwise use the defaultConstructor passed in
    // - (back off to canvas if we failed to find a class)
    getAutoChildClass : function (childName, dynamicProperties, defaultConstructor,
                                  childDefaultsName, childPropertiesName) {
        // use childDefaultsName if passed, so it doesn't have to be recalc'd
        childDefaultsName = childDefaultsName || this._getDefaultsName(childName);
        var childDefaults = this[childDefaultsName];

        childPropertiesName = childPropertiesName || this._getPropertiesName(childName);
        var childProperties = this[childPropertiesName];

        return this[childName + this._$Constructor] ||
               (dynamicProperties ? dynamicProperties._constructor : null) ||
               (childProperties ? childProperties._constructor : null) ||
               (childDefaults ? childDefaults._constructor : null) ||
               defaultConstructor || isc.Canvas;
    },

    // get defaults for all auto children
    applyBaseDefaults : function (child, childName, dynamicDefaults) {
        child.autoDraw = false;
        child._generated = true;

        // special "creator" property obviates the need to pass "window:this" et al dynamically
        child.creator = this;
        // ability to rename the "creator" pointer for clarity
        var creatorName = this.creatorName;
        if (creatorName) child[creatorName] = this;

        // generate an ID for the autoChild based on it's name.  NOTE: can be suppressed by
        // passing ID:null in dynamicProperties
        var undef;
        if (dynamicDefaults == null || dynamicDefaults.ID === undef) {
            child.ID = this.getID() + isc._underscore + childName;
            // if the defaultID collides, uniquify it.  This allows createAutoChild() to be
            // called multiple times on the same config block
            if (window[child.ID]) {
                child.ID = child.ID + isc._underscore + isc.ClassFactory.getNextGlobalID();
            }
        }
    },

    getDynamicDefaults : function () {},

    _$Defaults: "Defaults",
    _getDefaultsName : function (childName) {
        var cache = isc.Class._defaultsCache;
        if (!cache) isc.Class._defaultsCache = cache = {};

        if (cache[childName]) return cache[childName];

        var defaultsName = childName + this._$Defaults;
        if (this[defaultsName]) cache[childName] = defaultsName;
        return defaultsName;
    },

    _$Properties: "Properties",
    _getPropertiesName : function (childName) {
        var cache = isc.Class._propertiesCache;
        if (!cache) isc.Class._propertiesCache = cache = {};

        if (cache[childName]) return cache[childName];

        var propertiesName = childName + this._$Properties;
        if (this[propertiesName]) cache[childName] = propertiesName;
        return propertiesName;
    },

    //> @method class.createAutoChild()
    // Unconditionally creates and returns a component created according to the "AutoChild"
    // pattern.
    // <P>
    // In addition to applying defaults and properties as described under the
    // +link{group:autoChildUsage,AutoChild overview}, the created autoChild:
    // <ul>
    // <li> is automatically <code>autoDraw:false</code>
    // <li> has a <code>creator</code> property that points to this component, for easy
    // authoring of event handlers (eg click:"this.creator.doSomething()")
    // </ul>
    // <P>
    // Unlike +link{addAutoChild()}, <code>createAutoChild()</code> does not create a
    // this.<i>autoChildName</i> reference to the component, check a show<i>AutoChildName</i>
    // flag, or automatically add the autoChild via +link{Canvas.addChild()}.
    // <P>
    // General you use <code>createAutoChild</code> rather than addAutoChild when:
    // <ul>
    // <li> you are going to create several autoChildren with a common set of defaults (for
    // example the +link{columnTree.column,column} autoChild of the +link{ColumnTree}).
    // <li> children need to be created before their parents (eg, for layout/auto-sizing
    // reasons)
    // </ul>
    // <P>
    // Note that by default the child created by this method will be destroyed when
    // +link{canvas.destroy(),destroy()} is called on this instance. To disable this behavior,
    // set <code>dontAutoDestroy</code> to true on the auto child.
    //
    // @param childName (String) name of the autoChild
    // @param defaults (Properties) dynamic properties for the autoChild
    // @return (Class) created autoChild
    //
    // @group autoChildren
    // @visibility external
    //<
    createAutoChild : function (childName, passedDynamicDefaults, defaultConstructor,
                                assignToSlot)
    {
        var dynamicDefaults = this.getDynamicDefaults(childName);

        // NOTE: dynamicDefaults: generally, you will *either* pass dynamic defaults to
        // addAutoChild() *or* implement getDynamicDefaults() for cases where you don't call
        // addAutoChild directly.  It would be weird to do both, so we make sure it works, but
        // it's not as fast.
        if (dynamicDefaults != null && passedDynamicDefaults != null) {
            dynamicDefaults = isc.addProperties({}, dynamicDefaults, passedDynamicDefaults);
        } else {
            dynamicDefaults = passedDynamicDefaults || dynamicDefaults;
        }

        // standard name for defaults (eg bodyDefaults)
        var childDefaultsName = this._getDefaultsName(childName),
            childDefaults = this[childDefaultsName],
            childPropertiesName = this._getPropertiesName(childName),
            childProperties = this[childPropertiesName],
            // pass childDefaultsName so it doesn't have to be recalc'd
            childClassName = this.getAutoChildClass(childName, dynamicDefaults,
                                                    defaultConstructor, childDefaultsName, childPropertiesName),
            childClass = isc.ClassFactory.getClass(childClassName)
        ;
        if (childClass == null) {
            this.logWarn("Unable to create autoChild '"+childName
                         +"' of type '"+childClassName+"' - no such class in runtime.");
            if (isc.isA.String(childClassName) && childClassName.contains(".")) {
                this.logWarn("Did you make the SmartGWT class reflectable? See http://www.smartclient.com/smartgwt/javadoc/com/smartgwt/client/docs/Reflection.html");
            }
            return null;
        }

        dynamicDefaults = this.applyDuplicateAutoChildDefaults(
                            childClass,
                            childDefaultsName,
                            dynamicDefaults
                          );

        var child = childClass.createRaw();

        // autoPassthroughs: mechanism for declaring that certain properties on an autoParent
        // should be passed-through to the same-named properties on children
        // DO NOT USE, this will probably be renamed
        var passthroughs = this.autoPassthroughs,
            passthroughValues,
            undef;
        if (passthroughs) {
            for (var propName in passthroughs) {
                var targetChildName = passthroughs[propName];
                if (childName == targetChildName && this[propName] !== undef) {
                    child[propName] = this[propName];
                }
            }
        }

        this.applyBaseDefaults(child, childName, passedDynamicDefaults);

        isc.addProperties(child,
                          this.autoChildDefaults,
                          childDefaults,
                          passthroughValues,
                          dynamicDefaults);

        // call configure methods if available.  These allow maximum speed dynamicDefaults
        // through direct property assignment on the half-created autoChild.  Different
        // autoChildren can be quickly identified (eg child == this.newButton), and sharing
        // defaults across different autoChildren is easier.  These APIs are very advanced
        // because caller needs to understand the half-initialized "raw" state.

        if (assignToSlot) this[childName] = child;
        if (child.autoConfigure) child.autoConfigure(this, childName);
        if (this.configureAutoChild) this.configureAutoChild(child, childName);
        isc.addProperties(child, this[childPropertiesName]);

        // call initInterface() on any member interfaces that define the method
        if (childClass._initInterfaceMethods) {
            for (var i = 0; i < childClass._initInterfaceMethods.length; i++) {
                childClass._initInterfaceMethods[i].call(child);
            }
        }

        child.init();

        // Possibly extract from a config block -- will return the child itself
        // if this isn't a SmartGWT config block
        child = isc.SGWTFactory.extractFromConfigBlock(child);
        // Re-assigning to slot in case we extracted the child from an SGWT config block
        if (assignToSlot) this[childName] = child;

        // Maintain a mapping between child name and generated auto children IDs
        // This allows us to auto-destroy autochildren on destroy
        // Also used by the AutoTest locator APIs
        if (!this._createdAutoChildren) this._createdAutoChildren = {};
        var ID = child.getID ? child.getID() : null;
        if (ID != null) {

            if (!isc.isAn.Array(this._createdAutoChildren[childName])) {
                if (this._createdAutoChildren[childName] != null) {
                    isc.logWarn(this + ".createAutoChild(): Creating auto child named:" + childName
                        + " appears to be replacing autoChild with same name...");
                }
                this._createdAutoChildren[childName] = [ID];

            } else {
                this._createdAutoChildren[childName].add(ID);
            }
        }

        return child;
    },

    // When creating an autoChild, clone attributes registered for duplication
    // from the class level defaults block (or the special 'autoChildDefaults' object) and
    // apply cloned versions to dynamic defaults
    // Returns dynamicDefaults passed in - may be null or a new object if the
    // dynamicDefaults were unset originally
    applyDuplicateAutoChildDefaults : function (childClass, childDefaultsName, dynamicDefaults) {
          // clone attributes from class level defaults block that are registered for duplication
        var dupProps = childClass._dupAttrs;
        if (dupProps && dupProps.length > 0) {

            var childDefaults = this[childDefaultsName];

            if (childDefaults != null || this.autoChildDefaults != null) {
                for (var i = 0; i < dupProps.length; i++) {
                    var attr = dupProps[i],
                        undef;

                    if (childDefaults != null && childDefaults[attr] != null) {

                        if (dynamicDefaults == null) dynamicDefaults = {};
                        if (dynamicDefaults[attr] === undef) {
                            dynamicDefaults[attr] = childClass.cloneDupPropertyValue(
                                                        attr, childDefaults[attr]
                                                    );
                        }
                    } else if (this.autoChildDefaults != null &&
                                this.autoChildDefaults[attr] != null)
                    {
                        if (dynamicDefaults == null) dynamicDefaults = {};
                        if (dynamicDefaults[attr] === undef) {
                            dynamicDefaults[attr] = childClass.cloneDupPropertyValue(
                                                        attr, this.autoChildDefaults[attr]
                                                    );
                        }
                    }
                }
            }
        }
        return dynamicDefaults;
    },


    _completeCreationWithDefaults : function (childName, child, dynamicDefaults) {
        this.applyBaseDefaults(child, childName, dynamicDefaults);

        var childDefaultsName = this._getDefaultsName(childName),
            childPropertiesName = this._getPropertiesName(childName)
        ;

        // duplicate properties from the defaults to the dynamicDefaults block if necessary
        var childClass = child.getClass();

        // Note that this won't do anything for SGWT config blocks. But that's OK,
        // because the proper properties will eventually be duplicated when the
        // real Smartclient object is created.
        dynamicDefaults = this.applyDuplicateAutoChildDefaults(
                                childClass,
                                childDefaultsName,
                                dynamicDefaults
                          );

        child.completeCreation(
            // defaults for all named children
            this.autoChildDefaults,
            // instance defaults (for skinning) (eg bodyDefaults)
            this[childDefaultsName],
            // dynamic defaults
            dynamicDefaults,
            // user-provided instance properties
            this[childPropertiesName]
        );
    },

    // parents of named children can be declared as a map "autoChildParentMap" from child name
    // to parent name, on the assumption the parent is also a named child.
    _getAutoChildParentName : function (childName) {
        var parentMap = this.autoChildParentMap;
        if (parentMap) return parentMap[childName];
    },

    getAutoChildParent : function (childName) {
        var parentName = this._getAutoChildParentName(childName);
        if (parentName) return this[parentName];
        return this;
    },

    // set a named child: normally, just evaluates or re-evaluates the show flag in order to create
    // or destroy the component.  Can also be used to replace a named child with a specified
    // component.
    setAutoChild : function (childName, dynamicProperties) {

        if (!this.shouldCreateChild(childName)) {
            if (this[childName]) this[childName].destroy();
            // clear our pointer to the destroyed child
            delete this[childName];
        } else {
            // If we're passed a widget, apply it directly (unless shouldCreateChild() returns
            // false in which case we ignore the widget)
            if (isc.isA.Canvas(dynamicProperties)) {
                var child = dynamicProperties;
                // set the child to a custom-provided widget
                if (this[childName]) this[childName].destroy();
                this[childName] = child;
                this._addToParent(childName, child);
                return;
            }

            return this.addAutoChild(childName, dynamicProperties);
        }
    },



    //>    @method    class.map()
    //
    // Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.
    //
    //    @param    methodName (string)
    //      Name of the method on this instance which should be called on each element of the Array
    //    @param    items      (Array)
    //      Array of items to call the method on
    //
    //    @return            (Array) Array of results, one per element in the passed "items" Array
    // @visibility external
    //<
    map : isc.Class.map,

    //>    @method    class.Super()
    //
    // Call the SuperClass implementation of an instance method.  For example:
    // <pre>
    //    isc.defineClass("MyButton", "Button").addProperties({
    //        // this override causes no change in behavior because it just
    //        // calls Super and returns whatever the superclass would return
    //        getTitle : function () {
    //            return this.Super("getTitle", arguments);
    //        },
    //
    //        // this override would add "foo" to the titles of all buttons
    //        getTitle : function () {
    //            // add code here to take actions before the superclass method is invoked
    //
    //            var superResult = return this.Super("getTitle", arguments);
    //
    //            // add code here to take action after the superclass method is invoked
    //
    //            return superResult + "foo";
    //        }
    //
    //    })
    // </pre>
    // Note that Super is always called with the name of the current method.  You cannot call
    // the Super class implementation of another method directly.
    // <P>
    // It is <b>required</b> to always pass the native 'arguments' object to Super.  Arguments
    // is a JavaScript builtin that is available within any JavaScript function - see any
    // JavaScript Reference for details.
    // <P>
    // See also +link{ClassFactory.defineClass,defineClass()} and
    // +link{classMethod:class.addProperties,addProperties} for the basics of creating classes
    // and overriding methods.
    //
    //    @param methodName   (string)    name of the superclass method to call
    //    @param args         (arguments or Array) native "arguments" object, or array of
    //                                           arguments to pass to the Super call
    //    @param [nativeArgs] (arguments) native "arguments" object, required if an Array is
    //                                  passed for the "args" parameter in lieu of the native
    //                                  arguments object
    //
    //    @return                    (any)        return value of the superclass call
    //
    // @visibility external
    //<
    //    @param     [nativeArguments] (Arguments) native "arguments" object.  Required only if
    //                                        calling Super() with a substitute set of
    //                                        arguments
    Super : isc.Class.Super,
    _delayedSuper : isc.Class._delayedSuper,
    invokeSuper : isc.Class.invokeSuper,

    _assert : isc.Class._assert

});

// NOTE: toString functions CANNOT be added by addMethods, because a property named "toString"
// will not be enumerated by for..in.  This is actually part of the ECMAScript standard!

//>    @classMethod    Class.toString()
//
//  The default toString() for a ClassObject reports that you have a ClassObject and what class
//  it is.
// @visibility external
//<
isc.Class.toString = function () {
    return "[Class " + this.Class + "]";
}

//>    @method    class.toString()
//
//  The default toString() for instances reports that you have an instance of a class and prints
//  the instance ID if present.
// @visibility external
//<
isc.Class.getPrototype().toString = function () {
    return "[" + this.Class + " ID:" + this.ID + "]";
}

//
//  Add Class properties (useful static properties to be referenced by other code)
//
isc.Class.addClassProperties({


    // make the isc namespace available on all Class objects
    ns : isc,

    //>    @classAttr  Class.NO_OP    (function : {} : IA)
    //      An empty (no-op) function.  Used as a default setting for event
    //      handlers to allow observation to occur.
    //      Added as a class constant rather than class method, since this will not be directly
    //      called on the Class object (as in "Class.NO_OP()"), so does not need the logic
    //      usually required for methods.
    //
    // @group    events
    //
    //<
    NO_OP : function() {},

    RET_TRUE : function () {
        return true;
    },

    //>    @classAttr  Class._stringMethodRegistry (object : {} : IA)
    //      This object is a map of method names to strings of arguments.
    //      It serves a dual purpose
    //      1 - Any properties listed in here are instance methods of this class which can legally
    //          be assigned string values to eval.
    //      2 - Allows you to get at the set of parameter names used in the string value (for
    //          converting the string to a function).
    //
    //<
    _stringMethodRegistry: {}

});     // END isc.Class addClassProperties()

//
// add the observation methods to the ClassFactory as well so we can use 'em there
//
isc.addMethods(isc.ClassFactory, {
    observe : isc.Class.getPrototype().observe,
    ignore : isc.Class.getPrototype().ignore
});


//> @classMethod isc.eval()
// Evaluate a string of script and return the result. Falls through to
// +link{classMethod:Class.evaluate(),Class.evaluate()}
//
// @param expression (string) Expression to evaluate
// @return (any) Result of evaluating the expression passed in
// @visibility external
//<
// Additional 'hiddenIFrameEval' param indicating that we're evaluating a JSON block
// rather than executing arbitrary script.
// Note: this differs from a straight call to the native eval function in that you lose scope.
// You can workaround this by using the instance method 'evaluate()', and passing in a mapping
// of variable names to values to be available when the string executes.

isc.eval = function (expression, hiddenIFrameEval) {
    return isc.Class.evaluate(expression, null, false, hiddenIFrameEval);
}










  //>DEBUG
// This lets us label methods with a name within addMethods
Function.prototype.Class = "Function";
  //<DEBUG




// Utility methods for exploring and manipulating functions and methods
isc.ClassFactory.defineClass("Func");

isc.Func.addClassMethods({

    // create the static regular expression we use to parse out the name of a function
    _nameExpression : new RegExp("function\\s+([\\w$]+)\\s*\\("),
    parseFunctionName : function (func) {
        // derive the name from the function definition using a regular expression
        var match = isc.Func._nameExpression.exec(func.toString());
        if (match) return match[1];
        // if the regex didn't match, it's an anonymous function
        // NOTE that new Function().toString() is "function anonymous() { }" on both Moz and IE
        else return "anonymous";
    },

    // gets the name of a function as a string.  Uses
    getName : function (func, dontReport) {
        if (func == Function.prototype.apply) return "Function.apply";
        if (func == Function.prototype.call) return "Function.call";
        if (!func) {
            if (!arguments.callee || arguments.callee.caller === undefined) return "unknown";
            if (!arguments.callee.caller) return "none";
            func = arguments.callee.caller;
        }
        // if we've previously determined our name or been explicitly labelled with a name, return
        // that
        if (func._fullName == null) {

            if (func._className == null && isc._allFuncs) {
                var index = isc._allFuncs.indexOf(func);
                if (index != -1) {
                    for (var className = isc._funcClasses[index]; className == null; index--) {
                        className = isc._funcClasses[index];
                    }
                    func._className = className;
                } else {
                    // fallback approach uses the fact that we give a global name to all
                    // functions to figure out what they are - works for functions that somehow
                    // miss out on the _allFuncs index.
                    var functionName = this.parseFunctionName(func);
                    //isc.logWarn("function: " + functionName + " not in index");
                    var isClassMethod;
                    if (functionName.startsWith("isc_c_")) {
                        functionName = functionName.substring(6);
                        isClassMethod = true;
                    } else {
                        functionName = functionName.substring(4);
                    }
                    className = functionName.substring(0, functionName.indexOf("_"));
                    methodName = functionName.substring(className.length+1);
                    var clazz = isc.ClassFactory.getClass(className),
                        method = null;
                    if (clazz) {
                        method = isClassMethod ?
                            clazz[methodName] : clazz.getInstanceProperty(methodName);
                    }
                    //if (method != null) {
                    //    isc.logWarn("lookup up method: " + this.echoLeaf(method) +
                    //                " equals func: " + (method == func));
                    //}
                }
            }

            // if we have a className but no function name, search the class (and instance
            // prototype) for the function
            var name = func._name,
                isClassMethod;
            if (name == null && func._className != null) {
                var theProto;
                var classObj = isc.ClassFactory.getClass(func._className);
                if (classObj == null) {
                    // support lookups for non-Class singletons like isc.ClassFactory and
                    // isc.FileLoader, and native globals like Array and Function
                    //Log.logWarn("className is: " + func._className);
                    classObj = isc[func._className] || window[func._className];
                } else {
                    theProto = classObj.getPrototype();
                }
                // check instance methods first (more common)
                if (theProto != null) {
                    for (var methodName in theProto) {
                        if (theProto[methodName] === func) {
                            name = methodName;
                            break;
                        }
                    }
                }
                // then class methods
                if (name == null && classObj != null) {
                    for (var methodName in classObj) {
                        if (classObj[methodName] === func) {
                            name = methodName;
                            isClassMethod = true;
                            break;
                        }
                    }
                    // if this is a native object, check the prototype methods as well
                    if (name == null && !isc.isA.Class(classObj) && classObj.prototype != null) {
                        for (var methodName in classObj.prototype) {
                            if (classObj.prototype[methodName] === func) {
                                name = methodName;
                                break;
                            }
                        }
                    }
                }
            }

            if (name != null) {
                func._fullName = (func._instanceSpecific ?
                                  (func._isOverride ? "[o]" : "[a]") : isc._emptyString) +
                                 (isClassMethod ? "[c]" : isc._emptyString) +
                                 (func._className ? func._className + isc.dot : isc._emptyString) +
                                  name;
            } else {
                if (func._isCallback) func._fullName = "callback";
                else {
                    func._fullName = isc.Func.parseFunctionName(func);
                }
            }
            //this.logWarn("function acquired _fullName: " + func._fullName);
        }

        return func._fullName;
    },

    //>    @method    Func.getArgs()    (A)
    //
    //     Gets the arguments to the function as an array of strings
    //
    //  @param  func (function) Function to examine
    //    @return    (array)    argument names for the function (array of strings)
    //                    returns an empty array if the function has no arguments.
    //<
    getArgs : function (func) {
        var args = isc.Func.getArgString(func);
        if (args == "") return [];
        return args.split(",");
    },

    //>    @method    Func.getArgString()    (A)
    //
    //     Gets the arguments to the function as a string of comma separated values
    //
    //  @param  func (function) Function to examine
    //    @return    (string)    argument names for the function separated by commas
    //                    returns an empty string if the function has no arguments.
    //<
    getArgString : function (func) {
        if (func._argString != null) return func._argString;
        var string = func.toString(),
            lparenPosPlus1 = string.indexOf("(") + 1,
            args = string.substring(lparenPosPlus1, string.indexOf(")", lparenPosPlus1));
        args = args.replace(/\/\*.*?\*\/|\/\/.*$/gm, isc.space);
        args = args.replace(/\s+/g, isc.emptyString);
        func._argString = args;
        return args;
    },

    //>    @method    Func.getBody()    (A)
    //
    //     Gets the body of the function as a string.<br><br>
    //
    //    NOTE: This is the body of the function after it has been parsed -- all comments will
    //            have been removed, formatting may be changed from the original text, etc.
    //
    //  @param func (function) function to examine
    //    @return    (strings)    body of the function as a string, without leading "{" and trailing "}"
    //<
    getBody : function (func) {
        var string = func.toString();

        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}"));
    },


    //>    @method    Func.getShortBody()    (A)
    //
    //     Gets the body of the function as a string, removing all returns so it's more
    //     compact.<br><br>
    //
    //    NOTE: This is the body of the function after it has been parsed -- all comments will
    //    have been removed, formatting may be changed from the original text, etc.
    //
    //  @param func (function) function to examine
    //    @return    (string)    body of the function as a string, without leading "{" and trailing "}"
    //<
    getShortBody : function (func) {
        var string = func.toString();

        return string.substring(string.indexOf("{") + 1, string.lastIndexOf("}")).replace(/[\r\n\t]*/g, "");
    }
});


// -----------------------------------------------------------------------------------------------
// function.apply()
// This is a native method in most browsers.
// If it's not already defined, supply the "apply" function.
// If it is already defined, patch it so it will not JS error if explicitly passed
// <code>null</code> as the arguments (2nd) parameter.






//>    @method    function.apply()    (A)
//
// Applies this function to <code>targetObject</code>, as if the function was originally
// defined as a method of the object.
//
//    @param    targetObject    (object)            target to apply the function to.  Within the context
//                                                of the function as it evaluates, <code>this</code> == <code>targetObject</code>
//    @param    args            (array of objects)    list of arguments to pass to the function
//
//    @return                    (varies)            returns the normal return value of the function
//<
if (!Function.prototype.apply) {

    // temporary function number for generating a new function name
    isc.addMethods(Function.prototype, {
        apply :    function (targetObject, args) {

//!DONTOBFUSCATE
            if (targetObject == null) targetObject = window;
            // generate a temporary function name
            var tempFunctionName = "__TEMPF_" + Function.prototype._tempFuncNum++;
            var returnValue;

            // assign the function being apply'd (this) to the targetObject
            targetObject[tempFunctionName]=this;


            // if no argments passed, set args to an empty array
            if (!args) args = [];

            if (args.length <= 10) {
                // Note any undefined properties of the args array will simply be
                // undefined arguments of the function being invoked via apply, as
                // they should be.  The arguments.length of the function will be off, but so be it
                returnValue = targetObject[tempFunctionName](args[0],args[1],args[2],args[3],args[4],
                                                             args[5],args[6],args[7],args[8],args[9]);
            } else {
                // The function is being called with more than ten arguments.

                // Construct a string with the code necessary to call the function with
                // however many arguments were passed, then eval() it.
                var    functionString = 'targetObject[tempFunctionName](';
                for (var i = 0; i < args.length; i++) {
                    functionString += "args" + '[' + i + ']';
                    if (i + 1 < args.length) {
                        functionString += ',';
                    }
                }
                functionString += ');';
                isc.eval('returnValue =' + functionString);
            }
            // remove the temporary function from the targetObject
            delete targetObject[tempFunctionName];
            // and return the value returned by the function call
            return returnValue;
        }
    });
    // counter which is used to generate unique names for functions to be applied
    Function.prototype._tempFuncNum = 0;
}




// Add some static helper methods to the Func class
isc.Func.addClassMethods({

    // Helper properties
    _commentDelimeters : [["//", "\n"], ["//", "\\n"], ["/*", "*/"]],
    _stringDelimeters : ["\"", "\'"],
    _complexIdentifiers : ["switch", "while", "if", "return", "for", "var"],
    _multiLineDelimeters : ["(", ")", "[", "]", "{", "}", ":", "?", "!",
                            "+", "-", "/", "*", "=", ">", "<","|", "&", ",", "\\"],

    //>     @method isc.Func.expressionToFunction() (A)
    //
    //      Given an expression or conditional as a string, convert it into
    //              a Function object.   Used to create functions that need to return
    //              values where the user specifies a string.  These were formerly done
    //              via evals.
    //
    //      @params variables       (string)                Names of variables to pass into the new function
    //      @params expression      (string)                String expression to evaluate return
    //
    //      @return (function)      function that returns the conditional value
    //<
    expressionToFunction : function (variables, expression, comment) {




        var returnValue = this._expressionToFunction(variables, expression, comment);



        return returnValue;
    },
    _expressionToFunction : function (variables, expression, comment) {


        if (expression == null) {
            //>DEBUG
            isc.Log.logInfo("makeFunctionExpression() called with empty expression");
            //<DEBUG
            expression = "";
        }

        // Handle being passed an action type object.
        // This is an object of the format
        //   { target:"componentId", name:"fetchData", title:"click" }
        // or
        //  { target: "someForm", name : "editRecord", title:"itemChanged",
        //    // action method param name -> expression to populate it
        //    mapping : {
        //        record : "record",
        //        callback : "someExpression()" // something use manually entered
        //    }
        //  }
        if (isc.isAn.Object(expression)) {
            if (isc.isA.StringMethod(expression)) expression = expression.getValue();

            else if (expression.Action && !expression.target) expression = expression.Action;


            var varsArray = variables;
            if (isc.isA.String(varsArray)) varsArray= variables.split(",");
            else if (isc.isAn.Array(varsArray)) {
                variables = varsArray.join();
            }
            if (!isc.isAn.Array(varsArray)) varsArray = [];

            var expressionArray = [
                // Warn if we can't find the target
                "if (!window.",                     // 0
                ,                                   // 1 (ID of target)
                "){var message='Component ID \"",  // 2
                ,                                   // 3 (ID of target)
                "\", target of action \"",          // 4
                ,                                   // 5 (action title)
                "\" does not exist';isc.Log.logWarn(message);if(isc.designTime)isc.say(message);}", // 6
                // Call the method on the target
                ,                                   // 7 target ID
                ".",                                // 8
                ,                                   // 9 method name
                "(",                                // 10
                ,                                   // 11 arguments [as a ',' separated string]
                ")"                                 // then close with ")"
            ];
            // Plug the ID of the target, and the method to call into the function string.
            expressionArray[1] = expressionArray[3] = expressionArray[7] = expression.target;
            expressionArray[9] = expression.name;
            if (expression.title) expressionArray[5] = expression.title;
            else expressionArray[5] = "[No title specified]"

            // mapping is an array of expressions to pass in as parameters
            var mapping = expression.mapping || [];
            if (!isc.isAn.Array(mapping)) mapping = [];
            expressionArray[11] = mapping.join();   // automatically puts commas between args

            var expressionString = expressionArray.join(isc.emptyString);
            var theFunc;
            try {
                theFunc = isc._makeFunction(variables, expressionString);
            } catch (e) {
                this.logWarn("invalid code: " + expressionString +
                             " generated from action: " + this.echo(expression));
                theFunc = new Function();
            }
            theFunc.iscAction = expression;

            return theFunc;

        }

        var complexIdStartChars = "swirfv";


        // if variables passed in as an array of strings,
        // convert to a single string of vars separated by commas.
        //
        if (isc.isAn.Array(variables)) {
            variables = variables.join();
        }


        var isSimpleExpression = true;

        // loop through expression character by character. if there is any
        // indication that it contains more than one statement or a complex
        // statement, set isSimpleExpression to false and break.

        var i = 0; // character index.
        var commentDelimiters = this._commentDelimeters;
        var stringDelimiters = this._stringDelimeters;

        // strings that identify that a string is more than a simple expression
        var complexIdentifiers = this._complexIdentifiers;

        // the set of characters that can end a line while allowing a statement to continue onto the
        // next line
        var multiLineDelimiters = this._multiLineDelimeters;

        // keeps track of whether we've seen a semicolon.  Once we've seen a semicolon, anything
        // other than whitespace and comments indicates a multi-statement expression
        var commentsOnly = false;

        // set up some variables to avoid a bunch of string allocation during loops
        var nullString = isc._emptyString,
            commentStart = isc.slash,
            eol = "\n",
            backslash = "\\",
            plusSign = "+",
            semicolon = isc.semi;

        // keeps track of the last non-whitespace character,
        // so we know what it was when we get to the end of a line.
        var lastChar = nullString;

        // keeps track of the next non-whitespace character.
        var nextChar = nullString;

        // loop through each character of the expression
        while (i < expression.length) {
            var currentChar = expression.charAt(i);

            // check if we're in a comment by seeing if the current characters match any comment
            // openers
            if (currentChar == commentStart) {
                for (var j = 0; j < commentDelimiters.length; j++) {
                    var delimiterSet = commentDelimiters[j],
                        opener = delimiterSet[0],
                        closer = delimiterSet[1]
                    ;
                    //if (expression.substring(i, i + opener.length) == opener) {
                    if (expression.indexOf(opener, i) == i) {
                        // we're in a comment.. skip until we find the comment closer
                        var k = i + opener.length;
                        while (k < expression.length) {
                            if (expression.substring(k, k + closer.length) == closer) {
                                k = k + closer.length;
                                break;
                            }
                            k++;
                        }
                        i = k;
                        lastChar = nullString;
                        nextChar = this._getNextNonWhitespaceChar(expression, i);
                    }
                }
            }

            // we've seen a semicolon.  From here on, if we find anything other than a comment or
            // whitespace, we've got a complex expression
            if (commentsOnly) {
                // if we only have whitespace until the end, we can break now.
                if (nextChar == nullString) {
                    break;
                } else {
                    if (isc.isA.WhitespaceChar(currentChar)) {
                        i++;
                        continue;
                    } else {
                        isSimpleExpression = false;
                        break;
                    }
                }
            }

            // check for the beginning of string
            for (var j = 0; j < stringDelimiters.length; j++) {
                var delim = stringDelimiters[j]
                if (currentChar == delim) {
                    // we're in a string; find the next unquoted delimeter of the same kind
                    var k = i + 1;
                    while (k < expression.length) {
                        if (expression.charAt(k) == backslash) k = k + 2; // skip over escapes
                        if (expression.charAt(k) == delim) {
                            k++;
                            break;
                        }
                        k++;
                    }
                    i = k;
                    lastChar = delim.charAt(0);
                    nextChar = this._getNextNonWhitespaceChar(expression, i);
                }
            }

            // check if we've reached the end of a line
            if (currentChar == eol) {
                // see if the last character on the line is one that would allow the statement to
                // continue onto another line
                var isMLD = false;
                for (var j = 0; j < multiLineDelimiters.length; j++) {
                    if (lastChar == multiLineDelimiters[j]) {
                        isMLD = true;
                        break;
                    }
                }
                if (isMLD || nextChar == plusSign) {
                    lastChar = nullString;
                } else {
                    // the last character on this line closed a statement, and there's more
                    // characters, so this has to be a multi-statement expression
                    isSimpleExpression = false;
                    break;
                }
            }

            // look for semicolon
            if (currentChar == semicolon) {
                // set the commentsOnly flag to switch modes: from here on, if we find anything
                // other than a comment or whitespace, we've got a complex expression
                commentsOnly = true;
            }

            // check for keywords that indicate that this is not a simple expression
            // Note: There's a bug in string.charAt() in IE4 whereby a negative index will
            // return the first char of the string.
            // Therefore explicitly check whether the keyword is present and either at the
            // beginning or end of the string, or delimited by non AlphaNumeric chars.
            // (IE: it is the keyword, not just a substring of a non-keyword)

            // _complexIdentifiers : ["switch", "while", "if", "return", "for", "var"],
            if (complexIdStartChars.indexOf(currentChar) != -1) {

            for (var j = 0; j < complexIdentifiers.length; j++) {
                var word = complexIdentifiers[j],
                    length = word.length;

                if (
                     // Don't check if there are not enough characters for the keyword
                     (i + length <= expression.length) &&
                     // Is the keyword present?
                     (expression.substring(i, i+length) == word) &&
                     // Is it at the end of the string, or followed by a non Alpha char?
                     (i + length == expression.length ||
                      !isc.isA.AlphaNumericChar(expression.charAt(i + length))) &&
                     // Is it at the beginning of the string, or preceded by a non Alpha char?
                     (i == 0 ||
                      !isc.isA.AlphaNumericChar(expression.charAt(i - 1)))

                ) {
                    isSimpleExpression = false;
                    break;
                }
            }

            }

            // if the current char isn't whitespace, set it as the last non-whitespace char
            if (!isc.isA.WhitespaceChar(currentChar)) lastChar = currentChar;

            // increment
            i++;

            // set up a new nextChar
            nextChar = this._getNextNonWhitespaceChar(expression, i);
        }

        if (isSimpleExpression) {
            expression = "return " + expression;
        }
        // add a comment (if one was passed in) to the function
        // this lets us label the functions if we want to
        if (comment) expression = "/" + "/" + comment + "\r\n" + expression;

        // now create the new function and return it.
        var theFunc = isc._makeFunction(variables, expression);
        return theFunc;
    },

    //>    @method    isc.Func._getNextNonWhitespaceChar()    (A)
    //
    //     subroutine used by expressionToFunction(). gets the next non-whitespace character
    //     after the given index.
    //
    //  @params expression      (string)        String expression to evaluate return
    //    @params    index            (number)        index after which to look for nextChar
    //<
    _getNextNonWhitespaceChar : function (expression, index) {
        // set up a new nextChar
        var nextChar = isc._emptyString;
        for (var j = (index + 1); j < expression.length; j++) {
            if (!isc.isA.WhitespaceChar(expression.charAt(j))) {
                nextChar = expression.charAt(j);
                break;
            }
        }
        // we searched to the end of the string.
        if (j >= expression.length) nextChar = isc._emptyString;
        return nextChar;
    },


    //>    @method    isc.Func.convertToMethod()
    //
    //  A static version of class.convertToMethod()
    //    This takes an object and the name of a property as parameters, and (if legal)
    //  attempts to convert the property to a function.
    //  If the property's value is a function already, or the property is registered via
    //  Class.registerStringMethods() as being a legitimate target to convert to a function,
    //  return true.
    //  Otherwise return false
    //
    //  @param  object          (object)    object with property to convert
    //    @param    functionName     (string)    name of the property to convert to a string.
    //
    //    @return                    (boolean)   false if this is not a function and cannot be converted
    //                                      to one
    //
    //<
    convertToMethod : function (object, methodName) {

        // Handle bad parameters
        // XXX How to log this better - we know nothing about object, so can't do getID() or
        //     whatever
        if (!isc.isAn.Object(object) || !isc.isA.nonemptyString(methodName)) {
            isc.Log.logWarn("convertToMethod() called with bad parameters.  Cannot convert " +
                            " property '" + methodName + "' on object " + object +
                            " to a function.  Returning false.");
            return false;
        }

        // If the value of this property is already a function - we don't need to make any
        // changes, and can assume it's a legal property value.
        if (object[methodName] && isc.isA.Function(object[methodName])) return true;

        // By default the _stringMethodregistry map object is a static property on the Class
        // of the object passed in.
        // If the object passed in is not a member of a subclass of 'Class', this is not the case.
        // In these cases assume the _stringMethodRegistry map has been assigned to the object
        // directly (for now)
        // XXX - Currently this is not really used anywhere in the code, but potentially could
        // be for stringMethods on (for example) the ListViewer data array.
        var registry = (isc.isAn.Instance(object) ? object.getClass()._stringMethodRegistry :
                                                object._stringMethodRegistry);
        // return false if there's no registry.
        if (registry == null) return false;

        var undefined;
        var methodParamsString = registry[methodName];

        // If the value is not in the map, return false - this property can't legally be
        // converted to a function by us, so don't attempt it!
        // triple "=" - check for identity not equivalence, as having the argument string be
        // null is legitimate.

        // If this method is not listed in the stringMethodRegistry, we can't convert the
        // property value to a method.
        if (methodParamsString === undefined) return false;

        // We're dealing with a valid string method - attempt to convert the property value.
        isc.Func.replaceWithMethod(object, methodName, methodParamsString);

        // and return true to indicate that this is a legal slot for a function and should now
        // contain a function (if the conversion was possible).
        return true;
    },


    //>    @method    isc.Func.replaceWithMethod()    (A)
    //
    //     Given an object with a string property, convert the string to a function
    //    and assign it to the same property name.
    //
    //    This is useful when you expect developers to pass a method (such as an event handler,
    //  etc) as a string, but you need to execute it as a function.
    //
    //    @params    object        (object)    Object containing the property
    //    @params    methodName    (string)    Names of the method to convert from string to a function
    //    @params    variables    (string)    Names of variables to pass into the new function
    //<
    replaceWithMethod : function (object, methodName, variables, comment) {

        // If no string has been provided for the stringMethod, create a function with the
        // correct signature.  Signature has to match so that you can observe an undefined
        // string method.
        if (object[methodName] == null) {
            object[methodName] = isc.is.emptyString(variables)
                    ? isc.Class.NO_OP
                    : new Function(variables, isc._emptyString);
        }

        var stringMethod = object[methodName];

        // already converted
        if (isc.isA.Function(stringMethod)) return;

        var convertedMethod;

        if (isc.isA.String(stringMethod) || isc.isA.Object(stringMethod)) {
            // expressionToFunction can handle stringMethods and 'action' type objects
            convertedMethod = isc.Func.expressionToFunction(variables, stringMethod, comment);
        } else {

            isc.Log.logWarn("Property '" + methodName + "' on object " + object + " is of type " +
                            typeof stringMethod + ".  This can not be converted to a method.",
                            "Function");

            return;
        }

        // add the converted function to the object:
        var temp = {};
        temp[methodName] = convertedMethod;
        isc.addMethods(object, temp);
    }

});




//>    @object    Array
// Generic extensions to JavaScript Arrays.  You can call these on any Array.
// <P>
// JavaScript's native Array is retrofitted to support the <code>List</code> API.
//
// @implements List
// @see List
// @treeLocation Client Reference/System
// @visibility external
//<

// Internal notes: Array vs the List interface
// - List is an interface which the native JavaScript Array object is retrofitted to implement
// - When a given method can be implemented solely in terms of other parts of the List interface,
//   there is the possibility that Array and the List interface can share the actual JavaScript
//   function object.  When this is done, the method is first defined on Array (for load order
//   reasons).
// - on Array, several methods can be faster if they use various native functions (like splice()),
//   and so a unique implementation appears here
// - on List, in order to allow a valid List implementation with a minimum of effort, all methods
//   boil down to very simple primitives like addAt

// - public documentation for the List interface is in List.js

//> @groupDef dataChanged
// Operations that change the Array
// @title Data Changes
//<

//> @groupDef iteration
// Operations on entire Arrays at once
// @title Iteration
//<

//> @groupDef arrayMath
// Math operations on entire Arrays at once
// @title Array Math
//<

// add a "Class" property to the array prototype
//    so we can recognize Array instances
Array.prototype.Class = "Array";

//>    @classMethod        Array.newInstance()
//        Create a new array, adding any arguments passed in as properties.
//        Here so we can make standard newInstance() calls on arrays.
//
//        @param    [all arguments]    (object)    objects with properties to override from default
//        @return    (array)    new array.
//<
Array.newInstance = function () {
    var instance = [];
    isc.addPropertyList(instance, arguments);
    return instance;
}
Array.create = Array.newInstance;

//> @classAttr Array.LOADING (String : "loading" : IRA)
// Marker value returned by Lists that manage remote datasets, indicating the requested data is
// being loaded. Note that the recommended test for loading data is to call +link{Array.isLoading()}
// rather than compare to this value directly.
// @visibility external
//<

Array.LOADING = "loading";

//> @classMethod Array.isLoading() (A)
// Is the object passed in a loading marker value? For use with Lists that manage remote
// datasets, to indicate that a record has not yet been retrieved from the server. A typical
// use case might be to check if a row has been loaded in a ListGrid - for example:
// <P>
// <code>
// if (Array.isLoading(myList.getRecord(0))) isc.warn("Please wait for the data to load.");
// </code>
// @param value (any) data to test.
// @visibility external
//<
Array.isLoading = function (row) {

    return row != null &&

            !isc.isAn.XMLNode(row) &&

            (row === Array.LOADING);
}

//> @classAttr Array.CASE_INSENSITIVE (Function : See below : )
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find case-insensitively,
// so, eg, <code>find("foo", "bar")</code> would find objects with a "foo" property set to
// "Bar", "BAR" or "bar"
// @visibility external
//<
Array.CASE_INSENSITIVE = function(arrayMemberProperty, comparisonProperty, propertyName) {
    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.String(arrayMemberProperty) &&
         isc.isA.String(comparisonProperty) &&
         arrayMemberProperty.toLowerCase() == comparisonProperty.toLowerCase()));
};

//> @classAttr Array.DATE_VALUES (Function : See below : )
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find instances where Dates
// in the search criteria match Dates in the array members (ordinarily, Javascript only regards
// Dates as equal if they refer to the exact same object).  This comparator compares <i>logical</i>
// dates; the time elements of the values being compared are ignored, so two Dates representing
// different times on the same day will be considered equal.
// @see Array.DATETIME_VALUES
// @visibility external
//<
Array.DATE_VALUES = function(arrayMemberProperty, comparisonProperty, propertyName) {
    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.Date(arrayMemberProperty) &&
         isc.isA.Date(comparisonProperty) &&
         Date.compareLogicalDates(arrayMemberProperty, comparisonProperty) == 0));
};

//> @classAttr Array.DATETIME_VALUES (Function : See below : )
// This is a built-in comparator for the +link{array.find,find} and +link{array.findIndex,findIndex}
// methods of Array.  Passing this comparator to those methods will find instances where Dates
// in the search criteria match Dates in the array members (ordinarily, Javascript only regards
// Dates as equal if they refer to the exact same object).  This comparator compares entire
// date values, including the time elements of the values being compared, so two Dates
// representing different times on the same day (even if they are only a millisecond apart)
// will not be considered equal.
// @see Array.DATE_VALUES
// @visibility external
//<
Array.DATETIME_VALUES = function (arrayMemberProperty, comparisonProperty, propertyName) {

    return (
        arrayMemberProperty == comparisonProperty ||
        (isc.isA.Date(arrayMemberProperty) &&
         isc.isA.Date(comparisonProperty) &&
         Date.compareDates(arrayMemberProperty, comparisonProperty) == 0));
};


if (!Array.prototype.localeStringFormatter)
    Array.prototype.localeStringFormatter = "toString";

// add a bunch of methods to the Array prototype so all arrays can use them
isc.addMethods(Array.prototype, {

iscToLocaleString : function () {
    return this[this.localeStringFormatter]();
},

//>    @method        array.getPrototype()
//        Return the Array.prototype -- for conformity with the Class.getPrototype() method
//        Used in exporting arrays.
//<
getPrototype : function () {
    return Array.prototype;
},


//>    @method        array.newInstance()
//        Create a new array, adding any arguments passed in as properties.
//        Here so we can make standard newInstance() calls on arrays.
//
//        @param    [all arguments]    (object)    objects with properties to override from default
//        @return    (array)    new array.
//<
newInstance : Array.newInstance,
create : Array.newInstance,

// List Interface
// --------------------------------------------------------------------------------------------

//>    @method        array.get()
// @include list.get()
//<
get : function (pos) {
    return this[pos]
},

//>    @method        array.getLength()
// @include list.getLength()
//<
getLength : function () {
    return this.length
},

//>    @method        array.isEmpty()
// @include list.isEmpty()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
isEmpty : function () {
    return this.getLength() == 0;
},

//>    @method        array.first()
// @include list.first()
//<
first : function () {
    return this[0]
},

//>    @method        array.last()
// @include list.last()
//<
last : function () {
    return this[this.length-1]
},

//>    @method        array.indexOf()
// @include list.indexOf()
//<

indexOf : function (obj, pos, endPos, comparator) {
    // normalize position to the start of the list
    if (pos == null) pos = 0;
    if (endPos == null) endPos = this.length - 1;

    var hasComparator = (comparator != null);
    for (var i = pos; i <= endPos; i++) {
        if (hasComparator ? comparator(this[i], obj) : this[i] == obj) {
            return i;
        }
    }

    // not found -- return the not found flag
    return -1;
},

//>    @method        array.lastIndexOf()
// @include list.lastIndexOf()
//<
lastIndexOf : function (obj, pos, endPos, comparator) {
    // normalize position to the end of the list
    if (pos == null) pos = this.length-1;
    if (endPos == null) endPos = 0;

    var hasComparator = (comparator != null);
    for (var i = pos; i >= endPos; i--) {
        if (hasComparator ? comparator(this[i], obj) : this[i] == obj) {
            return i;
        }
    }

    // not found -- return the not found flag
    return -1;
},

//>    @method        array.contains()
// @include list.contains()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
contains : function (obj, pos, comparator) {
    return (this.indexOf(obj, pos, null, comparator) != -1);
},


// helper method for doing a substring search
containsSubstring : function (obj, startPos, endPos, ignoreCase) {
    if (obj == null) return true;
    var result = this.indexOf(obj, startPos, endPos, function (a, b) {
        var filter = b == null ? null : (isc.isA.String(b) ? b : b.toString()),
            value = a == null ? null : (isc.isA.String(a) ? a : a.toString())
        ;
        if (ignoreCase) {
            if (filter != null) filter = filter.toLowerCase();
            if (value != null) value = value.toLowerCase();
        }
        var r = (value != null && filter != null) &&
                    (value == filter || (value && value.contains && value.contains(filter)));
        return r;
    });

    return result >= 0;
},

//> @method     array.containsAll()
// @include list.containsAll()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
containsAll : function (list) {
    if (list == null) return true;
    var length = list.getLength();
    for (var i = 0; i < length; i++) {
        if (!this.contains(list.get(i))) return false;
    }
    return true;
},

// string-based method - substring search - returns true if all of the values from the passed
// list appear somewhere in the contents of the values in this list
containsAllSubstring : function (list, ignoreCase) {
    if (list == null) return true;
    var length = list.getLength();
    for (var i = 0; i < length; i++) {
        if (!this.containsSubstring(list.get(i), null, null, ignoreCase)) return false;
    }
    return true;
},

//>    @method        array.intersect()
// @include list.intersect()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
intersect : function () {
    var results = [];

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true;

        // skip null elements
        if (item == null) continue;

        // for each array passed in
        for (var a = 0; a < arguments.length; a++) {
            // if the item is not in that array
            if (!arguments[a].contains(item)) {
                // it hasn't been found
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    // return true
    return results;
},

// variant of intersect that specifically deals with arrays of dates, which need to be compared
// with compareDates() and compareLogicalDates()
intersectDates : function () {
    var results = [];

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true
        ;

        // skip null elements
        if (item == null) continue;

        var logicalDate = item.logicalDate;

            // for each array passed in
        for (var a = 0; a < arguments.length; a++) {
            var otherArray = arguments[a];
            var inOtherArray = false;
            if (!otherArray) continue;
            for (var b = 0; b < otherArray.length; b++) {
                var otherItem = otherArray[b];
                if (!otherItem) continue;
                if (logicalDate) {
                    if (Date.compareLogicalDates(item, otherItem) == 0) {
                        inOtherArray = true;
                        break;
                    }
                } else {
                    if (Date.compareDates(item, otherItem) == 0) {
                        inOtherArray = true;
                        break;
                    }
                }
            }
            if (!inOtherArray) {
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    return results;
},

// variant of intersect that compares arrays of values as strings - returns entries from this
// array that appear as a substring of at least one entry in each of the passed arrays
_intersectSubstringIgnoreCase: true,
intersectSubstring : function () {
    var results = [],
        ignoreCase = this._intersectSubstringIgnoreCase
    ;

    // for each element in this array
    for (var i = 0; i < this.length; i++) {
        // if the element is in each argument, add it to the results
        var item = this.get(i),
            isPresent = true;

        // skip null elements
        if (!item) continue;

        // for each array passed in
        for (var a = 0; a < arguments.length; a++) {
            var otherArray = arguments[a];
            if (!otherArray) continue;

            // match if any of the elements in the passed array contains "item" as a substring
            if (!otherArray.containsSubstring(item, null, null, ignoreCase)) {
                isPresent = false;
                break;
            }
        }
        if (isPresent) results.add(item);
    }

    // return true
    return results;
},

//>    @method        array.equals()
// @include list.equals()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
equals : function (list) {
    if (list == null || !isc.isA.List(list)) return false;

    var length = list.getLength();

    // arrays of differing lengths cannot be equals
    if (length != this.getLength()) return false;

    for (var i = 0; i < length; i++) {
        if (list.get(i) != this.get(i)) return false;
    }
    return true;
},

//>    @method        array.getItems()
// @include list.getItems()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
getItems : function (itemList) {
    var outputs = [], length = itemList.getLength();
    for (var i = 0; i < length; i++) {
        outputs[i] = this.get(itemList.get(i));
    }
    return outputs;
},

//>    @method        array.getRange()
// @include list.getRange()
//<
getRange : function (start, end) {
    if (end == null) end = this.length - 1;
    return this.slice(start, end);
},

//>    @method        array.duplicate()    (A)
// @include list.duplicate()
//<
duplicate : function () {
    return isc._emptyArray.concat(this); // NOTE: concat creates a copy
},

// getData() from list - no analogous method

//>    @method        array.set()
// @include list.set()
//<
set : function (pos, item) {
    this[pos] = item;
    this.dataChanged();
},

//>    @method        array.addAt()
// @include list.addAt()
//<
addAt : function (obj, pos) {
    if (pos == null) pos = 0;

    // copy items in the original array to their new position; copy backwards from last item to
    // item at pos, so that none of the items are overwritten
    for (var i = this.length - 1; i >= pos; i--) {
        this[i+1] = this[i];
    }

    // add the new object to the list
    this[pos] = obj;

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    // return the object that was added
    return obj;
},

//>    @method        array.removeAt()
// @include list.removeAt()
//<
removeAt : function (pos) {
    // make sure the pos passed in is valid
    var length = this.length;
    if (pos >= length || pos < 0) return null;

    // get the item at that position
    var it = this[pos];

    // remove the item at that position by sliding other things over it
    for(;pos < length-1;pos++)
        this[pos] = this[pos+1];
    // now update the length
    this.length--;

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    return it;
},

//>    @method        array.add()
// @include list.add()
//<
add : function (object, secondArg) {
    var undefined;
    if (secondArg !== undefined) {
        // support calling as add(index, object)
        return this.addAt(object, secondArg);
    }
    var pos;
    // if the list.sortUnique is true, we're only supposed to have each item once
    if (this.sortUnique) {
        // find the current position of the item in the list
        pos = this.indexOf(object);
        // if it wasn't found, put it at the end
        if (pos == -1) pos = this.length;
    } else {
        // otherwise we always put the item at the end
        pos = this.length;
    }
    // actually stick the object in the list
    this[pos] = object;

    // if we are currently sorted, maintain current sort
    if (this.sortProps && this.sortProps.length > 0) {

        this.sortByProperties(this.sortProps, this.sortDirections, this.sortNormalizers);
    }

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    // return the object that was added
    return object;
},

//>    @method        array.addList()
// @include list.addList()
//<
// NOTE: implementation stolen by List interface.  Must use only List API for internal access.
addList : function (list, listStartRow, listEndRow) {
    if (list == null) return null;

    this._startChangingData();

    if (listStartRow == null) listStartRow = 0;
    if (listEndRow == null) listEndRow = list.getLength();

    for (var pos = listStartRow; pos < listEndRow; pos++) {
        this.add(list.get(pos));
    }

    this._doneChangingData();

    // return the objects that were added
    return list;
},

//>    @method        array.setLength()
// @include list.setLength()
//<
setLength : function (length) {
    this.length = length;
},

//>    @method        array.addListAt()
// @include list.addListAt()
//<
addListAt : function (list, pos) {
    if (list == null) return null;

    // copy items in the original array to their new position; copy backwards from last item to
    // item at pos, so that none of the items are overwritten
    for (var i = this.length - 1, l = list.length; i >= pos; i--) {
        this[i+l] = this[i];
    }

    // add the new items in list
    for (i = 0; i < l; i++) {
        this[i+pos] = list[i];
    }

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    // return the list that was added
    return list;
},


//>    @method        array.remove()
// @include list.remove()
//<
remove : function (obj) {


    var index = this.indexOf(obj);
    if (index == -1) return false;

    for (var i = index; i < this.length; i++) this[i] = this[i+1];
    this.length = this.length-1;

    this.dataChanged();

    return true; // indicating object was removed, per java.util.Collection
},

//>    @method        array.removeList()
// @include list.removeList()
//<
removeList : function (list) {
    if (list == null) return null;

    // run through all the items, putting things we want to retain into new list output
    for (var output = [], i = 0, l = this.length;i < l;i++) {
        if (!list.contains(this[i])) output.add(this[i]);
    }
    // now set the items in this list to the items in output
    this.setArray(output);

    // return the list that was removed
    return list;
},

// useful in chaining expressions eg someList.removeEvery(null).getProperty(...)
// .. removeList/removeAll don't work in this circumstance
removeEvery : function (value) {
    this.removeList([value]);
    return this;
},

// methods to ensure dataChanged() fired only once when a series of changes are made: see List.js
_startChangingData : function () {
    var undef;
    if (this._dataChangeFlag === undef) this._dataChangeFlag = 0;
    this._dataChangeFlag++;
},

_doneChangingData : function () {
    if (--this._dataChangeFlag == 0) this.dataChanged();
},

//>    @method        array.dataChanged()    (A)
// @include list.dataChanged()
//<
dataChanged : function () {

    if (this.onDataChanged) this.onDataChanged()
},

// In some cases we want to perform a one-liner - call dataChanged unless we're inside a data
// changing loop
_isChangingData : function () {
    return (this._dataChangeFlag != null && this._dataChangeFlag > 0);
},

// End of List API
// --------------------------------------------------------------------------------------------

//>    @method        array.setArray()
// Completely change the contents of one array to the contents of another array.
// <P>
// This is useful if you have an external pointer to an array, but you want to change its
// contents, such as when you remove some items from the array.
//
//        @group    dataChanged
//
//        @param    (array)        array to set this array to
//<
setArray : function (list) {
    // match length
    this.setLength(list.length);

    // fill slots
    for (var i = 0; i < list.length; i++) this[i] = list[i];

    // call dataChanged in case someone is observing data in the list
    this.dataChanged();
},

//>    @method        array.addAsList()
// Add either a single object or a list of items to this array.
//
//        @group    dataChanged
//
//        @param    list    (array or object)        a single object or a list of items to add
//
//        @return    (list)                list of items that were added
//<
addAsList : function (list) {
    if (!isc.isAn.Array(list)) list = [list];
    // return the objects that were added
    return this.addList(list);
},

//>    @method        array.removeRange()
// Remove and return a range of elements from an array - same return value as array.slice(),
// but removes the slice from the array
//
//        @group    dataChanged
//
//        @param    startPos    (number)    start position of range to remove
//      @param  endPos      (number)    end position of range to remove
//
//      @return (array) array of items that were removed
//<
removeRange : function (startPos, endPos) {
    // fall through to splice
    var undefined;
    if (startPos === undefined) return this;    // no arguments
    if (!isc.isA.Number(startPos)) startPos = 0;
    if (!isc.isA.Number(endPos)) endPos = this.length;
    return this.splice(startPos, endPos - startPos);
},

//>    @method        array.removeWhere()
//            Remove all instances of object from this array
//        @group    dataChanged
//
//        @param    property    (string)    property to look for
//        @param    value        (string)    value to look for
//<
removeWhere : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (!this[i] || this[i][property] != value) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

// Corollary to removeWhere - remove every item where some property is not set to some
// specified value.
removeUnless : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (this[i] && this[i][property] == value) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

//>    @method        array.removeEmpty()
//            Remove all empty slots in this array (where array[n] == null)
//        @group    dataChanged
//<
removeEmpty : function (property, value) {
    for (var i = 0, newList = []; i < this.length; i++) {
        if (this[i] != null) {
            newList.add(this[i]);
        }
    }
    this.setArray(newList);
},

//> @method array.getProperty()
// @include list.getProperty
// @visibility external
//<
getProperty : function (property) {
    for(var output = [], i = 0, l = this.length;i < l;i++)
        output[output.length] = (this[i] ? this[i][property] : null);
    return output;
},

//>@method array.getValueMap()
// @include list.getValueMap()
// @visibility external
//<
getValueMap : function (idField, displayField) {
    var valueMap = {};
    for (var i = 0, l = this.getLength(); i < l; i++) {
        var item = this.get(i);
        // Don't attempt to pull properties from empty values / basic data types in the list.
        if (!isc.isAn.Object(item)) continue;
        if (item && item[idField] != null) {
            valueMap[item[idField]] = item[displayField];
        }
    }
    return valueMap;
},

//>    @method        array.map()
// Return an array where the value of item <code>i</code> is the result of calling the provided
// function on item <code>i</code> in this array.
// <P>
// The function to call can either be provided directly as a function object, in which case it
// is invoked with the item as the first argument, or can be provided as the String name of a
// method present on each item, which will be invoked.  In the latter case, if any item is null
// or lacks the named method, null will be returned for that item.
// <P>
// Examples:<PRE>
//    // line up widgets at 20 pixels from page edge
//    [widget1, widget2].map("setPageLeft", 20);
//
//    // find furthest right widget
//    [widget1, widget2].map("getPageRight").max();
// </PRE>
//
//        @group    iteration
//
//        @param    method  (string or function) function object, or name of method
//        @param    [(arguments 1-N)]    (any)     arguments to pass to the function or method
//                                           invoked on each item
//        @return    (array)        array of returned values
// @visibility external
//<
map : function (method, arg1, arg2, arg3, arg4, arg5) {
    var O = Object(this),
        isFunc = isc.isA.Function(method);

    var undef,
        mimicNativeImp = isFunc &&
                        (arg1 === undef || isc.isAn.Object(arg1)) &&
                         arg2 === undef && arg3=== undef && arg4 === undef && arg5 === undef;

    var length;
    if (mimicNativeImp) {
        length = O.length >>> 0;
    } else {
        length = O.getLength();
    }

    var output = new Array(length);
    for (var i = 0; i < length; ++i) {
        var item;

        if (mimicNativeImp) {
            item = O[i];
            output[i] = method.call(arg1, item, i, O);

        } else {
            item = O.get(i);
            if (isFunc) {
                output[i] = method(item, arg1, arg2, arg3, arg4, arg5);
            } else {
                output[i] = (item && item[method] != null ?
                             item[method](arg1, arg2, arg3, arg4, arg5) : null);
            }
        }
    }
    return output;
},

//>    @method        array.setProperty()
//    Set item[property] = value for each item in this array.
//        @group    iteration
//
//        @param    property    (string)    name of the property to set
//        @param    value        (any)        value to set to
// @visibility external
//<
setProperty : function (property, value) {
    for(var i = 0, l = this.length;i < l;i++)
        if (this[i]) this[i][property] = value;
},

//>    @method        array.clearProperty()
// Delete property in each item in this array.
//        @group    iteration
//
//        @param    property     (string)    name of the property to clear
// @return (boolean) returns true if any of the properties in the array had a value for the
//     specified property.
// @visibility external
//<
clearProperty : function (property) {
    var hadValue = false, undef;
    for(var i = 0, l = this.length;i < l;i++) {
        hadValue = hadValue || this[i] !== undef;
        if (this[i]) delete this[i][property];
    }
    return hadValue;
},

//>    @method        array.getProperties()
// Return a copy of the array where each object has only the list of properties provided.
//        @group    iteration
//
//        @param    properties    (string[])    names of the properties you want to export
//                            (object)    object with the properties you want to export
//
//        @return    (Array)        new Array with each item limited to the specified properties
//<
getProperties : function (properties) {
    return isc.applyMask(this, properties);
},

//>    @method        array.getUniqueItems()
// Return a list of each unique item in this list exactly once.
// <P>
// Returns in the same order they were found in the list.
// <P>
// Usage example:<br>
// &nbsp;&nbsp;&nbsp;&nbsp;uniqueList = myArray.getProperty("foo").getUniqueItems();
//
//        @group    subset
//
//        @return    (array)    list of each unique item in the list
// @visibility external
//<
getUniqueItems : function () {
    for (var output = [], i = 0, l = this.length; i < l; i++) {
        if (!output.contains(this[i])) output[output.length] = this[i];
    }
    return output;
},

//>    @method        array.slice()
// Return a contiguous range of rows of the array.
// DOES NOT include element at position <code>end</code> (similar to .substring())
// <P>
// NOTE: uses browser's native implementation if one is provided
//
// @param    start    (number)    start index
// @param    [end]    (number)    end index, if not specified will be list.length
//
// @return    (array)    new array with items from start -> end-1 in it
// @group    subset
//<
slice :
    (Array.prototype.slice
        ? Array.prototype.slice
        : function (start, end) {
            if (end == null) end = this.length;
            for(var output = [], l = this.length; start < end && start < l;start++)
                output[output.length] = this[start];
            return output;
        }
    ),

//>    @method array.findIndex()
// @include list.findIndex
//<
findIndex : function (property, value, comparator) {
    return this.findNextIndex(0, property, value, null, comparator);
},

//>    @method array.findNextIndex()
// @include list.findNextIndex
//<
findNextIndex : function (start, property, value, endPos, comparator) {
    if (start == null) start = 0;
    else if (start >= this.length) return -1;
    if (endPos == null) endPos = this.length - 1;

    if (property == null) return -1;

    var up = endPos >= start;

    if (isc.isA.String(property)) {
        // single property to match
        if (comparator) {
            for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
                if (this[i] && comparator(this[i][property], value, property)) return i;
            }
        } else {
            for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
                if (this[i] && this[i][property] == value) return i;
            }
        }
        return -1;


    } else if (isc.isA.Function(property)) {
        for (var i = start; (up ? i <= endPos : i >= endPos) ; (up ? i++ : i--)) {
            if (property(this[i])) return i;
        }
        return -1;
    } else {
        // "property" is an object specifying a set of properties to match
        return this.findNextMatch(property, start, endPos, comparator);
    }
},

findAllIndices : function (property, value, comparitor) {
    var matches = [];
    var start = 0;
    var match;
    do {

        match = this.findNextIndex(start, property, value, null, comparitor);
        if (match != -1) {
            matches.add(match);
            start = match+1;
        }

    } while (match != -1);
    return matches;
},

// internal: assumes multiple properties
findNextMatch : function (properties, start, end, comparator) {
    if (properties._constructor == "AdvancedCriteria") {
        if (isc.DataSource == null) {
            isc.warn("DataBinding module not loaded, AdvancedCriteria not supported for find()/findAll()");
            return -1;
        }
        var dataSource = this.dataSource || isc.DataSource;
        var result = dataSource.applyFilter(this.getRange(start, end + 1), properties);
        if (result.size() != 0) return this.findIndex(result.get(0));
        else return -1;
    }

    var propertyNames = isc.getKeys(properties),
        up = end >= start;

    // This processing is largely duplicated, to avoid a check on comparator in the inner loop
    if (comparator) {
        var isObject = isc.isAn.Object(comparator);
        for (var i = start; (up ? i <= end : i >= end); (up ? i++ : i--)) {
            var item = this.get(i);
            if (!item) continue;
            var found = true;
            for (var j = 0; j < propertyNames.length; j++) {
                var propertyName = propertyNames[j];
                if (isObject && comparator[propertyName] != null) {
                    if (!comparator[propertyName](item[propertyName], properties[propertyName], propertyName)) {
                        found = false;
                        break;
                    }
                } else if (!comparator(item[propertyName], properties[propertyName], propertyName)) {
                    found = false;
                    break;
                }
            }
            if (found) return i;
        }
    } else {
        for (var i = start; (up ? i <= end : i >= end); (up ? i++ : i--)) {
            var item = this.get(i);
            if (!item) continue;
            var found = true;
            for (var j = 0; j < propertyNames.length; j++) {
                var propertyName = propertyNames[j];
                if (item[propertyName] != properties[propertyName]) {
                    found = false;
                    break;
                }
            }
            if (found) return i;
        }
    }
    return -1;
},

//>    @method array.find()
// @include list.find
//<
find : function (property, value, comparator) {
    var index = this.findIndex(property, value, comparator);
    return (index != -1) ? this.get(index) : null;
},

// given values for the primary key fields ("record"), find the _index of_ the unique
// matching record.
// Will automatically trim extra, non-key fields from "record"
findByKeys : function (record, dataSource, pos, endPos, comparator) {
    if (record == null) {
        //>DEBUG
        isc.Log.logWarn("findByKeys: passed null record");
        //<DEBUG
        return -1;
    }

    // get the values for all the primary key fields from the passed record
    var findKeys = {},
        keyFields = dataSource.getPrimaryKeyFields(),
        hasKeys = false,
        comparators = comparator ? null : {}
    ;

    for (var keyField in keyFields) {
        hasKeys = true;
        var r = record[keyField];
        if (r == null) {
            //>DEBUG
            isc.Log.logWarn("findByKeys: passed record does not have a value for key field '"
                         + keyField + "'");
            //<DEBUG
            return -1;
        }
        findKeys[keyField] = r;
        if (comparators && isc.isAn.Object(r)) {

            comparators[keyField] = isc.DynamicForm.compareValues;
        }
    }

    if (!hasKeys) {
        //>DEBUG
        isc.Log.logWarn("findByKeys: dataSource '" + dataSource.ID + "' does not have primary " +
                     "keys declared, can't find record");
        //<DEBUG
        return -1;
    }

    if (isc.getKeys(comparators).length > 0) comparator = comparators;

    // go through the recordSet looking for a record with the same values for the primary keys
    return this.findNextIndex(pos, findKeys, null, endPos, comparator);
},

//>    @method        array.containsProperty()
//  Determine whether this array contains any members where the property passed in matches the value
//  passed in.
//
//        @group    find
//        @param    property    (string)    property to look for
//                            (object)    key:value pairs to look for
//        @param    [value]        (any)        value to compare against (if property is a string)
//
//        @return    (boolean)   true if this array contains an object with the appropriate property value
// @visibility external
//<
containsProperty : function (property, value) {
    var index = this.findIndex(property, value);
    return (index != -1);
},

//>    @method array.findAll()
// @include list.findAll
//<
findAll : function (property, value, comparator) {

    if (property == null) return null;

    if (isc.isA.String(property)) {
        var matches = null,
            l = this.length;

        // single property to match
        var multiVal = isc.isAn.Array(value),
            hasComparator = (comparator != null);
        for (var i = 0; i < l; i++) {
            var item = this[i];
            if (item && (multiVal ?
                    value.contains(item[property], null, comparator) :
                    (hasComparator ?
                        comparator(item[property], value) :
                        item[property] == value)))
            {
                if (matches == null) matches = [];
                matches.add(item);
            }
        }
        return matches;


    } else if (isc.isA.Function(property)) {
        var matches = null,
            l = this.length,
            iterator = property,
            context = value;

        for (var i = 0; i < l; i++) {
            var item = this[i];
            if (iterator(item, context)) {
                if (matches == null) matches = [];
                matches.add(item);
            }
        }
        return matches;
    } else {
        // "property" is an object specifying a set of properties to match
        return this.findAllMatches(property, comparator);
    }
},

// internal: assumes multiple properties
findAllMatches : function (properties, comparators) {
    var l = this.getLength(),
        propertyNames = isc.getKeys(properties),
        matches = null,
        hasComparators = (comparators != null),
        singleComparator = (hasComparators && !isc.isAn.Object(comparators) && comparators);

    if (properties._constructor == "AdvancedCriteria") {
        if (isc.DataSource == null) {
            isc.warn("DataBinding module not loaded, AdvancedCriteria not supported for find()/findAll()");
            return -1;
        }
        var dataSource = this.dataSource || isc.DataSource;
        return dataSource.applyFilter(this.getRange(0, this.getLength() + 1), properties);
    }
    for (var i = 0; i < l; i++) {
        var item = this.get(i);
        if (!item) continue;
        var found = true;
        for (var j = 0; j < propertyNames.length; j++) {
            var propertyName = propertyNames[j],
                comparator = (hasComparators && (singleComparator || comparators[propertyName])),
                itemValue = item[propertyName],
                propertiesValue = properties[propertyName];
            if (comparator ?
                !comparator(itemValue, propertiesValue) :
                (itemValue != propertiesValue))
            {
                found = false;
                break;
            }
        }
        if (found) {
            if (matches == null) matches = [];
            matches.add(item);
        }
    }
    return matches;
},

//>    @method        array.slide()    (A)
// Slide element at position start to position destination, moving all the other elements to cover
// the gap.
//
//        @param    start        (number)    start position
//        @param    destination    (number)    destination position for this[start]
// @visibility external
//<
slide : function (start, destination) {
    this.slideRange(start, start+1, destination);
},

//>    @method        array.slideRange()    (A)
// Slide a range of elements from start to end to position destination, moving all the other
// elements to cover the gap.
//
//        @param    start        (number)    start position
//        @param    end         (number)    end position (exclusive, like substring() and slice())
//        @param    destination    (number)    destination position for the range
// @visibility external
//<
slideRange : function (rangeStart, rangeEnd, destination) {
    // remove the range to be moved
    var removed = this.splice(rangeStart, rangeEnd - rangeStart);
    // and add it at the destination
    this.addListAt(removed, destination);
},

//>    @method        array.slideList()    (A)
// Slide the array of rows list to position destination.
//
//        @param    start        (number)    start position
//        @param    destination    (number)    destination position for this[start]
//<
slideList : function (list, destination) {
    var output = [],
        i
    ;

//XXX if destination is negative, set to 0 (same effect, cleaner code below)
if (destination < 0) destination = 0;

    // take all the things from this table before destination that aren't in the list to be moved
    for(i = 0;i < destination;i++)
        if (!list.contains(this[i]))
            output.add(this[i]);

    // now put in all the things to be moved
    for(i = 0;i < list.length;i++)
        output.add(list[i]);

    // now put in all the things after destination that aren't in the list to be moved
    for(i = destination;i < this.length;i++)
        if (!list.contains(this[i]))
            output.add(this[i]);

    // now copy the reordered list back into this array
    this.setArray(output);
},

//>    @method        array.makeIndex()    (A)
// Make an index for the items in this Array by a particular property of each item.
// <P>
// Returns an Object with keys for each distinct listItem[property] value.  Each key will point
// to an array of items that share that property value.  The sub-array will be in the same order
// that they are in this list.
//
//        @param    property        (strings)            names of the property to index by
//        @param    alwaysMakeArray    (boolean : false)
//              if true, we always make an array for every index.  if false, we make an Array only
//              when more than one item has the same value for the index property
//        @return    (object)                    index object
// @visibility external
//<
// NOTE: we don't document the awkard -1 param to allow collisions
makeIndex : function (property, alwaysMakeArray, useIndexAsKey) {
    var index = {};
    var allowCollisions = (alwaysMakeArray == -1);
    alwaysMakeArray = (alwaysMakeArray != null && alwaysMakeArray != 0);
    for (var i = 0; i < this.length; i++) {
        var item = this[i],
            key = item[property]
        ;

        // if the item has no value for the key property
        if (key == null) {
            // either skip it..
            if (!useIndexAsKey) continue;
            // or place it in the index under its position in the array
            key = i;
        }

        if (allowCollisions) {
            index[key] = item;
            continue;
        }

        var existingValue = index[key];
        if (existingValue == null) {
            if (alwaysMakeArray) {
                // every entry should be an array
                index[key] = [item];
            } else {
                index[key] = item;
            }
        } else {
            if (alwaysMakeArray) {
                // any non-null value is an array we created the first time we found an item
                // with this key value
                index[key].add(item);
            } else {
                // if the existing value is an array, add to it, otherwise put the new and old
                // value together in a new array
                if (isc.isAn.Array(existingValue)) {
                    index[key].add(item);
                } else {
                    index[key] = [existingValue, item];
                }
            }
        }
    }

    return index;
},


//>    @method        array.arraysToObjects()    (A)
// Map an array of arrays to an array of objects.
// <P>
// Each array becomes one object, which will have as many properties as the number of property
// names passed as the "propertyList".  The values of the properties will be the values found
// in the Array, in order.
// <P>
// For example:
// <pre>
//    var arrays = [
//       ["Mickey", "Mouse"],
//       ["Donald", "Duck"],
//       ["Yosemite", "Sam"]
//    ];
//    var objects = arrays.arraysToObjects(["firstName", "lastName"]);
// </pre>
// <code>objects</code> is now:
// <pre>
//    [
//       { firstName:"Mickey", lastName:"Mouse" },
//       { firstName:"Donald", lastName:"Duck" },
//       { firstName:"Yosemite", lastName:"Sam" }
//    ]
// </pre>
//
//        @param    propertyList    (Array of String)        names of the properties to assign to
//
//        @return    (Array of Object)        corresponding array of objects
//<
arraysToObjects : function (propertyList) {
    // get the number of properties we're dealing with
    var propLength = propertyList.length;
    // for each item in this array
    for (var output = [], i = 0, l = this.length; i < l; i++) {
        // make a new object to hold the output
        var it = output[i] = {};
        // for each property in the propertyList list
        for (var p = 0; p < propLength; p++) {
            var property = propertyList[p];
            // assign that item in the array to the proper name of the new object
            it[property] = this[i][p];
        }
    }
    // return the list that was generated
    return output;
},

//>    @method        array.objectsToArrays()    (A)
// Map an array of objects into an array of arrays.
// <P>
// Each object becomes one array, which contains the values of a list of properties from
// the source object.
// <P>
// For example:
// <pre>
//    var objects = [
//       { firstName:"Mickey", lastName:"Mouse" },
//       { firstName:"Donald", lastName:"Duck" },
//       { firstName:"Yosemite", lastName:"Sam" }
//    ]
//    var arrays = objects.objectsToArrays(["firstName", "lastName"]);
// </pre>
// <code>arrays</code> is now:
// <pre>
// [
//    ["Mickey", "Mouse"],
//    ["Donald", "Duck"],
//    ["Yosemite", "Sam"]
// ]
// </pre>
//
//        @param    propertyList    (Array of String)        names of the properties to output
//
//        @return    (Array of Object)        corresponding array of arrays
//<
objectsToArrays : function (propertyList) {
    // get the number of properties we're dealing with
    var propLength = propertyList.length;
    // for each item in this array
    for (var output = [], i = 0, l = this.length; i < l; i++) {
        // make a new object to hold the output
        var it = output[i] = [];
        // for each property in the propertyList list
        for (var p = 0; p < propLength; p++) {
            var property = propertyList[p];
            // assign that item in the array to the proper name of the new object
            it[p] = this[i][property];
        }
    }
    // return the list that was generated
    return output;
},


_MAX_APPLY_ARGCOUNT: 65535,

//>    @method        array.spliceArray()
//             Like array.splice() but takes an array (to concat) as a third parameter,
//          rather than a number of additional parameters.
//
//        @param    startPos    (number)        starting position for the splice
//      @param  deleteCount (number)        Number of elements to delete from affected array
//      @param  newArray    (any[])         Array of elements to splice into existing array
//
//        @return    (any[])        array of removed elements
//<
spliceArray : function (startPos, deleteCount, newArray) {

    var undefined;

    if (startPos === undefined) return this.splice();
    if (deleteCount === undefined) return this.splice(startPos);
    if (newArray === undefined) return this.splice(startPos, deleteCount);
    if (!isc.isAn.Array(newArray)) {
        isc.Log.logWarn("spliceArray() method passed a non-array third parameter. Ignoring...", "Array");
        return this.splice(startPos, deleteCount);
    }


    if (newArray.length + 2 <= this._MAX_APPLY_ARGCOUNT) {
        return this.splice.apply(this, [startPos, deleteCount].concat(newArray))
    }

    // extract tail of this array, from startPos through end
    var tail = this.splice(startPos, this.length - startPos);

    // add the elements from newArray at startPos
    newArray.forEach(function(value, index) {this[startPos + index] = value;}, this);

    var deleted = [];
    if (deleteCount < 0) deleteCount = 0;

    // add back the tail, less any deleted items, and build deleted list result
    var tailPos = startPos + newArray.length - deleteCount;
    tail.forEach(function(value, index) {
        if (index < deleteCount) deleted[index]= value;
        else              this[tailPos + index]= value;
    }, this);

    return deleted;
},

// stack peek method - returns the top item on the stack without removing it.
peek : function () {
    var item = this.pop();
    this.push(item);
    return item;
},

// see ResultSet.getCachedRow()
getCachedRow : function (rowNum) {
    return this[rowNum];
},

//
// ----------------------------------------------------------------------------------
// add the observation methods to the Array.prototype as well so we can use 'em there
//

observe: isc.Class.getPrototype().observe,
ignore : isc.Class.getPrototype().ignore,

// Synonyms and backcompat
// --------------------------------------------------------------------------------------------

    //>!BackCompat 2004.6.15 for old ISC names
    removeItem : function (pos) { return this.removeAt(pos) },
    getItem : function (pos) { return this.get(pos) },
    setItem : function (pos) { return this.set(pos) },
    // NOTE: instead of calling clearAll(), setLength(0) should be called (which is much more
    // efficient), however clearAll() still exists to support the old behavior of returning the
    // removed items.
    clearAll : function (list) { return this.removeList(this) },
    //<!BackCompat

    // Support for java.util.List API
    size : function () { return this.getLength() },
    subList : function (start, end) { return this.getRange(start, end) },
    addAll : function (list) { return this.addList(list); },
    removeAll : function (list) {
        var origLength = this.getLength();
        this.removeList(list);
        return this.getLength() != origLength; // return whether list was changed
    },
    clear : function () { this.setLength(0); },
    toArray : function () { return this.duplicate(); }
    // NOTE: incomplete compatibility:
    // - no iterators.  This exists in Java largely for concurrent modification reasons.
    // - remove(int): in Java, the collision between remove(int) and remove(object) is
    //   implemented by method overloading.  In JS, we assume if you pass a number you want
    //   removal by index, but this means remove(5) cannot be used to remove the first instance
    //   of the number 5 from our List.
    // - retainAll: not yet implemented.  Similar to intersect, except the Java version
    //   requires the List to change in place instead of returning the intersection, in order
    //   to preserve the target List's class.
    // - toArray(): in Java, this means go to a native, non-modifiable Array

});

// Fixes to splice() in older browsers.




//>IE8
// filter() doesn't exist in IE <= 8
if (Array.prototype.filter == null) {

    isc.addMethods(Array.prototype, {

        filter : function (callback, thisObject) {
            var result = [],
                initialLength = this.length; // scan original elements only
            for (var i = 0; i < initialLength; i++) {
                // skip positions for which no elements have been defined
                if (i in this && callback.call(thisObject, this[i])) {
                    result.add(this[i]);
                }
            }
            return result;
        }
    });

}
// forEach() doesn't exist in IE <= 8
if (Array.prototype.forEach == null) {

    isc.addMethods(Array.prototype, {

        forEach : function (callback, thisObject) {
            var length = this.length;
            for (var i = 0; i < length; i++) {
                if (i in this) {
                    callback.call(thisObject, this[i], i, this)
                }
            }
        }
    });

}
//<IE8
/*
    Isomorphic SmartClient web presentation layer
    Copyright 2000 and beyond Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.

    If you have any questions, please email <sourcecode@isomorphic.com>.

    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/



//> @class NumberUtil
// Static singleton class containing APIs for interacting with Numbers.
// @visibility external
//<
isc.defineClass("NumberUtil");

isc.NumberUtil.addClassProperties({

_jsDecimalSymbol : ".",

//> @classAttr NumberUtil.decimalSymbol (String : "." : IR)
// The decimal symbol to use when formatting numbers
// @group i18nMessages
// @visibility external
//<
decimalSymbol : ".",

//> @classAttr NumberUtil.groupingSymbol (String : "," : IR)
// The grouping symbol, or thousands separator, to use when formatting numbers
// @group i18nMessages
// @visibility external
//<
groupingSymbol : ",",

//> @classAttr NumberUtil.negativeSymbol (String : "-" : IR)
// The negative symbol to use when formatting numbers
// @group i18nMessages
// @visibility external
//<
negativeSymbol : "-",

//> @classAttr NumberUtil.currencySymbol (String : "$" : IR)
// The currency symbol to use when formatting numbers
// @group i18nMessages
// @visibility external
//<
currencySymbol : "$",

//> @classAttr NumberUtil.negativeFormat (Number : 1 : IR)
// The format to use when formatting nagative numbers.  Supported values are: 1 = before,
// 2 = after, 3 = beforeSpace, 4 = afterSpace, 5 = parens
// @group i18nMessages
// @visibility external
//<
negativeFormat : 1,

//> @classAttr NumberUtil.groupingFormat (Number : 1 : IR)
// The grouping-format for numbers
// @group i18nMessages
// @visibility external
//<
groupingFormat : 1, // 0 = none; 1 = 123,456,789; 2 = 12,34,56,789


//> @classMethod NumberUtil.setStandardFormatter()
// Set the standard "toString()" formatter for Number objects.
// After this call, all <code>numberUtil.toString()</code>  calls will yield a number
// in this format.
//
// @param functionName (string) name of a formatting function on the number object prototype
// @group stringProcessing
//<
setStandardFormatter : function (functionName) {
    if (isc.isA.Function(isc.NumberUtil[functionName]))
        isc.NumberUtil.formatter = functionName;
},

//> @classMethod NumberUtil.setStandardLocaleStringFormatter()
// Set the standard locale formatter for all Number objects.
// After this call, all  <code>isc.iscToLocaleString(number)</code> for number instances
// calls will yield the string returned by the formatter specified.
//
// @param functionName (string) name of a formatting function (on number instances)
// @group stringProcessing
//<
setStandardLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(isc.NumberUtil[functionName]))
        isc.NumberUtil.localeStringFormatter = functionName;
},

_1zero : "0",
_2zero : "00",
_3zero : "000",
_4zero : "0000",

_getZeroString : function (length) {
    if (length <= 0) return;

    var nu = isc.NumberUtil,
        pad
    ;
    // with > 4 zeros (very rare), build up a leading pad 4 0's at a time
    while (length > 4) {
        if (pad == null) pad = nu._4zero;
        else pad += nu._4zero;
        length -= 4;
    }

    var finalPad;
    switch (length) {
        case 4: finalPad = nu._4zero; break;
        case 3: finalPad = nu._3zero; break;
        case 2: finalPad = nu._2zero; break;
        case 1: finalPad = nu._1zero; break;
    }

    // no leading pad (less than 4 zeros total)
    if (pad == null) return finalPad;
    return pad + finalPad;
},

// Remove any exponent from a the formatted number, adding zeros where
// necessary while preserving the precision represented in the string.
_expandExponent : function (formattedNumber) {

    return formattedNumber.replace(/^([+-])?(\d+).?(\d*)[eE]([-+]?\d+)$/,

        // Search for an exponential in the formatted number, matching four groups:
        //     sign, natural, fraction, coeffcient
        //
        //     sign        = sign of the number
        //     natural     = integer part of significand (a natural number since no sign)
        //     fraction    = fractional part of significand
        //     coefficient = coefficient of number, including sign

        function(matchedString, sign, natural, fraction, coefficient){

            // We define the following variables
            //     lessThanOne           - whether number's absolute value is less than one
            //     normalizedCoefficient - coefficient normalized for the number of digits in
            //                             natural, integer part of the significand (off by one);
            //                             this abstractly represents the total number of digits
            //                             (including any added zeros) to the left of the
            //                             decimal point in the final formatted number
            //     digitsToCross         - when moving the decimal point left or right from its
            //                             place in the significand to remove the exponential,
            //                             the number of digits from the signficand that will
            //                             be crossed (excluding zeros added by our own logic)

            var lessThanOne = +coefficient < 0,
                normalizedCoefficient = natural.length + (+coefficient),
                digitsToCross = (lessThanOne ? natural : fraction).length;

            // Now, build a string of zeros whose length is determined by the absolute value
            // of the coefficient, less the number of digits to cross; this is the number of
            // zeros needed to separate the number from the decimal point.

            coefficient = Math.abs(coefficient);

            var nZeros = coefficient >= digitsToCross ?
                         coefficient - digitsToCross + lessThanOne : 0,
                zeros = nZeros > 0 ? isc.NumberUtil._getZeroString(nZeros) : "";

            // Form the significand (joining both parts together), and attach zeros
            var significand = natural + fraction;
            if (lessThanOne) significand  = zeros + significand;
            else             significand += zeros;

            // If absolute value of number is less than one, offset the
            // normalized coefficient by the number of zeros.
            if (lessThanOne) normalizedCoefficient += zeros.length;

            // Output the digits to the left of the decimal point; we may be done
            var result = (sign || "") + significand.substr(0, normalizedCoefficient);

            // If not, add the remaining fractional digits to the right of the decimal
            if (normalizedCoefficient < significand.length) {
                result += "." + significand.substr(normalizedCoefficient);
            }
            return result;
        });
},

//> @classMethod NumberUtil.stringify()
// Return the passed number as a string padded out to digits length.
//
// @param number (number) Number object to stringify
// @param [digits] (number) Number of digits to pad to.  (Default is 2)
// @return (string) Padded string version of the number
//
// @example var str = isc.NumberUtil.stringify(myNumberVar, 2);
// @group stringProcessing
// @visibility external
//<

stringify : function (number, totalDigits, predecimal) {
    if (!isc.isA.Number(number)) return "";


    return isc.NumberUtil._stringify(totalDigits, predecimal, number);
},

_stringify : function (totalDigits, predecimal, number) {
    if (number == null) number = this;
    // default to 2 digits
    if (!totalDigits) totalDigits = 2;

    var numberString = number.toString(),
        zeroes = totalDigits - numberString.length
    ;

    // predecimal: ignore any decimal digits, such that two numbers with differing decimal
    // precision get the same total number of characters before the decimal.
    if (predecimal) {
        var dotIndex = numberString.indexOf(isc.dot);
        if (dotIndex != -1) {
            zeroes += (numberString.length - dotIndex);
        }
    }
    var pad = isc.NumberUtil._getZeroString(zeroes);

    if (pad == null) return numberString;
    return pad + numberString;
},

//> @classMethod NumberUtil.toCurrencyString()
// Return the passed number as a currency-formatted string, or an empty string if not passed a
// number.
//
// @param number (Number) the number to convert
// @param [currencyChar] (string) Currency symbol, default taken from the locale and can be
//                                set to an empty string. If not passed and missing from the
//                                locale, defaults to <code>"$"</code>.
// @param [decimalChar] (string) Decimal separator symbol, default taken from the locale. If
//                                if not passed and missing from the locale, defaults to
//                                <code>"."</code>.
// @param [padDecimal] (boolean) Should decimal portion be padded out to two digits? True
//                               by default.
// @param [currencyCharLast] (boolean) Should the currency symbol be shown at the end of the
//                                      string?  If unspecified, it will prefix the number.
// @return (string) Currency-formatted string version of the number
// @group stringProcessing
// @visibility external
//<
toCurrencyString : function (number, currencyChar, decimalChar, padDecimal, currencyCharLast) {
    if (!isc.isA.Number(number)) return "";


    return isc.NumberUtil._toCurrencyString(currencyChar, decimalChar, padDecimal, currencyCharLast, number)
},

_toCurrencyString : function (currencyChar, decimalChar, padDecimal, currencyCharLast, number) {
    if (number == null) number = this;

    var negative = number < 0,
        wholeNumber = number < 0 ? Math.ceil(number) : Math.floor(number),
        decimalNumber = Math.abs(Math.round((number - wholeNumber)*100)),
        output = isc.StringBuffer.create()
    ;

    wholeNumber = Math.abs(wholeNumber);

    // default currency/decimal symbols and decimal padding on
    // allow empty string for no currency character
    currencyChar = currencyChar || isc.NumberUtil.currencySymbol || "$";
    decimalChar = decimalChar || isc.NumberUtil.decimalSymbol || ".";
    if (padDecimal == null) padDecimal = true;

    // output sign

    if (negative) output.append(isc.NumberUtil.negativeSymbol || "-");

    // output currency symbol first by default
    if (currencyCharLast != true) output.append(currencyChar);

    // output whole number
    output.append(wholeNumber.stringify(1));

    // output decimal symbol and decimal number
    // (unless padding is off and decimal portion is 0)
    if (padDecimal) {
        output.append(decimalChar);
        output.append(decimalNumber.stringify(2));
    } else if (decimalNumber != 0) {
        output.append(decimalChar);
        if (decimalNumber % 10 == 0) output.append(decimalNumber/10);
        else output.append(decimalNumber.stringify(2));
    }

    // output currency symbol last if specified
    if (currencyCharLast == true) output.append(currencyChar);

    return output.toString();
},

//> @classMethod NumberUtil.toLocalizedString()
//  Format the passed number for readability, with:
//  <ul>
//      <li>separators between three-digit groups</li>
//      <li>optional fixed decimal precision (so decimal points align on right-aligned numbers)</li>
//      <li>localized decimal, grouping, and negative symbols</li>
//  </ul>
//  +link{NumberUtil.decimalSymbol, Decimal symbol},
//  +link{NumberUtil.groupingSymbol, grouping symbol}, and
//  +link{NumberUtil.negativeSymbol, negative symbol} will normally come from
//  SmartClient locale settings (which may come from either client OS or application locale
//  settings), but they are also supported as arguments for mixed-format applications
//  (eg normalize all currency to +link{NumberUtil.toUSCurrencyString, US format}, but use the
// current locale format for other numbers).
//
//  @param number (Number) the number object to convert
//  @param [decimalPrecision] (number) decimal-precision for the formatted value
//  @param [decimalSymbol] (string) the symbol that appears before the decimal part of the number
//  @param [groupingSymbol] (string) the symbol shown between groups of 3 non-decimal digits
//  @param [negativeSymbol] (string) the symbol that indicate a negative number
//  @return (string) formatted number or empty string if not passed a number.
//  @visibility external
//<

toLocalizedString : function (number, decimalPrecision, decimalSymbol, groupingSymbol, negativeSymbol) {
    if (!isc.isA.Number(number)) return "";

    var roundedValue = !decimalPrecision ? number :
            Math.round(number * Math.pow(10, decimalPrecision)) / Math.pow(10, decimalPrecision);
    var absNum = Math.abs(roundedValue), // remove sign for now; deal with it at the very end of this method
        wholeNum = Math.floor(absNum), // whole part of the number (no decimal)
        wholeString, // string representation of whole part, before formatting
        decimalString, // string representation of decimal part, after formatting (padding)
        wholeChunks = []; // chunks of the whole number, based on 3-digit groupings

    // decimal part - doing this first because this code may round the whole part
    if (decimalPrecision) {
        // decimalPrecision specified and > 0, so
        // round/pad the decimal part to the specified number of digits
        var decimalNum = Math.round( (absNum-wholeNum) * Math.pow(10,decimalPrecision) );
        decimalString = isc.NumberUtil._stringify(decimalPrecision, null, decimalNum); // NOTE: stringify() could use a better name
    } else if (decimalPrecision == 0) {
        // decimalPrecision of 0 explicitly specified, so
        // round the whole number and drop the decimal part entirely
        wholeNum = Math.round(absNum);
    } else {
        // decimalPrecision not specified, so show the decimal part if there is one
        if (absNum-wholeNum > 0) {
            //  PRECISION ERROR - the next line of code introduces noise that makes a very long decimal part,
            //  e.g. 1.1 becomes 1.10000000000000009 - what causes this? some int to float conversion?
            //            decimalString = (absNum-wholeNum).toString().substring(2); // drops the leading "0."
            //  So using this alternate approach - just split the toString() on the decimal point
            //  and take the decimal part
            var absString = absNum.toString();
            decimalString = absString.substring(absString.indexOf(isc.NumberUtil._jsDecimalSymbol)+1);
        }
    }

    // whole part - slice it into chunks to be joined with grouping symbols
    wholeString = wholeNum.toString();
    var wholeLength = wholeString.length;
    var tripletCount = Math.floor(wholeLength/3); // number of complete chunks of 3 digits
    if (wholeLength%3) {
        // start with the incomplete chunk (first 1 or 2 digits) if any
        wholeChunks[0] = wholeString.substr(0, wholeLength%3);
    }
    for (var i=0; i<tripletCount; i++) {
        // then slice out each chunk of 3 digits
        wholeChunks[wholeChunks.length] = wholeString.substr(wholeLength%3 + i*3, 3);
    }

    // assembly - join the chunks of the whole part with grouping symbols, and glue together
    // the whole part, decimal symbol, decimal part, and negative sign as appropriate
    var outputString = wholeChunks.join(groupingSymbol || isc.NumberUtil.groupingSymbol);
    if (decimalString) outputString = outputString + (decimalSymbol || isc.NumberUtil.decimalSymbol) + decimalString;
    if (roundedValue < 0) outputString = (negativeSymbol || isc.NumberUtil.negativeSymbol) + outputString;
    return outputString;
},

// same as toLocalizedString but handles extra zeroes using decimalPrecision and decimalPad values
floatValueToLocalizedString : function (number, decimalPrecision, decimalPad) {
    if (!decimalPad) decimalPad = 0;
    var res = isc.NumberUtil.toLocalizedString(number, decimalPrecision);
    var decIndx = res.indexOf(isc.NumberUtil.decimalSymbol);
    var zeroesToAdd = 0;
    if (decIndx < 0) {
        if (decimalPad == 0) return res;
        zeroesToAdd = decimalPad;
        // no decimalSymbol were found, so we adding one
        res += isc.NumberUtil.decimalSymbol;
    } else {
        zeroesToAdd = decimalPad - (res.length - decIndx - 1);
    }
    if (zeroesToAdd > 0) {
        // add zeroes to the end according decimalPad value
        res += new Array(zeroesToAdd + 1).join('0');
    } else if (zeroesToAdd < 0) {
        // all extra zeroes should be removed
        for (var i = (res.length - 1); i>(decIndx + decimalPad); i--) {
            if (res[i] != '0' && res[i] != isc.NumberUtil.decimalSymbol) break;
        }
        // remove decimalSymbol if is the last one
        if (res[i] == isc.NumberUtil.decimalSymbol) i--;
        res = res.substr(0, i + 1);
    }
    return res;
},

//> @classMethod NumberUtil.toUSString()
//  Format the passed number as a US string.  Returns empty string if not passed a number.
//
//  @param number (Number) the number object to format
//  @param [decimalPrecision] (number)
//  @return (string) formatted number or empty string if not passed a number
//  @visibility external
//<
toUSString : function(number, decimalPrecision) {
    if (!isc.isA.Number(number)) return "";
    return isc.NumberUtil.toLocalizedString(number, decimalPrecision, ".", ",", "-");
},

//> @classMethod NumberUtil.toUSCurrencyString()
//  Format the passed number as a US Dollar currency string. Returns empty string if not passed
// a number.
//
//  @param number (Number) the number object to format
//  @param [decimalPrecision] (number)
//  @return (string) formatted number
//  @visibility external
//<
toUSCurrencyString : function(number, decimalPrecision) {
    if (!isc.isA.Number(number)) return "";
    var util = isc.NumberUtil;
    return "$" + util.toLocalizedString(number, decimalPrecision, ".", ",", "-");
},

//> @method NumberUtil.iscToLocaleString()
// Customizeable version of the <code>toLocaleString()</code> method for numbers.
// Called by <code>isc.iscToLocaleString()</code>.
// Uses the formatter set by NumberUtil.setStandardLocaleStringFormatter(), or at the instance
// level by NumberUtil.setLocaleStringFormatter()
//
// @param number (Number) the number to format
// @return (string) formatted number as a string
//
// @group stringProcessing
//<
iscToLocaleString : function (number) {
    var f = isc.NumberUtil.localeStringFormatter;
    //var method = Number[f] || isc.NumberUtil[f];
    var method = isc.isA.Function(f) ? f : isc.NumberUtil[f];
    return method ? method(number) : number.toString();
},

//> @method NumberUtil.toFormattedString()
// Allow use of a custom number formatter - can be passed in as a parameter, or set by
// NumberUtil.setStandardFormatter()
//
// @param number (Number) the number to format
// @param [formatter] (string) name of a Number function to use
// @return (string) formatted number as a string
//
// @group stringProcessing
//<

toFormattedString : function (number, formatter) {
    var f = formatter || isc.NumberUtil.formatter;
    var method = isc.isA.Function(f) ? f : isc.NumberUtil[f];
    return method ? method(number) : number.toString();
},

toString : function (number) {
    if (isc.isA.Class(number)) return number.valueOf().toString();
    return number.toString();
},

//> @method NumberUtil.parseInt()
// Parse string that contains integer number. This method correctly handles locale based
// separators and currency symbol.
//
// @param string (string) the string to parse
// @return (Number) parsed number as a Number
// @visibility external
//
//<

parseInt : function (string) {
  string = string.replace(new RegExp("[" + this.groupingSymbol + "|"  + this.currencySymbol
      + "]", "g"),"");
  return parseInt(string);
},

//> @method NumberUtil.parseFloat()
// Parse string that contains float number. This method correctly handles locale based
// separators, decimal points and currency symbol.
//
// @param string (string) the string to parse
// @return (float) parsed number as a Number
// @visibility external
//
//<
parseFloat : function (string) {
    string = string.replace(new RegExp("[" + this.groupingSymbol + "|"  + this.currencySymbol
        + "]", "g"), "");
    if (this.decimalSymbol != ".") {
        string = string.replace(new RegExp("[" + this.decimalSymbol + "]", "g"), ".");
    }
    return parseFloat(string);
},

parseLocaleFloat : function (string, decimalSymbol, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!decimalSymbol) decimalSymbol = isc.NumberUtil.decimalSymbol;
    if (!groupingSymbol) groupingSymbol = isc.NumberUtil.groupingSymbol;
    string = string.replace(new RegExp("[" + groupingSymbol + "]", "g"), "");
    if (decimalSymbol != ".") {
        string = string.replace(new RegExp("[" + decimalSymbol + "]", "g"), ".");
    }
    return parseFloat(string);
},

parseLocaleInt : function (string, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!groupingSymbol) groupingSymbol = isc.NumberUtil.groupingSymbol;
    string = string.replace(new RegExp("[" + groupingSymbol + "]", "g"), "");
    return parseInt(string);
},

parseLocaleCurrency : function (string, currencySymbol, decimalSymbol, groupingSymbol) {
    if (string == null) return Number.NaN;
    if (!currencySymbol) currencySymbol = isc.NumberUtil.currencySymbol;
    string = string.replace(new RegExp("[" + currencySymbol + "]", "g"), "");
    return this.parseLocaleFloat(string);
},

//> @classMethod NumberUtil.parseIfNumeric()
//
// If given a numeric string (that is, a non-empty string which converts to a
// number), will return the equivalent integer. Otherwise, returns the
// parameter unchanged. Useful for dealing with values that can be numbers or
// strings, but which you want to coerce to a numeric type if possible.
//
// @param numberOrString (any) the string or number to parse
// @return (any) an integer, if possible, otherwise the input unchanged
// @visibility internal
//<
// Used for dealing with heights and widths. They can be numbers or strings
// (e.g. "50%" or "*"), and thus are deserialized as strings. But we
// sometimes want to know whether it's "really" a string, or instead a
// "numeric string" like "100".

parseIfNumeric : function (numberOrString) {
    if (isc.isA.Number(numberOrString)) {
        return numberOrString;
    } else if (isc.isA.nonemptyString(numberOrString)) {
        // Note that we want to return strings with trailing characters (like
        // "100%") unchanged, even though parseInt would produce an integer
        // from them. To check for that, isNaN is probably faster than a
        // regexp.
        if (isNaN(numberOrString)) {
            return numberOrString;
        } else {
            return parseInt(numberOrString, 10);
        }
    } else {
        // If it's neither Number nor String, or an empty String, just return
        // it. An empty string could be parsed to 0, but that's not necessarily
        // what was meant.
        return numberOrString;
    }
}
});

// set the standard formatter for the date prototype to the native browser string
// so 'toFormattedString()' defaults to returning the standard number format string
if (!isc.NumberUtil.formatter) isc.NumberUtil.formatter = "toString";


if (!isc.NumberUtil.localeStringFormatter)
    isc.NumberUtil.localeStringFormatter = "toString";

/*
    Isomorphic SmartClient web presentation layer
    Copyright 2000 and beyond Isomorphic Software, Inc.

    OWNERSHIP NOTICE
    Isomorphic Software owns and reserves all rights not expressly granted in this source code,
    including all intellectual property rights to the structure, sequence, and format of this code
    and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.

    CONFIDENTIALITY NOTICE
    The contents of this file are confidential and protected by non-disclosure agreement:
      * You may not expose this file to any person who is not bound by the same obligations.
      * You may not expose or send this file unencrypted on a public network.

    SUPPORTED INTERFACES
    Most interfaces expressed in this source code are internal and unsupported. Isomorphic supports
    only the documented behaviors of properties and methods that are marked "@visibility external"
    in this code. All other interfaces may be changed or removed without notice. The implementation
    of any supported interface may also be changed without notice.

    If you have any questions, please email <sourcecode@isomorphic.com>.

    This entire comment must accompany any portion of Isomorphic Software source code that is
    copied or moved from this file.
*/



  //>DEBUG
// This lets us label methods with a name within addMethods
Number.prototype.Class = "Number";
  //<DEBUG


//> @object Number
//
// Extra methods added to the Number object, available on all number variables.
//
//  @visibility external
//  @treeLocation Client Reference/System
//<

isc.addMethods(Number, {
setStandardFormatter : function (functionName) {
    isc.NumberUtil.setStandardFormatter(functionName);
},
setStandardLocaleStringFormatter : function (functionName) {
    isc.NumberUtil.setStandardLocaleStringFormatter(functionName);
}
});

//
// add methods to all Numbers
//
isc.addMethods(Number.prototype, {
//> @method number.stringify()
//
// Return this number as a string padded out to digits length.
//
// @param [digits] (number : 2) Number of digits to pad to.  (Default is 2)
// @return (string) Padded string version of the number
//
// @example var str = myNumberVar.stringify(2);
// @group stringProcessing
// @visibility external
// @deprecated Moved to a static method on NumberUtil to avoid the possibility of collision
//              with other libraries on the native Number object
//<

stringify : isc.NumberUtil._stringify,

//> @method number.toCurrencyString()
// Return this number as a currency-formatted string.
//
// @param [currencyChar] (string) Currency symbol, can be set to an empty string.
//                                If unset <code>"$"</code> will be used.
// @param [decimalChar] (string) Decimal separator symbol. If unset <code>"."</code> will be used.
// @param [padDecimal] (boolean) Should decimal portion be padded out to two digits? True
//                               by default.
// @param [currencyCharLast] (boolean) Should currency symbol come at the end of the string?
//                                      If unspecified, currency symbol will be shown at the
//                                      beginning of the string.
// @return (string) Currency-formatted string version of the number
// @group stringProcessing
// @visibility external
// @deprecated Moved to a static method on NumberUtil to avoid the possibility of collision
//              with other libraries on the native Number object
//<

toCurrencyString : isc.NumberUtil._toCurrencyString

// NOTE:
// We don't provide 'setFormatter' or 'setStandardFormatter' instance methods for Numbers.
// This is because
// a) we don't want to confuse the issue of where formatters are stored (we have a pattern here
//    and on Dates of having standard formatters for all instances only)
// b) (at least in IE), numbers are not allocated as "true instances", so having a
//     number instance (var theVar = 2;) does not mean that you can set up properties on it,
//     such as theVar.formatter -- when you next refer to 'theVar', you are really given
//     another '2' instance, so your properties have been wiped out.

});

//
// add class-methods to the Number object
//  Moved to NumberUtil.js

isc.addProperties(Number.prototype, {

// doc and implementation moved to NumberUtil
iscToLocaleString : function () {
    var result = isc.NumberUtil.iscToLocaleString(this);
    return result;
},

// doc and implementation moved to NumberUtil
toFormattedString : function (formatter) {
    var result = isc.NumberUtil.toFormattedString(this, formatter)
    return result;
},

// doc and implementation moved to NumberUtil
toLocalizedString : function (decimalPrecision, decimalSymbol, groupingSymbol, negativeSymbol) {
    var result = isc.NumberUtil.toLocalizedString(this, decimalPrecision, decimalSymbol,
                groupingSymbol, negativeSymbol);
    return result;
},


toUSString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSString(this, decimalPrecision);
    return result;
},
toUSDollarString : function (decimalPrecision) {
    return isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
},
toUSCurrencyString : function(decimalPrecision) {
    var result = isc.NumberUtil.toUSCurrencyString(this, decimalPrecision);
    return result;
}

}) // end addProperties(Number.prototype) for localizable number formatter



isc.defineClass("Format");

isc.Format.addClassMethods({
    toUSString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSString(theNum, decimalPrecision)
    },
    toUSCurrencyString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision)
    },
    toUSDollarString : function (theNum, decimalPrecision) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil.toUSCurrencyString(theNum, decimalPrecision)
    },
    toCurrencyString : function (theNum, currencyChar, decimalChar,
                                 padDecimal, currencyCharLast) {
        if (!isc.isA.Number(theNum)) return theNum;
        return isc.NumberUtil._toCurrencyString(currencyChar, decimalChar,
                                       padDecimal, currencyCharLast, theNum);
    }
})
//
// Math helpers
//
isc.Math = {
    random : function (a,b) {
        if (b==null) {
            return Math.round(Math.random()*a)
        } else {
            return Math.round(Math.random()*(b-a))+a
        }
    },

    _signum : function (x) {
        return (x < 0 ? -1 : (x > 0 ? 1 : 0));
    },

    // Calculate sqrt(a^2 + b^2) without overflow or underflow
    _hypot : function (a, b) {
        a = Math.abs(a);
        b = Math.abs(b);
        if (a > b) {
            return a * Math.sqrt(1 + b * b / a / a);
        } else if (b != 0) {
            return b * Math.sqrt(1 + a * a / b / b);
        } else {
            return a;
        }
    },

    // Calculates the shortest Euclidean distance from a test point (x3, y3) to the line between
    // start point (x1, y1) and end point (x2, y2).
    euclideanDistanceToLine : function (x1, y1, x2, y2, x3, y3) {
        // http://web.archive.org/web/20080704103329/http://local.wasp.uwa.edu.au/~pbourke/geometry/pointline/

        var dx = x2 - x1,
            dy = y2 - y1;

        var uDenom = dx * dx + dy * dy;
        // If the line's endpoints are coincident, then just return the Euclidean distance from
        // the test point to the start point.
        if (uDenom <= 0.00001) {
            return this.euclideanDistance(x1, y1, x3, y3);
        }

        var u = ((x3 - x1) * (x2 - x1) + (y3 - y1) * (y2 - y1)) / uDenom;

        if (u < 0) {
            return this.euclideanDistance(x1, y1, x3, y3);
        } else if (u > 1) {
            return this.euclideanDistance(x2, y2, x3, y3);
        } else {
            // Actually compute the point of intersection.
            var x = x1 + u * dx,
                y = y1 + u * dy;

            return this.euclideanDistance(x, y, x3, y3);
        }
    },

    // Calculates the Euclidean distance between two points.
    euclideanDistance : function (x1, y1, x2, y2) {
        if (arguments.length == 2) {
            // Assume that the two given arguments are points.
            var p1 = x1,
                p2 = y1;
            x1 = p1[0];
            y1 = p1[1];
            x2 = p2[0];
            y2 = p2[1];
        }
        return this._hypot((x1 - x2), (y1 - y2));
    },

    // Trigonometry
    // ---------------------------------------------------------------------------------------
    _radPerDeg: Math.PI / 180,

    //> @classMethod math.toRadians()
    // Converts an angle in degrees to radians.
    // @param angle (double) the angle in degrees.
    // @return (double) the angle in radians.
    //<
    toRadians : function (angle) {
        return angle * this._radPerDeg;
    },

    //> @classMethod math.cosdeg()
    // Calculates the cosine of the given angle in degrees.
    // @param angle (double) the angle in degrees.
    // @return (double) the cosine of the given angle.
    //<
    cosdeg : function (angle) {
        return Math.cos(angle * this._radPerDeg);
    },

    //> @classMethod math.sindeg()
    // Calculates the sine of the given angle in degrees.
    // @param angle (double) the angle in degrees.
    // @return (double) the sine of the given angle.
    //<
    sindeg : function (angle) {
        return Math.sin(angle * this._radPerDeg);
    },

    // Linear Algebra
    // ---------------------------------------------------------------------------------------

    // Calculates the dot product of two vectors. To be well formed, the two vectors must have
    // the same array length (dimension).
    _dot : function (u, v) {
        var ret = 0;
        for (var i = 0; i < u.length; ++i) {
            ret += u[i] * v[i];
        }
        return ret;
    },

    // Given a matrix A (that is an Array of Arrays of Numbers) returns a new matrix that is the matrix
    // multiplication of the transpose of A times A.  If A has m rows and n columns then the
    // new matrix will have n rows and n columns.
    _dotAtA : function (A) {
        var m = A.length,
            n = A[0].length,
            AtA = new Array(n);

        for (var i = n; i--; ) {
            AtA[i] = new Array(n);
        }

        for (var i = n; i--; ) {
            var AtAi = AtA[i];
            for (var j = i; j < n; ++j) {
                var sum = 0;
                for (var k = m; k--; ) {
                    var Ak = A[k];
                    sum += Ak[i] * Ak[j];
                }
                AtAi[j] = AtA[j][i] = sum;
            }
        }
        return AtA;
    },

    // Given a matrix A, that is an Array of Arrays of Numbers, and a vector b, that is an Array of Numbers,
    // return a new vector that is the matrix multiplication of A times b.  If A has m rows and n columns,
    // then b is expected to have length n, and the returned vector will have length m.
    _dotAtb : function (A, b) {
        if (A.length != b.length) {
            return null;
        }

        var m = A[0].length, n = b.length,
            Atb = new Array(m);

        for (var i = m; i--; ) {
            var sum = 0;
            for (var j = n; j--; ) {
                sum += A[j][i] * b[j];
            }
            Atb[i] = sum;
        }
        return Atb;
    },

    // Calculates the Cholesky decomposition of a symmetric, positive-definite matrix A.
    // A must be an Array of Arrays of Numbers.  The return value is the unique,
    // lower triangular matrix L such that A = L * Lt.  If A has n rows and n columns
    // (it must have equal number of rows and columns in order to be symmetric), then the
    // returned matrix L will also have n rows and n columns.
    // See:  http://en.wikipedia.org/wiki/Cholesky_decomposition
    _cholesky : function (A) {
        if (A.length != A[0].length) {
            // The matrix A is apparently not symmetric, so return null.
            return null;
        }

        var n = A.length,
            L = isc.Math._createMatrix(n, n);

        for (var j = 0; j < n; ++j) {
            var Lj = L[j],
                sum = 0;

            for (var k = 0; k < j; ++k) {
                var Ljk = Lj[k];
                sum += Ljk * Ljk;
            }

            if (A[j][j] - sum < 0) {
                // The matrix A must not have been positive-definite.  In this case
                // the matrix has no Cholesky decomposition, so return null.
                return null;
            }

            var Ljj = Lj[j] = Math.sqrt(A[j][j] - sum);

            for (var i = j + 1; i < n; ++i) {
                var Li = L[i],
                    sum = 0;
                for (var k = 0; k < j; ++k) {
                    sum += Li[k] * Lj[k];
                }
                Li[j] = (A[i][j] - sum) / Ljj;
            }
        }

        return L;
    },

    // Return the transpose of a matrix A (an Array of Arrays of Numbers).  The transpose
    // matrix will have the same number of rows as A has columns and the same
    // number of columns as A has rows.
    _transpose : function (A) {
        var m = A.length, n = A[0].length,
            At = new Array(n);
        for (var i = n; i--; ) {
            At[i] = new Array(m);
        }
        for (var i = n; i--; ) {
            var Ati = At[i];
            for (var j = m; j--; ) {
                Ati[j] = A[j][i];
            }
        }
        return At;
    },

    // Create a matrix of m x n size as an Array of Arrays with no initial values.
    _createMatrix : function (m, n) {
        var A = new Array(m);
        for (var i = m; i--; ) {
            A[i] = new Array(n);
        }
        return A;
    },

    // Similar to _createMatrix(), but the matrix is filled with zeros.
    _createZeroMatrix : function (m, n) {
        var A = new Array(m);
        for (var i = m; i--; ) {
            var Ai = A[i] = new Array(n);
            for (var j = n; j--; ) {
                Ai[j] = 0;
            }
        }
        return A;
    },

    // Creates a new Array of length n that contains zeros as entries.
    _createZeroVector : function (n) {
        var v = new Array(n);
        for (var i = n; i--; ) {
            v[i] = 0;
        }
        return v;
    },

    // Creates a new matrix (an Array of Arrays) that has identical size and
    // entries as the given matrix A.
    _cloneMatrix : function (A) {
        var m = A.length, n = A[0].length,
            B = new Array(m);
        for (var i = m; i--; ) {
            var Ai = A[i],
                Bi = B[i] = new Array(n);
            for (var j = n; j--; ) {
                Bi[j] = Ai[j];
            }
        }
        return B;
    },

    // Calculate the Moore–Penrose pseudoinverse of a matrix A.
    _pseudoInv : function (A, maxIterations) {
        var svd = isc.Math._svd(A, maxIterations, true, true);
        if (svd != null) {
            var s = svd.s,
                m = s.length;
            for (var i = m; i--; ) {
                s[i] = (s[i] == 0 ? 0 : (1 / s[i]));
            }
            return isc.Math._dotUSVt(svd.V, s, svd.U);
        } else {
            return null;
        }
    },

    // Calculate the singular value decomposition of a matrix A into the product
    // A = U * S * Vt, where U and V are unitary matrices, and S is a
    // diagonal matrix.  The return value is an object with the keys "U" and "V"
    // each mapped to a matrix (an Array of Arrays of Numbers) and the key "s" mapped
    // to an Array of Numbers.  The matrix S in the singular value decomposition can
    // be formed by taking a zero matrix of the appropriate size (see _createZeroMatrix())
    // and filling the diagonal entries of that matrix with the entries of s:
    //
    //     var m = A.length,
    //         n = A[0].length,
    //         svd = isc.Math._svd(A),
    //         s = svd.s,
    //         S = isc.Math._createZeroMatrix(m, n);
    //     for (var i = 0; i < m && i < n; ++i) {
    //         S[i][i] = s[i];
    //     }
    //

    _svd : function (A, maxIterations, wantU, wantV, calculateThinSVD) {
        if (maxIterations == null) {
            maxIterations = 50;
        }
        if (wantU == null) {
            wantU = true;
        }
        if (wantV == null) {
            wantV = true;
        }

        var eps = 2.220446049250313e-16; // 2^-52
        var tiny = Number.MIN_VALUE;
        var m = A.length, n = A[0].length;

        if (m < n) {
            var ret = isc.Math._svd(isc.Math._transpose(A), maxIterations, wantV, wantU);
            if (ret != null) {
                var swap = ret.U;
                ret.U = ret.V;
                ret.V = swap;
            }
            return ret;
        }

        var hypot = isc.Math._hypot,
            nu = Math.min(m, n),
            q = (calculateThinSVD ? nu : m),
            p = Math.min(n, m + 1),
            nct = Math.min(m - 1, n),
            nrt = Math.max(0, Math.min(n - 2, m)),
            A = isc.Math._cloneMatrix(A),
            s = new Array(p),
            U = isc.Math._createZeroMatrix(m, q),
            V = isc.Math._createZeroMatrix(n, n),
            e = isc.Math._createZeroVector(n),
            work = isc.Math._createZeroVector(m);

        for (var k = 0, maxK = Math.max(nct, nrt); k < maxK; ++k) {
            if (k < nct) {
                s[k] = 0;
                for (var i = k; i < m; ++i) {
                    s[k] = hypot(s[k], A[i][k]);
                }
                if (s[k] != 0) {
                    if (A[k][k] < 0) {
                        s[k] = -s[k];
                    }
                    for (var i = k; i < m; ++i) {
                        A[i][k] /= s[k];
                    }
                    A[k][k] += 1;
                }
                s[k] = -s[k];
            }
            for (var j = k + 1; j < n; ++j) {
                if (k < nct && s[k] != 0) {
                    // apply the transformation
                    var t = 0;
                    for (var i = k; i < m; ++i) {
                        t += A[i][k] * A[i][j];
                    }
                    t = -t / A[k][k];
                    for (var i = k; i < m; ++i) {
                        A[i][j] += t * A[i][k];
                    }
                }

                // place the kth row of A into e for the subsequent calculation of the row transform
                e[j] = A[k][j];
            }
            if (wantU && k < nct) {
                // place the transformation in U for subsequent back multiplication
                for (var i = k; i < m; ++i) {
                    U[i][k] = A[i][k];
                }
            }
            if (k < nrt) {
                // compute the kth row transformation and place the kth super-diagonal into e[k].
                e[k] = 0;
                for (var i = k + 1; i < n; ++i) {
                    e[k] = hypot(e[k], e[i]);
                }
                if (e[k] != 0) {
                   if (e[k + 1] < 0) {
                       e[k] = -e[k];
                   }
                   for (var i = k + 1; i < n; ++i) {
                       e[i] /= e[k];
                   }
                   e[k + 1] += 1;
                }
                e[k] = -e[k];

                if (k + 1 < m && e[k] != 0) {
                    // apply the transformation
                    for (var i = k + 1; i < m; ++i) {
                        work[i] = 0;
                    }
                    for (var j = k + 1; j < n; ++j) {
                        for (var i = k + 1; i < m; ++i) {
                            work[i] += e[j] * A[i][j];
                        }
                    }
                    for (var j = k + 1; j < n; ++j) {
                        var t = -e[j] / e[k + 1];
                        for (var i = k + 1; i < m; ++i) {
                            A[i][j] += t * work[i];
                        }
                    }
                }
                if (wantV) {
                    // place the transformation in V for subsequent back multiplication
                    for (var i = k + 1; i < n; ++i) {
                        V[i][k] = e[i];
                    }
                }
            }
        }

        // Set up the final bidiagonal matrix of order p
        if (nct < n) {
            s[nct] = A[nct][nct];
        }
        if (m < p) {
            s[p - 1] = 0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0;

        // If required, generate U
        if (wantU) {
            for (var j = nct; j < q; ++j) {
                for (var i = 0; i < m; ++i) {
                    U[i][j] = 0;
                }
                U[j][j] = 1;
            }
            for (var k = nct - 1; k >= 0; --k) {
                if (s[k] != 0) {
                    for (var j = k + 1; j < q; ++j) {
                        var t = 0;
                        for (var i = k; i < m; ++i) {
                            t += U[i][k] * U[i][j];
                        }
                        t = -t / U[k][k];
                        for (var i = k; i < m; ++i) {
                            U[i][j] += t * U[i][k];
                        }
                    }
                    for (var i = k; i < m; ++i) {
                        U[i][k] = -U[i][k];
                    }
                    U[k][k] += 1;
                    for (var i = 0; i < k - 1; ++i) {
                        U[i][k] = 0;
                    }
                } else {
                    for (var i = 0; i < m; ++i) {
                        U[i][k] = 0;
                    }
                    U[k][k] = 1;
                }
            }
        }

        // If required, generate V
        if (wantV) {
            for (var k = n - 1; k >= 0; --k) {
                if (k < nrt && e[k] != 0) {
                    for (var j = k + 1; j < nu; ++j) {
                        var t = 0;
                        for (var i = k + 1; i < n; ++i) {
                            t += V[i][k] * V[i][j];
                        }
                        t = -t / V[k+1][k];
                        for (var i = k + 1; i < n; ++i) {
                            V[i][j] += t * V[i][k];
                        }
                    }
                }
                for (var i = 0; i < n; ++i) {
                    V[i][k] = 0;
                }
                V[k][k] = 1;
            }
        }

        // Main iteration loop for the singular values.
        var pp = p-1,
            iter = 0;
        while (p > 0) {
            if (iter > maxIterations) {
                return null;
            }

            // Inspect for negligible elements in the s and e arrays.
            // case 1:  s[p] and e[k-1] are negligible and k < p
            // case 2:  s[k] is negligible and k < p
            // case 3:  e[k-1] is negligible, k < p, and s[k], ..., s[p] are not negligible (QR step)
            // case 4:  e[p-1] is negligible (convergence)
            var k, caseNum;
            for (k = p - 2; k >= -1; --k) {
                if (k == -1) {
                    break;
                }
                if (Math.abs(e[k]) <= tiny + eps*(Math.abs(s[k]) + Math.abs(s[k+1]))) {
                    e[k] = 0;
                    break;
                }
            }
            if (k == p - 2) {
                // e[p - 1] is negligible (convergence)
                caseNum = 4;
            } else {
                var ks;
                for (ks = p - 1; ks >= k; --ks) {
                    if (ks == k) {
                        break;
                    }
                    var t = (ks != p ? Math.abs(e[ks]) : 0) +
                            (ks != k + 1 ? Math.abs(e[ks - 1]) : 0);
                    if (Math.abs(s[ks]) <= tiny + eps * t)  {
                        s[ks] = 0;
                        break;
                    }
                }
                if (ks == k) {
                    // e[k-1] is negligible, k < p, and
                    // s[k], ..., s[p] are not negligible => QR step
                    caseNum = 3;
                } else if (ks == p - 1) {
                    // s[p] and e[k-1] are negligible and k < p
                    caseNum = 1;
                } else {
                    // s[k] is negligible and k < p
                    caseNum = 2;
                    k = ks;
                }
            }
            ++k;

            // Perform the task indicated by the exact case:
            switch (caseNum) {
            case 1:
                // Deflate negligible s[p]
                var f = e[p-2];
                e[p-2] = 0;
                for (var j = p - 2; j >= k; --j) {
                    var t = hypot(s[j], f),
                        cs = s[j] / t,
                        sn = f / t;
                    s[j] = t;
                    if (j != k) {
                        f = -sn * e[j-1];
                        e[j-1] = cs * e[j-1];
                    }
                    if (wantV) {
                        for (var i = 0; i < n; ++i) {
                            t = cs * V[i][j] + sn * V[i][p-1];
                            V[i][p-1] = -sn * V[i][j] + cs * V[i][p-1];
                            V[i][j] = t;
                        }
                    }
                }
                break;

            case 2:
                // Split at negligible s(k).
                var f = e[k-1];
                e[k-1] = 0;
                for (var j = k; j < p; ++j) {
                    var t = hypot(s[j], f),
                        cs = s[j] / t,
                        sn = f / t;
                    s[j] = t;
                    f = -sn * e[j];
                    e[j] = cs * e[j];
                    if (wantU) {
                        for (var i = 0; i < m; ++i) {
                            t = cs * U[i][j] + sn * U[i][k-1];
                            U[i][k-1] = -sn * U[i][j] + cs * U[i][k-1];
                            U[i][j] = t;
                        }
                    }
                }
                break;

            case 3:
                // Perform one QR step

                // Calculate the shift.
                var scale = Math.max(
                        Math.abs(s[p-1]),
                        Math.abs(s[p-2]),
                        Math.abs(e[p-2]),
                        Math.abs(s[k]),
                        Math.abs(e[k])),
                    sp = s[p-1] / scale,
                    spm1 = s[p-2] / scale,
                    epm1 = e[p-2] / scale,
                    sk = s[k] / scale,
                    ek = e[k] / scale,
                    b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2,
                    c = sp * epm1 * sp * epm1,
                    shift = 0;
                if (!(b == 0 && c == 0)) {
                   shift = Math.sqrt(b * b + c);
                   if (b < 0) {
                      shift = -shift;
                   }
                   shift = c / (b + shift);
                }
                var f = (sk + sp) * (sk - sp) + shift,
                    g = sk * ek;

                // Chase zeros
                for (var j = k; j < p - 1; ++j) {
                   var t = hypot(f, g),
                       cs = f / t,
                       sn = g / t;
                   if (j != k) {
                      e[j-1] = t;
                   }
                   f = cs * s[j] + sn * e[j];
                   e[j] = cs * e[j] - sn * s[j];
                   g = sn * s[j+1];
                   s[j+1] = cs * s[j+1];
                   if (wantV) {
                       for (var i = 0; i < n; ++i) {
                           t = cs * V[i][j] + sn * V[i][j+1];
                           V[i][j+1] = -sn * V[i][j] + cs * V[i][j+1];
                           V[i][j] = t;
                       }
                   }
                   t = hypot(f, g);
                   cs = f / t;
                   sn = g / t;
                   s[j] = t;
                   f = cs * e[j] + sn * s[j+1];
                   s[j+1] = -sn * e[j] + cs * s[j+1];
                   g = sn * e[j+1];
                   e[j+1] = cs * e[j+1];
                   if (wantU && j < m - 1) {
                       for (var i = 0; i < m; ++i) {
                           t = cs * U[i][j] + sn * U[i][j+1];
                           U[i][j+1] = -sn * U[i][j] + cs * U[i][j+1];
                           U[i][j] = t;
                       }
                   }
                }
                e[p-2] = f;
                ++iter;
                break;

            case 4:
                // Convergence.

                // Make the singular values non-negative
                if (s[k] <= 0) {
                    s[k] = -s[k];
                    if (wantV) {
                        for (var i = 0; i <= pp; ++i) {
                            V[i][k] = -V[i][k];
                        }
                    }
                }

                // Order the singular values.
                for (; k < pp; ++k) {
                    if (s[k] >= s[k+1]) {
                        break;
                    }
                    var t = s[k];
                    s[k] = s[k+1];
                    s[k+1] = t;
                    if (wantV && k < n - 1) {
                        for (var i = 0; i < n; ++i) {
                            t = V[i][k+1]; V[i][k+1] = V[i][k]; V[i][k] = t;
                        }
                    }
                    if (wantU && k < m - 1) {
                        for (var i = 0; i < m; ++i) {
                            t = U[i][k+1]; U[i][k+1] = U[i][k]; U[i][k] = t;
                        }
                    }
                }
                iter = 0;
                --p;
                break;
            } // end of switch
        } // end of loop while p > 0

        return { U: U, s: s, V: V };
    },

    // Takes a matrix U, an array s that defines the diagonal elements of a diagonal matrix S, and
    // a matrix V, and returns the matrix multiplication of U times S times the transpose of V.
    // This method may be used to check the singular value decomposition of a matrix A,
    // but it is also used to calculate the Moore–Penrose pseudoinverse of A (see _pseudoInv()).
    _dotUSVt : function (U, s, V) {
        var m = U.length,
            n = V.length,
            l = Math.min(m, n),
            A = isc.Math._createMatrix(m, n);

        for (var i = m; i--; ) {
            var Ui = U[i], Ai = A[i];
            for (var j = n; j--; ) {
                var sum = 0, Vj = V[j];
                for (var k = l; k--; ) {
                    sum += Ui[k] * s[k] * Vj[k];
                }
                Ai[j] = sum;
            }
        }
        return A;
    }
};


isc.defineClass("AffineTransform").addClassProperties({
    // Rotation by an angle about a given point (cx, cy) is equivalent to:
    // 1. Translating by -cx, -cy. (A)
    // 2. Rotating by the angle.   (B)
    // 3. Translating by cx, cy.   (C)
    //
    // (*** C ****)(******** B *********)(*** A *****)
    // [1 , 0 , cx][cos(a) , -sin(a) , 0][1 , 0 , -cx]   [cos(a) , -sin(a) , cx][1 , 0 , -cx]   [cos(a) , -sin(a) , -cos(a) * cx + sin(a) * cy + cx]
    // [0 , 1 , cy][sin(a) ,  cos(a) , 0][0 , 1 , -cy] = [sin(a) ,  cos(a) , cy][0 , 1 , -cy] = [sin(a) ,  cos(a) , -sin(a) * cx - cos(a) * cy + cy]
    // [0 , 0 ,  1][     0 ,       0 , 1][0 , 0 ,   1]   [     0 ,       0 ,  1][0 , 0 ,   1]   [     0 ,       0 ,                               1]
    getRotateTransform : function (angle, cx, cy) {
        var c = isc.Math.cosdeg(angle),
            s = isc.Math.sindeg(angle);
        return isc.AffineTransform.create({
            m00: c, m01: -s, m02: -c * cx + s * cy + cx,
            m10: s, m11:  c, m12: -s * cx - c * cy + cy
        });
    },

    getTranslateTransform : function (dx, dy) {
        return isc.AffineTransform.create({
            m00: 1, m01: 0, m02: dx,
            m10: 0, m11: 1, m12: dy
        });
    }
});

isc.AffineTransform.addProperties({
    // Start with the identity transform.
    m00: 1, m01: 0, m02: 0,
    m10: 0, m11: 1, m12: 0,

    duplicate : function () {
        return isc.AffineTransform.create({
            m00: this.m00, m01: this.m01, m02: this.m02,
            m10: this.m10, m11: this.m11, m12: this.m12
        });
    },

    getDeterminant : function () {
        return this.m00 * this.m11 - this.m10 * this.m01;
    },

    getInverse : function () {
        var det = this.getDeterminant(),
            isInvertible = isc.isA.Number(det) && det != 0;

        if (!isInvertible) return null;

        return isc.AffineTransform.create({
            m00: this.m11 / det,
            m10: -this.m10 / det,
            m01: -this.m01 / det,
            m11: this.m00 / det,
            m02: (this.m01 * this.m12 - this.m11 * this.m02) / det,
            m12: (this.m10 * this.m02 - this.m00 * this.m12) / det
        });
    },

    // [t00 , t01 , t02][m00 , m01 , m02]   [t00 * m00 + t01 * m10 , t00 * m01 + t01 * m11 , t00 * m02 + t01 * m12 + t02]
    // [t10 , t11 , t12][m10 , m11 , m12] = [t10 * m00 + t11 * m10 , t10 * m01 + t11 * m11 , t10 * m02 + t11 * m12 + t12]
    // [  0 ,   0 ,   1][  0 ,   0 ,   1]   [                    0 ,                     0 ,                           1]
    leftMultiply : function (transform) {
        var m0 = this.m00,
            m1 = this.m10;
        this.m00 = transform.m00 * m0 + transform.m01 * m1;
        this.m10 = transform.m10 * m0 + transform.m11 * m1;

        m0 = this.m01;
        m1 = this.m11;
        this.m01 = transform.m00 * m0 + transform.m01 * m1;
        this.m11 = transform.m10 * m0 + transform.m11 * m1;

        m0 = this.m02;
        m1 = this.m12;
        this.m02 = transform.m00 * m0 + transform.m01 * m1 + transform.m02;
        this.m12 = transform.m10 * m0 + transform.m11 * m1 + transform.m12;
        return this;
    },

    // [m00 , m01 , m02][t00 , t01 , t02]   [m00 * t00 + m01 * t10 , m00 * t01 + m01 * t11 , m00 * t02 + m01 * t12 + m02]
    // [m10 , m11 , m12][t10 , t11 , t12] = [m10 * t00 + m11 * t10 , m10 * t01 + m11 * t11 , m10 * t02 + m11 * t12 + m12]
    // [  0 ,   0 ,   1][  0 ,   0 ,   1]   [                    0 ,                     0 ,                           1]
    rightMultiply : function (transform) {
        var mx = this.m00,
            my = this.m01;
        this.m00 = mx * transform.m00 + my * transform.m10;
        this.m01 = mx * transform.m01 + my * transform.m11;
        this.m02 = mx * transform.m02 + my * transform.m12 + this.m02;

        mx = this.m10;
        my = this.m11;
        this.m10 = mx * transform.m00 + my * transform.m10;
        this.m11 = mx * transform.m01 + my * transform.m11;
        this.m12 = mx * transform.m02 + my * transform.m12 + this.m12;
        return this;
    },

    preRotate : function (angle, cx, cy) {
        return this.leftMultiply(isc.AffineTransform.getRotateTransform(angle, cx, cy));
    },

    //> affineTransform.rotate()
    // Adds a rotation transform to this affine transform.
    //
    // @param angle (double) the angle in degrees.
    // @param cx (double) X coordinate of the center of rotation.
    // @param cy (double) Y coordinate of the center of rotation.
    //<
    rotate : function (angle, cx, cy) {
        return this.rightMultiply(isc.AffineTransform.getRotateTransform(angle, cx, cy));
    },

    // [sx ,  0 , 0][m00 , m01 , m02]   [sx * m00 , sx * m01 , sx * m02]
    // [ 0 , sy , 0][m10 , m11 , m12] = [sy * m10 , sy * m11 , sy * m12]
    // [ 0 ,  0 , 1][  0 ,   0 ,   1]   [       0 ,        0 ,        1]
    preScale : function (sx, sy) {
        this.m00 *= sx; this.m01 *= sx; this.m02 *= sx;
        this.m10 *= sy; this.m11 *= sy; this.m12 *= sy;
        return this;
    },

    // [m00 , m01 , m02][sx ,  0 , 0]   [m00 * sx , m01 * sy , m02]
    // [m10 , m11 , m12][ 0 , sy , 0] = [m10 * sx , m11 * sy , m12]
    // [  0 ,   0 ,   1][ 0 ,  0 , 1]   [       0 ,        0 ,   1]
    scale : function (sx, sy) {
        this.m00 *= sx; this.m01 *= sy;
        this.m10 *= sx; this.m11 *= sy;
        return this;
    },

    // [1 , 0 , dx][m00 , m01 , m02]   [m00 , m01 , m02 + dx]
    // [0 , 1 , dy][m10 , m11 , m12] = [m10 , m11 , m12 + dy]
    // [0 , 0 ,  1][  0 ,   0 ,   1]   [  0 ,   0 ,        1]
    preTranslate : function (dx, dy) {
        this.m02 += dx;
        this.m12 += dy;
        return this;
    },

    // [m00 , m01 , m02][1 , 0 , dx]   [m00 , m01 , m00 * dx + m01 * dy + m02]
    // [m10 , m11 , m12][0 , 1 , dy] = [m10 , m11 , m10 * dx + m11 * dy + m12]
    // [  0 ,   0 ,   1][0 , 0 ,  1]   [  0 ,   0 ,                         1]
    translate : function (dx, dy) {
        this.m02 += this.m00 * dx + this.m01 * dy;
        this.m12 += this.m10 * dx + this.m11 * dy;
        return this;
    },

    // [m00 , m01 , m02][v0]   [m00 * v0 + m01 * v1 + m02]
    // [m10 , m11 , m12][v1] = [m10 * v0 + m11 * v1 + m12]
    // [  0 ,   0 ,   1][ 1]   [                        1]
    transform : function (v0, v1) {
        return {
            v0: this.m00 * v0 + this.m01 * v1 + this.m02,
            v1: this.m10 * v0 + this.m11 * v1 + this.m12
        };
    },

    toString : function () {
        return "[" + this.m00 + " , " + this.m01 + " , " + this.m02 + "]\n" +
               "[" + this.m10 + " , " + this.m11 + " , " + this.m12 + "]";
    }
});







//> @class DateUtil
// Static singleton class containing APIs for interacting with Dates.
// @treeLocation Client Reference/System
// @visibility external
//<

isc.defineClass("DateUtil");

//>    @class Date
//
//    Extensions to the Date class, including added static methods on the Date object, and
//  additional instance methods available on all date instances.
//
//  @treeLocation Client Reference/System
//  @visibility external
//<

//>    @classMethod    isc.timeStamp()
//  Shorthand for <code>new Date().getTime();</code>, this returns a timeStamp - a large number
//  which is incremented by 1 every millisecond.  Can be used to generate unique identifiers,
//  or perform timing tasks.
//
//  @visibility external
//    @return    (int)    a large integer (actually the number of milliseconds since 1/1/1970)
//<

isc.addGlobal("timeStamp", function () {

    return new Date().getTime()
});


// synonym
isc.addGlobal("timestamp", isc.timeStamp);


  //>DEBUG
// This lets us label methods with a name within addMethods
Date.prototype.Class = "Date";
Date.Class = "Date";
  //<DEBUG


isc.Date = Date;


isc.addProperties(Date, {
    // add a constant for an error message when attempting to convert an invalid string to a
    // date
    INVALID_DATE_STRING:"Invalid date format"
});


//
// add methods to the Date object itself for parsing additional formats
//
isc.addMethods(Date, {

//>    @classMethod    Date.newInstance()
//            Cover function for creating a date in the 'Isomorphic-style',
//                eg:   Date.newInstance(args)
//            rather than new Date(args)
//        @return                (Date)        Date object
//      @deprecated As of SmartClient 5.5, use +link{Date.create}.
//<
newInstance : function (arg1, arg2, arg3, arg4, arg5, arg6, arg7) {
    return new Date(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
},


//>    @classMethod    Date.create()
//  Create a new <code>Date</code> object - synonym for <code>new Date(arguments)</code>
//    @return (Date) Date object
//  @visibility external
//<
create : function (arg1, arg2, arg3, arg4, arg5, arg6, arg7) {
    // handle being passed a subset of parameters
    // Note that passing undefined into new Date() results in an invalid date where
    // getTime() returns NaN
    var undef;
    if (arg1 === undef) return new Date();
    if (arg2 === undef) return new Date(arg1);
    if (arg3 === undef) arg3 = 0;
    if (arg4 === undef) arg4 = 0;
    if (arg5 === undef) arg5 = 0;
    if (arg6 === undef) arg6 = 0;
    if (arg7 === undef) arg7 = 0;
    return new Date(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
},

//> @classMethod Date.createLogicalDate()
// Create a new Date to represent a logical date value (rather than a specific datetime value),
// typically for display in a +link{DataSourceField.type,date type field}. The generated
// Date value will have year, month and date set to the specified values
// (in browser native local time).
// @param year (int) full year
// @param month (int) month (zero based, so 0 is January)
// @param date (int) date within the month
// @return (Date) new javascript Date object representing the Date in question
// @visibility external
//<
// For logical dates, the only requirement for the "time" component value is that the
// date shows up correctly in local time.

createLogicalDate : function (year, month, date, suppressConversion) {
    var d = new Date();
    d.setHours(12, 0, 0, 0);
    year = (year != null ? year : d.getFullYear());
    month = (month != null ? month : d.getMonth());
    date = (date != null ? date : d.getDate());
    d.setFullYear(year, month, date);

    if (suppressConversion) {
        // If the 'suppressConversion' flag was passed, we will want to return null to indicate
        // we were passed an invalid date if the values passed in had to be converted
        // (For example a month of 13 effecting the year, etc)
        var isValid = (d.getFullYear() == year &&
                       d.getMonth() == month &&
                       d.getDate() == date );
        if (!isValid) return null;
    }

    d.logicalDate = true;
    return d;
},

//> @classMethod Date.createLogicalTime()
// Create a new Date object to represent a logical time value (rather than a specific datetime
// value), typically for display in a +link{DataSourceField.type,time type field}. The generated
// Date value will have year, month and date set to the epoch date (Jan 1 1970), and time
// elements set to the supplied hour, minute and second (in browser native local time).
// @param hour (int) hour (0-23)
// @param minute (int) minute (0-59)
// @param second (int) second (0-59)
// @return (Date) new Javascript Date object representing the time in question
// @visibility external
//<
// This is a synonym for Time.createLogicalTime();
createLogicalTime : function (hour, minute, second, millisecond) {
    return isc.Time.createLogicalTime(hour,minute,second,millisecond);
},

createDatetime : function (year, month, date, hours, minutes, seconds, milliseconds, suppressConversion) {
    var hasHours = hours != null,
        hasMinutes = minutes != null,
        hasSeconds = seconds != null;

    // Handle being passed strings
    if (isc.isA.String(hours)) hours = parseInt(hours || 12, 10);
    if (isc.isA.String(minutes)) minutes = parseInt(minutes || 0, 10);
    if (isc.isA.String(seconds)) seconds = parseInt(seconds || 0, 10);

    var newDate;
    if (!isc.Time._customTimezone) {
        newDate = new Date(year, month, date);
        if (hasHours) {
            if (milliseconds != null) newDate.setHours(hours, minutes, seconds, milliseconds);
            else if (hasSeconds) newDate.setHours(hours, minutes, seconds);
            else if (hasMinutes) newDate.setHours(hours, minutes);
            else newDate.setHours(hours);
        }

        if (!suppressConversion) return newDate;

        // If the 'suppressConversion' flag was passed, we will want to return null to indicate
        // we were passed an invalid date if the values passed in had to be converted
        // (For example a month of 13 effecting the year, etc)
        var isValid = (newDate.getFullYear() == year &&
                       newDate.getMonth() == month &&
                       newDate.getDate() == date &&
                       (!hasHours || newDate.getHours() == hours) &&
                       (!hasMinutes || newDate.getMinutes() == minutes) &&
                       (!hasSeconds || newDate.getSeconds() == seconds)
                       );
        return (isValid ? newDate : null);
    } else {

        // We need a date where the UTCTime is set such that when we apply our
        // custom timezone offset we get back the local time.
        // Do this by creating a new date with UTC time matching this custom display time
        // and then shifting that date by the inverse of our display timezone offset.
        if (hours == null) hours = 0;
        if (minutes == null) minutes = 0;
        if (seconds == null) seconds = 0;
        if (milliseconds == null) milliseconds = 0;

        newDate = new Date(Date.UTC(year, month, date, hours, minutes, seconds, milliseconds));
        // If the 'suppressConversion' flag was passed, we will want to return null to indicate
        // we were passed an invalid date if the values passed in had to be converted
        // (For example a month of 13 effecting the year, etc)
        // Easiest to check this against the date before we apply the offset to correct for
        // our timezone
        if (suppressConversion) {
            var isValid = (newDate.getUTCFullYear() == year &&
                           newDate.getUTCMonth() == month &&
                           newDate.getUTCDate() == date &&
                           (!hasHours || newDate.getUTCHours() ==hours) &&
                           (!hasMinutes || newDate.getUTCMinutes() == minutes) &&
                           (!hasSeconds || newDate.getUTCSeconds() == seconds)
                           );
            if (!isValid) newDate = null;
        }
        if (newDate != null) {
            // Subtract the UTCHoursDisplayOffset and UTCMinutesDisplayOffset, then adjust
            // for DST if required.

            newDate._applyTimezoneOffset(
                -isc.Time.UTCHoursDisplayOffset,
                -isc.Time.UTCMinutesDisplayOffset
            );

            newDate._applyTimezoneOffset(-isc.Time.getUTCHoursDisplayOffset(newDate, 0),
                                         -isc.Time.getUTCMinutesDisplayOffset(newDate, 0));
        }
        return newDate;
    }
},

//> @classMethod Date.getLogicalDateOnly()
// Get a logical date - a value appropriate for a DataSourceField of type "date" - from a
// datetime value (a value from a DataSourceField of type "datetime").
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned Date
// will reflect the day, month and year that appears when the datetime is rendered
// by a SmartClient component rather than the date values that would be returned by
// Date.getDay() et al (which can differ, since getDay() uses the browser's local timezone).
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing a datetime value
// @return (Date) a Date instance representing just the date portion of the datetime value, as
//                a logical date
// @visibility external
//<
getLogicalDateOnly : function (datetime) {
    if (!isc.isA.Date(datetime)) {
        isc.logWarn("getLogicalDateOnly() passed invalid value:" + datetime
            + ". Returning null.");
        return null;
    }
    var year,month,day;
    // handle being passed something that's already a logical date
    if (datetime.logicalDate) {
        year = datetime.getFullYear();
        month = datetime.getMonth();
        day = datetime.getDate();
    } else {
        var offsetDate = datetime._getTimezoneOffsetDate(
                            isc.Time.getUTCHoursDisplayOffset(datetime),
                            isc.Time.getUTCMinutesDisplayOffset(datetime)
                         );
        offsetDate._applyTimezoneOffset(0, offsetDate.getTimezoneOffset());

        month = offsetDate.getMonth();
        day = offsetDate.getDate();
        year = offsetDate.getFullYear();
    }

    return this.createLogicalDate(year, month, day);
},

//> @classMethod Date.getLogicalTimeOnly()
// Get a logical time - a value appropriate for a DataSourceField of type "time" - from a
// datetime value (a value from a DataSourceField of type "datetime").
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned Date will
// reflect the hour, minute and second that appears when the datetime is rendered by a SmartClient
// component rather than the time values that would be returned by Date.getHours() et al (which
// can differ, since getHours() uses the browser's local timezone).
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing a datetime value
// @return (Date) a Date instance representing just the time portion of the datetime value, as
//                a logical time
// @visibility external
//<
getLogicalTimeOnly : function (datetime) {
    if (!isc.isA.Date(datetime)) {
        isc.logWarn("getLogicalTimeOnly() passed invalid value:" + datetime
            + ". Returning null.");
        return null;
    }

    var offsetHours = 0, offsetMinutes = 0;
    if (!datetime.logicalTime) {
        offsetHours = isc.Time.getUTCHoursDisplayOffset(datetime);
        offsetMinutes = isc.Time.getUTCMinutesDisplayOffset(datetime) +
                        datetime.getTimezoneOffset();
    }

    return this.createLogicalTime(datetime.getHours() + offsetHours, datetime.getMinutes() + offsetMinutes,
                                  datetime.getSeconds(), datetime.getMilliseconds());
},


//> @classMethod Date.combineLogicalDateAndTime()
// Combine a logical date (a value appropriate for a DataSourceField of type "date") with a
// logical time (a value appropriate for a DataSourceField of type "time") into a datetime
// value (a value appropriate for a DataSourceField of type "datetime")
// <P>
// This method correctly takes into account the current
// +link{Time.setDefaultDisplayTimezone,display timezone}, specifically, the returned datetime
// value will show the same date and time as the passed date and time objects when rendered by
// a SmartClient component that has been configured with a field of type "datetime".
// <P>
// For further background on date, time and datetime types, storage and transmission, see
// +link{group:dateFormatAndStorage,this overview}.
//
// @param date (Date) a Date instance representing logical date value
// @param time (Date) a Date instance representing logical time value
// @return (Date) a Date instance representing a datetime value combining the logical date and
//                time passed
// @visibility external
//<
combineLogicalDateAndTime : function (date, time) {
    var hasDate = isc.isA.Date(date),
        hasTime = isc.isA.Date(time);
    if (!hasDate || !hasTime) {
        // date only, convert from logical date to datetime.
        if (hasDate) {
            // pass in the result of 'getFullYear()' etc. These numbers are the correct
            // abs values - createDatetime will handle shifting them to account for
            // timezones.
            return this.createDatetime(date.getFullYear(), date.getMonth(), date.getDate(), 0,0,0);
        } else if (hasTime) {
            // We could log a warning and bail in this case. However may as well just
            // give back a datetime with the same time value as the 'time' passed in.
            return time.duplicate();
        } else {
            isc.logWarn("combineLogicalDateAndTime passed invalid parameters:"
                 + date + " and " + time + ". Returning null.");
            return null;
        }
    }

    // Get hours / minutes in display timezone.
    var hour = time.getHours(),
        minutes = time.getMinutes();
    return this.createDatetime(
                date.getFullYear(), date.getMonth(), date.getDate(),
                hour, minutes, time.getSeconds(), time.getMilliseconds()
           );
},


//>    @classMethod    Date.compareDates()
// Compare two dates; returns 0 if equal, -1 if the first date is greater (later), or 1 if
// the second date is greater.  If either value is not a Date object, it is treated as the
// epoch (midnight on Jan 1 1970) for comparison purposes.
//  @param  date1   (date)  first date to compare
//  @param  date2   (date)  second date to compare
//  @return (int)    0 if equal, -1 if first date &gt; second date, 1 if second date &gt; first date
// @visibility external
//<
compareDates : function (a, b) {
    if (a == b) return 0; // same date instance
    var aval = (isc.isA.Date(a) ? a.getTime() : 0),
        bval = (isc.isA.Date(b) ? b.getTime() : 0);
    return aval > bval ? -1 : (bval > aval ? 1 : 0);
},

//>    @classMethod    Date.compareLogicalDates()
// Compare two dates, normalizing out the time elements so that only the date elements are
// considered; returns 0 if equal, -1 if the first date is greater (later), or 1 if
// the second date is greater.
//  @param  date1   (date)  first date to compare
//  @param  date2   (date)  second date to compare
//  @return (int)    0 if equal, -1 if first date &gt; second date, 1 if second date &gt;
//                      first date.  Returns false if either argument is not a date
// @visibility external
//<
compareLogicalDates : function (a, b) {
    if (a == b) return 0; // same date instance
    if (!isc.isA.Date(a) || !isc.isA.Date(b)) return false; // bad arguments, so return false
    var aYear = a.getFullYear(),
        aMonth = a.getMonth(),
        aDay = a.getDate(),
        bYear = b.getFullYear(),
        bMonth = b.getMonth(),
        bDay = b.getDate();

    var aval = aYear * 10000 + aMonth * 100 + aDay,
        bval = bYear * 10000 + bMonth * 100 + bDay;

    return aval > bval ? -1 : (bval > aval ? 1 : 0);
},

// `month' begins at 0.
getJulianDayNumber : function (year, month, date) {
    // http://quasar.as.utexas.edu/BillInfo/JulianDatesG.html
    var y = year,
        m = month + 1,
        d = date;

    if (m <= 2) {
        --y;
        m += 12;
    }
    var a = parseInt(y / 100),
        b = parseInt(a / 4),
        c = 2 - a + b,
        e = parseInt(365.25 * (y + 4716)),
        f = parseInt(30.6001 * (m + 1))
    return c + d + e + f - 1524;
},

_getWeekdayCounts : function () {
    var weekendDays = isc.Date.getWeekendDays();
    var weekdayCounts = weekendDays._weekdayCounts;
    if (!weekdayCounts) {
        var isWeekend = {}, numWeekends = 0;
        for (var i = 0; i < weekendDays.length; ++i) {
            if (!isWeekend[weekendDays[i]]) {
                ++numWeekends;
                isWeekend[weekendDays[i]] = true;
            }
        }

        weekdayCounts = [];
        for (var d = 0; d <= 6; ++d) {
            var weekdayCount = 0;
            var counts = [ 0 ];
            for (var dd = 1; dd < 7; ++dd) {
                if (!isWeekend[(d + dd - 1) % 7]) ++weekdayCount;
                counts.push(weekdayCount);
            }
            weekdayCounts[d] = counts;
        }
        weekdayCounts._numWeekends = numWeekends;
        weekendDays._weekdayCounts = weekdayCounts;
    }
    return weekdayCounts;
},

_getDayDiff : function (date1, date2, weekdaysOnly, useCustomTimezone) {
    var logicalDate1, logicalDate2;
    var compareRes = isc.Date.compareDates(date1, date2);
    var sign = (compareRes > 0 ? 1 : -1);
    if (compareRes >= 0) { // `date1' is before `date2'.
        if (useCustomTimezone !== false) {
            logicalDate1 = isc.Date.getLogicalDateOnly(date1);
            logicalDate2 = isc.Date.getLogicalDateOnly(date2);
        } else {
            logicalDate1 = date1;
            logicalDate2 = date2;
        }
    } else {
        if (useCustomTimezone !== false) {
            logicalDate1 = isc.Date.getLogicalDateOnly(date2);
            logicalDate2 = isc.Date.getLogicalDateOnly(date1);
        } else {
            logicalDate1 = date2;
            logicalDate2 = date1;
        }
    }

    var jd1 = isc.Date.getJulianDayNumber(logicalDate1.getFullYear(), logicalDate1.getMonth(), logicalDate1.getDate()),
        jd2 = isc.Date.getJulianDayNumber(logicalDate2.getFullYear(), logicalDate2.getMonth(), logicalDate2.getDate());

    if (weekdaysOnly) {
        var dd = jd2 - jd1;
        var weekdayCounts = isc.Date._getWeekdayCounts();
        return sign * (parseInt(dd / 7) * (7 - weekdayCounts._numWeekends) + weekdayCounts[logicalDate1.getDay()][dd % 7]);
    } else {
        return sign * (jd2 - jd1);
    }
},

//>    @type DateInputFormat
//  3 character string containing the <code>"M"</code>, <code>"D"</code> and <code>"Y"</code>
//  characters to indicate the format of strings being parsed into Date instances via
//  <code>Date.parseInput()</code>.
//  <P>
//  As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999
// <var class="smartclient">
//  <P>
//  Note: In addition to these standard formats, a custom date string parser function may be
//  passed directly to +link{Date.setInputFormat()} or passed into +link{Date.parseInput()} as
//  the inputFormat parameter.
// </var>
//  @visibility external
//<

//> @classMethod Date.setInputFormat()
// Sets up the default system-wide input format for strings being parsed into dates via
// <code>Date.parseInput()</code>. This will effect how SmartClient components showing editable
// date or datetime fields parse user-entered values into live Date objects.
// <P>
// The input format can be specified as a +link{type:DateInputFormat} - a 3 character string like
// <code>"MDY"</code> indicating the order of the Month, Day and Year components of date strings.
// <P>
// As an example - an input format of "MDY" would parse "01/02/1999" to Jan 2nd 1999<br>
// This standard parsing logic will also handle date-time strings such as "01/02/1999 08:45", or
// "01/02/1999 16:21:05".
// <P>
// Notes:
// <ul>
// <li>If the inputFormat is not explicitly set,the system automatically determines
//     the standard input format will be based on the specified +link{Date.shortDisplayFormat}
//     wherever possible.
//     For example if the short display format has been set to "toEuropeanShortDate" the input
//     format will default to "DMY".</li>
// <li>The default date parsing functionality built into SmartClient will handle dates presented
//     with any separator string, and can handle 1 or 2 digit day and month values and 2 or 4
//     digit year values. This means that in many cases custom date display formats can be parsed
//     back to Date values without the need for a custom parser function. However if more
//     sophisticated parsing logic is required, a function may be passed into this method. In
//     this case the parser function should be able to handle parsing date and datetime values
//     formatted via +link{Date.toShortDate()} and +link{Date.toShortDateTime()}.</li>
// <li>Date parsing and formatting logic may be overridden at the component level by setting
//     properties directly on the component or field in question.</li>
// </ul>
// @param format (DateInputFormat | function) Default format for strings to be parsed into Dates.
// <var class="smartclient">
// If this method is passed a function, it is expected to take a single parameter
// (the formatted date string), and return the appropriate Javascript Date object (or null if
// appropriate).
// </var>
// @see Date.parseInput()
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setInputFormat : function (format) {

    this._inputFormat = format;
},

//> @classMethod Date.getInputFormat()
// Retrieves the default format for strings being parsed into dates via
// <code>Date.parseInput()</code>
// @see Date.setInputFormat()
// @return (string) the current inputFormat for dates
// @visibility external
//<
getInputFormat : function () {
    if (this._inputFormat != null) return this._inputFormat;
    return this.mapDisplayFormatToInputFormat("toShortDate");
},

// Given a display format return the associated input format
_inputFormatMap:{
    toUSShortDate:"MDY",
    toUSShortDateTime:"MDY",
    toUSShortDatetime:"MDY",
    toEuropeanShortDate:"DMY",
    toEuropeanShortDateTime:"DMY",
    toEuropeanShortDatetime:"DMY",
    toJapanShortDate:"YMD",
    toJapanShortDateTime:"YMD",
    toJapanShortDatetime:"YMD"
},
mapDisplayFormatToInputFormat : function (displayFormat) {
    if (displayFormat == null || displayFormat == "toShortDate") {
        displayFormat = Date.prototype._shortFormat;
    } else if (displayFormat == "toNormalDate") {
        displayFormat = Date.prototype.formatter;
    }
    if (isc.isA.Function(displayFormat)) {
        isc.Log.logInfo("Unable to determine input format associated with display format " +
                        "function - returning default input format", "Date");
        return this._inputFormat || "MDY";
    }
    var inputFormat = this._inputFormatMap[displayFormat];
    // Note: isA.String check is necessary - all objects have toString / toLocaleString
    // present on them and we definitely don't want to return those native object formatters
    // as what will become a dateString parsing function!
    if (inputFormat != null && isc.isA.String(inputFormat)) return inputFormat;

    // a couple of special cases where we actually return functions.
    if (displayFormat == "toSerializeableDate") return this.parseSchemaDate;

    // Otherwise you're on your own - assume you've set up input foramt, or overridden this method
    isc.Log.logInfo("Unable to determine input format associated with display format " +
                     displayFormat + " - returning default input format", "Date");

    return this._inputFormat || "MDY";
},

//>    @classMethod    Date.parseInput()
// Parse a date passed in as a string, returning the appropriate date object.
// @param dateString (string) date value as a string
// @param [format] (DateInputFormat) Format of the date string being passed.
//                                      If not passed, the default date input format as set up
//                                      via setInputFormat() will be used.
// @param [centuryThreshold] (integer) For date formats that support a 2 digit
//                                  year, if parsed year is 2 digits and less than this
//                                  number, assume year to be 20xx rather than 19xx
// @param [suppressConversion] (Boolean)
//          If the string passed in was not a valid date, in some cases we can convert to a
//          valid date (for example incrementing the year if the month is greater than 12).
//          This optional parameter will suppress such conversions - anything that doesn't
//          parse directly to a valid date will simply return null.
// @return (Date) date value, or null if the string could not be parsed to a valid date.
// @group dateFormatting
// @visibility external
//<

// Note: undocumented isDatetime parameter. Are we creating a logical "date" value or a standard
// datetime type value where the time component is important? If ommitted assume datetime.
// Implementation-wise, if isDatetime is explicitly false, we will use the system local timezone
// rather than any timezone specified via Time.setDisplayTimezone().

parseInput : function (dateString, format, centuryThreshold, suppressConversion,
                        isDatetime)
{
    var logicalDate = (isDatetime == false);

    if (isc.isA.Date(dateString)) return dateString;

    if (!isc.isA.String(dateString) || isc.isAn.emptyString(dateString)) {
        return null;
    }

    // Strip the '$$DATE$$:' prefix if present.
    var origDateString = dateString;
    dateString = dateString.trim();

    if (dateString.startsWith("$$DATESTAMP$$:")) {
        return new Date(parseInt(dateString.substring(14)));
    }

    if (dateString.startsWith("$$DATE$$:")) {
        dateString = dateString.substring(9).trimLeft();
    }

    // Default to the standard input format
    if (format == null) format = this.getInputFormat();

    // If the format passed in is the name of a function on the Date class, or an
    // explicit function, assume its a parser and call it directly

    if (isc.isA.Function(Date[format])) format = Date[format];
    if (isc.isA.Function(format)) {
        return format(origDateString, centuryThreshold, suppressConversion);
    }

    // use the helper method _splitDateString() to get an array of values back
    // (representing year / month / day, etc.)
    // If null is returned, this was not a valid date - just return null.
    // Otherwise make the month zero-based, by reducing by one, and pass construct a new date
    // from the values returned.
    var array = this._splitDateString(dateString, format);

    if (array != null) {
        var year = array[0],
            bce = year && year.contains("-");

        if (year && bce) year = year.replaceAll("-", "");

        if (year) {
            if (year.length <= 2) {
                year = parseInt(year, 10);
                if (centuryThreshold != null) {
                    if (year < centuryThreshold) year += 2000;
                    else year += 1900;
                }
                array[0] = year;
            } else if (year.length == 3) {
                array[0] = "0" + year.toString();
            } else {
                array[0] = year;
            }
            if (bce) array[0] = "-" + array[0];
        }

        if (logicalDate) {
            return Date.createLogicalDate(array[0], array[1], array[2], suppressConversion);
        } else {
            return Date.createDatetime(array[0], array[1], array[2],
                        array[3], array[4], array[5], null, suppressConversion);
        }
    } else {
        return null;
    }
},

// Helper used by the Relative date item -- returns true if the date-string passed
// in includes a time portion.
// False if it does not (or if it's not a recognized date-string at all)
isDatetimeString : function (dateString, format) {
    format = format || isc.Date.getInputFormat();
    if (!isc.isA.Function(format)) {
        var array = this._splitDateString(dateString, format, false);
        if (array == null) return false;

        return (array[3] != null && !isc.isA.emptyString(array[3])) &&
               (array[4] != null && !isc.isA.emptyString(array[4]));
    }


    if (!dateString.contains(" ")) return false;
    var timeString = dateString.substring(dateString.lastIndexOf(" ") + 1);
    var array = timeString.split(":");
    if (!array || array.length < 2) return false;
    for (var i=0; i<array.length; i++) {
        if (isNaN(array[i])) return false;
    }
    return true;
},

// Parse a date or datetime value from a dataset or specified in code.
// NB: unlike parseInput, this method should not change behavior in different locales, or dates
// coming over the wire or specified in code will suddenly break!
//
// For Datetime, XML Schema uses "2005-08-01T21:35:48.350Z", see
//    http://www.w3.org/TR/xmlschema-2/#dateTime
// SmartClient Server parses "yyyy-mm-dd" format
parseSchemaDate : function (value) {
    if (isc.isA.Date(value)) return value;

    if (!isc.isA.String(value)) value = (value.toString ? value.toString() : value + "");

    // Notes on regex:
    // - result[4] is the optional timestamp including the T and colon separators
    // - result[8] would be the optional milliseconds including the ".", whereas
    //   result[9] is just the numeric part
    //   results[10] is the timezone - either "Z" (zulu time or GMT) or +/- HH:MM
    var result = value.match(/(\d{4})[\/-](\d{2})[\/-](\d{2})([T ](\d{2}):(\d{2})(:(\d{2}))?)?(\.(\d+))?([+-]\d\d?:\d{2}|Z)?/);

    var secondsIndex = 8;
    var msIndex = 10;
    var tzIndex = 11;

//    isc.Log.logWarn("isDate: '" + value + "', regex match: " + result);

    if (result == null) return null;

    value = value.trim();


    var dateValue;
    // NOTE: pass only the relevant arguments as Moz does not like being passed nulls

    if (!result[4]) { // no VALID time
        // before creating a logical date, check if the value has additional characters that
        // make it look like it has something in place of a time-value, even if it isn't
        // valid for schema-format - return null in this case, rather than a valid logicalDate
        if (value.length > 10 && value.contains(" ")) return null;
        dateValue = Date.createLogicalDate(result[1], result[2] - 1, result[3]);
    } else if (!result[msIndex]) { // no ms
        dateValue = new Date(Date.UTC(result[1], result[2] - 1, result[3],
                                      result[5], result[6], result[secondsIndex] || 0));
    } else {
        var ms = result[msIndex];

        // XML Schema says any number of fractional digits can be specified.  new Date() is
        // expecting a whole number of milliseconds (and further precision would be ignored).
        // Multiply by a power of ten based on the number of digits provided, such that ".9"
        // becomes 900 and ".98367" becomes 984.
        if (ms.length != 3) {
            var multiplier = Math.pow(10,3-ms.length);
            ms = Math.round(parseInt(ms,10) * multiplier);
        }
        //isc.Log.logWarn("ms is: " + ms);

        dateValue = new Date(Date.UTC(result[1], result[2] - 1, result[3],
                                      result[5], result[6], result[secondsIndex] || 0, ms));
    }
    // Handle timezone offset from GMT

    if (result[tzIndex] && result[tzIndex].toLowerCase() != "z") {
        var HM = result[tzIndex].split(":"),
            H = HM[0],
            negative = H && H.startsWith("-"),
            M = HM[1];
        H = parseInt(H, 10);
        M = parseInt(M, 10);
        var dateTime = dateValue.getTime();


        // Note no need to account for negative on hours since the "+" or "-" prefix was picked up
        // in parseInt
        if (isc.isA.Number(H)) dateTime -= (3600000 * H);
        if (isc.isA.Number(M)) dateTime -= (60000 * M * (negative ? -1 : 1));
        dateValue.setTime(dateTime);
    }

    return dateValue
},

//>!BackCompat 2005.11.3
// parseDate() was old name for parseInput
parseDate : function (dateString, format, centuryThreshold, suppressConversion) {
    return this.parseInput(dateString, format, centuryThreshold, suppressConversion);
},

// For completeness also support parseDatetime()
parseDateTime : function (dateString, format, centuryThreshold, suppressConversion) {
    return this.parseDatetime(dateString,format,centuryThreshold,suppressConversion);
},
parseDatetime : function (dateString, format, centuryThreshold, suppressConversion) {
    return this.parseInput(dateString, format, centuryThreshold, suppressConversion);
},
//<!BackCompat

// ISC DSResponses that use our SQLTransform logic (basically our backend DB implementation)
// will call this method by default - giving the user an opportunity to override.  This can be
// disabled by setting jsTranslater.writeNativeDate: true in server.properties.
//
// Note: month is zero-based, just like the native Date constructor.
parseServerDate : function (year, month, day) {
    return Date.createLogicalDate(year, month, day);
},

// ISC DSResponses will call this method by default for fields of type "time"
parseServerTime : function (hour, minute, second) {
    return Date.createLogicalTime(hour, minute, second);
},


_splitDateString : function (string, format, zeroEmptyTime) {
    var isFunc = isc.isA.Function(format);

    if (zeroEmptyTime == null) zeroEmptyTime = true;

    var month, day, year, hour, minute, second;

    var monthIndex = format && !isFunc ? format.indexOf("M") : 0,
        dayIndex = format && !isFunc ? format.indexOf("D") : 1,
        yearIndex = format && !isFunc ? format.indexOf("Y") : 2;
    // shortDate implies it's of the format MM/DD/YYYY

    //>Safari12
    if (isc.Browser.isSafari && isc.Browser.safariVersion <= 312) {
        var splitDate = this._splitDateViaSubstring(string, monthIndex, dayIndex, yearIndex,
                                                    zeroEmptyTime);
        year = splitDate[0];
        month = splitDate[1];
        day = splitDate[2];
        hour = splitDate[3];
        minute = splitDate[4];
        second = splitDate[5];

    // For browsers that support RegExp properly, use regexp pattern matching to get the result
    // (This has the advantage that we can deal with dates of the form 1/1/1999, and attempt to
    //  convert MM/YY/DD -- though we're relying on the native browser handling for the
    //  Date constructor being passed a 2 digit year)
    } else {
    //<Safari12

        // Each of the first three slots is either YYYY / YY or MM / M (or DD/D) (depends on the
        // format passed in)
        // Note: We don't support years greater than 9999. Attempting to set a year greater than
        // 9999 on a JS date causes a native browser crash on IE6
        var regex =
        //          YYYY || YY/[M]M  /  YYYY || YY/[M]M  /  YYYY || YY/[M]M [(space) [H]H  :    MM    [:     SS]]
        new RegExp(/^\s*(-?\d{1,4})[^\d](-?\d{1,4})[^\d](-?\d{1,4})([^\d](\d{1,2})[^\d](\d\d)[^\d]?(\d\d)?)?\s*$/),
            results = string.match(regex);

        if (results == null) return null;
        // Notes - we need to match the order of day / month / year to the format passed in
        // Also - the month value in the string is 1-based rather than zero based

        // Note: this was parseInt(results[index]) -1, but both IE and Mozilla will do the
        // wrong thing here - if the substring was "09", the parseInt would return 0 rather
        // than 9.
        // In any case, the parseInt is rendered unnecessary by the 'isA.Number' check below.
        month = results[monthIndex +1] -1;
        day = results[dayIndex+1];
        year = results[yearIndex +1];

        // Note - results[4] is the whole time string (if present)
        // Zero out any time fields that are not present - this may happen if
        // - time has invalid format (could check by examining results[4] too)
        // - time not included in dateString (could check by examining results[4] too)
        // - time has no seconds (legal - just zero out the seconds)
        hour = results[5];
        if (zeroEmptyTime && hour == null) hour = 0;
        minute = results[6];
        if (zeroEmptyTime && results[6] == null) minute = 0;
        second = results[7];
        if (zeroEmptyTime && results[7] == null) second = 0;
    //>Safari12
    }
    //<Safari12
    // If they all are numbers, this was a valid date string
    // NOTE: If year - month - day gives a number then they
    // are all numbers, or strings that implicitly convert to numbers.
    // We could also use this syntax:
    // if(parseInt(year) == year && parseInt(month) == month ...)
    // but this is slower in both Moz and IE
    var isValid = zeroEmptyTime ?
                    isc.isA.Number(year - month - day - hour - minute - second) :
                    isc.isA.Number(year - month - day);
    if (isValid) {
        // Return the hours modulo 24 in case the hours were formatted by a Java `SimpleDateFormat'
        // using the 'k' pattern char. This takes care of both 'H' and 'k'.
        // http://ideone.com/E5HC4E

        return ([year,month,day,hour != null ? hour % 24 : null ,minute,second]);
    }
    else return null
},

//>    @type DateDisplayFormat
// Valid display formats for dates.  These strings are the names of formatters which can be
// passed to <code>Date.setNormalDisplayFormat()</code> or <code>Date.setShortDisplayFormat()</code>
// and will be subsequently used as default long or short formatters for date objects by
// SmartClient components.<br>
// Default set of valid display formats is as follows:<br><br>
//
// @value toString
// Default native browser 'toString()' implementation. May vary by browser.<br>
// <i>Example</i>: <code>Fri Nov 04 2005 11:03:00 GMT-0800 (Pacific Standard Time)</code>
// @value toLocaleString
// Default native browser 'toLocaleString()' implementation. May vary by browser.
// <i>Example</i>: <code>Friday, November 04, 2005 11:03:00 AM</code>
// @value toUSShortDate Short date in format MM/DD/YYYY.<br>
// <i>Example</i>: <code>11/4/2005</code>
// @value toUSShortDatetime Short date with time in format MM/DD/YYYY HH:MM<br>
// <i>Example</i>: <code>11/4/2005 11:03</code>
// @value toEuropeanShortDate Short date in format DD/MM/YYYY.<br>
// <i>Example</i>: <code>4/11/2005</code>
// @value toEuropeanShortDatetime Short date with time in format DD/MM/YYYY HH:MM<br>
// <i>Example</i>: <code>4/11/2005 11:03</code>
// @value toJapanShortDate Short date in format YYYY/MM/DD.<br>
// <i>Example</i>: <code>2005/11/4</code>
// @value toJapanShortDatetime Short date with time in format YYYY/MM/DD HH:MM<br>
// <i>Example</i>: <code>2005/11/4 11:03</code>
// @value toSerializeableDate Date in the format YYYY-MM-DD HH:MM:SS<br>
// <i>Example</i>: <code>2005-11-04 11:09:15</code>
// @value toDateStamp   Date in the format &lt;YYYYMMDD&gt;T&lt;HHMMSS&gt;Z
// <i>Example</i>: <code>20051104T111001Z</code>
// <br>
// <br>
// Note: In addition to these standard formats, custom formatting can be set by passing
// a function directly to +link{Date.setNormalDisplayFormat()} et al. This
// function will then be executed whenever the appropriate formatter method is called [eg
// +link{date.toNormalDate()}], in the scope of the date instance in question.
//
//  @visibility external
//<

//> @classMethod Date.setNormalDisplayFormat()
// Set the default formatter for date objects to the method name passed in.  After calling this
// method, subsequent calls to +link{Date.toNormalDate()} will return a string formatted
// according to this format specification. Note: this will be the standard long date format used
// by SmartClient components.<br>
// The <code>format</code> parameter may be either a +link{DateDisplayFormat} string, or
// a function. If passed a function, this function will be executed in the scope of the Date
// and should return the formatted string.<br>
// Initial default normalDisplayFormat is <code>"toLocaleString"</code>
// @group    dateFormatting
// @param    format    (DateDisplayFormat | function)    new formatter
//      @visibility external
//<
setNormalDisplayFormat : function (format) {
    // if a valid formatter was passed in, set our .formatter property
    if (isc.isA.Function(Date.prototype[format]) || isc.isA.Function(format)) {
        Date.prototype.formatter = format;
    }
},

setNormalDateDisplayFormat : function (format) {
    this.setNormalDisplayFormat(format);
},

//> @classMethod Date.setNormalDatetimeDisplayFormat()
//  Set the default normal format for datetime values. After calling this method, subsequent calls to
// +link{Date.toNormalDatetime()} will return a string formatted according to this format
// specification. Note that this will be the standard datetime format used by
// SmartClient components.
// <P>
// The <code>format</code> parameter may be either a +link{DateDisplayFormat} string, or
// a function. If passed a function, this function will be executed in the scope of the Date
// and should return the formatted string.
//
// @group    dateFormatting
// @param    format    (DateDisplayFormat | function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setNormalDatetimeDisplayFormat : function (format) {
    // if a valid formatter was passed in, set our .formatter property
    if (isc.isA.Function(Date.prototype[format]) || isc.isA.Function(format)) {
        Date.prototype.datetimeFormatter = format;
    }
},

//>    @classMethod    Date.setShortDisplayFormat()
// Set the default short format for dates. After calling this method, subsequent calls to
// +link{Date.toShortDate()} will return a string formatted according to this format
// specification. Note that this will be the standard short date format used by
// SmartClient components.
// <P>
// The <code>format</code> parameter may be either a +link{DateDisplayFormat} string, or
// a function. If passed a function, this function will be executed in the scope of the Date
// and should return the formatted string.
// <P>
// Initial default shortDateFormat is <code>"toUSShortDate"</code>. This property
// is commonly modified for localization of applications. See
// +externalLink{http://en.wikipedia.org/wiki/Date_format_by_country}
// for a useful overview of standard date formats per country.
//
// @group    dateFormatting
// @param    format    (DateDisplayFormat | function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setShortDisplayFormat : function (format) {
    if (isc.isA.Function(Date.prototype[format]) || isc.isA.Function(format)) {
        Date.prototype._shortFormat = format;
    }
},

//>    @classMethod Date.setDefaultDateSeparator
// Sets a new default separator that will be used when formatting dates. By default, this
// is a forward slash character: "/"
// @group   dateFormatting
// @param separator (string) separator to use in dates
// @visibility external
//<
setDefaultDateSeparator : function (separator) {
    Date.prototype._shortDateTemplate = [,,,,separator,,,,,separator,,,,null];
    Date.prototype._separator = separator;
},

//>    @classMethod Date.getDefaultDateSeparator
// gets the default date separator string
// @group   dateFormatting
// @return (string) the default date separator
// @visibility external
//<
getDefaultDateSeparator : function (separator) {
    if (Date.prototype._separator) return Date.prototype._separator;
    else return "/";
},

//> @classMethod Date.setShortDatetimeDisplayFormat()
//  Set the default short format for datetime values. After calling this method, subsequent calls to
// +link{Date.toShortDateTime()} will return a string formatted according to this format
// specification. Note that this will be the standard datetime format used by
// SmartClient components.
// <P>
// The <code>format</code> parameter may be either a +link{DateDisplayFormat} string, or
// a function. If passed a function, this function will be executed in the scope of the Date
// and should return the formatted string.
// <P>
// Initial default format is <code>"toUSShortDatetime"</code>.  See
// +externalLink{http://en.wikipedia.org/wiki/Date_format_by_country}
// for a useful overview of standard date formats per country.
//
// @group    dateFormatting
// @param    format    (DateDisplayFormat | function)    new formatter
// @example dateFormat
// @example customDateFormat
// @visibility external
//<
setShortDatetimeDisplayFormat : function (format) {
    if (isc.isA.Function(Date.prototype[format]) || isc.isA.Function(format)) {
        Date.prototype._shortDatetimeFormat = format;
    }
},


//> @object FiscalYear
//
// An object representing the start of a given Fiscal Year in the current locale.
// <P>
// See +link{FiscalCalendar} for more information on how FiscalYears are set up and used.
//
// @visibility external
//<

//> @attr fiscalYear.fiscalYear (integer : null : IRW)
//
// The actual fiscal year that this date relates to.
// <P>
// A fiscal year ends when the next one begins. A fiscal year may span the boundary
// between two calendar years in which case the +link{fiscalYear.fiscalYear} value may
// not match the +link{fiscalYear.year} value.
// <P>
// For example fiscalYear 2020 may start in July of 2019 and end in July of 2020. In this
// case the <code>fiscalYear</code> would be set to <code>2020</code> and the
// +link{fiscalYear.year} would be set to <code>2019</code>
//
// @visibility external
//<

//> @attr fiscalYear.year (integer : null : IRW)
//
// The 4-digit calendar year when this fiscal year starts.
//
// @visibility external
//<

//> @attr fiscalYear.month (integer : null : IRW)
//
// The zero-based month-number when this fiscal year starts.
//
// @visibility external
//<

//> @attr fiscalYear.date (integer : null : IRW)
//
// The one-based day-number in the +link{fiscalYear.month, specified month} when this fiscal
// year starts.
//
// @visibility external
//<

//> @object FiscalCalendar
//
// An object representing the start date for fiscal years in the current locale.
// <P>
// A fiscal year spans a configurable date range - it may not exactly
// match a calendar year in length and it can start on any date within the calendar year
// and potentially end in the next calendar year.
// <P>
// Developers may specify explicit fiscal year start dates by adding +link{FiscalYear}
// objects to the +link{FiscalCalendar.fiscalYears, fiscal years array}.
// If none are provided, or if there is no entry for the given year, one is
// manufactured based on the default +link{FiscalCalendar.defaultMonth, month}
// and +link{FiscalCalendar.defaultDate, date}.
//
// @visibility external
//<

//> @attr fiscalCalendar.defaultMonth (integer : null : IRW)
//
// The default zero-based month-number to use for calculating fiscal dates when no
// +link{FiscalCalendar.fiscalYears, fiscal years} are provided. This value together
// with +link{fiscalCalendar.defaultDate} will be used as the start date for the
// fiscal years where no explicitly specified fiscalYear configuration is present.
// <br>
// See also +link{fiscalCalendar.defaultYearMode}.
//
// @visibility external
//<

//> @attr fiscalCalendar.defaultDate (integer : null : IRW)
//
// The default one-based day-number in the +link{fiscalCalendar.defaultMonth, specified month}
// to use for calculating fiscal dates when no +link{FiscalCalendar.fiscalYears, fiscal years}
// are provided. This value together
// with +link{fiscalCalendar.defaultMonth} will be used as the start date for the
// fiscal years where no explicitly specified fiscalYear configuration is present.
// <br>
// See also +link{fiscalCalendar.defaultYearMode}.
//
// @visibility external
//<

//> @type FiscalYearMode
//
// Strategies for calculating the FiscalYear within a +link{fisalCalendar} from the
// specified +link{fiscalCalendar.defaultDate} and +link{fiscalCalendar.defaultMonth}
// If the specified fiscal year date starts in one calendar year and ends in the next.
//
// @value "end" The fiscalYear value for the date range will match the calendar year
//  in which the period ends. For example if the defaultDate and defaultMonth were set
//  to represent April 1st, the fiscal year starting on April 1st 2020 would end on
//  April 1st 2021. Setting the fiscalYearMode to <code>end</code> would mean the
//  fiscalYear value for this block would be 2021.
//
// @value "start" The fiscalYear value for the date range will match the calendar year
//  in which the period starts. For example if the defaultDate and defaultMonth were set
//  to represent April 1st, the fiscal year starting on April 1st 2020 would end on
//  April 1st 2021. Setting the fiscalYearMode to <code>start</code> would mean the
//  fiscalYear value for this block would be 2020.
// @visibility external
//<

//> @attr fiscalCalendar.defaultYearMode (FiscalYearMode : "end" : IRW)
//
// This attribute controls how the displayed fiscalYear value should be calculated for
// dates falling within a period not explicitly listed in the
// +lik{fiscalCalendar.fiscalYears,fiscal years array}.
// <P>
// The +link{fiscalCalendar.defaultMonth} and +link{fiscalCalendar.defaultDate} will be
// used to calculate the start of the fiscal year period. The defaultYearMode
// determines whether the reported fiscalYear for this period matches the year in which
// the period starts or the year in which it ends (so whether a fiscal year spanning
// dates within both 2020 and 2021 is reported as fiscalYear 2020 or 2021).
// @visibility external
//<

//> @attr fiscalCalendar.fiscalYears (Array of FiscalYear : null : IRW)
//
// An array of +link{FiscalYear, FiscalYear objects} which each represent the start date of a
// single fiscal year.
//
// @visibility external
//<

//>    @classMethod date.setFiscalCalendar()
// Sets the global fiscal calendar, which is used for all calls to
// getFiscalYear() / getFiscalWeek() if those methods aren't passed a fiscalCalander.
//
// @param fiscalCalendar (FiscalCalendar) the object representing the start month and date of
//           the fiscal year in the current locale
// @visibility external
//<
setFiscalCalendar : function (fiscalCalendar) {
    if (!fiscalCalendar.fiscalYears) fiscalCalendar.fiscalYears = [];
    Date.prototype.fiscalCalendar = fiscalCalendar;
    // init the start/endDate values on any specified FiscalYear objects
    Date._getFiscalYearObjectForDate(new Date());
},

//>    @classMethod date.getFiscalCalendar()
// Returns the global +link{FiscalCalendar, FiscalCalendar object} representing the start month and
// date of the fiscal year in the current locale.
// @return (FiscalCalendar)    the FiscalCalendar object
// @visibility external
//<
getFiscalCalendar : function () {
    if (!Date.prototype.fiscalCalendar.fiscalYears) {
        Date.prototype.fiscalCalendar.fiscalYears = [];
    }
    return Date.prototype.fiscalCalendar;
},

//>    @classMethod date.getFiscalStartDate()
// Returns the start date of the fiscal year for the passed date.
//
// @param date (Date | number) the date, or the year-number, to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of one or more
//                              fiscal years
// @return (Date)    the start of the fiscal year for the passed date and fiscalCalendar
// @visibility external
//<
getFiscalStartDate : function (date, fiscalCalendar) {
    var fiscalYear = Date._getFiscalYearObjectForDate(date, fiscalCalendar);
    return new Date(fiscalYear.year, fiscalYear.month, fiscalYear.date);
},


_getFiscalYearObjectForDate : function (date, fiscalCalendar) {

    fiscalCalendar = fiscalCalendar || Date.getFiscalCalendar();
    if (!fiscalCalendar.fiscalYears) fiscalCalendar.fiscalYears = [];

    var fiscalYears = fiscalCalendar.fiscalYears;

    var defaultStartDate = fiscalCalendar.defaultDate,
        defaultStartMonth = fiscalCalendar.defaultMonth;
    // If unspecified default to calendar years.
    if (defaultStartDate == null) defaultStartDate = 1;
    if (defaultStartMonth == null) defaultStartMonth = 0;

    // In order to rapidly find the fiscalYearObject associated with some date,
    // do a one-time calculation of the start and endDates of each specified fiscal year
    // and store them on the objects.

    var initialized = true;
    for (var i = 0; i < fiscalYears.length; i++) {
        if (fiscalYears[i].startDate == null || fiscalYears[i].endDate == null) {
            initialized = false;

            fiscalYears[i].startDate = Date.createDatetime(
                                        fiscalYears[i].year,
                                        fiscalYears[i].month,
                                        fiscalYears[i].date
                                       );
       }
    }
    fiscalYears.setSort({ property: "startDate", direction: "ascending" });
    if (!initialized) {
        for (var i = 0; i < fiscalYears.length; i++) {
            var endDate;

            var fy = fiscalYears[i],
                nextFY = fiscalYears[i+1];
            // If the next entry in the fiscalYears array starts in the following year
            // (or later in the same year), consider that the end date for this FY.
            // Otherwise use the defaultDate/defaultMonth of the next year.
            // This allows the specified fiscalYears array to be sparse
            // (For example custom behavior could be specified for 2000 and 2010 only, and
            // every year in between will use the default month/date start)
            if (nextFY && (nextFY.year == fy.year || (nextFY.year == fy.year+1))) {
                fy.endDate = new Date(nextFY.startDate.getTime()-1);
            } else {

                fy.endDate = Date.createDatetime(
                                fy.year+1, defaultStartMonth, defaultStartDate);
                // reduce by 1ms so it's the end of the prev day
                // This will avoid confusion with whether it rolls over a year
                // if the date is actually jan 1st
                fy.endDate.setTime(fy.endDate.getTime()-1);
            }
        }
    }


    // If we're passed just a year value, return the fiscalYear definition where
    // 'fiscalYear' is set to the specified date (may have to be created)
    if (!isc.isA.Date(date)) {

        var fiscalYearObj = fiscalYears.find("fiscalYear", date);
        if (fiscalYearObj != null) {
             return fiscalYearObj;
        }

        // We know we need to create a new fiscalYear object who's fiscalYear
        // property will be set to the specified date value.
        var calendarYear = date;
        if (fiscalCalendar.defaultYearMode != "start" &&
            (defaultStartMonth != 0 || defaultStartDate != 1))
        {
            calendarYear -= 1;
        }
        // Build a default object and return it.

        return {
            year:calendarYear,
            fiscalYear:date,
            month:defaultStartMonth,
            date:defaultStartDate,
            startDate: isc.DateUtil.getStartOf(new Date(calendarYear, defaultStartMonth, defaultStartDate))
        };

    } else {
        var date_timestamp = date.getTime();
        // Array should already be sorted - re-sort just in case it was missed.
        fiscalYears.sortByProperty("startDate", Array.ASCENDING);
        for (var i = 0; i < fiscalYears.length; i++) {
            if (date_timestamp < fiscalYears[i].startDate.getTime()) break;
            if (date_timestamp <= fiscalYears[i].endDate.getTime()) {
                // date falls between start and end of the specified fiscal year so use it.
                return fiscalYears[i];
            }
        }

        // At this point we know we didn't have an entry in the fiscal years array
        // for this date, so create one based on the default start date
        var dateYear = date.getFullYear(),
            startDate = Date.createDatetime(dateYear,
                                          defaultStartMonth,
                                          defaultStartDate);
        // Date falls before default start date, shift back a year.
        if (startDate.getTime() > date_timestamp) {
            dateYear -= 1;
            startDate = Date.createDatetime(dateYear,
                                          defaultStartMonth,
                                          defaultStartDate);
        }

        // Calculate the endDate - the year it falls in will determine the reported
        // 'fiscalYear'.
        var endDate = Date.createDatetime(dateYear+1,
                                          defaultStartMonth,
                                          defaultStartDate);
        // Shunt back to the end of the prev day.
        endDate.setTime(endDate.getTime()-1);

        // If there's a specified fiscalYear in our array that starts before the
        // calculated endDate, truncate this year a little earlier to account for it.
        var endDate_timestamp = endDate.getTime();
        for (var i = 0; i < fiscalYears.length; i++) {

            if (endDate_timestamp < fiscalYears[i].endDate.getTime()) {
                continue;
            } else {
                if (endDate_timestamp > fiscalYears[i].startDate.getTime()) {
                    endDate = new Date(fiscalYears[i].startDate.getTime()-1);
                } else break;
            }
        }

        var fiscalYear = dateYear;
        // If we span 2 calendar years and the year mode is set to "end",
        // (or unset - since this is default behavior), increment the fiscal year to
        // match the end date.
        if (endDate.getFullYear() != startDate.getFullYear()
             && fiscalCalendar.defaultYearMode != "start")
        {
            if (endDate.getFullYear() < date.getFullYear()) {
                fiscalYear = date.getFullYear();

                var tempStart = new Date(fiscalYear, defaultStartMonth, defaultStartDate);
                if (date.getTime() > tempStart.getTime()) {
                    fiscalYear++;
                }
            } else {
                fiscalYear = endDate.getFullYear();
            }
        }

        return {
            year:dateYear,
            fiscalYear:fiscalYear,
            date:defaultStartDate,
            month:defaultStartMonth
        };

    }
},

//>    @classMethod date.setShowChooserFiscalYearPickers()
// Sets the global attribute that dictates whether the +link{DateChooser, choosers} shelled
// from +link{DateItem, DateItems} show a UI for working with Fiscal Years.
//
// @param showChooserFiscalYearPickers (boolean) whether to show Fiscal Year pickers in DateChoosers by default
// @visibility external
//<
setShowChooserFiscalYearPickers : function (showChooserFiscalYearPickers) {
    isc.DateItem.addProperties({
        showChooserFiscalYearPicker: showChooserFiscalYearPickers
    });
    isc.DateChooser.addProperties({
        showFiscalYearChooser: showChooserFiscalYearPickers
    });
},

//>    @classMethod date.setShowChooserWeekPickers()
// Sets the global attribute that dictates whether the +link{DateChooser, choosers} shelled
// from +link{DateItem, DateItems} show a UI for working with Weeks.
//
// @param showChooserWeekPickers (boolean) whether to show Fiscal Week pickers in DateChoosers by default
// @visibility external
//<
setShowChooserWeekPickers : function (showChooserWeekPickers) {
    isc.DateItem.addProperties({
        showChooserWeekPicker: showChooserWeekPickers
    });
    isc.DateChooser.addProperties({
        showWeekChooser: showChooserWeekPickers
    });
},


//>    @classMethod date.setFirstDayOfWeek()
// Sets the global attribute that dictates which day should be treated as the first day of the
// week in calendars and date calculations.  The parameter is expected to be an integer value
// between 0 (Sunday) and 6 (Saturday).
// <P>
// The default value is picked up from the current locale.
//
// @param firstDayOfWeek (int) the number of the day to use as the first day of the week
// @visibility external
//<
setFirstDayOfWeek : function (firstDayOfWeek) {
    if (isc.DateChooser) {
        if (firstDayOfWeek == null || firstDayOfWeek < 0 || firstDayOfWeek > 6)
            firstDayOfWeek = 0;
        isc.DateChooser.addProperties({firstDayOfWeek: firstDayOfWeek});
    }
},

//>    @classMethod date.getFirstDayOfWeek()
// Returns the global attribute that dictates which day should be treated as the first day of
// the week in calendars and date calculations.  The parameter is expected to be an integer
// value between 0 (Sunday) and 6 (Saturday).
// <P>
// The default value is picked up from the current locale.
//
// @return (int) the number of the day being used as the first day of the week
// @visibility external
//<
getFirstDayOfWeek : function () {
    if (isc.DateChooser) {
        return isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }
    return 0;
},



//>    @classMethod date.getFiscalYear()
// Returns the +link{FiscalYear} object for the fiscal year in which the passed date exists.
//
// @param date (Date | int) the date to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the start of the fiscal period
// @return (FiscalYear) the +link{FiscalYear} object for the passed date
// @visibility external
//<
getFiscalYear : function (date, fiscalCalendar) {
    return Date._getFiscalYearObjectForDate(date, fiscalCalendar);
},

//>    @classMethod date.getFiscalWeek()
// Returns a date's week-number, according to the fiscal calendar
//
// @param date (Date) the date to get the fiscal year for
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of fiscal years
// @return (int) the fiscal week for the passed date
// @visibility external
//<
_millisInADay: (1000 * 60 * 60 * 24),
getFiscalWeek : function (date, fiscalCalendar, firstDayOfWeek) {
    fiscalCalendar = fiscalCalendar || Date.getFiscalCalendar();

    var yearStart = Date.getFiscalStartDate(date, fiscalCalendar),
        logicalYearStart = Date.getLogicalDateOnly(yearStart),
        logicalDate = date.logicalDate ? date : Date.getLogicalDateOnly(date);
    return this._getWeekOffset(logicalDate, logicalYearStart, firstDayOfWeek);
},

// Used by getWeek() / getFiscalWeek()
_stackCount:0,
_getWeekOffset : function (date, startDate, firstDayOfWeek) {

    var dayDiff = Math.round((date - startDate)/86400000);

    // firstDayOfWeek - used for calendar type views.
    // If weeks explicitly start on (say) a monday but the first of the month
    // falls on a tuesday, adjust the week# to account for this offset (return the
    // #weeks from the monday of the week containing the start day).
    var extraDays = 0;
    if (firstDayOfWeek == null) {
        firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");
    }
    if (firstDayOfWeek != null) {
        extraDays = startDate.getDay() - firstDayOfWeek;
        if (extraDays < 0) extraDays += 7;
    }
    // We want to use 1-based weeks (not zero based) - adding 1 and rounding causes issues, so
    // use Math.ceil() instead
    return Math.ceil((dayDiff + extraDays) / 7);
},

//>!BackCompat 2005.11.3
// -- Older depracated synonym of setNormalDisplayFormat
//>    @classMethod        Date.setFormatter()
//  Set the formatter for all date objects to the method name passed in.  After this call
//  all <code>theDate.toNormalDate()</code> calls will fall through to this formatter function to
//  return the date as a string.
//        @group    dateFormatting
//        @param    functionName    (string)    name of a date formatter method on this Date
//      @visibility internal
//<

setFormatter : function (formatter) {
    Date.setNormalDisplayFormat(formatter);
},
//<!BackCompat

//>    @classMethod Date.setLocaleStringFormatter() (A)
// Set default the +link{Date.iscToLocaleString()} formatter for all date instances.
//
//        @param    format (DateDisplayFormat | function) new formatter for iscToLocaleString()
//        @group    dateFormatting
//      @visibility internal
//<

setLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(Date.prototype[functionName]) || isc.isA.Function(functionName))
        Date.prototype.localeStringFormatter = functionName;
},

// Localizing dayName / monthNames
//> @classAttr  Date.shortDayNames  (Array : null : IRWA)
// This property may be set to an array of names of days of the week. <br>
// For example:
// <pre>
// ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]
// </pre>
// The appropriate day name will then be returned from +link{date.getShortDayName()}, and may
// be used whenever SmartClient components display day-names (for example in the
// +link{class:DateItem, DateItem class}).<br>
// Note: For US based applications the first item in the array should be the name for Sunday,
// then Monday, Tuesday, etc. For browsers with different locales this may vary.
// To determine the first day for some locale, you can run the following code:
// <pre>
//    alert(new Date(2000, 0, 2).getDay());
// </pre>
// You should see an alert with a number between zero and 6. This represents the numerical
// 'day' value for Sunday for your browser's locale, since Jan 2nd 2000 was a Sunday.
// Therefore if this code alerted the number 6, Sunday should appear last in your list
// of day-names, and Monday first.
// @group i18nMessages
// @visibility external
//<

//> @classAttr  Date.shortMonthNames  (Array : null : IRWA)
// This property may be set to an array of names of months.<br>
// For example:
// <pre>
// ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
// </pre>
// The appropriate month name will then be returned from +link{date.getShortMonthName()},
// and may be used whenever  SmartClient components display month-names (for example in the
// +link{class:DateItem, DateItem class}).
// @group i18nMessages
// @visibility external
//<

//>    @method        date.getShortMonthNames()    (A)
// Return an array of the short names of each month, suitable for us in a selection list, etc.
// If +link{Date.shortMonthNames} is specified, this list will be used. Otherwise the value
// will be derived from the native browser date formatters.
//        @group    dateFormatting
//
//      @param  length  (int)    Number of characters for each day (Defaults to 3, can't be
//                                  longer than 3)
//        @return        (string[])    array of short month names
//<
getShortMonthNames : function (length) {
    var rawNames = Date.shortMonthNames;



    // NOOP starts - this block of code will never run, because shortMonthNames will alway be set
    if (rawNames == null) rawNames = Date._derivedShortMonthNames;
    if (rawNames == null) {
        var list = Date._derivedShortMonthNames = [];
        for (var i = 0; i < 12; i++) {
            // Changed the day in this synthetic date to 2 in order to derive the
            // correct month in timezones that are ahead of GMT (if you convert
            // midnight on the first of a month to UTC in such timezones, you
            // get the previous month...)
            var date = Date.createLogicalDate(2000,i,2);
            // have deriveShortMonthNames() return the shortened strings according to the
            // internal default (3 chars)
            list[i] = date.deriveShortMonthName(Date.derivedShortMonthNameLength);
        }
        rawNames = Date._derivedShortMonthNames;
    }
    // NOOP ends

    var names = [];
    for (var i =0; i< 12; i++) {
        if (!length) {
            // zero or null length - return the full rawName - we used to default to 3 chars,
            // but that's a bit pointless, since the rawNames are already *short*MonthNames,
            // but they may not be 3 chars long, or of *any* fixed length
            names[i] = rawNames[i];
        } else {
            names[i] = rawNames[i].substring(0,length);
        }
    }
    return names;
},

//>    @method        date.getShortDayNames()    (A)
// Return an array of the short names of each day, suitable for us in a selection list, etc.
// Day names will be picked up from +link{Date.shortDayNames} if specified - otherwise derived
// from the native browser date string.
//        @group    dateFormatting
//
//      @param  length  (int)    Number of characters for each day (Defaults to 3, can't be
//                                  longer than 3)
//        @return        (string[])    array of short day names
//<
getShortDayNames : function (length) {
    length = length || 3;
        var rawNames = Date.shortDayNames;
    if (rawNames == null) rawNames = Date._derivedShortDayNames;
    if (rawNames == null) {
        Date._derivedShortDayNames = [];
        var dateObj = new Date();
        dateObj.setDate(1);
        if (dateObj.getDay() > 0) dateObj.setDate(dateObj.getDate() + (7-dateObj.getDay()));
        var startDate = dateObj.getDate();
        for (var i = 0; i < 7; i++) {
            dateObj.setDate(startDate + i);
            Date._derivedShortDayNames[i] = dateObj.deriveShortDayName();
        }
        rawNames = Date._derivedShortDayNames;
    }
    var names = [];
    for (var i = 0; i < 7; i++) {
        names[i] = rawNames[i].substring(0,length);
    }
    return names;
},

//> @classAttr Date.weekendDays (Array of int : [0, 6] : IR)
// Days that are considered "weekend" days.   Values should be the integers returned by the
// JavaScript built-in Date.getDay(), eg, 0 is Sunday and 6 is Saturday.  Override to
// accommodate different workweeks such as Saudi Arabia (Saturday -> Wednesday) or Israel
// (Sunday -> Thursday).
//
// @visibility external
//<

//> @classMethod Date.setWeekendDays()
// Sets the days that are considered +link{Date.weekendDays, weekend days}.  The parameter
// should be array of the integers returned by the JavaScript built-in Date.getDay(), eg, 0 is
// Sunday and 6 is Saturday.  Override to accommodate different workweeks such as Saudi Arabia
// (Saturday -> Wednesday) or Israel (Sunday -> Thursday).
//
// @param weekendDays (Array of Integer) the array of day-numbers to assign as weekend days
// @visibility external
//<
setWeekendDays : function (weekendDays) {
    Date.weekendDays = weekendDays;
},

//> @classMethod Date.getWeekendDays()
// Return an array of days that are considered "weekend" days. Values will be the integers
// returned by the JavaScript built-in Date.getDay(), eg, 0 is Sunday and 6 is Saturday.
// Override +link{date.weekendDays} to accommodate different workweeks such as Saudi Arabia
// (Saturday -> Wednesday) or  Israel (Sunday -> Thursday).
// @group dateFormatting
//
// @return (Array of integer) array of weekend days
// @visibility external
//<
getWeekendDays : function () {
    var daysArr = Date.weekendDays;
    if (daysArr == null) daysArr = Date._derivedWeekendDays;
    if (daysArr == null) {
        daysArr = Date._derivedWeekendDays = [0, 6];
    }
    return daysArr;
},

getFormattedDateRangeString : function (fromDate, toDate) {
    if (fromDate != null && !isc.isA.Date(fromDate)) {
        fromDate = null;
    }
    if (toDate != null && !isc.isA.Date(toDate)) {
        toDate = null;
    }
    var fromMonth = fromDate ? fromDate.getMonth() : null,
        fromMonthName = fromDate ? fromDate.getShortMonthName() : null,
        fromYear = fromDate ? fromDate.getFullYear() : null,
        fromDay = fromDate ? fromDate.getDate() : null,
        toMonth = toDate ? toDate.getMonth() : null,
        toMonthName = toDate ? toDate.getShortMonthName() : null,
        toYear = toDate ? toDate.getFullYear() : null,
        toDay = toDate ? toDate.getDate() : null,
        result = ""
    ;

    if (fromDate && toDate) {
        if (fromYear == toYear) {
            // dates are in the same year - check the months
            if (fromMonth == toMonth) {
                // dates are in the same month - check the day-numbers
                if (fromDay == toDay) {
                    // dates are the same - use just the one date
                    result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear;
                } else {
                    // day-numbers are different, use "month start - end, year"
                    result = fromMonthName + " " + fromDate.getDate() + " - " +
                        toDate.getDate() + ", " + fromYear;
                }
            } else {
                // dates are in different months, use "month start - month end, year"
                result = fromMonthName + " " + fromDate.getDate() + " - " +
                    toMonthName + " " + toDate.getDate() + ", " + fromYear;
            }
        } else {
            // different years - use "month start year - month end year"
                result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear + " - " +
                    toMonthName + " " + toDate.getDate() + ", " + toYear;
        }
    } else if (fromDate) {
        // only a fromDate provided use "month start - end, year"
        result = fromMonthName + " " + fromDate.getDate() + ", " + fromYear;
    } else if (toDate) {
        // only a toDate provided use "month start - end, year"
        result = toMonthName + " " + toDate.getDate() + ", " + toYear;
    }

    return result;
}

});

//
//    add methods to the Date.prototype for additional formatting options
//
isc.addMethods(Date.prototype, {

//>    @method        date.duplicate()    (A)
//      Copy the value of this date into a new Date() object for independent manipulation
//  @visibility external
//<
duplicate : function () {
    var newDate = new Date();
    newDate.setTime(this.getTime());
    newDate.logicalDate = this.logicalDate;
    newDate.logicalTime = this.logicalTime;
    newDate._fromRelativeDate = this._fromRelativeDate;
    newDate._relativeDateTimestamp = this._relativeDateTimestamp
    return newDate;
},

//>    @method        date.clearTimeFields()    (A)
//            Zero-out the time fields for a date.
//        @group    dateFormatting
//<
clearTimeFields : function () {
    this.setHours(0);
    this.setMinutes(0);
    this.setSeconds(0);
    this.setMilliseconds(0);
    return this;
},




// Determine the day name from this.toString()
deriveShortDayName : function (length) {
    var string = this.toString();
    if (length == null || length <=0 || length > 3) length = 3;
    return string.substring(0,length);
},

//>    @method        date.getShortDayName()
// Return the abbreviated (up to 3 chars) day of week name for this date (Mon, Tue, etc).
// To modify the value returned by this method, set +link{Date.shortDayNames}
//
//        @group    dateFormatting
//      @param  length  (int)    Number of characters to return (Defaults to 3, can't be
//                                  longer than 3)
//        @return        (string)    Abbreviated day name
//      @visibility external
//<
getShortDayName : function () {
    return Date.getShortDayNames()[this.getDay()];
},

// deriveShortMonthNames() - figure out the names of months from the native browser
// date formatting methods.
deriveShortMonthName : function (length) {
    // Use this.toUTCString - to work around Opera's different toString format
    var string = this.toUTCString();
    var start = 8;  // The correct start point if we have a 2-digit day portion in the date
    if (length == null || length < 0 || length > 3) length = 3;
    if (string.substring(6, 7) == ' ') {  // we have a single-digit day number - only IE
                                          // does this, the others put a leading 0 in
        start = 7;
    }
    return string.substring(start, (start+length));
},


//>    @method        date.getShortMonthName()
// Return the abbreviated (up to 3 chars) name of the month for this date (Jan, Feb, etc)
// To modify the value returned by this method,
// <var class="smartclient">set +link{Date.shortMonthNames}</var>
// <var class="smartgwt">use {@link com.smartgwt.client.util.DateUtil#setShortMonthNames()}</var>.
//        @group    dateFormatting
//      @param  length  (int)    Number of characters to return (Defaults to 3, can't be
//                                  longer than 3)
//        @return        (string)    Abbreviated month name (3 character string)
//  @visibility external
//<
getShortMonthName : function () {
    return Date.getShortMonthNames()[this.getMonth()];
},

//>    @method        date.getShortYear()
//      Return a 2 digit year for this date.
//    @group    dateFormatting
//    @return        (string)    year number, padded to 2 characters
//  @visibility external
//<
getShortYear : function () {
    var year = this.getFullYear();
    return (year % 100).stringify(2);
},

//>    @method date.getWeek()
// Returns an integer containing the week number
// @group dateFormatting
// @return (int) week number, starting with 1
// @visibility external
//<
getWeek : function (firstDayOfWeek) {
    var logicalDate = this;

    // Normalize to a logical date, and compare with the logical
    // first day of the year - this will get rid of any oddities around time of day
    // and custom timezones etc (any datetime within the logical day will round to the
    // same logicalDate object)
    if (!this.logicalDate) {
        logicalDate = Date.getLogicalDateOnly(this);
    }
    var yearStart = Date.createLogicalDate(this.getFullYear(),0,1);

    return Date._getWeekOffset(logicalDate, yearStart, firstDayOfWeek);
},

getFiscalCalendar : function () {
    return Date.getFiscalCalendar();
},

//>    @method date.getFiscalYear()
// Returns the +link{FiscalYear} object appropriate for the the current date, according to the
// +link{FiscalCalendar, FiscalCalendar}.
// @return (FiscalYear) the fiscal year object
// @visibility external
//<
getFiscalYear : function (fiscalCalendar) {
    return Date.getFiscalYear(this, fiscalCalendar);
},

//>    @method date.getFiscalWeek()
// Returns the fiscal week number of the current date, according to the global
// +link{Date.setFiscalCalendar, FiscalCalendar}.
// @param [fiscalCalendar] (FiscalCalendar) the object representing the starts of fiscal years
// @return (int) the week number, offset from the start of the fiscal period
// @visibility external
//<
getFiscalWeek : function (fiscalCalendar, firstDayOfWeek) {
    return Date.getFiscalWeek(this, fiscalCalendar, firstDayOfWeek);
},

//
// Date Formatters (toNormalDate(), toShortDate(), etc.)
//
// Date formatters are applied to date objects to convert them into strings for display.
// Dates are intended to be localizable.
// For localization, a developer would typically set either the shortDateFormatter or
// normalDateFormatter, as well as the inputDateFormat, and then call
// "toNormalDate()" / "toShortDate()" and "parseInput()" as normal.

//>    @method        date.toDateStamp()
//            Return this date in the format (UTC timezone):
//                <code><i>YYYYMMDD</i>T<i>HHMMSS</i>[Z]</code>
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//  @visibility external
//<
toDateStamp : function () {
    return    this.getUTCFullYear()
          + (this.getUTCMonth()+1).stringify()
          + this.getUTCDate().stringify()
          + "T"
          +    this.getUTCHours().stringify()
          + this.getUTCMinutes().stringify()
          + this.getUTCSeconds().stringify()
          + "Z";
},

//>    @method date.toNormalDate()
// Returns the date as a formatted string using the format set up via the
// <code>setNormalDisplayFormat()</code> method. Note that the default formatter for this
// method is <code>"toLocaleString"</code>.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @return  (string) formatted date string
// @visibility external
//<
// This method is used by our data components such as ListGrid to display long format dates.
// @param useCustomTimezone (boolean) If true, format the date using the timezone
//  setDefaultDisplayTimezone() rather than the native browser locale.
//  Defaults to true.
//  Has no effect if no custom timezone applied
//  * Note that the native browser formatters including toLocaleString won't respect the
//    developer specified timezone of course. We could workaround this (create a new date, shift
//    by offset between specified timezone and native timezone, and call the native formatter on that)
//    but we currently don't.
toNormalDate : function (formatter, useCustomTimezone) {


    if (!formatter) formatter = this.formatter;
    // fire the formatter in the scope of this date, so date is available as 'this'

    if (isc.isA.Function(formatter)) {
        return formatter.apply(this, [useCustomTimezone])
    } else if (this[formatter]) {
        return this[formatter](useCustomTimezone);
    }
},

toNormalDateTime : function (formatter, useCustomTimezone) {
    return this.toNormalDatetime(formatter, useCustomTimezone);
},

//>    @method date.toNormalDatetime()
// Returns the datetime as a formatted string using the format set up via the
// <code>setNormalDatetimeDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   To suppress this behavior, this parameter should be set to false.
// @return  (string) formatted date string
// @visibility external
//<
toNormalDatetime : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this.datetimeFormatter;
    return this.toNormalDate(formatter, useCustomTimezone);
},

//>    @method date.toShortDate()
// Returns the date as a formatted string using the format set up via the
// <code>setShortDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   to suppress this behavior, this parameter should be set to false.
// @return  (string) formatted date string
// @visibility external
//<

toShortDate : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this._shortFormat;
    if (isc.isA.Function(formatter)) return formatter.apply(this, [useCustomTimezone]);
    else if (isc.isA.Function(this[formatter])) {
        if (formatter == "toSerializeableDate") return this[formatter]();
        return this[formatter](useCustomTimezone);
    }

    isc.logWarn("Date.toShortDate() specified formatter not understood:" + formatter);
    return this.toUSShortDate();

},


//>    @method date.toShortDateTime()
// Returns the datetime as a formatted string using the format set up via the
// <code>setShortDatetimeDisplayFormat()</code> method.
// @group   dateFormatting
// @param format (DateDisplayFormat) Optional Format for the date returned
// @param [useCustomTimezone] (Boolean) If a custom timezone has been set via
//   Time.setDefaultDisplayTimezone(), by default date formatters will respect this timezone.
//   to suppress this behavior, this parameter should be set to false.
// @return  (string) formatted date string
// @visibility external
//<



toShortDateTime : function (formatter, useCustomTimezone) {
    return this.toShortDatetime(formatter,useCustomTimezone);
},

toShortDatetime : function (formatter, useCustomTimezone) {
    if (!formatter) formatter = this._shortDatetimeFormat;
    return this.toShortDate(formatter, useCustomTimezone);
},


//>    @method date.setDefaultDateSeparator
// Sets a new default separator that will be used when formatting dates. By default, this
// is a forward slash character: "/"
// @group dateFormatting
// @param separator (string) separator to use in dates
// @visibility external
//<
setDefaultDateSeparator : function (separator) {
    this._shortDateTemplate = [,,,,separator,,,,,separator,,,,null];
    this._separator = separator;
},

//>    @method date.getDefaultDateSeparator
// gets the default date separator string
// @group dateFormatting
// @return(string) the default date separator
// @visibility external
//<
getDefaultDateSeperator : function (separator) {
    if (this._separator) return this._separator;
    else return "/";
},


_shortDateTemplate:[,,,,"/",,,,,"/",,,,null],
_$MDY:"MDY",
_$DMY:"DMY",
_$YMD:"YMD",
_$MDY:"MDY",

// _applyTimezoneOffset()
// shift a date by some arbitrary number of hours/minutes
// third parameter allows you to specify the starting date time [result of date.getTime()]
// to offset from
_applyTimezoneOffset : function (hourOffset, minuteOffset, dateTime) {
    if (dateTime == null) dateTime = this.getTime();
    if (isc.isA.Number(hourOffset)) dateTime += (3600000 * hourOffset);
    if (isc.isA.Number(minuteOffset)) dateTime += (60000 * minuteOffset);
    this.setTime(dateTime);
},

// _getTimezoneOffsetDate()
// This is a helper method - given a date with a certain UTC time, apply an explicit timezone
// offset to return a date where the UTC time is offset by the specified hours/minutes.
// We'll use this when formatting dates for display in arbitrary local times [so we can't just
// use the native browser local timezone methods like getHours()]

_getTimezoneOffsetDate : function (hourOffset, minuteOffset) {
    var offsetDate = Date._timezoneOffsetDate;
    if (offsetDate == null) offsetDate = Date._timezoneOffsetDate = new Date();

    offsetDate._applyTimezoneOffset(hourOffset, minuteOffset, this.getTime());
    return offsetDate;

},


// _toShortDate()
// Internal method to give us a shortDate - either DD/MM/YYYY, MM/DD/YYYY or YYYY/MM/DD.
// this will be passed "MDY" / "DYM" / etc. as a format parameter.
// useCustomTimezone parameter: use the hour and minute offset specified by
// Time.setDefaultDisplayTimezone() rather than the native browser local timezone
_$zero:"0",
_toShortDate : function (format, useCustomTimezone) {

    // if this is a "logical date", don't use the developer-specified custom timezone when
    // formatting. Typically handled by DBC's passing in the useCustomTimezone parameter, but
    // we can also check for the logical date marker

    if (useCustomTimezone == null) {
        useCustomTimezone = !this.logicalDate;
    }
    var template = this._shortDateTemplate,
        month,day,year;

    // Browser native locale timezone
    if (!useCustomTimezone || !isc.Time._customTimezone) {
        month = this.getMonth()+1;
        day = this.getDate();
        year = this.getFullYear();

    // Developer specified custom timezone
    } else {
        var offsetDate = this._getTimezoneOffsetDate(
                            isc.Time.getUTCHoursDisplayOffset(this),
                            isc.Time.getUTCMinutesDisplayOffset(this)
                         );

        month = offsetDate.getUTCMonth() + 1;
        day = offsetDate.getUTCDate();
        year = offsetDate.getUTCFullYear();
    }

    var monthIndex, dayIndex, yearIndex;

    if (format == this._$MDY) {
        monthIndex = 0;
        dayIndex = 5;
        yearIndex = 10;
    } else if (format == this._$DMY) {
        dayIndex = 0;
        monthIndex = 5;
        yearIndex = 10;
    } else if (format == this._$YMD) {
        yearIndex = 0;
        monthIndex = 5;
        dayIndex = 10
    // Unlikely - don't bother avoiding string alloc's for every one of these options
    } else {
        dayIndex = format.indexOf("D")*5;
        yearIndex = format.indexOf("Y")*5;
        monthIndex = format.indexOf("M")*5;
    }

    // Note: each number has 4 slots so it can accommodate a full year
    // For month/day - if we need a leading zero, fill the first slot with it
    // Use fillNumber to fill 3 slots even though we have a max of 2 digits to ensure
    // the last slot gets cleared out if it was populated by a year already.
    template[dayIndex] = day < 10 ? this._$zero : null
    isc._fillNumber(template, day, dayIndex+1, 3);

    template[monthIndex] = month < 10 ? this._$zero : null
    isc._fillNumber(template, month, monthIndex+1, 3);

    template[yearIndex + 1] = null;
    isc._fillNumber(template, year, yearIndex, 4);
    return template.join(isc.emptyString);
},

//>    @method        date.toUSShortDate()
//            Return this date in the format: <code>MM/DD/YYYY</code>
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//  @visibility external
//<
toUSShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$MDY, useCustomTimezone);
},

// _toShortTime - returns the time portion of the date in HH:MM
_timeTemplate:[null,null],
_toShortTime : function (useCustomTimezone) {

    return isc.Time.toShortTime(this, "toShortPadded24HourTime");
},

//>    @method        date.toUSShortDateTime()
//  Return this date in the format: <code>MM/DD/YYYY HH:MM</code>
//
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//  @visibility external
//<
toUSShortDateTime : function (useCustomTimezone) {
    return this.toUSShortDatetime(useCustomTimezone);
},


toUSShortDatetime : function (useCustomTimezone) {
    return this.toUSShortDate(useCustomTimezone) + " " + this._toShortTime(useCustomTimezone);
},


//>    @method        date.toEuropeanShortDate()
//            Return this date in the format: <code>DD/MM/YYYY</code>
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//      @visibility external
//<
toEuropeanShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$DMY, useCustomTimezone);
},

//>    @method        date.toEuropeanShortDateTime()
// Return this date in the format: <code>DD/MM/YYYY HH:MM</code>.
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//      @visibility external
//<
toEuropeanShortDateTime : function (useCustomTimezone) {
    return this.toEuropeanShortDatetime();
},


toEuropeanShortDatetime : function (useCustomTimezone) {
    return this.toEuropeanShortDate(useCustomTimezone) + " " +
            this._toShortTime(useCustomTimezone);
},

//> @method date.toJapanShortDate()
// Return the date in this format: <code>YYYY/MM/DD</code>
// @group dateFormatting
// @return (string) formatted date string
// @visibility external
//<
toJapanShortDate : function (useCustomTimezone) {
    return this._toShortDate(this._$YMD, useCustomTimezone);
},

//>    @method        date.toJapanShortDateTime()
//            Return this date in the format: <code>YYYY/MM/DD HH:MM:SS</code>
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//      @visibility external
//<
toJapanShortDateTime : function (useCustomTimezone) {
    return this.toJapanShortDatetime(useCustomTimezone);
},


toJapanShortDatetime : function (useCustomTimezone) {
    return this.toJapanShortDate(useCustomTimezone) + " " + this._toShortTime(useCustomTimezone);
},

//>    @method        date._serialize()    (A)
//            Serialize this date to a string in a format that can be reinstantiated back into a date.
//                <code>$$DATE$$:<i>YYYY</i>-<i>MM</i>-<i>DD</i></code>
//        @group    dateFormatting
//        @return                    (string)    formatted date string
//      @visibility internal
//<
_serialize : function () {
    if (isc.Comm._legacyJSMode) {
        // legacy mode: add $$DATE$$ that only our server-side JS parser understands
        return isc.SB.concat('"' + this.toDBDate(), '"');
    } else {
        // any other caller: return code that would reconstruct the same Date in a JS
        // interpreter

        return isc.SB.concat("new Date(", this.getTime(), ")");
    }
},



//> @groupDef dateFormatAndStorage
// The SmartClient system has the following features for handling Date and Time type values
// within DataSources and databound components.
// <P>
// DataSources and databound components may define fields of type <code>date</code>,
// <code>time</code>, or <code>datetime</code>.
// <P>
// <h3>"date" handling</h3>
// <P>
// Fields of type +link{type:FieldType,date} are considered to be logical Dates with no time
// value, such as a holiday or birthday.  In the browser, values for "date" fields are stored
// as Date objects, but when formatted for display to the user, they are typically displayed
// without any time information.
// <P>
// When using the SmartClient server framework, "date" values are automatically transmitted
// with year, month and day preserved and time value ignored.
// <P>
// When sent or received in XML or JSON, date field values should be serialized in the
// <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema date format</a> -
// <code>YYYY-MM-DD</code> - are expected to be received in the same format.  Any time value
// present for a "date" field is ignored.
// <var class="smartclient">
// <P>
// The +link{Date.createLogicalDate()} method may be used to create a new Date object to represent
// a logical date value on the browser.
// </var>
// <var class="smartgwt">
// <P>
// The DateUtil.createLogicalDate() method may be used to create a new Date object to represent
// a logical date value on the browser.
// </var>
// <P>
// System wide formatting for dates may be controlled via the
// +link{Date.setNormalDisplayFormat()} and +link{Date.setShortDisplayFormat()} methods.
// <P>
// <h3>"datetime" handling</h3>
// <P>
// Fields of type +link{type:FieldType,datetime} are dates with full time information.
// In the browser, values for datetime fields are stored as Date objects.
// <P>
// When using the SmartClient server framework, "datetime" values are automatically transmitted
// such that the resulting Date object has the same GMT/UTC timestamp (milliseconds since
// epoch).
// <P>
// When sent or received in XML or JSON, datetime field values should be serialized out as full
// datetimes using the standard
// <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema date format</a>
// (EG:<code>2006-01-10T12:22:04-04:00</code>).  If no timezone offset is supplied, the value
// is assumed to be GMT/UTC.
// <P>
// System wide formatting for datetimes may be controlled via the
// +link{Date.setShortDatetimeDisplayFormat()} method.  Datetimes will be displayed to the user
// in browser local time by default (see also timezone notes below).
// <P>
// <h3>"time" handling</h3>
// <P>
// Fields of type +link{type:FieldType,time} are time values in the absence of a day, such as
// the beginning of the workday (9:00).  In the browser, values for "time" fields are stored as
// Date objects with the time in browser local time.  The date information has no meaning and
// only the time information is displayed to the user.
// <P>
// Time formatting is handled by the +link{Time} class APIs.
// <br>
// When using the SmartClient server framework, "time" values are automatically transmitted
// such that the resulting Date object has the same hour, minute and second values in local
// time, and year/month/day is ignored.
// <P>
// When sent or received in XML or JSON, date field values should be serialized as hours,
// minutes and seconds using the standard
// <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema time
// format</a> - <code>"22:01:45"</code>.  Timezone is not relevant and should be omitted.
// <var class="smartclient">
// <P>
// The +link{Date.createLogicalTime()} method may be used to create a new Date object to represent
// a logical time value on the browser.
// </var>
// <var class="smartgwt">
// <P>
// The DateUtil.createLogicalTime() method may be used to create a new Date object to represent
// a logical time value on the browser.
// </var>
// <P>
// <h3>Timezone settings and Daylight Savings Time</h3>
// <P>
// By default, "datetime" values will be shown to the user in browser local time, as derived
// from the native browser locale.  Developers may modify this behavior by specifying an
// explicit display timezone via +link{Time.setDefaultDisplayTimezone()}.
// <P>
// Note that depending on the specific date being displayed, a Daylight Savings Time offset may
// also be applied based on the browser locale.  To disable this behavior set
// +link{isc.Time.adjustForDST} to false.
// <P>
// If a custom timezone is specified, it will be respected by all +link{TimeDisplayFormat}s, and
// by the standard short +link{DateDisplayFormat}s when formatting dates representing datetime
// type values. However native JavaScript Date formatters,
// including <code>toLocaleString()</code> will not respect the specified timezone. Developers
// specifying a custom timezone may therefore wish to modify the +link{Date.setNormalDisplayFormat()}
// to avoid using a native JS Date formatter function.
// <P>
// Note that in addition to the system-wide date, datetime and time-formatting settings described
// above, databound components also support applying custom display formats for date values.
// Typically this can be achieved via a custom <code>dateFormatter</code> or
// <code>timeFormatter</code> at the field level (see +link{dataSourceField.dateFormatter},
// +link{dataSourceField.timeFormatter} and for example +link{listGridField.dateFormatter}).
// Date formatting may also be configured at the component level by setting the
// <code>dateFormatter</code>, <code>datetimeFormatter</code> and <code>timeFormatter</code>
// attributes (See for example +link{listGrid.dateFormatter}, +link{listGrid.timeFormatter},
// and +link{listGrid.datetimeFormatter}).
// <P>
// <h3>Troubleshooting Date and Time values</h3>
// <P>
// Date and time storage and timezones can be confusing, and Isomorphic receives a steady
// stream of false bug reports from users that are incorrectly analyzing logs and diagnostics.
// Please consider the following points when troubleshooting issues such as date values
// changing to a different day, or datetime value shifting when saved and reloaded:
// <P>
// <h4>1. compare values for "datetime" fields via date.getTime()</h4>
// <P>
// Whenever you use Date.toString() (client or server-side) the value you get is based on the
// server or browser timezone.
// <P>
// Perhaps you are troubleshooting an issue with datetimes and you try to log the value of a
// Date like this:
// <pre>
//    Date someDate = &lt;<i>some expression</i>&gt;;
//    log("date value is: " + someDate);
// </pre>
// Code like this will show the datetime value in the server's timezone if executed
// server-side, and in the client's timezone if executed client-side.  If they are in different
// timezones, the hour or day will be different, <b>whereas the actual datetime value -
// milliseconds since epoch as retrieved by Date.getTime() - is the same</b>.  To correctly
// compare two datetime values, compare the result of getTime().
// <P>
// <h4>2. "date" and "time" field values <b>cannot</b> be compared via getTime()</h4>
// <P>
// This is the inverse situation as for "datetime" values.  As explained above, "date" values
// have no meaningful values for time fields (hours/minutes/seconds) and "time" values have no
// meaningful values for date fields (month/day/year).  Here, the result of Date.getTime() is
// not meaningful, and values should be compared via getHours(), getMonth() et al.
// <P>
// <h4>3. the display timezone does not affect Date.getHours(), Date.getDay() et al</h4>
// <P>
// If you've called setDefaultDisplayTimezone() to cause all datetime values to be rendered in
// a particular timezone, this does not affect the return values of Date.getHours(), which will
// still return values for the browser's current timezone.  Hence it is not a bug if you have a
// "datetime" value which is displaying as 4am, but getHours() returns 10 or some other
// number.  This just reflects the timezone offset between the timezone passed to
// setDefaultDisplayTimezone() and the browser's local timezone.
// <P>
// <h4>4. use correct DataSourceField types and use the matching FormItem type</h4>
// <P>
// If you declare a field as type "date" but values you provide actually contain specific
// hours, minutes and seconds, these will not be preserved.  The system will discard or reset
// the hours, minutes and seconds in the course of serialization or editing.  Likewise
// if you declare a field as type "time" but actually provide values where year, month and day
// have meaning, these values will be dropped.
// <P>
// Similarly, DateItem expects values for "date" fields, TimeItem expects values for "time"
// fields, and DateTimeItem expects values for "datetime" fields.  Providing the wrong type of
// value to a control, such as providing a value from a "datetime" field to a DateItem, will
// have unspecified results.
// <P>
// <var class="smartclient">
// If you want to take the date and time aspects of a "datetime" value and edit them in separate
// FormItems, use +link{Date.getLogicalDateOnly()} and +link{Date.getLogicalTimeOnly()} to
// split a datetime value into date and time values, and use
// +link{Date.combineLogicalDateAndTime()} to re-combine such values. Otherwise it is very
// easy to make mistakes related to timezone offsets.
// </var>
// <var class="smartgwt">
// If you want to take the date and time aspects of a "datetime" value and edit them in separate
// FormItems, use
// <code>getLogicalDateOnly()</code> and <code>DateUtil.getLogicalTimeOnly()</code> to
// split a datetime value into date and time values, and use
// <code>DateUtil.combineLogicalDateAndTime()</code> to re-combine
// such values. Otherwise it is very
// easy to make mistakes related to timezone offsets.
// </var>
// <P>
// <h4>5. check data at every phase when troubleshooting</h4>
// <P>
// If you're having a problem with round-tripping "datetime" values or "date" values shifting
// to another day, you need to isolate the problem to a specific layer.  Bearing in mind the
// techniques above for comparing values, you potentially need to look at any/all of the
// following:
// <ol>
// <li> what value do I have on the server-side before it's sent to the client?
// <li> what value is being transmitted to the client? (use the RPC Tab of the Developer
// Console to see the actual data sent)
// <ul>
// <li> was the value shifted to a different time/date by my serialization approach?
// <li> does it have the right format? (see above for correct JSON/XML formats)
// </ul>
// <li> what value do I have on the client before it gets to any widgets (eg, do a direct call
// to +link{DataSource.fetchData()} and inspect the data in the callback)
// <li> what value does the FormItem or other editing widget report before saving is attempted?
// <li> what value is reported right before the value is serialized for transmission to the
// server (+link{DataSource.transformRequest()} is a good place to check)
// <li> what value is being transmitted to the server? (use the RPC tab - same concerns as for
// server-to-client transmission above)
// <li> what value does the server have after de-serialization, before saving to the database
// or other permanent storage?
// <li> what value is sent to the database or permanent storage?  If generating SQL or another
// similar query language, does the value in the SQL statement include an explicit timezone?
// If not, how will the database interpret it?
// </ol>
//
// @title Date and Time Format and Storage
// @treeLocation Concepts
// @visibility external
//<


_xmlSerialize : function (name, type, namespace, prefix) {
    return isc.Comm._xmlValue(name, this.toSchemaDate(),
                              type || (this.logicalDate ? "date" :
                                        (this.logicalTime &&
                                        !isc.DataSource.serializeTimeAsDatetime ? "time" : "datetime")),
                              namespace, prefix);
},

// logicalType parameter - option to specify "date" vs "datetime" vs "time" which impacts
// how this date instance should be serialized out.
// Alternatively logicalDate / logicalTime attributes may be hung onto the date objet
// directly.
// Used by DataSources when serializing dates out
toSchemaDate : function (logicalType) {
    // logical date values have no meaningful time
    // Note that they also have "no meaningful timezone" - we display native browser locale time
    // to the user and when we serialize to send to the server we serialize in that same
    // local timezone.
    if ((logicalType == "date") || this.logicalDate) {
        return isc.SB.concat(
            this.getFullYear().stringify(4),
            "-",
            (this.getMonth() + 1).stringify(2),     // getMonth() is zero-based
            "-",
            this.getDate().stringify(2)
        );
    };

    // logical times are serialized as truncated schema strings (HH:MM:SS) by default
    if ((!isc.DataSource || !isc.DataSource.serializeTimeAsDatetime) &&
        (logicalType == "time" || this.logicalTime))
    {
        return isc.SB.concat(
            this.getHours().stringify(2), ":",
            this.getMinutes().stringify(2), ":",
            this.getSeconds().stringify(2)
        );
    }

    // represent date time values in UTC
    return isc.SB.concat(
            this.getUTCFullYear().stringify(4),
            "-",
            (this.getUTCMonth() + 1).stringify(2),     // getMonth() is zero-based
            "-",
            this.getUTCDate().stringify(2),
            "T",
            this.getUTCHours().stringify(2),
            ":",
            this.getUTCMinutes().stringify(2),
            ":",
            this.getUTCSeconds().stringify(2)
    );
},

//>    @method        date.toSerializeableDate()    (A)
// Return this date in 'serialized' format <code>YYYY-MM-DD HH:MM:SS</code>
// @group dateFormatting
// @return (String) formatted date string
// @visibility external
//<

toSerializeableDate : function (useCustomTimezone) {
    var output = isc.SB.create();
    output.append(
            this.getFullYear().stringify(4),
            "-",
            (this.getMonth() + 1).stringify(2),     // getMonth() is zero-based
            "-",
            this.getDate().stringify(2)
    );

    output.append(isc.Comm.xmlSchemaMode ? "T" : " ",
                  isc.Time.toShortTime(this, "toPadded24HourTime"));
    return output.toString();
},

//>    @method        date.toDBDate()    (A)
//            Return this date in the format the database can parse as a datetime:
//                <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//        @group    dateFormatting
//
//        @return                    (string)    formatted date string
//  @visibility internal
//<
// Leave this internal for now
toDBDate : function () {
    return isc.StringBuffer.concat(
            "$$DATE$$:",
            this.toSerializeableDate()
            );
},


//>    @method        date.toDBDateTime()    (A)
//            Return this date in the format the database can parse as a dateTime:
//                <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//        @group    dateFormatting
//
//        @return                    (string)    formatted date string
//      @visibility internal
//<

toDBDateTime : function () {    return this.toDBDate();       },

//>    @method        date.setFormatter()
//  Set the formatter for this date object to the method name passed in.  After this call
//  wherever appropriate SmartClient components will use this formatter function to return
//  the date as a string.
//        @group    dateFormatting
//        @param    functionName    (string)    name of a date formatter method on this Date
//      @visibility external
//      @deprecated As of SmartClient 5.5 use the static methods
//              +link{classMethod:Date.setNormalDisplayFormat} and
//              +link{classMethod:Date.setShortDisplayFormat} to set default formatters for all dates
//<
setFormatter : function (formatter) {
    this.setNormalDisplayFormat(formatter);
},

//>    @method    date.setLocaleStringFormatter() (A)
//            Set the <code>iscToLocaleString()</code> formatter for a specific date object.
//            After this call, all  <code>theDate.toLocaleString()</code>  calls will yield a string
//             in this format.
//
//        @param    functionName    (string)    name of a dateFormatting function
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5 use the static method
//                  +link{classMethod:Date.setLocaleStringFormatter} instead
//<

setLocaleStringFormatter : function (functionName) {
    if (isc.isA.Function(this[functionName]) || isc.isA.Function(functionName))
        this.localeStringFormatter = functionName;
},

// ------------------------Advanced Date Comparison -------------------------------------------
// (currently undocd)
isBeforeToday : function (dateObj) {
    var today = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0).getTime();
    if (dateObj.getTime() < today) return true;
    else return false;
},

isToday : function (dateObj) {
    if (this.getFullYear() == dateObj.getFullYear() && this.getMonth() == dateObj.getMonth()
        && this.getDate() == dateObj.getDate())
        return true;
    else return false;
},

isTomorrow : function (dateObj) {
    var tomorrowStart = new Date(this.getFullYear(), this.getMonth(), this.getDate() + 1, 0);
    var tomorrowEnd = new Date(this.getFullYear(), this.getMonth(), this.getDate() + 1, 23);
    var dateTime = dateObj.getTime();
    if (dateTime >= tomorrowStart.getTime() && dateTime <= tomorrowEnd.getTime()) {
        return true;
    } else {
        return false;
    }
},

isThisWeek : function (dateObj) {
    var weekStart = new Date(this.getFullYear(), this.getMonth(), this.getDate() - this.getDay(), 0);
    var weekEnd = new Date(this.getFullYear(), this.getMonth(), this.getDate() + (7 - this.getDay()), 23);
    var dateTime = dateObj.getTime();
     if (dateTime >= weekStart.getTime() && dateTime <= weekEnd.getTime()) {
        return true;
    } else {
        return false;
    }
},

isNextWeek : function (dateObj) {
    var weekStart = new Date(this.getFullYear(), this.getMonth(), (this.getDate() - this.getDay()) + 7, 0);
    var weekEnd = new Date(this.getFullYear(), this.getMonth(), (this.getDate() - this.getDay()) + 14, 23);
    var dateTime = dateObj.getTime();
     if (dateTime >= weekStart.getTime() && dateTime <= weekEnd.getTime()) {
        return true;
    } else {
        return false;
    }
},

isNextMonth : function (dateObj) {
    var monthStart = new Date(this.getFullYear(), this.getMonth());
    monthStart.setMonth(monthStart.getMonth() + 1);
    if (monthStart.getFullYear() == dateObj.getFullYear() && monthStart.getMonth() == dateObj.getMonth()) {
        return true;
    } else {
        return false;
    }
},

getWeekNumber : function() {
    var d = new Date(this);
    d.setHours(0,0,0);
    // The ISO standard is: the first week of a year is the one that contains the year's
    // first Thursday.  http://en.wikipedia.org/wiki/ISO-8601#Week_dates
    d.setDate(d.getDate() + 4 - (d.getDay()||7));
    // Get first day of year
    var yearStart = new Date(d.getFullYear(),0,1);
    // Calculate full weeks to nearest Thursday
    var weekNo = Math.ceil(( ( (d - yearStart) / 86400000) + 1)/7);
    // Return array of year and week number
    return [d.getFullYear(), weekNo];
}

});


//>    @method        date.toBrowserString()
//  Native <code>date.toString()</code> provided by the browser for Date objects
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5
//<
// Note that the default formatter varies by browser/platform so it's not that useful.
// This was exposed in 5.2 so we're keeping it around for back-compat only
Date.prototype.toBrowserString = Date.prototype.toString;

//>    @method        date.toBrowserLocaleString()    (A)
//  Synonym for <code>date.toLocaleString()</code> provided by the browser for Date objects
//        @group    dateFormatting
//      @visibility internal
//      @deprecated As of SmartClient 5.5
//<

Date.prototype.toBrowserLocaleString = Date.prototype.toLocaleString;

// default the global fiscal year to the start of the calendar year
Date.prototype.fiscalCalendar = { defaultMonth:0, defaultDate:1, fiscalYears: [] };

// set the standard formatter for the date prototype to the native browser string
//    so everything works as normal until it is overridden.
if (!Date.prototype.formatter) Date.setNormalDateDisplayFormat("toLocaleString");
if (!Date.prototype.datetimeFormatter) Date.setNormalDatetimeDisplayFormat("toLocaleString");

// set the standard toShortDate() formatter to US Short Date
if (!Date.prototype._shortFormat) Date.setShortDisplayFormat("toUSShortDate");
if (!Date.prototype._shortDatetimeFormat) Date.setShortDatetimeDisplayFormat("toUSShortDatetime");

//>    @method        date.iscToLocaleString()   (A)
// Customizeable toLocaleString() type method.
// This method is called when isc.iscToLocaleString(date) is called.
//
//        @group    dateFormatting
//        @return                (string)    formatted date string
//      @visibility internal
//<
// Leave this internal - we don't really expect this to be called directly or overridden by
// the developer

Date.prototype.iscToLocaleString = function () {
    var formatter = this.localeStringFormatter;
    if (isc.isA.Function(formatter)) return formatter.apply(this);
    else if (this[formatter]) return this[formatter]();
}

// By default have iscToLocaleString() call date.toLocaleString()
if (!Date.prototype.localeStringFormatter)
    Date.prototype.localeStringFormatter = "toLocaleString";


//>Safari12
isc.addMethods(Date, {
    // Simple substring matching for splitting up a date string to avoid using unsupported
    // string.match() method in early Safari
    // Note - somewhat flawed: we're assuming well never be handed a single digit month or day
    _splitDateViaSubstring : function (string, monthIndex, dayIndex, yearIndex) {

        // We know that year may be after month and/or day - allow 3 chars ("DD/") for each
        var yearCharIndex = yearIndex * 3,
            year = string.substring(yearCharIndex, yearCharIndex +4)
        ;

        // If we have a 2 or 3 char year, this affects the position of the day/month in the
        // string
        var yearLength = year.length;

        var monthCharIndex = 0,
            dayCharIndex = 0;
        if (monthIndex > dayIndex) monthCharIndex += 3;
        else dayCharIndex += 3;

        if (monthIndex > yearIndex) monthCharIndex += yearLength + 1;
        if (dayIndex > yearIndex) dayCharIndex += yearLength + 1;

        // Note: Month is zero based rather than 1 based.
        var month = string.substring(monthCharIndex, monthCharIndex + 2) -1;
        var day = string.substring(dayCharIndex, dayCharIndex +2);

        // Hour minute second are not expected to change orders
        var hourCharIndex = 7 + yearLength,
            hour = (string.substring(hourCharIndex,hourCharIndex + 2) || 0),
            minute = (string.substring(hourCharIndex + 3, hourCharIndex + 5) || 0),
            second = (string.substring(hourCharIndex + 6, hourCharIndex + 8) || 0);

        return[year,month,day,hour,minute,second];
    }
});
//<Safari12

//>!BackCompat 2005.11.3

isc.addMethods(Date.prototype, {

//>    @method        date.toPrettyString()
//            Return this date in the format: <code>MM/DD/YY HH:MM</code>
//    @group  dateFormatting
//    @return (string)    formatted date string
//  @visibility external
//  @deprecated As of SmartClient 5.5 use +link{date.toShortDate()} instead
//<
toPrettyString : function () {
    return this.toUSShortDatetime();
}

});

isc.addMethods(Date, {


// --- Parsing functions --- :
// In 5.2 the paradigm was to provide formatters and complimentary parsers, like
// 'toEuropeanShortDate' and 'parseEuropeanShortDate'.
// We've moved away from this to instead use a single 'parseInput' function which takes a
// 'format' parameter specifying "MDY" / "DMY", etc.
// This is appropriate since we do not plan to provide parsing functions for every date formatter
// format.
// Leaving the older explicit parsing functions in place for back-compat only.

//>    @classMethod    Date.parseStandardDate()
//      Parse a date passed in as a string of format:
//      <code>YYYY-MM-DD HH:MM:SS</code> or <code>YYYY-MM-DD</code>
//      Returning a new <code>Date</code> object with the appropriate value.
//
//      @group  dateFormatting
//
//      @param  dateString  (string)    date value as a string
//
//      @return    (date)      date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseStandardDate : function (dateString) {
    if (!isc.isA.String(dateString)) return null;

    // Note: we could be using a regexp here rather than substring matches
    var year = dateString.substring(0,4),
        month = dateString.substring(5,7)-1,
        day = dateString.substring(8,10),
        hour = dateString.substring(11, 13),
        minute = dateString.substring(14, 16),
        second = dateString.substring(17, 19);

    // If they all are numbers, construct a new date
    // NOTE: If year - month - day gives a number then they
    // are all numbers, or strings that implicitly convert to numbers.
    // We could also use this syntax:
    // if(parseInt(year) == year && parseInt(month) == month ...)
    // but this is slower in both Moz and IE
    if (dateString.length < 19) {
        if (!isc.isA.Number(year - month - day)) return null;
    } else {
        if (!isc.isA.Number(year - month - day - hour - minute - second)) return null;
    }

    return new Date(year, month, day, hour, minute, second);

},

//>    @classMethod    Date.parseSerializeableDate()
//      Parse a date passed in as a string of format:
//      <code>YYYY-MM-DD HH:MM:SS</code> or <code>YYYY-MM-DD</code>
//      Returning a new <code>Date</code> object with the appropriate value.
//      <i>This is a synonym for </i><code>Date.parseStandardDate()</code>
//
//      @group  dateFormatting
//      @param  dateString  (string)    date value as a string
//      @return    (Date)      date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseSerializeableDate : function (dateString) {
    // synonym for parseStandardDate
    return this.parseStandardDate(dateString);
},


//>    @classMethod    Date.parseDBDate()
// Parse a date passed in as a string of format:
//  <code>$$DATE$$:<i>YYYY-MM-DD HH:MM:SS</i></code>
//      Returning a new <code>Date</code> object with the appropriate value.
//
//      @group  dateFormatting
//        @param    dateString  (string)    date value as a string
//        @return    (date)        date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseDBDate : function (dateString) {

    // remove the leading "$$DATE$$:"
    if (isc.isA.String(dateString) && dateString.startsWith("$$DATE$$:")) {
        dateString = dateString.substring(9)
        return this.parseStandardDate(dateString);
    }

    return null;

},

//>    @classMethod    Date.parseDateStamp()
//
// Parse a dateStamp of the format: <code><i>YYYYMMDD</i>T<i>HHMMSS</i>[Z]</code><br><br>
//
// @group  dateFormatting
// @param    dateString    (string)    String to parse
// @return                (Date)        Date object, or null if not parsed correctly.
//
// @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseDateStamp : function (string) {
    if (string == null || isc.isA.Date(string)) return string;

    var date = new Date( Date.UTC(
                string.substring(0,4),                // year
                parseInt(string.substring(4,6), 10)-1,    // mon
                string.substring(6,8),              // day
                // omit this character (T)
                string.substring(9,11),             // hour
                string.substring(11,13),            // min
                string.substring(13,15)
                // Technically we should look at the last character - if its something other
                // than "z" the timezone would be something other than UTC.
               ));

    if (isc.isA.Date(date)) return date;
    else                return null;

},

//>    @classMethod    Date.parseShortDate()
// Parse a date passed in as a string of format:   <code>MM/DD/YYYY</code>
//
//      @group  dateFormatting
//        @param    dateString  (string)    date value as a string
//      @param  [centuryThreshold]  (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseShortDate : function (string, centuryThreshold) {
    return this.parseInput(string, "MDY", centuryThreshold);
},

//>    @classMethod    Date.parseShortDateTime()
// Parse a date passed in as a string of format:   <code>MM/DD/YYYY HH:MM:SS</code>
//
//      @group  dateFormatting
//        @param    dateString  (string)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<

parseShortDateTime : function (string, centuryThreshold) {
    // synonym for parseShortDate - included for completeness and to provide the appropriate
    // compliment to date.toShortDateTime()
    return this.parseShortDate(string, centuryThreshold);
},

//>    @classMethod    Date.parsePrettyString()
// Parse a date passed in as a string of format:   <code>MM/DD/YY HH:MM:SS</code>
//
//      @group  dateFormatting
//        @param    dateString  (string)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is less than this
//                                              number, assume year to be 20xx rather than 19xx
//
//        @return    (date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parsePrettyString : function (string, centuryThreshold) {
    // this is just the same as a short date with a 2 digit year.
    return this.parseShortDate(string, centuryThreshold);
},

//>    @classMethod    Date.parseEuropeanShortDate()
//            parse a date passed in as a string of format:   <code>DD/MM/YYYY</code>
//        @group    dateFormatting
//        @param    dateString  (string)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (date)        date value
//      @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<
parseEuropeanShortDate : function (string, centuryThreshold) {
    return this.parseInput(string, "DMY", centuryThreshold);
},

//>    @classMethod    Date.parseEuropeanShortDateTime()
//            parse a date passed in as a string of format:   <code>DD/MM/YYYY HH:MM:SS</code>
//        @group    dateFormatting
//        @param    dateString  (string)    date value as a string
//      @param  [centuryThreshold]    (int)    if parsed year is 2 digits and less than this
//                                              number, assume year to be 20xx
//
//        @return    (date)        date value
//  @visibility internal
//  @deprecated As of SmartClient 5.5 use +link{date.parseInput} instead
//<

parseEuropeanShortDateTime : function (string, centuryThreshold) {
    return this.parseInput(string, "DMY", centuryThreshold);
},

// Helper to set the time to zero for a datetime

setToZeroTime : function (date) {
    if (date == null || !isc.isA.Date(date)) return date;

    // Clear the "logicalDate" flag so when we run through formatters we respect
    // developer specified timezone rather than displaying time in the browser native timezone
    var wasLogicalDate = date.logicalDate;
    date.logicalDate = false;

    var timestamp = date.getTime();

    // Apply the timezone offset such that if the default system-wide formatter is used
    // and applies the display timezone offset, 00:00 will be seen.
    var hourOffset = isc.Time.getUTCHoursDisplayOffset(date),
        minuteOffset = isc.Time.getUTCMinutesDisplayOffset(date)
    ;

    if (wasLogicalDate) {
        var previousDay = new Date(date);
        previousDay.setHours(0);
        previousDay.setMinutes(0);

        var previousDayHourOffset = isc.Time.getUTCHoursDisplayOffset(previousDay);
        if (hourOffset != previousDayHourOffset) {
            // logical dates have a time of 12-noon - if the date in question happens to be
            // the one that DST changes on, the final date (with a time of 00:00) will have
            // a different hourOffset - use that one instead.
            hourOffset = previousDayHourOffset;
        }
    }

    var utcHours = hourOffset > 0 ? 24-hourOffset : 0-hourOffset,
        utcMins = 60-minuteOffset;

    if (utcMins >= 60) {
        utcMins -= 60;

    // If the minute offset was non-zero and the offset as a whole is positive
    // we need to knock an additional hour off (as the hours/minutes are cumulative so
    // we otherwise will roll forward to 01:00 local time)

    } else if (utcMins != 0) {
        utcHours -= 1;
    }


    var oldDisplayDate;
    if (wasLogicalDate) {
        oldDisplayDate = date.getDate();
    } else {
        var offsetDate = date._getTimezoneOffsetDate(hourOffset, minuteOffset);
        oldDisplayDate = offsetDate.getUTCDate();
    }

    date.setUTCHours(utcHours);
    date.setUTCMinutes(utcMins);

    var displayOffsetDate = date._getTimezoneOffsetDate(hourOffset, minuteOffset),
        displayDate = displayOffsetDate.getUTCDate(),
        adjustedUTCHours = utcHours;

    if (displayDate != oldDisplayDate) {
        // Cant just check for displayDate > oldDisplayDate since it might be the first or
        // last of a month...
        var moveForward = date.getTime() < timestamp;

        adjustedUTCHours += moveForward ? 24 : -24;
        date.setUTCHours(adjustedUTCHours);
    }


    if (date.getUTCHours() != utcHours) {
        date.setTime(timestamp);
        date.setUTCHours(adjustedUTCHours+1);
        if (date.getUTCHours() != utcHours+1) {
            date.setTime(timestamp);
            date.setUTCHours(adjustedUTCHours+2);
        }
    }

    // No need to return the date - we updated it directly.

}

});
//<!BackCompat





//> @type RelativeDateShortcut
// A RelativeDateShortcut is a special string that represents a shortcut to a date phrase that can
// be automatically mapped to a +link{type:RelativeDateString} for use in widgets that
// leverage relative-dates, such as the +link{class:RelativeDateItem}.
// <P>
// Note that some shortcuts indicate a time period but do not directly indicate whether the value
// refers to the start or end of the time period in question. This ambiguity
// can be resolved by specifying an explicit +link{RelativeDateRangePosition} when calling APIs that
// convert from RelativeDates to absolute date values. This is the case for <i>$today</i>,
// <i>$tomorrow</i>, <i>$yesterday</i>, <i>$weekAgo</i>, <i>$weekFromNow</i>, <i>$monthAgo</i>
// and <i>$monthFromNow</i>. If a range position is not explicitly passed, these will all default
// to the start of the day in question.
// <P>
// Builtin options include
// <ul>
// <li> $now - this moment </li>
// <li> $today - the current day. By default this resolves to the start of the current day though
//   an explicit +link{RelativeDateRangePosition} may be used to specify the end of the current day.</li>
// <li> $startOfToday - the start of today</li>
// <li> $endOfToday - the end of today (one millisecond before the $startOfTomorrow) </li>
// <li> $yesterday - the previous day.</li>
// <li> $startOfYesterday - the start of yesterday</li>
// <li> $endOfYesterday - the end of yesterday (one millisecond before the $startOfToday) </li>
// <li> $tomorrow - the following day</li>
// <li> $startOfTomorrow - the start of tomorrow </li>
// <li> $endOfTomorrow - the end of tomorrow </li>
// <li> $weekAgo - the current day of the previous week </li>
// <li> $weekFromNow - the current day of the next week </li>
// <li> $startOfWeek - the start of the current week </li>
// <li> $endOfWeek - the end of the current week </li>
// <li> $monthAgo - the current day of the previous month </li>
// <li> $monthFromNow - the current day of the following month </li>
// <li> $startOfMonth - the start of the current month </li>
// <li> $endOfMonth - the end of the current month </li>
// <li> $startOfYear - the start of the current year </li>
// <li> $endOfYear - the end of the current year </li>
// </ul>
//
// <P>
//
// @see RelativeDateString
// @visibility external
//<

//> @type RelativeDateString
// A string of known format used to specify a datetime offset.  For example, a
// RelativeDateString that represents "one year from today" is written as <code>"+1y"</code>.
// <P>
// RelativeDateStrings are comprised of the following parts:
// <ul>
// <li>direction: the direction in which the quantity applies - one of + or - </li>
// <li>quantity: the number of units of time to apply - a number </li>
// <li>timeUnit: an abbreviated timeUnit to use - one of ms/MS (millisecond), s/S (second),
//      mn/MN (minute), h/H (hour), d/D (day), w/W (week), m/M (month), q/Q (quarter, 3-months),
//      y/Y (year), dc/DC (decade) or c/C (century). <br>
//      The timeUnit is case sensitive. A lowercase timeUnit implies an exact offset, so <code>+1d</code>
//      refers to the current date / time increased by exactly 24 hours. If the timeUnit is
//      uppercase, it refers to the start or end boundary of the period of time in question, so
//      <code>+1D</code> would refer to the end of the day (23:39:59:999) tomorrow, and
//      <code>-1D</code> would refer to the start of the day (00:00:00:000) yesterday.</li>
// <li>[qualifier]: an optional timeUnit encapsulated in square-brackets and used to offset
//      the calculation - eg. if +1d is "plus one day", +1d[W] is "plus one day from the
//      end of the current week".  You may also specify another complete RelativeDateString as the
//      [qualifier], which offers more control - eg, +1d[+1W] indicates "plus one day from
//      the end of NEXT week".</li>
// </ul>
// <P>
// This format is very flexible. Here are a few example relative date strings:<br>
// <code>+0D</code>: End of today. There are often multiple ways to represent the same time
//  using this system - for example this could also be written as <code>-1ms[+1D]</code><br>
// <code>-0D</code>: Beginning of today.<br>
// <code>+1W</code>: End of next week.<br>
// <code>+1w[-0W]</code>: Beginning of next week.<br>
// <code>+1w[-0D]</code>: Beginning of the current day of next week.
//
// @see RelativeDateShortcut
// @visibility external
//<

//> @object RelativeDate
// An object representing a relative date, useful for representing date ranges etc in criteria.
// RelativeDate objects may be created directly by SmartClient components such as the
// +link{RelativeDateItem}.
// <P>
// RelativeDate objects will have <code>"_constructor"</code> set to <code>"RelativeDate"</code>
// and must have a specified +link{RelativeDate.value}. Any other attributes are optional.
//
// @visibility external
//<
// This type of object is returned by RelativeDateItem.getValue() and is understood directly by
// DataSources when assembling criteria.


//> @attr relativeDate.value (RelativeDateString or RelativeDateShortcut : null : IR)
// The value of this relative date, specified as a +link{RelativeDateString}
// or +link{RelativeDateShortcut}.
// @visibility external
//<

//> @type RelativeDateRangePosition
// When  relative dates are specified in a date range, typically in a RelativeDateItem or
// DateRangeItem, in order to make the range inclusive or exclusive, it is useful to be able
// to specify whether we're referring to the start or end of the date in question.
//
// @value "start" Indicates this relative date should be treated as the start of the specified
//    logical date.
// @value "end" Indicates this relative date should be treated as the end of the specified logical
//    date.
// @visibility external
//<

//> @attr relativeDate.rangePosition (RelativeDateRangePosition : null : IR)
// If this relative date has its value specified as a +link{RelativeDateShortcut} which doesn't
// specify an exact time-period boundary - for example <code>"$yesterday"</code>, this attribute
// may be set to specify whether the date should be interpreted as the start or end boundary of
// the time period.
// @visibility external
//<

// Add static methods to the DateUtil class (defined in Date.js)
isc.DateUtil.addClassMethods({

    //> @classMethod DateUtil.mapRelativeDateShortcut() [A]
    // Converts a +link{RelativeDateShortcut} to a +link{RelativeDateString}.
    // @param relativeDate (RelativeDateShortcut) shortcut string to convert
    // @param [rangePosition] (RelativeDateRangePosition) Are we interested in the start or end of the
    //  specified relative date? This applies to shortcuts which do not specify a specific
    //  moment (such as <code>$today</code>) - it does not apply to shortcuts which
    //  already specify a specific moment such as <code>$startOfToday</code>. If unspecified
    //  rangePosition is always assumed to be "start"
    // @return (RelativeDateString) converted relative date string.
    // @visibility external
    //<
    mapRelativeDateShortcut : function (relativeDate, rangePosition) {
        switch (relativeDate) {
            case "$now": return "+0MS";

            case "$today":
                if (rangePosition == "end") {
                    return "+0D";
                } else {
                    return "-0D";
                }
            case "$startOfToday":
                return "-0D";
            case "$endOfToday": return "+0D";

            case "$yesterday":
                if (rangePosition == "end") {

                    return "-1d[+0D]";
                } else {
                    return "-1D";
                }
            case "$startOfYesterday":
                return "-1D";
            case "$endOfYesterday": return "-1d[+0D]";

            case "$tomorrow":
                if (rangePosition == "end") {
                    return "+1D";
                } else {
                    return "+1d[-0D]";
                }
            case "$startOfTomorrow":
                return "+1d[-0D]";
            case "$endOfTomorrow": return "+1D";

            case "$startOfWeek": return "-0W";
            case "$endOfWeek": return "+0W";

            case "$startOfMonth": return "-0M";
            case "$endOfMonth": return "+0M";

            case "$startOfYear": return "-0Y";
            case "$endOfYear": return "+0Y";

            case "$weekFromNow" :
                if (rangePosition == "end") {
                    return "+1w[+0D]";
                } else {
                    return "+1w[-0D]";
                }

            case "$weekAgo" :
                if (rangePosition == "end") {
                    return "-1w[+0D]";
                } else {
                    return "-1w[-0D]";
                }

            case "$monthFromNow" :
                if (rangePosition == "end") {
                    return "+1m[+0D]";
                } else {
                    return "+1m[-0D]";
                }

            case "$monthAgo" :
                if (rangePosition == "end") {
                    return "-1m[+0D]";
                } else {
                    return "-1m[-0D]";
                }
        }
        return relativeDate;
    },

    //> @classMethod DateUtil.getAbsoluteDate()
    //  Converts a +link{RelativeDate}, +link{type:RelativeDateShortcut} or +link{RelativeDateString}
    // to a concrete Date.
    // @param relativeDate (RelativeDate or RelativeDateShortcut or RelativeDateString) the relative
    //   date to convert
    // @param [baseDate] (Date) base value for conversion.  Defaults to the current date/time.
    // @param [rangePosition] (RelativeDateRangePosition) optional date-range position. Only has an effect
    //   if the date passed in is a +link{type:RelativeDateShortcut} where the range position
    //   is not implicit, such as "$yesterday"
    // @param [isLogicalDate] (boolean) should the generated date be marked as a "logical" date? A
    //   logical date object is a Date value where the time component is ignored for formatting and
    //   serialization purposes - such as the date displayed within a component field of
    //   specified type "date". See +link{group:dateFormatAndStorage} for more on logical dates vs
    //   datetime type values.
    // @return (Date) resulting absolute date value
    // @visibility external
    //<
    getAbsoluteDate : function (relativeDate, baseDate, rangePosition, isLogicalDate) {
        if (this.isRelativeDate(relativeDate)) {
            // the caller passed an actual RelativeDate object - get the relativeDateString and
            // potentially the rangePosition from the object
            if (!rangePosition) rangePosition = relativeDate.rangePosition;
            relativeDate = relativeDate.value;
        }

        // convert relativeDate to relativeDateString, if necessary.
        // This will resolve the 'rangePosition'
        if (relativeDate.startsWith("$")) {
            relativeDate = this.mapRelativeDateShortcut(relativeDate, rangePosition);
        }
        var value = relativeDate,
            localBaseDate = isLogicalDate ? Date.createLogicalDate() : new Date()
        ;

        if (baseDate != null) localBaseDate.setTime(baseDate.getTime());
        var parts = this.getRelativeDateParts(value);

        if (parts.qualifier) {
            // Qualifier is always going to be in "boundary" type increments -- support it being
            // specified as upper or lowercase.
            // get rid of the brackets and upper-case it because we're
            // just going to run the baseDate through addDate(), which already understands
            // about capitals
            parts.qualifier = parts.qualifier.toUpperCase();

            var qParts = this.getRelativeDateParts(parts.qualifier);

            var options = ["S", "MN", "H", "D", "W", "M", "Q", "Y"];
            if (options.contains(qParts.period)) {
                localBaseDate = this.dateAdd(localBaseDate,
                    qParts.period, qParts.countValue, (qParts.direction == "+" ? 1 : -1),
                    isLogicalDate);
            } else {
                // invalid qualifier - log a warning and skip
                isc.logWarn("Invalid date-offset qualifier provided: "+qParts.period+".  Valid "+
                    "options are: S, MN, H, D, W, M, Q and Y.");
            }
        }

        // perform the date calculation
        var absoluteDate = this.dateAdd(localBaseDate, parts.period,
                                        parts.countValue, (parts.direction == "+" ? 1 : -1),
                                        isLogicalDate);

        if (isLogicalDate) absoluteDate.isLogicalDate = true;

        return absoluteDate;
    },

    isRelativeDate : function (value) {
        if (isc.isA.Date(value)) return false;
        if (isc.isAn.Object(value) && value._constructor == "RelativeDate") return true;

        return false;
    },

    getRelativeDateParts : function (relativeDateString) {
        var value = relativeDateString,
            direction = value.substring(0,1),
            bracketIndex = value.indexOf("["),
            qualifier = (bracketIndex > 0 ? value.substring(bracketIndex) : null),
            withoutQualifier = (qualifier != null ? value.substring(1, bracketIndex) : value.substring(1)),
            countValue = parseInt(withoutQualifier),
            period = withoutQualifier.replace(countValue, "")
        ;

        return {
            direction: (direction == "+" || direction == "-" ? direction : "+"),
            qualifier: qualifier ? qualifier.replace("[", "").replace("]", "").replace(",", "") : null,
            countValue: isc.isA.Number(countValue) ? countValue : 0,
            period: period ? period : direction
        };
    },

    // helper method for adding positive and negative amounts of any time-unit from
    // milliseconds to centuries to a given date
    // date: base date to modify
    // period: one of "ms" / "MS", "H" / "h", "D" / "d" etc.
    // amount: how much to offset by
    // multiplier: + or -1 - direction in which we're shifting the date
    // Returns the modified date.
    dateAdd : function (date, period, amount, multiplier, isLogicalDate) {

        // boundary: If the specified time-unit is upperCase, we want to calculate the
        // date offset to the end of the time-unit in question. For example:
        // +1d ==> offset to the same time of the next day
        // +1D ==> offset to the end of the next day
        // -1D ==> offset to the beginning of the previous day.
        var boundary = false;

        switch (period) {
            case "MS":
                // no need to set boundary for ms - we don't have a finer gradation than this.
            case "ms":
                date.setMilliseconds(date.getMilliseconds()+(amount*multiplier));
                break;

            case "S":
                boundary = true;
            case "s":
                date.setSeconds(date.getSeconds()+(amount*multiplier));
                break;

            case "MN":
                boundary = true;
            case "mn":
                date.setMinutes(date.getMinutes()+(amount*multiplier));
                break;

            case "H":
                boundary = true;
            case "h":
                date.setHours(date.getHours()+(amount*multiplier));
                break;

            case "D":
                boundary = true;
            case "d":
                date.setDate(date.getDate()+(amount*multiplier));
                break;

            case "W":
                boundary = true;
            case "w":
                date.setDate(date.getDate()+((amount*7)*multiplier));
                break;

            case "M":
                boundary = true;
            case "m":
                var tempDate = isc.Date.createLogicalDate(date.getFullYear(), date.getMonth(), 1);

                tempDate.setMonth(tempDate.getMonth()+(amount*multiplier));
                tempDate = isc.DateUtil.getEndOf(tempDate, period, true);

                if (tempDate.getDate() < date.getDate()) date.setDate(tempDate.getDate());
                date.setMonth(tempDate.getMonth());
                date.setFullYear(tempDate.getFullYear());
                break;

            case "Q":
                boundary = true;
            case "q":
                date.setMonth(date.getMonth()+((amount*3)*multiplier));
                break;

            case "Y":
                boundary = true;
            case "y":
                date.setFullYear(date.getFullYear()+(amount*multiplier));
                break;

            case "DC":
                boundary = true;
            case "dc":
                date.setFullYear(date.getFullYear()+((amount*10)*multiplier));
                break;

            case "C":
                boundary = true;
            case "c":
                date.setFullYear(date.getFullYear()+((amount*100)*multiplier));
                break;
        }

        if (boundary) {
            if (multiplier > 0) {
                date = this.getEndOf(date, period, isLogicalDate);
            } else {
                date = this.getStartOf(date, period, isLogicalDate);
            }
        }
        return date;
    },

    // getStartOf / getEndOf - methods to round a date to start or end of a period (week, day, etc)


    _datetimeOnlyPeriods:{
        s:true, S:true,
        mn:true, MN:true,
        h:true, H:true,
        d:true, D:true
    },
    getStartOf : function (date, period, logicalDate, firstDayOfWeek) {
        var year, month, dateVal, hours, minutes, seconds, dayOfWeek;
        if (logicalDate == null) logicalDate = date.logicalDate;

        if (firstDayOfWeek == null && isc.DateChooser)
            firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");

        // If we're passed a period <= "day", and we're working in logical dates, just return
        // the date - there's no way to round the time within a "logical date"
        if (logicalDate && this._datetimeOnlyPeriods[period] == true) {
            this.logInfo("DateUtil.getStartOf() passed period:"
                + period + " for logical date. Ignoring");
            var newDate = new Date(date.getTime());
            newDate.logicalDate = true;
            return newDate;
        }

        if (!isc.Time._customTimezone || logicalDate) {
            month = date.getMonth();
            dateVal = date.getDate();
            year = date.getFullYear();
            hours = date.getHours();
            minutes = date.getMinutes();
            seconds = date.getSeconds();

            dayOfWeek = date.getDay();

        // Developer specified custom timezone
        } else {
            // Use the "offsetDate" trick we use for formatting datetimes - easier to shift the
            // date and call native date APIs than to actually modify potentially
            // minute, hour, date, month, year directly.
            var offsetDate = date._getTimezoneOffsetDate(
                                isc.Time.getUTCHoursDisplayOffset(date),
                                isc.Time.getUTCMinutesDisplayOffset(date)
                             );

            month = offsetDate.getUTCMonth();
            dateVal = offsetDate.getUTCDate();
            year = offsetDate.getUTCFullYear();

            hours = offsetDate.getUTCHours();
            minutes = offsetDate.getUTCMinutes();
            seconds = offsetDate.getUTCSeconds();

            dayOfWeek = offsetDate.getDay();
        }

        switch (period) {
            case "s":
            case "S":
                // start of second - bit dramatic, but may as well be there
                return Date.createDatetime(year, month, dateVal, hours, minutes, seconds, 0);
            case "mn":
            case "MN":
                // start of minute
                return Date.createDatetime(year, month, dateVal, hours, minutes, 0, 0);

            case "h":
            case "H":
                // start of hour
                return Date.createDatetime(year, month, dateVal, hours, 0, 0, 0);

            case "d":
            case "D":
                // start of day
                if (logicalDate) {
                    return Date.createLogicalDate(year, month, dateVal);
                } else {
                    return Date.createDatetime(year, month, dateVal, 0, 0, 0, 0);
                }

            case "w":
            case "W":
                // start of week
                var delta = Math.max(0, dayOfWeek-firstDayOfWeek);
                var endDate = dateVal - delta;
                if (logicalDate) {
                    return Date.createLogicalDate(year, month, endDate);
                } else {
                    return Date.createDatetime(year, month, endDate, 0, 0, 0, 0);
                }

            case "m":
            case "M":
                // start of month
                if (logicalDate) {
                    return Date.createLogicalDate(year, month, 1);
                } else {
                    return Date.createDatetime(year, month, 1, 0, 0, 0, 0);
                }
            case "q":
            case "Q":
                // start of quarter
                var quarterStart = month - (month % 3);
                if (logicalDate) {
                    return Date.createLogicalDate(year, quarterStart, 1);
                } else {
                    return Date.createDatetime(year, quarterStart, 1, 0, 0, 0, 0);
                }
            case "y":
            case "Y":
                // start of year
                if (logicalDate) {
                    return Date.createLogicalDate(year, 0, 1);
                } else {
                    return Date.createDatetime(year, 0, 1, 0, 0, 0, 0);
                }

            case "dc":
            case "DC":
                // start of decade
                var decade = year - (year % 10);
                if (logicalDate) {
                    return Date.createLogicalDate(decade, 0, 1);
                } else {
                    return Date.createDatetime(decade, 0, 1, 0, 0 ,0, 0);
                }

            case "c":
            case "C":
                // start of century
                var century = year - (year % 100);
                if (logicalDate) {
                    return Date.createLogicalDate(century, 0, 1);
                } else {
                    return Date.createDatetime(century, 0, 1, 0, 0, 0, 0);
                }
        }

        return date.duplicate();
    },
    getEndOf : function (date, period, logicalDate, firstDayOfWeek) {

        var year, month, dateVal, hours, minutes, seconds, dayOfWeek;
        if (logicalDate == null) logicalDate = date.logicalDate;

        if (firstDayOfWeek == null && isc.DateChooser)
            firstDayOfWeek = isc.DateChooser.getInstanceProperty("firstDayOfWeek");

        // If we're passed a period <= "day", and we're working in logical dates, just return
        // the date - there's no way to round the time within a "logical date"
        if (logicalDate && this._datetimeOnlyPeriods[period] == true) {
            this.logInfo("DateUtil.getEndOf() passed period:"
                + period + " for logical date. Ignoring");
            var newDate = new Date(date.getTime());
            newDate.logicalDate = true;
            return newDate;
        }

        if (!isc.Time._customTimezone || logicalDate) {
            month = date.getMonth();
            dateVal = date.getDate();
            year = date.getFullYear();
            hours = date.getHours();
            minutes = date.getMinutes();
            seconds = date.getSeconds();

            dayOfWeek = date.getDay();

        // Developer specified custom timezone
        } else {
            // Use the "offsetDate" trick we use for formatting datetimes - easier to shift the
            // date and call native date APIs than to actually modify potentially
            // minute, hour, date, month, year directly.
            var offsetDate = date._getTimezoneOffsetDate(
                                isc.Time.getUTCHoursDisplayOffset(date),
                                isc.Time.getUTCMinutesDisplayOffset(date)
                             );

            month = offsetDate.getUTCMonth();
            dateVal = offsetDate.getUTCDate();
            year = offsetDate.getUTCFullYear();

            hours = offsetDate.getUTCHours();
            minutes = offsetDate.getUTCMinutes();
            seconds = offsetDate.getUTCSeconds();

            dayOfWeek = offsetDate.getDay();
        }

        switch (period) {
            case "s":
            case "S":
                // end of second
                return Date.createDatetime(year, month, dateVal, hours, minutes, seconds, 999);
            case "mn":
            case "MN":
                // end of minute
                return Date.createDatetime(year, month, dateVal, hours, minutes, 59, 999);

            case "h":
            case "H":
                // end of hour
                return Date.createDatetime(year, month, dateVal, hours, 59, 59, 999);

            case "d":
            case "D":
                // end of day
                if (logicalDate) {
                    return Date.createLogicalDate(year, month, dateVal);
                } else {
                    return Date.createDatetime(year, month, dateVal, 23, 59, 59, 999);
                }

            case "w":
            case "W":
                // end of week
                var delta = (6-(dayOfWeek-firstDayOfWeek));
                if (delta >= 7) delta -= 7;
                var endDate = dateVal + delta;
                if (logicalDate) {
                    return Date.createLogicalDate(year, month, endDate);
                } else {
                    return Date.createDatetime(year, month, endDate, 23, 59, 59, 999);
                }

            case "m":
            case "M":
                // end of month

                // Get start of *next* month, then knock back to prev day.
                var newDate;
                if (logicalDate) {
                    newDate = Date.createLogicalDate(year, month+1, 1);
                    newDate.setTime(newDate.getTime() - (24*60*60*1000));
                } else {
                    newDate = Date.createDatetime(year, month+1, 1, 0, 0, 0, 0);
                    newDate.setTime(newDate.getTime()-1);
                }
                return newDate;

            case "q":
            case "Q":
                // end of quarter

                var nextQ = month + 3 - (month%3),
                    newDate;
                if (logicalDate) {
                    newDate = Date.createLogicalDate(year, nextQ, 1);
                    newDate.setDate(newDate.getDate()-1);
                } else {
                    newDate = Date.createDatetime(year, nextQ, 1, 0, 0, 0, 0);
                    newDate.setTime(newDate.getTime()-1);
                }
                return newDate;

            case "y":
            case "Y":
                // end of year
                if (logicalDate) {
                    return Date.createLogicalDate(year, 11, 31);
                } else {
                    return Date.createDatetime(year, 11, 31, 23, 59, 59, 999);
                }

            case "dc":
            case "DC":
                // end of decade
                var decade = year + 10 - (year % 10);
                if (logicalDate) {
                    return Date.createLogicalDate(decade, 11, 31);
                } else {
                    return Date.createDatetime(decade, 11, 31, 23, 59, 59, 999);
                }

            case "c":
            case "C":
                // start of century
                var century = year +100 - (year % 100);
                if (logicalDate) {
                    return Date.createLogicalDate(century, 11, 31);
                } else {
                    return Date.createDatetime(century,  11, 31, 23, 59, 59, 999);
                }
        }
        return date.duplicate();
    },

    // mappings between "TimeUnit" strings and the equivalent period markers used in
    // RelativeDateStrings and Calendars/Timelines
    _timeUnitMapping:{
        ms:"millisecond",
        s:"second",
        mn:"minute",
        h:"hour",
        d:"day",
        w:"week",
        m:"month",
        q:"quarter",
        y:"year",
        dc:"decade",
        c:"century"
    },
    getTimeUnitName : function (timeUnitKey) {
        var value = timeUnitKey.toLowerCase();
        return this._timeUnitMapping[value] || value;
    },
    getTimeUnitKey : function (timeUnitName) {
        if (this._timeUnitReverseMapping == null) {
            this._timeUnitReverseMapping = isc.makeReverseMap(this._timeUnitMapping);
        }
        var value = timeUnitName.toLowerCase();
        return this._timeUnitReverseMapping[value] || value;
    },
    compareTimeUnits : function (unitName, otherUnitName) {
        var unitMS = this.getTimeUnitMilliseconds(unitName),
            otherUnitMS = this.getTimeUnitMilliseconds(otherUnitName)
        ;
        if (unitMS <= otherUnitMS) return -1;
        if (unitMS == otherUnitMS) return 0;
        return 1;
    },
    getTimeUnitMilliseconds : function (timeUnitName) {
        var key = this.getTimeUnitKey(timeUnitName),
            l = { millisecond: 1, second: 1000 }
        ;

        l.minute = l.second * 60;
        l.hour = l.minute * 60;
        l.day = l.hour * 24;
        l.week = l.day * 7;
        l.month = l.day * 30; // this is accurate enough for the purposes of this method
        l.quarter = l.month * 3;
        l.year = l.day * 365;
        l.decade = l.year * 10;
        l.century = l.decade * 10;

        return l[timeUnitName];
    }

});








  //>DEBUG
// This lets us label methods with a name within addMethods
String.prototype.Class = "String";
  //<DEBUG

//>    @class String
//    Generic extensions to JavaScript Strings.  You can call these on any String.
// @treeLocation Client Reference/System
// @visibility external
//<

isc._patchLocaleSupport = function () {

    var protos = [Array, Number, Date].getProperty("prototype");
    for (var i = 0; i < protos.length; i++) {
        var theProto = protos[i];
        if (theProto.toLocaleString == null) {
            theProto.toLocaleString = theProto.toString;
        }
    }

    // ensure String.toLocaleUpper/LowerCase are there so we can call them blindly
    var strProto = String.prototype;
    if (!strProto.toLocaleUpperCase) {
        strProto.toLocaleUpperCase = strProto.toUpperCase;
        strProto.toLocaleLowerCase = strProto.toLowerCase;
    }

    // Mozilla's String.toLocaleString() actually does the equivalent of Object.toString(),
    // which is to return [object String] instead of the string value, so we patch it to
    // simply return the equivalent of String.toString() since Strings are unicode by nature.
    if (isc.Browser.isMoz) {
        var string = "x",
            localeString = string.toLocaleString();
            if (localeString != string) {

                strProto.toBrowserLocaleString = strProto.toLocaleString;
                strProto.toLocaleString = strProto.toString;
            }
        // Patch Boolean as well
        string = true;
        localeString = string.toLocaleString();
        if (localeString != string + "") {

            Boolean.prototype.toBrowserLocaleString = Boolean.prototype.toLocaleString;
            Boolean.prototype.toLocaleString = Boolean.prototype.toString;
        }
    }
}
isc._patchLocaleSupport();

isc.addProperties(String, {
    _singleQuoteRegex : new RegExp("'", "g"),
    _doubleQuoteRegex : new RegExp("\"", "g")
});

isc.addMethods(String.prototype, {

//>    @method    string.replaceAll()
//            Replace all occurances of 'find' string with 'replacement' string.
//            Uses a native method so is very efficient (and easier to use than grep).
//        @group    stringProcessing
//
//        @param    find        (string)    string to find
//        @param    replacement    (string)    string to replace each occurance of find with
//
//        @return                (string)    new string with replacements made
//<
replaceAll : function (find, replacement) {

    return isc.replaceAll(this, find, replacement);
},

//>    @method    string.contains()
//            Returns true if this string contains the specified substring.
//        @group    stringProcessing
//
//        @param    substring    (String)    string to look for
//        @return                (boolean)    true == this string contains the substring
// @visibility external
//<
contains : function (substring) {
    // support eg Numbers.  Note: only available with non-performance-critical version of API
    if (substring && !isc.isA.String(substring)) substring = substring.toString();


    return isc.contains(this, substring);
},

//>    @method    string.startsWith()
//            Returns true if this string starts with another string.
//        @group    stringProcessing
//
//        @param    substring    (String)    other string to check
//        @return                (boolean)    true == this string starts with substring
// @visibility external
//<
startsWith : function (substring) {
    // support eg Numbers.  Note: only available with non-performance-critical version of API
    if (substring && !isc.isA.String(substring)) substring = substring.toString();


    return isc.startsWith(this, substring);
},


//>    @method    string.endsWith()
//            Returns true if this string ends with another string.
//        @group    stringProcessing
//
//        @param    substring    (String)    other string to check
//        @return                (boolean)    true == this string ends with substring
// @visibility external
//<
endsWith : function (substring) {
    // support eg Numbers.  Note: only available with non-performance-critical version of API
    if (substring && !isc.isA.String(substring)) substring = substring.toString();


    return isc.endsWith(this, substring);
},

trim : function (chars) {
    var removeChars = chars || " \t\n\r",
        l = this.length,
        start = 0,
        end = l - 1,
        i = 0;

    // find first character not in the removal list
    while (start < l && removeChars.contains(this.charAt(i++))) start++;

    // find last character not in the removal list
    i = l - 1;
    while (end >= 0 && end >= start && removeChars.contains(this.charAt(i--))) end--;

    return this.substring(start, end + 1);
},

//>    @method    string.convertTags()    (A)
//            Convert all tag symbols ( &lt;  and &gt; ) into displayable HTML
//            by changing them to   &amp;lt;  and  &amp;gt;   respectively.
//        @group    stringProcessing
//
//        @param    [prefix]    (string)    text to tack onto the beginning of result (eg: "&lt;PRE&gt;")
//        @param    [suffix]    (string)    text to tack onto the end of result (eg: "&lt;/PRE&gt;")
//
//        @return                (string)    prefix + converted text + suffix as a single string
//<
convertTags : function (prefix,suffix){
    // use regular expressions to convert < and > characters
    return (prefix ? prefix : "") +
        this.replace(/</g, "&lt;").replace(/>/g, "&gt;") +
        (suffix ? suffix : "");
},

//>    @method    string.asHTML()
// Convert plain text into into displayable HTML.
// <p>
// This prevents HTML-special characters like &lt; and &gt; from being interpreted as tags, and
// preserves line breaks and extra spacing.
// <pre>
//    converts           to
//    --------             ---------------------------
//    &                   &amp;
//    <                   &lt;
//    >                   &gt;
//    \r,\n,\r\n1space <BR>&nbsp;
//    \r,\n,\r\n       <BR>
//    \t               &nbsp;&nbsp;&nbsp;&nbsp;
//    2 spaces           1space&nbsp;
// </pre>
//
// @group stringProcessing
// @return (string) string of HTML with tags in the original HTML escaped.
//<
asHTML : function (noAutoWrap) {
    var s = this.replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g,"&gt;")
                // if we don't do this, we lose the leading space after a crlf because all
                // browsers except IE in compat (non-standards) mode treat a <BR> followed by a
                // space as just a <BR> (the space is ignored)
                .replace(/(\r\n|\r|\n) /g,"<BR>&nbsp;")
                .replace(/(\r\n|\r|\n)/g,"<BR>")
                .replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;");
    // in autoWrap mode, replace two spaces with a space and an &nbsp; to preserve wrapping to
    // the maximum extent possible
    return (noAutoWrap ? s.replace(/ /g, "&nbsp;") : s.replace(/  /g, " &nbsp;"));
},

asAttValue : function (doubleQuote, includeOuterQuotes) {

    return String.asAttValue(this, doubleQuote, includeOuterQuotes);
},

// revereses asHTML()
unescapeHTML : function () {
    // Note: in asHTML() we turn tabs into four &nbsp;, this reversal is lossy in that it turns
    // those into four spaces - but we really have no way of knowing whether there were four
    // spaces there before or a tab.
    return this.replace(/&nbsp;/g, " ")
               .replace(/<BR>/gi, "\n")
               .replace(/&gt;/g, ">")
               .replace(/&lt;/g, "<")
               .replace(/&amp;/g, "&");
},




//>    @method    string.toInitialCaps()
//            Convert A String To Initial Caps
//        @group    stringProcessing
//
//        @return                (string)    converted string
//<
toInitialCaps : function () {
    // lowercase the entire thing, then split by spaces
    var it = this.toLowerCase().split(" ");
    // for each word
    for (var i = 0; i < it.length; i++) {
        // uppercase the first letter, then add the rest (already lower case)
        it[i] = it[i].substring(0,1).toLocaleUpperCase() + it[i].substring(1);
    }
    return it.join(" ");
},


//>    @method    string.evalDynamicString()
//            Look for ${expressions} in a string and evaluate them.  To escape, prepend a
//            backslash to the dollar sign.  Note that in the event that you actually want
//          to display \${  you will have to escape the backslash as follows: \\${.  Note
//          also that if you're writing this in a JS string you must escape the backslash
//          again.
//        @group    dynamicString
//
//        @return                (string)    converted string
//<
evalDynamicString : function (target, evalVars) {
    // must toString() - otherwise strange object literal with slots is returned
    if (this.indexOf("${") < 0) return this.toString();
    var str = this, lastStart, start, end, evalBlock;

    // hand-coded for performance
    var accum = isc.StringBuffer.create();
    while ((start = str.indexOf("${")) != -1) {
            end = str.indexOf("}", start + 1);
            if (end == -1) break;

            // handle escapes
            if (str.charAt(start - 1) == '\\') {
                accum.append(str.slice(0, start - 1), str.slice(start, end + 1));
                str = str.substring(end + 1, str.length);
                continue;
            }
            var evalBlock = str.slice(start + 2, end);
            var evalResult;
            if (evalVars != null && evalVars[evalBlock]) {
                // shortcut to avoid evalWithVars, which creates a Function each time
                evalResult = evalVars[evalBlock];
            } else {
                try {
                    evalResult = isc.Class.evalWithVars(evalBlock, evalVars, target);
                } catch (e) {
                    // if a target has been supplied, use that for the log report
                    var logTarget = target ? target : isc.Log;
                    logTarget.logWarn("dynamicContents eval error - returning empty string for block -->${"
                                      + evalBlock + "}<-- error was: " + isc.Log.echo(e));
                    evalResult = isc.emptyString;
                }
            }
            accum.append(str.slice(0, start), evalResult);
            str = str.substring(end + 1, str.length);
    }
    accum.append(str);
    str = accum.toString();
    return str;
},


//>    @method    string.asSource()    (A)
// Return a new String that, evaluated as source code, would produce this String's value.
//        @group    stringProcessing
//
//        @return                (string)    new string
//<
asSource : function (singleQuote) {
    return String.asSource(this, singleQuote);
},

// String.cssToCamelCaps()
//  Converts a string in css dash syntax "foo-bar-baz" to camelCaps syntax "fooBarBaz".
// Non-alphabetic chars between the '-' and the lowercase letter are ignored,
// eg, 'test-234foo' -> 'test234Foo'.
cssToCamelCaps : function () {
    return this.replace(/-([^a-z]*)([a-z])/g,
                        function (str, p1, p2, offset, s) { return p1 + p2.toUpperCase(); });
}

});


String._unicodeLPattern = "[\u0041-\u005a\u0061-\u007a\u00aa\u00b5\u00ba\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2183\u2184\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005\u3006\u3031-\u3035\u303b\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6e5\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]";
String._unicodeNlPattern = "[\u16ee-\u16f0\u2160-\u2182\u2185-\u2188\u3007\u3021-\u3029\u3038-\u303a\ua6e6-\ua6ef]";
String._unicodeMnPattern = "[\u0300-\u036f\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065f\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08e4-\u08fe\u0900-\u0902\u093a\u093c\u0941-\u0948\u094d\u0951-\u0957\u0962\u0963\u0981\u09bc\u09c1-\u09c4\u09cd\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b62\u0b63\u0b82\u0bc0\u0bcd\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc6\u0ccc\u0ccd\u0ce2\u0ce3\u0d41-\u0d44\u0d4d\u0d62\u0d63\u0dca\u0dd2-\u0dd4\u0dd6\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135d-\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4\u17b5\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1bab\u1be6\u1be8\u1be9\u1bed\u1bef-\u1bf1\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1cf4\u1dc0-\u1de6\u1dfc-\u1dff\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302d\u3099\u309a\ua66f\ua674-\ua67d\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaec\uaaed\uaaf6\uabe5\uabe8\uabed\ufb1e\ufe00-\ufe0f\ufe20-\ufe26]";
String._unicodeMcPattern = "[\u0903\u093b\u093e-\u0940\u0949-\u094c\u094e\u094f\u0982\u0983\u09be-\u09c0\u09c7\u09c8\u09cb\u09cc\u09d7\u0a03\u0a3e-\u0a40\u0a83\u0abe-\u0ac0\u0ac9\u0acb\u0acc\u0b02\u0b03\u0b3e\u0b40\u0b47\u0b48\u0b4b\u0b4c\u0b57\u0bbe\u0bbf\u0bc1\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcc\u0bd7\u0c01-\u0c03\u0c41-\u0c44\u0c82\u0c83\u0cbe\u0cc0-\u0cc4\u0cc7\u0cc8\u0cca\u0ccb\u0cd5\u0cd6\u0d02\u0d03\u0d3e-\u0d40\u0d46-\u0d48\u0d4a-\u0d4c\u0d57\u0d82\u0d83\u0dcf-\u0dd1\u0dd8-\u0ddf\u0df2\u0df3\u0f3e\u0f3f\u0f7f\u102b\u102c\u1031\u1038\u103b\u103c\u1056\u1057\u1062-\u1064\u1067-\u106d\u1083\u1084\u1087-\u108c\u108f\u109a-\u109c\u17b6\u17be-\u17c5\u17c7\u17c8\u1923-\u1926\u1929-\u192b\u1930\u1931\u1933-\u1938\u19b0-\u19c0\u19c8\u19c9\u1a19-\u1a1b\u1a55\u1a57\u1a61\u1a63\u1a64\u1a6d-\u1a72\u1b04\u1b35\u1b3b\u1b3d-\u1b41\u1b43\u1b44\u1b82\u1ba1\u1ba6\u1ba7\u1baa\u1bac\u1bad\u1be7\u1bea-\u1bec\u1bee\u1bf2\u1bf3\u1c24-\u1c2b\u1c34\u1c35\u1ce1\u1cf2\u1cf3\u302e\u302f\ua823\ua824\ua827\ua880\ua881\ua8b4-\ua8c3\ua952\ua953\ua983\ua9b4\ua9b5\ua9ba\ua9bb\ua9bd-\ua9c0\uaa2f\uaa30\uaa33\uaa34\uaa4d\uaa7b\uaaeb\uaaee\uaaef\uaaf5\uabe3\uabe4\uabe6\uabe7\uabe9\uabea\uabec]";
String._unicodeNdPattern = "[\u0030-\u0039\u0660-\u0669\u06f0-\u06f9\u07c0-\u07c9\u0966-\u096f\u09e6-\u09ef\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0be6-\u0bef\u0c66-\u0c6f\u0ce6-\u0cef\u0d66-\u0d6f\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f29\u1040-\u1049\u1090-\u1099\u17e0-\u17e9\u1810-\u1819\u1946-\u194f\u19d0-\u19d9\u1a80-\u1a89\u1a90-\u1a99\u1b50-\u1b59\u1bb0-\u1bb9\u1c40-\u1c49\u1c50-\u1c59\ua620-\ua629\ua8d0-\ua8d9\ua900-\ua909\ua9d0-\ua9d9\uaa50-\uaa59\uabf0-\uabf9\uff10-\uff19]";
String._unicodePcPattern = "[\u005f\u203f\u2040\u2054\ufe33\ufe34\ufe4d-\ufe4f\uff3f]";
String._jsUnicodeEscapeSequencePattern = "\\u[0-9A-Fa-f]{4}";
String._jsIdentifierStartPattern = "(?:" + String._unicodeLPattern + "|[$_]|" + String._jsUnicodeEscapeSequencePattern + ")";
String._jsUnicodeCombiningMarkPattern = "(?:" + String._unicodeMnPattern + "|" + String._unicodeMcPattern + ")";
String._jsUnicodeDigitPattern = String._unicodeNdPattern;
String._jsUnicodeConnectorPunctuationPattern = String._unicodePcPattern;
// Zero-width non-joiner
String._zwnjPattern = "\u200c";
// Zero-width joiner
String._zwjPattern = "\u200d";
String._jsIdentifierPartPattern = "(?:" + String._jsIdentifierStartPattern + "|" + String._jsUnicodeCombiningMarkPattern + "|" + String._jsUnicodeDigitPattern + "|" + String._jsUnicodeConnectorPunctuationPattern + "|" + String._zwnjPattern + "|" + String._zwjPattern + ")";
String._jsIdentifierNamePattern = "^(?:" + String._jsIdentifierStartPattern + String._jsIdentifierPartPattern + "*)$";
String._jsIdentifierNameRegExp = new RegExp(String._jsIdentifierNamePattern);

String._jsKeywordPattern = "(?:break|case|catch|continue|debugger|default|delete|do|else|finally|for|function|if|in|instanceof|new|return|switch|this|throw|try|typeof|var|void|while|with)";
String._jsFutureReservedWordPattern = "(?:class|const|enum|export|extends|import|super)";
String._jsStrictModeFutureReservedWordPattern = "(?:implements|interface|let|package|private|protected|public|static|yield)";
String._jsReservedWordRegExp = new RegExp("^(?:" + String._jsKeywordPattern + "|" + String._jsFutureReservedWordPattern + "|" + String._jsStrictModeFutureReservedWordPattern + "|null|true|false)$");

isc.addMethods(String, {

    //>    @classMethod    String.asSource()
    //            Static method to return a new String that, evaluated as source code, would produce
    //          the passed in String's value.
    //        @group    dynamicString
    //        @param    string  (string)    string to convert
    //        @return            (string)    converted string
    //<

    asSource : function (string, singleQuote) {
        if (!isc.isA.String(string)) string = ""+string;

        var quoteRegex = singleQuote ? String._singleQuoteRegex : String._doubleQuoteRegex,
            outerQuote = singleQuote ? "'" : '"';
        return outerQuote +
                   string.replace(/\\/g, "\\\\")
                         // quote whichever quote we use on the outside
                         .replace(quoteRegex, '\\' + outerQuote)
                         .replace(/\t/g, "\\t")
                         .replace(/\r/g, "\\r")
                         .replace(/\n/g, "\\n")
                         .replace(/\u2028/g, "\\u2028")
                         .replace(/\u2029/g, "\\u2029") + outerQuote;
    },

    // Escapes <code>str</code> as an +externalLink{http://www.w3.org/TR/xml11/#NT-AttValue,XML AttValue}.
    // @param str (string) the string to escape.
    // @param [doubleQuote] (boolean) <code>true</code> to use double-quotes; otherwise, use single-quotes.
    // @param [includeOuterQuotes] (boolean) <code>true</code> to prepend and append the outer
    // quote char; otherwise, the outer quote char is <em>not</em> prepended and appended in the resulting
    // string.
    _attValueSpecialCharsRegex: new RegExp("[<&\"']", ""),
    asAttValue : function (str, doubleQuote, includeOuterQuotes) {
        if (str == null) str = isc.emptyString;
        else str = String(str);

        // If there aren't any potentially special characters present in the string, then we can
        // skip the replace() calls.
        var inner;
        if (!this._attValueSpecialCharsRegex.test(str)) {
            inner = str;
        } else {
            var quoteRegex,
                quoteReplacement;
            if (doubleQuote) {
                quoteRegex = this._doubleQuoteRegex;
                quoteReplacement = isc._$quot;
            } else {
                quoteRegex = this._singleQuoteRegex;
                quoteReplacement = isc._$39;
            }
            inner = str.replace(isc._RE_amp, isc._$amp)
                       .replace(isc._RE_lt, isc._$lt)
                       .replace(quoteRegex, quoteReplacement);
        }

        if (includeOuterQuotes) {
            var outerQuote = doubleQuote ? "\"" : "'";
            return outerQuote + inner + outerQuote;
        } else {
            return inner;
        }
    },

    //> @classMethod String.isValidID()
    // Tests whether the given string is a valid JavaScript identifier.
    //
    // @param string (string) the string to test.
    // @return (boolean) true if string is a valid JavaScript identifier; false otherwise.
    // @visibility external
    //<
    isValidID : function (string) {
        if (!isc.isA.String(string)) return false;
        // A JavaScript Identifier is an IdentifierName that is not a ReservedWord. (ECMA-262 Section 7.6)
        return (string.search(String._jsIdentifierNameRegExp) != -1 &&
                string.search(String._jsReservedWordRegExp) == -1);
    }
});






isc.addMethods(isc, {

// isc.replaceAll() [string helper]
//  Replace all occurances of 'find' string with 'replacement' string.
//  Uses a native method so is very efficient (and easier to use than grep).
replaceAll : function (source, find, replacement) {
    return source.split(find).join(replacement);
},

// isc.contains() [string helper]
//  Returns true if this string contains the specified substring.
contains : function (string1, substring) {
    if (string1 == null) return false;

    return string1.indexOf(substring) > -1;
},

// isc.startsWith() [string helper]
//  Returns true if this string starts with another string.
startsWith : function (string1, substring) {
    if (string1 == null) return false;

    return (string1.lastIndexOf(substring, 0) == 0);
},


// isc.endsWith() [string helper]
//  Returns true if this string ends with another string.
endsWith : function (string1, substring) {
    if (string1 == null) return false;

    var startPos = string1.length - substring.length;
    if (startPos < 0) return false; // substring longer than main string
    return (string1.indexOf(substring, startPos) == startPos);
},

// escapes special characters in XML values - so called 'unparsed data'
// " -> &quot;
// ' -> &apos;
// & -> &amp;
// < -> &lt;
// > -> &gt;
// \r -> &x000D;
//
// NOTE: in an XHTML document, this is baseline functionality.
//
// NOTE: leave this function at the end of the file because the quotes within regex's hose the
// obfuscator, causing it to continue to end of file
makeXMLSafe : function (string, amp, lt, gt, quot, apos, cr) {
    if (string == null) return isc.emptyString;
    else if (!isc.isA.String(string)) string = string.toString();

    if (amp != false) string = string.replace(this._RE_amp, this._$amp);
    if (lt != false) string = string.replace(this._RE_lt, this._$lt);
    if (gt != false) string = string.replace(this._RE_gt, this._$gt);
    if (quot != false) string = string.replace(String._doubleQuoteRegex, this._$quot);
    if (apos != false) string = string.replace(String._singleQuoteRegex, this._$apos);
    if (cr != false) string = string.replace(this._RE_cr, this._$escapedCR);
    return string;
},
_$amp:"&amp;",
_$lt:"&lt;",
_$gt:"&gt;",
_$quot:"&quot;",
_$apos:"&apos;",
_$39:"&#39;",
_$escapedCR:"&#x000D;",
_RE_amp:/&/g,
_RE_lt:/</g,
_RE_gt:/>/g,
_RE_cr:/\r/g,

makeCDATA : function (string) {
    return "<![CDATA["+string.replace(/\]\]>/, "]]<![CDATA[>")+"]]>";
}

});









//>    @class    StringBuffer
//
//        Use instances of this class to concatenate strings rather than using the normal "this"+"that" methodology.
//        For large sets of strings, this can be up to an order of mangintude faster!
//
//        You can use this class in two ways:
//            1) if you have a static and fairly small set of things to concatenate, call statically
//                    alert(StringBuffer.concat("this"," ","that ","and the other"))
//                yields:        "This that and the other"
//
//            2) if you have a loop or more complex logic, create s StringBuffer instance and append to that,
//                then do a buffer.toString() on the results (or do something like an alert() or document.write()
//                that does a toString() for you:
//
//                  <pre>
//                    var buffer = StringBuffer.newInstance();
//                    for (var i = 0; i < 10; i++) {
//                        buffer.append(i, " ");
//                    }
//                    alert(buffer)
//                yields:    "0 1 2 3 4 5 6 7 8 9 "
//              </pre>
//<
isc.ClassFactory.defineClass("StringBuffer");
// nickname
isc.SB = isc.StringBuffer;

isc.StringBuffer.addClassProperties({
    // For efficiency we re-use StringBuffers (created lazily when needed).
    _bufferPool:[],
    // upper limit on the number of outstanding buffers to be re-used
    _maxPoolSize:50
});


isc.StringBuffer.addProperties({

    maxStreamLength : (isc.Browser.isIE6 ? 1000 : 100000),

    // Don't add props passed in to the SB on create - not supported and this is slightly
    // more efficient
    addPropertiesOnCreate:false

});
isc.StringBuffer.addMethods({


//>    @method        stringBuffer.init()    (A)
// Initialize the string buffer
//        @group    concat
//
//        @param    [a,b,c]    (object)    properties for the buffer instance
//<
init: function () {
    // create the stream array
    this._stream = [];
},

//>    @method        stringBuffer.append()
// Append all arguments to the string buffer as strings
//        @group    concat
//
//        @param    [arguments]    (string)    strings to append to the buffer
//<
append : function (arg1,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z) {


    // Set up local variable to use - this is a very small amount quicker than always referencing
    // this._stream directly
    var theStream = this._stream,  // by reference - manipulating this manipulates this._stream
        strings,
        undef;

    // If we are passed an array, it's quickest to manually add it slot by slot
       if (arg1 != null && arg1.constructor.__nativeType == 2) {



        var length = arg1.length;
        if (length <= 30) {
            var length = theStream.length;
            for (var i = 0; i < arg1.length; i++) {
                theStream[length++] = arg1[i];
            }
        } else {
            theStream[theStream.length] = arg1.join(isc.emptyString)
        }


    // If we are not passed an array it's quickest to iterate through the arguments and add them
    // to this._stream.
    // We don't have arguments.join(), and adding it is too expensive
    } else {
        if (Z === undef && Y === undef && X === undef) {


            if (arg1 != null) theStream[theStream.length] = arg1;
            if (A != null) theStream[theStream.length] = A
            if (B != null) theStream[theStream.length] = B
            if (C != null) theStream[theStream.length] = C
            if (D != null) theStream[theStream.length] = D
            if (E != null) theStream[theStream.length] = E
            if (F != null) theStream[theStream.length] = F
            if (G != null) theStream[theStream.length] = G
            if (H != null) theStream[theStream.length] = H
            if (I != null) theStream[theStream.length] = I
            if (J != null) theStream[theStream.length] = J
            if (K != null) theStream[theStream.length] = K
            if (L != null) theStream[theStream.length] = L
            if (M != null) theStream[theStream.length] = M
            if (N != null) theStream[theStream.length] = N
            if (O != null) theStream[theStream.length] = O
            if (P != null) theStream[theStream.length] = P
            if (Q != null) theStream[theStream.length] = Q
            if (R != null) theStream[theStream.length] = R
            if (S != null) theStream[theStream.length] = S
            if (T != null) theStream[theStream.length] = T
            if (U != null) theStream[theStream.length] = U
            if (V != null) theStream[theStream.length] = V
            if (W != null) theStream[theStream.length] = W

        // If we were passed more than 27 args, look at the arguments object

        } else {
            strings = arguments;
            for (var i = 0, l = strings.length; i < l; i++) {
                theStream[theStream.length] = strings[i]
            }
        }
    }

    // if we're holding on to too many string instances, collapse them into one instance
    // This is because IE slows down in general when a lot of large objects are sitting in
    // memory
    if (theStream.length > this.maxStreamLength) {
        theStream[0] = theStream.join(isc.emptyString);
        //isc.Log.logWarn("collapsing stream: " + theStream[0].substring(0, 80));
        theStream.length = 1;
    }
    return this;
},


appendNumber : function (number, length) {
    var stream = this._stream;
    if (length == null) {
        length = 5;
        var numberCopy = number;
        if (numberCopy < 0) {
            numberCopy = 0 - numberCopy;
            // add one for the "-" char
            length += 1;
        }
        // If it will take up more than 5 slots, determine how many it needs
        if (numberCopy >= 100000) {
            numberCopy = numberCopy / 100000;
            while (numberCopy >= 1) {
                length += 1;
                numberCopy = numberCopy / 10;
            }
        }
    }
    isc._fillNumber(stream, number, stream.length, length);
},

clear : function () {
    this._stream.length = 0;
},


// Can be called when a stringBuffer is no longer required - gets added to the pool to be reused
// Also returns the buffer's contents
release : function (noReturnValue) {

    var SB = isc.SB, pool = SB._bufferPool,
        string = noReturnValue ? null : this.toString();
    if (pool.length < SB._maxPoolSize) {

        // Clear it out and put it into the pool
        this.clear();
        pool[pool.length] = this;
    }
    if (!noReturnValue) return string;
},


getArray : function () {
    return this._stream;
}

});

//>    @method        stringBuffer.toString()
//        @group    concat
//             Return all of the appended strings as a single string.
//             Added manually here since doing it with addMethods doesn't work because toString is not
//             enumerable.
//
//        @return    (string)    a single concatenated string
//<
isc.StringBuffer.getPrototype().toString = function () {
    //if (isc.Browser.isMoz) isc.SB._checkArray(this._stream);
    return this._stream.join(isc.emptyString);
}

isc.StringBuffer._joinFunc = Array.prototype.join;
isc.StringBuffer.addClassMethods({

// Override create() - if we've already created a stringBuffer that's no longer being
// used, reuse it.
create : function () {
    var pool = this._bufferPool,
        poolLength = pool.length;
    if (poolLength > 0) {
        var buffer = pool[poolLength -1];
        pool.length = poolLength -1;
        return buffer;
    } else {
        // standard creation.
        return isc.Class.create.apply(this);
    }
},



//>    @method        StringBuffer.concat()
//        @group    concat
//             Static method that will return a string composed of the arguments passed in
//
//        @return    (string)    a single concatenated string
//<
_joinBuffer : [],
concat : function (A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,
                   a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z)
{


    var undef,
        returnString;
    if (isc.Browser.isIE && x === undef && y === undef && z === undef) {
        var buffer = this._joinBuffer;
        buffer.length = 0;


        if (A != null) buffer[buffer.length] = A;
        if (B != null) buffer[buffer.length] = B;
        if (C != null) buffer[buffer.length] = C;
        if (D != null) buffer[buffer.length] = D;
        if (E != null) buffer[buffer.length] = E;
        if (F != null) buffer[buffer.length] = F;
        if (G != null) buffer[buffer.length] = G;
        if (H != null) buffer[buffer.length] = H;
        if (I != null) buffer[buffer.length] = I;
        if (J != null) buffer[buffer.length] = J;
        if (K != null) buffer[buffer.length] = K;
        if (L != null) buffer[buffer.length] = L;
        if (M != null) buffer[buffer.length] = M;
        if (N != null) buffer[buffer.length] = N;
        if (O != null) buffer[buffer.length] = O;
        if (P != null) buffer[buffer.length] = P;
        if (Q != null) buffer[buffer.length] = Q;
        if (R != null) buffer[buffer.length] = R;
        if (S != null) buffer[buffer.length] = S;
        if (T != null) buffer[buffer.length] = T;
        if (U != null) buffer[buffer.length] = U;
        if (V != null) buffer[buffer.length] = V;
        if (W != null) buffer[buffer.length] = W;
        if (X != null) buffer[buffer.length] = X;
        if (Y != null) buffer[buffer.length] = Y;
        if (Z != null) buffer[buffer.length] = Z;
        if (a != null) buffer[buffer.length] = a;
        if (b != null) buffer[buffer.length] = b;
        if (c != null) buffer[buffer.length] = c;
        if (d != null) buffer[buffer.length] = d;
        if (e != null) buffer[buffer.length] = e;
        if (f != null) buffer[buffer.length] = f;
        if (g != null) buffer[buffer.length] = g;
        if (h != null) buffer[buffer.length] = h;
        if (i != null) buffer[buffer.length] = i;
        if (j != null) buffer[buffer.length] = j;
        if (k != null) buffer[buffer.length] = k;
        if (l != null) buffer[buffer.length] = l;
        if (m != null) buffer[buffer.length] = m;
        if (n != null) buffer[buffer.length] = n;
        if (o != null) buffer[buffer.length] = o;
        if (p != null) buffer[buffer.length] = p;
        if (q != null) buffer[buffer.length] = q;
        if (r != null) buffer[buffer.length] = r;
        if (s != null) buffer[buffer.length] = s;
        if (t != null) buffer[buffer.length] = t;
        if (u != null) buffer[buffer.length] = u;
        if (v != null) buffer[buffer.length] = v;
        if (w != null) buffer[buffer.length] = w;
        if (x != null) buffer[buffer.length] = x;
        if (y != null) buffer[buffer.length] = y;
        if (z != null) buffer[buffer.length] = z;

        returnString = buffer.join(isc.emptyString);
    } else {
        arguments.join = this._joinFunc;
        returnString = arguments.join(isc.emptyString);
    }

    return returnString;
}

});








isc.defineClass("StringMethod");

// Actual string value of the method is stored in the "value" property

isc.StringMethod.addMethods({

toString : function () {
    var value = this.getValue();
    if (value == null || isc.isA.String(value)) return value;
    return value.toString();
},

getValue : function () {
    return this.value;
},

// Helper method to get a 'display value' for the stringMethod
// Returns the expression / body of the function or, for actions, the title of the action
getDisplayValue : function () {
    var value = this.getValue();
    if (value == null || isc.isA.String(value)) return value;
    if (value.title != null) return "[" + value.title + "]"
    // If we were created with a string value, return the raw expression
    return value;

},

// not allowed to have ]]> in a CDATA block
cdata : function (string) {
    var index = string.indexOf("]]>");
    if (index == -1) return "<![CDATA[" + string + "]]>";
    return this.cdata(string.slice(0, index)) + "]]&gt;" + this.cdata(string.slice(index+3));
},

_xmlSerialize : function (name, type, namespace, prefix, refs, path) {
    var value = this.value;
    if (isc.isA.String(value)) return isc.Comm._xmlValue(name, this.cdata(value),
                                      type || "stringMethod", namespace, prefix);
    else
        return isc.StringMethod._xmlSerializeAction(value, name, prefix, refs, path);

}

});

isc.StringMethod.addClassMethods({

_$Action:"Action",
_xmlSerializeAction : function (action, name, indent, refs, path) {

        var actionDS = isc.DataSource.get(this._$Action);
        if (!actionDS) return isc.Comm._xmlSerializeObject(name, action, path, refs, indent);

        return [isc.Comm._xmlOpenTag(name),
                 actionDS.xmlSerialize(action, null, indent + "        ", this._$Action),
                 "\n", indent,
                 isc.Comm._xmlCloseTag(name)].join(isc.emptyString);

}

})




//> @class URIBuilder
//<
isc.defineClass("URIBuilder").addClassMethods({

create : function (uri) {
    if (isc.isA.String(uri)) return this.Super("create", { uri: uri });
    else return this.Super("create", arguments);
}

});

isc.URIBuilder.addProperties({

//> @attr URIBuilder.uri (String : "" : IR)
// The current URI.
//<
uri: ""

});

isc.URIBuilder.addMethods({

init : function () {
    this.Super("init", arguments);
    if (this.uri == null) this.uri = "";
    else this.uri = String(this.uri);
    this._qsStartPos = this._getQsStartPos();
},

_getQsStartPos : function () {
    var uri = this.uri;
    var hashStartPos = uri.indexOf('#');
    if (hashStartPos == -1) {
        return uri.indexOf('?');
    } else {
        var qsStartPos = uri.indexOf('?');
        if (qsStartPos >= hashStartPos) {
            return -1;
        }
        return qsStartPos;
    }
},

appendPath : function (path) {
    if (path == null || path.length == 0) return;

    var encodedPath = encodeURI(path).replace('?', encodeURIComponent('?')).replace('#', encodeURIComponent('#'));

    if (this.uri.length == 0) {
        this.uri = encodedPath;
        //assert this._getQsStartPos() == -1;
        //assert this._qsStartPos == -1;
        //assert this._getQsStartPos() == this._qsStartPos;
    } else {
        var pathEndPos = this._qsStartPos;
        if (pathEndPos == -1) {
            pathEndPos = this.uri.indexOf('#');
        }
        if (pathEndPos == -1) {
            pathEndPos = this.uri.length;
        }

        var tmp = this.uri.substring(0, pathEndPos);
        if (pathEndPos > 0 && this.uri[pathEndPos - 1] != '/' && path[0] != '/') {
            tmp += '/';
        }
        tmp += encodedPath;
        tmp += this.uri.substring(pathEndPos);
        this.uri = tmp;
        this._qsStartPos = this._getQsStartPos();
    }
},

_indexOfQueryParam : function (encodedName, pos) {
    if (pos == null) pos = this._qsStartPos;
    else pos = Math.max(this._qsStartPos, pos);

    if (pos < 0) return -1;

    var hashStartPos = this.uri.indexOf('#', this._qsStartPos + 1);
    var qsEndPos = hashStartPos == -1 ? this.uri.length : hashStartPos;
    for (; pos < qsEndPos && (pos = this.uri.indexOf(encodedName, pos)) != -1; pos += encodedName.length) {
        //assert pos >= 1;
        if (this.uri[pos - 1] == '&' || this.uri[pos - 1] == '?') {
            var pos2 = pos + encodedName.length;
            if (pos2 <= qsEndPos && (pos2 == qsEndPos ||
                                     this.uri[pos2] == '=' ||
                                     this.uri[pos2] == '&'))
            {
                return pos;
            }
        }
    }
    return -1;
},

containsQueryParam : function (name) {
    return name != null && this._indexOfQueryParam(encodeURIComponent(name)) != -1;
},

_appendQueryParamHelper : function (prefix, value) {
    if (value == null) return;
    if (isc.isA.String(value)) {
        var hashStartPos = this.uri.indexOf('#', this._qsStartPos == -1 ? 0 : this._qsStartPos + 1);
        if (hashStartPos == -1) hashStartPos = this.uri.length;

        var tmp = this.uri.substring(0, hashStartPos);

        if (this._qsStartPos == -1) {
            this._qsStartPos = hashStartPos;
            tmp += '?';
        } else tmp += '&';
        tmp += prefix;
        tmp += encodeURIComponent(value.toString());
        tmp += this.uri.substring(hashStartPos);
        this.uri = tmp;
        //assert this._getQsStartPos() == this._qsStartPos;
    } else if (isc.isAn.Array(value)) {
        for (var i = 0; i < value.length; ++i) {
            this._appendQueryParamHelper(prefix, value[i]);
        }
    } else {
        this._appendQueryParamHelper(prefix, String(value));
    }
},

appendQueryParam : function (name, value) {
    if (name == null) return;

    var encodedName = encodeURIComponent(name);
    var prefix = encodedName + '=';
    this._appendQueryParamHelper(prefix, value);
},

setQueryParam : function (name, value) {
    var encodedName = encodeURIComponent(name);
    var prefix = encodedName + '=';

    if (this._qsStartPos != -1) {
        var hashStartPos = this.uri.indexOf('#', this._qsStartPos + 1);
        var qsEndPos = hashStartPos == -1 ? this.uri.length : hashStartPos;
        var sb = "";
        sb += this.uri.substring(0, this._qsStartPos);
        var prevPos = this._qsStartPos, pos = this._qsStartPos;
        while (pos < qsEndPos && (pos = this.uri.indexOf(prefix, pos)) != -1) {
            //assert pos >= 1;
            var ampPos = this.uri.indexOf('&', pos + prefix.length);

            if (this.uri[pos - 1] == '&' || this.uri[pos - 1] == '?') {
                sb += this.uri.substring(prevPos, pos);
                if (ampPos != -1 && ampPos < qsEndPos) {
                    pos = ampPos + 1;
                } else {
                    pos = qsEndPos;
                    sb = sb.substring(0, sb.length - 1);
                }
            } else {
                pos = (ampPos != -1 && ampPos < qsEndPos ? ampPos + 1 : qsEndPos);
                sb += this.uri.substring(prevPos, pos);
            }
            prevPos = pos;
        }
        sb += this.uri.substring(prevPos, this.uri.length);
        this.uri = sb;
        this._qsStartPos = this._getQsStartPos();
    }

    this.appendQueryParam(name, value);
}

});








//>    @class    Cookie
//
//    Singleton class to manage browser cookies automatically.
//    The "Cookie" object is automatically created by the system for you.
//
//    Note that there is a limit to the size of the data that you can store
//    in all cookies for a site; it is generally believed that 1024 characters
//    is the maximum amount you can safely store in all cookies for one site.
//
//    You access cookie functions by calling methods on Cookie directly:
//
//            var value = Cookie.get("myCookieName");
//            Cookie.set("myCookieName", 100);
//            Cookie.clear("myCookieName");
//
//<


isc.ClassFactory.defineClass("Cookie");


//
//    add class methods to the cookie object
//
isc.Cookie.addClassMethods({
//>    @classMethod        Cookie.init()    (A)
//        Initialize the cookies array.  This method is called automatically whenever cookies are
//      accessed to make sure they're always correct.
//<
init : function () {
    isc.Cookie.list = {};
    if (document.cookie == "") return;

    var list = ("" + document.cookie).split("; ");
    for (var i = 0, len = list.length, it; it = list[i], i < len; i++) {
        var equalChar = it.indexOf('='),
            name = (equalChar == -1 ? it : it.substring(0,equalChar))
        ;
        isc.Cookie.list[name] = (equalChar == -1 ? '' : unescape(it.substring(equalChar+1)));
    }
},

//>    @classMethod        Cookie.get()
//        Get the value of a cookie by name.
//
//        @param    name    (string)    name of the cookie
//        @param            (string)    value of the cookie or null if not found
//<
get : function (name) {
    // call init again to refresh the list of cookies
    isc.Cookie.init();

    // get the value of the cookie
    return isc.Cookie.list[name];
},

//>    @classMethod        Cookie.set()
//        Set the value of a cookie.
//
//        @param    name            (string)        name of the cookie
//        @param    value            (string)        value for the cookie
//        @param    [path]            (string)        path to the cookie
//        @param    [domain]        (string)        domain of the cookie
//        @param    [expiration]    (date | string)    expiration date for the cookie
//<
set : function (name, value, path, domain, expiration) {
    // call init again to refresh the list of cookies
    isc.Cookie.init();

    // add the cookie
    document.cookie = name + "=" + escape(value)
                            + (path ? ";path=" + path : "")
                            + (domain ? ";domain=" + domain : "")
                            + (expiration ? ";expires=" + (isc.isA.String(expiration) ? expiration : expiration.toGMTString()) : "");
},

//>    @classMethod        Cookie.clear()
//        Clear a particular cookie.
//
//        @param    name            (string)        name of the cookie
//        @param    [path]            (string)        path to the cookie
//        @param    [domain]        (string)        domain of the cookie
//<
clear: function (name, path, domain) {
    // call init again to refresh the list of cookies
    isc.Cookie.init();

    // set the cookie to empty and set the expiration time to a long time ago
    this.set(name, "", path, domain, "Thu, 01-Jan-70 00:00:01 GMT");
},

//>    @classMethod        Cookie.getList()
//        Return the names of all of the cookies,
//
//        @return        (string[])    array of the names of all the cookies
//<
getList : function () {
    isc.Cookie.init();
    return isc.getKeys(isc.Cookie.list);
}

});





// Encapsulates various bits of logic for generating, converting, and
// presenting stack traces.
isc.defineClass("StackTrace");

isc.StackTrace.addClassMethods({
    // Creates a StackTrace from a browser-native exception stack
    //
    // For instance:
    //
    // try {
    //     eval("bob ===== 7;");
    // }
    // catch (e) {
    //     if (e.stack) {
    //         var trace = isc.StackTrace.fromNativeStack(e.stack);
    //         var output = trace.toString();
    //     }
    // }
    //
    // Chooses the correct subclass based on the browser. If the browser
    // native stack is not supported yet for te browswer, it will simply
    // output the stack itself.
    fromNativeStack : function (stack) {
        if (isc.Browser.isMoz) {
            return isc.MozStackTrace.create({stack: stack});
        } else if (isc.Browser.isChrome) {
            return isc.ChromeStackTrace.create({stack: stack});
        } else if (isc.Browser.isIE) {
            return isc.IEStackTrace.create({stack: stack});
        } else {
            return isc.UnsupportedStackTrace.create({stack: stack});
        }
    },

    // return an intelligently shortened version of the source file and line number
    getSourceLine : function (sourceLine, appDir, hostAndProtocol) {
        appDir = appDir || isc.Page.getAppDir();
        hostAndProtocol = hostAndProtocol || window.location.protocol + "//" + window.location.host;

        sourceLine = sourceLine.replace(/(\?|\&)?sc_selenium=true/, "");

        // detect core modules
        var modulesStart = sourceLine.indexOf("/system/modules/ISC_"),
            devModulesStart = sourceLine.indexOf("/system/development/ISC_");

        // core modules: trim off everything but module name
        if (modulesStart != -1) {
            sourceLine = sourceLine.substring(modulesStart + 16);
        } else if (devModulesStart != -1) {
            sourceLine = sourceLine.substring(devModulesStart + 20) + "[d]";
        }

        if (modulesStart != -1 || devModulesStart != -1) {
            // option to not show core modules
            if (!isc.Log.logIsDebugEnabled("traceLineNumbersCore")) return "";

            // core modules: trim out the version parameter (just noise)
            var versionIndex = sourceLine.indexOf("?isc_version");
            if (versionIndex != -1) {
                sourceLine = sourceLine.substring(0, versionIndex) +
                    sourceLine.substring(sourceLine.indexOf(":"));
            }
        }

        // other files: show obviously relative paths as relative
        if (sourceLine.startsWith(appDir)) {
            sourceLine = sourceLine.substring(appDir.length);
        } else if (sourceLine.startsWith(hostAndProtocol)) {
            sourceLine = sourceLine.substring(hostAndProtocol.length);
        }

        return " @ " + sourceLine;
    }
});


isc.StackTrace.addProperties({
    // Provide the browser-native stack on creation

    stack: null,

    // number of lines in error.stack before actual functions are lised off.  Eg Chrome stacks
    // start with the error message ("Reference error: ...").
    preambleLines : 0,

    // Where we store the "converted" stack trace in readable format
    // Access via the toString() method.
    _output: "",

    init : function() {
        if (this.stack) {
            this._parseStack();
        }
    },

    // Should extract the function name from a line of the stack
    // Implement in a browser-specific subclass
    extractFunctionFromLine : function (line) {
        this.logError("Should implement extractFunctionFromLine in subclass");
    },

    // Should extract the arguments from a line of the stack
    // Implement in a browser-specific subclass
    extractArgumentsFromLine : function (line) {
        this.logError("Should implement extractArgumentsFromLine in subclass");
    },

    // Should extract the source file and line number from a line of the stack
    // Implement in a browser-specific subclass
    extractSourceFromLine : function (line) {
        this.logError("Should implement extractSourceFromLine in subclass");
    },

    // Parse native stack trace
    // ---------------------------------------------------------------------------------------
    // Do an in-browser transform of the native stack to make it more readable.
    //
    // FF theoretically provides an onerror notification, but it seems flaky, and it is not
    // possible to walk the stack via arguments.caller.callee in this notification even when it
    // does fire.  So the best we can get when an error occurs is the native error.stack,
    // which we transform here for readability.
    //
    // How good is it:
    // - if function names have been embedded into framework code with server-side help, we can
    //   correctly identify and print the class and method for all framework functions that go
    //   through the obfuscator
    //   - this is better than the current state of parsing with the help of a server-side Perl
    //     script, which frequently misidentifies functions
    // - worse than stack walking via arguments.callee.caller, where:
    //   - we can identify all functions, regardless of whether they went through the
    //     obfuscator
    //   - we can directly access arguments and format them more meaningfully (eg, show than an
    //     object being passed to a method is an SC class, and show it's ID)
    _parseStack : function () {
        // Parse inside a try/catch block so that we can simply use the supplied
        // stack as the output if an error occurs in parsing.
        try {
            var lines = this.stack.split("\n"),
                output = isc.StringBuffer.create(),
                appDir = isc.Page.getAppDir(),
                hostAndProtocol = window.location.protocol + "//" + window.location.host;

            //isc.logWarn("original trace: " + lines.join("\n\n"));

            for (var i = this.preambleLines; i < lines.length; i++) {
                var line = lines[i],
                    argNames = null,
                    className = null,
                    methodName = null;

                //isc.logWarn("parsing line: " + line);

                var functionName = this.extractFunctionFromLine(line);
                if (functionName == "") {
                    functionName = "unnamed";
                } else if (functionName.startsWith("isc_")) {
                    var isClassMethod;
                    if (functionName.startsWith("isc_c_")) {
                        functionName = functionName.substring(6);
                        isClassMethod = true;
                    } else {
                        functionName = functionName.substring(4);
                    }
                    className = functionName.substring(0, functionName.indexOf("_"));
                    methodName = functionName.substring(className.length+1);

                    var clazz = isc.ClassFactory.getClass(className),
                        method = null;
                    if (clazz) {
                        method = isClassMethod ?
                            clazz[methodName] : clazz.getInstanceProperty(methodName);
                    }
                    // if we figure out what actual method is being referred to, we can find
                    // out the official argument names and show them
                    if (method != null) {
                        functionName = isc.Func.getName(method, true);
                        //isc.logWarn("Got live method: " + isc.Func.getName(method, true) +
                        //            " from functionName: " + functionName);
                        var argString;
                        if (!isClassMethod) {
                            // takes into account StringMethods
                            argString = clazz.getArgString(methodName);
                        } else {
                            argString = isc.Func.getArgString(method);
                        }
                        argNames = argString.split(",");
                        // NOTE: we checked to see if the live stack might still be there, since that would
                        // let us just call the normal getStackTrace() facility with the exception just
                        // serving to help us locate the leaf method, but as expected, only the stack above
                        // the try..catch is intact.  This does mean that we could call getStackTrace() for
                        // the top of the stack instead of parsing the Moz native trace, but not currently
                        // doing this since it could hit recursion issues and might mislead you into
                        // thinking two arguments differed since our traces provide more information (eg
                        // they look for an ID and display that)
                        //if (method.caller) {
                        //    isc.logWarn("method.caller: " + isc.Func.getName(method.caller, true) +
                        //                "\n" + isc.Log.getCallTrace(method.caller.arguments));
                    } else {
                        functionName = functionName.replace(/_{1}/, ".");
                        functionName = functionName.replace(/_{2}/, "._");
                    }
                }

                output.append("    ", functionName, "(");

                var argString = this.extractArgumentsFromLine(line);
                var argNum = 0;

                while (argString && argString.length > 0) {
                    if (argNum > 0) output.append(", ");
                    if (argNames) output.append(argNames[argNum] + "=>");
                    var lastLength = argString.length;
                    argString = this._parseArgument(argString, output);
                    if (argString.length == lastLength) {
                        isc.logWarn("failure to parse next arg at:\n" + argString);
                        break;
                    }
                    argNum++;
                }

                output.append(")");

                // add source path and line number
                var atIndex = line.lastIndexOf("@");
                output.append(isc.StackTrace.getSourceLine(this.extractSourceFromLine(line),
                                                           appDir, hostAndProtocol));

                output.append("\n");
            }

            this._output = output.toString();
        }
        // If there are any errors, we just store the stack itself as output
        catch (e) {
            this._output = this.stack;
        }
    },

    // parse an argument from a line in a native stack trace
    _parseArgument : function (argString, output) {
        //isc.logWarn("parsing argString: " + argString);

        var firstChar = argString.charAt(0);

        if (firstChar == "\"") { // string argument
            // look for an unquoted closing quote
            var stringEnd = argString.search(/[^\\]"/);
            if (stringEnd == -1) stringEnd = argString.length; // shouldn't happen

            var stringArg = argString.substring(0, stringEnd+2);
            // enforce max size
            if (stringArg.length > 40) {
                stringArg = stringArg.substring(0,40) + "...\"[ " + stringArg.length + "]";
            }
            output.append(stringArg);
            return argString.substring(stringEnd+3);

        } else if (firstChar == "[") { // object argument
            var closeBrace = argString.substring(1).indexOf("]"),
                objectString = argString.substring(0, closeBrace+2);
            // shorten this common case
            if (objectString == "[object Object]") objectString = "{Obj}";

            output.append(objectString);
            return argString.substring(closeBrace+3);

        } else if (argString.startsWith("(void 0)")) {
            output.append("undef");
            return argString.substring(9);

        } else if (argString.startsWith("undefined")) {
            output.append("undef");
            return argString.substring(10);

        } else if (argString.startsWith("(function ")) {
            var signature = argString.substring(1,argString.indexOf("{"));
            if (signature.endsWith(" ")) signature = signature.substring(0, signature.length-1);
            output.append(signature);

            var functionEnd = argString.indexOf("}),");
            if (functionEnd == -1) return ""; // no more arguments
            return argString.substring(functionEnd+3);

        } else { // other argument
            var nextComma = argString.indexOf(",");
            if (nextComma == -1) nextComma = argString.length;
            output.append(argString.substring(0, nextComma));
            return argString.substring(nextComma+1);
        }
    },

    // Return the normalized output
    toString : function () {
        return this._output;
    }
});

// The native stack trace for Mozilla has changed.  For FF14 and above, the arguments are
// no longer supplied and the native stack trace looks like:
//
// isc_Canvas_editSummaryField@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:30870
// isc_Canvas_addSummaryField@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:30865
// anonymous@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:420
// isc_Menu_selectMenuItem@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:28093
// isc_Menu_rowClick@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:28059
// anonymous@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:7836
// isc_GridRenderer__rowClick@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:6199
// isc_c_Class_invokeSuper@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:2263
// isc_c_Class_Super@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:2198
// isc_GridBody__rowClick@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:6793
// isc_GridRenderer_click@http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:6178
// isc_Canvas_handleClick@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:25741
// isc_c_EventHandler_bubbleEvent@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:15164
// isc_c_EventHandler_handleClick@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:14083
// isc_c_EventHandler__handleMouseUp@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:13973
// isc_c_EventHandler_handleMouseUp@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:13916
// isc_c_EventHandler_dispatch@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:15541
// anonymous@http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:420
//
// For FF13 and earlier, the lines from the native stack trace look something like this:
//
// eval("bob ==== 7;")@:0
// ()@http://localhost:40011/isomorphic/QA/Debug/StackTrace.test:45
// ()@http://localhost:40011/isomorphic/QA/Debug/StackTrace.test:40
// ()@http://localhost:40011/isomorphic/QA/Debug/StackTrace.test:36
// ([object Object],[object Object])@http://localhost:40011/isomorphic/QA/Debug/StackTrace.test:56
// isc_TestCase_run()@http://localhost:40011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:29775
// isc_TestRunner_runTests(0)@http://localhost:40011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:29920
// isc_TestRunner_init([object Object],(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0))@http://localhost:40011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:29882
// isc_Class_completeCreation([object Object],(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0),(void 0))@http://localhost:40011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:2323



isc.defineClass("MozStackTrace", isc.StackTrace).addProperties({
    // Parse a line from the stack and extract the function name
    extractFunctionFromLine : function (line) {
        var noArgs = isc.Browser.version >= 14,
            parenIndex = line.indexOf(noArgs ? "@" : "(");
        return line.substring(0, parenIndex);
    },

    // Parse a line from the stack and extract the arguments
    extractArgumentsFromLine : function (line) {
        if (isc.Browser.version >= 14) return "";
        var parenIndex = line.indexOf("(");
        var atIndex = line.lastIndexOf("@");
        return line.substring(parenIndex + 1, atIndex - 1);
    },

    // Extract the source file and line numver from a line
    extractSourceFromLine : function (line) {
        var atIndex = line.lastIndexOf("@");
        if (atIndex >= 0) {
            return line.substring(atIndex + 1);
        } else {
            return "";
        }
    }
});

// Browser specific subclass for Google Chrome
// Given this code:
//
//   isc.Page.setEvent("load", function foo () {
//       try {
//           var arr = [];
//           arr.myFunc = function () { crash() };
//           arr.myFunc();
//       } catch (e) {
//           isc.logWarn(e.stack);
//       }
//   });
//
// Error.stack looks like this:
//
//  ReferenceError: crash is not defined
//      at Array.myFunc (http://mime:15011/isomorphic/QA/scratch.jsp:776:31)
//      at Object.foo [as action] (http://mime:15011/isomorphic/QA/scratch.jsp:777:8)
//      at Object.isc_c_Page_handleEvent [as handleEvent] (http://mime:15011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:10998:17)
//      at isc_c_EventHandler_handleLoad (http://mime:15011/isomorphic/system/modules/ISC_Core.js?isc_version=dev.js:11702:17)
//
// 1. "Object." and "Array." is the native type of the "this" value.  Yes, incredibly useless
//     given that they clearly have the "this" value and its type is all we get.  May not be
//     present for something executed in global scope (last line)
// 2. "[as action]" means the function was invoked under the name "action" even though the
//     function is named foo.
//
// More background on special cases here, at the bottom:
//   http://code.google.com/p/v8/wiki/JavaScriptStackTraceApi
//
// Note: at the bottom of this page is a comment from Charles showing code to get a stack trace
// from a second, semi-secret Chrome API that allows programmatic accept to the stack frames,
// similar to arguments.callee.  As the snippet shows, using this API we would be able to get
// the actual "this" value.  We would also be able to get the value of arguments to functions
// in the stack for non-recursive functions, but only for a programmatic call to
// getStackTrace(), not from a caught error.

isc.defineClass("ChromeStackTrace", isc.StackTrace).addMethods({
    preambleLines:1,
    _functionRegexp: /at (Object\.)?([^ ]+)/,
    _sourceRegexp: /\((.+)\)/,

    // Parse a line from the stack and extract the function name
    extractFunctionFromLine : function (line) {
        var match = line.match(this._functionRegexp);
        return match ? match[2] : "";
    },

    // Parse a line from the stack and extract the arguments
    // Chrome does not appear to show the arguments ...
    extractArgumentsFromLine : function (line) {
        return "";
    },

    // Extract the source file and line numver from a line
    extractSourceFromLine : function (line) {
        var match = line.match(this._sourceRegexp);
        return match ? match[1] : "";
    }
});

// The error.stack from IE10 looks like:
//
// "TypeError: Unable to set property 'foo' of undefined or null reference
//   at isc_Canvas_editSummaryField (http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:30842:5)
//   at sc_Canvas_addSummaryField (http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:30837:5)
//   at Function code (Function code:1:1)
//   at isc_Menu_selectMenuItem (http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:28093:9)
//   at isc_Menu_rowClick (http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:28059:5)
//   at Function code (Function code:1:142)
//   at isc_GridRenderer__rowClick (http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:6199:5)
//   at isc_c_Class_invokeSuper (http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:2262:17)
//   at isc_c_Class_Super (http://localhost:49011/isomorphic/system/modules/ISC_Core.js?isc_version=v9.0p_2021-05-01.js:2198:9)
//   at isc_GridBody__rowClick (http://localhost:49011/isomorphic/system/modules/ISC_Grids.js?isc_version=v9.0p_2021-05-01.js:679[3:13)

isc.defineClass("IEStackTrace", isc.StackTrace).addMethods({
    preambleLines:1,
    _functionRegexp: /at ((?:[A-Za-z_$0-9]+ )+)/,
    _sourceRegexp: /\((.+)\)/,

    // Parse a line from the stack and extract the function name
    extractFunctionFromLine : function (line) {
        var match = line.match(this._functionRegexp);
        return match ? match[1] : "";
    },

    // Parse a line from the stack and extract the arguments
    // IE does not appear to show the arguments ...
    extractArgumentsFromLine : function (line) {
        return "";
    },

    // Extract the source file and line numver from a line
    extractSourceFromLine : function (line) {
        var match = line.match(this._sourceRegexp);
        return match ? match[1] : "";
    }
});

// Subclass for unsupported browsers
isc.defineClass("UnsupportedStackTrace", isc.StackTrace).addMethods({
    // For parseStack, just do nothing
    _parseStack : function () {

    },

    // Just return the stack itself
    toString : function () {
        return this.stack;
    }
});







isc._debug = {};

isc.addProperties(isc._debug, {

    // Stack Traces
    // --------------------------------------------------------------------------------------------
    // given the 'arguments' object from a function invocation, return a developer-readable summary,
    // complete with the names and values of the arguments

    //>    @method    Class.getCallTrace()
    // Returns a one-line summary of the current method call, showing method name and passed
    // arguments.
    // This function is available as a static on every ISC Class and as an instance
    // method on every instance of an ISC Class.<br>
    // General best practice is to call the method as "this.getCallTrace()" whenever "this" is an
    // instance, or call the static classMethod on the +link{class:Log} class otherwise.
    //
    // @param [args]  (Arguments)  arguments object from the call to trace.  On IE, defaults to the
    //                             calling function's arguments
    //
    // @group debug
    // @visibility external
    //<
    //> @classMethod Class.getCallTrace()
    // @include method:class.getCallTrace
    // @visibility external
    //<
    // We also explicitly doc this method on the Log class (the only place it was doc'd prior to 7.0)
    //> @classMethod Log.getCallTrace()
    // @include method:class.getCallTrace
    // @visibility external
    //<
    getCallTrace : function (args, thisValue, showShortMethodBody, argNames, argValues, extensionTrace) {
        if (args == null) args = arguments.caller;
        if (args == null) return "[getCallTrace(): Error: couldn't get arguments object]";

        var output, func = args.callee;

        // determine function name from arguments.callee.  arguments.callee property is the Function
        // instance being invoked.
        if (func == null) {
            // browser doesn't support args.callee? (should never happen)
            output = "[args.callee == null]";
        } else if (!isc.Func) {
            output = "[Func utility class not loaded]";
        } else {
            output = isc.Func.getName(func, true);
        }

        // output a summary of the parameters
        output += "(";

        // get the names of the parameters if available
        argNames = argNames || (func != null ? isc.Func.getArgs(func) : []);
        argValues = argValues || args;

        // iterate to the larger of the declared parameters or the passed parameters
        var length = Math.max(argValues.length, argNames.length);

        for (var i = 0; i < length; i++) {
            var argName = argNames[i],
                argValue = argValues[i];

            if (i > 0) output += ", ";
            if (argName != null) {
                // show the names of the parameters as eg
                // ListGrid.setRecordStyle(recordNum=>2, newStyle=>"cellDark");
                // Note that there may be no name for the parameter if a parameter was passed
                // where none was expected.
                output += argName + "=>";
            }
            output += this.echoLeaf(argValue);
        }
        output += ")";

        // there's no known way to generally derive the value of "this" from the arguments object -
        // but in ISC several key methods store it explicitly.  This is tremendously valuable in
        // trying to interpret long stacks with method calls weaving through several related
        // instances.a
        thisValue = thisValue || args.__this;
        if (thisValue) output += " on " + this.echoLeaf(thisValue);

        var showedCrashCode = false;


        // determine whether to show entire body of method in the trace
        if (showedCrashCode || (!showShortMethodBody && !func._showBodyInTrace)) return output;

        var body = this._getTrimmedMethodBody(func);
        if (!func._showBodyInTrace) {
            // if the function at the top of the stack (the one that crashed) or at the
            // bottom of the stack (the entry point) is a one-liner, show it's contents.
            // This is very useful when an anoynmous expression is being called on a timer.
            // NOTE: have to be careful here to avoid spitting out giant methods:
            // - with stripping all functions in ISC are one-liners, hence the crude length
            //   limit
            // - when using XML, very long functions are delivered as stringMethods
            // Could limit to anonymous functions like so:
            //     && args.callee.getName && args.callee.getName() == "anonymous")
            var lines = body.split(/[\r\n]+/);
            if (lines.length > 1 || lines[0].length > 200) return output;
        }
        output += '\n        "' + body + '"';

        return output;
    },

    // for when stack walking is enabled, trim off the try..catch block added to all functions
    _getTrimmedMethodBody : function (func) {
        var body = isc.Func.getBody(func);

        return body.trim();
    },

    //>    @method    Class.getStackTrace()
    // Returns a "stack trace" - one line per method in the current call stack, showing the method
    // name and any parameters passed.
    // This function is available as a static on every ISC Class and as an instance
    // method on every instance of an ISC Class.<br>
    // General best practice is to call the method as "this.getStackTrace" whenever "this" is an
    // instance, or call the static classMethod on the +link{class:Log} class otherwise.
    // <P>
    // Platform Notes: In Mozilla Firefox, if Firebug is enabled, a stack trace will be logged
    // to the firebug console in addition to the standard stack trace string returned by
    // this method.
    // <br>
    // In browsers other than Internet Explorer a complete stack trace may not be available -
    // this occurs when a function is re-entrant (meaning it calls itself). In this case the
    // stack will terminate with text indicating where the recursive function call occurred.
    // <P>
    // See +link{group:debugging} for further information information.
    //
    // @return (String) stack trace.  Use eg +link{method:isc.Class.logWarn()} to log to the
    // Developer Console.
    // @group debug
    // @visibility external
    //<
    //> @classMethod Class.getStackTrace()
    // @include method:class.getStackTrace
    // @visibility external
    //<

    // We also explicitly doc this method on the Log class (the only place it was doc'd prior to 7.0)
    //> @classMethod Log.getStackTrace()
    // @include method:class.getStackTrace
    // @visibility external
    //<
    getStackTrace : function (args, ignoreLevels, maxLevels, skipFBugTrace, extensionTrace) {


        var stack = "";


        stack += this._getStackTraceFromArgs(args,ignoreLevels,maxLevels);

        // If Firebug is present we can show a stack trace in it directly - see fireBugTrace()
        if (this.hasFireBug() && !skipFBugTrace) {
            isc.Log._fBugTrace = isc.Log._fBugTrace || 0;
            var traceId = "FBugTrace" + isc.Log._fBugTrace++;
            stack += "\r\n" + this.fireBugTrace(traceId);
        }

        return stack;
    },


    _getStackTraceFromArgs : function (args, ignoreLevels, maxLevels, extensionTrace) {
        // If we can't get at the properties necessary to do a stack walk just log a warning and
        // quit
        if (!arguments || !arguments.callee || !arguments.callee.caller) {
            return " [Stack trace not supported in this browser]";
        }

        // if we are not passed a specific arguments objects, default to the arguments object of
        // the function that asked for the stack trace

        if (args == null) args = arguments.caller || arguments.callee.caller.arguments;
        var output = [];

        // in earlier versions of IE we can use arguments.caller to walk up the stack
        // This actually allows us to get past recursive function calls in a way that
        // arguments.callee.caller does not - use it if available


        var useArgsCaller = extensionTrace || (isc.Browser.isIE && isc.Browser.version <= 5);

        // skip some of the stack (useful to eg, a logging subsystem)
        if (ignoreLevels != null) {
            for (var i = 0; i < ignoreLevels; i++) {
                if (args == null) break;
                if (!useArgsCaller) {
                    args = args.callee.caller.arguments;
                } else {
                    args = args.caller;
                }
            }
        }


        // we ran out of stack trying to skip past the ignoreLevels
        if (args == null) {
            return "";
        }

        var func = args.callee;

        var seenFuncs = [];

        var top = true;
        if (maxLevels == null) maxLevels = Number.MAX_VALUE;
        var numLevels = 0;

        var message = "";

        while (func != null && args != null && numLevels < maxLevels) {

            if (args.timerTrace) {
                output.add("\nStack trace for setTimeout() call:   " + args.timerTrace);
                break;
            }

            if (!useArgsCaller) {
                if (seenFuncs.contains(func)) {
                    output.add("    ** recursed on " + isc.Func.getName(func, true));
                    break;
                }
                seenFuncs.add(func);
            }

            var showFuncText = (top || (args.callee != null && args.callee.caller == null));
            if (extensionTrace) {

            } else {
                output.add("    " + this.getCallTrace(args, null, showFuncText));
            }

            if (numLevels == 0 || isc.showLocalsInTraces) {
                var locals = args.__frame;

                var frameLocalsOutput = this._getFrameLocals(locals, numLevels != 0);
                if (frameLocalsOutput) output.add(frameLocalsOutput);
            }

            func = args.callee;
            if (!useArgsCaller) {
                func = func.caller;
                if (func) args = func.arguments;
            } else args = args.caller;
            top = false;
            numLevels++;

            // the extension currently provides the global scope as a stack frame for
            // completeness
            if (extensionTrace && args != null && args.callee == null) {
                output.add("    [global scope]");
                break;
            }
        }
        if (output.length == 0) return "";
        // skip a line at the beginning of the stack trace
        return "\r\n" + output.join("\r") + "\r";
    },

    // http://stackoverflow.com/questions/398111/javascript-that-detects-firebug
    // Note that console.exception was added to Firefox 28, so we need to check whether console.exception
    // is a native function or not.
    // https://developer.mozilla.org/en-US/docs/Web/API/console.error
    hasFireBug : function () {
        return (isc.Browser.isMoz &&
                window.console != null &&
                (window.console.firebug != null ||
                 (window.console.exception != null &&
                  (isc.Browser.version <= 27 || window.console.exception.toString().indexOf("[native code]") < 0))));
    },

    fireBugVersion : function () {
        return this.hasFireBug() ? window.console.firebug : null;
    },

    // this help function
    fireBugTrace : function (traceId) {
        window.console.trace(traceId);
        return " [Complete stack trace logged via Firebug: " + traceId + "]";
    },

    // get a report of local variable values from a frame (that is, a dump of local variable
    // values from the moment a function crashed)
    _getFrameLocals : function (frame, singleLine) {
        var output = isc.SB.create();
        var first = true;
        for (var varName in frame) {
            var varValue = frame[varName], undef;

            // avoid reporting variables that have not yet been declared or assinged to.  Note
            // this also catches values that have been explicitly assigned undef; we require
            // the developer to understand what the omission means.
            if (varValue === undef) continue;

            // ignore special values stored on the frame object (we assume no local variable
            // would be named with an _)
            if (isc.startsWith(varName, isc._underscore)) continue;

            if (singleLine) {
                if (!first) output.append(", ");
                else output.append("\n        locals: ");
                output.append(varName + "=>" + this.echoLeaf(varValue));
                first = false;
            } else {
                output.append("\n        " + varName + " = " + this.echoLeaf(varValue));
            }
        }
        return output.toString();
    },

    // called in two circumstances (split these uses?)
    // - when trapping JS errors at top level entry points (eg events) in non-IE browsers
    // - with "stackwalking" try..catch blocks added to all methods, called from every catch
    //   block successively in order to walk the stack by catch..rethrow (any browser)
    _reportJSError : function (error, args, thisValue, frame, addedMessage) {


        // avoid reporting the same error twice
        if (error._reported) return;
        error._reported = true;

        var message = (addedMessage ? addedMessage + ": " : "") + error.toString();

        // Do an in-browser transform of the native stack to make it more readable.
        if (error.stack) {
            message += "\nStack from error.stack:\n";
            message += isc.StackTrace.fromNativeStack(error.stack).toString();
        } else {
            message += "  [No error.stack available]";
        }



        this._reportJSErrorStack(message);
    },


    _reportJSErrorStack : function (message) {
        this.logWarn(message);
    },





    // Shim for old function ... now implemented in debug/StackTrace.js
    transformMozStackTrace : function (trace) {
        return isc.StackTrace.fromNativeStack(trace).toString();
    },



    // Echoing Objects
    // --------------------------------------------------------------------------------------------

    //>    @method    Class.echoLeaf()
    // Return a very short (generally less than 40 characters) string representation of any object,
    // suitable for viewing by a developer for debugging purposes.
    // This function is available as a static on every ISC Class and as an instance
    // method on every instance of an ISC Class.<br>
    // General best practice is to call the method as "this.echoLeaf" whenever "this" is an
    // instance, or call the static classMethod on the +link{class:Log} class otherwise.
    //
    // @param  obj  (any)  object to echo
    // @return (string) a short string representation of the object
    //
    // @group debug
    // @see class.echo()
    // @visibility external
    //<
    //> @classMethod Class.echoLeaf()
    // @include method:class.echoLeaf
    // @visibility external
    //<

    // We also explicitly doc this method on the Log class (the only place it was doc'd prior to 7.0)
    //> @classMethod Log.echoLeaf()
    // @include method:class.echoLeaf
    // @visibility external
    //<
    _echoLeafLimit: 40,
    echoLeaf : function (obj, longMode) {
        var output = "", undefined;
        if (obj === undefined) return "undef";
        try {
            // Avoid attempting to manipulate SGWT Java objects
            if (obj != null && isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(obj))
                return obj.toString();

            if (isc.isA.Class(obj)) {
                // Always call toString() for instances of Classes.  We need handle this case
                // specially, since typeof [instance of a Class] is "object", and we try to do
                // special things for vanilla Objects below
                output += obj.toString();
            } else if (isc.isAn.Array(obj)) {
                output += "Array[" + obj.length + "]";
            } else if (isc.isA.Date(obj)) {
                output += "Date(" + obj.toShortDate() + ")";
            } else if (isc.isA.Function(obj)) {
                output += isc.Func.getName(obj, true) + "()";
            } else {
                switch (typeof obj) {
                case "string" :
                    var limit = this._echoLeafLimit;
                    // for shorter strings show the whole thing.  Also, in "longMode" don't
                    // shorten.
                    if (obj.length <= limit || longMode) {
                        output += '"' + obj + '"';
                        break;
                    }

                    // for long strings, show an elipsis and the strings full length
                    output += '"' + obj.substring(0, limit) + '..."[' + obj.length + ']';

                    // convert CR/LF to avoid spanning several lines
                    output = output.replaceAll("\n", "\\n").replaceAll("\r", "\\r");
                    break;
                case "object" :
                    // typeof null is "object"
                    if (obj == null) { output += "null"; break; }

                    // DOM object
                    if (obj.tagName != null) {
                        output += "[" + obj.tagName + "Element]" + this.getIDText(obj);
                        break;
                    }

                    var toString = "" + obj;
                    if (toString != "" && toString != "[object Object]" &&
                        toString != "[object]")
                    {
                        // someone went through the trouble of making a better toString(), so
                        // use it.  NOTE: check for "" because in IE an XmlNodeList among
                        // others will toString() to ""
                        output += toString;
                        break;
                    }

                    // return generic "Obj", plus any obvious ID/name property
                    output += "Obj" + this.getIDText(obj);

                    break;
                default: output += "" + obj; // invoke native toString()
                }
            }
            return output;
        } catch (e) {
            var message = "[Error in echoLeaf: " + e + "]";
            output += message;
            this.logDebug(message, "Log");
            return output;
        }
    },

    getIDText : function (obj) {
        // look for properties that may name the object

        // name
        var name = obj.name || (isc.isAn.XMLNode(obj) ? obj.getAttribute("name") : null);
        if (name != null && !isc.isAn.emptyString(name)) return "{name:" + name + "}";

        // ID or id
        var ID = obj.ID != null ? obj.ID :
                    obj.id != null ? obj.id :
                      (isc.isAn.XMLNode(obj) ? obj.getAttribute("id") : null);
        if (ID != null && !isc.isAn.emptyString(ID)) return "{ID:" + ID + "}";

        // nodeName (HTML DOM)
        if (obj.nodeName != null && !isc.isAn.emptyString(obj.nodeName)) {
            return "{nodeName:" + obj.nodeName + "}";
        }

        // title (eg sections)
        var title = obj.title || (isc.isAn.XMLNode(obj) ? obj.getAttribute("title") : null);
        if (title != null && !isc.isAn.emptyString(title)) return "{title:" + title + "}";

        // type (eg validators)
        var type = obj.type || (isc.isAn.XMLNode(obj) ? obj.getAttribute("type") : null);
        if (type != null && !isc.isAn.emptyString(type)) return "{type:" + type + "}";

        // _constructor (initData)
        var type = obj._constructor;
        if (type != null && !isc.isAn.emptyString(type)) return "{_constructor:" + type + "}";

        // random other objects that might have a "label" property (such as a TreeNode where
        // "label" is the titleField)
        var label = obj.label || (isc.isAn.XMLNode(obj) ? obj.getAttribute("label") : null);
        if (label != null && !isc.isAn.emptyString(label)) return "{label:" + label + "}";

        // className (initData as captured by globalEvalWithCapture)
        var type = obj.className;
        if (type != null && !isc.isAn.emptyString(type)) return "{className:" + type + "}";

        // length: handy for recognizing XMLNodeLists and similar objects in IE, which aren't
        // Arrays and can't be enumerated
        if (obj.length != null) return "{length:" + obj.length + "}";
        return "";
    },

    //>    @method    Class.echo()
    // Return a short string representation of any object, suitable for viewing by a developer for
    // debugging purposes.
    // <P>
    // If passed an object containing other objects, echo will not recurse into subobjects,
    // summarizing them instead via echoLeaf().
    // <P>
    // NOTE: echo() is used to generate the output shown in the Log window when evaluating an
    // expression.
    // <P>
    // This function is available as a static on every ISC Class and as an instance
    // method on every instance of an ISC Class.<br>
    // General best practice is to call the method as "this.echo()" whenever "this" is an
    // instance, or call the static classMethod on the +link{class:Log} class otherwise.
    //
    // @param obj (any) object to echo
    // @return (string) a short string representation of the object
    //
    // @group debug
    // @see Log.echoAll()
    // @see Log.echoLeaf()
    // @visibility external
    //<

    //> @classMethod Class.echo()
    // @include method:class.echo
    // @visibility external
    //<

    // We also explicitly doc this method on the Log class (the only place it was doc'd prior to 7.0)
    //> @classMethod Log.echo()
    // @include method:class.echo
    // @visibility external
    //<
    echo : function (obj, multiLine, longArrays, showFunctions) {
        if (obj == null) return this.echoLeaf(obj);

        // Avoid attempting to manipulate SGWT Java objects
        if (isc.Browser.isSGWT && window.SmartGWT.isNativeJavaObject(obj)) return obj.toString();

        if (multiLine == null) multiLine = true;

        if (obj.tagName) return this.echoDOM(obj);

        // anything isn't an Array or Object should be handled by echoLeaf.  (Note that typeof
        // [] is "object").  Note we pass a flag telling echoLeaf it shouldn't try to shorten
        // it's result, since it's going to be the entirety of the output.
        if (typeof obj != "object" || isc.isA.Date(obj)) return this.echoLeaf(obj, true);

        // echo entire arrays rather than just their properties
        if (isc.isAn.Array(obj)) {
            var output = (longArrays ? "[\n" : "[");
            for (var i = 0; i < obj.length; i++) {
                // echo each item either as a leaf or as a full property map
                output += (longArrays ? this.echo(obj[i], multiLine) : this.echoLeaf(obj[i]));
                if (i + 1 < obj.length) output += (longArrays ? ",\n" : ", ");
            }
            output += "\n]";
            return output;
        }

        // echo only properties of this instance, as opposed to properties inherited from it's
        // superclass if any
        var output = "{";
        if (obj.getUniqueProperties != null) {
            output = obj.getClassName() + "{";
            obj = obj.getUniqueProperties();
            // avoid a blizzard of function definitions
            if (showFunctions == null) showFunctions = false;
        }
        // if this is not an ISC object, not a DOM element, not atomic (eg String or
        // Number), and not an Array, show its functions as it's something unusual where we'd
        // like to see everything
        if (showFunctions == null) showFunctions = true;

        // echo normal objects
        var propertyNames;
        try {
            propertyNames = isc.getKeys(obj);
        } catch (e) {
            // in IE several XML-related objects through exceptions if you try to for..in on
            // them
            return this.echoLeaf(obj);
        }

        if (isc.Browser.isSafari) {

            var isStyle = false,
                styleDecl = "[object CSSStyleDeclaration]";
            try {
                // many objects JSError on attempts to toString() in Safari
                isStyle = (obj + "" == styleDecl);
            } catch (e) { }
            if (isStyle) {
                output = styleDecl + "{\n[standard props only]\n";
                propertyNames = isc.getKeys(isc.Canvas._getStylePropertyMask());
                // add 'cssText' as that's not included by default
                propertyNames.add("cssText");
            }
        }


        for (var i = 0; i < propertyNames.length; i++) {
            var propertyName = propertyNames[i],
                value;

            try {
                // sometimes you can get permission denied on the property access rather than
                // on the attempt to toString() the value
                value = obj[propertyName];
            } catch (e) {
                value = "[error accessing property: " + e + "]";
            }
            if (!showFunctions && isc.isA.Function(value)) continue;
            // don't show internal properties when private identifier obfuscation is on
            if (propertyName.startsWith("$")) continue;

            var echoValue;
            if (propertyName == isc.gwtRef) {
                // don't try to echo references to GWT Java objects.  In hosted / dev mode, our
                // attempt to look for various identifying properties can cause the GWT engine
                // to wedge
                echoValue = "{GWT Java Obj}";
            } else if (propertyName == isc.gwtModule) {
                // Also don't echo references to the GWT module exported to SGWTFactory
                echoValue = "{GWT Module Obj}";
            } else {
                echoValue = this.echoLeaf(value);
            }
            output += propertyName + ": " + echoValue;
            if (i + 1 < propertyNames.length) output += (multiLine ? ",\r" : ", ");
        }
        output += "}";
        return output;
    },

    //>    @method    Class.echoAll()
    // Like echo(), except that if passed an Array, echoAll() will echo() every element of the
    // Array.
    // This function is available as a static on every ISC Class and as an instance
    // method on every instance of an ISC Class.<br>
    // General best practice is to call the method as "this.echo()" whenever "this" is an
    // instance, or call the static classMethod on the +link{class:Log} class otherwise.
    //
    // @param obj  (any)  object to echo
    // @return (string) a short string representation of the object
    //
    // @group debug
    // @see echo()
    // @visibility external
    //<
    //> @classMethod Class.echoAll()
    // @include method:class.echoAll
    // @visibility external
    //<

    // We also explicitly doc this method on the Log class (the only place it was doc'd prior to 7.0)
    //> @classMethod Log.echoAll()
    // @include method:class.echoAll
    // @visibility external
    //<
    echoAll : function (obj, multiLine) {
        return this.echo(obj, multiLine, true);
    },

    echoFull : function (obj) {
        return isc.JSON.encode(obj, {
            prettyPrint:true,
            showDebugOutput:true
        })
    },

    // variant of echo that will be compact: one line, don't recurse into arrays
    echoShort : function (obj) {
        return this.echo(obj, false, false);
    },

    // echoArray - writes out an array with numbered slots.
    echoArray : function (obj) {
        if (!isc.isAn.Array(obj)) return this.echo(obj);
        if (obj.length == 0) return "[empty array]";
        var result = ["["];
        for (var i = 0; i < obj.length; i++) {
            result.addList([i, ":", obj[i], "\n"]);
        }
        result.add("]");
        return result.join("");
    },

    // various properties we want to ignore when echoing DOM elements
    _DOMIgnoreProperties : {

        // we rarely care about the text value of a node
        outerText: false,
        innerText: false,

        // IE proprietary crap
        parentTextEdit: false,
        isTextEdit: false,
        parentTextEdit: false,
        contentEditable: false,
        canHaveHTML: true,
        isMultiLine: false,
        filters: false,
        canHaveChildren: false,
        behaviorUrns: false,
        sourceIndex: false,
        accelerator: false,
        textDecorationUnderline: false,
        textDecorationNone: false

        // security exceptions in Moz
        //fullScreen: false, // window.fullScreen

        // error in IE6 (maybe other versions).  You cannot compare the values of these
        // properties to strings.  If you try (eg window.navigator == "") you get "object does
        // not support this property or method", presumably because some native code threw an
        // exception trying to compare against a JS string.
        //clientInformation: false, // window
        //external: false, // window
        //navigator: false, // window
    },

    // echo a DOM Node, avoiding outputting the many constants, functions, and other useless
    // things that appear on all DOM Nodes.
    // NOTE: in IE, there's no real prototype for DOM elements, so we just suppress things by
    // hand.
    echoDOM : function (node) {
        return this.echoDelta(node, window.Node, node.tagName + this.getIDText(node));
    },

    echoEvent : function (event) {
        // NOTE: in Moz, some of the constants we'd like to omit are on window.KeyEvent and some are
        // on window.Event.  window.KeyEvent has more.
        return this.echoDelta(event, (isc.Browser.isMoz ? window.KeyEvent : window.Event));
    },

    echoDelta : function (obj, base, prefix) {
        if (obj == null) return null;

        if (isc.Browser.isIE && isc.isAn.XMLNode(obj)) {

            var output = "<" + obj.tagName + " [XMLNode] ";
            var attrs = obj.attributes;
            for (var i = 0; i < attrs.length; i++) {
                var attr = attrs[i];
                if (i > 0) output += " ";
                output += attr.name + "=" + this.echoLeaf(attr.value);
            }
            output += (i > 0 ? " [" : "") + obj.childNodes.length + " child nodes]>";
            return output;
        }

        var output = (prefix || isc.emptyString) + "{",
            propertyNames = isc.getKeys(obj);
        for (var i = 0; i < propertyNames.length; i++) {
            var propertyName = propertyNames[i];

            // skip useless properties found in DOM objects
            if (this._DOMIgnoreProperties[propertyName] != null) continue;

            // skip properties inherited from base class
            if (base != null && base[propertyName] != null) continue;

            // omit multi-letter properties in all caps (typically constants)
            if (propertyName.length > 3 && propertyName.toUpperCase() == propertyName) continue;

            try {
                var value = obj[propertyName];

                // skip null/empty values
                if (value == null || value == "") continue;

                // skip functions
                if (isc.isA.Function(value)) continue;

                output += propertyName + ": " + this.echoLeaf(obj[propertyName]);
            } catch (e) {
                output += propertyName + ": " + this.echoLeaf(e);
            }
            if (i + 1 < propertyNames.length) output += ", ";
        }
        output += "}";
        return output;
    },

    // echo all the size-related properties of a DOM element.  Won't work in Nav4.
    echoElementSize : function (element) {
        var undefined;
        return this.echo({
            scrollLeft : element.scrollLeft,
            scrollTop : element.scrollTop,
            scrollWidth : element.scrollWidth,
            scrollHeight : element.scrollHeight,
            clientWidth : undefined,
            clientHeight : undefined,
            offsetWidth : element.offsetWidth,
            offsetHeight : element.offsetHeight,
            styleLeft : element.style.left,
            styleTop : element.style.top,
            styleWidth : element.style.width,
            styleHeight : element.style.height,
            styleClip : element.style.clip
        });
    }
});

// make methods available on any class or instance
isc.Class.addProperties(isc._debug);
isc.Class.addClassProperties(isc._debug);







// The log functions below will always be defined even with DEBUG> <DEBUG blocks stripped, so that
// if an end user calls a log function and forgets to mark it with DEBUG, it doesn't result in a
// JS error.

// write special log accessor functions for Class instances so we can call them
isc._logMethods =
{

    logMessage : function (priority, message, category, timestamp) {
        var log = isc.Log;
        if (!log) return;

        //>DEBUG

        // if no priority was passed in, use the default
        if (priority == null) priority = log.defaultPriority;

        // automatically add a stack trace for error logs
        if (priority <= log.stackTracePriority && this.getStackTrace != null) {
            // skip two levels of the stack to avoid showing the logMessage() invocation itself
            message += "\nStack trace:\n" + this.getStackTrace(arguments, 2);
        }

        // If a category was not specified, use the name of this class.
        if (!category) category = this.Class;

        var idString = this.ID;
        if (isc.FormItem && isc.isA.FormItem(this) && this.name != null) {
            idString += "[" + this.name + "]";
        }

        // actually do the log.  NOTE: if we have an instance ID, pass it
        log.log(priority, message, category, idString, this, timestamp);

        //<DEBUG
    },

    //> @method class.logDebug()
    // Log a message at "debug" priority
    // <P>
    // A method named log<i>Priority</i> exists for each priority level, on every ISC Class and
    // instance of an ISC Class.  Messages logged on a Class or instance have a default
    // category of the classname.  Messages logged on an instance will also automatically
    // incorporate the instance ID.  General best practice is to call logDebug() et al as
    // "this.logDebug" whenever "this" is an instance, or as "Log.logDebug" otherwise.
    //
    //     @param message    (String)  message to log
    //     @param [category] (String)  category to log in
    //
    // @see Log.echo() for dumping datastructures to the log
    // @see Log.setPriority() for controlling what messages appear in the log
    // @visibility external
    //<
    //> @classMethod class.logDebug()
    // @include method:class.logDebug
    // @visibility external
    //<

    // We commonly refer to the classMethod Log.logDebug / logWarn et al

    //> @classMethod Log.logDebug()
    // @include classMethod:class.logDebug()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    logDebug : function (message, category) { return this.logMessage(isc.Log.DEBUG, message, category)},

    //> @method class.logInfo()
    // Log a message at "info" priority
    //
    //     @param message    (String)  message to log
    //     @param [category] (String)  category to log in
    //
    // @see Log.logDebug() for usage info
    // @visibility external
    //<
    //> @classMethod class.logInfo()
    // @include method:class.logInfo
    // @visibility external
    //<

    //> @classMethod Log.logInfo()
    // @include classMethod:class.logInfo()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    logInfo : function (message, category) { return this.logMessage(isc.Log.INFO, message, category)},

    //> @method class.logWarn()
    // Log a message at "warn" priority
    //
    //     @param message    (String)  message to log
    //     @param [category] (String)  category to log in
    //
    // @see Log.logDebug() for usage info
    // @visibility external
    //<
    //> @classMethod class.logWarn()
    // @include method:class.logWarn
    // @visibility external
    //<

    //> @classMethod Log.logWarn()
    // @include classMethod:class.logWarn()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    logWarn : function (message, category) { return this.logMessage(isc.Log.WARN, message, category)},

    //> @method class.logError()
    // Log a message at "error" priority
    //
    //     @param message    (String)  message to log
    //     @param [category] (String)  category to log in
    //
    // @see Log.logDebug() for usage info
    // @visibility external
    //<
    //> @classMethod class.logError()
    // @include method:class.logError
    // @visibility external
    //<

    //> @classMethod Log.logError()
    // @include classMethod:class.logError()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    logError : function (message, category) { return this.logMessage(isc.Log.ERROR, message, category)},

    //> @method class.logFatal()
    // Log a message at "fatal" priority
    //
    //     @param message    (String)  message to log
    //     @param [category] (String)  category to log in
    //
    // @see Log.logDebug() for usage info
    // @visibility external
    //<
    //> @classMethod class.logFatal()
    // @include method:class.logFatal
    // @visibility external
    //<

    //> @classMethod Log.logFatal()
    // @include classMethod:class.logFatal()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    logFatal : function (message, category) { return this.logMessage(isc.Log.FATAL, message, category)},

    //> @method class.logIsEnabledFor()
    // Check whether a message logged at the given priority would be visible in the log.
    // <P>
    // As with logDebug, category is defaulted to the current className.  Use this method to avoid
    // putting together expensive log messages if they will never appear in the log.
    //
    //     @param priority   (LogPriority)  priority level
    //     @param [category] (String)            category to log in
    // @visibility external
    //<
    //> @classMethod class.logIsEnabledFor()
    // @include method:class.logIsEnabledFor
    // @visibility external
    //<
    logIsEnabledFor : function (priority, category) {
        return (isc.Log.isEnabledFor &&
                isc.Log.isEnabledFor((category ? category : this.Class), priority, this))
    },

    //> @method class.logIsDebugEnabled()
    // Check whether a message logged at "debug" priority would be visible in the log.
    // <P>
    // As with logDebug, category is defaulted to the current className.  Use this method to avoid
    // putting together expensive log messages if they will never appear in the log.
    //
    //     @param [category] (String)            category to log in
    // @visibility external
    //<
    //> @classMethod class.logIsDebugEnabled()
    // @include method:class.logIsDebugEnabled
    // @visibility external
    //<
    logIsDebugEnabled : function (category) { return this.logIsEnabledFor(isc.Log.DEBUG, category) },

    //> @method class.logIsInfoEnabled()
    // Check whether a message logged at "info" priority would be visible in the log.
    // <P>
    // As with logDebug, category is defaulted to the current className.  Use this method to avoid
    // putting together expensive log messages if they will never appear in the log.
    //
    //     @param [category] (String)            category to log in
    // @visibility external
    //<
    //> @classMethod class.logIsInfoEnabled()
    // @include method:class.logIsInfoEnabled
    // @visibility external
    //<
    logIsInfoEnabled : function (category) {    return this.logIsEnabledFor(isc.Log.INFO, category) },

    //> @method class.logIsWarnEnabled()
    // Check whether a message logged at "warn" priority would be visible in the log.
    // <P>
    // As with logDebug, category is defaulted to the current className.  Use this method to avoid
    // putting together expensive log messages if they will never appear in the log.
    //
    //     @param [category] (String)            category to log in
    // @visibility external
    //<
    //> @classMethod class.logIsWarnEnabled()
    // @include method:class.logIsWarnEnabled
    // @visibility external
    //<
    logIsWarnEnabled : function (category) {    return this.logIsEnabledFor(isc.Log.WARN, category) },

    //> @method class.logIsErrorEnabled()
    // Check whether a message logged at "error" priority would be visible in the log.
    // <P>
    // As with logDebug, category is defaulted to the current className.  Use this method to avoid
    // putting together expensive log messages if they will never appear in the log.
    //
    //     @param [category] (String)            category to log in
    // @visibility external
    //<
    //> @classMethod class.logIsErrorEnabled()
    // @include method:class.logIsErrorEnabled
    // @visibility external
    //<
    logIsErrorEnabled : function (category) {    return this.logIsEnabledFor(isc.Log.ERROR, category) },

    // Methods to update the log priority directly on objects

    //> @method class.setLogPriority()
    // Set the priority of messages that will be visible for some log category, when logged on
    // this Class or Instance object.<br>
    // If called with no category, this priority will be applied to every logged message on this
    // object<br>
    // To set the visible log priority for some category across the entire page, use
    // <code>isc.Log.setPriority()</code> instead.
    // @param category (string) Category for which the log priority will be updated. If not
    //                          all logs on this canvas will be logged at the priority passed in.
    // @param priority (LogPriority) priority level
    // @see Log.setPriority()
    // @visibility external
    //<
    //> @classMethod class.setLogPriority()
    // @include method:class.setLogPriority
    // @visibility external
    //<

    //> @classMethod Log.setLogPriority()
    // @include classMethod:class.setLogPriority()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    setLogPriority : function (category, priority) {
        isc.Log.setPriority(category, priority, this);
    },

    //> @method class.setDefaultLogPriority()
    // Set the default priority of logging for messages logged on this Class or Instance object.
    // All categories for which there is no explicit, instance level logging priority set will
    // log at this level on this object.<br>
    // To set the default visible log priority across the entire page, use
    // <code>isc.Log.setDefaultPriority()</code> instead.
    // @param category (string) Category for which the log priority will be updated. If not
    //                          all logs on this canvas will be logged at the priority passed in.
    // @param priority (LogPriority) priority level
    // @see Log.setPriority()
    // @visibility external
    //<
    //> @classMethod class.setDefaultLogPriority()
    // @include method:class.setDefaultLogPriority
    // @visibility external
    //<

    //> @classMethod Log.setDefaultLogPriority()
    // @include classMethod:class.setDefaultLogPriority()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    setDefaultLogPriority : function (priority) {
        isc.Log.setDefaultPriority(priority, this);
    },

    //> @method class.getDefaultLogPriority()
    // Retrieves the default priority of messages for this class or instance.
    // @return (LogPriority) default priority for logging messages on this object.
    // @visibility external
    //<
    //> @classMethod class.getDefaultLogPriority()
    // @include method:class.getDefaultLogPriority
    // @visibility external
    //<

    //> @classMethod Log.getDefaultLogPriority()
    // @include classMethod:class.getDefaultLogPriority()
    // A common usage is to call this method directly on the Log class
    // @visibility external
    //<
    getDefaultLogPriority : function () {
        return isc.Log.getDefaultPriority(this);
    },

    //> @method class.clearLogPriority()
    // Clear this object's priority setting for a particular category, so that the category's
    // effective priority returns to the specified priority for this category at the Log level
    // (or <code>Log.defaultPriority</code> if not set).<br>
    // To clear the Page-level priority setting for this log category use
    // <code>isc.Log.clearPriority()</code> instead.
    //
    // @param category   (String) Category name. If not specified, all logging on this object
    //                              will revert to default priority settings.
    // @visibility external
    // @see Log.clearPriority()
    //<
    //> @classMethod class.clearLogPriority()
    // @include method:class.clearLogPriority
    // @visibility external
    //<
    clearLogPriority : function (category) {
        isc.Log.clearPriority(category, this);
    }

};

// add the methods to Class object prototype and to the Class instance prototype
isc.Class.addMethods(isc._logMethods);
isc.Class.addClassMethods(isc._logMethods);



//>    @groupDef    debug
// Support for debugging and logging
//<

//>    @class    Log
// A logging system similar to the Java log4j package: messages are logged with a "category" and
// "priority", and developers can dynamically set which log messages are being displayed.
// <P>
// 5 log priorities are available, with the following general meaning:
// <ul>
// <li> "debug": diagnostic info which is only likely to be understood by a developer with
// source access, or would occur too frequently for normal usage
// <li> "info": reports of significant events in the normal operation of the subsystem
// <li> "warn": some kind of problem is likely to occur, an API appears is apparently being
// misused or will yield a partial or very slow result
// <li> "error": a definite error has occurred which may be recoverable
// <li> "fatal": total failure with no possibility of recovery
// </ul>
// <P>
// Log categories do not need to be declared in advance - you can simply make up a category name and
// start logging to it, and control whether that category's messages will be displayed via
// <code>setPriority()</code>.
// <P>
// <b>NOTE:</b> to open the Developer Console in any page that loads ISC, type
// javascript:isc.Log.show() in the URL bar - this URL is bookmarkable.
// <P>
// The Developer Console should <b>always</b> be open while developing any ISC-enabled application,
// because ISC logs many important errors and warnings to the Developer Console.
// <P>
// In Internet Explorer, the Developer Console is able to log a stack trace for every JS error,
// including errors that occur in non-ISC code.
// <P>
// NOTE: if you have the Microsoft JavaScript Debugger installed, ISC will be unable to log stack
// traces on JS errors until you go to Tools->Internet Options->Advanced Tab and check "Disable
// script debugging".  The ability to see stack traces in the Developer Console is generally much
// more useful for debugging ISC-based applications than the generic Javascript Debugging
// facilities.
//
// @treeLocation Client Reference/System
// @group debug
//
// @see Log.setPriority()
//
//  @visibility external
//<
isc.ClassFactory.defineClass("Log");

//> @groupDef debugging
// <h4>Built-in Diagnostics</h4>
// <P>
// The SmartClient Developer Console is a suite of development tools implemented in SmartClient itself.
// The Console runs in its own browser window, parallel to your running application, so it is always
// available in every browser, and in every deployment environment.
// <P>
// The Developer Console can be opened by calling <code>isc.showConsole()</code> on any page in which
// SmartClient has been loaded. You can create a bookmark in your browser to quickly show the Console on
// any SmartClient application, without any changes to the application code:
// <P>
// 1. Create a new bookmark in your browser.<BR>
// 2. Enter url "javascript:isc.showConsole()".<BR>
// 3. Label the bookmark as "Show Console".<BR>
// 4. Consider adding this to the Bookmarks Toolbar. This allows one-click access to the Console
// from any SmartClient application.
// <P>
// Note: For most browsers you can evaluate javascript directly from the browser URL bar by entering
// <code>javascript:<i>string to evaluate</i></code> directly in the URL bar, so setting up a bookmark
// is not strictly necessary. For Firefox 6 and above, this feature has been disallowed, but the bookmark
// approach will still work. Alternatively developers could use
// +externalLink{http://blog.mozilla.com/devtools/2011/08/15/introducing-scratchpad/,Firefox Scratchpad}
// to launch the console.
// <P>
// Basic information on the features of the Developer Console can be found in the QuickStart
// Guide.  For information about the "RPC" tab of the Developer Console and the request
// profiling information it can provide, see
// +link{groupDef:devConsoleRPCTab,the Developer Console RPC tab}.  The remainder of this
// topic focuses on use of the log system and related debugging facilities.
// <P>
// The Developer Console contains a "Results" pane that displays a list of diagnostic
// messages logged by the SmartClient framework. The "Logging Preferences" menu lets you
// enable and disable SmartClient's built-in diagnostics in several categories. Because
// important diagnostic messages may be logged at any time, you should have the Developer
// Console open whenever you are working with SmartClient (and you should bookmark the
// "javascript:" expression above to make this easier).
// <P>
// Log messages are of the format:
// <P>
// &nbsp;&nbsp;&nbsp;<i>timestamp</i>:<i>priority</i>:<i>category</i>:<i>message</i>
// <P>
// For example, the following log message:
// <pre>
//     11:59:25:806:INFO:Page:Page loading complete.</pre>
// Occurred at 11:59:25 local time and 806 milliseconds.  It's priority was <code>INFO</code>,
// it occurred in the category <i>Page</i>, and the message is "Page loading complete.".
// <P>
// Each logging <i>category</i> has a <i>priority</i> associated with it.  If a message's
// priority is lower than the current priority for the category it is logged in, the
// message will be suppressed (will not appear in the "Results" pane).
// <p>
// It is critical to be familiar with the diagnostic categories built-in to SmartClient -
// you will use them in most debugging sessions.  Open the Logging Preferences menu and select
// "More.." to see a list of diagnostic log categories.   Hover over each category name to
// see a description of what kind of messages are logged in the category.
// <P>
// <h4>Debugging JavaScript Errors</h4>
// <P>
// Javascript errors will typically be reported in the Developer Console. Wherever possible a stack
// trace will be included which can help determine the cause of the error.
// In addition to this, recent versions of the Firefox browser (versions 6.0 and above) ship with some
// useful development tools including the Error Console for reporting errors. We also recommend Console2
// and Firebug for debugging in Firefox.
// <P>
// In Internet Explorer, when JS errors occur, SmartClient is able to report full stack traces
// in the Developer Console.  This can be invaluable when your code triggers a JS error
// in the SmartClient libraries themselves, or when it is unclear how your code is being
// called.  Stack traces from Internet Explorer should <i>always</i> be included in issue
// reports sent to Isomorphic Software, if at all possible.
// <P>
// <h4>Inspecting application state</h4>
// <P>
// The "Evaluate JS Expression" area of the Results Pane in the Developer Console can be used
// to inspect the current state of a SmartClient application.  Any SmartClient or browser
// built-in API can be called from the "Evaluate JS Expression" area, and the results will
// be intelligently summarized (via +link{Log.echo()}).  For example, simply typing a
// component's ID and pressing the "Eval JS" button will give you a dump of it's current
// property values.
// <P>
// Many, many SmartClient APIs can be usefully called while troubleshooting, eg,
// +link{listGrid.data} is a +link{ResultSet} when a grid is DataBound and
// +link{resultSet.get()} can be called to inspect the current values on records.  In addition,
// new application code can be tried out, for example, you might repeatedly instantiate a new
// component, trying variants on the properties you could give it.
// <P>
// <b>Inspecting transient application state with logs</b>
// <P>
// Transient state, such as the values of local variables in a method that is crashing, can be
// sent to the Developer Console via using the +link{Log} class.  For example, to dump the
// value of the local variable "request":
// <pre>
//     isc.logWarn("request is: " + isc.echo(request));
// </pre>
// <P>
// It's a good idea to dump the values of local variables in any method that is crashing or
// behaving unexpectedly.
// <P>
// Note the use of +link{classMethod:isc.logWarn,logWarn()} above: in typical debugging sessions,
// it's best
// to simply use <code>logWarn</code> method to output diagnostics to ensure your message will
// not be suppressed by log priority settings.
// <P>
// NOTE: never use the native <code>alert()</code> method to output diagnostics.  Among other
// issues, <code>alert()</code> can affect timing, masking or altering the behavior you were
// trying to debug.  SmartClient's logging system doesn't suffer from these problems and
// provides much more control.
// <P>
// <h4>Issue Reports</h4>
// <P>
// If you believe you've discovered a bug in SmartClient or you are having trouble using
// SmartClient APIs, you can report it at +externalLink{http://forums.smartclient.com/}, or, if
// you have Enterprise Support, at the
// +externalLink{http://support.isomorphic.com/,Customer Support Extranet}.
// <P>
// <b>How quickly your issue is resolved is entirely up to you</b>.  If you follow the steps
// below and submit an appropriate issue report, you will generally receive a rapid solution
// from Isomorphic Support, regardless of what support level you have, because Isomorphic
// aggressively corrects bugs and legitimate usage issues.  If you skip steps you are likely to
// be directed back to this document and asked to submit a more complete issue report.
// <P>
// Before reporting an issue, ensure that you:
// <ul>
// <li> Have read the +docTreeLink{QuickStartGuide,QuickStart Guide} cover to
// cover.  Later chapters cover more advanced topics and provide links to further examples and
// reference.
// <li> Have searched the +docTreeLink{FeatureExplorer,Feature Explorer} for examples that show
// what you are trying to do
// <li> Have searched this reference, trying multiple searches using different, common and
// related terms for what you are trying to do (eg for search, try "search", "filter",
// "criteria", "find", "match", etc)
// <li> Have searched the public +externalLink{http://forums.smartclient.com,forums}
// </ul>
// Always include:
// <ul>
// <li> A description of what you are trying to accomplish <b>from a user's perspective</b>.
// The best answers often point out a simpler approach.
// <li> The browser(s), operating system(s) and SmartClient version(s) you experience the error
// on (SmartClient version is available in the lower-left handle corner of the Developer
// Console)
// </ul>
// Then, include <b>either</b> a standalone test case (see below), <b>or</b>:
// <ul>
// <li> For JS errors, Stack traces from Firebug (for Firefox) or the Developer Console (for
// IE), as covered under "Debugging JavaScript Errors" above
// <li> Results of calling <code>echo()</code> on local variables or other application
// state you think is relevant (see "Inspecting Application State" above)
// <li> What server platform and +link{group:clientServerIntegration,databinding approach} you
// are using, if applicable
// <li> contents of the SmartClient Developer Console "Log messages" area, with appropriate
// diagnostic categories set the DEBUG or INFO level (see "Built-in Diagnostics" above)
// <li> sample code and sample data
// </ul>
// <b>Preparing a standalone test case</b>
// <P>
// A standalone test case is one of:
// <ol>
// <li> a chunk of JavaScript code that can be executed from the "Eval JS" area of the
// Developer Console on some specified page within the unmodified SmartClient SDK,
// demonstrating your issue
// <li> an .html or .jsp file that can be dropped at a specified location into an unmodified
// SmartClient SDK and will run without changes, demonstrating your issue.
// <li> a .zip file that includes a standalone .html/.jsp file  as above, as well as
// dependencies required to make the test case runnable, such as XML datasets
// </ol>
// <P>
// Submitting a standalone test case removes any ambiguity as to whether there is a bug in
// SmartClient or a bug in your code, and eliminates the possibility of Isomorphic Support
// responding with a "works for me" result due to incomplete information.  Issues with verified
// test cases are routed directly to the engineer that authored the relevant SmartClient
// subsystem, often as the new highest priority task.  In addition, the process of preparing a
// test case very often allows you to solve the issue yourself.
// <P>
// There are two approaches to test case preparation:
// <ol>
// <li> Add code to an existing SmartClient example until you can reproduce the problem
// <li> Remove code from your application until it minimally shows the problem and runs standalone
// </ol>
// <P>
// For approach #1, find the nearest match to your use case in the
// +docTreeLink{FeatureExplorer} examples or in the other examples accessible from the Examples
// folder of the SDK, then try to minimally modify that example to demonstrate your issue.
// Feature Explorer examples are a particularly good starting point because you can simply copy
// the code from the Feature Explorer to the Eval JS area of the Developer Console and begin
// changing it, and if successful this yields a type #1 test case, the easiest for you to
// submit and most efficient for Isomorphic to work with.
// <P>
// For approach #2,
// <ol>
// <li> If a server is involved in initial page generation (eg a .jsp file), in most cases you
// can eliminate many server dependencies <b>and</b> create an easily modifiable starting point
// by using the browser's "View Source" feature to save a copy of the generated HTML output as
// an .html file in the same directory as the .jsp file that generated it.  Such a file will
// generally continue to function (all relative paths are still correct), and can be modified
// freely without the need to later revert changes to a .jsp.
// <li> Eliminate any code that isn't involved in the interaction.  Keep running the test case
// as you eliminate code to ensure you are still seeing the issue (you may solve it this way,
// or find key preconditions that you can report to Isomorphic)
// <li> For any issue that isn't cosmetic, revert to a default SmartClient skin
// <li> For any necessary RPC/DataSource interactions, spoof the interaction with one of these
// approaches:
// <ul>
// <li> switch any DataSources to one of the sample DataSources from the SDK (eg "supplyItem")
// if your issue can still be reproduced in this case.
// <li> create a small sample dataset in JavaScript directly in the .html file, and use a
// +link{dataSource.clientOnly,clientOnly DataSource} with that dataset.
// <li> capture server responses verbatim by setting the RPCManager log category to DEBUG, save
// the responses as flat files, and set +link{dataSource.dataURL} to point at them.
// <li> for RPCs, instead of calling the RPCManager, directly call your own callback function,
// passing a spoofed RPCResponse that includes just the fields your code depends upon
// </ul>
// <li> Finally, move your .html file into the stock SmartClient SDK along with any remaining
// dependencies and verify the problem can still be reproduced
// </ol>
// Having prepared the test case, combine it with the other required issue report information
// covered above, and submit it to the +externalLink{http://forums.smartclient.com/,forums},
// or, if you have Enterprise Support, at the
// +externalLink{http://support.isomorphic.com/,Customer Support Extranet}.
// <P>
// <h4>Adding your own diagnostic categories</h4>
// <P>
// Calling <code>logWarn()</code> is fine for a log statement you plan to delete at the end of
// the debugging session.  However, many log statements have lasting value if you could enable
// or disable them only when you need the relevant diagnostics, like SmartClient's built-in
// diagnostic categories.  To do this, pick a priority level less than <code>WARN</code>
// (<code>INFO</code> or <code>DEBUG</code>), and call the corresponding method on the Log
// class (<code>logInfo()</code> or <code>logDebug()</code>), passing the category name as a
// second parameter.  For example:
// <pre>
//   isc.Log.logInfo("first record is: " +
//                   isc.Log.echo(myGrid.data.get(0)),
//                  "myGridLoading");
// </pre>
// This message will no longer appear in the Results Pane by default, because its priority
// (<code>INFO</code>) is less than the default of <code>WARN</code>.  To see this message,
// open the Logging Preferences menu and pick "More..", then click the "Add" button, enter
// "myGridLoading" as the category name and set the priority to <code>INFO</code>.  The message
// will now appear next time it is logged.
// <P>
// Now you have a custom log category that you and other developers can use to debug your
// application, subsystem by subsystem.  These diagnostics will be available to you both in
// development and production environments.
// <P>
// As with SmartClient's built-in diagnostics, you may choose to log certain messages in your
// custom category at the <code>DEBUG</code> level and a lesser number of messages at the
// <code>INFO</code> level, to create different depths of diagnostic output.
// <P>
// <h4>Logging refinements</h4>
// <P>
// The core log methods (<code>logDebug()</code>, <code>logInfo()</code>,
// <code>logWarn()</code>) and the "echo" facilities (<code>echo()</code> and
// <code>echoAll()</code>) are available on every SmartClient component and Class.  Hence,
// in many cases, the special JavaScript value "this" will refer to an object that supports
// <code>logWarn()</code> et al.  For example:
// <pre>
//     Canvas.create({
//        ID:"canvasExample",
//        contents:"Hello World!",
//        click:"this.logWarn('the Canvas is: ' + this.echo(this))"
//     });
// </pre>
// The special value "this" is not always set to a SmartClient component, for example, in some
// kinds of callbacks (eg +link{ListGrid.fetchData(),fetchData()}).  When in doubt, use these
// methods via the Log class as <code>isc.Log.logWarn()</code>.
// <P>
// <b>Logging performance</b>
// <P>
// Because the log message is actually formed <i>before</i> the call to the log system, logs
// that are suppressed can still carry a performance penalty.  This is particularly true of
// logs that output a lot of data or occur frequently.  To avoid this penalty, you can check in
// advance whether a message will be suppressed using
// +link{classMethod:Class.logIsDebugEnabled(),isc.Log.logIsDebugEnabled()} and
// +link{classMethod:Class.logIsInfoEnabled(),isc.Log.logIsInfoEnabled()}.  For example:
// <pre>
//   if (isc.Log.logIsInfoEnabled("myGridLoading")) {
//      isc.Log.logInfo("first record is: " +
//                      isc.Log.echo(myGrid.data.get(0)),
//                      "myGridLoading");
//   }
// </pre>
// Generally, it is only important to do this for logs that will occur multiple times during a
// given user interaction (eg a mousedown or keypress) and/or that call <code>echo()</code> on
// objects with many properties.
//
// @title Debugging
// @treeLocation Concepts
// @visibility external
//<

//> @groupDef debugModules
// <!--<var class="smartclient">-->
// SmartClient comes with a debug / readable version of the SmartClient JS files that may
// be useful during development.
//
// <p>To use the debug modules, simply change each &lt;script&gt; tag's SRC to the URI of the
// debug version of the module. For example:
// <pre>&lt;script src="/isomorphic/system/modules/ISC_Core.js"&gt;&lt;/script&gt;</pre>
// should be changed to:
// <pre>&lt;script src="/isomorphic/system/modules<b>-debug</b>/ISC_Core.js"&gt;&lt;/script&gt;</pre>
//
// <p>Alternatively, the &lt;isomorphic:loadISC&gt; and &lt;isomorphic:loadModules&gt; tags
// support a <code>useDebugModules</code> attribute:
// <pre>&lt;isomorphic:loadISC skin="Enterprise" useDebugModules="true"/&gt;</pre>
// <!--</var>-->
// <!--<var class="smartgwt">-->
// Smart&nbsp;GWT LGPL, Pro, Power, and Enterprise come with debug / readable versions of the
// SmartClient JS files that may be useful during development.
//
// <p>To enable the use of debug modules, you will need to change the &lt;inherits&gt; lines
// in the application's GWT module file to reference the debug versions of the Smart&nbsp;GWT modules:
// <table border="1" cellpadding="5" cellspacing="0">
// <tbody>
// <tr><th>Edition</th><th>Original &lt;inherits&gt;</th><th>New &lt;inherits&gt;</th></tr>
// <tr>
// <th>LGPL</th>
// <td><code>&lt;inherits name="com.smartgwt.SmartGwt"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwt<b>.debug.</b>SmartGwt<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Pro</th>
// <td><code>&lt;inherits name="com.smartgwtpro.SmartGwtPro"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtpro<b>.debug.</b>SmartGwtPro<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Power</th>
// <td><code>&lt;inherits name="com.smartgwtpower.SmartGwtPower"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtpower<b>.debug.</b>SmartGwtPower<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Enterprise</th>
// <td><code>&lt;inherits name="com.smartgwtee.SmartGwtEE"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtee<b>.debug.</b>SmartGwtEE<b>Debug</b>"/&gt;</code></td>
// </tr>
// </tbody>
// </table>
//
// <p>The convention is that the names of debug GWT modules end with "Debug".
//
// <p>If using the NoScript modules, you will need to change the &lt;inherits&gt; lines
// <table border="1" cellpadding="5" cellspacing="0">
// <tbody>
// <tr><th>Edition</th><th>Original &lt;inherits&gt;</th><th>New &lt;inherits&gt;</th></tr>
// <tr>
// <th>LGPL</th>
// <td><code>&lt;inherits name="com.smartgwt.SmartGwtNoScript"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwt<b>.debug.</b>SmartGwtNoScript<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Pro</th>
// <td><code>&lt;inherits name="com.smartgwtpro.SmartGwtProNoScript"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtpro<b>.debug.</b>SmartGwtProNoScript<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Power</th>
// <td><code>&lt;inherits name="com.smartgwtpower.SmartGwtPowerNoScript"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtpower<b>.debug.</b>SmartGwtPowerNoScript<b>Debug</b>"/&gt;</code></td>
// </tr>
// <tr>
// <th>Enterprise</th>
// <td><code>&lt;inherits name="com.smartgwtee.SmartGwtEENoScript"/&gt;</code></td>
// <td><code>&lt;inherits name="com.smartgwtee<b>.debug.</b>SmartGwtEENoScript<b>Debug</b>"/&gt;</code></td>
// </tr>
// </tbody>
// </table>
// and change the &lt;script&gt; tags in the application's HTML file to the debug modules
// instead of the normal SmartClient modules. For example:
// <pre>&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Core.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Foundation.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Containers.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Grids.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Forms.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_RichTextEditor.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Calendar.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_DataBinding.js"&gt;&lt;/script&gt;
//&lt;script src="myapp/sc/modules<b>-debug</b>/ISC_Drawing.js"&gt;&lt;/script&gt;</pre>
//
// <p>Alternatively, the &lt;isomorphic:loadISC&gt; and &lt;isomorphic:loadModules&gt; tags
// support a <code>useDebugModules</code> attribute:
// <pre>&lt;isomorphic:loadISC skin="Enterprise" useDebugModules="true"/&gt;</pre>
// <!--</var>-->
//
// @title Using the Debug Modules
// @treeLocation Concepts
// @visibility external
//<


//> @groupDef devConsoleRPCTab
// The "RPC" tab of the SmartClient Developer Console allows you to track
// +link{class:RPCRequest}s and +link{class:DSRequest}s sent from your application.  Tracking
// is activated by checking the "Track RPCs" box at the top of the tab.
// <p>
// The main "RPC History" list shows the transactions that have been sent from your application
// since the session began (since you checked the "Track RPCs" box or refreshed your browser,
// whichever happened most recently).  Each entry in the list represents either a server
// roundtrip, a DSRequest to a clientOnly DataSource or a direct request to a webservice.
// +link{RPCManager.startQueue,Request queues} are shown as separate entries, with the requests
// that made up the queue shown indented beneath it.
// <p>
// Each entry in the RPC History list shows useful diagnostic information, including:
// <ul>
// <li>Whether the request was sent via a server-side proxy</li>
// <li>The URL of the request, or an indication that the request was client-only</li>
// <li>The type of request - +link{class:DSRequest}, +link{class:RPCRequest},
//    +link{class:WSRequest} or +link{RPCManager.startQueue,Queue}</li>
// <li>The DataSource name, operation type and operation ID</li>
// <li>The success/failure status of the request, if it has completed</li>
// <li>Basic timing information</li>
// </ul>
// In addition, clicking an entry in the RPC History list populates the "Request" and "Response"
// sections with the details of the request.
// <p>
// <h2>Detailed timing/profiling information</h2>
// <P>
// SmartClient and SmartClient Server can gather detailed profiling information for a
// request/response roundtrip, and display it in the Developer Console.  Note, the server-side
// information is only available for DSRequests, and only if you are using the SmartClient
// Server module.  Extra levels of server-side detail are available if you are also using one
// of SmartClient Server's built-in DataSource types (note, at the time of writing this only
// applies to SQLDataSource).  To enable detailed timings:
// <ul>
// <li>Set debug log category "RpcTabTiming" to INFO level in "Logging Preferences" (see
//     +link{group:debugging} for details)</li>
// <li>If you want to collect details of the server-side processing, either:
//     <ul>
//     <li>Set <code>DSRequest.returnTimingData: true</code> in your +link{server_properties,server.properties}
//         file.  This will cause server timing information to be gathered and returned for
//         every DSRequest from every client</li>
//     <li>Enable the built-in RPCs "areServerTimingsTracked" and "trackServerTimings" via the
//         <code>RPCManager.enabledBuiltinMethods</code> setting of your
//          +link{server_properties,server.properties}
//         file (these builtin RPCs should already be enabled in a development environment).
//         When these built-in RPCs are enabled, server timing data can be switched on and
//         off on a per-client basis, via a checkbox in the Developer Console.</li>
//     </ul>
// </li>
// </ul>
// With these settings in place, an extra "Timing" tab appears in the "Request" section:
// <p>
// <img src="skin/detailedTiming1.png" width="1059px" height="275px">
// <p>
// The timing data is tree-structured; a node with an opener next to it can be expanded to
// drill into more detail:
// <p>
// <img src="skin/detailedTiming2.png" width="1059px" height="701px">
// <p>
// The following important points apply to the detailed timing information:
// <ul>
// <li>It is meaningless to compare the actual start and end timestamps reported by the client
//     with those reported by the server, because their clocks are unlikely to be exactly
//     synchronized (unless the client and the server are the same physical machine).  The
//     timestamps are the underlying raw data - it is much more meaningful to consider the
//     elapsed times than the timestamps</li>
// <li>The basic timing details reported in the main RPC History list do not correspond to the
//     detailed timing data because the detailed timing data attempts to cover the entire
//     period of the transaction, from the UI event to calling the user callback method.  By
//     contrast, the basic timing data only covers the period from when the request left the
//     client to when the response was received by the client.  The basic timing "Time Sent"
//     and "Elapsed time" figures correspond to the "Server roundtrip" entry in the detailed
//     timing data</li>
// <li>The "Network time (inferred)" measurements are informed guesswork.  We calculate the
//     difference between the "Server turnaround" time measured by the client and the "Server
//     processing" time measured by the server, and apply half of that difference to either side
//     of the "Server processing" figure as "Network time (inferred)".  Note that this guesswork
//     can easily mean that network timings overlap with server processing timings, even when the
//     client and the server are the same machine</li>
// <li>The "UI event to DSRequest creation" timing measures the time from the most recent event
//     to be registered by the EventHandler subsystem, to that of DSRequest creation (and
//     hence, incidentally, is not recorded for RPCRequests).  This is often a meaningful thing
//     to measure, but not always.  If the DSRequest was created programatically during application
//     startup or off the back of a timer, then the most recent UI event clearly had no influence
//     and so measuring the time since it happened has no meaning.  However, most DSRequests
//     <em>are</em> created, directly or indirectly, as a result of a UI event; so even though we
//     can't tell which DSRequests belong to events and which don't, we still provide the figure
//     in the timing data as something that will be "often useful"</li>
// </ul>
//
// @title The Developer Console RPC Tab
// @treeLocation Concepts
// @visibility external
//<


isc.Log.addClassProperties({
    //> @type    LogPriority
    // Priority levels for log messages
    // @value  Log.FATAL   unrecoverable error
    FATAL : 1,
    // @value  Log.ERROR   error, may be recoverable
    ERROR : 2,
    // @value  Log.WARN    apparent problem, misused API, partial result
    WARN : 3,
    // @value  Log.INFO    significant events in normal operation
    INFO : 4,
    // @value  Log.DEBUG   diagnostics for developers
    DEBUG : 5,
    // @see Class.logDebug()
    //            @visibility external
    //<

    //>    @classAttr    Log.PRIORITY_NAMES        (string[] : [...] : IRWA)
    //        User-visible names for log priorities
    //        Note: NONE should never show up...
    //<
    PRIORITY_NAMES :["NONE" ,"FATAL", "ERROR", "WARN", "INFO", "DEBUG"]
});


// Hide the Log class setup when we're not debugging
//    this lets us just include the logger, but makes it all a no-op.
//    Note that the creation of Log and the setting of the LogPriority must always be present.


isc.Log.addClassProperties({

    //>    @classAttr    isc.Log.defaultPriority        (LogPriority : isc.Log.WARN : IRWA)
    // Any logs below this priority will be suppressed, unless a more specific setting exists for
    // the category.
    // @see Log.setPriority()
    // @visibility external
    //<
    defaultPriority:isc.Log.WARN,

    //>    @classAttr    isc.Log.stackTracePriority (LogPriority : isc.Log.ERROR : IRWA)
    // At this priority and above, a stack trace will be included automatically along with the log
    // message itself.
    // @visibility external
    //<
    stackTracePriority:isc.Log.ERROR,

    // priorities setting per category
    _logPriorities: {},
    // specific priorities for classes / instances
    _objectLogPriorities: {},

    // number of messages to keep
    _messageCount:1000,


    // index of the slot for the next message in messageCache
    _messageIndex:0,

    // array for keeping log messages
    _messageCache:[],

    _semiColon : ":",
    _dot : ".",
    _allCategories : "_allCategories",
    _default : "_default"
});

isc.Log.addClassMethods({

    // Log Priorities
    // --------------------------------------------------------------------------------------------

    //> @classMethod Log.applyLogPriorities()
    // Apply a batch a batch of priority settings, as a object mapping category names to priority
    // levels.
    //
    // @param settings (Object) priority settings for multiple categories
    // @visibility external
    //<
    applyLogPriorities : function (newDefaults) {
        // make a blank priority defaults object if necessary
        if (!this._logPriorities) {
            this._logPriorities = {};
        }

        // if new defaults were specified, overlay them on the current set
        if (newDefaults) {
            isc.addProperties(this._logPriorities, newDefaults);
        }
    },

    //> @classMethod Log.getLogPriorities()
    // Get all priority settings as an object mapping category names to priority levels.
    //
    // @param [object] (Class or Instance object) Optional param to get priorities specific to
    //                                            some ISC class or instance.
    // @param [overridesOnly] (boolean) If this method is retrieving the priorities specific
    //                                  to logging for some class or instance, this parameter
    //                                  can be used to view only the overrides to the default
    //                                  log priorities on this object.
    // @return (Object) priority settings
    // @visibility external
    //<
    getLogPriorities : function (object, overridesOnly) {
        var overrides;
        if (object != null) {
            var objectID = this._getObjectID(object);

            overrides = this._objectLogPriorities[objectID];
            if (overridesOnly) {
                return isc.addProperties({}, overrides);
            }
        }

        // copy to avoid unintentional changes
        var priorities = isc.addProperties({}, this._logPriorities);
        if (overrides) priorities = isc.addProperties(priorities, overrides);

        return priorities;
    },


    _getObjectID : function (object) {
        var ID;
        if (object == null) ID = isc.emptyString;
        else ID = (object.getID ? object.getID() : object.getClassName());
        return ID;
    },

    //> @classMethod Log.getPriority()
    // Return the priority setting for a particular category.
    // <P>
    // If there is no priority setting specific to this category, <code>null</code> will be
    // returned, NOT <code>Log.defaultPriority</code>.
    //
    // @param   category   (String)            category name
    // @param [object] (Class or Instance object)   Optional class or instance to check for
    //                                              specific log priority overrides
    // @return  (LogPriority)     priority setting
    // @visibility external
    //<
    // return the priority for a particular category
    getPriority : function (category, object) {

        if (object != null) {
            var objectID = this._getObjectID(object),
                overrides = this._objectLogPriorities[objectID];
            if (overrides) {
                if (overrides._allCategories != null) return overrides._allCategories;
                if (overrides[category] != null) return overrides[category];
                if (overrides._default != null) return overrides._default;
            }
        }

        // Still going - look at global settings
        var priorities = this._logPriorities;
        return priorities[category] || priorities._default;
    },

    //> @classMethod Log.setPriority()
    // Set the priority of messages that will be visible for this log category.
    // <P>
    // After calling setPriority, any messages logged to the given category whose priority is
    // below the specified priority will not appear in the Log.
    //
    // @param category   (String)            category name
    // @param priority   (LogPriority)  priority level to set
    // @param [object]   (Class or Instance object)
    //      Optional ISC class or instance - if passed the priority will be set for logging
    //      occurring on the class or instance only.
    // @see Log.isEnabledFor() to check whether a category would allow a log at a given priority
    // @visibility external
    //<
    setPriority : function (category, priority, object) {
        if (object != null) {
            var objectID = this._getObjectID(object);
            if (this._objectLogPriorities[objectID] == null)
                this._objectLogPriorities[objectID] = {};
            // If we're not passed a category, ensure we show all logs on the object in question
            // at the appropriate priority.
            if (!category) category = this._allCategories;
            this._objectLogPriorities[objectID][category] = priority;
        } else {

            this._logPriorities[category] = priority;
        }
    },

    //> @classMethod Log.setDefaultPriority()
    // Set the default priority of messages that will be visible.
    //
    // @param priority   (LogPriority)  priority level to set
    // @param [object]   (Class or Instance object)
    //      Optional ISC class or instance - if passed the default priority will be set for logging
    //      occurring on the class or instance only.
    // @visibility external
    //<
    setDefaultPriority : function (priority, object) {
        if (!object || object == isc.Log) isc.Log.defaultPriority = priority;
        else isc.Log.setPriority("_default", priority, object);
    },

    //> @classMethod Log.getDefaultPriority()
    // Retrieves the default priority of messages that will be visible.
    //
    // @param [object]   (Class or Instance object)
    //      Optional ISC class or instance - if passed the returns the default priority for
    //     the class or instance only.
    // @return (LogPriority) default priority for which messages will be logged.
    // @visibility external
    //<
    getDefaultPriority : function (object) {
        var defaultPriority;
        if (object && object != isc.Log) defaultPriority = this.getPriority("_default", object);
        return defaultPriority || isc.Log.defaultPriority;
    },

    //> @classMethod Log.clearPriority()
    // Clear the priority setting for a particular category, so that the category's effective
    // priority returns to <code>Log.defaultPriority</code><br>
    // If the optional second parameter is passed, the specific priority setting for the
    // category on that object will be cleared, so logs in that category on that object will
    // be logged at the global priority level for the category.
    //
    // @param category   (String)            category name
    // @param [object] (Class or Instance object) Optional instance or class object - if passed
    //                                        clear logging priority for the appropriate category
    //                                        on that object.
    // @visibility external
    //<
    clearPriority : function (category, object) {
        if (object) {
            var objectID = this._getObjectID(object);

            // If we were passed no category, clear all explicit log priorities on the object
            // in question.
            if (!category)
                delete this._objectLogPriorities[objectID];
            else if (this._objectLogPriorities[objectID])
                delete this._objectLogPriorities[objectID][category];

        } else {
            delete this._logPriorities[category];
        }
    },

    //> @classMethod Log.isEnabledFor()
    // Would a message logged to the given category at the given priority appear in the Log?
    // <P>
    // NOTE: if there is no specific priority setting for a given category, the
    // <code>Log.defaultPriority</code> is used.
    //
    // @param category   (String)            category name
    // @param priority   (LogPriority)  priority level to check
    //
    // @visibility external
    //<
    // NOTE: hierarchical categories are not documented; not clear whether we want to expose this
    // feature
    isEnabledFor : function (category, priority, object) {
        if (!category) category = isc._emptyString;
        while (category != isc._emptyString) {

            // get the priority for the category
            var categoryPriority = this.getPriority(category, object);
            // if it was found and its priority is set
            if (categoryPriority != null) {
                // return if the message is at the appropriate priority
                return priority <= categoryPriority;
            }

            // if the category contains a period, chop it down and try again
            var periodIndex = category.lastIndexOf(this._dot);
            if (periodIndex > 0) {
                // chop off the last category
                category = category.substring(0, periodIndex);
            } else {
                // jump out of the loop
                break;
            }
        }

        // category not found or was null -- return according to the default logging priority
        return priority <= isc.Log.defaultPriority;
    },

    // Formatting and Displaying Log messages
    // --------------------------------------------------------------------------------------------

    // log a message at an arbitrary priority (for wrappers)
    log : function (priority, message, category, msgPrefix, object, timestamp) {
        if (this.isEnabledFor(category, priority, object))
            this.addLogMessage(priority, message, category, msgPrefix, timestamp);
        else if (this.reportSuppressedLogs) {
            // Useful for detecting unnecessary logs, especially unnecessary logs during
            // critical path code
            this.logWarn("suppressed log, category: " + category + ": " + message
                // + this.getStackTrace()
            );
        }
    },

    // get a timestamp suitable for our short-lived log: millisecond precision, no need to show
    // date

    _1zero : "0",
    _2zero : "00",
    getLogTimestamp : function (date) {
        var tsArray = this._tsArray;
        if (tsArray == null) {
            tsArray = this._tsArray = [];
            tsArray[2] = this._semiColon;
            tsArray[5] = this._semiColon;
            tsArray[8] = this._dot;
        }

        if (date == null) date = new Date();
        var hours = date.getHours(),
            minutes = date.getMinutes(),
            seconds = date.getSeconds(),
            ms = date.getMilliseconds();

        tsArray[1] = hours;
        if (hours < 10) tsArray[0] = this._1zero;
        else tsArray[0] = null;

        tsArray[4] = minutes;
        if (minutes < 10) tsArray[3] = this._1zero;
        else tsArray[3] = null;

        tsArray[7] = seconds;
        if (seconds < 10) tsArray[6] = this._1zero;
        else tsArray[6] = null;

        tsArray[10] = ms;
        if (ms < 10) tsArray[9] = this._2zero;
        else if (ms < 100) tsArray[9] = this._1zero;
        else tsArray[9] = null;

        return tsArray.join(isc._emptyString);
    },


    // return the name shown to the user for a particular log priority
    getPriorityName : function (priority) {
        if (priority == null) return isc._emptyString;
        return this.PRIORITY_NAMES[priority];
    },

    // routine to format the log message and officially "log" it
    // override to set your own outputter
    _makeLogMessage : function (priority, message, category, msgPrefix, timestamp) {
        var msg = this._msgArray;
        if (msg == null) {
            msg = this._msgArray = [];
        }

        if (!category) category = this.category;

        msg[0] = this.getLogTimestamp(timestamp);
        msg[1] = this._semiColon;

        // Add the "thread" if available, eg, what the native source of the JS thread
        // is, such as mouse events, timers, etc
        if (this.ns.EH && this.ns.EH._thread != null) {
            msg[2] = this.ns.EH._thread;
            msg[3] = this._semiColon;
        }

        if (priority != null) {
            msg[4] = this.getPriorityName(priority);
            msg[5] = this._semiColon;
        }

        msg[6] = category;
        msg[7] = this._semiColon;
        // allow a prefix to the message to be passed in, so we can do the concat
        if (msgPrefix) {
            msg[8] = msgPrefix
            msg[9] = this._semiColon;
        }
        msg[10] = message;

        var result = msg.join(isc._emptyString);

        // clear out the array used to construct the message
        msg.length = 0;

        return result;
    },

    addLogMessage : function (priority, message, category, msgPrefix, timestamp) {


        var logMessage = this._makeLogMessage(priority, message, category, msgPrefix, timestamp);
        this.addToMasterLog(logMessage);

        if (this.warningLogged != null && priority != null && priority <= this.WARN) {
            this.warningLogged(logMessage);
        }

        // show alerts in addition for error and fatal level log messages
        if (priority != null && priority <= this.ERROR) {
            if (!isc.Browser.seleniumPresent) alert(message);
        }
    },

    // add a message to the master log
    // anyone who wants to know when messages are added should observe this method!
    addToMasterLog : function (message) {
//!DONTOBFUSCATE
// NOTE: we're not obfuscating so the "message" parameter will retain that name later

        // remember the message passed in
        this._messageCache[this._messageIndex] = message;

        // set up for the next message
        this._messageIndex++;

        // if we're beyond the appropriate number of messages to remember
        if (this._messageIndex > this._messageCount) {
            // roll over the messsageIndex to 0
            this._messageIndex = 0;
        }
        if (this.showInlineLogs) {
            this.updateInlineLogResults();
        }
    },

    showInlineLogs:false,
    updateInlineLogResults : function () {
        if (isc.Canvas == null || this._messageCache == null) return;
        if (!this.inlineLogCanvas) {
            this.inlineLogCanvas = isc.Canvas.create({
                    width:"50%", height:"100%", overflow:"auto",
                    backgroundColor:"white",
                    canDragReposition:true,
                    autoDraw:true
            });
        }
        this.inlineLogCanvas.setContents(this._messageCache.join("<br>"));
        this.inlineLogCanvas.bringToFront();
    },

    // return the array of messages stored in the master log
    getMessages : function () {
        var cache = this._messageCache,
            index = this._messageIndex,
            count = this._messageCount
        ;
        return cache.slice(count-index,count).concat(cache.slice(0, index));
    },

    //> @classMethod Log.show()
    // Open the Developer Console.
    // <P>
    // The Developer Console should <b>always</b> be open while developing any ISC-enabled
    // application, because ISC logs many important errors and warnings to the Developer Console.
    // <P>
    // In Internet Explorer, the Developer Console is able to log a stack trace for every JS error,
    // including errors that occur in non-ISC code.
    // <P>
    // NOTE: if you have the Microsoft JavaScript Debugger installed, ISC will be unable to log
    // stack traces on JS errors until you go to Tools->Internet Options->Advanced Tab and check
    // "Disable script debugging".  The ability to see stack traces in the Developer Console is
    // generally much more useful for debugging ISC-based applications than the generic Javascript
    // Debugging facilities.
    //
    // @group debug
    // @visibility external
    //<
    show : function (loading, logWindow, dontSaveState, windowName, inline) {
        if (!this.logViewer) this.logViewer = isc.LogViewer.create();
        this.logViewer.showLog(loading, logWindow, dontSaveState, windowName, inline);
    },

    //> @classMethod Log.clear()
    // Clear all currently displayed Log messages
    // @visibility external
    //<
    clear : function () {

        this._messageCache = [];
        this._messageIndex = 0;
        if (this.logViewer) this.logViewer.clear();
    },

    // evaluate an expression and log the results
    evaluate : function (expr, evalVars) {
        // execute the expression - and always report execution time
        var start = isc.timeStamp();

        var error,
            result
        ;
        // NOTE: "this" is the Log so that this.logWarn, this.echo et al will work
        if (isc.Log.supportsOnError) {
            // in IE, if there's an error, we report it via window.onerror
            result = isc.Class.evalWithVars(expr, evalVars, this);
        } else {
            // NOTE: try {} catch is not supported in Safari11, Nav4, or IE4
            try {
                result = isc.Class.evalWithVars(expr, evalVars, this);
            } catch (e) {
                error = e;
            }
        }
        var end = isc.timeStamp(),
            // show a timestamp for the log message itself if enabled
            resultString = isc.Log.getLogTimestamp() + ":";

        // don't show the entire expression
        var lines = expr.split(/[\r\n]+/);
        if (lines.length > 1) expr = lines[0] + "...";
        if (expr.length > 200) expr = expr.substring(0,200) + "...";
        if (error) {
            if (!isc.Log.supportsOnError) {
                isc.Log._reportJSError(error);
                return;
            }

            // In IE the error is an object - get the description property.
            // Unused since we let errors fall through in IE
            //if (isc.Browser.isIE) error = error.description;

            resultString += "Evaluator: '" + expr + "' returned a script error: \r\n"
                         + "'" + error + "'";
        } else {
            resultString = "Evaluator: result of '" + expr + "' (" + (end-start) +
                "ms):\r\n" + this.echo(result);
        }
        // Use addToLog instead of addToMasterLog()
        // - we don't care about losing this on log window reload
        if (this.logViewer) this.logViewer.addToLog(resultString, true);
    },

    // update the form in the log viewer
    updateStats : function (stat) {
        if (this.logViewer) this.logViewer.updateStats(stat);
    },

    // allow storing log messages before Log class has loaded (advanced internal usage)
    _logPrelogs : function () {
        var preLogs = isc._preLog;
        if (!preLogs) return;
        for (var i = 0; i < preLogs.length; i++) {
            var log = preLogs[i];
            if (isc.isA.String(log)) this.logDebug(log);
            else this.logMessage(log.priority || isc.Log.INFO,
                                 log.message, log.category, log.timestamp);
        }
        isc._preLog = null;
    },

    // Tracing and timing
    // --------------------------------------------------------------------------------------------

    //>    @classMethod        Log.traceMethod()
    //
    //  Observe a method on an object, logging a stack trace whenever the method is called.
    //  <P>
    //  Call a second time with identical arguments to disable tracing.
    //
    //    @param    object        (object)    object to observe
    //    @param    methodName    (string)    name of the method to observe
    //
    //    @group    debug
    //    @visibility external
    //<
    traceMethod : function (obj, methodName, callOnly) {
        // Bail if the arguments aren't valid
        var object = this.validObservation(obj, methodName);
        if (!object) return;

        // Keep a list of what objects / methods we're logging traces for
        //      Note: format is {objName:[methodName1, methodName2]}

        if (!this._traceRegistry) this._traceRegistry = {};
        if (!this._traceRegistry[obj]) this._traceRegistry[obj] = []; // array of method names

        // observation can only be done by instances, so create an arbitrary instance to
        // observe with
        if (!this._observer) this._observer = isc.Class.create();
        var observer = this._observer;

        // If this object is already being traced, stop observation
        if (observer.isObserving(object, methodName) &&
            this._traceRegistry[obj].contains(methodName))
        {
            observer.ignore(object, methodName);
            this.logWarn("MethodTimer: Stopped logging stack traces for " + methodName +
                         " method on " + obj);
            // remove it from the registry
            this._traceRegistry[obj].remove(methodName);

        } else {
            var objName = object.ID ? object.ID : (object.Class ? object.Class : object),
                expression = "isc.Log.logWarn('" + objName + "." + methodName + "() - trace:' +";
            if (callOnly) {
                expression += "'\\n' + isc.Log.getCallTrace(arguments))";
            } else {
                expression += "isc.Log.getStackTrace())";
            }
            this.logWarn("expression is: " + expression);
            observer.observe(object, methodName, expression);
            this.logWarn("MethodTimer: Logging traces whenever " + methodName +
                         " method on " + obj + " is called");
            // add it to the registry
            this._traceRegistry[obj].add(methodName);
        }

    },

    traceCall : function (obj, methodName) {
        this.traceMethod(obj, methodName, true);
    },

    //>    @classMethod        Log.timeMethod()
    //
    //  Observe a method on an object, logging execution time whenever the method is called.
    //  <P>
    //  Call a second time with identical arguments to disable tracing.
    //
    //    @param    object        (object)    object to observe
    //    @param    methodName    (string)    name of the method to observe
    //
    //    @group    debug
    //    @visibility external
    //<
    // storeTotals: execution times of methods and totals for that method will be store in a
    //              central structure Log.classMethodTimes, like:
    //            {
    //                className: { // also "All"
    //                   totalTime:0, calls:0, minTime:0, maxTime:0, avgTime:0
    //                }
    //            }
    // dontLog: means that individual executions will not be logged (typically used with
    //          storeTotals:true when timing methods where logging itself would be significant)
    //
    // Typical use cases:
    // 1. profile a mixture of operations (eg lots of components drawing) to get a breakdown of
    //    time spent in particular methods
    //
    //    isc.Log.timeMethod(someClass, someMethod, true, true); // several times
    //    isc.Log.resetTotals();
    //    ... run test code ...
    //    isc.logWarn(isc.echoFull(isc.Log.classMethodTimes));
    //
    // 2. time a specific codepath to see the time breakdown (high resolution timer only)
    //
    //    isc.Log.timeMethod(someClass, someMethod, true, false); // several times
    //    isc.Log.deferTimerLogs = true;
    //    ... run test code ...
    //    isc.Log.logDeferred(); // alll deferred logs are dumped
    //
    _methodPrefix:"$T_",
    timeMethod : function (obj, methodName, storeTotals, dontLog, causeGC) {

        // Bail if the arguments aren't valid
        var object = this.validObservation(obj, methodName);
        if (!object) return;

        // Keep a list of what objects / methods we're timing
        //      Note: format is {objName:[methodName1, methodName2]}
        if (!this._timeRegistry) this._timeRegistry = {};
        if (!this._timeRegistry[obj]) this._timeRegistry[obj] = []; // array of method names

        // already timing the method
        if (this._timeRegistry[obj].contains(methodName)) return;

        // Note - to time the method, we rename it, and replace it with a timer method (which will
        // return the same value
        var saveMethodName = isc.Log._methodPrefix + methodName,
            observedMethod = isc._obsPrefix + methodName, // Observation saves original method as _$method
            oldMethodName = (object[observedMethod] ? observedMethod : methodName)
        ;

        // If we're not timing the method:
        // If the method isn't being observed, we save the original method on the object as
        // (prefix + method) and replace it with a method that times and calls (prefix + method)
        //
        // If the method IS being observed, we do the same thing, except instead of saving and
        // replacing the current method, we save and replace (isc._obsPrefix + method), which is where the
        // original method's saved for observation.
        //
        // This way, we time only the original method, not the original method + its observer queue.
        //
        // This works even if we subsequently observe the method, because the method saved by the
        // observation mechanism (isc._obsPrefix + method) is left untouched if it already exists.

        object[saveMethodName] = object[oldMethodName];
        object[oldMethodName] = isc.Log.makeTimerFunction(
            methodName, object, storeTotals, dontLog, causeGC
        );
        this.logWarn("MethodTimer: Timing " + methodName + " method on " + obj);
        this._timeRegistry[obj].add(methodName);

    },

    stopTimingMethod : function (obj, methodName) {
        // Bail if the arguments aren't valid
        var object = this.validObservation(obj, methodName);
        if (!object) return;

        // If we're already timing the method, stop timing it.
        if (this._timeRegistry[obj].contains(methodName)) {
            var saveMethodName = isc.Log._methodPrefix + methodName,
                // Observation saves original method as _$method
                observedMethod = isc._obsPrefix + methodName,
                oldMethodName = (object[observedMethod] ? observedMethod : methodName)

            if (!object[saveMethodName]) {
                // This should never happen but we'll just clean up by deleting the registry entry
                this.logWarn("Not timing method '" + methodName + "' on object '"+ obj +"'.");
                this._timeRegistry[obj].remove(methodName);
                return;
            }

            // Stop timing the method:
            object[oldMethodName] = object[saveMethodName];
            delete object[saveMethodName];
            this.logWarn("MethodTimer: " + methodName + " method on " + obj +
                         " is no longer being timed");
            this._timeRegistry[obj].remove(methodName);
            return;
        }
    },

    // generate a function that calls the original message and logs timing data
    _currentlyTiming:{},
    makeTimerFunction : function (methodName, object, storeTotals, dontLog, causeGC) {

        var method = object[methodName],
            fullMethodName = isc.Func.getName(method, true);




        var timerFunc = function (a,b,c,d,e,f,g,h,i,j,k) {
            // you can use this to take the GC-based variability out of a method being timed
            if (causeGC) isc.Log._causeGC();
            var start = isc.timeStamp();


            var returnValue = method.call(this, a,b,c,d,e,f,g,h,i,j,k);
            var total = (isc.timeStamp()-start);



            if (!dontLog) isc.Log._logTimerResult(this, fullMethodName, total);
            return returnValue;
        }
        timerFunc._fullName = (object.ID || object.Class || "") + "_" + methodName + "Timing";
        timerFunc._isTimer = true;
        timerFunc._origMethodSlot = isc.Log._methodPrefix + methodName;
        return timerFunc;
    },

    // logTimerResult: log the result of timing a method
    _timerMessage : [
        "Timed ",
        , // methodName
        ": ",
        , // time
        "ms"
    ],
    _logTimerResult : function (object, methodName, callTime) {
        if (this.deferTimerLogs) return this._deferTimerLog(object, methodName, callTime);
        var template = isc.Log._timerMessage;

        // if "logWarn" exists, use it so the object identifies itself, otherwise,
        // toString() the object as part of the log message
        template[1] = (object.logWarn ? methodName :
                                        methodName + " on " + this.echoLeaf(object));
        template[3] = callTime.toFixed(3);

        var message = template.join(isc.emptyString);
        if (object.logMessage) object.logWarn(message);
        else isc.Log.logWarn(message);
    },





    // check whether method "method" on "obj" can be observed.  "obj" can be a string expression
    // that evaluates to an object
    validObservation : function (obj, method) {
        // Check that both fields are defined
        if (isc.isAn.emptyString(obj) || isc.isAn.emptyString(method)) return false;

        var object = obj;
        if (isc.isA.String(obj)) {
            // assume an expression (including a simple global ID)
            object = isc.Class.evaluate(obj);
            if (!object) {
                this.logWarn("MethodTimer: " + obj + " is not an object.");
                return false;
            }
        }

        // If the method was specifed with parentheses, remove them:
        if (method.indexOf("(") != -1) {
            method = method.slice(0, method.indexOf("("));
        }

        // If the object is a class, then we check whether there's a static method or an instance
        // method with the given name on the class.
        if (isc.isA.ClassObject(object)) {
            var theProto = object.getPrototype();
            // look for an instance method first and return the instance prototype if an
            // instance method was found
            if (isc.isA.Function(theProto[method])) return theProto;

            if (!object[method]) {
                this.logWarn("MethodTimer: " + method +
                             " could not be found as a static or instance property on " + obj);
                return false;
            }
        // not a class object, check that the method exists on it.
        } else if (!object[method]) {
            this.logWarn("MethodTimer: " + method + " is undefined or null on " + obj);
            return false;
        }

        // Check that the method is in fact a function, and not some other type of object
        if (!isc.Func.convertToMethod(object, method)) {
            this.logWarn("MethodTimer: " + method + " is not a method on " + obj);
            return false;
        }

        // Passed all the checks, return the object
        return object;
    },

    // Hiliting a Canvas
    // --------------------------------------------------------------------------------------------
    hiliteCanvas : function (name) {
        var canvas = name;
        if (isc.isA.String(name)) canvas = window[name];

        if (!isc.isA.Canvas(canvas)) {
            //>DEBUG
            this.logWarn("Unable to find specified canvas '" + name + "'."); //<DEBUG
            return;
        }

        this.showHiliteCanvas(canvas.getPageRect());
    },

    hiliteElement : function (name) {
        var element = name || this.elementToHilite;
        if (isc.isA.String(name)) element = isc.Element.get(name);
        if (element == null) {
            //>DEBUG
            this.logWarn("Unable to find specified element '" + name + "'."); //<DEBUG
            return;
        }

        this.showHiliteCanvas(isc.Element.getElementRect(element));
        this.elementToHilite = null;
    },

    showHiliteCanvas : function (rect) {

        // flash an outline around the canvas
        var hiliteCanvas = this._hiliteCanvas;
        if (!hiliteCanvas) {
            hiliteCanvas = this._hiliteCanvas = isc.Canvas.create({
                ID:"logHiliteCanvas",
                autoDraw:false,
                overflow:"hidden",
                hide : function () {
                    this.Super("hide", arguments);
                    this.resizeTo(1,1);
                    this.setTop(-20);
                },
                border1:"2px dotted red",
                border2:"2px dotted white"
            })
        }

        hiliteCanvas.setPageRect(rect);

        isc.Page.setEvent("click", hiliteCanvas.getID() + ".hide()");

        hiliteCanvas.setBorder(hiliteCanvas.border1);
        hiliteCanvas.bringToFront();
        hiliteCanvas.show();

        // Flash the border a few times
        this._flashHiliteCanvas()
    },

    hideHiliteCanvas : function () {
        if (this._hiliteCanvas) this._hiliteCanvas.hide();
    },

    flashHiliteCount: 7,
    flashHilitePeriod: 500,

    _flashHiliteCanvas : function () {
        // a function to set the hilite canvas to flash on a timer a few times
        var borders = [this._hiliteCanvas.border1,this._hiliteCanvas.border2];

        for (var i=0; i<this.flashHiliteCount; i++) {
            isc.Timer.setTimeout({
                    target:this._hiliteCanvas, methodName:"setBorder",
                    args:[borders[i%2]]
                }, (this.flashHilitePeriod*i)
            )
        }
    }

});


//    LogViewer -- simple log viewer -- use to display the log visually.
// ---------------------------------------------------------------------------------------
//    Automatically updates whenever the log is added to.

isc.ClassFactory.defineClass("LogViewer");
isc.LogViewer.addClassMethods({
    // the GlobalLogCookie stores Log window sizing info that's required to be at path / to
    // work.
    getGlobalLogCookie : function () {
        var globalLogCookie = isc.Cookie.get("GLog");
        if (!globalLogCookie) return null;

        try {
            var fn = new Function("return " + globalLogCookie);
            return fn();
        } catch (e) {
            this.logWarn("bad log cookie: " + globalLogCookie + this.getStackTrace());
        }
    },
    // The LogCookie is stored at /isomorphic/system/helpers so as not to pollute the / HTTP
    // header space.  This cookie contains everything except what the GlobalLogCookie has
    getLogCookie : function () {
        var logCookie = isc.Cookie.get("Log");
        if (!logCookie) return null;

        try {
            var fn = new Function("return " + logCookie);
            return fn();
        } catch (e) {
            this.logWarn("bad log cookie: " + logCookie + this.getStackTrace());
        }
    }
});

isc.LogViewer.addMethods({

    // whether the log window is loaded and ready to be accessed
    logWindowLoaded : function () {
        // We get bizarre errors in IE (typically: "trying to execute a freed script") if we
        // try to access elements of the logWindow page from the main frame if the log window
        // is being loaded, and replacing an existing log window.
        // This is probably due to window.open() returning a handle that is in an invalid state
        // until the new log window finished loading.
        // Therefore we wait for the log window to actually call back to the main frame and set
        // a flag telling us it has loaded.
        return (this._logWindowLoaded && this._logWindow != null && !this._logWindow.closed );
    },

    // showInline - if true we show the full log console in an isc.Window rather than a separate
    // window. useful for tablets where multi-window is a pain but we actually have enough space
    // to basically work with a log window.

    showConsoleInline:isc.Browser.isTouch,

    showLog : function (loading, logWindow, dontSaveState, windowName, showInline) {
        if (showInline == null) showInline = this.showConsoleInline;
        // allow a log window to be passed in.  This allows the log window to reconnect to the
        // opener after the opener has been navigated to a new ISC page.
        if (logWindow) this._logWindow = logWindow;

        //alert("showLog called: loading: " + loading + ", logWindow: " + this._logWindow +
        //      ", form: " + (this._logWindow ? this._logWindow.resultsForm : null));
        //    if the _logWindow property is set up, it's a pointer to a log window we previously
        //  opened.  If we can get into its form, just replace the form contents which is much
        //  faster.
        if (this.logWindowLoaded()) {
            this._logWindow.setResultsValue(isc.Log.getMessages().join("\r"));
            if (!this._logWindowInline) {
                this._logWindow.focus();
            }
            return;
        }

        // Assume that this is the only logViewer instance running - make sure it's available
        // as Log.logViewer
        if (!isc.Log.logViewer) isc.Log.logViewer = this;

        // if we have a log window, and it's not closed, we're done
        // (Note - if it is in the process of loading, we will rightly leave it alone)
        if (this._logWindow && !this._logWindow.closed) {

            return;
        }

        var rect = {},
            globalLogCookie = (dontSaveState ? null : isc.LogViewer.getGlobalLogCookie());

        if (globalLogCookie != null) {
            rect = globalLogCookie;
            // Disabled due to multiple-monitors: the log window position that's saved doesn't
            // work properly unless the log window is in the primary monitor. Also, negative
            // coordinates will mean that the window will be displayed at (0, 0) instead.
            /*
            // make sure the log window doesn't end up off the screen
            rect.left = rect.left > screen.availWidth ? 0 : rect.left;
            rect.top = rect.top > screen.availHeight ? 0 : rect.top;
            */
        } else {
            rect.left = 100;
            rect.top = 100;
            rect.width = 640;
            rect.height = 480;
        }

        if (showInline) {
            if (this.inlineWindow == null) {
                this.inlineWindow = isc.Window.create({
                    title:"Inline Developer Console",
                    src:isc.Page.getIsomorphicClientDir() + "helpers/Log.html",
                    animateMinimize:false,
                    // Size big enough to interact with and small enough to be able to grab
                    // the resize edges easily.
                    width:"50%",
                    height:Math.round(isc.Page.getHeight() * 0.8),//"80%",
                    headerControls:[
                        "headerIcon",
                        "headerLabel",
                        isc.Button.create({
                            width:16,
                            height:14,
                            title:"TL",
                            layoutAlign:"center",
                            click:function() {
                                isc.Log.logViewer.inlineWindow.moveTo(0,0);
                            }
                        }),
                        isc.Button.create({
                            width:16,
                            height:14,
                            title:"BL",
                            layoutAlign:"center",
                            click:function() {
                                isc.Log.logViewer.inlineWindow.moveTo(0,
                                    isc.Page.getHeight()-isc.Log.logViewer.inlineWindow.getHeight());
                            }
                        }),
                        isc.Button.create({
                            width:16,
                            height:14,
                            title:"TR",
                            layoutAlign:"center",
                            click:function() {
                                isc.Log.logViewer.inlineWindow.moveTo(
                                    isc.Page.getWidth()-isc.Log.logViewer.inlineWindow.getWidth(),
                                    0);
                            }
                        }),
                        isc.Button.create({
                            width:16,
                            height:14,
                            title:"BR",
                            layoutAlign:"center",
                            click:function() {
                                isc.Log.logViewer.inlineWindow.moveTo(
                                    isc.Page.getWidth()-isc.Log.logViewer.inlineWindow.getWidth(),
                                    isc.Page.getHeight()-isc.Log.logViewer.inlineWindow.getHeight());
                            }
                        }),
                        "minimizeButton",
                        "maximizeButton",
                        "closeButton"
                    ],
                    showMaximizeButton:true,
                    showMinimizeButton:true,
                    canDragReposition:true,
                    canDragResize:true
                });
            }

            if (!this.inlineWindow.isDrawn()) {
                this.inlineWindow.draw();
            }
            this._logWindowInline = true;

        } else {

            var windowSettings = "RESIZABLE,WIDTH=" + rect.width + ",HEIGHT=" + rect.height;

            if (globalLogCookie) {
                if (isc.Browser.isIE) {
                    windowSettings += ",left=" + rect.left + ",top=" + rect.top;
                } else {
                    windowSettings += ",screenX=" + rect.left + ",screenY=" + rect.top;
                }
                if (globalLogCookie.evals) this._currentEval = globalLogCookie.evals.length - 1;



            }


            //var subWindow = (window.opener && window.opener.isc);
            windowName = windowName || "_simpleLog";

            this._logWindow =
                window.open(isc.Page.getIsomorphicClientDir() + "helpers/Log.html",
                            windowName
                            // avoid log window name collisions between Devenv and released
                            // versions of ISC.  NOTE: we'd use the version number, but
                            // IE only is unhappy with a window name of eg "log5.5".
                            + (isc.version.contains("version") ? "Dev" : "")
                             , windowSettings);
        }

        this._initLogWindow(dontSaveState);
    },

    _logWindowInitAttempts:0,
    _logWindowPollInterval: 25,
    _initLogWindow : function (dontSaveState) {
        if (this._logWindow == null && this.inlineWindow != null) {
            var iFrame = this.inlineWindow.body._getURLHandle();
            if (iFrame) {
                this._logWindow = this.inlineWindow.body._getURLHandle().contentWindow;
            }
            // bail if we couldn't get the handle.

            if (this._logWindow == null) {
                return;
            }
        }

        if (this._logWindow == null) return;
        if (isc.Browser.isIE) {
            // if we've set document.domain, then attempting to immediately set a property on
            // the new window, before it can adjust its document.domain automatically, results
            // in an 'Access denied' error, so poll.
            try {
                this._logWindow._accessTest = true;
            } catch (e) {
                this.delayCall("_initLogWindow", [dontSaveState], this._logWindowPollInterval);
                return;
            }
        }

        // In IE, set up a pointer to this window in the newly opened log window
        // This is necessary as IE will not replace the 'window.opener' property to point
        // to this window, if the above call replaced the contents of an already open
        // log window.
        if (isc.Browser.isIE || this._logWindowInline) {
            this._logWindow.launchWindow = window;
            if (this._logWindowInline) {
                this._logWindow.showingInline = true;
            }
        }

        // If we don't want the log window to attempt to save / retrieve state from cookies
        // set a flag on it
        if (dontSaveState) this._logWindow.dontSaveState = true;


        // focus in the log window we just opened, to bring it in front of whatever other windows
        // might be occluding it (WinAmp et al).
        // Do this on an idle.  Otherwise some browsers will focus in the log window, then
        // as code continues to execute in the main window, focus back in the main window.
        // (Mac Moz is a specific example of this).
        //
        // Put the code to focus inside a conditional in case the window is dismissed before
        // page idle fires.

        var focusFunction = function () {
            if (isc.Log.logViewer) {
                var logWindow = isc.Log.logViewer._logWindow;
                if (logWindow && !logWindow.closed) logWindow.focus();
            }
        }

        // Note - if we're showing the log window on page load, avoid this
        isc.Page.setEvent("idle", focusFunction, isc.Page.FIRE_ONCE);

        // if the log window is already open, then reconnect.  Otherwise the log window will
        // fire initializePage() on its own onload.
        if (this._logWindow.initializePage) this._logWindow.initializePage();
    },

    // unlike addToMasterLog(), addToLog() simply updates the log window's results form
    // *without* putting the message into the message index.  This means the log would be lost
    // by log window reload, unlike normal logs.  Used by eval (above)
    // Standard logWarn() et al. use addToMasterLog() - observed by Log.html to keep the
    // results form up to date.
    addToLog : function (message, scrollToEnd) {
        if (this.logWindowLoaded() && !this._suppressRefresh) {
            // append the new message to the existing log
            this._logWindow.addToLog(message, scrollToEnd);
        }
    },

    //_staticFormUpdates:0,
    _$count : "count",
    updateStats : function (stat) {
        // don't update stats during timeExpression() runs
        if (isc._timingRun) return;

        if (!this.logWindowLoaded()) return;

        //this._staticFormUpdates++;
        var canvas = isc.Canvas,
            form = this._logWindow.staticForm;
        if (stat == this._$count) {
            form.setValue(stat,
                          canvas._canvasList.length - canvas._iscInternalCount);
        } else {
            form.setValue(stat, canvas._stats[stat]);
        }
    },
    displayEventTarget : function () {
        var targetID = isc.EH.lastTarget ? isc.EH.lastTarget.getID() : "";
        if (targetID == this._currentTarget) return;
        this._currentTarget = targetID;

        if (this.logWindowLoaded()) {
            this._logWindow.staticForm.setValue("currentCanvas", targetID)
        }

        var nativeTarget = isc.EH.lastEvent.nativeTarget;
        var nativeID = (nativeTarget? (nativeTarget.id || nativeTarget.ID || nativeTarget.tagName) : 'none')

        if (this.logWindowLoaded()) {
            this._logWindow.staticForm.setValue("nativeTarget", nativeID)
        }
    },
    displayFocusTarget : function () {
        var target = isc.EH.getFocusCanvas(),
            targetID = target ? target.getID() : "";
        if (targetID == this._currentFocusTarget) return;
        this._currentFocusTarget = targetID;
        if (this.logWindowLoaded()) {
            this._logWindow.staticForm.setValue("currentFocusCanvas", targetID);
        }
    },
    displayMouseDownTarget : function () {
        var target = isc.EH.mouseDownEvent.target,
            targetID = target ? target.getID() : "";
        if (this.logWindowLoaded()) {
            this._logWindow.staticForm.setValue("lastMouseDown", targetID);
            if (isc.AutoTest != null && isc.Log.showLocatorOnMouseDown) {
                var autoTestLocator = isc.AutoTest.getLocator();
                this._logWindow.staticForm.setValue("autoTestLocator", autoTestLocator || "none");
            }
        }
    },
    updateRPC : function () {
        if (this.logWindowLoaded() && this._logWindow.RPCTracker)
            this._logWindow.RPCTracker.dataChanged();
    },

    evaluate : function (expr, evalVars) {
        return isc.Log.evaluate(expr, evalVars);
    },

    clear : function () {
        if (this.logWindowLoaded()) this._logWindow.clearResults();
    }



});

// Set up the preferences, log priorities etc. saved in a previous session
isc._globalLogCookie = isc.LogViewer.getGlobalLogCookie();
if (isc._globalLogCookie != null) {
    isc.Log.applyLogPriorities(isc._globalLogCookie.priorityDefaults)

    if (isc._globalLogCookie.defaultPriority != null)
        isc.Log.defaultPriority = isc._globalLogCookie.defaultPriority;
} else {
    // For the "Log" category, default to "info"
    isc.Log.setPriority("Log", isc.Log.INFO);
}

isc.showConsole = function (loading, logWindow, dontSaveState, windowName) {
    isc.showLog(loading, logWindow, dontSaveState, windowName);
}
// this basically only exists as a convenience for those with old javascript:showLog() bookmarks
isc.addGlobal("showLog", function (loading, logWindow, dontSaveState, windowName) {
    isc.Log.show(loading, logWindow, dontSaveState, windowName)
})

// Useful for touch browsers so you can see log window and page content in the same browser view.
isc.addGlobal("showConsoleInline", function () {
    isc.Log.show(null, null, null, null, true);
});

// indicate that the log has started
isc.Log.logInfo("initialized");

// allow storing log messages before Log class has loaded (advanced internal usage)
isc.Log._logPrelogs();

// capture a stack trace for every JS error.
//

isc.Log.supportsOnError = (
    isc.Browser.isIE     && (isc.Browser.version <= 9  || isc.Browser.version >= 11) ||
    isc.Browser.isMoz    &&  isc.Browser.version >= 31 ||
    isc.Browser.isChrome &&  isc.Browser.version >= 34
);
if (isc.Log.supportsOnError && !(window.isc_installOnError == false)) {

    window.onerror = function (msg, file, lineNo, columnNo, error) {

        if (error != null) {
            // if an error object is present, use it to report
            isc.Log._reportJSError(error);
        } else {
            // arguments.caller is deprecated, equivalent of arguments.callee.caller.arguments
            // (See getStackTrace implementation for more on how we work with errors)
            //
            // Note:
            // - In FF 3.6+ while onerror fires, it appears we can't walk the stack -
            //   arguments.callee.caller is always null at this point.
            // - In IE9, we also can't walk the stack, though we can identify the function where
            //   the crash occurred (but not its arguments)
            //   - this is because arguments.callee.caller is there, but
            //     arguments.callee.caller.arguments is not, nor arguments.callee.caller.caller
            // Note in both cases the thread in onerror is actually running in some kind of
            // special security context: it's not just that you can't traverse through the
            // onerror function, even if you know the name of a function in the stack
            // beforehand, accessing func.caller on that function is null.
            var callerArgs = arguments.caller,
            caller;
            if (callerArgs == null && arguments.callee.caller != null) {
                caller = arguments.callee.caller;
                callerArgs = caller.arguments;
            }

            // one-time flag to avoid doubled reports for errors that are caught, go through
            // _reportJSError(), and are rethrown
            if (callerArgs && callerArgs._errorReported) {
                return;
            }

            var message = "Error:\r\t'" + msg + "'\r\tin " + file + "\r\tat line " + lineNo;

            // in IE9 called from window.onerror, this is the way the stacks end (not with a
            // bang but a whimper).  We can at least log the name of the function that crashed
            // and direct users to other browsers for better diagnostics.
            // Note we can't check Browser.isIE9 because that's enabled only when IE9 is not
            // running in a compatibility mode to emulate other browser's rendering.  This
            // JavaScript behavior is present in all modes.
            if (caller != null && callerArgs == null &&
                isc.Browser.isIE && isc.Browser.version >= 9)
            {
                message += "\r\n    crashed in:  " + isc.Func.getName(caller, true) + "()" +
                    "\r\n    Use a pre-9.0 Internet Explorer for best diagnostics, " +
                    "otherwise Firefox or Chrome";
            } else if (callerArgs != null) {
                message += isc.Log.getStackTrace(callerArgs);
            }

            isc.Log.logWarn(message);
        }

        if (isc.Browser.isIE && isc.useIEDebugger) {
            if (confirm("Run debugger?" + "\r\r" + message)) {
                debugger;
            }
        }
    };
} else if (isc.Browser.autotest == isc.Browser.RUNNER) {

    window.onerror = function (msg, url, line) {
        if (isc.TestRunner) {
            isc.TestRunner.addUnassignedErrorDetails("Javascript Exception at " + url +
                                                     ", line " + line + ": " + msg);
        }
    };
}



// shared toString method for data model classes (ResultSet, ResultTree)
isc._dataModelToString = function () {
    return "[" + this.Class + " ID:" + this.ID +
          (this.componentId != null ? " (created by: " + this.componentId + ")"
                                      : "(created directly)") +
    "]";
}

// shared logMessage method for data model classes (Resultset, ResultTree)
isc._dataModelLogMessage = function (priority, message, category, timestamp) {
    var log = isc.Log;
    if (!log) return;

    //>DEBUG

    // if no priority was passed in, use the default
    if (priority == null) priority = log.defaultPriority;

    // automatically add a stack trace for error logs
    if (priority <= log.stackTracePriority && this.getStackTrace != null) {
        // skip two levels of the stack to avoid showing the logMessage() invocation itself
        message += "\nStack trace:\n" + this.getStackTrace(arguments, 2);
    }

    // If a category was not specified, use the name of this class.
    if (!category) category = this.Class;

    // actually do the log.  NOTE: if we have an instance ID, pass it
    log.log(priority, message, category, this.ID  + " (created by: " + this.componentId + ")", this, timestamp);

    //<DEBUG
}











/////////////////////
//
//    Methods for sorting an array easily
//
/////////////////////


isc.addProperties(Array, {
    //>    @type    SortDirection
    // @visibility external
    //            @group    sorting
    ASCENDING:true,            //    @value    "ascending"        Sort in ascending order (eg: A-Z, larger items later in the list)
    DESCENDING:false        //    @value    "descending"    Sort in descending order (eg: Z-A, larger items earlier in the list)
    //<

});

isc.addMethods(Array, {

//>    @method        Array.shouldSortAscending()
//            Returns the passed in sortDirection (string / boolean) as the appropriate boolean
//        @group    sorting
//
//<
shouldSortAscending : function (sortDirection) {

    if (sortDirection == Array.ASCENDING) return true;
    if (sortDirection == Array.DESCENDING) return false;

    if (isc.isA.String(sortDirection)) {
        if (sortDirection.toLowerCase() == "ascending") return true;
        if (sortDirection.toLowerCase() == "descending") return false;
    }

    // Anything else is invalid  - just return null
    return null;
}

});


// add a bunch of methods to the Array prototype so all arrays can use them
isc.addMethods(Array.prototype, {




//>    @method        array.sortByProperty()
// @include list.sortByProperty()
//<
sortByProperty : function (property, direction, normalizer, context) {
    return this.sortByProperties({property:property, direction:direction,
                                  normalizer:normalizer, context:context});

},

//> @method array.setSort()
// Sort this Array by a list of +link{SortSpecifier}s.
// @param sortSpecifiers (Array of SortSpecifier) the list of +link{SortSpecifier}s to sort by
// @return (array) the array itself
// @visibility external
//<
setSort : function (sortSpecifiers) {
    var properties = [], directions = [], normalizers = [], contexts = [];
    for (var i = 0; i < sortSpecifiers.length; i++) {
        var item = sortSpecifiers[i];
        properties[i] = item.property;
        directions[i] = Array.shouldSortAscending(item.direction);
        normalizers[i] = item.normalizer;
        contexts[i] = item.context;
    }
    return this.sortByProperties(properties, directions, normalizers, contexts);
},

//> @method array.sortByProperties()
// Given an array of objects, sort them by the properties of the member objects.
// Note that the sort will occur by the first property passed in, then for objects
// with matching values for the first property, the second property will be used (and so on).
// Can pass in an arbitary number of parameters.
// @param sortData (object) Each parameter is an object of the following format:<br>
// <code>{property:'propertyName', direction:direction, normalizer:normalizer}</code><br>
// Only the "property" attribute is required.  Pass in multiple arguments to sort by multiple
// properties.
// @return (array) the array itself
//<
// This method also supports being passed a 'context' parameter. If present, this is passed
// into the sort normalizer method as a parameter
// Example use case: ListGrids pass themselves into the 'sortByProperty' method as the context
// and are then available to the sort normalizer for the field.
// The context, if present, should be passed in as the 'context' attribute of each parameter
// object (so we can support 1 context per field name)
// In addition to the documented parameter format, sortByProperties will take 4 arrays - an
// array of property names, an array of sort directions, an array of normalizers and an array
// of 'context' objects.
// The normalizer / sortDirection / context for each property is then determined by
// the position in the array (so the last 3 arrays are optional and may be sparse)


sortByProperties : function () {

    var normalizedArray = isc._normalizedValues,
        wrongTypeArray = isc._unexpectedTypeValues;

    // Support being called with either the signature
    //  (["prop1", "prop2", ...], [dir1, dir2, ...], [norm1, norm2, ...])
    // or
    //  ({property:"prop1", direction:dir1, normalizer:norm1}, {property:"prop2", ...},...)

    if (isc.isAn.Array(arguments[0])) {
        this.sortProps = arguments[0];
        this.sortDirections = arguments[1] || [];
        this.normalizers = arguments[2] || [];
        this.contexts = arguments[3] || [];
    } else {

        // clear out any sortProps so we don't get additional (old) properties

        if (!this.sortProps) {
            this.sortProps = [];
            this.normalizers = [];
            this.sortDirections = [];
            this.contexts = [];
        } else {
            this.sortProps.clear();
            this.sortDirections.clear();
            this.normalizers.clear();
            this.contexts.clear();
        }


        for (var i = 0; i < arguments.length; i++) {
            this.sortProps[i] = arguments[i].property;

            this.sortDirections[i] = arguments[i].direction;
            this.normalizers[i] = arguments[i].normalizer;
            this.contexts[i] = arguments[i].context;
        }
    }

    // Bail out if we have empty sortProps

    if (this.sortProps == null || this.sortProps.length == 0) return this;

    // local refs
    var props = this.sortProps,
        norms = this.normalizers,
        contexts = this.contexts;

    var start = isc.timestamp();

    for (var i = 0; i < props.length; i++) {

        // remember the sort directions on the Array object -- retrieved in _compareNormalized
        isc._sortDirections[i] = this.sortDirections[i];

        var property = props[i],
            normalizer = norms[i],
            context = contexts[i];
        // Set up the array to store the normalized values for this prop in
        normalizedArray[i] = [];
        wrongTypeArray[i] = [];

        var dataType = null;
        var isValueMap = false;
        var isDataPath = false;

        if (isc.isA.Function(normalizer)) {

            for (var ii = 0, l = this.length, item;ii < l;ii++) {
                item = this[ii];
                if (item == null) {
                    // If any nulls were detected during the sort notify the developer
                    isc._containsNulls = true;
                    continue;
                }

                item._tempSortIndex = ii;
                var normalizedValue = normalizer(item, this.sortProps[i], context);
                normalizedArray[i][ii] = normalizedValue;

                // If we're sorting the field according to an explicit data type, store values
                // not of that type for separate comparison

                if (dataType != null && !Array._matchesType(item[this.sortProps[i]], dataType)) {
                    wrongTypeArray[i][ii] = item[this.sortProps[i]];
                }

                // a custom normalizer might produce NaN, which is a dangerous because, unlike
                // any other value, both "1 > NaN" and "1 < NaN" are false, which fools the
                // comparator into thinking everything is equal to NaN, so the sort order is
                // scrambled and changes each time, and the reason why isn't obvious to the
                // developer.  Hence normalize NaN to the maximum negative value, like our
                // built-in numeric normalizer does.
                var undef;
                if (isc.isA.SpecialNumber(normalizedValue) && isNaN(normalizedValue)) {
                    normalizedArray[i][ii] = 0-Number.MAX_VALUE;
                }

            }
            //isc.Log.logWarn("function normalizer: normalized values: " + normalizedArray[i] +
            //                ", unexpected types: " + wrongTypeArray[i]);
        } else {
            // if not passed an explicit normalizer, choose the appropriate function to normalize data
            // (see above)
            // catch the case where we were passed a data type rather than a normalizer function
            if (isc.isA.String(normalizer)) {
                dataType = normalizer;
            } else if (normalizer != null) {
                isValueMap = true;
            }

            if (context && context.getField) {
                var field = context.getField(property);

                if (field) {
                    if (field.dataPath) {
                        // Trim dataPath - required as field.dataPath may be absolute (so may include
                        // component.dataPath.
                        property = isc.Canvas._trimDataPath(field.dataPath, context);
                        isDataPath = true;
                    } else {
                        property = field.name;
                        isDataPath = false;
                    }
                    if (field.type && dataType == null) {
                        dataType = field.type;
                    }
                } else {
                    isDataPath = (property.indexOf("/") >= 0);
                }
            }

            if (dataType == null) {
                dataType = this._getSortDataType(props[i]);
            }

            var type = isc.SimpleType.getType(dataType);
            var baseType = isc.SimpleType.getBaseType(type);
            if (baseType == null) {
                baseType = dataType;
            }

            if (!isValueMap) {
                normalizer = Array._getNormalizerFromType(baseType);
            }

            // In the case where we were unable to determine a custom data-type normalizer for the field
            // fall back on the default object normalizer.
            if (normalizer == null) normalizer = Array._normalizeObj;

            // a non-null, non-dataType, non-function normalizer was passed, assume it's a
            // propertyValue -> normalizedValue map
            var normalizerMap = this.normalizers[i];
            for (var ii = 0, l = this.length, item; ii < l ;ii++) {
                item = this[ii];

                if (item == null) {
                    isc._containsNulls = true;
                    continue;
                }
                item._tempSortIndex = ii;
                var atomicValue = Array._getAtomicValue(item, property, isDataPath, type);

                var normalizedValue = null;
                if (!isValueMap) {
                    normalizedValue = normalizer(atomicValue);
                } else {
                    var mappedVal = normalizer[atomicValue];
                    if (mappedVal == null) mappedVal = atomicValue;
                    normalizedValue = Array._normalizeStr(mappedVal);
                }
                normalizedArray[i][ii] = normalizedValue;

                // If we're sorting the field according to an explicit data type, store values
                // not of that type for separate comparison

                if (dataType != null && !Array._matchesType(atomicValue, baseType)) {
                    wrongTypeArray[i][ii] = item[this.sortProps[i]];
                }
            }
        }
    }   // END of the for loop



    if (isc.Browser.compensateForUnstableSort == null) {
        isc.Browser.compensateForUnstableSort =
                // Webkit covers Chrome, Safari, Android
                isc.Browser.isWebKit || isc.Browser.isOpera ||
                (isc.Browser.isIE && isc.Browser.version>=9);

    }
    if (isc.Browser.compensateForUnstableSort) {
        var numProps = normalizedArray.length;
        normalizedArray[numProps] = [];
        for (var i = 0; i < this.length; i++) {
            normalizedArray[numProps][i] = i;
        }

        var wrongTypeArrayNumPos = wrongTypeArray.length;
        if (wrongTypeArrayNumPos != 0) {
            wrongTypeArray[wrongTypeArrayNumPos] = [];
            for (var i = 0; i < this.length; i++) {
                wrongTypeArray[wrongTypeArrayNumPos][i] = i;
            }
        }
        // sort ascending
        isc._sortDirections[numProps] = true;
    }

    //isc.logWarn("normalizing took: " + (isc.timestamp() - start) + "ms");



    // worth pre-computing for the common case that there are no values of unexpected type
    var hasUnexpectedTypeValues = false;
    for (var i = 0; i < isc._unexpectedTypeValues.length; i++) {
        if (isc._unexpectedTypeValues[i].length > 0) {
            hasUnexpectedTypeValues = true;
            break;
        }
    }
    isc._hasUnexpectedTypeValues = hasUnexpectedTypeValues;

    //isc.logWarn("about to sort, hasUnexpectedTypeValues: " + isc._hasUnexpectedTypeValues +
    //            ", normalizedValues: " + isc.echoFull(isc._normalizedValues) +
    //            ", unexpectedTypes: " + isc.echoFull(isc._unexpectedTypeValues) +
    //            " directions: " + isc._sortDirections);


    var normalizedValues = isc._normalizedValues,
        directions = isc._sortDirections,
        hasUnexpectedTypeValues = isc._hasUnexpectedTypeValues;

    var arr = this;
    arr.compareAscending = Array.compareAscending;
    arr.compareDescending = Array.compareDescending;

    // define comparator function for sorting by property - uses already stored out normalized
    // values and sort-directions
    var compareNormalized =
function (a,b) {

    // For null values we'll always compare 'null' regardless of the field property
    var aIndex = (a != null ? a._tempSortIndex : null),
        bIndex = (b != null ? b._tempSortIndex : null);

    for (var i = 0; i < normalizedValues.length; i++) {

        var aFieldValue = normalizedValues[i][aIndex],
            bFieldValue = normalizedValues[i][bIndex];

        // if both values were not the expected type, compare them directly in un-normalized
        // form.  Note if only one value was unexpected type, by comparing normalized values we
        // will sort values of unexpected type to one end, since the standard normalizers all
        // normalize unexpected type values to the lowest values in the type's range.
        if (hasUnexpectedTypeValues && aFieldValue != null && bFieldValue != null) {
            var unexpectedTypes = isc._unexpectedTypeValues,
                aWrongType = unexpectedTypes[i][aIndex],
                bWrongType = unexpectedTypes[i][bIndex];
            if (aWrongType !== undef && bWrongType !== undef) {
                aFieldValue = aWrongType;
                bFieldValue = bWrongType;
            }
        }

        var returnVal = (directions[i] ? arr.compareAscending(aFieldValue, bFieldValue)
                                       : arr.compareDescending(aFieldValue, bFieldValue));

        //isc.Log.logWarn("compared: " + isc.Log.echo(aFieldValue) + " to " +
        //             isc.Log.echo(bFieldValue) + ", returning: " + returnVal);

        // If we have a non-equal result, return it, otherwise we'll check the next property
        // in array.sortProps
        if (returnVal != 0) return returnVal;
        else if (hasUnexpectedTypeValues) {

            if ((aWrongType !== undef) != (bWrongType !== undef)) {
                return (aWrongType !== undef) == !!directions[i] ? -1 : 1;
            }
        }
    }

    // at this point we've gone through every field in the sort, and these 2 items match in
    // each case -- just return 0 to indicate no order pref.

    return 0;
};

    var start = isc.timeStamp();

    // perform the actual sort
    this.sort(compareNormalized);

    //isc.logWarn("sorted in: " + (isc.timeStamp() - start) + "ms");

    // if we hit any nulls, warn the developer
    if (isc._containsNulls) {
        isc.Log.logWarn("Attempt to sort array by property hit null entry where a record should be. Array:" +
                        isc.Log.echo(this));
        isc._containsNulls = null;
    }

    // Clear out the index temporarily stored on each item, and empty the temp arrays of
    // sort values / directions

    this.clearProperty("_tempSortIndex");
    normalizedArray.clear();
    wrongTypeArray.clear();
    isc._sortDirections.clear();

    // call dataChanged in case anyone is observing it
    this.dataChanged();

    return this;
},


//>    @method        array.unsort()    (A)
//        Turn sorting off for this array, indicating that the current sort
//        order should be preserved.  Return true if this is supported in this List.
//
//        Some implementations may not support this -- they should return false
//        to indicate to the caller that sort order must be maintained (eg: in
//        the case where sort order is derived from the server, etc).
//
//        @group    sorting
//
//        @return    (boolean)    true == list supports unsorting, false == not supported.
// @visibility external
//<
unsort : function () {
    if (this.sortProps) this.sortProps.clear();
    return true;
},


// _getSortDataType() - given a field to sort this Array's member objects by, this method
// returns the data type to treat these field values as. Used to determine the appropriate
// normalizer function for the values.
// Note that a "normalizer" function renders a variable in a standardized format
// so we can sort by it easily.  For example, dates are converted into msec, etc.
_getSortDataType : function (sortProp, value) {
    var list = (value != null ? (isc.isAn.Array(value) ? value : [value]) : this);
    // determine the type WRT sorting based on the type of the first non null value
    for (var i = 0; i < list.length; i++) {

        if (!isc.isAn.Object(list[i])) continue;

        value = list[i][sortProp];

        // skip null entries
        if (value == null) continue;

        var type = Array._getType(value);
        if (type != null) return type;
    }
    return null;
},

// _getNormalizer() - method to give us a normalizer based on the data for the
// appropriate field within this Array's member objects.
_getNormalizer : function (sortProp, value) {

    var type = this._getSortDataType(sortProp, value);
    var normalizer = Array._getNormalizerFromType(type);
    return normalizer || Array._normalizeObj;
},


//>    @method        array.normalize()    (A)
//        @group    sorting
//             Normalize a property of an object based on the normalizer for this array
//            or the type of the property if that's this.normalizer is not set
//
//        @return    (any)    normalized value
//<
normalize : function (obj, property) {
    var isDataPath = (property.indexOf("/") >= 0);
    var type = null;
    var normalizer;
    if (isc.isA.String(this.normalizer)) {
        var dataType = this._getSortDataType(property);
        type = isc.SimpleType.getType(dataType);
        var baseType = isc.SimpleType.getBaseType(type);
        normalizer = this._getNormalizerFromType(baseType);
    } else {
        normalizer = this.normalizer;
    }
    var atomicValue = Array._getAtomicValue(obj, property, isDataPath, type);
    return normalizer[atomicValue];
}

}); // END isc.addMethods(Array.prototype)

// add static sort routines and variables to the Array object
isc.addProperties(Array,{
    _SORT_TEMP : "__sort_temp",        // name of the temporary variable to use as sort criteria
    _UNEXPECTED_TYPE : "__unexpected_type" // Used by sortByProperty when a value doesn't match
                                           // the field's expected data type
});

isc.addMethods(Array, {
//>    @method        array._normalize()
//        @group    sorting
//            Normalize one field into another for sorting
//    obj = object to normalize
//    property = property to normalize
//
//        @param    obj            (object)    object to normalize
//        @param    property    (string)    name of the property of object to normalize
//<
_normalizeObj : function (val) {
    return val;
},
_getAtomicValue : function (record, property, isDataPath, simpleType) {
    var value = null;
    if (isDataPath) {
        value = isc.Canvas._getFieldValue(property, null, record, null, true);
    } else {
        value = record[property];
    }
    if (simpleType &&  simpleType.getAtomicValue) {
        isc.Func.replaceWithMethod(simpleType, "getAtomicValue", "value");
        value = simpleType.getAtomicValue(value);
    }
    return value;
},
_normalizeStr : function (val) {

    return (isc.isA.String(val) ? val.toLowerCase() : isc.emptyString);
},
_normalizeNum : function (val) {
    // put non-numbers at the beginning of the sort
    return isc.isA.Number(val) ? val : (0 - Number.MAX_VALUE);
},

_normalizeBool : function (val) {
    if (val == true) return 1;
    if (val == false) return 0;
    if (val == null) return -1;
    return -2;
},

_normalizeDate : function (val) {

    var time = (val && isc.isA.Date(val) ? val.getTime() : new Date(val).getTime())
    // NOTE: "new Date([bad date])" creates a special invalidate date object for which
    // getTime() returns NaN in both Moz and IE.
    // Replace with zero to reliably sort at the top of ascending sort (or end of descending
    // sort).

    // NOTE: return the earliest valid date, not 0, which would be epoch time start (Jan 1
    // 1970), which would sort into the middle of some sets of dates.

    if (isNaN(time) || val == null) return -8640000000000000;
    return time;
},

_normalizeTime : function (val) {
    if (!isc.isA.Date(val) && val != null) val = isc.Time.parseInput(val);

    if (isc.isA.Date(val)) return val.getTime();
    return 0;
},

// Normalizer for sorting data of type string numerically
textToNumericNormalizer : function (val) {
    var value = parseInt(val, 10);
    if (isc.isA.Number(value)) return value;
    else return 0;
},

// Given a known data type - what is the appropriate sort-normalizer?


_$string:"string", _$text:"text", _$number:"number", _$integer:"integer", _$float:"float",

_$int:"int", _$boolean:"boolean", _$Date_ : "Date",  _$Time:"Time",
_$datetime : "datetime", _$Datetime:"Datetime",
_$date : "date", _$time:"time",

_getNormalizerFromType : function (type) {
    if (!type || !isc.isA.String(type)) return null;
    switch (type) {
        case this._$string:
        case this._$text:
                                return Array._normalizeStr;
        case this._$boolean:    return Array._normalizeBool;
        case this._$Date_:
        case this._$date:
        case this._$Datetime:
        case this._$datetime:
                                return Array._normalizeDate;
        case this._$Time:
        case this._$time:
                                return Array._normalizeTime;

        case this._$number:
        case this._$integer:
        case this._$int:
        case this._$float:
                                return Array._normalizeNum;
    }
    return Array._normalizeObj;
},

// _getType() - returns the "type" name of an object for sorting normalization purposes
_$object:"object",
_getType : function (object) {
    var type = typeof object;
    if (type == this._$object) {
        if (isc.isA.Date(object)) type = this._$date;
    }
    return type;
},

// _matchesType() - helper method used by sortByProperty to catch unexpected type values
// Note the 'type' specified for a field (like "float") may not match the value returned by
// this._getType(object) - so we have to detect equivalent types, (like float and number)
_standardTypeMap:{
    "float":"number",
    "int:":"number",
    "integer":"number",
    "text":"string",
    "Date":"date",
    "Time":"date",
    "time":"date"
},
_matchesType : function (object, type) {
    var objectType = this._getType(object);
    if (objectType == type) return true;

    return (this._standardTypeMap[type] == objectType);
},




//>    @classMethod        Array.compareAscending()    (A)
// Compare two values for an ascending order sort, using locale-sensitive comparison.
//        @group    sorting
//
// @param    a    (any)    first value to compare
// @param    b    (any)    second value to compare
//
// @return    (number)    negative == second is larger, 0 == same value, positive == first is larger
// @visibility external
//<
compareAscending : function (first, second) {
    if (first != null && first.localeCompare != null) {
        var lc = first.localeCompare(second);
        return lc;
    }
    if (second != null && second.localeCompare != null) {
        var lc = second.localeCompare(first);
        return lc;
    }
    return (second > first ? -1 : second < first ? 1 : 0);
},

//>    @classMethod        Array.compareDescending()    (A)
// Compare two values for a descending order sort, using locale-sensitive comparison.
//        @group    sorting
//
// @param    first    (any)    first value to compare
// @param    second    (any)    second value to compare
//
// @return    (number)    negative == first is larger, 0 == same value, positive == second is larger
// @visibility external
//<
compareDescending : function (first, second) {
    if (first != null && first.localeCompare != null) {
        var lc = first.localeCompare(second);
        return -1 * lc
    }
    if (second != null && second.localeCompare != null) {
        var lc = second.localeCompare(first);
        return -1 * lc;
    }
    return (second < first ? -1 : second > first ? 1 : 0);
}

//>Safari3 Safari comparators for broken localeCompare
,
safariCompareAscending : function (first, second) {
    if (first != null && first.localeCompare != null) {
        var lc = first.localeCompare(second);
        return lc - 2;
    }
    if (second != null && second.localeCompare != null) {
        var lc = second.localeCompare(first);
        return lc - 2;
    }
    return (second > first ? -1 : second < first ? 1 : 0);
},
safariCompareDescending : function (first, second) {
    if (first != null && first.localeCompare != null) {
        var lc = first.localeCompare(second);
        return -1 * (lc - 2);
    }
    if (second != null && second.localeCompare != null) {
        var lc = second.localeCompare(first);
        return -1 * (lc - 2);
    }
    return (second < first ? -1 : second > first ? 1 : 0);
}
//<Safari3

});

// Central array for temp storage of normalized values for sorting

isc._normalizedValues = [];
isc._unexpectedTypeValues = [];
isc._sortDirections = [];



//>Safari3
(function () {
    if (isc.Browser.isSafari) {
        var b = "b";
        if (b.localeCompare("a") == 3) {
            Array.compareAscending = Array.safariCompareAscending;
            Array.compareDescending = Array.safariCompareDescending;
        }
    }
})();
//<Safari3







//
//
//    Array object utilities -- not commonly used but sometimes useful stuff
//


isc.addMethods(Array.prototype, {

//>    @method        array.max() ([])
//
//             Returns the largest number in the array, skipping non-numeric values.
//
//            If the start and/or end are given, searches the specified subset of the list.
//
//      @visibility external
//        @group    arrayMath
//        @param    [start]        (number)    optional start index (default is 0)
//        @param    [end]        (number)    optional end index (default is list.length)
//
//        @return    (number)    maximum of all items in the list, or null if all values are non-numeric
//<
max : function (start, end) {
    if (start == null) start = 0;
    if (end == null) end = this.length;

    var max = null;

    for (var i = start; i < end; i++) {
        var value = this[i];
        if (isc.isA.Number(value)) {
            if (max == null) max = value;
            else max = Math.max(max, value);
        }
    }

    return max;
},

//>    @method        array.min() ([])
//
//             Returns the smallest number in the array, skipping non-numeric values.
//
//            If the start and/or end are given, searches the specified subset of the list.
//
//      @visibility external
//        @group    arrayMath
//        @param    [start]        (number)    optional start index (default is 0)
//        @param    [end]        (number)    optional end index (default is list.length)
//
//        @return    (number)    minimum of all items in the list, or null if all values are non-numeric
//<
min : function (start, end) {
    if (start == null) start = 0;
    if (end == null) end = this.length;

    var min = null;

    for (var i = start; i < end; i++) {
        var value = this[i];
        if (isc.isA.Number(value)) {
            if (min == null) min = value;
            else min = Math.min(min, value);
        }
    }

    return min;
},

//>    @method        array.sum() ([])
//             Returns the sum of the numbers in the array, skipping non-numeric values.
//
//            If the start and/or end are given, uses only the specified subset of the list.
//
//      @visibility external
//        @group    arrayMath
//        @param    [start]        (number)    optional start index (default is 0)
//        @param    [end]        (number)    optional end index (default is list.length)
//
//        @return    (number)    sum of all items in the list
//<
sum : function (start, end) {
    if (start == null) start = 0;
    if (end == null) end = this.length;

    var total = 0;

    for(var i = start; i < end; i++)
        if(isc.isA.Number(this[i])) total += this[i];
    return total;
},

//>    @method        array.and() ([])
// Returns true if all values between the start and end indices are true.
//
//      @visibility external
//        @group    arrayMath
//        @param    [start]        (number)    optional start index (default is 0)
//        @param    [end]        (number)    optional end index (default is list.length)
//
//        @return    (boolean)        all of the items in the array are true
//<
and : function (start, end) {
    if (start == null) start = 0;
    if (end == null) end = this.length;

    for(var i = start; i < end; i++)
        if (!this[i]) return false;
    return true;
},

//>    @method        array.or()  ([])
// Returns true if at least one value between the start and end indices is true.
//
//      @visibility external
//        @group    arrayMath
//        @param    [start]        (number)    optional start index (default is 0)
//        @param    [end]        (number)    optional end index (default is list.length)
//
//        @return    (boolean)        at least one of the items is true
//<
or : function (start, end) {
    if (start == null) start = 0;
    if (end == null) end = this.length;

    var total = 0;

    for(var i = start; i < end; i++)
        if (this[i]) return true;
    return false;
}

})    //END isc.addMethods(Array.prototype)







//>    @classMethod isc.getValueForKey()
// Given a key and an object of <code>key:value</code> pairs, return the value that corresponds to
// that key.
// <P>
// If the key is not found, <code>defaultValue</code> will be returned if provided, otherwise the
// key will be returned.
//
//    @param    key                (string or number)    key to look for
//    @param    valueMap        (object)            object of key:value pairs
//    @param    [defaultValue]    (any)                default value to return if key not found
//
//    @return                    (any)                returns value in valueMap under name key, or
//                                              defaultValue if key not found
// @visibility external
//<
isc.getValueForKey = function (key, valueMap, defaultValue) {

    if (valueMap && valueMap[key] != null && !isc.isAn.Array(valueMap)) return valueMap[key];
    return (arguments.length < 3 ? key : defaultValue);
}

//>    @classMethod isc.getKeyForValue()
// Given a value and an object of <code>key:value</code> pairs, return the value that corresponds
// to that key.
// <P>
// If the key is not found, <code>defaultValue</code> will be returned if provided, otherwise the
// value will be returned.
//
//    @param    key                (string or number)    value to look for
//    @param    valueMap        (object)            object of key:value pairs
//    @param    [defaultKey]    (any)                default key to return if value not found
//
//    @return                    (any)                returns first key in valueMap with value, or
//                                              defaultKey if value not found
// @visibility external
//<
isc.getKeyForValue = function (value, valueMap, defaultKey) {
// JMD: handle null value here?
    if (valueMap) {
        for (var key in valueMap) {
            if (valueMap[key] == value) return key;
        }
    }
    return (arguments.length < 3 ? value : defaultKey);
}


//>    @classMethod  isc.makeReverseMap()
// Given a key:value map, return a new map as value:key.
// <P>
// If the same value appears more than once, the key will correspond to the last instance of that
// value.
//
//    @param    valueMap        (object)            object of key:value pairs
//    @return                    (object)            reversed value map
// @visibility external
//<
isc.makeReverseMap = function (valueMap) {
    var newMap = {}, value;
    for (var key in valueMap) {
        value = valueMap[key];
        newMap[value] = key;
    }
    return newMap;
}

// returns a new value map, sorted by the key
// technically, maps can't be sorted, but in JS, objects "remember" the order in which key/value
// pairs were added
// XXX add support for normalizers
isc.sortByKey = function (valueMap) {
    var newMap = {},
        keys = isc.getKeys(valueMap).sort()
    ;
    for (var i = 0; i < keys.length; i++) {
        newMap[keys[i]] = valueMap[keys[i]];
    }
    return newMap;
}

// returns a new value map, sorted by the value
// technically, maps can't be sorted, but in JS, objects "remember" the order in which key/value
// pairs were added
// XXX add support for normalizers
isc.sortByValue = function (valueMap) {
    // make a reverse map of the input map; map is now: value -> key
    // call sortByKey on this reversed map
    // reverse the map again (so map is key -> value) and return it
    // XXX horribly inefficient
    return isc.makeReverseMap(isc.sortByKey(isc.makeReverseMap(valueMap)));
}






//> @class Time
// Helper methods and system-wide defaults for dealing with time values and time display formats.
// <P>
// This class includes utility methods for the creation and display of logical time values, as well
// as modifying the default display timezone for datetime type values. See
// +link{group:dateFormatAndStorage} for more information on working with dates, times and datetimes
// in SmartClient.
//
// @treeLocation Client Reference/System
// @visibility external
//<
isc.ClassFactory.defineClass("Time");


isc.Time.addClassProperties({

    //> @classAttr  Time.UTCHoursOffset (number : null : IRA)
    // Hour offset from UTC to use when formatting +link{fieldType,"datetime"} type fields for
    // display to the user.
    // <P>
    // Has no effect on fields specified as logical date (<code>field.type = "date";</code>) and
    // logical time (<code>field.type = "time"</code>) fields.
    //
    // @visibility external
    // @deprecated As of 7.0 this attribute has been deprecated in favor of
    // +link{Time.setDefaultDisplayTimezone()}
    //<
    //UTCHoursOffset:0,
    // ** On page load we check for this property being set and use it to call
    //    setDefaultDisplayTimezone() with a deprecated warning


    //> @classMethod  Time.setDefaultDisplayTimezone()
    // Sets the offset from UTC to use when formatting values of type +link{FieldType,datetime}
    // with standard display formatters.
    // <p>
    // This property effects how dates are displayed and also the
    // assumed timezone for user-input. For a concrete example - assume this method has been called
    // and passed a value of "+01:00", and an application has a +link{DateTimeItem} visible in
    // a DynamicForm. If the value of this field is set to the current date, with UTC time set to
    // "10:00", the time portion of the value displayed in the form item will be "11:00".
    // Similarly if a user modifies the time value in the text box to be "16:00", a call to
    // +link{FormItem.getValue()} for the item will return a date object with UTC time set to 15:00.
    // <P>
    // Interaction with daylight savings time: The specified "defaultDisplayTimezone" should
    // reflect the correct UTC offset for the current date, for which it will always be exactly respected;
    // adjustment will only be made for dates that fall outside the current daylight savings time mode.
    // <P>
    // In other words if DST is currently not in effect (IE: the current date is a Winter date),
    // any other dates where DST is not in effect will be formatted to exactly respect the specified
    // defaultDisplayTimezone (so for defaultDisplayTimezone of "+01:00", the display
    // string will be 1 hour ahead of the UTC time on the date in question), and any
    // dates where DST is in effect would be further adjusted to account for DST
    // (so the display string would be 2 hours ahead for dates that fall in the Summer).<br>
    // Alternatively if DST currently is in effect (EG: Current date is a Summer date)
    // the situation is reversed. Any date value for which DST should be applied
    // will be be formatted for display with an offset of 1 hour from UTC - and any date value
    // for which DST should not be applied would be formatted with an offset of 0 hours from UTC.
    // <br>
    // Note that the +link{Time.adjustForDST} property may be set to <code>false</code> to
    // disable this logic - in this case the time portion of dates will always be offset from
    // UTC by exactly the specified defaultDisplayOffset, regardless of whether they fall in the
    // range where Daylight Savings Time would usually be applied or not.
    // <p>
    // Note that if a custom timezone is specified, it will not effect native javascript
    // date formatting functions such as <code>toLocaleString()</code>.
    // See +link{group:dateFormatAndStorage} for more on how SmartClient handles date and time
    // formatting and storage.
    // <P>
    // If this method is never called, the default display timezone for times and datetimes will
    // be derived from the native browser local timezone.
    // <P>
    // Note that the displayTimezone effects datetime fields only and has no effect on fields
    // specified as logical date (<code>field.type = "date";</code>) or
    // logical time (<code>field.type = "time"</code>).
    //
    // @param offset (string) offset from UTC. This should be a string in the format
    //    <code>+/-HH:MM</code> for example <code>"-08:00"</code>
    // @see group:dateFormatAndStorage
    // @visibility external
    //<
    setDefaultDisplayTimezone : function (offset, isBrowserDefault) {

        this._customTimezone = !isBrowserDefault;

        if (offset == null) return;
        // Handle being passed an offset in minutes - this matches the format returned by
        // native Date.getTimezoneOffset()
        var hours, minutes;
        if (isc.isA.Number(offset)) {

            offset = -offset;
            hours = Math.floor(offset/60);
            minutes = offset - (hours*60);
        } else if (isc.isA.String(offset)) {
            var HM = offset.split(":");
            hours = HM[0];
            // If the string starts with "-", hours and minutes will be negative
            var negative = hours && hours.startsWith("-");
            if (negative) hours = hours.substring(1);
            minutes = HM[1];

            hours = (negative ? -1 : 1) * parseInt(hours,10);
            minutes = (negative ? -1 : 1) * parseInt(minutes,10);
        }

        if (isc.isA.Number(hours) && isc.isA.Number(minutes)) {
            this.UTCHoursDisplayOffset = hours;
            this.UTCMinutesDisplayOffset = minutes;
        }

    },

    //> @classMethod Time.getDefaultDisplayTimezone()
    // Returns the default display timezone set up by +link{Time.setDefaultDisplayTimezone}.
    // If no explicit timezone has been set this will return the browser locale timezone offset.
    // @return (string) String of the format <code>+/-HH:MM</code>
    // @visibility external
    //<
    // we don't call this internally since it's easier to to work with the stored hours/minutes
    // directly
    getDefaultDisplayTimezone : function () {
        var H = this.UTCHoursDisplayOffset,
            M = this.UTCMinutesDisplayOffset,
            negative = H < 0;
        return (!negative ? "+" : "-") +
            ((negative ? -1 : 1) * H).stringify(2) + ":" + ((negative ? -1 : 1) * M).stringify(2);
    },

    //>    @classAttr    isc.Time._timeExpressions (Array : [..] : IRA)
    // List of regular expressions to parse a time string
    //        @group    parsing
    //<
    _timeExpressions : [
            /^\s*(\d?\d)\s*[: ]\s*(\d?\d)\s*[: ]\s*(\d?\d)?\s*([AaPp][Mm]?)?\s*([+-]\d{2}:\d{2}|Z)?\s*$/,
            /^\s*(\d?\d)\s*[: ]\s*(\d?\d)(\s*)([AaPp][Mm]?)?\s*([+-]\d{2}:\d{2}|Z)?\s*$/,
            /^\s*(\d\d)(\d\d)(\d\d)?\s*([AaPp][Mm]?)?\s*([+-]\d{2}:\d{2}|Z)?\s*$/,
            /^\s*(\d)(\d\d)(\d\d)?\s*([AaPp][Mm]?)?\s*([+-]\d{2}:\d{2}|Z)?\s*$/,
            /^\s*(\d\d?)(\s)?(\s*)([AaPp][Mm]?)?\s*([+-]\d{2}:\d{2}|Z)?\s*$/
        ],

    // This is a combination of the time patterns matched by regular expressions in `_timeExpressions'.
    // If this is changed, be sure to update Time._prepForParseValueExpressions() as well.
    _combinedTimeExpression: /(?:(\d?\d)\s*[: ]\s*(\d?\d)\s*[: ]\s*(\d?\d)?|(\d?\d)\s*[: ]\s*(\d?\d)(\s*)|(\d\d)(\d\d)(\d\d)|(\d)(\d\d)(\d\d)?|(\d\d?)(\s)?(\s*))\s*([AaPp][Mm])?/g,

    //> @type   TimeDisplayFormat
    // String designating a standard time format for displaying the times associated with
    // dates strings.
    // @value   toTime
    //  String will display with seconds and am/pm indicator:<code>[H]H:MM:SS am|pm</code>. <br>
    //  Example: <code>3:25:15 pm</code>
    // @value  to24HourTime
    //  String will display with seconds in 24 hour time: <code>[H]H:MM:SS</code>. <br>
    //  Example: <code>15:25:15</code>
    // @value  toPaddedTime
    //  String will display with seconds, with a 2 digit hour and am/pm indicator:
    //  <code>HH:MM:SS am|pm</code> <br>
    //  Example: <code>03:25:15 pm</code>
    // @value  toPadded24HourTime
    //  String will display with seconds, with a 2 digit hour in 24 hour format:
    //  <code>HH:MM:SS</code> <br>
    //  Examples: <code>15:25:15</code>, <code>03:16:45</code>
    // @value toShortTime
    //  String will have no seconds and be in 12 hour format:<code>[H]H:MM am|pm</code><br>
    //  Example: <code>3:25 pm</code>
    // @value toShort24HourTime
    //  String will have no seconds and be in 24 hour format: <code>[H]H:MM</code><br>
    //  Example:<code>15:25</code>
    // @value toShortPaddedTime
    //  String will have no seconds and will display a 2 digit hour, in 12 hour clock format:
    //  <code>HH:MM am|pm</code><br>
    //  Example: <code>03:25 pm</code>
    // @value toShortPadded24HourTime
    //  String will have no seconds and will display with a 2 digit hour in 24 hour clock format:
    // <code>HH:MM</code><br>
    // Examples: <code>15:25</code>, <code>03:16</code>
    //
    // @visibility external
    //<

    // To simplify parsing / formatting, map valid formatter names to the details of the format
    formatterMap:{
        toTime:{showSeconds:true, padded:false, show24:false},
        to24HourTime:{showSeconds:true, padded:false, show24:true},

        toPaddedTime:{showSeconds:true, padded:true, show24:false},
        toPadded24HourTime:{showSeconds:true, padded:true, show24:true},

        toShortTime:{showSeconds:false, padded:false, show24:false},
        toShort24HourTime:{showSeconds:false, padded:false, show24:true},
        toShortPaddedTime:{showSeconds:false, padded:true, show24:false},

        toShortPadded24HourTime:{showSeconds:false, padded:true, show24:true},
        toTimestamp:{showSeconds:true, padded:true, show24:true, showMillis:true}
    },


    //> @classAttr Time.displayFormat  (TimeDisplayFormat | function : "toTime" : RWA)
    // Standard formatter to be used when converting a date to a time-string via +link{Time.toTime()}
    // @setter Time.setNormalDisplayFormat()
    // @visibility external
    //<
    displayFormat:"toTime",

    //> @classAttr Time.shortDisplayFormat  (TimeDisplayFormat | function : "toShortTime" : RWA)
    // Standard formatter to be used when converting a date to a time-string via +link{Time.toShortTime()}
    // @setter Time.setShortDisplayFormat()
    // @visibility external
    //<
    shortDisplayFormat:"toShortTime",

    //> @classAttr Time.AMIndicator (string : " am" : RWA)
    // String appended to times to indicate am (when not using 24 hour format).
    // @visibility external
    // @group i18nMessages
    //<
    AMIndicator:" am",
    //> @classAttr Time.PMIndicator (string : " pm" : RWA)
    // String appended to times to indicate am (when not using 24 hour format).
    // @visibility external
    // @group i18nMessages
    //<
    PMIndicator:" pm"

    //> @classAttr Time.adjustForDST (boolean : true (see description) : RWA)
    // Determines whether datetime formatters should consider the effect of Daylight Saving
    // Time when computing offsets from UTC.  By default, this flag is set during framework
    // initialization if SmartClient detects that it is running in a locale that is observing
    // DST this year.  If you do not want DST adjustments to be applied, set this flag to
    // false.<p>
    // Note that setting this flag to true will have no effect unless you are in a locale
    // that is observing Daylight Saving Time for the date in question; this is because
    // we rely on the browser for offset information, and browsers are only capable of
    // returning local date and time information for the computer's current locale.
    // <P>
    // This setting will not have any impact on the display of fields specified as type "time" or
    // "date" (logical dates and logical times) - only on datetime type values. See
    // +link{group:dateFormatAndStorage} for information on working with dates, times and datetimes
    // in SmartClient.
    // @visibility external
    //<

});

isc.Time.addClassMethods({

    //> @classMethod Time.toTime()
    // Given a date object, return the time associated with the date as a formatted string.
    // If no formatter is passed, use the standard formatter set up via
    // +link{Time.setNormalDisplayFormat()}.
    //
    // @param date (Date) Date to convert to a time string.
    // @param [formatter] (TimeDisplayFormat | function) Optional custom formatter to use. Will accept
    //  a function (which will be passed a pointer to the date to perform the conversion), or
    //  a string designating a standard formatter
    // @param [logicalTime] Is the date passed in a representation of a logical time value such as
    //  a value from a <code>"time"</code> type field on a dataSource or a datetime value?
    //  For datetime values the formatted string will respect any custom
    // +link{Time.setDefaultDisplayTimezone,display timezone}.
    // If not explicitly specified, the date passed in will be assumed to be a datetime unless
    // it was created explicitly as a time via +link{Time.createLogicalTime()} or similar APIs.
    // @visibility external
    //<
    toTime : function (date, formatter, logicalTime) {
        return this.format(date, formatter, false, logicalTime);
    },

    //> @classMethod Time.toShortTime()
    // Given a date object, return the time associated with the date as a short string.
    // If no formatter is passed, use the standard formatter set up via +link{Time.setShortDisplayFormat()}
    // @param date (Date) Date to convert to a time string.
    // @param [formatter] (TimeDisplayFormat | function) Optional custom formatter to use. Will accept
    //  a function (which will be passed a pointer to the Date to format), or
    //  a string designating a standard formatter
    // @param [logicalTime] Is the date passed in a representation of a logical time value such as
    //  a value from a <code>"time"</code> type field on a dataSource or a datetime value?
    //  For datetime values the formatted string will respect any custom
    // +link{Time.setDefaultDisplayTimezone,display timezone}.
    // If not explicitly specified, the date passed in will be assumed to be a datetime unless
    // it was created explicitly as a time via +link{Time.createLogicalTime()} or similar APIs.

    // @visibility external
    //<
    toShortTime : function (date, formatter, logicalTime) {
        return this.format(date, formatter, true, logicalTime);
    },

    // Given a date return a formatted time string
    _$timeTemplate:[null, ":", null, ":"],
    _$shortTimeTemplate:[null, ":"],

    format : function (date, formatter, shortFormat, logicalTime) {
        // If we're passed a random object (most likely null or a string), just return it
        if (!isc.isA.Date(date)) return date;

        var originalFormatter = formatter;

        // Sanity check - don't allow unexpected things passed in as a formatter to give us
        // odd results
        if (!formatter && !isc.isA.String(formatter) && !isc.isA.Function(formatter)) {
            formatter = shortFormat ? this.shortDisplayFormat : this.displayFormat;
        }

        // Support passing in a completely arbitrary formatter function
        if (isc.isA.Function(formatter)) return formatter(date, logicalTime);

        if (isc.isA.String(formatter)) formatter = this.formatterMap[formatter];

        if (!isc.isAn.Object(formatter)) {
            this.logWarn("Invalid time formatter:" + originalFormatter + " - using 'toTime'");
            formatter = this.formatterMap.toTime;
        }

        var showSeconds = formatter.showSeconds,
            padded = formatter.padded,
            show24 = formatter.show24,
            showMillis = formatter.showMillis;

        var useCustomTimezone;

        if (logicalTime != null) useCustomTimezone = !logicalTime;
        else useCustomTimezone = !date.logicalTime && !date.logicalDate;

        var hour,minutes;
        if (!useCustomTimezone) {
            hour = date.getHours();
            minutes = date.getMinutes();
        } else {

            var hour = date.getUTCHours(),
                minutes = date.getUTCMinutes();

            // Add the display timezone offset to the hours / minutes so we display the
            // time in the appropriate timezone
            var hm = this._applyTimezoneOffset(hour, minutes,
                                                this.getUTCHoursDisplayOffset(date),
                                                this.getUTCMinutesDisplayOffset(date));
            hour = hm[0];
            minutes = hm[1];
        }


        var seconds = showSeconds ? date.getUTCSeconds() : null,
            pm = show24 ? null : (hour >=12);

        // Hour will be in 24 hour format by default
        if (!show24) {
            if (hour > 12) hour = hour - 12;
            if (hour == 0) hour = 12;
        }
        if (padded) hour = hour.stringify(2);

        var template = showSeconds ? this._$timeTemplate : this._$shortTimeTemplate;
        template[0] = hour;
        template[2] = minutes.stringify();
        if (showSeconds) template[4] = seconds.stringify();

        if (!show24) template[5] = (pm ? this.PMIndicator : this.AMIndicator);
        else template[5] = null;

        var formatted = template.join(isc.emptyString);

        if (showMillis) {
            var millis = date.getMilliseconds().stringify(3);
            formatted += "." + millis;
        }

        return formatted;
    },

    //> @classMethod Time.parseInput()
    // Converts a time-string such as <code>1:00pm</code> to a new Date object
    // representing a logical time value (rather than a specific datetime
    // value), typically for display in a +link{DataSourceField.type,time type field}.
    // Accepts most formats of time string. The generated
    // Date value will have year, month and date set to the epoch date (Jan 1 1970), and time
    // elements set to the supplied hour, minute and second (in browser native local time).
    // <P>
    // See +link{group:dateFormatAndStorage} for more information on date, time and datetime
    // values in SmartClient.
    //
    // @param timeString (string) time string to convert to a date
    // @param validTime (boolean) If this method is passed a timeString in an unrecognized format,
    //  return null rather than a date object with time set to 00:00:00
    // @visibility external
    //<
    // UTCTime param deprecated - leaving supported (though now undocumented) for backCompat only.
    //
    // Additional 'isDatetime' and 'baseDatetime' parameters: These are used for the case where we
    // need to set the time portion of a datetime based on a user-entered time string.
    // In this case we need to respect the local timezone specified by
    // +link{time.setDefaultDisplayTimezone}, and we'll also support respecting an explicit
    // timezone offset from UTC being present in the string (EG: <code>"00:00:00+02:00"</code>).
    //
    // Assuming we're not passed a 'baseDatetime', the returned date is always set to 1/1/1970.
    // This is deliberate: It'll make DST never
    // an issue and it matches the format for Time values returned by the server for JSON format
    // DataSources.
    //
    // EXTREMELY forgiving of formatting, can accept the following:
    //        11:34:45 AM    => 11:34:45
    //      11:34:45    => 11:34:45
    //        1:3:5 AM    => 01:30:50
    //        1:3p        => 13:30:00
    //        11 34 am    => 11:34:00
    //        11-34        => 11:34:00
    //        113445        => 11:34:45
    //        13445        => 01:34:45
    //        1134        => 11:34:00
    //        134            => 01:34:00
    //        11            => 11:00:00
    //        1p            => 13:00:00
    //        9            => 09:00:00
    // Also supports explicitly specified timezone offset specified by "+/-HH:MM" at the end, though
    // we only care about this for the datetime case. logical times are literally a way for us
    // to work with numbers for H, M and S.

    // Note: technically being passed "1:00" is ambiguous - could be AM or PM.
    // We always interpret as 24 hour clock (so <12 = AM) unless am/pm is  passed in.
    parseInput : function (string, validTime, UTCTime, isDatetime, baseDatetime) {
        var hours = null,
            minutes = null,
            seconds = null,
            // We don't currently extract milliseconds from a time-string. Instead we zero them
            // out for consistency across times created by this method.
            milliseconds = null,
            ampm;

        var hoursOffset, minutesOffset;

        // if we're passed a date we'll return a new date with the same time (h/m/s/ms, not the same
        // date).
        if (isc.isA.Date(string)) {
            // We'll match the specified time exactly - no need to manipulate timezone offsets
            // here since the underlying UTC time will match and any offsetting for display
            // will occur in formatters.
            UTCTime = true;
            hours = string.getUTCHours();
            minutes = string.getUTCMinutes();
            seconds = string.getUTCSeconds();
            milliseconds = string.getUTCMilliseconds();

        } else if (string != null) {
            // iterate through the time expressions, trying to find a match
            for (var i = 0; i < isc.Time._timeExpressions.length; i++) {
                var match = isc.Time._timeExpressions[i].exec(string);
                if (match) break;
            }
            if (match) {
                // get the hours, minutes and seconds from the match
                // NOTE: this results in 24:00 going to 23:00 rather than 23:59...
                var defaultHours,
                    defaultMinutes,
                    defaultSeconds;
                if (baseDatetime != null) {
                    defaultSeconds = defaultMinutes = defaultHours = null;
                } else {
                    defaultSeconds = defaultMinutes = defaultHours = 0;
                }
                hours = match[1] ? Math.min(parseInt(match[1], 10), 23) : defaultHours;
                minutes = match[2] ? Math.min(parseInt(match[2], 10), 59) : defaultMinutes;
                seconds = match[3] ? Math.min(parseInt(match[3], 10), 59) : defaultSeconds;
                ampm = match[4];

                if (ampm) {
                    if (!this._pmStrings) this._pmStrings = {p:true, P:true, pm:true, PM:true, Pm:true};
                    if (this._pmStrings[ampm] == true) {
                        if (hours == null) hours = 12;
                        else if (hours < 12) hours += 12;
                    } else if (hours == 12) hours = 0;
                }

                // For dateTimes only, if a timezone was explicitly specified on the value passed in,
                // respect it.
                // So we'll handle 18:00:01 -01:00 as 6pm one hour offset from UTC on the generated
                // date value.
                // NOTE: the offset specifies the timezone the date is already in, so
                // to get to UTC we have to subtract the offset

                if (isDatetime && match[5] != null && match[5] != "" && match[5].toLowerCase() != "z") {
                    var HM = match[5].split(":"),
                        H = HM[0],
                        negative = H && H.startsWith("-"),
                        M = HM[1];
                    hoursOffset = parseInt(H,10);
                    minutesOffset = (negative ? -1 : 1) * parseInt(M,10);
                }
            } else if (validTime) return null;
        } else if (validTime) return null;

        var date;
        if (baseDatetime != null) {
            date = baseDatetime.duplicate();
        } else {
            date = new Date(null);
            // Zero out the milliseconds for consistency.
            date.setMilliseconds(0);
        }
        if (isDatetime || UTCTime) {

            if (hoursOffset == null) {
                hoursOffset = UTCTime ? 0 : this.getUTCHoursDisplayOffset(date);
            }
            if (minutesOffset == null) {
                minutesOffset = UTCTime ? 0 : this.getUTCMinutesDisplayOffset(date);
            }

            // NOTE: we're creating UTC time -- any offset indicates the offset for the timezone
            // the inputted time is currently in [either browser local time or explicit offset
            // passed in as part of the time string], so we need to subtract this offset to get to
            // UTC time (not add it)
            var hm = this._applyTimezoneOffset(hours, minutes, (0-hoursOffset), (0-minutesOffset));

            hours = hm[0];
            minutes = hm[1];

            date.setUTCHours(hours == null ? date.getUTCHours() : hours,
                             minutes == null ? date.getUTCMinutes() : minutes,
                             seconds == null ? date.getUTCSeconds() : seconds,
                             milliseconds == null ? date.getUTCMilliseconds() : milliseconds);
        } else {
            date.setHours(hours == null ? date.getHours() : hours,
                          minutes == null ? date.getMinutes() : minutes,
                          seconds == null ? date.getSeconds() : seconds,
                          milliseconds == null ? date.getMilliseconds() : milliseconds);
        }

        // Mark as logical time so we format / serialize correctly without requiring
        // explicit "logicalTime" param to formatter functions
        if (!isDatetime) date.logicalTime = true;

        return date;
    },

    // Preps a string value for parsing by FormItem.parseValueExpressions().
    // It is assumed that value contains a time value expression. The result of calling this
    // function is a new time value expression that can be better parsed by FormItem.parseValueExpressions().
    // For example, without the use of this function, FormItem.parseValueExpressions() will fail
    // on "< 6 am" because of the space between "6" and "am".
    _prepForParseValueExpressions : function (value) {
        if (value == null) return null;
        value = String(value);

        value = value.replace(this._combinedTimeExpression, function (match, p1, p2, p3,
                                                                             p4, p5, p6,
                                                                             p7, p8, p9,
                                                                             p10, p11, p12,
                                                                             p13, p14, p15,
                                                                             p16) {
            p1 = parseInt(p1 || p4 || p7|| p10 || p13) || 0;
            p2 = parseInt(p2 || p5 || p8|| p11 || p14) || 0;
            p3 = (p3 || p6 || p9|| p12 || p15);
            if (p3) {
                p3 = ":" + (parseInt(p3) || 0).stringify(2);
            } else p3 = "";
            p16 = (p16 || "").trim();
            var value = p1 + ":" + p2.stringify(2) + p3;
            if (p16) {
                value += p16;
            }
            return value + " ";
        });
        return value;
    },

    // Helper method to apply an arbitrary timezone offset to hours / minutes
    // Returns array: [newHours,newMinutes,dayOffset]
    // dayOffset ignored for time fields, but can be used to update datetimes
    _applyTimezoneOffset : function (hours, minutes, hOffset, mOffset) {
        if (minutes == null || hours == null) {
            this.logWarn("applyTimezoneOffset passed null hours/minutes");
            return [hours,minutes];
        }
        if (hOffset == null) hOffset = 0;
        if (mOffset == null) hOffset = 0;
        if (hOffset == 0 && mOffset == 0) return [hours,minutes,0];

        hours += hOffset;
        minutes += mOffset;

        // Catch the case where the display offset from UTC pushes the hours / minutes
        // past 60 [or 24] or below zero
        // (Don't worry about the date - we're only interested in the time!)
        while (minutes >= 60) {
            minutes -= 60;
            hours += 1;
        }

        while (minutes < 0) {
            minutes += 60;
            hours -= 1;
        }

        var dayOffset = 0;

        while (hours >= 24) {
            hours -= 24;
            dayOffset += 1;
        }
        while (hours < 0) {
            hours += 24;
            dayOffset -= 1;
        }

        return [hours,minutes, dayOffset];
    },


    //> @classMethod Time.createDate()
    // Creates a date object with the time set to the hours, minutes and seconds passed in.
    // Unless the <code>UTCTime</code> parameter is passed in, parameters are assumed
    // to specify the time in native local display time.
    // @param [hours] (number) Hours for the date (defaults to zero)
    // @param [minutes] (number) Minutes for the date (defaults to zero)
    // @param [seconds] (number) Seconds for the date (defaults to zero)
    // @param [milliseconds] (number) Milliseconds for the date (defaults to zero)
    // @param [UTCTime] (boolean) If true, treat the time passed in as UTC time rather than local time
    // @visibility external
    // @deprecated use +link{Time.createLogicalTime()} instead.
    //<
    createDate : function (hours, minutes, seconds, milliseconds, UTCTime) {
        return this.createLogicalTime(hours, minutes, seconds, milliseconds, UTCTime);
    },

    //> @classMethod Time.createLogicalTime()
    // Create a new Date object to represent a logical time value (rather than a specific datetime
    // value), typically for display in a +link{DataSourceField.type,time type field}. The generated
    // Date value will have year, month and date set to the epoch date (Jan 1 1970), and time
    // elements set to the supplied hour, minute and second (in browser native local time).
    // <P>
    // See +link{group:dateFormatAndStorage} for more information on date, time and datetime
    // values in SmartClient.
    //
    // @param hour (integer) hour (0-23)
    // @param minute (integer) minute (0-59)
    // @param second (integer) second (0-59)
    // @return (Date) new Javascript Date object representing the time in question
    // @visibility external
    //<
    // This is also available as Date.createLogicalTime [and the deprecated Time.createDate]
    // The returned date is always set to 1/1/1970. This is deliberate: It'll make DST never
    // an issue and it matches the format for Time values returned by the server for JSON format
    // DataSources.
    createLogicalTime : function (hours, minutes, seconds, milliseconds, UTCTime) {

        var date = new Date(null);

        if (hours == null) hours = 0;
        if (minutes == null) minutes = 0;
        if (seconds == null) seconds = 0;
        if (milliseconds == null) milliseconds = 0;

        if (UTCTime) {
            date.setUTCHours(hours, minutes, seconds, milliseconds);
        } else {
            date.setHours(hours, minutes, seconds, milliseconds);
        }
        date.logicalTime = true;
        return date;
    },

    //> @classMethod Time.setShortDisplayFormat()
    // Sets the default format for strings returned by +link{Time.toShortTime()}.
    // @param formatter (TimeDisplayFormat | function) Optional custom formatter to use. Will accept
    //  a function (which will be passed a pointer to the date to perform the conversion), or
    //  a string designating a standard formatter
    // @visibility external
    //<
    setShortDisplayFormat : function (format) {
        this.shortDisplayFormat = format;
    },

    //> @classMethod Time.setNormalDisplayFormat()
    // Sets the default format for strings returned by +link{Time.toTime()}.
    // @param formatter (TimeDisplayFormat | function) Optional custom formatter to use. Will accept
    //  a function (which will be passed a pointer to the date to perform the conversion), or
    //  a string designating a standard formatter
    // @visibility external
    //<
    setNormalDisplayFormat : function (format) {
        this.displayFormat = format;
    },

    //> @classMethod Time.compareTimes()
    // Compares the times of 2 dates, or strings. If a string is passed as one of the
    // parameters it should be in a format that converts to a valid time such as <code>"1:30pm"</code>,
    // <code>"13:30"</code>, or <code>"1:30:45pm"</code>
    // @param time1 (Date|string) First time to compare
    // @param time2 (Date|string) Second time to compare
    // @return (boolean) True if the times match, false if not
    // @visibility external
    //<
    compareTimes : function (time1, time2) {
        // If this method becomes time-critical we could speed this up by avoiding the
        // date conversion and having parseInput return just an array of H,M,S
        if (isc.isA.String(time1)) time1 = isc.Time.parseInput(time1);
        if (isc.isA.String(time2)) time2 = isc.Time.parseInput(time2);

        if (time1 == null && time2 == null) return true;

        // If we get non-dates at this point just return false - we don't want to be
        // comparing other types
        if (!isc.isA.Date(time1) || !isc.isA.Date(time2)) return false;


        return ((time1.getUTCHours() == time2.getUTCHours()) &&
                (time1.getUTCMinutes() == time2.getUTCMinutes()) &&
                (time1.getUTCSeconds() == time2.getUTCSeconds()));

    },

    //> @classMethod Time.compareLogicalTimes()
    // Compare two times, normalizing out the date elements so that only the time elements are
    // considered; returns 0 if equal, -1 if the first time is greater (later), or 1 if
    // the second time is greater.
    //  @param  time1   (Date)  first time to compare
    //  @param  time2   (Date)  second time to compare
    //  @return (number)    0 if equal, -1 if first time &gt; second time, 1 if second time &gt;
    //                      first time.  Returns false if either argument is not a date
    //<
    compareLogicalTimes : function (time1, time2) {
        if (!isc.isA.Date(time1) || !isc.isA.Date(time2)) return false;

        time1 = isc.Date.getLogicalTimeOnly(time1);
        time2 = isc.Date.getLogicalTimeOnly(time2);

        var aHours = time1.getHours(),
            aMinutes = time1.getMinutes(),
            aSeconds = time1.getSeconds(),
            aMillis = time1.getMilliseconds();
        var bHours = time2.getHours(),
            bMinutes = time2.getMinutes(),
            bSeconds = time2.getSeconds(),
            bMillis = time2.getMilliseconds();
        var aval = aMillis + 1000 * (aSeconds + 60 * (aMinutes + 60 * aHours));
        var bval = bMillis + 1000 * (bSeconds + 60 * (bMinutes + 60 * bHours));
        return aval > bval ? -1 : (bval > aval ? 1 : 0);
    },

    _performDstInit : function () {
        var now = new Date(),
            january = new Date(0),
            july = new Date(0);

        // Daylight Saving Time involves moving the clock forward in order to shift some of
        // the daylight from very early morning (when most people are asleep) to mid-evening
        // (when people benefit from more hours of daylight, and energy can be saved that
        // would otherwise be needed for lighting).  Not every country observes DST, and those
        // countries that do observe it set their own start and end dates, though there are
        // common approaches - for example, many European countries start DST during the last
        // weekend of March and end it during the last weekend of October.
        //
        // Daylight Saving Time, if it is applicable at all, always starts sometime in spring
        // and ends ends sometime in autumn, but there is no more accurate rule than that.
        // Currently, every country that observes DST does so by moving their local time
        // forward by one hour; however, other values have been used, so this cannot be relied
        // upon either.
        //
        // It is common to transition to and from DST ar 02:00 local time - when
        // DST starts, the local time jumps instantly to 03:00, when DST ends it jumps
        // instantly back to 01:00.  However, this is again a common approach rather than a
        // rule.
        //
        // Note that it is important to think in terms of seasons rather than months, because
        // the northern and southern hemispheres have opposite seasons.  Hence DST (if it
        // applies at all) starts in March/April and ends in October/November in the northern
        // hemisphere, and does the exact opposite in the southern hemisphere.
        //
        // Because of all of this, and because the only timezone information you can retrieve
        // from a Javascript Date object is the number of minutes that particular date/time
        // is offset from UTC, we have quite limited information and must resort to roundabout
        // techniques.  We can discover if we are in a locale that observes DST by checking
        // the UTC offsets in January and July; if they are different, the current locale
        // observes DST.
        //
        // Going a step further than this, we can tell whether we are observing DST or normal
        // time on an arbitrary date: by looking to see whether the clock goes  forward or
        // backward in the early part of the year (spring in the northern hemisphere), we can
        // infer which hemisphere the current locale is in, and from that we can decide if
        // the offset in January is the DST or non-DST offset.  Then, we can check the offset
        // of the given date against the offset in January; if it matches then it is in DST
        // if we're in the southern hemisphere, and in normal time if we're in the northern
        // hemisphere.
        //
        // For more interesting information on this subject, see
        // http://www.timeanddate.com/time/aboutdst.html

        january.setUTCFullYear(now.getUTCFullYear());
        january.setUTCMonth(0);
        january.setUTCDate(1);
        july.setUTCFullYear(now.getUTCFullYear());
        july.setUTCMonth(6);
        july.setUTCDate(1);

        var nowOffset = now.getTimezoneOffset();
        this.januaryDstOffset = january.getTimezoneOffset();
        var julyOffset = july.getTimezoneOffset();

        this.dstDeltaMinutes = this.januaryDstOffset - julyOffset;
        if (this.dstDeltaMinutes > 0) {
            // Time is offset further forward from UTC in July; this locale observes DST
            // and is in the northern hemisphere (this logic is curiously backwards, because
            // getTimezoneOffset() returns negative numbers for positive offsets)
            this.southernHemisphere = false;
            this.adjustForDST = true;
            if (nowOffset == julyOffset) this.currentlyInDST = true;
        } else if (this.dstDeltaMinutes < 0) {
            // Time is offset further forward from UTC in January; this locale observes DST
            // and is in the southern hemisphere
            this.southernHemisphere = true;
            this.adjustForDST = true;
            if (nowOffset == this.januaryDstOffset) this.currentlyInDST = true;
        } else {
            // the delta is 0 and DST is not a factor in this locale
            this.adjustForDST = false;
        }

        // As noted above, all current observations of Daylight Saving Time involve moving
        // local time one hour forward, so right now these variables will always end up as
        // 1 and 0
        this.dstDeltaMinutes = Math.abs(this.dstDeltaMinutes);
        this.dstDeltaHours = Math.floor(this.dstDeltaMinutes / 60);
        this.dstDeltaMinutes -= (this.dstDeltaHours * 60);
    },

    getUTCHoursDisplayOffset : function (date, utcHoursDisplayOffset) {
        // If we're currently inside DST and wanting to calculate an offset for a datetime
        // that is outside DST, we need to move the offset backwards because the offset we
        // stored on the Time class during startup already includes the DST offset
        var dstDelta = this.currentlyInDST ? -(this.dstDeltaHours) : 0;
        if (this.adjustForDST) {
            if (date.getTimezoneOffset() == this.januaryDstOffset) {
                if (this.southernHemisphere) {
                    dstDelta += this.dstDeltaHours;
                }
            } else {
                if (!this.southernHemisphere) {
                    dstDelta += this.dstDeltaHours;
                }
            }
        }
        return (utcHoursDisplayOffset != null
                ? utcHoursDisplayOffset
                : this.UTCHoursDisplayOffset) + (this.adjustForDST ? dstDelta : 0);
    },

    getUTCMinutesDisplayOffset : function (date, utcMinutesDisplayOffset) {
        var dstDelta = this.currentlyInDST ? -(this.dstDeltaMinutes) : 0;
        if (this.adjustForDST) {
            if (date.getTimezoneOffset() == this.januaryDstOffset) {
                if (this.southernHemisphere) {
                    dstDelta += this.dstDeltaMinutes;
                }
            } else {
                if (!this.southernHemisphere) {
                    dstDelta += this.dstDeltaMinutes;
                }
            }
        }
        return (utcMinutesDisplayOffset != null
                ? utcMinutesDisplayOffset
                : this.UTCMinutesDisplayOffset) + (this.adjustForDST ? dstDelta : 0);
    }
});

// Work out whether we're currently inside Daylight Saving Time, and compute the offset to
// apply on the transition.
isc.Time._performDstInit();

// set up the default timezone offset based on the browser locale here.
isc.Time.setDefaultDisplayTimezone(new Date().getTimezoneOffset(), true);









// We add a few convenience methods on SmartClient instances so that they can
// reflect a little on their SmartGWT equivalents.
isc.Class.addProperties({
    // Returns the corresponding SmartGWT instance.
    getSGWTInstance : function () {
        return this[isc.gwtRef];
    },

    // Returns the SGWTModule which corresponds to the module that created
    // the SmartGWT instance
    getSGWTModule : function () {
        return this[isc.gwtModule];
    },

    getSGWTFactory : function () {
        var module = this.getSGWTModule();
        if (!module) return null;

        var instance = this.getSGWTInstance();
        if (!instance) return null;

        return module.getSGWTFactory(instance);
    },

    // Returns the fully-qualified Java class name of the SmartGWT instance.
    getSGWTClassName : function () {
        var factory = this.getSGWTFactory();
        if (!factory) {
            this.logWarn("Could not find the SGWTFactory for: " + this.echo(this));
            return null;
        }

        return factory.getClassName();
    },

    // Sets properties via the SmartGWT object, rather than directly. Of
    // course, the SmartGWT object will often eventually call back to set
    // properties on the SmartClient object. If we can't find a SmartGWT
    // object, we fall back to setProperties. Thus, you can call this and know
    // that the properties will be set, one way or the other.
    setSGWTProperties : function (json) {
        var factory = this.getSGWTFactory();
        if (factory) {
            factory.setSGWTProperties(this.getSGWTInstance(), json);
        } else {
            this.setProperties(json);
        }
    },

    // Gets an array of the names of SmartGWT properties (but not values). If
    // we can't find the SmartGWT object, we fall back to getAttributes, which
    // does the equivalent for SmartClient objects.
    getSGWTAttributes : function () {
        var factory = this.getSGWTFactory();
        if (factory) {
            return factory.getSGWTAttributes();
        } else {
            // Adapted from language/Reflection.js
            var list = [];
            for (var property in this) {
                if (typeof this[property] == "function") continue;
                if (property.charAt(0) == "_") continue;
                if (property == property.toUpperCase()) continue;
                list[list.length] = property;
            }
            return list;
        }
    },

    // Gets a single attribute value
    getSGWTProperty : function (property) {
        var module = this.getSGWTModule();
        if (module) {
            return module.getProperty(this.getSGWTInstance(), property);
        } else {
            return this.getProperty(property);
        }
    },

    // Gets a single attribute value as a string. Can be equivalent to
    // getSGWTProperty(prop).toString(). But, if there is more than one getter,
    // it will prefer the one that actually returns a string (e.g.
    // getWidthAsString)
    getSGWTPropertyAsString : function (property) {
        var module = this.getSGWTModule();
        if (module) {
            return module.getPropertyAsString(this.getSGWTInstance(), property);
        } else {
            // Note that when we're not dealing with SGWT objects, we just call
            // toString rather than looking for alternate methods. This isn't
            // ideal, since sometimes we might want an alternative method.
            // However, it isn't trivial to figure out which methods to choose.
            var result = this.getProperty(property);
            return result ? result.toString() : result;
        }
    }
});

// A factory class which knows how to produce SmartGWT objects, apply
// properties to them, get lists of their property names, and get the
// corresponding SmartClient instance.  SmartGWT creates an SGWTFactory
// instance for each SmartGWT BeanFactory. The SGWTFactory is stored in the
// isc[] space, as if it were a regular SmartClient class. In fact, calls to
// isc.ClassFactory.getClass(fullyQualifiedSmartGWTClassName) will return the
// SGWTFactory. So, SGWTFactory is a kind of sister-class to Class. This
// permits the autoChild process and creation via _constructor to work mostly
// unchanged where the autoChild or _constructor is specified as a
// fully-qualified SmartGWT class name. Calling code does have to be aware of
// SGWTFactory if using createRaw() rather than create() -- see below.
isc.defineClass("SGWTFactory");

isc.SGWTFactory.addClassProperties({
    // A marker that we use to identify config blocks for the createRaw() /
    // init() | completeCreation() cycle
    CONFIG_BLOCK: "sgwtConfigBlock",

    // The name of the property on the config block where init() |
    // completeCreation() stores the real object when called after createRaw()
    SC_INSTANCE: "smartclientInstance",

    // A marker on hashes in the isc[] space, to indicate that they represent
    // parts of bean class names ... e.g. "com" in com.mycompany.MyListGrid.
    BEAN_CLASS_PARTS: "beanClassParts",

    // Note that this only gets factories by name, and only those which have
    // been explicitly created by GWT.create on the SmartGWT side (rather than
    // merely having been creating for superclasses of those classes).
    //
    // If you have an existing object, then call getSGWTFactory on it instead,
    // since that will query class objects from the appropriate SGWT module,
    // possibly loaded separately with classes that possibly have the same
    // name.
    //
    // Thus, this function is really only for cases in which all you have is
    // a class name, and nothing else.
    getFactory : function (beanClassName) {
        if (!beanClassName) return null;
        var factory = isc[beanClassName];
        if (factory && isc.isA.SGWTFactory(factory)) {
            return factory;
        } else {
            return null;
        }
    },

    // This is a convenience function to help with the createRaw / (init |
    // completeCreation) cycle ... see below
    extractFromConfigBlock : function (sgwtConfigBlock) {
        if (sgwtConfigBlock[isc.SGWTFactory.CONFIG_BLOCK]) {
            // if it is a config block, extract the instance
            return sgwtConfigBlock[isc.SGWTFactory.SC_INSTANCE];
        } else {
            // Otherwise, return the "config block" itself, so we can call this
            // unconditionally with things that might not be config blocks
            return sgwtConfigBlock;
        }
    }
});

isc.SGWTFactory.addProperties({
    // These properties will be set by the SGWT BeanFactory when it creates
    // this SGWTFactory.

    // The fully-qualified SmartGWT class name: e.g. com.mycompany.MyListGrid
    // beanClassName: null,

    // The SGWTModule that corresopnds to this factory
    // sgwtModule: null,

    getClassName : function () {
        return this.beanClassName;
    },

    // Registers the class name in the isc[] space, so that getFactory() will
    // return it, and the following idioms will work (where _constructor is a
    // fully-qualified SmartGWT class name):
    //
    // isc[object._constructor].create(properties)
    // isc["com.mycompany.MyListGrid"].create(properties);
    //
    // Also, see the notes on createRaw() below -- this is also supported, but
    // the calling code needs to be aware of a few details.
    //
    // This is called from the SmartGWT side if GWT.create was used to make the
    // factory. It is not called if the factory was automatically created for
    // a superclass. That way, the developer controls which class names are
    // registered by which factories are explicitly instantiated by GWT.create.
    registerClassName : function () {
        // Wrap in an error handler, since we call this from SmartGWT
        try {
            // Check for collisions within isc[] This should be extremely rare,
            // as there is nothing typically in isc[] that would look like a
            // fully-qualified java name. But better safe than sorry! Note that
            // here we store the beanClassName as a single entry in isc[] --
            // that is, if beanClassName is "com.mycompany.MyListGrid" that
            // produces one entry in the hash (at top-level), despite the dots.
            // Below we do a little extra work so that
            // isc.com.mycompany.MyListGrid will also work.
            //
            // Note that we don't try to support simpleNames here, since we
            // wouldn't expect the developer to access any of this directly. We
            // could support simpleNames, at the cost of some increased
            // possibility of collision.
            var existingObject = isc[this.beanClassName];
            if (existingObject) {
                if (isc.isA.ClassObject(existingObject)) {
                    this.logWarn("beanClassName '" + this.beanClassName + "' collides with existing native " +
                                "SmartClient class with the same name. The bean will not be registered.");
                    return;
                } else if (isc.isA.SGWTFactory(existingObject)) {
                    this.logWarn("beanClassName '" + this.beanClassName + "' has already been registered. " +
                                "The existing bean will be replaced.");
                } else {
                    this.logWarn("beanClassName '" + this.beanClassName + "' collides with the ID of an existing " +
                                "object with value '" + this.echo(existingObject) +
                                "'. The bean will not be registered.");
                    return;
                }
            }

            // If the beanClassName has dots (which it should), then we also want
            // to make the following idiom work:
            //
            // isc.com.mycompany.MyListGrid.create(properties)
            //
            // Collisions within isc[] should still be rare. Generally speaking,
            // the first part of the java fully-qualified name will be a short word
            // with only lower-case letters. There are very few of those normally
            // within isc[] -- just:
            //
            // "ask", "auto", "clone", "colon", "confirm", "contains", "defer",
            // "dot", "echo", "eval", "is", "nbsp", "params", "px", "rpc", "say",
            // "semi", "slash", "star", "version", "warn", "xml", "xnbsp"
            //
            // Well, I suppose that's not such a short list. But none of them are
            // very likely candidates for the first part of a Java class name.
            //
            // An alternative would be to use "sgwt." as a prefix -- that way, we
            // would only reserve isc[sgwt]. Using "sgwt:" as the prefix would be
            // awkward, because then ...
            //
            // isc.sgwt:com.mycompany.MyListGrid.create()
            //
            // ... would no longer be legal code.
            var beanClassParts = this.beanClassName.split(".");
            if (beanClassParts.length > 1) {
                var base = isc;
                var breadCrumbs = "isc";

                // Note we're stopping at the second-last element, not the last
                for (var i = 0; i < beanClassParts.length - 1; i++) {
                    var part = beanClassParts[i]
                    var existingObject = base[part];
                    breadCrumbs = breadCrumbs + "." + part;

                    if (existingObject) {
                        // If it exists, make sure it's ours
                        if (!existingObject[isc.SGWTFactory.BEAN_CLASS_PARTS]) {
                            this.logWarn("beanClassName '" + this.beanClassName +
                                        "' collides with existing object located at '" + breadCrumbs +
                                        "' with value '" + this.echo(existingObject) +
                                        "'. The bean will not be registered.");
                            return;
                        }
                    } else {
                        // If it doesn't exist, then create it and mark it as ours,
                        // so we can check for collisions.
                        base[part] = {};
                        base[part][isc.SGWTFactory.BEAN_CLASS_PARTS] = true;
                    }

                    base = base[part];
                }

                // There can't be a collision at this stage, since we would have
                // caught it when checking the isc object itself.
                var lastPart = beanClassParts[beanClassParts.length - 1];
                base[lastPart] = this;
            }

            // Wait until here to actually store the proxy in the isc object, in
            // case we bail out
            isc[this.beanClassName] = this;
        }
        catch (e) {
            this.logError(e.message);
        }
    },

    // Returns a new SmartGWT instance. Note that this is an instance method,
    // not a class method. However, the semantics are the same as
    // isc.Class.create -- that is, the properties are the entire
    // initialization config, and we return a SmartClient object.
    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        //>EditMode
        // Capture clean initialization data, and don't construct the actual
        // instance.  This is used to load a set of components for editing.
        if (isc.captureDefaults) {
            var component = {
                type: this.Class,
                defaults: isc.addProperties({}, A,B,C,D,E,F,G,H,I,J,K,L,M)
            }
            if (!isc.capturedComponents) isc.capturedComponents = [];
            isc.capturedComponents.add(component);
            if (component.defaults.ID) {
                isc.ClassFactory.addGlobalID(component, component.defaults.ID);
                //isc.Log.logWarn("adding global component: " + component.defaults.ID);
            }
            return component;
        }
        //<EditMode

        var sgwtInstance = this.sgwtModule.newInstance(this.beanClassName);

        var properties = isc.addProperties({}, A,B,C,D,E,F,G,H,I,J,K,L,M);

        // Note that the SmartGWT side will set properties uknown to SmartGWT
        // on the SmartClient config block.
        this.setSGWTProperties(sgwtInstance, properties);

        // Of course, the semantics of "create" are to return the Smartclient
        // object, not the opaque SmartGWT object. So, we get or create it. At
        // this point, it's appropriate to call getOrCreateJsObj, because the
        // properties supplied to create are, by definition, all of the
        // creation properties.
        return this.getOrCreateJsObj(sgwtInstance);
    },

    // createRaw would be called on a normal SmartClient class as a highly
    // efficient way of creating an object -- typically followed by directly
    // setting some properties and then callling init(), or completeCreation(),
    // or _completeCreationWithDefaults(). The usual semantics are that
    // createRaw returns the SmartClient native object *itself*, but with no
    // initialization having been done. That won't exactly work if we're
    // creating a SmartGWT object, because SmartGWT defers creating the native
    // SmartClient object until it has collected the configuration, in order to
    // preserve the distinction between configuration and later changes.
    //
    // Thus, we can't return the ultimate SmartClient object without
    // initialization, since SmartGWT doesn't want to create it before
    // initialization. So, we'll return a special object whose purpose is to
    // collect configuration properties and then apply them lazily when the
    // native SmartClient object is actually created. Unfortunately, code
    // calling createRaw does need to be aware of this, because it needs to
    // explicitly dereference the SmartClient object. Fortunately, there aren't
    // that many usages of createRaw.
    createRaw : function () {
        var factory = this;

        // We return an object which will accept property assignments and then
        // lazily create the real Javascript object and return it. This
        // respects the *semantics* of createRaw, though it does not retain its
        // actual efficiency if what we are creating is a SmartGWT object.
        // However, the code calling createRaw does need to check whether to
        // dereference the real object after it is created.
        var sgwtConfigBlock = {
            getClass : function () {
                return isc[factory.beanClassName]
            },

            init : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
                isc.addProperties(this, A,B,C,D,E,F,G,H,I,J,K,L,M);

                // Self-destruct, since we don't want to pass "init" or
                // "completeCreation" as a property to create(). Note that
                // "this" is deliberate -- we're referring to our anonymous
                // config object.
                delete(this.init);
                delete(this.completeCreation);
                delete(this.getClass);
                delete(this[isc.SGWTFactory.CONFIG_BLOCK]);

                // SectionStack sets __ref to null when creating a
                // SectionHeader, to deal with some differences between the way
                // that SmartClient and SmartGWT manage SectionStackSection and
                // SectionHeader. But that doesn't make sense in this code
                // path, because here it is SmartGWT that actually handles the
                // creation.  So, we'll delete a null __ref if provided, and
                // let SmartGWT provide its own.
                if (this[isc.gwtRef] === null) delete this[isc.gwtRef];

                //>EditMode
                // Capture clean initialization data, and don't construct the actual
                // instance.  This is used to load a set of components for editing.
                if (isc.captureDefaults) {
                    var component = {
                        type: factory.beanClassName,
                        defaults: isc.addProperties({}, this)
                    }
                    if (!isc.capturedComponents) isc.capturedComponents = [];
                    isc.capturedComponents.add(component);
                    if (component.defaults.ID) {
                        isc.ClassFactory.addGlobalID(component, component.defaults.ID);
                        //isc.Log.logWarn("adding global component: " + component.defaults.ID);
                    }
                    this[isc.SGWTFactory.SC_INSTANCE] = component;
                    this[isc.SGWTFactory.CONFIG_BLOCK] = true;
                    return;
                }
                //<EditMode

                // Create the property that calling code will need to
                // dereference ... doesn't seem to be a way of avoiding that.
                // Again, note that "this" is deliberate.
                this[isc.SGWTFactory.SC_INSTANCE] = factory.create(this);

                // And add the marker back
                this[isc.SGWTFactory.CONFIG_BLOCK] = true;
            },

            // In the completeCreation case, we may get some extra properties
            // to apply. We just fall through to init above, after adding
            // the properties. Again, the use of "this" is deliberate.
            completeCreation : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
                this.init(A,B,C,D,E,F,G,H,I,J,K,L,M);
                return this[isc.SGWTFactory.SC_INSTANCE];
            }
        }

        // Add a marker so that we know it's a config block, rather than a
        // partially created SmartClient object
        sgwtConfigBlock[isc.SGWTFactory.CONFIG_BLOCK] = true;
        return sgwtConfigBlock;
    },

    // Apply json string or object properties to the specified sgwtInstance.
    setSGWTProperties : function (sgwtInstance, json) {
        if (json) {
            if (isc.isA.String(json)) {
                if (!(isc.startsWith(json, '(') && isc.endsWith(json, ')'))) {
                    json = '(' + json + ')';
                }
                json = isc.Class.evaluate(json);
            }

            for (var name in json) {
                this.sgwtModule.setProperty(sgwtInstance, name, json[name]);
            }
        }
    },

    // Returns the names of the properties of the beanClass as an array
    getSGWTAttributes : function () {
        return this.sgwtModule.getAttributes(this.beanClassName);
    },

    // Returns the property of the SGWT instance
    getSGWTProperty : function (sgwtInstance, property) {
        return this.sgwtModule.getProperty(sgwtInstance, property);
    },

    // Returns the property of the SGWT instance as a string, preferring
    // getters that natively return a string (if present)
    getSGWTPropertyAsString : function (sgwtInstance, property) {
        return this.sgwtModule.getPropertyAsString(sgwtInstance, property);
    },

    // If the passed object represents an SGWT instance, invoke it's
    // getOrCreateJsObj() method so that the SC object is returned.
    getOrCreateJsObj : function (sgwtInstance) {
        return this.sgwtModule.getOrCreateJsObj(sgwtInstance);
    }
});

isc.SGWTFactory.addProperties({
    // Synonym for "create", because isc.ClassFactory calls it
    newInstance : isc.SGWTFactory.getInstanceProperty("create")
});
isc.defineClass("PubSub");

isc.PubSub.addClassMethods({
    _subscriberRegistry : {},
    _nextSubscriptionId : 0,

    getSubscribers : function (channelName) {
        return (this._subscriberRegistry[channelName] = 
                this._subscriberRegistry[channelName] || []);
    },

    subscribe : function (channelName, target, callback) {
        var subscribers = this.getSubscribers(channelName), 
            subscriptionId = this._nextSubscriptionId++;

        subscribers.add({ subscriptionId: subscriptionId, target: target, callback: callback });
        return subscriptionId;
    },

    unsubscribe : function (channelName, subscriptionId) {
        var subscribers = this.getSubscribers(channelName);
        subscribers.remove(subscribers.find("subscriptionId", subscriptionId));
    },

    publish : function (channelName, data) {
        // dup to avoid concurrent modification during publish()
        var subscribers = this.getSubscribers(channelName).duplicate(); 
        for (var i = 0; i < subscribers.length; i++) {
            isc.Class.fireCallback(subscribers[i].callback, "data", [data], subscribers[i].target);
        }
    }
});











//>    @class    Page
//
//     Provides information about the page you're loaded in.  We define "page" here to be roughly
//     equivalent to the browser window or frame the libraries have been loaded in.
//
//  @treeLocation Client Reference/System
//  @visibility external
//<



//
//    Create the Page singleton object
//
isc.ClassFactory.defineClass("Page");


// define groups for documentation purposes
isc.Page.addClassProperties({

    _historyActions : [],

    // flag for whether page.onload has fired yet
    _doneLoading : false,

    //>    @classAttr    isc.Page.defaultUnsupportedBrowserURL   (URL : "[SKIN]/unsupported_browser.html" : IRWA)
    //      On a call to <code>Page.checkBrowserAndRedirect()</code>, if no explicit URL
    //      is passed in, and the browser is not supported by ISC, redirect to this URL.
    //
    // @group    files
    // @see Page.checkBrowserAndRedirect()
    // @visibility external
    //<
    //  Note all the default load_skin.js files will call this method and pass in an
    //  explicit URL for a page to redirect to.  This default is unlikely to be modified as
    //  it's easier to just modify the explicit URL passed in when the method is called.
    defaultUnsupportedBrowserURL : "[SKIN]/unsupported_browser.html",

    //>    @classAttr    isc.Page._directoryCache    (array : [] : IRW)
    //         URLs in our framework can have keywords embedded in them as
    //        [SKIN] or [ISOMORPHIC], etc.  This is where we store the expanded directory names.
    //        Use Page.getURL() to figure that out.
    //
    //        @group    files
    //         @see Page.setDirectories()
    //<
    _directoryCache : {},

    //> @classAttr Page.protocolURLs (Array of String : [...] : IRW)
    // If a URL provided to various Page APIs begins with one of these Strings, it is treated
    // as an absolute URL.
    // <P>
    // The default of protocols is:
    // <pre>
    //     ["http://","https://","file://","mailto:", "app-resource:", "data:"]
    // </pre>
    // .. and can be replaced via +link{class.addClassProperties,Page.addClassProperties()} or
    // via setting the global variable isc_protocolURLs before SmartClient loads.
    //
    // @group files
    // @see Page.getURL()
    // @visibility external
    //<
    // "app-resource:" used by apollo
    // "data:" allows base64 encoded images to be specified directly, in recent browsers
    protocolURLs : window.isc_protocolURLs || ["http://","https://","file://","mailto:", "app-resource:", "data:"],

    //>    @classAttr    isc.Page.textDirection    (TextDirection : (null) : IRW)
    //        What direction is text supposed to run?
    //            LTR (left to right, eg: English) or RTL (right to left, eg: Arabic)
    //        @group    textDirection
    //        @platformNotes    IE only
    //<
    textDirection:null, // don't remove: initalized to null so we will look up the value set in
                        // the body tag if it hasn't been set in our framework.

    //> @classAttr   isc.Page.pollPageSize (boolean : null : IRWA)
    // Advanced attribute which will cause SmartClient to constantly check for the introduction
    // of scrollbars due to resizing of native content by direct DOM manipulation, and
    // automatically adjust percent sized widgets if external code causes the browser window to
    // be resized.
    //<
    // Polling for changes in page size will also catch orientation changes. We use this
    // in MobileWebKit browsers


    //>    @type    Page.TextDirection
    // Specifies RTL or LTR direction for text -- IE5+ and FF1.5+ only
    LTR:"ltr",                                             //    @value    isc.Page.LTR        Show text left-to-right (eg: English)
    RTL:"rtl"                                            //    @value    isc.Page.RTL        Show text right-to-left (eg: Arabic)
    //            @group    appearance
    //<


});


isc.Page.addClassMethods({

//>    @classMethod    Page.finishedLoading()    (A)
// Routine called automatically by the EventHandler when the page finishes loading.
//        @group    eventHandling
//<
finishedLoading : function () {

    isc.Page._doneLoading = true;
    isc.Log.logInfo("isc.Page is loaded");

    // kick off the idle timer when the page starts
    isc.EH.startIdleTimer();


    if (isc.Browser.isSafari) isc.Canvas.clearCSSCaches();

    // Open the log window if it should be open
    if (!window.suppressAutoLogWindow) {
        var cookie = isc.LogViewer.getLogCookie();
        if (cookie != null && cookie.keepOpen) {
            // NOTE: wait until any existing log window has had time to reconnect before
            // auto-opening the log window
            isc.Timer.setTimeout("isc.Log.show(true)", 1000);
        }
    }


    // If deprecated UTCHoursOffset has been set for the page, respect it (but log a warning)

    if (isc.Time && isc.Time.UTCHoursOffset != null) {
        isc.logWarn("This application includes code to set the Time.UTCHoursOffset attribute. " +
            "This property will be respected but has been deprecated in favor of the " +
            "classMethod isc.Time.setDefaultDisplayTimezone().");
        // respect it anyway
        isc.Time.setDefaultDisplayTimezone(isc.Time.UTCHoursOffset.stringify() + ":00");
    }

    // If we're polling for page size changes, kick this off now.
    if (isc.Page.pollPageSize) {
        isc.EH._pageResize();

    // Otherwise we've seen a case in some browsers where the scroll size is not calculated
    // correctly on initial draw from clean cache - force a single pageResize event on
    // a delay to fix this if necessary

    } else {
        isc.EH.delayCall("_pageResize", [true],  200);
    }


    if (isc.Browser.isIE) { isc.Class.evaluate("1", null, false, true); }
},

//>    @classMethod    Page.isLoaded()
//        Has the page finished loading?
//
//        @return    (Boolean)        true == page is done loading
// @visibility external
//<
isLoaded : function () { return this._doneLoading },

// return the URL that should be used for an IFRAME that should be blank
getBlankFrameURL : function () {



    if (isc.Browser.isIE && ("https:" == window.location.protocol || document.domain != location.hostname )) {
        // In IE under HTTPS, using "about:blank" as the location for an IFRAME causes a bogus "Mix
        // of secure and insecure content" dialog, so instead fetch an empty html file.
        return this.getURL("[HELPERS]empty.html");
    }
    // known to work in IE, Moz, Safari
    return "about:blank";
},


//>    @classMethod    Page.setTitle()
//        Set the title of the page, which is typically shown as part of the browser window title
// @visibility external
//<
// Doesn't actually update the browser window title in IE.
setTitle : function (title) {
    document.title = title;
},

//>    @classMethod    Page.setDirectories()
//        Set any and all of the directories that the page keeps track of in a single call.
//
//        @param    [directories]    (object)    Object of {directory:URL} paths.
//                                If not specified, we will try to get directories specified in the window objecs.
//        @group    files, images
//<
setDirectories : function (directories) {
    if (directories == null) {
        directories = {
            imgDir:window.imgDir,
            isomorphicDir:(window.isomorphicDir ? window.isomorphicDir : window.IsomorphicDir),
            isomorphicClientDir:window.isomorphicClientDir,
            isomorphicDocsDir:window.isomorphicDocsDir,
            skinDir:window.skinDir,
            helperDir:window.helperDir
        }
    }

    this._deriveAppDir();

    this.setIsomorphicDir(directories.isomorphicDir);
    this.setIsomorphicClientDir(directories.isomorphicClientDir);
    this.setIsomorphicDocsDir(directories.isomorphicDocsDir);
    this.setAppImgDir(directories.imgDir);
    this.setSkinDir(directories.skinDir);
    this.setHelperDir(directories.helperDir);
},


// derive the base URL of the application.
_deriveAppDir : function () {

    // get the path to the current file and strip off any query params and leaf file names
    var filePath = window.location.href;
    // strip off anything after a "?"
    if (filePath.contains("?")) filePath = filePath.substring(0,filePath.indexOf("?"));
    // # references node IDs which, according to the W3C cannot have slashes in them, but in
    // the AJAX world, # refs are often used to provide back button support rather than
    // actually reference any node ids in the DOM, so it's best that we don't break if # refs
    // contain slashes in the value.
    if (filePath.contains("#")) filePath = filePath.substring(0,filePath.indexOf("#"));
    // strip off the leaf file name if one exists
    if (filePath.charAt(filePath.length-1) != "/") {
        filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
    }

    this._directoryCache.APP = filePath;

    //>DEBUG
    if (this.logIsInfoEnabled()) {
        this.logInfo("app dir is " + this._directoryCache.APP);
    }
    //<DEBUG

    // call getAppImgDir() so it will change based on the changed app dir...
    this.setAppImgDir();
},

//>    @classMethod    Page.getAppDir()
// Returns the base URL of the application, which is the page URL minus the last non-directory
// path component.  For example, if the page is loaded from
// <code>http://foo.com/bar/zoo.jsp</code>, appDir will be <code>http://foo.com/bar/</code>.
// <P>
// If other page-wide URLs such as +link{Page.setIsomorphicDir()} are specified as
// relative paths, they are considered relative to this URL.
//
//        @return    (string)    URL for page-specific files.
//        @group    files
// @visibility external
//<
getAppDir : function () {
    return this._directoryCache.APP;
},

//    Application-specific resource directories
// ---------------------------------------------------------------------------------------

//>    @classMethod    Page.setAppImgDir()
// Specify the directory for app-specific images.
// <P>
// This becomes the default location where any SmartClient component will load images from
// unless the special "[SKIN]" prefix is used to indicate that an image is part of a skin.
// <P>
// Default is "[APP]images/"
//
//        @param    [URL]        (string)    New imgDir URL.
//        @group    files, images
// @visibility external
//<
// NOTE: Caches the combined appDir + imgDir.
setAppImgDir : function (URL) {
    // If the URL passed in is not absolute, explicitly combine it with the app dir
    // This means if we generate Img HTML and end up showing it in another frame it'll still
    // pick up the correct image (required for EG printing support)
    this._directoryCache.APPIMG =
            this.combineURLs(this.getAppDir(), URL != null ? URL : "[APP]images/");
},

//>    @classMethod    Page.getAppImgDir()
// Return the directory for app-specific images.
//
//        @return    (string)    URL for page-specific images.
//        @group    files, images
// @visibility external
//<
getAppImgDir : function (imgDir) {
    // specifically check for an imgDir that has been specified as an absolute path.
    if ( imgDir != null &&
          (isc.startsWith(imgDir, isc.slash) ||
           this.getProtocol(imgDir) != isc.emptyString ))
    {
        return imgDir;
    }

    if (imgDir) return this._directoryCache.APPIMG + imgDir;
    else return this._directoryCache.APPIMG;
},

//>    @classMethod    Page.setAppFilesDir()
// Specify the directory for miscellaneous app-specific files <b>other than</b> images, such as
// +link{HTMLFlow.contentsURL,HTML fragments}, +link{ViewLoader,loadable views},
// XML or JSON flat data files, videos, etc.
// <P>
// This URL also becomes available via the prefix "[APPFILES]" for +link{rpcRequest.actionURL}.
// <P>
// Defaults to the value of +link{Page.getAppDir()}, that is, the current directory.
//
//        @param    [URL]        (string)    New app files URL.
//        @group    files, images
// @visibility external
//<
// NOTE: Caches the combined appDir + imgDir.
setAppFilesDir : function (URL) {
    this._directoryCache.APPFILES = this.combineURLs(this.getAppDir(), URL);
},

//>    @classMethod    Page.getAppFilesDir()
// Returns the directory for application-specific files (other than images).
//
//        @param    [URL]        (string)    New app files URL.
//        @group    files, images
// @visibility external
//<
getAppFilesDir : function (URL) {
    return this._directoryCache.APPFILES;
},

//    Isomorphic-supplied file locations
// ---------------------------------------------------------------------------------------

//>    @classMethod    Page.setIsomorphicDir()
//        Specify the root directory for Isomorphic-supplied files.
//
//        @param    [URL]        (string)    New IsomorphicDir URL.
//        @group    files
// @visibility external
//<
setIsomorphicDir : function (URL) {
    this._directoryCache.ISOMORPHIC =
            this.combineURLs(this.getAppDir(), URL != null ? URL : "../isomorphic/");

    // call setSkinDir() and setHelperDir() to reset those cached values
    this.setIsomorphicClientDir();
    this.setIsomorphicDocsDir();
},

//>    @classMethod    Page.getIsomorphicDir()
//        Return the root directory for Isomorphic-specific files.
//
//        @return    (string)    IsomorphicDir URL.
//        @group    files
// @visibility external
//<
getIsomorphicDir : function () {
    return this._directoryCache.ISOMORPHIC;
},

// Note skins groupDef is in Canvas.js

//>    @classMethod    Page.setSkinDir()
//        Specify the URL for media that's part of the skin
//
//        @param    [URL]        (string)    New skinDir URL
//        @group    skins, files, images
// @visibility external
//<
setSkinDir : function (URL) {
    this._directoryCache.SKIN =
            this.combineURLs(this.getAppDir(), URL != null ? URL : "[ISOMORPHIC]/skins/standard/");
    // remember the skin image directory
    this._directoryCache.SKINIMG = this._directoryCache.SKIN + "images/";

    if (isc.Canvas) isc.Canvas._blankTemplate = isc.Canvas._blankURL = null;
},

//>    @classMethod    Page.getSkinDir()
//        Return the directory for media that's part of the skin
//
//        @return    (string)    base URL for skin media
//        @group    files, images
// @visibility external
//<
getSkinDir : function () {
    return this._directoryCache.SKIN;
},


//>    @classMethod    Page.getSkinImgDir()
//        Return the directory for a skin image.
//
//        @param    [imgDir]    (URL)        Partial URL (relative to Page._skinDir) where the image lives.
//                                        If not supplied, will use "images/"
//        @return                (string)    URL for page-specific images.
//        @group    files, images
// @visibility external
//<
getSkinImgDir : function (imgDir) {
    if (imgDir == null) return this._directoryCache.SKINIMG;
    return this.combineURLs(this._directoryCache.SKIN, imgDir);
},

// Internal directory structures
// ---------------------------------------------------------------------------------------
// Applications need to tell us the relative path to the "isomorphic/" directory and may
// relocate the skin outside of the "isomorphic/" area, however, none of the rest of
// the structure under "isomorphic/" is really intended to be changed.  The most likely reason
// to actually do so might involve needing to move the helpers dir to password protect the log
// window.

//>    @classMethod    Page.setIsomorphicClientDir()
//        Specify the root directory for Isomorphic client files.
//
//        @param    [URL]        (string)    New URL for root of client files.
//        @group    files
//<
// NOTE: not visible: we don't actually want customers to relocate the client dir
setIsomorphicClientDir : function (URL) {
    this._directoryCache.ISOMORPHIC_CLIENT =
            this.combineURLs(this.getAppDir(), URL != null ? URL : "[ISOMORPHIC]/system/");

    // call setSkinDir() and setHelperDir() to reset those cached values
    this.setSkinDir();
    this.setHelperDir();
},

//>    @classMethod    Page.getIsomorphicClientDir()
//        Return the root directory for Isomorphic client files.
//
//        @return    (string)    URL for root of client files.
//        @group    files
//<
getIsomorphicClientDir : function () {
    return this._directoryCache.ISOMORPHIC_CLIENT;
},

//>    @classMethod    Page.setIsomorphicDocsDir()
//        Specify the root directory for Isomorphic documentation and example files.
//
//        @param    [URL]        (string)    New URL for root of documentatio