var initialLayoutStyle = "vertical";

var suppliesForm = isc.DynamicForm.create({
    ID: "selectedSupplyItems",
    colWidths: [500, 120],
    cellPadding: 15,
    titleOrientation: "top",
    fields: [{
        name: "supplies",
        title: "Items",
        editorType: "MultiComboBoxItem",
        optionDataSource: "supplyItem",
        displayField: "itemName",
        valueField: "itemID",
        value: [1, 10, 23, 123],
        autoFetchData: true,
        layoutStyle: initialLayoutStyle
    }, {
        type: "spacer"
    }, {
        type: "spacer"
    }, {
        title: "Change layout style",
        type: "select",
        shouldSaveValue: false,
        defaultValue: initialLayoutStyle,
        valueMap: ["flow", "horizontal", "horizontalReverse", "vertical", "verticalReverse"],
        changed: function (form, item, value) {
            form.getField("supplies").setLayoutStyle(value);
        }
    }]
});
