/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.log.RevolvingMemoryAppender;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.IImageExporter;
import com.isomorphic.rpc.IPdfExporter;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.taglib.LoadWSDLTag;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import com.isomorphic.xml.XMLParsingException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Level;

public class BuiltinRPC
extends Base {
    protected static Logger log = new Logger(BuiltinRPC.class.getName());
    public static String cssStylenameSuffix = "$style";

    public static void downloadWSDL(String url, String format, String fileName, RPCManager rpc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders(response);
        response.setContentType(DataTools.mimeTypeForFileName(fileName));
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", fileName));
        XML.loadWSDL(LoadWSDLTag.getAbsoluteURL(url, null), format, response.getWriter());
    }

    public static void downloadClientContent(String fileContents, String fileName, String mimeType, RPCManager rpc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        rpc.doCustomResponse();
        RequestContext.setNoCacheHeaders(response);
        response.setContentType(mimeType);
        response.addHeader("content-disposition", "attachment; " + rpc.encodeParameter("fileName", fileName));
        PrintWriter writer = response.getWriter();
        if (log.isDebugEnabled()) {
            log.debug("downloadClientContent() writing fileContents: " + fileContents);
        }
        ((Writer)writer).write(fileContents);
        ((Writer)writer).flush();
        ((Writer)writer).close();
    }

    public static RPCResponse xmlToJS(String xmlString) throws Exception {
        StringWriter out = new StringWriter();
        try {
            XML.toJS(new StringReader(xmlString), (Writer)out);
        }
        catch (XMLParsingException e) {
            log.info("Error parsing inbound XML - assuming multiple top-level elements and retrying with wrapper tag.");
            SequenceReader reader = new SequenceReader("<isomorphicXML xmlns:xsi=\"nativeType\">", new StringReader(xmlString), "</isomorphicXML>");
            out = new StringWriter();
            XML.toJS(reader, (Writer)out);
        }
        return new RPCResponse(out.toString());
    }

    public static RPCResponse uploadProgressCheck(HttpSession session, String formID) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        responseData.put("formID", formID);
        List errors = (List)session.getAttribute("errors");
        if (errors != null) {
            responseData.put("errors", errors);
        }
        responseData.put("bytesSoFar", session.getAttribute("bytesSoFar"));
        responseData.put("totalBytes", session.getAttribute("totalBytes"));
        return new RPCResponse(responseData);
    }

    public static RPCResponse deleteFile(String path) throws Exception {
        path = ISCFile.canonicalizePath(Config.expandPathVariables(path));
        log.debug("Deleting: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse saveFile(String path, String data) throws Exception {
        path = ISCFile.canonicalizePath(Config.expandPathVariables(path));
        log.debug("Saving: " + path);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        } else {
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse appendToFile(String path, String data) throws Exception {
        path = ISCFile.canonicalizePath(Config.expandPathVariables(path));
        log.debug("Appending to: " + path);
        File file = new File(path);
        IOUtil.copyCharacterStreams(new StringReader(data), new FileWriter(file, true));
        RPCResponse response = new RPCResponse();
        return response;
    }

    public static RPCResponse loadFile(String path) throws Exception {
        path = ISCFile.canonicalizePath(Config.expandPathVariables(path));
        log.debug("Loading: " + path);
        File file = new File(path);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(new FileReader(file), sw);
        RPCResponse response = new RPCResponse();
        response.setData(sw.toString());
        return response;
    }

    public static Map getAvailableScriptEngines() throws Exception {
        return Scripting.getAvailableScriptEngines();
    }

    public static RPCResponse evalGroovyScript(DataTypeMap data) throws Exception {
        return Scripting.evalGroovyScript(data);
    }

    public static RPCResponse evalServerScript(DataTypeMap data) throws Exception {
        return Scripting.evalServerScript(data);
    }

    public static RPCResponse devConsoleEvalServerScript(RequestContext context, DataTypeMap data) throws Exception {
        return Scripting.devConsoleEvalServerScript(context, data);
    }

    public static RPCResponse evalJava(String javaCode, RequestContext context) throws Exception {
        if (ISCFile.inContainerIOMode()) {
            throw new Exception("Can't execute Java code in container-IO mode - to fix, explicitly set webRoot in server.properties");
        }
        String webRoot = config.getPath("webRoot");
        String tmpPath = "/tools/devConsoleEval.jsp";
        File tmpJSP = new File(webRoot + tmpPath);
        if (tmpJSP.exists()) {
            tmpJSP.delete();
        }
        tmpJSP.createNewFile();
        File header = new File(webRoot + "/shared/jsp/evalJavaHeader.jsp");
        File footer = new File(webRoot + "/shared/jsp/evalJavaFooter.jsp");
        FileWriter fw = new FileWriter(tmpJSP);
        if (header.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(header), fw);
        }
        IOUtil.copyCharacterStreams(new StringReader(javaCode), fw);
        if (footer.exists()) {
            IOUtil.copyCharacterStreams(new FileReader(footer), fw);
        }
        ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
        ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(context.response, new ProxyServletOutputStream(wrapBuf), "evalJava");
        RPCResponse response = new RPCResponse();
        try {
            ServletTools.include(context.servletContext, (ServletRequest)context.request, (ServletResponse)wrapResponse, tmpPath);
            try {
                wrapResponse.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            wrapBuf.flush();
            response.setData(wrapBuf.toString());
            response.setStatus(RPCResponse.STATUS_SUCCESS);
        }
        catch (Throwable t) {
            response.setData(t.toString());
            response.setStatus(RPCResponse.STATUS_FAILURE);
        }
        return response;
    }

    public static RPCResponse loadSharedXML(String type, String ID) throws Exception {
        boolean returnXML = true;
        boolean returnJS = true;
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        try {
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("loadSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            log.debug("loadSharedXML - loading from path: " + path);
            if (path == null) {
                throw new Exception("Can't find " + type + " " + ID);
            }
            ISCFile file = new ISCFile(path);
            if (!file.exists()) {
                throw new Exception("Can't find " + type + " " + ID);
            }
            String xml = DataTools.fileContentsAsString(file);
            if (returnXML) {
                responseData.put("xml", xml);
            }
            if (returnJS) {
                StringReader reader = new StringReader(xml);
                StringWriter sw = new StringWriter();
                XML.toJS(reader, (Writer)sw);
                responseData.put("js", sw.toString());
            }
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    public static RPCResponse saveSharedXML(String type, String ID, String contents) throws Exception {
        HashMap<String, String> responseData = new HashMap<String, String>();
        responseData.put("type", type);
        responseData.put("ID", ID);
        Object error = null;
        try {
            if (ISCFile.inContainerIOMode()) {
                throw new Exception("SmartClient server running in Container-IO mode - unable to save.");
            }
            String typeName = BuiltinRPC.getTypeNameForExtension(type);
            if (typeName == null) {
                throw new Exception("Unknown type: " + type);
            }
            log.debug("saveSharedXML - ID: " + ID + " typeName: " + typeName + " type: " + type);
            String path = DataStructCache.getInstanceFile(ID, typeName, type);
            if (path == null) {
                List paths = config.getCommaSeparatedList("project." + typeName);
                path = (String)paths.get(0);
                if (path == null) {
                    throw new Exception("Unable to determine default storage path for type: " + type + " was looking for config param: project." + typeName);
                }
                path = path + "/" + ID + "." + type.toLowerCase() + ".xml";
            }
            log.warn("Saving " + type + " " + ID + " at location: " + path);
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            IOUtil.copyCharacterStreams(new StringReader(contents), new FileWriter(file));
        }
        catch (Exception e) {
            responseData.put("error", e.toString());
        }
        return new RPCResponse(responseData);
    }

    private static String getTypeNameForExtension(String type) {
        String typeName = null;
        if ("DS".equals(type)) {
            typeName = "datasources";
        } else if ("APP".equals(type)) {
            typeName = "apps";
        } else if ("UI".equals(type)) {
            typeName = "ui";
        }
        return typeName;
    }

    public static List getLogNames() throws Exception {
        return RevolvingMemoryAppender.getLogNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLogEntries(String logName) throws Exception {
        ArrayList logEntries;
        ArrayList arrayList = logEntries = RevolvingMemoryAppender.getLogEntries(logName);
        synchronized (arrayList) {
            logEntries = new ArrayList(logEntries);
        }
        return logEntries;
    }

    public static void setLogThreshold(String category, String threshold) {
        Logger.getHierarchy().getLogger(category).setLevel(Level.toLevel((String)threshold));
        log.info("Category " + category + " now at: " + threshold);
    }

    public static List getLogThresholds() {
        ArrayList<Map> loggers = new ArrayList<Map>();
        Enumeration e = Logger.getHierarchy().getCurrentLoggers();
        while (e.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)e.nextElement();
            if (logger.getLevel() == null) continue;
            loggers.add(DataTools.buildMap("category", logger.getName(), "threshold", logger.getLevel().toString()));
        }
        return loggers;
    }

    public static void downloadClientExport(List records, String format, String fileName, String exportDisplay, Map settings, HttpServletResponse response, RPCManager rpc, RPCRequest request) throws Exception {
        if (settings == null) {
            settings = new HashMap<String, String>();
        }
        if (format == null) {
            format = (String)settings.get("exportAs");
        } else {
            settings.put("exportAs", format);
        }
        if ("json".equals(format)) {
            log.warn("Client request for 'json' format data export is not allowed for security reasons - using CSV instead");
            format = "csv";
        }
        if (log.isInfoEnabled()) {
            log.info("Export data passed to server:\n" + DataTools.prettyPrint(records));
        }
        rpc.doCustomResponse();
        boolean toClient = DataTools.getBoolean(settings, "exportToClient", true);
        boolean toFilesystem = DataTools.getBoolean(settings, "exportToFilesystem", false);
        if (toClient || toFilesystem) {
            Object os1 = null;
            BufferedOutputStream os2 = null;
            if (fileName == null) {
                fileName = (String)settings.get("exportFilename");
            }
            if (fileName != null && fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
            if (fileName == null) {
                fileName = "export";
            }
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + (format.equals("ooxml") ? "xlsx" : format);
            }
            if (records instanceof List && records.size() > 0) {
                int contentLength;
                String qname;
                block34: {
                    if (toClient) {
                        String mimeType = DataExport.getMimeTypeForFormat(format);
                        String fileNameEncoding = rpc.encodeParameter("fileName", fileName);
                        if (exportDisplay.equals("download")) {
                            response.addHeader("content-disposition", "attachment; " + fileNameEncoding);
                            response.setContentType(mimeType);
                        } else {
                            response.addHeader("content-disposition", "inline; " + fileNameEncoding);
                        }
                        os1 = response.getOutputStream();
                    }
                    qname = config.getPath("export.location");
                    if (!config.getBoolean((Object)"export.allow.filesystem", false) && toFilesystem) {
                        log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                        toFilesystem = false;
                    } else if (toFilesystem) {
                        String path;
                        if (qname == null) {
                            qname = "";
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if ((path = (String)settings.get("exportPath")) != null) {
                            qname = qname + path;
                        }
                        if (!qname.endsWith("/") && qname.length() > 0) {
                            qname = qname + "/";
                        }
                        if (fileName != null) {
                            qname = qname + fileName;
                        }
                        if (os1 == null) {
                            os1 = new BufferedOutputStream(new FileOutputStream(qname));
                        } else {
                            os2 = new BufferedOutputStream(new FileOutputStream(qname));
                        }
                    }
                    List rows = records;
                    log.info("Generating and streaming " + format + " file...");
                    Map firstRow = (Map)rows.get(0);
                    ArrayList<String> columns = new ArrayList<String>();
                    HashMap<String, String> fieldMap = new HashMap<String, String>();
                    String separator = (String)settings.get("exportTitleSeparatorChar");
                    if (separator == null) {
                        separator = "";
                    }
                    for (String column : firstRow.keySet()) {
                        if (!"xls".equals(format) && !"ooxml".equals(format) && column.endsWith(cssStylenameSuffix)) continue;
                        String fieldTitle = column;
                        if (format.equals("xml")) {
                            fieldTitle = fieldTitle.replaceAll("[$&<>()\"'\\n ]", separator);
                        }
                        fieldMap.put(column, fieldTitle);
                        columns.add(column);
                    }
                    if (settings.get("exportFields") == null) {
                        settings.put("exportFields", (String)((Object)columns));
                    }
                    DataExport exportObj = DataExport.getDataExport(settings);
                    contentLength = 0;
                    try {
                        contentLength = exportObj.exportResultSet(rows.iterator(), fieldMap, (OutputStream)os1, os2, null);
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception during export - continuing anyway to avoid sending the client to a blank screen", e);
                        if (!toClient) break block34;
                        response.getOutputStream().print("  *** Exception during export - please check server logs ***");
                    }
                }
                if (toClient) {
                    response.setContentLength(contentLength);
                } else {
                    BuiltinRPC.writeResponse(RPCResponse.STATUS_SUCCESS, "Successfully exported " + qname, response);
                }
                return;
            }
            log.warn("Provided data was null or empty - abandoning");
            if (!toClient) {
                BuiltinRPC.writeResponse(RPCResponse.STATUS_FAILURE, "Provided data was null or empty - abandoning", response);
            }
        } else {
            log.warn("Export requested, but neither client nor filesystem specified - doing nothing");
            BuiltinRPC.writeResponse(RPCResponse.STATUS_FAILURE, "Export requested, but neither client nor filesystem specified - we did nothing", response);
        }
    }

    private static void writeResponse(int status, String data, HttpServletResponse response) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        HashMap<String, Object> clientResponse = new HashMap<String, Object>();
        clientResponse.put("status", status);
        clientResponse.put("data", data);
        PrintWriter w = response.getWriter();
        ((Writer)w).write("//isc_RPCResponseStart-->");
        jsTrans.toJS(clientResponse, w);
        ((Writer)w).write("//isc_RPCResponseEnd");
    }

    public static void getPdfObject(String html, Map settings, HttpServletResponse response, RPCManager rpc) throws Exception {
        IPdfExporter pdfFactory = (IPdfExporter)InterfaceProvider.load("IPdfExporter");
        pdfFactory.getPdfObject(html, settings, response, rpc);
    }

    public static RPCResponse exportImage(String svgString, Map settings, HttpServletResponse response, RPCManager rpc) throws Exception {
        Object os;
        String usedFormat;
        if (settings == null) {
            settings = Collections.EMPTY_MAP;
        }
        IImageExporter imageExporter = (IImageExporter)InterfaceProvider.load("IImageExporter");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String imageFormat = (String)settings.get("exportImageFormat");
        if (imageFormat == null || "png".equals(imageFormat)) {
            imageExporter.writePNG(baos, svgString);
            usedFormat = "png";
        } else if ("jpeg".equals(imageFormat)) {
            double quality = DataTools.asDouble(settings.get("exportImageQuality"));
            Float qualityF = Double.isNaN(quality) || quality < 0.0 || 1.0 < quality ? null : Float.valueOf((float)quality);
            imageExporter.writeJPEG(baos, svgString, qualityF);
            usedFormat = "jpeg";
        } else {
            throw new Exception("Unsupported export image format '" + imageFormat + "'");
        }
        String exportDisplay = (String)settings.get("exportDisplay");
        if ("return".equals(exportDisplay)) {
            HashMap<String, String> responseData = new HashMap<String, String>();
            String encodedImageData = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
            responseData.put("usedFormat", usedFormat);
            responseData.put("base64", encodedImageData);
            RPCResponse rpcResponse = new RPCResponse(responseData);
            rpcResponse.setStatus(RPCResponse.STATUS_SUCCESS);
            return rpcResponse;
        }
        rpc.doCustomResponse();
        String fileName = (String)settings.get("exportFilename");
        if (fileName != null && fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if (fileName == null) {
            fileName = "image";
        }
        if (fileName.lastIndexOf(".") == -1) {
            fileName = fileName + "." + usedFormat;
        }
        boolean toFilesystem = DataTools.getBoolean(settings, "exportToFilesystem", false);
        String qname = config.getPath("export.location");
        if (toFilesystem) {
            String path;
            List enabledBuiltinMethods = config.getList("RPCManager.enabledBuiltinMethods");
            if (!enabledBuiltinMethods.contains("saveFile") && !enabledBuiltinMethods.contains("*")) {
                throw new Exception("Attempt to execute RPC DMI Builtin 'exportImage' in a way that saves to the filesystem DENIED by server.properties configuration.  To enable saving exported images to the filesystem, add 'saveFile' to the list of methods under RPCManager.enabledBuiltinMethods in server.properties");
            }
            if (qname == null) {
                qname = "";
            }
            if (!qname.endsWith("/") && qname.length() > 0) {
                qname = qname + "/";
            }
            if ((path = (String)settings.get("exportPath")) != null) {
                qname = qname + path;
            }
            if (!qname.endsWith("/") && qname.length() > 0) {
                qname = qname + "/";
            }
            if (fileName != null) {
                qname = qname + fileName;
            }
            os = new FileOutputStream(qname);
        } else {
            String mimeType = DataExport.getMimeTypeForImageFormat(usedFormat);
            response.setContentType(mimeType);
            String encodedFileNameParam = rpc.encodeParameter("fileName", fileName);
            if ("download".equals(exportDisplay)) {
                response.addHeader("content-disposition", "attachment; " + encodedFileNameParam);
            } else {
                response.addHeader("content-disposition", "inline; " + encodedFileNameParam);
            }
            os = response.getOutputStream();
        }
        baos.writeTo((OutputStream)os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        return null;
    }

    public static RPCResponse areServerTimingsTracked(HttpServletRequest req) {
        Boolean tracked = (Boolean)req.getSession().getAttribute("__isc_trackServerTimings");
        if (tracked == null) {
            tracked = config.getBoolean((Object)"DSRequest.returnTimingData", false);
        }
        return new RPCResponse(tracked);
    }

    public static RPCResponse trackServerTimings(boolean track, HttpServletRequest req) {
        req.getSession().setAttribute("__isc_trackServerTimings", (Object)track);
        return new RPCResponse(track);
    }
}

