/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public class ScreenLoaderServlet
extends BaseServlet {
    public static final String PARAM_SCREEN_NAME = "screenName";
    public static final String PROJECT_UI = "project.ui";
    public static final String PARAM_STRUCTURED_RESPONSE = "structuredResponse";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("application/javascript;charset=" + encoding);
        } else {
            response.setContentType("application/javascript");
        }
        Locale locale = null;
        String localeName = request.getParameter("locale");
        if (localeName != null && (locale = DataTools.deriveLocaleFromName(localeName)) == null) {
            this.log.warn("Locale name " + localeName + " is not valid - ignoring");
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        try {
            StringWriter writer = new StringWriter();
            String screenNames = request.getParameter(PARAM_SCREEN_NAME);
            if (screenNames == null) {
                this.log.warn("Parameter \"screenName\" is not specified.");
            } else if ("".equals(screenNames.trim())) {
                this.log.warn("No data specified in parameter \"screenName\".");
            } else {
                this.log.debug("Requested screens:" + screenNames);
                if (request.getParameter(PARAM_STRUCTURED_RESPONSE) == null) {
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        this.log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = ScreenLoaderServlet.loadScreen(screenName, locale);
                                if (screen == null) {
                                    this.log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write(screen.toString());
                                ((Writer)writer).write("\r\n");
                            }
                            catch (Exception ex) {
                                this.log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        this.log.warn("Empty string specified as screen name. Skipping.");
                    }
                } else {
                    ((Writer)writer).write("{\n\r");
                    ((Writer)writer).write("  screens: [\n\r");
                    int separator = 32;
                    for (String screenName : DataTools.commaSeparatedStringToList(screenNames)) {
                        screenName = screenName.trim();
                        this.log.debug("Processing screen \"" + screenName + "\".");
                        if (!"".equals(screenName)) {
                            try {
                                String screen = ScreenLoaderServlet.loadScreen(screenName, locale);
                                if (screen == null) {
                                    this.log.warn("Screen \"" + screenName + "\" not found in configured locations. Skipping.");
                                    continue;
                                }
                                ((Writer)writer).write("      " + (char)separator + "{ screenName:\"" + screenName + "\",\n\r");
                                ((Writer)writer).write("        source:\"" + StringEscapeUtils.escapeJavaScript((String)screen.toString()) + "\"}\n\r");
                                ((Writer)writer).write("\r\n");
                                separator = 44;
                            }
                            catch (Exception ex) {
                                this.log.error((Object)("Failed to load screen \"" + screenName + "\". Skipping."), ex);
                            }
                            continue;
                        }
                        this.log.warn("Empty string specified as screen name. Skipping.");
                    }
                    ((Writer)writer).write("      ]\n\r");
                    ((Writer)writer).write("}\n\r");
                    ((Writer)writer).write("\r\n");
                }
            }
            this.log.debug("Generated response:" + ((Object)writer).toString());
            response.setStatus(200);
            PrintWriter rw = response.getWriter();
            rw.print(((Object)writer).toString());
            rw.close();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException writer) {}
        }
    }

    public static String loadScreen(String screenName, Locale locale) throws Exception {
        String screenFile = DataStructCache.getInstanceFile(screenName, "ui", "ui");
        if (screenFile != null) {
            StringWriter screenWriter = new StringWriter();
            XML.toJS("<isomorphicXML>" + new ISCFile(screenFile).getAsString() + "</isomorphicXML>", locale, (Writer)screenWriter);
            return ((Object)screenWriter).toString();
        }
        return null;
    }
}

