/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.MailMessage;
import com.thoughtworks.selenium.Selenium;
import isc.org.apache.oro.text.GlobCompiler;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class Utils {
    private static final String RESULT_VIEWER = "http://wrath.isomorphic.com:41080/tools/selenium/testResultViewer.jsp";
    private static Logger log = new Logger(Utils.class.getName());
    private static Perl5Util regex = new Perl5Util();

    public static int getMaximumReportLength() {
        String res = System.getenv("DETAILS_REPORT_MAX_LENGTH");
        return res == null ? 0 : Integer.parseInt(res);
    }

    public static String getMyInstanceId() {
        return System.getenv("MY_AWS_INSTANCE_ID");
    }

    public static String getTestName(String testUrl, String basePath) {
        int qaInd;
        int n = qaInd = basePath != null ? testUrl.indexOf(basePath) : -1;
        if (qaInd >= 0) {
            return testUrl.substring(qaInd + basePath.length() + 1);
        }
        URI uri = URI.create(testUrl);
        return uri.getPath();
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        Utils.outputHelp(cmdLineSyntax, options, null);
    }

    public static void outputHelp(String cmdLineSyntax, Options options, String error) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.setSyntaxPrefix("usage:");
        formatter.printHelp(" " + cmdLineSyntax, "", options, error != null ? "\nError: " + error : "");
    }

    public static boolean equalsOrBothNull(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        return s1.equals(s2);
    }

    public static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getEvalWithTry(Selenium selenium, String javaScript) {
        return selenium.getEval("try { " + javaScript + "; } catch(notUsed) { }");
    }

    public static boolean evalAsBoolean(Selenium selenium, String javaScript) {
        return Boolean.parseBoolean(selenium.getEval(javaScript));
    }

    public static boolean isCvsSpam(String commitSpam) {
        return commitSpam.toLowerCase().indexOf("<html>") == 0;
    }

    public static String getModifiedFilesFromCvsSpam(String cvsSpam) throws Exception {
        String nextLine;
        StringBuilder modifiedFiles = new StringBuilder();
        BufferedReader br = new BufferedReader(new StringReader(cvsSpam));
        while ((nextLine = br.readLine()) != null) {
            String committedUrl;
            if (!nextLine.contains("href=\"#file") || !StringUtils.isNotEmpty((String)(committedUrl = StringUtils.substringBetween((String)nextLine, (String)"http://", (String)"?rev=")))) continue;
            modifiedFiles.append("http://").append(committedUrl).append(" , ");
        }
        IOUtils.closeQuietly((Reader)br);
        int length = modifiedFiles.length();
        if (length > 2) {
            modifiedFiles.setLength(length - 3);
        }
        return modifiedFiles.toString();
    }

    public static String getCommitBranchFromCvsSpam(String cvsSpam) {
        String commitPrefix = "^.*\\n<tr class[^\\n]*>Commit in <b>[^\\n]*<\\/b>[^\\n]* on ";
        cvsSpam = regex.substitute("s/" + commitPrefix + "//s", cvsSpam);
        return StringUtils.substringBefore((String)cvsSpam, (String)"</");
    }

    public static String getFileRegionFromSvnSpam(String svnSpam) {
        String next;
        svnSpam = StringUtils.substringAfter((String)svnSpam, (String)"http://code.google.com");
        svnSpam = StringUtils.substringAfter((String)svnSpam, (String)"\n");
        if (StringUtils.isNotEmpty((String)(svnSpam = StringUtils.substringBefore((String)svnSpam, (String)"\n\n=============================="))) && StringUtils.isNotEmpty((String)(next = StringUtils.substringAfterLast((String)svnSpam, (String)"http://code.google.com")))) {
            svnSpam = StringUtils.substringAfter((String)next, (String)"\n");
        }
        return StringUtils.isEmpty((String)svnSpam) ? "" : svnSpam.trim();
    }

    public static String getModifiedFilesFromSvnSpam(String svnSpam) {
        String[] files = Utils.getFileRegionFromSvnSpam(svnSpam).split("[\\s]+");
        String csvFiles = "";
        for (int i = 0; i < files.length; ++i) {
            if (Utils.matchRegExp("/^[A-Z]+:$/i", files[i])) continue;
            if (csvFiles.length() > 0) {
                csvFiles = csvFiles + " , ";
            }
            csvFiles = csvFiles + files[i];
        }
        return csvFiles;
    }

    public static String getCommitBranchFromSvnSpam(String svnSpam) {
        String[] branches = new String[]{"ISC_SC81_BRANCH", "ISC_82_BRANCH", "ISC_83_BRANCH", "ISC_90_BRANCH", "MAIN"};
        String[] directories = new String[]{"/branches/2.5/", "/branches/3.0/", "/branches/3.1/", "/branches/4.0/", "/trunk/"};
        String branch = null;
        String modifiedFiles = Utils.getModifiedFilesFromSvnSpam(svnSpam);
        for (int i = 0; i < directories.length; ++i) {
            if (modifiedFiles.indexOf(directories[i]) < 0 || branch != null && Utils.compareBranches(branch, "ISC_82_BRANCH") >= 0 && (Utils.compareBranches(branches[i], "ISC_82_BRANCH") < 0 || Utils.compareBranches(branches[i], branch) >= 0)) continue;
            branch = branches[i];
        }
        return branch != null ? branch : "MAIN";
    }

    public static String getModifiedFilesFromCommitSpam(String commitSpam) throws Exception {
        return Utils.isCvsSpam(commitSpam) ? Utils.getModifiedFilesFromCvsSpam(commitSpam) : Utils.getModifiedFilesFromSvnSpam(commitSpam);
    }

    public static String getSmartClientVersionFromBranch(String branch) {
        if (branch != null) {
            String version = regex.substitute("s/ISC_([0-9]+)([0-9])_BRANCH/$1.$2/", branch);
            return version.indexOf(".") >= 0 ? version : "??.?";
        }
        return null;
    }

    public static String getSubjectBaseAndSetFromFieldForEmail(MailMessage msg, String mode, String showcase, String branch) {
        String version = Utils.getSmartClientVersionFromBranch(branch);
        msg.setFrom(mode.toLowerCase() + "test" + (null != showcase ? "." + showcase : "") + "@isomorphic.com");
        return "[" + (null != version ? version + " " : "") + mode + "Test" + (null != showcase ? "/" + showcase : "") + "] ";
    }

    public static void dumpStringToFile(String fileName, String content) {
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(fileName));
            file.write(content);
            file.close();
        }
        catch (Exception e) {
            log.error((Object)("Error during write to file " + fileName), (Throwable)e);
        }
    }

    public static boolean matchRegExp(String pattern, String input) {
        if (input != null) {
            return regex.match(pattern, input);
        }
        return false;
    }

    public static void setBrowserMaximization(Selenium selenium, boolean maximize) {
        String jsCode = "var bot = this.browserbot, win = bot.getUserWindow(); ";
        if (maximize) {
            jsCode = jsCode + "core._scOriginalWidth = win.outerWidth; core._scOriginalHeight = win.outerHeight";
            Utils.getEvalWithTry(selenium, jsCode);
            selenium.windowMaximize();
        } else {
            jsCode = jsCode + "win.resizeTo(core._scOriginalWidth, core._scOriginalHeight); ";
            jsCode = jsCode + "delete core._scOriginalWidth; delete core._scOriginalHeight";
            Utils.getEvalWithTry(selenium, jsCode);
        }
    }

    public static void clearDeveloperConsoleMessages(Selenium selenium) {
        String javascript = "selenium.browserbot.getCurrentWindow().isc.Log.clear()";
        Utils.getEvalWithTry(selenium, javascript);
    }

    public static String getDeveloperConsoleMessages(Selenium selenium) {
        String messageArray = "selenium.browserbot.getCurrentWindow().isc.Log.getMessages()";
        return Utils.getEvalWithTry(selenium, messageArray + ".join('\\n')");
    }

    public static String addURLArgument(String location, String variableAssignment) {
        if (variableAssignment.length() == 0) {
            return location;
        }
        String operator = location.indexOf("?") >= 0 ? "&" : "?";
        return location + operator + variableAssignment;
    }

    public static String getCurrentMethodName() {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        return stackTraceElements[1].getMethodName();
    }

    protected static boolean isLocalFileAccessAllowed(String browser) {
        return false;
    }

    protected static String getSeleniumFilePath(String fileName, int serverPort) {
        return "http://localhost:" + serverPort + "/selenium-server/tests/" + fileName;
    }

    protected static String getUnqualifiedFileName(String path, boolean excludeSuffix) {
        String name = regex.substitute("s/^(?:[^\\\\\\/]*[\\\\\\/])*(.*)$/$1/", path);
        return excludeSuffix ? regex.substitute("s/^([^.]*).*$/$1/", name) : name;
    }

    protected static String linkify(String branch, Date batchStartTime, String showcase, String testFile, boolean hidePass, String color) {
        String result = "<a href=\"http://wrath.isomorphic.com:41080/tools/selenium/testResultViewer.jsp";
        result = result + "?branch=" + branch;
        result = result + "&batch=" + batchStartTime.getTime();
        result = result + "&showcase=" + ShowcaseSpecifier.getShowcaseAsUrlParameter(showcase);
        if (testFile != null) {
            result = result + "&testFile=" + URLEncoder.encode(testFile);
        }
        if (hidePass) {
            result = result + "&hidePass=true";
        }
        return result + "\" style=\"color:" + color + ";\">";
    }

    protected static boolean isUnqualifiedFilename(String path) {
        return path.indexOf("/") < 0 && path.indexOf(".") >= 0;
    }

    private static List ffind(String testRootPath, String pattern) {
        List files = ISCFile.ffind((String)testRootPath, (boolean)true, (String)pattern);
        return files != null ? files : new ArrayList();
    }

    protected static List<String> getFilesMatchingRegExs(String testRootPath, String[] pathRegExs, String suffixRegEx) {
        ArrayList<String> files;
        String rootRegEx = regex.substitute("s/([()[{*.+^$\\?|])/\\\\$1/g", testRootPath);
        if (pathRegExs != null) {
            files = new ArrayList();
            for (int i = 0; i < pathRegExs.length; ++i) {
                String pattern = "(?=^" + rootRegEx + ".*" + pathRegExs[i] + ")" + "(?=.*" + suffixRegEx + ")";
                List fileGroup = Utils.ffind(testRootPath, pattern);
                Collections.sort(fileGroup);
                files.addAll(fileGroup);
            }
        } else {
            files = Utils.ffind(testRootPath, suffixRegEx);
            Collections.sort(files);
        }
        return files;
    }

    protected static List<String> getFilesSpecifiedByPath(String testRootPath, String[] paths, String suffixRegEx) {
        ArrayList<String> files = new ArrayList<String>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                String pathRegEx = Utils.isUnqualifiedFilename(path) ? ".*" + GlobCompiler.globToPerl5((char[])path.toCharArray(), (int)0) + "$" : "^" + GlobCompiler.globToPerl5((char[])(testRootPath + "/" + path).toCharArray(), (int)0);
                String pattern = "(?=" + pathRegEx + ")" + "(?=.*" + suffixRegEx + ")";
                List fileGroup = Utils.ffind(testRootPath, pattern);
                Collections.sort(fileGroup);
                files.addAll(fileGroup);
            }
        }
        return files;
    }

    protected static String getBatchLogFromSystemIn(String eofIndicator) throws Exception {
        String nextLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder content = new StringBuilder();
        while ((nextLine = br.readLine()) != null) {
            content.append(nextLine).append("\n");
            if (eofIndicator == null || !nextLine.contains(eofIndicator)) continue;
            break;
        }
        return content.toString();
    }

    protected static String getCvsSpamFromSystemIn() throws Exception {
        return Utils.getBatchLogFromSystemIn("</html>");
    }

    protected static String execCommandAndReturnStdOut(String[] command) throws Exception {
        String line;
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList(command));
        Map<String, String> environ = builder.environment();
        String perl5Lib = System.getenv("GLOBAL_DEVENV_BASE") + "/lib/perl";
        environ.put("PERL5LIB", perl5Lib + ":" + System.getenv("PERL5LIB"));
        Process process = builder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer buffer = new StringBuffer();
        while ((line = br.readLine()) != null) {
            buffer.append(line + "\n");
        }
        return buffer.toString();
    }

    protected static String getCanonicalDate(String cvsDate, String timezone, int offsetSeconds) {
        try {
            String epochSeconds = Utils.execCommandAndReturnStdOut(new String[]{"/bin/date", "+%s", "-d", "TZ=\"" + timezone + "\" " + cvsDate}).trim();
            return Utils.execCommandAndReturnStdOut(new String[]{"/bin/date", "-d", "@" + (Integer.parseInt(epochSeconds) + offsetSeconds)}).trim();
        }
        catch (Exception e) {
            log.error((Object)("Unable to canonicalize date " + cvsDate));
            return cvsDate;
        }
    }

    public static String clipTextField(String dataSourceName, String fieldName, String text) throws Exception {
        Long length;
        DSField field;
        DataSource dataSource = DataSourceManager.get((String)dataSourceName);
        if (dataSource != null && text != null && (field = dataSource.getField(fieldName)) != null && (length = (Long)field.get((Object)"length")) != null && length < (long)text.length()) {
            return text.substring(0, length.intValue());
        }
        return text;
    }

    public static int compareBranches(String branch1, String branch2) {
        int ordinal1;
        Object[] branches = new String[]{"ISC_SC81_BRANCH", "ISC_82_BRANCH", "ISC_83_BRANCH", "ISC_90_BRANCH", "MAIN"};
        if ("HEAD".equalsIgnoreCase(branch1)) {
            branch1 = "MAIN";
        }
        if ("HEAD".equalsIgnoreCase(branch2)) {
            branch2 = "MAIN";
        }
        if ((ordinal1 = ArrayUtils.indexOf((Object[])branches, (Object)branch1.toUpperCase())) < 0) {
            throw new IndexOutOfBoundsException("Branch " + branch1 + " is not valid");
        }
        int ordinal2 = ArrayUtils.indexOf((Object[])branches, (Object)branch2.toUpperCase());
        if (ordinal2 < 0) {
            throw new IndexOutOfBoundsException("Branch " + branch2 + " is not valid");
        }
        return ordinal1 - ordinal2;
    }
}

