/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest.model;

import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.Utils;
import com.isomorphic.log.Logger;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class TestResult
implements Serializable {
    private static final long serialVersionUID = 5517047163311898846L;
    private static Logger log = new Logger(TestResult.class.getName());
    public static final String TEST_RESULT_SUCCESS = "success";
    public static final String TEST_RESULT_FAILURE = "failure";
    public static final String TEST_RESULT_TIMEOUT = "timeout";
    public static final String TEST_FILE_FIELD = "testFile";
    public static final String TEST_NUMBER_FIELD = "testNumber";
    public static final String RESULT_FIELD = "result";
    public static final String DETAILS_FIELD = "details";
    public static final String MESSAGES_FIELD = "messages";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String START_TIME_FIELD = "startTime";
    public static final String END_TIME_FIELD = "endTime";
    public static final String BATCH_START_TIME_FIELD = "batchStartTime";
    public static final String SHOWCASE_FIELD = "showcase";
    public static final String BRANCH_FIELD = "branch";
    public static final String IMAGE_FILE_FIELD = "capture_filename";
    public static final String IMAGE_SIZE_FIELD = "capture_filesize";
    private static Perl5Util regex = new Perl5Util();
    private String testFile;
    private int testNumber;
    private String result;
    private String description;
    private String details;
    private String messages;
    private Date startTime;
    private Date endTime;
    private Date batchStartTime;
    private String showcase;
    private String branch;
    private String imageFile;
    private long imageSize;
    private String pastResults;

    public String getTestFile() {
        return this.testFile;
    }

    public void setTestFile(String testFile) {
        this.testFile = testFile;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public void setTestNumber(int testNumber) {
        this.testNumber = testNumber;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
        if (this.imageFile != null && TEST_RESULT_SUCCESS.equals(result)) {
            try {
                File file = new File(this.imageFile);
                this.imageFile = null;
                file.delete();
            }
            catch (Exception e) {
                log.error((Object)("encountered exception trying to remove screen capture file for test " + this.testFile + " #" + this.testNumber + ": "), (Throwable)e);
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getMessages() {
        return this.messages;
    }

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getBatchStartTime() {
        return this.batchStartTime;
    }

    public void setBatchStartTime(Date batchStartTime) {
        this.batchStartTime = batchStartTime;
    }

    public void setShowcase(String showcase) {
        this.showcase = showcase;
    }

    public String getShowcase() {
        return this.showcase;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setImageFile(String imageFile) {
        this.imageFile = imageFile;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageSize(long nBytes) {
        this.imageSize = nBytes;
    }

    public long getImageSize() {
        return this.imageSize;
    }

    public void setContent(String content) {
        String separator = "ISC_DEVELOPER_MESSAGES: ";
        this.details = regex.substitute("s/\\n" + separator + "(.*)//s", content);
        String messages = regex.substitute("s/(.*)\\n" + separator + "//s", content);
        if (!messages.equals(content)) {
            this.messages = messages;
        }
    }

    public TestResult() {
    }

    public TestResult(Map<String, ?> data) {
        this.setBatchStartTime((Date)data.get(BATCH_START_TIME_FIELD));
        this.setDescription((String)data.get(DESCRIPTION_FIELD));
        this.setEndTime((Date)data.get(END_TIME_FIELD));
        this.setResult((String)data.get(RESULT_FIELD));
        this.setDetails((String)data.get(DETAILS_FIELD));
        this.setMessages((String)data.get(MESSAGES_FIELD));
        this.setStartTime((Date)data.get(START_TIME_FIELD));
        this.setTestFile((String)data.get(TEST_FILE_FIELD));
        this.setShowcase((String)data.get(SHOWCASE_FIELD));
        this.setBranch((String)data.get(BRANCH_FIELD));
        int testNumber = data.containsKey(TEST_NUMBER_FIELD) ? (Integer)data.get(TEST_NUMBER_FIELD) : 1;
        this.setTestNumber(testNumber);
    }

    public TestResult(TestResult tr, boolean truncate) throws Exception {
        this.batchStartTime = tr.batchStartTime;
        this.description = tr.description;
        this.details = truncate ? TestResult.clipTextField(DETAILS_FIELD, tr.details) : tr.details;
        this.messages = truncate ? TestResult.clipTextField(MESSAGES_FIELD, tr.messages) : tr.messages;
        this.result = tr.result;
        this.testFile = tr.testFile;
        this.testNumber = tr.testNumber;
        this.startTime = tr.startTime;
        this.endTime = tr.endTime;
        this.showcase = tr.showcase;
        this.branch = tr.branch;
        this.imageFile = tr.imageFile;
        this.imageSize = tr.imageSize;
    }

    public static String clipTextField(String fieldName, String text) throws Exception {
        TestRunnerConfiguration config = TestResultDao.getConfiguration();
        return Utils.clipTextField(config.getTestResultDS(), fieldName, text);
    }

    public void addPastResult(String pastResult, String openAnchor) {
        if (this.pastResults == null) {
            this.pastResults = "";
        }
        String grade = pastResult;
        if (TEST_RESULT_SUCCESS.equals(pastResult)) {
            grade = "P";
        } else if (TEST_RESULT_FAILURE.equals(pastResult)) {
            grade = "F";
        } else if (TEST_RESULT_TIMEOUT.equals(pastResult)) {
            grade = "O";
        }
        this.pastResults = this.pastResults + (openAnchor != null ? openAnchor + grade + "</a>" : grade);
    }

    public void setPastResults() {
        for (int i = 0; i < this.pastResults.length(); ++i) {
            if (this.pastResults.charAt(i) == '-') continue;
            return;
        }
        this.pastResults = "<No History>";
    }

    public String getPastResults() {
        return this.pastResults;
    }
}

