/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuditDSGenerator
implements DynamicDSGenerator {
    public static String DEFAULT_REVISION_FIELD_NAME = "revision";
    public static String DEFAULT_TIMESTAMP_FIELD_NAME = "timestamp";
    public static String DEFAULT_TYPE_FIELD_NAME = "type";
    public static String DEFAULT_USER_FIELD_NAME = "user";
    public static String DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY = "autoCreateAuditTable";
    public static String GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY = "audit.autoCreateTables";
    private static Logger log = new Logger(AuditDSGenerator.class.getName());
    private Map ds2audit = Collections.synchronizedMap(new HashMap());
    private static Map ds2TableChecked = new HashMap();
    private Config config = Config.getGlobal();

    public DataSource getDataSource(String id, DSRequest dsRequest) {
        if (!this.ds2audit.containsKey(id)) {
            return null;
        }
        log.debug(id + " is an audit DataSource, processing");
        try {
            DataSource ds = DataSourceManager.getDataSource((String)this.ds2audit.get(id));
            DataSource ret = ((BasicDataSource)ds).getAuditDataSource();
            if (ret == null) {
                try {
                    StringWriter sw = new StringWriter();
                    sw.write("<DataSource serverType=\"sql\" ID=\"");
                    sw.write(id);
                    sw.write("\" inheritsFrom=\"");
                    sw.write(ds.getID());
                    sw.write("\">\n");
                    sw.write("<fields>\n");
                    String tmp = AuditDSGenerator.getAuditRevisionFieldName(ds);
                    if (tmp != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"sequence\" primaryKey=\"true\"/>\n");
                    }
                    if ((tmp = AuditDSGenerator.getAuditTypeFieldName(ds)) != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"enum\">\n");
                        sw.write("<valueMap>\n");
                        sw.write("\t<value>add</value>");
                        sw.write("\t<value>remove</value>");
                        sw.write("\t<value>update</value>");
                        sw.write("</valueMap>\n");
                        sw.write("</field>\n");
                    }
                    if ((tmp = AuditDSGenerator.getAuditTimestampFieldName(ds)) != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"creatorTimestamp\"/>\n");
                    }
                    if ((tmp = AuditDSGenerator.getAuditUserFieldName(ds)) != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"creator\"/>\n");
                    }
                    sw.write("</fields>\n");
                    sw.write("</DataSource>");
                    ret = DataSource.fromXML(sw.toString());
                    log.debug("Generated DataSource " + id + " from xml:");
                    log.debug(sw.toString());
                    List fields = ret.getFieldNames();
                    for (String name : fields) {
                        DSField f = ret.getField(name);
                        if (f.containsKey("audit") && !f.getBoolean("audit")) {
                            f.put("inapplicable", true);
                        }
                        if (f.isPrimaryKey() && !AuditDSGenerator.getAuditRevisionFieldName(ds).equals(f.getName())) {
                            f.put("primaryKey", false);
                            if ("sequence".equals(f.getType())) {
                                f.put("type", "integer");
                            }
                        }
                        if (!f.isRequired()) continue;
                        f.put("required", false);
                    }
                    if (!ds2TableChecked.containsKey(id)) {
                        boolean shouldCreateAuditTable = false;
                        String auditAutoCreate = (String)Config.getProperty(GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY);
                        if (auditAutoCreate != null && "true".equals(auditAutoCreate)) {
                            shouldCreateAuditTable = true;
                        } else if (ds.getConfig().containsKey("audit") && "true".equals(ds.getConfig().get("audit")) && ds.getConfig().containsKey(DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY) && "true".equals(ds.getConfig().get(DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY))) {
                            shouldCreateAuditTable = true;
                        }
                        if (shouldCreateAuditTable) {
                            log.debug("Audit table should be autocreated for DataSource " + ds.getID());
                            try {
                                log.debug("Creating audit table for DataSource " + ds.getName());
                                ret.createStorage(false);
                                log.debug("Audit table successfully created for DataSource " + ds.getName());
                            }
                            catch (Exception e1) {
                                log.warn("Error creating audit table for DataSource " + ds.getName());
                            }
                        } else {
                            log.debug("Audit table should not be automatically created for DataSource " + ds.getID());
                        }
                        ds2TableChecked.put(id, id);
                    } else {
                        log.debug("Audit table creation already checked for DataSource " + ds.getID());
                    }
                }
                catch (Exception e) {
                    log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
                }
            }
            DataSourceManager.free(ds);
            return ret;
        }
        catch (Exception e) {
            log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
            return null;
        }
    }

    public static String getAuditRevisionFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_REVISION_FIELD_NAME;
            if (ds.getConfig().containsKey("auditRevisionFieldName")) {
                result = (String)ds.getConfig().get("auditRevisionFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static String getAuditTimestampFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_TIMESTAMP_FIELD_NAME;
            if (ds.getConfig().containsKey("auditTimeStampFieldName")) {
                result = (String)ds.getConfig().get("auditTimeStampFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static String getAuditUserFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_USER_FIELD_NAME;
            if (ds.getConfig().containsKey("auditUserFieldName")) {
                result = (String)ds.getConfig().get("auditUserFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static String getAuditTypeFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_TYPE_FIELD_NAME;
            if (ds.getConfig().containsKey("auditTypeFieldName")) {
                result = (String)ds.getConfig().get("auditTypeFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            return result;
        }
        return null;
    }

    public void addMapping(String auditDSID, String dsID) {
        this.ds2audit.put(auditDSID, dsID);
    }

    public boolean isAutoCreateAuditTableActive(DataSource ds) {
        String auditAutoCreate = (String)Config.getProperty(GLOBAL_AUTO_CREATE_AUDIT_TABLE_KEY);
        if (auditAutoCreate != null && "true".equals(auditAutoCreate)) {
            return true;
        }
        return ds.getConfig().containsKey("audit") && "true".equals(ds.getConfig().get("audit")) && ds.getConfig().containsKey(DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY) && "true".equals(ds.getConfig().get(DATASOURCE_AUTO_CREATE_AUDIT_TABLE_KEY));
    }
}

