/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

class CapabilitiesComparator
implements Comparator<Capabilities> {
    private final Comparator<Capabilities> compareWith;

    public CapabilitiesComparator(Capabilities desiredCapabilities, Platform currentPlatform) {
        final CapabilityScorer<String> browserNameScorer = CapabilityScorer.scoreAgainst(desiredCapabilities.getBrowserName());
        Comparator<Capabilities> byBrowserName = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return browserNameScorer.score(c1.getBrowserName()) - browserNameScorer.score(c2.getBrowserName());
            }
        };
        final VersionScorer versionScorer = new VersionScorer(desiredCapabilities.getVersion());
        Comparator<Capabilities> byVersion = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return versionScorer.score(c1.getVersion()) - versionScorer.score(c2.getVersion());
            }
        };
        final CapabilityScorer<Boolean> jsScorer = CapabilityScorer.scoreAgainst(desiredCapabilities.isJavascriptEnabled());
        Comparator<Capabilities> byJavaScript = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return jsScorer.score(c1.isJavascriptEnabled()) - jsScorer.score(c2.isJavascriptEnabled());
            }
        };
        Platform desiredPlatform = desiredCapabilities.getPlatform();
        if (desiredPlatform == null) {
            desiredPlatform = Platform.ANY;
        }
        final CurrentPlatformScorer currentPlatformScorer = new CurrentPlatformScorer(currentPlatform, desiredPlatform);
        Comparator<Capabilities> byCurrentPlatform = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return currentPlatformScorer.score(c1.getPlatform()) - currentPlatformScorer.score(c2.getPlatform());
            }
        };
        final CapabilityScorer<Platform> strictPlatformScorer = CapabilityScorer.scoreAgainst(desiredPlatform);
        Comparator<Capabilities> byStrictPlatform = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return strictPlatformScorer.score(c1.getPlatform()) - strictPlatformScorer.score(c2.getPlatform());
            }
        };
        final FuzzyPlatformScorer fuzzyPlatformScorer = new FuzzyPlatformScorer(desiredPlatform);
        Comparator<Capabilities> byFuzzyPlatform = new Comparator<Capabilities>(){

            @Override
            public int compare(Capabilities c1, Capabilities c2) {
                return fuzzyPlatformScorer.score(c1.getPlatform()) - fuzzyPlatformScorer.score(c2.getPlatform());
            }
        };
        this.compareWith = Ordering.compound((Iterable)Lists.newArrayList((Object[])new Comparator[]{byBrowserName, byVersion, byJavaScript, byCurrentPlatform, byStrictPlatform, byFuzzyPlatform}));
    }

    public static <T extends Capabilities> T getBestMatch(Capabilities against, Collection<T> toCompare) {
        return CapabilitiesComparator.getBestMatch(against, toCompare, Platform.getCurrent());
    }

    @VisibleForTesting
    static <T extends Capabilities> T getBestMatch(Capabilities against, Collection<T> toCompare, Platform currentPlatform) {
        return (T)((Capabilities)Ordering.from((Comparator)new CapabilitiesComparator(against, currentPlatform)).max(toCompare));
    }

    @Override
    public int compare(Capabilities a, Capabilities b) {
        return this.compareWith.compare(a, b);
    }

    private static class CapabilityScorer<T> {
        final T scoreAgainst;

        public CapabilityScorer(T scoreAgainst) {
            this.scoreAgainst = scoreAgainst;
        }

        public int score(T value) {
            if (value == null || this.scoreAgainst == null) {
                return 0;
            }
            if (value.equals(this.scoreAgainst)) {
                return 1;
            }
            return -1;
        }

        static <T> CapabilityScorer<T> scoreAgainst(T value) {
            return new CapabilityScorer<T>(value);
        }
    }

    private static class CurrentPlatformScorer
    extends CapabilityScorer<Platform> {
        private final boolean currentIsDesired;

        private CurrentPlatformScorer(Platform currentPlatform, Platform desiredPlatform) {
            super(currentPlatform);
            this.currentIsDesired = !CurrentPlatformScorer.isNullOrAny(currentPlatform) && (currentPlatform.is(desiredPlatform) || desiredPlatform.is(currentPlatform));
        }

        private static boolean isNullOrAny(Platform p) {
            return p == null || p.equals((Object)Platform.ANY);
        }

        @Override
        public int score(Platform value) {
            if (!this.currentIsDesired) {
                return 0;
            }
            if (value == null) {
                value = Platform.ANY;
            }
            return ((Platform)((Object)this.scoreAgainst)).is(value) ? 1 : -1;
        }
    }

    private static class FuzzyPlatformScorer
    extends CapabilityScorer<Platform> {
        public FuzzyPlatformScorer(Platform scoreAgainst) {
            super(scoreAgainst);
        }

        @Override
        public int score(Platform value) {
            if (value == null) {
                value = Platform.ANY;
            }
            if (value.equals((Object)Platform.ANY)) {
                return 0;
            }
            return value.is((Platform)((Object)this.scoreAgainst)) || ((Platform)((Object)this.scoreAgainst)).is(value) ? 1 : -1;
        }
    }

    private static class VersionScorer
    extends CapabilityScorer<String> {
        public VersionScorer(String against) {
            super(Strings.nullToEmpty((String)against).trim());
        }

        @Override
        public int score(String other) {
            if ((other = Strings.nullToEmpty((String)other).trim()).isEmpty() || ((String)this.scoreAgainst).isEmpty()) {
                return 0;
            }
            if (other.equals(this.scoreAgainst)) {
                return 1;
            }
            return -1;
        }
    }
}

