isc.DrawPane.create({
    showEdges: true,
    autoDraw:  true,
    ID:        "mainPane",
    width:     400,
    height:    400,
    top:       70,
    overflow:  "hidden",
    cursor:    "auto",
    canDrag: true
});

isc.DrawTriangle.create({
    autoDraw: true,
    drawPane: mainPane,
    points:   [[75,50],[100,100],[50,100]],
    canDrag: true
});

isc.DrawCurve.create({
    autoDraw:      true,
    drawPane:      mainPane,
    startPoint:    [125, 50],
    endPoint:      [175, 100],
    controlPoint1: [150, 25],
    controlPoint2: [150, 125],
    canDrag: true
});

isc.DrawLinePath.create({
    autoDraw:   true,
    drawPane:   mainPane,
    startPoint: [200, 50],
    endPoint:   [250, 100],
    canDrag: true
});

isc.DrawPath.create({
    autoDraw: true,
    drawPane: mainPane,
    points:   [[275, 50], [287,50], [300,62], [312,62], 
              [325,62],   [325,87], [312,87], [300,87], 
              [287,100],  [275,100]],
    canDrag: true
});

isc.DrawOval.create({
    autoDraw: true,
    drawPane: mainPane,
    left:     50,
    top:      150,
    width:    50,
    height:   75,
    canDrag: true
});

isc.DrawRect.create({
    autoDraw: true,
    drawPane: mainPane,
    left:     125,
    top:      150,
    width:    50,
    height:   75,
    canDrag: true
});

isc.DrawLine.create({
    autoDraw:   true,
    drawPane:   mainPane,        
    startPoint: [200, 150],
    endPoint:   [250,225],
    canDrag: true
});

isc.DrawSector.create({
    autoDraw:true,
    drawPane:mainPane,
    centerPoint:[275, 150],
    startAngle: 0,
    endAngle: 90,
    radius:75,
    canDrag:true
});

isc.Slider.create({
    ID:             "zoomSlider",
    minValue:       0.10,
    maxValue:       3.00,
    numValues:      300,
    roundValues:    false,
    roundPrecision: 2,
    width:          400,
    title:          "Zoom Shapes",
    vertical:       false,
    valueChanged : function (value) {
        mainPane.zoom(value);
    },
    canDrag: true
});
