/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.PoolableDataSourceFactory;
import com.isomorphic.log.Logger;
import com.isomorphic.pool.PoolManager;
import com.isomorphic.util.DataTools;

public class DataSourceManager
extends Base {
    private static Logger log = new Logger(DataSourceManager.class.getName());
    public static PoolManager manager = new PoolManager("datasources", new PoolableDataSourceFactory());
    private static boolean poolDynamicDataSources = Config.getGlobal().getBoolean((Object)"datasources.poolDynamicDataSources", false);
    private static long count = 0L;
    private static long millis = 0L;

    public static void restartPoolManager() {
        manager = new PoolManager("datasources", new PoolableDataSourceFactory());
    }

    public static DataSource getDataSource(String name) throws Exception {
        return DataSourceManager.getDataSource(name, null);
    }

    public static DataSource getDataSource(String name, DSRequest request) throws Exception {
        return DataSourceManager.getDataSource(name, request, false);
    }

    public static synchronized DataSource getDataSource(String name, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        long start = 0L;
        if (log.isDebugEnabled()) {
            ++count;
            start = System.currentTimeMillis();
        }
        DataSource ds = null;
        ds = !poolDynamicDataSources && DataSource.isDynamic(name) ? (DataSource)manager.borrowUnpooledObject(name, dsRequest, isSchemaless) : (DataSource)manager.borrowObject(name, dsRequest, isSchemaless);
        return ds;
    }

    public static DataSource get(String name) throws Exception {
        return DataSourceManager.getDataSource(name);
    }

    public static DataSource get(String name, DSRequest dsRequest) throws Exception {
        return DataSourceManager.getDataSource(name, dsRequest);
    }

    public static DataSource getUnpooledDataSource(String name) throws Exception {
        return (DataSource)manager.borrowUnpooledObject(name);
    }

    public static void freeDataSource(DataSource ds) {
        DataSourceManager.free(ds);
    }

    public static void free(DataSource ds) {
        if (ds == null) {
            return;
        }
        if (ds.isPassive()) {
            return;
        }
        ds.clearState();
        if (!poolDynamicDataSources && DataSource.isDynamic(ds.getID())) {
            ds = null;
        } else if (DataTools.getBoolean(ds.getConfig(), "doNotPool")) {
            manager.invalidateObject(ds.getName(), ds);
        } else {
            manager.returnObject(ds.getName(), ds);
        }
    }

    public static void clearPooledInstances(String dsName) throws Exception {
        manager.clearPool(dsName);
    }
}

