/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.log.LogEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class RevolvingMemoryAppender
extends AppenderSkeleton {
    protected static Map logs = new LinkedMap();
    protected int maxEntries = 50;

    public static List getLogNames() {
        return new ArrayList(logs.keySet());
    }

    public static List getLogEntries(String name) {
        return (List)logs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        this.name = name;
        Map map = logs;
        synchronized (map) {
            List log = (List)logs.get(name);
            if (log == null) {
                log = Collections.synchronizedList(new ArrayList());
                logs.put(name, log);
            }
        }
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public int getMaxEntires() {
        return this.maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(LoggingEvent event) {
        List logEntries;
        List list = logEntries = RevolvingMemoryAppender.getLogEntries(this.name);
        synchronized (list) {
            String[] throwableRep;
            while (logEntries.size() >= this.maxEntries) {
                logEntries.remove(0);
            }
            String formattedMessage = this.layout.format(event);
            ThrowableInformation throwableInfo = event.getThrowableInformation();
            if (throwableInfo != null && this.layout.ignoresThrowable() && (throwableRep = throwableInfo.getThrowableStrRep()) != null) {
                for (int i = 0; i < throwableRep.length; ++i) {
                    formattedMessage = formattedMessage + throwableRep[i] + Layout.LINE_SEP;
                }
            }
            logEntries.add(new LogEntry(formattedMessage, event.getLevel().toString()));
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    public void close() {
    }
}

