/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileDownload
extends BaseServlet {
    public Map expires;
    public Map cache = null;
    public boolean noCache = false;
    public Map charsets;
    public int stripPathComponents = -1;

    public void setExpires(String value) {
        this.expires = new HashMap();
        List list = DataTools.commaSeparatedStringToList(value);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mapping = i.next().toString();
            if (mapping.equals("")) continue;
            List split = DataTools.simpleSplit(mapping, ":");
            if (split.size() != 2) {
                this.log.error("Malformed expiry mapping: " + mapping + " - ignored");
                continue;
            }
            String mimeType = split.get(0).toString().toLowerCase();
            Long expiry = null;
            try {
                expiry = Long.valueOf((String)split.get(1));
            }
            catch (Exception e) {
                this.log.error((Object)("Malformed expiry mapping: " + mapping + " - ignored"), e);
                continue;
            }
            this.expires.put(mimeType, expiry);
            this.log.debug("Registered expires mapping - " + mimeType + ": " + expiry + " seconds");
        }
        if (this.expires.size() == 0) {
            this.expires = null;
        }
    }

    public void setCache(String value) {
        if ("NONE".equals(value.toUpperCase())) {
            this.noCache = true;
            return;
        }
    }

    public void setCharsets(String value) {
        this.charsets = new HashMap();
        List list = DataTools.commaSeparatedStringToList(value);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String mapping = i.next().toString();
            if (mapping.equals("")) continue;
            List split = DataTools.simpleSplit(mapping, ":");
            if (split.size() != 2) {
                this.log.error("Malformed charset mapping: " + mapping + " - ignored");
                continue;
            }
            String mimeType = split.get(0).toString().toLowerCase();
            String charset = (String)split.get(1);
            this.charsets.put(mimeType, charset);
            this.log.debug("Registerd charset mapping - " + mimeType + ": " + charset);
        }
    }

    public void setStripPathComponents(String value) {
        if (value != null) {
            try {
                this.stripPathComponents = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.log.error("Non-integer value provided for stripPathComponents property");
            }
            this.log.debug("stripPathComponents set to " + this.stripPathComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            String isc_delay = context.request.getParameter("isc_delay");
            if (isc_delay != null) {
                int delay = Integer.decode(isc_delay);
                this.log.debug("Delaying send by: " + delay + "ms");
                Thread.currentThread();
                Thread.sleep(delay);
            }
            String requestPath = request.getServletPath();
            if (request.getPathInfo() != null) {
                requestPath = requestPath + request.getPathInfo();
            }
            if (this.stripPathComponents > 0) {
                requestPath = ServletTools.stripPathComponents(request, this.stripPathComponents);
            }
            if (this.noCache) {
                context.setNoCacheHeaders();
            }
            ServletTools.sendStaticFile(context, config.get("webRoot") + requestPath, null, this.expires, this.charsets, false);
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            requestTimer.stop();
        }
    }
}

