/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTableClause
extends Base {
    private static Logger log = new Logger(SQLTableClause.class.getName());
    private List dataSources;
    private boolean isSubSelect = false;
    private DSRequest dsRequest;

    public SQLTableClause(DSRequest req, SQLDataSource ds) {
        this(req, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLTableClause(DSRequest req, List dataSources) {
        this.dataSources = dataSources;
        this.dsRequest = req;
    }

    public String getSQLString() throws Exception {
        if (this.dataSources == null) {
            log.debug((Object)"No datasources, can't generate table clause");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        HashMap<String, SQLDataSource> allDataSources = new HashMap<String, SQLDataSource>();
        for (SQLDataSource ds : this.dataSources) {
            if (!allDataSources.containsKey(ds.getName())) {
                allDataSources.put(ds.getName(), ds);
            }
            if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) continue;
            break;
        }
        if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) {
            Boolean useAnsiJoins = DataTools.asBooleanObject(this.dsRequest.getDataSource().getConfig().get("useAnsiJoins"));
            if (useAnsiJoins == null) {
                useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
            }
            if (this.isSubSelect || useAnsiJoins == null || !useAnsiJoins.booleanValue()) {
                for (IncludeFromDefinition incFrom : this.dsRequest.getIncludeFrom()) {
                    if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource) || !this.dsRequest.isGroupBy() && !this.isSubSelect && incFrom.getThisField() != null && incFrom.getThisField().getProperty("groupFunction") != null) continue;
                    if (!allDataSources.containsKey(incFrom.getDataSourceName())) {
                        allDataSources.put(incFrom.getDataSourceName(), (SQLDataSource)incFrom.getDataSource());
                    }
                    this.addDataSourcesFromJoiningRelations(incFrom, allDataSources);
                    IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
                    while (target != null && target.getDataSource() instanceof SQLDataSource) {
                        if (!allDataSources.containsKey(target.getDataSourceName())) {
                            allDataSources.put(target.getDataSourceName(), (SQLDataSource)target.getDataSource());
                        }
                        incFrom = target;
                        this.addDataSourcesFromJoiningRelations(incFrom, allDataSources);
                        target = incFrom.getTargetIncludeFrom();
                    }
                }
            }
        }
        Iterator<Object> i = allDataSources.keySet().iterator();
        while (i.hasNext()) {
            String dsName = (String)i.next();
            SQLDataSource ds = (SQLDataSource)((Object)allDataSources.get(dsName));
            String schema = (String)ds.getConfig().get("schema");
            if (schema != null) {
                buf.append(schema);
                buf.append(ds.getDriver().getQualifiedSchemaSeparator());
            }
            buf.append(ds.getTable().getName());
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private void addDataSourcesFromJoiningRelations(IncludeFromDefinition incFrom, Map relatedDataSources) {
        for (Relation r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
            if (!r.isValid() || relatedDataSources.containsKey(r.getToDataSource().getName())) continue;
            relatedDataSources.put(r.getToDataSource().getName(), r.getToDataSource());
        }
    }

    public void setIsSubSelect(boolean isSubSelect) {
        this.isSubSelect = isSubSelect;
    }
}

