/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLWhereClause
extends Base {
    private static Logger log = new Logger(SQLWhereClause.class.getName());
    boolean doFilter = false;
    String filterStyle = null;
    Object whereStructure = null;
    List dataSources = null;
    boolean keepUndeclaredFields = false;
    Map field2ColumnMap = null;
    private Map column2TableMap = new HashMap();
    private boolean qualifyColumnNames = true;
    private List customCriteriaFields = null;
    private List excludeCriteriaFields = null;
    private boolean isAdvanced = false;
    private boolean strictSQLFiltering = false;
    private DSRequest dsRequest;
    private Map operatorToSql = new HashMap(){
        {
            this.put("equalsField", "=");
            this.put("notEqualField", "<>");
            this.put("greaterThanField", ">");
            this.put("greaterOrEqualField", ">=");
            this.put("lessThanField", "<");
            this.put("lessOrEqualField", "<=");
        }
    };

    public SQLWhereClause(DSRequest dsRequest, SQLDataSource ds, boolean filter) throws Exception {
        this(dsRequest, ds, filter, (String)null);
    }

    public SQLWhereClause(DSRequest dsRequest, SQLDataSource ds, boolean filter, String filterStyle) throws Exception {
        this((Object)dsRequest, DataTools.makeList((Object)((Object)ds)), filter, filterStyle);
    }

    public SQLWhereClause(boolean qualifyColumnNames, DSRequest dsRequest, List dataSources, boolean filter, String filterStyle) throws Exception {
        this(dsRequest.getRawCriteria(), dataSources, filter, filterStyle);
        this.qualifyColumnNames = qualifyColumnNames;
        if (dataSources.size() > 1) {
            this.column2TableMap = SQLDataSource.getColumn2TableMap(dataSources);
        }
        this.field2ColumnMap = SQLDataSource.getField2ColumnMap(dataSources);
        List constraints = (List)dsRequest.constraints();
        if (constraints != null) {
            this.field2ColumnMap = DataTools.subsetMap((Map)this.field2ColumnMap, (List)constraints);
        }
        this.dsRequest = dsRequest;
    }

    public SQLWhereClause(Object whereStructure, List dataSources) throws Exception {
        this.dataSources = dataSources;
        this.whereStructure = whereStructure;
        if ("".equals(this.whereStructure)) {
            this.whereStructure = null;
        }
        DataSource ds = null;
        if (dataSources != null && dataSources.size() > 0) {
            ds = (DataSource)dataSources.get(0);
        }
        this.field2ColumnMap = SQLDataSource.getField2ColumnMap(dataSources);
        if (whereStructure == null) {
            return;
        }
        if (whereStructure instanceof String) {
            if (((String)whereStructure).length() != 0) {
                whereStructure = "'1'='1'";
            }
        } else if (whereStructure instanceof Map) {
            if (ds != null && ds.isAdvancedCriteria((Map)whereStructure)) {
                this.isAdvanced = true;
                Object strictMode = null;
                strictMode = ((Map)whereStructure).get("strictSQLFiltering");
                if (strictMode == null && ds != null) {
                    strictMode = ds.getConfig().get("strictSQLFiltering");
                }
                if (strictMode != null && (strictMode instanceof Boolean && strictMode.equals(Boolean.TRUE) || strictMode instanceof String && strictMode.equals("true"))) {
                    this.strictSQLFiltering = true;
                }
            }
        } else if (whereStructure instanceof List) {
            List clauses = (List)whereStructure;
            if (clauses.isEmpty()) {
                this.whereStructure = null;
                return;
            }
            if (clauses.size() == 1 && ((Map)clauses.get(0)).size() == 0) {
                this.whereStructure = null;
            }
        } else {
            throw new Exception("Data type: '" + whereStructure.getClass().getName() + "' is not supported");
        }
    }

    public SQLWhereClause(Object whereStructure, List dataSources, boolean filter, String filterStyle) throws Exception {
        this(whereStructure, dataSources);
        this.doFilter = filter;
        this.filterStyle = filterStyle;
    }

    public SQLWhereClause(Object whereStructure, SQLDataSource ds) throws Exception {
        this(whereStructure, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLWhereClause(Object whereStructure, SQLDataSource ds, boolean filter, String filterStyle) throws Exception {
        this(whereStructure, ds);
        this.doFilter = filter;
        this.filterStyle = filterStyle;
    }

    public SQLWhereClause(boolean qualifyColumnNames, Object whereStructure, SQLDataSource ds) throws Exception {
        this(whereStructure, ds);
        this.qualifyColumnNames = qualifyColumnNames;
    }

    public SQLWhereClause(boolean qualifyColumnNames, Object whereStructure, SQLDataSource ds, boolean filter, String filterStyle) throws Exception {
        this(whereStructure, ds);
        this.qualifyColumnNames = qualifyColumnNames;
        this.doFilter = filter;
        this.filterStyle = filterStyle;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }

    public List getExcludeCriteriaFields() {
        return this.excludeCriteriaFields;
    }

    public void setExcludeCriteriaFields(List fields) {
        this.excludeCriteriaFields = fields;
    }

    public void setField2ColumnMap(Map field2ColumnMap, boolean keepUndeclaredFields) {
        this.field2ColumnMap = field2ColumnMap;
        this.keepUndeclaredFields = keepUndeclaredFields;
    }

    public Map getDataHash() {
        if (this.whereStructure instanceof Map) {
            return (Map)this.whereStructure;
        }
        if (this.whereStructure instanceof List) {
            List whereList = (List)this.whereStructure;
            return (Map)whereList.get(whereList.size() - 1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.whereStructure == null;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    public String toString(SQLDriver driver) throws Exception {
        if (this.isEmpty()) {
            log.debug((Object)"no data; returning empty string");
            return "('1'='1')";
        }
        return this.getOutput(this.whereStructure, driver);
    }

    public String getSQLString() throws Exception {
        String whereClause = this.toString(((SQLDataSource)((Object)this.dataSources.get(0))).getDriver());
        if (whereClause == null) {
            whereClause = "('1'='1')";
        }
        return whereClause;
    }

    private String getOutput(Object condition, SQLDriver driver) throws Exception {
        if (this.dsRequest != null && this.dsRequest.getEndRow() == -1L && this.dsRequest.hasNonSqlCriteria() && !this.dsRequest.criteriaIsDivisible()) {
            log.warn((Object)"The presence of both SQL and non-SQL fields in the criteria requires that filtering logic be divided between SQL query and Java code. However, the criteria is indivisible so we cannot do this. Skipping SQL filtering and doing all filtering in Java code - this may drastically affect performance");
            return "'1'='1'";
        }
        if (condition instanceof String) {
            return "(" + condition + ")";
        }
        if (!this.isAdvanced) {
            if (condition instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)condition;
                Object value = entry.getValue();
                if (value instanceof List) {
                    List values = (List)value;
                    ArrayList<Map> equivalentExpression = new ArrayList<Map>();
                    Iterator i = values.iterator();
                    while (i.hasNext()) {
                        equivalentExpression.add(DataTools.buildMap(entry.getKey(), i.next()));
                    }
                    return this.buildCompoundExpression(equivalentExpression.iterator(), "OR", driver);
                }
                return this.buildExpression(entry.getKey().toString(), value, driver);
            }
            if (condition instanceof Map) {
                return this.buildCompoundExpression(((Map)condition).entrySet().iterator(), "AND", driver);
            }
            if (condition instanceof List) {
                return this.buildCompoundExpression(((List)condition).iterator(), "OR", driver);
            }
        } else {
            if (!(condition instanceof Map)) {
                throw new Exception("AdvancedCriteria was not an instance of Map");
            }
            String operator = (String)((Map)condition).get("operator");
            Object criteriaObject = ((Map)condition).get("criteria");
            String fieldName = (String)((Map)condition).get("fieldName");
            if (operator == null) {
                return "'1'='1'";
            }
            if (fieldName == null) {
                if (criteriaObject == null) {
                    return "'1'='1'";
                }
                if (criteriaObject instanceof Map && ((Map)criteriaObject).isEmpty()) {
                    return "'1'='1'";
                }
                if (criteriaObject instanceof List && ((List)criteriaObject).isEmpty()) {
                    return "'1'='1'";
                }
            }
            if ("and".equals(operator) || "or".equals(operator) || "not".equals(operator)) {
                if (!(criteriaObject instanceof List)) {
                    log.warn((Object)"Subcriteria of AdvancedCriteria not an instance of List - using empty ArrayList");
                    criteriaObject = new ArrayList();
                }
                List criteria = (List)criteriaObject;
                return this.buildCompoundExpression(criteria.iterator(), operator, driver);
            }
            Object value = ((Map)condition).get("value");
            if (fieldName == null || operator == null) {
                throw new Exception("AdvancedCriteria contains a clause with fieldName: '" + fieldName + "', operator: '" + operator + ", value '" + value + "'.  Aborting.");
            }
            Object start = ((Map)condition).get("start");
            Object end = ((Map)condition).get("end");
            return this.buildAdvancedExpression(fieldName, operator, value, start, end, driver);
        }
        throw new Exception("Data type: '" + condition.getClass().getName() + "' is not supported");
    }

    private String buildCompoundExpression(Iterator conditions, String operator, SQLDriver driver) throws Exception {
        if (!conditions.hasNext()) {
            log.info((Object)"empty condition");
            return "('1'='1')";
        }
        StringBuffer clause = new StringBuffer();
        while (conditions.hasNext()) {
            String subclause = this.getOutput(conditions.next(), driver);
            if (subclause == null) continue;
            if (clause.length() != 0) {
                if (!operator.equals("not")) {
                    clause.append(" " + operator.toUpperCase() + " ");
                } else {
                    clause.append(" OR ");
                }
            }
            clause.append(subclause);
        }
        if (clause.toString() == null || clause.toString().equals("")) {
            return null;
        }
        if (operator.equals("not")) {
            return "NOT(" + clause.toString() + ")";
        }
        return "(" + clause.toString() + ")";
    }

    private String buildExpression(String fieldName, Object value, SQLDriver driver) throws Exception {
        DataSource sqlDS;
        String overrideTableName = null;
        boolean skipCustomSQLCheck = false;
        if (this.customCriteriaFields != null) {
            Iterator i = this.customCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                skipCustomSQLCheck = true;
                break;
            }
        }
        BasicDataSource ds = null;
        DSField field = null;
        for (int i = 0; i < this.dataSources.size(); ++i) {
            ds = (BasicDataSource)this.dataSources.get(i);
            field = ds.getField(fieldName);
            if (field == null) continue;
            if (!skipCustomSQLCheck && (field.getBoolean("customSQL") || Boolean.FALSE.equals(field.get((Object)"canFilter")))) {
                return null;
            }
            if (field.get((Object)"tableName") == null) break;
            overrideTableName = field.get((Object)"tableName").toString();
            break;
        }
        if (!skipCustomSQLCheck && this.excludeCriteriaFields != null) {
            Iterator i = this.excludeCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                return null;
            }
        }
        String columnName = this.getColumnNameForField(fieldName);
        field = this.getField(fieldName);
        if (field != null && field.isInapplicable()) {
            return null;
        }
        if (columnName == null && field != null && field.get((Object)"customSQLExpression") == null && field.get((Object)"customSelectExpression") == null && field.get((Object)"customCriteriaExpression") == null) {
            log.warn((Object)("no column name for field named: " + fieldName + ", field2ColumnMap: " + DataTools.prettyPrint((Object)this.field2ColumnMap)));
            return "('1'='1')";
        }
        String columnType = ds.getSimpleBaseType(this.getFieldType(fieldName));
        if (columnType == null) {
            log.warn((Object)("Unable to find simple basetype for field " + fieldName + " (declared " + "type is " + this.getFieldType(fieldName) + ")"));
            columnType = "text";
        }
        IncludeFromDefinition incFrom = null;
        if (this.dsRequest != null) {
            List includeFrom = this.dsRequest.getIncludeFrom();
            incFrom = field != null ? IncludeFromDefinition.forField((List)includeFrom, (String)fieldName, (DataSource)((DataSource)this.dataSources.get(0)), (boolean)false, (boolean)true, (boolean)false) : IncludeFromDefinition.forField((List)includeFrom, (String)fieldName, null, (boolean)IncludeFromDefinition.isDynamicInclusion((String)fieldName), (boolean)true, (boolean)false);
        }
        if (field == null && incFrom == null) {
            return null;
        }
        if (field != null && !driver.fieldIsSearchable(field)) {
            return null;
        }
        String columnOrExpression = null;
        if (incFrom == null) {
            DataSource firstDS;
            String escapedColumnName = driver.escapeColumnName(columnName);
            String tableName = overrideTableName;
            if (tableName == null) {
                tableName = (String)this.column2TableMap.get(columnName);
            }
            if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
                tableName = ((SQLDataSource)firstDS).getTable().getName();
            }
            if (!this.qualifyColumnNames && overrideTableName != null) {
                escapedColumnName = overrideTableName + "." + escapedColumnName;
            } else if (tableName != null) {
                escapedColumnName = tableName + "." + escapedColumnName;
            }
            columnOrExpression = escapedColumnName;
            if (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) {
                columnOrExpression = this.getCustomSelectExpression(field);
            }
        } else {
            if (incFrom.isInError()) {
                return null;
            }
            if (!(incFrom.getDataSource() instanceof SQLDataSource)) {
                return null;
            }
            while (incFrom.getTargetIncludeFrom() != null) {
                if ((incFrom = incFrom.getTargetIncludeFrom()).getDataSource() instanceof SQLDataSource) continue;
                return null;
            }
            DSField incField = incFrom.getIncludedField();
            columnName = incField.getNativeName();
            if (columnName == null) {
                columnName = incField.getName();
            }
            String escapedColumnName = driver.escapeColumnName(columnName);
            SQLDataSource sqlDS2 = (SQLDataSource)incFrom.getDataSource();
            columnOrExpression = field != null && (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) ? this.getCustomSelectExpression(field) : sqlDS2.getTable().getName() + "." + escapedColumnName;
            field = incField;
        }
        if (field.get((Object)"customCriteriaExpression") != null) {
            String op = "equals";
            if ((columnType.equals("text") || columnType.equals("string")) && this.doFilter) {
                op = "startsWith".equals(this.filterStyle) ? "iStartsWith" : "iContains";
            }
            return this.getCustomCriteriaExpression(field, value, op);
        }
        if (value == null) {
            return columnOrExpression + " IS NULL";
        }
        if (columnType.equals("text") || columnType.equals("string")) {
            if (!this.doFilter || field.shouldIgnoreTextMatchStyle().equals(Boolean.TRUE)) {
                sqlDS = (DataSource)this.dataSources.get(0);
                if (sqlDS instanceof SQLDataSource) {
                    return columnOrExpression + "=" + driver.sqlInTransform(value, field, (SQLDataSource)sqlDS);
                }
                return columnOrExpression + "=" + driver.sqlInTransform(value, field, null);
            }
            return this.substringFilter(columnOrExpression, value, driver, (SQLDataSource)ds, field);
        }
        if (columnType.equals("number") || columnType.equals("integer") || columnType.equals("sequence") || columnType.equals("float")) {
            if (!this.doFilter || field.shouldIgnoreTextMatchStyle().equals(Boolean.TRUE)) {
                if (value instanceof String) {
                    try {
                        value = columnType.equals("float") ? new BigDecimal((String)value).toString() : new BigInteger((String)value).toString();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Got non-numeric value '" + value + "' for numeric column '" + columnName + "', creating literal false expression: " + e));
                        return "'0'='1'";
                    }
                    return columnOrExpression + "=" + value.toString();
                }
            } else if (value instanceof String || "substring".equals(this.dsRequest.getTextMatchStyle())) {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                return this.substringFilter(columnOrExpression, value, driver, true, (SQLDataSource)ds, field);
            }
        }
        if ((sqlDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
            return columnOrExpression + "=" + driver.sqlInTransform(value, field, (SQLDataSource)sqlDS);
        }
        return columnOrExpression + "=" + driver.sqlInTransform(value, field, null);
    }

    private String getCustomSelectExpression(DSField field) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        String expr = (String)field.get((Object)"customSelectExpression");
        if (expr == null) {
            expr = (String)field.get((Object)"customSQLExpression");
        }
        return Velocity.evaluateAsString((String)expr, (Map)context, (String)"customSelectExpression", (DataSource)this.dsRequest.getDataSource(), (boolean)field.getBoolean("autoQuoteCustomExpressions", true));
    }

    private String getCustomCriteriaExpression(DSField field, Object value, String operator) throws Exception {
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        context.put("criteriaValue", value);
        context.put("criteriaOperator", operator);
        String expr = (String)field.get((Object)"customCriteriaExpression");
        return Velocity.evaluateAsString((String)expr, (Map)context, (String)"customCriteriaExpression", (DataSource)this.dsRequest.getDataSource(), (boolean)field.getBoolean("autoQuoteCustomExpressions", true));
    }

    private String substringFilter(String lval, Object rval, SQLDriver driver, SQLDataSource ds, DSField field) {
        return this.substringFilter(lval, rval, driver, false, ds, field);
    }

    private String substringFilter(String lvalue, Object rvalue, SQLDriver driver, boolean isNumber, SQLDataSource ds, DSField field) {
        if (driver.caseInsensitiveStrategy() != 0) {
            String sql = driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(";
            sql = driver.castNumbersBeforeLikeCompare() && isNumber ? sql + "CAST(" + lvalue + " AS varchar(50))" : sql + lvalue;
            String compare = rvalue.toString();
            compare = driver.caseInsensitiveStrategy() == 2 ? compare.toUpperCase() : compare.toLowerCase();
            return sql + ") LIKE " + driver.sqlFilterTransform(compare, field, ds, this.filterStyle) + driver.escapeClause();
        }
        String sql = driver.castNumbersBeforeLikeCompare() && isNumber ? "CAST(" + lvalue + " AS varchar(50))" : lvalue;
        return sql + " LIKE " + driver.escapeValueForFilter(rvalue.toString(), this.filterStyle);
    }

    private String getColumnNameForField(String fieldName) {
        return this.getColumnNameForField(fieldName, false);
    }

    private String getColumnNameForField(String fieldName, boolean forceNoUndeclaredFields) {
        if (this.field2ColumnMap == null) {
            return fieldName;
        }
        String columnName = (String)this.field2ColumnMap.get(fieldName);
        if (columnName != null) {
            if (columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            return columnName;
        }
        if (this.keepUndeclaredFields && !forceNoUndeclaredFields) {
            return fieldName;
        }
        return null;
    }

    private DSField getField(String fieldName) {
        if (this.dataSources != null) {
            for (SQLDataSource ds : this.dataSources) {
                DSField field = ds.getField(fieldName);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    private String getFieldType(String fieldName) {
        DSField field = this.getField(fieldName);
        return field == null ? "text" : field.getType();
    }

    private String buildAdvancedExpression(String fieldName, String operator, Object value, Object start, Object end, SQLDriver driver) throws Exception {
        String otherColumnType;
        DSField field;
        String overrideTableName = null;
        boolean skipCustomSQLCheck = false;
        if (this.customCriteriaFields != null) {
            Iterator i = this.customCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                skipCustomSQLCheck = true;
                break;
            }
        }
        BasicDataSource ds = null;
        for (int i = 0; i < this.dataSources.size(); ++i) {
            ds = (BasicDataSource)this.dataSources.get(i);
            field = ds.getField(fieldName);
            if (field == null) continue;
            if (!skipCustomSQLCheck && (field.getBoolean("customSQL") || Boolean.FALSE.equals(field.get((Object)"canFilter")))) {
                return null;
            }
            if (field.get((Object)"tableName") == null) break;
            overrideTableName = field.get((Object)"tableName").toString();
            break;
        }
        if (!skipCustomSQLCheck && this.excludeCriteriaFields != null) {
            Iterator i = this.excludeCriteriaFields.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(fieldName)) continue;
                return null;
            }
        }
        String columnName = this.getColumnNameForField(fieldName);
        field = this.getField(fieldName);
        if (field != null && field.isInapplicable()) {
            return null;
        }
        if (columnName == null && field != null && field.get((Object)"customSQLExpression") == null && field.get((Object)"customSelectExpression") == null && field.get((Object)"customCriteriaExpression") == null) {
            log.warn((Object)("no column name for field named: " + fieldName + ", field2ColumnMap: " + DataTools.prettyPrint((Object)this.field2ColumnMap)));
            return null;
        }
        String columnType = null;
        columnType = ds.getSimpleBaseType(this.getFieldType(fieldName));
        if (columnType == null) {
            log.warn((Object)("Unable to find simple basetype for field " + fieldName + " (declared " + "type is " + this.getFieldType(fieldName) + ")"));
            columnType = "text";
        }
        if (columnType == null) {
            columnType = "text";
        }
        IncludeFromDefinition incFrom = null;
        if (this.dsRequest != null) {
            List includeFrom = this.dsRequest.getIncludeFrom();
            incFrom = field != null ? IncludeFromDefinition.forField((List)includeFrom, (String)fieldName, (DataSource)((DataSource)this.dataSources.get(0)), (boolean)false, (boolean)true, (boolean)false) : IncludeFromDefinition.forField((List)includeFrom, (String)fieldName, null, (boolean)IncludeFromDefinition.isDynamicInclusion((String)fieldName), (boolean)true, (boolean)false);
        }
        if (field == null && incFrom == null) {
            return "'1'='1'";
        }
        if (field != null && !driver.fieldIsSearchable(field)) {
            return "'1'='1'";
        }
        String columnOrExpression = null;
        if (incFrom == null) {
            if (field.get((Object)"customCriteriaExpression") != null) {
                return this.getCustomCriteriaExpression(field, value, operator);
            }
            columnOrExpression = this.deriveColumnName(columnName, field, overrideTableName, driver);
        } else {
            if (incFrom.isInError()) {
                return null;
            }
            if (!(incFrom.getDataSource() instanceof SQLDataSource)) {
                return null;
            }
            while (incFrom.getTargetIncludeFrom() != null) {
                if ((incFrom = incFrom.getTargetIncludeFrom()).getDataSource() instanceof SQLDataSource) continue;
                return null;
            }
            DSField incField = incFrom.getIncludedField();
            columnName = incField.getNativeName();
            if (columnName == null) {
                columnName = incField.getName();
            }
            String escapedColumnName = driver.escapeColumnName(columnName);
            SQLDataSource sqlDS = (SQLDataSource)incFrom.getDataSource();
            columnOrExpression = field != null && (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) ? this.getCustomSelectExpression(field) : sqlDS.getTable().getName() + "." + escapedColumnName;
            field = incField;
            ds = sqlDS;
        }
        if (operator.equals("contains") || operator.equals("iContains") || operator.equals("startsWith") || operator.equals("iStartsWith") || operator.equals("endsWith") || operator.equals("iEndsWith") || operator.equals("iEquals")) {
            return this.stringComparison(columnOrExpression, columnType, operator, value, false, driver, field, ds);
        }
        if (operator.equals("notContains") || operator.equals("iNotContains") || operator.equals("notStartsWith") || operator.equals("iNotStartsWith") || operator.equals("notEndsWith") || operator.equals("iNotEndsWith") || operator.equals("iNotEqual")) {
            return this.stringComparison(columnOrExpression, columnType, operator, value, true, driver, field, ds);
        }
        if (operator.equals("equals") || operator.equals("notEqual") || operator.equals("greaterThan") || operator.equals("greaterOrEqual") || operator.equals("lessThan") || operator.equals("lessOrEqual") || operator.equals("between") || operator.equals("betweenInclusive") || operator.equals("iBetween") || operator.equals("iBetweenInclusive")) {
            return this.valueComparison(columnOrExpression, columnType, operator, value, start, end, driver, fieldName);
        }
        if (operator.equals("isNull") || operator.equals("notNull")) {
            return this.nullComparison(columnOrExpression, operator, driver);
        }
        if (operator.equals("inSet") || operator.equals("notInSet")) {
            return this.setComparison(columnOrExpression, columnType, operator, value, operator.equals("notInSet"), driver, fieldName);
        }
        if (operator.equals("equalsField") || operator.equals("notEqualField") || operator.equals("greaterThanField") || operator.equals("greaterOrEqualField") || operator.equals("lessThanField") || operator.equals("lessOrEqualField")) {
            otherColumnType = "";
            if (value != null) {
                otherColumnType = this.getFieldType(value.toString());
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldComparison(columnOrExpression, columnType, operator, (String)value, otherColumnType, operator.equals("notEqualField"), driver, (SQLDataSource)ds, incFrom);
            }
            return null;
        }
        if (operator.equals("containsField") || operator.equals("iContainsField") || operator.equals("startsWithField") || operator.equals("iStartsWithField") || operator.equals("endsWithField") || operator.equals("iEndsWithField") || operator.equals("iEqualsField")) {
            otherColumnType = "";
            if (value != null) {
                otherColumnType = this.getFieldType(value.toString());
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldStringComparison(columnOrExpression, columnType, operator, (String)value, false, otherColumnType, driver, (SQLDataSource)ds);
            }
            return null;
        }
        if (operator.equals("notContainsField") || operator.equals("iNotContainsField") || operator.equals("notStartsWithField") || operator.equals("iNotStartsWithField") || operator.equals("notEndsWithField") || operator.equals("iNotEndsWithField") || operator.equals("iNotEqualField")) {
            otherColumnType = "";
            if (value != null) {
                otherColumnType = this.getFieldType(value.toString());
            }
            if (ds instanceof SQLDataSource) {
                return this.fieldStringComparison(columnOrExpression, columnType, operator, (String)value, true, otherColumnType, driver, (SQLDataSource)ds);
            }
            return null;
        }
        if (operator.equals("regexp") || operator.equals("iregexp")) {
            log.info((Object)"'regexp' and 'iregexp' conditions are ignored on the server");
            return "('1'='1')";
        }
        log.warn((Object)("Found unknown operator " + operator));
        return "('1'='1')";
    }

    private String deriveColumnName(String columnName, DSField field, String overrideTableName, SQLDriver driver) throws Exception {
        DataSource firstDS;
        String escapedColumnName = driver.escapeColumnName(columnName);
        String tableName = overrideTableName;
        if (tableName == null) {
            tableName = (String)this.column2TableMap.get(columnName);
        }
        if (tableName == null && this.qualifyColumnNames && (firstDS = (DataSource)this.dataSources.get(0)) instanceof SQLDataSource) {
            tableName = ((SQLDataSource)firstDS).getTable().getName();
        }
        if (tableName != null) {
            escapedColumnName = tableName + "." + escapedColumnName;
        }
        if (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) {
            return this.getCustomSelectExpression(field);
        }
        return escapedColumnName;
    }

    private String stringComparison(String fieldName, String columnType, String operator, Object objVal, boolean negate, SQLDriver driver, DSField field, BasicDataSource ds) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        if (driver.castNumbersBeforeLikeCompare() && (columnType.equals("integer") || columnType.equals("float") || columnType.equals("sequence") || columnType.equals("number"))) {
            fieldName = "CAST(" + fieldName + " AS varchar(50))";
        }
        if (!(columnType.equals("text") || columnType.equals("string") || columnType.equals("integer") || columnType.equals("float") || columnType.equals("sequence") || columnType.equals("number"))) {
            if (columnType.equals("date")) {
                log.warn((Object)("Attempt to compare a Date as String, testing value " + objVal + " with operator " + operator + ". This is an invalid comparison, so we are returning " + (negate ? "TRUE" : "FALSE.")));
            }
            if (columnType.equals("boolean")) {
                log.warn((Object)("Attempt to compare a Boolean as String, testing value " + objVal + " with operator " + operator + ". This is an invalid comparison, so we are returning " + (negate ? "TRUE" : "FALSE.")));
            }
            if (negate) {
                return "('1'='1')";
            }
            return "'0'='1'";
        }
        String operatorText = "iNotEqual".equals(operator) || "iEquals".equals(operator) ? "=" : "LIKE";
        boolean usingLike = "LIKE".equals(operatorText);
        StringBuffer sql = new StringBuffer("(");
        if (driver.caseInsensitiveStrategy() != 0) {
            if (operator.startsWith("i")) {
                sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
                sql.append(fieldName + ") " + operatorText + " ");
            } else {
                sql.append(fieldName + " " + operatorText + " ");
            }
        } else if (operator.startsWith("i")) {
            sql.append(fieldName + " " + operatorText + " ");
        } else {
            sql.append(fieldName + " LIKE BINARY ");
            usingLike = true;
        }
        if (objVal == null) {
            objVal = "";
        }
        String value = objVal.toString();
        value = driver.escapeValueUnquoted(value, usingLike);
        if (operator.startsWith("i") && driver.caseInsensitiveStrategy() != 0) {
            sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
        }
        if (field != null) {
            sql.append(driver.getLiteralPrefix(field, ds));
        }
        sql.append("'");
        if (operator.indexOf("ndsWith") != -1 || operator.indexOf("tains") != -1) {
            sql.append("%");
        }
        if (operator.startsWith("i")) {
            sql.append(value.toLowerCase());
        } else {
            sql.append(value);
        }
        if (operator.indexOf("rtsWith") != -1 || operator.indexOf("tains") != -1) {
            sql.append("%");
        }
        sql.append("'");
        if (operator.startsWith("i") && driver.caseInsensitiveStrategy() != 0) {
            sql.append(")");
        }
        if (usingLike) {
            sql.append(driver.escapeClause());
        }
        if (!this.strictSQLFiltering) {
            sql.append(" AND " + fieldName + " IS NOT NULL");
        }
        sql.append(")");
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private String valueComparison(String fieldName, String columnType, String operator, Object value, Object start, Object end, SQLDriver driver, String realFieldName) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        DSField field = null;
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        if (firstDS != null) {
            field = firstDS.getField(realFieldName);
        }
        if (("text".equals(columnType) || "string".equals(columnType)) && (value instanceof Date || start instanceof Date || end instanceof Date)) {
            if (operator.equals("notEqual")) {
                return "('1'='1')";
            }
            return "('0'='1')";
        }
        String fieldType = field == null ? null : field.getType();
        value = this.castValue(value, columnType, fieldType, firstDS);
        start = this.castValue(start, columnType, fieldType, firstDS);
        end = this.castValue(end, columnType, fieldType, firstDS);
        if ("integer".equals(columnType) && value != null && !(value instanceof Number) || "float".equals(columnType) && value != null && !(value instanceof Number) || "date".equals(columnType) && value != null && !(value instanceof Date) || "integer".equals(columnType) && start != null && !(start instanceof Number) || "float".equals(columnType) && start != null && !(start instanceof Number) || "date".equals(columnType) && start != null && !(start instanceof Date) || "integer".equals(columnType) && end != null && !(end instanceof Number) || "float".equals(columnType) && end != null && !(end instanceof Number) || "date".equals(columnType) && end != null && !(end instanceof Date)) {
            if (operator.equals("notEqual")) {
                if (this.strictSQLFiltering) {
                    return "(" + fieldName + " = " + fieldName + ")";
                }
                return "('1'='1')";
            }
            if (operator.equals("lessThan") || operator.equals("lessOrEqual")) {
                if (this.strictSQLFiltering) {
                    return "(" + fieldName + " <> " + fieldName + " AND " + fieldName + " IS NULL)";
                }
                return "(" + fieldName + " IS NULL)";
            }
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " <> " + fieldName + " AND " + fieldName + " IS NULL)";
            }
            return "('0'='1')";
        }
        if (value != null) {
            value = driver.sqlInTransform(value, field, firstDS);
        }
        if (start != null) {
            start = driver.sqlInTransform(start, field, firstDS);
        }
        if (end != null) {
            end = driver.sqlInTransform(end, field, firstDS);
        }
        if (operator.equals("equals")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " = " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " = " + value + " AND " + fieldName + " IS NOT NULL)";
            }
            return "(" + fieldName + " IS NULL)";
        }
        if (operator.equals("notEqual")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " <> " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " <> " + value + " OR " + fieldName + " IS NULL)";
            }
            return "(" + fieldName + " IS NOT NULL)";
        }
        if (operator.equals("greaterThan")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " > " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " > " + value + " AND " + fieldName + " IS NOT NULL)";
            }
            return "('1'='1')";
        }
        if (operator.equals("greaterOrEqual")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " >= " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " >= " + value + " AND " + fieldName + " IS NOT NULL)";
            }
            return "('1'='1')";
        }
        if (operator.equals("lessThan")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " < " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " < " + value + " OR " + fieldName + " IS NULL)";
            }
            return "('1'='1')";
        }
        if (operator.equals("lessOrEqual")) {
            if (this.strictSQLFiltering) {
                return "(" + fieldName + " <= " + value + ")";
            }
            if (value != null) {
                return "(" + fieldName + " <= " + value + " OR " + fieldName + " IS NULL)";
            }
            return "('1'='1')";
        }
        if (operator.equals("between") || operator.equals("iBetween")) {
            String lEnd;
            boolean ignoreCase = operator.equals("iBetween") && "text".equals(columnType);
            String prefix = ignoreCase ? "lower(" : "";
            String suffix = ignoreCase ? ")" : "";
            String lFieldName = prefix + fieldName + suffix;
            String lStart = start == null ? "null" : prefix + start + suffix;
            String string = lEnd = end == null ? "null" : prefix + end + suffix;
            if (this.strictSQLFiltering) {
                return "(" + lFieldName + " > " + lStart + " AND " + lFieldName + " < " + lEnd + ")";
            }
            if (start == null && end != null) {
                return "(" + lFieldName + " < " + lEnd + " OR " + fieldName + " IS NULL)";
            }
            if (start != null && end == null) {
                return "(" + lFieldName + " > " + lStart + ")";
            }
            if (start != null && end != null) {
                return "(" + lFieldName + " > " + lStart + " AND " + lFieldName + " < " + lEnd + " AND " + fieldName + " IS NOT NULL)";
            }
            return "('1'='1')";
        }
        if (operator.equals("betweenInclusive") || operator.equals("iBetweenInclusive")) {
            String lEnd;
            boolean ignoreCase = operator.equals("iBetweenInclusive") && "text".equals(columnType);
            String prefix = ignoreCase ? "lower(" : "";
            String suffix = ignoreCase ? ")" : "";
            String lFieldName = prefix + fieldName + suffix;
            String lStart = start == null ? "null" : prefix + start + suffix;
            String string = lEnd = end == null ? "null" : prefix + end + suffix;
            if (this.strictSQLFiltering) {
                return "(" + lFieldName + " >= " + lStart + " AND " + lFieldName + " <= " + lEnd + ")";
            }
            if (start == null && end != null) {
                return "(" + lFieldName + " <= " + lEnd + " OR " + fieldName + " IS NULL)";
            }
            if (start != null && end == null) {
                return "(" + lFieldName + " >= " + lStart + ")";
            }
            if (start != null && end != null) {
                return "(" + lFieldName + " >= " + lStart + " AND " + lFieldName + " <= " + lEnd + " AND " + fieldName + " IS NOT NULL)";
            }
            return "('1'='1')";
        }
        return "('1'='1')";
    }

    private String nullComparison(String fieldName, String operator, SQLDriver driver) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        if (operator.equals("isNull")) {
            return "(" + fieldName + " IS NULL)";
        }
        return "(" + fieldName + " IS NOT NULL)";
    }

    private String setComparison(String fieldName, String columnType, String operator, Object value, boolean negate, SQLDriver driver, String realFieldName) {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        DSField field = null;
        SQLDataSource firstDS = (SQLDataSource)((Object)this.dataSources.get(0));
        if (firstDS != null) {
            field = firstDS.getField(realFieldName);
        }
        if (value == null) {
            value = new ArrayList();
        }
        if (!(value instanceof List)) {
            ArrayList val = value;
            value = new ArrayList();
            ((List)value).add(val);
        } else {
            value = new ArrayList(value);
        }
        int size = ((List)value).size();
        for (int i = 0; i < size; ++i) {
            Object work = ((List)value).get(i);
            work = this.castValue(work, columnType, field == null ? null : field.getType(), firstDS);
            if ("integer".equals(columnType) && work != null && !(work instanceof Number) || "float".equals(columnType) && work != null && !(work instanceof Number) || "date".equals(columnType) && work != null && !(work instanceof Date)) {
                ((List)value).set(i, null);
                continue;
            }
            if (work != null) {
                work = driver.sqlInTransform(work, field, firstDS);
            }
            ((List)value).set(i, work);
        }
        while (((List)value).contains(null)) {
            ((List)value).remove(null);
        }
        StringBuffer sql = new StringBuffer();
        if (((List)value).isEmpty()) {
            sql.append("('0'='1')");
        } else {
            sql.append("((" + fieldName + " IN (");
            int setSize = driver.getMaximumSetSize();
            if (setSize == 0) {
                setSize = ((List)value).size();
            }
            int j = 0;
            for (int i = 0; i < ((List)value).size(); ++i) {
                if (j >= setSize) {
                    sql.append(") OR " + fieldName + " IN (");
                    j = 0;
                }
                if (i > 0 && j > 0) {
                    sql.append(", ");
                }
                sql.append(((List)value).get(i));
                ++j;
            }
            sql.append(")) AND " + fieldName + " IS NOT NULL)");
        }
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private String fieldComparison(String fieldName, String columnType, String operator, String otherFieldName, String otherColumnType, boolean negate, SQLDriver driver, SQLDataSource ds, IncludeFromDefinition incFrom) throws Exception {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        if (otherFieldName == null) {
            log.error((Object)"Found a null 'other' fieldName in a field comparison");
            return "('1'='1')";
        }
        String columnName = this.getColumnNameForField(otherFieldName, true);
        if (columnName == null) {
            log.warn((Object)("no column name for field named: " + otherFieldName));
            return "('1'='1')";
        }
        String columnOrExpression = null;
        if (incFrom == null) {
            DSField field = ds.getField(otherFieldName);
            if (field.get((Object)"customCriteriaExpression") != null) {
                log.warn((Object)("Field " + otherFieldName + " appeared on the right-hand side of " + "a '" + operator + "' clause.  This is not supported - fields with " + "customCriteriaExpression may not appear in ordinary field " + "comparison criteria"));
                return null;
            }
            columnOrExpression = this.deriveColumnName(columnName, field, ds.getTable().getName(), driver);
        }
        if (!columnType.equals(otherColumnType)) {
            if (negate) {
                return "('1'='1')";
            }
            return "('0'='1')";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        if (operator.equals("equalsField")) {
            sql.append("(" + fieldName + " IS NULL AND " + columnOrExpression + " IS NULL)");
        } else if (operator.equals("notEqualField")) {
            sql.append("((" + fieldName + " IS NULL AND " + columnOrExpression + " IS NOT NULL) OR ");
            sql.append("(" + fieldName + " IS NOT NULL AND " + columnOrExpression + " IS NULL))");
        } else if (operator.equals("lessThanField")) {
            sql.append("(" + fieldName + " IS NULL AND " + columnOrExpression + " IS NOT NULL)");
        } else if (operator.equals("lessOrEqualField")) {
            sql.append("(" + fieldName + " IS NULL)");
        } else if (operator.equals("greaterThanField")) {
            sql.append("(" + fieldName + " IS NOT NULL AND " + columnOrExpression + " IS NULL)");
        } else {
            sql.append("(" + columnOrExpression + " IS NULL)");
        }
        if (driver.caseInsensitiveStrategy() == 0) {
            fieldName = "CAST(" + fieldName + " AS BINARY)";
        }
        sql.append(" OR (" + fieldName + " " + this.operatorToSql.get(operator) + " ");
        sql.append(columnOrExpression + " AND ");
        sql.append(fieldName + " IS NOT NULL AND " + columnOrExpression + " IS NOT NULL)");
        sql.append(")");
        return sql.toString();
    }

    private String fieldStringComparison(String fieldName, String columnType, String operator, String otherFieldName, boolean negate, String otherColumnType, SQLDriver driver, SQLDataSource ds) throws Exception {
        if (fieldName == null) {
            log.error((Object)"Found a null fieldName");
            return "('1'='1')";
        }
        String columnName = this.getColumnNameForField(otherFieldName, true);
        if (columnName == null) {
            log.warn((Object)("no column name for field named: " + otherFieldName));
            return "('1'='1')";
        }
        DSField field = ds.getField(otherFieldName);
        if (field.get((Object)"customCriteriaExpression") != null) {
            log.warn((Object)("Field " + otherFieldName + " appeared on the right-hand side of " + "a '" + operator + "' clause.  This is not supported - fields with " + "customCriteriaExpression may not appear in ordinary field " + "comparison criteria"));
            return null;
        }
        otherFieldName = this.deriveColumnName(columnName, field, ds.getTable().getName(), driver);
        if (driver.castNumbersBeforeLikeCompare()) {
            if (columnType.equals("integer") || columnType.equals("float") || columnType.equals("sequence") || columnType.equals("number")) {
                fieldName = "CAST(" + fieldName + " AS varchar(50))";
            }
            if (otherColumnType.equals("integer") || otherColumnType.equals("float") || otherColumnType.equals("sequence") || otherColumnType.equals("number")) {
                otherFieldName = "CAST(" + otherFieldName + " AS varchar(50))";
            }
        }
        if (!(columnType.equals("text") || columnType.equals("string") || columnType.equals("integer") || columnType.equals("float") || columnType.equals("sequence") || columnType.equals("number"))) {
            if (negate) {
                return "('1'='1')";
            }
            return "'0'='1'";
        }
        StringBuffer sql = new StringBuffer("(");
        if (!this.strictSQLFiltering) {
            sql.append(otherFieldName + " IS NULL");
            if (operator.toLowerCase().contains("Equal".toLowerCase())) {
                sql.insert(0, "(");
                sql.append(" AND " + fieldName + " IS NULL)");
            }
            sql.append(" OR (");
        }
        if (driver.caseInsensitiveStrategy() != 0) {
            if (operator.startsWith("i")) {
                sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
                sql.append(fieldName + ") LIKE ");
            } else {
                sql.append(fieldName + " LIKE ");
            }
        } else if (operator.startsWith("i")) {
            sql.append(fieldName + " LIKE ");
        } else {
            sql.append(fieldName + " LIKE BINARY ");
        }
        if (operator.startsWith("i") && driver.caseInsensitiveStrategy() != 0) {
            sql.append(driver.caseInsensitiveStrategy() == 2 ? "UPPER(" : "LOWER(");
        }
        if (operator.indexOf("ndsWith") != -1) {
            sql.append(driver.sqlConcat("'%'", otherFieldName));
        } else if (operator.indexOf("tains") != -1) {
            sql.append(driver.sqlConcat("'%'", otherFieldName, "'%'"));
        } else if (operator.indexOf("rtsWith") != -1) {
            sql.append(driver.sqlConcat(otherFieldName, "'%'"));
        } else {
            sql.append(otherFieldName);
        }
        if (operator.startsWith("i") && driver.caseInsensitiveStrategy() != 0) {
            sql.append(")");
        }
        sql.append(driver.escapeClause());
        if (!this.strictSQLFiltering) {
            sql.append(" AND " + fieldName + " IS NOT NULL AND " + otherFieldName + " IS NOT NULL)");
        }
        sql.append(")");
        if (negate) {
            sql.insert(0, "NOT");
        }
        return sql.toString();
    }

    private Object castValue(Object value, String columnType, String fieldType, BasicDataSource ds) {
        if (value instanceof String) {
            String text = (String)value;
            try {
                if (this.inheritsFromType(fieldType, "datetime", ds)) {
                    value = JSTranslater.parseDate((String)(text.indexOf(84) >= 0 ? "yyyy-MM-dd'T'HH:mm:ss" : "yyyy-MM-dd kk:mm:ss"), (String)text);
                } else if (this.inheritsFromType(fieldType, "date", ds)) {
                    value = JSTranslater.parseDate((String)"yyyy-MM-dd", (String)text);
                } else if (this.inheritsFromType(fieldType, "time", ds)) {
                    value = JSTranslater.parseDate((String)"HH:mm:ss", (String)text);
                }
            }
            catch (Exception e) {
                log.warn((Object)("String '" + text + "' was passed as filter criteria for a " + fieldType + " field, but it could not be parsed."));
            }
        }
        if (value instanceof String) {
            try {
                Number temp;
                if (this.inheritsFromType(columnType, "integer", ds)) {
                    temp = new Long((String)value);
                    value = temp;
                }
                if (this.inheritsFromType(columnType, "float", ds)) {
                    temp = new Double((String)value);
                    value = temp;
                }
            }
            catch (Exception e) {
                log.warn((Object)("String '" + value + "' was passed as filter criteria for a " + "numeric field. We could not parse it."));
            }
        }
        if (value != null && !(value instanceof String) && (this.inheritsFromType(columnType, "text", ds) || this.inheritsFromType(columnType, "string", ds))) {
            value = value.toString();
        }
        return value;
    }

    private boolean inheritsFromType(String typeId, String parentTypeId, BasicDataSource ds) {
        if (ds != null) {
            try {
                return ds.simpleTypeInheritsFrom(typeId, parentTypeId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parentTypeId != null && parentTypeId.equalsIgnoreCase(typeId);
    }
}

