/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Const;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.StreamingResponseException;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ExcelDataExport;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DSResponse {
    private static Logger log = new Logger(DSResponse.class.getName());
    public static final int STATUS_SUCCESS = RPCResponse.STATUS_SUCCESS;
    public static final int STATUS_FAILURE = RPCResponse.STATUS_FAILURE;
    public static final int STATUS_LOGIN_INCORRECT = -5;
    public static final int STATUS_MAX_LOGIN_ATTEMPTS_EXCEEDED = -6;
    public static final int STATUS_LOGIN_REQUIRED = -7;
    public static final int STATUS_LOGIN_SUCCESS = -8;
    public static final int UPDATE_WITHOUT_PK = -9;
    public static final int STATUS_TRANSACTION_FAILED = -10;
    public static final int STATUS_MAX_FILE_SIZE_EXCEEDED = -11;
    public static final int STATUS_VALIDATION_ERROR = Const.VALIDATION_ERROR;
    private DataSource dataSource;
    protected Map responseData = new HashMap();
    private Boolean bypassDataFilter = new Boolean(false);
    private Boolean dropExtraFields;
    long affectedRows = 0L;
    private List beanList;
    private long requestEndRow;
    private int status = Const.UNSET;
    private List relatedUpdates;
    private List errors;
    private boolean requestConnectionClose = false;
    OutputStream exportOutputStream = null;
    Object exportObject = null;
    private Map streamingContext;
    private boolean hasNextRecord;
    private boolean progressiveLoading = false;

    public String getOperationType() {
        return (String)this.responseData.get("operationType");
    }

    public DSResponse setOperationType(String value) {
        this.responseData.put("operationType", value);
        return this;
    }

    public Object getParameter(Object key) {
        return this.responseData.get(key);
    }

    public DSResponse setParameter(Object key, Object value) {
        if (key != null && value != null) {
            this.responseData.put(key, value);
        } else if (key != null) {
            this.responseData.remove(key);
        }
        return this;
    }

    public DSResponse setProperty(String key, Object value) {
        this.setParameter(key, value);
        return this;
    }

    public Object getProperty(String key) {
        return this.getParameter(key);
    }

    public DSResponse() {
        this.responseData.put("invalidateCache", new Boolean(false));
        this.responseData.put("isDSResponse", new Boolean(true));
        this.setSuccess();
    }

    public DSResponse(int status) {
        this();
        this.setStatus(status);
    }

    public DSResponse(Object data) {
        this();
        this.setData(data);
    }

    public DSResponse(Object data, int status) {
        this();
        this.setData(data);
        this.setStatus(status);
    }

    public DSResponse(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
    }

    public DSResponse(DataSource dataSource, int status) {
        this();
        this.setDataSource(dataSource);
        this.setStatus(status);
    }

    public DSResponse(DataSource dataSource, Object data) {
        this();
        this.setDataSource(dataSource);
        this.setData(data);
    }

    public DSResponse(DataSource dataSource, Object data, int status) {
        this();
        this.setDataSource(dataSource);
        this.setData(data);
        this.setStatus(status);
    }

    public Boolean getBypassDataFilter() {
        return this.bypassDataFilter;
    }

    public DSResponse setBypassDataFilter(Boolean value) {
        this.bypassDataFilter = value;
        return this;
    }

    public Boolean getDropExtraFields() {
        return this.dropExtraFields;
    }

    public DSResponse setDropExtraFields(Boolean value) {
        this.dropExtraFields = value;
        return this;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public DSResponse setAffectedRows(long affectedRows) {
        this.affectedRows = affectedRows;
        return this;
    }

    public boolean getInvalidateCache() {
        return (Boolean)this.responseData.get("invalidateCache");
    }

    public DSResponse setInvalidateCache(boolean invalidateCache) {
        this.responseData.put("invalidateCache", new Boolean(invalidateCache));
        return this;
    }

    public DSResponse setData(Object data) {
        this.setParameter("data", data);
        if (data instanceof List) {
            long rowCount = ((List)data).size();
            log.info("DSResponse: List with " + rowCount + " items");
        } else if (data instanceof Map) {
            long rowCount = ((Map)data).size();
            log.info("DSResponse: Map with " + rowCount + " keys");
        }
        return this;
    }

    public List getDataList() {
        Object data = this.getData();
        if (data instanceof JSONFilter) {
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof List) {
            return (List)data;
        }
        return null;
    }

    public Map getDataMap() {
        Object data = this.getData();
        if (data instanceof JSONFilter) {
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof Map) {
            return (Map)data;
        }
        List theData = this.getDataList();
        if (theData == null || theData.isEmpty()) {
            return null;
        }
        if (theData.get(0) instanceof Map) {
            return (Map)theData.get(0);
        }
        return null;
    }

    public Object getData() {
        return this.getParameter("data");
    }

    public Object getDataField(String name) {
        Map resultRow = this.getDataMap();
        if (resultRow == null) {
            return null;
        }
        return resultRow.get(name);
    }

    public List getBeanList() {
        return this.beanList;
    }

    public void setBeanList(List beanList) {
        this.beanList = beanList;
    }

    public long getStartRow() {
        Object startRow = this.responseData.get("startRow");
        if (startRow == null) {
            return -1L;
        }
        return Long.parseLong(startRow.toString());
    }

    public DSResponse setStartRow(long startRow) {
        this.responseData.put("startRow", new Long(startRow));
        return this;
    }

    public long getEndRow() {
        Object endRow = this.responseData.get("endRow");
        if (endRow == null) {
            return -1L;
        }
        return Long.parseLong(endRow.toString());
    }

    public DSResponse setEndRow(long endRow) {
        this.responseData.put("endRow", new Long(endRow));
        long startRow = this.getStartRow();
        if (startRow > endRow) {
            this.setStartRow(Math.max(0L, Math.min(startRow, endRow)));
        }
        return this;
    }

    public long getTotalRows() {
        Object totalRows = this.responseData.get("totalRows");
        if (totalRows == null) {
            return -1L;
        }
        return Long.parseLong(totalRows.toString());
    }

    public DSResponse setTotalRows(long totalRows) {
        this.responseData.put("totalRows", new Long(totalRows));
        return this;
    }

    public void setRequestEndRow(long value) {
        this.requestEndRow = value;
    }

    public long getRequestEndRow() {
        return this.requestEndRow;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean statusIsError() {
        return this.status < 0;
    }

    public boolean statusIsSuccess() {
        return this.status == STATUS_SUCCESS;
    }

    public DSResponse setStatus(int status) {
        this.status = status;
        return this;
    }

    public DSResponse setSuccess() {
        this.setStatus(STATUS_SUCCESS);
        return this;
    }

    public DSResponse setFailure() {
        this.setStatus(STATUS_FAILURE);
        return this;
    }

    public DSResponse setFailure(String message) {
        this.setStatus(STATUS_FAILURE);
        this.setData(message);
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DSResponse setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public List getRelatedUpdates() {
        return this.relatedUpdates;
    }

    public DSResponse addRelatedUpdate(DSResponse relatedUpdate) {
        if (relatedUpdate.getDataSource() == null) {
            relatedUpdate.setDataSource(this.getDataSource());
        }
        relatedUpdate.setProperty("dataSource", relatedUpdate.getDataSource().getID());
        if (relatedUpdate.getOperationType() == null) {
            relatedUpdate.setOperationType(this.getOperationType());
        }
        if (this.relatedUpdates == null) {
            this.relatedUpdates = new ArrayList();
        }
        this.relatedUpdates.add(relatedUpdate);
        return this;
    }

    public List getErrors() {
        return this.errors;
    }

    public DSResponse setErrors(List errors) {
        this.errors = errors;
        this.setStatus(STATUS_VALIDATION_ERROR);
        return this;
    }

    public ErrorReport getErrorReport() {
        if (this.errors != null) {
            return (ErrorReport)this.errors.get(0);
        }
        return null;
    }

    public DSResponse addErrorReport(ErrorReport errorReport) {
        if (this.errors == null) {
            this.setErrorReport(errorReport);
        } else {
            this.errors.add(errorReport);
        }
        return this;
    }

    public DSResponse setErrorReport(ErrorReport errorReport) {
        this.errors = new ArrayList();
        this.addErrorReport(errorReport);
        this.setStatus(STATUS_VALIDATION_ERROR);
        return this;
    }

    public DSResponse addError(String fieldName, ErrorMessage errorMessage) {
        ErrorReport errorReport = this.getErrorReport();
        if (errorReport == null) {
            errorReport = new ErrorReport();
            this.setErrorReport(errorReport);
        }
        errorReport.addError(fieldName, errorMessage);
        this.setStatus(STATUS_VALIDATION_ERROR);
        return this;
    }

    public DSResponse addError(String fieldName, String errorMessage) {
        this.addError(fieldName, new ErrorMessage(errorMessage));
        return this;
    }

    public Map getJSResponse() {
        return this.getJSResponse(false);
    }

    public Map getJSResponse(boolean sortKeys) {
        this.setParameter("errors", this.errors);
        this.setParameter("status", new Integer(this.getStatus()));
        if (this.relatedUpdates != null && !this.relatedUpdates.isEmpty()) {
            ArrayList<Map> jsResponseList = new ArrayList<Map>();
            for (Object obj : this.relatedUpdates) {
                DSResponse related = (DSResponse)obj;
                jsResponseList.add(related.getJSResponse());
            }
            this.setParameter("relatedUpdates", jsResponseList);
        }
        if (sortKeys) {
            this.responseData = DataTools.getSortedMap(this.responseData);
        }
        return this.responseData;
    }

    public long getRowCount() {
        Object data = this.getData();
        if (data instanceof JSONFilter) {
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof List) {
            return ((List)data).size();
        }
        return this.affectedRows;
    }

    public DSResponse requestConnectionClose() {
        this.requestConnectionClose = true;
        return this;
    }

    public boolean wantsConnectionClosed() {
        return this.requestConnectionClose;
    }

    public Map getRecord() {
        if (this.getDataSource() == null) {
            log.warn("Attempted to call getRecord() on a DSResponse with null DataSource");
            return null;
        }
        Object data = this.getData();
        IBeanFilter filter = null;
        if (data instanceof JSONFilter) {
            filter = ((JSONFilter)data).getBeanFilter();
            data = ((JSONFilter)data).getObj();
        }
        if (data instanceof List) {
            data = ((List)data).size() > 0 ? ((List)data).get(0) : null;
        }
        Map record = this.getDataSource().getProperties(data);
        if (filter != null) {
            try {
                record = filter.filter(record);
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to filter record:'" + filter), ex);
            }
        }
        return record;
    }

    public List getRecords() {
        ArrayList<Object> source;
        if (this.getDataSource() == null) {
            log.warn("Attempted to call getRecord() on a DSResponse with null DataSource");
            return null;
        }
        ArrayList<Map> target = new ArrayList<Map>();
        Object data = this.getData();
        IBeanFilter filter = null;
        if (data instanceof JSONFilter) {
            filter = ((JSONFilter)data).getBeanFilter();
            data = ((JSONFilter)data).getObj();
        }
        if (!(data instanceof List)) {
            source = new ArrayList<Object>();
            source.add(data);
        } else {
            source = (ArrayList<Object>)data;
        }
        ValidationContext vc = new ValidationContext();
        for (Object e : source) {
            Map properties = e instanceof Map ? (Map)e : this.getDataSource().getProperties(e, true, true, vc);
            if (filter != null) {
                try {
                    if (filter instanceof IContextBeanFilter) {
                        target.add(((IContextBeanFilter)filter).filter(properties, vc));
                        continue;
                    }
                    target.add(filter.filter(properties));
                }
                catch (Exception ex) {
                    log.warn((Object)("Failed to filter record:'" + properties + "'. Skipping."), ex);
                }
                continue;
            }
            target.add(properties);
        }
        return target;
    }

    public Object getFieldValue(String fieldName) {
        Map record = this.getRecord();
        if (record == null) {
            log.warn("Failed to get field '" + fieldName + "' value. DSResponse has no data.");
            return null;
        }
        return record.get(fieldName);
    }

    public DSResponse setFieldValue(String fieldName, Object value) {
        Object dataObj = this.getData() instanceof List ? ((List)this.getData()).get(0) : this.getData();
        if (dataObj instanceof Map) {
            Map dataMap = (Map)dataObj;
            dataMap.put(fieldName, value);
        } else {
            HashMap<String, Object> newValues = new HashMap<String, Object>();
            newValues.put(fieldName, value);
            this.getDataSource().setProperties(newValues, dataObj);
        }
        return this;
    }

    public boolean getExportResults() {
        if (this.getParameter("exportResults") == null) {
            return false;
        }
        return (Boolean)this.getParameter("exportResults");
    }

    public DSResponse setExportResults(Boolean exportResults) {
        if (exportResults == null) {
            exportResults = Boolean.FALSE;
        }
        this.setParameter("exportResults", exportResults);
        return this;
    }

    public DSResponse setExportResults(boolean exportResults) {
        this.setParameter("exportResults", new Boolean(exportResults));
        return this;
    }

    public String getExportAs() {
        return (String)this.getParameter("exportAs");
    }

    public DSResponse setExportAs(String exportAs) {
        this.setParameter("exportAs", exportAs);
        return this;
    }

    public String getExportDelimiter() {
        return (String)this.getParameter("exportDelimiter");
    }

    public DSResponse setExportDelimiter(String exportDelimiter) {
        this.setParameter("exportDelimiter", exportDelimiter);
        return this;
    }

    public String getExportTitleSeparatorChar() {
        return (String)this.getParameter("exportTitleSeparatorChar");
    }

    public DSResponse setExportTitleSeparatorChar(String exportTitleSeparatorChar) {
        this.setParameter("exportTitleSeparatorChar", exportTitleSeparatorChar);
        return this;
    }

    public String getExportFilename() {
        return (String)this.getParameter("exportFilename");
    }

    public DSResponse setExportFilename(String exportFilename) {
        this.setParameter("exportFilename", exportFilename);
        return this;
    }

    public String getExportPath() {
        String path = (String)this.getParameter("exportPath");
        return path == null ? "" : path;
    }

    public DSResponse setExportPath(String exportPath) {
        this.setParameter("exportPath", exportPath);
        return this;
    }

    public String getExportDisplay() {
        return (String)this.getParameter("exportDisplay");
    }

    public DSResponse setExportDisplay(String exportDisplay) {
        this.setParameter("exportDisplay", exportDisplay);
        return this;
    }

    public String getLineBreakStyle() {
        return (String)this.getParameter("lineBreakStyle");
    }

    public DSResponse setLineBreakStyle(String lineBreakStyle) {
        this.setParameter("lineBreakStyle", lineBreakStyle);
        return this;
    }

    public List getExportFields() {
        return (List)this.getParameter("exportFields");
    }

    public DSResponse setExportFields(List exportFields) {
        this.setParameter("exportFields", exportFields);
        return this;
    }

    public Map getExportFieldTitles() {
        return (Map)this.getParameter("exportFieldTitles");
    }

    public DSResponse setExportFieldTitles(Map exportFieldTitles) {
        this.setParameter("exportFieldTitles", exportFieldTitles);
        return this;
    }

    public String getExportHeader() {
        return (String)this.getParameter("exportHeader");
    }

    public DSResponse setExportHeader(String exportHeader) {
        this.setParameter("exportHeader", exportHeader);
        return this;
    }

    public boolean getExportHeaderless() {
        return DataTools.asBoolean(this.getParameter("exportHeaderless"), false);
    }

    public DSResponse setExportHeaderless(boolean exportHeaderless) {
        this.setParameter("exportHeaderless", exportHeaderless);
        return this;
    }

    public String getExportFooter() {
        return (String)this.getParameter("exportFooter");
    }

    public DSResponse setExportFooter(String exportFooter) {
        this.setParameter("exportFooter", exportFooter);
        return this;
    }

    public Boolean shouldExportToClient() {
        return DataTools.asBooleanObject(this.getParameter("exportToClient"));
    }

    public DSResponse setExportToClient(Boolean exportToClient) {
        this.setParameter("exportToClient", exportToClient);
        return this;
    }

    public Boolean shouldExportToFilesystem() {
        return DataTools.asBooleanObject(this.getParameter("exportToFilesystem"));
    }

    public DSResponse setExportToFilesystem(Boolean exportToFilesystem) {
        this.setParameter("exportToFilesystem", exportToFilesystem);
        return this;
    }

    public Boolean getExportDatesAsFormattedString() {
        return DataTools.asBooleanObject(this.getParameter("exportDatesAsFormattedString"));
    }

    public DSResponse setExportDatesAsFormattedString(Boolean exportDatesAsFormattedString) {
        this.setParameter("exportDatesAsFormattedString", exportDatesAsFormattedString);
        return this;
    }

    public OutputStream getExportTo() {
        return this.exportOutputStream;
    }

    public DSResponse setExportTo(OutputStream exportOutputStream) {
        this.exportOutputStream = exportOutputStream;
        return this;
    }

    public Object getExportObject(DSRequest dsRequest) throws Exception {
        if (this.exportObject == null && dsRequest != null) {
            dsRequest.setExportObjectCalled(true);
            DSResponse work = dsRequest.execute();
            this.exportObject = work.getExportObject(null);
        }
        return this.exportObject;
    }

    public DSResponse setExportObject(Object exportObject) throws Exception {
        if (!ExcelDataExport.getExportObjectType().isAssignableFrom(exportObject.getClass())) {
            throw new Exception("The supplied export object is of type " + exportObject.getClass().getName() + ".  We were expecting an object of type " + ExcelDataExport.getExportObjectType().getName() + " (or a subclass).  Please see the Javadoc for DSResponse.setExportObject" + " for important warnings about the use of this API.");
        }
        this.exportObject = exportObject;
        return this;
    }

    public DSResponse setStreamingContext(Map context) {
        this.streamingContext = new HashMap(context);
        return this;
    }

    public Map _getStreamingContext() {
        return this.streamingContext;
    }

    public DSResponse _setHasNextRecord(boolean value) {
        this.hasNextRecord = value;
        if (!this.hasNextRecord && this.isProgressiveLoading()) {
            long rEndRow = this.getRequestEndRow() + (long)this.getDataSource().getLookAhead();
            if (this.getEndRow() == rEndRow) {
                this.setTotalRows(rEndRow + (long)this.getDataSource().getEndGap());
            }
        }
        return this;
    }

    public boolean hasNextRecord() {
        return this.hasNextRecord;
    }

    public Map nextRecord() throws StreamingResponseException {
        if (this.getDataSource() == null) {
            throw new StreamingResponseException("This method cannot be called on a DSResponse that has no associated DataSource");
        }
        Map record = this.getDataSource().streamNextRecord(this);
        if (record != null) {
            this.setEndRow(this.getEndRow() + 1L);
        }
        return record;
    }

    public Object nextRecordAsObject() throws StreamingResponseException {
        if (this.getDataSource() == null) {
            throw new StreamingResponseException("This method cannot be called on a DSResponse that has no associated DataSource");
        }
        Object object = this.getDataSource().streamNextRecordAsObject(this);
        if (object != null) {
            this.setEndRow(this.getEndRow() + 1L);
        }
        return object;
    }

    public void setProgressiveLoading(boolean value) {
        this.progressiveLoading = value;
    }

    public boolean isProgressiveLoading() {
        return this.progressiveLoading;
    }
}

