/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationInfo {
    private static Logger log = new Logger(RelationInfo.class.getName());
    private String fromDataSource;
    private String toDataSource;
    private List<String> fromFields;
    private List<String> toFields;
    private int joinType;
    private RelationInfo nextRelation;

    public static RelationInfo create(Relation relation) {
        DataSource toDS;
        if (relation == null) {
            return null;
        }
        RelationInfo relationInfo = new RelationInfo();
        DataSource fromDS = relation.getFromDataSource();
        if (fromDS != null) {
            relationInfo.setFromDataSource(fromDS.getName());
        }
        if ((toDS = relation.getToDataSource()) != null) {
            relationInfo.setToDataSource(toDS.getName());
        }
        relationInfo.setJoinType(relation.getJoinType());
        if (relation.getFromFields() != null) {
            ArrayList<String> from = new ArrayList<String>();
            for (DSField field : relation.getFromFields()) {
                if (field == null) continue;
                from.add(field.getName());
            }
            relationInfo.setFromFields(from);
        }
        if (relation.getToFields() != null) {
            ArrayList<String> to = new ArrayList<String>();
            for (DSField field : relation.getToFields()) {
                if (field == null) continue;
                to.add(field.getName());
            }
            relationInfo.setToFields(to);
        }
        relationInfo.setNextRelation(RelationInfo.create(relation.getNextRelation()));
        return relationInfo;
    }

    public String getFromDataSource() {
        return this.fromDataSource;
    }

    public void setFromDataSource(String fromDataSource) {
        this.fromDataSource = fromDataSource;
    }

    public List<String> getFromFields() {
        return this.fromFields;
    }

    public void setFromFields(List<String> fromFields) {
        this.fromFields = fromFields;
    }

    public void addFromField(String field) {
        if (this.fromFields == null) {
            this.fromFields = new ArrayList<String>();
        }
        this.fromFields.add(field);
    }

    public void removeFromField(String field) {
        if (this.fromFields == null) {
            return;
        }
        this.fromFields.remove(field);
    }

    public String getToDataSource() {
        return this.toDataSource;
    }

    public void setToDataSource(String toDataSource) {
        this.toDataSource = toDataSource;
    }

    public List<String> getToFields() {
        return this.toFields;
    }

    public void setToFields(List<String> toFields) {
        this.toFields = toFields;
    }

    public void addToField(String field) {
        if (this.toFields == null) {
            this.toFields = new ArrayList<String>();
        }
        this.toFields.add(field);
    }

    public void removeToField(String field) {
        if (this.toFields == null) {
            return;
        }
        this.toFields.remove(field);
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public boolean isValid() {
        return this.fromDataSource != null && this.toDataSource != null && this.fromFields != null && this.fromFields.size() > 0 && this.toFields != null && this.toFields.size() == this.fromFields.size();
    }

    public boolean isComposite() {
        return this.isValid() && this.fromFields.size() > 1;
    }

    public String getFromFieldIndexValue(Map record) {
        return this.buildIndexValue(record, this.fromFields);
    }

    public String getToFieldIndexValue(Map record) {
        return this.buildIndexValue(record, this.toFields);
    }

    private String buildIndexValue(Map record, List<String> fields) {
        StringBuffer sb = new StringBuffer();
        for (String name : fields) {
            Object value = record.get(name);
            sb.append(value == null ? "null" : value.toString());
        }
        return sb.toString();
    }

    public boolean isAToField(String fieldName) {
        return this.isARelationField(fieldName, this.toFields);
    }

    public boolean isAFromField(String fieldName) {
        return this.isARelationField(fieldName, this.fromFields);
    }

    private boolean isARelationField(String fieldName, List<String> fields) {
        return fieldName != null && fields != null && fields.contains(fieldName);
    }

    public RelationInfo getNextRelation() {
        return this.nextRelation;
    }

    public void setNextRelation(RelationInfo nextRelation) {
        this.nextRelation = nextRelation;
    }

    public String toString() {
        StringBuffer rtn = new StringBuffer();
        rtn.append("From: " + (this.fromDataSource == null ? "null" : this.fromDataSource));
        rtn.append(" To: " + (this.toDataSource == null ? "null" : this.toDataSource));
        rtn.append("\n");
        rtn.append("From keys: " + (this.fromFields == null ? "null" : this.fromFields.toString()));
        rtn.append("\n");
        rtn.append("To keys: " + (this.toFields == null ? "null" : this.toFields.toString()));
        rtn.append("\n");
        rtn.append("Join type: " + (this.joinType == 0 ? "inner" : "outer"));
        rtn.append("\n");
        rtn.append("Next relation: " + (this.nextRelation == null ? "null" : this.nextRelation.toString()));
        return rtn.toString();
    }
}

