/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.EasySSLProtocolSocketFactory;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.RegexRule;
import com.isomorphic.xml.XML;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class HttpProxyServlet
extends BaseServlet {
    public String proxyHost;
    public String rulesFile;
    public String webXmlRules;
    public boolean useURLCache = true;
    public int urlCacheSize = 4096;
    protected Map urlCache;
    protected List rules;
    public boolean acceptInvalidAndExpiredSSLCertificates = false;
    public boolean includeSOAPAttachments = true;
    public String SOAPAttachmentDataSource = "sessionFiles";
    public int proxyPort = -1;
    private static final Set headersToNotRelay;
    private static final String[] headersToNotRelay_initiaData;

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public void setRulesFile(String value) {
        this.rulesFile = value;
    }

    public void setRules(String value) {
        this.webXmlRules = value;
    }

    public void setUseURLCache(String value) {
        this.useURLCache = Boolean.valueOf(value);
    }

    public void setUrlCacheSize(String value) {
        this.urlCacheSize = Integer.valueOf(value);
    }

    public void setAcceptInvalidAndExpiredSSLCertificates(String value) {
        this.acceptInvalidAndExpiredSSLCertificates = Boolean.valueOf(value);
    }

    public void setIncludeSOAPAttachments(String value) {
        this.includeSOAPAttachments = Boolean.valueOf(value);
    }

    public void setSOAPAttachmentDataSource(String value) {
        this.SOAPAttachmentDataSource = value;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.webXmlRules != null) {
            for (String rule : DataTools.simpleSplit(this.webXmlRules, "\n")) {
                if ((rule = rule.trim()).length() <= 1) continue;
                try {
                    if (this.rules == null) {
                        this.rules = new ArrayList();
                    }
                    this.rules.add(new RegexRule(rule, "rules init-param in web.xml"));
                }
                catch (Exception e) {
                    this.log.warn(e.toString() + " - dropping this rule.");
                }
            }
        }
        if (this.rulesFile != null) {
            if (this.webXmlRules != null) {
                this.log.warn("Both the rules and rulesFile params are defined in web.xml. Rules defined in the rulesFile: " + this.rulesFile + " will be appended to those defined in the rules param in web.xml");
            }
            if (!this.rulesFile.startsWith("/")) {
                this.rulesFile = "/" + this.rulesFile;
            }
            List rulesFromFile = null;
            try {
                rulesFromFile = DataStructCache.getSingleList(webRoot + this.rulesFile);
            }
            catch (Exception e) {
                this.log.error("Failed to parse rules file: " + webRoot + this.rulesFile);
            }
            if (rulesFromFile != null) {
                for (String rule : rulesFromFile) {
                    try {
                        if (this.rules == null) {
                            this.rules = new ArrayList();
                        }
                        this.rules.add(new RegexRule(rule, "rulesFile: " + this.rulesFile));
                    }
                    catch (Exception e) {
                        this.log.warn(e.toString() + " - dropping this rule.");
                    }
                }
            }
        }
        if (this.rules == null) {
            this.useURLCache = false;
            this.log.info("No rules defined - proxying all incoming URLs.");
        }
        if (this.useURLCache) {
            this.urlCache = Collections.synchronizedMap(new LRUMap(this.urlCacheSize));
            this.log.debug("URL Cache enabled - max size: " + this.urlCacheSize + " entries");
        }
    }

    public void setProxyPort(String value) {
        this.proxyPort = Integer.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            String requestBody;
            Map httpHeaders;
            Object httpMethod;
            HttpClient client;
            String method;
            HashMap<String, String> params;
            Map data;
            block66: {
                String contentType;
                block69: {
                    String url;
                    block71: {
                        Iterator i;
                        Document doc;
                        block72: {
                            block67: {
                                block70: {
                                    String uploadFileName;
                                    block68: {
                                        block65: {
                                            String requestData = request.getParameter("data");
                                            ValidationContext vc = new ValidationContext();
                                            vc.setRestrictedXMLMode(true);
                                            data = (Map)XML.toDSRecords(new StringReader(requestData), vc);
                                            vc.freeResources();
                                            this.log.debug("ProxyData is: " + DataTools.prettyPrint(data));
                                            url = (String)data.get("url");
                                            if (this.rules != null) {
                                                RegexRule matchedRule = null;
                                                if (this.useURLCache) {
                                                    matchedRule = (RegexRule)this.urlCache.get(url);
                                                }
                                                if (matchedRule == null) {
                                                    for (RegexRule rule : this.rules) {
                                                        boolean match = false;
                                                        try {
                                                            match = rule.match(url);
                                                        }
                                                        catch (Exception e) {
                                                            this.log.warn("Syntax error in rule: " + rule.toString() + " - ignoring rule");
                                                        }
                                                        if (!match) continue;
                                                        matchedRule = rule;
                                                        break;
                                                    }
                                                }
                                                if (matchedRule == null) {
                                                    String error = "HttpProxy to URL: " + url + " DENIED.  The URL did not match " + "any rule - returning HTTP code 403 (Forbidden) to client.";
                                                    this.log.warn(error);
                                                    response.sendError(403);
                                                    return;
                                                }
                                                String action = matchedRule.action;
                                                if ("block".equals(action) || "ignore".equals(action)) {
                                                    String error = "HttpProxy to URL: " + url + " DENIED by rule " + matchedRule.toString() + " - returning HTTP code 403 (Forbidden) " + "to client.";
                                                    this.log.warn(error);
                                                    response.sendError(403);
                                                    return;
                                                }
                                                if (this.useURLCache) {
                                                    this.urlCache.put(url, matchedRule);
                                                }
                                            }
                                            params = (HashMap<String, String>)data.get("params");
                                            method = (String)data.get("httpMethod");
                                            if (method == null) {
                                                method = "GET";
                                            }
                                            uploadFileName = (String)data.get("uploadFileName");
                                            if (this.acceptInvalidAndExpiredSSLCertificates) {
                                                Protocol easyhttps = new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443);
                                                Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
                                            }
                                            client = new HttpClient();
                                            if (this.proxyHost != null) {
                                                ProxyHost ph = new ProxyHost(this.proxyHost, this.proxyPort);
                                                HostConfiguration hostConfig = new HostConfiguration();
                                                hostConfig.setProxyHost(ph);
                                                client.setHostConfiguration(hostConfig);
                                            }
                                            if (data.get("username") != null) {
                                                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials((String)data.get("username"), (String)data.get("password"));
                                                client.getState().setCredentials(new AuthScope(null, -1, null), (Credentials)credentials);
                                            }
                                            httpMethod = null;
                                            httpHeaders = (Map)data.get("httpHeaders");
                                            requestBody = null;
                                            Object rbObj = data.get("requestBody");
                                            if (rbObj instanceof Map) {
                                                method = "POST";
                                                this.setIncludeSOAPAttachments("false");
                                                int start = requestData.indexOf("<requestBody");
                                                start = requestData.indexOf(">", start);
                                                int end = requestData.indexOf("</requestBody>");
                                                requestBody = requestData.substring(start + 1, end);
                                                requestBody = "<transaction xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" xsi:type=\"xsd:Object\"><operations xsi:type=\"xsd:List\"> <elem xsi:type=\"xsd:Object\"> " + requestBody;
                                                requestBody = requestBody + "</elem></operations></transaction>";
                                                if (params == null) {
                                                    params = new HashMap<String, String>();
                                                }
                                                params.put("_transaction", requestBody);
                                                url = url + "?isc_rpc=1&isc_xhr=1";
                                                requestBody = null;
                                            } else {
                                                requestBody = (String)data.get("requestBody");
                                                if ("".equals(requestBody)) {
                                                    requestBody = null;
                                                }
                                            }
                                            contentType = (String)data.get("contentType");
                                            if (!method.equals("PUT")) break block65;
                                            httpMethod = new PutMethod(url);
                                            httpMethod.setRequestBody(requestBody);
                                            if (contentType != null) {
                                                httpMethod.setRequestHeader("Content-Type", contentType);
                                            }
                                            break block66;
                                        }
                                        if (!method.equals("POST")) break block67;
                                        if (requestBody != null || uploadFileName != null) break block68;
                                        httpMethod = new PostMethod(url);
                                        break block69;
                                    }
                                    if (uploadFileName == null) break block70;
                                    this.log.warn("uploading file: " + uploadFileName);
                                    ISCFile file = new ISCFile(Config.getGlobal().get("webRoot") + uploadFileName);
                                    httpMethod = new XMLPost(url, file, method);
                                    break block69;
                                }
                                if (!this.includeSOAPAttachments || contentType == null || !contentType.contains("xml")) break block71;
                                doc = XML.parseXML(new InputSource(new StringReader(requestBody)));
                                Map namespaces = DataTools.buildMap("xop", "http://www.w3.org/2004/08/xop/include");
                                List binaryNodes = XML.selectNodes(doc, "//xop:Include", namespaces);
                                i = binaryNodes.iterator();
                                break block72;
                            }
                            if (!method.equals("GET")) {
                                if (!method.equals("DELETE")) throw new Exception("Unsupported HTTP method: " + method);
                            }
                            httpMethod = method.equals("GET") ? new GetMethod(url) : new DeleteMethod(url);
                            httpMethod.setFollowRedirects(true);
                            break block66;
                        }
                        while (i.hasNext()) {
                            RequestContext context;
                            Element node = (Element)i.next();
                            String primaryKey = node.getAttribute("href");
                            DSRequest dsRequest = new DSRequest(this.SOAPAttachmentDataSource, "fetch");
                            dsRequest.context = context = RequestContext.instance((Servlet)this, request, response);
                            dsRequest.setCriteria(DataTools.buildMap("primaryKey", primaryKey));
                            DSResponse dsResponse = dsRequest.execute();
                            Map responseData = (Map)dsResponse.getData();
                            if (responseData == null) {
                                throw new Exception("Unable to locate binary file for primaryKey: " + primaryKey);
                            }
                            byte[] binary = (byte[])responseData.get("file_binary");
                            Base64 encoder = new Base64();
                            String binary64Text = new String(encoder.encode(binary));
                            Text newNode = doc.createTextNode(binary64Text);
                            Node parentNode = node.getParentNode();
                            parentNode.replaceChild(newNode, node);
                        }
                        requestBody = XML.toXML(doc);
                    }
                    httpMethod = new XMLPost(url, requestBody, method);
                }
                if (contentType != null) {
                    httpMethod.setRequestHeader("Content-Type", contentType);
                }
            }
            if (data.get("username") != null) {
                httpMethod.setDoAuthentication(true);
            }
            if (httpHeaders != null) {
                for (String headerName : httpHeaders.keySet()) {
                    httpMethod.setRequestHeader(headerName, (String)httpHeaders.get(headerName));
                }
            }
            ((HttpMethodBase)httpMethod).setHttp11(true);
            if (params != null && params.size() > 0) {
                NameValuePair[] queryParams = new NameValuePair[params.size()];
                int counter = 0;
                for (String key : params.keySet()) {
                    Object value = params.get(key);
                    if (value == null) {
                        value = "";
                    }
                    queryParams[counter++] = new NameValuePair(key, value.toString());
                }
                if (method.equals("POST") && requestBody == null) {
                    ((PostMethod)httpMethod).addParameters(queryParams);
                } else {
                    httpMethod.setQueryString(queryParams);
                }
            }
            byte[] responseBody = null;
            try {
                int statusCode = client.executeMethod((HttpMethod)httpMethod);
                if (statusCode < 200 || statusCode > 300) {
                    this.log.warn("Method failed: " + httpMethod.getStatusLine());
                } else {
                    this.log.info("Method succeeded: " + httpMethod.getStatusLine());
                }
                response.setStatus(statusCode);
                responseBody = httpMethod.getResponseBody();
                if (responseBody == null) {
                    this.log.info("Empty response body");
                }
            }
            catch (UnknownHostException e) {
                this.log.warn("Tried to proxy to unknown host, returning error");
                e.printStackTrace();
                response.addHeader("X-ISC-HttpProxy-Status", "-91");
                response.setStatus(200);
            }
            catch (SocketException e) {
                this.log.warn("SocketException in proxy - is the remote server down? Returning error");
                e.printStackTrace();
                response.addHeader("X-ISC-HttpProxy-Status", "-92");
                response.setStatus(200);
            }
            catch (HttpException e) {
                this.log.warn("Fatal protocol violation: " + e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                this.log.warn("Fatal transport error: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                httpMethod.releaseConnection();
            }
            Header cookieHeader = httpMethod.getResponseHeader("Set-Cookie");
            if (cookieHeader != null && cookieHeader.getValue() != null) {
                response.addHeader("X-Proxied-Set-Cookie", cookieHeader.getValue());
            }
            Header[] responseHeaders = httpMethod.getResponseHeaders();
            for (int hdrIdx = 0; hdrIdx < responseHeaders.length; ++hdrIdx) {
                Header header = responseHeaders[hdrIdx];
                if (headersToNotRelay.contains(header.getName()) || response.containsHeader(header.getName())) continue;
                response.addHeader(header.getName(), header.getValue());
            }
            if (responseBody == null) return;
            if (this.log.isInfoEnabled()) {
                this.log.info("Response:\n" + new String(responseBody));
            }
            IOUtil.copyStreams(new ByteArrayInputStream(responseBody), (OutputStream)response.getOutputStream());
            return;
        }
        catch (Throwable e) {
            this.handleError(response, e);
            return;
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException rule) {}
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    static {
        headersToNotRelay_initiaData = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Location", "Content-MD5", "Content-Range", "Cookie", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Retry-After", "Server", "Set-Cookie", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
        headersToNotRelay = new HashSet(headersToNotRelay_initiaData.length){

            public boolean add(Object o) {
                return super.add(o.toString().toLowerCase());
            }

            public boolean remove(Object o) {
                return super.remove(o.toString().toLowerCase());
            }

            public boolean contains(Object o) {
                return super.contains(o.toString().toLowerCase());
            }
        };
        for (int i = 0; i < headersToNotRelay_initiaData.length; ++i) {
            headersToNotRelay.add(headersToNotRelay_initiaData[i]);
        }
    }

    class XMLPost
    extends HttpMethodBase {
        private ISCFile _uploadFile;
        private String _requestBody;
        private String _methodName;

        public XMLPost(String url, String requestBody, String methodName) {
            super(url);
            this._uploadFile = null;
            this._requestBody = "<foo></foo>";
            this._methodName = "POST";
            this._requestBody = requestBody;
            this._methodName = methodName;
        }

        public XMLPost(String url, ISCFile file, String methodName) {
            super(url);
            this._uploadFile = null;
            this._requestBody = "<foo></foo>";
            this._methodName = "POST";
            this._uploadFile = file;
            this._methodName = methodName;
        }

        public String getName() {
            return this._methodName;
        }

        protected void addRequestHeaders(HttpState state, HttpConnection conn) throws HttpException, IOException {
            super.addRequestHeaders(state, conn);
            if (this._uploadFile != null) {
                this.setRequestHeader("Content-Length", "" + this._uploadFile.length());
            } else {
                this.setRequestHeader("Content-Length", "" + this._requestBody.length());
            }
        }

        protected long getRequestContentLength() {
            return this._requestBody.length();
        }

        protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws HttpException, IOException {
            if (this._uploadFile != null) {
                HttpProxyServlet.this.log.warn("copying streams");
                OutputStream outStream = conn.getRequestOutputStream();
                IOUtil.copyStreams(this._uploadFile.getInputStream(), outStream);
            } else {
                HttpProxyServlet.this.log.info("writing body: " + this._requestBody);
                conn.print(this._requestBody);
            }
            return true;
        }
    }
}

