/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Reflection;
import com.isomorphic.hibernate.HibernateDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class HibernateTransaction {
    protected static Logger log = new Logger(HibernateTransaction.class.getName());
    public static final String TRANSACTION_ATTR = "_isc_hibernate_transaction_";
    protected static Map transactionInfo = new HashMap();

    public static Session openSession(SessionFactory sessionFactory) throws Exception {
        Session session = (Session)Reflection.invokeMethod((Object)sessionFactory, (String)"openSession");
        return session;
    }

    public static synchronized Transaction startTransaction(RPCManager rpc) throws Exception {
        return HibernateTransaction.startTransaction(rpc, null);
    }

    public static synchronized Transaction startTransaction(RPCManager rpc, HibernateDataSource hbds) throws Exception {
        HashMap<String, Object> trxInfo = new HashMap<String, Object>();
        SessionFactory sessionFactory = hbds == null ? HibernateDataSource.getStaticSessionFactory() : hbds.getSessionFactory();
        Session session = HibernateTransaction.openSession(sessionFactory);
        Transaction trx = session.beginTransaction();
        trxInfo.put("session", session);
        trxInfo.put("transaction", trx);
        trxInfo.put("operationCount", new Integer(0));
        transactionInfo.put(trx, trxInfo);
        log.debug((Object)("Started new transaction \"" + trx.hashCode() + "\""));
        if (rpc != null) {
            rpc.setAttribute(TRANSACTION_ATTR, (Object)trx);
        }
        return trx;
    }

    public static Session getTransactionSession(Transaction trx) {
        Map trxInfo = (Map)transactionInfo.get(trx);
        if (trxInfo == null) {
            return null;
        }
        return (Session)trxInfo.get("session");
    }

    public static Integer getTransactionOpCount(Transaction trx) {
        Map trxInfo = (Map)transactionInfo.get(trx);
        if (trxInfo == null) {
            return null;
        }
        return (Integer)trxInfo.get("operationCount");
    }

    public static void incrementTransactionOpCount(Transaction trx) {
        Map trxInfo = (Map)transactionInfo.get(trx);
        if (trxInfo != null) {
            int opCount = (Integer)trxInfo.get("operationCount");
            trxInfo.put("operationCount", new Integer(opCount + 1));
        }
    }

    public static void removeTransaction(Transaction trx) {
        transactionInfo.remove(trx);
        log.debug((Object)("Removed transaction \"" + trx.hashCode() + "\""));
    }

    public static void rollbackTransaction(RPCManager rpc) throws Exception {
        HibernateTransaction.rollbackTransaction(null, rpc);
    }

    public static void rollbackTransaction(Transaction trx) throws Exception {
        HibernateTransaction.rollbackTransaction(trx, null);
    }

    public static synchronized void rollbackTransaction(Transaction trx, RPCManager rpc) throws Exception {
        if (trx == null) {
            if (rpc == null) {
                throw new Exception("Both Transaction and RPCManager were null in rollbackTransaction");
            }
            trx = (Transaction)rpc.getAttribute(TRANSACTION_ATTR);
        }
        if (trx != null && transactionInfo.get(trx) != null) {
            if (trx.isActive()) {
                log.warn((Object)("Rolling back " + HibernateTransaction.getTransactionOpCount(trx) + " database update(s)"));
                log.debug((Object)("Rolling back transaction \"" + trx.hashCode() + "\""));
                trx.rollback();
            } else {
                log.warn((Object)"Attempted to roll back inactive transaction");
            }
        } else {
            log.warn((Object)"Attempted to roll back null transaction");
        }
    }

    public static void commitTransaction(RPCManager rpc) throws Exception {
        HibernateTransaction.commitTransaction(null, rpc);
    }

    public static void commitTransaction(Transaction trx) throws Exception {
        HibernateTransaction.commitTransaction(trx, null);
    }

    public static synchronized void commitTransaction(Transaction trx, RPCManager rpc) throws Exception {
        if (trx == null) {
            if (rpc == null) {
                throw new Exception("Both Transaction and RPCManager were null in commitTransaction");
            }
            trx = (Transaction)rpc.getAttribute(TRANSACTION_ATTR);
        }
        if (trx != null) {
            if (trx.isActive()) {
                log.info((Object)("Attempting to commit " + HibernateTransaction.getTransactionOpCount(trx) + " database update(s)"));
                log.debug((Object)("Committing transaction \"" + trx.hashCode() + "\""));
                try {
                    trx.commit();
                }
                catch (Exception e) {
                    log.warn((Object)("Could not commit, attempting to rollback " + HibernateTransaction.getTransactionOpCount(trx) + " database update(s)"));
                    trx.rollback();
                    throw e;
                }
            } else {
                log.warn((Object)"Attempted to commit inactive transaction");
            }
        } else {
            log.warn((Object)"Attempted to commit null transaction");
        }
    }

    public static void closeSession(RPCManager rpc) throws Exception {
        HibernateTransaction.closeSession(null, rpc);
    }

    public static void closeSession(Transaction trx) throws Exception {
        HibernateTransaction.closeSession(trx, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void closeSession(Transaction trx, RPCManager rpc) throws Exception {
        if (trx == null) {
            if (rpc == null) {
                throw new Exception("Both Transaction and RPCManager were null in closeSession");
            }
            trx = (Transaction)rpc.getAttribute(TRANSACTION_ATTR);
        }
        if (trx != null) {
            try {
                if (!trx.isActive()) return;
                log.debug((Object)"Attempting to close session when transaction is still active - commit it first.");
                HibernateTransaction.commitTransaction(trx);
                return;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                log.debug((Object)("Closing session \"" + trx.hashCode() + "\""));
                Session s = HibernateTransaction.getTransactionSession(trx);
                if (s != null) {
                    s.close();
                }
                HibernateTransaction.removeTransaction(trx);
            }
        } else {
            log.warn((Object)"Attempted to close session for null transaction.");
        }
    }
}

