/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.ResponseAwareWebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;
import org.openqa.selenium.remote.server.rest.ResultType;

public class ExecuteScript
extends ResponseAwareWebDriverHandler
implements JsonParametersAware {
    private volatile String script;
    private volatile List<Object> args = new ArrayList<Object>();

    public ExecuteScript(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.script = (String)allParameters.get("script");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList((Iterable)Iterables.transform((Iterable)params, (Function)new ArgumentConverter(this.getKnownElements())));
    }

    @Override
    public ResultType call() throws Exception {
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)((Object)this.getDriver())).executeScript(this.script, this.args.toArray()) : ((JavascriptExecutor)((Object)this.getDriver())).executeScript(this.script, new Object[0]);
        Object result = new ResultConverter(this.getKnownElements()).apply(value);
        this.response.setValue(result);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[execute script: %s, %s]", this.script, this.args);
    }
}

