/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSRepo;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Map;

public class FileSystemDSRepo
extends DSRepo {
    private Logger log = new Logger(FileSystemDSRepo.class.getName());

    public FileSystemDSRepo() {
        super(null);
    }

    public DataSource loadDS(String dsName, DSRequest dsRequest, boolean isSchemaless) throws Exception {
        Map dsConfig;
        HashMap flags = new HashMap();
        String dsConfigFile = null;
        if ("Object".equals(dsName)) {
            dsConfig = DataTools.buildMap("ID", "Object");
        } else {
            Object dsObject = DataStructCache.getCachedObjectWithNoConfigFile(dsName);
            if (dsObject != null && dsObject instanceof DataSource) {
                return (DataSource)dsObject;
            }
            dsConfigFile = DataStructCache.getInstanceFile(dsName, "datasources", "DS", isSchemaless);
            if (dsConfigFile == null) {
                return null;
            }
            dsConfig = (Map)DataStructCache.loadInstance(dsConfigFile, dsName, "DS", flags);
            if (dsConfig == null) {
                throw new Exception("Can't locate datasource for name: " + dsName);
            }
            String ID = (String)dsConfig.get("ID");
            if (ID != null && !dsName.equals(ID)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("dsName case sensitivity mismatch - looking for: " + dsName + ", but got: " + ID);
                }
                return null;
            }
            if (dsConfig == null) {
                return null;
            }
        }
        Object autoDerive = dsConfig.get("autoDeriveSchema");
        if (autoDerive != null && "true".equals(autoDerive.toString()) && Boolean.TRUE.equals(flags.get("objectWasStale"))) {
            DataStructCache.removeCachedObjectWithNoConfigFile(dsName + "_inheritsFrom");
        }
        long start = System.currentTimeMillis();
        DataSource ds = DataSource.fromConfig(dsConfig, dsRequest);
        long end = System.currentTimeMillis();
        if (dsConfigFile != null) {
            ds.dsConfigFile = dsConfigFile;
            ds.configTimestamp = new ISCFile(dsConfigFile).lastModified();
        }
        return ds;
    }
}

