/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.io;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import isc.org.apache.oro.text.GlobCompiler;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISCFile {
    private static Logger log = new Logger(ISCFile.class.getName());
    public static final String SHUTDOWN = "; shutdown=true";
    public static ServletContext servletContext = null;
    private static String fallBackRootDir;
    String canonicalPath;
    String filename;
    URL url;
    File file;
    FileObject fileObject;
    private static Boolean forceCloseConnection;
    public static final String CONTAINER_IO_PREFIX = "__USE_CONTAINER__";

    public ISCFile(URL url) {
        this.url = url;
    }

    public ISCFile(File file) {
        this.file = file;
    }

    public ISCFile(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public ISCFile(String filename) throws IOException {
        this.filename = filename;
        if (filename.startsWith("{CLASSPATH}")) {
            filename = StringUtils.substringAfter((String)filename, (String)"{CLASSPATH}");
            this.url = ISCFile.class.getResource(ISCFile.canonicalizePath(filename));
        } else if (filename.startsWith("ram://") || filename.startsWith("res://")) {
            this.fileObject = VFS.getManager().resolveFile(filename);
        } else if (ISCFile.isContainerIOPath(filename)) {
            if (!(filename = ISCFile.canonicalizePath(ISCFile.stripContainerIOPrefix(filename))).startsWith("/")) {
                filename = "/" + filename;
            }
            if (servletContext == null) {
                if (fallBackRootDir != null) {
                    this.file = new File(ISCFile.canonicalizePath(fallBackRootDir + filename));
                    return;
                }
                throw new IOException("Configured for containerIO, but servletContext not available!  You need to install the Init servlet");
            }
            this.url = servletContext.getResource(filename);
        } else {
            if (filename.startsWith("file:")) {
                filename = filename.substring("file:".length());
            }
            if (DataTools.isURI(filename)) {
                this.url = new URL(filename);
            } else {
                this.file = new File(ISCFile.canonicalizePath(filename));
            }
        }
    }

    public boolean delete() throws IOException {
        if (this.file != null) {
            return this.file.delete();
        }
        if (this.fileObject != null) {
            return this.fileObject.delete();
        }
        throw new IOException("delete() operation not supported for filename: " + this.filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws IOException {
        if (this.file != null) {
            return DataTools.caseSensitiveFileExists(this.filename, this.file);
        }
        if (this.fileObject != null) {
            return this.fileObject.exists();
        }
        if (this.url == null) {
            return false;
        }
        InputStream is = null;
        try {
            is = this.getInputStream();
            if (is != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public String getParent() {
        if (this.fileObject != null) {
            try {
                return this.fileObject.getParent().getName().getURI();
            }
            catch (Exception e) {
                return null;
            }
        }
        return new File(this.filename).getParent();
    }

    public String getCanonicalPath() throws IOException {
        if (this.canonicalPath == null) {
            if (this.file != null) {
                this.canonicalPath = this.file.getCanonicalPath();
            } else if (this.url != null) {
                if (this.filename != null && ISCFile.isContainerIOPath(this.filename)) {
                    return this.filename;
                }
                this.canonicalPath = this.url.toExternalForm();
            }
        }
        if (this.canonicalPath != null) {
            return this.canonicalPath;
        }
        return this.filename;
    }

    public boolean canRead() throws IOException {
        if (this.file != null) {
            return this.file.canRead();
        }
        if (this.fileObject != null) {
            return this.fileObject.isReadable();
        }
        return this.url != null;
    }

    public boolean canWrite() throws IOException {
        if (this.file != null) {
            return this.file.canWrite();
        }
        if (this.fileObject != null) {
            return this.fileObject.isWriteable();
        }
        return false;
    }

    public boolean mkdir() throws IOException {
        if (this.file != null) {
            return this.file.mkdir();
        }
        if (this.fileObject != null) {
            try {
                this.fileObject.createFolder();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IOException("mkdir() not supported for filename: " + this.filename);
    }

    public boolean mkdirs() throws IOException {
        if (this.file != null) {
            return this.file.mkdirs();
        }
        if (this.fileObject != null) {
            try {
                this.fileObject.createFolder();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        throw new IOException("mkdirs() not supported for filename: " + this.filename);
    }

    public String getPath() throws IOException {
        return this.getCanonicalPath();
    }

    public String getName() throws IOException {
        String name = ISCFile.canonicalizePath(this.getPath());
        int slashIndex = name.lastIndexOf("/");
        if (slashIndex != -1) {
            name = name.substring(slashIndex + 1);
        }
        return name;
    }

    public Object getNativeHandler() {
        if (this.file != null) {
            return this.file;
        }
        if (this.fileObject != null) {
            return this.fileObject;
        }
        return this.url;
    }

    public Reader getReader() throws IOException {
        return this.getReader(null);
    }

    public Reader getReader(Charset charset) throws IOException {
        InputStream is = this.getInputStream();
        if (charset == null) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, charset);
    }

    public String getAsString() throws IOException {
        StringWriter sw = new StringWriter();
        Reader reader = this.getReader();
        IOUtil.copyCharacterStreams(reader, sw);
        reader.close();
        return sw.toString();
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getInputStream();
        }
        if (this.url != null) {
            return this.url.openConnection().getInputStream();
        }
        throw new IOException("ISCFile (hashCode " + this.hashCode() + ") state is invalid. Failed to initialize native file object for: " + this.filename);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.file != null) {
            return new FileOutputStream(this.file);
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getOutputStream();
        }
        throw new IOException("getOutputStream not supported for filename: " + this.filename);
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public long length() throws IOException {
        if (!this.exists()) {
            return 0L;
        }
        if (this.file != null) {
            return this.file.length();
        }
        if (this.fileObject != null) {
            return this.fileObject.getContent().getSize();
        }
        if (this.url != null) {
            return this.url.openConnection().getContentLength();
        }
        log.warn("ISCFile (hashCode " + this.hashCode() + ") state is invalid. Failed to initialize native file object for: " + this.filename);
        return 0L;
    }

    public long lastModified() throws IOException {
        if (this.file != null) {
            return this.file.lastModified();
        }
        if (this.fileObject != null) {
            if (this.exists()) {
                long lastModified = this.fileObject.getContent().getLastModifiedTime();
                lastModified = (long)Math.floor(lastModified / 1000L) * 1000L;
                return lastModified;
            }
            return 0L;
        }
        if (this.url != null) {
            URLConnection urlConnection = this.url.openConnection();
            long lastModified = urlConnection.getLastModified();
            if (this.forceCloseConnection()) {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception during file connection closure", e);
                }
            }
            return lastModified;
        }
        log.warn("ISCFile (hashCode " + this.hashCode() + ") state is invalid. Failed to initialize native file object for: " + this.filename);
        return 0L;
    }

    public boolean setLastModified(long time) {
        return this.file != null && this.file.setLastModified(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceCloseConnection() {
        if (forceCloseConnection != null) return forceCloseConnection;
        Class<ISCFile> clazz = ISCFile.class;
        synchronized (ISCFile.class) {
            if (forceCloseConnection != null) return forceCloseConnection;
            Boolean flag = null;
            if (Config.getGlobal() != null) {
                flag = Config.getGlobal().getBoolean("file.forceCloseURLConnection");
            }
            if (flag == null) {
                Class wlVersion = null;
                try {
                    wlVersion = Reflection.classForName("weblogic.common.internal.Version");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                forceCloseConnection = wlVersion != null ? Boolean.TRUE : Boolean.FALSE;
            } else {
                forceCloseConnection = flag;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return forceCloseConnection;
        }
    }

    public static boolean isContainerIOPath(String path) {
        Config config = Config.getGlobal(false);
        if (config == null) {
            return false;
        }
        List prefixes = config.getCommaSeparatedList("containerIOPrefixes");
        if (prefixes == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!path.contains(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String stripContainerIOPrefix(String path) {
        Config config = Config.getGlobal();
        if (config == null) {
            return path;
        }
        List prefixes = config.getCommaSeparatedList("containerIOPrefixes");
        if (prefixes == null) {
            return path;
        }
        for (String prefix : prefixes) {
            int containerIOIndex = path.indexOf(prefix);
            if (containerIOIndex == -1) continue;
            path = path.substring(containerIOIndex + prefix.length());
            break;
        }
        return path;
    }

    public static String canonicalizePath(String path) {
        char lastChar;
        if (path == null) {
            return null;
        }
        path = path.trim();
        StringWriter sw = new StringWriter();
        int copiedFrom = 0;
        int length = path.length();
        for (int ii = 0; ii < length; ++ii) {
            char nextChar;
            char currChar = path.charAt(ii);
            if (currChar != '\\' && currChar != '/') continue;
            sw.write(path.substring(copiedFrom, ii));
            sw.write(47);
            while (ii + 1 < length && ((nextChar = path.charAt(ii + 1)) == '/' || nextChar == '\\')) {
                if (ii - 1 >= 0 && path.charAt(ii - 1) == ':') {
                    sw.write(47);
                }
                ++ii;
            }
            copiedFrom = ii + 1;
        }
        sw.write(path.substring(copiedFrom, length));
        path = sw.getBuffer().toString();
        length = path.length();
        if (length > 1 && ((lastChar = path.charAt(length - 1)) == '/' || lastChar == '\\')) {
            path = path.substring(0, length - 1);
        }
        return path;
    }

    public static boolean inContainerIOMode() {
        Config config = Config.getGlobal();
        return ISCFile.isContainerIOPath(config.getPath("webRoot"));
    }

    public static List<String> list(String path) {
        if (servletContext != null) {
            Set files = servletContext.getResourcePaths(path);
            if (files == null) {
                return null;
            }
            return new ArrayList<String>(files);
        }
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        String[] files = f.list();
        if (files == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String file : files) {
            String fileName = ISCFile.canonicalizePath(path + "/" + file);
            File x = new File(fileName);
            if (x.isDirectory()) {
                results.add(fileName + "/");
                continue;
            }
            results.add(fileName);
        }
        return results;
    }

    public static List<String> list(String path, String regex) {
        Set files = servletContext.getResourcePaths(path);
        if (files == null) {
            return null;
        }
        if (!regex.startsWith("/") || !regex.endsWith("/")) {
            regex = "/" + regex + "/";
        }
        Perl5Util perl5 = new Perl5Util();
        ArrayList<String> matchingFiles = new ArrayList<String>();
        for (String file : files) {
            if (!perl5.match(regex, file)) continue;
            matchingFiles.add(file);
        }
        return matchingFiles;
    }

    public static List<String> find(String basePath, boolean recurse, String glob) {
        String regex = GlobCompiler.globToPerl5((char[])glob.toCharArray(), (int)0);
        regex = "^" + regex + "(\\/)?$";
        return ISCFile.ffind(basePath, recurse, regex);
    }

    public static List<String> ffind(String basePath, boolean recurse, String regex) {
        if (basePath == null) {
            return null;
        }
        List<String> filesAtBasePath = ISCFile.list(basePath);
        if (filesAtBasePath == null) {
            return null;
        }
        if (!regex.startsWith("/") || !regex.endsWith("/")) {
            regex = "/" + regex + "/";
        }
        ArrayList<String> matchingFiles = new ArrayList<String>();
        Perl5Util perl5 = new Perl5Util();
        for (String path : filesAtBasePath) {
            List<String> matchingFilesInDir;
            if (recurse && ISCFile.isDirectory(path) && (matchingFilesInDir = ISCFile.ffind(path, true, regex)) != null) {
                matchingFiles.addAll(matchingFilesInDir);
            }
            if (!perl5.match(regex, path)) continue;
            matchingFiles.add(path);
        }
        return matchingFiles;
    }

    public boolean isDirectory() throws IOException {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this.fileObject != null) {
            return this.fileObject.getType().hasChildren();
        }
        return this.filename.endsWith("/");
    }

    public static boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    public static void setFallBackRootDir(String fallBackRootDir) {
        ISCFile.fallBackRootDir = fallBackRootDir;
    }

    public static boolean isUnresolvedContainer(String path) {
        return path.contains(CONTAINER_IO_PREFIX);
    }

    public static String replaceUnresolvedContainer(String path) {
        if (fallBackRootDir == null) {
            return path;
        }
        return path.replaceFirst(CONTAINER_IO_PREFIX, fallBackRootDir);
    }

    public static File getCanonicalFile(String filename) throws IOException {
        return new ISCFile((String)filename).file;
    }

    static {
        forceCloseConnection = null;
    }
}

