/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileAssembly
extends BaseServlet {
    public String configFile = "/isomorphicConfig/fileAssembly.xml";
    private boolean configFileModified = false;
    public Map cache = null;
    public boolean noCache = false;

    public void setConfigFile(String value) {
        this.configFile = value;
        this.configFileModified = true;
    }

    public void setCache(String value) {
        if ("NONE".equals(value.toUpperCase())) {
            this.noCache = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String configFile = this.configFile;
        if (!this.configFileModified && config.getBoolean((Object)"devenv", false)) {
            configFile = null;
        }
        if (request.getAttribute("isc_fa_configOnly") != null) {
            if (configFile != null) {
                request.setAttribute("isc_fa_configFile", (Object)configFile);
            }
            return;
        }
        RequestTimer requestTimer = new RequestTimer(request);
        try {
            String requestURI;
            String assembledFilePath;
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            IAssembly assembly = (IAssembly)InterfaceProvider.load("IAssembly");
            if (configFile != null) {
                assembly.addConfigFile(webRoot + configFile);
            }
            if ((assembledFilePath = assembly.assembleFile(requestURI = ServletTools.getCanonicalRequestURI(request))) == null) {
                throw new Exception("URI: " + requestURI + " is not registered with the FileAssembler.");
            }
            if (this.noCache) {
                context.setNoCacheHeaders();
            }
            ServletTools.sendStaticFile(context, assembledFilePath, null, null, null, true);
            context.completeResponse();
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (Exception context) {}
            requestTimer.stop();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

