/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.SimpleTransformErrorListener;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.xslt.TransformerUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XsltView
extends AbstractUrlBasedView {
    private Class transformerFactoryClass;
    private String sourceKey;
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private boolean indent;
    private Properties outputProperties;
    private boolean cacheTemplates;
    private TransformerFactory transformerFactory;
    private Templates cachedTemplates;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$org$springframework$core$io$Resource;

    public XsltView() {
        this.errorListener = new SimpleTransformErrorListener(this.logger);
        this.indent = true;
        this.cacheTemplates = true;
    }

    public void setTransformerFactoryClass(Class transformerFactoryClass) {
        Assert.isAssignable(class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = XsltView.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory, transformerFactoryClass);
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener != null ? errorListener : new SimpleTransformErrorListener(this.logger);
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setCacheTemplates(boolean cacheTemplates) {
        this.cacheTemplates = cacheTemplates;
    }

    protected void initApplicationContext() throws BeansException {
        this.transformerFactory = this.newTransformerFactory(this.transformerFactoryClass);
        this.transformerFactory.setErrorListener(this.errorListener);
        if (this.uriResolver != null) {
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.cacheTemplates) {
            this.cachedTemplates = this.loadTemplates();
        }
    }

    protected TransformerFactory newTransformerFactory(Class transformerFactoryClass) {
        if (transformerFactoryClass != null) {
            try {
                return (TransformerFactory)transformerFactoryClass.newInstance();
            }
            catch (Exception ex) {
                throw new TransformerFactoryConfigurationError(ex, "Could not instantiate TransformerFactory");
            }
        }
        return TransformerFactory.newInstance();
    }

    protected final TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Templates templates = this.cachedTemplates;
        if (templates == null) {
            templates = this.loadTemplates();
        }
        Transformer transformer = this.createTransformer(templates);
        this.configureTransformer(model, response, transformer);
        this.configureResponse(model, response, transformer);
        Source source = null;
        try {
            source = this.locateSource(model);
            if (source == null) {
                throw new IllegalArgumentException("Unable to locate Source object in model: " + model);
            }
            transformer.transform(source, this.createResult(response));
        }
        finally {
            this.closeSourceIfNecessary(source);
        }
    }

    protected Result createResult(HttpServletResponse response) throws Exception {
        return new StreamResult((OutputStream)response.getOutputStream());
    }

    protected Source locateSource(Map model) throws Exception {
        if (this.sourceKey != null) {
            return this.convertSource(model.get(this.sourceKey));
        }
        Object source = CollectionUtils.findValueOfType(model.values(), this.getSourceTypes());
        return source != null ? this.convertSource(source) : null;
    }

    protected Class[] getSourceTypes() {
        return new Class[]{class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = XsltView.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source, class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = XsltView.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XsltView.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$java$io$Reader == null ? (class$java$io$Reader = XsltView.class$("java.io.Reader")) : class$java$io$Reader, class$java$io$InputStream == null ? (class$java$io$InputStream = XsltView.class$("java.io.InputStream")) : class$java$io$InputStream, class$org$springframework$core$io$Resource == null ? (class$org$springframework$core$io$Resource = XsltView.class$("org.springframework.core.io.Resource")) : class$org$springframework$core$io$Resource};
    }

    protected Source convertSource(Object source) throws Exception {
        if (source instanceof Source) {
            return (Source)source;
        }
        if (source instanceof Document) {
            return new DOMSource(((Document)source).getDocumentElement());
        }
        if (source instanceof Node) {
            return new DOMSource((Node)source);
        }
        if (source instanceof Reader) {
            return new StreamSource((Reader)source);
        }
        if (source instanceof InputStream) {
            return new StreamSource((InputStream)source);
        }
        if (source instanceof Resource) {
            return new StreamSource(((Resource)source).getInputStream());
        }
        throw new IllegalArgumentException("Value '" + source + "' cannot be converted to XSLT Source");
    }

    protected void configureTransformer(Map model, HttpServletResponse response, Transformer transformer) {
        this.copyModelParameters(model, transformer);
        this.copyOutputProperties(transformer);
        this.configureIndentation(transformer);
    }

    protected final void configureIndentation(Transformer transformer) {
        if (this.indent) {
            TransformerUtils.enableIndenting(transformer);
        } else {
            TransformerUtils.disableIndenting(transformer);
        }
    }

    protected final void copyOutputProperties(Transformer transformer) {
        if (this.outputProperties != null) {
            Enumeration<?> en = this.outputProperties.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                transformer.setOutputProperty(name, this.outputProperties.getProperty(name));
            }
        }
    }

    protected final void copyModelParameters(Map model, Transformer transformer) {
        this.copyMapEntriesToTransformerParameters(model, transformer);
    }

    protected void configureResponse(Map model, HttpServletResponse response, Transformer transformer) {
        String contentType = this.getContentType();
        String mediaType = transformer.getOutputProperty("media-type");
        String encoding = transformer.getOutputProperty("encoding");
        if (StringUtils.hasText(mediaType)) {
            contentType = mediaType;
        }
        if (StringUtils.hasText(encoding) && contentType != null && contentType.toLowerCase().indexOf(";charset=") == -1) {
            contentType = contentType + ";charset=" + encoding;
        }
        response.setContentType(contentType);
    }

    private Templates loadTemplates() throws ApplicationContextException {
        Source stylesheetSource = this.getStylesheetSource();
        try {
            Templates templates = this.transformerFactory.newTemplates(stylesheetSource);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading templates '" + templates + "'"));
            }
            Templates templates2 = templates;
            return templates2;
        }
        catch (TransformerConfigurationException ex) {
            throw new ApplicationContextException("Can't load stylesheet from '" + this.getUrl() + "'", ex);
        }
        finally {
            this.closeSourceIfNecessary(stylesheetSource);
        }
    }

    protected Transformer createTransformer(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        if (this.uriResolver != null) {
            transformer.setURIResolver(this.uriResolver);
        }
        return transformer;
    }

    protected Source getStylesheetSource() {
        String url = this.getUrl();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading XSLT stylesheet from '" + url + "'"));
        }
        try {
            Resource stylesheetResource = this.getApplicationContext().getResource(url);
            String systemId = url.substring(0, url.lastIndexOf(47) + 1);
            return new StreamSource(stylesheetResource.getInputStream(), systemId);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from '" + url + "'", ex);
        }
    }

    private void copyMapEntriesToTransformerParameters(Map map, Transformer transformer) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            transformer.setParameter(ObjectUtils.nullSafeToString(entry.getKey()), entry.getValue());
        }
    }

    private void closeSourceIfNecessary(Source source) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (streamSource.getReader() != null) {
                try {
                    streamSource.getReader().close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            if (streamSource.getInputStream() != null) {
                try {
                    streamSource.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

