/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.isomorphic.autotest.AwsInstancesDao;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.base.ISCInit;
import com.isomorphic.log.Logger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class AwsHelper {
    private static Logger log = new Logger(AwsHelper.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    private static final int EC2_API_RETRY_DELAY = 5000;
    private static final int EC2_API_COMMAND_DELAY = 1000;
    private static final String AWS_CREDENTIALS_FILE = "/home/autotest/AWS/AwsCredentials.properties";
    protected static final String AWS_INSTANCE_AVAILABLE = "i-available";
    private static String securityGroupIds;
    private static String machineInstanceType;
    private static String amazonMachineImageId;
    private static String deprecatedAMImageId;
    private static AWSCredentials credentials;

    private static void loadAmazonWebServicesConfiguration() throws ConfigurationException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.load(AWS_CREDENTIALS_FILE);
        String accessKey = (String)config.getProperty("accessKey");
        String secretKey = (String)config.getProperty("secretKey");
        credentials = new BasicAWSCredentials(accessKey, secretKey);
        securityGroupIds = (String)config.getProperty("securityGroupIds");
        machineInstanceType = (String)config.getProperty("machineInstanceType");
        amazonMachineImageId = (String)config.getProperty("amazonMachineImageId");
        deprecatedAMImageId = (String)config.getProperty("deprecatedAMImageId");
    }

    private static List<Instance> getLiveInstances(AmazonEC2 ec2) throws AmazonClientException, AmazonServiceException {
        ArrayList<String> amis = new ArrayList<String>();
        amis.add(amazonMachineImageId);
        if (deprecatedAMImageId != null) {
            amis.add(deprecatedAMImageId);
        }
        Filter filter = new Filter("image-id", amis);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(filter);
        DescribeInstancesRequest request = new DescribeInstancesRequest();
        request.setFilters(filters);
        DescribeInstancesResult result = ec2.describeInstances(request);
        List reservations = result.getReservations();
        ArrayList instances = new ArrayList();
        for (Reservation r : reservations) {
            instances.addAll(r.getInstances());
        }
        ArrayList<Instance> liveInstances = new ArrayList<Instance>();
        for (Instance i : instances) {
            if (i.getState().getName().equals("terminated")) continue;
            liveInstances.add(i);
        }
        return liveInstances;
    }

    private static String launchNewInstance(AmazonEC2 ec2, int keyOrdinal, Date batchStartTime) throws AmazonClientException, AmazonServiceException {
        String ordinal = Integer.toString(keyOrdinal);
        String encoded = new String(Base64.encodeBase64((byte[])ordinal.getBytes()));
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest().withInstanceType(machineInstanceType).withImageId(amazonMachineImageId).withMinCount(Integer.valueOf(1)).withMaxCount(Integer.valueOf(1)).withSecurityGroupIds(new String[]{securityGroupIds}).withKeyName("primary").withInstanceInitiatedShutdownBehavior("terminate").withUserData(encoded);
        RunInstancesResult runInstances = ec2.runInstances(runInstancesRequest);
        List instances = runInstances.getReservation().getInstances();
        if (instances.size() > 0) {
            Instance instance = (Instance)instances.get(0);
            String instanceId = instance.getInstanceId();
            log.info((Object)("[AMI Id: " + instance.getImageId() + ", " + "Instance Id: " + instance.getInstanceId() + ", " + "Public IP: " + instance.getPublicIpAddress() + "," + "State: " + instance.getState() + "]"));
            AwsInstancesDao.registerKeyOrdinalWithInstance(keyOrdinal, instanceId, batchStartTime);
            BatchRunDao.registerAwsInstanceId(batchStartTime, instanceId);
            return instanceId;
        }
        return null;
    }

    protected static void killOldInstance(AmazonEC2 ec2, ZombieProperties properties) {
        String instanceId = properties.instanceId;
        BatchRunDao.updateBatchStatus(properties.batchStartTime, "zombie", false);
        try {
            TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest().withInstanceIds(new String[]{instanceId});
            TerminateInstancesResult terminateInstances = ec2.terminateInstances(terminateInstancesRequest);
            List changes = terminateInstances.getTerminatingInstances();
            if (changes.size() == 0) {
                return;
            }
            InstanceStateChange change = (InstanceStateChange)changes.get(0);
            String changedInstanceId = change.getInstanceId();
            InstanceState current = change.getCurrentState();
            InstanceState previous = change.getPreviousState();
            if (!changedInstanceId.equals(instanceId)) {
                log.error((Object)("Attempt to terminate instance " + instanceId + " via EC2 APIs " + "has returned an invalid instance " + changedInstanceId));
                return;
            }
            String currentState = current.getName();
            if (!"terminated".equals(currentState) && !"shutting-down".equals(currentState)) {
                log.error((Object)("Attempt to terminate instance " + instanceId + " via EC2 APIs " + "has left instance in state " + current.getName()));
                return;
            }
            log.info((Object)("Terminate request sent to AWS Instance " + instanceId + " for exceeding " + "its maximum allowed lifespan.  Its previous state was " + previous.getName()));
            try {
                FileWriter fstream = new FileWriter(tmpDir + "/awslogs/killed-" + instanceId);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write("Lifespan of " + properties.lifespanMinutes + " minutes exceeded maximum");
                out.close();
            }
            catch (Exception e) {
                log.error((Object)("failed to record termination of instance " + instanceId), (Throwable)e);
            }
        }
        catch (AmazonServiceException e) {
            log.error((Object)e);
        }
        catch (AmazonClientException e) {
            log.error((Object)e);
        }
    }

    protected static int getFreeAwsVpnKeyOrdinal() {
        try {
            AmazonEC2Client ec2 = new AmazonEC2Client(credentials);
            List<ZombieProperties> instances = AwsInstancesDao.getZombieInstances();
            for (ZombieProperties properties : instances) {
                log.error((Object)("AWS instance " + properties.instanceId + " has exceeded " + "the maximum lifespan without completing its tests; killing"));
                AwsHelper.killOldInstance((AmazonEC2)ec2, properties);
            }
            System.out.println("Validating any pending completed batches...");
            return AwsInstancesDao.getKeyOrdinal(AwsHelper.getLiveInstances((AmazonEC2)ec2));
        }
        catch (AmazonServiceException e) {
            log.error((Object)e);
        }
        catch (AmazonClientException e) {
            log.error((Object)e);
        }
        return 0;
    }

    protected static String launchAwsServer(int retryLimit, Date batchStartTime) {
        try {
            AwsHelper.loadAmazonWebServicesConfiguration();
            for (int i = 0; i < retryLimit; ++i) {
                try {
                    int keyOrdinal = AwsHelper.getFreeAwsVpnKeyOrdinal();
                    if (keyOrdinal > 0) {
                        if (null == batchStartTime) {
                            return AWS_INSTANCE_AVAILABLE;
                        }
                        AmazonEC2Client ec2 = new AmazonEC2Client(credentials);
                        Utils.sleep(1000);
                        return AwsHelper.launchNewInstance((AmazonEC2)ec2, keyOrdinal, batchStartTime);
                    }
                    log.error((Object)"no VPN keys are available to launch a new instance");
                    log.error((Object)"check the VPN key table on wrath to see instance bindings");
                    return null;
                }
                catch (AmazonServiceException e) {
                    log.error((Object)e);
                }
                catch (AmazonClientException e) {
                    log.error((Object)e);
                }
                Utils.sleep(5000);
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)"File '/home/autotest/AWS/AwsCredentials.properties' NOT found");
            log.error((Object)e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)AwsHelper.class.getName());
        TestRunnerLauncher config = new TestRunnerLauncher();
        TestRunner.setConfiguration(config);
        config.initFileRoot();
        config.setStoreToDb(true);
        config.setHistoryDepth(50);
        try {
            AwsHelper.loadAmazonWebServicesConfiguration();
            AwsHelper.getFreeAwsVpnKeyOrdinal();
        }
        catch (ConfigurationException e) {
            log.error((Object)"File '/home/autotest/AWS/AwsCredentials.properties' NOT found");
            log.error((Object)e);
        }
    }

    protected static class ZombieProperties {
        public String instanceId;
        public Date batchStartTime;
        public long lifespanMinutes;

        protected ZombieProperties() {
        }
    }
}

