/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUpload;

public abstract class Authenticator
extends Base
implements IAutoConfigurable,
IAuthenticator {
    public String usernameParameter = "username";
    public String passwordParameter = "password";

    public boolean containsCredentials(RequestContext context) throws Exception {
        return this.getSubmittedUsername(context) != null && this.getSubmittedPassword(context) != null;
    }

    public String getUsername(RequestContext context, Object user) throws Exception {
        return this.getSubmittedUsername(context);
    }

    protected String getSubmittedUsername(RequestContext context) throws Exception {
        return this.getRequestParameter(this.usernameParameter, context);
    }

    protected String getSubmittedPassword(RequestContext context) throws Exception {
        return this.getRequestParameter(this.passwordParameter, context);
    }

    protected String getRequestParameter(String parameterName, RequestContext context) {
        if (FileUpload.isMultipartContent((HttpServletRequest)context.request)) {
            Map queryParams = null;
            try {
                queryParams = ServletTools.parseQueryString(context.request.getQueryString());
            }
            catch (Exception e) {
                RequestContext.staticLog.error((Object)"Authenticator can't parse queryParams", e);
                return null;
            }
            return (String)queryParams.get(parameterName);
        }
        return context.request.getParameter(parameterName);
    }

    public abstract Object authenticate(RequestContext var1) throws Exception;
}

