/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.ValueMap;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;

public class PointType
extends BasicDataSource {
    private static Logger log = new Logger(ValueMap.class.getName());

    public Object toRecord(Object data, ValidationContext context) throws Exception {
        if (data instanceof List) {
            log.warn("data is already a List");
            return this.toRecords((List)data, context);
        }
        if (data instanceof Element) {
            Element element = (Element)data;
            if (element.hasAttribute("x") && element.hasAttribute("y")) {
                ArrayList<Long> result = new ArrayList<Long>();
                try {
                    long l = Long.parseLong(element.getAttribute("x"));
                    result.add(new Long(l));
                    l = Long.parseLong(element.getAttribute("y"));
                    result.add(new Long(l));
                }
                catch (NumberFormatException ex) {
                    throw new Exception("y and y attributes must be numeric");
                }
                return result;
            }
            throw new Exception("Point must have x and y attributes");
        }
        if (data instanceof HashMap) {
            HashMap map = (HashMap)data;
            if (map.containsKey("x") && map.containsKey("y")) {
                Long l;
                Object attr = map.get("x");
                ArrayList<Object> res = new ArrayList<Object>();
                if (attr instanceof Long) {
                    res.add(attr);
                } else if (attr instanceof Integer) {
                    l = ((Integer)attr).longValue();
                    res.add(l);
                } else if (attr instanceof String) {
                    try {
                        l = Long.parseLong((String)attr);
                        res.add(l);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("X coordinate of point must be number");
                    }
                } else {
                    throw new Exception("Unknow type " + attr.getClass().getName() + " for coordinate x");
                }
                attr = map.get("x");
                if (attr instanceof Long) {
                    res.add(attr);
                } else if (attr instanceof Integer) {
                    l = ((Integer)attr).longValue();
                    res.add(l);
                } else if (attr instanceof String) {
                    try {
                        l = Long.parseLong((String)attr);
                        res.add(attr);
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("Y coordinate of point must be number");
                    }
                } else {
                    throw new Exception("Unknow type " + attr.getClass().getName() + " for coordinate Y");
                }
                return res;
            }
            throw new Exception("Point must have x and y attributes");
        }
        log.warn("Instance of data is " + data.getClass().getName() + ".Using " + "DataTools.makeListIfSingle to convert it to List");
        return DataTools.makeListIfSingle(data);
    }
}

