/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;

public class IDACall
extends BaseServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
            response.setContentType("text/plain;charset=" + encoding);
        }
        if (this.log.isDebugEnabled()) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                this.log.debug("Header Name:Value pair: " + headerName + ":" + headerValue);
                if (!"authorization".equals(headerName)) continue;
                String encodedValue = headerValue.split(" ")[1];
                String decodedValue = new String(Base64.decodeBase64((byte[])encodedValue.getBytes()));
                this.log.debug("Base64-decoded Authorization Value: " + decodedValue);
            }
            HttpSession ses = request.getSession(false);
            this.log.debug("session exists: " + (ses == null ? "null" : ses.getId()));
            this.log.debug("remote user: " + request.getRemoteUser());
        }
        try {
            this.processRequest(request, response);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RPCManager rpc = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                rpc = new RPCManager((Servlet)this, request, response);
            }
            catch (ClientMustResubmitException cmre) {
                return;
            }
            this.processRPCTransaction(rpc, context);
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
    }

    public void processRPCTransaction(RPCManager rpc, RequestContext context) throws Exception {
        this.log.info("Performing " + rpc.requestCount() + " operation(s) [UA: " + context.request.getHeader("User-Agent") + "]");
        for (Object r : rpc.getRequests()) {
            if (r instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)r;
                rpc.send(rpcRequest, this.handleRPCRequest(rpcRequest, rpc, context));
                continue;
            }
            DSRequest dsRequest = (DSRequest)r;
            try {
                rpc.send(dsRequest, this.handleDSRequest(dsRequest, rpc, context));
            }
            catch (Exception e) {
                Logger.observeThread();
                try {
                    this.log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rpc.sendFailure((Object)dsRequest, e);
            }
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return dsRequest.execute();
        }
        catch (Exception e) {
            String errorToString = e.toString();
            StackTraceElement[] stack = e.getStackTrace();
            Throwable t = e.fillInStackTrace();
            e.setStackTrace(stack);
            if (errorToString != null && !errorToString.equals("") && t != null) {
                RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", e);
            } else {
                e.setStackTrace(stack);
                RequestContext.staticLog.warn((Object)("dsRequest.execute() failed: " + e.getClass().getName() + ": " + e.getMessage() + " (The original exception may be missing information)"), e);
            }
            DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
            if (e instanceof UpdateWithoutPKException) {
                dsResponse.setStatus(-9);
            } else {
                dsResponse.setStatus(DSResponse.STATUS_FAILURE);
            }
            dsResponse.setData(e.getMessage());
            return dsResponse;
        }
    }

    public RPCResponse handleRPCRequest(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return rpcRequest.execute();
        }
        catch (Exception e) {
            RequestContext.staticLog.warn((Object)"rpcRequest.execute() failed: ", e);
            RPCResponse rpcResponse = new RPCResponse();
            rpcResponse.setStatus(RPCResponse.STATUS_FAILURE);
            rpcResponse.setData(e.getMessage());
            return rpcResponse;
        }
    }
}

