/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.NightlyBuildStatusDao;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.base.ISCInit;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class BatchEvaluator {
    protected static final int NO_NEW_COMMITS = 10;

    public static void main(String[] args) throws Exception {
        String status;
        ISCInit.go((String)BatchEvaluator.class.getName());
        PosixParser parser = new PosixParser();
        Options options = new Options();
        Option branchOption = new Option("br", "branch", true, "Branch to evaluate");
        branchOption.setRequired(true);
        options.addOption(branchOption);
        TestRunnerLauncher config = new TestRunnerLauncher();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            TestRunner.setConfiguration(config);
            config.installOptionValues(line);
            config.initFileRoot();
        }
        catch (MissingOptionException moe) {
            Utils.outputHelp("batchEvaluator [OPT1] [ARG1] [OPT2] [ARG2] ...", options, moe.getMessage());
            System.exit(5);
        }
        String branch = config.getBranch();
        Date targetBatch = BatchRunDao.getLastBatchFromPreviousDay(branch);
        if (targetBatch == null) {
            System.exit(10);
        }
        if (!"success".equals(status = BatchRunDao.getBatchProperty(targetBatch, "completionStatus"))) {
            System.exit(20);
        }
        List<String> showcases = ShowcaseSpecifier.getValidShowcases(branch, null);
        for (int i = 0; i < showcases.size(); ++i) {
            double passRatio;
            double d = passRatio = Utils.compareBranches(branch, "MAIN") < 0 ? 0.95 : 0.9;
            if (!(BatchEvaluator.getPassRatio(targetBatch, showcases.get(i), branch) < passRatio)) continue;
            System.exit(30 + i);
        }
        String awsInstanceId = BatchRunDao.getAwsInstanceId(targetBatch);
        NightlyBuildStatusDao.add(branch, awsInstanceId);
        System.exit(0);
    }

    protected static double getPassRatio(Date targetBatch, String showcase, String branch) throws Exception {
        List<TestResult> tests = TestResultDao.getTestsForBatch(targetBatch, showcase, branch);
        TestRunner.compareBatches(tests, tests);
        double ratio = TestRunner.getPassRatio();
        TestRunner.clearTestResults();
        return ratio;
    }

    protected static boolean isStatusError(int status) {
        return status != 0 && status != 10;
    }
}

