/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.DetailViewParser;
import com.isomorphic.autotest.SeleniumServerHelper;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHTMLLauncher;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.TestRunnerSelenium;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class TestRunnerHelper
extends ConfiguredBase {
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";
    protected static final String GET_ACTIVE_WINDOW = "selenium.browserbot.getCurrentWindow()";
    protected static final String TESTRUNNER_OBJECT = "isc.TestRunner.getSingletonInstance()";
    protected static final String EXTRACT_TESTRUNNER_OBJECT = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner";
    protected static final String EXTRACT_TESTCONFIG_OBJECT = "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig";
    protected static final String HTML_BEGIN_COMMENT = "\\<!\\-\\-";
    protected static final String HTML_END_COMMENT = "\\-\\-\\>";
    protected static final String RCTEST_MAXIMIZE_TAG = "/^\\<!\\-\\-\\s*maximize\\s*\\-\\-\\>$/m";
    private static Logger log = new Logger(TestRunnerHelper.class.getName());
    private static final TestCaseResults SEPARATE_BROWSER_TOKEN = new TestCaseResults();
    private static final int MAX_SESSION_ID_COLLISIONS = 10;

    public static void testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, boolean batchRun, TestCallback callback) {
        List<String> testFiles;
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        String testRootPath = config.getTestRoot(null);
        if (runUsualTests && (testFiles = ((TestRunnerLauncher)config).getTestScripts(scripts, "\\.*\\.test(\\.(jsp|isc|html))?$", testRootPath)) != null && testFiles.size() > 0) {
            TestRunnerHelper.processUsualTests(testFiles, browser, callback, testRootPath, batchRun);
        }
        if (runSelenium && (testFiles = ((TestRunnerLauncher)config).getTestScripts(scripts, "\\.*\\.rctest(\\.(jsp|isc|html))?$", testRootPath)) != null && testFiles.size() > 0) {
            TestRunnerHelper.processSeleniumTests(testFiles, browser, callback, seleniumServerHelper, testRootPath);
        }
        seleniumServerHelper.stopSeleniumServer();
    }

    protected static void processSeleniumTests(List testFiles, String browser, TestCallback callback, SeleniumServerHelper seleniumServerHelper, String testRootPath) {
        String browserURL = config.getHttpBaseURL(null);
        for (Object object : testFiles) {
            try {
                TestCaseResults tcr = TestRunnerHelper.testRctest(browserURL, testRootPath, (String)object, browser, seleniumServerHelper, null, null);
                callback.onTestResults(tcr);
            }
            catch (IOException e) {
                log.error((Object)("Problems with selenium test: " + object), (Throwable)e);
            }
        }
    }

    protected static void processUsualTests(List testFiles, String browser, TestCallback callback, String testRootPath, boolean batch) {
        if (!"localhost".equals(config.getHttpTarget())) {
            log.warn((Object)"Attempting to run .test TestRunner.js tests on a remote machine. This is unpredictable because the list of tests to run is generated locally, yet the files are then loaded by the remote browser.  If the two hiearchies differ, tests may not load and may time out.");
        }
        if (batch) {
            String browserURL = config.getHttpBaseURL(null);
            String fileRootPath = config.getFileRoot();
            int port = SeleniumServerHelper.getInstance().getSeleniumPort();
            TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, browserURL);
            selenium.start();
            for (Object object : testFiles) {
                String name = ((String)object).substring(testRootPath.length() + 1);
                String filePath = ((String)object).substring(fileRootPath.length() + 1);
                TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
                TestCaseResults tcr = TestRunnerHelper.test(ts, browser, (Selenium)selenium, null, true);
                if (tcr != null) {
                    callback.onTestResults(tcr);
                    continue;
                }
                if (tcr != SEPARATE_BROWSER_TOKEN) continue;
                TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath);
            }
            selenium.stop();
        } else {
            for (Object object : testFiles) {
                TestRunnerHelper.processUsualTest((String)object, browser, callback, testRootPath);
            }
        }
    }

    public static List<TestCaseResults> testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] scripts, boolean batchRun) {
        final ArrayList<TestCaseResults> result = new ArrayList<TestCaseResults>();
        TestRunnerHelper.testAll(browser, runSelenium, runUsualTests, scripts, batchRun, new TestCallback(){

            @Override
            public void onTestResults(TestCaseResults testCaseResults) {
                result.add(testCaseResults);
            }
        });
        return result;
    }

    protected static void processUsualTest(String testFile, String browser, TestCallback callback, String testRootPath) {
        String browserURL = config.getHttpBaseURL(null);
        String fileRootPath = config.getFileRoot();
        int port = SeleniumServerHelper.getInstance().getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, browserURL);
        selenium.start();
        String name = testFile.substring(testRootPath.length() + 1);
        String filePath = testFile.substring(fileRootPath.length() + 1);
        TestSpecifier ts = new TestSpecifier(browserURL + filePath, name);
        TestCaseResults tcr = TestRunnerHelper.test(ts, browser, (Selenium)selenium, null, false);
        if (tcr != null) {
            callback.onTestResults(tcr);
        }
        selenium.stop();
    }

    public static TestCaseResults testRctest(String browserURL, String filePathPrefix, String filePath, String browser, SeleniumServerHelper seleniumServerHelper, ShowcaseSpecifier showcase, String smartClientId) throws IOException {
        String param;
        TestRunnerLauncher launcher = (TestRunnerLauncher)config;
        SeleniumServer server = seleniumServerHelper.getSeleniumServer();
        int serverPort = server.getConfiguration().getPortDriversShouldContact();
        File tmpDir = new File(TestRunnerHelper.tmpDir);
        File testOrig = new File(filePath);
        File testCopy = File.createTempFile(Utils.getUnqualifiedFileName(filePath, true), ".rctest.html", tmpDir);
        FileUtils.copyFile((File)testOrig, (File)testCopy);
        String testHtml = FileUtils.readFileToString((File)testOrig);
        boolean maximizeTag = Utils.matchRegExp(RCTEST_MAXIMIZE_TAG, testHtml);
        ISCFile templateFile = new ISCFile(config.getSeleniumTemplateFile());
        InputStream templateStream = templateFile.getInputStream();
        String templateData = IOUtils.toString((InputStream)templateStream);
        IOUtils.closeQuietly((InputStream)templateStream);
        String testFilePath = Utils.getSeleniumFilePath(testCopy.getName(), serverPort);
        templateData = templateData.replace("{url}", testFilePath);
        File suite = new File(tmpDir, "suite.html");
        server.addNewStaticContent(suite.getParentFile());
        FileWriter fw = new FileWriter(suite);
        IOUtils.write((String)templateData, (Writer)fw);
        fw.flush();
        IOUtils.closeQuietly((Writer)fw);
        String suiteURL = Utils.getSeleniumFilePath(suite.getName(), serverPort);
        String filename = Utils.getTestName(filePath, filePathPrefix);
        if (launcher.shouldMaximizeBrowser(maximizeTag)) {
            suiteURL = Utils.addURLArgument(suiteURL, "maximize=true");
        }
        if (launcher.shouldSaveMessages()) {
            suiteURL = Utils.addURLArgument(suiteURL, "addMessages=true");
        }
        if (launcher.shouldSaveServerLogs()) {
            suiteURL = Utils.addURLArgument(suiteURL, "serverLogMode=" + config.getServerLogMode());
        }
        if (showcase != null && (param = showcase.getExampleOpenShowcase()) != null) {
            suiteURL = Utils.addURLArgument(suiteURL, "showcase=" + param);
        }
        if (smartClientId != null) {
            String mappedId = showcase.getShowcaseSpecificId(smartClientId);
            suiteURL = Utils.addURLArgument(suiteURL, "mappedId=" + mappedId);
        }
        File outputFile = new File(tmpDir, "test.out.html");
        int timeout = config.getSeleniumTimeout();
        suiteURL = Utils.addURLArgument(suiteURL, "timeout=" + timeout);
        TestCaseResults results = new TestCaseResults();
        results.setStartTime(new Date());
        results.setTestName(filename);
        TestResult res = new TestResult();
        res.setTestFile(filename);
        res.setTestNumber(1);
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", serverPort, browser, browserURL);
        TestRunnerHTMLLauncher l = new TestRunnerHTMLLauncher(server, selenium, res);
        for (int nRetries = 9; nRetries >= 0; --nRetries) {
            try {
                res.setStartTime(results.getStartTime());
                String status = l.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeout + 5, launcher.shouldMaximizeBrowser(maximizeTag) || launcher.shouldCaptureScreenshot());
                results.setEndTime(new Date());
                res.setEndTime(results.getEndTime());
                res.setResult("PASSED".equals(status) ? "success" : "failure");
                HTMLTestResults htr = l.getResults();
                StringWriter sw = new StringWriter();
                htr.write((Writer)sw);
                if (res.isFailure()) {
                    res.setContent(StringUtils.substringBetween((String)sw.toString(), (String)"<pre>", (String)"</pre>"));
                }
                sw.close();
                break;
            }
            catch (IOException e) {
                log.error((Object)"test suite cannot be run", (Throwable)e);
                break;
            }
            catch (SeleniumCommandTimedOutException te) {
                res.setResult("timeout");
                results.setEndTime(new Date());
                res.setEndTime(results.getEndTime());
                res.setDetails("TestCase results have not appeared after " + timeout + " seconds");
                String content = l.getTimeoutLog();
                if (content == null) break;
                res.setContent(content);
                break;
            }
            catch (RuntimeException e) {
                block15: {
                    block14: {
                        String errorMessage = e.getMessage();
                        if (errorMessage == null || !errorMessage.startsWith("sessionId") || errorMessage.indexOf("already exists") < 0) break block14;
                        log.error((Object)(e.getMessage() + " (" + nRetries + " attempts left)"), (Throwable)e);
                        if (nRetries != 0) break block15;
                    }
                    throw e;
                }
                Utils.sleep(5678);
                continue;
            }
        }
        testCopy.delete();
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        testResults.add(res);
        results.setTestResults(testResults);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestCaseResults test(TestSpecifier specifier, String browser, Selenium selenium, ShowcaseSpecifier showcase, boolean batch) {
        TestCaseResults results;
        block19: {
            results = new TestCaseResults();
            results.setTestName(specifier.getTestName());
            Date testStartTime = new Date();
            try {
                specifier.run(selenium);
                int timeout = TestRunnerHelper.getTestTimeout(selenium, showcase);
                if (timeout == 0) {
                    TestCaseResults testCaseResults = null;
                    return testCaseResults;
                }
                if (batch && showcase == null && TestRunnerHelper.shouldUseSeparateBrowser(selenium)) {
                    TestCaseResults testCaseResults = SEPARATE_BROWSER_TOKEN;
                    return testCaseResults;
                }
                boolean success = TestRunnerHelper.configureBrowserAndWaitForElementPresent(selenium, "scLocator=//DetailViewer[ID='isc_AutoTest_DetailViewer']", timeout);
                Date testEndTime = new Date();
                if (success) {
                    String html = selenium.getHtmlSource();
                    try {
                        List<Map<String, String>> testResults = DetailViewParser.parse(html);
                        ArrayList<TestResult> trs = new ArrayList<TestResult>();
                        boolean saveMessages = config.shouldSaveMessages();
                        boolean saveServerLogs = config.shouldSaveServerLogs();
                        int[] counts = TestRunnerHelper.getTestCaseNotificationCounts(selenium);
                        int testNumber = 0;
                        for (Map<String, String> testData : testResults) {
                            TestResult tr = new TestResult();
                            tr.setStartTime(testStartTime);
                            tr.setEndTime(testEndTime);
                            tr.setResult(testData.get("result"));
                            tr.setDescription(testData.get("description"));
                            tr.setDetails(testData.get("detail"));
                            tr.setTestFile(specifier.getTestName());
                            if (counts != null) {
                                tr.setNotificationCount(counts[testNumber]);
                            }
                            tr.setTestNumber(++testNumber);
                            if (tr.isFailure() && saveMessages) {
                                String messages = showcase != null ? Utils.getDeveloperConsoleMessages(selenium) : TestRunnerHelper.getMessagesForTest(selenium, testNumber);
                                tr.setMessages(messages);
                            }
                            if (saveServerLogs) {
                                tr.setServerLogs(ShowcaseSpecifier.getServerLogs(selenium, showcase, testNumber));
                            }
                            trs.add(tr);
                        }
                        results.setTestResults(trs);
                    }
                    catch (Exception e) {
                        log.error((Object)"Parsing detail viewer data failed:", (Throwable)e);
                        try {
                            results.setUnparsableResponse(DetailViewParser.getDetailViewerHtml(html));
                            break block19;
                        }
                        catch (Exception e2) {
                            results.setUnparsableResponse(html);
                        }
                    }
                    break block19;
                }
                results.setTimeoutError(true);
                results.setStartTime(testStartTime);
                results.setEndTime(testEndTime);
                results.setTimeoutInSeconds(timeout);
                String report = ShowcaseSpecifier.getPartialReportForTimedoutTest(selenium, showcase);
                results.setPartialReport(report);
            }
            catch (SeleniumException se) {
                log.error((Object)"Selenium error: ", (Throwable)se);
                results.setStartTime(testStartTime);
                results.setEndTime(new Date());
                results.setSeleniumError(se.getMessage());
            }
            finally {
                specifier.complete(selenium);
            }
        }
        if (results.getTestResults() == null) {
            int count = TestRunnerHelper.getDefaultTestCaseNotificationCount(selenium);
            results.setNotificationCount(count);
        }
        return results;
    }

    protected static String getMessagesForTest(Selenium selenium, int naturalIndex) {
        return Utils.getEvalWithTry(selenium, "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.getMessages(" + (naturalIndex - 1) + ")");
    }

    protected static boolean waitForElementPresent(Selenium selenium, String element, int timeoutInSeconds) {
        long startTime = System.currentTimeMillis();
        do {
            try {
                if (selenium.isElementPresent(element)) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Utils.sleep(500);
        } while (System.currentTimeMillis() - startTime < (long)(timeoutInSeconds * 1000));
        return false;
    }

    protected static boolean shouldMaximizeBrowser(Selenium selenium) {
        String testConfigJs = EXTRACT_TESTCONFIG_OBJECT;
        String maximize = Utils.getEvalWithTry(selenium, testConfigJs + ".maximize");
        if (maximize.equalsIgnoreCase("null")) {
            maximize = null;
        }
        if (maximize != null) {
            return Boolean.parseBoolean(maximize);
        }
        return ((TestRunnerLauncher)config).shouldMaximizeBrowser();
    }

    protected static boolean shouldUseSeparateBrowser(Selenium selenium) {
        String testConfigJs = EXTRACT_TESTCONFIG_OBJECT;
        return Boolean.parseBoolean(Utils.getEvalWithTry(selenium, testConfigJs + ".separate"));
    }

    protected static boolean configureBrowserAndWaitForElementPresent(Selenium selenium, String element, int timeoutInSeconds) {
        boolean maximize = TestRunnerHelper.shouldMaximizeBrowser(selenium);
        if (((TestRunnerSelenium)selenium).getBrowserMaximized() != maximize) {
            ((TestRunnerSelenium)selenium).setBrowserMaximized(maximize);
            Utils.setBrowserMaximization(selenium, maximize);
        }
        return TestRunnerHelper.waitForElementPresent(selenium, element, timeoutInSeconds);
    }

    public static int getTestTimeout(Selenium selenium, ShowcaseSpecifier showcase) {
        String testIsDisabled;
        String testConfigJs;
        String testTimeout;
        if (!ShowcaseSpecifier.isTestRunnerBased(showcase)) {
            return config.getSeleniumTimeout();
        }
        int timeout = config.getTestRunnerTimeout();
        if (!Utils.waitForJSToSucceed(selenium, "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.testConfig != null", 10)) {
            log.error((Object)"Attempt to read TestRunner.testConfig timed out. Selenium will not be able to apply any custom test configuration.");
        }
        if ((testTimeout = Utils.getEvalWithTry(selenium, (testConfigJs = EXTRACT_TESTCONFIG_OBJECT) + ".timeout")) == null || "null".equalsIgnoreCase(testTimeout)) {
            return timeout;
        }
        if (timeout < Integer.parseInt(testTimeout) / 1000) {
            timeout = Integer.parseInt(testTimeout) / 1000;
        }
        return "true".equalsIgnoreCase(testIsDisabled = Utils.getEvalWithTry(selenium, testConfigJs + ".testDisabled")) ? 0 : timeout;
    }

    public static int[] getTestCaseNotificationCounts(Selenium selenium) {
        String rawValue = Utils.getEvalWithTry(selenium, "var window = selenium.browserbot.getCurrentWindow(), runner = window.isc.TestRunner.getSingletonInstance();     runner.getTestCaseNotificationCounts()");
        try {
            String[] values = rawValue.split("[\\[\\s,]");
            int[] counts = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                counts[i] = Integer.parseInt(values[i]);
            }
            return counts;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static int getDefaultTestCaseNotificationCount(Selenium selenium) {
        String testConfigJs = EXTRACT_TESTCONFIG_OBJECT;
        String rawValue = Utils.getEvalWithTry(selenium, testConfigJs + ".notificationCount");
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static TestCaseResults test(String url, String browser) {
        SeleniumServerHelper seleniumServerHelper = SeleniumServerHelper.getInstance();
        seleniumServerHelper.startSeleniumServer();
        int port = seleniumServerHelper.getSeleniumPort();
        TestRunnerSelenium selenium = new TestRunnerSelenium("localhost", port, browser, config.getHttpBaseURL(null));
        selenium.start();
        TestCaseResults result = TestRunnerHelper.test(new TestSpecifier(url, null), browser, (Selenium)selenium, null, false);
        selenium.stop();
        seleniumServerHelper.stopSeleniumServer();
        return result;
    }

    public static interface TestCallback {
        public void onTestResults(TestCaseResults var1);
    }
}

