/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.HttpResponse;

public class JeeServletHttpResponse
implements HttpResponse {
    private final HttpServletResponse response;

    public JeeServletHttpResponse(HttpServletResponse response) {
        this.response = (HttpServletResponse)Preconditions.checkNotNull((Object)response);
    }

    @Override
    public void setStatus(int status) {
        this.response.setStatus(status);
    }

    @Override
    public void setContentType(String mimeType) {
        this.response.setContentType(mimeType);
    }

    @Override
    public void setContent(byte[] data) {
        int length = data == null ? 0 : data.length;
        this.response.setContentLength(length);
        try {
            this.response.getOutputStream().write(data);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    public void setContent(String message) {
        this.setContent(message.getBytes());
    }

    @Override
    public void setEncoding(Charset charset) {
        this.response.setCharacterEncoding(charset.name());
    }

    @Override
    public void sendRedirect(String to) {
        this.response.setContentLength(0);
        try {
            this.response.sendRedirect(to);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    @Override
    public void end() {
        try {
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    public HttpServletResponse getServletResponse() {
        return this.response;
    }
}

