/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.contentexport;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.Base64;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.xhtmlrenderer.context.StyleReference;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.newmatch.CascadedStyle;
import org.xhtmlrenderer.css.sheet.PropertyDeclaration;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.pdf.ITextReplacedElementFactory;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;

public class B64ImgReplacedElementFactory
extends ITextReplacedElementFactory {
    private static final float mmPerCm = 10.0f;
    private static final float mmPerIn = 25.4f;
    private static final float mmPerPica = 4.233333f;
    private static final float mmPerPt = 0.35277778f;

    private static Float getFloatValueDots(LayoutContext c, PropertyDeclaration lengthPropDecl) {
        if (lengthPropDecl == null) {
            return null;
        }
        CSSPrimitiveValue val = lengthPropDecl.getValue();
        if (val == null) {
            return null;
        }
        switch (val.getPrimitiveType()) {
            case 5: {
                return Float.valueOf(val.getFloatValue((short)5) * (float)c.getDotsPerPixel());
            }
            case 6: {
                return Float.valueOf(val.getFloatValue((short)6) * 10.0f / c.getMmPerDot());
            }
            case 8: {
                return Float.valueOf(val.getFloatValue((short)8) * 25.4f / c.getMmPerDot());
            }
            case 10: {
                return Float.valueOf(val.getFloatValue((short)10) * 4.233333f / c.getMmPerDot());
            }
            case 9: {
                return Float.valueOf(val.getFloatValue((short)9) * 0.35277778f / c.getMmPerDot());
            }
        }
        return null;
    }

    public B64ImgReplacedElementFactory(ITextOutputDevice outputDevice) {
        super(outputDevice);
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if ("img".equals(nodeName)) {
            FSImage fsImage;
            String attribute = e.getAttribute("src");
            try {
                fsImage = B64ImgReplacedElementFactory.buildImage(c, attribute, uac);
            }
            catch (BadElementException e1) {
                fsImage = null;
            }
            catch (IOException e1) {
                fsImage = null;
            }
            if (fsImage != null) {
                CSSPrimitiveValue maxWidthVal;
                float maxWidthPct;
                PropertyDeclaration maxWidthDecl;
                StyleReference styleRef = c.getCss();
                CascadedStyle cascadedStyle = styleRef.getCascadedStyle(e, false);
                if (cssWidth == -1) {
                    cssWidth = fsImage.getWidth();
                }
                if (cssHeight == -1) {
                    cssHeight = fsImage.getHeight();
                }
                if ((maxWidthDecl = cascadedStyle.propertyByName(CSSName.MAX_WIDTH)) != null && (maxWidthPct = (maxWidthVal = maxWidthDecl.getValue()).getFloatValue((short)2)) == 100.0f) {
                    Node ancestorNode;
                    for (ancestorNode = e.getParentNode(); ancestorNode != null && ancestorNode.getNodeType() != 1; ancestorNode = ancestorNode.getParentNode()) {
                    }
                    if (ancestorNode != null) {
                        int maxWidth;
                        Float f;
                        Element parentElem = (Element)ancestorNode;
                        CascadedStyle parentCascadedStyle = styleRef.getCascadedStyle(parentElem, false);
                        float parentHMarginDots = 0.0f;
                        if ("body".equalsIgnoreCase(parentElem.getTagName())) {
                            f = B64ImgReplacedElementFactory.getFloatValueDots(c, parentCascadedStyle.propertyByName(CSSName.MARGIN_LEFT));
                            if (f != null) {
                                parentHMarginDots += f.floatValue();
                            }
                            if ((f = B64ImgReplacedElementFactory.getFloatValueDots(c, parentCascadedStyle.propertyByName(CSSName.MARGIN_RIGHT))) != null) {
                                parentHMarginDots += f.floatValue();
                            }
                        }
                        if ((f = B64ImgReplacedElementFactory.getFloatValueDots(c, parentCascadedStyle.propertyByName(CSSName.WIDTH))) == null) {
                            Box parentBox = box.getParent();
                            if (parentBox == null) {
                                parentBox = c.getLayer().getMaster();
                            }
                            f = Float.valueOf(parentBox.getWidth() - box.getAbsX());
                        }
                        if (cssWidth > (maxWidth = (int)Math.floor(f.floatValue() - parentHMarginDots))) {
                            cssHeight = (int)((float)maxWidth / (float)cssWidth * (float)cssHeight);
                            cssWidth = maxWidth;
                        }
                    }
                }
            }
            fsImage.scale(cssWidth, cssHeight);
            return new ITextImageElement(fsImage);
        }
        return null;
    }

    private static FSImage buildImage(LayoutContext c, String srcAttr, UserAgentCallback uac) throws IOException, BadElementException {
        FSImage fsImage;
        if (srcAttr.startsWith("data:image/")) {
            String b64encoded = srcAttr.substring(srcAttr.indexOf("base64,") + "base64,".length());
            fsImage = new ITextFSImage(Image.getInstance((byte[])Base64.decode((String)b64encoded)));
            fsImage.scale(fsImage.getWidth() * c.getDotsPerPixel(), fsImage.getHeight() * c.getDotsPerPixel());
        } else {
            fsImage = uac.getImageResource(srcAttr).getImage();
        }
        return fsImage;
    }

    public void remove(Element e) {
    }

    public void reset() {
    }
}

