/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuditDSGenerator
implements DynamicDSGenerator {
    public static String DEFAULT_REVISION_FIELD_NAME = "audit_revision";
    public static String DEFAULT_TIMESTAMP_FIELD_NAME = "audit_changeTime";
    public static String DEFAULT_TYPE_FIELD_NAME = "audit_operationType";
    public static String DEFAULT_USER_FIELD_NAME = "audit_modifier";
    public static String DEFAULT_SCHEMA_NAME = "auditSchema";
    private static Logger log = new Logger(AuditDSGenerator.class.getName());
    private Map ds2audit = Collections.synchronizedMap(new HashMap());
    private static List<String> auditedDses = Collections.synchronizedList(new ArrayList());
    private static Map ds2TableChecked = new HashMap();
    private Config config = Config.getGlobal();

    public DataSource getDataSource(String id, DSRequest dsRequest) {
        if (!this.ds2audit.containsKey(id)) {
            return null;
        }
        log.debug(id + " is an audit DataSource, processing");
        boolean hasPrimaryKey = true;
        try {
            DataSource ds = DataSourceManager.getDataSource((String)this.ds2audit.get(id));
            DataSource ret = ((BasicDataSource)ds).getAuditDataSource();
            if (ret == null) {
                try {
                    StringWriter sw = new StringWriter();
                    sw.write("<DataSource ");
                    sw.write("serverType=\"");
                    sw.write((String)ds.getConfig().get("serverType"));
                    sw.write("\"");
                    sw.write(" ID=\"");
                    sw.write(id);
                    sw.write("\"");
                    sw.write(" inheritsFrom=\"");
                    sw.write(ds.getID());
                    sw.write("\"");
                    sw.write(" xmlFromConfig=\"true\"");
                    String tmp = AuditDSGenerator.getAuditSchemaName(ds);
                    if (tmp != null) {
                        sw.write(" schema=\"");
                        sw.write(tmp);
                        sw.write("\"");
                    }
                    if ((tmp = AuditDSGenerator.getAuditDSConstructor(ds)) != null) {
                        if ("sql".equals(tmp)) {
                            tmp = "com.isomorphic.sql.SQLDataSource";
                        }
                        sw.write(" serverConstructor=\"");
                        sw.write(tmp);
                        sw.write("\"");
                    }
                    sw.write(">\n");
                    sw.write("<fields>\n");
                    tmp = AuditDSGenerator.getAuditRevisionFieldName(ds);
                    if (tmp != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"sequence\" primaryKey=\"true\"/>\n");
                    } else {
                        hasPrimaryKey = false;
                    }
                    tmp = AuditDSGenerator.getAuditTypeFieldName(ds);
                    if (tmp != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"enum\">\n");
                        sw.write("<valueMap>\n");
                        sw.write("\t<value>add</value>");
                        sw.write("\t<value>remove</value>");
                        sw.write("\t<value>update</value>");
                        sw.write("</valueMap>\n");
                        sw.write("</field>\n");
                    }
                    if ((tmp = AuditDSGenerator.getAuditTimestampFieldName(ds)) != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"creatorTimestamp\" hidden=\"false\"/>\n");
                    }
                    if ((tmp = AuditDSGenerator.getAuditUserFieldName(ds)) != null) {
                        sw.write("<field name=\"");
                        sw.write(tmp);
                        sw.write("\"    type=\"creator\" hidden=\"false\"/>\n");
                    }
                    List fields = ds.getFieldNames();
                    log.debug("Found " + fields.size() + " fields in the inherited datasource!");
                    for (String name : fields) {
                        boolean needsChanges = false;
                        DSField f = new DSField((Map)ds.getField(name));
                        if (f.containsKey("validators")) {
                            f.remove("validators");
                        }
                        if (f.isPrimaryKey() && !f.getName().equals(AuditDSGenerator.getAuditRevisionFieldName(ds))) {
                            if (hasPrimaryKey) {
                                log.debug("Setting primaryKey to false on field " + name);
                                f.put("primaryKey", false);
                                f.remove("autoGenerated");
                                needsChanges = true;
                                if ("sequence".equals(f.getType())) {
                                    log.debug("Changing field " + name + " type from sequence to integer.");
                                    f.put("type", "integer");
                                }
                            } else {
                                log.warn("Retaining primaryKey on field " + name + " as the Audit DataSource does not specify one!");
                            }
                        }
                        if (f.isRequired()) {
                            needsChanges = true;
                            f.put("required", false);
                        }
                        if (f.containsKey("audit") && !f.getBoolean("audit")) {
                            needsChanges = true;
                            f.put("inapplicable", true);
                        }
                        if (!needsChanges) continue;
                        log.warn("Field " + name + " has overriden attributes. Saving it to inheriting DataSource.");
                        sw.write("<field ");
                        for (Object key : f.keySet()) {
                            if ("valueMap".equals(key)) continue;
                            String val = f.get(key).toString();
                            sw.write(key.toString());
                            sw.write("=\"");
                            sw.write(val);
                            sw.write("\" ");
                        }
                        if (f.containsKey("valueMap")) {
                            String[] values;
                            sw.write(">\n");
                            sw.write("<valueMap>\n");
                            String mapValues = f.get("valueMap").toString();
                            mapValues = mapValues.replace("[", "").replace("]", "");
                            for (String value : values = mapValues.split(",")) {
                                sw.write("<value>");
                                sw.write(value);
                                sw.write("</value>\n");
                            }
                            sw.write("</valueMap>\n");
                            sw.write("</field>\n");
                            continue;
                        }
                        sw.write(" />\n");
                    }
                    sw.write("</fields>\n");
                    sw.write("</DataSource>");
                    log.debug("Generating DataSource " + id + " from xml:");
                    log.debug(sw.toString());
                    ret = DataSource.fromXML(sw.toString());
                    if (!ds2TableChecked.containsKey(id)) {
                        BasicDataSource bds = (BasicDataSource)ds;
                        if (((BasicDataSource)ds).isAutoCreateAuditTableActive()) {
                            log.debug("Audit table should be autocreated for DataSource " + ds.getID());
                            try {
                                log.debug("Creating audit table for DataSource " + ds.getName());
                                ret.createStorage(false);
                                log.debug("Audit table successfully created for DataSource " + ds.getName());
                            }
                            catch (Exception e1) {
                                log.debug("Error creating audit table for DataSource " + ds.getName());
                            }
                        } else {
                            log.debug("Audit table should not be automatically created for DataSource " + ds.getID());
                        }
                        ds2TableChecked.put(id, id);
                    } else {
                        log.debug("Audit table creation already checked for DataSource " + ds.getID());
                    }
                }
                catch (Exception e) {
                    log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
                }
            }
            DataSourceManager.free(ds);
            return ret;
        }
        catch (Exception e) {
            log.error("Couldn't create audit DataSource " + id + " for the DataSource '" + this.ds2audit.get(id) + " Problem was:\n" + DataTools.getStackTrace(e));
            return null;
        }
    }

    public static String getAuditRevisionFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_REVISION_FIELD_NAME;
            if (ds.getConfig().containsKey("auditRevisionFieldName")) {
                result = (String)ds.getConfig().get("auditRevisionFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            if (ds.getField(result) != null) {
                log.warn("Field " + result + " is already defined in the original DataSource, trying to add a suffix.");
                int counter = 2;
                while (true) {
                    String tmpName;
                    if (ds.getField(tmpName = result + counter) == null) {
                        log.debug("Using " + tmpName + " for audit type field name.");
                        result = tmpName;
                        break;
                    }
                    ++counter;
                }
            }
            log.debug("getAuditRevisionFieldName returns " + result);
            return result;
        }
        return null;
    }

    public static String getAuditTimestampFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_TIMESTAMP_FIELD_NAME;
            if (ds.getConfig().containsKey("auditTimeStampFieldName")) {
                result = (String)ds.getConfig().get("auditTimeStampFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            if (ds.getField(result) != null) {
                log.warn("Field " + result + " is already defined in the original DataSource, trying to add a suffix.");
                int counter = 2;
                while (true) {
                    String tmpName;
                    if (ds.getField(tmpName = result + counter) == null) {
                        log.debug("Using " + tmpName + " for audit type field name.");
                        result = tmpName;
                        break;
                    }
                    ++counter;
                }
            }
            log.debug("getAuditTimestampFieldName returns " + result);
            return result;
        }
        return null;
    }

    public static String getAuditUserFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_USER_FIELD_NAME;
            if (ds.getConfig().containsKey("auditUserFieldName")) {
                result = (String)ds.getConfig().get("auditUserFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            if (ds.getField(result) != null) {
                log.warn("Field " + result + " is already defined in the original DataSource, trying to add a suffix.");
                int counter = 2;
                while (true) {
                    String tmpName;
                    if (ds.getField(tmpName = result + counter) == null) {
                        log.debug("Using " + tmpName + " for audit type field name.");
                        result = tmpName;
                        break;
                    }
                    ++counter;
                }
            }
            log.debug("getAuditUserFieldName returns " + result);
            return result;
        }
        return null;
    }

    public static String getAuditTypeFieldName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = DEFAULT_TYPE_FIELD_NAME;
            if (ds.getConfig().containsKey("auditTypeFieldName")) {
                result = (String)ds.getConfig().get("auditTypeFieldName");
            }
            if (result.length() < 1) {
                return null;
            }
            if (ds.getField(result) != null) {
                log.warn("Field " + result + " is already defined in the original DataSource, trying to add a suffix.");
                int counter = 2;
                while (true) {
                    String tmpName;
                    if (ds.getField(tmpName = result + counter) == null) {
                        log.debug("Using " + tmpName + " for audit type field name.");
                        result = tmpName;
                        break;
                    }
                    ++counter;
                }
            }
            log.debug("getAuditTypeFieldName returns " + result);
            return result;
        }
        return null;
    }

    public static String getAuditSchemaName(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = null;
            if (ds.getConfig().containsKey("auditSchema")) {
                result = (String)ds.getConfig().get("auditSchema");
            }
            return result;
        }
        return null;
    }

    public static String getAuditDSConstructor(DataSource ds) {
        BasicDataSource bds = (BasicDataSource)ds;
        if (bds.getConfig().containsKey("audit") && "true".equals(bds.getConfig().get("audit"))) {
            String result = null;
            if (ds.getConfig().containsKey("auditDSConstructor")) {
                result = (String)ds.getConfig().get("auditDSConstructor");
                log.debug("Using " + result + " for auditDSConstructor.");
            }
            return result;
        }
        return null;
    }

    public void addMapping(String auditDSID, String dsID) {
        this.ds2audit.put(auditDSID, dsID);
        if (!auditedDses.contains(dsID)) {
            auditedDses.add(dsID);
        } else {
            log.warn(dsID + " is already on the list of datasoruces for which we generate audit DataSources!");
        }
    }

    public boolean hasMappingFor(String auditDSID) {
        return this.ds2audit.containsKey(auditDSID);
    }

    public String getMappingFor(String auditDSID) {
        if (this.ds2audit.containsKey(auditDSID)) {
            return (String)this.ds2audit.get(auditDSID);
        }
        return null;
    }
}

