/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToMapHandler
extends DefaultHandler {
    protected boolean useListsForMultipleElements = false;
    public static final String TEXT_VALUE = "__TEXT_VALUE__";
    private HashMap result = null;
    private Stack elements = new Stack();
    private Stack values = new Stack();
    private Stack textValues = new Stack();

    public boolean getUseListsForMultipleElements() {
        return this.useListsForMultipleElements;
    }

    public void setUseListsForMultipleElements(boolean newValue) {
        this.useListsForMultipleElements = newValue;
    }

    public Map getResult() {
        return this.result;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        HashMap<String, String> value = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            String attrName = atts.getQName(i);
            String attrValue = atts.getValue(i);
            value.put(attrName, attrValue);
        }
        this.elements.push(qName);
        this.values.push(value);
        this.textValues.push(new StringBuffer());
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String element = (String)this.elements.pop();
        HashMap value = (HashMap)this.values.pop();
        StringBuffer textValue = (StringBuffer)this.textValues.pop();
        String currentString = textValue.toString().trim();
        if (value.size() > 0) {
            if (currentString.length() > 0) {
                value.put(TEXT_VALUE, currentString);
            }
            if (!this.values.empty()) {
                Map parent = (Map)this.values.peek();
                if (parent.containsKey(element) && this.useListsForMultipleElements && !value.isEmpty()) {
                    ArrayList<Object> list;
                    Object obj = parent.get(element);
                    if (obj instanceof List) {
                        list = (ArrayList<Object>)obj;
                    } else {
                        list = new ArrayList<Object>();
                        list.add(obj);
                    }
                    list.add(value);
                    parent.put(element, list);
                } else {
                    parent.put(element, value.isEmpty() ? null : value);
                }
            } else {
                this.result = value;
            }
        } else if (!this.values.empty()) {
            ((HashMap)this.values.peek()).put(element, currentString.length() > 0 ? currentString : null);
        } else {
            this.result = new HashMap();
            this.result.put(element, currentString.length() > 0 ? currentString : null);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        StringBuffer textValue = (StringBuffer)this.textValues.peek();
        textValue.append(ch, start, length);
    }
}

