/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.CustomCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.RangeCriterion;
import com.isomorphic.criteria.criterion.SetCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedCriteria {
    protected static Logger log = new Logger(AdvancedCriteria.class);
    public static final String CONSTRUCTOR_NAME = "AdvancedCriteria";
    Criterion criteria;

    public AdvancedCriteria(Criterion _criteria) {
        this.criteria = _criteria;
    }

    public AdvancedCriteria(Operator operator, Criterion[] criteria) {
        this(operator.getID(), criteria);
    }

    public AdvancedCriteria(String operator, Criterion ... criteria) {
        this.criteria = criteria.length == 1 ? (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : criteria[0]) : (operator.equals(DefaultOperators.And.getID()) ? new AndCriterion(criteria) : (operator.equals(DefaultOperators.Or.getID()) ? new OrCriterion(criteria) : (operator.equals(DefaultOperators.Not.getID()) ? new NotCriterion(criteria) : new LogicalCriterion(operator, criteria))));
    }

    public Object getFieldValue(String fieldName) {
        Criterion criterion = this.getFieldCriterion(fieldName);
        if (criterion != null) {
            try {
                if (criterion instanceof SetCriterion) {
                    return ((SetCriterion)criterion).getValues();
                }
                return criterion.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Criterion getFieldCriterion(String fieldName) {
        return this.getFieldCriterion(fieldName, this.criteria);
    }

    public Criterion getFieldCriterion(String fieldName, Criterion criteria) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    Criterion res = this.getFieldCriterion(fieldName, c);
                    if (res == null) continue;
                    return res;
                }
            }
        } else if (criteria != null && criteria.getFieldName() != null && criteria.getFieldName().equals(fieldName)) {
            return criteria;
        }
        return null;
    }

    public Set<Criterion> getFieldCriterions(String fieldName) {
        return this.getFieldCriterions(fieldName, this.criteria, new HashSet<Criterion>());
    }

    public Set<Criterion> getFieldCriterions(String fieldName, Criterion criteria, Set<Criterion> resultAccumulator) {
        if (criteria instanceof LogicalCriterion) {
            LogicalCriterion lc = (LogicalCriterion)criteria;
            if (lc.getCriteria() != null) {
                for (Criterion c : lc.getCriteria()) {
                    this.getFieldCriterions(fieldName, c, resultAccumulator);
                }
            }
        } else if (criteria.getFieldName() != null && fieldName.equals(criteria.getFieldName())) {
            resultAccumulator.add(criteria);
        }
        return resultAccumulator;
    }

    public Map<String, Object> getCriteriaAsMap() {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(this.criteria.getOperatorId());
        if (o instanceof OperatorBase) {
            Map<String, Object> result = ((OperatorBase)o).convertToMap(this.criteria);
            result.put("_constructor", CONSTRUCTOR_NAME);
            return result;
        }
        if (this.criteria instanceof CustomCriterion) {
            LinkedMap result = new LinkedMap((Map)((Object)this.criteria));
            result.put("_constructor", CONSTRUCTOR_NAME);
            return result;
        }
        return null;
    }

    public static Map<String, Object> getCriteriaAsMap(Criterion criterion) {
        Operator o = DefaultOperators.getDefaultOperatorMap().get(criterion.getOperatorId());
        if (o instanceof OperatorBase) {
            return ((OperatorBase)o).convertToMap(criterion);
        }
        if (criterion instanceof CustomCriterion) {
            return new LinkedMap((Map)((Object)criterion));
        }
        return null;
    }

    public static boolean isAdvancedCriteria(Object criteria) {
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        if (l != null) {
            if (l.size() == 1) {
                Map critData = (Map)l.get(0);
                return CONSTRUCTOR_NAME.equals(critData.get("_constructor"));
            }
            return false;
        }
        if (criteria instanceof Map) {
            Map critData = (Map)criteria;
            return CONSTRUCTOR_NAME.equals(critData.get("_constructor"));
        }
        return false;
    }

    public static AdvancedCriteria fromCollections(Object criteria) {
        return AdvancedCriteria.fromCollections(criteria, DefaultOperators.Equals.getID());
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator) {
        return AdvancedCriteria.fromCollections(criteria, operator, null);
    }

    public static AdvancedCriteria fromCollections(Object criteria, String operator, DSRequest req) {
        ArrayList l = null;
        if (criteria instanceof List) {
            l = (ArrayList)criteria;
        } else if (criteria instanceof Collection) {
            l = new ArrayList((Collection)criteria);
        }
        if (l != null) {
            if (l.size() == 0) {
                return null;
            }
            if (l.size() == 1) {
                return DataSource.parseAdvancedCriteria((Map)l.get(0));
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", l);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        if (criteria instanceof Map) {
            Map criteriaMap = (Map)criteria;
            String contsructor = (String)criteriaMap.get("_constructor");
            if (CONSTRUCTOR_NAME.equals(contsructor)) {
                return DataSource.parseAdvancedCriteria(criteriaMap);
            }
            ArrayList c = new ArrayList();
            BasicDataSource ds = null;
            if (req != null) {
                try {
                    ds = (BasicDataSource)req.getDataSource();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
            for (Object key : criteriaMap.keySet()) {
                HashMap<String, Object> critMap = new HashMap<String, Object>();
                HashMap<String, Object> innerCritMap = null;
                String overriddenOperator = null;
                Object value = criteriaMap.get(key);
                List valueList = null;
                if (value instanceof List) {
                    valueList = (List)value;
                    if (valueList.size() > 1) {
                        innerCritMap = new HashMap<String, Object>();
                        innerCritMap.put("operator", DefaultOperators.Or.getID());
                        ArrayList innerCritList = new ArrayList();
                        innerCritMap.put("criteria", innerCritList);
                        for (Object listValue : valueList) {
                            overriddenOperator = AdvancedCriteria.getOperator(key, ds, listValue, operator);
                            HashMap<String, Object> innerCriterion = new HashMap<String, Object>();
                            innerCriterion.put("operator", overriddenOperator);
                            innerCriterion.put("fieldName", key);
                            innerCriterion.put("value", listValue);
                            innerCritList.add(innerCriterion);
                        }
                        c.add(innerCritMap);
                        continue;
                    }
                    if (valueList.size() > 0) {
                        value = valueList.get(0);
                    } else {
                        log.warn("Encountered empty list as the value for key '" + key + "' in simple criteria.  Ignoring this criterion.");
                        continue;
                    }
                }
                overriddenOperator = AdvancedCriteria.getOperator(key, ds, value, operator);
                critMap.put("operator", overriddenOperator);
                critMap.put("fieldName", key);
                critMap.put("value", value);
                c.add(critMap);
            }
            HashMap<String, Object> advCritMap = new HashMap<String, Object>();
            advCritMap.put("_constructor", CONSTRUCTOR_NAME);
            if (operator != null && (DefaultOperators.Or.getID().equals(operator) || DefaultOperators.And.getID().equals(operator))) {
                advCritMap.put("operator", operator);
            } else {
                advCritMap.put("operator", DefaultOperators.And.getID());
            }
            advCritMap.put("criteria", c);
            return DataSource.parseAdvancedCriteria(advCritMap);
        }
        return null;
    }

    private static String getOperator(Object fieldName, BasicDataSource ds, Object value, String baseOperator) {
        if (ds != null) {
            DSField field = ds.getField((String)fieldName);
            if (field != null) {
                try {
                    String type = ds.getSimpleBaseType(field.getType());
                    if (!("text".equals(type) || ("integer".equals(type) || "float".equals(type)) && value instanceof String)) {
                        return DefaultOperators.Equals.getID();
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Exception converting criteria", e);
                }
            }
        } else {
            return DefaultOperators.Equals.getID();
        }
        return baseOperator;
    }

    public void addCriteria(Criterion criterion) {
        if (this.criteria == null) {
            this.criteria = new AndCriterion(criterion);
        } else if (this.criteria instanceof AndCriterion) {
            List<Criterion> listCriteria = ((AndCriterion)this.criteria).getCriteria();
            listCriteria.add(criterion);
        } else {
            AndCriterion c = new AndCriterion(criterion);
            List<Criterion> listCriteria = c.getCriteria();
            listCriteria.add(this.criteria);
            this.criteria = c;
        }
    }

    public void addCriteria(String field, OperatorBase operator, Object start, Object end) {
        if (!(operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID()))) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a start and end value such as \"between\" etc.");
        }
        this.addCriteria(new RangeCriterion(field, operator.getID(), (Comparable)start, (Comparable)end));
    }

    public void addCriteria(String field, OperatorBase operator, Object value) {
        if (operator.getID().equals(DefaultOperators.Between.getID()) || operator.getID().equals(DefaultOperators.BetweenInclusive.getID()) || operator.getID().equals(DefaultOperators.IBetween.getID()) || operator.getID().equals(DefaultOperators.IBetweenInclusive.getID())) {
            throw new IllegalArgumentException("The passed operator may only be of the type that takes a singular value such as \"and\" etc. ");
        }
        this.addCriteria(new SimpleCriterion(field, operator, value));
    }

    public Criterion asCriterion() {
        return this.criteria;
    }

    public String toString() {
        return "AdvancedCriteria:[" + this.criteria + "]";
    }
}

