/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import java.util.Map;

public class Repo
extends Base {
    private Logger log = new Logger(Repo.class.getName());
    private DataSource dataSource;
    private String objectField = "object";
    private String objectFormat = "xml";

    public Repo(DataSource dataSource) {
        this(dataSource, "object", "xml");
    }

    public Repo(DataSource dataSource, String objectField, String objectFormat) {
        this.dataSource = dataSource;
        this.objectField = objectField;
        this.objectFormat = objectFormat;
    }

    public Repo setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Repo setObjectField(String obejctField) {
        this.objectField = this.objectField;
        return this;
    }

    public String getObjectField() {
        return this.objectField;
    }

    public Repo setObjectFormat(String obejctFormat) {
        this.objectFormat = this.objectFormat;
        return this;
    }

    public String getObjectFormat() {
        return this.objectFormat;
    }

    public Object loadObject(Map criteria) throws Exception {
        Map row = this.dataSource.fetchSingle(criteria);
        Object o = row.get(this.objectField);
        return o;
    }
}

