/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class BaseFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ServletContext servletContext;
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        Init.go(filterConfig.getServletContext(), true);
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String filterName = filterConfig.getFilterName();
        String className = this.getClass().getName();
        String logPrefix = null;
        if (!className.endsWith(filterName)) {
            logPrefix = filterName;
        }
        this.log = new Logger(this.getClass().getName(), logPrefix);
        ServletTools.applyConfigToServletOrFilter(this, filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        throw new ServletException("BaseFilter is not for direct use.");
    }

    public void destroy() {
    }
}

