/*
 Isomorphic SmartClient web presentation layer
 Online documentation data
 Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
*/


var docItems = {
    "method:Layout.getMember":{
        ref:"method:Layout.getMember",
        flags:"",
        description:" Given a numerical index or a member name or member ID, return a pointer to the appropriate member.\n <p>\n If passed a member Canvas, just returns it.\n\n",
        name:"getMember",
        seeAlso:[
            {
                ref:"method:Layout.getMemberNumber",
                description:null
            }
        ],
        params:[
            {
                description:"identifier for the required member",
                optional:false,
                name:"memberID",
                defaultValue:null,
                type:"String | int | Canvas"
            }
        ],
        returns:{
            description:"member widget",
            type:"Canvas"
        },
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:ComboBoxItem.pickListProperties":{
        ref:"attr:ComboBoxItem.pickListProperties",
        flags:"IRA",
        description:"If specified this properties block will be applied to the ${isc.DocUtils.linkForRef('class:PickListMenu','pickList')}\n created for this FormItem.\n <P>\n <i>Note</i>: Not every ListGrid property is supported when assigned to a pickList.\n Where there is a dedicated API on the form item (such as ${isc.DocUtils.linkForRef('attr:PickList.pickListCellHeight','pickListCellHeight')}),\n we recommend that be used in favor of setting the equivalent property on the \n <code>pickListProperties</code> block. Also note that while setting\n ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is a valid way to create a filterable pickList,\n this setting is not supported on a SelectItem with ${isc.DocUtils.linkForRef('attr:SelectItem.multiple')} set to\n true - this combination of settings can cause a selected value to be filtered out of\n view at which point further selection changes will discard that value. In general\n we recommend the ComboBoxItem class (with ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} set\n as appropriate) as a better interface for filtering pickList data.",
        name:"pickListProperties",
        seeAlso:[
        ],
        valueType:"ListGrid Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:TabSet.useSimpleTabs":{
        ref:"attr:TabSet.useSimpleTabs",
        flags:"IRA",
        description:"Should we use simple button based tabs styled with CSS rather than\n image based ${isc.DocUtils.linkForRef('class:ImgTab')} tabs?\n <P>\n <smartclient>\n If set to true the ${isc.DocUtils.linkForRef('attr:TabSet.simpleTabButtonConstructor')} will be used and tabs will\n by styled according to ${isc.DocUtils.linkForRef('attr:TabSet.simpleTabBaseStyle')}.\n </smartclient>\n <smartgwt>\n If set to true tabs will instances of ${isc.DocUtils.linkForRef('class:Button')}, styled according to the\n ${isc.DocUtils.linkForRef('attr:TabSet.simpleTabBaseStyle')}.\n </smartgwt>",
        name:"useSimpleTabs",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "attr:MiniDateRangeItem.autoValidate":{
        ref:"attr:MiniDateRangeItem.autoValidate",
        flags:"IRW",
        description:"If this attribute is set to true, the pop up date range dialog will automatically\n validate the user-entered <i>\"to\"</i> and <i>\"from\"</i> values on \n <code>\"OK\"</code>-click, and refuse to dismiss if these items contain invalid values.",
        name:"autoValidate",
        setter:[
            "setAutoValidate"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:MiniDateRangeItem"
    },
    "method:UploadItem.setValue":{
        ref:"method:UploadItem.setValue",
        flags:"",
        description:" Attempting to set the value for an upload form item is disallowed for security reasons.\n Therefore this method will just log a warning, and not modify the value of the item.\n",
        name:"setValue",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:UploadItem"
    },
    "attr:TileLayout.expandMargins":{
        ref:"attr:TileLayout.expandMargins",
        flags:"IR",
        description:"With ${isc.DocUtils.linkForRef('type:LayoutPolicy')}:\"fit\", should margins be expanded so that tiles fill the\n available space in the TileLayout on the breadth axis?\n This can also affect ${isc.DocUtils.linkForRef('attr:TileLayout.tileWidth')} or ${isc.DocUtils.linkForRef('attr:TileLayout.tileHeight')}. See those properties for details.",
        name:"expandMargins",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "layoutMargin"
        ]
    },
    "method:DrawItem.dragMove":{
        ref:"method:DrawItem.dragMove",
        flags:"",
        description:" Notification fired for every mouseMove event triggered while the user is dragging this\n DrawItem.  Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')} is true.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        name:"dragMove",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to cancel drag interaction.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragPan')}"
        ],
        definingClass:"class:DrawItem",
        groups:[
            "widgetEvents"
        ]
    },
    "type:LineCap":{
        ref:"type:LineCap",
        values:[
            {
                description:"Semicircular rounding",
                value:"\"round\""
            },
            {
                description:"Squared-off endpoint",
                value:"\"square\""
            },
            {
                description:"Square endpoint, stops exactly at the line's end coordinates instead                   of extending 1/2 lineWidth further as \"round\" and \"square\" do",
                value:"\"butt\""
            }
        ],
        description:"Supported styles of drawing the endpoints of a line",
        name:"LineCap",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "line"
        ]
    },
    "attr:FormItem.startRow":{
        ref:"attr:FormItem.startRow",
        flags:"IRW",
        description:"Whether this item should always start a new row in the form layout.",
        name:"startRow",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formLayout"
        ]
    },
    "attr:MultiSortDialog.title":{
        ref:"attr:MultiSortDialog.title",
        flags:"IR",
        description:"The title-text to appear in this Dialog's Header-bar.",
        name:"title",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Sort\"",
        type:"attr",
        definingClass:"class:MultiSortDialog",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:IMenuButton.menuButtonImageUp":{
        ref:"attr:IMenuButton.menuButtonImageUp",
        flags:"IRA",
        description:"Image for menu button indicating that the button expands a menu.  This image is shown\n for menus expanding up from the button.   Menu direction is controlled by\n ${isc.DocUtils.linkForRef('attr:MenuButton.showMenuBelow')}.",
        name:"menuButtonImageUp",
        seeAlso:[
            {
                ref:"attr:MenuButton.menuButtonImage",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]menu_button_up.gif\"",
        type:"attr",
        definingClass:"class:IMenuButton"
    },
    "method:ListGrid.sortChanged":{
        ref:"method:ListGrid.sortChanged",
        flags:"",
        description:" Notification method executed when the ${isc.DocUtils.linkForRef('method:ListGrid.setSort','sort specifiers')} change\n for this grid.\n",
        name:"sortChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"new sort specifiers - may be empty indicating   the grid was unsorted",
                optional:false,
                name:"sortSpecifiers",
                defaultValue:null,
                type:"Array of SortSpecifier"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "classAttr:Validator.mustBeLongerThan":{
        ref:"classAttr:Validator.mustBeLongerThan",
        flags:"IRA",
        description:"Default error message to display when standard <code>lengthRange</code> type validator\n returns false because the value passed in has fewer than <code>validator.min</code> characters.\n This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"mustBeLongerThan",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Must be at least ${min} characters\"",
        type:"classAttr",
        definingClass:"class:Validator",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:HiliteRule.clause":{
        ref:"attr:HiliteRule.clause",
        flags:"IR",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:FilterClause')} displaying the ${isc.DocUtils.linkForRef('class:FormItem','formItems')} used to \n specify the criteria for this HiliteRule.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>hiliteRule.clauseProperties</code>.",
        name:"clause",
        seeAlso:[
        ],
        valueType:"AutoChild FilterClause",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:HiliteRule"
    },
    "attr:ResultTree.resultSize":{
        ref:"attr:ResultTree.resultSize",
        flags:"IRA",
        description:"How many tree nodes to retrieve at once from each large set of children in the tree.\n <P>\n Applicable only with <code>fetchMode: \"paged\"</code>.  When a paged ResultTree is asked\n for rows that have not yet been loaded, it will fetch adjacent rows that are likely to\n be required soon, in batches of this size.",
        name:"resultSize",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"75",
        type:"attr",
        definingClass:"class:ResultTree",
        groups:[
            "treeDataBinding"
        ]
    },
    "attr:FilterClause.removeButtonPrompt":{
        ref:"attr:FilterClause.removeButtonPrompt",
        flags:"IR",
        description:"The hover prompt text for the remove button.",
        name:"removeButtonPrompt",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Remove\"",
        type:"attr",
        definingClass:"class:FilterClause",
        groups:[
            "i18nMessages"
        ]
    },
    "classMethod:Browser.setIsTouch":{
        ref:"classMethod:Browser.setIsTouch",
        flags:"A",
        description:" Setter for ${isc.DocUtils.linkForRef('classAttr:Browser.isTouch')} to allow this global variable to be changed at runtime.\n This advanced method is provided to override SmartClient's auto-detection logic, since the\n framework can only detect touch devices that existed at the time the platform was released.\n Any change to ${isc.DocUtils.linkForRef('classAttr:Browser.isTouch')} must be made before any component is created.\n <p>\n Note that setting <code>Browser.isTouch</code> might affect the values of\n ${isc.DocUtils.linkForRef('classAttr:Browser.isDesktop')}, ${isc.DocUtils.linkForRef('classAttr:Browser.isTablet')}, and/or ${isc.DocUtils.linkForRef('classAttr:Browser.isHandset')}.\n\n",
        name:"setIsTouch",
        seeAlso:[
        ],
        params:[
            {
                description:"new setting for <code>Browser.isTablet</code>.",
                optional:false,
                name:"isTouch",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"classMethod",
        definingClass:"class:Browser"
    },
    "attr:TimeItem.millisecondValues":{
        ref:"attr:TimeItem.millisecondValues",
        flags:"IRW",
        getter:[
            "getMillisecondValues"
        ],
        description:"An array of values to make available in the \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem','millisecond picker')} when\n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.\n <P>Used for specifying a limited set of valid Millisecond values, or when using the \n TimeItem to record duration, rather than time per-se.\n <P> See ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMinValue','millisecondMinValue')}, \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondMaxValue','millisecondMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondIncrement','millisecondIncrement')} for another method of \n controlling the content in the millisecond picker.",
        name:"millisecondValues",
        setter:[
            "setMillisecondValues"
        ],
        seeAlso:[
        ],
        valueType:"Array of Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "attr:TileGrid.dataFetchMode":{
        ref:"attr:TileGrid.dataFetchMode",
        flags:"IRW",
        description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",
        name:"dataFetchMode",
        seeAlso:[
        ],
        valueType:"FetchMode",
        defaultValue:"\"paged\"",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:[
            "databinding"
        ]
    },
    "method:Dialog.setToolbarButtons":{
        ref:"method:Dialog.setToolbarButtons",
        flags:"",
        description:" Set the ${isc.DocUtils.linkForRef('attr:Dialog.toolbarButtons')} for this dialog.\n Synonym for ${isc.DocUtils.linkForRef('method:Dialog.setButtons')}.\n",
        name:"setToolbarButtons",
        seeAlso:[
        ],
        params:[
            {
                description:"buttons for the toolbar",
                optional:false,
                name:"newButtons",
                defaultValue:"null",
                type:"array of Buttons"
            }
        ],
        type:"method",
        definingClass:"class:Dialog"
    },
    "attr:FacetChart.showDataPoints":{
        ref:"attr:FacetChart.showDataPoints",
        flags:"IR",
        description:"For line charts, whether to show data points for each individual data value.\n <P>\n If shown, the ${isc.DocUtils.linkForRef('method:FacetChart.pointClick')} and ${isc.DocUtils.linkForRef('method:FacetChart.getPointHoverHTML')} APIs can be used to create\n interactivity.",
        name:"showDataPoints",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:Hilite.title":{
        ref:"attr:Hilite.title",
        flags:"IRW",
        description:"User-visible title for this hilite.  Used for interfaces such as menus that can enable or\n disable hilites.",
        name:"title",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Hilite",
        groups:[
            "hiliting"
        ]
    },
    "method:DynamicForm.setError":{
        ref:"method:DynamicForm.setError",
        deprecated:"This method has been deprecated as of SmartClient release 5.7.  Use ${isc.DocUtils.linkForRef('method:DynamicForm.addFieldErrors')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setFieldErrors')} instead",
        flags:"A",
        description:"          Sets error message(s) for the specified itemName to the error string or array of\n          strings. You must call form.markForRedraw() to display the new error message(s).<br>\n          <b>Note:</b> you can call this multiple times for an individual itemName\n\t\t\t which will result in an array of errors being remembered.\n\n",
        name:"setError",
        seeAlso:[
        ],
        params:[
            {
                description:"name of the item to set",
                optional:false,
                name:"itemName",
                defaultValue:null,
                type:"string"
            },
            {
                description:"error message string or array of strings",
                optional:false,
                name:"errorMessage",
                defaultValue:null,
                type:"string|array"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "errors"
        ]
    },
    "method:DrawPath.getCenter":{
        ref:"method:DrawPath.getCenter",
        flags:"",
        description:" Get the mean center of the path.\n",
        name:"getCenter",
        seeAlso:[
        ],
        returns:{
            description:"the mean center",
            type:"Point"
        },
        type:"method",
        definingClass:"class:DrawPath"
    },
    "attr:AdvancedHiliteEditor.saveButton":{
        ref:"attr:AdvancedHiliteEditor.saveButton",
        flags:"IR",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:ImgButton')} that accepts this Hilite and fires the \n ${isc.DocUtils.linkForRef('attr:AdvancedHiliteEditor.callback','callback')}.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>advancedHiliteEditor.saveButtonProperties</code>.",
        name:"saveButton",
        seeAlso:[
        ],
        valueType:"AutoChild StatefulCanvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:AdvancedHiliteEditor"
    },
    "attr:DynamicForm.canEdit":{
        ref:"attr:DynamicForm.canEdit",
        flags:"IRWA",
        description:"If set to <code>false</code>, the form will be marked read-only. A widget on the form\n is editable if either (1) beginning with the widget and continuing up the containment\n hierarchy, including the form, the first widget to have a non-null <code>canEdit</code>\n attribute has canEdit:true, or (2) neither the widget nor any parent has a non-null\n <code>canEdit</code> attribute. This setting allows you to enable or disable the default\n editability of the form's items at one time.\n <p>\n This setting differs from the enabled/disabled state in that most form items will\n allow copying of the contents while read-only but do not while disabled.\n <p>\n Note that a form is considered editable if <code>canEdit</code> is null (default) or\n <code>true</code>.",
        name:"canEdit",
        setter:[
            "setCanEdit"
        ],
        seeAlso:[
            {
                ref:"attr:DynamicForm.readOnlyDisplay",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "readOnly"
        ]
    },
    "attr:TreeGrid.showRoot":{
        ref:"attr:TreeGrid.showRoot",
        flags:"IR",
        description:"Specifies whether the root node should be displayed in the treeGrid.\n <P>\n This property is only available for \"children\" modelType trees, hence is not allowed for\n trees that load data from the server dynamically via ${isc.DocUtils.linkForRef('method:TreeGrid.fetchData')}.  \n <P>\n To get the equivalent of a visible \"root\" node in a tree that loads data dynamically,\n add a singular, top-level parent to the data.  However, note that this top-level parent\n will technically be the only child of root, and the implicit root object will be\n returned by ${isc.DocUtils.linkForRef('method:Tree.getRoot','this.data.getRoot()')}.",
        name:"showRoot",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeField"
        ]
    },
    "attr:ComboBoxItem.showAllOptions":{
        ref:"attr:ComboBoxItem.showAllOptions",
        flags:"IR",
        description:"If true, even non-matching options will be shown, with configurable \n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.separatorRows','separator rows')} in between.  Not valid for\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.optionDataSource','databound pickLists')}.",
        name:"showAllOptions",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:FacetChart.logScale":{
        ref:"attr:FacetChart.logScale",
        flags:"IR",
        description:"Whether to use logarithmic scaling for values.\n <P>\n Logarithmic scale charts show an equivalent percentage increase as equivalent distance\n on the chart.  That is, 10 and 100 are the same distance apart as 100 and 1000 (each\n being a 10 times or 1000% increase).",
        name:"logScale",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "method:FilterBuilder.getCriteria":{
        ref:"method:FilterBuilder.getCriteria",
        flags:"",
        description:" Get the criteria entered by the user.\n \n",
        name:"getCriteria",
        seeAlso:[
        ],
        params:[
            {
                description:"By default if a user has selected a field and operator   type, but has failed to enter a value for the field it will be skipped. This optional parameter\n   allows you to retrieve all criteria, including those with an empty <code>value</code> attribute.",
                optional:true,
                name:"includeEmptyValues",
                defaultValue:null,
                type:"boolean"
            }
        ],
        returns:{
            description:null,
            type:"AdvancedCriteria"
        },
        type:"method",
        definingClass:"class:FilterBuilder"
    },
    "attr:ListGrid.includeInSummaryProperty":{
        ref:"attr:ListGrid.includeInSummaryProperty",
        flags:"IRW",
        description:"Property name on a record that will be checked to determine whether a record should\n be included when calculating totals for the ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary','grid summary')}.",
        name:"includeInSummaryProperty",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"includeInSummary\"",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "group:menuBasic":{
        ref:"group:menuBasic",
        refs:[
            "method:MenuItem.action",
            "attr:MenuItem.title",
            "attr:MenuItem.submenu",
            "attr:MenuItem.isSeparator",
            "attr:MenuItem.enabled"
        ],
        name:"menuBasic",
        seeAlso:[
        ],
        type:"group"
    },
    "classMethod:Date.setShortDatetimeDisplayFormat":{
        ref:"classMethod:Date.setShortDatetimeDisplayFormat",
        flags:"",
        description:"  Set the default short format for datetime values. After calling this method, subsequent calls to\n ${isc.DocUtils.linkForRef('method:Date.toShortDateTime')} will return a string formatted according to this format\n specification. Note that this will be the standard datetime format used by\n SmartClient components.\n <P>\n The <code>format</code> parameter may be a ${isc.DocUtils.linkForRef('type:FormatString')}, a ${isc.DocUtils.linkForRef('type:DateDisplayFormat')} \n string, or a function. If passed a function, this function will be executed in the scope of\n the Date and should return the formatted string.<br>\n <P>\n Initial default format is <code>\"toUSShortDatetime\"</code>.  See\n <a href='http://en.wikipedia.org/wiki/Date_format_by_country' target='_blank'>http://en.wikipedia.org/wiki/Date_format_by_country</a>\n for a useful overview of standard date formats per country.\n\n",
        name:"setShortDatetimeDisplayFormat",
        seeAlso:[
        ],
        params:[
            {
                description:"new formatter",
                optional:false,
                name:"format",
                defaultValue:null,
                type:"FormatString | DateDisplayFormat | function"
            }
        ],
        type:"classMethod",
        examples:[
            "${isc.DocUtils.linkForExampleId('dateFormat')}",
            "${isc.DocUtils.linkForExampleId('customDateFormat')}"
        ],
        definingClass:"class:Date",
        groups:[
            "dateFormatting"
        ]
    },
    "attr:Calendar.mainView":{
        ref:"attr:Calendar.mainView",
        flags:"R",
        description:"${isc.DocUtils.linkForRef('class:TabSet')} for managing calendar views when multiple views are available (eg,\n ${isc.DocUtils.linkForRef('attr:Calendar.dayView','day')} and ${isc.DocUtils.linkForRef('attr:Calendar.monthView','month')}).",
        name:"mainView",
        seeAlso:[
        ],
        valueType:"AutoChild TabSet",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "method:CubeGrid.expandField":{
        ref:"method:CubeGrid.expandField",
        flags:"facetValueMap",
        description:" Expands the specified field.  No-ops if it's not showing, or if it's already expanded.\n",
        name:"expandField",
        seeAlso:[
        ],
        params:[
            {
                description:"field specified as a facetValueMap",
                optional:false,
                name:"facetValueMap",
                defaultValue:null,
                type:"FacetValueMap"
            }
        ],
        returns:{
            description:"whether specified field was actually expanded",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:DateChooser.todayButton":{
        ref:"attr:DateChooser.todayButton",
        flags:"IR",
        description:"A button shown below the ${isc.DocUtils.linkForRef('class:DateGrid','calendar grid')} which, when clicked, \n navigates the calendar to today.",
        name:"todayButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:PickList.filterLocally":{
        ref:"attr:PickList.filterLocally",
        flags:"IRA",
        description:"If <code>filterLocally</code> is set for this item, and this item is showing options \n from a dataSource, fetch the entire set of options from the server, and use these values\n to map the item value to the appropriate display value. Also use <code>\"local\"</code>\n type filtering on drop down list of options.\n <P>\n This means data will only be fetched once from the server, and then filtered on the\n client.\n <P>\n Note - when this property is set to <code>false</code>, filtering will still be \n performed on the client if a complete set of data for some criteria has been cached\n by a fetch, and a subsequent fetch has more restrictive criteria. To explicitly\n disable client-side filtering set the ${isc.DocUtils.linkForRef('attr:PickList.useClientFiltering')} property to false.",
        name:"filterLocally",
        seeAlso:[
            {
                ref:"attr:FormItem.filterLocally",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "attr:RPCRequest.useXmlHttpRequest":{
        ref:"attr:RPCRequest.useXmlHttpRequest",
        deprecated:"As of SmartClient 5.5, use ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.  If you specify a value for this property, it will take precedence over ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.",
        flags:"IRWA",
        description:"Selects the default http transport for this RPCRequest.  If set to true, this request will use\n XMLHttpRequest for the transport to the server.  If set to false it will use a hidden frame.  If\n left unset, the transport mechanism is determined from the RPCManager default set in \n ${isc.DocUtils.linkForRef('classAttr:RPCManager.useXmlHttpRequest')}\n <p>\n If you're using queueing, note that all requests in the queue must use the same transport.\n If you attempt to send a request via a different transport than those that are currently on\n the queue, it will be sent to the server separately, ahead of the queue, and a warning will\n be logged to the Developer Console.\n <p>\n If you specify <code>true</code> for this attribute and XMLHttp is not available, a warning\n will be logged to the Developer Console and RPCManager will attempt to use the frames\n transport for this request.  Note that some features like\n ${isc.DocUtils.linkForRef('attr:RPCRequest.serverOutputAsString')} require the XMLHttp transport and will not work if the\n XMLHttp transport is unavailable (this can happen if the end user is using Internet Explorer\n and has disabled ActiveX).  You can query the availability of XMLHttp by calling\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.xmlHttpRequestAvailable')}",
        name:"useXmlHttpRequest",
        seeAlso:[
            {
                ref:"classAttr:RPCManager.useXmlHttpRequest",
                description:null
            },
            {
                ref:"classMethod:RPCManager.xmlHttpRequestAvailable",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"RPCManager.useXmlHttpRequest",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "method:ListGrid.canSelectCell":{
        ref:"method:ListGrid.canSelectCell",
        flags:"A",
        description:" If ${isc.DocUtils.linkForRef('attr:ListGrid.canSelectCells')} is set to <code>true</code> then, whenever an end-user or\n programmatic cell-selection is attempted, this method is called for \n each cell in the selection. If it returns false, the cell will not be selected.\n\n",
        name:"canSelectCell",
        seeAlso:[
        ],
        params:[
            {
                description:"rowNum being selected",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"int"
            },
            {
                description:"colNum being selected",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"int"
            }
        ],
        returns:{
            description:"return false to disallow selection",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:Mail.templateFile":{
        ref:"attr:Mail.templateFile",
        flags:"IR",
        description:"Qualified name of the file containing the message template, relative to webroot.  Like all\n the other <code>String</code> properties of <code>Mail</code>, you can use Velocity\n substitution variables in this property.  The content itself (ie, the contents of the file\n named in this property) can also contain Velocity substitutions, of course.\n <p>\n You must specify either this property or ${isc.DocUtils.linkForRef('attr:Mail.messageTemplate','messageTemplate')}, but\n clearly it makes no sense to specify them both.",
        name:"templateFile",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:Mail",
        groups:[
            "mail"
        ]
    },
    "attr:DrawItem.linePattern":{
        ref:"attr:DrawItem.linePattern",
        flags:"IRW",
        description:"Pattern for lines, eg \"solid\" or \"dash\".\n <P>\n Note that support in old browsers, such as Internet Explorer versions before IE11, is\n limited for ${isc.DocUtils.linkForRef('drawPane.drawingType','drawingType')} \"bitmap\" to items with straight\n edges - ${isc.DocUtils.linkForRef('class:DrawLine')}s, ${isc.DocUtils.linkForRef('class:DrawPath')}s, and ${isc.DocUtils.linkForRef('class:DrawRect')}s with no \n ${isc.DocUtils.linkForRef('attr:DrawRect.rounding','rounding')}.",
        name:"linePattern",
        setter:[
            "setLinePattern"
        ],
        seeAlso:[
        ],
        valueType:"LinePattern",
        defaultValue:"\"solid\"",
        type:"attr",
        definingClass:"class:DrawItem",
        groups:[
            "line"
        ]
    },
    "attr:ListGridField.suppressValueIcon":{
        ref:"attr:ListGridField.suppressValueIcon",
        flags:"IRW",
        description:"If this field has a valueIcons property specified, setting this property to true will\n prevent the valueIcon being written out into this field's cells.\n <P>\n Note this property may also be set to false to avoid showing the standard\n ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')} for fields of type\n <code>boolean</code>.",
        name:"suppressValueIcon",
        seeAlso:[
            {
                ref:"attr:ListGridField.valueIcons",
                description:null
            },
            {
                ref:"attr:ListGridField.showValueIconOnly",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ]
    },
    "method:DatabaseBrowser.getResults":{
        ref:"method:DatabaseBrowser.getResults",
        flags:"",
        description:" \n",
        name:"getResults",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DatabaseBrowser"
    },
    "type:ListGridComponent":{
        ref:"type:ListGridComponent",
        values:[
            {
                description:"The standard filter-component displayed when ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')}   is true",
                value:"\"filterEditor\""
            },
            {
                description:"The header-component displayed when ${isc.DocUtils.linkForRef('attr:ListGrid.showHeader')} is true.",
                value:"\"header\""
            },
            {
                description:"The body component for the grid.",
                value:"\"body\""
            },
            {
                description:"The summary-row component displayed when ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} is   true.",
                value:"\"summaryRow\""
            }
        ],
        description:"Standard component-type displayed within a ListGrid, as contained by ${isc.DocUtils.linkForRef('attr:ListGrid.gridComponents')}.",
        name:"ListGridComponent",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "appearance"
        ]
    },
    "method:DataBoundComponent.find":{
        ref:"method:DataBoundComponent.find",
        flags:"",
        description:" This API is equivalent to ${isc.DocUtils.linkForRef('method:List.find')} but searches for a matching record among already-loaded data only.  \n Use ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData')} to load data from the server.\n",
        name:"find",
        seeAlso:[
        ],
        params:[
            {
                description:"AdvancedCriteria to use with",
                optional:false,
                name:"advancedCriteria",
                defaultValue:null,
                type:"AdvancedCriteria"
            }
        ],
        returns:{
            description:"first matching object or null if not found",
            type:"Object"
        },
        type:"method",
        definingClass:"interface:DataBoundComponent"
    },
    "attr:TabSet.moreTabProperties":{
        ref:"attr:TabSet.moreTabProperties",
        flags:"IR",
        description:"Properties to apply to the \"more\" tab created by this TabSet.",
        name:"moreTabProperties",
        seeAlso:[
        ],
        valueType:"Tab Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "method:Tree.getAllNodes":{
        ref:"method:Tree.getAllNodes",
        flags:"",
        description:" Get all the nodes that exist in the tree under a particular node, as a flat list, in\n depth-first traversal order.\n\n",
        name:"getAllNodes",
        seeAlso:[
        ],
        params:[
            {
                description:"soptional node to start from.  Default is root.",
                optional:true,
                name:"node",
                defaultValue:null,
                type:null
            }
        ],
        returns:{
            description:"all the nodes that exist in the tree",
            type:"Array of TreeNode"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "classMethod:Page.getScreenWidth":{
        ref:"classMethod:Page.getScreenWidth",
        flags:"",
        description:"\t\tGet the width of the user's screen, in pixels.\n",
        name:"getScreenWidth",
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:Page"
    },
    "attr:Scrollbar.skinImgDir":{
        ref:"attr:Scrollbar.skinImgDir",
        flags:"IRA",
        description:"Where are the skin images for the Scrollbar.  This is local to the ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','overall skin directory')}.",
        name:"skinImgDir",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"\"images/Scrollbar/\"",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "images"
        ]
    },
    "method:ColorPicker.setSaturation":{
        ref:"method:ColorPicker.setSaturation",
        flags:"",
        description:" Sets the Saturation of the selected color\n",
        name:"setSaturation",
        seeAlso:[
            {
                ref:"method:ColorPicker.getSaturation",
                description:null
            }
        ],
        params:[
            {
                description:"An integer between 0 and 240",
                optional:false,
                name:"newValue",
                defaultValue:null,
                type:"Number"
            }
        ],
        type:"method",
        definingClass:"class:ColorPicker"
    },
    "attr:AnimateShowEffect.startFrom":{
        ref:"attr:AnimateShowEffect.startFrom",
        flags:"IR",
        description:"For show animations of type <code>\"wipe\"</code> and\n   <code>\"slide\"</code> this attribute specifies where the wipe / slide should originate.\n   Valid values are <code>\"T\"</code> (vertical animation from the top down, the \n   default behavior), and <code>\"L\"</code> (horizontal animation from the left side).",
        name:"startFrom",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:AnimateShowEffect"
    },
    "attr:Point.x":{
        ref:"attr:Point.x",
        flags:"IR",
        description:"The x coordinate of this point.",
        name:"x",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0",
        type:"attr",
        definingClass:"object:Point"
    },
    "attr:Point.y":{
        ref:"attr:Point.y",
        flags:"IR",
        description:"The y coordinate of this point.",
        name:"y",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0",
        type:"attr",
        definingClass:"object:Point"
    },
    "method:CanvasItem.getCriterion":{
        ref:"method:CanvasItem.getCriterion",
        flags:"",
        description:" The standard formItem criteria editing APIs have been overridden in the canvasItem class\n to simplify the editing of complex ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} objects using nested \n DynamicForms.\n <P>\n The following pattern is supported without need for further modification:<br>\n A complex Advanced criteria object may have nested sub criteria using the <code>\"and\"</code>\n or <code>\"or\"</code> operators. For example:\n <pre>\n { _constructor:\"AdvancedCriteria\",\n   operator:\"and\",\n   criteria:[\n      {fieldName:\"field1\", value:\"value1\", operator:\"iContains\"},\n      {operator:\"or\", criteria:[\n          {fieldName:\"innerField1\", value:\"value1\", operator:\"equals\"},\n          {fieldName:\"innerField2\", value:\"value2\", operator:\"iContains\"}\n       ]\n      }\n   ]\n }\n </pre>\n To create a form capable of editing the above criteria without providing custom overrides\n to ${isc.DocUtils.linkForRef('method:FormItem.getCriterion')} et al, you would create a form with 2 items.\n The 'field1' criterion could be edited by a simple form item such as a TextItem.\n The nested criteria ('innerField1' and 'innerField2') could be edited by a canvasItem\n whose canvas property was set to a DynamicForm showing items capable of editing the 2\n inner criteria, and whose operator was specified as \"or\".<br>\n For example:\n <pre>\n  isc.DynamicForm.create({\n      items:[\n          {name:\"field1\", type:\"TextItem\"},\n          {name:\"nestedItem\", shouldSaveValue:true, type:\"CanvasItem\",\n              canvas:isc.DynamicForm.create({\n                  operator:\"or\",\n                  items:[\n                      {name:\"innerField1\", type:\"TextItem\", operator:\"equals\"},\n                      {name:\"innerField2\", type:\"TextItem\"}\n                  ]\n              })\n          }\n      ]\n  });\n  </pre>\n This form would be able to edit the above advanced criteria object via\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValuesAsCriteria')}. Edited values would be retrieved via\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}.\n <P>\n Note that the canvas item has <code>shouldSaveValue</code> set to true - this is required\n to ensure the nested form is actually passed the values to edit. \n <P>\n The default implementation of this method checks for this.canvas being specified as a\n dynamicForm, and in that case simply returns the result of \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsAdvancedCriteria')} on the inner form.\n <P>\n Note that this functionality may be entirely bypassed by\n setting ${isc.DocUtils.linkForRef('attr:CanvasItem.editCriteriaInInnerForm')} to false. This flag is useful when defining a\n dynamicForm based canvasItem which is not intended for editing nested data -- for example\n if a standard atomic field value is being displayed in some custom way using a\n DynamicForm embedded in the item.\n \n",
        name:"getCriterion",
        seeAlso:[
        ],
        returns:{
            description:"criterion to merge with advanced criteria returned by   ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')}",
            type:"Criterion"
        },
        type:"method",
        definingClass:"class:CanvasItem",
        groups:[
            "criteriaEditing"
        ]
    },
    "method:Tree.getParent":{
        ref:"method:Tree.getParent",
        flags:"",
        description:"\n Returns the parent of this node.\n\n",
        name:"getParent",
        seeAlso:[
        ],
        params:[
            {
                description:"node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"parent of this node",
            type:"node"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "method:StatefulCanvas.setAutoFit":{
        ref:"method:StatefulCanvas.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[
        ],
        params:[
            {
                description:"New autoFit setting.",
                optional:false,
                name:"autoFit",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:StatefulCanvas"
    },
    "type:DrawShapeCommandType":{
        ref:"type:DrawShapeCommandType",
        values:[
            {
                description:"Draws a straight line from the current point to the last \"moveto\" point. There are no arguments.",
                value:"\"close\""
            },
            {
                description:"Start a new sub-path at a given (x,y) coordinate. The args array for this command type is a two-element array of the X and Y coordinates.",
                value:"\"moveto\""
            },
            {
                description:"Draw a line from the current point to the given (x,y) coordinate which becomes the new current point. Multiple (x,y) coordinates may be specified to draw a path, in which\n case the last point becomes the new current point. The args array for this command type is\n an array of one or more Points (two-element arrays of the X and Y coordinates).",
                value:"\"lineto\""
            },
            {
                description:"Draw a segment of a specified circle. A straight line (the \"initial line segment\") is drawn from the current point to the start of the circular arc. The args array\n for this command type contains 4 values:\n <ol start=\"0\">\n <li>The center (cx,cy) Point (two-element array) of the circle.</li>\n <li>radius</li>\n <li>startAngle - Start angle in degrees</li>\n <li>endAngle - End angle in degrees</li>\n </ol>\n Note that the ${isc.DocUtils.linkForExampleId('circletoCommand', '\"circleto\" Command example')} can be very helpful\n when learning how to write \"circleto\" commands.",
                value:"\"circleto\""
            }
        ],
        description:null,
        name:"DrawShapeCommandType",
        seeAlso:[
        ],
        type:"type"
    },
    "method:Selection.deselectAll":{
        ref:"method:Selection.deselectAll",
        flags:"",
        description:"\t\t\tDeselect ALL records of the list\n",
        name:"deselectAll",
        seeAlso:[
        ],
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "attr:ListGrid.ungroupText":{
        ref:"attr:ListGrid.ungroupText",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.isGrouped','this.isGrouped')} is true, this\n attribute will be shown as the title for the menu item to ungroup the grid.",
        name:"ungroupText",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Ungroup\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages"
        ]
    },
    "group:shadow":{
        ref:"group:shadow",
        refs:[
            "method:Canvas.setShowShadow",
            "attr:Canvas.showShadow",
            "attr:Canvas.shadowDepth",
            "attr:Canvas.shadowOffset",
            "attr:Canvas.shadowSoftness",
            "attr:Canvas.shadowImage"
        ],
        name:"shadow",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:DynamicForm.suppressValidationErrorCallback":{
        ref:"attr:DynamicForm.suppressValidationErrorCallback",
        flags:"IRWA",
        description:"When calling ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} on a form or valuesManager, by default if the server\n returns an error code, any callback passed into saveData() will not be fired.\n If the error code returned by the server indicates a validation error, it will be\n displayed to the user by updating the form items to show the error messages, and firing\n any specified hiddenValidationErrors handler, otherwise the standard RPCManager\n error handling logic would be invoked.\n <P>\n Developers who want to handle errors themselves can override this default by specifying\n ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError','dsRequest.willHandleError')} on the DSRequest. In this case the callback passed in \n will be fired even if the server returns an error status code.\n <P>\n If <code>suppressValidationErrorCallback</code> is set to true, if a save attempt returns\n a <i>validation</i> error code, the user-specified callback will not be fired\n <i>even if <code>willHandleError:true</code> was specified on the dsRequest</i> \n - though for other error codes, the callback would be fired if willHandleError is \n specified on the request.\n Note that this is the historical behavior for\n <smartclient>SmartClient builds 8.0 and earlier</smartclient>\n <smartgwt>SmartGWT builds 4.0 and earlier</smartgwt>",
        name:"suppressValidationErrorCallback",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "classMethod:Log.logWarn":{
        ref:"classMethod:Log.logWarn",
        flags:"",
        description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.logWarn')} is to call the method directly on\n the Log class.\n",
        name:"logWarn",
        seeAlso:[
            {
                ref:"classMethod:Log.logDebug",
                description:"for usage info"
            }
        ],
        params:[
            {
                description:"message to log",
                optional:false,
                name:"message",
                defaultValue:null,
                type:"String"
            },
            {
                description:"category to log in",
                optional:true,
                name:"category",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:FormItem.valueHover":{
        ref:"method:FormItem.valueHover",
        flags:"A",
        description:" Optional stringMethod to fire when the user hovers over this item's value.\n Return false to suppress default behavior of showing a hover canvas containing the\n HTML returned by ${isc.DocUtils.linkForRef('method:FormItem.valueHoverHTML')} / ${isc.DocUtils.linkForRef('method:DynamicForm.valueHoverHTML')}.\n\n",
        name:"valueHover",
        seeAlso:[
            {
                ref:"method:FormItem.itemHover",
                description:null
            }
        ],
        params:[
            {
                description:"Pointer to this item",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            },
            {
                description:"This items form",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            }
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:[
            "Hovers"
        ]
    },
    "method:DrawPane.createSimpleGradient":{
        ref:"method:DrawPane.createSimpleGradient",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('method:DrawPane.addGradient')}",
        flags:"",
        description:" Creates a simple linear gradient which can be used by any DrawItem of this DrawPane.\n Any DrawItem's ${isc.DocUtils.linkForRef('attr:DrawItem.fillGradient','fillGradient')} can reference the gradient by the\n given ID.\n\n",
        name:"createSimpleGradient",
        seeAlso:[
        ],
        params:[
            {
                description:"the ID of the simple linear gradient",
                optional:false,
                name:"id",
                defaultValue:null,
                type:"identifier"
            },
            {
                description:"the simple linear gradient",
                optional:false,
                name:"simple",
                defaultValue:null,
                type:"SimpleGradient"
            }
        ],
        returns:{
            description:"id",
            type:"identifier"
        },
        type:"method",
        definingClass:"class:DrawPane"
    },
    "type:PromptStyle":{
        ref:"type:PromptStyle",
        values:[
            {
                description:"Displays a centered modal prompt with text specified by                 ${isc.DocUtils.linkForRef('attr:RPCRequest.prompt')}",
                value:"\"dialog\""
            },
            {
                description:"Changes the current cursor to the style specified by                 ${isc.DocUtils.linkForRef('attr:RPCRequest.promptCursor')}",
                value:"\"cursor\""
            }
        ],
        description:null,
        name:"PromptStyle",
        seeAlso:[
        ],
        type:"type"
    },
    "class:XJSONDataSource":{
        methods:[
        ],
        ref:"class:XJSONDataSource",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        attrs:[
        ],
        description:"A DataSource preconfigured to use the ${isc.DocUtils.linkForRef('type:RPCTransport','\"scriptInclude\"')} transport\n (sometimes called \"JSONP\") for cross-domain calls to JSON services.\n <P>\n To use this DataSource, provide the URL of the service as ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')}, and\n provide ${isc.DocUtils.linkForRef('attr:DataSource.fields','fields')} that describe the structure of the data you want to\n extract from the service's response.\n <P>\n ${isc.DocUtils.linkForRef('attr:DataSource.recordXPath')} and ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath')} can be used to extract\n data from the JSON structure returned by the service.  See\n ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-Side Data Integration')} for an overview of how to\n control what parts of the JSON structure are included in the ${isc.DocUtils.linkForRef('class:DSResponse')} object, and\n hence provided to ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}s that are bound to this DataSource.\n <P>\n This XJSONDataSource is really a subclass of DataSource with just a few property settings:\n <pre>\n    dataFormat : \"json\",\n    dataTransport : \"scriptInclude\"\n    callbackParam : \"callback\"\n </pre>\n <P>\n If you are also writing the server side code to respond to requests from this DataSource,\n see the \n <a href='http://developer.yahoo.net/common/json.html#callbackparam' target='_blank'>tutorial provided by Yahoo!</a> \n for a good overview of how this transport mechanism works.  Note, as indicated in the\n tutorial above, the server is responsible for writing out not just the data, but also a\n JavaScript function call that tells the client that the response has arrived.  The client\n passes the name of the function to call as the \"callback\" URL parameter.\n <P>\n NOTE: if you use this DataSource to contact Yahoo web services, remember to include\n output=json in the dataURL, as well as a\n <a href='http://developer.yahoo.net/' target='_blank'>Yahoo developer ID</a>.",
        name:"XJSONDataSource",
        seeAlso:[
        ],
        type:"class",
        examples:[
            "${isc.DocUtils.linkForExampleId('jsonYahooWebServices')}"
        ]
    },
    "method:DataSource.getTypeOperators":{
        ref:"method:DataSource.getTypeOperators",
        flags:"",
        description:" Get the list of ${isc.DocUtils.linkForRef('type:OperatorId')}s available on this DataSource for the given ${isc.DocUtils.linkForRef('type:FieldType')}.\n <P>\n If ${isc.DocUtils.linkForRef('method:DataSource.setTypeOperators')} has been called for this DataSource and FieldType, returns that\n list, otherwise, returns the set of valid operators for the ${isc.DocUtils.linkForRef('type:FieldType')} as specified by \n ${isc.DocUtils.linkForRef('attr:SimpleType.validOperators')}, otherwise, the system-wide set of valid operators for the\n type as registered via ${isc.DocUtils.linkForRef('classMethod:DataSource.addSearchOperator')}.\n \n",
        name:"getTypeOperators",
        seeAlso:[
        ],
        params:[
            {
                description:"Defaults to \"text\" if not passed.",
                optional:true,
                name:"typeName",
                defaultValue:null,
                type:"FieldType | String"
            }
        ],
        returns:{
            description:"available Operators",
            type:"Array of OperatorId"
        },
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "advancedFilter"
        ]
    },
    "classMethod:AutoTest.getLocator":{
        ref:"classMethod:AutoTest.getLocator",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('type:AutoTestLocator')} associated with some DOM element in a SmartClient\n application page.  If coords, representing the page position, is passed in, the locator\n may be generated with a specific trailing \"target area\" identifer that will map back to\n the appropriate, potentially different, physical coordinates, even if the widget is\n moved.  The coords argument will only have an effect in cases where the mouse position\n over the target could potentially change behavior.\n",
        name:"getLocator",
        seeAlso:[
        ],
        params:[
            {
                description:"DOM element within in the page. If null the locator for  the last mouse event target will be generated",
                optional:false,
                name:"DOMElement",
                defaultValue:null,
                type:"DOMElement"
            },
            {
                description:"If this parameter is passed in, check whether  the target element responds to native browser events directly rather than going through\n  the SmartClient widget/event handling model. If we detect this case, return null rather\n  than a live locator.  This allows us to differentiate between (for example) an event on\n  a Canvas handle, and an event occurring directly on a simple \n  <code>&lt;a href=...&gt;</code> tag written inside a Canvas handle.",
                optional:true,
                name:"checkForNativeHandling",
                defaultValue:null,
                type:"boolean"
            },
            {
                description:"X, Y page position",
                optional:true,
                name:"coords",
                defaultValue:null,
                type:"array"
            }
        ],
        returns:{
            description:"Locator string allowing the AutoTest subsystem to find   an equivalent DOM element on subsequent page loads.",
            type:"AutoTestLocator"
        },
        type:"classMethod",
        definingClass:"class:AutoTest",
        groups:[
            "autoTest"
        ]
    },
    "attr:TabSet.showPaneContainerEdges":{
        ref:"attr:TabSet.showPaneContainerEdges",
        flags:"IRWA",
        description:"Should the paneContainer for this tabset show ${isc.DocUtils.linkForRef('attr:Canvas.showEdges','edges')}.",
        name:"showPaneContainerEdges",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "method:List.first":{
        ref:"method:List.first",
        flags:"",
        description:" Return the first item in this list\n\n",
        name:"first",
        seeAlso:[
        ],
        returns:{
            description:"first item in the list",
            type:"any"
        },
        type:"method",
        definingClass:"interface:List",
        groups:[
            "access"
        ]
    },
    "method:ListGrid.shouldIncludeHiliteInSummaryField":{
        ref:"method:ListGrid.shouldIncludeHiliteInSummaryField",
        flags:"",
        description:" When assembling a value for a ${isc.DocUtils.linkForRef('attr:ListGrid.canAddSummaryFields','summary field')}, if a referenced\n field is hilited, should the hilite HTML be included in the summary field value?\n <P>\n Example use case: Consider a grid containing a numeric field, and a summary field\n which contains some string value, plus the contents of the numeric field.\n If a hilite is defined for the grid which turns the numeric field text red when\n the value is negative, this property will govern whether the number will also be\n rendered in red within the summary field cells. Any other text in the summary field\n cells would not be effected by this hilite.\n <P>\n Default implementation returns ${isc.DocUtils.linkForRef('attr:DataBoundComponent.includeHilitesInSummaryFields','includeHilitesInSummaryFields')}.\n <P>\n To control hilites showing in group summaries, see ${isc.DocUtils.linkForRef('attr:ListGrid.showHilitesInGroupSummary','showHilitesInGroupSummary')}.\n\n",
        name:"shouldIncludeHiliteInSummaryField",
        seeAlso:[
        ],
        params:[
            {
                description:"name of the summary field",
                optional:false,
                name:"summaryFieldName",
                defaultValue:null,
                type:"string"
            },
            {
                description:"name of the field referenced by this summary",
                optional:false,
                name:"usedFieldName",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"Return true to include hilites from the used field in the generated   summary field value.",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:ListGrid.focusInFilterEditor":{
        ref:"method:ListGrid.focusInFilterEditor",
        flags:"",
        description:" If the filter editor (${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')}) is visible for this grid,\n this method will explicitly put focus into the specified field in the filter editor.\n",
        name:"focusInFilterEditor",
        seeAlso:[
        ],
        params:[
            {
                description:"Name of the field to put focus into. If unspecified focus will go                             to the first field in the editor",
                optional:true,
                name:"fieldName",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "filterEditor"
        ]
    },
    "attr:DynamicForm.wrapItemTitles":{
        ref:"attr:DynamicForm.wrapItemTitles",
        flags:"IRW",
        description:"Whether titles for form items should wrap.  If not specified, titles will wrap by\n default.  Can be overridden for individual items via ${isc.DocUtils.linkForRef('attr:FormItem.wrapTitle')}",
        name:"wrapItemTitles",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ]
    },
    "group:allowedOperations":{
        ref:"group:allowedOperations",
        title:"Allowed Operations",
        refs:[
            "attr:Calendar.canCreateEvents",
            "attr:Calendar.canEditEvents",
            "attr:Calendar.canDeleteEvents",
            "attr:Calendar.canRemoveEvents",
            "attr:Calendar.canDragEvents"
        ],
        description:null,
        name:"allowedOperations",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:Window.printBodyStyle":{
        ref:"attr:Window.printBodyStyle",
        flags:"IR",
        description:"Style for the Window body in printed output.",
        name:"printBodyStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"printHeader\"",
        type:"attr",
        definingClass:"class:Window"
    },
    "classMethod:Class.logFatal":{
        ref:"classMethod:Class.logFatal",
        flags:"",
        description:" Log a message at \"fatal\" priority\n \n",
        name:"logFatal",
        seeAlso:[
            {
                ref:"classMethod:Log.logDebug",
                description:"for usage info"
            }
        ],
        params:[
            {
                description:"message to log",
                optional:false,
                name:"message",
                defaultValue:null,
                type:"String"
            },
            {
                description:"category to log in",
                optional:true,
                name:"category",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"classMethod",
        definingClass:"class:Class"
    },
    "method:TileGrid.setFieldState":{
        ref:"method:TileGrid.setFieldState",
        flags:"",
        description:" Sets some presentation properties (visibility, width, userFormula and userSummary) of the \n grid fields based on the ${isc.DocUtils.linkForRef('type:ListGridFieldState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to ${isc.DocUtils.linkForRef('method:TileGrid.getFieldState')}.\n\n",
        name:"setFieldState",
        seeAlso:[
            {
                ref:"method:TileGrid.getFieldState",
                description:null
            }
        ],
        params:[
            {
                description:"state to apply to the grid's fields.",
                optional:false,
                name:"fieldState",
                defaultValue:null,
                type:"ListGridFieldState"
            }
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:[
            "viewState"
        ]
    },
    "classMethod:Log.setPriority":{
        ref:"classMethod:Log.setPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for this log category.\n <P>\n After calling setPriority, any messages logged to the given category whose priority is\n below the specified priority will not appear in the Log.\n\n",
        name:"setPriority",
        seeAlso:[
            {
                ref:"classMethod:Log.isEnabledFor",
                description:"to check whether a category would allow a log at a given priority"
            }
        ],
        params:[
            {
                description:"category name",
                optional:false,
                name:"category",
                defaultValue:null,
                type:"String"
            },
            {
                description:"priority level to set",
                optional:false,
                name:"priority",
                defaultValue:null,
                type:"LogPriority"
            },
            {
                description:"Optional ISC class or instance - if passed the priority will be set for logging \n      occurring on the class or instance only.",
                optional:true,
                name:"object",
                defaultValue:null,
                type:"Class or Instance object"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:DecisionGateway.criteriaMap":{
        ref:"attr:DecisionGateway.criteriaMap",
        flags:"IR",
        description:"A Map from ${isc.DocUtils.linkForRef('attr:ProcessElement.ID')} to Criteria that will cause this ProcessElement to\n be chosen as the next element if the criteria matches.",
        name:"criteriaMap",
        seeAlso:[
        ],
        valueType:"Object<String,Criteria>",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DecisionGateway"
    },
    "attr:Menu.submenuImage":{
        ref:"attr:Menu.submenuImage",
        flags:"IR",
        description:"Default image to use for the submenu indicator. Valid src, width and height must be\n specified. See ${isc.DocUtils.linkForRef('object:ImgProperties')} for format.<br>\n If ${isc.DocUtils.linkForRef('attr:Menu.submenuDirection')} is set to <code>\"left\"</code>, the image src will have\n the suffix <code>\"_left\"</code> appended to it.",
        name:"submenuImage",
        seeAlso:[
        ],
        valueType:"Img Properties",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:SimpleType.updateAtomicValue":{
        ref:"method:SimpleType.updateAtomicValue",
        flags:"",
        description:" Optional method to update a live data value with an edited atomic value\n (such as a string or number). If defined this method will be called\n when the user edits data in a field of this type, allowing the developer\n to convert from the atomic type to a raw data value for storage.\n <P>\n Note that if the user is editing a field which did not previously have a value, the\n 'currentValue' will be null. This method should handle this (creating a new data value).\n\n",
        name:"updateAtomicValue",
        seeAlso:[
        ],
        params:[
            {
                description:"New atomic value. This should match the underlying  atomic type specified by the ${isc.DocUtils.linkForRef('attr:SimpleType.inheritsFrom')} attribute.",
                optional:false,
                name:"atomicValue",
                defaultValue:null,
                type:"any"
            },
            {
                description:"Existing data value to be updated.",
                optional:false,
                name:"currentValue",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"Updated data value.",
            type:"any"
        },
        type:"method",
        definingClass:"class:SimpleType"
    },
    "method:Canvas.resizeBy":{
        ref:"method:Canvas.resizeBy",
        flags:"",
        description:"\t\t\tResizes the widget, adding deltaX to its width and deltaY to its height (moves the right\n          and/or bottom sides of the widget).\n",
        name:"resizeBy",
        seeAlso:[
        ],
        params:[
            {
                description:"amount to resize horizontally (may be negative)",
                optional:true,
                name:"deltaX",
                defaultValue:null,
                type:"number"
            },
            {
                description:"amount to resize vertically (may be negative)",
                optional:true,
                name:"deltaY",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether the component actually changed size",
            type:"Boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('resize')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "method:Array.first":{
        ref:"method:Array.first",
        flags:"",
        description:" Return the first item in this list\n\n",
        name:"first",
        seeAlso:[
        ],
        returns:{
            description:"first item in the list",
            type:"any"
        },
        type:"method",
        definingClass:"object:Array",
        groups:[
            "access"
        ]
    },
    "attr:RPCRequest.serverOutputAsString":{
        ref:"attr:RPCRequest.serverOutputAsString",
        flags:"IRWA",
        description:"Setting this flag makes the body of the HTTP response available as a String in the\n ${isc.DocUtils.linkForRef('attr:RPCRequest.callback')} as ${isc.DocUtils.linkForRef('attr:RPCResponse.data')}.  This is typically only useful if you\n are sending a request that will <b>not</b> be received by the SmartClient Java Server,\n however in that case, set ${isc.DocUtils.linkForRef('attr:RPCRequest.useSimpleHttp')}:true instead, which implies\n <code>serverOutputAsString:true</code>.\n <P>\n <code>serverOutputAsString:true</code> allows you to, for example, load the contents of\n static files off your webserver into a string for processing on the client with no server\n support.  The ${isc.DocUtils.linkForRef('attr:RPCRequest.actionURL')} must be in the same domain as the current page for\n this to work.\n <p>\n This feature relies on the XMLHttpRequest object which can be disabled by end-users in some\n supported browsers.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.\n <p>\n Generally this API is used for either ${isc.DocUtils.linkForRef('group:nonJavaBackend','non-Java backends')} \n or for advanced usage such as content that requires processing before it can be used in\n SmartClient components (such as client-side web scraping).  Note that SmartClient provides\n higher-level APIs for loading common types of data, see eg ${isc.DocUtils.linkForRef('class:HTMLFlow')} for HTML content,\n ${isc.DocUtils.linkForRef('class:ViewLoader')} for loading SmartClient components, ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXML')} for loading\n XML, ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} for loading <a href='http://www.json.org/' target='_blank'>JSON</a>, and\n ${isc.DocUtils.linkForRef('class:DataSource')} for loading structured data in various formats.",
        name:"serverOutputAsString",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "attr:ComboBoxItem.filterWithValue":{
        ref:"attr:ComboBoxItem.filterWithValue",
        flags:"RA",
        description:"Read-only property set by the ComboBoxItem to indicate whether we should use the \n current typed-in value as part of the filter criteria returned by \n ${isc.DocUtils.linkForRef('method:ComboBoxItem.getPickListFilterCriteria')}.  You can check this flag in order to\n mimic the ComboBoxItem's default behavior if you provide a custom implementation of\n <code>getPickListFilterCriteria()</code>.",
        name:"filterWithValue",
        seeAlso:[
            {
                ref:"method:ComboBoxItem.getPickListFilterCriteria",
                description:null
            },
            {
                ref:"attr:ComboBoxItem.filterFields",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:FormulaBuilder.titleField":{
        ref:"attr:FormulaBuilder.titleField",
        flags:"IR",
        description:"TextItem that allows users to set the title for this field.",
        name:"titleField",
        seeAlso:[
        ],
        valueType:"AutoChild TextItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "formulaFields"
        ]
    },
    "classAttr:RPCManager.defaultPrompt":{
        ref:"classAttr:RPCManager.defaultPrompt",
        flags:"IRW",
        description:"If showPrompt is enabled for a given transaction, this is the defaultPrompt to be shown\n to the user in a modal dialog while the transaction occurs.\n May be overridden at the request level via ${isc.DocUtils.linkForRef('attr:RPCRequest.prompt')}.<br>\n More targetted default prompts are also supported for certain code-paths. See the following \n set of properties for details:<ul>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.removeDataPrompt')}</li>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.saveDataPrompt')}</li>\n <li>${isc.DocUtils.linkForRef('classAttr:RPCManager.fetchDataPrompt')}</li>\n </ul>",
        name:"defaultPrompt",
        seeAlso:[
            {
                ref:"classAttr:RPCManager.showPrompt",
                description:null
            },
            {
                ref:"classAttr:RPCManager.promptStyle",
                description:null
            },
            {
                ref:"classAttr:RPCManager.promptCursor",
                description:null
            },
            {
                ref:"attr:RPCRequest.showPrompt",
                description:null
            },
            {
                ref:"attr:RPCRequest.prompt",
                description:null
            },
            {
                ref:"attr:RPCRequest.promptStyle",
                description:null
            },
            {
                ref:"attr:RPCRequest.promptCursor",
                description:null
            }
        ],
        valueType:"HTMLString",
        defaultValue:"\"Contacting Server...\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:[
            "rpcPrompt",
            "i18nMessages"
        ]
    },
    "group:mouseEvents":{
        ref:"group:mouseEvents",
        refs:[
            "classMethod:EventHandler.getTarget",
            "classMethod:EventHandler.getDragTarget",
            "classMethod:EventHandler.getX",
            "classMethod:EventHandler.getY",
            "classMethod:EventHandler.leftButtonDown",
            "classMethod:EventHandler.rightButtonDown",
            "classMethod:EventHandler.middleButtonDown"
        ],
        name:"mouseEvents",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:FormItem.iconHSpace":{
        ref:"attr:FormItem.iconHSpace",
        flags:"IR",
        description:"Horizontal space (in px) to leave between form item icons. The space\n appears to the left of each icon. May be overridden at the icon level via\n ${isc.DocUtils.linkForRef('attr:FormItemIcon.hspace')}.",
        name:"iconHSpace",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"3",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formIcons"
        ]
    },
    "attr:DrawItem.canHover":{
        ref:"attr:DrawItem.canHover",
        flags:"IRW",
        description:"Will this DrawItem fire hover events when the user hovers over it?",
        name:"canHover",
        seeAlso:[
            {
                ref:"attr:DrawItem.showHover",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DrawItem",
        groups:[
            "hovers"
        ]
    },
    "attr:ComboBoxItem.saveOnEnter":{
        ref:"attr:ComboBoxItem.saveOnEnter",
        flags:"IRW",
        description:"ComboBox items will submit their containing form on enter keypress \n if ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOnEnter','saveOnEnter')} is true. Setting this property to\n <code>false</code> will disable this behavior.\n <P>\n Note that if the drop down list of options (pickList) is visible an\n <code>Enter</code> keypress is used to select a value from the available set of\n options and will not automatically cause form submission.",
        name:"saveOnEnter",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "method:ToolStripGroup.setControlColumn":{
        ref:"method:ToolStripGroup.setControlColumn",
        flags:"",
        description:" Return the column widget that contains the passed control.\n \n",
        name:"setControlColumn",
        seeAlso:[
        ],
        params:[
            {
                description:"the control to find in this group",
                optional:false,
                name:"control",
                defaultValue:null,
                type:"Canvas"
            }
        ],
        type:"method",
        definingClass:"class:ToolStripGroup"
    },
    "method:DynamicForm.itemChanged":{
        ref:"method:DynamicForm.itemChanged",
        flags:"",
        description:" Handler fired when there is a changed() event fired on a FormItem within this form.\n <P>\n Fires after the change() handler on the FormItem itself, and only if the item did not\n cancel the change event and chooses to allow it to propagate to the form as a whole. \n\n",
        name:"itemChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"the FormItem where the change event occurred",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            },
            {
                description:"new value for the FormItem",
                optional:false,
                name:"newValue",
                defaultValue:null,
                type:"any"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm"
    },
    "attr:ColorPicker.crosshairImageURL":{
        ref:"attr:ColorPicker.crosshairImageURL",
        flags:"IR",
        description:"The location of the crosshair image file",
        name:"crosshairImageURL",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"[SKIN]ColorPicker/crosshair.png\"",
        type:"attr",
        definingClass:"class:ColorPicker"
    },
    "attr:TextAreaItem.height":{
        ref:"attr:TextAreaItem.height",
        flags:"IRW",
        description:"default height of this item",
        name:"height",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:TextAreaItem",
        groups:[
            "appearance"
        ]
    },
    "attr:Gauge.drawnClockwise":{
        ref:"attr:Gauge.drawnClockwise",
        flags:"IRW",
        description:"Whether the sectors are drawn clockwise, and increasing the value causes the\n needle to move clockwise.",
        name:"drawnClockwise",
        setter:[
            "setDrawnClockwise"
        ],
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Gauge"
    },
    "attr:RichTextItem.startRow":{
        ref:"attr:RichTextItem.startRow",
        flags:"IRW",
        description:"By default RichTextItems take up an entire row",
        name:"startRow",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RichTextItem"
    },
    "attr:DataSource.inheritsFrom":{
        ref:"attr:DataSource.inheritsFrom",
        flags:"IR",
        description:"ID of another DataSource this DataSource inherits its ${isc.DocUtils.linkForRef('attr:DataSource.fields')} from.\n <P>\n Local fields (fields defined in this DataSource) are added to inherited fields \n to form the full set of fields.  Fields with the same name are merged in the same way\n that ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields','databound component fields')} are merged with\n DataSource fields.\n <P>\n The default order of the combined fields is new local fields first (including any fields\n present in the parent DataSource which the local DataSource re-declares), then parent\n fields.  You can set ${isc.DocUtils.linkForRef('attr:DataSource.useParentFieldOrder')} to instead use the parent's field\n order, with new local fields appearing last.  You can set ${isc.DocUtils.linkForRef('attr:DataSource.showLocalFieldsOnly')} to\n have all non-local fields hidden.\n <P>\n Note that <b>only fields are inherited</b> - other properties such as dataURL and\n dataFormat are not.  You can use ordinary inheritance, that is, creating a subclass of\n DataSource, in order to share properties such as dataURL across a series of DataSources\n that also inherit fields from each other via <code>inheritsFrom</code>.\n <P>\n This feature can be used for:\n <ul>\n <li>creating a customized view (eg, only certain fields shown) which will be used by\n multiple ${isc.DocUtils.linkForRef('interface:DataBoundComponent','databound components')}.\n <li>adding presentation-specific attributes to metadata that has been automatically\n derived from ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema','XML Schema')} or other metadata formats\n <li>modeling object subclassing and extension in server-side code and storage systems\n <li>modeling relational database joins, and the equivalents in other systems\n <li>creating hooks for others to customize your application in a maintainable way.  For\n example, if you have a dataSource \"employee\", you can create a dataSource\n \"customizedEmployee\" which inherits from \"employee\" but does not initially define any\n fields, and bind all ${isc.DocUtils.linkForRef('interface:DataBoundComponent','databound components')} to\n \"customizedEmployee\".  Customizations of fields (including appearance changes, field\n order, new fields, hiding of fields, and custom validation rules) can be added to\n \"customizedEmployee\", so that they are kept separately from the original field data and\n have the best possible chance of working with future versions of the \"employee\"\n dataSource.\n </ul>",
        name:"inheritsFrom",
        seeAlso:[
        ],
        valueType:"DataSource ID",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        examples:[
            "${isc.DocUtils.linkForExampleId('schemaChaining')}"
        ],
        definingClass:"class:DataSource",
        groups:[
            "fields"
        ]
    },
    "attr:FacetValue.isMinimizeValue":{
        ref:"attr:FacetValue.isMinimizeValue",
        flags:"IR",
        description:"Used to determine which facetValue is to be shown when the facet is minimized.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.  See\n ${isc.DocUtils.linkForRef('attr:CubeGrid.canMinimizeFacets')}.",
        name:"isMinimizeValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "method:DataSource.performCustomOperation":{
        ref:"method:DataSource.performCustomOperation",
        flags:"",
        description:" Invoke an operation declared with ${isc.DocUtils.linkForRef('attr:OperationBinding.operationType')} \"custom\".\n <P>\n <b>This is a rarely used API.</b>  If the operation you are performing can be thought of\n as one of the standard \"CRUD\" ${isc.DocUtils.linkForRef('type:DSOperationType','operation types')}, declare it\n with a CRUD operationType.  For example, if your operation updates a record, declare it\n with operationType \"update\" and invoke it via ${isc.DocUtils.linkForRef('method:DataSource.updateData')} - this will cause\n ${isc.DocUtils.linkForRef('class:ResultSet','cache sync')} to work correctly.\n <P>\n In particular:\n <ul>\n <li> do not use this API just because you need to add additional server-side logic to a\n CRUD operation (${isc.DocUtils.linkForRef('class:DMI')} allows this)\n <li> do not use this API to implement variants of core CRUD operations\n (${isc.DocUtils.linkForRef('attr:DSRequest.operationId')} is the correct way to do this)\n <li> do not use this API just because an operation affects more than one record.  Most\n kinds of multi-record operations should use ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','queuing')}.  \n However, a custom operation <em>is</em> appropriate for genuine \"batch\" updates, as \n opposed to just a number of ordinary updates by primaryKey - see \n ${isc.DocUtils.linkForRef('attr:OperationBinding.allowMultiUpdate')}\n <li> do not use this API just because you are calling a stored procedure in SQL - if the\n stored procedure performs some kind of CRUD operation on the records of this DataSource,\n use a standard CRUD operationType\n </ul>\n <P>\n Instead, the specific purpose of this API is to bypass all checks and side effects that\n normally occur for CRUD operations, for example, that a \"fetch\" requires valid Criteria\n or that an \"update\" or \"remove\" operation contains a valid primary key, or that an \"add\"\n operation returns the newly added record.  <code>performCustomOperation</code> allows\n you to pass an arbitrary Record to the server, act on it with custom code, and return\n arbitray results or even no results.\n <P>\n The \"data\" parameter becomes ${isc.DocUtils.linkForRef('attr:DSRequest.data','dsRequest.data')}.  With the SmartClient\n Server Framework, the data is accessible server-side via DSRequest.getValues() and in\n ${isc.DocUtils.linkForRef('group:velocitySupport','Velocity templates')} (such as &lt;customSQL&gt;) as $values.\n <P>\n Note that with SQLDataSource, <code>performCustomOperation</code> must be used if you\n plan to have a &lt;customSQL&gt; tag in your operationBinding that will execute SQL\n operations other than SELECT, UPDATE, INSERT, DELETE (such as creating a new table).\n By declaring ${isc.DocUtils.linkForRef('attr:OperationBinding.operationType')} \"custom\" in your .ds.xml file, all\n checks related to normal CRUD operations will be skipped and your &lt;customSQL&gt;\n can do arbitrary things.\n\n",
        name:"performCustomOperation",
        seeAlso:[
        ],
        params:[
            {
                description:"the operation ID",
                optional:false,
                name:"operationId",
                defaultValue:null,
                type:"String"
            },
            {
                description:"data to pass to the server.",
                optional:true,
                name:"data",
                defaultValue:null,
                type:"Record Properties"
            },
            {
                description:"callback to invoke on completion",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"DSCallback"
            },
            {
                description:"additional properties to set on                                                       the DSRequest that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            }
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "operations"
        ]
    },
    "attr:ListGridField.validators":{
        ref:"attr:ListGridField.validators",
        flags:"IRW",
        description:"Array of ${isc.DocUtils.linkForRef('class:Validator')} objects for this field.  When the user edits cells in\n this field, these validators will be applied to the edited value.<br>\n Note: for databound listGrids, this property may be specified on the\n ${isc.DocUtils.linkForRef('class:DataSourceField')}, enabling both client and server side validation.",
        name:"validators",
        seeAlso:[
            {
                ref:"class:Validator",
                description:null
            },
            {
                ref:"attr:ListGridField.required",
                description:null
            }
        ],
        valueType:"Array of Validator",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('dataValidation')}"
        ],
        definingClass:"object:ListGridField",
        groups:[
            "gridValidation"
        ]
    },
    "attr:PortalPosition.rowNum":{
        ref:"attr:PortalPosition.rowNum",
        flags:"IR",
        description:"The row number occupied by a ${isc.DocUtils.linkForRef('class:Portlet')} within a ${isc.DocUtils.linkForRef('class:PortalLayout')} column.",
        name:"rowNum",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0",
        type:"attr",
        definingClass:"object:PortalPosition"
    },
    "attr:Calendar.headerLevels":{
        ref:"attr:Calendar.headerLevels",
        flags:"IRW",
        description:"Configures the levels of ${isc.DocUtils.linkForRef('object:HeaderLevel','headers')} shown above the event area, and \n their time units.\n <P>\n Header levels are provided from the top down, so the first header level should be the largest \n time unit and the last one the smallest.  The smallest is then used for the actual \n field-headers.",
        name:"headerLevels",
        setter:[
            "setHeaderLevels"
        ],
        seeAlso:[
        ],
        valueType:"Array of HeaderLevel",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "attr:FilterBuilder.showSelectionCheckbox":{
        ref:"attr:FilterBuilder.showSelectionCheckbox",
        flags:"IR",
        description:"If true, causes a CheckboxItem to appear to the left of each clause in \"inline\" \n ${isc.DocUtils.linkForRef('type:TopOperatorAppearance','appearance')}.  This checkbox allows the user to select \n individual clauses so that, for example, clauses can be removed from the filterBuilder \n by application code.  This property is ignored for appearances other than \"inline\".",
        name:"showSelectionCheckbox",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "attr:HeaderSpan.valign":{
        ref:"attr:HeaderSpan.valign",
        flags:"IR",
        description:"Vertical alignment of the title of this headerSpan.\n <P>\n Defaults to listGrid.headerSpanVAlign if unset.",
        name:"valign",
        seeAlso:[
        ],
        valueType:"VerticalAlignment",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:HeaderSpan",
        groups:[
            "headerSpan"
        ]
    },
    "attr:DynamicForm.saveOnEnter":{
        ref:"attr:DynamicForm.saveOnEnter",
        flags:"IRW",
        description:"If <code>true</code>, when the user hits the Enter key while focused in a text-item in\n this form, we automatically submit the form to the server using the \n ${isc.DocUtils.linkForRef('method:DynamicForm.submit')} method.",
        name:"saveOnEnter",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "submitting"
        ]
    },
    "method:SectionItem.expandSection":{
        ref:"method:SectionItem.expandSection",
        flags:"",
        description:" Expands a section, showing all the items contained within the section.\n",
        name:"expandSection",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:SectionItem"
    },
    "method:ListGrid.setCriteria":{
        ref:"method:ListGrid.setCriteria",
        flags:"",
        description:" Sets this component's filter criteria.\n Default implementation calls this.data.setCriteria().\n <P>\n Note: if ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true, the ${isc.DocUtils.linkForRef('method:ListGrid.setFilterEditorCriteria')}\n method may be used to update the values displayed in the filter editor without effecting the\n data object.\n",
        name:"setCriteria",
        seeAlso:[
        ],
        params:[
            {
                description:"new criteria to show",
                optional:false,
                name:"",
                defaultValue:null,
                type:"Criteria or AdvancedCriteria"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "attr:DataSourceField.rootValue":{
        ref:"attr:DataSourceField.rootValue",
        flags:"IR",
        description:"For a field that is a foreignKey establishing a tree relationship, what value indicates a\n root-level node.  Defaults to null.\n <P>\n Note that the rootValue may be overridden on a specific ResultTree instance by setting\n ${isc.DocUtils.linkForRef('attr:ResultTree.rootNode')}, or if the ResultTree is auto-generated by a ${isc.DocUtils.linkForRef('class:TreeGrid')},\n by setting ${isc.DocUtils.linkForRef('attr:TreeGrid.treeRootValue')}. This allows a component to navigate a subtree of\n the hierarchical data from this dataSource starting at a particular node.",
        name:"rootValue",
        seeAlso:[
        ],
        valueType:"any",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        examples:[
            "${isc.DocUtils.linkForExampleId('treeLoadXML')}"
        ],
        definingClass:"class:DataSourceField",
        groups:[
            "dataSourceRelations"
        ]
    },
    "attr:FacetChart.canMoveAxes":{
        ref:"attr:FacetChart.canMoveAxes",
        flags:"IR",
        description:"Whether the positions of value axes can be changed.  The default is true\n for charts with three or more vertical, value axes.",
        name:"canMoveAxes",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "classMethod:Page.goBack":{
        ref:"classMethod:Page.goBack",
        flags:"",
        description:" Go back in the browser's history.<br><br>\n\n If the history is empty and the window.opener is set, we assume we're a child window and just\n close the window.\n\n",
        name:"goBack",
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:Page"
    },
    "attr:FacetChart.chartRectProperties":{
        ref:"attr:FacetChart.chartRectProperties",
        flags:"IRW",
        description:"Properties for chart rect",
        name:"chartRectProperties",
        seeAlso:[
        ],
        valueType:"DrawRect Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "class:FieldPickerField":{
        methods:[
        ],
        ref:"class:FieldPickerField",
        classAttrs:[
            "classAttr:FieldPickerField.frozenTitle",
            "classAttr:FieldPickerField.precisionTitle",
            "classAttr:FieldPickerField.decimalPrecisionTitle",
            "classAttr:FieldPickerField.decimalPadTitle",
            "classAttr:FieldPickerField.alignTitle",
            "classAttr:FieldPickerField.cellAlignTitle"
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding/FieldPicker"
        ],
        attrs:[
        ],
        description:"Class containing properties that configure the display of\n and interaction with the fields showing in a ${isc.DocUtils.linkForRef('class:FieldPicker')}.",
        name:"FieldPickerField",
        seeAlso:[
        ],
        type:"class"
    },
    "group:dataType":{
        ref:"group:dataType",
        refs:[
            "attr:DataSourceField.required",
            "attr:DataSourceField.autoGenerated",
            "attr:DataSourceField.nillable",
            "attr:DataSourceField.valueMap",
            "attr:DataSourceField.validators",
            "attr:DataSourceField.length",
            "attr:SimpleType.valueMap"
        ],
        name:"dataType",
        seeAlso:[
        ],
        type:"group"
    },
    "type:LabelCollapseMode":{
        ref:"type:LabelCollapseMode",
        values:[
            {
                description:"Show all labels regardless, even though they will overlap",
                value:"\"none\""
            },
            {
                description:"Show significant time values such as the first day of the month or week.  Data values in Records must be true Date objects, not Strings.",
                value:"\"time\""
            },
            {
                description:"Pick round numbers in the range and show labels for just those numbers.  Best for continuous datasets that are not time-based",
                value:"\"numeric\""
            },
            {
                description:"Pick periodic values from the dataset and show labels for those.  Best when the there are no particular points that would clearly be the best to label",
                value:"\"sample\""
            }
        ],
        description:"Strategy to apply when there is too little room for labels to be shown for all data points with\n comfortable padding (${isc.DocUtils.linkForRef('attr:FacetChart.minLabelGap')}).",
        name:"LabelCollapseMode",
        seeAlso:[
        ],
        type:"type"
    },
    "attr:MenuButton.title":{
        ref:"attr:MenuButton.title",
        flags:"IRW",
        description:"Default title for the button.",
        name:"title",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Show Menu\"",
        type:"attr",
        definingClass:"class:MenuButton",
        groups:[
            "i18nMessages"
        ]
    },
    "group:defaults":{
        ref:"group:defaults",
        refs:[
        ],
        name:"defaults",
        seeAlso:[
        ],
        type:"group"
    },
    "object:LinearGradient":{
        methods:[
        ],
        ref:"object:LinearGradient",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Drawing/Gradients"
        ],
        attrs:[
            "attr:LinearGradient.x1",
            "attr:LinearGradient.y1",
            "attr:LinearGradient.x2",
            "attr:LinearGradient.y2"
        ],
        description:"Definition of a linear gradient between two points, (${isc.DocUtils.linkForRef('attr:LinearGradient.x1','x1')}, ${isc.DocUtils.linkForRef('attr:LinearGradient.y1','y1')})\n and (${isc.DocUtils.linkForRef('attr:LinearGradient.x2','x2')}, ${isc.DocUtils.linkForRef('attr:LinearGradient.y2','y2')}).",
        name:"LinearGradient",
        seeAlso:[
        ],
        type:"object",
        inheritsFrom:"Gradient"
    },
    "method:ActiveXControl.getPluginHandle":{
        ref:"method:ActiveXControl.getPluginHandle",
        flags:"",
        description:"  Returns a handle to the element for this ISC ActiveX control object.\n",
        name:"getPluginHandle",
        seeAlso:[
        ],
        returns:{
            description:"pointer to the plugin element in the DOM",
            type:"HTML Element"
        },
        type:"method",
        definingClass:"class:ActiveXControl"
    },
    "classMethod:Class.echoLeaf":{
        ref:"classMethod:Class.echoLeaf",
        flags:"",
        description:" Return a very short (generally less than 40 characters) string representation of any object,\n suitable for viewing by a developer for debugging purposes.\n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.echoLeaf\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n\n",
        name:"echoLeaf",
        seeAlso:[
            {
                ref:"method:Class.echo",
                description:null
            }
        ],
        params:[
            {
                description:"object to echo",
                optional:false,
                name:"obj",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"a short string representation of the object",
            type:"string"
        },
        type:"classMethod",
        definingClass:"class:Class",
        groups:[
            "debug"
        ]
    },
    "classMethod:Page.getAppDir":{
        ref:"classMethod:Page.getAppDir",
        flags:"",
        description:" Returns the base URL of the application, which is the page URL minus the last non-directory \n path component.  For example, if the page is loaded from\n <code>http://foo.com/bar/zoo.jsp</code>, appDir will be <code>http://foo.com/bar/</code>.\n <P>\n If other page-wide URLs such as ${isc.DocUtils.linkForRef('classMethod:Page.setIsomorphicDir')} are specified as\n relative paths, they are considered relative to this URL.\n\n",
        name:"getAppDir",
        seeAlso:[
        ],
        returns:{
            description:"URL for page-specific files.",
            type:"string"
        },
        type:"classMethod",
        definingClass:"class:Page",
        groups:[
            "files"
        ]
    },
    "attr:ListGridRecord.canAcceptDrop":{
        ref:"attr:ListGridRecord.canAcceptDrop",
        flags:"IR",
        description:"When set to <code>false</code>, other records cannot be dropped on (i.e., inserted\n via drag and drop) immediately before this record.",
        name:"canAcceptDrop",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "classMethod:Messaging.getSubscribedChannels":{
        ref:"classMethod:Messaging.getSubscribedChannels",
        flags:"",
        description:" Returns an array of identifiers for all currently subscribed channels on this client\n\n",
        name:"getSubscribedChannels",
        seeAlso:[
        ],
        returns:{
            description:null,
            type:"Array of String"
        },
        type:"classMethod",
        definingClass:"class:Messaging",
        groups:[
            "messaging"
        ]
    },
    "attr:TreeGrid.animateFolderSpeed":{
        ref:"attr:TreeGrid.animateFolderSpeed",
        flags:"IRW",
        description:"When animating folder opening / closing, this property designates the speed of the\n animation in pixels shown (or hidden) per second. Takes precedence over the \n ${isc.DocUtils.linkForRef('attr:TreeGrid.animateFolderTime')} property, which allows the developer to specify a\n duration for the animation rather than a speed.",
        name:"animateFolderSpeed",
        seeAlso:[
            {
                ref:"attr:TreeGrid.animateFolderTime",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"3000",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateTree')}"
        ],
        definingClass:"class:TreeGrid",
        groups:[
            "animation"
        ]
    },
    "method:LoginDialog.register":{
        ref:"method:LoginDialog.register",
        flags:"",
        description:" Called if the user clicks on the ${isc.DocUtils.linkForRef('attr:LoginDialog.registrationItem','registration link')}\n on the login form. Implement this method to allow the user to register for a\n new account.\n",
        name:"register",
        seeAlso:[
        ],
        params:[
            {
                description:"Current values of form fields",
                optional:false,
                name:"values",
                defaultValue:null,
                type:"Object"
            },
            {
                description:"Form on which the link was clicked",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            }
        ],
        type:"method",
        definingClass:"class:LoginDialog"
    },
    "attr:Flashlet.classID":{
        ref:"attr:Flashlet.classID",
        flags:"IR",
        description:"This attribute specifies the clsid of the outer &lt;object&gt; tag.\n  <p>\n  The default classID is: \"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"\n  <p>",
        name:"classID",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"see below",
        type:"attr",
        definingClass:"class:Flashlet"
    },
    "method:FacetChart.dataLabelClick":{
        ref:"method:FacetChart.dataLabelClick",
        flags:"",
        description:" Fires when the user clicks on a data label, that is, a text label showing values from\n the first facet.  For example, the labels underneath the X-axis of a column chart,\n labelling each column.\n\n",
        name:"dataLabelClick",
        seeAlso:[
        ],
        params:[
            {
                description:"facetValue that was clicked, or null if click was in        empty space",
                optional:false,
                name:"facetValue",
                defaultValue:null,
                type:"FacetValue"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('drillCharting')}"
        ],
        definingClass:"class:FacetChart"
    },
    "method:ListGrid.resizeField":{
        ref:"method:ListGrid.resizeField",
        flags:"A",
        description:" Resize a particular field to a new width. Note that this method\n will also set ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')} to false if it was previously true.\n\n",
        name:"resizeField",
        seeAlso:[
        ],
        params:[
            {
                description:"Number of the field to resize",
                optional:false,
                name:"fieldNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"New width of the field",
                optional:false,
                name:"newWidth",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:ListGrid.expansionMode":{
        ref:"attr:ListGrid.expansionMode",
        flags:"IRWA",
        description:"The ${isc.DocUtils.linkForRef('type:ExpansionMode')} for records in this grid.\n Default <code>null</code> value means no expansion.",
        name:"expansionMode",
        seeAlso:[
        ],
        valueType:"ExpansionMode",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "attr:RPCRequest.suppressAutoDraw":{
        ref:"attr:RPCRequest.suppressAutoDraw",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:RPCRequest.evalResult')} is set, setting this property to true causes\n ${isc.DocUtils.linkForRef('attr:Canvas.autoDraw')} to be set to false for the duration of the result evaluation -\n which is generally what you want if you're returning new components from the server.\n <P>\n This also effects components loaded via the ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadScreen')} API.",
        name:"suppressAutoDraw",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "attr:FacetChart.dataLineType":{
        ref:"attr:FacetChart.dataLineType",
        flags:"IRW",
        description:"How to draw lines between adjacent data points in Line and Scatter charts.\n See ${isc.DocUtils.linkForRef('type:DataLineType')}.\n <p>\n Does not apply to boundary lines for shapes in Area or Radar plots.",
        name:"dataLineType",
        setter:[
            "setDataLineType"
        ],
        seeAlso:[
        ],
        valueType:"DataLineType",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:ListGrid.autoFitFieldText":{
        ref:"attr:ListGrid.autoFitFieldText",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid,\n and ${isc.DocUtils.linkForRef('attr:ListGrid.canAutoFitFields')} is true, this attribute will be shown as the menu\n item title for an item to perform a one-time autoFit of the field to its title or content\n via a call to ${isc.DocUtils.linkForRef('method:ListGrid.autoFitField')}.",
        name:"autoFitFieldText",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Auto Fit\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages",
            "autoFitFields"
        ]
    },
    "attr:ColorItem.pickerIconSrc":{
        ref:"attr:ColorItem.pickerIconSrc",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ColorItem.showPickerIcon','showPickerIcon')} is true for this item, this property governs the\n ${isc.DocUtils.linkForRef('attr:FormItemIcon.src','src')} of the picker icon image to be displayed.",
        name:"pickerIconSrc",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]/DynamicForm/ColorPicker_icon.png\"",
        type:"attr",
        definingClass:"class:ColorItem",
        groups:[
            "pickerIcon"
        ]
    },
    "attr:DataSourceField.inapplicable":{
        ref:"attr:DataSourceField.inapplicable",
        flags:"IR",
        description:"For use in ${isc.DocUtils.linkForRef('group:componentSchema')}, a field ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom','inherited')} from\n another schema can be redeclared with this property set in order to indicate that the\n property should not be used.\n <P>\n This is primarily used to influence ${isc.DocUtils.linkForRef('group:visualBuilder')}.  For simple type properties,\n this avoids the property appearing in the Component Editor.  \n <P>\n For fields that hold subcomponents, this prevents inappropriate drag and drop.  For example,\n a custom class called <code>MyDialog</code> may automatically create a series of children,\n and not allow arbitrary other children to be added.  In this case, the inherited property\n ${isc.DocUtils.linkForRef('attr:Canvas.children')} should be marked inapplicable in order to prevent arbitrary\n components being dropped onto a <code>MyDialog</code> instance.",
        name:"inapplicable",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField",
        groups:[
            "componentSchema"
        ]
    },
    "attr:SplitPane.addHistoryEntries":{
        ref:"attr:SplitPane.addHistoryEntries",
        flags:"IRW",
        description:"Should default history-tracking support be enabled? If <code>true</code>, then a history\n management scheme utilizing ${isc.DocUtils.linkForRef('classMethod:History.addHistoryEntry')} and ${isc.DocUtils.linkForRef('classMethod:History.registerCallback')}\n is enabled. The history callback is registered as an additive callback, allowing other\n history callbacks including the primary callback to be registered.\n <p>\n The default history management scheme is as follows:\n <ul>\n <li>History entries are only added after ${isc.DocUtils.linkForRef('classMethod:Page.isLoaded','page load')} and when the\n <code>SplitPane</code> is drawn.</li>\n <li>A history entry is added for a pane that is hidden by ${isc.DocUtils.linkForRef('method:SplitPane.showNavigationPane')},\n ${isc.DocUtils.linkForRef('method:SplitPane.showListPane')}, or ${isc.DocUtils.linkForRef('method:SplitPane.showDetailPane')} for the current ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','deviceMode')}\n and ${isc.DocUtils.linkForRef('attr:SplitPane.pageOrientation','pageOrientation')} settings.\n <p>\n Example 1: When <code>deviceMode</code> is \"desktop\", all 3 panes are shown simultaneously,\n so no history entries are added.\n <p>\n Example 2: When <code>deviceMode</code> is \"handset\", calling ${isc.DocUtils.linkForRef('method:SplitPane.showDetailPane')}\n will hide the current pane (the ${isc.DocUtils.linkForRef('attr:SplitPane.listPane')} if present, otherwise the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationPane')}).\n A history entry is added for the pane that was hidden</li>\n </ul>\n <p>\n The default history management scheme can be supplemented with application-specific\n history management. For example, when <code>deviceMode</code> is \"tablet\", the ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane')}\n is always visible, but changes to the content of the <code>detailPane</code> are transparent\n to the <code>SplitPane</code>. The application can add history entries of its own when\n the user causes new information to be displayed in the <code>detailPane</code>.",
        name:"addHistoryEntries",
        setter:[
            "setAddHistoryEntries"
        ],
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SplitPane",
        requiresModules:[
            "History"
        ]
    },
    "group:title":{
        ref:"group:title",
        refs:[
            "method:DataSource.getAutoTitle",
            "classMethod:DataSource.getAutoTitle",
            "attr:FormItem.showTitle",
            "attr:FormItem.titleOrientation",
            "attr:FormItem.titleAlign",
            "attr:FormItem.titleVAlign",
            "attr:FormItem.clipTitle",
            "attr:FormItem.wrapTitle",
            "attr:FormItem.vAlign",
            "attr:FormItem.titleClassName",
            "attr:FormItem.titleErrorClassName"
        ],
        name:"title",
        seeAlso:[
        ],
        type:"group"
    },
    "classMethod:RPCManager.xmlHttpRequestAvailable":{
        ref:"classMethod:RPCManager.xmlHttpRequestAvailable",
        flags:"",
        description:"\n Returns true if the XMLHttpRequest object is available, false otherwise.  See\n ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information on when XMLHttpRequest parser may\n not available and what features are\n impacted as a result.\n\n",
        name:"xmlHttpRequestAvailable",
        seeAlso:[
        ],
        returns:{
            description:"true if XMLHttpRequest is available, false otherwise.",
            type:"Boolean"
        },
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "attr:ListGridField.shouldPrint":{
        ref:"attr:ListGridField.shouldPrint",
        flags:"IRW",
        description:"Whether this field should be included in the printable representation of the grid.",
        name:"shouldPrint",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "printing"
        ]
    },
    "attr:DataSource.audit":{
        flags:"IR",
        type:"attr",
        requiresModules:[
            "SCServer"
        ],
        ref:"attr:DataSource.audit",
        description:"Enables saving of a log of changes to this DataSource in a second DataSource with the same\n fields, called the \"audit DataSource\".  <b>NOTE</b>: this feature applies to Enterprise\n Edition only; for more information on edition-specific features, see\n <a href='http://smartclient.com/product' target='_blank'>http://smartclient.com/product</a>.\n <p>\n When auditing is enabled, every time a DSRequest modifies this DataSource, a Record is added\n to the audit DataSource that shows the record as it existed after the change was made (or\n for a \"remove\", the values of the record at the time of deletion).  In addition, the audit\n DataSource has the following additional metadata fields:\n <ul>\n <li> ${isc.DocUtils.linkForRef('attr:DataSource.auditTypeFieldName','\"audit_operationType\"')}: type of the change (\"update\", \"add\" or \"remove\")\n <li> ${isc.DocUtils.linkForRef('attr:DataSource.auditUserFieldName','\"audit_modifier\"')}: username of the user that made the change.  The username is\n      determined in the same way that the \n      ${isc.DocUtils.linkForRef('attr:OperationBinding.requiresRole','Declarative Security')} subsystem determines the \n      current user.\n <li> ${isc.DocUtils.linkForRef('attr:DataSource.auditTimeStampFieldName','\"audit_changeTime\"')}: a field of type \"datetime\" recording the timestamp of\n      the change\n <li> ${isc.DocUtils.linkForRef('attr:DataSource.auditRevisionFieldName','\"audit_revision\"')}: a field of type \"sequence\" recording a simple\n      increasing integer value\n </ul>\n <p>\n If any of the field names above collide with field names of the DataSource being audited,\n an integer suffix will also be added, starting with 2 (for example, \"audit_modifier2\", then\n \"audit_modifier3\", etc).\n <p>\n To omit a data field from the automatically generated audit DataSource, just set\n ${isc.DocUtils.linkForRef('attr:DataSourceField.audit')} to false.\n <p>\n <h4>Auto-generated Audit DataSources</h4>\n <p>\n The audit DataSource is normally automatically generated, and unless otherwise specified\n with ${isc.DocUtils.linkForRef('attr:DataSource.auditDataSourceID')}, the ID of the audit DataSource will be\n <code>audit_[OriginalDSID]</code>.  \n <p>\n By default, the automatically generated audit DataSource will be of the same type as the\n DataSource being audited, however, if the DataSource being audited is not already a\n SQLDataSource, we recommend using ${isc.DocUtils.linkForRef('attr:DataSource.auditDSConstructor','auditDSConstructor:\"sql\"')} to use\n a SQLDataSource as the audit DataSource.  This is because a SQLDataSource used an audit\n DataSource will automatically generate a SQL table for storing audit data the first time\n changes are made.  JPA would require manual creation of a Java Bean, and Hibernate requires \n <a href='http://www.google.com/search?q=hbm2ddl.auto' target='_blank'>hbm2ddl.auto=update</a> to be set,\n which is widely considered unsafe for production use.\n <p>\n Automatically created audit DataSources can be loaded and queried just like other\n DataSources, using the DataSourceLoader, and using the server-side API\n <code>DataSource.getAuditDataSource()</code>.  However, you <b>must</b> load the DataSource\n being audited before loading its automatically created audit DataSource.\n <p>\n Note, that automatic SQL tables creation can be disabled. See \n ${isc.DocUtils.linkForRef('attr:DataSource.autoCreateAuditTable','autoCreateAuditTable')} for details.\n <p>\n <h4>Manually created Audit DataSources</h4>\n <p>\n The audit DataSource can also be manually created.  In this case, you can \n can either follow the naming conventions described above for the ID of the audit DataSource\n and the names of metadata fields, or use the linked properties to assign custom names.  If\n you omit any data fields from the tracked DataSource in your audit DataSource, those fields\n will be ignored for auditing purposes, exactly as though ${isc.DocUtils.linkForRef('attr:DataSourceField.audit')} had\n been set to false for an automatically-generated audit DataSource.\n <p>\n Also, note that in case of manually defined audit DataSource, if this DataSource\n is defined so it inherits the audited DataSource, all the audited DataSource's fields\n will be inherited, this including the primary keys. Since for the audit\n DataSource the primary key should be the revision field, in order to prevent the\n audit DataSource having two primary keys, the inherited DataSource's primary key \n will have to be declared in audit DataSource, but with the primaryKey attribute \n omitted (as well not being of type \"sequence\") in the audit DataSource.",
        name:"audit",
        valueType:"boolean",
        seeAlso:[
        ],
        serverDS:"only",
        examples:[
            "${isc.DocUtils.linkForExampleId('auditing')}"
        ],
        defaultValue:"false",
        definingClass:"class:DataSource",
        groups:[
            "serverDataIntegration"
        ]
    },
    "method:ListGrid.setHeaderSpanTitle":{
        ref:"method:ListGrid.setHeaderSpanTitle",
        flags:"",
        description:" Update the title of a ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')} dynamically.\n\n",
        name:"setHeaderSpanTitle",
        seeAlso:[
        ],
        params:[
            {
                description:"name of the headerSpan, as specified via ${isc.DocUtils.linkForRef('attr:HeaderSpan.name')}.",
                optional:false,
                name:"name",
                defaultValue:null,
                type:"String"
            },
            {
                description:"new title for the headerSpan",
                optional:false,
                name:"newTitle",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "headerSpan"
        ]
    },
    "method:MultiSortPanel.sortChanged":{
        ref:"method:MultiSortPanel.sortChanged",
        flags:"",
        description:" Fired whenever the sort configuration changes.  The single parameter is an array of\n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s that represent the list of sort-levels as they appear after \n whatever change has occurred.\n\n",
        name:"sortChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"The current sort configuration, after any changes",
                optional:false,
                name:"sortLevels",
                defaultValue:null,
                type:"Array of SortSpecifier"
            }
        ],
        type:"method",
        definingClass:"class:MultiSortPanel"
    },
    "method:CubeGrid.removeFacet":{
        ref:"method:CubeGrid.removeFacet",
        flags:"",
        description:"\n Remove a facet from the current view, using a fixed value from that facet.  For example, remove\n the \"months\" facet from the view, collapsing to just January, or total for all months.\n\n",
        name:"removeFacet",
        seeAlso:[
            {
                ref:"method:CubeGrid.addFacet",
                description:null
            },
            {
                ref:"attr:CubeGrid.fixedFacetValues",
                description:null
            }
        ],
        params:[
            {
                description:"facetId to remove",
                optional:false,
                name:"facetId",
                defaultValue:null,
                type:"id"
            },
            {
                description:"New fixed value for the facet, to be added to cubeGrid.fixedFacetValues.  Default is the\n     rollup value for the facet.",
                optional:true,
                name:"fixedFacetValueId",
                defaultValue:null,
                type:"id"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "facetLayout"
        ]
    },
    "attr:ButtonItem.button":{
        ref:"attr:ButtonItem.button",
        flags:"R",
        description:"This item is an autoChild generated ${isc.DocUtils.linkForRef('class:Canvas')} displayed by\n the ButtonItem and is an instance of ${isc.DocUtils.linkForRef('class:Button')} by defaut, cuztomizeable \n via the ${isc.DocUtils.linkForRef('attr:ButtonItem.buttonConstructor')} attribute.",
        name:"button",
        seeAlso:[
        ],
        valueType:"AutoChild Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ButtonItem"
    },
    "attr:Canvas.accessKey":{
        ref:"attr:Canvas.accessKey",
        flags:"IRWA",
        description:"If specified this governs the HTML accessKey for the widget.\n <P>\n This should be set to a character - when a user hits the html accessKey modifier for\n the browser, plus this character, focus will be given to the widget in question.\n The accessKey modifier can vary by browser and platform. \n <P>\n The following list of default behavior is for reference only, developers should also\n consult browser documentation for additional information.\n <ul>\n <li><b>Internet Explorer (all platforms)</b>: <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Windows, Unix)</b>: <code>Alt+Shift</code> + <i>accessKey</i></li>\n <li><b>Mozilla Firefox (Mac)</b>: <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Windows, Unix)</b>:  <code>Alt</code> + <i>accessKey</i></li>\n <li><b>Chrome and Safari (Mac)</b>:  <code>Ctrl+Opt</code> + <i>accessKey</i></li>\n </ul>",
        name:"accessKey",
        setter:[
            "setAccessKey"
        ],
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "focus"
        ]
    },
    "attr:DataBoundComponent.showComplexFields":{
        ref:"attr:DataBoundComponent.showComplexFields",
        flags:"IRWA",
        description:"Whether to show fields of non-atomic types when a DataBoundComponent is given a\n DataSource but no <code>component.fields</code>.\n <p>\n If true, the component will show fields that declare a complex type, for example, a\n field 'shippingAddress' that declares type 'Address', where 'Address' is the ID of a\n DataSource that declares the fields of a shipping address (city, street name, etc).\n <P>\n Such fields may need custom formatters or editors in order to create a usable interface,\n for example, an Address field in a ListGrid might use a custom formatter to combine the\n relevant fields of an address into one column, and might use a pop-up dialog for\n editing.",
        name:"showComplexFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "databinding"
        ]
    },
    "method:SelectItem.defaultDynamicValue":{
        ref:"method:SelectItem.defaultDynamicValue",
        flags:"A",
        description:" Expression evaluated to determine the ${isc.DocUtils.linkForRef('attr:SelectItem.defaultValue')} when no value is\n provided for this item. To default to the first option use\n ${isc.DocUtils.linkForRef('attr:SelectItem.defaultToFirstOption')} instead.\n",
        name:"defaultDynamicValue",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:SelectItem"
    },
    "class:TextSettings":{
        methods:[
        ],
        ref:"class:TextSettings",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/System"
        ],
        attrs:[
            "attr:TextSettings.fieldList",
            "attr:TextSettings.fieldSeparator",
            "attr:TextSettings.lineSeparator",
            "attr:TextSettings.escapingMode"
        ],
        description:"Common base class of ${isc.DocUtils.linkForRef('class:TextImportSettings')}.",
        name:"TextSettings",
        seeAlso:[
        ],
        type:"class"
    },
    "classAttr:GroupingMessages.upcomingBeforeTitle":{
        ref:"classAttr:GroupingMessages.upcomingBeforeTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs before\n the current date.",
        name:"upcomingBeforeTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Before\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGrid.isSeparatorProperty":{
        ref:"attr:ListGrid.isSeparatorProperty",
        flags:"IRW",
        description:"If <code>record[this.isSeparatorProperty]</code> is set for some record, the\n record will be displayed as a simple separator row.",
        name:"isSeparatorProperty",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"isSeparator\"",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:TreeGrid.customIconProperty":{
        ref:"attr:TreeGrid.customIconProperty",
        flags:"IRW",
        description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.icon','default node.icon')} property.",
        name:"customIconProperty",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ]
    },
    "method:DataView.dataViewLoaded":{
        ref:"method:DataView.dataViewLoaded",
        flags:"A",
        description:"\n Executed when the dataView has loaded all dependencies (such as DataSources or WebServices).\n No default implementation.\n\n",
        name:"dataViewLoaded",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DataView"
    },
    "attr:HeaderSpan.height":{
        ref:"attr:HeaderSpan.height",
        flags:"IR",
        description:"Height of this headerSpan.  Defaults to ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpanHeight')}.",
        name:"height",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:HeaderSpan",
        groups:[
            "headerSpan"
        ]
    },
    "attr:SectionHeader.showClippedTitleOnHover":{
        ref:"attr:SectionHeader.showClippedTitleOnHover",
        flags:"IRW",
        description:"If true and the title is clipped, then a hover containing the full title of this section header\n is enabled.",
        name:"showClippedTitleOnHover",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SectionHeader",
        groups:[
            "hovers"
        ]
    },
    "method:ColumnTree.getSelectedRecord":{
        ref:"method:ColumnTree.getSelectedRecord",
        flags:"",
        description:" Get the selected record, that is, the parent of the nodes in the rightmost visible column.\n <P>\n This is generally the most recently clicked node unless programmatic navigation has taken\n place.\n <P>\n If only the first column is showing, the root node is returned (which can be detected via\n ${isc.DocUtils.linkForRef('method:Tree.isRoot')}).\n\n",
        name:"getSelectedRecord",
        seeAlso:[
        ],
        returns:{
            description:"the selected record",
            type:"Record"
        },
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:TimeItem.millisecondItemTitle":{
        ref:"attr:TimeItem.millisecondItemTitle",
        flags:"IRW",
        description:"Title to show for the ${isc.DocUtils.linkForRef('attr:TimeItem.millisecondItem','millisecond picker')}.",
        name:"millisecondItemTitle",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Ms\"",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:BlurbItem.clipValue":{
        ref:"attr:BlurbItem.clipValue",
        flags:"IRW",
        description:"If true, text that exceeds the specified size of the form item will be clipped.",
        name:"clipValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:[
            "appearance"
        ]
    },
    "method:Tree.openAll":{
        ref:"method:Tree.openAll",
        flags:"",
        description:"\n Open all nodes under a particular node.\n\n",
        name:"openAll",
        seeAlso:[
        ],
        params:[
            {
                description:"node from which to open folders (if not specified, the root                              node is used)",
                optional:true,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('parentLinking')}"
        ],
        definingClass:"class:Tree"
    },
    "attr:IMenuButton.height":{
        ref:"attr:IMenuButton.height",
        flags:"IRW",
        description:"Default height of the button.",
        name:"height",
        seeAlso:[
        ],
        valueType:"Number or String",
        defaultValue:"22",
        type:"attr",
        definingClass:"class:IMenuButton"
    },
    "attr:TimeItem.invalidTimeStringMessage":{
        ref:"attr:TimeItem.invalidTimeStringMessage",
        flags:"IRW",
        description:"Validation error message to display if the user enters an invalid time string.",
        name:"invalidTimeStringMessage",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Invalid time\"",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "i18nMessages"
        ]
    },
    "class:BooleanItem":{
        methods:[
        ],
        ref:"class:BooleanItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        attrs:[
        ],
        description:"Boolean form item, implemented with customizable checkbox images",
        name:"BooleanItem",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:FormItem.editPendingCSSText":{
        ref:"attr:FormItem.editPendingCSSText",
        flags:"IRWA",
        description:"Custom CSS text to be applied to cells with pending edits that have not yet been\n submitted.",
        name:"editPendingCSSText",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"color:#0066CC;\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGrid.locateRowsBy":{
        ref:"attr:ListGrid.locateRowsBy",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('classMethod:AutoTest.getElement')} is used to parse locator strings generated by\n ${isc.DocUtils.linkForRef('classMethod:AutoTest.getLocator')} for a cell in this grid, how should the row be identified?\n <br>\n Note that getLocator() will actually store all available information about the row in\n the generated string -- this attribute effects how a stored string will be parsed only.\n <P>\n Valid options area:\n <ul>\n <li><code>\"primaryKey\"</code> Only applies to databound grids: If the cell in question has\n  a primary key cell value, use it to identify cells in autoTest locator strings.</li>\n <li><code>\"titleField\"</code> If the cell in question has a value for the\n  ${isc.DocUtils.linkForRef('method:ListGrid.getTitleField','titleField')}, use it to identify cells in autoTest\n  locator strings</li>\n <li><code>\"targetCellValue\"</code> Identify rows by storing the cell value for the target\n  row / field in autoTest locator strings</li>\n <li><code>\"index\"</code>The rowNum will be used to identify the row.</li>\n </ul>\n If unset, default behavior is to identify by primary key (if available), otherwise by\n titleField (if available), otherwise by cell value (if available), and lastly by index.",
        name:"locateRowsBy",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "autoTest"
        ]
    },
    "method:Calendar.addEvent":{
        ref:"method:Calendar.addEvent",
        flags:"",
        description:" Create a new event in this calendar instance.\n\n",
        name:"addEvent",
        seeAlso:[
        ],
        params:[
            {
                description:"start date of event, or CalendarEvent Object",
                optional:false,
                name:"startDate",
                defaultValue:null,
                type:"Date or Object"
            },
            {
                description:"end date of event",
                optional:true,
                name:"endDate",
                defaultValue:null,
                type:"Date"
            },
            {
                description:"name of event",
                optional:true,
                name:"name",
                defaultValue:null,
                type:"String"
            },
            {
                description:"description of event",
                optional:true,
                name:"description",
                defaultValue:null,
                type:"String"
            },
            {
                description:"new values of additional fields to be updated",
                optional:true,
                name:"otherFields",
                defaultValue:null,
                type:"Object"
            }
        ],
        type:"method",
        definingClass:"class:Calendar"
    },
    "method:DataSource.invalidateCache":{
        ref:"method:DataSource.invalidateCache",
        flags:"",
        description:" Invalidate the cache when ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')} or ${isc.DocUtils.linkForRef('attr:DataSource.clientOnly','clientOnly')} are true.\n",
        name:"invalidateCache",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "clientData"
        ]
    },
    "method:ListGrid.getCellStartRow":{
        ref:"method:ListGrid.getCellStartRow",
        flags:"",
        description:" When using ${isc.DocUtils.linkForRef('method:ListGrid.getRowSpan','row spanning')}, returns the row number where a row-spanning cell\n starts.\n <P>\n For example, if row 2 col 0 spans 3 cells, <code>getCellStartRow()</code> for row 2 col 0,\n row 3 col 0, row 4 col 0 will all return 2, because that's the row when spanning starts.\n\n",
        name:"getCellStartRow",
        seeAlso:[
        ],
        params:[
            {
                description:"row number of cell for which the start row should be returned",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"int"
            },
            {
                description:"column number of cell for which the start row should be returned",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"int"
            }
        ],
        returns:{
            description:"row number where spanning starts",
            type:"int"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:DynamicForm.showErrorIcons":{
        ref:"attr:DynamicForm.showErrorIcons",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','showErrorIcons')}, \n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText','showErrorText')}, and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorStyle','showErrorStyle')} control how validation errors are\n displayed when they are displayed inline in the form (next to the form item where there\n is a validation error).  To instead display all errors at the top of the form, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showInlineErrors','showInlineErrors')}:false.\n <P>\n <code>showErrorIcons</code>, <code>showErrorText</code> and <code>showErrorStyle</code>\n are all boolean properties, and can be set on a DynamicForm to control the behavior\n form-wide, or set on individual FormItems.  \n <P>\n The HTML displayed next to a form item with errors is generated by \n ${isc.DocUtils.linkForRef('method:FormItem.getErrorHTML')}.\n The default implementation of that method respects <code>showErrorIcons</code> and\n <code>showErrorText</code> as follows:\n <P>\n <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls\n whether an error icon should appear next to fields which have validation errors.  The icon's\n appearance is governed by ${isc.DocUtils.linkForRef('attr:FormItem.errorIconSrc')}, ${isc.DocUtils.linkForRef('attr:FormItem.errorIconWidth')} and\n ${isc.DocUtils.linkForRef('attr:FormItem.errorIconHeight')}\n <P>\n <code>showErrorText</code> determines whether the text of the validation error should be\n displayed next to fields which have validation errors. The attribute\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showTitlesWithErrorMessages')} may be set to prefix error messages with the \n form item's title + <code>\":\"</code> (may be desired if the item has \n ${isc.DocUtils.linkForRef('attr:FormItem.showTitle')} set to false).\n <P>\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')} controls where the error HTML should appear relative \n to form items. Therefore the combination of ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorText')}<code>:false</code> and\n ${isc.DocUtils.linkForRef('attr:DynamicForm.errorOrientation')}<code>:\"left\"</code> creates a compact validation error display\n consisting of just an icon, to the left of the item with the error message\n available via a hover (similar appearance to ListGrid validation error display).  \n <P>\n In addition to this, <code>showErrorStyle</code> determines whether fields  with validation\n errors should have special styling applied to them. See ${isc.DocUtils.linkForRef('type:FormItemBaseStyle')} for a \n discussion for how error styling is calculated.",
        name:"showErrorIcons",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "validation"
        ]
    },
    "attr:SectionStackSection.icon":{
        ref:"attr:SectionStackSection.icon",
        flags:"IR",
        description:"Base filename of the icon that represents open and closed states. The default settings\n also change the icon for disabled sections, so a total of four images are required\n (opened, closed, Disabled_opened, Disabled_closed).\n <P>\n Not shown if ${isc.DocUtils.linkForRef('attr:SectionStackSection.canCollapse')} is false.",
        name:"icon",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]SectionHeader/opener.gif\"",
        type:"attr",
        definingClass:"object:SectionStackSection"
    },
    "type:DragDataAction":{
        ref:"type:DragDataAction",
        values:[
            {
                description:"Don't do anything, resulting in the same data being in both lists.",
                value:"\"none\""
            },
            {
                description:"Copy the data leaving the original in our list.",
                value:"Canvas.COPY"
            },
            {
                description:"Remove the data from this list so it can be moved into the other list.",
                value:"Canvas.MOVE"
            }
        ],
        description:"What do we do with data that's been dropped into another list?",
        name:"DragDataAction",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "drag"
        ]
    },
    "classAttr:Operators.iContainsPatternTitle":{
        ref:"classAttr:Operators.iContainsPatternTitle",
        flags:"IR",
        description:"Title for the \"iContainsPattern\" operator",
        name:"iContainsPatternTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"contains pattern\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "method:GridRenderer.setFastCellUpdates":{
        ref:"method:GridRenderer.setFastCellUpdates",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:GridRenderer.fastCellUpdates')}. Has no effect in browsers other than\n Internet Explorer.\n",
        name:"setFastCellUpdates",
        seeAlso:[
        ],
        params:[
            {
                description:"whether to enable fastCellUpdates.",
                optional:false,
                name:"fastCellUpdates",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "attr:DateItem.pickerConstructor":{
        ref:"attr:DateItem.pickerConstructor",
        flags:"IR",
        description:"SmartClient class for the ${isc.DocUtils.linkForRef('attr:FormItem.picker')} autoChild displayed to allow the user\n to directly select dates.",
        name:"pickerConstructor",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"DateChooser\"",
        type:"attr",
        definingClass:"class:DateItem"
    },
    "attr:TreeGrid.recordDropAppearance":{
        ref:"attr:TreeGrid.recordDropAppearance",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:TreeGrid.canAcceptDroppedRecords')} is true for this treeGrid, this property governs\n whether the user can drop between, or over records within the grid.\n This controls what ${isc.DocUtils.linkForRef('type:RecordDropPosition')} is passed to the ${isc.DocUtils.linkForRef('method:TreeGrid.recordDrop')}\n event handler.",
        name:"recordDropAppearance",
        seeAlso:[
        ],
        valueType:"RecordDropAppearance",
        defaultValue:"ListGrid.BOTH",
        type:"attr",
        definingClass:"class:TreeGrid"
    },
    "method:ListGrid.scrollToColumn":{
        ref:"method:ListGrid.scrollToColumn",
        flags:"",
        description:" Scroll the grid to specified column such that the row appears near the center of the\n viewport.\n <P>\n See ${isc.DocUtils.linkForRef('method:ListGrid.scrollToCell')} for a full description of how\n this method interacts with incremental loading and rendering of data.\n",
        name:"scrollToColumn",
        seeAlso:[
        ],
        params:[
            {
                description:"Index of the column to scroll into view",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"Horizontal position of scrolled column (optional)",
                optional:true,
                name:"xPosition",
                defaultValue:null,
                type:"Alignment"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "scrolling"
        ]
    },
    "attr:JSONEncoder.skipInternalProperties":{
        ref:"attr:JSONEncoder.skipInternalProperties",
        flags:"IR",
        description:"If true, don't show SmartClient internal properties when encoding and object.",
        name:"skipInternalProperties",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:JSONEncoder"
    },
    "attr:ComboBoxItem.allowEmptyValue":{
        ref:"attr:ComboBoxItem.allowEmptyValue",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ComboBoxItem.addUnknownValues')} is <code>false</code>, this property \n determines whether\n the user can clear the comboBoxItem value, or whether they are constrained to\n choosing one of the available options (in which case clearing the text box will\n simply revert to the last picked value when the user leaves the field).",
        name:"allowEmptyValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:Window.hiliteHeaderSrc":{
        ref:"attr:Window.hiliteHeaderSrc",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Window.showHeaderBackground')} is true, this governs the URL of the image to \n use in the header's highlighted state when the window is ${isc.DocUtils.linkForRef('method:Window.flash','flashed')}",
        name:"hiliteHeaderSrc",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]Window/headerGradient_hilite.gif\" | null",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "appearance",
            "header"
        ]
    },
    "method:DrawKnob.setCenterPoint":{
        ref:"method:DrawKnob.setCenterPoint",
        flags:"",
        description:" Sets the center point of the drawKnob. If the additional <code>drawingCoords</code> attribute\n is passed, coordinates are expected to be already adjusted for drawPane pan and zoom.\n Otherwise coordinates are expected to be absolute pixel coordinates within the drawPane.\n",
        name:"setCenterPoint",
        seeAlso:[
        ],
        params:[
            {
                description:"new x coordinate for this drawKnob",
                optional:false,
                name:"x",
                defaultValue:null,
                type:"integer"
            },
            {
                description:"new y coordinate for this drawKnob",
                optional:false,
                name:"y",
                defaultValue:null,
                type:"integer"
            },
            {
                description:"If specified, <code>x</code> and <code>y</code> values are  expected to be drawing coordinates - already adjusted for any zoom or pan applied to the\n  drawPane.",
                optional:true,
                name:"drawingCoords",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:DrawKnob"
    },
    "method:GridRenderer.cellContextClick":{
        ref:"method:GridRenderer.cellContextClick",
        flags:"A",
        description:" Called when a cell receives a contextclick event.\n\n",
        name:"cellContextClick",
        seeAlso:[
        ],
        params:[
            {
                description:"cell record as returned by getCellRecord",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "method:GridRenderer.rowHover":{
        ref:"method:GridRenderer.rowHover",
        flags:"A",
        description:" Called when the mouse hovers over a row if this.canHover is true. \n  Returning false will suppress the hover text from being shown if this.showHover is true.\n\n",
        name:"rowHover",
        seeAlso:[
            {
                ref:"attr:GridRenderer.canHover",
                description:null
            }
        ],
        params:[
            {
                description:"cell record as returned by getCellRecord",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether to cancel the event (default behavior of showing the hover)",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "method:GridRenderer.cellSelectionChanged":{
        ref:"method:GridRenderer.cellSelectionChanged",
        flags:"A",
        description:" Called when (cell-based) selection changes within this grid.\n\n",
        name:"cellSelectionChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"Array of cells whos selected state was modified.",
                optional:false,
                name:"cellList",
                defaultValue:null,
                type:"array"
            }
        ],
        returns:{
            description:"Returning false will prevent the GridRenderer styling from being updated                      to reflect the selection change.",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "selection"
        ]
    },
    "attr:FilterBuilder.rangeSeparator":{
        ref:"attr:FilterBuilder.rangeSeparator",
        flags:"IR",
        description:"For operators that check that a value is within a range, text to show between the start and\n end input fields for specifying the limits of the range.",
        name:"rangeSeparator",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"and\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGridField.frozen":{
        ref:"attr:ListGridField.frozen",
        flags:"IR",
        description:"Whether this field should be \"frozen\" for the purposes of horizontal scrolling.  See\n ${isc.DocUtils.linkForRef('group:frozenFields')}.",
        name:"frozen",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "frozenFields"
        ]
    },
    "method:StretchImgButton.setAutoFit":{
        ref:"method:StretchImgButton.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[
        ],
        params:[
            {
                description:"New autoFit setting.",
                optional:false,
                name:"autoFit",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:StretchImgButton"
    },
    "method:Canvas.setPadding":{
        ref:"method:Canvas.setPadding",
        flags:"",
        description:" Set the CSS padding of this component, in pixels.  Padding provides space between the border\n and the component's contents.\n <P>\n This property sets the same thickness of padding on every side.  Differing per-side\n padding can be set in a CSS style and applied via ${isc.DocUtils.linkForRef('attr:Canvas.styleName')}.\n <P>\n",
        name:"setPadding",
        seeAlso:[
        ],
        params:[
            {
                description:"new padding in pixels",
                optional:false,
                name:"newPadding",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "appearance"
        ]
    },
    "object:EditNode":{
        methods:[
        ],
        ref:"object:EditNode",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Tools"
        ],
        attrs:[
            "attr:EditNode.defaults",
            "attr:EditNode.type",
            "attr:EditNode.liveObject"
        ],
        description:"An object representing a component that is currently being edited within an\n ${isc.DocUtils.linkForRef('interface:EditContext')}.\n <P>\n An EditNode is essentially a copy of a ${isc.DocUtils.linkForRef('object:PaletteNode')}, initially with the same properties\n as the PaletteNode from which it was generated.  However unlike a PaletteNode, an EditNode \n always has a ${isc.DocUtils.linkForRef('attr:EditNode.liveObject','liveObject')} - the object created from the \n ${isc.DocUtils.linkForRef('attr:PaletteNode.defaults')} or other properties defined on a paletteNode.\n <P>\n Like a Palette, an EditContext may use properties such as ${isc.DocUtils.linkForRef('attr:PaletteNode.icon')} or \n ${isc.DocUtils.linkForRef('attr:PaletteNode.title')} to display EditNodes.\n <P>\n An EditContext generally offers some means of editing EditNodes and, as edits are made,\n updates ${isc.DocUtils.linkForRef('attr:EditNode.defaults')} with the information required to re-create the component.",
        name:"EditNode",
        seeAlso:[
        ],
        type:"object",
        inheritsFrom:"PaletteNode"
    },
    "attr:Tab.iconHeight":{
        ref:"attr:Tab.iconHeight",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:Tab.icon')} is specified, this property may be used to specify a size for the icon",
        name:"iconHeight",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:Tab"
    },
    "attr:ListGrid.titleField":{
        ref:"attr:ListGrid.titleField",
        flags:"IRW",
        getter:[
            "getTitleField"
        ],
        description:"Best field to use for a user-visible title for an individual record from this grid.\n If ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')} is non null, this property may be specified on the\n dataSource instead.\n <p>\n If not explicitly set, titleField looks for fields named \"title\", \"name\", and \"id\"\n in that order.  If a field exists with one of those names, it becomes the titleField.\n If not, then the first field is designated as the titleField.",
        name:"titleField",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"see below",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:ListGrid.rowHasChanges":{
        ref:"method:ListGrid.rowHasChanges",
        flags:"",
        description:" If this listGrid can be edited, this method will return true if the row passed in has been\n edited, but the edits have not yet been saved to the ListGrid's data object.\n <P>\n Note this method will not return true if a record has been marked as\n ${isc.DocUtils.linkForRef('method:ListGrid.markRecordRemoved','removed')}, but has no other changes. Developers can use\n ${isc.DocUtils.linkForRef('method:ListGrid.recordMarkedAsRemoved')} to check for this case.\n\n",
        name:"rowHasChanges",
        seeAlso:[
        ],
        params:[
            {
                description:"index of row to check for changes",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"int"
            }
        ],
        returns:{
            description:"true if the row has changes.",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "method:DrawItem.setLinePattern":{
        ref:"method:DrawItem.setLinePattern",
        flags:"",
        description:" Update linePattern for this drawItem.\n",
        name:"setLinePattern",
        seeAlso:[
        ],
        params:[
            {
                description:"new linePattern to use",
                optional:false,
                name:"pattern",
                defaultValue:null,
                type:"LinePattern"
            }
        ],
        type:"method",
        definingClass:"class:DrawItem"
    },
    "attr:ListGridField.align":{
        ref:"attr:ListGridField.align",
        flags:"IRW",
        description:"Horizontal alignment for field's column header: \"left\", \"right\"\n or \"center\". Applied to the column header title and cells by default. A separate\n alignment for cells can be specified via ${isc.DocUtils.linkForRef('attr:ListGridField.cellAlign')}.<br>\n If null, values are left-aligned. If this field is editable, the\n alignment of cells in the body will also be reflected in any editors for the field.",
        name:"align",
        seeAlso:[
        ],
        valueType:"Alignment",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "appearance"
        ]
    },
    "attr:DrawCurve.endPoint":{
        ref:"attr:DrawCurve.endPoint",
        flags:"IRW",
        description:"End point of the curve",
        name:"endPoint",
        setter:[
            "setEndPoint"
        ],
        seeAlso:[
        ],
        valueType:"Point",
        defaultValue:"[100,100]",
        type:"attr",
        definingClass:"class:DrawCurve"
    },
    "attr:Canvas.mouseStillDownDelay":{
        ref:"attr:Canvas.mouseStillDownDelay",
        flags:"IRWA",
        description:"Amount of time (in milliseconds) between repeated 'mouseStillDown' events for this\n canvas. See ${isc.DocUtils.linkForRef('method:Canvas.mouseStillDown')} for details.",
        name:"mouseStillDownDelay",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "events"
        ]
    },
    "attr:DetailViewer.hiliteIcons":{
        ref:"attr:DetailViewer.hiliteIcons",
        flags:"IR",
        description:"Specifies a list of icons that can be used in ${isc.DocUtils.linkForRef('method:DataBoundComponent.editHilites','hilites')}.\n <P>\n <code>hiliteIcons</code> should be specified as an Array of ${isc.DocUtils.linkForRef('type:SCImgURL')}.\n When present, the hilite editing interface shown when ${isc.DocUtils.linkForRef('method:DataBoundComponent.editHilites')} is called \n will offer the user a drop down for picking one of these icons when defining either a \n simple or advanced hilite rule.\n <P>\n If the user picks an icon, the created hiliting rule will have ${isc.DocUtils.linkForRef('attr:Hilite.icon')} set to \n the chosen icon.  ${isc.DocUtils.linkForRef('attr:DataBoundComponent.hiliteIconPosition')} controls where the icon will \n appear for that field -- the default is that it appears in front of the normal cell content.\n This can also be overriden at the field level.",
        name:"hiliteIcons",
        seeAlso:[
        ],
        valueType:"Array of String",
        defaultValue:"[\"[SKINIMG]/Dialog/notify.png\", \"[SKINIMG]/Dialog/warn.png\", \"[SKINIMG]/actions/approve.png\"]",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "hiliting"
        ]
    },
    "attr:ListGrid.canReorderRecords":{
        ref:"attr:ListGrid.canReorderRecords",
        flags:"IRW",
        description:"Indicates whether records can be reordered by dragging within this listGrid.",
        name:"canReorderRecords",
        setter:[
            "setCanReorderRecords"
        ],
        seeAlso:[
            {
                ref:"attr:ListGridRecord.canDrag",
                description:null
            },
            {
                ref:"attr:ListGridRecord.canAcceptDrop",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragListMove')}",
            "${isc.DocUtils.linkForExampleId('gridsDragReorder')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "dragging"
        ]
    },
    "attr:ListGrid.expansionFieldTrueImage":{
        ref:"attr:ListGrid.expansionFieldTrueImage",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} is set to <code>true</code>, this property\n determines the image to display in the expansion field for expanded rows.\n If unset, the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} will be used.",
        name:"expansionFieldTrueImage",
        seeAlso:[
            {
                ref:"attr:ListGrid.expansionFieldFalseImage",
                description:null
            },
            {
                ref:"attr:ListGrid.expansionFieldImageWidth",
                description:null
            },
            {
                ref:"attr:ListGrid.expansionFieldImageHeight",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "class:DrawLabel":{
        methods:[
            "method:DrawLabel.moveBy",
            "method:DrawLabel.moveTo",
            "method:DrawLabel.getCenter",
            "method:DrawLabel.getBoundingBox",
            "method:DrawLabel.setLineColor",
            "method:DrawLabel.setContents",
            "method:DrawLabel.setFontSize"
        ],
        ref:"class:DrawLabel",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Drawing/DrawItem"
        ],
        attrs:[
            "attr:DrawLabel.knobs",
            "attr:DrawLabel.contents",
            "attr:DrawLabel.left",
            "attr:DrawLabel.top",
            "attr:DrawLabel.alignment",
            "attr:DrawLabel.fontFamily",
            "attr:DrawLabel.fontSize",
            "attr:DrawLabel.fontWeight",
            "attr:DrawLabel.fontStyle",
            "attr:DrawLabel.lineColor",
            "attr:DrawLabel.rotation"
        ],
        description:"DrawItem subclass to render a single-line text label.",
        name:"DrawLabel",
        seeAlso:[
        ],
        type:"class",
        inheritsFrom:"DrawItem"
    },
    "attr:ListGrid.autoFitMaxWidth":{
        ref:"attr:ListGrid.autoFitMaxWidth",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"horizontal\"</code> or <code>\"both\"</code>\n this property provides an upper limit on how far the ListGrid will expand horizontally to\n accommodate its content.\n If content exceeds this width, scrollbars will be introduced as usual.\n In addition to this property, ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxColumns')} allows you to limit\n horizontal expansion based on the number of columns to be rendered.",
        name:"autoFitMaxWidth",
        setter:[
            "setAutoFitMaxWidth"
        ],
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "autoFitData"
        ]
    },
    "method:DataSource.applyFilter":{
        ref:"method:DataSource.applyFilter",
        flags:"",
        description:" Returns records in the passed Array that match the provided filter\n ${isc.DocUtils.linkForRef('type:Criteria','criteria')}. Handles simple or ${isc.DocUtils.linkForRef('object:AdvancedCriteria','advanced')} criteria.\n <P>\n By default:\n <ul>\n <li> any criteria that do not correspond to a DataSource field are ignored\n <li> for simple criteria, any null or empty string criteria are ignored and\n      all other criteria are passed to ${isc.DocUtils.linkForRef('method:DataSource.fieldMatchesFilter')}\n <li> for advanced criteria, each criterion is evaluated via ${isc.DocUtils.linkForRef('method:DataSource.evaluateCriterion')}\n </ul>\n This method is called by ${isc.DocUtils.linkForRef('method:ResultSet.applyFilter')} to provide filtering when a\n ResultSet has a complete cache and filtering can be performed client-side.  You may want\n to override this method in order to mimic the filtering behavior that your server performs.\n\n",
        name:"applyFilter",
        seeAlso:[
        ],
        params:[
            {
                description:"the list of rows",
                optional:false,
                name:"data",
                defaultValue:null,
                type:"Array of Record"
            },
            {
                description:"the filter criteria",
                optional:false,
                name:"criteria",
                defaultValue:null,
                type:"Criteria"
            },
            {
                description:"optional dataSource request properties",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            }
        ],
        returns:{
            description:"the list of matching rows",
            type:"Array"
        },
        type:"method",
        definingClass:"class:DataSource"
    },
    "method:FacetChart.getGradations":{
        ref:"method:FacetChart.getGradations",
        flags:"",
        description:" Return an array of the gradation values used in the current chart.  Pass these values\n to ${isc.DocUtils.linkForRef('method:FacetChart.getXCoord')} / ${isc.DocUtils.linkForRef('method:FacetChart.getYCoord')} (depending on the orientation of the chart)\n to discover the coordinates where gradations are drawn.\n <P>\n This is only allowed to be called when ${isc.DocUtils.linkForRef('method:FacetChart.chartDrawn')} fires.\n\n",
        name:"getGradations",
        seeAlso:[
        ],
        returns:{
            description:"an array of gradation values used in the current chart.",
            type:"Array of float"
        },
        type:"method",
        definingClass:"class:FacetChart"
    },
    "method:TabSet.setCanCloseTabs":{
        ref:"method:TabSet.setCanCloseTabs",
        flags:"",
        description:" Changes this TabSet's ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs','canCloseTabs')} property.\n",
        name:"setCanCloseTabs",
        seeAlso:[
        ],
        params:[
            {
                description:"the new value for canCloseTabs.",
                optional:false,
                name:"canCloseTabs",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "attr:BlurbItem.textBoxStyle":{
        ref:"attr:BlurbItem.textBoxStyle",
        flags:"IRW",
        description:"Base css style for this item.",
        name:"textBoxStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"staticTextItem\"",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:[
            "appearance"
        ]
    },
    "attr:DataBoundComponent.showHiddenFields":{
        ref:"attr:DataBoundComponent.showHiddenFields",
        flags:"IRW",
        description:"Whether to show fields marked <code>hidden:true</code> when a DataBoundComponent is given a\n DataSource but no <code>component.fields</code>.\n <p>\n The <code>hidden</code> property is used on DataSource fields to mark fields that are\n never of meaning to an end user.",
        name:"showHiddenFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "databinding"
        ]
    },
    "method:Window.setTitle":{
        ref:"method:Window.setTitle",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Window.title','title')} that appears in the window ${isc.DocUtils.linkForRef('attr:Window.header','header')}.\n The header will be redrawn if necessary.\n",
        name:"setTitle",
        seeAlso:[
        ],
        params:[
            {
                description:"new title.",
                optional:false,
                name:"newTitle",
                defaultValue:null,
                type:"HTMLString"
            }
        ],
        type:"method",
        definingClass:"class:Window",
        groups:[
            "header"
        ]
    },
    "attr:StatefulCanvas.align":{
        ref:"attr:StatefulCanvas.align",
        flags:"IRW",
        description:"Horizontal alignment of this component's title.",
        name:"align",
        seeAlso:[
        ],
        valueType:"Alignment",
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:StatefulCanvas",
        groups:[
            "appearance"
        ]
    },
    "attr:DataSourceField.canView":{
        ref:"attr:DataSourceField.canView",
        flags:"IR",
        description:"If false, this property indicates that this field is considered \"server only\".  This means:\n <ul>\n <li>Components cannot bind to the field; even if you explicitly add a field with the same \n     name to your ${isc.DocUtils.linkForRef('interface:DataBoundComponent','dataBoundComponent')}, it will be dropped</li>\n <li>If you are using SmartClient Server, the client will never be sent a value for the \n     field</li>\n <li>If you are using SmartClient Server, then similar to ${isc.DocUtils.linkForRef('attr:DataSourceField.canEdit','canEdit')}, no updates\n     to the field are allowed from the client.  If you explicitly add a value for the field \n     to, eg, a record you are passing to ${isc.DocUtils.linkForRef('method:DataSource.updateData')}, the server will strip\n     the value out of the record before processing the update request.\n </ul>\n <code>canView:false</code> is <b>not</b> the same thing as ${isc.DocUtils.linkForRef('attr:DataSourceField.hidden','hidden')}.  Use \n <code>canView:false</code> when you want to prevent the client from ever seeing a field's \n definition or values; use <code>hidden:true</code> if it is fine from a security perspective\n that a field's definition and values are sent to the browser, but the field should not by\n default appear in user interface elements (but could do in some cases, like a special screen\n for advanced users or administrators, for example).\n <p>\n Note that this property must be set explicitly to false to have an effect; a null or \n undefined setting is treated the same as true.\n <P>\n This property is used to implement field-level view security: failing a \n ${isc.DocUtils.linkForRef('attr:DataSourceField.viewRequiresAuthentication','viewRequiresAuthentication')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.viewRequiresRole','viewRequiresRole')} or ${isc.DocUtils.linkForRef('attr:DataSourceField.viewRequires','viewRequires')} test is \n equivalent to setting <code>canView:false</code> on the field (and, indeed, from the \n client's perspective, the field <em>has</em> had <code>canView:false</code> set).",
        name:"canView",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField",
        groups:[
            "componentBinding"
        ]
    },
    "attr:DynamicForm.formSubmitFailedWarning":{
        ref:"attr:DynamicForm.formSubmitFailedWarning",
        flags:"IRWA",
        description:"Warning to display to the user if an attempt to ${isc.DocUtils.linkForRef('method:DynamicForm.submitForm','natively submit')} a\n form is unable to submit to the server. The most common cause for this failure is that the user\n has typed an invalid file-path into an upload type field.",
        name:"formSubmitFailedWarning",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Form was unable to be submitted. The most likely cause for this is an invalid value in an upload field.\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:PickList.useClientFiltering":{
        ref:"attr:PickList.useClientFiltering",
        flags:"IRA",
        description:"For ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource','databound')} items, this property will be passed\n to the generated ResultSet data object for the pickList as ${isc.DocUtils.linkForRef('attr:ResultSet.useClientFiltering')}.\n Setting to false will disable filtering on the client and ensure criteria are\n always passed to the DataSource directly.",
        name:"useClientFiltering",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "attr:DSResponse.endRow":{
        ref:"attr:DSResponse.endRow",
        flags:"R",
        description:"End row of returned server results, when using paged result fetching\n <p>\n Note that startRow and endRow are zero-based - the first record is row zero.",
        name:"endRow",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSResponse",
        groups:[
            "paging"
        ]
    },
    "attr:FormItem.height":{
        ref:"attr:FormItem.height",
        flags:"IRW",
        description:"Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a\n percentage indicating a percentage of the overall form's height, or \"*\" indicating take\n whatever remaining space is available. See the ${isc.DocUtils.linkForRef('group:formLayout')} overview for details.\n <p>\n <smartgwt>If height is specified as a String, getHeight() will return -1.  Use \n +sgwtLink{getHeightAsString()} in this case.<p></smartgwt>    \n For form items having a ${isc.DocUtils.linkForRef('attr:FormItem.showPickerIcon','picker icon')} (e.g. ${isc.DocUtils.linkForRef('class:SelectItem')}, ${isc.DocUtils.linkForRef('class:ComboBoxItem')})\n and ${isc.DocUtils.linkForRef('class:SpinnerItem')}s, if ${isc.DocUtils.linkForRef('group:skinning','spriting')} is enabled, it is not recommended\n to change the height of the form item from the default because the image sprites are set up\n assuming a specific, fixed height of the item. If the item height must be changed, then\n the ${isc.DocUtils.linkForRef('attr:FormItem.pickerIconStyle','pickerIconStyle')} should be changed to a custom CSS style name.\n Or, in the case of ${isc.DocUtils.linkForRef('class:SpinnerItem')}s, the ${isc.DocUtils.linkForRef('attr:FormItemIcon.baseStyle','baseStyle')} and\n ${isc.DocUtils.linkForRef('attr:FormItemIcon.src','src')} of the ${isc.DocUtils.linkForRef('attr:SpinnerItem.increaseIcon')} and ${isc.DocUtils.linkForRef('attr:SpinnerItem.decreaseIcon')}\n AutoChildren should be customized.",
        name:"height",
        seeAlso:[
        ],
        valueType:"int | String",
        defaultValue:"20",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('formLayoutFilling')}"
        ],
        definingClass:"class:FormItem",
        groups:[
            "formLayout"
        ]
    },
    "attr:ProcessElement.nextElement":{
        ref:"attr:ProcessElement.nextElement",
        flags:"IR",
        description:"Next ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} or ${isc.DocUtils.linkForRef('attr:Process.elements','element')} to execute\n after this one completes.  Sequences are checked first. <code>nextElement</code> does\n not need to be specified on most elements if you use\n ${isc.DocUtils.linkForRef('attr:Process.sequences','sequences')}.",
        name:"nextElement",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ProcessElement"
    },
    "attr:ToolStripGroup.body":{
        ref:"attr:ToolStripGroup.body",
        flags:"IR",
        description:"HLayout autoChild that manages multiple VLayouts containing controls.",
        name:"body",
        seeAlso:[
        ],
        valueType:"AutoChild HLayout",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ToolStripGroup"
    },
    "attr:DataSourceField.javaKeyClass":{
        ref:"attr:DataSourceField.javaKeyClass",
        flags:"IR",
        description:"See ${isc.DocUtils.linkForRef('attr:DataSourceField.javaClass')} - when auto-populating of Java Beans / POJOs based on \n inbound DSRequest data, for a field of Map type, <code>javaKeyClass</code> can be used to\n specify a particular concrete class for the map keys.  If not specified, and a concrete\n type cannot be discovered using Java Reflection, <code>java.lang.Object</code> is used.\n\n Note that <code>javaKeyClass</code> take precedence over generics if both are used.",
        name:"javaKeyClass",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField"
    },
    "method:DrawOval.setTop":{
        ref:"method:DrawOval.setTop",
        flags:"",
        description:" Set the top coordinate of the drawOval\n",
        name:"setTop",
        seeAlso:[
        ],
        params:[
            {
                description:"new top coordinate",
                optional:false,
                name:"top",
                defaultValue:null,
                type:"integer"
            }
        ],
        type:"method",
        definingClass:"class:DrawOval"
    },
    "method:EditContext.addNode":{
        ref:"method:EditContext.addNode",
        flags:"",
        description:" Add a new ${isc.DocUtils.linkForRef('object:EditNode')} to the EditContext, under the specified parent.\n <P>\n The EditContext will interrogate the parent and new nodes to determine what field \n within the parent allows a child of this type, and to find a method to add the newNode's \n liveObject to the parentNode's liveObject.  The new relationship will then be stored\n in the tree of EditNodes.\n <P>\n For example, when a Tab is dropped on a TabSet, the field TabSet.tabs is discovered as\n the correct target field via naming conventions, and the method TabSet.addTab() is likewise \n discovered as the correct method to add a Tab to a TabSet.\n\n",
        name:"addNode",
        seeAlso:[
        ],
        params:[
            {
                description:"new node to be added",
                optional:false,
                name:"newNode",
                defaultValue:null,
                type:"EditNode"
            },
            {
                description:"parent to add the new node under.",
                optional:true,
                name:"parentNode",
                defaultValue:null,
                type:"EditNode"
            },
            {
                description:"index within the parent's children array",
                optional:true,
                name:"index",
                defaultValue:null,
                type:"integer"
            },
            {
                description:"the property of the liveParent to which the new node should                                  be added, if not auto-discoverable from the schema",
                optional:true,
                name:"parentProperty",
                defaultValue:null,
                type:"string"
            },
            {
                description:"whether to skip adding the liveObject to the liveParent                                           (default false)",
                optional:true,
                name:"skipParentComponentAdd",
                defaultValue:null,
                type:"Boolean"
            }
        ],
        returns:{
            description:"newNodenode added",
            type:"EditNode"
        },
        type:"method",
        definingClass:"interface:EditContext"
    },
    "method:TreeGrid.getSelectedPaths":{
        ref:"method:TreeGrid.getSelectedPaths",
        flags:"",
        description:" Returns a snapshot of the current selection within this treeGrid as \n a ${isc.DocUtils.linkForRef('type:ListGridSelectedState')} object.<br>\n This object can be passed to ${isc.DocUtils.linkForRef('method:TreeGrid.setSelectedPaths')} to reset this grid's selection\n the current state (assuming the same data is present in the grid).<br>\n",
        name:"getSelectedPaths",
        seeAlso:[
            {
                ref:"method:TreeGrid.setSelectedPaths",
                description:null
            }
        ],
        returns:{
            description:"current state of this grid's selection",
            type:"ListGridSelectedState"
        },
        type:"method",
        definingClass:"class:TreeGrid",
        groups:[
            "viewState"
        ]
    },
    "group:loadXMLSchemaTag":{
        ref:"group:loadXMLSchemaTag",
        title:"&lt;isomorphic:loadXMLSchema&gt;",
        treeLocation:[
            "Java Server Reference/SmartClient JSP Tags"
        ],
        refs:[
        ],
        description:"<i>produces:</i> JavaScript\n <p>\n Load an XML Schema (.xsd) file and create a ${isc.DocUtils.linkForRef('class:SchemaSet')} object representing the loaded\n definitions. This tag works just like ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')}, except it's\n synchronous and the result is server-cacheable.\n <p>\n Note that this JSP tag must be surrounded by &lt;SCRIPT&gt; tags in the JSP because it\n generates JavaScript code.  Like other tags that generate JavaScript code, this tag can be\n used in a JSP that is included from your main page in order to create separate\n cacheability.  For example:\n <pre>\n &lt;SCRIPT SRC=\"myXMLSchemaDefinitions.jsp\"&gt;&lt;/SCRIPT&gt;\n </pre>\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>url</b><br>\n <i>value format</i>: URL or URI\n <i>default value</i>: NONE\n <p>\n This attribute specifies the URL or URI of the XML Schema file to fetch and translate.  This\n can be either a remote URL - e.g: <code>http://host:port/schemaFile.xsd</code> or a relative\n or absolute URI to a file local to this container - e.g: <code>/some/schemaFile.xsd</code>\n or <code>../some/schemaFile.xsd</code>.  If the url is a remote URL, then an HTTP request\n will be made for the file.  If it is local, it will be fetched from disk using standard\n Servlet APIs (<code>ServletContext.getResourceAsStream()</code>).\n <p>\n <b>cache</b><br>\n <i>value format</i>: Integer (number of seconds to cache result)\n <i>default value</i>: 3600 (1 hour)\n <p>\n This attribute specifies the number of seconds for which the fetched XML Schema is cacheable\n on the server.  Fetching an XML Schema file from a remote server can cause a significant\n delay in JSP processing, and XML Schema files rarely change outside of a development\n environment.  Set this value to zero to disable caching.",
        name:"loadXMLSchemaTag",
        seeAlso:[
            {
                ref:"classMethod:XMLTools.loadXMLSchema",
                description:null
            }
        ],
        type:"group",
        requiresModules:[
            "SCServer"
        ]
    },
    "attr:DetailViewerField.timeFormatter":{
        ref:"attr:DetailViewerField.timeFormatter",
        flags:"IRWA",
        description:"Time-format to apply to date type values within this field.  If specified, any\n dates displayed in this field will be formatted as times using the appropriate format.\n This is most commonly only applied to fields specified as type <code>\"time\"</code> though\n if no explicit ${isc.DocUtils.linkForRef('attr:DetailViewerField.dateFormatter')} is specified it will be respected for other \n fields as well.\n <P>\n If unspecified, a timeFormatter may be defined \n ${isc.DocUtils.linkForRef('attr:DetailViewer.timeFormatter','at the component level')} and will be respected by fields\n of type <code>\"time\"</code>.",
        name:"timeFormatter",
        seeAlso:[
        ],
        valueType:"TimeDisplayFormat",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField",
        groups:[
            "appearance"
        ]
    },
    "method:IMenuButton.setShowMenuButtonImage":{
        ref:"method:IMenuButton.setShowMenuButtonImage",
        flags:"",
        description:" Setter for the 'showMenuButtonImage' property - shows/hides the menu button image\n at runtime.\n\n",
        name:"setShowMenuButtonImage",
        seeAlso:[
        ],
        params:[
            {
                description:"Should the image be shown",
                optional:false,
                name:"show",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:IMenuButton"
    },
    "attr:ListGrid.dataFetchMode":{
        ref:"attr:ListGrid.dataFetchMode",
        flags:"IR",
        description:"How to fetch and manage records retrieve from the server.  See ${isc.DocUtils.linkForRef('type:FetchMode')}.\n <P>\n This setting only applies to the ${isc.DocUtils.linkForRef('class:ResultSet')} automatically created by calling\n ${isc.DocUtils.linkForRef('method:ListGrid.fetchData','fetchData()')}.  If a pre-existing ResultSet is passed to setData() instead, it's\n existing setting for ${isc.DocUtils.linkForRef('attr:ResultSet.fetchMode')} applies.",
        name:"dataFetchMode",
        seeAlso:[
        ],
        valueType:"FetchMode",
        defaultValue:"\"paged\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "databinding"
        ]
    },
    "method:TimeItem.setHourValues":{
        ref:"method:TimeItem.setHourValues",
        flags:"A",
        description:" Sets the array of valid ${isc.DocUtils.linkForRef('attr:TimeItem.hourValues','hour values')} to use when\n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.\n <P>Used for limiting available valid Hour values, or when using the TimeItem to record\n duration, rather than time per-se.\n <P> See ${isc.DocUtils.linkForRef('attr:TimeItem.hourMinValue','hourMinValue')}, \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourMaxValue','hourMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourIncrement','hourIncrement')} for another method of controlling the \n content in the hour picker.\n",
        name:"setHourValues",
        seeAlso:[
        ],
        params:[
            {
                description:"array of available Hour values",
                optional:false,
                name:"values",
                defaultValue:null,
                type:"Array of Number"
            }
        ],
        type:"method",
        definingClass:"class:TimeItem"
    },
    "method:FacetChart.setFilled":{
        ref:"method:FacetChart.setFilled",
        flags:"",
        description:" Method to change ${isc.DocUtils.linkForRef('attr:FacetChart.filled','filled')}.\n Use null to apply a default value for the current ${isc.DocUtils.linkForRef('type:ChartType','chartType')}.\n\n",
        name:"setFilled",
        seeAlso:[
        ],
        params:[
            {
                description:"new value",
                optional:false,
                name:"filled",
                defaultValue:null,
                type:"boolean or null"
            }
        ],
        type:"method",
        definingClass:"class:FacetChart"
    },
    "attr:TabBar.breadth":{
        ref:"attr:TabBar.breadth",
        flags:"IRW",
        description:"Breadth of the tabBar (including baseline breadth)",
        name:"breadth",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"21",
        type:"attr",
        definingClass:"class:TabBar"
    },
    "method:ColumnTree.getColumn":{
        ref:"method:ColumnTree.getColumn",
        flags:"A",
        description:" Advanced API - get the ListGrid representing the indicated column.\n",
        name:"getColumn",
        seeAlso:[
        ],
        params:[
            {
                description:"column number, or parent node of the nodes shown in the column",
                optional:false,
                name:"column",
                defaultValue:null,
                type:"int or TreeNode"
            }
        ],
        returns:{
            description:"ListGrid that renders the indicated column, or null if column is not shown",
            type:"ListGrid"
        },
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:TileGrid.tile":{
        ref:"attr:TileGrid.tile",
        flags:"IR",
        getter:[
            "getTile"
        ],
        description:"A TileGrid automatically creates one tile per record in the dataset, via the\n ${isc.DocUtils.linkForRef('type:AutoChild')} pattern.\n <P>\n By default, the ${isc.DocUtils.linkForRef('class:SimpleTile')} class will be used, and will contain content as rendered\n by a ${isc.DocUtils.linkForRef('class:DetailViewer')}, based on the provided ${isc.DocUtils.linkForRef('attr:TileGrid.fields')} (or on the default\n set of fields).\n <P>\n <smartclient>\n To create a completely different appearance, override ${isc.DocUtils.linkForRef('attr:TileGrid.tileConstructor')} with the name\n of the custom SmartClient class to use for each tile.  For example, subclass\n ${isc.DocUtils.linkForRef('class:SimpleTile')} and override ${isc.DocUtils.linkForRef('method:Canvas.getInnerHTML','getInnerHTML()')}, returning custom\n HTML for each tile.\n <pre>\n     isc.defineClass(\"MyCustomTile\", \"SimpleTile\").addProperties({\n        getInnerHTML : function () {\n           return this.Super(\"getInnerHTML\", arguments) +\n                this.getRecord().width + \" x \" + this.getRecord().height;\n        }\n     });\n\n     isc.TileGrid.create({\n        tileConstructor:\"MyCustomTile\"\n     });\n </pre>\n <P>\n Note that you can also override tile behaviors on a per-record basis, via\n ${isc.DocUtils.linkForRef('attr:TileRecord.tileConstructor')} and ${isc.DocUtils.linkForRef('attr:TileRecord.tileProperties')}.\n </smartclient>\n <smartgwt>\n To create a completely different appearance set ${isc.DocUtils.linkForRef('attr:TileGrid.tileConstructor')} to custom Canvas\n class name. You can use SmartGWT classes too with help of Reflection. For example, you can\n extend a DynamicForm with any layout:\n <pre>\n   public class CarTile extends DynamicForm {\n     public CarTile() {\n       StaticTextItem name = new StaticTextItem(\"name\");\n       name.setShowTitle(false);\n       StaticTextItem price = new StaticTextItem(\"price\");\n       price.setShowTitle(false);\n       this.setFields(pictureItem, name, price);\n     }\n   }\n </pre>\n Register the class factory and use it by passing it's class to tileConstructor\n <pre>\n   public interface CarTileMetaFactory extends BeanFactory.MetaFactory {\n     BeanFactory<CarTile> getCarTileFactory();\n   }\n   public void onModuleLoad() {\n     GWT.create(CarTileMetaFactory.class);\n     TileGrid tileGrid = new TileGrid();\n     tileGrid.setTileConstructor(CarTile.class.getName());\n     tileGrid.draw();\n   }\n </pre>\n </smartgwt>",
        name:"tile",
        seeAlso:[
        ],
        valueType:"MultiAutoChild SimpleTile",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TileGrid"
    },
    "attr:SectionStackSection.showClippedTitleOnHover":{
        ref:"attr:SectionStackSection.showClippedTitleOnHover",
        flags:"IRW",
        description:"If true and the title is clipped, then a hover containing the full title of this section header\n is enabled.",
        name:"showClippedTitleOnHover",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"object:SectionStackSection",
        groups:[
            "hovers"
        ]
    },
    "method:ListGrid.getExpansionField":{
        ref:"method:ListGrid.getExpansionField",
        flags:"",
        description:" Returns the specially generated expansion field used when ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} is\n true.\n <P>\n Called during ${isc.DocUtils.linkForRef('method:ListGrid.setFields')}, this method can be overridden to add advanced dynamic\n defaults to the expansion field (call Super, modify the default field returned by Super,\n return the modified field).  Normal customization can be handled by just setting\n ${isc.DocUtils.linkForRef('type:AutoChild')} properties, as mentioned under the docs for ${isc.DocUtils.linkForRef('attr:ListGrid.expansionField')}.\n\n",
        name:"getExpansionField",
        seeAlso:[
        ],
        returns:{
            description:null,
            type:"ListGridField"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "method:Canvas.setShowResizeBar":{
        ref:"method:Canvas.setShowResizeBar",
        flags:"",
        description:" When this Canvas is included as a member in a ${isc.DocUtils.linkForRef('class:Layout')}, dynamically updates whether a \n resizeBar should be shown after this member in the layout, to allow it to be resized.\n <p>\n Whether a resizeBar is actually shown also depends on the \n ${isc.DocUtils.linkForRef('attr:Layout.defaultResizeBars','defaultResizeBars')} attribute of the layout, and whether this\n Canvas is the last layout member.\n",
        name:"setShowResizeBar",
        seeAlso:[
            {
                ref:"attr:Layout.defaultResizeBars",
                description:null
            }
        ],
        params:[
            {
                description:"setting for this.showResizeBar",
                optional:false,
                name:"show",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "layoutMember"
        ]
    },
    "method:ListGrid.setFieldIcon":{
        ref:"method:ListGrid.setFieldIcon",
        flags:"",
        description:" Change the ${isc.DocUtils.linkForRef('attr:ListGridField.icon')} for a field after the grid is created\n",
        name:"setFieldIcon",
        seeAlso:[
        ],
        params:[
            {
                description:"field to update",
                optional:false,
                name:"fieldName",
                defaultValue:null,
                type:"String"
            },
            {
                description:"icon for the field",
                optional:false,
                name:"icon",
                defaultValue:null,
                type:"SCImgURL"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Canvas.getContentElement":{
        ref:"method:Canvas.getContentElement",
        flags:"A",
        description:" Returns the DOM element for this Canvas which contains the ${isc.DocUtils.linkForRef('attr:Canvas.contents')}, or\n for ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas','parent components')}, the DOM elements for any drawn\n children. This method is provided for the \n very rare cases where a programmer needs to examine the DOM hierarchy created by\n a drawn SmartClient component.\n <P>\n Direct manipulation of the DOM elements created by SmartClient components\n is not supported. SmartClient components should be rendered or cleared using\n standard methods such as ${isc.DocUtils.linkForRef('method:Canvas.draw')}, ${isc.DocUtils.linkForRef('method:Canvas.clear')}. If direct\n integration with existing DOM structures is required, this should be achieved via the\n ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} attribute, rather than by attempting to move the\n component's outer element via native browser APIs.<br>\n The content of SmartClient components' DOM elements should also not be directly \n manipulated using native browser APIs - standard methods such as \n ${isc.DocUtils.linkForRef('method:Canvas.setContents')}, ${isc.DocUtils.linkForRef('method:Canvas.addChild')}, ${isc.DocUtils.linkForRef('method:Canvas.removeChild')},\n ${isc.DocUtils.linkForRef('method:Canvas.markForRedraw')} and ${isc.DocUtils.linkForRef('method:Canvas.redraw')} should be used instead.\n <P>\n In some cases, the element returned may match the element returned by\n ${isc.DocUtils.linkForRef('method:Canvas.getOuterElement')}, but this will not always be the case.\n <P>\n If the widget is undrawn, this method will return <code>null</code>.\n\n",
        name:"getContentElement",
        seeAlso:[
        ],
        returns:{
            description:"The outer DOM element for a drawn Canvas.",
            type:"DOMElement"
        },
        type:"method",
        definingClass:"class:Canvas"
    },
    "attr:ListGridField.valueIconSize":{
        ref:"attr:ListGridField.valueIconSize",
        flags:"IRW",
        description:"Default width and height of value icons in this field.\n Takes precedence over valueIconWidth, valueIconHeight and valueIconSize specified at\n the ListGrid level.\n Can be overridden via ${isc.DocUtils.linkForRef('attr:ListGridField.valueIconWidth')} and {ListGridField.valueIconHeight}",
        name:"valueIconSize",
        seeAlso:[
            {
                ref:"attr:ListGrid.valueIconSize",
                description:null
            },
            {
                ref:"attr:ListGridField.valueIconWidth",
                description:null
            },
            {
                ref:"attr:ListGridField.valueIconHeight",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ]
    },
    "object:PortalPosition":{
        methods:[
        ],
        ref:"object:PortalPosition",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout/PortalLayout"
        ],
        attrs:[
            "attr:PortalPosition.colNum",
            "attr:PortalPosition.rowNum",
            "attr:PortalPosition.position"
        ],
        description:"Represents the position of a ${isc.DocUtils.linkForRef('class:Portlet')} within a ${isc.DocUtils.linkForRef('class:PortalLayout')}, indicating the\n column, row, and position within the row.",
        name:"PortalPosition",
        seeAlso:[
        ],
        type:"object"
    },
    "method:FacetChart.formatAxisValue":{
        ref:"method:FacetChart.formatAxisValue",
        flags:"",
        description:" Return the text string to display in ${isc.DocUtils.linkForRef('attr:FacetChart.gradationLabelProperties','gradation labels')}\n given the raw value for the metric displayed on the value axis.\n <p>\n Note that the rendering of values in hovers or via ${isc.DocUtils.linkForRef('attr:FacetChart.showDataValues')} is handled\n by ${isc.DocUtils.linkForRef('method:FacetChart.formatDataValue')}.\n",
        name:"formatAxisValue",
        seeAlso:[
        ],
        params:[
            {
                description:"raw value of the metric",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"whether the raw value is for the horizontal/x-axis (true) or for the vertical/y-axis (false)",
                optional:false,
                name:"forHorizontalAxis",
                defaultValue:null,
                type:"boolean"
            }
        ],
        returns:{
            description:"the text to display.",
            type:"String"
        },
        type:"method",
        definingClass:"class:FacetChart",
        groups:[
            "display_values"
        ]
    },
    "attr:CalendarEvent.startDate":{
        ref:"attr:CalendarEvent.startDate",
        flags:"IRW",
        description:"Date object which represents the start date of a ${isc.DocUtils.linkForRef('object:CalendarEvent')}.\n The name of this field within the CalendarEvent can be changed via\n ${isc.DocUtils.linkForRef('attr:Calendar.startDateField')}",
        name:"startDate",
        seeAlso:[
        ],
        valueType:"Date",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:CalendarEvent"
    },
    "method:TreeGrid.recordDoubleClick":{
        ref:"method:TreeGrid.recordDoubleClick",
        flags:"",
        description:"\n Handle a doubleClick on a tree node - override of ListGrid stringMethod of same name.  If\n the node is a folder, this implementation calls ${isc.DocUtils.linkForRef('method:TreeGrid.toggleFolder')} on it.  If\n the node is a leaf, calls ${isc.DocUtils.linkForRef('method:TreeGrid.openLeaf')} on it.\n \n",
        name:"recordDoubleClick",
        seeAlso:[
            {
                ref:"method:ListGrid.recordDoubleClick",
                description:null
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:Tab.tabSelected":{
        ref:"method:Tab.tabSelected",
        flags:"",
        description:" Optional handler to fire when a tab is selected. As with ${isc.DocUtils.linkForRef('method:TabSet.tabSelected')} this\n method only fires when the tabset is drawn.\n\n",
        name:"tabSelected",
        seeAlso:[
            {
                ref:"method:Tab.tabDeselected",
                description:null
            }
        ],
        params:[
            {
                description:"the tabSet containing the tab.",
                optional:false,
                name:"tabSet",
                defaultValue:null,
                type:"TabSet"
            },
            {
                description:"the index of the newly selected tab",
                optional:false,
                name:"tabNum",
                defaultValue:null,
                type:"integer"
            },
            {
                description:"the newly selected tab's pane if set",
                optional:false,
                name:"tabPane",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"the ID of the newly selected tab",
                optional:false,
                name:"ID",
                defaultValue:null,
                type:"String"
            },
            {
                description:"pointer to the selected tab object",
                optional:false,
                name:"tab",
                defaultValue:null,
                type:"tab"
            },
            {
                description:"the name of the newly selected tab",
                optional:false,
                name:"name",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"object:Tab"
    },
    "method:TreeGrid.folderDrop":{
        ref:"method:TreeGrid.folderDrop",
        flags:"A",
        description:"\n Process a drop of one or more nodes on a TreeGrid folder.\n <P>\n This method can be overridden to provide custom drop behaviors and is a more appropriate\n override point than the lower level ${isc.DocUtils.linkForRef('method:Canvas.drop')} handler.\n <P>\n If this is a self-drop, nodes are simply reordered. An \"update\" operation will\n be submitted to update the ${isc.DocUtils.linkForRef('attr:Tree.parentIdField','parentId')} field of the moved node(s). \n <P>\n For a drop from another widget, ${isc.DocUtils.linkForRef('method:TreeGrid.transferDragData')} is called which,\n depending on the ${isc.DocUtils.linkForRef('attr:TreeGrid.dragDataAction','dragDataAction')} specified on the source\n widget, may either remove the source nodes from the original list (<code>dragDataAction:\"move\"</code>)\n or just provide a copy to this tree (<code>dragDataAction:\"copy\"</code>).\n <P>\n In either case the new row(s) appear in the <code>folder</code> at the <code>index</code>\n specified by the arguments of the same name.\n <P>\n If this grid is databound, the new nodes will be added to the dataset by calling\n ${isc.DocUtils.linkForRef('method:DataSource.addData')}.  Further, if the new nodes were dragged from another\n databound component, and ${isc.DocUtils.linkForRef('attr:DataBoundComponent.addDropValues','addDropValues')}\n is true, ${isc.DocUtils.linkForRef('method:DataBoundComponent.getDropValues','getDropValues')} will be called for every item\n being dropped.\n <P>\n As a special case, if the <code>sourceWidget</code> is also databound and a\n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreignKey')} relationship is declared from the\n <code>sourceWidget</code>'s DataSource to this TreeGrid's DataSource, the interaction will\n be treated as a \"drag recategorization\" use case such as files being placed in folders,\n employees being assigned to teams, etc.  \"update\" DSRequests will be submitted that\n change the foreignKey field in the dropped records to point to the tree folder that was the\n target of the drop.  In this case no change will be made to the Tree data as such, only to\n the dropped records. \n <P>\n For multi-record drops, Queuing is automatically used to combine all DSRequests into a\n single HTTP Request (see QuickStart Guide, Server Framework chapter).  This allows the\n server to persist all changes caused by the drop in a single transaction (and this is\n automatically done when using the built-in server DataSources with Power Edition and\n above).\n <P>\n If these default persistence behaviors are undesirable, return false to cancel them, then\n and implement your own behavior, typically by using grid.updateData() or addData() to add\n new records.\n <p><b>NOTE:</b> the records you receive in this event are the actual Records from the source\n component.  Use ${isc.DocUtils.linkForRef('method:DataSource.copyRecords')} to create a copy before modifying the records\n or using them with updateData() or addData().\n\n",
        name:"folderDrop",
        seeAlso:[
        ],
        params:[
            {
                description:"List of nodes being dropped",
                optional:false,
                name:"nodes",
                defaultValue:null,
                type:"Array of TreeNode"
            },
            {
                description:"The folder being dropped on",
                optional:false,
                name:"folder",
                defaultValue:null,
                type:"TreeNode"
            },
            {
                description:"Within the folder being dropped on, the index at which the drop is                        occurring.  Only passed if ${isc.DocUtils.linkForRef('attr:TreeGrid.canReorderRecords')} is true.",
                optional:false,
                name:"index",
                defaultValue:null,
                type:"int"
            },
            {
                description:"The component that is the source of the nodes (where the nodes                              were dragged from).",
                optional:false,
                name:"sourceWidget",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"optional callback to be fired when the transfer process has                        completed.  The callback will be passed a single parameter \"records\",\n                       the list of nodes actually transferred to this component (it is called\n                       \"records\" because this is logic shared with ${isc.DocUtils.linkForRef('class:ListGrid')})",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"Callback"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('treeDropEvents')}"
        ],
        definingClass:"class:TreeGrid"
    },
    "attr:PickList.pickListMaxWidth":{
        ref:"attr:PickList.pickListMaxWidth",
        flags:"IRW",
        description:"Maximum width for this item's pickList.\n By default if the values displayed in this pickList are wider than the specified\n ${isc.DocUtils.linkForRef('attr:PickList.pickListWidth')} the pickList will render wide enough to accomodate them.\n This property allows the developer to limit how wide the pickList will render.",
        name:"pickListMaxWidth",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"400",
        type:"attr",
        definingClass:"interface:PickList"
    },
    "attr:OperationBinding.lineBreakStyle":{
        ref:"attr:OperationBinding.lineBreakStyle",
        flags:"IR",
        description:"The style of line-breaks to use in the exported output.  See ${isc.DocUtils.linkForRef('type:LineBreakStyle')} for\n more information.",
        name:"lineBreakStyle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:OperationBinding"
    },
    "attr:CubeGrid.alternateRecordStyles":{
        ref:"attr:CubeGrid.alternateRecordStyles",
        flags:"IRW",
        description:"Whether alternating rows should be drawn in alternating styles, in order to create a \"ledger\"\n effect for easier reading.  If enabled, the cell style for alternate rows will have \"Dark\"\n appended to it.",
        name:"alternateRecordStyles",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "appearance"
        ]
    },
    "group:iscServer":{
        ref:"group:iscServer",
        title:"SmartClient Server Summary",
        treeLocation:[
            "Java Server Reference"
        ],
        refs:[
        ],
        description:"The SmartClient Server is a set of Java libraries, servlets and tools that provide the key\n server-side components needed to build a complete application in the modern web\n architecture.\n <P>\n The SmartClient Server can be ${isc.DocUtils.linkForRef('group:iscInstall','integrated')} into any pre-existing Java\n application, and is designed to rapidly connect SmartClient visual components to\n pre-existing Java business logic or persistence engines.  SmartClient's Ajax request\n processing facilities can be easily integrated into Struts Actions,\n ${isc.DocUtils.linkForRef('group:springIntegration','Spring controllers')}, or custom servlets and JSPs.\n <P>\n Alternatively, the SmartClient Server provides a complete SQL and Hibernate-based\n persistence engine for new applications, with out-of-the-box servlets for processing Ajax\n data requests.\n <P>\n The SmartClient Server is optional, and SmartClient's client-side Ajax engine can be\n integrated with any server that provides HTTP access, using XML, JSON, SOAP or proprietary\n data protocols.  However any server in a modern web application will be required to provide\n most or all of the features of the SmartClient Server (described below), and the SmartClient\n Server represents a best-of-breed implementation of these facilities with a long history of\n high-volume production deployments.\n <P>\n <h4>Server enforcement of ${isc.DocUtils.linkForRef('class:Validator','Validators')}</h4>\n <P>\n Data passed from the browser can be automatically validated by the SmartClient Server.\n In contrast, when using ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side integration')},\n data arrives as HTTP params or XML messages, and you must parse values into the correct\n types (eg java.util.Date) and validate them, or use a server framework that does so.\n <P>\n <h4>High Speed Data Delivery / Data Compression</h4>\n <P>\n The SmartClient Server delivers data to and from the browser using a proprietary, maximally\n efficient protocol, providing simple Java APIs for sending and receiving data.\n <P>\n SmartClient's data protocol is:\n <ul>\n <li> automatically compressed: provides 6-8x improvement in bandwidth utilization\n <li> efficient on the server: high speed data serialization for any Java Object\n <li> efficient in the browser: faster than ordinary XML or JSON data delivery\n <li> minimal: facilities for ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields','trimming')} and\n ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','extracting')} only the data you want the browser to see\n </ul>\n <P>\n <h4>Transparent upload support</h4>\n <P>\n SmartClient provides special client and server-side support for ${isc.DocUtils.linkForRef('group:upload','file\\n upload')}, which allows single and multiple-file HTTP uploads to be performed as a background\n Ajax request without reloading the page or launching sub-windows.\n <P>\n Uploaded files arrive at the SmartClient server as Java InputStreams accessible from the\n DSRequest object, and can optionally be automatically stored via SmartClient's SQL\n subsystem.\n <P>\n <h4>Transparent Queuing / \"Batch\" Operations</h4>\n <P>\n Any request transmitted to the SmartClient Server can be combined into a \"queue\" transmitted\n as a single HTTP request, with in-order execution for all queued operations. \n ${isc.DocUtils.linkForRef('classMethod:RPCManager.startQueue','startQueue()')} starts a queue and\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendQueue','sendQueue()')} transmits it; queuing is transparent to the code\n that initiates the individual requests.  This enables:\n <ul>\n <li> re-use of data access operations across different screens\n <li> easy implementation of transaction boundaries\n <li> simplified saving and loading of screens with complex, master-detail views\n <li> guaranteed in-order processing of operations\n <li> more efficient network usage\n </ul>\n <P>\n <h4>Visual Builder</h4>\n <P>\n ${isc.DocUtils.linkForRef('group:visualBuilder','Visual Builder')} is included with the SmartClient Server, and uses\n server features such as automatic SQL binding to provide a rapid prototyping environment.\n <P>\n <h4>Automatic Bi-directional Java &lt; - &gt; JavaScript serialization and translation</h4>\n <P>\n Provides a powerful, type-safe ${isc.DocUtils.linkForRef('attr:RPCRequest.data','data transmission mechanism')} for moving\n data between a Java server and the browser. \n <P>\n Any Java objects, including Java Beans, POJOs, Java Collections, XML DOMs and all Java\n primitives, with any level of nesting, can be automatically serialized and delivered as\n JavaScript Objects to the SmartClient client-side components.\n <P>\n JavaScript Objects existing in the browser can likewise be automatically transmitted to a\n Java Server and translated to Java Objects, with any level of nesting and automatic\n preservation of primitive types.\n <P>\n <h4>SQL and Hibernate connectors</h4>\n <P>\n DataSources of serverType:\"sql\" or serverType:\"hibernate\" can generate and execute queries\n against popular SQL engines or against the Hibernate ORM system, providing SmartClient's\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}s with the four standard CRUD operations (create, retrieve, update,\n delete) without writing any server-side code.  For rapid prototyping, these DataSources can\n even generate SQL tables based on the DataSource declaration, using the\n ${isc.DocUtils.linkForRef('group:adminConsole')} visual tool.\n <P>\n Server-side APIs allow server-side modification of the request before it is executed (for\n example, to enforce security) and post-processing of the request after execution (for\n example, to provide calculated values).\n <P>\n Both serverType:\"sql\" and serverType:\"hibernate\" support the field-operator-value queries\n that can be generated by using the ${isc.DocUtils.linkForRef('class:FilterBuilder')} component (see\n ${isc.DocUtils.linkForExampleId('filterBuilderBracket', 'example')}).\n <P>\n <h4>Rich, Standardized Request / Response protocol</h4>\n <P>\n The SmartClient Server provides a standardized request and response protocol designed for\n data-oriented \"CRUD\" operations (create, retrieve, update, delete).\n <P>\n This standardized protocol automatically handles ${isc.DocUtils.linkForRef('class:DSRequest','request metadata')} (paging\n parameters, requested sort order, original values of data being modified) and\n ${isc.DocUtils.linkForRef('class:DSResponse','response metadata')} (error handling, cache management, session expiration etc).\n <P>\n Similar to the impact of Struts on early web applications, this standardized protocol avoids\n developers in different groups inventing their own incompatible and redundant\n request/response protocols, and allows developers to more easily learn code they didn't\n author.\n <P>\n <h4>Bi-directional XPath binding to Java Objects</h4>\n <P>\n Most UI designs do not directly reflect the underlying Object model and so some degree of\n translation is necessary in order to populate UI components with data and apply user changes\n to the Java Object model.  This is often accomplished with brittle, difficult to understand\n data translation code sprinkled throughout the system, done in a different way for every\n screen or component.\n <P>\n SmartClient provides a standard, ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','XPath-based approach')} to\n adapting any Java-based Object model to the requirements of the UI design.  Data relevant to\n the application UI is centrally extracted in the server-side ${isc.DocUtils.linkForRef('class:DataSource')} layer, so\n that all UI components have a consistent, unified view of the data model for both loading\n <b>and</b> saving data.\n <P>\n <h4>Broadest possible browser support</h4>\n <P>\n The SmartClient Server can compensate for facilities \n ${isc.DocUtils.linkForRef('group:platformDependencies','missing or disabled in certain browsers')},\n including ActiveX being disabled in IE6 and missing XML support in some versions\n of Apple's Safari browser.\n <P>\n <h4>Transparent Proxying</h4>\n <P>\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.sendProxied','Proxying')} allows SmartClient applications to access web\n services, RSS feeds, HTML content and other data services in a secure manner regardless of\n where they are located: across the enterprise or publicly available.\n <P>\n <h4>Optional ${isc.DocUtils.linkForRef('group:networkPerformance','Network Performance')} Module</h4>\n <P>\n Provides:\n <ul>\n <li> compressed delivery of SmartClient runtime, application logic and other assets such as CSS\n <li> ${isc.DocUtils.linkForRef('class:FileLoader','background download')} of SmartClient and other assets for zero\n user-perceived load time\n <li> on-the-fly stripping and combining of JavaScript (application code and data)\n <li> browser cache control\n </ul>\n <P>\n <h4>Optional Messaging Module (aka server push)</h4>\n <P>\n The ${isc.DocUtils.linkForRef('group:messaging','Messaging')} module allows the server to \"push\" messages to the client, without\n client polling, for real-time monitoring/dashboarding applications.",
        name:"iscServer",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:RichTextItem.shouldSaveValue":{
        ref:"attr:RichTextItem.shouldSaveValue",
        flags:"IR",
        description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",
        name:"shouldSaveValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RichTextItem",
        groups:[
            "formValues"
        ]
    },
    "attr:Menu.keyFieldDefaults":{
        ref:"attr:Menu.keyFieldDefaults",
        flags:"IR",
        description:"Default properties for the automatically generated icon column.\n Default object includes properties to set width and to show key for this column.\n <P>\n To modify the behavior or appearance of this column, developers may set\n ${isc.DocUtils.linkForRef('attr:Menu.keyFieldProperties')} at the instance level, or override this\n object at the class level. If overriding this object, we recommend using\n ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults')} rather than replacing this object entirely.\n <P>\n See ${isc.DocUtils.linkForRef('attr:Menu.showKeys')} for an overview of the key column.",
        name:"keyFieldDefaults",
        seeAlso:[
        ],
        valueType:"ListGridField properties",
        defaultValue:"object",
        type:"attr",
        definingClass:"class:Menu"
    },
    "attr:MultiGroupPanel.levelDownButton":{
        ref:"attr:MultiGroupPanel.levelDownButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:ImgButton')} providing a mechanism for moving existing\n group-levels down in the group configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiGroupPanel.levelDownButtonProperties</code> and \n <code>multiGroupPanel.levelDownButtonDefaults</code>.",
        name:"levelDownButton",
        seeAlso:[
        ],
        valueType:"AutoChild ImgButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiGroupPanel"
    },
    "attr:ListGrid.showSelectionCanvas":{
        ref:"attr:ListGrid.showSelectionCanvas",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType','selectionType')} is set to\n <smartclient>\"single\",</smartclient>\n <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE},</smartgwt>\n setting this property to <code>true</code> means selection will be displayed to the\n user with the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionCanvas','selectionCanvas')} and/or\n ${isc.DocUtils.linkForRef('attr:ListGrid.selectionUnderCanvas','selectionUnderCanvas')} rather than with CSS styling.\n <p>\n If <code>showSelectionCanvas</code> is set to <code>true</code>, then the\n <code>selectionUnderCanvas</code> will automatically be enabled unless\n ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectionUnderCanvas','showSelectionUnderCanvas')} is set to <code>false</code>.\n <p>\n NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the\n <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is\n stacked on top of the selected record and this may interfere with event handling in rare\n cases. If no interactive components are shown in the <code>selectionCanvas</code> and it\n simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used\n instead.\n <p>\n With ${isc.DocUtils.linkForRef('attr:ListGrid.canFreezeFields','frozen fields')}, the <code>selectionCanvas</code>\n is displayed only over the non-frozen fields of the selected row.",
        name:"showSelectionCanvas",
        seeAlso:[
            {
                ref:"attr:ListGrid.showSelectionUnderCanvas",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "rowEffects"
        ]
    },
    "attr:UserTask.saveToServer":{
        ref:"attr:UserTask.saveToServer",
        flags:"IR",
        description:"If saveToServer is set then associated form will perform the normal \n ${isc.DocUtils.linkForRef('method:DynamicForm.submit')}\n actions when called (typically from a ${isc.DocUtils.linkForRef('class:SubmitItem')}). By default the form submit\n action is bypassed.",
        name:"saveToServer",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:UserTask"
    },
    "method:Class.map":{
        ref:"method:Class.map",
        flags:"",
        description:"\n Call <code>method</code> on each item in <code>argsList</code> and return the Array of results.\n\n",
        name:"map",
        seeAlso:[
        ],
        params:[
            {
                description:"Name of the method on this instance which should be called on each element of the Array",
                optional:false,
                name:"methodName",
                defaultValue:null,
                type:"string"
            },
            {
                description:"Array of items to call the method on",
                optional:false,
                name:"items",
                defaultValue:null,
                type:"Array"
            }
        ],
        returns:{
            description:"Array of results, one per element in the passed \"items\" Array",
            type:"Array"
        },
        type:"method",
        definingClass:"class:Class"
    },
    "method:DrawPane.getSvgString":{
        ref:"method:DrawPane.getSvgString",
        flags:"",
        description:" Converts this DrawPane to the source of an <code>&lt;svg&gt;</code> element equivalent to the\n current drawing.\n <p>\n In Pro edition and above, the returned string can be used with\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.exportImage')} to download an image, or with server-side APIs in\n com.isomorphic.contentexport.ImageExport to obtain various kinds of images for further\n server-side processing.\n\n",
        name:"getSvgString",
        seeAlso:[
        ],
        returns:{
            description:"the source of an <code>&lt;svg&gt;</code> element.",
            type:"String"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('chartImageExport')}"
        ],
        definingClass:"class:DrawPane"
    },
    "attr:PickListMenu.normalCellHeight":{
        ref:"attr:PickListMenu.normalCellHeight",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} is unset, base style will be derived from\n ${isc.DocUtils.linkForRef('attr:ListGrid.normalBaseStyle')} if this grid has fixed row heights and\n the specified ${isc.DocUtils.linkForRef('attr:ListGrid.cellHeight')} matches this value. Otherwise\n ${isc.DocUtils.linkForRef('attr:ListGrid.tallBaseStyle')} will be used.",
        name:"normalCellHeight",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:PickListMenu"
    },
    "attr:TreeGrid.animateFolderMaxRows":{
        ref:"attr:TreeGrid.animateFolderMaxRows",
        flags:"IRW",
        getter:[
            "getAnimateFolderMaxRows"
        ],
        description:"If ${isc.DocUtils.linkForRef('attr:TreeGrid.animateFolders')} is true for this grid, this number can be set to designate\n the maximum number of rows to animate at a time when opening / closing a folder.",
        name:"animateFolderMaxRows",
        seeAlso:[
            {
                ref:"method:TreeGrid.getAnimateFolderMaxRows",
                description:null
            }
        ],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "animation"
        ]
    },
    "attr:ImgTab.align":{
        ref:"attr:ImgTab.align",
        flags:"IRW",
        description:"Alignment of title text",
        name:"align",
        seeAlso:[
        ],
        valueType:"Alignment",
        defaultValue:"Canvas.CENTER",
        type:"attr",
        definingClass:"class:ImgTab",
        groups:[
            "positioning"
        ]
    },
    "attr:TimeItem.secondValues":{
        ref:"attr:TimeItem.secondValues",
        flags:"IRW",
        getter:[
            "getSecondValues"
        ],
        description:"An array of values to make available in the ${isc.DocUtils.linkForRef('attr:TimeItem.secondItem','second picker')} when\n ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false.\n <P>Used for specifying a limited set of valid Second values, or when using the \n TimeItem to record duration, rather than time per-se.\n <P> See ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')}, \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondIncrement','secondIncrement')} for another method of controlling the \n content in the second picker.",
        name:"secondValues",
        setter:[
            "setSecondValues"
        ],
        seeAlso:[
        ],
        valueType:"Array of Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "method:SectionItem.collapseSection":{
        ref:"method:SectionItem.collapseSection",
        flags:"",
        description:" Collapse a sectionItem, and hide all the items within the section (not including\n the header).\n",
        name:"collapseSection",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:SectionItem"
    },
    "method:GridRenderer.getCellStyle":{
        ref:"method:GridRenderer.getCellStyle",
        flags:"",
        description:" Return the CSS class for a cell. By default this method has the following implementation:<br>\n - return any custom style for the record (see ${isc.DocUtils.linkForRef('attr:GridRenderer.recordCustomStyleProperty')}) \n   if defined.<br>\n - create a style name based on the result of ${isc.DocUtils.linkForRef('method:GridRenderer.getBaseStyle')} and the \n   state of the record.<br>\n The state of the record is indicated by adding a suffix to the base style.\n There are four independent boolean states, which are combined in the order given:\n <ol>\n <li>\"Disabled\" : whether the cell is disabled; enable by setting the \"enabled\" flag on record\n     returned by getCellRecord\n <li>\"Selected\" : whether cell is selected; enable by passing a Selection object as \"selection\"\n <li>\"Over\" : mouse is over this cell; enable with showRollovers\n <li>\"Dark\" : alternating color bands; enable with alternateRowStyles\n </ol>\n For example, with a baseStyle of \"myCell\", a cell which is selected, which the mouse is over,\n and which is in a dark-colored band will get a styleName of myCellSelectedOverDark.\n <p>\n Cell Styles customizable by:\n <ul>\n <li>attaching a custom style to a record by setting \n    <code>record[this.recordCustomStyleProperty]</code> to some valid CSS style name.  \n <li>modifying the base style returned by getBaseStyle() [see that method for further \n     documentation on this]\n <li>overriding this function\n </ul>\n <p>\n \"Selected\" style can be ignored by setting ${isc.DocUtils.linkForRef('attr:GridRenderer.showSelectedStyle')} to false.\n\n",
        name:"getCellStyle",
        seeAlso:[
        ],
        params:[
            {
                description:"record object for this row and column",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"number of the row",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"number of the column",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"CSS style for this cell",
            type:"CSSStyleName"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "appearance"
        ]
    },
    "group:menuKeys":{
        ref:"group:menuKeys",
        refs:[
            "attr:MenuItem.keys",
            "attr:MenuItem.keyTitle"
        ],
        name:"menuKeys",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:PortalLayout.column":{
        ref:"attr:PortalLayout.column",
        flags:"A",
        description:"Automatically generated vertical ${isc.DocUtils.linkForRef('class:Layout')} used to create columns of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} via\n ${isc.DocUtils.linkForRef('method:Class.createAutoChild','createAutoChild()')}. Since this is an ${isc.DocUtils.linkForRef('type:AutoChild')}, you can use \n columnDefaults and columnProperties to customize the columns.\n <p>\n The column includes a menu, if ${isc.DocUtils.linkForRef('attr:PortalLayout.showColumnMenus','showColumnMenus')} is true, and a ${isc.DocUtils.linkForRef('attr:PortalLayout.rowLayout','rowLayout')} which\n actually contains the ${isc.DocUtils.linkForRef('attr:PortalLayout.row','rows')}. Therefore, if you want to style the columns as a whole,\n use columnDefaults or columnProperties, but if you want to style the layout that contains the\n rows, use rowLayoutDefaults or rowLayoutProperties.",
        name:"column",
        seeAlso:[
            {
                ref:"attr:PortalLayout.rowLayout",
                description:null
            },
            {
                ref:"attr:PortalLayout.row",
                description:null
            }
        ],
        valueType:"MultiAutoChild Layout",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PortalLayout"
    },
    "method:Canvas.setDragTracker":{
        ref:"method:Canvas.setDragTracker",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance')} is set to <code>\"tracker\"</code>, this method will be called\n (if defined), when the user starts to drag this widget. It is an opportunity to update the\n drag tracker to display something relative to this canvas.  Typical implementation will\n be to call ${isc.DocUtils.linkForRef('classMethod:EventHandler.setDragTracker')}, passing in the desired custom tracker HTML\n as a string\n",
        name:"setDragTracker",
        seeAlso:[
        ],
        returns:{
            description:"Return false to suppress bubbling, and prevent <code>setDragTracker()</code>                      from being called on this widget's ancestors.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragTracker')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ]
    },
    "attr:Canvas.shrinkElementOnHide":{
        ref:"attr:Canvas.shrinkElementOnHide",
        flags:"IRWA",
        description:"This is an advanced setting. If set to <code>true</code>, when a widget is\n ${isc.DocUtils.linkForRef('method:Canvas.hide','hidden')}, the widget's handle will be resized such that\n it takes up no space, in addition to having its css <code>visibility</code>\n property set to <code>\"hidden\"</code>.\n <P>\n In addition to preventing the size of this widget from impacting the\n ${isc.DocUtils.linkForRef('method:Canvas.getScrollWidth','scroll size')} of any parent widget while hidden, this\n setting works around a native bug observed in Internet Explorer 10, whereby\n an <code>&lt;IFRAME&gt;</code> element with visibility set to hidden can\n cause rendering problems, if the HTML loaded by the <code>&lt;IFRAME&gt;</code>\n contains a <code>&lt;frameset&gt;</code>. In this case the browser may\n refuse to draw other elements at the same coordinates with a lower z-index than\n the hidden frame. Setting this property to <code>true</code> works around\n this problem for cases where an <code>&lt;IFRAME&gt;</code> containing a\n <code>&lt;frameset</code> will be rendered out, for example in an\n ${isc.DocUtils.linkForRef('class:HTMLFlow')} with <code>contentsType</code> set to <code>\"page\"</code>.",
        name:"shrinkElementOnHide",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "visibility"
        ]
    },
    "method:ListGrid.setAutoFitWidthApproach":{
        ref:"method:ListGrid.setAutoFitWidthApproach",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitWidthApproach')}.\n",
        name:"setAutoFitWidthApproach",
        seeAlso:[
        ],
        params:[
            {
                description:"new AutoFitWidth approach",
                optional:false,
                name:"approach",
                defaultValue:null,
                type:"AutoFitWidthApproach"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "classMethod:RPCManager.startQueue":{
        ref:"classMethod:RPCManager.startQueue",
        flags:"",
        description:"\n Start queuing requests.  When queuing requests, an HTTP request will not be sent to\n the server until RPCManager.sendQueue() is called.\n <p>\n All requests in a given queue must go to the same actionURL and use the same transport\n (XMLHttp or frames).  If a request specifies a different actionURL or transport than\n that of the requests currently on the queue, it will be sent to the server separately,\n ahead of the queue, and a warning will be logged to the Developer Console.\n <p>\n Note that the server must process all requests sent as part of the queue before any\n response is sent to the client.  You should avoid batching a request that will take a\n long time to process on the server with any other requests because it will delay the\n response of all requests in the queue.\n\n",
        name:"startQueue",
        seeAlso:[
            {
                ref:"classMethod:RPCManager.sendQueue",
                description:null
            }
        ],
        params:[
            {
                description:"whether queuing should be enabled, default true.  Passing false                      will disable queuing but not send the queue yet, so that any\n                      queued requests will be sent along with the next\n                      send()/sendRequest()",
                optional:true,
                name:"shouldQueue",
                defaultValue:null,
                type:"boolean"
            }
        ],
        returns:{
            description:"whether queuing was already enabled before we called",
            type:"boolean"
        },
        type:"classMethod",
        definingClass:"class:RPCManager",
        requiresModules:[
            "SCServer"
        ]
    },
    "attr:AdvancedHiliteEditor.invalidHilitePrompt":{
        ref:"attr:AdvancedHiliteEditor.invalidHilitePrompt",
        flags:"IR",
        description:"The message to show when the user clicks \"Save\" without entering any criteria.",
        name:"invalidHilitePrompt",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Enter at least one rule, a color or icon, and a target field, or press 'Cancel' to abandon changes.\"",
        type:"attr",
        definingClass:"class:AdvancedHiliteEditor",
        groups:[
            "i18nMessages"
        ]
    },
    "method:JSONEncoder.encodeDate":{
        ref:"method:JSONEncoder.encodeDate",
        flags:"",
        description:" Encode a JavaScript Date value.\n <P>\n By default, follows the ${isc.DocUtils.linkForRef('attr:JSONEncoder.dateFormat')} setting.  <smartclient>Override to do\n custom encoding.</smartclient><smartgwt>To override the date format, all Dates should be\n converted to Strings beforehand.</smartgwt>\n \n",
        name:"encodeDate",
        seeAlso:[
        ],
        params:[
            {
                description:"JavaScript date object to be serialized",
                optional:false,
                name:"theDate",
                defaultValue:null,
                type:"Date"
            }
        ],
        returns:{
            description:"value to be included in result.  <b>If this value is intended to appear                  as a String it should include quotes (\")</b>",
            type:"String"
        },
        type:"method",
        definingClass:"class:JSONEncoder"
    },
    "attr:DetailViewer.configureFieldsText":{
        ref:"attr:DetailViewer.configureFieldsText",
        flags:"IR",
        description:"The title for the Configure Fields menu item.",
        name:"configureFieldsText",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Configure Fields...\"",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "i18nMessages"
        ]
    },
    "method:DateItem.formatEditorValue":{
        ref:"method:DateItem.formatEditorValue",
        flags:"A",
        description:" Convert this item's data value to a text value for display in this item's\n text field.\n <P>\n If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is true, entirely custom date formatting and\n parsing logic may be applied via overrides to ${isc.DocUtils.linkForRef('method:DateItem.parseEditorValue')} and\n ${isc.DocUtils.linkForRef('method:DateItem.formatEditorValue')}. These methods apply to this FormItem only - \n system-wide Date and Datetime formatting and parsing may also be customized via\n the APIs on the ${isc.DocUtils.linkForRef('class:Date')} class. See ${isc.DocUtils.linkForRef('group:dateFormatAndStorage')} for more\n on this.\n <P>\n Note: custom formatting for this item may also be achieved via the\n ${isc.DocUtils.linkForRef('attr:DateItem.dateFormatter')} which allows you to directly specify various standard\n date display formats.\n",
        name:"formatEditorValue",
        seeAlso:[
        ],
        params:[
            {
                description:"Underlying data value to format. May be null.",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"The record currently being edited by this form.      Essentially the form's current values object.",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"pointer to the DynamicForm",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            },
            {
                description:"pointer to the FormItem",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            }
        ],
        returns:{
            description:"display value to show in the editor.",
            type:"string"
        },
        type:"method",
        definingClass:"class:DateItem"
    },
    "attr:FormItem.showIcons":{
        ref:"attr:FormItem.showIcons",
        flags:"IRWA",
        description:"Set to false to suppress writing out any ${isc.DocUtils.linkForRef('attr:FormItem.icons')} for this item.",
        name:"showIcons",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formIcons"
        ]
    },
    "attr:LoginDialog.loginFailureItem":{
        ref:"attr:LoginDialog.loginFailureItem",
        flags:"IR",
        description:"Field item containing login error message (if required) in ${isc.DocUtils.linkForRef('attr:LoginDialog.loginForm')}.",
        name:"loginFailureItem",
        seeAlso:[
        ],
        valueType:"AutoChild BlurbItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:LoginDialog"
    },
    "classMethod:Validator.addValidators":{
        ref:"classMethod:Validator.addValidators",
        flags:"A",
        description:"  Add several new validator types at once, as though ${isc.DocUtils.linkForRef('classMethod:Validator.addValidator')} were called\n  several times.\n \n",
        name:"addValidators",
        seeAlso:[
            {
                ref:"classMethod:Validator.addValidator",
                description:null
            }
        ],
        params:[
            {
                description:"Set of validators to add.  This parameter should      be a JavaScript object where the property names are validator type names, and the\n      property values are condition functions or expressions, for example:<br>\n      &nbsp;&nbsp;&nbsp;<code>{type1:condition1, type2:condition2}</code><br>.",
                optional:false,
                name:"newValidators",
                defaultValue:null,
                type:"object"
            }
        ],
        type:"classMethod",
        definingClass:"class:Validator",
        groups:[
            "validation"
        ]
    },
    "method:TreeGrid.getExtraIcon":{
        ref:"method:TreeGrid.getExtraIcon",
        flags:"A",
        description:" Get an additional icon to show between the open icon and folder/node icon for a particular \n node.\n <P>\n NOTE: If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionAppearance')} is <code>\"checkbox\"</code>, this method will\n NOT be called. Extra icons cannot be shown for that appearance.\n\n",
        name:"getExtraIcon",
        seeAlso:[
        ],
        params:[
            {
                description:"tree node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"URL for the extra icon (null if none required)",
            type:"URL"
        },
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "attr:ListGrid.fieldVisibilitySubmenuTitle":{
        ref:"attr:ListGrid.fieldVisibilitySubmenuTitle",
        flags:"IRW",
        description:"If we're showing a ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','headerContextMenu')} for this grid, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields','this.canPickFields')} is true, this\n attribute will be shown as the title for the menu item which contains a submenu with items\n allowing the user to show and hide fields in the grid.",
        name:"fieldVisibilitySubmenuTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Columns\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DSRequest.exportFields":{
        ref:"attr:DSRequest.exportFields",
        flags:"IR",
        description:"The list of field-names to export.  If provided, the field-list in the exported output is \n limited and sorted as per the list.\n <P>\n If exportFields is not provided, the exported output includes all visible fields \n from the DataSource (field.hidden=false), sorted in the order they're defined.",
        name:"exportFields",
        seeAlso:[
        ],
        valueType:"Array of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:Window.headerSrc":{
        ref:"attr:Window.headerSrc",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Window.showHeaderBackground')} is <code>true</code>, this property provides\n the URL of the background image for the header.",
        name:"headerSrc",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]Window/headerGradient.gif\" | null",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "appearance",
            "header"
        ]
    },
    "method:Array.clearProperty":{
        ref:"method:Array.clearProperty",
        flags:"",
        description:" Delete property in each item in this array.\n",
        name:"clearProperty",
        seeAlso:[
        ],
        params:[
            {
                description:"name of the property to clear",
                optional:false,
                name:"property",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"returns true if any of the properties in the array had a value for the     specified property.",
            type:"boolean"
        },
        type:"method",
        definingClass:"object:Array",
        groups:[
            "iteration"
        ]
    },
    "attr:FacetValue.width":{
        ref:"attr:FacetValue.width",
        flags:"IR",
        description:"Width of the cube grid facetValue in pixels.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.",
        name:"width",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"facet.width",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "classMethod:AutoTest.getObject":{
        ref:"classMethod:AutoTest.getObject",
        flags:"",
        description:" Given an ${isc.DocUtils.linkForRef('type:AutoTestLocator')}, return the live SmartClient object it refers to, if any.\n",
        name:"getObject",
        seeAlso:[
        ],
        params:[
            {
                description:"Locator String previously returned by        ${isc.DocUtils.linkForRef('classMethod:AutoTest.getLocator')}",
                optional:false,
                name:"locator",
                defaultValue:null,
                type:"AutoTestLocator"
            }
        ],
        returns:{
            description:"target object, or null if  unable to resolve the locator to a live object.",
            type:"Canvas or FormItem or SectionStackSection"
        },
        type:"classMethod",
        definingClass:"class:AutoTest",
        groups:[
            "autoTest"
        ]
    },
    "attr:ListGrid.isGrouped":{
        ref:"attr:ListGrid.isGrouped",
        flags:"R",
        description:"True if this listgrid is grouped, false otherwise",
        name:"isGrouped",
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "grouping"
        ]
    },
    "attr:RelativeDateItem.showFutureOptions":{
        ref:"attr:RelativeDateItem.showFutureOptions",
        flags:"IR",
        description:"Should we show time-unit options in the future? If set to false, for each \n ${isc.DocUtils.linkForRef('attr:RelativeDateItem.timeUnitOptions','timeUnitOption')} we will show only past options [for example\n \"N weeks ago\"].\n <P>\n Note: this does not change the ${isc.DocUtils.linkForRef('attr:RelativeDateItem.presetOptions')}, which show up in \n addition to the time-unit options (<i>\"N days from now\"</i>, etc). The default\n preset options include both past and future presets so developers may wish to modify the\n presets to ensure only future options are available.",
        name:"showFutureOptions",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RelativeDateItem"
    },
    "attr:TabSet.tabBarPosition":{
        ref:"attr:TabSet.tabBarPosition",
        flags:"IR",
        description:"Which side of the TabSet the TabBar should appear on.",
        name:"tabBarPosition",
        seeAlso:[
        ],
        valueType:"Side",
        defaultValue:"Canvas.TOP",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('tabsOrientation')}"
        ],
        definingClass:"class:TabSet",
        groups:[
            "tabBar"
        ]
    },
    "method:FormItem.valueClipped":{
        ref:"method:FormItem.valueClipped",
        flags:"",
        description:" Is the value clipped?\n <p>\n The form item must have value clipping enabled. If a form item type supports the\n clipValue attribute, then clipValue must be true. ${isc.DocUtils.linkForRef('class:TextItem')}s and derivatives\n (e.g. ${isc.DocUtils.linkForRef('class:SpinnerItem')}) automatically clip their values.\n\n",
        name:"valueClipped",
        seeAlso:[
        ],
        returns:{
            description:"true if the value is clipped; false otherwise.",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:FormItem"
    },
    "attr:ComboBoxItem.completeOnTab":{
        ref:"attr:ComboBoxItem.completeOnTab",
        flags:"IRW",
        description:"If true, when the pickList is showing, the user can select the current value by hitting\n the <code>Tab</code> key.\n <P>\n Note that <code>completeOnTab</code> is not compatible with ${isc.DocUtils.linkForRef('attr:ComboBoxItem.formatOnBlur')}",
        name:"completeOnTab",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:Tree.pathDelim":{
        ref:"attr:Tree.pathDelim",
        flags:"IRWA",
        description:"Specifies the delimiter between node names.  The pathDelim is used to construct a unique\n path to each node. A path can be obtained for any node by calling\n ${isc.DocUtils.linkForRef('method:Tree.getPath')} and can be used to find any node in the tree by calling\n ${isc.DocUtils.linkForRef('method:Tree.find')}.  Note that you can also hand-construct a path - in other words\n you are not required to call ${isc.DocUtils.linkForRef('method:Tree.getPath')} in order to later use\n ${isc.DocUtils.linkForRef('method:Tree.find')} to retrieve it.\n <br><br>\n The pathDelim can be any character or sequence of characters, but must be a unique string\n with respect to the text that can appear in the ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} that's used\n for naming the nodes.  So for example, if you have the following tree:\n <pre>\n one\n   two\n     three/four\n </pre>\n Then you will be unable to find the <code>three/four</code> node using\n ${isc.DocUtils.linkForRef('method:Tree.find')} if your tree is using the default pathDelim of /.\n In such a case, you can use a different pathDelim for the tree.  For example if you used |\n for the path delim, then you can find the <code>three/four</code> node in the tree above by\n calling <code>tree.find(\"one|two|three/four\")</code>.\n <br><br>\n The pathDelim is used only by ${isc.DocUtils.linkForRef('method:Tree.getPath')} and ${isc.DocUtils.linkForRef('method:Tree.find')} and\n does not affect any aspect of the tree structure or other forms of tree navigation (such as\n via ${isc.DocUtils.linkForRef('method:Tree.getChildren')}).",
        name:"pathDelim",
        seeAlso:[
            {
                ref:"attr:Tree.nameProperty",
                description:null
            },
            {
                ref:"method:Tree.find",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"\"/\"",
        type:"attr",
        definingClass:"class:Tree"
    },
    "method:FormItem.blurItem":{
        ref:"method:FormItem.blurItem",
        flags:"",
        description:"\t\t\tTakes focus from this form item's focusable element.\n",
        name:"blurItem",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:FormItem",
        groups:[
            "eventHandling",
            "focus"
        ]
    },
    "attr:ComboBoxItem.cachePickListResults":{
        ref:"attr:ComboBoxItem.cachePickListResults",
        flags:"IR",
        description:"For databound pickLists (see ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource')}), by default SmartClient\n will cache and re-use datasets shown by different pickLists displayed by different\n SelectItems in an LRU (least recently used) caching pattern.\n <P>\n Setting this flag to false avoids this caching for situations where it is too\n aggressive.\n <p>\n Note that this does not control re-use of data <b>within a single pickList</b>.  To\n control when client-side filtering is used in ComboBoxItem, see\n ${isc.DocUtils.linkForRef('attr:ComboBoxItem.useClientFiltering')} and ${isc.DocUtils.linkForRef('attr:ComboBoxItem.filterLocally')}.",
        name:"cachePickListResults",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:TileLayout.autoWrapLines":{
        ref:"attr:TileLayout.autoWrapLines",
        flags:"IR",
        description:"When ${isc.DocUtils.linkForRef('type:LayoutPolicy')} is \"flow\", should we automatically start a new line when there's\n not enough room to fit the next tile on the same line?\n <P>\n If set to false, a new line will only be started if a tile specifies tile.startLine or\n tile.endLine.",
        name:"autoWrapLines",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "layoutPolicy"
        ]
    },
    "attr:FormulaBuilder.defaultNewFieldTitle":{
        ref:"attr:FormulaBuilder.defaultNewFieldTitle",
        flags:"IRWA",
        description:"The default value for new Formula and Summary fields.",
        name:"defaultNewFieldTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"New Field\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGrid.canDragRecordsOut":{
        ref:"attr:ListGrid.canDragRecordsOut",
        flags:"IRW",
        description:"Indicates whether records can be dragged from this listGrid and dropped elsewhere.",
        name:"canDragRecordsOut",
        seeAlso:[
            {
                ref:"attr:ListGridRecord.canDrag",
                description:null
            },
            {
                ref:"attr:ListGridRecord.canAcceptDrop",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragListMove')}",
            "${isc.DocUtils.linkForExampleId('recordsAcrossWindows')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "dragging"
        ]
    },
    "method:DataBoundComponent.setHiliteState":{
        ref:"method:DataBoundComponent.setHiliteState",
        flags:"",
        description:" Set the current hilites based on a hiliteState String previously returned from\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.getHiliteState')}.\n",
        name:"setHiliteState",
        seeAlso:[
        ],
        params:[
            {
                description:"hilites state encoded as a String",
                optional:false,
                name:"hiliteState",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "viewState"
        ]
    },
    "classMethod:Page.unregisterKey":{
        ref:"classMethod:Page.unregisterKey",
        flags:"",
        description:" Clears an action registered to fire on a specific a keyPress event via the ${isc.DocUtils.linkForRef('classMethod:Page.registerKey')}\n method. \n",
        name:"unregisterKey",
        seeAlso:[
            {
                ref:"classMethod:Page.registerKey",
                description:null
            }
        ],
        params:[
            {
                description:"Name of key to clear registry entries for.",
                optional:false,
                name:"actionID",
                defaultValue:null,
                type:"KeyName"
            },
            {
                description:"target specified when the action was registered for the key.",
                optional:true,
                name:"target",
                defaultValue:null,
                type:"object"
            }
        ],
        type:"classMethod",
        definingClass:"class:Page",
        groups:[
            "KeyRegistry"
        ]
    },
    "attr:HiliteRule.iconFieldTitle":{
        ref:"attr:HiliteRule.iconFieldTitle",
        flags:"IR",
        description:"The ${isc.DocUtils.linkForRef('attr:FormItem.title','title')} of the 'Icon' picker.",
        name:"iconFieldTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Icon\"",
        type:"attr",
        definingClass:"class:HiliteRule",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Window.modalMask":{
        ref:"attr:Window.modalMask",
        flags:"R",
        description:"A ScreenSpan instance used to darken the rest of a page when a modal window is\n active. To use, set ${isc.DocUtils.linkForRef('attr:Window.showModalMask')} to true, add a CSS style \n \"modalMask\" to the active skin (generally with background-color set), \n and adjust ${isc.DocUtils.linkForRef('attr:Window.modalMaskOpacity')}.",
        name:"modalMask",
        seeAlso:[
        ],
        valueType:"AutoChild Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "modal",
            "appearance"
        ]
    },
    "attr:ListGrid.recordEnabledProperty":{
        ref:"attr:ListGrid.recordEnabledProperty",
        flags:"IR",
        description:"Property name on a record that will be checked to determine whether a record is enabled.\n <P>\n Setting this property on a record will effect the visual style and interactivity of\n the record.  If set to <code>false</code> the record (row in a ${isc.DocUtils.linkForRef('class:ListGrid')} or\n ${isc.DocUtils.linkForRef('class:TreeGrid')}) will not highlight when the mouse moves over it, nor will it respond to\n mouse clicks.",
        name:"recordEnabledProperty",
        seeAlso:[
            {
                ref:"attr:ListGridRecord.enabled",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"\"enabled\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('disabledRows')}"
        ],
        definingClass:"class:ListGrid"
    },
    "class:ValuesManager":{
        methods:[
            "method:ValuesManager.editNewRecord",
            "method:ValuesManager.editRecord",
            "method:ValuesManager.setSaveOperationType",
            "method:ValuesManager.isNewRecord",
            "method:ValuesManager.getSaveOperationType",
            "method:ValuesManager.editSelectedData",
            "method:ValuesManager.saveData",
            "method:ValuesManager.submit",
            "method:ValuesManager.cancel",
            "method:ValuesManager.filterData",
            "method:ValuesManager.fetchData",
            "method:ValuesManager.synchronizeMembers",
            "method:ValuesManager.setDataSource",
            "method:ValuesManager.getDataSource",
            "method:ValuesManager.getItem",
            "method:ValuesManager.getMembers",
            "method:ValuesManager.getMember",
            "method:ValuesManager.getMemberForField",
            "method:ValuesManager.validate",
            "method:ValuesManager.getValidatedValues",
            "method:ValuesManager.setErrors",
            "method:ValuesManager.addFieldErrors",
            "method:ValuesManager.setFieldErrors",
            "method:ValuesManager.clearErrors",
            "method:ValuesManager.clearFieldErrors",
            "method:ValuesManager.getErrors",
            "method:ValuesManager.getFieldErrors",
            "method:ValuesManager.hasErrors",
            "method:ValuesManager.hasFieldErrors",
            "method:ValuesManager.showErrors",
            "method:ValuesManager.showFieldErrors",
            "method:ValuesManager.getValues",
            "method:ValuesManager.setValues",
            "method:ValuesManager.clearValues",
            "method:ValuesManager.getMemberValues",
            "method:ValuesManager.setMemberValues",
            "method:ValuesManager.rememberValues",
            "method:ValuesManager.getOldValues",
            "method:ValuesManager.getChangedValues",
            "method:ValuesManager.resetValues",
            "method:ValuesManager.valuesHaveChanged",
            "method:ValuesManager.getValue",
            "method:ValuesManager.setValue",
            "method:ValuesManager.clearValue",
            "method:ValuesManager.addMember",
            "method:ValuesManager.addMembers",
            "method:ValuesManager.removeMember",
            "method:ValuesManager.removeMembers",
            "method:ValuesManager.handleHiddenValidationErrors",
            "method:ValuesManager.submitValues"
        ],
        exampleConfig:"ValuesManager.xml",
        ref:"class:ValuesManager",
        classAttrs:[
        ],
        classMethods:[
            "classMethod:ValuesManager.getById"
        ],
        treeLocation:[
            "Client Reference/Forms"
        ],
        attrs:[
            "attr:ValuesManager.saveOperationType",
            "attr:ValuesManager.suppressValidationErrorCallback",
            "attr:ValuesManager.dataSource",
            "attr:ValuesManager.addOperation",
            "attr:ValuesManager.updateOperation",
            "attr:ValuesManager.removeOperation",
            "attr:ValuesManager.members",
            "attr:ValuesManager.disableValidation",
            "attr:ValuesManager.autoSynchronize"
        ],
        description:"The ValuesManager manages data from multiple member forms.\n <P>\n If a single logical form needs to be separated into multiple DynamicForm instances for\n Layout purposes (for example, spanning one logical form across multiple Tabs), a\n ValuesManager can be used to make the forms act as one logical form, supporting all\n value-related APIs otherwise called on DynamicForm directly.\n <P>\n A ValuesManager has no visual representation - it is strictly a logical entity, and the\n member forms provide the user interface.  You can initialize a ValuesManager with a set of\n member forms (by setting ${isc.DocUtils.linkForRef('attr:ValuesManager.members')} at init) or add and remove member\n forms dynamically.\n <P>\n Calling ${isc.DocUtils.linkForRef('method:ValuesManager.setValues')} on a ValuesManager will automatically route new\n field values to whichever member form is showing an editor for that field.  Likewise,\n calling ${isc.DocUtils.linkForRef('method:ValuesManager.validate')} will validate all member forms, and\n ${isc.DocUtils.linkForRef('method:ValuesManager.saveData')} will initiate a save operation which aggregates values from\n all member forms.\n <P>\n Like a DynamicForm, a ValuesManager can be databound by setting\n ${isc.DocUtils.linkForRef('attr:ValuesManager.dataSource')}.  In this case all member forms must also be bound to the\n same DataSource.\n <P>\n In general, when working with a ValuesManager and its member forms, call APIs on the\n ValuesManager whenever you are dealing with values that span multiple forms, and only call\n APIs on member forms that are specific to that form or its fields.\n <P>\n Note that, just as a DynamicForm can track values that are not shown in any FormItem, a\n ValuesManager may track values for which there is no FormItem in any member form.  However,\n when using a ValuesManager these extra values are only allowed on the ValuesManager itself.\n Member forms will not track values for which they do not have FormItems.",
        name:"ValuesManager",
        seeAlso:[
            {
                ref:"group:memoryLeaks",
                description:null
            }
        ],
        type:"class",
        examples:[
            "${isc.DocUtils.linkForExampleId('formSplitting')}"
        ]
    },
    "method:ListGrid.getExportBGColor":{
        ref:"method:ListGrid.getExportBGColor",
        flags:"",
        description:"When exporting data to Excel/OpenOffice format using ${isc.DocUtils.linkForRef('method:ListGrid.exportData','exportData()')} or\n${isc.DocUtils.linkForRef('method:ListGrid.exportClientData','exportClientData()')}, background color to use \nfor the cell at the given rowNum and colNum.\n <p>\nSee ${isc.DocUtils.linkForRef('group:exportBGColor')} for an overview.\n\n",
        name:"getExportBGColor",
        seeAlso:[
        ],
        params:[
            {
                description:"row number of cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"int"
            },
            {
                description:"column number of cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"int"
            },
            {
                description:"the record object behind the row being exported",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"Record"
            }
        ],
        returns:{
            description:"background color to use for the cell, or null to use the default                 background color",
            type:"CSSColor"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "exportBackgroundColor"
        ]
    },
    "method:Array.setLength":{
        ref:"method:Array.setLength",
        flags:"",
        description:" Set the length of this list.\n <P>\n If the length of the list is shortened, any elements past the new length of the list are removed.\n If the length is increased, all positions past the old length have the value\n <code>undefined</code>.\n\n",
        name:"setLength",
        seeAlso:[
        ],
        params:[
            {
                description:"new length",
                optional:false,
                name:"length",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"object:Array",
        groups:[
            "modification"
        ]
    },
    "attr:DrawKnob.knobShape":{
        ref:"attr:DrawKnob.knobShape",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('class:DrawItem')} instance rendered into this DrawKnob's drawPane",
        name:"knobShape",
        seeAlso:[
        ],
        valueType:"AutoChild DrawItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DrawKnob"
    },
    "method:StretchImg.setState":{
        ref:"method:StretchImg.setState",
        flags:"",
        description:" Set the specified image's state to newState and update the displayed image given by\n whichPart, or set the state for all images to newState and update the displayed images\n if whichPart is not provided.\n",
        name:"setState",
        seeAlso:[
        ],
        params:[
            {
                description:"name for the new state (\"off\", \"down\", etc)",
                optional:false,
                name:"newState",
                defaultValue:null,
                type:"string"
            },
            {
                description:"name of the piece to set (\"start\", \"stretch\" or \"end\")\t\t\t\t\t\t\t\t\t\t\tif not specified, sets them all",
                optional:true,
                name:"whichPart",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:StretchImg",
        groups:[
            "appearance"
        ]
    },
    "method:ResultTree.dataArrived":{
        ref:"method:ResultTree.dataArrived",
        flags:"",
        description:" This callback fires whenever the resultTree receives new nodes from the server, after\n the new nodes have been integrated into the tree.\n \n",
        name:"dataArrived",
        seeAlso:[
        ],
        params:[
            {
                description:"The parentNode for which children were just loaded",
                optional:false,
                name:"parentNode",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        type:"method",
        definingClass:"class:ResultTree"
    },
    "method:Gauge.getSectorLabelContents":{
        ref:"method:Gauge.getSectorLabelContents",
        flags:"",
        description:" Gets the label contents of the label for the sector at sectorIndex.\n\n",
        name:"getSectorLabelContents",
        seeAlso:[
        ],
        params:[
            {
                description:"index of the target sector.",
                optional:false,
                name:"sectorIndex",
                defaultValue:null,
                type:"int"
            }
        ],
        returns:{
            description:"the label contents of the sector's label.",
            type:"String"
        },
        type:"method",
        definingClass:"class:Gauge"
    },
    "attr:SpinnerItem.decreaseIconProperties":{
        ref:"attr:SpinnerItem.decreaseIconProperties",
        flags:"IR",
        description:"FormItemIcon properties applied to the ${isc.DocUtils.linkForRef('attr:SpinnerItem.decreaseIcon','decreaseIcon')} AutoChild of this\n SpinnerItem.",
        name:"decreaseIconProperties",
        seeAlso:[
        ],
        valueType:"FormItemIcon Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SpinnerItem"
    },
    "attr:DetailViewer.data":{
        ref:"attr:DetailViewer.data",
        flags:"IRW",
        description:"A single record object or an array of them, specifying data. Note that DetailViewers do\n not observe changes to the data array (in other words they will not automatically\n re-draw when the data provided via this property is altered).",
        name:"data",
        setter:[
            "setData"
        ],
        seeAlso:[
        ],
        valueType:"Array[] of DetailViewerRecord | Array[] of Record | RecordList",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "basics"
        ]
    },
    "classAttr:RPCManager.defaultTransport":{
        ref:"classAttr:RPCManager.defaultTransport",
        flags:"IRW",
        description:"Selects the transport use for RPC requests by default.  You can override this setting on\n a per-request basis by setting ${isc.DocUtils.linkForRef('attr:RPCRequest.transport')}.",
        name:"defaultTransport",
        seeAlso:[
            {
                ref:"attr:RPCRequest.transport",
                description:null
            }
        ],
        valueType:"RPCTransport",
        defaultValue:"\"xmlHttpRequest\"",
        type:"classAttr",
        definingClass:"class:RPCManager"
    },
    "method:Gauge.getNumSectors":{
        ref:"method:Gauge.getNumSectors",
        flags:"",
        description:" Gets the number of sectors.\n\n",
        name:"getNumSectors",
        seeAlso:[
        ],
        returns:{
            description:"the number of sectors on this gauge.",
            type:"int"
        },
        type:"method",
        definingClass:"class:Gauge"
    },
    "attr:OperationBinding.mail":{
        ref:"attr:OperationBinding.mail",
        flags:"IR",
        description:"Definition of an email message that will be sent as an after-effect of selecting or updating\n data.\n <p>\n Note that if a fixed number of different messages need to be sent, multiple \n <code>&lt;mail&gt;</code> tags may be specified.  For example, one mail could be sent to an \n admin address, and a different message to every member of a user group.",
        name:"mail",
        seeAlso:[
        ],
        valueType:"Mail",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:OperationBinding",
        groups:[
            "mail"
        ]
    },
    "classMethod:Validator.addValidator":{
        ref:"classMethod:Validator.addValidator",
        flags:"A",
        description:" Add a new validator type that can be specified as ${isc.DocUtils.linkForRef('attr:Validator.type')} anywhere\n validators are declared, such as ${isc.DocUtils.linkForRef('attr:DataSourceField.validators')} or\n ${isc.DocUtils.linkForRef('attr:FormItem.validators')}.\n <br>\n The <code>condition</code> argument should be a method of the same signature as\n ${isc.DocUtils.linkForRef('method:Validator.condition')}.\n <P>\n This method is essentially a shortcut for building a ${isc.DocUtils.linkForRef('object:validatorDefinition')} object\n and passing that to ${isc.DocUtils.linkForRef('classMethod:Validator.addValidatorDefinition')}\n\n",
        name:"addValidator",
        seeAlso:[
            {
                ref:"classMethod:Validator.addValidators",
                description:null
            }
        ],
        params:[
            {
                description:"type name for the new validator",
                optional:false,
                name:"type",
                defaultValue:null,
                type:"String"
            },
            {
                description:"function or expression to evaluate to determine whether                                 validation was successful",
                optional:false,
                name:"condition",
                defaultValue:null,
                type:"StringMethod"
            }
        ],
        type:"classMethod",
        definingClass:"class:Validator",
        groups:[
            "validation"
        ]
    },
    "attr:ColorPicker.moreButtonTitle":{
        ref:"attr:ColorPicker.moreButtonTitle",
        flags:"IR",
        description:"The title for the button that switches to a more complex view.",
        name:"moreButtonTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"More &gt;&gt;\"",
        type:"attr",
        definingClass:"class:ColorPicker",
        groups:[
            "i18nMessages"
        ]
    },
    "classAttr:FacetChart.invalidPolynomialDegreeMessage":{
        ref:"classAttr:FacetChart.invalidPolynomialDegreeMessage",
        flags:"IRW",
        description:"Warning message issued when an invalid polynomial degree is entered into the prompt dialog created\n by the <code>\"Polynomial Degree...\"</code> option in the context menu for scatter plots.",
        name:"invalidPolynomialDegreeMessage",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"The regression polynomial degree must be a positive integer.\"",
        type:"classAttr",
        definingClass:"class:FacetChart",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:SelectItem.defaultToFirstOption":{
        ref:"attr:SelectItem.defaultToFirstOption",
        flags:"IRW",
        description:"Select the first option as the default value for this SelectItem. \n <P>\n If options are derived from a dataSource, the first value returned by the server will be\n used, otherwise the first value in the valueMap.  Note that setting this property to\n true will trigger a fetch at soon as the form is created, because the form will try to\n establish a default value at that time.\n <P>\n If enabled, this setting overrides ${isc.DocUtils.linkForRef('attr:SelectItem.defaultValue')} and\n ${isc.DocUtils.linkForRef('method:SelectItem.defaultDynamicValue')}.",
        name:"defaultToFirstOption",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:SelectItem"
    },
    "method:ListGrid.showField":{
        ref:"method:ListGrid.showField",
        flags:"",
        description:" Force a field to be shown. This method does not add new fields to the grid,\n it simply changes field visibility. If a field.showIf expression exists, it will be\n destroyed.\n <P>\n Note: for showing multiple fields it is more efficient to call ${isc.DocUtils.linkForRef('method:ListGrid.showFields')} than\n to call this method repeatedly.\n\n",
        name:"showField",
        seeAlso:[
        ],
        params:[
            {
                description:"field to show",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"String | ListGridField"
            },
            {
                description:"If passed, don't resize non-explicitly sized columns                                       to fill the available space.",
                optional:true,
                name:"suppressRelayout",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('columnOrder')}"
        ],
        definingClass:"class:ListGrid"
    },
    "classMethod:Log.clearPriority":{
        ref:"classMethod:Log.clearPriority",
        flags:"",
        description:" Clear the priority setting for a particular category, so that the category's effective\n priority returns to <code>Log.defaultPriority</code><br>\n If the optional second parameter is passed, the specific priority setting for the \n category on that object will be cleared, so logs in that category on that object will\n be logged at the global priority level for the category.\n\n",
        name:"clearPriority",
        seeAlso:[
        ],
        params:[
            {
                description:"category name",
                optional:false,
                name:"category",
                defaultValue:null,
                type:"String"
            },
            {
                description:"Optional instance or class object - if passed                                        clear logging priority for the appropriate category\n                                        on that object.",
                optional:true,
                name:"object",
                defaultValue:null,
                type:"Class or Instance object"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:ListPropertiesPane.startNumberFieldTitle":{
        ref:"attr:ListPropertiesPane.startNumberFieldTitle",
        flags:"IR",
        description:"The ${isc.DocUtils.linkForRef('attr:FormItem.title','title')} of the ${isc.DocUtils.linkForRef('attr:ListPropertiesPane.startNumberField','startNumberField')}.",
        name:"startNumberFieldTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Start at\"",
        type:"attr",
        definingClass:"class:ListPropertiesPane",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Label.showDownIcon":{
        ref:"attr:Label.showDownIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the mouse goes\n down on the button.",
        name:"showDownIcon",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Label",
        groups:[
            "buttonIcon"
        ]
    },
    "attr:MetricSettings.showDataValues":{
        ref:"attr:MetricSettings.showDataValues",
        flags:"IR",
        description:"Should data values be shown as text labels near the shape representing the value, for example,\n above columns of a column chart, or adjacent to points in a line chart?\n <p>\n If set to false, then data values will not be shown.\n <p>\n If set to true, data values will be shown unless the data density is high enough that\n labels will potentially overlap, in which case, data values will not be shown and\n ${isc.DocUtils.linkForRef('attr:MetricSettings.showValueOnHover')} will be enabled instead.",
        name:"showDataValues",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MetricSettings"
    },
    "attr:ListGrid.filterButtonProperties":{
        ref:"attr:ListGrid.filterButtonProperties",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showFilterEditor')} is true, this attribute may be used to customize the\n filter button shown to the right of the filterEditor row.",
        name:"filterButtonProperties",
        seeAlso:[
        ],
        valueType:"Button properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:ListGrid.selectRecord":{
        ref:"method:ListGrid.selectRecord",
        flags:"",
        description:" Select/deselect a ${isc.DocUtils.linkForRef('object:Record')} passed in explicitly, or by index.\n <P>\n Note that this method selects records unconditionally, allowing multiple selected\n records, even when ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType')} is \"single\".  To enforce mutually-exclusive\n record-selection, use ${isc.DocUtils.linkForRef('method:ListGrid.selectSingleRecord')}.\n",
        name:"selectRecord",
        seeAlso:[
        ],
        params:[
            {
                description:"record (or row number) to select",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"Record | number"
            },
            {
                description:"new selection state (if null, defaults to true)",
                optional:true,
                name:"newState",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "selection"
        ]
    },
    "class:ImgTab":{
        methods:[
        ],
        ref:"class:ImgTab",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Foundation"
        ],
        attrs:[
            "attr:ImgTab.capSize",
            "attr:ImgTab.skinImgDir",
            "attr:ImgTab.labelSkinImgDir",
            "attr:ImgTab.baseStyle",
            "attr:ImgTab.titleStyle",
            "attr:ImgTab.src",
            "attr:ImgTab.showRollOver",
            "attr:ImgTab.showFocus",
            "attr:ImgTab.showFocused",
            "attr:ImgTab.align"
        ],
        description:"Specialized StretchImgButton used by TabSet/TabBar for tabs",
        name:"ImgTab",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:DataSourceField.group":{
        ref:"attr:DataSourceField.group",
        flags:"IR",
        description:"For use in ${isc.DocUtils.linkForRef('group:componentSchema')}, indicates what group to place the property in when\n editing in Visual Builder.",
        name:"group",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField",
        groups:[
            "componentSchema"
        ]
    },
    "attr:TextItem.emptyStringValue":{
        ref:"attr:TextItem.emptyStringValue",
        flags:"IRW",
        description:"How should an empty string entered by the user be stored?\n This value is typically set to <code>null</code> or <code>\"\"</code>.\n <P>\n Note that a call to ${isc.DocUtils.linkForRef('method:FormItem.setValue','setValue(null)')} or ${isc.DocUtils.linkForRef('method:FormItem.setValue','setValue(\"\")')}\n automatically updates this property to ensure that \"empty\" values are stored in a \n consistent format.",
        name:"emptyStringValue",
        seeAlso:[
        ],
        valueType:"any",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TextItem",
        groups:[
            "formValues"
        ]
    },
    "attr:Layout.locateMembersType":{
        ref:"attr:Layout.locateMembersType",
        flags:"IRWA",
        description:"${isc.DocUtils.linkForRef('type:LocatorTypeStrategy')} to use when finding members within this layout.",
        name:"locateMembersType",
        seeAlso:[
        ],
        valueType:"LocatorTypeStrategy",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "autoTest"
        ]
    },
    "attr:Scrollbar.trackEndWidth":{
        ref:"attr:Scrollbar.trackEndWidth",
        flags:"IRA",
        description:"The minimum pixel width of the track end segments (if enabled with showTrackEnds).",
        name:"trackEndWidth",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"12",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "track"
        ]
    },
    "method:ValuesManager.saveData":{
        ref:"method:ValuesManager.saveData",
        flags:"",
        description:"\n Validate and then save the form's current values to the ${isc.DocUtils.linkForRef('class:DataSource')} this form is\n bound to.\n <p>\n If client-side validators are defined, they are executed first, and if any errors are\n found the save is aborted and the form will show the errors.\n <p>\n If client-side validation passes, a ${isc.DocUtils.linkForRef('class:DSRequest')} will be sent, exactly as though\n ${isc.DocUtils.linkForRef('method:DataSource.addData')} or ${isc.DocUtils.linkForRef('method:DataSource.updateData')} had been called with \n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','the form\\'s values')} as data.  The\n ${isc.DocUtils.linkForRef('attr:DSRequest.operationType')} will be either \"update\" or \"add\", depending on the\n current ${isc.DocUtils.linkForRef('attr:DynamicForm.saveOperationType')}.\n <P>\n On either a client-side or server-side validation failure, validation errors will be\n displayed in the form.  Visible items within a DynamicForm will be redrawn to display\n errors. Validation failure occurring on hidden items, or DataSource fields with no \n associated form items may be handled via ${isc.DocUtils.linkForRef('method:DynamicForm.handleHiddenValidationErrors')}\n or ${isc.DocUtils.linkForRef('method:ValuesManager.handleHiddenValidationErrors')}.\n <P>\n In the case of a validation error, the callback will <b>not</b> be called by default\n since the form has already handled the failed save by displaying the validation errors\n to the user.  If you need to do something additional in this case, you can set\n ${isc.DocUtils.linkForRef('attr:RPCRequest.willHandleError')} via the <code>requestProperties</code> parameter to\n force your callback to be invoked.  However, first consider:\n <ul>\n <li> if you are trying to customize display of validation errors, there are several\n ${isc.DocUtils.linkForRef('attr:DynamicForm.showErrorIcons','built-in modes')} and ${isc.DocUtils.linkForRef('method:DynamicForm.showErrors')} may be a better\n place to put customizations.\n <li> for unrecoverable general errors (eg server is down),\n ${isc.DocUtils.linkForRef('classMethod:RPCManager.handleError','central error handling')} in invoked, so consider placing\n customizations there unless an unrecoverable error should be handled specially by this\n specific form.\n </ul>\n\n",
        name:"saveData",
        seeAlso:[
        ],
        params:[
            {
                description:"callback to invoke on completion",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"DSCallback"
            },
            {
                description:"additional properties to set on the DSRequest                                            that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('addOperation')}"
        ],
        definingClass:"class:ValuesManager",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "group:formIcons":{
        ref:"group:formIcons",
        refs:[
            "method:FormItemIcon.click",
            "method:FormItemIcon.keyPress",
            "method:FormItem.iconClick",
            "method:FormItem.iconKeyPress",
            "object:FormItemIcon",
            "attr:FormItem.disableIconsOnReadOnly",
            "attr:FormItem.icons",
            "attr:FormItem.defaultIconSrc",
            "attr:FormItem.showOverIcons",
            "attr:FormItem.showFocusedIcons",
            "attr:FormItem.iconHSpace",
            "attr:FormItem.iconVAlign",
            "attr:FormItem.iconHeight",
            "attr:FormItem.iconWidth",
            "attr:FormItem.iconPrompt",
            "attr:FormItem.showIcons",
            "attr:FormItemIcon.src",
            "attr:FormItemIcon.showOver",
            "attr:FormItemIcon.showFocused",
            "attr:FormItemIcon.showRTL",
            "attr:FormItemIcon.showFocusedWithItem",
            "attr:FormItemIcon.neverDisable",
            "attr:FormItemIcon.disableOnReadOnly",
            "attr:FormItemIcon.tabIndex",
            "attr:FormItemIcon.width",
            "attr:FormItemIcon.height",
            "attr:FormItemIcon.prompt",
            "attr:FormItemIcon.hspace",
            "attr:LinkItem.disableIconsOnReadOnly",
            "attr:LinkItem.iconVAlign",
            "attr:TextAreaItem.iconVAlign"
        ],
        name:"formIcons",
        seeAlso:[
        ],
        type:"group"
    },
    "method:ListGrid.scrollToRow":{
        ref:"method:ListGrid.scrollToRow",
        flags:"",
        description:" Scroll the grid to specified row such that the row appears near the center of the\n viewport, loading data if necessary.\n <P>\n See ${isc.DocUtils.linkForRef('method:ListGrid.scrollToCell')} for a full description of how\n this method interacts with incremental loading and rendering of data.\n\n",
        name:"scrollToRow",
        seeAlso:[
        ],
        params:[
            {
                description:"Row index of the cell to scroll into view",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"Vertical position of scrolled row (optional)",
                optional:true,
                name:"yPosition",
                defaultValue:null,
                type:"VerticalAlignment"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "scrolling"
        ]
    },
    "attr:TextItem.maskPadChar":{
        ref:"attr:TextItem.maskPadChar",
        flags:"IRWA",
        description:"Character that is used to fill required empty mask positions\n to display text while control has no focus.",
        name:"maskPadChar",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\" \"",
        type:"attr",
        definingClass:"class:TextItem"
    },
    "method:DrawCurve.moveTo":{
        ref:"method:DrawCurve.moveTo",
        flags:"",
        description:" Sets start, end and control points of this curve\n\n",
        name:"moveTo",
        seeAlso:[
        ],
        params:[
            {
                description:"new x coordinate in pixels",
                optional:false,
                name:"x",
                defaultValue:null,
                type:"int"
            },
            {
                description:"new y coordinate in pixels",
                optional:false,
                name:"y",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DrawCurve"
    },
    "type:SCClassName":{
        ref:"type:SCClassName",
        description:"Name of a SmartClient Class, that is, a Class that has been created via\n ${isc.DocUtils.linkForRef('classMethod:isc.defineClass')}, including Classes built into SmartClient, such as \"ListGrid\".",
        name:"SCClassName",
        seeAlso:[
        ],
        type:"type"
    },
    "classMethod:DrawItem.computeAngle":{
        ref:"classMethod:DrawItem.computeAngle",
        flags:"",
        description:" Computes the angle in degrees from the positive X axis to the difference vector\n <nobr><b>v</b><sub>2</sub> - <b>v</b><sub>1</sub></nobr> between the two given vectors.\n",
        name:"computeAngle",
        seeAlso:[
        ],
        params:[
            {
                description:"X coordinate of <b>v</b><sub>1</sub>",
                optional:false,
                name:"px1",
                defaultValue:null,
                type:"double"
            },
            {
                description:"Y coordinate of <b>v</b><sub>1</sub>",
                optional:false,
                name:"py1",
                defaultValue:null,
                type:"double"
            },
            {
                description:"X coordinate of <b>v</b><sub>2</sub>",
                optional:false,
                name:"px2",
                defaultValue:null,
                type:"double"
            },
            {
                description:"Y coordinate of <b>v</b><sub>2</sub>",
                optional:false,
                name:"py2",
                defaultValue:null,
                type:"double"
            }
        ],
        returns:{
            description:"the angle in degrees, in the range [0, 360).",
            type:"double"
        },
        type:"classMethod",
        definingClass:"class:DrawItem"
    },
    "method:Calendar.refreshEvent":{
        ref:"method:Calendar.refreshEvent",
        flags:"",
        description:" Refreshes the event's canvas in the current view.  Has no effect in the \n ${isc.DocUtils.linkForRef('attr:Calendar.monthView','monthView')}.\n\n",
        name:"refreshEvent",
        seeAlso:[
        ],
        params:[
            {
                description:"The event object to refresh in the current view",
                optional:false,
                name:"event",
                defaultValue:null,
                type:"CalendarEvent"
            }
        ],
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:DetailViewerField.type":{
        ref:"attr:DetailViewerField.type",
        flags:"IR",
        description:"Specifies the type of this DetailViewerField.  By default (value is <code>null</code>)\n the field shows a field title on the left and the field value on the right.  There are\n four special values for this attribute:\n <ul>\n <li>\"header\" - If you specify type \"header\", the field spans both the field name and\n field value columns and contains text defined in the ${isc.DocUtils.linkForRef('attr:DetailViewerField.value')}\n attribute with the style specified by ${isc.DocUtils.linkForRef('attr:DetailViewer.headerStyle')}.  You can use this\n field type as a titled separator.\n <li>\"separator\" - If you specify type \"separator\", the field spans both the field name\n and the field value columns with no text, and is styled using the style specified via\n ${isc.DocUtils.linkForRef('attr:DetailViewer.separatorStyle')}.  The height of the separator field can be controlled\n via ${isc.DocUtils.linkForRef('attr:DetailViewerField.height')}.\n <li>\"image\" For viewing, a thumbnail image is rendered in the field.  The URL of the\n image is the value of the field, and should be absolute. The size of the image is\n controlled by ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageSize')},\n ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageWidth')}, ${isc.DocUtils.linkForRef('attr:DetailViewerField.imageHeight')}\n <li><p>\"link\" For viewing, a clickable html link (using an HTML anchor tag: &lt;A&gt;)\n is rendered in the field.  The target URL is the value of the field, which is also the\n default display value.  You can override the display value by setting\n ${isc.DocUtils.linkForRef('attr:DetailViewerRecord.linkText')} or ${isc.DocUtils.linkForRef('attr:DetailViewerField.linkText')}.</p>\n <p>\n Clicking the link opens the URL in a new window by default.  To change this behavior,\n you can set <code>field.target</code>, which works identically to the \"target\"\n attribute on an HTML anchor (&lt;A&gt;) tag.  See ${isc.DocUtils.linkForRef('attr:DetailViewerField.target')} for\n more information.</p></li>\n </ul>",
        name:"type",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField"
    },
    "method:TabSet.scrollBack":{
        ref:"method:TabSet.scrollBack",
        flags:"",
        description:" If there is not enough space to display all the tabs in this tabSet, this method will \n scroll the previous tab (that first tab that is clipped at the beginning of the tab-bar) \n into view.\n",
        name:"scrollBack",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "class:SplitPane":{
        methods:[
            "method:SplitPane.setAddHistoryEntries",
            "method:SplitPane.setCurrentPane",
            "method:SplitPane.setDetailToolButtons",
            "method:SplitPane.setPageOrientation",
            "method:SplitPane.setShowLeftButton",
            "method:SplitPane.setLeftButtonTitle",
            "method:SplitPane.setShowRightButton",
            "method:SplitPane.setRightButtonTitle",
            "method:SplitPane.setNavigationPane",
            "method:SplitPane.setNavigationTitle",
            "method:SplitPane.showNavigationPane",
            "method:SplitPane.setListPane",
            "method:SplitPane.showListPane",
            "method:SplitPane.setListTitle",
            "method:SplitPane.setDetailPane",
            "method:SplitPane.showDetailPane",
            "method:SplitPane.setDetailTitle",
            "method:SplitPane.setDetailNavigationControl",
            "method:SplitPane.navigationClick",
            "method:SplitPane.paneChanged"
        ],
        ref:"class:SplitPane",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout"
        ],
        attrs:[
            "attr:SplitPane.addHistoryEntries",
            "attr:SplitPane.deviceMode",
            "attr:SplitPane.pageOrientation",
            "attr:SplitPane.showResizeBars",
            "attr:SplitPane.navigationBar",
            "attr:SplitPane.showNavigationBar",
            "attr:SplitPane.backButton",
            "attr:SplitPane.currentPane",
            "attr:SplitPane.navigationTitle",
            "attr:SplitPane.navigationPane",
            "attr:SplitPane.listTitle",
            "attr:SplitPane.listPane",
            "attr:SplitPane.listToolStrip",
            "attr:SplitPane.showListToolStrip",
            "attr:SplitPane.detailTitle",
            "attr:SplitPane.detailPane",
            "attr:SplitPane.detailToolStrip",
            "attr:SplitPane.showDetailToolStrip",
            "attr:SplitPane.detailToolButtons",
            "attr:SplitPane.showLeftButton",
            "attr:SplitPane.showRightButton",
            "attr:SplitPane.detailNavigationControl"
        ],
        description:"A device- and orientation-sensitive layout that implements the common pattern of rendering\n two panes side-by-side on desktop devices and on tablets in landscape orientation,\n while switching to showing a single pane for handset-sized devices or tablets in portrait\n orientation (this type of behavior is sometimes called \"responsive design\").\n <p>\n A <code>SplitPane</code> can manage either two or three panes &mdash; a\n ${isc.DocUtils.linkForRef('attr:SplitPane.navigationPane','navigationPane')} and the\n ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane','detailPane')} are required, and a\n ${isc.DocUtils.linkForRef('attr:SplitPane.listPane','listPane')} can also be provided which appears in the same place as\n the navigation pane, with built-in navigation between the panes based on\n ${isc.DocUtils.linkForRef('class:NavigationBar')}.  An example of 3-pane usage would be an email application:\n <ul>\n <li> <code>navigationPane</code>: ${isc.DocUtils.linkForRef('class:TreeGrid')} of folders\n <li> <code>listPane</code>: ${isc.DocUtils.linkForRef('class:ListGrid')} showing messages in a folder\n <li> <code>detailPane</code>: message detail view (perhaps a ${isc.DocUtils.linkForRef('class:DetailViewer')} over an\n      ${isc.DocUtils.linkForRef('class:HTMLFlow')} or similar arrangement)\n </ul>\n <p>\n The placement of the panes is by default sensitive to whether the device is detected as a\n handset (phone), tablet or desktop device (see ${isc.DocUtils.linkForRef('type:DeviceMode')}) and to the current\n ${isc.DocUtils.linkForRef('type:PageOrientation')}.  You can also configure a <code>SplitPane</code> with a fixed\n ${isc.DocUtils.linkForRef('attr:SplitPane.pageOrientation')} or ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode')}.\n <p>\n Beyond providing the panes listed above, typical usage is simply to call\n ${isc.DocUtils.linkForRef('method:SplitPane.showListPane','showListPane()')} and ${isc.DocUtils.linkForRef('method:SplitPane.showDetailPane','showDetailPane()')} when the\n <code>SplitPane</code> should navigate to a new pane.  For example, in an email application,\n clicking on a folder in the <code>navigationPane</code> should cause the\n <code>listPane</code> to show messages from the folder, then\n <code>showListPane(<em>\"folder name\"</em>)</code> would be called to show the\n <code>listPane</code> and give it a new title reflecting the name of the folder.\n <p>\n Similarly, clicking on a message in the <code>listPane</code> should show the message\n details in the <code>detailPane</code> and call\n <code>showDetailPane(<em>\"message title\"</em>)</code> to reveal the <code>detailPane</code>\n and give it an appropriate title.\n <p>\n <h3>Automatic control placement</h3>\n <p>\n ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolButtons')} allows you to define a set of controls that are specially\n placed based on the <code>deviceMode</code> and <code>pageOrientation</code>.  See\n ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolButtons')} for details.\n <p>\n <h3>NavigationBar and ToolStrips</h3>\n <p>\n By default, a ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar')} is created in all modes, and in some modes\n additional bars are created as follows:\n <ul>\n <li> in <code>deviceMode:\"desktop\"</code> and <code>deviceMode</code> \"tablet\", the\n      ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolStrip')} is shown <em>above</em> the <code>detailPane</code>.\n <li> in <code>deviceMode:\"handset\"</code>, the ${isc.DocUtils.linkForRef('attr:SplitPane.detailToolStrip')} is created\n      <strong>only</strong> if <code>detailToolButtons</code> are specified, and is placed\n      <em>underneath</em> the <code>detailPane</code>.\n <li> ${isc.DocUtils.linkForRef('attr:SplitPane.listToolStrip')} - separate bar for the <code>listPane</code>, only present\n      for <code>deviceMode:\"desktop\"</code> when a <code>listPane</code> is provided.\n </ul>\n All of these bars are ${isc.DocUtils.linkForRef('group:autoChildUsage','AutoChildren')} and hence completely\n optional.  You can omit them entirely, or, if you want navigation bars or tool strips but\n want to customize them more than the AutoChild system allows, you can prevent the built-in\n bars from being created and place your own ${isc.DocUtils.linkForRef('class:NavigationBar')}s either <em>inside</em> your\n navigation, list or detail panes, or <em>outside</em> the <code>SplitPane</code> as a whole.\n This allows you to completely customize your navigation but still use <code>SplitPane</code>\n to handle device- and orientation-aware layout. See ${isc.DocUtils.linkForRef('attr:SplitPane.showNavigationBar')},\n ${isc.DocUtils.linkForRef('attr:SplitPane.showListToolStrip')}, and ${isc.DocUtils.linkForRef('attr:SplitPane.showDetailToolStrip')}.\n <p>\n Note that while the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')} is named after the ${isc.DocUtils.linkForRef('class:NavigationBar')}\n class, the other automatically created bars are also instances of\n <code>NavigationBar</code> despite the \"toolStrip\" naming convention.  These controls will\n not generally contain navigation elements; the <code>NavigationBar</code> class is used for\n consistent styling, since the <code>navigationBar</code> appears adjacent to the toolstrips\n in some modes and orientations, so they should have the same height and styling.",
        name:"SplitPane",
        seeAlso:[
        ],
        type:"class",
        inheritsFrom:"VLayout"
    },
    "attr:ListGrid.loadingMessage":{
        ref:"attr:ListGrid.loadingMessage",
        flags:"IR",
        description:"If you have a databound listGrid and you scroll out of the currently loaded dataset, by\n default you will see blank rows until the server returns the data for those rows.  The\n loadingMessage attribute allows you to specify arbitrary html that will be shown in each\n such \"blank\" record while the data for that record is loading.",
        name:"loadingMessage",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"&amp;nbsp;\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "emptyMessage",
            "i18nMessages"
        ]
    },
    "method:Array.getUniqueItems":{
        ref:"method:Array.getUniqueItems",
        flags:"",
        description:" Return a list of each unique item in this list exactly once.\n <P>\n Returns in the same order they were found in the list.\n <P>\n Usage example:<br>\n &nbsp;&nbsp;&nbsp;&nbsp;uniqueList = myArray.getProperty(\"foo\").getUniqueItems();\n\n",
        name:"getUniqueItems",
        seeAlso:[
        ],
        returns:{
            description:"list of each unique item in the list",
            type:"array"
        },
        type:"method",
        definingClass:"object:Array",
        groups:[
            "subset"
        ]
    },
    "method:CubeGrid.facetRemoved":{
        ref:"method:CubeGrid.facetRemoved",
        flags:"",
        description:" Notification fired when a facet is removed.\n \n",
        name:"facetRemoved",
        seeAlso:[
            {
                ref:"method:CubeGrid.facetAdded",
                description:null
            }
        ],
        params:[
            {
                description:"facetId that was removed",
                optional:false,
                name:"facetId",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "facetLayout"
        ]
    },
    "attr:RichTextEditor.toolbar":{
        ref:"attr:RichTextEditor.toolbar",
        flags:"R",
        description:"Layout used to contain each of the ${isc.DocUtils.linkForRef('attr:RichTextEditor.controlGroups')}.",
        name:"toolbar",
        seeAlso:[
        ],
        valueType:"MultiAutoChild Layout",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RichTextEditor"
    },
    "method:FacetChart.getNumDataPoints":{
        ref:"method:FacetChart.getNumDataPoints",
        flags:"",
        description:" Count the number of data points.\n",
        name:"getNumDataPoints",
        seeAlso:[
        ],
        params:[
            {
                description:"a set of facetValues describing a slice of the data",
                optional:true,
                name:"criteria",
                defaultValue:null,
                type:"FacetValueMap"
            }
        ],
        returns:{
            description:"the number of data values",
            type:"Integer"
        },
        type:"method",
        definingClass:"class:FacetChart"
    },
    "attr:FacetChart.tickMarkToValueAxisMargin":{
        ref:"attr:FacetChart.tickMarkToValueAxisMargin",
        flags:"IR",
        description:"Margin between the tick marks and the labels of the\n ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','extra value axes')}.",
        name:"tickMarkToValueAxisMargin",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"7",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "classMethod:Hover.show":{
        ref:"classMethod:Hover.show",
        flags:"",
        description:" Displays a standard Hover canvas containing the specified HTML content.<br>\n This method may also be called to modify the content of the hover if it is already showing.\n Call ${isc.DocUtils.linkForRef('classMethod:Hover.hide')} to hide the canvas again.<br>\n A common use case for calling this method is to asynchronously fetch detail data from the\n server about some component, and display it in the Hover canvas when the data is returned.\n Note that in this case you will typically need to verify that the user is still hovering \n over the component in question before calling Hover.show() - if the user has moved the mouse \n off the component, the information will not apply to whatever is now under the mouse. \n Suggested approaches for handling this are to either use a ${isc.DocUtils.linkForRef('method:Canvas.mouseOut')} handler\n to track when the user moves off the component, or checking ${isc.DocUtils.linkForRef('classMethod:EventHandler.getTarget')}\n as part of the asynchronous callback\n <p>\n The default Hover canvas position will be based on the mouse pointer position, adjusted by\n ${isc.DocUtils.linkForRef('classAttr:Hover.leftOffset')} and ${isc.DocUtils.linkForRef('classAttr:Hover.topOffset')}. If this position would render the\n Hover canvas partially clipped, it will be automatically modified to ensure the Hover \n is entirely visible.\n",
        name:"show",
        seeAlso:[
        ],
        params:[
            {
                description:"contents for the hover",
                optional:false,
                name:"contents",
                defaultValue:null,
                type:"HTMLString | Canvas"
            },
            {
                description:"object containing attributes for managing the hover canvas'   appearance. Valid properties include:<ul>\n  <li>left, top, width, height\n  <li>baseStyle\n  <li>opacity\n  <li>wrap\n  <li>moveWithMouse [overrides ${isc.DocUtils.linkForRef('classAttr:Hover.moveWithMouse')}]\n </ul>",
                optional:false,
                name:"properties",
                defaultValue:null,
                type:"Label Properties"
            }
        ],
        type:"classMethod",
        definingClass:"class:Hover"
    },
    "attr:MenuButton.showMenuButtonImage":{
        ref:"attr:MenuButton.showMenuButtonImage",
        flags:"IR",
        description:"Show menu button image (up / down arrowhead) for this menu button.",
        name:"showMenuButtonImage",
        setter:[
            "setShowMenuButtonImage"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:MenuButton"
    },
    "method:Canvas.scrollByPercent":{
        ref:"method:Canvas.scrollByPercent",
        flags:"",
        description:"  Scroll this widget by some percentage of scroll size in either (or both) direction(s).\n\n",
        name:"scrollByPercent",
        seeAlso:[
        ],
        params:[
            {
                description:"Percentage to scroll horizontally. Will accept either                                      a numeric percent value, or a string like \"10%\".",
                optional:false,
                name:"dX",
                defaultValue:null,
                type:"number | string"
            },
            {
                description:"Percentage to scroll horizontally. Will accept either                                      a numeric percent value, or a string like \"10%\".",
                optional:false,
                name:"dY",
                defaultValue:null,
                type:"number | string"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "scrolling"
        ]
    },
    "attr:FacetValue.collapsed":{
        ref:"attr:FacetValue.collapsed",
        flags:"IR",
        description:"For tree facets, initial collapse state for this node.  Defaults to ${isc.DocUtils.linkForRef('attr:Facet.collapsed')}.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.",
        name:"collapsed",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"facet.collapsed",
        type:"attr",
        definingClass:"class:FacetValue"
    },
    "attr:Canvas.hoverDelay":{
        ref:"attr:Canvas.hoverDelay",
        flags:"IRW",
        description:"If <code>this.canHover</code> is true, how long should the mouse be kept over this\n widget before the hover event is fired",
        name:"hoverDelay",
        seeAlso:[
            {
                ref:"attr:Canvas.canHover",
                description:null
            },
            {
                ref:"method:Canvas.hover",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"300",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "hovers"
        ]
    },
    "method:CubeGrid.setEnableCharting":{
        ref:"method:CubeGrid.setEnableCharting",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:CubeGrid.enableCharting')} attribute.\n",
        name:"setEnableCharting",
        seeAlso:[
        ],
        params:[
            {
                description:null,
                optional:false,
                name:"enableCharting",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:Menu.iconFieldProperties":{
        ref:"attr:Menu.iconFieldProperties",
        flags:"IR",
        description:"Custom properties for the automatically generated icon column.\n <P>\n See ${isc.DocUtils.linkForRef('attr:Menu.showIcons')} for an overview of the icon column.",
        name:"iconFieldProperties",
        seeAlso:[
        ],
        valueType:"ListGridField properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Menu"
    },
    "classAttr:Operators.greaterThanTitle":{
        ref:"classAttr:Operators.greaterThanTitle",
        flags:"IR",
        description:"Title for the \"greaterThan\" operator",
        name:"greaterThanTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"greater than\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGridField.showGridSummary":{
        ref:"attr:ListGridField.showGridSummary",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} is true, should this field show a summary value.\n If unset, this field will show a summary value in the summary row if an\n explicit ${isc.DocUtils.linkForRef('attr:ListGridField.summaryFunction')} is specified or if a\n ${isc.DocUtils.linkForRef('classMethod:SimpleType.getDefaultSummaryFunction','default summary function')} is defined\n for the specified field type.",
        name:"showGridSummary",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "object:AdvancedCriteria":{
        methods:[
        ],
        ref:"object:AdvancedCriteria",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding/DataSource"
        ],
        attrs:[
        ],
        description:"AdvancedCriteria is a format for representing search criteria which may include\n operators on field values such as \"less than\", or may include sub-clauses such as several \n criteria applied to fields joined by an \"OR\" operator.\n <P>\n SmartClient DataSources can use AdvancedCriteria to search a list of ${isc.DocUtils.linkForRef('object:Record')}s, and\n the SmartClient Java Server can translate AdvancedCriteria to either SQL or Hibernate\n queries (<b>Note:</b> The server-side AdvancedCriteria handling feature is only available \n with the <b>Power</b> and <b>Enterprise</b> Editions of SmartClient; the Pro Edition is \n limited to ordinary criteria handling on the server side).<p>\n If the entire dataset is cached locally, SmartClient can perform AdvancedCriteria filtering \n on the client, avoiding a server call.\n <P>\n <smartclient>\n An AdvancedCriteria is an ordinary JavaScript object which can be created directly\n with JavaScript literal notation.  For example:\n <pre>\n var advancedCriteria = {\n        _constructor:\"AdvancedCriteria\",\n        operator:\"and\",\n        criteria:[\n            // this is a Criterion\n            { fieldName:\"salary\", operator:\"lessThan\", value:\"80000\" },\n            { operator:\"or\", criteria:[\n                  { fieldName:\"title\", operator:\"iContains\", value:\"Manager\" },\n                  { fieldName:\"reports\", operator:\"notNull\" }\n              ]  \n            }\n        ]\n    }\n </pre>\n An AdvancedCriteria is in effect a ${isc.DocUtils.linkForRef('object:Criterion')} that has been marked with \n _constructor:\"AdvancedCriteria\" to mark it as complete criteria.\n <P>\n This makes AdvancedCriteria very easy to store and retrieve as JSON strings, using\n ${isc.DocUtils.linkForRef('classMethod:JSON.encode','JSONEncoder')}.\n </smartclient>\n <smartgwt>\n AdvancedCriteria objects can be created directly in java. For example:\n <pre>\n AdvancedCriteria criteria = new AdvancedCriteria(OperatorId.AND, new Criterion[]{\n     new Criterion(\"salary\", OperatorId.LESS_THAN, 8000),\n     new AdvancedCriteria(OperatorId.OR, new Criterion[]{\n         new Criterion(\"title\", OperatorId.ICONTAINS, \"Manager\"),\n         new Criterion(\"reports\", OperatorId.NOT_NULL)\n     })\n });\n </pre>\n </smartgwt>\n <P>\n In addition to building a raw AdvancedCriteria object as described above, the\n ${isc.DocUtils.linkForRef('classMethod:DataSource.convertCriteria')} and ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')} methods\n may be used to create and modify criteria based on simple fieldName / value mappings.\n <P>\n When passed to the SmartClient Server, a server-side AdvancedCriteria instance (in the\n package com.isomorphic.criteria) can be retrieved from a DSRequest via\n com.isomorphic.datasource.DSRequest.getAdvancedCriteria().  These same AdvancedCriteria\n objects can be directly created server side, and applied to a DSRequest via\n setAdvancedCriteria().\n <P>\n ${isc.DocUtils.linkForRef('class:RestDataSource')}, the recommended way of integration with servers that are not running\n the SmartClient Server Framework, defines a standard XML and JSON serialization of\n <code>AdvancedCriteria</code>.\n <P>\n For other servers, you can translate <code>AdvancedCriteria</code> into whatever format is\n expected by the server, typically by implementing ${isc.DocUtils.linkForRef('method:DataSource.transformRequest')}.\n <P>\n <smartgwt>\n The internal representation of AdvancedCriteria is a simple JavaScript structure, available\n via AdvancedCriteria.getJsObj():\n <pre>\n // an AdvancedCriteria\n {\n     _constructor:\"AdvancedCriteria\",\n     operator:\"and\",\n     criteria:[\n         // this is a Criterion\n         { fieldName:\"salary\", operator:\"lessThan\", value:\"80000\" },\n         { operator:\"or\", criteria:[\n             { fieldName:\"title\", operator:\"iContains\", value:\"Manager\" },\n             { fieldName:\"reports\", operator:\"notNull\" }\n           ]  \n         }\n     ]\n }\n </pre>\n And an AdvancedCriteria can also be created from a JavaScriptObject.  This makes\n AdvancedCriteria very easy to store and retrieve as JSON strings, using\n ${isc.DocUtils.linkForRef('classMethod:JSON.encode','JSONEncoder')}.\n </smartgwt>\n See ${isc.DocUtils.linkForRef('group:criteriaEditing','Criteria Editing')} for information about\n editing AdvancedCriteria in a DynamicForm.",
        name:"AdvancedCriteria",
        seeAlso:[
        ],
        type:"object",
        serverDS:"allowed",
        groups:[
            "advancedFilter"
        ],
        inheritsFrom:"Criterion"
    },
    "attr:StretchImgButton.title":{
        ref:"attr:StretchImgButton.title",
        flags:"IRW",
        getter:[
            "getTitle"
        ],
        description:"The title HTML to display in this button.",
        name:"title",
        setter:[
            "setTitle"
        ],
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "basics"
        ]
    },
    "group:dmiOverview":{
        ref:"group:dmiOverview",
        title:"Direct Method Invocation",
        treeLocation:[
            "Client Reference/RPC"
        ],
        refs:[
        ],
        description:"Direct Method Invocation (DMI) allows Ajax requests from the UI to directly\n invoke methods on server-side objects via XML configuration.  See also\n ${isc.DocUtils.linkForRef('attr:OperationBinding.script','DMI Scripts')}, which allows you to place code directly into the\n XML file instead of in a separate .java file; this is a useful approach when DMI code is\n short.\n <P>\n When using DMI, request data from the UI is translated to Java objects and passed to the\n Java method you designate with an XML declaration.  Your Java method simply declares the\n parameters it needs and they are automatically provided (see \"Method Invocation\" below).\n The return value of your method is automatically wrapped as a valid response and delivered\n to the browser.\n <P>\n DMI requires the ${isc.DocUtils.linkForRef('group:iscServer','SmartClient Server')}.  Note that SmartClient also supports\n several approaches for interacting with ${isc.DocUtils.linkForRef('group:nonJavaBackend','non-Java backends')} and/or\n Java backends not running the ISC server.\n <P>\n <u><b>DataSource DMI</b></u>\n <br>\n See also ${isc.DocUtils.linkForRef('group:serverDataIntegration','Server DataSource Integration')} overview.<br>\n To enable DMI for a given DataSource, simply include a <code>&lt;serverObject&gt;</code>\n configuration block in that DataSource's configuration either at\n ${isc.DocUtils.linkForRef('attr:DataSource.serverObject')} or on a particular operationBinding via\n ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject')}.  The ServerObject specifies the target of the method\n invocation and ${isc.DocUtils.linkForRef('attr:OperationBinding.serverMethod')} specifies the method that will be\n called.\n <P>\n For example, the following Datasource DMI declaration would route \"fetch\" operations for\n this DataSource to the method \"fetch\" on an object stored in the servlet session under the\n name \"beanFetcher\":\n <pre>\n &lt;DataSource&gt;\n   &lt;operationBindings&gt;\n       &lt;binding operationType=\"fetch\" serverMethod=\"fetch\"&gt;\n           &lt;serverObject  \n                lookupStyle=\"attribute\" \n                attributeScope=\"session\" \n                attributeName=\"beanFetcher\"/&gt;\n       &lt;/binding&gt;\n   &lt;/operationBindings&gt;\n   ...\n &lt;/DataSource&gt;\n </pre>\n Method overloading is not supported - there must be exactly one method on the target class\n with the name specified in ${isc.DocUtils.linkForRef('attr:OperationBinding.serverMethod')}.  The method must be public,\n but can be either an instance or static method.  If no operationBinding is specified or the\n operationBinding does not specify a <code>serverMethod</code> then it defaults to the name of\n the operation (eg \"fetch\").\n <p>\n By default, the DSResponse data sent back by DataSource DMIs is filtered to just the set of\n fields specified on the DataSource.  This allows you to simply return beans that potentially\n have getter methods for fields other than are defined in the DataSource without that\n (potentially private) data being sent to the client.  If you want to disable this\n functionality, you can do so on a per-operation basis by setting\n ${isc.DocUtils.linkForRef('attr:ServerObject.dropExtraFields')}, on a per-DataSource level by setting\n ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')}, or globally by setting the config parameter\n <code>DMI.dropExtraFields</code> to <code>false</code> in\n ${isc.DocUtils.linkForRef('group:server_properties','[webroot]/WEB-INF/classes/server.properties')}.  \n Non-DMI DSResponse data is, by\n default, not filtered in this manner for backward compatibility reasons.  If you want to\n enable this type of filtering for non-DMI DSResponse data, you can do so by setting the\n config parameter <code>DSResponse.dropExtraFields</code> to <code>true</code> in\n ${isc.DocUtils.linkForRef('group:server_properties','[webroot]/WEB-INF/classes/server.properties')}.  \n <code>DMI.dropExtraFields</code>\n and <code>DSResponse.dropExtraFields</code> can be enabled/disabled independently of each\n other - that is, setting one does not side-effect the other.  ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}\n settings can be overridden by an explicit setting in ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')} which\n in turn can be overridden by an explicit setting in ${isc.DocUtils.linkForRef('attr:ServerObject.dropExtraFields')} (this\n last one for DMI only since non-DMI operations don't have a serverObject context).\n <p>\n <u><b>DataSource DMI and regular RPCManager dispatch</b></u><br>\n It is possible to use DMI to incorporate your own code into what is otherwise the regular \n process flow of an ordinary, non-DMI DataSource request.  This is particularly valuable if\n you are using the built-in SQL or Hibernate DataSources, because it allows you to inject\n extra functionality (validations, processing steps, messages to other systems, anything you\n can code) into a fetch or update request that is otherwise handled for you by the SmartClient \n Server.\n <p>\n To do this, just configure an operationBinding for DMI, as described above.  Then, in your\n server-side method, invoke <code>execute()</code> on the <code>DSRequest</code> your method\n is passed.  If you create a DMI method that does nothing <b>but</b> invoke\n <code>dsRequest.execute()</code>, then you have a DMI method that behaves exactly like the\n normal RPCManager dispatch code.  Customizing \"normal RPCManager dispatch code\" is now a \n simple matter of adding logic to your DMI method.  See \n ${isc.DocUtils.linkForExampleId('userSpecificData', 'this example')} of this technique in the Feature Explorer.\n <p>\n <u><b>RPC DMI</b></u>\n <br>\n RPC DMI makes a set of methods from a server-side class available as client-side methods for\n direct invocation (via ${isc.DocUtils.linkForRef('classMethod:DMI.call')}). This provides a way to perform arbitrary\n client/server interactions outside of the DataSource subsystem.\n <P>\n RPC DMI is an alternative approach to using the ${isc.DocUtils.linkForRef('class:RPCManager')} class directly to send\n requests to some <code>actionURL</code> where your server code would receive a generalized\n ${isc.DocUtils.linkForRef('class:RPCRequest','request object')}, to be routed to appropriate\n methods yourself.  Which interface (DMI or RPCManager) you choose is largely a matter of\n preference - they provide equivalent functionality.\n <P>\n RPC DMI also uses a ${isc.DocUtils.linkForRef('class:ServerObject')} configuration block to specify\n the server-side DMI end-point, but in the case of RPCs, the ${isc.DocUtils.linkForRef('class:ServerObject')} definition\n goes into an <code>rpcBindings</code> section of an\n ${isc.DocUtils.linkForRef('group:applicationDeclaration','Application definition')} in a <code>*.app.xml</code> file. \n <smartclient>For an example, see the <code>example.app.xml</code> file \n in the /shared/app directory of the SmartClient SDK.</smartclient>\n The only difference between the RPC DMI\n ServerObject definition and the DataSource DMI version is the addition of the\n ${isc.DocUtils.linkForRef('attr:ServerObject.visibleMethods')} block that specifies which methods are callable on this\n ServerObject.  This section is not consulted for DataSource DMIs because the\n ${isc.DocUtils.linkForRef('attr:OperationBinding.serverMethod')} is used to specify the callable method in that case.\n <p>\n <u><b>Method Invocation</b></u>\n <br>\n SmartClient can pass a set of stock context variables to your DMI method and also performs\n some type adaptation logic to make this interface more flexible.  For DataSource DMI, you\n can declare your method to take any number of the following types of arguments and they will\n be passed to you:\n <ul>\n <li>HttpServletRequest\n <li>HttpServletResponse\n <li>ServletContext\n <li>HttpSession\n <li>RPCManager\n <li>DSRequest\n <li>RequestContext (from com.isomorphic.servlet)\n <li>DataSource (same as DSRequest.getDataSource())\n <li>Map (same as DSRequest.getValues())\n <li>Bean (auto-populated from DSRequest.getValues())\n </ul>\n DataSource DMI methods can return any of the following types of values:\n <ul>\n <li>DSResponse (used as the DSResponse verbatim)\n <li>List (valid response to a fetch operation - gets auto-popuplated into a DSResponse for\n you via setData())\n <li>Map or Bean (valid response to add, update, remove operations - gets auto-populated\n into a DSResponse for you via setData()).\n </ul>\n Note that to take advantage of some SmartClient features like paging and custom validation,\n you need to return a DSResponse and provide the required metadata (like\n startRow/endRow/totalRows for paging).  You can simply return a <code>List</code> instead,\n but this won't work for large datasets.\n <p>\n So, for example, all of the following DataSource DMI method signatures are valid:\n <pre>\n public List myFetch(Map criteria)\n public List myFetch(SupplyItem criteria)\n public DSResponse myAdd(HttpSession session, \n                         DataSource ds, \n                         DSRequest dsRequest)\n </pre>\n <p>\n See\n <a href='/examples/server_integration/#customDataSourceIntegrationDMI' target='_blank'>the supplyItemDMI example</a>\n for an example of DataSource DMI.\n <p>\n <p>\n RPC DMIs work slightly differently.  Unlike DataSource DMIs, RPC DMIs can have an arbitrary\n number of required arguments, and also some optional context arguments.  For example, let's\n say you call a method from the client like so \n <smartclient>(note that there's a cleaner way to invoke\n DMIs if you use the ${isc.DocUtils.linkForRef('group:loadDMIStubsTag')} JSP tag)</smartclient>:\n <br>\n <smartclient><pre>\n DMI.call(\"myApp\", \"com.sample.MyClass\", \"doSomething\",\n          1, \"zoo\", [1, 2, 3], \"clientCallback()\");\n </pre>\n </smartclient>\n <smartgwt><pre>\n\t\tList someList = new ArrayList();\n\t\tsomeList.add(1);\n\t\tsomeList.add(2);\n\t\tDMI.call(\"myApp\", \"com.sample.MyClass\", \"doSomething\", new RPCCallback() {\n\t\t\t\n\t\t\t&#64;Override\n\t\t\tpublic void execute(RPCResponse response, Object rawData, RPCRequest request) {\n\t\t\t\t\n\t\t\t\tSC.say(\"raw data from server method:\" + rawData.toString());\n\t\t\t\t\n\t\t\t\t\n\t\t\t}\n\t\t}, new Object[] {1, \"zoo\", someList});\n </pre>\n </smartgwt>\n The server-side implementation of the method invoked must have a signature that\n will accept the arguments passed in from the client. In the example above \n <code>com.sample.MyClass.doSomething</code> should accept a Number, String, \n and a List as arguments.  SmartClient will try to adapt arguments where possible - \n so for example the first argument can be a Long or an Integer, or a native type \n (<code>long</code> or <code>int</code>) instead and the\n invocation will still work. \n <smartclient>\n JavaScript objects passed from the client becomes a Map on the server and will\n be automatically applied to a bean if the method argument takes a Bean in that position.\n </smartclient>\n <smartgwt>\n If a Map is passed from the client to the server it will\n be automatically applied to a bean if the method argument takes a Bean in that position.\n </smartgwt>\n See ${isc.DocUtils.linkForRef('attr:RPCRequest.data')} for a table of type conversions.\n <P>\n In addition to the parameters explicitly passed from the client, your method signature\n can include some additional arguments to pick up information about the request passed in.\n If your server side method is declared with arguments of the following type they will\n be passed to your DMI method.\n <ul>\n <li>HttpServletRequest\n <li>HttpServletResponse\n <li>HttpSession\n <li>RPCManager\n <li>RPCRequest\n </ul>\n <P>\n Your server side method can return a <code>RPCResponse</code> object giving you full\n control over the response sent to the server. If your method does not return a response,\n one will be created automatically and the return value from the server method will become the\n <code>data</code> value on the response. <br>\n See ${isc.DocUtils.linkForRef('attr:RPCRequest.data')} for an overview of how server side java data types are mapped \n to client side values.\n <smartclient>\n <p>\n See\n <a href='/examples/server_integration/#genericRPCIntegrationDMI' target='_blank'>the getTimeStampDMI example</a>\n for an example of RPC DMI.\n </smartclient>",
        name:"dmiOverview",
        seeAlso:[
            {
                ref:"group:applicationDeclaration",
                description:null
            },
            {
                ref:"group:loadDMIStubsTag",
                description:null
            },
            {
                ref:"class:ServerObject",
                description:null
            },
            {
                ref:"attr:DataSource.serverObject",
                description:null
            },
            {
                ref:"attr:OperationBinding.serverObject",
                description:null
            },
            {
                ref:"group:clientServerIntegration",
                description:null
            }
        ],
        type:"group",
        requiresModules:[
            "SCServer"
        ]
    },
    "method:HTMLFlow.setContentsURL":{
        ref:"method:HTMLFlow.setContentsURL",
        flags:"",
        description:" Change the URL this component loads content from.  Triggers a fetch for content from the new\n URL.\n <p>\n Can also be called with no arguments to reload content from the existing ${isc.DocUtils.linkForRef('attr:HTMLFlow.contentsURL')}.\n <P>\n This feature relies on the XMLHttpRequest object which can be disabled by end-users in some\n supported browsers.  See ${isc.DocUtils.linkForRef('group:platformDependencies')} for more information.\n\n",
        name:"setContentsURL",
        seeAlso:[
            {
                ref:"attr:HTMLFlow.evalScriptBlocks",
                description:null
            }
        ],
        params:[
            {
                description:"URL to retrieve contents from",
                optional:true,
                name:"url",
                defaultValue:null,
                type:"URL"
            },
            {
                description:"Parameters to send to the contentsURL.  Merged with                            <code>component.contentsURLParams</code> if both are set.",
                optional:true,
                name:"params",
                defaultValue:null,
                type:"Object"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('loadHtmlPages')}"
        ],
        definingClass:"class:HTMLFlow",
        groups:[
            "contentLoading"
        ]
    },
    "attr:ToolStripResizer.skinImgDir":{
        ref:"attr:ToolStripResizer.skinImgDir",
        flags:"IR",
        description:"Path to resizer image.",
        name:"skinImgDir",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"images/ToolStrip/\"",
        type:"attr",
        definingClass:"class:ToolStripResizer"
    },
    "attr:Canvas.scrollbarSize":{
        ref:"attr:Canvas.scrollbarSize",
        flags:"IRWA",
        getter:[
            "getScrollbarSize"
        ],
        description:"How thick should we make the scrollbars for this canvas.<br>\n\t\t\tNOTE: has no effect if showCustomScrollbars is false.",
        name:"scrollbarSize",
        seeAlso:[
            {
                ref:"method:Canvas.getScrollbarSize",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "scrolling"
        ]
    },
    "classMethod:RPCManager.sendRequest":{
        ref:"classMethod:RPCManager.sendRequest",
        flags:"",
        description:"\n Send the passed <code>RPCRequest</code> to the server.  If queuing is in effect, this queues\n the request instead.\n\n",
        name:"sendRequest",
        seeAlso:[
        ],
        params:[
            {
                description:"RPCRequest to send to the server",
                optional:false,
                name:"rpcRequest",
                defaultValue:null,
                type:"RPCRequest Properties"
            }
        ],
        type:"classMethod",
        definingClass:"class:RPCManager"
    },
    "attr:Calendar.eventNameFieldTitle":{
        ref:"attr:Calendar.eventNameFieldTitle",
        flags:"IR",
        description:"The title for the event name field in the quick and advanced event dialogs",
        name:"eventNameFieldTitle",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Event Name\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGridField.inputFormat":{
        ref:"attr:ListGridField.inputFormat",
        flags:"IRWA",
        description:"For fields of type <code>\"date\"</code> or <code>\"datetime\"</code>, if this is an editable\n listGrid, this property allows you to specify the ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat','inputFormat')}\n applied to the editor for this field.",
        name:"inputFormat",
        seeAlso:[
            {
                ref:"attr:ListGridField.dateFormatter",
                description:null
            }
        ],
        valueType:"DateInputFormat",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "method:Canvas.keyPress":{
        ref:"method:Canvas.keyPress",
        flags:"A",
        description:"\n Executed when a key is pressed and released on a focusable widget (${isc.DocUtils.linkForRef('attr:Canvas.canFocus')}:\n true).\n <P>\n Use ${isc.DocUtils.linkForRef('classMethod:EventHandler.getKey')} to find out the ${isc.DocUtils.linkForRef('type:KeyName','keyName')} of the key that\n was pressed, and use ${isc.DocUtils.linkForRef('classMethod:EventHandler.shiftKeyDown')} and related functions to determine\n whether modifier keys were down.\n\n",
        name:"keyPress",
        seeAlso:[
            {
                ref:"attr:Canvas.canFocus",
                description:null
            }
        ],
        returns:{
            description:"false to suppress native behavior in response to the keyPress, and prevent                   this event from bubbling to this widget's parent, or true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('keyboardEvents')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "method:CubeGrid.facetLabelOut":{
        ref:"method:CubeGrid.facetLabelOut",
        flags:"",
        description:" StringMethod handler fired when mouseout occurs over a facet label\n\n",
        name:"facetLabelOut",
        seeAlso:[
        ],
        params:[
            {
                description:"ID of the appropriate facet",
                optional:false,
                name:"facetId",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "events"
        ]
    },
    "method:Selection.deselect":{
        ref:"method:Selection.deselect",
        flags:"",
        description:"\t\t\tDeselect a particular item\n",
        name:"deselect",
        seeAlso:[
        ],
        params:[
            {
                description:"object to select",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"object"
            }
        ],
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "method:HiliteEditor.removeRule":{
        ref:"method:HiliteEditor.removeRule",
        flags:"",
        description:" Removes the passed ${isc.DocUtils.linkForRef('class:HiliteRule','HiliteRule')} from this editor.\n\n",
        name:"removeRule",
        seeAlso:[
        ],
        params:[
            {
                description:"the hiliteRule to remove",
                optional:false,
                name:"hiliteRule",
                defaultValue:null,
                type:"HiliteRule"
            }
        ],
        type:"method",
        definingClass:"class:HiliteEditor"
    },
    "attr:MultiGroupDialog.propertyFieldTitle":{
        ref:"attr:MultiGroupDialog.propertyFieldTitle",
        flags:"IR",
        description:"The title-text to appear in the header of the \"property\" field.\n <P>\n Note, this is a passthrough property which, when set, is passed through to the \n ${isc.DocUtils.linkForRef('class:MultiGroupPanel','MultiGroupPanel')} contained in this dialog.  You only need to\n consider the properties on the MultiGroupPanel for i18n.",
        name:"propertyFieldTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Column\"",
        type:"attr",
        definingClass:"class:MultiGroupDialog",
        groups:[
            "i18nMessages"
        ]
    },
    "method:DataBoundComponent.setSort":{
        ref:"method:DataBoundComponent.setSort",
        flags:"",
        description:" Sort this component by a list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.  If the component's data is not a \n ${isc.DocUtils.linkForRef('class:ResultSet')}, only the first specifier is applied.\n \n",
        name:"setSort",
        seeAlso:[
        ],
        params:[
            {
                description:"List of ${isc.DocUtils.linkForRef('object:SortSpecifier')} objects, one    per sort-field and direction",
                optional:false,
                name:"sortSpecifiers",
                defaultValue:null,
                type:"Array of SortSpecifier"
            }
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent"
    },
    "method:MultiGroupPanel.getGroup":{
        ref:"method:MultiGroupPanel.getGroup",
        flags:"",
        description:" Returns all configured grouping levels, as an array of ${isc.DocUtils.linkForRef('object:GroupSpecifier')}s.\n\n",
        name:"getGroup",
        seeAlso:[
        ],
        returns:{
            description:"the GroupSpecifiers for all configured grouping levels",
            type:"Array of GroupSpecifier"
        },
        type:"method",
        definingClass:"class:MultiGroupPanel"
    },
    "method:ListGrid.getRecord":{
        ref:"method:ListGrid.getRecord",
        flags:"A",
        description:" Return the pointer to a particular record by record number.\n Synonym for ${isc.DocUtils.linkForRef('method:ListGrid.getCellRecord')}.\n\n",
        name:"getRecord",
        seeAlso:[
            {
                ref:"method:ListGrid.getCellRecord",
                description:null
            },
            {
                ref:"method:ListGrid.getEditedRecord",
                description:null
            }
        ],
        params:[
            {
                description:"row index of record to return.",
                optional:false,
                name:"recordNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"Record object for the row.",
            type:"ListGridRecord"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Class.observe":{
        ref:"method:Class.observe",
        flags:"",
        description:" Take an arbitrary action whenever a method is called on an instance.<br><br>\n\n When you observe some method of another object, eg:<br>\n\t\t\t<code>thisObject.observe(thatObject, \"someMethod\", \"observer.foo()\")</code><br><br>\n\n When <code>thatObject.someMethod()</code> is called,<br>\n\t\t\t<code>thisObject.foo()</code> <br>\n will be called automatically, after the observed method completes.<br><br>\n\n Action is typically a string expression.  Available variables:\n <ul>\n    <li> observed: target of the observation, that is, object passed to observe()\n    <li> observer: object that observes, that is, object that observe() was called on\n    <li> returnVal: return value of observed function\n </ul>\n\n An unlimited number of observers can observe any message, they will all be notified\n automatically in the order that the observations were set up.<br><br>\n\n NOTES:\n - observation also works on JavaScript Array objects\n - a method may trigger an observation of itself by another object, either through code\n   within the method itself or within an observer's action.  In this case the observation\n   will be set up, but the new observation action will not fire as part of this thread.\n   When the method is called again in the future the newly added observer will be fired.\n\n\n",
        name:"observe",
        seeAlso:[
            {
                ref:"method:Class.ignore",
                description:null
            }
        ],
        params:[
            {
                description:"object to observe",
                optional:false,
                name:"object",
                defaultValue:null,
                type:"object"
            },
            {
                description:"name of the method to observe",
                optional:false,
                name:"methodName",
                defaultValue:null,
                type:"string"
            },
            {
                description:"String for the function to call.\t\t\t\t\t\t\t\t\t\tIn this string,\n\t\t\t\t\t\t\t\t\t\t\t<code>observer</code> is the object that is observing,\n\t\t\t\t\t\t\t\t\t\t\t<code>this</code> is the object that is being observed\n\n\t\t\t\t\t\t\t\t\t\tIf <code>action</code> is not specified,\n\t\t\t\t\t\t\t\t\t\t\t<code>observer.methodName()</code> will be called.",
                optional:true,
                name:"action",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"true == observation set up, false == observation not set up",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Class",
        groups:[
            "observation"
        ]
    },
    "attr:ListGrid.canPickFields":{
        ref:"attr:ListGrid.canPickFields",
        flags:"IRW",
        description:"Indicates whether the field picker item and submenu should be present in the header\n context menu. This menu allows the user to hide visible fields and show hidden fields.\n <p>\n By default only fields explicitly included in the ${isc.DocUtils.linkForRef('attr:ListGrid.fields')} array will\n be available in this menu, unless ${isc.DocUtils.linkForRef('attr:ListGrid.canPickOmittedFields')} is set to true for\n a databound grid.\n <p>\n A specific field can be omitted from the column picker via ${isc.DocUtils.linkForRef('attr:ListGridField.canHide')}.",
        name:"canPickFields",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:TabSet.showPartialEdges":{
        ref:"attr:TabSet.showPartialEdges",
        flags:"IRA",
        description:"If the paneContainer for this tab set is showing ${isc.DocUtils.linkForRef('attr:Canvas.showEdges','edges')}, setting this\n attribute to <code>true</code> will set the paneContainer to show\n ${isc.DocUtils.linkForRef('attr:Canvas.customEdges','customEdges')} for the three sides opposing the tabBarPosition.",
        name:"showPartialEdges",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "attr:DataBoundComponent.useAllDataSourceFields":{
        ref:"attr:DataBoundComponent.useAllDataSourceFields",
        flags:"IRW",
        description:"If true, the set of fields given by the \"default binding\" (see \n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fields')}) is used, with any fields specified in\n <code>component.fields</code> acting as overrides that can suppress or modify the\n display of individual fields, without having to list the entire set of fields that\n should be shown.\n <P>\n If <code>component.fields</code> contains fields that are not found in the DataSource,\n they will be shown after the most recently referred to DataSource field.  If the new\n fields appear first, they will be shown first.\n <P>\n ${isc.DocUtils.linkForExampleId('validationFieldBinding', 'This example')} shows a mixture of component\n fields and DataSource fields, and how they interact for validation.",
        name:"useAllDataSourceFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('validationFieldBinding')}"
        ],
        definingClass:"interface:DataBoundComponent",
        groups:[
            "databinding"
        ]
    },
    "attr:ListGrid.alternateFieldStyles":{
        ref:"attr:ListGrid.alternateFieldStyles",
        flags:"IRW",
        description:"Whether alternating columns should be drawn in alternating styles, in order to create a \n vertical \"ledger\" effect for easier reading.  If enabled, the cell style for alternate \n columns will have \"Dark\" appended to it.",
        name:"alternateFieldStyles",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "cellStyling"
        ]
    },
    "method:Canvas.setClassName":{
        ref:"method:Canvas.setClassName",
        deprecated:"As of SmartClient version 5.5, use ${isc.DocUtils.linkForRef('method:Canvas.setStyleName')} instead.",
        flags:"A",
        description:" Sets the CSS class for this widget\n",
        name:"setClassName",
        seeAlso:[
        ],
        params:[
            {
                description:"new CSS class name (must be defined previously)",
                optional:false,
                name:"newClass",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "appearance"
        ]
    },
    "classMethod:Offline.goOnline":{
        ref:"classMethod:Offline.goOnline",
        flags:"",
        description:" Explicitly sets this session into online mode.  This setting will override whatever \n state the browser reports.  This allows users to manually set an application into \n offline or online state.\n \n",
        name:"goOnline",
        seeAlso:[
            {
                ref:"classMethod:Offline.goOffline",
                description:null
            },
            {
                ref:"classMethod:Offline.useNativeOfflineDetection",
                description:null
            }
        ],
        type:"classMethod",
        definingClass:"class:Offline"
    },
    "attr:DynamicForm.titleOrientation":{
        flags:"IRW",
        getter:[
            "getTitleOrientation"
        ],
        type:"attr",
        ref:"attr:DynamicForm.titleOrientation",
        description:"Default orientation for titles for items in this form.  ${isc.DocUtils.linkForRef('type:TitleOrientation')}\n lists valid options.\n <P>\n Note that titles on the left or right take up a cell in tabular\n ${isc.DocUtils.linkForRef('group:formLayout','form layouts')}, but titles on top do not.",
        name:"titleOrientation",
        setter:[
            "setTitleOrientation"
        ],
        valueType:"TitleOrientation",
        seeAlso:[
        ],
        examples:[
            "${isc.DocUtils.linkForExampleId('formLayoutTitles')}"
        ],
        defaultValue:"\"left\"",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ]
    },
    "attr:SelectItem.showHintInField":{
        ref:"attr:SelectItem.showHintInField",
        flags:"IRWA",
        description:"If showing a hint for this form item, should it be shown within the field?\n <P>CSS style for the hint is ${isc.DocUtils.linkForRef('attr:SelectItem.textBoxStyle')} with the suffix\n \"Hint\" appended to it.",
        name:"showHintInField",
        seeAlso:[
            {
                ref:"attr:FormItem.hint",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGrid.errorIconSrc":{
        ref:"attr:ListGrid.errorIconSrc",
        flags:"IRW",
        description:"Src of the image to show as an error icon, if we're showing icons when validation\n      errors occur.",
        name:"errorIconSrc",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]/ListGrid/validation_error_icon.png\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "errorIcon"
        ]
    },
    "type:DragIntersectStyle":{
        ref:"type:DragIntersectStyle",
        values:[
            {
                description:"Look for drop targets that are under the current mouse cursor position.",
                value:"\"mouse\""
            },
            {
                description:"Look for drop targets by intersection of the entire rect of the drag               target with the droppable target.",
                value:"\"rect\""
            }
        ],
        description:"Different styles of determining intersection: with mouse or entire rect of target",
        name:"DragIntersectStyle",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "dragdrop"
        ]
    },
    "group:enable":{
        ref:"group:enable",
        title:"Enabling and Disabling",
        refs:[
            "method:Canvas.setEnabled",
            "method:Canvas.setDisabled",
            "method:Canvas.enable",
            "method:Canvas.disable",
            "method:Canvas.isDisabled",
            "method:Canvas.isEnabled",
            "method:StatefulCanvas.setDisabled",
            "method:Button.setDisabled",
            "method:ImgButton.setDisabled",
            "method:StretchImgButton.setDisabled",
            "method:FormItem.setDisabled",
            "method:FormItem.isDisabled",
            "method:FormItem.enable",
            "method:FormItem.disable",
            "attr:Canvas.disabled",
            "attr:Canvas.enabled"
        ],
        description:"Disabled components do not respond to mouse or keyboard events, and change appearance to\n indicate they are disabled.",
        name:"enable",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:FilterBuilder.operatorPickerTitle":{
        ref:"attr:FilterBuilder.operatorPickerTitle",
        flags:"IR",
        description:"The title for the operator-picker select-item.",
        name:"operatorPickerTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Operator\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:CubeGrid.canSortFacets":{
        ref:"attr:CubeGrid.canSortFacets",
        flags:"IRW",
        description:"If true, sort controls will be shown on FacetHeaders.\n <P>\n When clicked, sort controls call ${isc.DocUtils.linkForRef('method:CubeGrid.sortByFacetId')}.",
        name:"canSortFacets",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "attr:MultiComboBoxItem.buttonDefaults":{
        ref:"attr:MultiComboBoxItem.buttonDefaults",
        flags:"RA",
        description:"Default properties to be used in creating each ${isc.DocUtils.linkForRef('class:IButton')}.",
        name:"buttonDefaults",
        seeAlso:[
        ],
        valueType:"IButton Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiComboBoxItem"
    },
    "method:ComboBoxItem.getPickListFilterCriteria":{
        ref:"method:ComboBoxItem.getPickListFilterCriteria",
        flags:"A",
        description:" ${isc.DocUtils.linkForRef('group:stringMethods','StringMethod')} to return filter criteria for options displayed for\n this item.  \n <P>\n See ${isc.DocUtils.linkForRef('group:comboBoxFiltering')} for details on how pickList filter criteria\n are calculated by default for a comboBoxItem.\n    \n",
        name:"getPickListFilterCriteria",
        seeAlso:[
        ],
        returns:{
            description:"criteria to be used for databound or local filtering",
            type:"Criteria"
        },
        type:"method",
        definingClass:"class:ComboBoxItem"
    },
    "method:GridRenderer.rowDoubleClick":{
        ref:"method:GridRenderer.rowDoubleClick",
        flags:"A",
        description:" Called when a row receives a double click event.\n\n",
        name:"rowDoubleClick",
        seeAlso:[
        ],
        params:[
            {
                description:"Record object returned from getCellRecord()",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "attr:CanvasItem.canvas":{
        ref:"attr:CanvasItem.canvas",
        flags:"IRW",
        description:"The canvas that will be displayed inside this item.  You can pass an instance you've \n already created, or its global ID as a String. You can also implement \n ${isc.DocUtils.linkForRef('method:CanvasItem.createCanvas')} to dynamically create the canvas when the FormItem\n is initialized.\n <P>\n If <code>canvas</code> and <code>createCanvas()</code> are unspecified, the \n canvas for this item will be auto-created using the overrideable defaults:\n ${isc.DocUtils.linkForRef('attr:CanvasItem.canvasProperties')} and ${isc.DocUtils.linkForRef('attr:CanvasItem.canvasConstructor')}\n <P>\n Note that ${isc.DocUtils.linkForRef('attr:Canvas.canvasItem')} will be set on the canvas to point back to this\n item.",
        name:"canvas",
        setter:[
            "setCanvas"
        ],
        seeAlso:[
        ],
        valueType:"Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CanvasItem"
    },
    "method:TileLayout.setTileVMargin":{
        ref:"method:TileLayout.setTileVMargin",
        flags:"",
        description:" Sets the vertical margin of tiles.\n",
        name:"setTileVMargin",
        seeAlso:[
        ],
        params:[
            {
                description:"width",
                optional:false,
                name:"",
                defaultValue:null,
                type:"Integer"
            }
        ],
        type:"method",
        definingClass:"class:TileLayout",
        groups:[
            "tileLayout"
        ]
    },
    "attr:DateChooser.applyButton":{
        ref:"attr:DateChooser.applyButton",
        flags:"IR",
        description:"When a DateChooser is configured for ${isc.DocUtils.linkForRef('attr:DateChooser.timeItem','a \"datetime\" value')},\n clicking on a date cell in the ${isc.DocUtils.linkForRef('attr:DateChooser.dateGrid','grid')} will not automatically\n dismiss the DateChooser canvas.  In this case, use the <code>Apply</code> button to\n accept the selected date and time and dismiss the chooser.",
        name:"applyButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:DataSource.testData":{
        deprecated:"In favor of ${isc.DocUtils.linkForRef('attr:DataSource.cacheData')}.",
        flags:"IRW",
        type:"attr",
        ref:"attr:DataSource.testData",
        description:"For a client-only DataSource, a set of records to use as a dataset, specified as an\n Array of JavaScript Objects. \n <P>\n See ${isc.DocUtils.linkForRef('group:clientOnlyDataSources','this discussion')} for ways to populate a\n client-only DataSource with test data.",
        name:"testData",
        setter:[
            "setTestData"
        ],
        valueType:"Array of Record",
        seeAlso:[
        ],
        defaultValue:"null",
        groups:[
            "clientData"
        ],
        definingClass:"class:DataSource"
    },
    "attr:ListGrid.editOnFocus":{
        ref:"attr:ListGrid.editOnFocus",
        flags:"IRWA",
        description:"Should we start editing when this widget receives focus (if this ListGrid supports\n editing)?\n <P>\n Note that this property being set to true will cause editing to occur on a single\n click, even if ${isc.DocUtils.linkForRef('attr:ListGrid.editEvent')} is <code>\"doubleClick\"</code>, because single clicking\n the grid will place keyboard focus there automatically.\n <P>\n If this property is set together with ${isc.DocUtils.linkForRef('attr:ListGrid.listEndEditAction')} being set to \"next\", \n users can create a new edit row in an empty grid by simply tabbing into the grid.",
        name:"editOnFocus",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "attr:Canvas.canvasItem":{
        ref:"attr:Canvas.canvasItem",
        flags:"R",
        description:"If this canvas is being displayed in a ${isc.DocUtils.linkForRef('class:CanvasItem')}, this property will be set\n to point at the item. Otherwise this property will be null.",
        name:"canvasItem",
        seeAlso:[
        ],
        valueType:"CanvasItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas"
    },
    "attr:DataSource.transformMultipleFields":{
        ref:"attr:DataSource.transformMultipleFields",
        flags:"IR",
        description:"If set to \"false\", transformation of values for\n ${isc.DocUtils.linkForRef('attr:DataSourceField.multiple','multiple:true')} fields, normally controlled by\n ${isc.DocUtils.linkForRef('attr:DataSourceField.multipleStorage')}, is instead disabled for this entire DataSource.",
        name:"transformMultipleFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSource",
        groups:[
            "multipleField"
        ]
    },
    "method:ListGrid.getExpansionComponent":{
        ref:"method:ListGrid.getExpansionComponent",
        flags:"",
        description:" Gets the embedded-component to show as a given record's expansionComponent.  This\n component is then housed in ${isc.DocUtils.linkForRef('attr:ListGrid.expansionLayout','a VLayout')} and embedded\n into a record's row.\n <P>\n By default, this method returns one of a set of built-in components, according to the\n value of ${isc.DocUtils.linkForRef('type:ExpansionMode','listGrid.expansionMode')}.  You can override this method\n to return any component you wish to provide as an expansionComponent.\n <P>\n As long as the record is expanded, this component may be retrieved via a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.getCurrentExpansionComponent')}.\n <P>\n When an expanded record is collapsed, the component is disassociated from the record and\n may or may not be automatically destroyed.  By default, built-in components\n will be destroyed on unembed.  Custom expansion components, created via an override of\n getExpansionComponents(), may not be auto-destroyed, according to the\n ${isc.DocUtils.linkForRef('type:ExpansionComponentPoolingMode','pooling mode')} being used.\n\n",
        name:"getExpansionComponent",
        seeAlso:[
        ],
        params:[
            {
                description:"record to get the expansionComponent for",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            }
        ],
        returns:{
            description:"the component to embed",
            type:"Canvas | Canvas Properties"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "attr:DataBoundComponent.offlineMessage":{
        ref:"attr:DataBoundComponent.offlineMessage",
        flags:"IRW",
        description:"Message to display when this DataBoundComponent attempts to load data that is not available\n because the browser is currently offline.  Depending on the component, the message is either\n displayed in the component's body, or in a pop-up warning dialog.",
        name:"offlineMessage",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"This data not available while offline\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('offlineSupport')}"
        ],
        definingClass:"interface:DataBoundComponent",
        groups:[
            "i18nMessages",
            "offlineGroup"
        ]
    },
    "attr:Mail.to":{
        ref:"attr:Mail.to",
        flags:"IR",
        description:"Comma-separated list of recipients.  Like all other <code>String</code> \n properties of <code>Mail</code>, you can use Velocity substitution variables in this property.\n <p>\n If you specify a \"To:\" line in the body of your email, recipient addresses will be parsed \n and this property will be ignored.",
        name:"to",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:Mail",
        groups:[
            "mail"
        ]
    },
    "attr:Menu.autoDraw":{
        ref:"attr:Menu.autoDraw",
        flags:"IRWA",
        description:"Menus will not draw on initialization, until they're explicitly show()n",
        name:"autoDraw",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Menu"
    },
    "type:LogicalOperator":{
        ref:"type:LogicalOperator",
        values:[
            {
                description:"true if all criteria are true",
                value:"\"and\""
            },
            {
                description:"true if any criteria are true",
                value:"\"or\""
            },
            {
                description:"true if all criteria are false",
                value:"\"not\""
            }
        ],
        description:"Operators that can evaluate a set of criteria and produce a combined result.",
        name:"LogicalOperator",
        seeAlso:[
        ],
        type:"type"
    },
    "attr:TreeGrid.data":{
        ref:"attr:TreeGrid.data",
        flags:"IRW",
        description:"A ${isc.DocUtils.linkForRef('class:Tree')} object containing of nested ${isc.DocUtils.linkForRef('object:TreeNode')}s to \n display as rows in this TreeGrid.  \n The <code>data</code> property will typically not be explicitly specified for \n databound TreeGrids, where the data is returned from the server via databound component\n methods such as <code>fetchData()</code>",
        name:"data",
        setter:[
            "setData"
        ],
        seeAlso:[
        ],
        valueType:"Tree",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "data"
        ]
    },
    "attr:FormItem.hint":{
        ref:"attr:FormItem.hint",
        flags:"IRW",
        description:"Specifies \"hint\" string to show next to the form item to indicate something to the user.\n This string generally appears to the right of the form item.",
        name:"hint",
        setter:[
            "setHint"
        ],
        seeAlso:[
            {
                ref:"attr:FormItem.hintStyle",
                description:null
            }
        ],
        valueType:"HTMLString",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('formHints')}"
        ],
        definingClass:"class:FormItem",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGridField.canExport":{
        ref:"attr:ListGridField.canExport",
        flags:"IR",
        description:"Dictates whether the data in this field be exported.  Explicitly set this\n  to false to prevent exporting.  Has no effect if the underlying\n  ${isc.DocUtils.linkForRef('attr:DataSourceField.canExport','dataSourceField')} is explicitly set to\n  canExport: false.",
        name:"canExport",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "attr:SectionStack.itemEndIndent":{
        ref:"attr:SectionStack.itemEndIndent",
        flags:"IRW",
        description:"Size, in pixels, of indentation of all member items relative to the end of\n the alignment axis. For instance, for left-aligned members, \n itemStartIndent specifies indentation for every item from the right side of the\n section stack.",
        name:"itemEndIndent",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"undefined",
        type:"attr",
        definingClass:"class:SectionStack",
        groups:[
            "layoutMember"
        ]
    },
    "method:Canvas.showNextTo":{
        ref:"method:Canvas.showNextTo",
        flags:"",
        description:" Show this widget next to another widget on the page, positioned such that it will \n not extend beyond the browser viewport.\n <P>\n Note that this method simply sets the coordinates of the widget and displays it (using\n a ${isc.DocUtils.linkForRef('method:Canvas.animateShow')} by default). It will\n not change the ${isc.DocUtils.linkForRef('attr:Canvas.parentElement')} of either component.\n <P>\n An example use case might be showing a menu next to a menu-button.\n\n",
        name:"showNextTo",
        seeAlso:[
        ],
        params:[
            {
                description:"Canvas to show next to",
                optional:false,
                name:"otherWidget",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"which side to show on, defaults to \"right\"",
                optional:true,
                name:"side",
                defaultValue:null,
                type:"String"
            },
            {
                description:"This argument controls whether this canvas can be positioned on top of the other\n  widget if there isn't room to put it next to the other widget extending out of the\n  browser viewport<br>\n  If 'canOcclude' is true, simply shift this widget over the other widget, so that\n  it ends up onscreen.  If 'canOcclude' is false, avoid extending offscreen\n  by positioning this widget on the other side of the other widget.",
                optional:true,
                name:"canOcclude",
                defaultValue:null,
                type:"boolean"
            },
            {
                description:"If <code>false</code> do not use an animation to  show the component.",
                optional:true,
                name:"skipAnimation",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:Canvas"
    },
    "attr:SectionStackSection.controls":{
        ref:"attr:SectionStackSection.controls",
        flags:"IR",
        description:"Custom controls to be shown on top of this section header.\n <P>\n These controls are shown in the ${isc.DocUtils.linkForRef('attr:SectionHeader.controlsLayout')}.\n <P>\n Note that this is an init-time property. If you need to dynamically change what \n controls are displayed to the user, we would recommend embedding the\n controls in a Layout or similar container. \n This will allow you to show/hide or add/remove members at runtime\n by manipulating the existing control(s) set up at init time.",
        name:"controls",
        seeAlso:[
        ],
        valueType:"Array of Canvas",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('sectionControls')}"
        ],
        definingClass:"object:SectionStackSection"
    },
    "attr:PortalLayout.columnOverflow":{
        ref:"attr:PortalLayout.columnOverflow",
        flags:"IRWA",
        description:"Controls the ${isc.DocUtils.linkForRef('attr:Canvas.overflow','overflow')} setting for each column. If set to \"auto\" (the\n default) then each column will scroll individually (if its ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} overflow\n the column height). You can also use \"hidden\" to clip overflowing heights, or \"visible\" to\n show the overflow. The effect of \"visible\" will depend on the setting for ${isc.DocUtils.linkForRef('attr:PortalLayout.overflow')}\n -- by default, the PortalLayout as a whole will scroll when necessary.",
        name:"columnOverflow",
        setter:[
            "setColumnOverflow"
        ],
        seeAlso:[
            {
                ref:"type:Overflow",
                description:null
            },
            {
                ref:"attr:Canvas.overflow",
                description:null
            }
        ],
        valueType:"Overflow",
        defaultValue:"\"auto\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('portalLayoutColumnHeight')}"
        ],
        definingClass:"class:PortalLayout",
        groups:[
            "sizing"
        ]
    },
    "method:TreeGrid.dataArrived":{
        ref:"method:TreeGrid.dataArrived",
        flags:"",
        description:" Notification method fired whenever this TreeGrid receives new data nodes from the \n dataSource. Only applies to databound TreeGrids where ${isc.DocUtils.linkForRef('attr:TreeGrid.data')} is a \n ${isc.DocUtils.linkForRef('class:ResultTree')} - either explicitly created and applied via ${isc.DocUtils.linkForRef('method:TreeGrid.setData')} or\n automatically generated via a ${isc.DocUtils.linkForRef('method:TreeGrid.fetchData','fetchData()')} call.\n",
        name:"dataArrived",
        seeAlso:[
        ],
        params:[
            {
                description:"The parentNode for which children were just loaded",
                optional:false,
                name:"parentNode",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:GridRenderer.getCellCSSText":{
        ref:"method:GridRenderer.getCellCSSText",
        flags:"A",
        description:" Return CSS text for styling this cell, which will be applied in addition to the CSS class\n for the cell, as overrides.\n <p>\n \"CSS text\" means semicolon-separated style settings, suitable for inclusion in a CSS\n stylesheet or in a STYLE attribute of an HTML element.\n\n",
        name:"getCellCSSText",
        seeAlso:[
            {
                ref:"method:GridRenderer.getCellStyle",
                description:null
            }
        ],
        params:[
            {
                description:"cell record as returned by getCellRecord",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"CSS text for this cell",
            type:"string"
        },
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "type:DataLineType":{
        ref:"type:DataLineType",
        values:[
            {
                description:"simple straight lines between points that are adjacent in the dataset",
                value:"\"straight\""
            },
            {
                description:"smooth spline curve between points that are adjacent in the dataset",
                value:"\"smooth\""
            }
        ],
        description:"Algorithms for drawing lines between points.",
        name:"DataLineType",
        seeAlso:[
        ],
        type:"type"
    },
    "method:Scrollbar.setScrollTarget":{
        ref:"method:Scrollbar.setScrollTarget",
        flags:"",
        description:"          Sets or clears the scrollbar's scrollTarget. If no argument is provided, then the\n          scrollTarget will be set to the scrollbar itself.\n\n",
        name:"setScrollTarget",
        seeAlso:[
        ],
        params:[
            {
                description:"target canvas to be scrolled",
                optional:true,
                name:"newTarget",
                defaultValue:null,
                type:"Canvas"
            }
        ],
        type:"method",
        definingClass:"class:Scrollbar",
        groups:[
            "scroll"
        ]
    },
    "classAttr:Canvas.neverUsePNGWorkaround":{
        ref:"classAttr:Canvas.neverUsePNGWorkaround",
        flags:"IR",
        description:"If set, the AlphaImageLoader IE filter will never be used.   Does not remove\n AlphaImageLoader usage in already-drawn components.\n <P>\n See ${isc.DocUtils.linkForRef('group:IEFilters')} for background.",
        name:"neverUsePNGWorkaround",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"classAttr",
        definingClass:"class:Canvas",
        groups:[
            "IEFilters"
        ]
    },
    "attr:ServerObject.dropExtraFields":{
        ref:"attr:ServerObject.dropExtraFields",
        flags:"IR",
        description:"By default, for DMI DSResponses, DSResponse.data is filtered on the server to just the set\n of fields defined on the DataSource.  This behavior can be overridden in several ways - see\n the overview in ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} for details.  The value of this attribute overrides\n ${isc.DocUtils.linkForRef('attr:DataSource.dropExtraFields')}.",
        name:"dropExtraFields",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:ServerObject"
    },
    "method:FormItemIcon.click":{
        ref:"method:FormItemIcon.click",
        flags:"",
        description:"  Called when this icon is clicked. The default action is to call ${isc.DocUtils.linkForRef('method:FormItem.showPicker')}.\n",
        name:"click",
        seeAlso:[
        ],
        params:[
            {
                description:"The Dynamic Form to which this icon's item belongs.",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            },
            {
                description:"The Form Item containing this icon",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            },
            {
                description:"A pointer to the form item icon clicked",
                optional:false,
                name:"icon",
                defaultValue:null,
                type:"FormItemIcon"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('formIcons')}"
        ],
        definingClass:"object:FormItemIcon",
        groups:[
            "formIcons"
        ]
    },
    "attr:ListGrid.longTextEditorType":{
        ref:"attr:ListGrid.longTextEditorType",
        flags:"IRW",
        description:"When the length of the field specified by ${isc.DocUtils.linkForRef('attr:DataSourceField.length')} exceeds\n <code>this.longTextEditorThreshold</code> show an edit field of this type\n rather than the standard text field when the field enters inline edit mode.",
        name:"longTextEditorType",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"PopUpTextAreaItem\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "attr:MultiComboBoxItem.comboBox":{
        ref:"attr:MultiComboBoxItem.comboBox",
        flags:"RA",
        description:"An ${isc.DocUtils.linkForRef('type:AutoChild')} attribute to create the combo box in a MultiComboBoxItem.",
        name:"comboBox",
        seeAlso:[
        ],
        valueType:"AutoChild ComboBoxItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiComboBoxItem"
    },
    "attr:SectionStack.headerHeight":{
        ref:"attr:SectionStack.headerHeight",
        flags:"IR",
        description:"Height of headers for sections.",
        name:"headerHeight",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:SectionStack"
    },
    "method:ListGrid.setShowGridSummary":{
        ref:"method:ListGrid.setShowGridSummary",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary')} attribute\n",
        name:"setShowGridSummary",
        seeAlso:[
        ],
        params:[
            {
                description:"new value for this.showGridSummary",
                optional:false,
                name:"showGridSummary",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:DrawLabel.setLineColor":{
        ref:"method:DrawLabel.setLineColor",
        flags:"",
        description:" Sets the text color of the label.\n",
        name:"setLineColor",
        seeAlso:[
        ],
        params:[
            {
                description:"new text color.",
                optional:false,
                name:"color",
                defaultValue:null,
                type:"CSSColor"
            }
        ],
        type:"method",
        definingClass:"class:DrawLabel"
    },
    "attr:PortalLayout.showColumnMenus":{
        ref:"attr:PortalLayout.showColumnMenus",
        flags:"IRW",
        description:"Should a menu be shown within each column with options to add / remove columns?",
        name:"showColumnMenus",
        setter:[
            "setShowColumnMenus"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('addRemovePortalColumn')}"
        ],
        definingClass:"class:PortalLayout"
    },
    "method:MultiSortPanel.getSort":{
        ref:"method:MultiSortPanel.getSort",
        flags:"",
        description:" Returns all configured sorting levels, as an array of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n\n",
        name:"getSort",
        seeAlso:[
        ],
        returns:{
            description:"the SortSpecifiers for all configured sorting levels",
            type:"Array of SortSpecifier"
        },
        type:"method",
        definingClass:"class:MultiSortPanel"
    },
    "attr:ActiveXControl.codeBase":{
        ref:"attr:ActiveXControl.codeBase",
        flags:"IR",
        description:"Specifies the URL from which to load the ActiveX control.",
        name:"codeBase",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ActiveXControl"
    },
    "attr:Menu.iconFieldDefaults":{
        ref:"attr:Menu.iconFieldDefaults",
        flags:"IR",
        description:"Default properties for the automatically generated icon column.\n Default object includes properties to set width and to show icon for this column.\n <P>\n To modify the behavior or appearance of this column, developers may set\n ${isc.DocUtils.linkForRef('attr:Menu.iconFieldProperties')} at the instance level, or override this\n object at the class level. If overriding this object, we recommend using\n ${isc.DocUtils.linkForRef('classMethod:Class.changeDefaults')} rather than replacing this object entirely.\n <P>\n See ${isc.DocUtils.linkForRef('attr:Menu.showIcons')} for an overview of the icon column.",
        name:"iconFieldDefaults",
        seeAlso:[
        ],
        valueType:"ListGridField properties",
        defaultValue:"object",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:Array.addAt":{
        ref:"method:Array.addAt",
        flags:"",
        description:" Add a single item to this array at a specific position in the list, sliding other items over\n to fit.\n\n",
        name:"addAt",
        seeAlso:[
        ],
        params:[
            {
                description:"object to add",
                optional:false,
                name:"obj",
                defaultValue:null,
                type:"object"
            },
            {
                description:"position in the list to add at",
                optional:false,
                name:"pos",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"object that was added",
            type:"object"
        },
        type:"method",
        definingClass:"object:Array",
        groups:[
            "modification"
        ]
    },
    "attr:DataBoundComponent.dataPageSize":{
        ref:"attr:DataBoundComponent.dataPageSize",
        flags:"IRW",
        description:"When using ${isc.DocUtils.linkForRef('attr:DataBoundComponent.dataFetchMode','data paging')}, how many records to fetch at a time.  The value of this\n attribute is passed on to the auto-constructed ${isc.DocUtils.linkForRef('class:ResultSet')} object for this\n component.  In effect, this gives you control over the ${isc.DocUtils.linkForRef('attr:ResultSet.resultSize')}\n attribute for this component.\n <P>\n <b>Note</b> that regardless of the <code>dataPageSize</code> setting, a component will always fetch\n all of data that it needs to draw.  Settings such as\n ${isc.DocUtils.linkForRef('attr:ListGrid.showAllRecords','showAllRecords:true')},\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAllMaxCells','drawAllMaxCells')} and\n ${isc.DocUtils.linkForRef('attr:ListGrid.drawAheadRatio','drawAheadRatio')} can cause more rows than the configured\n <code>dataPageSize</code> to be fetched.",
        name:"dataPageSize",
        seeAlso:[
            {
                ref:"attr:ResultSet.resultSize",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"75",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "databinding"
        ]
    },
    "attr:SummaryBuilder.formulaField":{
        ref:"attr:SummaryBuilder.formulaField",
        flags:"IR",
        description:"TextItem that users type into when entering a formula.",
        name:"formulaField",
        seeAlso:[
        ],
        valueType:"AutoChild TextItem",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:[
            "summaryFields"
        ]
    },
    "attr:ListGrid.skinImgDir":{
        ref:"attr:ListGrid.skinImgDir",
        flags:"IRWA",
        description:"Where do 'skin' images (those provided with the class) live?",
        name:"skinImgDir",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"\"images/ListGrid/\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "appearance",
            "images"
        ]
    },
    "attr:SummaryBuilder.showAutoHideCheckBox":{
        ref:"attr:SummaryBuilder.showAutoHideCheckBox",
        flags:"IR",
        description:"Whether to show a checkbox offering the user the ability to automatically\n hide any fields involved in the formula.",
        name:"showAutoHideCheckBox",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:[
            "summaryFields"
        ]
    },
    "attr:DrawLabel.alignment":{
        ref:"attr:DrawLabel.alignment",
        flags:"IR",
        description:"Sets the text alignment from the x position. Similar to html5 context.textAlign, eg \"start\", \"center\", \"end\"",
        name:"alignment",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"start\"",
        type:"attr",
        definingClass:"class:DrawLabel"
    },
    "method:FormItem.storeValue":{
        ref:"method:FormItem.storeValue",
        flags:"",
        description:" Store (and optionally show) a value for this form item. \n <p>\n This method will fire standard ${isc.DocUtils.linkForRef('method:FormItem.change')} and\n ${isc.DocUtils.linkForRef('method:DynamicForm.itemChanged')} handlers, and store the value passed in such that\n subsequent calls to ${isc.DocUtils.linkForRef('method:FormItem.getValue')} or ${isc.DocUtils.linkForRef('method:DynamicForm.getValue')} will\n return the new value for this item.\n <P>\n This method is intended to provide a way for custom formItems - most commonly \n ${isc.DocUtils.linkForRef('class:CanvasItem','canvasItems')} - to provide a new interface to the user, allowing them\n to manipulate the item's value, for example in an embedded ${isc.DocUtils.linkForRef('attr:CanvasItem.canvas')},\n or a pop-up dialog launched from an ${isc.DocUtils.linkForRef('object:FormItemIcon','icon')}, etc.  Developers\n should call this method when the user interacts with this custom \n interface in order to store the changed value.\n <P>\n ${isc.DocUtils.linkForRef('attr:CanvasItem.shouldSaveValue','shouldSaveValue')} for CanvasItems is\n false by default. Custom CanvasItems will need to override shouldSaveValue\n to true if the values stored via this API should be included in the form's\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','getValues()')} and saved with the form when\n ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saveData()')} is called.\n <P>\n If you cannot easily detect interactions that should change the value as the \n user performs them, a workaround is to call\n <code>storeValue</code> right before the form saves.\n <P>\n Note that this method is not designed for customizing a value which is already being\n saved by a standard user interaction. For example you should not call this method\n from a ${isc.DocUtils.linkForRef('method:FormItem.change','change handler')}. Other APIs such as \n ${isc.DocUtils.linkForRef('method:FormItem.transformInput')} exist for this.\n \n",
        name:"storeValue",
        seeAlso:[
        ],
        params:[
            {
                description:"value to save for this item",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"Should the formItem be updated to display the new value?",
                optional:true,
                name:"showValue",
                defaultValue:null,
                type:"Boolean"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('canvasItem')}"
        ],
        definingClass:"class:FormItem"
    },
    "attr:TreeGrid.nodeIcon":{
        ref:"attr:TreeGrid.nodeIcon",
        flags:"IRW",
        description:"The filename of the default icon for all leaf nodes in this grid. To specify a \n custom image for an individual node, set the ${isc.DocUtils.linkForRef('attr:TreeGrid.customIconProperty')} directly on\n the node.",
        name:"nodeIcon",
        setter:[
            "setNodeIcon"
        ],
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]file.gif\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('nodeTitles')}"
        ],
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ]
    },
    "attr:FormItem.exportFormat":{
        ref:"attr:FormItem.exportFormat",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('type:FormatString')} used during exports for numeric or date formatting.  See\n ${isc.DocUtils.linkForRef('attr:DataSourceField.exportFormat')}.",
        name:"exportFormat",
        seeAlso:[
        ],
        valueType:"FormatString",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "exportFormatting"
        ]
    },
    "attr:Facet.titleAlign":{
        ref:"attr:Facet.titleAlign",
        flags:"IR",
        description:"Alignment of facet label title.\n <P>\n <b>Note:</b>  This property is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.",
        name:"titleAlign",
        seeAlso:[
            {
                ref:"attr:CubeGrid.facetTitleAlign",
                description:null
            }
        ],
        valueType:"Alignment",
        defaultValue:"cubeGrid.facetTitleAlign",
        type:"attr",
        definingClass:"class:Facet"
    },
    "method:Layout.removeMember":{
        ref:"method:Layout.removeMember",
        flags:"",
        description:" Removes the specified member from the layout.  If it has a resize bar, the bar will be\n destroyed.\n\n",
        name:"removeMember",
        seeAlso:[
        ],
        params:[
            {
                description:"the canvas to be removed from the layout",
                optional:false,
                name:"member",
                defaultValue:null,
                type:"Canvas"
            }
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "class:MultiFilePicker":{
        methods:[
        ],
        ref:"class:MultiFilePicker",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Forms/Form Items/MultiFileItem"
        ],
        attrs:[
            "attr:MultiFilePicker.minUploadFields",
            "attr:MultiFilePicker.maxUploadFields"
        ],
        description:"The MultiFilePicker is a pop-up picker used by the ${isc.DocUtils.linkForRef('class:MultiFileItem')} to allow the user to\n enter several files for upload.",
        name:"MultiFilePicker",
        seeAlso:[
        ],
        type:"class",
        groups:[
            "upload"
        ]
    },
    "classMethod:MultiSortDialog.askForSort":{
        ref:"classMethod:MultiSortDialog.askForSort",
        flags:"",
        description:" Launches a MultiSortDialog and obtains a sort-definition from the user.\n\n",
        name:"askForSort",
        seeAlso:[
        ],
        params:[
            {
                description:"A source for Fields which the user can choose to sort by",
                optional:false,
                name:"fieldSource",
                defaultValue:null,
                type:"Array of Field or DataSource or DataBoundComponent"
            },
            {
                description:"The initial sort definition.",
                optional:false,
                name:"initialSort",
                defaultValue:null,
                type:"Array of SortSpecifier"
            },
            {
                description:"Called when the user defines and accepts one or more  ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.  Single parameter <code>sortLevels</code> is an Array of \n SortSpecifier or null if the user cancelled the dialog.",
                optional:false,
                name:"callback",
                defaultValue:null,
                type:"Callback"
            }
        ],
        type:"classMethod",
        definingClass:"class:MultiSortDialog"
    },
    "attr:StretchImgButton.showRollOverIcon":{
        ref:"attr:StretchImgButton.showRollOverIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image on mouse rollover.",
        name:"showRollOverIcon",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StretchImgButton",
        groups:[
            "buttonIcon"
        ]
    },
    "group:domIntegration":{
        ref:"group:domIntegration",
        title:"DOM Integration &amp; Third-party Components",
        treeLocation:[
            "Concepts"
        ],
        refs:[
        ],
        description:"SmartClient provides a huge variety of pre-built components and allows you to create new\n components via combining and composing the existing components.  However in rare cases, it can\n make sense to write code that works directly with raw HTML and the browser's DOM (document\n object model) APIs.  This level of coding is also involved when integrating third-party\n JavaScript components into SmartClient applications.\n <P>\n First, a warning: when you use HTML and the DOM directly, all of SmartClient's guarantees of\n cross-browser consistent behavior no longer apply.  When you use SmartClient's API, SmartClient\n is automatically compensating for many, many browser bugs - not just trivial things like\n different property names or missing utility methods, but problems where browsers fail to fire\n certain events, report sizes wrong only in certain modes with certain styling, or bugs that\n only occur with specific timing.\n <P>\n Before deciding to do direct HTML coding, consider whether you really want to expose yourself\n to all of these possible issues.  If you can achieve the same look and feel and behavior\n through SmartClient's APIs, that's usually best.\n <P>\n <h3>Adding or modifying the DOM</h3>\n <P>\n The DOM structures used by SmartClient necessarily differ by browser in order to work around\n each browser's specific bugs.  This DOM structure is intentionally undocumented because it is\n subject to change without notice - in may be necessary to modify the DOM structure to work\n around the bugs in each new browser release.\n <P>\n Instead of trying to modify the SmartClient-generated DOM, you should always <b>add new\n elements</b>.  For a new standalone component that will be based on direct use of HTML, you\n usually do this by subclassing Canvas and overriding ${isc.DocUtils.linkForRef('method:Canvas.getInnerHTML')} and returning\n an HTML string representing the components you want to create.\n <P>\n You can use a similar approach anywhere HTML is allowed in a widget property: formatting APIs\n for StaticTextItem, DetailViewer, TileGrid, and other DataBoundComponents, as well as places\n such as ${isc.DocUtils.linkForRef('attr:Tab.title')} or ${isc.DocUtils.linkForRef('attr:Button.title')}.\n <P>\n <h3>Third-party components</h3>\n <P>\n Most third-party JavaScript components have the ability to generate their HTML content into a\n DOM element specified by ID, or to replace such an element with new HTML.  This is true of\n Google Maps, <a href='http://ckeditor.com' target='_blank'>CKEditor</a> and many other libraries.\n <P>\n To use this form of integration, implement a ${isc.DocUtils.linkForRef('method:Canvas.getInnerHTML')} function that returns\n a DOM element with a known ID, then have the third-party library target that DOM element once\n the Canvas is drawn.  For example, CKEDITOR.replace() takes the ID of a &lt;textarea&gt;\n element, and the following code would create a &lt;textarea&gt; and have the CKEditor replace\n it with a CKEditor widget: \n <smartclient>\n <pre>\n isc.defineClass(\"CKEditor\", \"Canvas\");\n isc.CKEditor.addProperties({\n     // write out a textarea with a known ID\n     getInnerHTML : function () {\n         return \"&lt;textarea style=\"width:100%;height:100%\" ID='\" + \n                           this.getID() + \"_ckEditor\" + \"'>&lt;/textarea>\";\n     },\n     // call superclass method to draw, then have CKEditor replace the textarea we\n     // wrote out with the CKEditor widget\n     draw : function () {\n         if (!this.readyToDraw()) return this;\n         this.Super(\"draw\", arguments);\n         CKEDITOR.replace(this.getID() + \"_ckEditor\";\n         return this;\n     },\n     redrawOnResize:false // see next section\n });\n </pre>\n </smartclient>\n <smartgwt>\n <pre>\n public class CKEditor extends Canvas {\n \n     private static native void replace(String id) &#47;*-{\n         $wnd.CKEDITOR.replace(id);\n     }-*&#47;;\n \n     public CKEditor() {\n         setRedrawOnResize(false);\n     }\n \n     &#64;Override\n     public String getInnerHTML() {\n         return \"&lt;textarea id='\" + getID() + \"_ckEditor' style='width:100%;height:100%'>&lt;/textarea>\";\n     }\n \n     &#64;Override\n     protected void onDraw() {\n         CKEditor.replace(getID() + \"_ckEditor\");\n     }\n }\n </pre>\n </smartgwt>\n <P>\n This same approach can be used when you want to insert third-party generated HTML into just a\n specific part of a SmartClient widget.  For example, you might want to insert \n <a href='https://www.google.com/search?q=jquery+sparklines' target='_blank'>JQuery 'sparklines'</a>, which are\n essentially miniature charts, into cells of a ListGrid.  You could use\n ${isc.DocUtils.linkForRef('method:ListGridField.formatCellValue','a cell formatter')} to write out &lt;div&gt; elements with\n known IDs into the cells, then target them with JQuery.\n <P>\n <h3>Resizing and Redraw</h3>\n <P>\n When implementing <code>canvas.getInnerHTML()</code>, your getInnerHTML() function will be\n called every time the component redraw()s, and the new HTML will replace the old.  This is also\n true of something like a ListGrid cell formatter.\n <P>\n Also by default, your component will redraw() if it is resized.  In the example above with\n CKEditor, we wouldn't want this because it would wipe out the CKEditor widget every time it was\n resized, so we set ${isc.DocUtils.linkForRef('attr:Canvas.redrawOnResize')} to false.  In other circumstances you may want\n to redraw on every resize in order to generate new HTML.\n <P>\n If you do not redraw HTML on resize, you either have to write the HTML in a way that makes it\n flow into available space (width/height 100% may be enough here) <b>or</b> you need to manually\n resize the DOM element when the ${isc.DocUtils.linkForRef('method:Canvas.resized','resized event')} fires.  \n <P>\n In the latter case, you should adjust the size of the DOM element to match the\n ${isc.DocUtils.linkForRef('method:Canvas.getInnerWidth','inner width')} and \n ${isc.DocUtils.linkForRef('method:Canvas.getInnerHeight','inner height')} of the containing Canvas.  The \"inner\" dimensions\n are the dimensions after border and margins have been subtracted, so this will work even if a\n border is added to your Canvas subclass via CSS or ${isc.DocUtils.linkForRef('method:Canvas.setBorder')}.\n <P>\n <h3>Other redraws</h3>\n <P>\n Once you have set ${isc.DocUtils.linkForRef('attr:Canvas.redrawOnResize')} to false you may still see redraws from other\n sources.  Generally this would be from code in your application which calls\n ${isc.DocUtils.linkForRef('method:Canvas.redraw')} or ${isc.DocUtils.linkForRef('method:Canvas.markForRedraw')} unnecessarily.  To troubleshoot, you\n can enable the \"redraws\" log category in the Developer Console - this will log the source of\n any redraws in the system.\n <P>\n <h3>Masking during drags</h3>\n <P>\n Third-party components that utilize iframes, browser plugins or other special elements will\n \"swallow\" events such that SmartClient never receives them.  This is a problem whenever a\n drag interaction goes over the component, including drag resizing of the component itself.\n To avoid this issue, set ${isc.DocUtils.linkForRef('attr:Canvas.useDragMask')} for any component that contains an iframe\n or browser plugin, or that appears to be swallowing events during drag.  The telltale sign\n is that when the mouse goes over the plugin, the visual effect of the drag (differs by\n ${isc.DocUtils.linkForRef('attr:Canvas.dragAppearance')}) stops updating or stutters.\n <P>\n <h3>Overflow &amp; Auto-Sizing</h3>\n <P>\n Consider which ${isc.DocUtils.linkForRef('attr:Canvas.overflow')} setting to use for your custom component:\n <ul>\n <li> <code>overflow:\"hidden\"</code> is the most common.  In the context of third-party\n components, it means the component is prepared to render itself at any requested size (above\n a minimum). \n <li> <code>overflow:\"visible\"</code> means you want SmartClient to attempt to automatically\n determine a minimum size based on the HTML content generated by the custom component\n <li> <code>overflow:\"auto\"</code> is similar to <code>overflow:\"hidden\"</code>, but means\n your custom component needs SmartClient to create scrollbars whenever its HTML content does\n not fit in the allocated space.\n </ul>\n Note that with the automatic measurement of HTML content enabled by\n <code>overflow:\"visible\"</code> or <code>overflow:\"auto\"</code>, if you make on-the-fly\n modifications to the HTML you returned from <code>getInnerHTML()</code>, there is no\n cross-browser-reliable way for the Canvas to detect this and auto-size again.  Instead, call\n ${isc.DocUtils.linkForRef('method:Canvas.adjustForContent')} to trigger auto-sizing again.\n <P>\n <h3>zIndex</h3>\n <P>\n zIndex values control what component is rendered \"on top\" when multiple components appear in\n the same area of the page.\n <P>\n To work around various browser issues, SmartClient components use a very high range of\n zIndex values.  If a component creates pop-up widgets such as hovers or floating toolbars\n via direct HTML/DOM usage, these pop-up widgets will appear <b>behind</b> all SmartClient\n components unless they set a very high zIndex.  \n <P>\n For your own custom HTML/DOM components, the simplest strategy is to create pop-up widgets\n based on SmartClient components, even if they are triggered by interacting with\n hand-created HTML.  For example, even if you've written some kind of advanced SVG-based data\n visualization component, you can still implement pop-up configuration dialogs based on the\n SmartClient ${isc.DocUtils.linkForRef('class:Window')} class; there's no reason to implement such dialogs directly in\n low-level HTML/DOM code.\n <P>\n If a third-party widget is creating pop-ups you don't directly control, you may be able to\n configure the third-party widget to use a certain zIndex range, or you may be able to\n directly reach into the widget's DOM and modify zIndexes that way.  You can use\n ${isc.DocUtils.linkForRef('method:Canvas.getZIndex')} to discover the zIndex of any SmartClient widget you need to\n appear above, then set a higher value.\n <P>\n Finally, as a last resort and completely unsupported approach, you can modify the zIndex\n range used by SmartClient using the following JavaScript code:\n <pre>\n isc.Canvas.addClassProperties({\n    // default zIndex for the next item to be drawn\n    _nextZIndex:200000,\n\n    // zIndex of the next item to be sent to the back\n    _SMALL_Z_INDEX:199950,\n\n    // zIndex of the next item to be brought to the front\n    _BIG_Z_INDEX:800000\n });\n </pre>\n <P>\n <h3>Other issues</h3>\n <P>\n There are several other issues, listed below, for which there really is no general strategy\n for solving the issue, although some general pointers are provided.\n <P>\n Because of problems like these, it's a very very bad idea to freely intermix components from\n multiple component libraries.  While mixing components may appear to be an appealing\n strategy and you may experience apparent success with early attempts, the issues below will\n ultimately prevent you from completing an application of sufficient quality for enterprise\n use.\n <P>\n In the following discussion, \"third-party widgets\" should be understood to include\n widgets that you write using direct DOM/HTML techniques.\n <ul>\n <li> <b>tabbing order / accessibility</b>: a correct tabbing order that visits all\n components on the page is a requirement for your application to be considered accessible, as\n is ARIA markup (for more information, see ${isc.DocUtils.linkForRef('group:accessibility')}).  Third-party\n widgets may completely lack ARIA markup, such that you may be required to modify them or\n reach into their DOM to add ARIA attributes.  It may be necessary to add manual keyDown or\n keyPress event handlers to handle focus moving from SmartClient components to third-party\n widgets and back.\n\n <li> <b>modality</b>: aside from zIndex issues covered above, modality means that the tab\n order should be a closed loop that reaches only active widgets, which can create additional\n complexity in getting tabbing to work correctly.  Also, keyboard shortcuts should be\n disabled for inactive widgets; this may require calls to\n ${isc.DocUtils.linkForRef('classMethod:EventHandler.targetIsMasked')} to make third-party widgets respect SmartClient\n modality, or may require calls to ${isc.DocUtils.linkForRef('method:Canvas.showClickMask')} to cause SmartClient\n components to consider themselves inactive when a third-party widget opens a pop-up that is\n intended to be modal.  Multi-layered modality, such as a modal window that in turn pops a\n modal dialog, is yet more complex.\n\n <li> <b>bad CSS</b>: some third-party widgets introduce CSS selectors that target, for\n example, every table cell on the entire page.  This very bad practice will interfere with\n SmartClient (or any other HTML on the page).  This may require modifying the third-party\n component, or extensively modifying SmartClient CSS to reverse any changes caused by\n third-party CSS.  For example, it may be necessary to modify every SmartClient CSS style\n that may be applied to a table cell to reverse a change in padding for all table cells that\n is introduced by bad third-party CSS.\n\n <li> <b>skinning</b>: third-party widgets may lack sufficient skinning APIs to allow you to match\n look and feel to SmartGWT, which may necessitate creating a custom SmartGWT skin to match\n the look and feel of third-party widgets (see ${isc.DocUtils.linkForRef('group:skinning','Skinning Overview')})\n\n <li> <b>event interference</b>: third-party widgets may register page-wide event handling\n logic that conflicts with or destroys similar event handling logic in SmartClient.  For best\n results, load third-party JavaScript libraries <b>before</b> SmartClient since SmartClient\n makes a best effort to preserve any previously installed handlers and allows such handlers to\n cancel native browser behaviors if they do so.\n\n <li> <b>RTL / i18n</b>: third party widgets may not allow all user-visible messages to be\n replaced, a requirement for internationalization / localization, or they may not support\n RTL/BIDI (Right-To-Left / Bi-Directional) rendering\n </ul>\n\n Because of issues like the above, not all of which may be resolvable for some third-party\n widgets, we recommend the following overall approach:\n <ul>\n <li> avoid using third-party widgets if you can build equivalent functionality in\n      SmartClient\n <li> if the third-party component is completely non-interactive, either does not require\n      ARIA markup or already includes such markup, and there are no conflicting look and feel\n      issues, go ahead and use it\n <li> if you anticipate issues, consider the \n <a href='http://www.smartclient.com/services/index.jsp#features' target='_blank'>Feature Sponsorship Program</a> \n      as a means of getting new supported functionality added to SmartClient\n <li> search for existing posts and/or ask about the feasibility of integration on the\n      <a href='http://forums.smartclient.com/' target='_blank'>SmartClient Forums</a>.\n <li> finally, you could attempt to tackle the issues above on your own.  To avoid wasting\n      time on dead ends, we would recommend assessing the amount of work involved in fixing\n      <b>all</b> problems that need to be solved before attempting actual fixes for any one issue.\n </ul>",
        name:"domIntegration",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:Layout.overflow":{
        ref:"attr:Layout.overflow",
        flags:"IRW",
        description:"Normal ${isc.DocUtils.linkForRef('type:Overflow')} settings can be used on layouts, for example, an\n overflow:auto Layout will scroll if members exceed its specified size, whereas an\n overflow:visible Layout will grow to accommodate members.",
        name:"overflow",
        seeAlso:[
        ],
        valueType:"Overflow",
        defaultValue:"\"visible\"",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutPolicy"
        ]
    },
    "method:DrawItem.hover":{
        ref:"method:DrawItem.hover",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:DrawItem.canHover','canHover')} is true for this DrawItem, the hover() string method will\n be fired when the user hovers over this DrawItem. If this method returns false, it will\n suppress the default behavior of showing a hover canvas if ${isc.DocUtils.linkForRef('attr:DrawItem.showHover','showHover')}\n is true.\n",
        name:"hover",
        seeAlso:[
        ],
        returns:{
            description:"false to cancel the hover event.",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:DrawItem",
        groups:[
            "hovers"
        ]
    },
    "method:Canvas.animateResize":{
        ref:"method:Canvas.animateResize",
        flags:"",
        description:" Animate a resize of this canvas from its current size to the specified size\n",
        name:"animateResize",
        seeAlso:[
        ],
        params:[
            {
                description:"new width (or null for unchanged)",
                optional:false,
                name:"width",
                defaultValue:null,
                type:"Integer"
            },
            {
                description:"new height (or null for unchanged)",
                optional:false,
                name:"height",
                defaultValue:null,
                type:"Integer"
            },
            {
                description:"When the resize completes this callback will be fired. Single                              'earlyFinish' parameter will be passed if the animation was\n                              cut short by a call to finishAnimation",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"AnimationCallback"
            },
            {
                description:"Duration in ms of the animated resize",
                optional:true,
                name:"duration",
                defaultValue:null,
                type:"Integer"
            },
            {
                description:"Optional acceleration effect to apply to the resize",
                optional:true,
                name:"acceleration",
                defaultValue:null,
                type:"AnimationAcceleration"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateResize')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "method:Calendar.eventClick":{
        ref:"method:Calendar.eventClick",
        flags:"",
        description:" Called whenever an event is clicked on in the day, week or month views.\n <P>\n By default a dialog appears showing details for the event, and offering the ability to\n edit events which are editable.  Return false to cancel the default action. This is a good\n place to, for example, show a completely customized event dialog instead of the default one.\n\n",
        name:"eventClick",
        seeAlso:[
        ],
        params:[
            {
                description:"event that was clicked on",
                optional:false,
                name:"event",
                defaultValue:null,
                type:"CalendarEvent"
            },
            {
                description:"view where the event was clicked on: \"day\", \"week\", \"month\", \"timeline\"",
                optional:false,
                name:"viewName",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"false to cancel the default action",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Calendar",
        groups:[
            "monthViewEvents"
        ]
    },
    "attr:DynamicForm.defaultSearchOperator":{
        ref:"attr:DynamicForm.defaultSearchOperator",
        flags:"IR",
        description:"Default ${isc.DocUtils.linkForRef('type:OperatorId','search operator')} to use for fields in a form that produces\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.  Default is \"iContains\" unless ${isc.DocUtils.linkForRef('attr:DynamicForm.allowExpressions')} is\n enabled for the form as a whole, in which case the default is\n ${isc.DocUtils.linkForRef('attr:DataSource.translatePatternOperators','\"iContainsPattern\"')}.\n <p>\n Does not apply to special fields where exact match is obviously the right default\n setting, such as fields of type:\"enum\", or fields with a\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} or  ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}.\n <p>\n <code>defaultSearchOperator</code> also has no effect in a form that does not produce\n <code>AdvancedCriteria</code> - see ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} for\n settings that cause a form to produce AdvancedCriteria.",
        name:"defaultSearchOperator",
        seeAlso:[
        ],
        valueType:"OperatorId",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "attr:DataBoundComponent.fieldEditorWindowTitle":{
        ref:"attr:DataBoundComponent.fieldEditorWindowTitle",
        flags:"IRWA",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:DataBoundComponent.fieldEditorWindow','Window')} used to edit calculated\n fields.\n <P>\n This is a dynamic string - text within <code>&#36;{...}</code> are dynamic variables and will\n be evaluated as JS code whenever the message is displayed.\n <P>\n Two dynamic variables are available - \"builderType\", either Formula or Summary, and \n \"fieldTitle\", which is the title of the calculated field being edited.",
        name:"fieldEditorWindowTitle",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"${builderType} Editor [${fieldTitle}]\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent"
    },
    "attr:GridRenderer.scrollRedrawDelay":{
        ref:"attr:GridRenderer.scrollRedrawDelay",
        flags:"IRW",
        description:"While drag scrolling in an incrementally rendered grid, time in milliseconds to wait\n before redrawing, after the last mouse movement by the user. This delay may be \n separately customized for mouse-wheel scrolling via ${isc.DocUtils.linkForRef('attr:GridRenderer.scrollWheelRedrawDelay')}.\n <P>\n See also\n ${isc.DocUtils.linkForRef('attr:GridRenderer.instantScrollTrackRedraw')} for cases where this delay is skipped.",
        name:"scrollRedrawDelay",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"75",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:[
            "performance"
        ]
    },
    "attr:ListGridRecord.enabled":{
        ref:"attr:ListGridRecord.enabled",
        flags:"IR",
        description:"Default property name denoting whether this record is enabled. Property name may be\n modified for some grid via ${isc.DocUtils.linkForRef('attr:ListGrid.recordEnabledProperty')}.",
        name:"enabled",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('disabledRows')}"
        ],
        definingClass:"object:ListGridRecord"
    },
    "attr:MultiGroupPanel.fields":{
        ref:"attr:MultiGroupPanel.fields",
        flags:"IR",
        description:"The list of fields which the user can choose to group by.",
        name:"fields",
        seeAlso:[
        ],
        valueType:"Array of Field",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiGroupPanel"
    },
    "attr:Process.sequences":{
        ref:"attr:Process.sequences",
        flags:"IR",
        description:"Sequences of ProcessElements.  By defining a sequences of elements you can make the\n ${isc.DocUtils.linkForRef('attr:ProcessElement.nextElement')} implicit.\n <P>\n <smartclient>You do not have to explicitly create a ${isc.DocUtils.linkForRef('class:ProcessSequence')},\n you can instead use the shorthand:\n <pre>\n isc.Process.create({\n     startElement:\"firstSequence\", \n     sequences: [\n         { ID:\"something\", elements: [ ... ] },\n         { ID:\"somethingElse\", elements: [ ... ] },\n         ...\n     ]\n     ...\n });\n </pre>\n .. this is equivalent to ..\n <pre>\n isc.Process.create({\n     startElement:\"firstSequence\", \n     sequences: [\n         isc.ProcessSequence.create({ \n              ID:\"something\", \n              elements: [ ... ] \n         }),\n         isc.ProcessSequence.create({ \n              ID:\"somethingElement\", \n              elements: [ ... ] \n         }),\n         ...                           \n     ]\n     ...\n });\n </pre>\n </smartclient>\n <smartgwt>\n Example of using sequences:\n <pre>\n Process process = new Process();\n process.setStartElement(\"firstSequence\");\n ProcessSequence innerSequence = new ProcessSequence(incTask, add2Task, incTask);\n process.setSequences(\n     new ProcessSequence(\"firstSequence\", serviceTask, decisionGateway),\n     new ProcessSequence(\"errorFlow\", failureTask, userNotifyTask)\n );\n // standalone process elements not part of sequences\n process.setElements(new ServiceTask(){...});\n Record state = new Record();\n state.setAttribute(\"someField\", \"someValue\");\n process.setState(state);\n process.start();\n </pre>\n </smartgwt>",
        name:"sequences",
        seeAlso:[
        ],
        valueType:"Array of ProcessSequence",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Process"
    },
    "method:DrawItem.resizeBy":{
        ref:"method:DrawItem.resizeBy",
        flags:"",
        description:" Resize the shape by the specified deltas for the left and top coordinate.\n\n",
        name:"resizeBy",
        seeAlso:[
        ],
        params:[
            {
                description:"change to left coordinate in pixels",
                optional:false,
                name:"dX",
                defaultValue:null,
                type:"int"
            },
            {
                description:"change to top coordinate in pixels",
                optional:false,
                name:"dY",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DrawItem"
    },
    "attr:DSRequest.resultSet":{
        ref:"attr:DSRequest.resultSet",
        flags:"R",
        description:"For advanced use in integrating dataset paging with web services,\n the ResultSet that issued this \"fetch\" DSRequest is automatically made available as the\n <code>resultSet</code> property.\n <P>\n This property can only be read.  There is no meaning to setting this property\n yourself.",
        name:"resultSet",
        seeAlso:[
        ],
        valueType:"ResultSet",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:DynamicForm.validateOnExit":{
        ref:"attr:DynamicForm.validateOnExit",
        flags:"IRW",
        description:"If true, form items will be validated when each item's \"editorExit\" handler is fired\n as well as when the entire form is submitted or validated.\n <P>\n Note that this property can also be set at the item level to enable finer granularity\n validation in response to user interaction - if true at either level, validation\n will occur on editorExit.",
        name:"validateOnExit",
        seeAlso:[
            {
                ref:"attr:FormItem.validateOnExit",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "method:DynamicForm.fetchData":{
        ref:"method:DynamicForm.fetchData",
        flags:"",
        description:" Retrieve data that matches the provided criteria, and edit the first record returned\n \n",
        name:"fetchData",
        seeAlso:[
        ],
        params:[
            {
                description:"search criteria",
                optional:true,
                name:"criteria",
                defaultValue:null,
                type:"Criteria"
            },
            {
                description:"callback to invoke on completion",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"DSCallback"
            },
            {
                description:"additional properties to set on the DSRequest                                            that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "attr:Calendar.saveButtonTitle":{
        ref:"attr:Calendar.saveButtonTitle",
        flags:"IR",
        description:"The title for the save button in the quick event dialog and the event editor",
        name:"saveButtonTitle",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Save Event\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DateChooser.nextYearIconHeight":{
        ref:"attr:DateChooser.nextYearIconHeight",
        flags:"IRW",
        description:"Height of the icon for the next year button",
        name:"nextYearIconHeight",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"7",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:GridRenderer.showClippedValuesOnHover":{
        ref:"attr:GridRenderer.showClippedValuesOnHover",
        flags:"IRWA",
        description:"If true and a cell's value is clipped, then a hover containing the full cell value is\n enabled.\n <p>\n Note that standard cell hovers override clipped value hovers. Thus, to enable clipped value\n hovers, ${isc.DocUtils.linkForRef('attr:GridRenderer.canHover','canHover')} must be unset or null and the corresponding field must have\n ${isc.DocUtils.linkForRef('attr:ListGridField.showHover','showHover')} unset or null as well.",
        name:"showClippedValuesOnHover",
        seeAlso:[
            {
                ref:"attr:GridRenderer.canHover",
                description:null
            },
            {
                ref:"method:GridRenderer.cellValueHoverHTML",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "attr:ListGrid.headerButtonConstructor":{
        ref:"attr:ListGrid.headerButtonConstructor",
        flags:"IR",
        description:"Widget class for this ListGrid's header buttons. If unset, constructor will be\n picked up directly from the standard ${isc.DocUtils.linkForRef('class:Toolbar')} button constructor.",
        name:"headerButtonConstructor",
        seeAlso:[
        ],
        valueType:"Class",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridHeader",
            "appearance"
        ]
    },
    "method:FacetChart.legendHover":{
        ref:"method:FacetChart.legendHover",
        flags:"",
        description:" Fires when the mouse hovers over a color swatch or its label in the legend area of the\n chart.\n <p>\n The ${isc.DocUtils.linkForRef('class:FacetValue')} that the user is hovering over is provided.\n If the chart is a ${isc.DocUtils.linkForRef('attr:FacetChart.extraAxisMetrics','multi-axis chart')}, the\n ${isc.DocUtils.linkForRef('class:FacetValue')} for the hovered-over metric will also be provided.\n\n",
        name:"legendHover",
        seeAlso:[
        ],
        params:[
            {
                description:"facetValue that the mouse is over",
                optional:false,
                name:"facetValue",
                defaultValue:null,
                type:"FacetValue"
            },
            {
                description:"for a multi-axis chart, facetValue representing        the hovered-over metric.  Null if chart is not multi-axis",
                optional:false,
                name:"metricFacetValue",
                defaultValue:null,
                type:"FacetValue"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('drillCharting')}"
        ],
        definingClass:"class:FacetChart"
    },
    "type:ValidationMode":{
        ref:"type:ValidationMode",
        values:[
            {
                description:"Assume provided data is complete and run all validation rules",
                value:"\"full\""
            },
            {
                description:"Validate only the data values that are present ignoring the                  absence of required fields, validators that refer to fields\n                  that are not present, and any conditional validators dependent\n                  on fields that are not present.",
                value:"\"partial\""
            }
        ],
        description:"Mode of validation used for running validation on partially entered data.",
        name:"ValidationMode",
        seeAlso:[
        ],
        type:"type",
        serverDS:"allowed"
    },
    "attr:StaticTextItem.escapeHTML":{
        ref:"attr:StaticTextItem.escapeHTML",
        flags:"IRW",
        description:"By default HTML values in a staticTextItem will be interpreted by the browser.\n Setting this flag to true causes HTML characters to be escaped, meaning the\n raw value of the field (for example <code>\"&lt;b&gt;AAA&lt;/b&gt;\"</code>) is displayed\n to the user rather than the interpreted HTML (for example <code>\"<b>AAA</b>\"</code>)",
        name:"escapeHTML",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:StaticTextItem",
        groups:[
            "appearance"
        ]
    },
    "attr:SectionStack.animateSections":{
        ref:"attr:SectionStack.animateSections",
        flags:"IRW",
        description:"If true, sections are animated during expand/collapse and addition/removal of\n SectionItems is likewise animated.",
        name:"animateSections",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateSections')}"
        ],
        definingClass:"class:SectionStack",
        groups:[
            "animation"
        ]
    },
    "attr:DateChooser.baseFiscalYearStyle":{
        ref:"attr:DateChooser.baseFiscalYearStyle",
        flags:"IRW",
        description:"Base CSS style applied to cells in the ${isc.DocUtils.linkForRef('attr:DateChooser.showFiscalYearChooser','fiscal year column')}.",
        name:"baseFiscalYearStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"dateChooserFiscalYearCell\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:Canvas.getScrollWidth":{
        ref:"method:Canvas.getScrollWidth",
        flags:"A",
        description:" Returns the scrollable width of the widget's contents, including children, ignoring\n clipping.\n",
        name:"getScrollWidth",
        seeAlso:[
        ],
        returns:{
            description:"the scrollable width of the widget's contents",
            type:"number"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "attr:ListGridField.format":{
        ref:"attr:ListGridField.format",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('type:FormatString')} for numeric or date formatting.  See ${isc.DocUtils.linkForRef('attr:DataSourceField.format')}.",
        name:"format",
        seeAlso:[
        ],
        valueType:"FormatString",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "exportFormatting"
        ]
    },
    "attr:TimeItem.secondIncrement":{
        ref:"attr:TimeItem.secondIncrement",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','secondValues')} is unset, this attribute specifies the increment\n to use when generating entries for the second picker.  For example, if this attribute is\n set to 5, the second picker will contain only every fifth value between the \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondMaxValue','secondMaxValue')}.",
        name:"secondIncrement",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "attr:TextItem.characterCasing":{
        ref:"attr:TextItem.characterCasing",
        flags:"IRWA",
        description:"Should entered characters be converted to upper or lowercase?\n Also applies to values applied with ${isc.DocUtils.linkForRef('method:FormItem.setValue')}.\n <P>\n Note: character casing cannot be used at the same time as a ${isc.DocUtils.linkForRef('attr:TextItem.mask')}.",
        name:"characterCasing",
        seeAlso:[
        ],
        valueType:"CharacterCasing",
        defaultValue:"TextItem.DEFAULT",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('formFilters')}"
        ],
        definingClass:"class:TextItem"
    },
    "method:DataSource.setClientOnly":{
        ref:"method:DataSource.setClientOnly",
        flags:"",
        description:" Switch into clientOnly mode, taking the cache from the cacheAllData ResultSet if it \n exists.\n",
        name:"setClientOnly",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "clientData"
        ]
    },
    "attr:ServiceTask.fixedCriteria":{
        ref:"attr:ServiceTask.fixedCriteria",
        flags:"IR",
        description:"Criteria to be submitted as part of the DSRequest, regardless of inputs to the task.\n Will be combined with the data from the ${isc.DocUtils.linkForRef('attr:Task.inputField')} or with\n ${isc.DocUtils.linkForRef('attr:ServiceTask.criteria')} if specified, via ${isc.DocUtils.linkForRef('classMethod:DataSource.combineCriteria')}.",
        name:"fixedCriteria",
        seeAlso:[
        ],
        valueType:"Criteria",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ServiceTask"
    },
    "attr:ButtonItem.autoFit":{
        ref:"attr:ButtonItem.autoFit",
        flags:"IR",
        description:"Should the button auto fit to its title. Maps to ${isc.DocUtils.linkForRef('attr:Button.autoFit')} attribute.\n Note that if an explicit width or height is specified for this item, it will be respected,\n disabling autoFit behavior",
        name:"autoFit",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ButtonItem"
    },
    "method:ListGrid.getCellAlign":{
        ref:"method:ListGrid.getCellAlign",
        flags:"",
        description:" Return the horizontal alignment for cell contents. Default implementation returns\n ${isc.DocUtils.linkForRef('attr:ListGridField.cellAlign')} if specified, otherwise ${isc.DocUtils.linkForRef('attr:ListGridField.align')}.\n\n",
        name:"getCellAlign",
        seeAlso:[
            {
                ref:"method:ListGrid.getCellStyle",
                description:null
            }
        ],
        params:[
            {
                description:"this cell's record",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"listGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"Horizontal alignment of cell contents: 'right', 'center', or 'left'",
            type:"Alignment"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:DataSourceField.canFilter":{
        ref:"attr:DataSourceField.canFilter",
        flags:"IR",
        description:"Should the user be able to filter data by this field?\n Affects whether this field will show up in dataBoundComponents with UI for filtering data.\n <P>",
        name:"canFilter",
        seeAlso:[
            {
                ref:"attr:SearchForm.showFilterFieldsOnly",
                description:null
            },
            {
                ref:"attr:SearchForm.canEditFieldAttribute",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField"
    },
    "method:Canvas.parentResized":{
        ref:"method:Canvas.parentResized",
        flags:"",
        description:" Fires when the interior size of the parent changes, including parent resize and\n scrollbar introduction or removal.\n <p>\n This method allows a child to implement a layout policy that can be used within any\n parent, such as a Resizer component that always snaps to the parent's\n bottom-right corner.  The default implementation of this method applies a child's\n percent sizes, if any, or implements layout based on the ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')} property\n",
        name:"parentResized",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "attr:TreeGrid.customIconOpenProperty":{
        ref:"attr:TreeGrid.customIconOpenProperty",
        flags:"IRWA",
        description:"This property allows the developer to rename the \n ${isc.DocUtils.linkForRef('attr:TreeNode.showOpenIcon','default node.showOpenIcon')} property.",
        name:"customIconOpenProperty",
        seeAlso:[
            {
                ref:"attr:TreeGrid.customIconProperty",
                description:null
            },
            {
                ref:"attr:TreeGrid.showCustomIconOpen",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"\"showOpenIcon\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ]
    },
    "attr:DataBoundComponent.useFlatFields":{
        ref:"attr:DataBoundComponent.useFlatFields",
        flags:"IR",
        description:"The <code>useFlatFields</code> flag causes all simple type fields anywhere in a nested\n set of DataSources to be exposed as a flat list for form binding.  \n <P>\n <code>useFlatFields</code> is typically used with imported metadata, such as \n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema','XML Schema')} from a \n ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL','WSDL-described web service')}, as a means of eliminating levels of XML\n nesting that aren't meaningful in a user interface, without the cumbersome and fragile\n process of mapping form fields to XML structures.\n <P>\n For example, having called ${isc.DocUtils.linkForRef('method:WebService.getInputDS')} to retrieve the input message\n schema for a web service operation whose input message looks like this:\n <pre>\n &lt;FindServices&gt;\n     &lt;searchFor&gt;search text&lt;/searchFor&gt;\n     &lt;Options&gt;\n         &lt;caseSensitive&gt;false&lt;/caseSensitive&gt;\n     &lt;/Options&gt;\n     &lt;IncludeInSearch&gt;\n         &lt;serviceName&gt;true&lt;/serviceName&gt;\n         &lt;documentation&gt;true&lt;/documentation&gt;\n         &lt;keywords&gt;true&lt;/keywords&gt;\n     &lt;/IncludeInSearch&gt;\n &lt;/FindServices&gt;\n </pre>\n Setting <code>useFlatFields</code> on a ${isc.DocUtils.linkForRef('class:DynamicForm')} that is bound to this input\n message schema would result in 5 ${isc.DocUtils.linkForRef('class:FormItem','FormItems')} reflecting the 5 simple type\n fields in the message.\n <P>\n For this form, the result of ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')} might look\n like:\n <P>\n <pre>{\n    searchFor: \"search text\",\n    caseSensitive: false,\n    serviceName: true,\n    documentation : true,\n    keywords : true\n }</pre>\n When contacting a ${isc.DocUtils.linkForRef('class:WebService','WSDL web service')}, these values can be automatically\n mapped to the structure of the input message for a web service operation by setting\n ${isc.DocUtils.linkForRef('attr:WSRequest.useFlatFields')} (for use with ${isc.DocUtils.linkForRef('method:WebService.callOperation')}) or by setting\n ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields')} (for use with a ${isc.DocUtils.linkForRef('class:DataSource')} that is\n ${isc.DocUtils.linkForRef('group:wsdlBinding','bound to a WSDL web service')} via\n ${isc.DocUtils.linkForRef('attr:OperationBinding.wsOperation')}).  \n <P>\n Using these two facilities in conjunction (component.useFlatFields and\n request.useFlatFields) allows gratuitous nesting to be consistently bypassed in both the user\n presentation and when providing the data for XML messages.\n <P>\n You can also set ${isc.DocUtils.linkForRef('attr:OperationBinding.useFlatFields')} to automatically enable \n \"flattened\" XML serialization (request.useFlatFields) for all DataSource requests of a\n particular operationType.\n <P>\n Note that <code>useFlatFields</code> is not generally recommended for use with structures\n where multiple simple type fields exist with the same name, however if used with such a\n structure, the first field to use a given name wins.  \"first\" means the first field\n encountered in a depth first search.  \"wins\" means only the first field will be present as a\n field when data binding.",
        name:"useFlatFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent"
    },
    "classAttr:Page.defaultUnsupportedBrowserURL":{
        ref:"classAttr:Page.defaultUnsupportedBrowserURL",
        flags:"IRWA",
        description:"On a call to <code>Page.checkBrowserAndRedirect()</code>, if no explicit URL\n      is passed in, and the browser is not supported by ISC, redirect to this URL.",
        name:"defaultUnsupportedBrowserURL",
        seeAlso:[
            {
                ref:"classMethod:Page.checkBrowserAndRedirect",
                description:null
            }
        ],
        valueType:"URL",
        defaultValue:"\"[SKIN]/unsupported_browser.html\"",
        type:"classAttr",
        definingClass:"class:Page",
        groups:[
            "files"
        ]
    },
    "attr:DrawPolygon.lineCap":{
        ref:"attr:DrawPolygon.lineCap",
        flags:"IRW",
        description:"Style of drawing the corners of the polygon.",
        name:"lineCap",
        seeAlso:[
        ],
        valueType:"LineCap",
        defaultValue:"\"butt\"",
        type:"attr",
        definingClass:"class:DrawPolygon",
        groups:[
            "line"
        ]
    },
    "classMethod:isc.clearPrompt":{
        ref:"classMethod:isc.clearPrompt",
        flags:"",
        description:"\n\tClear the modal prompt being shown to the user.\n\n",
        name:"clearPrompt",
        seeAlso:[
            {
                ref:"classAttr:Dialog.Prompt",
                description:null
            }
        ],
        type:"classMethod",
        definingClass:"class:isc",
        groups:[
            "Prompting"
        ]
    },
    "attr:ColumnTree.column":{
        ref:"attr:ColumnTree.column",
        flags:"IR",
        getter:[
            "getColumn"
        ],
        description:"Instance of ListGrid used to display each column of the tree.",
        name:"column",
        seeAlso:[
        ],
        valueType:"MultiAutoChild ListGrid",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ColumnTree"
    },
    "method:TreeGrid.isExportingClientData":{
        ref:"method:TreeGrid.isExportingClientData",
        flags:"",
        description:" Returns true if this component is currently \n ${isc.DocUtils.linkForRef('method:TreeGrid.exportClientData','exporting client data')}.  This method can be called from\n custom cell formatters if you need to return a different formatted value for an export\n than for a live TreeGrid\n",
        name:"isExportingClientData",
        seeAlso:[
            {
                ref:"method:TreeGrid.exportClientData",
                description:null
            }
        ],
        returns:{
            description:"returns true if this component is currently exporting client data",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "group:clientData":{
        ref:"group:clientData",
        refs:[
            "method:DataSource.setCacheAllData",
            "method:DataSource.setCacheData",
            "method:DataSource.setTestData",
            "method:DataSource.invalidateCache",
            "method:DataSource.setClientOnly",
            "method:DataSource.hasAllData",
            "attr:DataSource.cacheAllData",
            "attr:DataSource.cacheAllOperationId",
            "attr:DataSource.cacheAcrossOperationIds",
            "attr:DataSource.cacheMaxAge",
            "attr:DataSource.cacheData",
            "attr:DataSource.testData",
            "attr:DataSource.autoCacheAllData",
            "attr:DataSource.useTestDataFetch"
        ],
        name:"clientData",
        seeAlso:[
        ],
        type:"group"
    },
    "group:compression":{
        ref:"group:compression",
        title:"Compression",
        treeLocation:[
            "Optional Modules/Network Performance"
        ],
        refs:[
        ],
        description:"Compression helps reduce the sizes of various data fetched from the server.  Most modern web\n browsers can handle compressed responses of certain content types. The time it takes to\n decompress these responses on a client system is negligible compared to the time saved\n by reducing the number of bits on the wire, especially for slow connections.\n <p>\n If you're not using the SmartClient Java back-end, there are several compression solutions\n available, depending on your server of choice.  Microsoft's IIS has built-in compression\n capability, please check the reference manual for details.  If you're using Apache, you can\n use <a href='http://sourceforge.net/projects/mod-gzip/' target='_blank'>mod_gzip</a> or \n use <a href='http://httpd.apache.org/docs/2.0/mod/mod_deflate.html' target='_blank'>mod_deflate</a>.  Some\n servlet containers also natively support dynamic compression.\n <p>\n The SmartClient Java back-end supports two types of response compression:\n <ul>\n <li>Pre-compressed static content served via the ISC FileDownload servlet.\n <li>On-the-fly compression of arbitrary content using the CompressionFilter.\n </ul>\n <u>Serving pre-compressed files</u>\n <p>\n To serve pre-compressed static content via FileDownload, register the FileDownload servlet\n in your web.xml as follows:\n <pre>\n     &lt;servlet&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;servlet-class&gt;com.isomorphic.servlet.FileDownload&lt;/servlet-class&gt;\n     &lt;/servlet&gt;\n </pre>\n Then map any resource that you want to serve compressed to the FileDownload servlet in your\n web.xml.  Typically, you'll want to serve all SmartClient modules compressed.  You can do so\n by adding the following servlet-mapping directive to your web.xml:\n <pre>\n     &lt;servlet-mapping&gt;\n       &lt;servlet-name&gt;FileDownload&lt;/servlet-name&gt;\n       &lt;url-pattern&gt;/isomorphic/system/modules/*&lt;/url-pattern&gt;\n     &lt;/servlet-mapping&gt;\n </pre>\n Finally, you'll need to create pre-compressed versions of your files alongside the\n uncompressed versions.  If you're using the FileAssembler mechanism, it can create\n pre-compressed files for you automatically.  For all other files, you can use any program\n that uses the gzip encoding.  The compressed file must have exactly the same filename as the\n uncompressed version, with a '.gz' extension.  Note that it's important that both the\n compressed and uncompressed versions be present alongside each other because there are cases\n where serving compressed content is not possible (for example HTTP 1.0 requests) - for those\n situations it's important that the uncompressed files be available to be served to the\n client.  The FileDownload filter automatically detects whether or not compression is\n possible.\n <p>\n <u>Dynamic Compression</u>\n <p>\n Dynamic Compression requires the optional Network Performance module.  To use Dynamic\n Compression, register the CompressionFilter filter in your web.xml as follows:\n <pre>\n     &lt;filter&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;filter-class&gt;com.isomorphic.servlet.CompressionFilter&lt;/filter-class&gt;\n     &lt;/filter&gt;\n </pre>\n Then map any resource that you want dynamically compressed to this filter.  Note that the\n CompressionFilter knows the mime types that are compressible and will automatically ignore\n any stream that sets a content-encoding header, and it automatically figures out if the\n current request is an include or forward (and doesn't compress in that case), so it's safe\n to simply map it to all resources as follows:\n <pre>\n     &lt;filter-mapping&gt;\n         &lt;filter-name&gt;CompressionFilter&lt;/filter-name&gt;\n         &lt;url-pattern&gt;/*&lt;/url-pattern&gt;\n     &lt;/filter-mapping&gt;\n </pre>\n You can register the CompressionFilter anywhere in your filter chain, but be aware that\n if any filters in front wrap and inspect the HttpServletResponse output stream, they will\n be inspecting the compressed response.  Filters are typically applied in the order in which\n they are listed in web.xml and it is advised to keep them that way, otherwise it may result \n in unexpected behavior. For example, if CompressionFilter would be listed after the \n JSSyntaxScannerFilter, the last one would stop working, since it relies on uncompressed data.\n <p>\n <u>Compressible mime types and compatibility</u>\n <p>\n The FileDownload servlet and CompressionFilter filter can serve the following mime-types\n compressed: text/html, text/xml, application/x-javascript, text/javascript, text/ecmascript,\n image/svg+xml, application/javascript, application/json.  If your files are not being compressed, make sure your \n servlet container has a mime type mapping that identifies it as one of the above file types.\n <p>\n Compression for the mime types listed above is supported on all browsers supported by\n SmartClient.  There is one exception: compression of javascript files for IE versions older\n than IE6 Service Pack 2 requires that the CompressionFilter be registered to dynamically\n compress the page that loads these javascript files.",
        name:"compression",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:ListGridRecord.canDrag":{
        ref:"attr:ListGridRecord.canDrag",
        flags:"IR",
        description:"When set to <code>false</code>, this record cannot be dragged. If canDrag is false for\n any record in the current selection, none of the records will be draggable.",
        name:"canDrag",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridRecord"
    },
    "attr:Canvas.animateScrollAcceleration":{
        ref:"attr:Canvas.animateScrollAcceleration",
        flags:"IRWA",
        description:"Default acceleration function for performing an animated scroll.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateScrollAcceleration",
        seeAlso:[
        ],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "attr:HibernateBrowser.includeSubstring":{
        ref:"attr:HibernateBrowser.includeSubstring",
        flags:"IR",
        description:"If set, specifies a substring which must exist in an entity name for it to be included in\n this HibernateBrowser.  If this property is set to a List of strings, entity names are\n included if they match any one of the strings.  The comparison is case-insensitive.\n <p>\n For example, <code>includeSubstring: [\"Order\", \"inv\"]</code> would match all the following \n entity names: \"ORDERS\", \"Inventory\", \"client_invoicing\"",
        name:"includeSubstring",
        seeAlso:[
        ],
        valueType:"String | List of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:HibernateBrowser"
    },
    "attr:DataSource.dataTransport":{
        ref:"attr:DataSource.dataTransport",
        flags:"IR",
        description:"Transport to use for all operations on this DataSource. Defaults to\n ${isc.DocUtils.linkForRef('classAttr:RPCManager.defaultTransport')}.  This would typically only be set to\n enable \"scriptInclude\" transport for contacting ${isc.DocUtils.linkForRef('attr:DataSource.dataFormat','JSON')} web\n services hosted on servers other than the origin server.\n <p>\n When using the \"scriptInclude\" transport, be sure to set ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')} or\n ${isc.DocUtils.linkForRef('attr:OperationBinding.callbackParam')} to match the name of the query parameter name expected\n by your JSON service provider.",
        name:"dataTransport",
        seeAlso:[
            {
                ref:"type:RPCTransport",
                description:null
            },
            {
                ref:"attr:DataSource.callbackParam",
                description:null
            }
        ],
        valueType:"RPCTransport",
        defaultValue:"RPCManager.defaultTransport",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSource",
        groups:[
            "clientDataIntegration"
        ]
    },
    "attr:Mail.messageData":{
        ref:"attr:Mail.messageData",
        flags:"IRA",
        description:"Allows you to specify an alternative source of substitution values for the templating \n process (by default, the data record(s) returned by the DataSource operation are used).\n If set, this ${isc.DocUtils.linkForRef('type:VelocityExpression')} should evaluate to a Java <code>Map</code>\n object, or a Java <code>List</code> containing only <code>Map</code>s.\n <p>\n For example, assuming you had suitable context stored in a <code>Map</code> that is\n held in the current session as attribute \"foo\", the following would cause the mail \n templating system to look in there for values when running substitution:\n <pre>\n     messageData=\"$session.foo\"\n </pre>",
        name:"messageData",
        seeAlso:[
        ],
        valueType:"VelocityExpression",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:Mail",
        groups:[
            "mail"
        ]
    },
    "class:ServerObject":{
        methods:[
        ],
        ref:"class:ServerObject",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/RPC"
        ],
        attrs:[
            "attr:ServerObject.lookupStyle",
            "attr:ServerObject.className",
            "attr:ServerObject.methodName",
            "attr:ServerObject.ID",
            "attr:ServerObject.bean",
            "attr:ServerObject.attributeName",
            "attr:ServerObject.attributeScope",
            "attr:ServerObject.visibleMethods",
            "attr:ServerObject.dropExtraFields",
            "attr:ServerObject.targetXPath",
            "attr:ServerObject.crudOnly"
        ],
        description:"The ServerObject tells the ISC server how to find or create a server-side object involved in\n ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')} (Direct Method Invocation).  \n <p>\n A ServerObject declaration appears in the XML definition of a ${isc.DocUtils.linkForRef('class:DataSource')} (for\n responding to ${isc.DocUtils.linkForRef('class:DSRequest')}s) or in an Application configuration file (.app.xml) for\n responding to ${isc.DocUtils.linkForRef('class:RPCRequest')}s.\n <P>\n NOTE: Please take note of the points made in \n ${isc.DocUtils.linkForRef('group:serverDataSourceImplementation','this discussion')} of caching and thread-safety\n issues in server-side DataSources.",
        name:"ServerObject",
        seeAlso:[
            {
                ref:"class:DMI",
                description:null
            }
        ],
        type:"class",
        serverDS:"only",
        requiresModules:[
            "SCServer"
        ]
    },
    "group:jsStringTag":{
        ref:"group:jsStringTag",
        title:"&lt;isomorphic:jsString&gt;",
        treeLocation:[
            "Java Server Reference/SmartClient JSP Tags"
        ],
        refs:[
        ],
        description:"<i>produces:</i>JavaScript\n <p>\n This tag takes everything in its body and outputs a correctly-escaped JavaScript string.\n This is useful for capturing HTML for display in a Canvas or Label, for example.\n <p>\n <b><u>Tag Attributes:</u></b>\n <p>\n <b>var</b><br>\n <i>value format</i>: Any legal JavaScript variable name\n <i>default value</i>: NONE\n <p>\n If specified, the escaped string is assigned to a newly created variable of the specified\n name.  e.g: var foo = \"bar\";\n <p>\n <b>filename</b><br>\n <i>value format</i>: webRoot-relative path to file\n <i>default value</i>: NONE\n <p>\n If specified, the resulting string content is loaded from the specified file instead of\n from the tag body.",
        name:"jsStringTag",
        seeAlso:[
        ],
        type:"group",
        requiresModules:[
            "SCServer"
        ]
    },
    "method:Slider.setValue":{
        ref:"method:Slider.setValue",
        flags:"",
        description:" Sets the slider value to newValue and moves the slider thumb to the appropriate position for this\n value. Sends the 'sliderMove' event to the sliderTarget.\n\n",
        name:"setValue",
        seeAlso:[
        ],
        params:[
            {
                description:"the new value <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal\n values.  See ${isc.DocUtils.linkForRef('group:gwtFloatVsDouble')} for details</smartgwt>",
                optional:false,
                name:"newValue",
                defaultValue:null,
                type:"float"
            },
            {
                description:"do not animate the slider thumb to the new value",
                optional:false,
                name:"noAnimation",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "attr:DataSource.tableCode":{
        ref:"attr:DataSource.tableCode",
        flags:"R",
        description:"<b>Only applicable to the built-in SQL DataSource</b>\n <p>\n This read-only attribute is a secure and unique hashed version of the name of the table \n underlying this dataSource.  It is used automatically by client-side framework code to \n link dataSources together by ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','foreign key')}, by matching \n DataSource <code>tableCode</code>s with ${isc.DocUtils.linkForRef('attr:DataSourceField.fkTableCode')}s.  This is \n necessary if we automatically discovered a foreign key relationship by inspecting the \n database schema, as a result of a DataSource specifying ${isc.DocUtils.linkForRef('attr:DataSource.autoDeriveSchema','autoDeriveSchema')}:\n true.  We use a secure hash rather than the table name itself for security reasons - \n sending the actual table name to the client would be considered an information leakage\n that could encourage attempts at injection attacks.",
        name:"tableCode",
        seeAlso:[
            {
                ref:"attr:DataSourceField.fkTableCode",
                description:null
            },
            {
                ref:"attr:DataSourceField.fkColumnCode",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSource",
        requiresModules:[
            "SCServer"
        ]
    },
    "method:DateItem.setSelectionRange":{
        ref:"method:DateItem.setSelectionRange",
        flags:"",
        description:" If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is true, falls through to standard\n ${isc.DocUtils.linkForRef('method:TextItem.setSelectionRange','setSelectionRange()')} implementation on this items freeform text entry field.\n Otherwise has no effect.\n",
        name:"setSelectionRange",
        seeAlso:[
        ],
        params:[
            {
                description:"character index for start of new selection",
                optional:false,
                name:"start",
                defaultValue:null,
                type:"int"
            },
            {
                description:"character index for end of new selection",
                optional:false,
                name:"end",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DateItem"
    },
    "method:FacetValue.formatCellValue":{
        ref:"method:FacetValue.formatCellValue",
        flags:"",
        description:" Formatter to apply to values displayed for cells under this facetValue.\n <P>\n Can only be set on the ${isc.DocUtils.linkForRef('attr:CubeGrid.metricFacetId','metric facet')} or, if no metric facet\n is specified, on the innermost column facet.\n <P>\n If a single, grid-wide formatting style is desired, implement\n ${isc.DocUtils.linkForRef('method:ListGrid.formatCellValue','grid.formatCellValue()')} instead.\n <P>\n <b>Note:</b>  This method is specific to ${isc.DocUtils.linkForRef('class:CubeGrid','CubeGrids')}.\n\n",
        name:"formatCellValue",
        seeAlso:[
        ],
        params:[
            {
                description:"raw value for the cell being",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"record object for the cell.   Note: If this is a new cell that has not been saved, in an \n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"CellRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number for the cell.",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"formatted value to display in the cell.",
            type:"string"
        },
        type:"method",
        definingClass:"class:FacetValue"
    },
    "attr:FormulaBuilder.saveAddAnotherButton":{
        ref:"attr:FormulaBuilder.saveAddAnotherButton",
        flags:"IR",
        description:"Button to Save the formula, by generating it's function, testing it and firing \n formulaBuilder.fireOnClose, and then start editing another, new one.",
        name:"saveAddAnotherButton",
        seeAlso:[
        ],
        valueType:"AutoChild Button",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "formulaFields"
        ]
    },
    "class:Label":{
        methods:[
            "method:Label.setIconOrientation",
            "method:Label.setIcon",
            "method:Label.setStyleName",
            "method:Label.setContents"
        ],
        ref:"class:Label",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Foundation"
        ],
        attrs:[
            "attr:Label.contents",
            "attr:Label.dynamicContents",
            "attr:Label.align",
            "attr:Label.valign",
            "attr:Label.wrap",
            "attr:Label.autoFit",
            "attr:Label.icon",
            "attr:Label.iconSize",
            "attr:Label.iconWidth",
            "attr:Label.iconHeight",
            "attr:Label.iconOrientation",
            "attr:Label.iconAlign",
            "attr:Label.iconSpacing",
            "attr:Label.showDisabledIcon",
            "attr:Label.showRollOverIcon",
            "attr:Label.showFocusedIcon",
            "attr:Label.showDownIcon",
            "attr:Label.showSelectedIcon",
            "attr:Label.styleName"
        ],
        description:"Labels display a small amount of ${isc.DocUtils.linkForRef('attr:Label.align','alignable')} ${isc.DocUtils.linkForRef('attr:Label.contents','text')}\n with optional ${isc.DocUtils.linkForRef('attr:Label.icon','icon')} and ${isc.DocUtils.linkForRef('attr:Label.autoFit','autoFit')}.\n <P>\n For a general-purpose container for HTML content, use ${isc.DocUtils.linkForRef('class:HTMLFlow')} or ${isc.DocUtils.linkForRef('class:HTMLPane')}\n instead.",
        name:"Label",
        seeAlso:[
        ],
        type:"class",
        examples:[
            "${isc.DocUtils.linkForExampleId('label')}"
        ]
    },
    "attr:TileGrid.animateTileChange":{
        ref:"attr:TileGrid.animateTileChange",
        flags:"IRWA",
        description:"If set, when the dataset changes due to filtering, sorting or other actions, any tiles that\n were showing before and after the change will animate from their old positions to their new\n positions.",
        name:"animateTileChange",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:[
            "appearance"
        ]
    },
    "classMethod:isc.defineClass":{
        ref:"classMethod:isc.defineClass",
        flags:"",
        description:" Shortcut for <code>isc.ClassFactory.defineClass()</code>.\n",
        name:"defineClass",
        seeAlso:[
            {
                ref:"classMethod:ClassFactory.defineClass",
                description:null
            }
        ],
        params:[
            {
                description:"Name for the new class.",
                optional:false,
                name:"className",
                defaultValue:null,
                type:"string"
            },
            {
                description:"Optional SuperClass Class object or name",
                optional:true,
                name:"superClass",
                defaultValue:null,
                type:"Class"
            }
        ],
        returns:{
            description:"Returns the new Class object.",
            type:"Class"
        },
        type:"classMethod",
        definingClass:"class:isc"
    },
    "attr:Shadow.offset":{
        ref:"attr:Shadow.offset",
        flags:"IR",
        description:null,
        name:"offset",
        seeAlso:[
        ],
        valueType:"Point",
        defaultValue:"[0,0]",
        type:"attr",
        definingClass:"object:Shadow"
    },
    "attr:Calendar.timelineViewTitle":{
        ref:"attr:Calendar.timelineViewTitle",
        flags:"IR",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:Calendar.timelineView','timeline view')}.",
        name:"timelineViewTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Timeline\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "i18nMessages"
        ]
    },
    "method:NavigationBar.setShowRightButton":{
        ref:"method:NavigationBar.setShowRightButton",
        flags:"",
        description:" Show or hide the ${isc.DocUtils.linkForRef('attr:NavigationBar.rightButton','rightButton')}.\n",
        name:"setShowRightButton",
        seeAlso:[
        ],
        params:[
            {
                description:"if true, the button will be shown, otherwise hidden.",
                optional:false,
                name:"visible",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:NavigationBar"
    },
    "attr:ServerObject.crudOnly":{
        ref:"attr:ServerObject.crudOnly",
        flags:"IR",
        description:"For a ServerObject defined at the ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','DataSource level')}, by \n default we only allow it to intercept standard CRUD operations (ie, ordinary fetches, adds,\n updates and removes).  To allow the ServerObject to intercept other types of operation - \n custom operations, validations, etc - set this property to false.  Note that ServerObjects \n declared at the ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject','OperationBinding level')} always intercept\n that operation, whatever its type, and this property has no effect.\n <p>\n <b>NOTE:</b> If you are intercepting operations on the server because you wish to inspect\n them before deciding whether to process them with bespoke code or allow them to proceed \n with normal processing, the way to invoke normal processing without causing any interference\n is:<pre>\n    return dsRequest.execute();\n </pre>",
        name:"crudOnly",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:ServerObject",
        requiresModules:[
            "SCServer"
        ]
    },
    "type:BackgroundRepeat":{
        ref:"type:BackgroundRepeat",
        values:[
            {
                description:"Tile the background image horizontally and vertically.",
                value:"Canvas.REPEAT"
            },
            {
                description:"Don't tile the background image at all.",
                value:"Canvas.NO_REPEAT"
            },
            {
                description:"Repeat the background image horizontally but not vertically.",
                value:"Canvas.REPEAT_X"
            },
            {
                description:"Repeat the background image vertically but not horizontally.",
                value:"Canvas.REPEAT_Y"
            }
        ],
        description:"Possible values for ${isc.DocUtils.linkForRef('attr:Canvas.backgroundRepeat')}.",
        name:"BackgroundRepeat",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "appearance"
        ]
    },
    "method:ListGrid.getDefaultFieldWidth":{
        ref:"method:ListGrid.getDefaultFieldWidth",
        flags:"",
        description:" Method to calculate and return the default width of a field. This method is called\n to calculate the size of each field's content as part of the\n ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths','field auto fit')} behavior.\n <P>\n The default implementation varies by ${isc.DocUtils.linkForRef('type:ListGridFieldType','field type')}.\n For fields of type <code>\"icon\"</code>, or fields which show only a\n ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons','valueIcon')} as a value, and for boolean fields which\n show a checkbox value, the width will be calculated based on the icon size and\n ${isc.DocUtils.linkForRef('attr:ListGrid.iconPadding')}. For other fields the width will be calculated\n based on the rendered width of content. Note that for\n <code>\"image\"</code> type fields, this method will rely on the ${isc.DocUtils.linkForRef('attr:ListGridField.imageWidth')}\n being specified.\n <P>\n Note that this width is the default width of \"content\" - it does not take into account\n the rendered size of the field title.\n\n",
        name:"getDefaultFieldWidth",
        seeAlso:[
        ],
        params:[
            {
                description:"Field for which the size should be determined",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"ListGridField"
            }
        ],
        returns:{
            description:"default size required for the field's content.",
            type:"int"
        },
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Canvas.enable":{
        ref:"method:Canvas.enable",
        flags:"",
        description:" Enables this widget and any children / peers of this widget.\n",
        name:"enable",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "enable"
        ]
    },
    "class:Portlet":{
        methods:[
            "method:Portlet.setHeight",
            "method:Portlet.setRowHeight",
            "method:Portlet.getPortalLayout",
            "method:Portlet.getPortalPosition",
            "method:Portlet.closeClick",
            "method:Portlet.close"
        ],
        ref:"class:Portlet",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout/PortalLayout"
        ],
        attrs:[
            "attr:Portlet.dragType",
            "attr:Portlet.canDrop",
            "attr:Portlet.minHeight",
            "attr:Portlet.minWidth",
            "attr:Portlet.height",
            "attr:Portlet.rowHeight",
            "attr:Portlet.showCloseConfirmationMessage",
            "attr:Portlet.closeConfirmationMessage",
            "attr:Portlet.closeConfirmationDialogProperties",
            "attr:Portlet.destroyOnClose"
        ],
        description:"Custom subclass of Window configured to be embedded within a PortalLayout.",
        name:"Portlet",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:DynamicForm.unknownErrorMessage":{
        ref:"attr:DynamicForm.unknownErrorMessage",
        flags:"IRW",
        description:"The error message for a failed validator that does not specify its own errorMessage.",
        name:"unknownErrorMessage",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Invalid value\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "validation",
            "i18nMessages"
        ]
    },
    "attr:FilterClause.validateOnChange":{
        ref:"attr:FilterClause.validateOnChange",
        flags:"IR",
        description:"If true (the default), validates the entered value when it changes, to make sure it is a \n a valid value of its type (valid string, number, and so on).  No other validation is \n carried out.  If you switch this property off, it is still possible to validate the \n <code>FilterClause</code> by calling ${isc.DocUtils.linkForRef('method:FilterClause.validate')} from your own code.",
        name:"validateOnChange",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FilterClause"
    },
    "attr:Validator.stopIfFalse":{
        ref:"attr:Validator.stopIfFalse",
        flags:"IR",
        description:"Normally, all validators defined for a field will be run even if one of the validators has\n already failed.  However, if <code>stopIfFalse</code> is set, validation will not proceed\n beyond this validator if the check fails.\n <P>\n This is useful to prevent expensive validators from being run unnecessarily, or to allow\n custom validators that don't need to be robust about handling every conceivable type of\n value.",
        name:"stopIfFalse",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:Validator"
    },
    "attr:DrawLinePath.endLeft":{
        ref:"attr:DrawLinePath.endLeft",
        flags:"IR",
        description:"Ending left coordinate of the line.  Overrides left coordinate of ${isc.DocUtils.linkForRef('attr:DrawLinePath.endPoint')} if\n both are set.",
        name:"endLeft",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0 , IRW",
        type:"attr",
        definingClass:"class:DrawLinePath"
    },
    "attr:DrawPane.translate":{
        ref:"attr:DrawPane.translate",
        flags:"IR",
        description:"Global translation. This array has two numbers. The first number is the X translation amount\n in pixels and the second number is the Y translation amount in pixels.",
        name:"translate",
        seeAlso:[
        ],
        valueType:"Array[] of int",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DrawPane"
    },
    "group:monthViewFormatting":{
        ref:"group:monthViewFormatting",
        refs:[
            "method:Calendar.getDayBodyHTML"
        ],
        name:"monthViewFormatting",
        seeAlso:[
        ],
        type:"group"
    },
    "method:ListGrid.resort":{
        ref:"method:ListGrid.resort",
        flags:"",
        description:" If a list has become unsorted due to data modification or a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.unsort')}, this method will resort the list by the previous\n ${isc.DocUtils.linkForRef('method:ListGrid.setSort','sort-specifier')} array, if there is one, or by the previous\n sort-field and -direction.\n\n",
        name:"resort",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "sorting"
        ]
    },
    "attr:GridRenderer.canSelectOnRightMouse":{
        ref:"attr:GridRenderer.canSelectOnRightMouse",
        flags:"RW",
        description:"If true, rightMouseDown events will fire 'selectOnRightMouseDown()' for the appropriate cells.",
        name:"canSelectOnRightMouse",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "attr:DataSourceField.validators":{
        ref:"attr:DataSourceField.validators",
        flags:"IR",
        description:"Validators to be applied to this field.\n <p>\n Validators are applied whenever there is an attempt to save changes to a field.\n <p>\n For the available set of built-in validators, and how to define a custom validator, see the\n ${isc.DocUtils.linkForRef('class:Validator')} class.",
        name:"validators",
        seeAlso:[
            {
                ref:"class:Validator",
                description:null
            }
        ],
        valueType:"Array of Validator",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField",
        groups:[
            "dataType",
            "validation"
        ]
    },
    "method:PickTreeItem.fetchData":{
        ref:"method:PickTreeItem.fetchData",
        flags:"",
        description:" Only applies to databound items (see ${isc.DocUtils.linkForRef('attr:PickTreeItem.optionDataSource')}).<br>\n Performs a fetch type operation on this item's DataSource to retrieve/refresh the tree\n of data displayed as rows in this items menu.\n",
        name:"fetchData",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:PickTreeItem"
    },
    "method:Class.ignore":{
        ref:"method:Class.ignore",
        flags:"A",
        description:"\t\tStop observing a method on some other object.\n\n",
        name:"ignore",
        seeAlso:[
            {
                ref:"method:Class.observe",
                description:null
            }
        ],
        params:[
            {
                description:"object to observe",
                optional:false,
                name:"object",
                defaultValue:null,
                type:"object"
            },
            {
                description:"name of the method to ignore",
                optional:false,
                name:"methodName",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"true == observation stopped, false == no change made",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Class",
        groups:[
            "observation"
        ]
    },
    "attr:RecordEditor.actionButton":{
        ref:"attr:RecordEditor.actionButton",
        flags:"R",
        description:"Automatically created Button auto-child shown at the edge of the recordEditor.\n For a recordEditor acting as a ${isc.DocUtils.linkForRef('attr:ListGrid.filterEditor')}, this button will\n show the ${isc.DocUtils.linkForRef('attr:RecordEditor.filterImg')} as an ${isc.DocUtils.linkForRef('attr:Button.icon')} by default.\n <P>\n Clicking this button will call ${isc.DocUtils.linkForRef('method:RecordEditor.performAction')} on the editor.\n <P>\n May be customized using the standard ${isc.DocUtils.linkForRef('type:AutoChild')} pattern, by overriding\n ${isc.DocUtils.linkForRef('attr:RecordEditor.actionButtonProperties')}.",
        name:"actionButton",
        seeAlso:[
        ],
        valueType:"Button AutoChild",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RecordEditor"
    },
    "attr:CubeGrid.canResizeColumns":{
        ref:"attr:CubeGrid.canResizeColumns",
        flags:"IRW",
        description:"If true, body columns can be resized via the innermost column headers.",
        name:"canResizeColumns",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "gridLayout"
        ]
    },
    "attr:ListGridField.sortByDisplayField":{
        ref:"attr:ListGridField.sortByDisplayField",
        flags:"IRW",
        description:"For a field with <code>displayField</code> configured, should client-side sorting\n be performed on the display field value? Unless explicitly set to <code>false</code>\n the display field value is used.",
        name:"sortByDisplayField",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "display_values"
        ]
    },
    "attr:TimeItem.textFieldProperties":{
        ref:"attr:TimeItem.textFieldProperties",
        flags:"IRA",
        description:"Custom properties to apply to the ${isc.DocUtils.linkForRef('attr:TimeItem.textField','text field')} generated for \n this timeItem when ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is true.",
        name:"textFieldProperties",
        seeAlso:[
        ],
        valueType:"TextItem properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "attr:FilterBuilder.removeButtonPrompt":{
        ref:"attr:FilterBuilder.removeButtonPrompt",
        flags:"IR",
        description:"The hover prompt text for the remove button.",
        name:"removeButtonPrompt",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Remove\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "method:String.contains":{
        ref:"method:String.contains",
        flags:"",
        description:"\t\t\tReturns true if this string contains the specified substring.\n",
        name:"contains",
        seeAlso:[
        ],
        params:[
            {
                description:"string to look for",
                optional:false,
                name:"substring",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"true == this string contains the substring",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:String",
        groups:[
            "stringProcessing"
        ]
    },
    "attr:OperationBinding.callbackParam":{
        ref:"attr:OperationBinding.callbackParam",
        flags:"IR",
        description:"Applies only to dataFormat: \"json\".  Specifies the name of the query parameter that\n tells your JSON service what function to call as part of the response for this operation.\n <P>\n Typically set once for the DataSource as a whole via ${isc.DocUtils.linkForRef('attr:DataSource.callbackParam')}.",
        name:"callbackParam",
        seeAlso:[
            {
                ref:"attr:DataSource.callbackParam",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"\"callback\"",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:OperationBinding",
        groups:[
            "clientDataIntegration"
        ]
    },
    "attr:CubeGrid.canMinimizeColumns":{
        ref:"attr:CubeGrid.canMinimizeColumns",
        flags:"IRW",
        description:"If true, allow columns in the grid body to be minimized (reduced to the width of the\n minimize control) by clicking on a minimize control in the innermost column headers.",
        name:"canMinimizeColumns",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "gridLayout"
        ]
    },
    "attr:DynamicForm.valuesManager":{
        ref:"attr:DynamicForm.valuesManager",
        flags:"IA",
        description:"If set at init time, this dynamicForm will be created as a member form for the\n specified valuesManager.  To update the valuesManager to which a form belongs after init\n use <code>valuesManager.addMember(form)</code> and \n <code>valuesManager.removeMember(form)</code>",
        name:"valuesManager",
        seeAlso:[
            {
                ref:"class:ValuesManager",
                description:null
            }
        ],
        valueType:"ValuesManager instance or global ID",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formValuesManager"
        ]
    },
    "attr:Tree.defaultNodeTitle":{
        ref:"attr:Tree.defaultNodeTitle",
        flags:"IRW",
        description:"Title assigned to nodes without a ${isc.DocUtils.linkForRef('attr:Tree.titleProperty')} value or a\n ${isc.DocUtils.linkForRef('attr:Tree.nameProperty')} value.",
        name:"defaultNodeTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Untitled\"",
        type:"attr",
        definingClass:"class:Tree"
    },
    "attr:FacetChart.dataShapeProperties":{
        ref:"attr:FacetChart.dataShapeProperties",
        flags:"IR",
        description:"Properties for data shapes (filled areas in area or radar charts).",
        name:"dataShapeProperties",
        seeAlso:[
        ],
        valueType:"DrawPath Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "method:ListGrid.getEditCol":{
        ref:"method:ListGrid.getEditCol",
        flags:"",
        description:" Returns the index of the column being edited or null if there is no edit col.\n\n",
        name:"getEditCol",
        seeAlso:[
        ],
        returns:{
            description:"index of the current edit column",
            type:"int"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "attr:DrawSector.radius":{
        ref:"attr:DrawSector.radius",
        flags:"IR",
        description:"Radius of the sector.",
        name:"radius",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"100",
        type:"attr",
        definingClass:"class:DrawSector"
    },
    "method:Layout.drop":{
        ref:"method:Layout.drop",
        flags:"A",
        description:" Layouts have built-in handling of component drag and drop.  See the discussion in\n ${isc.DocUtils.linkForRef('class:Layout')} on how it works.  If you override this builtin implementation of drop() and\n you're using the built-in dropLine via ${isc.DocUtils.linkForRef('attr:Layout.canDropComponents')}:true, be sure to call\n ${isc.DocUtils.linkForRef('method:Layout.hideDropLine')} to hide the dropLine after doing your custom drop() handling.\n\n",
        name:"drop",
        seeAlso:[
        ],
        returns:{
            description:"Returning false will cancel the drop entirely",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:EdgedCanvas.centerBackgroundColor":{
        ref:"attr:EdgedCanvas.centerBackgroundColor",
        flags:"IR",
        description:"Background color for the center section only.  Can be used as a surrogate background\n color for the decorated Canvas, if the Canvas is set to partially overlap the edges and\n hence can't show a background color itself without occluding media.",
        name:"centerBackgroundColor",
        seeAlso:[
        ],
        valueType:"CSSColor",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:EdgedCanvas",
        groups:[
            "imageEdges"
        ]
    },
    "attr:DSRequest.pendingAdd":{
        ref:"attr:DSRequest.pendingAdd",
        flags:"IR",
        description:"Indicates that a validation request is being made for a record that will ultimately be \n saved with an \"add\" request, as opposed to an \"update\" request.  This context is necessary\n for some validators because the nature of the validation depends on whether we are adding\n or updating a record.  The system sets this flag when processing interim validations, such\n as those fired when ${isc.DocUtils.linkForRef('attr:DynamicForm.validateOnChange')} is in force.",
        name:"pendingAdd",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "group:prompt":{
        ref:"group:prompt",
        refs:[
        ],
        name:"prompt",
        seeAlso:[
        ],
        type:"group"
    },
    "method:DrawRect.getBoundingBox":{
        ref:"method:DrawRect.getBoundingBox",
        flags:"",
        description:" Returns the top, left, top+height, left+width \n",
        name:"getBoundingBox",
        seeAlso:[
        ],
        returns:{
            description:"x1, y1, x2, y2 coordinates",
            type:"array"
        },
        type:"method",
        definingClass:"class:DrawRect"
    },
    "attr:DataSourceField.mimeType":{
        ref:"attr:DataSourceField.mimeType",
        flags:"IR",
        description:"For a ${isc.DocUtils.linkForRef('group:binaryFields','binary field')}, sets a fixed mime type for all files stored\n to this field.  Should be set to a standard mime type string, for example, \"text/plain\" for\n a .txt file.\n <P>\n This is useful if a binary field only stored one type of file and you chose not to store \n filenames, since the extension of the file name is normally used to determine the mime type.",
        name:"mimeType",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField"
    },
    "attr:Calendar.dateFormatter":{
        ref:"attr:Calendar.dateFormatter",
        flags:"IRW",
        description:"Date formatter for displaying events.\n Default is to use the system-wide default short date format, configured via\n ${isc.DocUtils.linkForRef('classMethod:Date.setShortDisplayFormat')}.  Specify any valid ${isc.DocUtils.linkForRef('type:DateDisplayFormat')}.",
        name:"dateFormatter",
        seeAlso:[
        ],
        valueType:"DateDisplayFormat",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "method:CubeGrid.deselectAll":{
        ref:"method:CubeGrid.deselectAll",
        flags:"",
        description:" Deselect all cells and facetValues.\n\n      <br><i>methodType</i> action\n",
        name:"deselectAll",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "selection"
        ]
    },
    "classAttr:Operators.orTitle":{
        ref:"classAttr:Operators.orTitle",
        flags:"IR",
        description:"Title for the \"or\" operator",
        name:"orTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Match Any\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ImgSplitbar.canCollapse":{
        ref:"attr:ImgSplitbar.canCollapse",
        flags:"IRW",
        description:"If this property is true, a click on the Splitbar will collapse its \n ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}, hiding it and shifting the Splitbar and other members\n of the layout across to fill the newly available space. If the target is already hidden\n a click will expand it again (showing it at its normal size).\n <p>\n Note that on touch devices, to enable collapsing/uncollapsing the <code>target</code>\n in response to a tap, ${isc.DocUtils.linkForRef('attr:Splitbar.canCollapseOnTap','canCollapseOnTap')} must be set to\n <code>true</code>.",
        name:"canCollapse",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ImgSplitbar"
    },
    "attr:TimeItem.showHintInField":{
        ref:"attr:TimeItem.showHintInField",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is true and a ${isc.DocUtils.linkForRef('attr:FormItem.hint','hint')} is\n set, should the hint be shown within the field?\n <p>\n Note that when using a native HTML5 time input (see ${isc.DocUtils.linkForRef('attr:TimeItem.browserInputType')}),\n in-field hints are currently supported, but future browser changes might not allow\n in-field hints to be supported. Therefore, it is safest to <em>not</em> use in-field\n hints in conjunction with a native HTML5 time input.\n <p>\n To change this attribute after being drawn, it is necessary to call ${isc.DocUtils.linkForRef('method:FormItem.redraw')}\n or redraw the form.",
        name:"showHintInField",
        seeAlso:[
            {
                ref:"attr:FormItem.hint",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGridField.defaultGroupingMode":{
        ref:"attr:ListGridField.defaultGroupingMode",
        flags:"IR",
        description:"Default groupingMode used when the user does not specify a mode or grouping is triggered\n programmatically and ${isc.DocUtils.linkForRef('attr:ListGridField.groupingMode','field.groupingMode')} is unset.\n See ${isc.DocUtils.linkForRef('attr:ListGridField.groupingModes','field.groupingModes')}.",
        name:"defaultGroupingMode",
        seeAlso:[
        ],
        valueType:"identifier",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "grouping"
        ]
    },
    "group:cacheSync":{
        ref:"group:cacheSync",
        refs:[
            "attr:DSResponse.invalidateCache",
            "attr:ResultSet.initialData",
            "attr:ResultSet.initialLength",
            "attr:ResultSet.sortSpecifiers",
            "attr:ResultSet.allRows",
            "attr:ResultSet.updateCacheFromRequest",
            "attr:ResultSet.dropCacheOnUpdate",
            "attr:ResultSet.disableCacheSync",
            "attr:ResultSet.neverDropUpdatedRows",
            "attr:ResultSet.updatePartialCache",
            "attr:ResultTree.updateCacheFromRequest",
            "attr:ResultTree.disableCacheSync"
        ],
        name:"cacheSync",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:SplitPane.detailTitle":{
        ref:"attr:SplitPane.detailTitle",
        flags:"IRW",
        description:"The title for the ${isc.DocUtils.linkForRef('attr:SplitPane.detailPane','detailPane')}.",
        name:"detailTitle",
        setter:[
            "setDetailTitle"
        ],
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SplitPane"
    },
    "method:Layout.showMember":{
        ref:"method:Layout.showMember",
        flags:"",
        description:" Show the specified member, firing the specified callback when the show is complete.\n <P>\n Members can always be directly shown via <code>member.show()</code>, but if\n ${isc.DocUtils.linkForRef('attr:Layout.animateMembers','animation')} is enabled, animation will only occur if showMember() is\n called to show the member.\n\n",
        name:"showMember",
        seeAlso:[
        ],
        params:[
            {
                description:"Member to show",
                optional:false,
                name:"member",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"action to fire when the member has been shown",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"Function"
            }
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "group:submitting":{
        ref:"group:submitting",
        refs:[
            "method:DynamicForm.cancel",
            "method:ValuesManager.cancel",
            "method:DynamicForm.submitForm",
            "method:DynamicForm.submitValues",
            "method:SearchForm.search",
            "method:ValuesManager.submitValues",
            "attr:DynamicForm.action",
            "attr:DynamicForm.target",
            "attr:DynamicForm.method",
            "attr:DynamicForm.encoding",
            "attr:DynamicForm.canSubmit",
            "attr:DynamicForm.saveOnEnter",
            "type:FormMethod",
            "type:Encoding"
        ],
        description:"Direct submission of forms to a target URL\n <P>\n <b>NOTE:</b> directly submitting forms is only done for specialized purposes, such as\n integration with certain legacy systems.  Normal form usage contacts the server via \n ${isc.DocUtils.linkForRef('group:dataBoundComponentMethods','DataBound Component Methods')}, through the RPCManager system.",
        name:"submitting",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:TextItem.maskPromptChar":{
        ref:"attr:TextItem.maskPromptChar",
        flags:"IRWA",
        description:"Character that is used to fill required empty mask positions\n to display text while control has focus.",
        name:"maskPromptChar",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"_\"",
        type:"attr",
        definingClass:"class:TextItem"
    },
    "attr:SelectOtherItem.separatorTitle":{
        ref:"attr:SelectOtherItem.separatorTitle",
        flags:"IRW",
        description:"Title for the separator between normal items and the <code>Other...</code> item in the drop\n down list.  Selecting this item will not change the FormItem's value.",
        name:"separatorTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"--------------------\"",
        type:"attr",
        definingClass:"class:SelectOtherItem",
        groups:[
            "appearance"
        ]
    },
    "attr:DataSourceField.viewRequiresRole":{
        ref:"attr:DataSourceField.viewRequiresRole",
        flags:"IR",
        description:"Comma-separated list of user roles that are allowed to fetch this field. If the current user\n has any of the roles listed, values for the field will be fetched.  Please see \n ${isc.DocUtils.linkForRef('attr:OperationBinding.requiresRole')} for further details of SmartClient's declarative \n role-based security.  Please also see \n ${isc.DocUtils.linkForRef('attr:DataSourceField.viewRequiresAuthentication','viewRequiresAuthentication')} for details\n of how declarative field-level security settings can be overridden per-request.",
        name:"viewRequiresRole",
        seeAlso:[
            {
                ref:"attr:DataSourceField.viewRequiresAuthentication",
                description:null
            },
            {
                ref:"attr:DataSourceField.editRequiresRole",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField",
        groups:[
            "fieldLevelAuth"
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "method:Selection.getLength":{
        ref:"method:Selection.getLength",
        flags:"",
        description:" Returns the number of selected records.\n\n",
        name:"getLength",
        seeAlso:[
        ],
        returns:{
            description:"number of selected records",
            type:"int"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "attr:ColorPicker.cancelButtonTitle":{
        ref:"attr:ColorPicker.cancelButtonTitle",
        flags:"IR",
        description:"The title for the 'Cancel' button.",
        name:"cancelButtonTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Cancel\"",
        type:"attr",
        definingClass:"class:ColorPicker",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:RPCRequest.promptCursor":{
        ref:"attr:RPCRequest.promptCursor",
        flags:"IRW",
        description:"Controls the cursor shown when ${isc.DocUtils.linkForRef('classAttr:RPCManager.promptStyle')} is set to\n <code>\"cursor\"</code> for this request only. Defaults to ${isc.DocUtils.linkForRef('classAttr:RPCManager.promptCursor')}.\n <p>\n In Safari, IE 5.5 and Firefox 1.0 the default value is \"wait\", on all other platforms it is\n \"progress\".  The reason for this split is that the above-mentioned browsers do not support\n CSS2.1 - which is required for the \"progress\" cursor type.",
        name:"promptCursor",
        seeAlso:[
            {
                ref:"classAttr:RPCManager.promptCursor",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"browser-dependent",
        type:"attr",
        definingClass:"class:RPCRequest",
        groups:[
            "rpcPrompt"
        ]
    },
    "attr:Task.inputField":{
        ref:"attr:Task.inputField",
        flags:"IR",
        description:"Field in the ${isc.DocUtils.linkForRef('attr:Process.state','process state')} which is provided as input data to this\n task.  \n See ${isc.DocUtils.linkForRef('group:taskIO')}.",
        name:"inputField",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Task"
    },
    "method:Canvas.updateHover":{
        ref:"method:Canvas.updateHover",
        flags:"A",
        description:" If this canvas is currently showing a hover (see ${isc.DocUtils.linkForRef('method:Canvas.handleHover')}), this method\n can be called to update the contents of the hover. Has no effect if the hover canvas is not\n showing for this widget.\n",
        name:"updateHover",
        seeAlso:[
        ],
        params:[
            {
                description:"Option to specify new HTML for the hover. If not passed, the result   of ${isc.DocUtils.linkForRef('method:Canvas.getHoverHTML','this.getHoverHTML()')} will be used instead. Note that if the\n   hover HTML is empty the hover will be hidden.",
                optional:true,
                name:"hoverHTML",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "hovers"
        ]
    },
    "class:RibbonBar":{
        methods:[
            "method:RibbonBar.addGroup"
        ],
        ref:"class:RibbonBar",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout"
        ],
        attrs:[
        ],
        description:"A ${isc.DocUtils.linkForRef('class:ToolStrip','ToolStrip-based')} class for showing \n ${isc.DocUtils.linkForRef('class:RibbonGroup','groups')} of related buttons and other controls.",
        name:"RibbonBar",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:ListGrid.tallBaseStyle":{
        ref:"attr:ListGrid.tallBaseStyle",
        flags:"IR",
        description:"\"Tall\" baseStyle for this listGrid. Only applies if ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')} is\n set to null.\n <P>\n If <code>baseStyle</code> is unset, this\n property will be used as a base cell style unless the grid is showing fixed height\n rows with a specified cellHeight that matches ${isc.DocUtils.linkForRef('attr:ListGrid.normalCellHeight')}, in\n which case ${isc.DocUtils.linkForRef('attr:ListGrid.normalBaseStyle')} will be used. Note that in Internet Explorer\n if ${isc.DocUtils.linkForRef('attr:ListGrid.fastCellUpdates')} is true, <code>tallBaseStyle</code> will also be\n used even if the cellHeight matches the specified <code>normalCellHeight</code> for the\n grid.",
        name:"tallBaseStyle",
        seeAlso:[
            {
                ref:"method:ListGrid.getBaseStyle",
                description:null
            }
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"cell\"",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "type:AutoFitWidthApproach":{
        ref:"type:AutoFitWidthApproach",
        values:[
            {
                description:"Size field to fit to the data value(s) contained in the field.",
                value:"\"value\""
            },
            {
                description:"Size field to fit the field title",
                value:"\"title\""
            },
            {
                description:"Size field to fit either the field title or the data values in the field  (whichever requires more space).",
                value:"\"both\""
            }
        ],
        description:"How should field width be determined when ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')} is true?",
        name:"AutoFitWidthApproach",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "autoFitFields"
        ]
    },
    "method:Selection.select":{
        ref:"method:Selection.select",
        flags:"",
        description:"\t\t\tSelect a particular item\n",
        name:"select",
        seeAlso:[
        ],
        params:[
            {
                description:"object to select",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"object"
            }
        ],
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "method:ListGrid.expandRecords":{
        ref:"method:ListGrid.expandRecords",
        flags:"",
        description:" Expands the passed list of ${isc.DocUtils.linkForRef('object:ListGridRecord','records')} by creating a subcomponent for\n each record and inserting them it in to the record's grid-row.  Calls\n ${isc.DocUtils.linkForRef('method:ListGrid.expandRecord','expandRecord')} for each passed record, but only marks the\n grid for redraw once, after all expansions are complete.\n\n",
        name:"expandRecords",
        seeAlso:[
        ],
        params:[
            {
                description:"records to expand",
                optional:false,
                name:"records",
                defaultValue:null,
                type:"Array of ListGridRecord"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "attr:ListGrid.headerBarStyle":{
        ref:"attr:ListGrid.headerBarStyle",
        flags:"IR",
        description:"Set the CSS style used for the header as a whole.",
        name:"headerBarStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridHeader",
            "appearance"
        ]
    },
    "type:ListStyleType":{
        ref:"type:ListStyleType",
        values:[
            {
                description:"A filled, black dot (&bull;)",
                value:"\"disc\""
            },
            {
                description:"An unfilled circle (&#9702;)",
                value:"\"circle\""
            },
            {
                description:"A filled, black square (&#9632;)",
                value:"\"square\""
            },
            {
                description:"Numbers (1., 2., 3., etc.)",
                value:"\"decimal\""
            },
            {
                description:"Uppercase Roman numerals (I., II., III., IV., etc.)",
                value:"\"upper-roman\""
            },
            {
                description:"Lowercase Roman numerals (i., ii., iii., iv., etc.)",
                value:"\"lower-roman\""
            },
            {
                description:"Uppercase letters (A., B., C., etc.)",
                value:"\"upper-alpha\""
            },
            {
                description:"Lowercase letters (a., b., c., etc.)",
                value:"\"lower-alpha\""
            },
            {
                description:"An image used in place of a marker.",
                value:"\"custom-image\""
            }
        ],
        description:"The style of list item marker for a list.",
        name:"ListStyleType",
        seeAlso:[
        ],
        type:"type"
    },
    "attr:DataSourceField.showFileInline":{
        ref:"attr:DataSourceField.showFileInline",
        flags:"IR",
        description:"For a field of type:\"imageFile\", indicates whether to stream the image and display it\n inline or to display the View and Download icons.",
        name:"showFileInline",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField"
    },
    "attr:Canvas.percentBox":{
        ref:"attr:Canvas.percentBox",
        flags:"IRA",
        description:"Governs the model to be used when sizing canvases with percentage width or height, or\n positioning widgets with a specified ${isc.DocUtils.linkForRef('attr:Canvas.snapTo','snapTo')}.\n <P>\n Only affects widgets with a a specified ${isc.DocUtils.linkForRef('attr:Canvas.percentSource','percentSource')}, or\n widgets that have ${isc.DocUtils.linkForRef('attr:Canvas.snapTo')} set and are peers of some\n ${isc.DocUtils.linkForRef('method:Canvas.getMasterCanvas','other canvas')}.\n <P>\n Determines whether the coordinates used for sizing (for percentage sized widgets) and\n positioning (if <code>snapTo</code> is set) should be relative to the visible size or the\n viewport size of the percentSource or ${isc.DocUtils.linkForRef('method:Canvas.getMasterCanvas','master canvas')} widget.",
        name:"percentBox",
        seeAlso:[
        ],
        valueType:"PercentBoxModel",
        defaultValue:"\"visible\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "method:DateItem.getFiscalCalendar":{
        ref:"method:DateItem.getFiscalCalendar",
        flags:"",
        description:" Returns the ${isc.DocUtils.linkForRef('object:FiscalCalendar')} object that will be used by this item's DateChooser.\n\n",
        name:"getFiscalCalendar",
        seeAlso:[
        ],
        returns:{
            description:"the fiscal calendar for this chooser, if set, or the global            one otherwise",
            type:"FiscalCalendar"
        },
        type:"method",
        definingClass:"class:DateItem"
    },
    "attr:DynamicForm.implicitSaveDelay":{
        ref:"attr:DynamicForm.implicitSaveDelay",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:DynamicForm.implicitSave','implicitSave')} is true, this attribute dictates the \n millisecond delay after which form items are automatically saved during editing.",
        name:"implicitSaveDelay",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"2000",
        type:"attr",
        definingClass:"class:DynamicForm"
    },
    "method:DynamicForm.handleAsyncValidationReply":{
        ref:"method:DynamicForm.handleAsyncValidationReply",
        flags:"",
        description:" Notification fired when an asynchronous validation completes.\n",
        name:"handleAsyncValidationReply",
        seeAlso:[
        ],
        params:[
            {
                description:"true if validation succeeded, false if it failed",
                optional:false,
                name:"success",
                defaultValue:null,
                type:"boolean"
            },
            {
                description:"Map of errors by fieldName. Will be null if validation succeeded.",
                optional:false,
                name:"errors",
                defaultValue:null,
                type:"object"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm"
    },
    "method:Tree.getParents":{
        ref:"method:Tree.getParents",
        flags:"",
        description:"\n Given a node, return an array of the node's parents with the immediate parent first.  The\n node itself is not included in the result.  For example, for the following tree:\n <pre>\n root\n   foo\n     bar\n </pre>\n Calling <code>tree.getParents(bar)</code> would return: <code>[foo, root]</code>.  Note that\n the returned array will contain references to the nodes, not the names.\n\n",
        name:"getParents",
        seeAlso:[
        ],
        params:[
            {
                description:"node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"array of node's parents",
            type:"Array"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "attr:DetailViewerField.linkText":{
        ref:"attr:DetailViewerField.linkText",
        flags:"IRW",
        description:"The HTML to display for values of this field if the field type is set to \"link\". \n <P>\n This property sets linkText that will be the same for all records.  You can set linkText\n on a per-record basis via ${isc.DocUtils.linkForRef('attr:DetailViewerRecord.linkText')}.",
        name:"linkText",
        seeAlso:[
            {
                ref:"attr:DetailViewerField.type",
                description:null
            },
            {
                ref:"attr:DetailViewerRecord.linkText",
                description:null
            },
            {
                ref:"attr:DetailViewer.linkTextProperty",
                description:null
            },
            {
                ref:"attr:DetailViewerField.linkTextProperty",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField"
    },
    "attr:ListGrid.validateByCell":{
        ref:"attr:ListGrid.validateByCell",
        flags:"IRW",
        description:"Whether client-side validation checks should be performed when the user moves between\n cells in the current edit row.  If unset, defaults to ${isc.DocUtils.linkForRef('attr:ListGrid.editByCell')}.\n <P>\n Note that validation always occurs when a row is to be saved, so setting\n ${isc.DocUtils.linkForRef('attr:ListGrid.saveByCell')}:true forces validation on cell transitions.  To completely disable\n automatic validation, set ${isc.DocUtils.linkForRef('attr:ListGrid.neverValidate')}:true.",
        name:"validateByCell",
        seeAlso:[
            {
                ref:"group:editing",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "gridValidation"
        ]
    },
    "method:GridRenderer.getEventColumn":{
        ref:"method:GridRenderer.getEventColumn",
        flags:"",
        description:" Returns the column number of the most recent mouse event.\n",
        name:"getEventColumn",
        seeAlso:[
        ],
        params:[
            {
                description:"optional x-coordinate to obtain column number for, in lieu of the x                        coordinate of the last mouse event",
                optional:true,
                name:"x",
                defaultValue:null,
                type:"Integer"
            }
        ],
        returns:{
            description:"column number, or -2 if beyond last drawn column",
            type:"int"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "events",
            "selection"
        ]
    },
    "attr:Canvas.snapHGap":{
        ref:"attr:Canvas.snapHGap",
        flags:"IRW",
        description:"The horizontal grid size to use, in pixels, when snap-to-grid is enabled.",
        name:"snapHGap",
        seeAlso:[
            {
                ref:"attr:Canvas.snapToGrid",
                description:null
            },
            {
                ref:"attr:Canvas.snapResizeToGrid",
                description:null
            },
            {
                ref:"attr:Canvas.childrenSnapToGrid",
                description:null
            },
            {
                ref:"attr:Canvas.childrenSnapResizeToGrid",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ]
    },
    "type:RelativeDateShortcut":{
        ref:"type:RelativeDateShortcut",
        description:"A RelativeDateShortcut is a special string that represents a shortcut to a date phrase that can \n be automatically mapped to a ${isc.DocUtils.linkForRef('type:RelativeDateString')} for use in widgets that \n leverage relative-dates, such as the ${isc.DocUtils.linkForRef('class:RelativeDateItem')}.\n <P>\n Note that some shortcuts indicate a time period but do not directly indicate whether the value\n refers to the start or end of the time period in question. This ambiguity\n can be resolved by specifying an explicit ${isc.DocUtils.linkForRef('type:RelativeDateRangePosition')} when calling APIs that \n convert from RelativeDates to absolute date values. This is the case for <i>$today</i>, \n <i>$tomorrow</i>, <i>$yesterday</i>, <i>$weekAgo</i>, <i>$weekFromNow</i>, <i>$monthAgo</i>\n and <i>$monthFromNow</i>. If a range position is not explicitly passed, these will all default\n to the start of the day in question.\n <P>\n Builtin options include\n <ul>\n <li> $now - this moment </li>\n <li> $today - the current day. By default this resolves to the start of the current day though\n   an explicit ${isc.DocUtils.linkForRef('type:RelativeDateRangePosition')} may be used to specify the end of the current day.</li>\n <li> $startOfToday - the start of today</li>\n <li> $endOfToday - the end of today (one millisecond before the $startOfTomorrow) </li>\n <li> $yesterday - the previous day.</li>\n <li> $startOfYesterday - the start of yesterday</li>\n <li> $endOfYesterday - the end of yesterday (one millisecond before the $startOfToday) </li>\n <li> $tomorrow - the following day</li>\n <li> $startOfTomorrow - the start of tomorrow </li>\n <li> $endOfTomorrow - the end of tomorrow </li>\n <li> $weekAgo - the current day of the previous week </li>\n <li> $weekFromNow - the current day of the next week </li>\n <li> $startOfWeek - the start of the current week </li>\n <li> $endOfWeek - the end of the current week </li>\n <li> $monthAgo - the current day of the previous month </li>\n <li> $monthFromNow - the current day of the following month </li>\n <li> $startOfMonth - the start of the current month </li>\n <li> $endOfMonth - the end of the current month </li>\n <li> $startOfYear - the start of the current year </li>\n <li> $endOfYear - the end of the current year </li>\n </ul>\n \n <P>",
        name:"RelativeDateShortcut",
        seeAlso:[
            {
                ref:"type:RelativeDateString",
                description:null
            }
        ],
        type:"type"
    },
    "method:Gauge.setMinValue":{
        ref:"method:Gauge.setMinValue",
        flags:"",
        description:" Sets the minimum dial value, rescaling all sectors and the dial value.\n\n",
        name:"setMinValue",
        seeAlso:[
        ],
        params:[
            {
                description:"the new minimum dial value. Must be at least 1 less than the maximum dial value. If <code>minValue</code> is not at least 1 less than the maximum value,\n then it is set to <code>maxValue - 1</code>.",
                optional:false,
                name:"minValue",
                defaultValue:null,
                type:"float"
            }
        ],
        type:"method",
        definingClass:"class:Gauge"
    },
    "attr:UserTask.targetView":{
        ref:"attr:UserTask.targetView",
        flags:"IR",
        description:"Optional widget that should be shown to allow user input.  If this widget is a DynamicForm,\n it will also be automatically used as the ${isc.DocUtils.linkForRef('attr:UserTask.targetForm')} unless either\n <code>targetForm</code> or ${isc.DocUtils.linkForRef('attr:UserTask.targetVM')} is set.\n <P>\n <code>UserTask</code> will automatically handle various scenarios of the\n <code>targetView</code> being not currently visible or draw()n, according to the following\n rules:\n <ul>\n <li> if the view itself is marked hidden, it will be show()n\n <li> if the view is inside a hidden parent, the parent will be show()n\n <li> if the view is the ${isc.DocUtils.linkForRef('attr:Tab.pane')} of a tab in a TabSet, the tab will be selected\n <li> if the view is listed in ${isc.DocUtils.linkForRef('attr:SectionStackSection.items')} for a which is either\n      collapsed or hidden section, the section will be shown and expanded\n <li> if the view is listed in ${isc.DocUtils.linkForRef('attr:Window.items')} for a Window, the Window will be shown\n <li> if any of these conditions apply to any parent of the targetView, the rules will be\n      applied to that parent as well.  For example, the targetView is in a collapsed section\n      inside a tab which is not selected, the section will be expanded <b>and</b> the tab\n      selected\n </ul>",
        name:"targetView",
        seeAlso:[
        ],
        valueType:"Canvas or String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:UserTask"
    },
    "attr:Canvas.snapTo":{
        ref:"attr:Canvas.snapTo",
        flags:"IRW",
        getter:[
            "getSnapTo"
        ],
        description:"Position this widget such that it is aligned with (\"snapped to\") an edge of its\n ${isc.DocUtils.linkForRef('method:Canvas.getMasterCanvas','master')} (if specified), or its\n ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas','parent canvas')}.\n <P>\n Note that this property also impacts the sizing of this widget. If this widgets size\n is specified as a percent value, and has no explicit\n ${isc.DocUtils.linkForRef('attr:Canvas.percentSource')}, sizing will be calculated based on the size of the\n ${isc.DocUtils.linkForRef('method:Canvas.getMasterCanvas','master canvas')} when snapTo is set.\n <P>\n Possible values: BR, BL, TR, TL, R, L, B, T, C where B=Bottom, T=Top, L=Left, R=right\n and C=center\n <P>\n Standard snapTo behavior will attach the outer edge of the widget to the parent or master\n element - for example setting <code>snapTo</code> to <code>\"B\"</code> would align the\n bottom edge of this component with the bottom edge of the master or parent element\n (and center this component horizontally over its master or parent element).\n ${isc.DocUtils.linkForRef('attr:Canvas.snapEdge')} can be specified to change this behavior allowing the developer\n to, for example, align the top edge of this component with the bottom edge of its\n ${isc.DocUtils.linkForRef('method:Canvas.getMasterCanvas','master canvas')}.\n <P>\n ${isc.DocUtils.linkForRef('attr:Canvas.snapOffsetLeft')} and ${isc.DocUtils.linkForRef('attr:Canvas.snapOffsetTop')} may also be specified to\n offset the element from exact snapTo alignment.",
        name:"snapTo",
        setter:[
            "setSnapTo"
        ],
        seeAlso:[
            {
                ref:"attr:Canvas.snapEdge",
                description:null
            },
            {
                ref:"attr:Canvas.percentBox",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "attr:Slider.hTrackStyle":{
        ref:"attr:Slider.hTrackStyle",
        flags:"IR",
        description:"Optional CSS style for the track for a horizontally oriented slider.\n <P>\n Will have the suffix \"Disabled\" added when the slider is disabled.",
        name:"hTrackStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Slider"
    },
    "method:MultiSortDialog.getSortLevel":{
        ref:"method:MultiSortDialog.getSortLevel",
        flags:"",
        description:" Return a ${isc.DocUtils.linkForRef('object:SortSpecifier')} object for the requested levelNum.\n\n",
        name:"getSortLevel",
        seeAlso:[
        ],
        params:[
            {
                description:"The index of the level to return a SortSpecifier for",
                optional:false,
                name:"levelNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"A SortSpecifier representing the requested levelNum",
            type:"SortSpecifier"
        },
        type:"method",
        definingClass:"class:MultiSortDialog"
    },
    "attr:TileLayout.tileHMargin":{
        ref:"attr:TileLayout.tileHMargin",
        flags:"IR",
        description:"Horizontal margin in between tiles.  See ${isc.DocUtils.linkForRef('attr:TileLayout.tileMargin')}.",
        name:"tileHMargin",
        setter:[
            "setTileHMargin"
        ],
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TileLayout",
        groups:[
            "layoutMargin"
        ]
    },
    "method:ImgButton.titleHover":{
        ref:"method:ImgButton.titleHover",
        flags:"",
        description:" Optional stringMethod to fire when the user hovers over this button and the title is\n clipped. If ${isc.DocUtils.linkForRef('attr:ImgButton.showClippedTitleOnHover')} is true, the default behavior is to\n show a hover canvas containing the HTML returned by ${isc.DocUtils.linkForRef('method:ImgButton.titleHoverHTML')}.\n Return false to suppress this default behavior.\n",
        name:"titleHover",
        seeAlso:[
            {
                ref:"method:ImgButton.titleClipped",
                description:null
            }
        ],
        returns:{
            description:"false to suppress the standard hover",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:ImgButton",
        groups:[
            "hovers"
        ]
    },
    "method:IconButton.click":{
        ref:"method:IconButton.click",
        flags:"",
        description:" Notification method fired when a user clicks anywhere on this button.  If the click occurred\n directly on the ${isc.DocUtils.linkForRef('attr:IconButton.icon','icon')} or the ${isc.DocUtils.linkForRef('iconButton.menuIcon','menuIcon')}, \n the related notifications ${isc.DocUtils.linkForRef('method:IconButton.iconClick','iconClick')} and \n ${isc.DocUtils.linkForRef('method:IconButton.menuIconClick','menuIconClick')} are fired first and must return false to \n prevent this notification from firing.\n <P>\n If a ${isc.DocUtils.linkForRef('iconButton.menu','menu')} is installed then, by default, it is only displayed when a \n user clicks on the ${isc.DocUtils.linkForRef('iconButton.menuIcon','menuIcon')}.  This can be altered via \n ${isc.DocUtils.linkForRef('attr:IconButton.showMenuOnClick','showMenuOnClick')}.\n\n",
        name:"click",
        seeAlso:[
        ],
        returns:{
            description:"return false to cancel event-bubbling",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:IconButton"
    },
    "attr:DateRangeDialog.okButtonTitle":{
        ref:"attr:DateRangeDialog.okButtonTitle",
        flags:"IR",
        description:"The title for the \"OK\" button on this dialog.",
        name:"okButtonTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"OK\"",
        type:"attr",
        definingClass:"class:DateRangeDialog",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DateChooser.cancelButton":{
        ref:"attr:DateChooser.cancelButton",
        flags:"IR",
        description:"A button shown below the ${isc.DocUtils.linkForRef('class:DateGrid','calendar grid')} which, when clicked, \n closes the DateChooser without selecting a value.",
        name:"cancelButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:MultiSortPanel.addLevelButton":{
        ref:"attr:MultiSortPanel.addLevelButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for adding new levels\n to the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.addLevelButtonProperties</code> and \n <code>multiSortPanel.addLevelButtonDefaults</code>.",
        name:"addLevelButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiSortPanel"
    },
    "attr:TimeItem.ampmItemTitle":{
        ref:"attr:TimeItem.ampmItemTitle",
        flags:"IRW",
        description:"Title to show for the ${isc.DocUtils.linkForRef('attr:TimeItem.ampmItem','AM/PM picker')}.",
        name:"ampmItemTitle",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"AM/PM\"",
        type:"attr",
        definingClass:"class:TimeItem",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Canvas.edgeCursorMap":{
        ref:"attr:Canvas.edgeCursorMap",
        flags:"IRWA",
        description:"Cursor to use when over each edge of a Canvas that is drag resizable.\n <P>\n To disable drag resize cursors, set the edgeCursorMap property to null.",
        name:"edgeCursorMap",
        seeAlso:[
            {
                ref:"attr:Canvas.resizeFrom",
                description:null
            }
        ],
        valueType:"object",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ]
    },
    "attr:Canvas.hoverWidth":{
        ref:"attr:Canvas.hoverWidth",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.showHover','this.showHover')} is true, this property can be used to customize the\n width of the hover canvas shown.",
        name:"hoverWidth",
        seeAlso:[
            {
                ref:"attr:Canvas.showHover",
                description:null
            }
        ],
        valueType:"int",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('customHovers')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "hovers"
        ]
    },
    "attr:ListGrid.printCheckboxFieldFalseImage":{
        ref:"attr:ListGrid.printCheckboxFieldFalseImage",
        flags:"IRWA",
        description:"If set, the ${isc.DocUtils.linkForRef('attr:ListGrid.checkboxFieldFalseImage')} to use when ${isc.DocUtils.linkForRef('groupDef:printing','printing')}.",
        name:"printCheckboxFieldFalseImage",
        seeAlso:[
            {
                ref:"attr:ListGrid.checkboxFieldFalseImage",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "checkboxField",
            "printing"
        ]
    },
    "attr:FormItem.iconWidth":{
        ref:"attr:FormItem.iconWidth",
        flags:"IRWA",
        getter:[
            "getIconWidth"
        ],
        description:"Default width for form item icons",
        name:"iconWidth",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"20",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formIcons"
        ]
    },
    "attr:DrawGroup.left":{
        ref:"attr:DrawGroup.left",
        flags:"IRW",
        description:"Left coordinate of the ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')} in pixels relative to the DrawPane.",
        name:"left",
        setter:[
            "setLeft"
        ],
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0",
        type:"attr",
        definingClass:"class:DrawGroup"
    },
    "attr:DSRequest.resultTree":{
        ref:"attr:DSRequest.resultTree",
        flags:"R",
        description:"For advanced use in integrating trees that \n ${isc.DocUtils.linkForRef('attr:ResultTree.loadDataOnDemand','load data on demand')} with web services,\n the ResultTree that issued this \"fetch\" DSRequest is automatically made available as the\n <code>resultTree</code> property.\n <P>\n This property can only be read.  There is no meaning to setting this property\n yourself.",
        name:"resultTree",
        seeAlso:[
        ],
        valueType:"ResultTree",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:ValuesManager.members":{
        ref:"attr:ValuesManager.members",
        flags:"IRW",
        getter:[
            "getMembers"
        ],
        description:"The set of member components for this valuesManager.  These can be specified at init time\n via the <code>members</code> property, or updated at runtime via <code>addMember()</code>\n and <code>removeMember()</code>.<br>\n Note: Alternatively a DataBoundComponent can be initialized as a member of a valuesManager\n by setting the <code>valuesManager</code> property of the component to a pre-defined \n valuesManager instance, or by calling <code>setValuesManager</code> on the component.",
        name:"members",
        seeAlso:[
            {
                ref:"method:ValuesManager.addMember",
                description:null
            },
            {
                ref:"method:ValuesManager.removeMember",
                description:null
            },
            {
                ref:"method:Canvas.setValuesManager",
                description:null
            }
        ],
        valueType:"Array of DynamicForm",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ValuesManager"
    },
    "attr:CancelItem.title":{
        ref:"attr:CancelItem.title",
        flags:"IRW",
        description:"CancelItems show a title of <code>\"Cancel\"</code> by default. May be overridden.",
        name:"title",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Cancel\"",
        type:"attr",
        definingClass:"class:CancelItem"
    },
    "attr:ListGrid.exportFieldAlignments":{
        ref:"attr:ListGrid.exportFieldAlignments",
        flags:"IRW",
        description:"When exporting data to Excel/OpenOffice format using ${isc.DocUtils.linkForRef('method:ListGrid.exportData')} or\n ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData')}, whether field\n ${isc.DocUtils.linkForRef('attr:ListGridField.align','horizontal header alignments')} and \n ${isc.DocUtils.linkForRef('attr:ListGridField.cellAlign','data value alignments')} should be replicated in the resulting \n spreadsheet. \n <p>\n If this attribute is not set, cells will be assigned a default alignment by the spreadsheet,\n which is typically right-aligned for numeric and date values, and left-aligned for \n everything else (including dates and numbers that have been exported as strings, as would\n be the case, for example, if ${isc.DocUtils.linkForRef('attr:DSRequest.exportDatesAsFormattedString')} is set)",
        name:"exportFieldAlignments",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:ResultSet.getSort":{
        ref:"method:ResultSet.getSort",
        flags:"",
        description:" Return the current sort-specification for this ResultSet as an Array of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n \n",
        name:"getSort",
        seeAlso:[
        ],
        returns:{
            description:"the list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s currently applied to   this ResultSet",
            type:"Array of SortSpecifier"
        },
        type:"method",
        definingClass:"class:ResultSet"
    },
    "attr:TimeItem.maskOverwriteMode":{
        ref:"attr:TimeItem.maskOverwriteMode",
        flags:"IRWA",
        description:"Internal-use only for a TimeItem.",
        name:"maskOverwriteMode",
        seeAlso:[
            {
                ref:"attr:TimeItem.useMask",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "method:StatefulCanvas.select":{
        ref:"method:StatefulCanvas.select",
        flags:"",
        description:" Select this object.\n",
        name:"select",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:[
            "state"
        ]
    },
    "attr:DrawShape.commands":{
        ref:"attr:DrawShape.commands",
        flags:"IRW",
        description:"The drawing commands that will be executed to render the shape.",
        name:"commands",
        setter:[
            "setCommands"
        ],
        seeAlso:[
        ],
        valueType:"Array of DrawShapeCommand",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DrawShape"
    },
    "attr:FormItem.allowExpressions":{
        ref:"attr:FormItem.allowExpressions",
        flags:"IRW",
        description:"For a form that produces filter criteria\n (see ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','form.getValuesAsCriteria()')}), allows the user\n to type in simple expressions to cause filtering with that operator.  For\n example, entering \"&gt;5\" means values greater than 5, and \"&gt;0 and &lt;5\" means values between\n 0 and 5.\n <P>\n The following table lists character sequences that can be entered as a prefix to a value, \n and the corresponding ${isc.DocUtils.linkForRef('type:OperatorId','operator')} that will be used. \n <P>\n <table style='font-size:14;'>\n <tr><td><b>Prefix</b></td><td><b>Operator</b></td></tr>\n <tr><td>&lt;</td><td>lessThan</td></tr>\n <tr><td>&gt;</td><td>greaterThan</td></tr>\n <tr><td>&lt;=</td><td>lessThanOrEqual</td></tr>\n <tr><td>&gt;=</td><td>greaterThanOrEqual</td></tr>\n <tr><td>someValue...someValue</td><td>betweenInclusive</td></tr>\n <tr><td>!</td><td>notEqual</td></tr>\n <tr><td>^</td><td>startsWith</td></tr>\n <tr><td>|</td><td>endsWith</td></tr>\n <tr><td>!^</td><td>notStartsWith plus logical not</td></tr>\n <tr><td>!@</td><td>notEndsWith plus logical not</td></tr>\n <tr><td>~</td><td>contains</td></tr>\n <tr><td>!~</td><td>notContains</td></tr>\n <tr><td>#</td><td>isNull</td></tr>\n <tr><td>!#</td><td>isNotNull</td></tr>\n <tr><td>==</td><td>exact match (for fields where 'contains' is the default)</td></tr>\n </table>\n <P>\n Two further special notations are allowed:\n <ul>\n <li> /<i>regex</i>/ means the value is taken as a regular expression and applied via the\n \"regexp\" operator\n <li> =.<i>fieldName</i> means the value should match the value of another field.  Either the\n user-visible title of the field (field.title) or the field's name (field.name) may be used.\n </ul>\n <P>\n In all cases, if an operator is disallowed for the field (via\n ${isc.DocUtils.linkForRef('attr:DataSourceField.validOperators','field.validOperators')} at either the dataSource or field\n level), the operator character is ignored (treated as part of a literal value).\n <P>\n By default, the case-insensitive version of the operator is used (eg, startsWith will\n actually use \"iStartsWith\").  To avoid this, explicitly set item.operator (the default\n operator) to any case sensitive operator (eg \"equals\" or \"contains\") and case sensitive\n operators will be used for user-entered expressions.\n <P>\n Compound expressions (including \"and\" and \"or\") are allowed only for numeric or date/time\n types.\n <P>\n Note that if the user does not type a prefix or use other special notation as described\n above, the operator specified via ${isc.DocUtils.linkForRef('attr:FormItem.operator')} is used, or if\n <code>formItem.operator</code> is unspecified, a default operator chosen as described\n under ${isc.DocUtils.linkForRef('attr:FormItem.operator')}.  \n <p>\n Also note that whatever you enter will be used literally, including any whitespace\n characters. For example if you input '== China ' then ' China ' will be the value.\n <p>\n The <code>allowExpression</code> behavior can be enabled for every field in a form via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.allowExpressions')}.\n <P>\n Finally, note that, like ${isc.DocUtils.linkForRef('attr:FormItem.operator')}, enabling\n <code>allowExpressions:true</code> causes\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria','form.getValuesAsCriteria()')}) to return\n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}.",
        name:"allowExpressions",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "advancedFilter"
        ]
    },
    "attr:DataBoundComponent.progressiveLoading":{
        ref:"attr:DataBoundComponent.progressiveLoading",
        flags:"IRW",
        description:"Indicates whether or not this component will load its data \n ${isc.DocUtils.linkForRef('attr:DataSource.progressiveLoading','progressively')}.",
        name:"progressiveLoading",
        seeAlso:[
            {
                ref:"attr:DataSource.progressiveLoading",
                description:null
            },
            {
                ref:"attr:ResultSet.progressiveLoading",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "progressiveLoading"
        ]
    },
    "type:TreeGridViewState":{
        ref:"type:TreeGridViewState",
        description:"An object containing the \"view state\" information for a treeGrid. In addition to the \n state data contained by a ${isc.DocUtils.linkForRef('type:ListGridViewState')} object, this will also contain the \n current open state of the treeGrid in question.<br>\n Note that this object is not intended to be interrogated directly, but may be stored \n (for example) as a blob on the server for view state persistence across sessions.",
        name:"TreeGridViewState",
        seeAlso:[
        ],
        type:"type",
        groups:[
            "viewState"
        ]
    },
    "classMethod:DrawSector.getArcMidpoint":{
        ref:"classMethod:DrawSector.getArcMidpoint",
        flags:"",
        description:" Calculates the midpoint coordinates of the circular arc of the sector defined by the\n given centerPoint, startAngle, endAngle, and radius. The formula for this point is:\n <blockquote>\n <pre>var averageAngle = (startAngle + endAngle) / 2; // in degrees\n[centerX + radius * cosdeg(averageAngle), centerY + radius * sindeg(averageAngle)]</pre>\n </blockquote>\n",
        name:"getArcMidpoint",
        seeAlso:[
        ],
        params:[
            {
                description:"X coordinate of the center point of the sector.",
                optional:false,
                name:"centerX",
                defaultValue:null,
                type:"double"
            },
            {
                description:"Y coordinate of the center point of the sector.",
                optional:false,
                name:"centerY",
                defaultValue:null,
                type:"double"
            },
            {
                description:"start angle of the sector in degrees.",
                optional:false,
                name:"startAngle",
                defaultValue:null,
                type:"double"
            },
            {
                description:"end angle of the sector in degrees.",
                optional:false,
                name:"endAngle",
                defaultValue:null,
                type:"double"
            },
            {
                description:"radius of the sector.",
                optional:false,
                name:"radius",
                defaultValue:null,
                type:"double"
            }
        ],
        returns:{
            description:"the coordinates of the midpoint of the arc.",
            type:"Point"
        },
        type:"classMethod",
        definingClass:"class:DrawSector"
    },
    "attr:MetricSettings.dataLineProperties":{
        ref:"attr:MetricSettings.dataLineProperties",
        flags:"IR",
        description:"Properties for lines that show data (as opposed to gradations or borders around the data\n area).",
        name:"dataLineProperties",
        seeAlso:[
        ],
        valueType:"DrawLine Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MetricSettings"
    },
    "attr:TileGrid.showAllRecords":{
        ref:"attr:TileGrid.showAllRecords",
        flags:"IR",
        description:"Whether tiles are created and drawn for all records, or only for those currently visible.",
        name:"showAllRecords",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TileGrid",
        groups:[
            "basics"
        ]
    },
    "method:TreeGrid.openLeaf":{
        ref:"method:TreeGrid.openLeaf",
        flags:"A",
        description:" Executed when a leaf node receives a 'doubleClick' event. This handler must be\n specified as a function, whose single parameter is a reference to the relevant leaf node in\n the tree's data.<br>\n See the ListGrid Widget Class for inherited recordClick and recordDoubleClick events.\n\n",
        name:"openLeaf",
        seeAlso:[
            {
                ref:"class:ListGrid",
                description:null
            }
        ],
        params:[
            {
                description:"node to open",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "method:ListGrid.canExpandRecord":{
        ref:"method:ListGrid.canExpandRecord",
        flags:"",
        description:" Indicates whether a given record or rowNum can be expanded.  The default implementation\n checks the value of ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} and\n <code>record[${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecordProperty')}]</code>.\n <P>\n Override this method for more specific control over individual record expansion.\n <P>\n <b>Note:</b> Rows with no underlying record in the data array - for example newly\n added edit rows that have not yet been saved - cannot be expanded.\n\n",
        name:"canExpandRecord",
        seeAlso:[
        ],
        params:[
            {
                description:"record to work with",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"rowNum of the record to work with",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"Number"
            }
        ],
        returns:{
            description:"true if the record can be expanded",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "classMethod:XMLTools.selectObjects":{
        ref:"classMethod:XMLTools.selectObjects",
        flags:"A",
        description:" Applies an XPath expression to JavaScript objects, returning matching objects.\n <P>\n Both child and attribute names are interpreted as property names, and array access notation\n can be used to select elements from Arrays.  For example:<pre>\n     var results = {\n        searchResults:[\n            { title:\"Page One\", relevance:6.3 },\n            { title:\"Page Two\", relevance:5.2, \n              summary: \"Summary of Page One\" }\n        ]\n     };\n\n     // returns the \"searchResults\" two-item Array\n     isc.XMLTools.selectObjects(results, \"/searchResults\");\n\n     // returns the first item under \"searchResults\", in an Array (NOTE: in XPath, Array\n     // index starts at 1, not 0)\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]\");\n\n     // returns [\"Page One\"]\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]/title\");\n\n     // also returns [\"Page One\"]\n     isc.XMLTools.selectObjects(results, \"/searchResults[1]@title\");\n </pre>\n A limited form of XPath \"predicates\", that is, expressions with brackets that filter\n returned objects, is allowed.  A predicate can be either:\n <ul>\n <li> a number only, eg [5], for Array access\n <li> the XPath function call \"last()\", eg [last()], to retrieve the last item\n <li> a property name (*without* any leading \"@\"), meaning that the property contains a value\n      that is considered \"true\" in JavaScript.  For example: [summary]\n <li> a property name, comparison operator, and either a number or String literal, for\n      example, [name = \"bob\"].  In this case the property can also be the XPath function\n      position(), for example, [position() > 5]\n </ul>\n Some examples of using simple predicates with the sample data above:\n <pre>\n     // returns an Array with only the first result\n     isc.XMLTools.selectObjects(results, \"/searchResults[relevance > 5.5]\");\n \n     // return an Array with only the second result, since the first has no summary\n     isc.XMLTools.selectObjects(results, \"/searchResults[summary]\");\n </pre>\n Details of the XPath -> Objects mapping:\n <ul> \n <li> JavaScript Object properties are considered element children, and text children do not\n      exist (in the XML model, text children exist *between* element children, but nothing\n      exists between JavaScript properties)\n <li> The contents of Array-valued properties are considered immediate element children (this\n      is consistent with the predicate \"[5]\" acting like Array access)\n <li> \"*\" in XML selects all element children, so \"*\" in Object XPath selects the values of\n      all properties, that is, ${isc.DocUtils.linkForRef('classMethod:isc.getValues','isc.getValues(object)')}, except\n      that Array-valued properties are \"flattened\" into the returned list.\n </ul>\n\n",
        name:"selectObjects",
        seeAlso:[
        ],
        params:[
            {
                description:"Object to select results from",
                optional:false,
                name:"object",
                defaultValue:null,
                type:"Object"
            },
            {
                description:"XPath expression",
                optional:false,
                name:"xPath",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"Array of matching objects, or null for no match",
            type:"Array"
        },
        type:"classMethod",
        definingClass:"class:XMLTools"
    },
    "attr:FieldPicker.dataSource":{
        ref:"attr:FieldPicker.dataSource",
        flags:"IR",
        description:"An optional DataSource that is used to create a disposable\n ${isc.DocUtils.linkForRef('attr:FieldPicker.dataBoundComponent')} if none is provided.\n Has no effect if a ${isc.DocUtils.linkForRef('attr:FieldPicker.dataBoundComponent')} is specified.",
        name:"dataSource",
        seeAlso:[
        ],
        valueType:"DataSource",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FieldPicker"
    },
    "attr:PortalLayout.row":{
        ref:"attr:PortalLayout.row",
        flags:"A",
        description:"Automatically generated horizontal ${isc.DocUtils.linkForRef('class:Layout')} used to create rows of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} via\n ${isc.DocUtils.linkForRef('method:Class.createAutoChild','createAutoChild()')}. Since this is an ${isc.DocUtils.linkForRef('type:AutoChild')}, you can use \n rowDefaults and rowProperties to customize the rows.\n <p>\n Rows are created inside ${isc.DocUtils.linkForRef('attr:PortalLayout.rowLayout','rowLayouts')}, which in turn are inside ${isc.DocUtils.linkForRef('attr:PortalLayout.column','columns')}.",
        name:"row",
        seeAlso:[
            {
                ref:"attr:PortalLayout.column",
                description:null
            },
            {
                ref:"attr:PortalLayout.rowLayout",
                description:null
            }
        ],
        valueType:"MultiAutoChild Layout",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PortalLayout"
    },
    "attr:Splitbar.canCollapse":{
        ref:"attr:Splitbar.canCollapse",
        flags:"IRW",
        description:"If this property is true, a click on the Splitbar will collapse its \n ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}, hiding it and shifting the Splitbar and other members\n of the layout across to fill the newly available space. If the target is already hidden\n a click will expand it again (showing it at its normal size).\n <p>\n Note that on touch devices, to enable collapsing/uncollapsing the <code>target</code>\n in response to a tap, ${isc.DocUtils.linkForRef('attr:Splitbar.canCollapseOnTap','canCollapseOnTap')} must be set to\n <code>true</code>.",
        name:"canCollapse",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Splitbar"
    },
    "attr:TabSet.pickerButtonSize":{
        ref:"attr:TabSet.pickerButtonSize",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:TabSet.showTabPicker')} is true, this property governs the size of tab-picker\n button. Applied as the width of buttons if the tabBar is horizontal, or the height\n if tabBar is vertical. Note that the other dimension is determined by\n ${isc.DocUtils.linkForRef('attr:TabSet.tabBarThickness','this.tabBarThickness')}",
        name:"pickerButtonSize",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:TabSet",
        groups:[
            "tabBarControls"
        ]
    },
    "group:event":{
        ref:"group:event",
        refs:[
        ],
        name:"event",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:Canvas.useOpacityFilter":{
        ref:"attr:Canvas.useOpacityFilter",
        flags:"IR",
        description:"Configures where the Opacity filter is used for IE6-8.\n <P>\n With the default of null, opacity filters are used unless\n ${isc.DocUtils.linkForRef('classAttr:Canvas.neverUseFilters')} has been set.  When set explicitly to true,\n opacity filters are used even if <code>neverUseFilters</code> is true.\n <P>\n See ${isc.DocUtils.linkForRef('group:IEFilters')} for background.",
        name:"useOpacityFilter",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "IEFilters"
        ]
    },
    "group:dateFormatting":{
        ref:"group:dateFormatting",
        refs:[
            "method:Date.getShortDayName",
            "method:Date.getDayName",
            "method:Date.getShortMonthName",
            "method:Date.getMonthName",
            "method:Date.getShortYear",
            "method:Date.getWeek",
            "method:Date.toDateStamp",
            "method:Date.toNormalDate",
            "method:Date.toNormalDatetime",
            "method:Date.toShortDate",
            "method:Date.toShortDateTime",
            "method:Date.setDefaultDateSeparator",
            "method:Date.getDefaultDateSeparator",
            "method:Date.toUSShortDate",
            "method:Date.toUSShortDateTime",
            "method:Date.toEuropeanShortDate",
            "method:Date.toEuropeanShortDateTime",
            "method:Date.toJapanShortDate",
            "method:Date.toJapanShortDateTime",
            "method:Date.toSerializeableDate",
            "method:Date.setFormatter",
            "method:Date.toPrettyString",
            "classMethod:DateUtil.format",
            "classMethod:Date.parseInput",
            "classMethod:Date.setNormalDisplayFormat",
            "classMethod:Date.setNormalDatetimeDisplayFormat",
            "classMethod:Date.setShortDisplayFormat",
            "classMethod:Date.setDefaultDateSeparator",
            "classMethod:Date.getDefaultDateSeparator",
            "classMethod:Date.setShortDatetimeDisplayFormat",
            "classMethod:Date.getWeekendDays"
        ],
        name:"dateFormatting",
        seeAlso:[
        ],
        type:"group"
    },
    "group:grouping":{
        ref:"group:grouping",
        refs:[
            "method:ListGridField.getGroupValue",
            "method:ListGridField.getGroupTitle",
            "method:ListGrid.groupBy",
            "method:ListGrid.getOriginalData",
            "object:groupNode",
            "attr:groupNode.groupMembers",
            "attr:groupNode.groupTitle",
            "attr:groupNode.groupValue",
            "attr:ListGrid.originalData",
            "attr:ListGrid.groupTree",
            "attr:ListGrid.groupStartOpen",
            "attr:ListGrid.canCollapseGroup",
            "attr:ListGrid.groupTitleField",
            "attr:ListGrid.showGroupSummaryInHeader",
            "attr:ListGrid.showCollapsedGroupSummary",
            "attr:ListGridField.groupingModes",
            "attr:ListGridField.groupingMode",
            "attr:ListGridField.defaultGroupingMode",
            "attr:ListGridField.groupPrecision",
            "attr:ListGridField.groupGranularity",
            "attr:ListGrid.groupNodeStyle",
            "attr:ListGrid.groupNodeBaseStyle",
            "attr:ListGrid.groupIcon",
            "attr:ListGrid.groupIconSize",
            "attr:ListGrid.groupIndentSize",
            "attr:ListGrid.groupLeadingIndent",
            "attr:ListGrid.canGroupBy",
            "attr:ListGrid.groupByMaxRecords",
            "attr:ListGrid.isGrouped",
            "attr:ListGrid.nullGroupTitle",
            "attr:ListGrid.groupByField"
        ],
        name:"grouping",
        seeAlso:[
        ],
        type:"group"
    },
    "method:ListGrid.setEditValue":{
        ref:"method:ListGrid.setEditValue",
        flags:"A",
        description:"\n  Modifies a field value being tracked as an unsaved user edit.<P>\n  Use for suggested or reformatted values for edits that remain unsaved.\n\n",
        name:"setEditValue",
        seeAlso:[
        ],
        params:[
            {
                description:"Row number (or edit values ID)",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"Column number of cell, or name of field                                           having editValue updated",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number | string"
            },
            {
                description:"New value for the appropriate field.",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "attr:TileGrid.selectionType":{
        ref:"attr:TileGrid.selectionType",
        flags:"IRW",
        description:"Defines a tileGrid's clickable-selection behavior.",
        name:"selectionType",
        seeAlso:[
            {
                ref:"type:SelectionStyle",
                description:null
            }
        ],
        valueType:"SelectionStyle",
        defaultValue:"Selection.MULTIPLE",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('tilingEditing')}"
        ],
        definingClass:"class:TileGrid",
        groups:[
            "selection",
            "appearance"
        ]
    },
    "attr:DataSourceField.escapeHTML":{
        ref:"attr:DataSourceField.escapeHTML",
        flags:"IR",
        description:"When data values are displayed in DataBound components, by default strings will be interpreted\n as HTML by the browser in most cases.\n <P>\n If set, this property will be picked up by components bound to this dataSource, notifying them\n that any HTML characters should be escaped when displaying values for this field.",
        name:"escapeHTML",
        seeAlso:[
            {
                ref:"attr:ListGridField.escapeHTML",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSourceField"
    },
    "attr:Splitbar.src":{
        ref:"attr:Splitbar.src",
        flags:"IR",
        description:"The base URL for the image. \n <P>\n The ${isc.DocUtils.linkForRef('type:State')} for the component will be combined with this URL using the\n same approach as described in ${isc.DocUtils.linkForRef('attr:Img.src')}.\n Then the image segment ${isc.DocUtils.linkForRef('attr:StretchItem.name','name')} as specified by each ${isc.DocUtils.linkForRef('object:StretchItem')}\n is added.\n <P>\n For example, for a stretchImg in \"Over\" state with a <code>src</code> of \"button.png\"\n and a segment name of \"stretch\", the resulting URL would be \"button_Over_stretch.png\".",
        name:"src",
        seeAlso:[
            {
                ref:"attr:StretchImg.hSrc",
                description:null
            },
            {
                ref:"attr:StretchImg.vSrc",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Splitbar",
        groups:[
            "appearance"
        ]
    },
    "group:dataSourceRelations":{
        ref:"group:dataSourceRelations",
        title:"Relations",
        refs:[
            "attr:DataSourceField.primaryKey",
            "attr:DataSourceField.foreignKey",
            "attr:DataSourceField.childrenProperty",
            "attr:DataSourceField.rootValue",
            "attr:DataSourceField.includeFrom",
            "attr:DataSourceField.displayField",
            "attr:DataSourceField.joinType",
            "attr:DataSource.childrenField",
            "type:JoinType"
        ],
        description:"Properties for declaring relations between DataSources and within DataSources, such as\n master-detail relationships (a SalesOrder contains 0 or more OrderItems) and tree\n relationships (records can be linked by a parentId field).",
        name:"dataSourceRelations",
        seeAlso:[
            {
                ref:"attr:DataSourceField.foreignKey",
                description:null
            }
        ],
        type:"group"
    },
    "attr:FormItem.validateOnExit":{
        ref:"attr:FormItem.validateOnExit",
        flags:"IRW",
        description:"If true, form items will be validated when each item's \"editorExit\" handler is fired\n as well as when the entire form is submitted or validated.\n <p>\n Note that this property can also be set at the form level.\n If true at either level the validator will be fired on editorExit.",
        name:"validateOnExit",
        seeAlso:[
            {
                ref:"attr:DynamicForm.validateOnExit",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "classMethod:Log.show":{
        ref:"classMethod:Log.show",
        flags:"",
        description:" Open the Developer Console.\n <P>\n The Developer Console should <b>always</b> be open while developing any ISC-enabled\n application, because ISC logs many important errors and warnings to the Developer Console.\n <P>\n In Internet Explorer, the Developer Console is able to log a stack trace for every JS error,\n including errors that occur in non-ISC code.\n <P>\n NOTE: if you have the Microsoft JavaScript Debugger installed, ISC will be unable to log\n stack traces on JS errors until you go to Tools->Internet Options->Advanced Tab and check\n \"Disable script debugging\".  The ability to see stack traces in the Developer Console is\n generally much more useful for debugging ISC-based applications than the generic Javascript\n Debugging facilities.\n \n",
        name:"show",
        seeAlso:[
        ],
        type:"classMethod",
        definingClass:"class:Log",
        groups:[
            "debug"
        ]
    },
    "attr:SliderItem.changeOnDrag":{
        ref:"attr:SliderItem.changeOnDrag",
        flags:"IRW",
        description:"Should this sliderItem update its value and fire change handlers while the user is\n actively dragging the slider.\n Setting this attribute value to <code>false</code> will suppress any change notifications\n from the user dragging the slider thumb until the user releases the mouse at the final\n position.\n This can be useful to avoid repeatedly firing expensive operations such as server fetches\n while the user drags through a range of values.",
        name:"changeOnDrag",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SliderItem"
    },
    "method:ListGridField.showIf":{
        ref:"method:ListGridField.showIf",
        flags:"",
        description:" An optional ${isc.DocUtils.linkForRef('group:stringMethods','stringMethod')} which if provided, is evaluated to\n conditionally determine whether this field should be displayed.\n Evaluated on initial draw, then reevaluated on explicit\n calls to <code>listGrid.refreshFields()</code> or <code>listGrid.setFields()</code>.\n <P>\n Use <code>${isc.DocUtils.linkForRef('attr:ListGridField.hidden','hidden')}:true</code> or <code>showIf:\"false\"</code>\n to set a ListGrid field to initially hidden.<br>\n The user will still be able to show the field via a context menu.\n This may be suppressed by setting ${isc.DocUtils.linkForRef('attr:ListGridField.canHide')} to false, or by\n setting ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields')} to false to suppress the\n field-picker entirely.\n <P>\n Note that explicit calls to ${isc.DocUtils.linkForRef('method:ListGrid.showField','grid.showField()')} or hideField()\n will wipe out the <code>showIf</code> expression, as will the end user showing and\n hiding columns via the ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderContextMenu','header contextMenu')}.\n <P>\n Also note that fields marked as ${isc.DocUtils.linkForRef('attr:DataSourceField.detail','detail:true')} will be hidden by\n default even if ${isc.DocUtils.linkForRef('attr:ListGrid.showDetailFields')} is <code>true</code>. To show detail fields\n inherited from a DataSource, include an explicit field definition for the field and\n set this property to return <code>true</code>.\n\n",
        name:"showIf",
        seeAlso:[
            {
                ref:"method:ListGrid.refreshFields",
                description:null
            }
        ],
        params:[
            {
                description:"A pointer to the listGrid containing the field",
                optional:false,
                name:"list",
                defaultValue:null,
                type:"ListGrid"
            },
            {
                description:"the ListGridField object",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"ListGridField"
            },
            {
                description:"the index of the field",
                optional:false,
                name:"fieldNum",
                defaultValue:null,
                type:"integer"
            }
        ],
        returns:{
            description:"whether the field should be shown",
            type:"boolean"
        },
        type:"method",
        definingClass:"object:ListGridField",
        groups:[
            "appearance"
        ]
    },
    "attr:HiliteEditor.saveButtonTitle":{
        ref:"attr:HiliteEditor.saveButtonTitle",
        flags:"IR",
        description:"The title text for the ${isc.DocUtils.linkForRef('attr:HiliteEditor.saveButton','saveButton')}.",
        name:"saveButtonTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Save\"",
        type:"attr",
        definingClass:"class:HiliteEditor",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DSRequest.exportData":{
        ref:"attr:DSRequest.exportData",
        flags:"IR",
        description:"Only applies to request properties passed to ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData')}.\n If specified this property contains an arbitrary set of data to be exported.",
        name:"exportData",
        seeAlso:[
        ],
        valueType:"Array of Record",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:ToolStripGroup.titleAlign":{
        ref:"attr:ToolStripGroup.titleAlign",
        flags:"IRW",
        description:"Controls the horizontal alignment of the group-title in its label.  Setting this\n attribute overrides the default specified by \n ${isc.DocUtils.linkForRef('attr:ToolStrip.groupTitleAlign','groupTitleAlign')} on the containing \n ${isc.DocUtils.linkForRef('class:ToolStrip','ToolStrip')}.",
        name:"titleAlign",
        setter:[
            "setTitleAlign"
        ],
        seeAlso:[
        ],
        valueType:"Alignment",
        defaultValue:"\"center\"",
        type:"attr",
        definingClass:"class:ToolStripGroup"
    },
    "attr:Toolbar.canResizeItems":{
        ref:"attr:Toolbar.canResizeItems",
        flags:"IRWA",
        description:"If true, items (buttons) can be resized by dragging on them.",
        name:"canResizeItems",
        setter:[
            "setCanResizeItems"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Toolbar",
        groups:[
            "dragndrop"
        ]
    },
    "method:Canvas.intersects":{
        ref:"method:Canvas.intersects",
        flags:"",
        description:"\t\t\tReturns true if the rectangles of this widget and the specified widget overlap.\n",
        name:"intersects",
        seeAlso:[
        ],
        params:[
            {
                description:"other canvas to test for intersection",
                optional:false,
                name:"other",
                defaultValue:null,
                type:"canvas"
            }
        ],
        returns:{
            description:"true if this canvas intersects other; false otherwise",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ]
    },
    "attr:Gauge.fontSize":{
        ref:"attr:Gauge.fontSize",
        flags:"IR",
        description:"Font size of sector labels. Must be at least 3.",
        name:"fontSize",
        seeAlso:[
            {
                ref:"attr:DrawLabel.fontSize",
                description:null
            }
        ],
        valueType:"int",
        defaultValue:"11",
        type:"attr",
        definingClass:"class:Gauge"
    },
    "attr:Progressbar.vertical":{
        ref:"attr:Progressbar.vertical",
        flags:"IRW",
        description:"Indicates whether this is a vertical or horizontal progressbar.",
        name:"vertical",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Progressbar",
        groups:[
            "appearance"
        ]
    },
    "attr:MultiFileItem.pickerUploadButtonTitle":{
        ref:"attr:MultiFileItem.pickerUploadButtonTitle",
        flags:"IR",
        description:"The title of the upload button in the picker lauched by the\n ${isc.DocUtils.linkForRef('attr:MultiFileItem.editButton','edit button')} that is used after the form is saved.",
        name:"pickerUploadButtonTitle",
        seeAlso:[
            {
                ref:"attr:MultiFileItem.pickerUploadButtonInitialTitle",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"\"Save\"",
        type:"attr",
        definingClass:"class:MultiFileItem",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:TreeGrid.openerImage":{
        ref:"attr:TreeGrid.openerImage",
        flags:"IR",
        description:"The base filename of the opener icon for the folder node when 'showConnectors' is false\n for this TreeGrid.<br>\n The opener icon is displayed beside the folder icon in the Tree column for folder nodes.\n Clicking on this icon will toggle the open state of the folder.<br>\n The filenames for these icons are assembled from this base filename and the state of the\n node, as follows:<br>\n If the openerImage is set to <code>{baseName}.{extension}</code>, \n <code>{baseName}_opened.{extension}</code> will be displayed next to opened folders, and\n <code>{baseName}_closed.{extension}</code> will be displayed next to closed folders, or\n if this page is in RTL mode, <code>{baseName}_opened_rtl.{extension}</code> and\n <code>{baseName}_closed_rtl.{extension}</code> will be used.",
        name:"openerImage",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]opener.gif\"",
        type:"attr",
        definingClass:"class:TreeGrid",
        groups:[
            "treeIcons"
        ]
    },
    "attr:DataSourceField.allowClientRequestedSummaries":{
        ref:"attr:DataSourceField.allowClientRequestedSummaries",
        flags:"IR",
        description:"Affects whether client dsRequests can request summaries for this field.\n <p>\n Default setting of null means that the DataSource-wide default setting\n ${isc.DocUtils.linkForRef('attr:DataSource.allowClientRequestedSummaries')} is used for this field.",
        name:"allowClientRequestedSummaries",
        seeAlso:[
            {
                ref:"attr:DataSource.allowClientRequestedSummaries",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField",
        groups:[
            "serverSummaries"
        ]
    },
    "attr:DataSourceField.initRequiresAuthentication":{
        ref:"attr:DataSourceField.initRequiresAuthentication",
        flags:"IR",
        description:"Whether a user must be authenticated in order to initialize to this field.  If this property is \n set and the user is not authenticated, the SmartClient Server will not allow this field to\n be initialized.",
        name:"initRequiresAuthentication",
        seeAlso:[
            {
                ref:"attr:DataSourceField.editRequiresAuthentication",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField",
        groups:[
            "fieldLevelAuth"
        ],
        requiresModules:[
            "SCServer"
        ]
    },
    "classAttr:Operators.andTitle":{
        ref:"classAttr:Operators.andTitle",
        flags:"IR",
        description:"Title for the \"and\" operator",
        name:"andTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Match All\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "group:hiliting":{
        ref:"group:hiliting",
        title:"Hiliting Overview",
        refs:[
            "method:CubeGrid.hiliteCell",
            "method:CubeGrid.hiliteCellList",
            "method:CubeGrid.hiliteFacetValue",
            "method:DataBoundComponent.getHilites",
            "method:DataBoundComponent.setHilites",
            "method:DataBoundComponent.enableHilite",
            "method:DataBoundComponent.disableHilite",
            "method:DataBoundComponent.enableHiliting",
            "method:DataBoundComponent.disableHiliting",
            "method:DataBoundComponent.editHilites",
            "method:ListGrid.hilitesChanged",
            "object:Hilite",
            "attr:CubeGrid.hilites",
            "attr:Hilite.id",
            "attr:Hilite.cssText",
            "attr:Hilite.fieldName",
            "attr:Hilite.criteria",
            "attr:Hilite.htmlBefore",
            "attr:Hilite.htmlAfter",
            "attr:Hilite.htmlValue",
            "attr:Hilite.disabled",
            "attr:Hilite.title",
            "attr:Hilite.textColor",
            "attr:Hilite.backgroundColor",
            "attr:Hilite.icon",
            "attr:Hilite.replacementValue",
            "attr:DataBoundComponent.canEditHilites",
            "attr:DataBoundComponent.hilites",
            "attr:DataBoundComponent.hiliteIcons",
            "attr:DataBoundComponent.hiliteIconPosition",
            "attr:DataBoundComponent.hiliteIconSize",
            "attr:DataBoundComponent.hiliteIconWidth",
            "attr:DataBoundComponent.hiliteIconHeight",
            "attr:DataBoundComponent.hiliteIconLeftPadding",
            "attr:DataBoundComponent.hiliteIconRightPadding",
            "attr:DataBoundComponent.hiliteEditor",
            "attr:DetailViewer.hiliteIcons",
            "attr:DetailViewer.hiliteIconPosition",
            "attr:DetailViewer.hiliteIconSize",
            "attr:DetailViewer.hiliteIconWidth",
            "attr:DetailViewer.hiliteIconHeight",
            "attr:DetailViewer.hiliteIconLeftPadding",
            "attr:DetailViewer.hiliteIconRightPadding",
            "attr:DetailViewerField.canHilite",
            "attr:DetailViewerField.hiliteIconPosition",
            "attr:DetailViewerField.hiliteIconSize",
            "attr:DetailViewerField.hiliteIconWidth",
            "attr:DetailViewerField.hiliteIconHeight",
            "attr:DetailViewerField.hiliteIconLeftPadding",
            "attr:DetailViewerField.hiliteIconRightPadding",
            "attr:ListGrid.hiliteIcons",
            "attr:ListGrid.hiliteIconPosition",
            "attr:ListGrid.hiliteIconSize",
            "attr:ListGrid.hiliteIconWidth",
            "attr:ListGrid.hiliteIconHeight",
            "attr:ListGrid.hiliteIconLeftPadding",
            "attr:ListGrid.hiliteIconRightPadding",
            "attr:ListGridField.hiliteIconPosition",
            "attr:ListGridField.hiliteIconSize",
            "attr:ListGridField.hiliteIconWidth",
            "attr:ListGridField.hiliteIconHeight",
            "attr:ListGridField.hiliteIconLeftPadding",
            "attr:ListGridField.hiliteIconRightPadding",
            "attr:ListGrid.hiliteCanReplaceValue",
            "attr:ListGrid.canEditHilites",
            "type:HiliteIconPosition"
        ],
        description:"Hiliting means special visual styling which is applied to specific data values that meet\n certain criteria.\n <P>\n A ${isc.DocUtils.linkForRef('object:Hilite')} definition contains styling information such as ${isc.DocUtils.linkForRef('attr:Hilite.cssText')} and\n ${isc.DocUtils.linkForRef('attr:Hilite.htmlBefore')} that define what the hilite looks like, as well as properties\n defining where the hilite is applied.  If you create hilites manually, they should ideally\n specify ${isc.DocUtils.linkForRef('attr:Hilite.textColor','textColor')} and/or \n ${isc.DocUtils.linkForRef('attr:Hilite.backgroundColor','backgroundColor')} in order to be editable in a \n ${isc.DocUtils.linkForRef('class:HiliteEditor')}.  If these are not provided, however, note that they will be \n manufactured automatically from the ${isc.DocUtils.linkForRef('attr:Hilite.cssText','cssText')} attribute if it is present.\n <P>\n A hilite can be applied to data <b>either</b> by defining ${isc.DocUtils.linkForRef('attr:Hilite.criteria','criteria')}\n or by explicitly including markers on the data itself.  \n <P>\n Hiliting rules such as hiliting different ranges of values with different colors can be\n accomplished entirely client-side by defining ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} in hilite definitions\n that pick out values to be highlighted.\n <P>\n Hiliting rules that require server-side calculations can be achieved by assigning a\n ${isc.DocUtils.linkForRef('attr:Hilite.id')} to a hilite definition, and setting the\n ${isc.DocUtils.linkForRef('attr:DataBoundComponent.hiliteProperty')} on the records that should show that highlight.\n This can be used, for example, to hilite the record with the maximum value for a dataset\n that the application will load incrementally.",
        name:"hiliting",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:ImgButton.selected":{
        ref:"attr:ImgButton.selected",
        flags:"IRW",
        description:"Whether this component is selected.  For some components, selection affects appearance.",
        name:"selected",
        setter:[
            "setSelected"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:[
            "state"
        ]
    },
    "attr:ValuesManager.disableValidation":{
        ref:"attr:ValuesManager.disableValidation",
        flags:"IRWA",
        description:"If set to true, client-side validators will not run on the form when validate() is\n called.  Server-side validators (if any) will still run on attempted save.",
        name:"disableValidation",
        seeAlso:[
            {
                ref:"method:DynamicForm.saveData",
                description:null
            },
            {
                ref:"method:DynamicForm.submit",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ValuesManager",
        groups:[
            "validation"
        ]
    },
    "interface:List":{
        methods:[
            "method:List.get",
            "method:List.getLength",
            "method:List.isEmpty",
            "method:List.first",
            "method:List.last",
            "method:List.indexOf",
            "method:List.lastIndexOf",
            "method:List.findIndex",
            "method:List.findNextIndex",
            "method:List.find",
            "method:List.findAll",
            "method:List.contains",
            "method:List.containsAll",
            "method:List.intersect",
            "method:List.equals",
            "method:List.getItems",
            "method:List.getRange",
            "method:List.duplicate",
            "method:List.set",
            "method:List.addAt",
            "method:List.removeAt",
            "method:List.add",
            "method:List.addList",
            "method:List.setLength",
            "method:List.addListAt",
            "method:List.remove",
            "method:List.removeList",
            "method:List.sort",
            "method:List.getProperty",
            "method:List.sortByProperty",
            "method:List.getValueMap",
            "method:List.dataChanged"
        ],
        ref:"interface:List",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/System"
        ],
        attrs:[
        ],
        description:"An interface for an ordered collection of items.\n <P>\n This is the interface that is expected by list-oriented display components such as the\n ListGrid.  The JavaScript native Array object is retrofitted to support the List interface.\n Also, a valid List can be created by mixing the List interface into any class that supports:\n <ul>\n <li> for read-only support: get(position), getLength()\n <li> for modifiable support: set(position), addAt(object, position), removeAt(position)\n </ul>\n <P>\n NOTE: this interface is compatible with the java.util.List interface, except that:\n <ul>\n <li> for removal by index, removeAt() must be called instead of remove().  In Java, remove()\n is an overloaded method that takes either an int or Object, whereas in JavaScript, a\n Number is an Object.\n <li> Iterators don't exist.\n </ul> \n Some methods from the Java List interface have been omitted from the documentation to avoid\n redundancy.",
        name:"List",
        seeAlso:[
        ],
        type:"interface"
    },
    "classMethod:EventHandler.leftButtonDown":{
        ref:"classMethod:EventHandler.leftButtonDown",
        flags:"",
        description:"\t\t\tReturns true if the left mouse button is being pressed.\n\n",
        name:"leftButtonDown",
        seeAlso:[
            {
                ref:"classMethod:EventHandler.middleButtonDown",
                description:null
            },
            {
                ref:"classMethod:EventHandler.rightButtonDown",
                description:null
            }
        ],
        returns:{
            description:"true == left button is down, false == up",
            type:"Boolean"
        },
        type:"classMethod",
        platformNotes:"Mac:\t\tMacintosh platform generally has only one mouse button - ISC considers it to be the \"left\"\n\t\tmouse button, so this method will return true if the mouse is down on a single-button mouse Mac.",
        definingClass:"class:EventHandler",
        groups:[
            "mouseEvents"
        ]
    },
    "method:Canvas.dropOver":{
        ref:"method:Canvas.dropOver",
        flags:"A",
        description:"\n Executed when the compatible dragged object is first moved over this drop target. Your\n implementation can use this to show a custom visual indication that the object can be\n dropped here.\n\n",
        name:"dropOver",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('customDrag')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "attr:DetailViewer.printHeaderStyle":{
        ref:"attr:DetailViewer.printHeaderStyle",
        flags:"IRW",
        description:"Optional CSS style for a header in printable HTML for this component. If unset\n ${isc.DocUtils.linkForRef('attr:DetailViewer.headerStyle')} will be used for printing as well as normal presentation.",
        name:"printHeaderStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "printing"
        ]
    },
    "method:CubeGrid.getEditValues":{
        ref:"method:CubeGrid.getEditValues",
        flags:"",
        description:" Returns the current set of unsaved edits for a given row being edited.\n\n",
        name:"getEditValues",
        seeAlso:[
        ],
        params:[
            {
                description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
                optional:false,
                name:"valuesID",
                defaultValue:null,
                type:"number | Object"
            },
            {
                description:"colNum of the record being edited. Only required if valuesID                         is passed in as a rowNum.",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"Current editValues object for the row.  This contains the current                     edit values in {fieldName1:value1, fieldName2:value2} format.",
            type:"object"
        },
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "editing"
        ]
    },
    "method:Selection.selectRange":{
        ref:"method:Selection.selectRange",
        flags:"",
        description:"\t\t\tSelect range of records from <code>start</code> to <code>end</code>, non-inclusive.\n",
        name:"selectRange",
        seeAlso:[
        ],
        params:[
            {
                description:"start index to select",
                optional:false,
                name:"start",
                defaultValue:null,
                type:"number"
            },
            {
                description:"end index (non-inclusive)",
                optional:false,
                name:"end",
                defaultValue:null,
                type:"number"
            },
            {
                description:"optional new selection state to set.  True means                                      selected, false means unselected.  Defaults to true.",
                optional:true,
                name:"newState",
                defaultValue:null,
                type:"boolean"
            }
        ],
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "classMethod:Page.setAppImgDir":{
        ref:"classMethod:Page.setAppImgDir",
        flags:"",
        description:" Specify the directory for app-specific images.\n <P>\n This becomes the default location where any SmartClient component will load images from\n unless the special \"[SKIN]\" prefix is used to indicate that an image is part of a skin.\n <P>\n Default is \"[APP]images/\"\n\n",
        name:"setAppImgDir",
        seeAlso:[
        ],
        params:[
            {
                description:"New imgDir URL.",
                optional:true,
                name:"URL",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"classMethod",
        definingClass:"class:Page",
        groups:[
            "files",
            "images"
        ]
    },
    "attr:XORGateway.failureElement":{
        ref:"attr:XORGateway.failureElement",
        flags:"IR",
        description:"ID of the next sequence or element to proceed to if the criteria do not match.",
        name:"failureElement",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:XORGateway"
    },
    "method:ListGrid.hasChanges":{
        ref:"method:ListGrid.hasChanges",
        flags:"",
        description:" Whether the grid as a whole has any unsaved edits, in any row. Note that this method will return\n true if any rows are ${isc.DocUtils.linkForRef('method:ListGrid.markRecordRemoved','marked as removed')} in addition to any rows that have\n pending unsaved edits.\n",
        name:"hasChanges",
        seeAlso:[
        ],
        returns:{
            description:"returns true of any unsaved edits are present",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "attr:OperationBinding.invalidateCache":{
        ref:"attr:OperationBinding.invalidateCache",
        flags:"IR",
        description:"If set, every invocation of this operationBinding will invalidate the local cache, forcing\n a server visit to refresh the data.",
        name:"invalidateCache",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:OperationBinding"
    },
    "attr:DataSourceField.summaryValueTitle":{
        ref:"attr:DataSourceField.summaryValueTitle",
        flags:"IR",
        description:"Title to show in a ${isc.DocUtils.linkForRef('type:SummaryFunction','Summary of type \"title\"')} for this field. If unspecified\n <code>title</code> summaries will show the ${isc.DocUtils.linkForRef('attr:DataSourceField.title')} for the field.",
        name:"summaryValueTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DataSourceField"
    },
    "attr:ListGrid.canResizeFields":{
        ref:"attr:ListGrid.canResizeFields",
        flags:"IRW",
        description:"Indicates whether fields in this listGrid can be resized by dragging header\n fields.",
        name:"canResizeFields",
        setter:[
            "setCanResizeFields"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('columnSize')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "dragging"
        ]
    },
    "method:DrawGroup.dragStart":{
        ref:"method:DrawGroup.dragStart",
        flags:"",
        description:" Notification fired when the user starts to drag this DrawGroup. Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')}\n is true for this group.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is true, this notification will be triggered\n by the user interacting with the specified ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')} for the group.\n If ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is false, the notification will bubble up from interactions\n with individual items within the group.\n <P>\n Default drag behavior will be to reposition all items in the group (and update the group\n rectangle).\n",
        name:"dragStart",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to cancel drag action.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragPan')}"
        ],
        definingClass:"class:DrawGroup",
        groups:[
            "widgetEvents"
        ]
    },
    "attr:ColorPicker.greenFieldPrompt":{
        ref:"attr:ColorPicker.greenFieldPrompt",
        flags:"IR",
        description:"The text to show when the mouse hovers over the 'Green' field in the complex chooser.",
        name:"greenFieldPrompt",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"The Green component of the selected color\"",
        type:"attr",
        definingClass:"class:ColorPicker",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DynamicForm.rightTitlePrefix":{
        ref:"attr:DynamicForm.rightTitlePrefix",
        flags:"IRW",
        description:"The string prepended to the title of an item in this form if its\n titleOrientation property is set to \"right\".",
        name:"rightTitlePrefix",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\":&amp;nbsp;\"",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ]
    },
    "method:SectionStack.getVisibleSections":{
        ref:"method:SectionStack.getVisibleSections",
        flags:"",
        description:"\n Returns the list of currently visible sections.  The list items are section names.\n\n",
        name:"getVisibleSections",
        seeAlso:[
        ],
        returns:{
            description:"list of hidden sections",
            type:"List"
        },
        type:"method",
        definingClass:"class:SectionStack"
    },
    "classMethod:EventHandler.getKey":{
        ref:"classMethod:EventHandler.getKey",
        flags:"",
        description:"\t\t\tReturn the name of the key for the event passed in.\n\t\t\tNote that this is only set reliably for keyboard events.\n\n",
        name:"getKey",
        seeAlso:[
        ],
        returns:{
            description:"Key Name",
            type:"KeyName"
        },
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:[
            "keyboardEvents"
        ]
    },
    "method:UserTask.goToPrevious":{
        ref:"method:UserTask.goToPrevious",
        flags:"",
        description:" Set ${isc.DocUtils.linkForRef('attr:UserTask.previousElement')} as next element of workflow. This method could be used to \n create wizard-like UI behavior.  \n",
        name:"goToPrevious",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:UserTask"
    },
    "attr:ListGridField.baseStyle":{
        ref:"attr:ListGridField.baseStyle",
        flags:"IRW",
        description:"Custom base style to apply to all cells in this field instead of ${isc.DocUtils.linkForRef('attr:ListGrid.baseStyle')}\n  To override the baseStyle at the row level, use\n  ${isc.DocUtils.linkForRef('attr:ListGrid.recordBaseStyleProperty','record[listGrid.recordBaseStyleProperty]')}\n  instead.",
        name:"baseStyle",
        seeAlso:[
            {
                ref:"attr:ListGrid.recordBaseStyleProperty",
                description:null
            }
        ],
        valueType:"CSSClass",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('gridCells')}"
        ],
        definingClass:"object:ListGridField",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGrid.wrapHeaderTitles":{
        ref:"attr:ListGrid.wrapHeaderTitles",
        flags:"IR",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGridField.wrap')} is not explicitly set, should fields wrap?",
        name:"wrapHeaderTitles",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:ListGrid.expansionFieldFalseImage":{
        ref:"attr:ListGrid.expansionFieldFalseImage",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} is set to <code>true</code>, this property\n determines the image to display in the expansion field for collapsed rows.\n If unset, the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')} will be used.",
        name:"expansionFieldFalseImage",
        seeAlso:[
            {
                ref:"attr:ListGrid.expansionFieldTrueImage",
                description:null
            },
            {
                ref:"attr:ListGrid.expansionFieldImageWidth",
                description:null
            },
            {
                ref:"attr:ListGrid.expansionFieldImageHeight",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "expansionField"
        ]
    },
    "object:RelativeDate":{
        methods:[
        ],
        ref:"object:RelativeDate",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/System"
        ],
        attrs:[
            "attr:RelativeDate.value",
            "attr:RelativeDate.rangePosition"
        ],
        description:"An object representing a relative date, useful for representing date ranges etc in criteria.\n RelativeDate objects may be created directly by SmartClient components such as the\n ${isc.DocUtils.linkForRef('class:RelativeDateItem')}.\n <P>\n RelativeDate objects will have <code>\"_constructor\"</code> set to <code>\"RelativeDate\"</code>\n and must have a specified ${isc.DocUtils.linkForRef('attr:RelativeDate.value')}. Any other attributes are optional.",
        name:"RelativeDate",
        seeAlso:[
        ],
        type:"object"
    },
    "attr:DetailViewer.canPickFields":{
        ref:"attr:DetailViewer.canPickFields",
        flags:"IR",
        description:"If set, right-clicking on the DetailViewer will show a context menu that offers to bring up a\n ${isc.DocUtils.linkForRef('class:FieldPicker')} for configuring which fields are displayed and their order.",
        name:"canPickFields",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DetailViewer"
    },
    "attr:Canvas.animateAcceleration":{
        ref:"attr:Canvas.animateAcceleration",
        flags:"IRWA",
        description:"Default acceleration effect to apply to all animations on this Canvas.\n Can be overridden by setting animationAcceleration for specific animations or by passing\n an acceleration function directly into the appropriate method.",
        name:"animateAcceleration",
        seeAlso:[
        ],
        valueType:"AnimationAcceleration",
        defaultValue:"\"smoothEnd\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "method:TileGrid.selectRecords":{
        ref:"method:TileGrid.selectRecords",
        flags:"",
        description:"\n Select/deselect a list of ${isc.DocUtils.linkForRef('object:Record')}s passed in explicitly, or by index.\n <P>\n Note that developers may wish to use ${isc.DocUtils.linkForRef('method:TileGrid.selectRange')} to select a single\n contiguous range.\n\n",
        name:"selectRecords",
        seeAlso:[
        ],
        params:[
            {
                description:"records (or row numbers) to select",
                optional:false,
                name:"records",
                defaultValue:null,
                type:"Array of Record | numbers"
            },
            {
                description:"new selection state (if null, defaults to true)",
                optional:true,
                name:"newState",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:[
            "selection"
        ]
    },
    "method:CubeGrid.cellSelectionChanged":{
        ref:"method:CubeGrid.cellSelectionChanged",
        flags:"",
        description:"\n      Handler/Notification function for cell selection change\n      May update header button styles.\n\n      <br><i>methodType</i> handler\n",
        name:"cellSelectionChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"array of cells with new selection state",
                optional:false,
                name:"cellList",
                defaultValue:null,
                type:"Array of cells"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "selection"
        ]
    },
    "attr:ListGridField.imageURLSuffix":{
        ref:"attr:ListGridField.imageURLSuffix",
        flags:"IRWA",
        description:"If any cells in this field are showing a value icon (see: ${isc.DocUtils.linkForRef('attr:ListGridField.valueIcons')})\n or this is has ${isc.DocUtils.linkForRef('type:ListGridFieldType')} set to <code>\"image\"</code>, this the value\n of this property will be appended to the end of the URL for the icon displayed.<br>\n Typical usage might be to append a file type such as <code>\".gif\"</code> to the\n filename of the image.<br>\n For editable fields, this property will also be passed through to any editors as\n ${isc.DocUtils.linkForRef('attr:FormItem.imageURLSuffix')}.",
        name:"imageURLSuffix",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('imageType')}"
        ],
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ]
    },
    "attr:StretchImgButton.labelVPad":{
        ref:"attr:StretchImgButton.labelVPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        name:"labelVPad",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:DrawItem.mouseOver":{
        ref:"method:DrawItem.mouseOver",
        flags:"",
        description:" Notification fired when the mouse enters this DrawItem.\n <p>\n Note that if this item is part of a ${isc.DocUtils.linkForRef('class:DrawGroup')}, then the group's ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')}\n setting affects whether this item receives the notification. If useGroupRect is true, then\n this item will <em>not</em> receive the notification. Otherwise, the item receives the\n notification and notification bubbles up to the group.\n",
        name:"mouseOver",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:DrawItem",
        groups:[
            "widgetEvents"
        ]
    },
    "attr:StretchImgButton.labelLengthPad":{
        ref:"attr:StretchImgButton.labelLengthPad",
        flags:"IRW",
        description:"The padding for a StretchImgButton's label is determined as follows.\n <P>\n If <code>labelHPad</code> is set it will specify the horizontal padding applied to the\n label. Similarly if <code>labelVPad</code> is set it will specify the vertical padding\n for the label, regardless of the button's ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical','vertical')} setting.\n <P>\n Otherwise <code>labelLengthPad</code> can be set to specify the label padding along the\n length axis (ie: horizontal padding if ${isc.DocUtils.linkForRef('attr:StretchImgButton.vertical')} is false,\n otherwise vertical padding), and \n <code>labelBreadthPad</code> can be set to specify the label padding along the other axis.\n <P>\n Otherwise the padding on the length axis will match the ${isc.DocUtils.linkForRef('attr:StretchImgButton.capSize')} and\n will be set to zero on the breadth axis.\n <P>\n So by default the label will be sized to match the center image of the StretchImgButton, but\n these settings allow the label to partially or wholly overlap the caps.",
        name:"labelLengthPad",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImgButton"
    },
    "method:Array.remove":{
        ref:"method:Array.remove",
        flags:"",
        description:" Remove first instance of the passed object from this array, sliding other items around to\n fill gaps.\n\n",
        name:"remove",
        seeAlso:[
        ],
        params:[
            {
                description:"item to remove",
                optional:false,
                name:"obj",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"true if a matching object was found and removed, false if no matching object was found and the list remains unchanged.",
            type:"boolean"
        },
        type:"method",
        definingClass:"object:Array",
        groups:[
            "modification"
        ]
    },
    "method:ImgButton.select":{
        ref:"method:ImgButton.select",
        flags:"",
        description:" Select this object.\n",
        name:"select",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:[
            "state"
        ]
    },
    "attr:FacetChart.valueLineProperties":{
        ref:"attr:FacetChart.valueLineProperties",
        flags:"IR",
        description:"Properties for a \"value line\" - a line shows where a particular discrete value is\n placed, eg, vertical lines connecting points of a line chart to the X axis, or radial\n lines in a Radar chart.",
        name:"valueLineProperties",
        seeAlso:[
        ],
        valueType:"DrawLine Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:Chart.title":{
        ref:"attr:Chart.title",
        flags:"IR",
        description:"Title for the chart as a whole.",
        name:"title",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:Chart"
    },
    "method:PortalLayout.setCanResizePortlets":{
        ref:"method:PortalLayout.setCanResizePortlets",
        flags:"",
        description:" Set whether the height and width of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} should be drag-resizable, and\n update any drawn Portlets to reflect this.\n",
        name:"setCanResizePortlets",
        seeAlso:[
            {
                ref:"attr:PortalLayout.canResizePortlets",
                description:null
            }
        ],
        params:[
            {
                description:"Whether drag-resizing the height and width of portlets is allowed",
                optional:false,
                name:"canResize",
                defaultValue:null,
                type:"Boolean"
            }
        ],
        type:"method",
        definingClass:"class:PortalLayout",
        groups:[
            "sizing"
        ]
    },
    "method:GridRenderer.refreshCellStyle":{
        ref:"method:GridRenderer.refreshCellStyle",
        flags:"",
        description:" Refresh the styling of an individual cell without redrawing the grid.\n <P>\n The cell's CSS class and CSS text will be refreshed, to the current values returned by\n getCellStyle() and getCellCSSText() respectively.\n <P>\n The cell's contents (as returned by getCellValue()) will <b>not</b> be refreshed.  To\n refresh both styling and contents, call refreshCell() instead.\n\n",
        name:"refreshCellStyle",
        seeAlso:[
            {
                ref:"method:GridRenderer.refreshCell",
                description:"to update cell contents too"
            }
        ],
        params:[
            {
                description:"row number of cell to refresh",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of cell to refresh",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "appearance"
        ]
    },
    "attr:TabSet.moreTabPaneProperties":{
        ref:"attr:TabSet.moreTabPaneProperties",
        flags:"IR",
        description:"Properties to apply to the \"more\" tab's pane created by this TabSet.",
        name:"moreTabPaneProperties",
        seeAlso:[
        ],
        valueType:"Canvas Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TabSet"
    },
    "type:RelativeDateString":{
        ref:"type:RelativeDateString",
        description:"A string of known format used to specify a datetime offset.  For example, a \n RelativeDateString that represents \"one year from today\" is written as <code>\"+1y\"</code>.\n <P>\n RelativeDateStrings are comprised of the following parts:\n <ul>\n <li>direction: the direction in which the quantity applies - one of + or - </li>\n <li>quantity: the number of units of time to apply - a number </li>\n <li>timeUnit: an abbreviated timeUnit to use - one of ms/MS (millisecond), s/S (second), \n      mn/MN (minute), h/H (hour), d/D (day), w/W (week), m/M (month), q/Q (quarter, 3-months), \n      y/Y (year), dc/DC (decade) or c/C (century). <br>\n      The timeUnit is case sensitive. A lowercase timeUnit implies an exact offset, so <code>+1d</code>\n      refers to the current date / time increased by exactly 24 hours. If the timeUnit is \n      uppercase, it refers to the start or end boundary of the period of time in question, so\n      <code>+1D</code> would refer to the end of the day (23:39:59:999) tomorrow, and\n      <code>-1D</code> would refer to the start of the day (00:00:00:000) yesterday.</li>\n <li>[qualifier]: an optional timeUnit encapsulated in square-brackets and used to offset \n      the calculation - eg. if +1d is \"plus one day\", +1d[W] is \"plus one day from the \n      end of the current week\".  You may also specify another complete RelativeDateString as the\n      [qualifier], which offers more control - eg, +1d[+1W] indicates \"plus one day from \n      the end of NEXT week\".</li>\n </ul>\n <P>\n This format is very flexible. Here are a few example relative date strings:<br>\n <code>+0D</code>: End of today. There are often multiple ways to represent the same time\n  using this system - for example this could also be written as <code>-1ms[+1D]</code><br>\n <code>-0D</code>: Beginning of today.<br>\n <code>+1W</code>: End of next week.<br>\n <code>+1w[-0W]</code>: Beginning of next week.<br>\n <code>+1w[-0D]</code>: Beginning of the current day of next week.",
        name:"RelativeDateString",
        seeAlso:[
            {
                ref:"type:RelativeDateShortcut",
                description:null
            }
        ],
        type:"type"
    },
    "group:subset":{
        ref:"group:subset",
        refs:[
            "method:Array.getUniqueItems"
        ],
        name:"subset",
        seeAlso:[
        ],
        type:"group"
    },
    "method:SectionStack.addItem":{
        ref:"method:SectionStack.addItem",
        flags:"",
        description:" Add a canvas as an item to a section.\n",
        name:"addItem",
        seeAlso:[
        ],
        params:[
            {
                description:"ID or index of the section to add item to",
                optional:false,
                name:"section",
                defaultValue:null,
                type:"String or Number"
            },
            {
                description:"Item to insert into the section",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"Index into section to insert item",
                optional:false,
                name:"index",
                defaultValue:null,
                type:"Number"
            }
        ],
        type:"method",
        definingClass:"class:SectionStack"
    },
    "attr:FacetChart.gradationZeroLineProperties":{
        ref:"attr:FacetChart.gradationZeroLineProperties",
        flags:"IR",
        description:"Properties for the gradation line drawn for zero (slightly thicker by default).",
        name:"gradationZeroLineProperties",
        seeAlso:[
        ],
        valueType:"DrawLine Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:Calendar.bringEventsToFront":{
        ref:"attr:Calendar.bringEventsToFront",
        flags:"IR",
        description:"If set to true, clicking an event will bring it to the front of the zorder.",
        name:"bringEventsToFront",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "calendarEvent"
        ]
    },
    "attr:Canvas.animateScrollTime":{
        ref:"attr:Canvas.animateScrollTime",
        flags:"IRWA",
        description:"Default time for performing an animated scroll.  If unset, <code>this.animateTime</code>\n will be used by default instead",
        name:"animateScrollTime",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "attr:ListGrid.checkboxFieldTrueImage":{
        ref:"attr:ListGrid.checkboxFieldTrueImage",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.selectionAppearance')} is set to <code>\"checkbox\"</code> this property\n determines the image to display in the checkbox field for a selected row.\n If unset, the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} will be used. Note that the special\n value \"blank\" means that no image will be shown.",
        name:"checkboxFieldTrueImage",
        seeAlso:[
            {
                ref:"attr:ListGrid.checkboxFieldFalseImage",
                description:null
            },
            {
                ref:"attr:ListGrid.checkboxFieldImageWidth",
                description:null
            },
            {
                ref:"attr:ListGrid.checkboxFieldImageHeight",
                description:null
            },
            {
                ref:"attr:ListGrid.printCheckboxFieldTrueImage",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "checkboxField"
        ]
    },
    "group:buttonIcon":{
        ref:"group:buttonIcon",
        title:"Button Icon",
        refs:[
            "method:StatefulCanvas.setIconOrientation",
            "method:StatefulCanvas.setIcon",
            "method:Button.setIconOrientation",
            "method:Button.setIcon",
            "method:Button.iconClick",
            "method:Label.setIconOrientation",
            "method:Label.setIcon",
            "method:ImgButton.setIconOrientation",
            "method:ImgButton.setIcon",
            "method:StretchImgButton.setIconOrientation",
            "method:StretchImgButton.setIcon",
            "method:StretchImgButton.iconClick",
            "method:PanelHeader.iconClick",
            "attr:ListGridField.iconSpacing",
            "attr:ListGridField.showDisabledIcon",
            "attr:ListGridField.showRollOverIcon",
            "attr:ListGridField.showFocusedIcon",
            "attr:ListGridField.showDownIcon",
            "attr:ListGridField.showSelectedIcon",
            "attr:StatefulCanvas.icon",
            "attr:StatefulCanvas.iconSize",
            "attr:StatefulCanvas.iconWidth",
            "attr:StatefulCanvas.iconHeight",
            "attr:StatefulCanvas.iconStyle",
            "attr:StatefulCanvas.iconOrientation",
            "attr:StatefulCanvas.iconSpacing",
            "attr:StatefulCanvas.showDisabledIcon",
            "attr:StatefulCanvas.showRollOverIcon",
            "attr:StatefulCanvas.showDownIcon",
            "attr:StatefulCanvas.showSelectedIcon",
            "attr:StatefulCanvas.showFocusedIcon",
            "attr:Button.icon",
            "attr:Button.iconSize",
            "attr:Button.iconWidth",
            "attr:Button.iconHeight",
            "attr:Button.iconStyle",
            "attr:Button.iconOrientation",
            "attr:Button.iconAlign",
            "attr:Button.iconSpacing",
            "attr:Button.showDisabledIcon",
            "attr:Button.showRollOverIcon",
            "attr:Button.showFocusedIcon",
            "attr:Button.showDownIcon",
            "attr:Button.showSelectedIcon",
            "attr:Label.icon",
            "attr:Label.iconSize",
            "attr:Label.iconWidth",
            "attr:Label.iconHeight",
            "attr:Label.iconOrientation",
            "attr:Label.iconAlign",
            "attr:Label.iconSpacing",
            "attr:Label.showDisabledIcon",
            "attr:Label.showRollOverIcon",
            "attr:Label.showFocusedIcon",
            "attr:Label.showDownIcon",
            "attr:Label.showSelectedIcon",
            "attr:ImgButton.icon",
            "attr:ImgButton.iconSize",
            "attr:ImgButton.iconWidth",
            "attr:ImgButton.iconHeight",
            "attr:ImgButton.iconOrientation",
            "attr:ImgButton.iconAlign",
            "attr:ImgButton.iconSpacing",
            "attr:ImgButton.showDisabledIcon",
            "attr:ImgButton.showRollOverIcon",
            "attr:ImgButton.showFocusedIcon",
            "attr:ImgButton.showDownIcon",
            "attr:ImgButton.showSelectedIcon",
            "attr:StretchImgButton.icon",
            "attr:StretchImgButton.iconSize",
            "attr:StretchImgButton.iconWidth",
            "attr:StretchImgButton.iconHeight",
            "attr:StretchImgButton.iconOrientation",
            "attr:StretchImgButton.iconAlign",
            "attr:StretchImgButton.iconSpacing",
            "attr:StretchImgButton.showDisabledIcon",
            "attr:StretchImgButton.showRollOverIcon",
            "attr:StretchImgButton.showFocusedIcon",
            "attr:StretchImgButton.showDownIcon",
            "attr:StretchImgButton.showSelectedIcon",
            "attr:ImgSectionHeader.icon",
            "attr:ImgSectionHeader.iconAlign",
            "attr:ImgSectionHeader.iconSize",
            "attr:ImgSectionHeader.iconHeight",
            "attr:ImgSectionHeader.iconWidth",
            "attr:ImgSectionHeader.iconOrientation"
        ],
        description:"Control over optional icons shown in Buttons, Labels and other contexts",
        name:"buttonIcon",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:Tree.nameProperty":{
        ref:"attr:Tree.nameProperty",
        flags:"IRW",
        description:"Name of the property on a ${isc.DocUtils.linkForRef('object:TreeNode')} that holds a name for the node that is unique\n among its immediate siblings, thus allowing a unique path to be used to identify the node,\n similar to a file system.  Default value is \"name\".  See ${isc.DocUtils.linkForRef('attr:TreeNode.name')} for usage.",
        name:"nameProperty",
        seeAlso:[
            {
                ref:"attr:TreeNode.name",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"\"name\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('nodeTitles')}"
        ],
        definingClass:"class:Tree"
    },
    "attr:LinearGradient.x2":{
        ref:"attr:LinearGradient.x2",
        flags:"IR",
        description:"X coordinate of the end point. This can be a number or a percentage of the width of the\n bounding box of the DrawItem to which it is applied.",
        name:"x2",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:LinearGradient"
    },
    "attr:Validator.serverOnly":{
        ref:"attr:Validator.serverOnly",
        flags:"IR",
        description:"Indicates this validator runs on the server only.",
        name:"serverOnly",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:Validator"
    },
    "attr:LinearGradient.x1":{
        ref:"attr:LinearGradient.x1",
        flags:"IR",
        description:"X coordinate of the start point. This can be a number or a percentage of the width of the\n bounding box of the DrawItem to which it is applied.",
        name:"x1",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:LinearGradient"
    },
    "attr:ListGrid.canFocusInEmptyGrid":{
        ref:"attr:ListGrid.canFocusInEmptyGrid",
        flags:"IRA",
        description:"If the listGrid is empty, should the user be able to put focus into the grid body by tabbing\n to it?\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:ListGrid.editOnFocus')} is true for this grid and ${isc.DocUtils.linkForRef('attr:ListGrid.listEndEditAction')} is set to next,\n having this property set to true will allow users to automatically create a new edit row by\n simply tabbing into the grid.",
        name:"canFocusInEmptyGrid",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "classMethod:Log.setLogPriority":{
        ref:"classMethod:Log.setLogPriority",
        flags:"",
        description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.setLogPriority')} is to call the method\n directly on the Log class.\n",
        name:"setLogPriority",
        seeAlso:[
            {
                ref:"classMethod:Log.setPriority",
                description:null
            }
        ],
        params:[
            {
                description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
                optional:false,
                name:"category",
                defaultValue:null,
                type:"string"
            },
            {
                description:"priority level",
                optional:false,
                name:"priority",
                defaultValue:null,
                type:"LogPriority"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:ListGrid.selectionChanged":{
        ref:"method:ListGrid.selectionChanged",
        flags:"",
        description:" Called when (row-based) selection changes within this grid. Note this method fires for\n each record for which selection is modified - so when a user clicks inside a grid this\n method will typically fire twice (once for the old record being deselected, and once for\n the new record being selected).\n <P>\n NOTE: For updating other components based on selections or triggering selection-oriented\n events within an application, see the\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.selectionUpdated','selectionUpdated()')} event\n which is likely more suitable.  Calls to ${isc.DocUtils.linkForRef('method:ListGrid.getSelection','getSelection()')}\n from within this event may not return a valid set of selected records if the event has\n been triggered by a call to ${isc.DocUtils.linkForRef('method:DataBoundComponent.selectAllRecords','selectAllRecords()')}\n or ${isc.DocUtils.linkForRef('method:DataBoundComponent.deselectAllRecords','deselectAllRecords()')} - in this case\n use the ${isc.DocUtils.linkForRef('method:DataBoundComponent.selectionUpdated','selectionUpdated()')} event instead.\n\n",
        name:"selectionChanged",
        seeAlso:[
        ],
        params:[
            {
                description:"record for which selection changed",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"New selection state (true for selected, false for unselected)",
                optional:false,
                name:"state",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('multipleSelect')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "selection"
        ]
    },
    "attr:Canvas.dragRepositionCursor":{
        ref:"attr:Canvas.dragRepositionCursor",
        flags:"IRWA",
        description:"Cursor to switch to if the mouse is over a widget that is drag repositionable.",
        name:"dragRepositionCursor",
        seeAlso:[
        ],
        valueType:"Cursor",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "dragdrop"
        ]
    },
    "group:clientOnlyDataSources":{
        ref:"group:clientOnlyDataSources",
        title:"Client Only DataSources",
        treeLocation:[
            "Client Reference/Data Binding/DataSource"
        ],
        refs:[
            "attr:DataSource.clientOnly"
        ],
        description:"For prototyping purposes, a \"client-only\" DataSource can be created that has no permanent\n storage and never contacts the server, instead using a set of test data to respond to\n requests in the same manner as a server-based DataSource might.\n <P>\n The client-side interface to a client-only DataSource is identical to a server-based\n DataSource, including asynchronous responses, so that a client-only DataSource can be\n replaced by a server-based DataSource without code changes.  The only difference is that\n changes to records belonging to the DataSource persist only until the page is reloaded.\n <p>\n Client-only DataSources allow you to create a complete prototype application in an .html\n file that does not require a server.\n <p>\n <smartclient>\n The <code>clientOnly</code> property is specified to create a client-only DataSource, and\n the <code>testData</code> property should contain the test dataset, as an Array of Objects,\n one per DataSource record.  For example:\n <pre>\n   isc.DataSource.create({\n       ID:\"supplyItem\",\n       fields: ...,\n       clientOnly:true,\n       testData:[\n          {itemName:\"Pencil\", cost:5.50},\n          ...\n       ]\n   });\n </pre>\n If you have existing test data in XML (see the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} for\n expected format),\n you can use the XML->JS translation engine to load it into a client-only DataSource, like so:\n <pre>\n   isc.DataSource.create({\n     ID:\"solutions\",\n     fields: ...,\n     clientOnly : true,\n     testData : \n         &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n Another useful practice is to specify both the clientOnly DataSource and its test data in\n XML, so that the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} can later be used to import the\n DataSource and its test data into a SQL Database.  An idiom for accomplishing this is:\n <pre>\n   &lt;isomorphic:loadDS name=\"solutions\"/&gt;\n   isc.DataSource.getDataSource(\"solutions\").addProperties({\n     clientOnly : true,\n     testData : \n        &lt;isomorphic:XML filename=\"shared/ds/test_data/solutions.data.xml\"/&gt;\n   });\n </pre>\n If you specify your DataSource as <code>clientOnly: true</code>, omit testData\n entirely, and provide either a ${isc.DocUtils.linkForRef('attr:DataSource.dataURL')} or a <code>testFileName</code>, the\n </smartclient>\n <smartgwt>\n The setClientOnly method is specified to create a client-only DataSource. For example:\n <pre>\n  DataSource dataSource = new DataSource();\n  dataSource.setID(\"stockQuotesDS\");\n  DataSourceField idField = new DataSourceField(\"id\", FieldType.INTEGER, \"Id\");\n  ........\n  dataSource.setFields(idField,.....);\n  dataSource.setClientOnly(true);\n </pre>\n If you have existing test data in XML (see the Admin Console for expected format), \n you can load it into a client-only DataSource using setDataURL method, like so:\n <pre>\n  DataSource dataSource = new DataSource();\n  dataSource.setID(\"stockQuotesDS\");\n  dataSource.setRecordXPath(\"/List/stockQuotes\");\n  DataSourceField idField = new DataSourceField(\"id\", FieldType.INTEGER, \"Id\");\n  ........\n  dataSource.setFields(idField,.....);\n  dataSource.setDataURL(\"ds/test_data/stockQuotes.data.xml\");\n  dataSource.setClientOnly(true);\n </pre>\n The\n </smartgwt>\n DataSource will lazily make a one-time fetch against the specified data file the first time\n an operation is called on it.  From then on, the DataSource will work against the local\n cache created from this initial request.  This is a quick way to prototype against some test\n data that may eventually be returned from an arbitrary back-end.\n <P>\n Finally, it is possible to have a DataSource which initially fetches the entire dataset and\n performs all subsequent fetching locally, while still visiting the server to perform all \n other operations.  See ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')}.",
        name:"clientOnlyDataSources",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:ScriptTask.isAsync":{
        ref:"attr:ScriptTask.isAsync",
        flags:"IR",
        description:"Whether the script task is asynchronous.  A synchronous task is expected to return data\n directly from execute() and is considered complete once the execute() method exits.\n <P>\n An asnychronous task is expected to start processing in execute(), and will not be\n considered complete until either ${isc.DocUtils.linkForRef('method:ScriptTask.setOutputData')} or ${isc.DocUtils.linkForRef('method:ScriptTask.setOutputRecord')} is\n called.",
        name:"isAsync",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ScriptTask"
    },
    "method:Canvas.doubleClick":{
        ref:"method:Canvas.doubleClick",
        flags:"A",
        description:"\n Executed when the left mouse button is clicked twice in rapid succession (within\n ${isc.DocUtils.linkForRef('attr:Canvas.doubleClickDelay')} by default) in this object.\n\n",
        name:"doubleClick",
        seeAlso:[
            {
                ref:"attr:Canvas.doubleClickDelay",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "group:sizing":{
        ref:"group:sizing",
        refs:[
            "method:Portlet.setHeight",
            "method:Portlet.setRowHeight",
            "method:PortalLayout.setCanStretchColumnWidths",
            "method:PortalLayout.setCanShrinkColumnWidths",
            "method:PortalLayout.setStretchColumnWidthsProportionally",
            "method:PortalLayout.setPreventUnderflow",
            "method:PortalLayout.setColumnPreventUnderflow",
            "method:PortalLayout.setPreventRowUnderflow",
            "method:PortalLayout.setCanResizeColumns",
            "method:PortalLayout.setCanResizePortlets",
            "method:Canvas.setRect",
            "method:Canvas.getWidth",
            "method:Canvas.setWidth",
            "method:Canvas.getHeight",
            "method:Canvas.setHeight",
            "method:Canvas.getRight",
            "method:Canvas.setRight",
            "method:Canvas.getBottom",
            "method:Canvas.setBottom",
            "method:Canvas.getScrollWidth",
            "method:Canvas.getScrollHeight",
            "method:Canvas.getViewportWidth",
            "method:Canvas.getViewportHeight",
            "method:Canvas.getInnerHeight",
            "method:Canvas.getInnerWidth",
            "method:Canvas.getInnerContentHeight",
            "method:Canvas.getInnerContentWidth",
            "method:Canvas.getVisibleWidth",
            "method:Canvas.getVisibleHeight",
            "method:Canvas.resizeBy",
            "method:Canvas.setPercentSource",
            "method:Canvas.layoutChildren",
            "method:Canvas.resizeTo",
            "method:Canvas.parentResized",
            "method:Canvas.setOverflow",
            "method:Canvas.adjustForContent",
            "method:GridRenderer.getCellPageRect",
            "method:GridRenderer.getColumnLeft",
            "method:GridRenderer.getColumnPageLeft",
            "method:GridRenderer.getColumnWidth",
            "method:ListGrid.getColumnLeft",
            "method:ListGrid.getColumnPageLeft",
            "method:ListGrid.getColumnWidth",
            "method:ListGrid.getCellPageRect",
            "method:ListGrid.getDrawnRowHeight",
            "method:ListGrid.setHeaderHeight",
            "method:FormItem.getRect",
            "method:FormItem.getPageRect",
            "method:FormItem.getVisibleHeight",
            "method:FormItem.getIconHeight",
            "method:FormItem.getWidth",
            "method:FormItem.getVisibleWidth",
            "method:FormItem.getIconWidth",
            "method:FormItem.getLeft",
            "method:FormItem.getTop",
            "classMethod:Page.resizeTo",
            "classMethod:Page.getWidth",
            "classMethod:Page.getHeight",
            "classMethod:Page.getScrollWidth",
            "classMethod:Page.getScrollHeight",
            "classMethod:Page.getScrollLeft",
            "classMethod:Page.getScrollTop",
            "attr:Portlet.rowHeight",
            "attr:PortalLayout.overflow",
            "attr:PortalLayout.columnOverflow",
            "attr:PortalLayout.canStretchColumnWidths",
            "attr:PortalLayout.canShrinkColumnWidths",
            "attr:PortalLayout.stretchColumnWidthsProportionally",
            "attr:PortalLayout.preventUnderflow",
            "attr:PortalLayout.preventColumnUnderflow",
            "attr:PortalLayout.preventRowUnderflow",
            "attr:PortalLayout.canResizeColumns",
            "attr:PortalLayout.canResizePortlets",
            "attr:Canvas.width",
            "attr:Canvas.height",
            "attr:Canvas.defaultWidth",
            "attr:Canvas.defaultHeight",
            "attr:Canvas.minWidth",
            "attr:Canvas.maxWidth",
            "attr:Canvas.minHeight",
            "attr:Canvas.maxHeight",
            "attr:Canvas.overflow",
            "attr:Canvas.percentSource",
            "attr:Canvas.percentBox",
            "attr:Canvas.snapTo",
            "attr:Canvas.snapEdge",
            "attr:Canvas.snapOffsetLeft",
            "attr:Canvas.snapOffsetTop",
            "attr:GridRenderer.fixedColumnWidths",
            "attr:GridRenderer.autoFit",
            "attr:ListGrid.bodyOverflow",
            "attr:ListGrid.headerHeight",
            "attr:Menu.defaultWidth",
            "attr:Menu.cellHeight",
            "attr:TileLayout.tileSize",
            "attr:TileLayout.tileWidth",
            "attr:TileLayout.tileHeight",
            "attr:TileLayout.overflow",
            "attr:StatefulCanvas.autoFit",
            "attr:Button.autoFit",
            "attr:Img.size",
            "attr:Label.wrap",
            "attr:Label.autoFit",
            "attr:ImgButton.autoFit",
            "attr:StretchImgButton.autoFit",
            "attr:ToolStrip.height",
            "type:Overflow"
        ],
        description:"Width and height of an object",
        name:"sizing",
        seeAlso:[
        ],
        type:"group"
    },
    "method:Slider.setLabelHeight":{
        ref:"method:Slider.setLabelHeight",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.labelHeight')} property of the slider\n\n",
        name:"setLabelHeight",
        seeAlso:[
        ],
        params:[
            {
                description:"new label height",
                optional:false,
                name:"newHeight",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "group:labels":{
        ref:"group:labels",
        refs:[
            "attr:DetailViewer.labelPrefix",
            "attr:DetailViewer.labelSuffix",
            "attr:DetailViewer.wrapLabel",
            "attr:DetailViewer.wrapValues"
        ],
        name:"labels",
        seeAlso:[
        ],
        type:"group"
    },
    "method:FormItem.clearValue":{
        ref:"method:FormItem.clearValue",
        flags:"",
        description:" Clear the value for this form item.\n <P>\n Note that if a default value is specified, value will be set to that default value,\n otherwise value will be cleared, (and removed from the containing form's values).\n",
        name:"clearValue",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:FormItem"
    },
    "attr:Canvas.position":{
        ref:"attr:Canvas.position",
        flags:"IRWA",
        description:"Absolute or relative, corresponding to the \"absolute\" (with respect to parent) or\n \"relative\" (with respect to document flow) values for the CSS position attribute.\n <P>\n Setting <code>position:\"relative\"</code> enables SmartClient components to be embedded\n directly into the native HTML flow of a page, causing the component to be rendered\n within an existing DOM structure.\n This attribute should only be set to <code>\"relative\"</code> on a top level component\n (a component with no ${isc.DocUtils.linkForRef('method:Canvas.getParentCanvas')}).\n <P>\n There are 2 ways to embed relatively positioned canvases in the DOM - by default the\n component will be written out inline when it gets ${isc.DocUtils.linkForRef('method:Canvas.draw','drawn()n')}. For example\n to embed a canvas in an HTML table you could use this code:\n <pre>\n &lt;table&gt;\n   &lt;tr&gt;\n     &lt;td&gt;\n       &lt;script&gt;\n         isc.Canvas.create({autoDraw:true, backgroundColor:\"red\", position:\"relative\"});\n       &lt;/script&gt;\n     &lt;td&gt;\n   &lt;/tr&gt;\n &lt;/table&gt;\n </pre>\n Alternatively you can make use of the ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} attribute.\n <P>\n Relative positioning is intended as a short-term integration scenario while incrementally\n upgrading existing applications.\n Note that relative positioning is not used to manage layout within SmartClient components -\n instead the ${isc.DocUtils.linkForRef('class:Layout')} class would typically be used.\n For best consistency and flexibility across browsers, all SmartClient layout managers\n use absolute positioning.\n <P>\n For canvases with a specified ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')}, this attribute defaults to\n <code>\"relative\"</code>. In all other cases the default value will be\n <code>\"absolute\"</code>.",
        name:"position",
        seeAlso:[
        ],
        valueType:"Positioning",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('inlineComponents')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ]
    },
    "attr:TreeGrid.createDefaultTreeField":{
        ref:"attr:TreeGrid.createDefaultTreeField",
        flags:"IR",
        description:"If no fields are specified, create a single field with \n ${isc.DocUtils.linkForRef('attr:TreeGridField.treeField')} set to <code>true</code> to show the tree.\n <P>\n This automatically generated field will display values derived by calling\n ${isc.DocUtils.linkForRef('method:TreeGrid.getNodeTitle')}, and have the column title set to the specified\n ${isc.DocUtils.linkForRef('attr:TreeGrid.treeFieldTitle')}.\n <P>\n Has no effect if fields are explicitly specified.\n <P>\n This is a convenience setting to allow a TreeGrid to be created without specifying a\n field list.  If fields are specified, refer to the documentation on property\n ${isc.DocUtils.linkForRef('attr:TreeGrid.autoAssignTreeField')} for a way to automatically have one of the fields be\n use as the tree field if no fields have ${isc.DocUtils.linkForRef('attr:TreeGridField.treeField')} set.\n <P>\n For databound treeGrids, if there is no explicit fields array specified, developers\n who wish to pick up all fields from the DataSource definition rather than displaying\n this single automatically generated tree field may \n either set this property to false, or set ${isc.DocUtils.linkForRef('attr:TreeGrid.useAllDataSourceFields')}\n to <code>true</code>.",
        name:"createDefaultTreeField",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:TreeGrid"
    },
    "method:DrawItem.resizeTo":{
        ref:"method:DrawItem.resizeTo",
        flags:"",
        description:" Resize to the specified size\n",
        name:"resizeTo",
        seeAlso:[
        ],
        params:[
            {
                description:"new width",
                optional:false,
                name:"width",
                defaultValue:null,
                type:"int"
            },
            {
                description:"new height",
                optional:false,
                name:"height",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DrawItem"
    },
    "attr:FilterClause.criterion":{
        ref:"attr:FilterClause.criterion",
        flags:"IRW",
        getter:[
            "getCriterion"
        ],
        description:"Initial criterion for this FilterClause.\n <P>\n When initialized with a criterion, the clause will be automatically set up for editing\n the supplied criterion.\n <P>\n Note that an empty or partial criterion is allowed, for example, it may specify\n ${isc.DocUtils.linkForRef('attr:Criterion.fieldName')} only and will generate an expression with the operator not chosen.",
        name:"criterion",
        seeAlso:[
        ],
        valueType:"Criteria",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FilterClause"
    },
    "attr:FiscalYear.fiscalYear":{
        ref:"attr:FiscalYear.fiscalYear",
        flags:"IRW",
        description:"The actual fiscal year that this date relates to.\n <P>\n A fiscal year ends when the next one begins. A fiscal year may span the boundary\n between two calendar years in which case the ${isc.DocUtils.linkForRef('attr:FiscalYear.fiscalYear')} value may\n not match the ${isc.DocUtils.linkForRef('attr:FiscalYear.year')} value.\n <P>\n For example fiscalYear 2020 may start in July of 2019 and end in July of 2020. In this\n case the <code>fiscalYear</code> would be set to <code>2020</code> and the\n ${isc.DocUtils.linkForRef('attr:FiscalYear.year')} would be set to <code>2019</code>",
        name:"fiscalYear",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:FiscalYear"
    },
    "attr:FormItem.requiredMessage":{
        ref:"attr:FormItem.requiredMessage",
        flags:"IRW",
        description:"The required message for required field errors.",
        name:"requiredMessage",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "validation"
        ]
    },
    "attr:MultiSortDialog.optionsGrid":{
        ref:"attr:MultiSortDialog.optionsGrid",
        flags:"IR",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:ListGrid')} allowing the user to configure a set of \n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.optionsGridProperties</code> and \n <code>multiSortPanel.optionsGridDefaults</code>.",
        name:"optionsGrid",
        seeAlso:[
        ],
        valueType:"AutoChild ListGrid",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiSortDialog"
    },
    "attr:DataBoundComponent.fieldEditorWindow":{
        ref:"attr:DataBoundComponent.fieldEditorWindow",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('class:Window')} used to edit calculated fields for this component.",
        name:"fieldEditorWindow",
        seeAlso:[
        ],
        valueType:"AutoChild Window",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent"
    },
    "method:MenuButton.setShowMenuBelow":{
        ref:"method:MenuButton.setShowMenuBelow",
        flags:"",
        description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the menubutton.\n",
        name:"setShowMenuBelow",
        seeAlso:[
        ],
        params:[
            {
                description:"True if the menu should be shown below the menubutton.",
                optional:false,
                name:"below",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:MenuButton"
    },
    "attr:DrawItem.lineCap":{
        ref:"attr:DrawItem.lineCap",
        flags:"IRW",
        description:"Style of drawing the endpoints of a line.\n <P>\n Note that for dashed and dotted lines, the lineCap style affects each dash or dot.",
        name:"lineCap",
        setter:[
            "setLineCap"
        ],
        seeAlso:[
        ],
        valueType:"LineCap",
        defaultValue:"\"round\"",
        type:"attr",
        definingClass:"class:DrawItem",
        groups:[
            "line"
        ]
    },
    "attr:FacetChart.probabilityMetric":{
        ref:"attr:FacetChart.probabilityMetric",
        flags:"IR",
        description:"The \"id\" of the metric facet value that assigns a probability to each combination\n of facets and their values.  Each probability must be a non-negative number.\n These probabilities are used by all methods of FacetChart that calculate statistical\n values (e.g. ${isc.DocUtils.linkForRef('method:FacetChart.getMean')} and ${isc.DocUtils.linkForRef('method:FacetChart.getStdDev')}).  The default value of\n this property is null which causes the FacetChart to assign probabilities to the\n data records according to a uniform probability distribution.\n <p>\n Note that the FacetChart handles cases where the sum total of all probabilities\n in the ${isc.DocUtils.linkForRef('attr:FacetChart.data')} is not exactly one by scaling the assigned probabilities.",
        name:"probabilityMetric",
        seeAlso:[
            {
                ref:"method:FacetChart.getMean",
                description:null
            },
            {
                ref:"method:FacetChart.getMedian",
                description:null
            },
            {
                ref:"method:FacetChart.getStdDev",
                description:null
            },
            {
                ref:"method:FacetChart.getVariance",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:MetricSettings.matchGradations":{
        ref:"attr:MetricSettings.matchGradations",
        flags:"IR",
        description:"When this property is set to the metric of another MetricSettings object, the extra\n value axis and chart corresponding to these settings will use the same scale for the\n gradations as the extra value axis and chart of the other MetricSettings object.  The\n value of <code>matchGradations</code> can only be one of the metrics of the metric\n facet whose values will be displayed by the chart.",
        name:"matchGradations",
        seeAlso:[
            {
                ref:"attr:FacetChart.extraAxisMetrics",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:MetricSettings"
    },
    "method:ValuesManager.cancel":{
        ref:"method:ValuesManager.cancel",
        flags:"",
        description:"\n This method exists for clean integration with existing server frameworks that have a 'cancel'\n feature which typically clears session state associated with the form.  When this method is\n called, an RPC is sent to the server with a parameter named\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamName')} with the value\n ${isc.DocUtils.linkForRef('attr:DynamicForm.cancelParamValue')}.<p>\n\n Note that no other form data is sent.  By default the current top-level page is replaced with the\n reply.  If you wish to ignore the server reply instead, call this method like this:\n <pre>\n dynamicFormInstance.cancel({ignoreTimeout: true, target: null});\n </pre>\n",
        name:"cancel",
        seeAlso:[
            {
                ref:"method:DynamicForm.cancelEditing",
                description:null
            }
        ],
        params:[
            {
                description:"additional properties to set on the RPCRequest                                          that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest"
            }
        ],
        type:"method",
        definingClass:"class:ValuesManager",
        groups:[
            "submitting"
        ]
    },
    "method:Label.setIconOrientation":{
        ref:"method:Label.setIconOrientation",
        flags:"",
        description:" Changes the orientation of the icon relative to the text of the button.\n\n",
        name:"setIconOrientation",
        seeAlso:[
        ],
        params:[
            {
                description:"The new orientation of the icon relative to the text of the button.",
                optional:false,
                name:"orientation",
                defaultValue:null,
                type:"\"left\" or \"right\""
            }
        ],
        type:"method",
        definingClass:"class:Label",
        groups:[
            "buttonIcon"
        ]
    },
    "method:CubeGrid.getEditedRecord":{
        ref:"method:CubeGrid.getEditedRecord",
        flags:"",
        description:" Returns the combination of unsaved edits (if any) and original values (if any) for a given\n cell being edited.\n <P>\n The returned value is never null, and can be freely modified.\n\n",
        name:"getEditedRecord",
        seeAlso:[
        ],
        params:[
            {
                description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
                optional:false,
                name:"valuesID",
                defaultValue:null,
                type:"number | Object"
            },
            {
                description:"colNum of the record being edited. Only required if the records                          rowNum is passed in as the first parameter",
                optional:true,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"A copy of the record with unsaved edits included",
            type:"Object"
        },
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "editing"
        ]
    },
    "method:ListGridField.getFieldTitle":{
        ref:"method:ListGridField.getFieldTitle",
        flags:"",
        description:" If your derivation of the field title is more complex than specifying a static string,\n you can specify a getFieldTitle() method on your field to return the title string.\n Otherwise you can use the ${isc.DocUtils.linkForRef('attr:ListGridField.title')} attribute on the field to specify the title.\n <P>\n You can use ${isc.DocUtils.linkForRef('method:ListGrid.setFieldProperties','setFieldProperties()')} to dynamically\n update the title.\n\n",
        name:"getFieldTitle",
        seeAlso:[
            {
                ref:"attr:ListGridField.title",
                description:null
            }
        ],
        params:[
            {
                description:"pointer back to the ListGrid",
                optional:false,
                name:"viewer",
                defaultValue:null,
                type:"ListGrid"
            },
            {
                description:"index of this field in the grid's fields array.",
                optional:false,
                name:"fieldNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"Field title.",
            type:"string"
        },
        type:"method",
        definingClass:"object:ListGridField",
        groups:[
            "appearance"
        ]
    },
    "attr:Splitbar.canCollapseOnTap":{
        ref:"attr:Splitbar.canCollapseOnTap",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:Splitbar.canCollapse','canCollapse')} is <code>true</code>, should a tap result in\n collapsing/uncollapsing the ${isc.DocUtils.linkForRef('attr:Splitbar.target','target')}? By default this is <code>false</code>\n because it can be difficult to tap a thin <code>Splitbar</code>.\n <p>\n If this property is set to <code>true</code>, it is recommended to increase the width/height\n of the <code>Splitbar</code> on touch devices (see, e.g., ${isc.DocUtils.linkForRef('attr:Layout.resizeBarSize')}).",
        name:"canCollapseOnTap",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Splitbar"
    },
    "classMethod:EventHandler.getNativeMouseTarget":{
        ref:"classMethod:EventHandler.getNativeMouseTarget",
        flags:"A",
        description:" Returns the natively reported target (or source) DOM element for the current mouse event.\n <b>NOTE:</b> SmartClient cannot guarantee that the same element will\n be reported in all browser/platform configurations for all event types.\n If you wish to make use of this value, we recommend testing your use case \n in all target browser configurations.\n\n",
        name:"getNativeMouseTarget",
        seeAlso:[
        ],
        returns:{
            description:"native DOM element over which the mouse event occurred",
            type:"HTML Element"
        },
        type:"classMethod",
        definingClass:"class:EventHandler"
    },
    "method:Tree.addList":{
        ref:"method:Tree.addList",
        flags:"",
        description:"\n Add a list of nodes to some parent.\n\n",
        name:"addList",
        seeAlso:[
            {
                ref:"group:sharingNodes",
                description:null
            }
        ],
        params:[
            {
                description:"The list of nodes to add",
                optional:false,
                name:"nodeList",
                defaultValue:null,
                type:"List of TreeNode"
            },
            {
                description:"Parent of the nodes being added.  You can pass                                          in either the ${isc.DocUtils.linkForRef('object:TreeNode')} itself, or a path to\n\t                                        the node (as a String), in which case a\n\t                                        ${isc.DocUtils.linkForRef('method:Tree.find')} is performed to find\n\t                                        the node.",
                optional:false,
                name:"parent",
                defaultValue:null,
                type:"String or TreeNode"
            },
            {
                description:"Position of the new nodes in the children list. If not\t                                specified, the nodes will be added at the end of the list.",
                optional:true,
                name:"position",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"List of added nodes.",
            type:"List"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "attr:CubeGrid.sortedFacetValues":{
        ref:"attr:CubeGrid.sortedFacetValues",
        flags:"IRW",
        description:"${isc.DocUtils.linkForRef('object:FacetValueMap')} of facet values representing a set of facetValues by which the\n cubeGrid data is sorted.",
        name:"sortedFacetValues",
        seeAlso:[
        ],
        valueType:"FacetValueMap",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "method:DynamicForm.setValuesAsCriteria":{
        ref:"method:DynamicForm.setValuesAsCriteria",
        flags:"",
        description:" This method will display the specified criteria in this form for editing. The criteria\n parameter may be a simple ${isc.DocUtils.linkForRef('object:Criterion')} object or an ${isc.DocUtils.linkForRef('object:AdvancedCriteria')} object.\n <P>\n For simple criteria, the specified fieldName will be used to apply criteria to form items,\n as with a standard setValues() call.\n <P>\n For AdvancedCriteria, behavior is as follows:\n <ul>\n <li>If the top level operator doesn't match the ${isc.DocUtils.linkForRef('attr:DynamicForm.operator','operator')} for\n  this form, the entire criteria will be nested in an outer advanced criteria object with\n  the appropriate operator.</li>\n <li>Each criterion within AdvancedCriteria will be applied to a form item if\n  ${isc.DocUtils.linkForRef('attr:FormItem.shouldSaveValue')} is true for the item and \n  ${isc.DocUtils.linkForRef('method:FormItem.canEditCriterion')} returns true for the criterion in question. By default\n  this method checks for a match with both the <code>fieldName</code> and <code>operator</code>\n  of the criterion. The criterion is actually passed to the item for editing via\n  <smartclient>${isc.DocUtils.linkForRef('method:FormItem.setCriterion')}</smartclient>\n  <smartgwt>the <code>FormItemCriterionSetter</code>'s <code>setCriterion()</code> method</smartgwt>.\n  Note that these methods may be overridden for custom\n  handling. Also note that the default <smartclient>${isc.DocUtils.linkForRef('method:CanvasItem.setCriterion')} implementation</smartclient>\n  <smartgwt><code>FormItemCriterionSetter.setCriterion()</code> implementation\n  used by ${isc.DocUtils.linkForRef('class:CanvasItem')}</smartgwt> handles editing nested criteria via embedded dynamicForms.</li>\n <li>Criteria which don't map to any form item will be stored directly on the form and\n  recombined with the edited values from each item when ${isc.DocUtils.linkForRef('method:DynamicForm.getValuesAsCriteria')} is\n  called.</li>\n </ul>\n",
        name:"setValuesAsCriteria",
        seeAlso:[
        ],
        params:[
            {
                description:"criteria to edit.",
                optional:false,
                name:"criteria",
                defaultValue:null,
                type:"Criterion"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "criteriaEditing"
        ]
    },
    "method:DrawPane.removeGradient":{
        ref:"method:DrawPane.removeGradient",
        flags:"",
        description:" Removes gradient for gradientID.\n\n",
        name:"removeGradient",
        seeAlso:[
        ],
        params:[
            {
                description:"ID of gradient to remove",
                optional:false,
                name:"gradientID",
                defaultValue:null,
                type:"identifier"
            }
        ],
        type:"method",
        definingClass:"class:DrawPane"
    },
    "method:TimeItem.getEnteredValue":{
        ref:"method:TimeItem.getEnteredValue",
        flags:"",
        description:" Returns the raw text value typed into this items text field if ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField')} \n is true (otherwise returns the result of this.getValue()).\n",
        name:"getEnteredValue",
        seeAlso:[
        ],
        returns:{
            description:"value the user entered",
            type:"String"
        },
        type:"method",
        definingClass:"class:TimeItem"
    },
    "classMethod:EventHandler.rightButtonDown":{
        ref:"classMethod:EventHandler.rightButtonDown",
        flags:"",
        description:"\t\t\tReturns true if the right mouse button is being pressed.\n\n",
        name:"rightButtonDown",
        seeAlso:[
            {
                ref:"classMethod:EventHandler.leftButtonDown",
                description:null
            },
            {
                ref:"classMethod:EventHandler.middleButtonDown",
                description:null
            }
        ],
        returns:{
            description:"true == right button is down, false == up",
            type:"Boolean"
        },
        type:"classMethod",
        platformNotes:"Mac:\t\tMacintosh platform generally has only one mouse button, and the\n\t\tcontrol key being held down serves the same purpose of the \n\t\tright mouse button on Windows.  This is taken into account automatically.<br>\n      Opera: \n      The Opera browser does not pass right mouse button events to JavaScript code by default\n      (the user must explicitly enable this behavior via a menu item). Therefore we \n      treat <b>Shift+Ctrl+Click</b> as a context click in Opera.",
        definingClass:"class:EventHandler",
        groups:[
            "mouseEvents"
        ]
    },
    "type:MultiAutoChild":{
        ref:"type:MultiAutoChild",
        description:null,
        name:"MultiAutoChild",
        seeAlso:[
            {
                ref:"group:multiAutoChildren",
                description:null
            }
        ],
        type:"type"
    },
    "method:ListGrid.setRowErrors":{
        ref:"method:ListGrid.setRowErrors",
        flags:"",
        description:" Set the validation errors for some row (replacing any pre-existent validation errors)\n",
        name:"setRowErrors",
        seeAlso:[
            {
                ref:"method:ListGrid.getRowErrors",
                description:null
            },
            {
                ref:"method:ListGrid.setFieldError",
                description:null
            }
        ],
        params:[
            {
                description:"row to add validation error for",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"validation errors for the row in the format                          <code>{fieldName:errorMessage, ...}</code> <br>or <br>\n                          <code>{fieldName:[errorMessage1, errorMessage2], ...}</code>",
                optional:false,
                name:"errors",
                defaultValue:null,
                type:"any"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "gridValidation"
        ]
    },
    "attr:ListGrid.valueIconLeftPadding":{
        ref:"attr:ListGrid.valueIconLeftPadding",
        flags:"IRW",
        description:"How much padding should there be on the left of valueIcons by default\n Can be overridden at the field level",
        name:"valueIconLeftPadding",
        seeAlso:[
            {
                ref:"attr:ListGridField.valueIcons",
                description:null
            }
        ],
        valueType:"number",
        defaultValue:"2",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "imageColumns"
        ]
    },
    "attr:Toolbar.buttons":{
        ref:"attr:Toolbar.buttons",
        flags:"IRW",
        description:"An array of button object initializers. See the Button Widget Class for standard\n button properties. The following additional properties can also be specified for\n button sizing and positioning on the toolbar itself:<br><br>\n <ul><li>width--Specifies the width of this button as an absolute number of pixels, a\n named property of the toolbar that specifies an absolute number of pixels, a\n percentage of the remaining space (e.g. '60%'), or \"*\" (default) to allocate an\n equal portion of the remaining space.\n <li>height--Specifies the height of this button.\n <li>extraSpace--Specifies an optional amount of extra space, in pixels, to separate\n this button from the next button in the toolbar.</ul>",
        name:"buttons",
        setter:[
            "setButtons"
        ],
        seeAlso:[
            {
                ref:"method:Toolbar.addButtons",
                description:null
            },
            {
                ref:"method:Toolbar.removeButtons",
                description:null
            },
            {
                ref:"class:Button",
                description:null
            }
        ],
        valueType:"array",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Toolbar"
    },
    "attr:DSRequest.useFlatHeaderFields":{
        ref:"attr:DSRequest.useFlatHeaderFields",
        flags:"IRW",
        description:"Cause the ${isc.DocUtils.linkForRef('attr:DSRequest.useFlatFields','useFlatFields')} XML serialization behavior to be used\n for <b>all</b> soap headers in the request.  See also ${isc.DocUtils.linkForRef('attr:DSRequest.headerData')}.",
        name:"useFlatHeaderFields",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest",
        groups:[
            "flatFields"
        ]
    },
    "attr:FilterBuilder.operatorPickerProperties":{
        ref:"attr:FilterBuilder.operatorPickerProperties",
        flags:"IR",
        description:"Properties to combine with the ${isc.DocUtils.linkForRef('attr:FilterBuilder.operatorPicker')} autoChild FormItem.",
        name:"operatorPickerProperties",
        seeAlso:[
        ],
        valueType:"FormItem Properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "method:Calendar.setChosenDate":{
        ref:"method:Calendar.setChosenDate",
        flags:"",
        description:" Set the current date for which the calendar will display events.\n\n",
        name:"setChosenDate",
        seeAlso:[
        ],
        params:[
            {
                description:"the new date to set as the current date",
                optional:false,
                name:"newDate",
                defaultValue:null,
                type:"Date"
            }
        ],
        type:"method",
        definingClass:"class:Calendar"
    },
    "method:Calendar.getWorkdayStart":{
        ref:"method:Calendar.getWorkdayStart",
        flags:"",
        description:" Returns the start of the working day on the passed date.  By default, this method returns\n the value of ${isc.DocUtils.linkForRef('attr:Calendar.workdayStart','workdayStart')}.\n",
        name:"getWorkdayStart",
        seeAlso:[
        ],
        params:[
            {
                description:"a Date instance",
                optional:false,
                name:"date",
                defaultValue:null,
                type:"Date"
            },
            {
                description:"(String) the name of the relevant lane - only passed for dayView with                             showDayLanes: true",
                optional:false,
                name:"",
                defaultValue:null,
                type:"laneName"
            }
        ],
        returns:{
            description:"any parsable time-string",
            type:"String"
        },
        type:"method",
        definingClass:"class:Calendar"
    },
    "attr:Canvas.className":{
        deprecated:"In favor or ${isc.DocUtils.linkForRef('attr:Canvas.styleName')} as of SmartClient release 5.5",
        flags:"IRW",
        type:"attr",
        ref:"attr:Canvas.className",
        description:"The CSS class applied to this widget as a whole.",
        name:"className",
        setter:[
            "setClassName"
        ],
        valueType:"CSSStyleName",
        seeAlso:[
        ],
        defaultValue:"\"normal\"",
        groups:[
            "appearance"
        ],
        definingClass:"class:Canvas"
    },
    "attr:DataSource.resultSetClass":{
        ref:"attr:DataSource.resultSetClass",
        flags:"IRA",
        description:"Class for ResultSets used by this datasource.  If null, defaults to using\n ${isc.DocUtils.linkForRef('class:ResultSet')}.\n <P>\n This can be set to a custom subclass of ResultSet that, for example, hangs onto to extra\n information necessary for integration with web services.",
        name:"resultSetClass",
        seeAlso:[
        ],
        valueType:"Class Object",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:DataSource"
    },
    "attr:FileItem.shouldSaveValue":{
        ref:"attr:FileItem.shouldSaveValue",
        flags:"IR",
        description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",
        name:"shouldSaveValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:FileItem",
        groups:[
            "formValues"
        ]
    },
    "type:NavigationMode":{
        ref:"type:NavigationMode",
        values:[
            {
                description:"Clicking anywhere on the record navigates",
                value:"TableView.WHOLE_RECORD"
            },
            {
                description:"Only clicking directly on the navigation icon                                triggers navigation",
                value:"TableView.NAVICON_ONLY"
            }
        ],
        description:"Controls the navigation mode of records.",
        name:"NavigationMode",
        seeAlso:[
        ],
        type:"type"
    },
    "classAttr:GroupingMessages.upcomingNextMonthTitle":{
        ref:"classAttr:GroupingMessages.upcomingNextMonthTitle",
        flags:"IRW",
        description:"When a ${isc.DocUtils.linkForRef('class:ListGrid')} is grouped by a date field in 'Upcoming' mode, \n this is the group title for all records in which the grouped date field occurs next month,\n relative to the current date.",
        name:"upcomingNextMonthTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Next Month\"",
        type:"classAttr",
        definingClass:"class:GroupingMessages",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:DSRequest.streamResults":{
        ref:"attr:DSRequest.streamResults",
        flags:"IR",
        description:"If true, results will be streamed on the server, rather than all records being read into \n server memory at once; this approach is appropriate for retrieving or exporting large\n datasets without swamping the server.  \n <p>\n Although this property can be set without any particular concerns (small datasets can be \n streamed just as readily as large ones), bear in mind that although streaming enables the\n processing of very large datasets, processing and downloading very large datasets in a \n normal client/server flow will very rarely give an acceptable user experience.  Streaming\n is of more practical use in a batch setting - for example, a disconnected \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','export')}.\n <p>\n Note that streaming requires specific server support; of SmartClient's built-in DataSource\n types, only <code>SQLDataSource</code> is able to stream results.  This property is ignored\n by other DataSource types.\n <p>\n See also the server-side documentation for <code>DSResponse</code>, \n <code>SQLDataSource</code> and <code>StreamingResponseIterator</code>.",
        name:"streamResults",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "method:ValuesManager.editSelectedData":{
        ref:"method:ValuesManager.editSelectedData",
        flags:"",
        description:"\n Edit the record selected in the specified selection component (typically a\n ${isc.DocUtils.linkForRef('class:ListGrid')}).\n <P>\n Updates the values of this editor to match the selected record's values.\n <P>\n If this form has a dataSource, then saving via ${isc.DocUtils.linkForRef('method:ValuesManager.saveData')} will use the \n \"update\" operation type.\n\n",
        name:"editSelectedData",
        seeAlso:[
            {
                ref:"method:DynamicForm.saveData",
                description:null
            }
        ],
        params:[
            {
                description:"the ListGrid or ID of a ${isc.DocUtils.linkForRef('class:ListGrid')} whose currently selected\n     record(s) is/are to be edited",
                optional:false,
                name:"selectionComponent",
                defaultValue:null,
                type:"ListGrid or ID"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('updateOperation')}"
        ],
        definingClass:"class:ValuesManager",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "method:Canvas.containsFocus":{
        ref:"method:Canvas.containsFocus",
        flags:"",
        description:" Returns true if the keyboard focus is in this Canvas or any child of this Canvas.\n",
        name:"containsFocus",
        seeAlso:[
        ],
        returns:{
            description:"whether this Canvas contains the keyboard focus",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "focus"
        ]
    },
    "attr:TextItem.width":{
        ref:"attr:TextItem.width",
        flags:"IRW",
        description:"Default width for fields.",
        name:"width",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"150",
        type:"attr",
        definingClass:"class:TextItem",
        groups:[
            "appearance"
        ]
    },
    "method:Calendar.eventRemoved":{
        ref:"method:Calendar.eventRemoved",
        flags:"",
        description:" Notification fired whenever a user removes an event\n <P>\n In a calendar with a DataSource, eventRemoved() fires <b>after</b> the event has\n been successfully removed from the server\n\n",
        name:"eventRemoved",
        seeAlso:[
        ],
        params:[
            {
                description:"the event that was removed",
                optional:false,
                name:"event",
                defaultValue:null,
                type:"CalendarEvent"
            }
        ],
        type:"method",
        definingClass:"class:Calendar",
        groups:[
            "monthViewEvents"
        ]
    },
    "method:MultiGroupDialog.validate":{
        ref:"method:MultiGroupDialog.validate",
        flags:"",
        description:" Validate that no two ${isc.DocUtils.linkForRef('object:GroupSpecifier')}s group on the same \n ${isc.DocUtils.linkForRef('attr:GroupSpecifier.property','property')}.\n\n",
        name:"validate",
        seeAlso:[
        ],
        returns:{
            description:"True if validation succeeds, false if any property is used twice",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:MultiGroupDialog"
    },
    "classMethod:EventHandler.getY":{
        ref:"classMethod:EventHandler.getY",
        flags:"",
        description:"\t\t\tReturn the page-relative Y (vertical) coordinate of an event.\n\n",
        name:"getY",
        seeAlso:[
        ],
        returns:{
            description:"y-coordinate in page coordinate space",
            type:"int"
        },
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:[
            "mouseEvents"
        ]
    },
    "attr:ListGridField.groupGranularity":{
        ref:"attr:ListGridField.groupGranularity",
        flags:"IR",
        description:"Granularity of grouping for numeric fields.\n <P>\n Groups will be formed based on ranges of values of size <code>groupGranularity</code>.  For\n example, if groupGranularity were 1000, groups would be 0-1000, 1000-2000, etc.",
        name:"groupGranularity",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "grouping"
        ]
    },
    "attr:PresetCriteriaItem.valueMap":{
        ref:"attr:PresetCriteriaItem.valueMap",
        flags:"IR",
        description:"This attribute is not applicable to the PresetCriteriaItem.  See \n ${isc.DocUtils.linkForRef('attr:PresetCriteriaItem.options')} instead.",
        name:"valueMap",
        seeAlso:[
        ],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PresetCriteriaItem"
    },
    "method:MenuItem.click":{
        ref:"method:MenuItem.click",
        flags:"",
        description:" Executed when this menu item is clicked by the user. The click handler must be specified\n as a function or string of script.  Return false to suppress the ${isc.DocUtils.linkForRef('method:Menu.itemClick')}\n handler if specified.\n\n",
        name:"click",
        seeAlso:[
        ],
        params:[
            {
                description:"for a menu shown as a context menu, the Canvas the menu was shown                        on.  Otherwise the ${isc.DocUtils.linkForRef('class:Menu')} instance of which this\n                        ${isc.DocUtils.linkForRef('object:MenuItem')} is a member.",
                optional:false,
                name:"target",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:"The ${isc.DocUtils.linkForRef('object:MenuItem')} that was clicked on.",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"MenuItem"
            },
            {
                description:"The ${isc.DocUtils.linkForRef('class:Menu')} instance of which this ${isc.DocUtils.linkForRef('object:MenuItem')} is a                          member.",
                optional:false,
                name:"menu",
                defaultValue:null,
                type:"Menu"
            },
            {
                description:"Index of the column the user clicked. May be null if the                          user activated the menu via a keyboard event.",
                optional:true,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"object:MenuItem",
        groups:[
            "menuItemEvents"
        ]
    },
    "classMethod:Time.setNormalDisplayFormat":{
        ref:"classMethod:Time.setNormalDisplayFormat",
        flags:"",
        description:" Sets the default format for strings returned by ${isc.DocUtils.linkForRef('classMethod:Time.toTime')}.\n",
        name:"setNormalDisplayFormat",
        seeAlso:[
        ],
        params:[
            {
                description:"Optional custom formatter to use. Will accept  a function (which will be passed a pointer to the date to perform the conversion), or\n  a string designating a standard formatter",
                optional:false,
                name:"formatter",
                defaultValue:null,
                type:"TimeDisplayFormat | function"
            }
        ],
        type:"classMethod",
        definingClass:"class:Time"
    },
    "attr:TimeItem.mask":{
        ref:"attr:TimeItem.mask",
        flags:"IRWA",
        description:"Internal-use only for a TimeItem.",
        name:"mask",
        setter:[
            "setMask"
        ],
        seeAlso:[
            {
                ref:"attr:TimeItem.useMask",
                description:null
            }
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "class:PortalLayout":{
        methods:[
            "method:PortalLayout.setColumnOverflow",
            "method:PortalLayout.setCanStretchColumnWidths",
            "method:PortalLayout.setCanShrinkColumnWidths",
            "method:PortalLayout.setStretchColumnWidthsProportionally",
            "method:PortalLayout.setPreventUnderflow",
            "method:PortalLayout.setColumnPreventUnderflow",
            "method:PortalLayout.setPreventRowUnderflow",
            "method:PortalLayout.getNumColumns",
            "method:PortalLayout.setShowColumnMenus",
            "method:PortalLayout.setColumnBorder",
            "method:PortalLayout.setCanResizeColumns",
            "method:PortalLayout.setCanResizeRows",
            "method:PortalLayout.setCanResizePortlets",
            "method:PortalLayout.setPortletDropTypes",
            "method:PortalLayout.willAcceptPortletDrop",
            "method:PortalLayout.getDropPortlet",
            "method:PortalLayout.addColumn",
            "method:PortalLayout.removeColumn",
            "method:PortalLayout.getPortlets",
            "method:PortalLayout.getPortletArray",
            "method:PortalLayout.getPortalPosition",
            "method:PortalLayout.addPortlet",
            "method:PortalLayout.setColumnWidth",
            "method:PortalLayout.getColumnWidth",
            "method:PortalLayout.removePortlet",
            "method:PortalLayout.willMaximizePortlet",
            "method:PortalLayout.portletMaximized",
            "method:PortalLayout.willMinimizePortlet",
            "method:PortalLayout.portletMinimized",
            "method:PortalLayout.willRestorePortlet",
            "method:PortalLayout.portletRestored",
            "method:PortalLayout.willClosePortlet",
            "method:PortalLayout.portletsChanged",
            "method:PortalLayout.portletsResized"
        ],
        ref:"class:PortalLayout",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout"
        ],
        attrs:[
            "attr:PortalLayout.overflow",
            "attr:PortalLayout.columnOverflow",
            "attr:PortalLayout.canStretchColumnWidths",
            "attr:PortalLayout.canShrinkColumnWidths",
            "attr:PortalLayout.stretchColumnWidthsProportionally",
            "attr:PortalLayout.preventUnderflow",
            "attr:PortalLayout.preventColumnUnderflow",
            "attr:PortalLayout.preventRowUnderflow",
            "attr:PortalLayout.portlets",
            "attr:PortalLayout.numColumns",
            "attr:PortalLayout.showColumnMenus",
            "attr:PortalLayout.columnBorder",
            "attr:PortalLayout.canResizeColumns",
            "attr:PortalLayout.canResizeRows",
            "attr:PortalLayout.canResizePortlets",
            "attr:PortalLayout.portletDropTypes",
            "attr:PortalLayout.dropTypes",
            "attr:PortalLayout.row",
            "attr:PortalLayout.rowLayout",
            "attr:PortalLayout.column"
        ],
        description:"A PortalLayout is a special subclass of Layout designed to display ${isc.DocUtils.linkForRef('class:Portlet')} windows.\n A PortalLayout displays Portlets in columns and supports drag-drop interaction for moving \n Portlets around within the PortalLayout. Portlets may be drag-reordered within columns, dragged\n into other columns, or dragged next to other Portlets to sit next to them horizontally\n within a column.",
        name:"PortalLayout",
        seeAlso:[
        ],
        type:"class"
    },
    "method:StatefulCanvas.setIconOrientation":{
        ref:"method:StatefulCanvas.setIconOrientation",
        flags:"",
        description:" Changes the orientation of the icon relative to the text of the button.\n\n",
        name:"setIconOrientation",
        seeAlso:[
        ],
        params:[
            {
                description:"The new orientation of the icon relative to the text of the button.",
                optional:false,
                name:"orientation",
                defaultValue:null,
                type:"\"left\" or \"right\""
            }
        ],
        type:"method",
        definingClass:"class:StatefulCanvas",
        groups:[
            "buttonIcon"
        ]
    },
    "method:CubeGrid.getFacet":{
        ref:"method:CubeGrid.getFacet",
        flags:"",
        description:" Get a facet definition by facetId.  Constant time.\n\n",
        name:"getFacet",
        seeAlso:[
            {
                ref:"class:Facet",
                description:null
            }
        ],
        params:[
            {
                description:"the id of the facet to retrieve",
                optional:false,
                name:"facetId",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"the Facet if found, or null",
            type:"Facet"
        },
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:TileGrid.dataSource":{
        ref:"attr:TileGrid.dataSource",
        flags:"IRW",
        description:"The DataSource that this component should bind to for default fields and for performing\n ${isc.DocUtils.linkForRef('class:DSRequest','DataSource requests')}.\n <P>\n Can be specified as either a DataSource instance or the String ID of a DataSource.",
        name:"dataSource",
        seeAlso:[
        ],
        valueType:"DataSource or ID",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('dataSourceFields')}"
        ],
        definingClass:"class:TileGrid",
        groups:[
            "databinding"
        ]
    },
    "method:DateItem.setEndDate":{
        ref:"method:DateItem.setEndDate",
        flags:"A",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:DateItem.endDate')}.\n",
        name:"setEndDate",
        seeAlso:[
        ],
        params:[
            {
                description:"the new endDate.",
                optional:false,
                name:"endDate",
                defaultValue:null,
                type:"LogicalDate | String"
            }
        ],
        type:"method",
        definingClass:"class:DateItem"
    },
    "method:List.find":{
        ref:"method:List.find",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.findIndex')}, but returns the object itself instead of its index.\n\n",
        name:"find",
        seeAlso:[
        ],
        params:[
            {
                description:"property to match, or if an Object is passed, set of                                        properties and values to match",
                optional:false,
                name:"propertyName",
                defaultValue:null,
                type:"String or Object or AdvancedCriteria"
            },
            {
                description:"value to compare against (if propertyName is a string)",
                optional:true,
                name:"value",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"first matching object or null if not found",
            type:"Object"
        },
        type:"method",
        definingClass:"interface:List",
        groups:[
            "access",
            "find"
        ]
    },
    "attr:ListGrid.dragTrackerMode":{
        ref:"attr:ListGrid.dragTrackerMode",
        flags:"IRA",
        description:"When records are being dragged from within a ListGrid, what sort of drag-tracker\n should be displayed?<br>\n Note that if multiple records are being dragged the displayed tracker will be\n based on the first selected record.",
        name:"dragTrackerMode",
        seeAlso:[
        ],
        valueType:"DragTrackerMode",
        defaultValue:"\"icon\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "dragTracker"
        ]
    },
    "method:StretchImgButton.setBaseStyle":{
        ref:"method:StretchImgButton.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[
        ],
        params:[
            {
                description:"new base style",
                optional:false,
                name:"style",
                defaultValue:null,
                type:"className"
            }
        ],
        type:"method",
        definingClass:"class:StretchImgButton"
    },
    "method:ColumnTree.setData":{
        ref:"method:ColumnTree.setData",
        flags:"",
        description:" Set the ${isc.DocUtils.linkForRef('class:Tree')} object this ColumnTree will view\n\n",
        name:"setData",
        seeAlso:[
        ],
        params:[
            {
                description:"Tree to show",
                optional:false,
                name:"newData",
                defaultValue:null,
                type:"Tree"
            }
        ],
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:ComboBoxItem.valueField":{
        ref:"attr:ComboBoxItem.valueField",
        flags:"IRW",
        getter:[
            "getValueFieldName"
        ],
        description:"If this form item maps data values to display values by retrieving the \n ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} values from an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}, this property \n denotes the the field to use as the underlying data value in records from the \n optionDataSource.<br>\n If unset, assumed to be the ${isc.DocUtils.linkForRef('attr:FormItem.name')} of this form item.",
        name:"valueField",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem",
        groups:[
            "display_values"
        ]
    },
    "attr:DateChooser.startYear":{
        ref:"attr:DateChooser.startYear",
        flags:"IR",
        description:"Earliest year that may be selected.",
        name:"startYear",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"1995",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:FormulaBuilder.warnDuplicateTitlesMessage":{
        ref:"attr:FormulaBuilder.warnDuplicateTitlesMessage",
        flags:"IRWA",
        description:"The message to display when warnDuplicateTitles is true \n This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed.",
        name:"warnDuplicateTitlesMessage",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Another field already has the title '${fieldTitle}'.  Continue anyway?\"",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "classMethod:isc.clone":{
        ref:"classMethod:isc.clone",
        flags:"",
        description:" Create a deep clone of an object that can be edited without affecting the original\n <P>\n All mutable types, including Objects, Arrays and Dates, are copied.  All immutable types\n (Number, String, etc) are just preserved by reference.\n <P>\n Only JavaScript built-in types may be cloned.  SmartClient UI widgets do not support\n cloning, instead, use ${isc.DocUtils.linkForRef('classMethod:Class.create')} to make a new component with similar\n configuration.\n <P>\n Does not handle looping references (will infinite loop).\n\n",
        name:"clone",
        seeAlso:[
        ],
        params:[
            {
                description:"object to clone",
                optional:false,
                name:"object",
                defaultValue:null,
                type:"object"
            }
        ],
        returns:{
            description:"cloned object",
            type:"object"
        },
        type:"classMethod",
        definingClass:"class:isc",
        groups:[
            "serialization"
        ]
    },
    "attr:DateItem.daySelectorProperties":{
        ref:"attr:DateItem.daySelectorProperties",
        flags:"IRA",
        description:"Custom properties to apply to this dateItem's generated ${isc.DocUtils.linkForRef('attr:DateItem.daySelector')}.",
        name:"daySelectorProperties",
        seeAlso:[
        ],
        valueType:"SelectItem properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "dateItemAppearance"
        ]
    },
    "classMethod:Class.getDefaultLogPriority":{
        ref:"classMethod:Class.getDefaultLogPriority",
        flags:"",
        description:" Retrieves the default priority of messages for this class or instance.\n",
        name:"getDefaultLogPriority",
        seeAlso:[
        ],
        returns:{
            description:"default priority for logging messages on this object.",
            type:"LogPriority"
        },
        type:"classMethod",
        definingClass:"class:Class"
    },
    "attr:Canvas.customEdges":{
        ref:"attr:Canvas.customEdges",
        flags:"IR",
        description:"Array of side names (\"T\", \"B\", \"L\", \"R\") specifying which sides of the decorated\n component should show edges.  For example: <pre>\n      customEdges : [\"T\", \"B\"]\n </pre>\n .. would show edges only on the top and bottom of a component.\n <P>\n The default of <code>null</code> means edges will be shown on all sides.",
        name:"customEdges",
        seeAlso:[
        ],
        valueType:"Array of String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "imageEdges"
        ]
    },
    "attr:FilterBuilder.allowEmpty":{
        ref:"attr:FilterBuilder.allowEmpty",
        flags:"IR",
        description:"If set to false, the last clause cannot be removed.",
        name:"allowEmpty",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "attr:IconButton.align":{
        ref:"attr:IconButton.align",
        flags:"IRW",
        description:"Horizontal alignment of this button's content.  If unset, \n ${isc.DocUtils.linkForRef('attr:IconButton.orientation','vertical buttons')} are center-aligned and horizontal\n buttons left-aligned by default.",
        name:"align",
        seeAlso:[
        ],
        valueType:"Alignment",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:IconButton",
        groups:[
            "appearance"
        ]
    },
    "class:DataSource":{
        methods:[
            "method:DataSource.setCacheAllData",
            "method:DataSource.setCacheData",
            "method:DataSource.setTestData",
            "method:DataSource.invalidateCache",
            "method:DataSource.setClientOnly",
            "method:DataSource.hasAllData",
            "method:DataSource.convertRelativeDates",
            "method:DataSource.updateCaches",
            "method:DataSource.getLegalChildTags",
            "method:DataSource.copyRecord",
            "method:DataSource.copyRecords",
            "method:DataSource.transformRequest",
            "method:DataSource.getUpdatedData",
            "method:DataSource.getDataProtocol",
            "method:DataSource.processResponse",
            "method:DataSource.getXMLRequestBody",
            "method:DataSource.xmlSerialize",
            "method:DataSource.recordsFromXML",
            "method:DataSource.transformResponse",
            "method:DataSource.fetchRecord",
            "method:DataSource.fetchData",
            "method:DataSource.filterData",
            "method:DataSource.exportClientData",
            "method:DataSource.exportData",
            "method:DataSource.getClientOnlyDataSource",
            "method:DataSource.addData",
            "method:DataSource.updateData",
            "method:DataSource.removeData",
            "method:DataSource.validateData",
            "method:DataSource.performCustomOperation",
            "method:DataSource.downloadFile",
            "method:DataSource.viewFile",
            "method:DataSource.getFileURL",
            "method:DataSource.getFetchDataURL",
            "method:DataSource.useOfflineResponse",
            "method:DataSource.handleError",
            "method:DataSource.getField",
            "method:DataSource.getFieldForDataPath",
            "method:DataSource.getDisplayValue",
            "method:DataSource.getFieldNames",
            "method:DataSource.getPrimaryKeyFields",
            "method:DataSource.getPrimaryKeyFieldNames",
            "method:DataSource.getPrimaryKeyField",
            "method:DataSource.getPrimaryKeyFieldName",
            "method:DataSource.getAutoTitle",
            "method:DataSource.getCacheData",
            "method:DataSource.getClientOnlyResponse",
            "method:DataSource.applyFilter",
            "method:DataSource.fieldMatchesFilter",
            "method:DataSource.supportsTextMatchStyle",
            "method:DataSource.compareCriteria",
            "method:DataSource.getFieldCriterion",
            "method:DataSource.compareDates",
            "method:DataSource.recordsAreEqual",
            "method:DataSource.convertDataSourceCriteria",
            "method:DataSource.supportsAdvancedCriteria",
            "method:DataSource.addSearchOperator",
            "method:DataSource.getSearchOperator",
            "method:DataSource.getTypeOperators",
            "method:DataSource.setTypeOperators",
            "method:DataSource.getFieldOperators",
            "method:DataSource.getFieldOperatorMap",
            "method:DataSource.getTypeOperatorMap",
            "method:DataSource.recordsAsText",
            "method:DataSource.recordsFromText",
            "method:DataSource.evaluateCriterion",
            "method:DataSource.splitCriteria"
        ],
        ref:"class:DataSource",
        classAttrs:[
            "classAttr:DataSource.loaderURL",
            "classAttr:DataSource.serializeTimeAsDatetime",
            "classAttr:DataSource.offlineMessage",
            "classAttr:DataSource.maxFileSizeExceededMessage"
        ],
        classMethods:[
            "classMethod:DataSource.getDataSource",
            "classMethod:DataSource.get",
            "classMethod:DataSource.getFieldValue",
            "classMethod:DataSource.load",
            "classMethod:DataSource.loadWithParents",
            "classMethod:DataSource.getSortBy",
            "classMethod:DataSource.getSortSpecifiers",
            "classMethod:DataSource.copyCriteria",
            "classMethod:DataSource.isFlatCriteria",
            "classMethod:DataSource.flattenCriteria",
            "classMethod:DataSource.canFlattenCriteria",
            "classMethod:DataSource.getAdvancedCriteriaDescription",
            "classMethod:DataSource.getLoaderURL",
            "classMethod:DataSource.setLoaderURL",
            "classMethod:DataSource.addSearchOperator",
            "classMethod:DataSource.setTypeOperators",
            "classMethod:DataSource.getAutoTitle",
            "classMethod:DataSource.convertCriteria",
            "classMethod:DataSource.combineCriteria",
            "classMethod:DataSource.applyRecordSummaryFunction",
            "classMethod:DataSource.registerRecordSummaryFunction",
            "classMethod:DataSource.exportClientData",
            "classMethod:DataSource.getSimpleErrors"
        ],
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        attrs:[
            "attr:DataSource.ID",
            "attr:DataSource.addGlobalId",
            "attr:DataSource.dataFormat",
            "attr:DataSource.useStrictJSON",
            "attr:DataSource.dataProtocol",
            "attr:DataSource.useHttpProxy",
            "attr:DataSource.callbackParam",
            "attr:DataSource.requestProperties",
            "attr:DataSource.dataTransport",
            "attr:DataSource.preventHTTPCaching",
            "attr:DataSource.serverType",
            "attr:DataSource.tableName",
            "attr:DataSource.schema",
            "attr:DataSource.quoteTableName",
            "attr:DataSource.dbName",
            "attr:DataSource.configBean",
            "attr:DataSource.quoteColumnNames",
            "attr:DataSource.jsonPrefix",
            "attr:DataSource.jsonSuffix",
            "attr:DataSource.fields",
            "attr:DataSource.inheritsFrom",
            "attr:DataSource.inheritanceMode",
            "attr:DataSource.sequenceMode",
            "attr:DataSource.useFlatFields",
            "attr:DataSource.showLocalFieldsOnly",
            "attr:DataSource.useParentFieldOrder",
            "attr:DataSource.dropExtraFields",
            "attr:DataSource.sendExtraFields",
            "attr:DataSource.autoDeriveSchema",
            "attr:DataSource.schemaBean",
            "attr:DataSource.idClassName",
            "attr:DataSource.patternSingleWildcard",
            "attr:DataSource.patternMultiWildcard",
            "attr:DataSource.patternEscapeChar",
            "attr:DataSource.translatePatternOperators",
            "attr:DataSource.xmlNamespaces",
            "attr:DataSource.serviceNamespace",
            "attr:DataSource.schemaNamespace",
            "attr:DataSource.recordXPath",
            "attr:DataSource.dataURL",
            "attr:DataSource.tagName",
            "attr:DataSource.useOfflineStorage",
            "attr:DataSource.clientOnly",
            "attr:DataSource.criteriaPolicy",
            "attr:DataSource.defaultTextMatchStyle",
            "attr:DataSource.ignoreTextMatchStyleCaseSensitive",
            "attr:DataSource.resultTreeClass",
            "attr:DataSource.resultSetClass",
            "attr:DataSource.useLocalValidators",
            "attr:DataSource.requiredMessage",
            "attr:DataSource.showPrompt",
            "attr:DataSource.enumTranslateStrategy",
            "attr:DataSource.enumConstantProperty",
            "attr:DataSource.enumOrdinalProperty",
            "attr:DataSource.autoDeriveTitles",
            "attr:DataSource.canMultiSort",
            "attr:DataSource.sparseUpdates",
            "attr:DataSource.noNullUpdates",
            "attr:DataSource.omitNullDefaultsOnAdd",
            "attr:DataSource.nullStringValue",
            "attr:DataSource.nullIntegerValue",
            "attr:DataSource.nullFloatValue",
            "attr:DataSource.nullBooleanValue",
            "attr:DataSource.nullDateValue",
            "attr:DataSource.requiresAuthentication",
            "attr:DataSource.requiresRole",
            "attr:DataSource.requires",
            "attr:DataSource.creatorOverrides",
            "attr:DataSource.sqlPaging",
            "attr:DataSource.sqlUsePagingHint",
            "attr:DataSource.useSubselectForRowCount",
            "attr:DataSource.tableCode",
            "attr:DataSource.progressiveLoading",
            "attr:DataSource.progressiveLoadingThreshold",
            "attr:DataSource.lookAhead",
            "attr:DataSource.endGap",
            "attr:DataSource.cacheAllData",
            "attr:DataSource.cacheAllOperationId",
            "attr:DataSource.cacheAcrossOperationIds",
            "attr:DataSource.cacheMaxAge",
            "attr:DataSource.cacheData",
            "attr:DataSource.testData",
            "attr:DataSource.sendParentNode",
            "attr:DataSource.autoCacheAllData",
            "attr:DataSource.useTestDataFetch",
            "attr:DataSource.autoConvertRelativeDates",
            "attr:DataSource.useAnsiJoins",
            "attr:DataSource.trimMilliseconds",
            "attr:DataSource.transformMultipleFields",
            "attr:DataSource.audit",
            "attr:DataSource.auditDataSourceID",
            "attr:DataSource.auditUserFieldName",
            "attr:DataSource.auditTimeStampFieldName",
            "attr:DataSource.auditRevisionFieldName",
            "attr:DataSource.auditTypeFieldName",
            "attr:DataSource.auditDSConstructor",
            "attr:DataSource.autoCreateAuditTable",
            "attr:DataSource.title",
            "attr:DataSource.pluralTitle",
            "attr:DataSource.titleField",
            "attr:DataSource.iconField",
            "attr:DataSource.infoField",
            "attr:DataSource.dataField",
            "attr:DataSource.descriptionField",
            "attr:DataSource.childrenField",
            "attr:DataSource.serverConstructor",
            "attr:DataSource.qualifyColumnNames",
            "attr:DataSource.validateRelatedRecords",
            "attr:DataSource.beanClassName",
            "attr:DataSource.globalNamespaces",
            "attr:DataSource.resultBatchSize",
            "attr:DataSource.serverObject",
            "attr:DataSource.operationBindings",
            "attr:DataSource.allowClientRequestedSummaries",
            "attr:DataSource.dropUnknownCriteria",
            "attr:DataSource.strictSQLFiltering",
            "attr:DataSource.allowAdvancedCriteria"
        ],
        description:"A DataSource is data-provider-independent description of a set of objects\n that will be loaded, edited and saved within the user interface of your application.\n <P>\n Each DataSource consists of a list of ${isc.DocUtils.linkForRef('attr:DataSource.fields','fields')} that make up a\n DataSource <code>record</code>, along with ${isc.DocUtils.linkForRef('attr:DataSourceField.type','field types')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.validators','validation rules')}, \n ${isc.DocUtils.linkForRef('attr:DataSourceField.foreignKey','relationships')} to other DataSources, and other\n metadata.\n <P>\n The abstract object description provided by a DataSource is easily mapped to a variety of\n backend object models and storage schemes.  The following table shows analogous terminology\n across systems.\n <table border=1 class=\"normal\">\n <tr>\n   <td>Isomorphic SmartClient</td>\n   <td>Relational Database</td>\n   <td>Enterprise Java Beans (EJB)</td>\n   <td>Entity/Relationship Modeling</td>\n   <td>OO/UML</td>\n   <td>XML Schema/WSDL</td>\n   <td>LDAP</td>\n </tr><tr>\n   <td>DataSource</td>\n   <td>Table</td>\n   <td>EJB class</td>\n   <td>Entity</td>\n   <td>Class</td>\n   <td>Element Schema (ComplexType)</td>\n   <td>Objectclass</td>\n </tr><tr>\n   <td>Record</td>\n   <td>Row</td>\n   <td>EJB instance</td>\n   <td>Entity instance</td>\n   <td>Class instance/Object</td>\n   <td>Element instance (ComplexType)</td>\n   <td>Entry</td>\n </tr><tr>\n   <td>Field</td>\n   <td>Column</td>\n   <td>Property</td>\n   <td>Attribute</td>\n   <td>Property/Attribute</td>\n   <td>Attribute or Element (SimpleType)</td>\n   <td>Attribute</td>\n </tr></table>\n <P>\n DataSources can be ${isc.DocUtils.linkForRef('group:dataSourceDeclaration','declared')} in either JavaScript or XML\n format, and can also be ${isc.DocUtils.linkForRef('group:metadataImport','imported')} from existing metadata formats,\n including XML Schema.\n <P>\n <i>Data Binding</i> is the process by which\n ${isc.DocUtils.linkForRef('interface:DataBoundComponent','Data Binding-capable UI components')} can automatically configure\n themselves for viewing, editing and saving data described by DataSources.  DataBinding is\n covered in the ${isc.DocUtils.linkForDocNode('QuickStartGuide', 'QuickStart Guide')}, Chapter 6, <i>Data\n Binding</i>.\n <P>\n ${isc.DocUtils.linkForRef('group:clientServerIntegration','Data Integration')} is the process by which a DataSource\n can be connected to server systems such as SQL DataBases, Java Object models, WSDL web\n services and other data providers.  Data Integration comes in two variants: client-side and\n server-side.  ${isc.DocUtils.linkForRef('group:serverDataIntegration','Server-side integration')} uses the\n SmartClient Java-based server to connect to data represented by Java Objects or\n JDBC-accessible databases.  ${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side integration')}\n connects SmartClient DataSources to XML, JSON or other formats accessible via HTTP.\n <P>\n DataSources have a concept of ${isc.DocUtils.linkForRef('group:dataSourceOperations','4 core operations')} (\"fetch\",\n \"add\", \"update\" and \"remove\") that can be performed on the set of objects represented by a\n DataSource.  Once a DataSource has been integrated with your data store, databinding-capable \n UI components can leverage the 4 core DataSource operations to provide many complete user\n interactions without the need to configure how each individual component loads and saves\n data.\n <P>\n These interactions include ${isc.DocUtils.linkForRef('class:ListGrid','grid views')}, ${isc.DocUtils.linkForRef('class:TreeGrid','tree views')}, \n ${isc.DocUtils.linkForRef('class:DetailViewer','detail views')}, ${isc.DocUtils.linkForRef('class:DynamicForm','form')}-based \n ${isc.DocUtils.linkForRef('method:DynamicForm.editRecord','editing')} and ${isc.DocUtils.linkForRef('method:DynamicForm.saveData','saving')},\n grid-based ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','editing')} and ${isc.DocUtils.linkForRef('attr:ListGrid.saveByCell','saving')},\n and custom interactions provided by ${isc.DocUtils.linkForExampleId('patternReuse')} custom\n databinding-capable components.",
        name:"DataSource",
        seeAlso:[
            {
                ref:"interface:DataBoundComponent",
                description:"for information on DataBound Components"
            },
            {
                ref:"group:dataSourceDeclaration",
                description:"for how to create DataSources"
            }
        ],
        type:"class",
        serverDS:"allowed"
    },
    "attr:SummaryBuilder.helpIcon":{
        ref:"attr:SummaryBuilder.helpIcon",
        flags:"IRA",
        description:"Icon that appears after the ${isc.DocUtils.linkForRef('attr:SummaryBuilder.formulaField')}, showing help on hover.",
        name:"helpIcon",
        seeAlso:[
        ],
        valueType:"AutoChild FormItemIcon",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SummaryBuilder",
        groups:[
            "summaryFields"
        ]
    },
    "class:Operators":{
        methods:[
        ],
        ref:"class:Operators",
        classAttrs:[
            "classAttr:Operators.equalsTitle",
            "classAttr:Operators.notEqualTitle",
            "classAttr:Operators.iEqualsTitle",
            "classAttr:Operators.iNotEqualTitle",
            "classAttr:Operators.greaterThanTitle",
            "classAttr:Operators.lessThanTitle",
            "classAttr:Operators.greaterOrEqualTitle",
            "classAttr:Operators.lessOrEqualTitle",
            "classAttr:Operators.betweenTitle",
            "classAttr:Operators.iBetweenTitle",
            "classAttr:Operators.betweenInclusiveTitle",
            "classAttr:Operators.iBetweenInclusiveTitle",
            "classAttr:Operators.iContainsTitle",
            "classAttr:Operators.iStartsWithTitle",
            "classAttr:Operators.iEndsWithTitle",
            "classAttr:Operators.containsTitle",
            "classAttr:Operators.startsWithTitle",
            "classAttr:Operators.endsWithTitle",
            "classAttr:Operators.iNotContainsTitle",
            "classAttr:Operators.iNotStartsWithTitle",
            "classAttr:Operators.iNotEndsWithTitle",
            "classAttr:Operators.notContainsTitle",
            "classAttr:Operators.notStartsWithTitle",
            "classAttr:Operators.notEndsWithTitle",
            "classAttr:Operators.isNullTitle",
            "classAttr:Operators.notNullTitle",
            "classAttr:Operators.regexpTitle",
            "classAttr:Operators.iregexpTitle",
            "classAttr:Operators.matchesPatternTitle",
            "classAttr:Operators.iMatchesPatternTitle",
            "classAttr:Operators.containsPatternTitle",
            "classAttr:Operators.iContainsPatternTitle",
            "classAttr:Operators.inSetTitle",
            "classAttr:Operators.notInSetTitle",
            "classAttr:Operators.equalsFieldTitle",
            "classAttr:Operators.notEqualFieldTitle",
            "classAttr:Operators.iEqualsFieldTitle",
            "classAttr:Operators.iNotEqualFieldTitle",
            "classAttr:Operators.greaterThanFieldTitle",
            "classAttr:Operators.lessThanFieldTitle",
            "classAttr:Operators.greaterOrEqualFieldTitle",
            "classAttr:Operators.lessOrEqualFieldTitle",
            "classAttr:Operators.containsFieldTitle",
            "classAttr:Operators.startsWithFieldTitle",
            "classAttr:Operators.endsWithFieldTitle",
            "classAttr:Operators.iContainsFieldTitle",
            "classAttr:Operators.iStartsWithFieldTitle",
            "classAttr:Operators.iEndsWithFieldTitle",
            "classAttr:Operators.notContainsFieldTitle",
            "classAttr:Operators.notStartsWithFieldTitle",
            "classAttr:Operators.notEndsWithFieldTitle",
            "classAttr:Operators.iNotContainsFieldTitle",
            "classAttr:Operators.iNotStartsWithFieldTitle",
            "classAttr:Operators.iNotEndsWithFieldTitle",
            "classAttr:Operators.andTitle",
            "classAttr:Operators.notTitle",
            "classAttr:Operators.orTitle"
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding/DataSource"
        ],
        attrs:[
        ],
        description:"The Operators class provides a collection of class-level properties that can be used to\n modify the descriptions associated with the logical ${isc.DocUtils.linkForRef('object:Operator')}s used in \n ${isc.DocUtils.linkForRef('object:AdvancedCriteria')}. This is primarily intended for internationalization.\n <p>\n To add or override an operator's description, use\n Operators.${isc.DocUtils.linkForRef('classMethod:Class.addClassProperties','addClassProperties()')}.  For example:\n <p>\n <code>Operators.addClassProperties({lessOrEqualTitle: \"Less than or equal to\"});</code>",
        name:"Operators",
        seeAlso:[
        ],
        type:"class"
    },
    "class:MultiSortPanel":{
        methods:[
            "method:MultiSortPanel.getNumLevels",
            "method:MultiSortPanel.getSortLevel",
            "method:MultiSortPanel.getSort",
            "method:MultiSortPanel.validate",
            "method:MultiSortPanel.sortChanged"
        ],
        ref:"class:MultiSortPanel",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        attrs:[
            "attr:MultiSortPanel.fields",
            "attr:MultiSortPanel.addLevelButtonTitle",
            "attr:MultiSortPanel.deleteLevelButtonTitle",
            "attr:MultiSortPanel.copyLevelButtonTitle",
            "attr:MultiSortPanel.invalidListPrompt",
            "attr:MultiSortPanel.propertyFieldTitle",
            "attr:MultiSortPanel.directionFieldTitle",
            "attr:MultiSortPanel.ascendingTitle",
            "attr:MultiSortPanel.descendingTitle",
            "attr:MultiSortPanel.firstSortLevelTitle",
            "attr:MultiSortPanel.otherSortLevelTitle",
            "attr:MultiSortPanel.addLevelButton",
            "attr:MultiSortPanel.deleteLevelButton",
            "attr:MultiSortPanel.copyLevelButton",
            "attr:MultiSortPanel.levelUpButtonTitle",
            "attr:MultiSortPanel.levelUpButton",
            "attr:MultiSortPanel.levelDownButtonTitle",
            "attr:MultiSortPanel.levelDownButton",
            "attr:MultiSortPanel.optionsGrid",
            "attr:MultiSortPanel.initialSort",
            "attr:MultiSortPanel.maxLevels"
        ],
        description:"A widget that allows the user to set up complex sorting arrangements by defining a group of\n ${isc.DocUtils.linkForRef('object:SortSpecifier')}s.\n <P>\n Each ${isc.DocUtils.linkForRef('object:SortSpecifier')} applies to a single property and direction - so, for instance, in \n a grid with two columns, <code>year</code> and <code>monthNumber</code>, you could sort first \n by <code>year</code> in descending order and then by <code>monthNumber</code> in ascending \n order.  This would producing a grid sorted by year from largest (most \n recent) to smallest (least recent) and, within each year, by monthNumber from smallest \n (January) to largest (December).",
        name:"MultiSortPanel",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:Slider.maxValueLabel":{
        ref:"attr:Slider.maxValueLabel",
        flags:"IRW",
        description:"The text displayed in the label for the maximum value of the slider. If left as null, then\n slider.maxValue will be displayed.",
        name:"maxValueLabel",
        setter:[
            "setMaxValueLabel"
        ],
        seeAlso:[
            {
                ref:"attr:Slider.showRange",
                description:null
            },
            {
                ref:"attr:Slider.maxValue",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Slider"
    },
    "attr:DrawLinePath.endTop":{
        ref:"attr:DrawLinePath.endTop",
        flags:"IR",
        description:"Ending top coordinate of the line.  Overrides top coordinate of ${isc.DocUtils.linkForRef('attr:DrawLinePath.endPoint')} if\n both are set.",
        name:"endTop",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"0 , IRW",
        type:"attr",
        definingClass:"class:DrawLinePath"
    },
    "attr:RestDataSource.dataProtocol":{
        ref:"attr:RestDataSource.dataProtocol",
        flags:"IR",
        description:"Rather than setting ${isc.DocUtils.linkForRef('attr:DataSource.dataProtocol')}, to control the format in which \n inputs are sent to the dataURL, you must specify a replacement ${isc.DocUtils.linkForRef('class:OperationBinding')} \n and specify ${isc.DocUtils.linkForRef('attr:OperationBinding.dataProtocol')} on that <code>operationBinding</code>.\n <P>\n This is because <code>RestDataSource</code> specifies default\n <code>operationBindings</code> for all operationTypes - see\n ${isc.DocUtils.linkForRef('attr:RestDataSource.operationBindings')}.",
        name:"dataProtocol",
        seeAlso:[
        ],
        valueType:"DSProtocol",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"class:RestDataSource",
        groups:[
            "clientDataIntegration",
            "serverDataIntegration"
        ]
    },
    "attr:ComboBoxItem.pickerIconHeight":{
        ref:"attr:ComboBoxItem.pickerIconHeight",
        flags:"IRWA",
        description:"Don't specify an explicit height for the picker icon - instead have it size to match the\n height of the combo box item.",
        name:"pickerIconHeight",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ComboBoxItem"
    },
    "attr:MultiSortDialog.copyLevelButton":{
        ref:"attr:MultiSortDialog.copyLevelButton",
        flags:"RA",
        description:"Automatically generated ${isc.DocUtils.linkForRef('class:IButton')} providing a mechanism for duplicating levels\n in the sort configuration.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>multiSortPanel.copyLevelButtonProperties</code> and \n <code>multiSortPanel.copyLevelButtonDefaults</code>.",
        name:"copyLevelButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:MultiSortDialog"
    },
    "method:ListGrid.setHeaderSpanHeaderTitle":{
        ref:"method:ListGrid.setHeaderSpanHeaderTitle",
        flags:"",
        description:" Update the headerTitle of a ${isc.DocUtils.linkForRef('attr:ListGrid.headerSpans','headerSpan')} dynamically.\n\n",
        name:"setHeaderSpanHeaderTitle",
        seeAlso:[
        ],
        params:[
            {
                description:"name of the headerSpan, as specified via ${isc.DocUtils.linkForRef('attr:HeaderSpan.name')}.",
                optional:false,
                name:"name",
                defaultValue:null,
                type:"String"
            },
            {
                description:"new headerTitle for the headerSpan",
                optional:false,
                name:"newTitle",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "headerSpan"
        ]
    },
    "classMethod:Log.getCallTrace":{
        ref:"classMethod:Log.getCallTrace",
        flags:"",
        description:" Returns a one-line summary of the current method call, showing method name and passed\n arguments. \n This function is available as a static on every ISC Class and as an instance\n method on every instance of an ISC Class.<br>\n General best practice is to call the method as \"this.getCallTrace()\" whenever \"this\" is an\n instance, or call the static classMethod on the ${isc.DocUtils.linkForRef('class:Log')} class otherwise. \n\n",
        name:"getCallTrace",
        seeAlso:[
        ],
        params:[
            {
                description:"arguments object from the call to trace.  On IE, defaults to the                             calling function's arguments",
                optional:true,
                name:"args",
                defaultValue:null,
                type:"Arguments"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log",
        groups:[
            "debug"
        ]
    },
    "attr:Calendar.sizeEventsToGrid":{
        ref:"attr:Calendar.sizeEventsToGrid",
        flags:"IR",
        description:"If true, events will be sized to the grid, even if they start and/or end at times\n between grid cells.",
        name:"sizeEventsToGrid",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Calendar"
    },
    "attr:Gauge.pivotPoint":{
        ref:"attr:Gauge.pivotPoint",
        flags:"R",
        description:"The pivot point of the needle.",
        name:"pivotPoint",
        seeAlso:[
        ],
        valueType:"Point",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Gauge"
    },
    "attr:Process.elements":{
        ref:"attr:Process.elements",
        flags:"IR",
        description:"Elements involved in this Process.  You can also group elements into ${isc.DocUtils.linkForRef('attr:Process.sequences')}\n to reduce the need to explicitly define IDs for elements and interlink them.",
        name:"elements",
        seeAlso:[
        ],
        valueType:"Array of ProcessElement",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Process"
    },
    "method:Canvas.setTop":{
        ref:"method:Canvas.setTop",
        flags:"",
        description:" Set the top coordinate of this object, relative to its enclosing context, in pixels.\n <P>\n NOTE: if you're setting multiple coordinates, use setRect() or moveTo() instead\n\n",
        name:"setTop",
        seeAlso:[
        ],
        params:[
            {
                description:"new top coordinate",
                optional:false,
                name:"top",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ]
    },
    "method:ListGrid.setSort":{
        ref:"method:ListGrid.setSort",
        flags:"A",
        description:" Sort the grid on one or more fields.\n <P>\n Pass in an array of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s to have the grid's data sorted by the fields in\n each ${isc.DocUtils.linkForRef('attr:SortSpecifier.property','specifier.property')} and in the directions specified.  The\n grid can be sorted by any combination of fields, including fields specified in the fields\n array, whether visible or hidden, and ${isc.DocUtils.linkForRef('attr:DataSource.fields','unused fields from the\\n underlying dataSource')}, if there is one.\n <P>\n If multiple fields are sorted, those that are visible show a directional icon and a small\n ${isc.DocUtils.linkForRef('attr:ListGrid.sortNumeralStyle','sort-numeral')}\n indicating that field's index in the sort configuration.\n <P>\n See ${isc.DocUtils.linkForRef('method:ListGrid.addSort','addSort()')} and ${isc.DocUtils.linkForRef('method:ListGrid.toggleSort','toggleSort()')} APIs\n for information on making changes to the current sort configuration.\n\n",
        name:"setSort",
        seeAlso:[
        ],
        params:[
            {
                description:"Array of ${isc.DocUtils.linkForRef('object:SortSpecifier')} objects",
                optional:false,
                name:"sortSpecifiers",
                defaultValue:null,
                type:"Array of SortSpecifier"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:FormItem.stopOnError":{
        ref:"attr:FormItem.stopOnError",
        flags:"IR",
        description:"Indicates that if validation fails, the user should not be allowed to exit\n the field - focus will be forced back into the field until the error is corrected.\n <p>\n This property defaults to ${isc.DocUtils.linkForRef('attr:DynamicForm.stopOnError')} if unset.\n <p>\n Enabling this property also implies ${isc.DocUtils.linkForRef('attr:FormItem.validateOnExit')} is automatically\n enabled. If there are server-based validators on this item, setting this property\n also implies that ${isc.DocUtils.linkForRef('attr:FormItem.synchronousValidation')} is forced on.",
        name:"stopOnError",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "method:DateRangeItem.hasAdvancedCriteria":{
        ref:"method:DateRangeItem.hasAdvancedCriteria",
        flags:"",
        description:" Overridden to return true: dateRangeItems always generate AdvancedCriteria.\n",
        name:"hasAdvancedCriteria",
        seeAlso:[
        ],
        returns:{
            description:"true",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:DateRangeItem",
        groups:[
            "criteriaEditing"
        ]
    },
    "method:DataBoundComponent.disableHilite":{
        ref:"method:DataBoundComponent.disableHilite",
        flags:"",
        description:" Disable a hilite\n\n",
        name:"disableHilite",
        seeAlso:[
        ],
        params:[
            {
                description:"ID of hilite to disable",
                optional:false,
                name:"hiliteID",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "hiliting"
        ]
    },
    "attr:Layout.vertical":{
        ref:"attr:Layout.vertical",
        flags:"IRW",
        description:"Should this layout appear with members stacked vertically or horizontally. Defaults to \n <code>false</code> if unspecified.",
        name:"vertical",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutPolicy"
        ]
    },
    "classMethod:Offline.goOffline":{
        ref:"classMethod:Offline.goOffline",
        flags:"",
        description:" Explicitly sets this session into offline mode.  This setting will override whatever \n state the browser reports.  This allows users to manually set an application into \n offline or online state.\n \n",
        name:"goOffline",
        seeAlso:[
            {
                ref:"classMethod:Offline.goOnline",
                description:null
            },
            {
                ref:"classMethod:Offline.useNativeOfflineDetection",
                description:null
            }
        ],
        type:"classMethod",
        definingClass:"class:Offline"
    },
    "attr:FormulaBuilder.editMode":{
        ref:"attr:FormulaBuilder.editMode",
        flags:"IR",
        description:"Are we editing an existing field?",
        name:"editMode",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:FormulaBuilder",
        groups:[
            "formulaFields"
        ]
    },
    "method:StretchImgButton.setDisabled":{
        ref:"method:StretchImgButton.setDisabled",
        flags:"",
        description:" Enable or disable this object\n",
        name:"setDisabled",
        seeAlso:[
        ],
        params:[
            {
                description:"true if this widget is to be disabled",
                optional:false,
                name:"disabled",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:StretchImgButton",
        groups:[
            "enable",
            "state"
        ]
    },
    "attr:ResultTree.autoPreserveOpenState":{
        ref:"attr:ResultTree.autoPreserveOpenState",
        flags:"IRW",
        description:"Controls what happens to the ${isc.DocUtils.linkForRef('method:ResultTree.getOpenState','\"open state\"')} - the set of \n nodes opened or closed by the end user after tree data is loaded - when an entirely\n new tree of nodes is loaded from the server, as a consequence of calling \n ${isc.DocUtils.linkForRef('method:ResultTree.invalidateCache')} or of changing criteria such that the current cache of\n nodes is dropped.",
        name:"autoPreserveOpenState",
        seeAlso:[
        ],
        valueType:"PreserveOpenState",
        defaultValue:"\"whenUnique\"",
        type:"attr",
        definingClass:"class:ResultTree"
    },
    "method:DataBoundComponent.transferSelectedData":{
        ref:"method:DataBoundComponent.transferSelectedData",
        flags:"",
        description:" Simulates a drag / drop type transfer of the selected records in some other component to this\n component, without requiring any user interaction.  This method acts on the dropped records \n exactly as if they had been dropped in an actual drag / drop interaction, including any \n special databound behavior invoked by calling\n ${isc.DocUtils.linkForRef('method:DataBoundComponent.getDropValues','getDropValues')} for each dropped record.\n <P>\n To transfer <b>all</b> data in, for example, a ${isc.DocUtils.linkForRef('class:ListGrid')}, call grid.selection.selectAll() first.\n <P>\n Note that drag/drop type transfers of records between components are asynchronous operations:\n SmartClient may need to perform server turnarounds to establish whether dropped records \n already exist in the target component.  Therefore, it is possible to issue a call to \n transferSelectedData() and/or the ${isc.DocUtils.linkForRef('method:ListGrid.drop','drop()')} method of a databound \n component whilst a transfer is still active.  When this happens, SmartClient adds the \n second and subsequent transfer requests to a queue and runs them one after the other.  If \n you want to be notified when a transfer process has actually completed, either provide a \n callback to this method or implement ${isc.DocUtils.linkForRef('method:DataBoundComponent.dropComplete')}.\n <P>\n See the ${isc.DocUtils.linkForRef('group:dragging')} documentation for an overview of list grid drag/drop data\n transfer.\n \n",
        name:"transferSelectedData",
        seeAlso:[
        ],
        params:[
            {
                description:"source component from which the records will be transferred",
                optional:false,
                name:"source",
                defaultValue:null,
                type:"DataBoundComponent"
            },
            {
                description:"target index (drop position) of the rows within this grid.",
                optional:true,
                name:"index",
                defaultValue:null,
                type:"integer"
            },
            {
                description:"optional callback to be fired when the transfer process has                        completed.  The callback will be passed a single parameter \"records\",\n                       the list of records actually transferred to this component.",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"Callback"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragListMove')}"
        ],
        definingClass:"interface:DataBoundComponent",
        groups:[
            "dragdrop"
        ]
    },
    "method:ResultSet.findAll":{
        ref:"method:ResultSet.findAll",
        flags:"",
        description:" Like ${isc.DocUtils.linkForRef('method:List.findAll')}.  Checks only loaded rows and will not trigger a fetch.\n",
        name:"findAll",
        seeAlso:[
        ],
        params:[
            {
                description:"property to match, or if an Object is passed, set of                                        properties and values to match",
                optional:false,
                name:"propertyName",
                defaultValue:null,
                type:"String or Object or AdvancedCriteria"
            },
            {
                description:"value to compare against (if propertyName is a string)",
                optional:true,
                name:"value",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"all matching Objects or null if none found",
            type:"Array"
        },
        type:"method",
        definingClass:"class:ResultSet",
        groups:[
            "access",
            "find"
        ]
    },
    "method:Canvas.drop":{
        ref:"method:Canvas.drop",
        flags:"A",
        description:"\n Executed when the mouse button is released over a compatible drop target at the end of\n a drag sequence. Your widget should implement whatever it wants to do when receiving a\n drop here. For example, in a file moving interface, a drop might mean that you should\n move or copy the dragged file into the folder it was dropped on, or dropping something in\n a trash can might mean to clear it from the screen.\n\n",
        name:"drop",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            },
            {
                ref:"classMethod:EventHandler.getDragTarget",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragCreate')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "classMethod:SchemaSet.get":{
        ref:"classMethod:SchemaSet.get",
        flags:"A",
        description:" Retrieve a SchemaSet object by it's schemaNamespace.\n\n",
        name:"get",
        seeAlso:[
        ],
        params:[
            {
                description:"uri from the \"targetNamespace\" attribute of the &lt;xsd:schema&gt; element from the XML Schema or WSDL file this SchemaSet was derived\n from.",
                optional:false,
                name:"schemaNamespace",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"the requested SchemaSet, or null if not loaded",
            type:"SchemaSet"
        },
        type:"classMethod",
        definingClass:"class:SchemaSet"
    },
    "classMethod:Log.setDefaultLogPriority":{
        ref:"classMethod:Log.setDefaultLogPriority",
        flags:"",
        description:" A common usage of ${isc.DocUtils.linkForRef('classMethod:Class.setDefaultLogPriority')} is to call the\n method directly on the Log class.\n",
        name:"setDefaultLogPriority",
        seeAlso:[
            {
                ref:"classMethod:Log.setPriority",
                description:null
            }
        ],
        params:[
            {
                description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
                optional:false,
                name:"category",
                defaultValue:null,
                type:"string"
            },
            {
                description:"priority level",
                optional:false,
                name:"priority",
                defaultValue:null,
                type:"LogPriority"
            }
        ],
        type:"classMethod",
        definingClass:"class:Log"
    },
    "attr:StretchImg.hSrc":{
        ref:"attr:StretchImg.hSrc",
        flags:"IRW",
        description:"Base URL for the image if ${isc.DocUtils.linkForRef('attr:StretchImg.vertical')} is false and \n ${isc.DocUtils.linkForRef('attr:StretchImg.src')} is unset.",
        name:"hSrc",
        seeAlso:[
            {
                ref:"attr:StretchImg.src",
                description:null
            },
            {
                ref:"attr:StretchImg.vSrc",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StretchImg",
        groups:[
            "appearance"
        ]
    },
    "method:DrawLine.setStartPoint":{
        ref:"method:DrawLine.setStartPoint",
        flags:"",
        description:" Update the startPoint\n\n",
        name:"setStartPoint",
        seeAlso:[
        ],
        params:[
            {
                description:"left coordinate for start point, in pixels",
                optional:false,
                name:"left",
                defaultValue:null,
                type:"int"
            },
            {
                description:"top coordinate for start point, in pixels",
                optional:false,
                name:"top",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DrawLine"
    },
    "method:GridRenderer.cellOver":{
        ref:"method:GridRenderer.cellOver",
        flags:"A",
        description:" Called when the mouse pointer enters a cell\n\n",
        name:"cellOver",
        seeAlso:[
        ],
        params:[
            {
                description:"cell record as returned by getCellRecord",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number of the cell",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether to cancel the event",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:GridRenderer",
        groups:[
            "events"
        ]
    },
    "attr:Flashlet.params":{
        ref:"attr:Flashlet.params",
        flags:"IR",
        description:"A map of key/value pairs to pass to the flashlet as parameters.  Note that these will be set\n  on the outer &lt;object&gt; element as well as the inner &lt;embed&gt; element.",
        name:"params",
        seeAlso:[
        ],
        valueType:"object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Flashlet"
    },
    "attr:DateItem.monthSelectorProperties":{
        ref:"attr:DateItem.monthSelectorProperties",
        flags:"IRA",
        description:"Custom properties to apply to this dateItem's generated ${isc.DocUtils.linkForRef('attr:DateItem.monthSelector')}.",
        name:"monthSelectorProperties",
        seeAlso:[
        ],
        valueType:"SelectItem properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateItem",
        groups:[
            "dateItemAppearance"
        ]
    },
    "attr:IconButton.showMenuOnClick":{
        ref:"attr:IconButton.showMenuOnClick",
        flags:"IRW",
        description:"If set to true, shows this button's ${isc.DocUtils.linkForRef('iconButton.menu','menu')} when a user clicks anywhere \n in the button, rather than specifically on the ${isc.DocUtils.linkForRef('iconButton.menuIcon','menuIcon')}.",
        name:"showMenuOnClick",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:IconButton"
    },
    "method:CubeGrid.clearEditValue":{
        ref:"method:CubeGrid.clearEditValue",
        flags:"A",
        description:"\n  Clear a field value being tracked as an unsaved user edit for some cell.<P>\n  The saved record value will be displayed in the the appropriate cell instead.\n\n",
        name:"clearEditValue",
        seeAlso:[
        ],
        params:[
            {
                description:"Row number, primary keys object for the record,                                              or editValues object",
                optional:false,
                name:"editValuesID",
                defaultValue:null,
                type:"number | object"
            },
            {
                description:"Column number for the cell in question. Only required if the                              first parameter is a row number.",
                optional:true,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "editing"
        ]
    },
    "attr:Calendar.showDayHeaders":{
        ref:"attr:Calendar.showDayHeaders",
        flags:"IR",
        description:"If true, the default, show a header cell for each day cell in the \n ${isc.DocUtils.linkForRef('attr:Calendar.monthView','month view')}, with both cells having a minimum combined height of \n ${isc.DocUtils.linkForRef('attr:Calendar.minimumDayHeight')}.  If false, the header cells will not be shown, and the value \n of ${isc.DocUtils.linkForRef('attr:Calendar.minimumDayHeight')} is ignored.  This causes the available vertical space in month\n views to be shared equally between day cells, such that no vertical scrollbar is required\n unless the HTML in the cells renders them taller than will fit.",
        name:"showDayHeaders",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "visibility"
        ]
    },
    "attr:Menu.submenuDisabledImage":{
        ref:"attr:Menu.submenuDisabledImage",
        flags:"IR",
        description:"Default image to use for the submenu indicator when item is disabled. Valid src, width and\n height must be specified. See ${isc.DocUtils.linkForRef('object:ImgProperties')} for format.<br>\n If ${isc.DocUtils.linkForRef('attr:Menu.submenuDirection')} is set to <code>\"left\"</code>, the image src will have\n the suffix <code>\"_left\"</code> appended to it.",
        name:"submenuDisabledImage",
        seeAlso:[
        ],
        valueType:"Img Properties",
        defaultValue:"{...}",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:AdvancedHiliteEditor.cancelEditing":{
        ref:"method:AdvancedHiliteEditor.cancelEditing",
        flags:"",
        description:" Discard changes and fire the ${isc.DocUtils.linkForRef('attr:AdvancedHiliteEditor.callback','callback')} with a null \n parameter.\n\n",
        name:"cancelEditing",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:AdvancedHiliteEditor"
    },
    "attr:DrawItem.canDrag":{
        ref:"attr:DrawItem.canDrag",
        flags:"IRWA",
        description:"Is this DrawItem draggable? If true, then the DrawItem can be drag-repositioned by the user.",
        name:"canDrag",
        setter:[
            "setCanDrag"
        ],
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DrawItem"
    },
    "attr:MultiGroupPanel.groupingFieldTitle":{
        ref:"attr:MultiGroupPanel.groupingFieldTitle",
        flags:"IR",
        description:"The title-text to appear in the header of the \"grouping\" field.",
        name:"groupingFieldTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Grouping\"",
        type:"attr",
        definingClass:"class:MultiGroupPanel",
        groups:[
            "i18nMessages"
        ]
    },
    "method:ListGrid.setViewState":{
        ref:"method:ListGrid.setViewState",
        flags:"",
        description:" Reset this grid's view state to match the ${isc.DocUtils.linkForRef('type:ListGridViewState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to\n ${isc.DocUtils.linkForRef('method:ListGrid.getViewState')}.\n\n",
        name:"setViewState",
        seeAlso:[
            {
                ref:"method:ListGrid.getViewState",
                description:null
            }
        ],
        params:[
            {
                description:"Object describing the desired view state for the grid",
                optional:false,
                name:"viewState",
                defaultValue:null,
                type:"ListGridViewState"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "viewState"
        ]
    },
    "attr:ListGridField.hoverWrap":{
        ref:"attr:ListGridField.hoverWrap",
        flags:"IRW",
        description:"This property may be set to customize the <code>wrap</code> attribute for the\n canvas shown when the mouse hovers over cells in this field. Note that this causes a \n soft-wrap - if set, the hover text will wrap at word boundaries.\n <P>\n If unset, default behavior is derived from ${isc.DocUtils.linkForRef('attr:ListGrid.headerHoverWrap')}.",
        name:"hoverWrap",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "attr:ListGridField.valueIconOrientation":{
        ref:"attr:ListGridField.valueIconOrientation",
        flags:"IRW",
        description:"If we're showing a valueIcon for this field should it appear to the left or the right\n of the text?  By default the icon will appear to the left of the textual value -\n set this to \"right\" to show the icon on the right of the text.\n Has no effect if ${isc.DocUtils.linkForRef('attr:ListGridField.showValueIconOnly')} is true",
        name:"valueIconOrientation",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "imageColumns"
        ]
    },
    "attr:SplitPane.backButton":{
        ref:"attr:SplitPane.backButton",
        flags:"IR",
        description:"The back button shown in the ${isc.DocUtils.linkForRef('attr:SplitPane.navigationBar','navigationBar')} depending on\n the current UI configuration. The back button's ${isc.DocUtils.linkForRef('attr:Button.title','title')} is determined\n by the <code>SplitPane</code>.",
        name:"backButton",
        seeAlso:[
        ],
        valueType:"AutoChild NavigationButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SplitPane"
    },
    "method:ListGrid.viewStateChanged":{
        ref:"method:ListGrid.viewStateChanged",
        flags:"",
        description:" Notification method executed whenever the viewState of this grid changes.\n View state is accessible via ${isc.DocUtils.linkForRef('method:ListGrid.getViewState')}, and contains field state\n information, sort information, selection information, hiliting information and\n grouping information.\n\n",
        name:"viewStateChanged",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:SelectItem.addUnknownValues":{
        ref:"attr:SelectItem.addUnknownValues",
        flags:"IRWA",
        description:"If this item's value is set (via ${isc.DocUtils.linkForRef('method:SelectItem.setValue')} or similar) to a value which\n is not present in the ${isc.DocUtils.linkForRef('type:ValueMap')}, should the value be rejected.\n <P>\n If set to <code>false</code> the setValue() call will have no effect if the value\n is not a valid option.\n <P>\n If set to <code>true</code> the item's value will be update to the new value, and\n the value will be added to the set of options displayed in the pick-list until the\n next call to ${isc.DocUtils.linkForRef('method:SelectItem.setValueMap')} or ${isc.DocUtils.linkForRef('method:SelectItem.setValue')}.\n <P>\n Exception: If the value is set to <code>null</code> but there is no null entry in the\n valueMap for this item, setting <code>addUnknownValues</code> to true will not cause\n a null option to show up at the top of the select item pickList. Whether an empty\n option is shown in the pickList is governed by ${isc.DocUtils.linkForRef('attr:SelectItem.allowEmptyValue')}\n instead.\n <P>\n Note that this property has no effect if the selectItem has a specified\n ${isc.DocUtils.linkForRef('attr:SelectItem.optionDataSource')}. If ${isc.DocUtils.linkForRef('method:SelectItem.setValue')} is called on a databound SelectItem\n and the new value does not match any loaded options, the value will be accepted,\n but not added to the options displayed in the pickList. Also note that if a\n ${isc.DocUtils.linkForRef('attr:SelectItem.displayField')} exists, a fetch will be performed in an attempt to retrieve\n a valid display value, as described under ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')}.  \n If specified the ${isc.DocUtils.linkForRef('attr:FormItem.loadingDisplayValue')} will be displayed while the \n fetch is in progress, and then the real value (mapped to a display field value if\n a matching record was found) will be displayed when the fetch completes.",
        name:"addUnknownValues",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('formDependentSelectsLocal')}"
        ],
        definingClass:"class:SelectItem"
    },
    "attr:OperationBinding.summaryFunctions":{
        ref:"attr:OperationBinding.summaryFunctions",
        flags:"IR",
        description:"A mapping from field names to ${isc.DocUtils.linkForRef('type:SummaryFunction','summary functions')} to be applied\n to each field.\n <p>\n Valid only for an operation of type \"fetch\".  See the \n ${isc.DocUtils.linkForRef('group:serverSummaries','Server Summaries overview')} for examples of usage.",
        name:"summaryFunctions",
        seeAlso:[
            {
                ref:"attr:OperationBinding.groupBy",
                description:null
            }
        ],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:OperationBinding",
        groups:[
            "serverSummaries"
        ]
    },
    "attr:DataBoundComponent.addSummaryFieldText":{
        ref:"attr:DataBoundComponent.addSummaryFieldText",
        flags:"IRW",
        description:"Text for a menu item allowing users to add a formula field",
        name:"addSummaryFieldText",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Add summary column...\"",
        type:"attr",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "i18nMessages"
        ]
    },
    "class:Splitbar":{
        methods:[
        ],
        ref:"class:Splitbar",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Layout"
        ],
        attrs:[
            "attr:Splitbar.target",
            "attr:Splitbar.vertical",
            "attr:Splitbar.src",
            "attr:Splitbar.hSrc",
            "attr:Splitbar.vSrc",
            "attr:Splitbar.capSize",
            "attr:Splitbar.skinImgDir",
            "attr:Splitbar.showGrip",
            "attr:Splitbar.gripImgSuffix",
            "attr:Splitbar.showDownGrip",
            "attr:Splitbar.showRollOverGrip",
            "attr:Splitbar.showClosedGrip",
            "attr:Splitbar.targetAfter",
            "attr:Splitbar.invertClosedGripIfTargetAfter",
            "attr:Splitbar.canDrag",
            "attr:Splitbar.canCollapse",
            "attr:Splitbar.canCollapseOnTap",
            "attr:Splitbar.cursor",
            "attr:Splitbar.vResizeCursor",
            "attr:Splitbar.hResizeCursor"
        ],
        description:"Resize bar for use in ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass','Layouts')}, based on the\n ${isc.DocUtils.linkForRef('class:StretchImg')} class.  As with the ${isc.DocUtils.linkForRef('class:ImgSplitbar')} class, \n widgets of this class can be displayed as a resize-bar for widgets \n in Layouts where showResizeBar is set to true. Provides a different appearance from\n the <code>ImgSplitbar</code> class.\n <p>\n To specify the resizeBar class for some layout, use the ${isc.DocUtils.linkForRef('attr:Layout.resizeBarClass')}\n property.",
        name:"Splitbar",
        seeAlso:[
            {
                ref:"class:Layout",
                description:null
            },
            {
                ref:"class:ImgSplitbar",
                description:null
            }
        ],
        type:"class"
    },
    "attr:DrawCurve.startPoint":{
        ref:"attr:DrawCurve.startPoint",
        flags:"IRW",
        description:"Start point of the curve",
        name:"startPoint",
        setter:[
            "setStartPoint"
        ],
        seeAlso:[
        ],
        valueType:"Point",
        defaultValue:"[0,0]",
        type:"attr",
        definingClass:"class:DrawCurve"
    },
    "type:SequenceMode":{
        ref:"type:SequenceMode",
        values:[
            {
                description:"Use the JDBC 3.0 API \"getGeneratedKeys()\" to get the most recent                      sequence value.  Obviously, this is only an option for JDBC 3.0+ drivers",
                value:"\"jdbcDriver\""
            },
            {
                description:"Use a database-specific native technique to obtain the most recent                     sequence value.  The actual technique used varies widely depending on\n                     the vagaries of the underlying database (and sometimes the vagaries of\n                     particular releases of a database product)",
                value:"\"native\""
            },
            {
                description:"No automatic attempt is made to retrieve the most recent sequence value.                     You are expected to handle this by providing a  \n                     ${isc.DocUtils.linkForRef('attr:OperationBinding.cacheSyncOperation','cacheSyncOperation')} that is \n                     able to return the entire row without needing generated PK values for\n                     context. For example, a query that uses <code>MAX(pk)</code> would be\n                     capable of this.  To give a more complex example, say you have a \n                     sequence value that is retrieved from a legacy system: you could store \n                     that sequence value in the HTTP session and then have your custom \n                     <code>cacheSyncOperation</code> reference that session attribute in \n                     its <code>WHERE</code> clause.  Also note that cacheSyncOperations, \n                     like any other ${isc.DocUtils.linkForRef('class:OperationBinding','DataSource operation')}, \n                     can be ${isc.DocUtils.linkForRef('attr:OperationBinding.serverObject','written in Java')} or any \n                     ${isc.DocUtils.linkForRef('attr:OperationBinding.script','JSR223-compliant scripting language')} -\n                     you do not have to use SQL",
                value:"\"none\""
            }
        ],
        description:"The possible types of sequence handling SmartClient Server can apply.  This refers to the\n technique used to obtain the primary keys of the most recent insert, which the product \n uses to enable automatic cache synchronization (updating client-side components bound to a \n dataSource to reflect updates to that dataSource).  Only applicable to\n ${isc.DocUtils.linkForRef('class:DataSourceField','fields')} of ${isc.DocUtils.linkForRef('type:FieldType','type')} \"sequence\".\n <P>",
        name:"SequenceMode",
        seeAlso:[
        ],
        type:"type",
        serverDS:"only"
    },
    "attr:LinearGradient.y2":{
        ref:"attr:LinearGradient.y2",
        flags:"IR",
        description:"Y coordinate of the end point. This can be a number or a percentage of the height of the\n bounding box of the DrawItem to which it is applied.",
        name:"y2",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:LinearGradient"
    },
    "attr:BlurbItem.wrap":{
        ref:"attr:BlurbItem.wrap",
        flags:"IRW",
        description:"If true, item contents can wrap. If false, all the contents should appear on a single line.",
        name:"wrap",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:BlurbItem",
        groups:[
            "appearance"
        ]
    },
    "method:Button.setState":{
        ref:"method:Button.setState",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.state','state')} of this object, changing its appearance.\n Note: <code>newState</code> cannot be\n <smartclient><code>\"Disabled\"</code></smartclient>\n <smartgwt>{@link com.smartgwt.client.types.State#STATE_DISABLED}</smartgwt>\n if ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showDisabled','this.showDisabled')} is <code>false</code>.\n\n",
        name:"setState",
        seeAlso:[
        ],
        params:[
            {
                description:"the new state.",
                optional:false,
                name:"newState",
                defaultValue:null,
                type:"State"
            }
        ],
        type:"method",
        definingClass:"class:Button",
        groups:[
            "state",
            "appearance"
        ]
    },
    "attr:LinearGradient.y1":{
        ref:"attr:LinearGradient.y1",
        flags:"IR",
        description:"Y coordinate of the start point. This can be a number or a percentage of the height of the\n bounding box of the DrawItem to which it is applied.",
        name:"y1",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:LinearGradient"
    },
    "attr:Facet.inlinedValues":{
        ref:"attr:Facet.inlinedValues",
        flags:"IRW",
        description:"When applied to a ${isc.DocUtils.linkForRef('interface:Chart')}, does the chart's data contain multiple values per record\n for this facet. See ${isc.DocUtils.linkForRef('attr:Chart.data')} for a full overview of <code>inlinedValues</code>\n behavior.",
        name:"inlinedValues",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Facet"
    },
    "method:DrawItem.getPageTop":{
        ref:"method:DrawItem.getPageTop",
        flags:"A",
        description:" Returns the page-relative top coordinate of the widget on the page, in pixels\n",
        name:"getPageTop",
        seeAlso:[
        ],
        returns:{
            description:"GLOBAL top coordinate",
            type:"number"
        },
        type:"method",
        definingClass:"class:DrawItem",
        groups:[
            "positioning"
        ]
    },
    "method:ImgButton.getTitle":{
        ref:"method:ImgButton.getTitle",
        flags:"A",
        description:" Return the title - HTML drawn inside the component.\n <p>\n Default is to simply return this.title.\n",
        name:"getTitle",
        seeAlso:[
        ],
        returns:{
            description:"HTML for the title.",
            type:"HTMLString"
        },
        type:"method",
        definingClass:"class:ImgButton"
    },
    "attr:Label.icon":{
        ref:"attr:Label.icon",
        flags:"IRW",
        description:"Optional icon to be shown with the button title text.  \n <P>\n Specify as the partial URL to an image, relative to the imgDir of this component.",
        name:"icon",
        setter:[
            "setIcon"
        ],
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Label",
        groups:[
            "buttonIcon"
        ]
    },
    "classMethod:EventHandler.getX":{
        ref:"classMethod:EventHandler.getX",
        flags:"",
        description:"\t\t\tReturn the page-relative X (horizontal) coordinate of an event.\n\n",
        name:"getX",
        seeAlso:[
        ],
        returns:{
            description:"x-coordinate in page coordinate space",
            type:"int"
        },
        type:"classMethod",
        definingClass:"class:EventHandler",
        groups:[
            "mouseEvents"
        ]
    },
    "method:FormItemIcon.showIf":{
        ref:"method:FormItemIcon.showIf",
        flags:"",
        description:" If specified, <code>icon.showIf</code> will be evaluated when the form item is\n drawn or redrawn. Return true if the icon should be visible, or false if it\n should be hidden. Note that if ${isc.DocUtils.linkForRef('method:FormItem.showIcon')} or ${isc.DocUtils.linkForRef('method:FormItem.hideIcon')}\n is called, this method will be overridden.\n",
        name:"showIf",
        seeAlso:[
        ],
        params:[
            {
                description:"the DynamicForm in which the icon is embedded",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            },
            {
                description:"the item to which this icon is attached.",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            }
        ],
        returns:{
            description:"Return true if the icon should be visible, false otherwise.",
            type:"boolean"
        },
        type:"method",
        definingClass:"object:FormItemIcon"
    },
    "method:Canvas.getPageRight":{
        ref:"method:Canvas.getPageRight",
        flags:"",
        description:" Return the page-relative right coordinate of this object, in pixels.\n\n",
        name:"getPageRight",
        seeAlso:[
        ],
        returns:{
            description:"GLOBAL right coordinate",
            type:"number"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "positioning"
        ]
    },
    "method:ImgButton.setTitle":{
        ref:"method:ImgButton.setTitle",
        flags:"",
        description:" Setter for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.title','title')}.\n",
        name:"setTitle",
        seeAlso:[
        ],
        params:[
            {
                description:"the new title HTML.",
                optional:false,
                name:"newTitle",
                defaultValue:null,
                type:"HTMLString"
            }
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:[
            "appearance"
        ]
    },
    "attr:CubeGrid.rowHeaderGridMode":{
        ref:"attr:CubeGrid.rowHeaderGridMode",
        flags:"IRA",
        description:"If enabled row headers for this cubeGrid will be rendered using a ${isc.DocUtils.linkForRef('class:GridRenderer')}\n component. This improves performance for very large cubeGrids.",
        name:"rowHeaderGridMode",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "attr:SectionStackSection.ID":{
        ref:"attr:SectionStackSection.ID",
        flags:"IR",
        description:"Optional ID for the section. If ${isc.DocUtils.linkForRef('attr:SectionStack.useGlobalSectionIDs')} is true, this property will\n be applied to the generated SectionStackHeader widget as a standard widget ID, meaning\n it should be unique within a page.\n <P>\n <b>Backcompat Note</b>: Section stack sections may be uniquely identified within a stack\n via the ${isc.DocUtils.linkForRef('attr:SectionStackSection.name')} attribute (introduced in Jan 2010). Prior to this,\n the section ID attribute was used in this way (and would not be applied to the section header \n as a widget ID). For backwards compatibility this is still supported: If \n <code>section.name</code> is unspecified for a section but <code>section.ID</code> is set,\n the ID will be used as a default name attribute for the section. For backwards compatibility\n we also disable the standard behavior of having the <code>section.ID</code> being applied to the generated\n section header (thereby avoiding the page-level uniqueness requirement) by defaulting \n ${isc.DocUtils.linkForRef('attr:SectionStack.useGlobalSectionIDs')} to false.",
        name:"ID",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:SectionStackSection"
    },
    "group:clientServerIntegration":{
        ref:"group:clientServerIntegration",
        title:"Client-Server Integration",
        treeLocation:[
            "Concepts"
        ],
        refs:[
        ],
        description:"Like client-server desktop applications, SmartClient browser-based applications interact\n with remote data and services via background communication channels. Background requests\n retrieve chunks of data rather than new HTML pages, and update your visual components in\n place rather than rebuilding the entire user interface.\n <P>\n <b>DataSources</b>\n <p>\n First you must create ${isc.DocUtils.linkForRef('class:DataSource','DataSources')} that describe the objects from\n your object model that will be loaded or manipulated within your application.  All of \n SmartClient's most powerful functionality builds on the concept of a DataSource, and because \n of SmartClient's databinding framework (see ${isc.DocUtils.linkForRef('interface:DataBoundComponent')}), it's as easy to \n create a DataSource that can configure an unlimited number of components as it is to \n configure a single component.\n <P>\n For background information on how to create DataSources, ${isc.DocUtils.linkForRef('interface:DataBoundComponent','bind')}\n components to DataSources and initiate ${isc.DocUtils.linkForRef('class:DSRequest')}s, please see the <em>Data \n Binding</em> chapter of the <em>SmartClient Quickstart Guide</em>.\n <P>\n <b>Data Integration</b>\n <P>\n DataSources provide a data-provider agnostic API to SmartClient Visual Components that \n allow them to perform the 4 CRUD operations (<b>C</b>reate, <b>R</b>etrieve, \n <b>U</b>pdate, <b>D</b>elete).  By \"agnostic\" we mean that the implementation details - \n the nuts and bolts of how a given DataSource actually retrieves or updates data - are \n unknown to bound SmartClient components.  One effect of this is that DataSources are \n \"pluggable\": they can be replaced without affecting the User Interface.\n <p>\n When a visual component, or your own custom code, performs a CRUD operation on a DataSource,\n the DataSource creates a ${isc.DocUtils.linkForRef('class:DSRequest')} (DataSource Request) representing the operation.\n \"Data Integration\" is the process of fulfilling that DSRequest by creating a corresponding\n ${isc.DocUtils.linkForRef('class:DSResponse')} (DataSource Response), by using a variety of possible approaches to \n connect to the ultimate data provider.  \n <p>\n There are two main approaches to integrating DataSources with your server technology: \n <ul>\n <li><b>Server-side integration</b>: DataSource requests from the browser arrive as Java \n Objects on the server. You deliver responses to the browser by returning Java Objects. The\n various server-side integration possibilities are discussed later in this article.</li>\n <li>${isc.DocUtils.linkForRef('group:clientDataIntegration','Client-side integration')}: DataSource requests arrive as \n simple HTTP requests which your server code receives directly (in Java, you use the \n Servlet API or .jsps to handle the requests). Responses are sent as XML or JSON which you \n directly generate.</li>\n </ul>\n The possible approaches are summarized in the diagram below. Paths 2, 3 and 4 are \n client-side integration approaches, and path 1 includes all server-side integration \n approaches. \n <p>\n <img src=\"skin/ClientServerIntegration.png\" width=\"866px\" height=\"495px\">\n <p>\n SmartClient supports, out of the box, codeless connectivity to various kinds of common data\n providers, including SQL and Hibernate.  SmartClient also provides functionality and tools\n for accelerated integration with broad categories of data providers, such as Java\n Object-based persistence mechanisms (JPA, EJB, Ibatis, in-house written systems), and REST \n and WSDL web services in XML or JSON formats.  Ultimately, a DataSource can be connected to \n anything that is accessible via HTTP or HTTPS, and also to in-browser persistence engines \n such as <a href='http://gears.google.com' target='_blank'>Google Gears</a>.\n <p>\n <b>Choosing a Data Integration Approach</b><p>\n This section aims to help you decide which of the many possible data integration approaches\n is best for your particular circumstances.  The recommendations given here will guide you\n to the approach that involves the least effort.<p>\n <img src=\"skin/dataIntegrationFlowchart.png\" width=\"640px\" height=\"300px\">\n <p>\n <ul>\n <li>If you have a Java server:</li>\n <ul>\n   <li>If your ultimate storage is a SQL database:</li>\n     <ul>\n       <li>Use the SQLDataSource unless you have a very large amount of pre-existing\n           JPA or Hibernate code - small amounts of business logic can be easily migrated.\n           Be sure to read the overview of ${isc.DocUtils.linkForRef('group:sqlVsJPA','SQLDataSource vs JPA/Hibernate')} \n           in order to understand the large benefits the SQLDataSource provides</li>\n       <li>Derive DataSource definitions from existing tables or Hibernate mappings using the\n           ${isc.DocUtils.linkForRef('attr:DataSource.autoDeriveSchema','autoDeriveSchema')} feature, or from Java Beans\n           via the ${isc.DocUtils.linkForRef('attr:DataSource.schemaBean','schemaBean')} feature.\n           Or, use the ${isc.DocUtils.linkForRef('group:adminConsole','Admin Console')} to generate tables from DataSource\n           definitions you create by hand</li>\n     </ul>\n   <li>If your ultimate storage is not a SQL database:</li>\n     <ul>\n       <li>If your persistence is based on Java Beans, use the\n           ${isc.DocUtils.linkForRef('attr:DataSource.schemaBean','schemaBean')} feature to derive DataSource definitions from\n            any Java bean</li>\n       <li>write a ${isc.DocUtils.linkForRef('group:writeCustomDataSource','custom DataSource')} that provides the\n           CRUD operations you want to support.</li>\n     </ul>\n   <li>Whether or not your storage is SQL, add business logic either declaratively in the \n       DataSource definition, via ${isc.DocUtils.linkForRef('group:dmiOverview','DMI')}, or any combination of the two:\n     <ul>\n       <li>The &lt;criteria&gt; and &lt;values&gt; properties of an ${isc.DocUtils.linkForRef('class:OperationBinding')}\n           allow you to dynamically set data values at transaction-processing time, using \n           built-in ${isc.DocUtils.linkForRef('group:velocitySupport','Velocity support')}</li>\n       <li>Override the <code>validate()</code> method of the DataSource to provide extra\n           custom validations - just call <code>super</code> to obtain the list of errors \n           derived from SmartClient validations, then add to that list as required with your\n           own custom code</li>\n       <li>Override the <code>execute()</code> method of the DataSource to add extra processing\n           either before or after the SmartClient processing</li>\n       <li>Use ${isc.DocUtils.linkForRef('attr:DSRequestModifier.value','Transaction Chaining')} to dynamically set\n           data values according to the results of earlier transactions</li>\n       <li>For SQL DataSources, use ${isc.DocUtils.linkForRef('group:customQuerying','SQL Templating')} to change, \n           add to or even completely replace the SQL sent to the database, and to implement\n           special query requirements</li>\n       <li>For JPA DataSources, use ${isc.DocUtils.linkForRef('attr:OperationBinding.customJQL','custom JQL queries')}\n           to implement special query requirements</li>\n       <li>For Hibernate DataSources, use ${isc.DocUtils.linkForRef('attr:OperationBinding.customHQL','custom HQL queries')}\n           to implement special query requirements</li>\n      </ul>\n      Read more about the server-side request processing flow and how to customize it in\n      ${isc.DocUtils.linkForRef('group:serverDataIntegration','the server integration overview')}.\n </ul>\n </ul>\n <ul>\n <li>If you do not have a Java server:</li>\n   <ul><li>If you are not obliged to use a pre-existing network protocol, use the \n           ${isc.DocUtils.linkForRef('class:RestDataSource')}</li>\n       <li>Otherwise, use ${isc.DocUtils.linkForRef('group:clientDataIntegration','client-side data integration')} features\n           to create a custom client-side DataSource that adapts the DataSource protocol to \n           your existing services</li>\n   </ul>\n </ul>\n <p><br>\n <b>RPCs: Unstructured Server Communication</b>\n <P>\n SmartClient also supports \"unstructured\" client-server operations.  These \n ${isc.DocUtils.linkForRef('class:RPCRequest')}s (Remote Procedure Call Requests) are a low-level, very flexible \n mechanism for custom client-server communications.  In an nutshell, RPCRequests:\n <ul>\n <li> may contain arbitrary data\n <li> are always initiated by custom code (a call to ${isc.DocUtils.linkForRef('classMethod:RPCManager.send')}), and have\n their responses handled by custom code (the callback passed to <code>send()</code>)\n </ul>\n <P>\n RPCRequests are relatively rare.  Most client-server communications are better done in a \n structured fashion using a ${isc.DocUtils.linkForRef('class:DSRequest')} (DataSource Request).  Note that <em>any</em>\n RPCRequest can alternatively be framed as a ${isc.DocUtils.linkForRef('method:DataSource.fetchData','DataSource fetch')}; \n depending on the circumstances, this may be more convenient.\n <P>\n See the ${isc.DocUtils.linkForRef('class:RPCManager')} documentation for further information on RPCRequests.",
        name:"clientServerIntegration",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:FieldPickerWindow.title":{
        ref:"attr:FieldPickerWindow.title",
        flags:"IR",
        description:null,
        name:"title",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Field Picker\"",
        type:"attr",
        definingClass:"class:FieldPickerWindow",
        groups:[
            "i18nMessages"
        ]
    },
    "method:TabSet.addTabs":{
        ref:"method:TabSet.addTabs",
        flags:"A",
        description:" Add one or more tabs\n",
        name:"addTabs",
        seeAlso:[
            {
                ref:"method:TabSet.addTab",
                description:null
            }
        ],
        params:[
            {
                description:"new tab or tabs",
                optional:false,
                name:"tabs",
                defaultValue:null,
                type:"Tab or Array of Tab"
            },
            {
                description:"position where tab should be added (or array of positions)",
                optional:false,
                name:"position",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "attr:DateChooser.prevMonthIcon":{
        ref:"attr:DateChooser.prevMonthIcon",
        flags:"IR",
        description:"Icon for the previous month button",
        name:"prevMonthIcon",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"\"[SKIN]arrow_left.gif\"",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "object:GroupSpecifier":{
        methods:[
        ],
        ref:"object:GroupSpecifier",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        attrs:[
            "attr:GroupSpecifier.property",
            "attr:GroupSpecifier.grouping",
            "attr:GroupSpecifier.normalizer",
            "attr:GroupSpecifier.context"
        ],
        description:"A Javascript object defining the details of a single group operation.",
        name:"GroupSpecifier",
        seeAlso:[
        ],
        type:"object"
    },
    "group:EventRegistry":{
        ref:"group:EventRegistry",
        refs:[
            "classMethod:Page.setEvent",
            "classMethod:Page.clearEvent",
            "type:FireStyle"
        ],
        name:"EventRegistry",
        seeAlso:[
        ],
        type:"group"
    },
    "class:ToolbarItem":{
        methods:[
        ],
        exampleConfig:"ToolbarItem.xml",
        ref:"class:ToolbarItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:ToolbarItem.buttons",
            "attr:ToolbarItem.showTitle",
            "attr:ToolbarItem.startRow",
            "attr:ToolbarItem.endRow",
            "attr:ToolbarItem.colSpan",
            "attr:ToolbarItem.canvas",
            "attr:ToolbarItem.vertical",
            "attr:ToolbarItem.buttonConstructor",
            "attr:ToolbarItem.buttonProperties",
            "attr:ToolbarItem.buttonBaseStyle"
        ],
        description:"Set of horizontally arranged buttons.",
        name:"ToolbarItem",
        seeAlso:[
        ],
        type:"class"
    },
    "method:ListGrid.setFastCellUpdates":{
        ref:"method:ListGrid.setFastCellUpdates",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:GridRenderer.fastCellUpdates')}. Has no effect in browsers other than\n Internet Explorer.\n",
        name:"setFastCellUpdates",
        seeAlso:[
        ],
        params:[
            {
                description:"whether to enable fastCellUpdates.",
                optional:false,
                name:"fastCellUpdates",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "attr:CubeGrid.autoSelectValues":{
        ref:"attr:CubeGrid.autoSelectValues",
        flags:"IR",
        description:"Whether to select cells in the body when row or column headers are selected.",
        name:"autoSelectValues",
        seeAlso:[
        ],
        valueType:"AutoSelectionModel",
        defaultValue:"\"both\"",
        type:"attr",
        definingClass:"class:CubeGrid"
    },
    "method:Canvas.moveAbove":{
        ref:"method:Canvas.moveAbove",
        flags:"",
        description:" Puts this widget just above the specified widget in the stacking order, so it appears in\n front of the specified widget if both widgets have the same parent.\n",
        name:"moveAbove",
        seeAlso:[
        ],
        params:[
            {
                description:"canvas to move above",
                optional:false,
                name:"canvas",
                defaultValue:null,
                type:"Canvas or subclass"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('layer')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "zIndex"
        ]
    },
    "attr:Window.dismissOnOutsideClick":{
        ref:"attr:Window.dismissOnOutsideClick",
        flags:"IRW",
        description:"If true, a click outside the bounds of the Window will have the same effect as\n      pressing its cancel button.<br>\n      <b>Note:</b> Applies only to modal windows.",
        name:"dismissOnOutsideClick",
        seeAlso:[
            {
                ref:"attr:Window.isModal",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "modal"
        ]
    },
    "attr:Canvas.animateResizeAcceleration":{
        ref:"attr:Canvas.animateResizeAcceleration",
        flags:"IRWA",
        description:"Default acceleration function for performing an animated resize.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateResizeAcceleration",
        seeAlso:[
        ],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "attr:SelectItem.valueField":{
        ref:"attr:SelectItem.valueField",
        flags:"IRW",
        getter:[
            "getValueFieldName"
        ],
        description:"If this form item maps data values to display values by retrieving the \n ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} values from an \n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')}, this property \n denotes the the field to use as the underlying data value in records from the \n optionDataSource.<br>\n If unset, assumed to be the ${isc.DocUtils.linkForRef('attr:FormItem.name')} of this form item.",
        name:"valueField",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('relatedRecords')}"
        ],
        definingClass:"class:SelectItem",
        groups:[
            "display_values"
        ]
    },
    "attr:Layout.animateMembers":{
        ref:"attr:Layout.animateMembers",
        flags:"IRW",
        description:"If true when members are added / removed, they should be animated as they are shown\n or hidden in position",
        name:"animateMembers",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateLayout')}"
        ],
        definingClass:"class:Layout",
        groups:[
            "animation"
        ]
    },
    "classAttr:Validator.mustBeLaterThanTime":{
        ref:"classAttr:Validator.mustBeLaterThanTime",
        flags:"IRA",
        description:"Default error message to display when standard <code>timeRange</code> type validator\n returns false because the time-portion of the date-value passed in is less than the \n specified minimum time.\n <p> This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code\n when the message is displayed, with <code>max</code> and <code>min</code> available as\n variables mapped to <code>validator.max</code> and <code>validator.min</code>.",
        name:"mustBeLaterThanTime",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Must be later than ${isc.Time.toShortTime(min)}\"",
        type:"classAttr",
        definingClass:"class:Validator",
        groups:[
            "i18nMessages"
        ]
    },
    "method:ImgButton.setBaseStyle":{
        ref:"method:ImgButton.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[
        ],
        params:[
            {
                description:"new base style",
                optional:false,
                name:"style",
                defaultValue:null,
                type:"className"
            }
        ],
        type:"method",
        definingClass:"class:ImgButton"
    },
    "attr:OperationBinding.serverMethod":{
        ref:"attr:OperationBinding.serverMethod",
        flags:"IR",
        description:"The name of the method to invoke on the ${isc.DocUtils.linkForRef('class:ServerObject')} for this operationBinding.\n <p>\n <b>NOTE:</b> If you have a ${isc.DocUtils.linkForRef('attr:DataSource.serverObject','DataSource-level ServerObject')} and\n wish to override this operation so that it simply calls a different method on the same \n server object, it is sufficient to specify just this property on the operationBinding:\n there is no need to redefine the serverObject at the operationBinding level.",
        name:"serverMethod",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:OperationBinding",
        requiresModules:[
            "SCServer"
        ]
    },
    "attr:ListGrid.groupTree":{
        ref:"attr:ListGrid.groupTree",
        flags:"R",
        description:"The data tree that results from a call to  ${isc.DocUtils.linkForRef('method:ListGrid.groupBy')}.\n This will be a ${isc.DocUtils.linkForRef('class:ResultTree')} if ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')} is\n present, otherwise it will be a ${isc.DocUtils.linkForRef('class:Tree')}.",
        name:"groupTree",
        seeAlso:[
            {
                ref:"method:ListGrid.groupBy",
                description:null
            }
        ],
        valueType:"AutoChild Tree",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "grouping"
        ]
    },
    "classAttr:RPCManager.saveDataPrompt":{
        ref:"classAttr:RPCManager.saveDataPrompt",
        flags:"IRW",
        description:"Default prompt displayed to the user while an operation is running to save data to\n the server.<br>\n Displayed as a result of the ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} code path.",
        name:"saveDataPrompt",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"Saving form...\"",
        type:"classAttr",
        definingClass:"class:RPCManager",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Scrollbar.showTrackEnds":{
        ref:"attr:Scrollbar.showTrackEnds",
        flags:"IRA",
        description:"If true, the scrollbar uses a 5-segment rather than 3-segment image representation,\n where the 3 interior image segments have the same state (Down, Over, etc), independent\n of the two outermost image segments.  \n <P>\n This allows certain advanced skinning designs where the track-as-such (space in which\n the thumb may be dragged) has curved endcaps, and is also visually stateful (that is,\n changes when the mouse goes down, without affecting the appearance of the outermost\n segments).",
        name:"showTrackEnds",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "track"
        ]
    },
    "attr:ListGrid.selectionCanvas":{
        ref:"attr:ListGrid.selectionCanvas",
        flags:"RA",
        description:"AutoChild created and embedded in the grid if ${isc.DocUtils.linkForRef('attr:ListGrid.showSelectionCanvas','showSelectionCanvas')}\n is <code>true</code> and the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionType','selectionType')} is\n <smartclient>\"single\".</smartclient>\n <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE}.</smartgwt>\n This component will be created and displayed above the selected record whenever the\n selection changes.\n <p>\n NOTE: It is recommended to use the ${isc.DocUtils.linkForRef('attr:ListGrid.selectionUnderCanvas','selectionUnderCanvas')}\n rather than the <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code>\n is stacked on top of the selected record and this may interfere with event handling in rare\n cases. If no interactive components are shown in the <code>selectionCanvas</code> and it\n simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used\n instead.\n <p>\n The <code>selectionCanvas</code> has the following read-only attributes set:<br>\n - <code>this.grid</code> - a pointer to the grid<br>\n - <code>this.record</code> - a pointer to the currently selected record in the grid",
        name:"selectionCanvas",
        seeAlso:[
            {
                ref:"attr:ListGrid.selectionUnderCanvas",
                description:null
            }
        ],
        valueType:"AutoChild Canvas",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "rowEffects"
        ]
    },
    "attr:SliderItem.shouldSaveValue":{
        ref:"attr:SliderItem.shouldSaveValue",
        flags:"IR",
        description:"Should this item's value be saved in the form's values and hence returned from\n ${isc.DocUtils.linkForRef('method:DynamicForm.getValues','form.getValues()')}?\n <p>\n <code>shouldSaveValue:false</code> is used to mark formItems which do not correspond to\n the underlying data model and should not save a value into the form's\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','values')}.  Example includes visual separators, password re-type fields,\n or checkboxes used to show/hide other form items.\n <p>\n A <code>shouldSaveValue:false</code> item should be given a value either via\n ${isc.DocUtils.linkForRef('attr:FormItem.defaultValue')} or by calling\n ${isc.DocUtils.linkForRef('method:DynamicForm.setValue','form.setValue(item, value)')} or \n ${isc.DocUtils.linkForRef('method:FormItem.setValue','formItem.setValue(value)')}.  Providing a value via\n ${isc.DocUtils.linkForRef('attr:DynamicForm.values','form.values')} or ${isc.DocUtils.linkForRef('method:DynamicForm.setValues','form.setValues()')} \n will automatically switch the item to <code>shouldSaveValue:true</code>.\n <P>\n Note that <ul>\n <li>if an item is shouldSaveValue true, but has no name, a warning is logged, and \n     shouldSaveValue will be set to false.\n </li></ul>",
        name:"shouldSaveValue",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:SliderItem",
        groups:[
            "formValues"
        ]
    },
    "attr:SelectItem.showFocused":{
        ref:"attr:SelectItem.showFocused",
        flags:"IRWA",
        description:"When this item receives focus, should it be re-styled to indicate it has focus?",
        name:"showFocused",
        seeAlso:[
            {
                ref:"attr:FormItem.cellStyle",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"true, [IRWA]",
        type:"attr",
        definingClass:"class:SelectItem",
        groups:[
            "appearance"
        ]
    },
    "classAttr:Operators.notContainsFieldTitle":{
        ref:"classAttr:Operators.notContainsFieldTitle",
        flags:"IR",
        description:"Title for the \"notContainsField\" operator",
        name:"notContainsFieldTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"does not contain (match case) another field value\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:TreeGrid.animateFolders":{
        ref:"attr:TreeGrid.animateFolders",
        flags:"IRW",
        description:"If true, when folders are opened / closed children will be animated into view.",
        name:"animateFolders",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('animateTree')}"
        ],
        definingClass:"class:TreeGrid",
        groups:[
            "animation"
        ]
    },
    "method:Callbacks.LoadScreenCallback":{
        ref:"method:Callbacks.LoadScreenCallback",
        flags:"",
        description:" A ${isc.DocUtils.linkForRef('type:Callback')} to evaluate when a screen is loaded via ${isc.DocUtils.linkForRef('classMethod:RPCManager.loadScreen')}.\n\n",
        name:"LoadScreenCallback",
        seeAlso:[
        ],
        params:[
            {
                description:"The last top-level component loaded",
                optional:true,
                name:"screen",
                defaultValue:null,
                type:"Canvas"
            },
            {
                description:null,
                optional:true,
                name:"rpcResponse",
                defaultValue:null,
                type:"RPCResponse"
            },
            {
                description:"A collection of suppressed globals.",
                optional:true,
                name:"suppressedGlobals",
                defaultValue:null,
                type:"Map"
            }
        ],
        type:"method",
        definingClass:"class:Callbacks"
    },
    "classAttr:Time.shortDisplayFormat":{
        ref:"classAttr:Time.shortDisplayFormat",
        flags:"RWA",
        description:"Standard formatter to be used when converting a date to a time-string via ${isc.DocUtils.linkForRef('classMethod:Time.toShortTime')}",
        name:"shortDisplayFormat",
        setter:[
            "setShortDisplayFormat"
        ],
        seeAlso:[
        ],
        valueType:"TimeDisplayFormat | function",
        defaultValue:"\"toShortTime\"",
        type:"classAttr",
        definingClass:"class:Time"
    },
    "attr:ListGridField.applyAfterSummary":{
        ref:"attr:ListGridField.applyAfterSummary",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGridField.userFormula')} is set for this field, and this grid is showing\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary','group summaries')} or a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary','grid summary')}, this property determines what field value\n should be present in those summary rows. Should the field apply the user-formula to the\n calculated summary row, or should it apply a standard grid or group summary to the\n user-formula values displayed in the grid?\n <P>\n Default behavior may be specified at the grid level via ${isc.DocUtils.linkForRef('attr:ListGrid.applyFormulaAfterSummary')}",
        name:"applyAfterSummary",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "attr:TimeItem.hourIncrement":{
        ref:"attr:TimeItem.hourIncrement",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourValues','hourValues')} is unset, this attribute specifies the increment\n to use when generating entries for the hour picker.  For example, if this attribute is\n set to 5, the hour picker will contain only every fifth value between the \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourMinValue','hourMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.hourMaxValue','hourMaxValue')}.",
        name:"hourIncrement",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "method:Canvas.showComponentMask":{
        ref:"method:Canvas.showComponentMask",
        flags:"",
        description:" Temporariy block all user interaction with children of this widget, with the exception of those\n passed in in the <code>unmaskedChildren</code> parameter. Children will remain blocked until\n ${isc.DocUtils.linkForRef('method:Canvas.hideComponentMask')} is called.\n <P>\n This method will show the ${isc.DocUtils.linkForRef('attr:Canvas.componentMask')} canvas to block mouse interaction with\n children, and temporarily remove masked children from the page's tab-order.\n <P>\n This behavior differs from the standard ${isc.DocUtils.linkForRef('method:Canvas.showClickMask','click mask')} in that the\n modal mask shown by ${isc.DocUtils.linkForRef('method:Canvas.showClickMask')} will cover the entire screen and typically only \n allow \"unmasking\" of top level components.\n <P>\n Use ${isc.DocUtils.linkForRef('method:Canvas.hideComponentMask')} to hide the component level mask.\n\n",
        name:"showComponentMask",
        seeAlso:[
        ],
        params:[
            {
                description:"Children passed into this parameter will continue to       be interactive while other children are blocked. They will be moved above the componentMask in\n      the page's z-order and remain accessible via keyboard navigation.  Note that this array should\n      contain direct children of this widget only.",
                optional:true,
                name:"unmaskedChildren",
                defaultValue:null,
                type:"Array of Canvas"
            }
        ],
        type:"method",
        definingClass:"class:Canvas"
    },
    "attr:DSResponse.clientContext":{
        ref:"attr:DSResponse.clientContext",
        flags:"R",
        description:"The ${isc.DocUtils.linkForRef('attr:DSRequest.clientContext')} object as set on the ${isc.DocUtils.linkForRef('class:DSRequest')}.",
        name:"clientContext",
        seeAlso:[
            {
                ref:"attr:DSRequest.clientContext",
                description:null
            },
            {
                ref:"attr:RPCResponse.clientContext",
                description:null
            }
        ],
        valueType:"Object",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSResponse"
    },
    "attr:RPCRequest.omitNullMapValuesInResponse":{
        ref:"attr:RPCRequest.omitNullMapValuesInResponse",
        flags:"IRWA",
        description:"If enabled, the server omits any key/value pairs in map that have null values from the\n response.  This can reduce the size of the response when many fields have null values.\n <p>\n To enable this globally for all responses you can set RPCManager.omitNullMapValuesInResponse\n in ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}.",
        name:"omitNullMapValuesInResponse",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:RPCRequest"
    },
    "method:ListGridField.formatEditorValue":{
        ref:"method:ListGridField.formatEditorValue",
        flags:"",
        description:" Return the value to display in cells of this field which are being edited.\n <P>\n <i>Example usage</i>: converting a stored value in cents (100) to a dollar-and-cents\n value in the editor (1.00)\n <P>\n The value passed to this method is the raw value for the cell.\n <P>\n <code>formatEditorValue</code> takes precedence over ${isc.DocUtils.linkForRef('method:ListGrid.formatEditorValue')}\n defined at the grid level for cells in this field.\n <P>\n To convert the formatted value displayed within an editor back to a raw value, implement\n ${isc.DocUtils.linkForRef('method:ListGridField.parseEditorValue')} as well.\n\n",
        name:"formatEditorValue",
        seeAlso:[
            {
                ref:"method:ListGridField.formatCellValue",
                description:null
            },
            {
                ref:"method:ListGrid.formatEditorValue",
                description:null
            },
            {
                ref:"method:ListGridField.parseEditorValue",
                description:null
            }
        ],
        params:[
            {
                description:"raw value for the cell being edited",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"Record object for the cell. Note: If this is a new row that has not been saved, in an\n   editable grid, it has no associated record object. In this case the edit values will\n   be passed in as this parameter.",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"column number for the cell.",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"A pointer to the ListGrid displaying the cell",
                optional:false,
                name:"grid",
                defaultValue:null,
                type:"ListGrid instance"
            }
        ],
        returns:{
            description:"formatted value to display in the editor",
            type:"any"
        },
        type:"method",
        definingClass:"object:ListGridField",
        groups:[
            "editing"
        ]
    },
    "attr:Label.iconSize":{
        ref:"attr:Label.iconSize",
        flags:"IR",
        description:"Size in pixels of the icon image.\n <P>\n The <code>iconWidth</code> and <code>iconHeight</code> properties can be used to\n configure width and height separately.",
        name:"iconSize",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:Label",
        groups:[
            "buttonIcon"
        ]
    },
    "attr:DataBoundComponent.initialCriteria":{
        ref:"attr:DataBoundComponent.initialCriteria",
        flags:"IR",
        description:"Criteria to be used when ${isc.DocUtils.linkForRef('attr:DataBoundComponent.autoFetchData')} is set.",
        name:"initialCriteria",
        seeAlso:[
        ],
        valueType:"Criteria",
        defaultValue:"null",
        type:"attr",
        definingClass:"interface:DataBoundComponent"
    },
    "method:Canvas.moveBelow":{
        ref:"method:Canvas.moveBelow",
        flags:"",
        description:" Puts this widget just below the specified widget in the stacking order, so it appears\n behind the specified widget if both widgets have the same parent.\n",
        name:"moveBelow",
        seeAlso:[
        ],
        params:[
            {
                description:"canvas to move below",
                optional:false,
                name:"canvas",
                defaultValue:null,
                type:"Canvas or subclass"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('layer')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "zIndex"
        ]
    },
    "method:Menu.getItemNum":{
        ref:"method:Menu.getItemNum",
        flags:"",
        description:" Given a MenuItem, return it's index in the items array.\n\n",
        name:"getItemNum",
        seeAlso:[
        ],
        params:[
            {
                description:"index of the item or MenuItem itself",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"MenuItem | int"
            }
        ],
        returns:{
            description:"index of the item, or -1 if not defined.",
            type:"int"
        },
        type:"method",
        definingClass:"class:Menu",
        groups:[
            "menuItems"
        ]
    },
    "method:UploadItem.deselectValue":{
        ref:"method:UploadItem.deselectValue",
        flags:"",
        description:" <strong>This method is not supported</strong> by <code>UploadItem</code>.\n",
        name:"deselectValue",
        seeAlso:[
        ],
        params:[
            {
                description:"By default the text insertion cursor will be moved to the end of the   current value - pass in this parameter to move to the start instead",
                optional:true,
                name:"start",
                defaultValue:null,
                type:"Boolean"
            }
        ],
        type:"method",
        definingClass:"class:UploadItem"
    },
    "method:GridRenderer.getCellRowSpan":{
        ref:"method:GridRenderer.getCellRowSpan",
        flags:"",
        description:" When using ${isc.DocUtils.linkForRef('method:GridRenderer.getRowSpan','row spanning')}, returns the number of cells spanned by the cell\n at the given coordinates.\n <P>\n If the passed coordinates are in the middle of a series of spanned cells, the row span of\n the spanning cell is returned.  For example, if row 2 col 0 spans 3 cells, calls to\n <code>getCellRowSpan()</code> for row 2 col 0, row 3 col 0, row 4 col 0 will all return 3.\n <P>\n This method returns row span information for the current rendered cells.  In contrast, if\n the grid is about to be redrawn, a call to <code>getRowSpan()</code> may return row span\n values for how the grid is about to be drawn.  Also, user-provided getRowSpan() functions\n are not required to operate properly when called outside of the grid rendering loop.\n <P>\n <b>Note:</b> This method is a utility method for developers - it is not called\n directly by the grid rendering path and therefore is not intended for override. To\n set up custom row-spanning behavior, override ${isc.DocUtils.linkForRef('method:GridRenderer.getRowSpan')} instead.\n\n",
        name:"getCellRowSpan",
        seeAlso:[
        ],
        params:[
            {
                description:"row number of cell to return the row span for",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"int"
            },
            {
                description:"column number of cell to return the row span for",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"int"
            }
        ],
        returns:{
            description:"number of cells spanned by the cell that spans through these coordinates",
            type:"int"
        },
        type:"method",
        definingClass:"class:GridRenderer"
    },
    "method:RichTextEditor.setValue":{
        ref:"method:RichTextEditor.setValue",
        flags:"",
        description:" Updates the current value of the edit area.\n",
        name:"setValue",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:RichTextEditor"
    },
    "group:dragTracker":{
        ref:"group:dragTracker",
        refs:[
            "method:DataBoundComponent.setDragTracker",
            "method:ListGrid.setDragTracker",
            "method:ListGrid.getDragTrackerIcon",
            "method:ListGrid.getDragTrackerTitle",
            "method:TreeGrid.getDragTrackerIcon",
            "method:TileGrid.setDragTracker",
            "method:TileGrid.getDragTrackerTitle",
            "classMethod:EventHandler.setDragTracker",
            "attr:ListGrid.dragTrackerMode",
            "attr:ListGrid.trackerImage",
            "type:DragTrackerMode"
        ],
        name:"dragTracker",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:Calendar.datePickerHoverText":{
        ref:"attr:Calendar.datePickerHoverText",
        flags:"IR",
        description:"The text to be displayed when a user hovers over the ${isc.DocUtils.linkForRef('attr:Calendar.datePickerButton','date picker')}\n toolbar button",
        name:"datePickerHoverText",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Choose a date\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Layout.enforcePolicy":{
        ref:"attr:Layout.enforcePolicy",
        flags:"IRWA",
        description:"Whether the layout policy is continuously enforced as new members are added or removed\n and as members are resized.\n <p>\n This setting implies that any member that resizes larger, or any added member, will take\n space from other members in order to allow the overall layout to stay the same size.",
        name:"enforcePolicy",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Layout",
        groups:[
            "layoutPolicy"
        ]
    },
    "method:DataSource.removeData":{
        ref:"method:DataSource.removeData",
        flags:"",
        description:" Perform a \"remove\" DataSource operation against this DataSource, to delete an existing\n DataSource record.\n\n",
        name:"removeData",
        seeAlso:[
        ],
        params:[
            {
                description:"primary key values of record to delete, (or complete record)",
                optional:false,
                name:"data",
                defaultValue:null,
                type:"Record | PrimaryKeys"
            },
            {
                description:"callback to invoke on completion",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"DSCallback"
            },
            {
                description:"additional properties to set on                                                       the DSRequest that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            }
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "operations"
        ]
    },
    "attr:FormItem.cellStyle":{
        ref:"attr:FormItem.cellStyle",
        flags:"IRW",
        description:"CSS style applied to the form item as a whole, including the text element, any icons, and\n any hint text for the item. Applied to the cell containing the form item.\n <P>\n NOTE: See the ${isc.DocUtils.linkForRef('group:CompoundFormItem_skinning')} discussion for special skinning considerations.",
        name:"cellStyle",
        setter:[
            "setCellStyle"
        ],
        seeAlso:[
        ],
        valueType:"FormItemBaseStyle",
        defaultValue:"\"formCell\"",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "appearance"
        ]
    },
    "attr:TileGrid.wrapValues":{
        ref:"attr:TileGrid.wrapValues",
        flags:"IR",
        description:"Whether values should be allowed to wrap by default, or should be shown on one line\n regardless of length.",
        name:"wrapValues",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:TileGrid"
    },
    "attr:Dialog.styleName":{
        ref:"attr:Dialog.styleName",
        flags:"IRW",
        description:"Style of the Dialog background",
        name:"styleName",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"dialogBackground\"",
        type:"attr",
        definingClass:"class:Dialog",
        groups:[
            "appearance"
        ]
    },
    "attr:ListGrid.asynchGroupingPrompt":{
        ref:"attr:ListGrid.asynchGroupingPrompt",
        flags:"IR",
        description:"The prompt to display while interactivity is blocked during ${isc.DocUtils.linkForRef('attr:ListGrid.groupByAsyncThreshold','asynchronous grouping')}.",
        name:"asynchGroupingPrompt",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"\"${loadingImage}&amp;nbsp;Grouping data...\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:Tab.icon":{
        ref:"attr:Tab.icon",
        flags:"IRW",
        description:"If specified, this tab will show an icon next to the tab title.  \n <p>\n <b>NOTE:</b> if you enable ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs','closeable tabs')},\n <code>tab.icon</code> is used for the close icon.  ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} describes\n a workaround to enable both a <code>closeIcon</code> and a second icon to be shown.\n <p>\n Use ${isc.DocUtils.linkForRef('method:TabSet.tabIconClick')} to add an event handler specifically for clicks on the icon.\n <p>\n If a tab ${isc.DocUtils.linkForRef('attr:Tab.disabled','becomes disabled')}, a different icon will be loaded by adding\n a suffix to the image name (see ${isc.DocUtils.linkForRef('attr:Button.icon')}).\n <p>\n You should specify a size for the icon via ${isc.DocUtils.linkForRef('attr:Tab.iconSize')} or ${isc.DocUtils.linkForRef('attr:Tab.iconWidth')}\n and ${isc.DocUtils.linkForRef('attr:Tab.iconHeight')}. Without an explicitly specified size, tabs may be drawn\n overlapping or with gaps the first time a page is loaded, because the icon is not cached\n and therefore its size isn't known.",
        name:"icon",
        seeAlso:[
            {
                ref:"method:TabSet.tabIconClick",
                description:null
            }
        ],
        valueType:"SCImgURL",
        defaultValue:"null",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('tabsOrientation')}"
        ],
        definingClass:"object:Tab"
    },
    "attr:DynamicForm.requiredMessage":{
        ref:"attr:DynamicForm.requiredMessage",
        flags:"IRW",
        description:"The required message for required field errors.",
        name:"requiredMessage",
        seeAlso:[
        ],
        valueType:"HTMLString",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DynamicForm",
        groups:[
            "formTitles"
        ]
    },
    "method:HiliteEditor.setHilites":{
        ref:"method:HiliteEditor.setHilites",
        flags:"",
        description:" Initialize this editor with a set of Hilites.\n\n",
        name:"setHilites",
        seeAlso:[
        ],
        params:[
            {
                description:"the array of hilite objects to apply",
                optional:false,
                name:"hilites",
                defaultValue:null,
                type:"Array of Hilite"
            }
        ],
        type:"method",
        definingClass:"class:HiliteEditor"
    },
    "class:DateTimeItem":{
        methods:[
        ],
        ref:"class:DateTimeItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:DateTimeItem.useTextField",
            "attr:DateTimeItem.browserInputType",
            "attr:DateTimeItem.displayFormat",
            "attr:DateTimeItem.inputFormat"
        ],
        description:"Subclass of DateItem for manipulating ${isc.DocUtils.linkForRef('type:FieldType','datetimes')}.",
        name:"DateTimeItem",
        seeAlso:[
        ],
        type:"class"
    },
    "classAttr:Array.DATE_VALUES":{
        ref:"classAttr:Array.DATE_VALUES",
        flags:null,
        description:"This is a built-in comparator for the ${isc.DocUtils.linkForRef('method:Array.find','find')} and ${isc.DocUtils.linkForRef('method:Array.findIndex','findIndex')}\n methods of Array.  Passing this comparator to those methods will find instances where Dates  \n in the search criteria match Dates in the array members (ordinarily, Javascript only regards\n Dates as equal if they refer to the exact same object).  This comparator compares <i>logical</i>\n dates; the time elements of the values being compared are ignored, so two Dates representing\n different times on the same day will be considered equal.",
        name:"DATE_VALUES",
        seeAlso:[
            {
                ref:"classAttr:Array.DATETIME_VALUES",
                description:null
            }
        ],
        valueType:"Function",
        defaultValue:"See below",
        type:"classAttr",
        definingClass:"object:Array"
    },
    "attr:DSRequest.exportDelimiter":{
        ref:"attr:DSRequest.exportDelimiter",
        flags:"IR",
        description:"The character to use as a field-separator in CSV exports.  The default delimiter is comma.",
        name:"exportDelimiter",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\",\"",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:Calendar.showWorkday":{
        ref:"attr:Calendar.showWorkday",
        flags:"IR",
        description:"If set, causes the calendar to use ${isc.DocUtils.linkForRef('attr:Calendar.workdayBaseStyle')}\n for cells falling within the workday as defined by ${isc.DocUtils.linkForRef('attr:Calendar.workdayStart')} and ${isc.DocUtils.linkForRef('attr:Calendar.workdayEnd')},\n in both the ${isc.DocUtils.linkForRef('attr:Calendar.weekView')} and ${isc.DocUtils.linkForRef('attr:Calendar.dayView','dayView')}.\n <P>\n The hours of the workday can be customized for particular dates by providing implementations\n of ${isc.DocUtils.linkForRef('method:Calendar.getWorkdayStart')} and ${isc.DocUtils.linkForRef('method:Calendar.getWorkdayEnd')}.",
        name:"showWorkday",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "workday"
        ]
    },
    "attr:DSRequest.exportToClient":{
        ref:"attr:DSRequest.exportToClient",
        flags:"IR",
        description:"If set, SmartClient Server will export data back to the client, either as a file download \n or as content in a new browser window, depending on the setting of\n ${isc.DocUtils.linkForRef('attr:DSRequest.exportDisplay','exportDisplay')}.\n <p>\n Note that it is perfectly valid to specify both this property and \n ${isc.DocUtils.linkForRef('attr:DSRequest.exportToFilesystem','exportToFilesystem')}; in this case the data is both \n exported to a file on the server filesystem, and downloaded to the client.  If you specify \n <em>neither</em> property, the export no-ops.",
        name:"exportToClient",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "method:TileGrid.setCanReorderTiles":{
        ref:"method:TileGrid.setCanReorderTiles",
        flags:"",
        description:" Setter for ${isc.DocUtils.linkForRef('attr:TileGrid.canReorderTiles')}.\n",
        name:"setCanReorderTiles",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:[
            "dragging"
        ]
    },
    "attr:FormItem.selectOnClick":{
        ref:"attr:FormItem.selectOnClick",
        flags:"IRW",
        description:"Allows the ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnClick','selectOnClick')} behavior to be configured on a\n per-FormItem basis.  Normally all items in a form default to the value of\n ${isc.DocUtils.linkForRef('attr:DynamicForm.selectOnClick')}.",
        name:"selectOnClick",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "focus"
        ]
    },
    "method:TreeGrid.recordDrop":{
        ref:"method:TreeGrid.recordDrop",
        flags:"",
        description:" The superclass event ${isc.DocUtils.linkForRef('method:ListGrid.recordDrop')} does not fire on a TreeGrid, use\n ${isc.DocUtils.linkForRef('method:TreeGrid.folderDrop')} instead.\n\n",
        name:"recordDrop",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "attr:Canvas.backgroundPosition":{
        ref:"attr:Canvas.backgroundPosition",
        flags:"IR",
        description:"Specifies how the background image should be positioned on the widget.\n      It corresponds to the CSS background-position attribute. If unset,\n      no background-position attribute is specified if a background image is\n      specified.",
        name:"backgroundPosition",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "appearance"
        ]
    },
    "attr:FormItem.clipTitle":{
        ref:"attr:FormItem.clipTitle",
        flags:"IRW",
        description:"If the title for this form item is showing, and is too large for the available space\n should the title be clipped?\n <p>\n Null by default - if set to true or false, overrides ${isc.DocUtils.linkForRef('attr:DynamicForm.clipItemTitles')}.",
        name:"clipTitle",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "title"
        ]
    },
    "method:TileGrid.invalidateCache":{
        ref:"method:TileGrid.invalidateCache",
        flags:"",
        description:" Invalidate the current data cache for this databound component via a call to\n the dataset's <code>invalidateCache()</code> method, for example,\n ${isc.DocUtils.linkForRef('method:ResultSet.invalidateCache')}.\n <P>\n <b>NOTE:</b> there is no need to call <code>invalidateCache()</code> when a save operation\n is performed on a DataSource.  Automatic cache synchronization features will automatically\n update caches - see ${isc.DocUtils.linkForRef('class:ResultSet')} for details.  If automatic cache synchronization isn't\n working, troubleshoot the problem using the steps suggested \n <a href='http://forums.smartclient.com/showthread.php?t=8159#aGrid' target='_blank'>in the FAQ</a> rather\n than just calling invalidateCache().  Calling <code>invalidateCache()</code> unnecessarily\n causes extra server load and added code complexity.\n <P>\n Calling <code>invalidateCache()</code> will automatically cause a new fetch to \n be performed with the current set of criteria if data had been previously fetched and the\n component is currently drawn with data visible - there is no need to manually call\n fetchData() after invalidateCache() and this could result in duplicate fetches.  \n <P>\n While data is being re-loaded after a call to <code>invalidateCache()</code>, the widget is\n in a state similar to initial data load - it doesn't know the total length of the dataset\n and any APIs that act on records or row indices will necessarily fail and should not be\n called.  To detect that the widget is in this state, call ${isc.DocUtils.linkForRef('method:ResultSet.lengthIsKnown')}.\n <P>\n <code>invalidateCache()</code> only has an effect is this components dataset is a data\n manager class that manages a cache (eg ResultSet or ResultTree).  If data was provided as a\n simple Array or List, invalidateCache() does nothing.\n \n",
        name:"invalidateCache",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:TileGrid",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "method:Slider.setMaxValueLabel":{
        ref:"method:Slider.setMaxValueLabel",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.maxValueLabel')} property of the slider\n\n",
        name:"setMaxValueLabel",
        seeAlso:[
        ],
        params:[
            {
                description:"new label text",
                optional:false,
                name:"labelText",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "attr:TimeItem.secondMaxValue":{
        ref:"attr:TimeItem.secondMaxValue",
        flags:"IRW",
        description:"When ${isc.DocUtils.linkForRef('attr:TimeItem.useTextField','useTextField')} is false and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondValues','secondValues')} is unset, this attribute specifies the maximum\n value present in the second picker.\n <P>Used for specifying a limited set of valid Second values, or when using the \n TimeItem to record duration, rather than time per-se.  The default is 59.\n <P> See also ${isc.DocUtils.linkForRef('attr:TimeItem.secondMinValue','secondMinValue')} and \n ${isc.DocUtils.linkForRef('attr:TimeItem.secondIncrement','secondIncrement')}.",
        name:"secondMaxValue",
        seeAlso:[
        ],
        valueType:"Number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "method:PortalLayout.setCanResizeRows":{
        ref:"method:PortalLayout.setCanResizeRows",
        deprecated:"Use ${isc.DocUtils.linkForRef('method:PortalLayout.setCanResizePortlets','setCanResizePortlets()')} instead.",
        flags:"",
        description:" Set whether vertical drag-resize of portlets within columns is allowed, and\n update any drawn columns to reflect this.\n",
        name:"setCanResizeRows",
        seeAlso:[
        ],
        params:[
            {
                description:"Whether drag-resize of portlets within columns is allowed",
                optional:false,
                name:"canResize",
                defaultValue:null,
                type:"Boolean"
            }
        ],
        type:"method",
        definingClass:"class:PortalLayout"
    },
    "class:DoubleItem":{
        methods:[
            "method:DoubleItem.getValueAsDouble"
        ],
        ref:"class:DoubleItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        attrs:[
        ],
        description:"TextForm item for managing a text field that displays a decimal value.",
        name:"DoubleItem",
        seeAlso:[
        ],
        type:"class"
    },
    "method:ColumnTree.getIcon":{
        ref:"method:ColumnTree.getIcon",
        flags:"",
        description:" Get the appropriate icon for a node.\n <P>\n By default icons are derived from ${isc.DocUtils.linkForRef('attr:ColumnTree.folderIcon')} and ${isc.DocUtils.linkForRef('attr:ColumnTree.nodeIcon')}.\n Custom icons for individual nodes can be overridden by setting the ${isc.DocUtils.linkForRef('attr:ColumnTree.customIconProperty')}\n on a node.\n <p>\n If you want to suppress icons altogether, provide an override of this method that simply\n returns null.\n <p> \n Note that the full icon URL will be derived by applying ${isc.DocUtils.linkForRef('method:Canvas.getImgURL')} to the\n value returned from this method.\n\n",
        name:"getIcon",
        seeAlso:[
        ],
        params:[
            {
                description:"tree node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"URL for the icon to show for this node",
            type:"URL"
        },
        type:"method",
        definingClass:"class:ColumnTree"
    },
    "attr:HiddenItem.rowSpan":{
        ref:"attr:HiddenItem.rowSpan",
        flags:"IRW",
        description:"hidden fields don't take up any rows",
        name:"rowSpan",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"0",
        type:"attr",
        definingClass:"class:HiddenItem",
        groups:[
            "appearance"
        ]
    },
    "method:DataSource.recordsAsText":{
        ref:"method:DataSource.recordsAsText",
        flags:"",
        description:" Converts a list of Records to simple text formats with a Record per line and values separated\n by a configurable separator, including both tab-separated-values and comma-separated-values\n (aka CSV).\n <P>\n In addition to the <code>settings</code> parameter for this method,\n ${isc.DocUtils.linkForRef('method:DataSourceField.exportForceText')} can be set.  \n <P>\n If two or more different text exports are needed for the same DataSource creating a conflict\n for any DataSourceField setting, ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')} can be used to create a\n child DataSource where these settings can be changed without recapitulating all field\n definitions.\n\n",
        name:"recordsAsText",
        seeAlso:[
        ],
        params:[
            {
                description:"records to convert",
                optional:false,
                name:"records",
                defaultValue:null,
                type:"Array of Record"
            },
            {
                description:"settings for the export",
                optional:true,
                name:"settings",
                defaultValue:null,
                type:"TextExportSettings Properties"
            }
        ],
        returns:{
            description:"records as CSV/TSV (separator can be specified)",
            type:"String"
        },
        type:"method",
        definingClass:"class:DataSource"
    },
    "method:Tree.hasChildren":{
        ref:"method:Tree.hasChildren",
        flags:"",
        description:"\n Returns true if this node has any children.\n\n",
        name:"hasChildren",
        seeAlso:[
        ],
        params:[
            {
                description:"node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"true if the node has children",
            type:"Boolean"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "method:TreeGrid.setOpenState":{
        ref:"method:TreeGrid.setOpenState",
        flags:"",
        description:" Reset this set of open folders within this grid's data to match the \n ${isc.DocUtils.linkForRef('type:TreeGridOpenState')} object passed in.<br>\n Used to restore previous state retrieved from the grid by a call to \n ${isc.DocUtils.linkForRef('method:TreeGrid.getOpenState')}.\n\n",
        name:"setOpenState",
        seeAlso:[
            {
                ref:"method:TreeGrid.getOpenState",
                description:null
            }
        ],
        params:[
            {
                description:"Object describing the desired set of open folders.",
                optional:false,
                name:"openState",
                defaultValue:null,
                type:"TreeGridOpenState"
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid",
        groups:[
            "viewState"
        ]
    },
    "method:DetailViewer.isExportingClientData":{
        ref:"method:DetailViewer.isExportingClientData",
        flags:"",
        description:" Returns true if this component is currently \n ${isc.DocUtils.linkForRef('method:DetailViewer.exportClientData','exporting client data')}.  This method can be called from\n custom cell formatters if you need to return a different formatted value for an export\n than for a live detailViewer\n",
        name:"isExportingClientData",
        seeAlso:[
            {
                ref:"method:ListGrid.exportClientData",
                description:null
            }
        ],
        returns:{
            description:"returns true if this component is currently exporting client data",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:DetailViewer"
    },
    "attr:ListGrid.canPickOmittedFields":{
        ref:"attr:ListGrid.canPickOmittedFields",
        flags:"IR",
        description:"If this grid has a specified ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')}, and\n ${isc.DocUtils.linkForRef('attr:ListGrid.useAllDataSourceFields')} is false, setting this property to true\n will cause all dataSource fields not included in the specified set of fields to\n show up in the ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields','field picker menu item')}.\n <P>\n Has no effect if ${isc.DocUtils.linkForRef('attr:ListGrid.fields')} is unset (as in this case all dataSource fields\n will be displayed by default), or if ${isc.DocUtils.linkForRef('attr:ListGrid.canPickFields')} is false.",
        name:"canPickOmittedFields",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:DSRequest.summaryFunctions":{
        ref:"attr:DSRequest.summaryFunctions",
        flags:"IR",
        description:"A mapping from field names to ${isc.DocUtils.linkForRef('type:SummaryFunction','summary functions')} to be applied\n to each field.\n <p>\n Valid only for an operation of type \"fetch\".  See the \n ${isc.DocUtils.linkForRef('group:serverSummaries','Server Summaries overview')} for examples of usage.",
        name:"summaryFunctions",
        seeAlso:[
            {
                ref:"attr:DSRequest.groupBy",
                description:null
            }
        ],
        valueType:"Object<String,SummaryFunction>",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest",
        groups:[
            "serverSummaries"
        ]
    },
    "attr:ListGrid.bodyOverflow":{
        ref:"attr:ListGrid.bodyOverflow",
        flags:"IRWA",
        description:"Overflow setting for the \"body\", that is, the area of the grid where data values are\n rendered.\n <P>\n By setting both the grid itself and the body to overflow:visible, it is possible to\n \"auto-fit\" to the rendered height or width of the rows.  Note that in this case\n <code>grid.width</code> and <code>grid.height</code> act as minimums.",
        name:"bodyOverflow",
        setter:[
            "setBodyOverflow"
        ],
        seeAlso:[
        ],
        valueType:"Overflow",
        defaultValue:"Canvas.AUTO",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('autofitRows')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "sizing"
        ]
    },
    "attr:Scrollbar.showTrackButtons":{
        ref:"attr:Scrollbar.showTrackButtons",
        flags:"IRA",
        description:"Should the track buttons that allow page scrolling be shown?\n <P>",
        name:"showTrackButtons",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Scrollbar",
        groups:[
            "track"
        ]
    },
    "method:DrawGroup.moveTo":{
        ref:"method:DrawGroup.moveTo",
        flags:"",
        description:" Sets both the left and top coordinates of this <code>DrawGroup</code>'s ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')}.\n Note that this does not move or resize the items in this <code>DrawGroup</code>.\n\n",
        name:"moveTo",
        seeAlso:[
        ],
        params:[
            {
                description:"new left coordinate in pixels",
                optional:false,
                name:"left",
                defaultValue:null,
                type:"int"
            },
            {
                description:"new top coordinate in pixels",
                optional:false,
                name:"top",
                defaultValue:null,
                type:"int"
            }
        ],
        type:"method",
        definingClass:"class:DrawGroup"
    },
    "method:DrawGroup.dragMove":{
        ref:"method:DrawGroup.dragMove",
        flags:"",
        description:" Notification fired for every mouseMove event triggered while the user is dragging this\n DrawGroup. Will only fire if ${isc.DocUtils.linkForRef('attr:DrawItem.canDrag','canDrag')} is true for this group.\n <P>\n Note that if ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is true, this notification will be triggered\n by the user interacting with the specified ${isc.DocUtils.linkForRef('method:DrawGroup.getGroupRect','group rectangle')} for the group.\n If ${isc.DocUtils.linkForRef('attr:DrawGroup.useGroupRect','useGroupRect')} is false, the notification will bubble up from interactions\n with individual items within the group.\n <P>\n Default drag behavior will be to reposition all items in the group (and update the group rectangle).\n",
        name:"dragMove",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to cancel drag interaction.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('dragPan')}"
        ],
        definingClass:"class:DrawGroup",
        groups:[
            "widgetEvents"
        ]
    },
    "method:DrawItem.setFillColor":{
        ref:"method:DrawItem.setFillColor",
        flags:"",
        description:" Update fillColor for this drawItem.\n",
        name:"setFillColor",
        seeAlso:[
        ],
        params:[
            {
                description:"new fillColor to use.  Pass null for transparent.",
                optional:false,
                name:"color",
                defaultValue:null,
                type:"CSSColor"
            }
        ],
        type:"method",
        definingClass:"class:DrawItem"
    },
    "attr:Operator.symbol":{
        ref:"attr:Operator.symbol",
        flags:"IR",
        description:"The text use when using this operator as an \n ${isc.DocUtils.linkForRef('attr:FormItem.allowExpressions','expression')} in a FormItem.",
        name:"symbol",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"allowed",
        definingClass:"object:Operator",
        groups:[
            "advancedFilter"
        ]
    },
    "attr:ImgButton.showFocusedIcon":{
        ref:"attr:ImgButton.showFocusedIcon",
        flags:"IR",
        description:"If using an icon for this button, whether to switch the icon image when the button\n receives focus.\n <P>\n If ${isc.DocUtils.linkForRef('attr:StatefulCanvas.showFocusedAsOver')} is true, the <code>\"Over\"</code> icon will be\n displayed when the canvas has focus, otherwise a separate <code>\"Focused\"</code> icon\n will be displayed",
        name:"showFocusedIcon",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ImgButton",
        groups:[
            "buttonIcon"
        ]
    },
    "type:TopOperatorAppearance":{
        ref:"type:TopOperatorAppearance",
        values:[
            {
                description:"radio buttons appear at the top of the form",
                value:"\"radio\""
            },
            {
                description:"a SelectItem appears with a \"bracket\" spanning all top-level clauses, exactly the same appearance used for showing\n ${isc.DocUtils.linkForRef('attr:FilterBuilder.showSubClauseButton','subClauses')}, if enabled.",
                value:"\"bracket\""
            },
            {
                description:"each line in the FilterBuilder is a top-level item, with a SelectItem shown on the left that allows the user to choose between the main operator in force (either \"and\"\n or \"or\", depending on the setting of topOperator) and \"and not\".",
                value:"\"inline\""
            },
            {
                description:"no interface is shown.  The top-level operator is expected to be shown to the user outside the FilterBuilder, and, if editable, ${isc.DocUtils.linkForRef('method:FilterBuilder.setTopOperator')}\n should be called to update it",
                value:"\"none\""
            }
        ],
        description:"Interface to use for showing and editing the ${isc.DocUtils.linkForRef('attr:FilterBuilder.topOperator','top-level operator')} \n of a FilterBuilder.",
        name:"TopOperatorAppearance",
        seeAlso:[
        ],
        type:"type"
    },
    "method:DataSource.setCacheData":{
        ref:"method:DataSource.setCacheData",
        flags:"",
        description:" Call this method to set the data in the client-side cache after initialization.\n",
        name:"setCacheData",
        seeAlso:[
        ],
        params:[
            {
                description:"Array of records to apply as the client-side cache",
                optional:false,
                name:"data",
                defaultValue:null,
                type:"Array of Record"
            }
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "clientData"
        ]
    },
    "method:DynamicForm.getFields":{
        ref:"method:DynamicForm.getFields",
        flags:"",
        description:" Method to retrieve the ${isc.DocUtils.linkForRef('attr:DynamicForm.fields','items')} for this DynamicForm. \n\n",
        name:"getFields",
        seeAlso:[
        ],
        returns:{
            description:null,
            type:"Array of FormItem"
        },
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "elements"
        ]
    },
    "method:Tree.getPath":{
        ref:"method:Tree.getPath",
        flags:"",
        description:"\n Returns the path of a node - a path has the following format:\n <code>([name][pathDelim]?)*</code>\n <br><br>\n For example, in this tree:\n <pre>\n root\n   foo\n     bar\n </pre>\n Assuming that ${isc.DocUtils.linkForRef('attr:Tree.pathDelim')} is the default <code>/</code>, the <code>bar</code>\n node would have the path <code>root/foo/bar</code> and the path for the <code>foo</code>\n node would be <code>root/foo</code>.\n <br><br>\n Once you have a path to a node, you can call find(path) to retrieve a reference to the node\n later.\n\n",
        name:"getPath",
        seeAlso:[
            {
                ref:"method:Tree.getParentPath",
                description:null
            }
        ],
        params:[
            {
                description:"node in question",
                optional:false,
                name:"node",
                defaultValue:null,
                type:"TreeNode"
            }
        ],
        returns:{
            description:"path to the node",
            type:"string"
        },
        type:"method",
        definingClass:"class:Tree"
    },
    "method:FieldPicker.setAvailableFields":{
        ref:"method:FieldPicker.setAvailableFields",
        flags:"",
        description:" Provides a new set of available fields.\n",
        name:"setAvailableFields",
        seeAlso:[
        ],
        params:[
            {
                description:null,
                optional:false,
                name:"newFields",
                defaultValue:null,
                type:"Array of DataSourceField"
            }
        ],
        type:"method",
        definingClass:"class:FieldPicker"
    },
    "class:Process":{
        methods:[
            "method:Process.getElement",
            "method:Process.start",
            "method:Process.reset",
            "method:Process.setState",
            "method:Process.finished"
        ],
        ref:"class:Process",
        classAttrs:[
        ],
        classMethods:[
            "classMethod:Process.loadProcess",
            "classMethod:Process.getProcess"
        ],
        treeLocation:[
            "Client Reference/Workflow"
        ],
        attrs:[
            "attr:Process.sequences",
            "attr:Process.elements",
            "attr:Process.startElement",
            "attr:Process.wizard",
            "attr:Process.containerId",
            "attr:Process.setState",
            "attr:Process.state",
            "attr:Process.autoStart"
        ],
        description:"A instance of Process represents a stateful process executing a series of Tasks, \n which may be:\n <ul>\n <li> user interactions\n <li> calls to DataSources (hence: any database or web service)\n <li> arbitrary code\n <li> other Processes\n </ul>\n A Process is <i>stateful</i> in the sense that it maintains ${isc.DocUtils.linkForRef('attr:Process.state','state')}\n across the different tasks that are executed.  This allows you to maintain context as you\n walk a user through a multi-step business process in your application, which may involve\n multiple operations on multiple entities.  Each Task that executes can use the Process state\n as inputs, and can output a result which is stored in the Process state - see\n ${isc.DocUtils.linkForRef('group:taskIO')}.\n <P>\n A Process can have multiple branches, choosing the next Task to execute based on\n ${isc.DocUtils.linkForRef('type:Criteria')} - see ${isc.DocUtils.linkForRef('class:XORGateway')} and ${isc.DocUtils.linkForRef('class:DecisionGateway')}.\n <P>\n Because a Process may return to a previous Task in various situations, the data model of a\n Process is strictly speaking a <i>graph</i> (a set of nodes connected by arbitary\n interlinks). However, most processes have sequences of several tasks in a row, and the\n definition format allows these to be represented as simple Arrays called \"sequences\",\n specified via ${isc.DocUtils.linkForRef('attr:Process.sequences')}.  This reduces the need to manually specify IDs and\n interlinks for Tasks that simply proceed to the next task in a sequence.\n <P>\n <b>NOTE:</b> you must load the Workflow module\n ${isc.DocUtils.linkForRef('group:loadingOptionalModules','Optional Modules')} before you can use Process.\n <P>",
        name:"Process",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:AnimateShowEffect.effect":{
        ref:"attr:AnimateShowEffect.effect",
        flags:"IR",
        description:"Effect to apply",
        name:"effect",
        seeAlso:[
        ],
        valueType:"animateShowEffectId",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:AnimateShowEffect"
    },
    "attr:CubeGrid.hideEmptyFacetValues":{
        ref:"attr:CubeGrid.hideEmptyFacetValues",
        flags:"IR",
        description:"This causes the headers for any combination of facetValues for which there are no \n cellRecords to be suppressed.\n <P>\n To use this feature, either:\n <ul>\n <li> all must be provided via ${isc.DocUtils.linkForRef('method:ListGrid.setData','setData()')} before the CubeGrid is first drawn, OR\n <li> all data must be returned by the first DataSource fetch, OR\n <li> ${isc.DocUtils.linkForRef('attr:CubeGrid.hideEmptyAxis')} must be set to either \"row\" or \"column\" so that empty values\n are only automatically hidden for one axis\n </ul>\n This last point is required because there is no way to determine whether a row is empty\n unless data for all columns of the row has been loaded (and vice-versa).  For this\n reason if you set hideEmptyFacetValues but do not set hideEmptyAxis, the default\n behavior of ${isc.DocUtils.linkForRef('class:DataSource','loading only visible data')} is automatically disabled and\n only ${isc.DocUtils.linkForRef('attr:CubeGrid.fixedFacetValues')} will be sent as criteria.",
        name:"hideEmptyFacetValues",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "facetLayout"
        ]
    },
    "attr:ColumnTree.nodeIcon":{
        ref:"attr:ColumnTree.nodeIcon",
        flags:"IRW",
        description:"The filename of the default icon for all leaf nodes in this grid. To specify a \n custom image for an individual node, set the ${isc.DocUtils.linkForRef('attr:ColumnTree.customIconProperty')} directly on\n the node.",
        name:"nodeIcon",
        seeAlso:[
        ],
        valueType:"SCImgURL",
        defaultValue:"\"[SKIN]file.gif\"",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('millerColumns')}"
        ],
        definingClass:"class:ColumnTree",
        groups:[
            "treeIcons"
        ]
    },
    "attr:RelativeDateItem.yearsFromNowTitle":{
        ref:"attr:RelativeDateItem.yearsFromNowTitle",
        flags:"IR",
        description:"The title to show for future periods when the ${isc.DocUtils.linkForRef('type:TimeUnit')} is \"year\".",
        name:"yearsFromNowTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"N years from now\"",
        type:"attr",
        definingClass:"class:RelativeDateItem",
        groups:[
            "i18nMessages"
        ]
    },
    "method:Menu.itemClick":{
        ref:"method:Menu.itemClick",
        flags:"A",
        description:"          Executed when a menu item with no click handler is clicked by the user. This\n          itemClick handler must be specified as a function. It is passed an item parameter that\n          is a reference to the clicked menu item.\n\n",
        name:"itemClick",
        seeAlso:[
        ],
        params:[
            {
                description:"pointer to the item in question",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"object"
            },
            {
                description:"Index of the column clicked by the user. May be null if                                  this menu item was activated in response to a keyboard event.",
                optional:true,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"false if event processing should be stopped, true to continue",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('menuColumns')}"
        ],
        definingClass:"class:Menu"
    },
    "class:SchemaSet":{
        methods:[
            "method:SchemaSet.getSchema"
        ],
        ref:"class:SchemaSet",
        classAttrs:[
        ],
        classMethods:[
            "classMethod:SchemaSet.get"
        ],
        treeLocation:[
            "Client Reference/Data Binding"
        ],
        attrs:[
            "attr:SchemaSet.schemaNamespace"
        ],
        description:"A set of schema derived from the &lt;xsd:schema&gt; element in a WSDL or XML schema file\n loaded by ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadWSDL')} or ${isc.DocUtils.linkForRef('classMethod:XMLTools.loadXMLSchema')}.",
        name:"SchemaSet",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:Canvas.locatePeersType":{
        ref:"attr:Canvas.locatePeersType",
        flags:"IRWA",
        description:"${isc.DocUtils.linkForRef('type:LocatorTypeStrategy')} to use when finding peers of this canvas.",
        name:"locatePeersType",
        seeAlso:[
        ],
        valueType:"LocatorTypeStrategy",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "autoTest"
        ]
    },
    "method:DataBoundComponent.addFormulaField":{
        ref:"method:DataBoundComponent.addFormulaField",
        flags:"",
        description:" Convenience method to display a ${isc.DocUtils.linkForRef('class:FormulaBuilder')} to create a new Formula Field.  This \n is equivalent to calling ${isc.DocUtils.linkForRef('method:DataBoundComponent.editFormulaField','editFormulaField()')} with \n no parameter.\n\n",
        name:"addFormulaField",
        seeAlso:[
        ],
        type:"method",
        definingClass:"interface:DataBoundComponent",
        groups:[
            "formulaFields"
        ]
    },
    "attr:XORGateway.nextElement":{
        ref:"attr:XORGateway.nextElement",
        flags:"IR",
        description:"ID of the next ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} or {process.elements,element} to\n procede to if the criteria match the process state.  If this gateway is part of a\n ${isc.DocUtils.linkForRef('attr:Process.sequences','sequence')} and has a next element in the sequence,\n <code>nextElement</code> does not need to be specified.",
        name:"nextElement",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:XORGateway"
    },
    "method:CubeGrid.saveAllEdits":{
        ref:"method:CubeGrid.saveAllEdits",
        flags:"",
        description:" Save a number of outstanding edits for this CubeGrid. If no cells are specified, all \n outstanding edits will be saved\n",
        name:"saveAllEdits",
        seeAlso:[
        ],
        params:[
            {
                description:"optionally specify which cells to save. Each cell  should be specified as a 2 element array in the format <code>[rowNum,colNum]</code>.",
                optional:true,
                name:"cells",
                defaultValue:null,
                type:"array of 2-element arrays"
            },
            {
                description:"If specified this callback will be fired on a successful save  of the specified rows. Note that if there are no pending edits to be saved this callback will\n  not fire - you can check for this condition using ${isc.DocUtils.linkForRef('method:CubeGrid.hasChanges')} or \n  ${isc.DocUtils.linkForRef('method:CubeGrid.recordHasChanges')}.",
                optional:true,
                name:"saveCallback",
                defaultValue:null,
                type:"callback"
            }
        ],
        returns:{
            description:"true if a save has been initiated (at least one row had changes, passed                   client-side validation, and a save has been attempted).  False otherwise",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "editing"
        ]
    },
    "method:ScriptTask.setOutputData":{
        ref:"method:ScriptTask.setOutputData",
        flags:"",
        description:" Set the task output as specified by ${isc.DocUtils.linkForRef('attr:Task.outputField')}.\n <P>\n NOTE: for an ${isc.DocUtils.linkForRef('attr:ScriptTask.isAsync','asychronous task')}, calling\n <code>setOutputData()</code> indicates the task is complete.  For a task with\n ${isc.DocUtils.linkForRef('attr:Task.outputFieldList','multiple outputs')}, call ${isc.DocUtils.linkForRef('method:ScriptTask.setOutputRecord')} instead.\n",
        name:"setOutputData",
        seeAlso:[
        ],
        params:[
            {
                description:"task output",
                optional:false,
                name:"taskOutput",
                defaultValue:null,
                type:"any"
            }
        ],
        type:"method",
        definingClass:"class:ScriptTask",
        groups:[
            "taskIO"
        ]
    },
    "method:Canvas.dropOut":{
        ref:"method:Canvas.dropOut",
        flags:"A",
        description:"\n Executed when the dragged object is no longer over this drop target, including when the drag\n interaction is ending with a drop on this drop target. If you have set a visual indication \n in dropOver or dropMove, you should reset it to its normal state in dropOut.\n\n",
        name:"dropOut",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('customDrag')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "attr:ListGridField.showFileInline":{
        ref:"attr:ListGridField.showFileInline",
        flags:"IR",
        description:"For a field of type:\"imageFile\", indicates whether to stream the image and display it\n inline or to display the View and Download icons.",
        name:"showFileInline",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField"
    },
    "attr:ListGrid.rowNumberStart":{
        ref:"attr:ListGrid.rowNumberStart",
        flags:"IRWA",
        description:"The number to start the row-count from - default value is 1.",
        name:"rowNumberStart",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"1",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "rowNumberField"
        ]
    },
    "method:TreeGrid.setData":{
        ref:"method:TreeGrid.setData",
        flags:"",
        description:" Set the ${isc.DocUtils.linkForRef('class:Tree')} object this TreeGrid will view and manipulate.\n\n",
        name:"setData",
        seeAlso:[
        ],
        params:[
            {
                description:"Tree to show",
                optional:false,
                name:"newData",
                defaultValue:null,
                type:"Tree"
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "group:sqlConnectionPooling":{
        ref:"group:sqlConnectionPooling",
        title:"SQL Connection Pooling",
        treeLocation:[
            "Concepts/Persistence Technologies"
        ],
        refs:[
        ],
        description:"Many databases will automatically close inactive connections, which can interfere with\n connection pooling: if an application is not constantly using all of the connections in its\n pool, it may retrieve a closed connection from the pool.\n <P>\n In some cases you can disable the behavior of closing inactive connections.  For MySQL it's\n controlled by the\n <a href='http://dev.mysql.com/doc/refman/5.0/en/server-system-variables.html#sysvar_wait_timeout' target='_blank'>wait_timeout</a>\n setting in your my.cnf file).  However, this could potentially cause leaked connections if\n applications terminate without cleaning up their database connections.\n <P>\n Intelligent connection pools compensate for unexpectedly closed connections automatically:\n <ul>\n <li>J2EE containers generally implement internal keepalives or staleness checks - this is\n the preferred solution if available.  If using SQLDataSource, use JNDI-based\n configuration as described ${isc.DocUtils.linkForRef('group:adminConsole','here')}.\n <li>SQLDataSource uses DBCP (Apache Commons) pooling, which also compensates for connection\n closure automatically.  This is enabled by default with appropriate settings, but can be\n disabled system wide via setting <b>sql.pool.enabled</b> to false in\n ${isc.DocUtils.linkForRef('group:server_properties','server.properties')}, or\n disabled for a specific database configuration via <b>sql.<i>dbName</i>.pool.enabled</b>.\n The following properties can also be set on sql.pool / sql.<i>dbName</i>.pool and control\n same-named DBCP properties, however, it is not recommended to set these properties unless\n you have experience with DBCP and are troubleshooting a specific pool-related performance\n problem: testOnBorrow, testOnReturn, testWhileIdle, timeBetweenEvictionRunsMillis,\n minEvictableIdleTimeMillis, numTestsPerEvictionRun.\n <p>\n If you are trying to diagnose an issue related to SQL connection pooling, you can enable\n DEBUG logging for the following classes in <code>log4j.isc.config.xml</code> (see\n installation instructions for details about this file).  All of these classes are in package\n <code>com.isomorphic.sql</code>:\n <ul>\n <li> PoolableSQLConnectionFactory: logs connection creation, and whether or not the\n      connections are pooled\n <li> SQLConnectionManager: logs when connections are borrowed\n <li> SQLDriver: logs the hashCode of the connection when SQL statements are executed\n <li> SQLTransaction: logs transactional open, commit, rollback and close.\n </ul>\n <li>JPA/Hibernate: Hibernate's built-in connection pool is <b>not</b> intended for\n production use according to Hibernate's own documentation.  This includes using JPA with\n Hibernate as the provider. If you get dead connections during development you can disable\n Hibernate's built-in connection pool by setting \"hibernate.connection.pool_size\" to 0. For\n production use you must use production-ready connection pool libraries for example\n C3P0. Here are recommended settings for C3P0 properties:\n <ul>\n <li>c3p0.acquireRetryDelay=1000</li>\n <li>c3p0.acquireRetryAttempts=60</li>\n <li>c3p0.breakAfterAcquireFailure=false</li>\n </ul>\n </li>\n </ul>",
        name:"sqlConnectionPooling",
        seeAlso:[
        ],
        type:"group"
    },
    "method:Canvas.hideComponentMask":{
        ref:"method:Canvas.hideComponentMask",
        flags:"",
        description:" Hide the ${isc.DocUtils.linkForRef('method:Canvas.showComponentMask','component level clickMask')} for this widget\n",
        name:"hideComponentMask",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:Canvas"
    },
    "attr:ListGridField.leaveHeaderMenuButtonSpace":{
        ref:"attr:ListGridField.leaveHeaderMenuButtonSpace",
        flags:"IWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderMenuButton')} is true, when auto-fitting fields to\n the title width via ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitFieldWidths')} or ${isc.DocUtils.linkForRef('attr:ListGridField.autoFitWidth')},\n should the button be sized such that there is enough space for the heeader menu button to\n show without covering the field title?\n <P>\n May be explicitly specified at the ${isc.DocUtils.linkForRef('attr:ListGridField.leaveHeaderMenuButtonSpace','field level')}\n or at the ${isc.DocUtils.linkForRef('attr:ListGrid.leaveHeaderMenuButtonSpace','grid level')}. If not explicitly\n specified space will be left for fields with\n ${isc.DocUtils.linkForRef('attr:ListGridField.align')} set to <code>\"left\"</code> or <code>\"right\"</code>, but not for\n fields with align set to <code>\"center\"</code>.",
        name:"leaveHeaderMenuButtonSpace",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:ListGridField",
        groups:[
            "headerMenuButton"
        ]
    },
    "attr:ListGrid.detailDS":{
        ref:"attr:ListGrid.detailDS",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.canExpandRecords')} is true and ${isc.DocUtils.linkForRef('type:ExpansionMode','listGrid.expansionMode')}\n is <code>\"related\"</code>, this property specifies the dataSource for the\n related records grid to be shown embedded in expanded records.\n <P>\n This property may also be specified on a per-record basis - see\n ${isc.DocUtils.linkForRef('attr:ListGrid.recordDetailDSProperty')}",
        name:"detailDS",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:DateChooser.showFiscalYearChooser":{
        ref:"attr:DateChooser.showFiscalYearChooser",
        flags:"IRW",
        description:"When set to true, show a button that allows the calendar to be navigated by fiscal year.",
        name:"showFiscalYearChooser",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:DataSourceField.valueMapEnum":{
        ref:"attr:DataSourceField.valueMapEnum",
        flags:"IR",
        description:"Fully qualified Java className of an Enum that should be used to derive this field's\n ${isc.DocUtils.linkForRef('type:ValueMap')}.\n <P>\n This has the same behavior of auto-deriving a <code>valueMap</code> from a Java Enum as\n ${isc.DocUtils.linkForRef('attr:DataSource.autoDeriveSchema')} except it applies only to one field.\n <P>\n If you enable <code>autoDeriveSchema</code> there is no need to set\n <code>valueMapEnum</code> for Enum fields unless you want to actually <i>override</i> the\n behavior to use a different Enum for the field (eg, a superclass Enum that is more\n restrictive).",
        name:"valueMapEnum",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:DataSourceField"
    },
    "attr:ListGrid.dragDataAction":{
        ref:"attr:ListGrid.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[
        ],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('gridsDragMove')}",
            "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"
        ],
        definingClass:"class:ListGrid",
        groups:[
            "dragging"
        ]
    },
    "class:EdgedCanvas":{
        methods:[
        ],
        ref:"class:EdgedCanvas",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Foundation"
        ],
        attrs:[
            "attr:EdgedCanvas.skinImgDir",
            "attr:EdgedCanvas.edgeImage",
            "attr:EdgedCanvas.edgeColor",
            "attr:EdgedCanvas.customEdges",
            "attr:EdgedCanvas.showCenter",
            "attr:EdgedCanvas.edgeSize",
            "attr:EdgedCanvas.edgeLeft",
            "attr:EdgedCanvas.edgeRight",
            "attr:EdgedCanvas.edgeTop",
            "attr:EdgedCanvas.edgeBottom",
            "attr:EdgedCanvas.edgeOffset",
            "attr:EdgedCanvas.edgeOffsetTop",
            "attr:EdgedCanvas.edgeOffsetBottom",
            "attr:EdgedCanvas.edgeOffsetLeft",
            "attr:EdgedCanvas.edgeOffsetRight",
            "attr:EdgedCanvas.centerBackgroundColor",
            "attr:EdgedCanvas.edgeStyleName",
            "attr:EdgedCanvas.addEdgeStyleSuffix"
        ],
        description:"EdgedCanvas acts as a decorative, image-based frame around another single Canvas.",
        name:"EdgedCanvas",
        seeAlso:[
        ],
        type:"class",
        groups:[
            "imageEdges"
        ]
    },
    "attr:StateTask.failureElement":{
        ref:"attr:StateTask.failureElement",
        flags:"IR",
        description:"ID of the next sequence or element to proceed to if a failure condition arises, such as\n the output data not being convertible to the target ${isc.DocUtils.linkForRef('attr:StateTask.type')}.",
        name:"failureElement",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:StateTask"
    },
    "attr:Window.canDragReposition":{
        ref:"attr:Window.canDragReposition",
        flags:"IRW",
        description:"If true, this Window may be moved around by the user by dragging on the Window header.  \n Note that if the header is not showing, the Window can't be drag-repositioned regardless\n of this setting.",
        name:"canDragReposition",
        seeAlso:[
            {
                ref:"attr:Window.showHeader",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Window",
        groups:[
            "dragging"
        ]
    },
    "attr:ListGrid.hoverMode":{
        ref:"attr:ListGrid.hoverMode",
        flags:"IRWA",
        description:"When ${isc.DocUtils.linkForRef('attr:ListGrid.showHoverComponents','showHoverComponents')} is true, the builtin mode\n to use when automatically creating a hover component for rows in this grid.\n <P>\n A number of builtin modes are provided - see ${isc.DocUtils.linkForRef('type:HoverMode')}.  You can also override\n ${isc.DocUtils.linkForRef('method:ListGrid.getCellHoverComponent','getCellHoverComponent()')} to provide a custom hover\n widget - in that case, this attribute is ignored.",
        name:"hoverMode",
        seeAlso:[
        ],
        valueType:"HoverMode",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "hoverComponents"
        ]
    },
    "attr:Scrollbar.autoEnable":{
        ref:"attr:Scrollbar.autoEnable",
        flags:"IRWA",
        description:"If true, this scrollbar will automatically enable when the scrollTarget is\n scrollable (i.e., when the contents of the scrollTarget exceed its clip size in the\n direction relevant to this scrollbar), and automatically disable when the\n scrollTarget is not scrollable. Set this property to false for full manual control\n over a scrollbar's enabled state.",
        name:"autoEnable",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Scrollbar"
    },
    "method:Button.setAutoFit":{
        ref:"method:Button.setAutoFit",
        flags:"",
        description:" Setter method for the ${isc.DocUtils.linkForRef('attr:StatefulCanvas.autoFit')} property. Pass in true or false to turn\n autoFit on or off. When autoFit is set to <code>false</code>, canvas will be resized to\n it's previously specified size.\n",
        name:"setAutoFit",
        seeAlso:[
        ],
        params:[
            {
                description:"New autoFit setting.",
                optional:false,
                name:"autoFit",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:Button"
    },
    "method:ListGrid.clearSort":{
        ref:"method:ListGrid.clearSort",
        flags:"A",
        description:"  This method clears any existing sort on this grid by calling ${isc.DocUtils.linkForRef('method:ListGrid.setSort')} with\n a null parameter.  The internal list of ${isc.DocUtils.linkForRef('object:SortSpecifier')}s is removed and the grid is\n unsorted.\n",
        name:"clearSort",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ListGrid"
    },
    "method:Canvas.resizeTo":{
        ref:"method:Canvas.resizeTo",
        flags:"",
        description:"\t\t\tResizes the widget to the specified width and height (moves the right and/ or bottom\n          sides of the widget). The width and height parameters can be expressed as a percentage\n          of viewport size or as the number of pixels.\n",
        name:"resizeTo",
        seeAlso:[
        ],
        params:[
            {
                description:"new width for canvas.",
                optional:true,
                name:"width",
                defaultValue:null,
                type:"number"
            },
            {
                description:"new height for canvas",
                optional:true,
                name:"height",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"whether the size actually changed",
            type:"Boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('resize')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "attr:ListGrid.headerMenuButtonHeight":{
        ref:"attr:ListGrid.headerMenuButtonHeight",
        flags:"IRA",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.showHeaderMenuButton')} is true, this property governs the height of the\n auto-generated <code>headerMenuButton</code>",
        name:"headerMenuButtonHeight",
        seeAlso:[
        ],
        valueType:"measure",
        defaultValue:"\"100%\"",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "headerMenuButton"
        ]
    },
    "attr:DateChooser.prevMonthIconHeight":{
        ref:"attr:DateChooser.prevMonthIconHeight",
        flags:"IR",
        description:"Height of the icon for the previous month button",
        name:"prevMonthIconHeight",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"7",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:Canvas.getInnerHTML":{
        ref:"method:Canvas.getInnerHTML",
        flags:"A",
        description:" Return the inner HTML for this canvas. Called when the canvas is drawn or redrawn;\n override to customize.\n\n",
        name:"getInnerHTML",
        seeAlso:[
        ],
        returns:{
            description:"HTML contents of this canvas",
            type:"HTMLString"
        },
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "drawing"
        ]
    },
    "method:Gauge.setLabelSuffix":{
        ref:"method:Gauge.setLabelSuffix",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Gauge.labelSuffix','labelSuffix')} property and re-creates all sector labels.\n\n",
        name:"setLabelSuffix",
        seeAlso:[
        ],
        params:[
            {
                description:"the new label suffix.",
                optional:false,
                name:"labelSuffix",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        definingClass:"class:Gauge"
    },
    "attr:DateChooser.nextMonthIconRTL":{
        ref:"attr:DateChooser.nextMonthIconRTL",
        flags:"IRW",
        description:"Icon for the next month button",
        name:"nextMonthIconRTL",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "attr:SplitPane.pageOrientation":{
        ref:"attr:SplitPane.pageOrientation",
        flags:"IRW",
        description:"Current ${isc.DocUtils.linkForRef('type:PageOrientation')}.  The default behavior of the <code>SplitPane</code> is to\n register for orientation change notifications from the device (see\n ${isc.DocUtils.linkForRef('classMethod:Page.getOrientation')}) and automatically change orientation based on the\n ${isc.DocUtils.linkForRef('attr:SplitPane.deviceMode','type of device')}.\n <p>\n You can instead set a specific value for <code>pageOrientation</code> if you only want to\n use a specific layout, and not respond to orientation information from the device.",
        name:"pageOrientation",
        setter:[
            "setPageOrientation"
        ],
        seeAlso:[
        ],
        valueType:"PageOrientation",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:SplitPane"
    },
    "method:DetailViewer.exportClientData":{
        ref:"method:DetailViewer.exportClientData",
        flags:"",
        description:" Exports this component's data with client-side formatters applied, so is suitable for direct\n display to users.  See ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData')} for details of the general \n requirements and restrictions when exporting client data.\n <p>\n The following notes apply when exporting client data from DetailViewers:<ul>\n <li>Data is exported in \"grid\" format, with each record shown in a single row and each \n     column representing a single field. This is quite different from the way DetailViewers\n     display records in the browser</li>\n </ul>\n <P>\n If your detailViewer has custom formatters, formatted values will be exported by default, with\n HTML normalized to text where possible.  Since some levels of HTML normalizing aren't \n possible, this may result in missing or incorrect export values.  In this case, you have \n two possible approaches:<ul>\n <li>Set ${isc.DocUtils.linkForRef('attr:DetailViewerField.exportRawValues','exportRawValues')} on the field.  This will export\n     the raw underlying value of the field; your formatter will not be called</li>\n <li>Have your formatter call ${isc.DocUtils.linkForRef('method:DetailViewer.isExportingClientData','isExportingClientData()')}\n     and perform whatever alternative formatting you require if that method returns true</li>\n </ul>\n",
        name:"exportClientData",
        seeAlso:[
            {
                ref:"method:ListGrid.exportClientData",
                description:null
            }
        ],
        params:[
            {
                description:"Request properties for the export.  Note that specifying ${isc.DocUtils.linkForRef('attr:DSRequest.exportData','exportData')} on the request properties\n  allows the developer to pass in an explicit data set to export.",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            },
            {
                description:"Optional callback.  If  you specify ${isc.DocUtils.linkForRef('attr:DSRequest.exportToClient','exportToClient')}: false in the request\n  properties, this callback will fire after export completes.  Otherwise the callback will\n  fire right before the download request is made to the server.",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"RPCCallback"
            }
        ],
        type:"method",
        definingClass:"class:DetailViewer"
    },
    "attr:Toolbar.buttonDefaults":{
        ref:"attr:Toolbar.buttonDefaults",
        flags:"IRWA",
        description:"Settings to apply to all buttons of a toolbar. Properties that can be applied to\n button objects can be applied to all buttons of a toolbar by specifying them in\n buttonDefaults using the following syntax:<br>\n <code>buttonDefaults:{property1:value1, property2:value2, ...}</code><br>\n See the Button Widget Class for standard button properties.",
        name:"buttonDefaults",
        seeAlso:[
            {
                ref:"class:Button",
                description:null
            }
        ],
        valueType:"object",
        defaultValue:"varies",
        type:"attr",
        definingClass:"class:Toolbar",
        groups:[
            "appearance"
        ]
    },
    "attr:FilterBuilder.matchAnyTitle":{
        ref:"attr:FilterBuilder.matchAnyTitle",
        flags:"IR",
        description:"Title for the \"Match Any\" (or) operator\n when using ${isc.DocUtils.linkForRef('type:TopOperatorAppearance','topOperatorAppearance')}:\"radio\".",
        name:"matchAnyTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"Match Any\"",
        type:"attr",
        definingClass:"class:FilterBuilder",
        groups:[
            "i18nMessages"
        ]
    },
    "type:DrawPosition":{
        ref:"type:DrawPosition",
        values:[
            {
                description:"insert before the target element",
                value:"\"beforeBegin\""
            },
            {
                description:"insert as the target element's first child",
                value:"\"afterBegin\""
            },
            {
                description:"insert as the target element's last child",
                value:"\"beforeEnd\""
            },
            {
                description:"insert after the target element",
                value:"\"afterEnd\""
            },
            {
                description:"replace the target element",
                value:"\"replace\""
            }
        ],
        description:null,
        name:"DrawPosition",
        seeAlso:[
        ],
        type:"type"
    },
    "attr:ListGrid.animateFolderEffect":{
        ref:"attr:ListGrid.animateFolderEffect",
        flags:"IRW",
        description:"When animating folder opening / closing, this property can be set to apply an\n animated acceleration effect. This allows the animation speed to be \"weighted\", for\n example expanding or collapsing at a faster rate toward the beginning of the animation\n than at the end.\n <P>\n For a ListGrid, this property applies when ${isc.DocUtils.linkForRef('attr:ListGrid.canGroupBy','grouping')} is enabled.",
        name:"animateFolderEffect",
        seeAlso:[
        ],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "animation"
        ]
    },
    "attr:FormItem.showFocusedIcons":{
        ref:"attr:FormItem.showFocusedIcons",
        flags:"IRWA",
        description:"If we're showing icons, should we change their image source to the appropriate\n  <i>focused</i>  source when this item has focus?  Can be overridden on a per\n  icon basis by the formItemIcon <code>showFocused</code> property.",
        name:"showFocusedIcons",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "formIcons"
        ]
    },
    "attr:Menu.showIcons":{
        ref:"attr:Menu.showIcons",
        flags:"IRW",
        description:"A boolean, indicating whether the checkmark/custom icon column should be displayed.",
        name:"showIcons",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:Menu"
    },
    "method:Slider.setThumbSrc":{
        ref:"method:Slider.setThumbSrc",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.thumbSrc')} property of the slider\n\n",
        name:"setThumbSrc",
        seeAlso:[
        ],
        params:[
            {
                description:"new thumbSrc",
                optional:false,
                name:"newSrc",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "attr:PortalLayout.rowLayout":{
        ref:"attr:PortalLayout.rowLayout",
        flags:"A",
        description:"Automatically generated vertical ${isc.DocUtils.linkForRef('class:Layout')} used to create columns of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')} via\n ${isc.DocUtils.linkForRef('method:Class.createAutoChild','createAutoChild()')}. Since this is an ${isc.DocUtils.linkForRef('type:AutoChild')}, you can use \n rowLayoutDefaults and rowLayoutProperties to customize the layout used to contain the rows.\n <p>\n The rowLayout is the actual container for ${isc.DocUtils.linkForRef('attr:PortalLayout.row','rows')} of ${isc.DocUtils.linkForRef('class:Portlet','Portlets')}. See ${isc.DocUtils.linkForRef('attr:PortalLayout.column','column')} for\n the column as a whole, which may include a menu as well (depending on ${isc.DocUtils.linkForRef('attr:PortalLayout.showColumnMenus','showColumnMenus')}).\n If you want to style the columns as a whole,\n use columnDefaults or columnProperties, but if you want to style the layout that actually contains the\n rows, use rowLayoutDefaults or rowLayoutProperties.",
        name:"rowLayout",
        seeAlso:[
            {
                ref:"attr:PortalLayout.rowLayout",
                description:null
            },
            {
                ref:"attr:PortalLayout.row",
                description:null
            }
        ],
        valueType:"MultiAutoChild Layout",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:PortalLayout"
    },
    "attr:RelativeDateItem.rangePosition":{
        ref:"attr:RelativeDateItem.rangePosition",
        flags:"IRWA",
        description:"Does this items relative date value refer to the start or end of the chosen date? Useful\n when using this item to generate filter criteria, such as the from or to value for an\n inclusive range.\n <P>\n If unset \"start\" is assumed.",
        name:"rangePosition",
        seeAlso:[
            {
                ref:"attr:RelativeDateItem.operator",
                description:null
            },
            {
                ref:"attr:RelativeDateItem.rangeRoundingGranularity",
                description:null
            }
        ],
        valueType:"RelativeDateRangePosition",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:RelativeDateItem"
    },
    "method:CubeGrid.getEditedCell":{
        ref:"method:CubeGrid.getEditedCell",
        flags:"",
        description:" Returns the current value of a cell. If the cell has an outstanding edit value, this will\n be returned, otherwise the underlying value of the record will be returned.\n\n",
        name:"getEditedCell",
        seeAlso:[
        ],
        params:[
            {
                description:"rowNum of the record being edited, or an Object                                      containing values for all the record's primary keys",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"number | Object"
            },
            {
                description:"colNum of the cell. Only required if the first parameter is                              a rowNum",
                optional:false,
                name:"colNum",
                defaultValue:null,
                type:"number"
            }
        ],
        returns:{
            description:"Current edit value, or underlying value for the cell.",
            type:"any"
        },
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "editing"
        ]
    },
    "method:TreeGrid.exportClientData":{
        ref:"method:TreeGrid.exportClientData",
        flags:"",
        description:" Exports this component's data with client-side formatters applied, so is suitable for direct\n display to users.  See ${isc.DocUtils.linkForRef('method:ListGrid.exportClientData')} for details of the general \n requirements and restrictions when exporting client data.\n <p>\n The following notes apply when exporting client data from TreeGrids:<ul>\n <li>Export only works correctly if you specify ${isc.DocUtils.linkForRef('attr:TreeGrid.fields','fields')}; if you allow it to\n     generate a ${isc.DocUtils.linkForRef('attr:TreeGrid.createDefaultTreeField','default field')}, nothing will be exported</li>\n <li>Only visible nodes are exported; if you close a node, its children are not exported \n     even if they are loaded and known to the client</li>\n <li>Tree nodes are exported as a flat list, in the same order they are displayed in the \n     TreeGrid</li>\n </ul>\n <P>\n If your TreeGrid has custom formatters, formatted values will be exported by default, with\n HTML normalized to text where possible.  Since some levels of HTML normalizing aren't \n possible, this may result in missing or incorrect export values.  In this case, you have \n two possible approaches:<ul>\n <li>Set ${isc.DocUtils.linkForRef('attr:ListGridField.exportRawValues','exportRawValues')} on the field.  This will export\n     the raw underlying value of the field; your formatter will not be called</li>\n <li>Have your formatter call ${isc.DocUtils.linkForRef('method:TreeGrid.isExportingClientData','isExportingClientData()')}\n     and perform whatever alternative formatting you require if that method returns true</li>\n </ul>\n",
        name:"exportClientData",
        seeAlso:[
            {
                ref:"method:ListGrid.exportClientData",
                description:null
            }
        ],
        params:[
            {
                description:"Request properties for the export.  Note that specifying ${isc.DocUtils.linkForRef('attr:DSRequest.exportData','exportData')} on the request properties\n  allows the developer to pass in an explicit data set to export.",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            },
            {
                description:"Optional callback.  If  you specify ${isc.DocUtils.linkForRef('attr:DSRequest.exportToClient','exportToClient')}: false in the request\n  properties, this callback will fire after export completes.  Otherwise the callback will\n  fire right before the download request is made to the server.",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"RPCCallback"
            }
        ],
        type:"method",
        definingClass:"class:TreeGrid"
    },
    "attr:FilterBuilder.radioOptions":{
        ref:"attr:FilterBuilder.radioOptions",
        deprecated:"in favor of ${isc.DocUtils.linkForRef('attr:FilterBuilder.topOperatorOptions')}.",
        flags:"IR",
        description:"Logical operators to allow if we have a ${isc.DocUtils.linkForRef('type:TopOperatorAppearance')} of \"radio\".",
        name:"radioOptions",
        seeAlso:[
        ],
        valueType:"Array of OperatorId",
        defaultValue:"[\"and\", \"or\", \"not\"]",
        type:"attr",
        definingClass:"class:FilterBuilder"
    },
    "object:FormItemEventInfo":{
        methods:[
        ],
        ref:"object:FormItemEventInfo",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Forms/DynamicForm"
        ],
        attrs:[
            "attr:FormItemEventInfo.item",
            "attr:FormItemEventInfo.overItem",
            "attr:FormItemEventInfo.overTitle",
            "attr:FormItemEventInfo.icon"
        ],
        description:"An object containing details for mouse events occurring over a FormItem.",
        name:"FormItemEventInfo",
        seeAlso:[
        ],
        type:"object"
    },
    "method:TimeItem.setMilliseconds":{
        ref:"method:TimeItem.setMilliseconds",
        flags:"A",
        description:" Set the milliseconds value of this TimeItem.\n",
        name:"setMilliseconds",
        seeAlso:[
        ],
        params:[
            {
                description:"new milliseconds value for this TimeItem.",
                optional:false,
                name:"milliseconds",
                defaultValue:null,
                type:"Number"
            }
        ],
        type:"method",
        definingClass:"class:TimeItem"
    },
    "attr:FormItem.filterLocally":{
        ref:"attr:FormItem.filterLocally",
        flags:"IRA",
        description:"If this form item is mapping data values to a display value by fetching records from a \n dataSource (see ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource')}, ${isc.DocUtils.linkForRef('attr:FormItem.displayField')} \n and ${isc.DocUtils.linkForRef('attr:FormItem.fetchMissingValues')}), setting this property to true ensures that when\n the form item value is set, entire data-set from the dataSource is loaded at once and \n used as a valueMap, rather than just loading the display value for the current value.\n This avoids the need to perform fetches each time setValue() is called with a new value.\n <P>\n See also ${isc.DocUtils.linkForRef('attr:PickList.filterLocally')} for behavior on form items such as SelectItems\n that show pick-lists.",
        name:"filterLocally",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem",
        groups:[
            "display_values"
        ]
    },
    "method:CubeGrid.getSelectedCellIds":{
        ref:"method:CubeGrid.getSelectedCellIds",
        flags:"",
        description:"  Returns an array of the IDs of all selected cell records.\n\n  <br><i>methodType</i> getter\n",
        name:"getSelectedCellIds",
        seeAlso:[
        ],
        returns:{
            description:"array of the selected cell IDs",
            type:"Array of String"
        },
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "selection"
        ]
    },
    "attr:Canvas.matchElement":{
        ref:"attr:Canvas.matchElement",
        flags:"IRWA",
        description:"If ${isc.DocUtils.linkForRef('attr:Canvas.htmlElement')} is specified, should this canvas initially be drawn\n at the same dimensions as the htmlElement?<br>\n Note: setting this property will not force the canvas to resize if the element\n subsequently resizes (for example due to page reflow).",
        name:"matchElement",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas"
    },
    "attr:DSRequest.exportFooter":{
        ref:"attr:DSRequest.exportFooter",
        flags:"IR",
        description:"Optional text to appear at the end of the file.",
        name:"exportFooter",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DSRequest"
    },
    "attr:ListGrid.filterLocalData":{
        ref:"attr:ListGrid.filterLocalData",
        flags:"IRW",
        description:"If this grid has its ${isc.DocUtils.linkForRef('method:ListGrid.setData','data property')} set to a static array\n of records, should ${isc.DocUtils.linkForRef('method:ListGrid.filterData')} filter this array?\n If this property is set to true, the local data array will be filtered according to\n the specified criteria, and the results displayed. If false, a normal databound\n fetch will occur, retriving records that match the specified criteria from this\n component's ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')}.\n <P>\n If this property is not explicitly set, default behavior will filter against the\n dataSource unless the grid has a specified ${isc.DocUtils.linkForRef('type:DataPath','dataPath')}, in which case\n filtering will occur locally.\n <P>\n Note that a specified ${isc.DocUtils.linkForRef('attr:ListGrid.dataSource')} is required for filtering to occur\n even when filtering a local data array.",
        name:"filterLocalData",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:List.getValueMap":{
        ref:"method:List.getValueMap",
        flags:"",
        description:" Get a map of the form <code>{ item[idField] -&gt; item[displayField] }</code>, for all \n items in the list.  Note that if more than one item has the same <code>idProperty</code>, \n the value for the later item in the list will clobber the value for the earlier item.\n\n",
        name:"getValueMap",
        seeAlso:[
        ],
        params:[
            {
                description:"Property to use as ID (data value) in the valueMap",
                optional:false,
                name:"idField",
                defaultValue:null,
                type:"string"
            },
            {
                description:"Property to use a display value in the valueMap",
                optional:false,
                name:"displayField",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"valueMap object",
            type:"object"
        },
        type:"method",
        definingClass:"interface:List"
    },
    "attr:RelativeDateItem.endDate":{
        ref:"attr:RelativeDateItem.endDate",
        flags:"IRW",
        description:"Maximum date the selectors will allow the user to pick.\n <P>\n See ${isc.DocUtils.linkForRef('attr:DateItem.startDate')} for details on how this restriction works.",
        name:"endDate",
        seeAlso:[
        ],
        valueType:"Date",
        defaultValue:"12/31/2020",
        type:"attr",
        definingClass:"class:RelativeDateItem",
        groups:[
            "appearance"
        ]
    },
    "method:ListGrid.recordClick":{
        ref:"method:ListGrid.recordClick",
        flags:"",
        description:" Executed when the listGrid receives a 'click' event on an enabled, non-separator\n record. The default implementation does nothing -- override to perform some action\n when any record or field is clicked.<br>\n A record event handler can be specified either as\n a function to execute, or as a string of script to evaluate. If the handler is defined\n as a string of script, all the parameters below will be available as variables for use\n in the script.<br>\n To do something specific if a particular field is clicked, add a recordClick\n method or string of script to that field (same parameters) when you're setting up\n the list.<br>\n <b>Notes:</b><ul>\n <li>This will not be called if the click is below the last item of the list.</li>\n <li>This method is called from the default implementation of\n ${isc.DocUtils.linkForRef('method:ListGrid.rowClick')}, so if that method is overridden\n this method may not be fired.</li></ul>\n\n",
        name:"recordClick",
        seeAlso:[
            {
                ref:"method:ListGrid.rowClick",
                description:null
            }
        ],
        params:[
            {
                description:"the listGrid that contains the click event",
                optional:false,
                name:"viewer",
                defaultValue:null,
                type:"ListGrid"
            },
            {
                description:"the record that was clicked on",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridRecord"
            },
            {
                description:"number of the record clicked on in the current set of                                  displayed records (starts with 0)",
                optional:false,
                name:"recordNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"the field that was clicked on (field definition)",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"ListGridField"
            },
            {
                description:"number of the field clicked on in the listGrid.fields                                  array",
                optional:false,
                name:"fieldNum",
                defaultValue:null,
                type:"number"
            },
            {
                description:"value of the cell (after valueMap, etc. applied)",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"raw value of the cell (before valueMap, etc applied)",
                optional:false,
                name:"rawValue",
                defaultValue:null,
                type:"any"
            }
        ],
        returns:{
            description:"return false to cancel default behavior",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "events"
        ]
    },
    "method:Menu.setItemTitle":{
        ref:"method:Menu.setItemTitle",
        flags:"",
        description:" Sets the title of a particular menu item to the string specified by newTitle and\n redraws the menu if necessary.\n\n",
        name:"setItemTitle",
        seeAlso:[
        ],
        params:[
            {
                description:"MenuItem in question, or it's index",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"MenuItem or number"
            },
            {
                description:"new title",
                optional:false,
                name:"newTitle",
                defaultValue:null,
                type:"string"
            }
        ],
        returns:{
            description:"true if the title was changed, and false otherwise",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Menu"
    },
    "attr:ServerObject.attributeScope":{
        ref:"attr:ServerObject.attributeScope",
        flags:"IR",
        description:"Specifies the scope in which the DMI instance is to be looked up.  Valid values are: \n <code>\"request\"</code>, <code>\"session\"</code>, and <code>\"application\"</code>.  If\n <code>attributeScope</code> is left out of the <code>ServerObject</code> definition, then\n all scopes are searched in the order in which they are listed above.\n <p>\n This attribute is consulted only when the value of ${isc.DocUtils.linkForRef('attr:ServerObject.lookupStyle')} is\n <code>\"attribute\"</code>.",
        name:"attributeScope",
        seeAlso:[
            {
                ref:"attr:ServerObject.attributeName",
                description:null
            },
            {
                ref:"attr:ServerObject.lookupStyle",
                description:null
            }
        ],
        valueType:"\"request\"|\"session\"|\"application\"",
        defaultValue:"null",
        type:"attr",
        serverDS:"only",
        definingClass:"class:ServerObject"
    },
    "classAttr:RPCRequest.useCursorTracker":{
        ref:"classAttr:RPCRequest.useCursorTracker",
        flags:"IRW",
        description:"If true, an image is shown to the right of the cursor when ${isc.DocUtils.linkForRef('attr:RPCRequest.promptStyle')} is\n set to \"cursor\", otherwise the cursor itself is modified via css to the value of\n ${isc.DocUtils.linkForRef('attr:RPCRequest.promptCursor')}.  The default is platform-dependent.  In Safari, IE 5.5 and\n Firefox 1.0 the default is true, on all other platforms it is false.  The reason for this\n split is that the above browsers require that the cursor move before CSS settings are\n re-evaluated - this means the progress cursor can stick until the user moves the mouse.\n <p>\n If left unspecified, the default value is set by ${isc.DocUtils.linkForRef('classAttr:RPCManager.useCursorTracker')}.",
        name:"useCursorTracker",
        seeAlso:[
            {
                ref:"classAttr:RPCManager.useCursorTracker",
                description:null
            }
        ],
        valueType:"boolean",
        defaultValue:"platform-dependent",
        type:"classAttr",
        definingClass:"class:RPCRequest",
        groups:[
            "rpcPrompt"
        ]
    },
    "type:XPathExpression":{
        ref:"type:XPathExpression",
        description:"A standard XPath expression as a string. To learn about XPath, try the following search:\n <a href=\"http://www.google.com/search?q=xpath+tutorial\" target=\"_blank\"\n >http://www.google.com/search?q=xpath+tutorial</a>",
        name:"XPathExpression",
        seeAlso:[
        ],
        type:"type"
    },
    "method:Applet.getPluginHandle":{
        ref:"method:Applet.getPluginHandle",
        flags:"A",
        description:" \n",
        name:"getPluginHandle",
        seeAlso:[
        ],
        returns:{
            description:"Returns a handle to the applet DOM element (valid only after the component has been drawn).",
            type:"DOMElement"
        },
        type:"method",
        definingClass:"class:Applet"
    },
    "method:StretchImgButton.getState":{
        ref:"method:StretchImgButton.getState",
        flags:"",
        description:" Return the state of this StatefulCanvas\n",
        name:"getState",
        seeAlso:[
        ],
        returns:{
            description:null,
            type:"State"
        },
        type:"method",
        definingClass:"class:StretchImgButton",
        groups:[
            "state"
        ]
    },
    "method:DataSource.fetchData":{
        ref:"method:DataSource.fetchData",
        flags:"",
        description:" Perform a \"fetch\" DataSource operation against this DataSource, sending search criteria\n and retrieving matching records.\n <P>\n <b>NOTE:</b> do not attempt to override this method to create a custom DataSource.  For\n a server-side custom DataSource, use the ${isc.DocUtils.linkForRef('attr:DataSource.serverConstructor')} attribute,\n and the ${isc.DocUtils.linkForExampleId('customDataSource', 'Custom DataSource samples')}.  For a\n client-side custom DataSource, see ${isc.DocUtils.linkForRef('attr:DataSource.dataProtocol','dataProtocol:\"custom\"')}.\n <P>\n In contrast to ${isc.DocUtils.linkForRef('method:ListGrid.fetchData')}, which creates a ${isc.DocUtils.linkForRef('class:ResultSet')} to manage\n the returned data, calling <code>dataSource.fetchData()</code> provides the returned\n data in the callback as a \n <smartclient>simple JavaScript Array of JavaScript Objects.</smartclient>\n <smartgwt>RecordList or simple Array of Record objects.</smartgwt>  Calling\n <code>dataSource.fetchData()</code> does not automatically update any visual components or\n caches: code in the callback passed to <code>fetchData()</code> decides what to do with\n the returned data. \n <P>\n For example, given a ListGrid \"myGrid\" and a DataSource \"employees\", the following code\n would populate \"myGrid\" with data fetched from the DataSource:\n <pre>\n    <smartclient>isc.DataSource.get(\"employees\").fetchData(null, \"myGrid.setData(data)\");</smartclient>\n    <smartgwt>DataSource.get(\"employees\").fetchData(null, new DSCallback() {\n        public void execute(DSResponse response, Object rawData, DSRequest request) {\n            myGrid.setData(response.getData());\n        }\n    });</smartgwt>\n </pre>\n Unlike calling <code>myGrid.fetchData()</code>, which creates a ${isc.DocUtils.linkForRef('class:ResultSet')}, the\n data provided to the grid is \"disconnected\" data, unmanaged by SmartClient's databinding\n facilities and safe to directly modify.  This is useful when, for example, a ListGrid is\n being used as a more sophisticated version of HTML's multi-select component.\n <P>\n Disconnected datasets may be used to populate various visual components.  For example,\n while an individual FormItem can be configured to fetch\n ${isc.DocUtils.linkForRef('attr:FormItem.valueMap','valueMap')} options from a DataSource via the\n ${isc.DocUtils.linkForRef('attr:FormItem.optionDataSource','optionDataSource')} property, the following code shows\n storing a dataset to derive valueMaps from later:\n <pre>\n    <smartclient>\n    isc.DataSource.get(\"countries\").fetchData(null, \"window.countries = data\");\n\n    ... later, a form is created dynamically ...\n\n    function showForm() {\n       isc.DynamicForm.create({\n           items : [\n              { name:\"country\", title:\"Pick Country\",\n                valueMap: window.countries.getValueMap(\"countryId\", \"countryName\")\n              },\n       ...\n    </smartclient>\n    <smartgwt>\n      // Assume GlobalStore.allCountries is a public static variable of type RecordList \n      DataSource.get(\"countries\").fetchData(null, new DSCallback(){\n         public void execute(DSResponse response, Object rawData, DSRequest request) {\n            GlobalStore.allCountries = response.getDataAsRecordList();\n         }\n      });\n      ... later, while a DynamicForm is being created ...    \n      SelectItem select = new SelectItem(\"country\", \"Pick Country\");\n      Map valueMap = GlobalStore.countries.getValueMap(\"countryId\", \"countryName\");\n      myItem.setValueMap(new LinkedHashMap(valueMap));\n    </smartgwt>\n </pre>\n <P>\n You can also create a ResultSet from the data retrieved from <code>fetchData()</code>,\n like so:\n <pre>\n    <smartclient>\n    isc.DataSource.get(\"countries\").fetchData(null,\n        function (dsResponse, data) {\n            isc.ResultSet.create({\n                dataSource:\"countries\",\n                allRows:data\n            })\n        }\n    )\n    </smartclient>\n    <smartgwt>\n    DataSource.get(\"countries\").fetchData(null, new DSCallback() {\n        public void execute(DSResponse response, Object rawData, DSRequest request) {\n            ResultSet rs = new ResultSet(DataSource.get(\"countries\"));\n            rs.setAllRows(response.getData());\n        }\n    });\n    </smartgwt>\n </pre>\n <P>\n This gives you a dataset that supports client-side filtering (via\n ${isc.DocUtils.linkForRef('method:ResultSet.setCriteria','setCriteria()')}), can provide \n ${isc.DocUtils.linkForRef('method:ResultSet.getValueMap','filtered valueMaps')}, will \n ${isc.DocUtils.linkForRef('attr:ResultSet.disableCacheSync','automatically reflect updates')} to the DataSource made via\n other components, and can be re-used with multiple visual components.\n <P>\n See also ${isc.DocUtils.linkForRef('method:DataSource.getClientOnlyDataSource')} and ${isc.DocUtils.linkForRef('attr:DataSource.cacheAllData')} for\n similar capabilities for dealing with smaller datasets entirely within the browser, or working\n with modifiable caches representing subsets of the data available from a DataSource.\n <P>\n See also the server-side com.isomorphic.js.JSTranslater class in the\n ${isc.DocUtils.linkForDocNode('javaServerReference', 'Java Server Reference')} for other, similar approaches\n involving dumping data into the page during initial page load.  <b>Note:</b> care should\n be taken when using this approach.  Large datasets degrade the basic performance of some\n browsers, so use ${isc.DocUtils.linkForRef('attr:PickList.optionDataSource','optionDataSource')} and similar\n facilities to manage datasets that may become very large.\n <P>\n <b>Data-Driven Visual Component Creation</b>\n <P>\n <smartclient>\n <code>DataSource.fetchData()</code> can also be used to create SmartClient components in\n a data-driven way.  Many properties on SmartClient visual components are configured via\n an Array of Objects - the same data format that <code>dataSource.fetchData()</code>\n returns.  These include ${isc.DocUtils.linkForRef('attr:ListGrid.fields')}, ${isc.DocUtils.linkForRef('attr:TabSet.tabs')},\n ${isc.DocUtils.linkForRef('attr:DynamicForm.items')}, ${isc.DocUtils.linkForRef('attr:Facet.values')} and even ${isc.DocUtils.linkForRef('attr:DataSource.fields')}.\n <P>\n For example, if you had a DataSource \"myFormFields\" whose fields included the\n basic properties of ${isc.DocUtils.linkForRef('class:FormItem','FormItems')} (name, title, type, etc), this example\n code would create a form based on stored field definitions, loaded from the\n \"myFormFields\" DataSource on the fly:\n <pre>\n    isc.DataSource.get(\"myFormFields\").fetchData(null, \n        \"isc.DynamicForm.create({ items:data })\"\n    )\n </pre>\n </smartclient>\n <smartgwt>\n <code>DataSource.fetchData()</code> can also be used to create Smart GWT components in a\n data-driven way.  For example, if you had a DataSource \"myGridFields\" whose fields included the\n basic properties of {@link com.smartgwt.client.widgets.grid.ListGridField} (name, title, type,\n etc), this example code would create a form based on stored field definitions, loaded from the\n \"myFormFields\" DataSource on the fly: \n <pre>    \n   DataSource.get(\"myFormFields\").fetchData(null, new DSCallback(){\n       public void execute(DSResponse response, Object rawData, DSRequest request) {\n          Record[] records = response.getData();\n          ListGridField[] fields = new ListGridField[records.length];\n          for (Record record in records) {\n              ListGridField field = new ListGridField();\n              field.setName(record.getAttribute(\"name\"));\n              field.setTitle(record.getAttribute(\"title\"));\n              field.setType(ListGridFieldType.valueOf(record.getAttribute(\"type\")));\n          }\n          ListGrid grid = new ListGrid();\n          grid.setFields(fields);\n       }\n   });\n </pre>  \n </smartgwt>\n This capability to dynamically create visual components from dynamically fetched data\n provides a foundation for creating interfaces that can be customized by end users.\n See also the server-side API com.isomorphic.datasource.DataSource.addDynamicDSGenerator() for\n dynamically creating DataSources supporting all server-side DataSource features, and\n ${isc.DocUtils.linkForRef('attr:DataSource.inheritsFrom')} for sharing field definitions across multiple DataSources.\n\n",
        name:"fetchData",
        seeAlso:[
        ],
        params:[
            {
                description:"search criteria",
                optional:true,
                name:"criteria",
                defaultValue:null,
                type:"Criteria"
            },
            {
                description:"callback to invoke on completion",
                optional:true,
                name:"callback",
                defaultValue:null,
                type:"DSCallback"
            },
            {
                description:"additional properties to set on                                                       the DSRequest that will be issued",
                optional:true,
                name:"requestProperties",
                defaultValue:null,
                type:"DSRequest Properties"
            }
        ],
        type:"method",
        definingClass:"class:DataSource",
        groups:[
            "operations"
        ]
    },
    "classAttr:Log.defaultPriority":{
        ref:"classAttr:Log.defaultPriority",
        flags:"IRWA",
        getter:[
            "getDefaultPriority"
        ],
        description:"Any logs below this priority will be suppressed, unless a more specific setting exists for\n the category.",
        name:"defaultPriority",
        setter:[
            "setDefaultPriority"
        ],
        seeAlso:[
            {
                ref:"classMethod:Log.setPriority",
                description:null
            }
        ],
        valueType:"LogPriority",
        defaultValue:"Log.WARN",
        type:"classAttr",
        definingClass:"class:Log"
    },
    "classAttr:Operators.notEqualTitle":{
        ref:"classAttr:Operators.notEqualTitle",
        flags:"IR",
        description:"Title for the \"notEqual\" operator",
        name:"notEqualTitle",
        seeAlso:[
        ],
        valueType:"String",
        defaultValue:"\"not equal\"",
        type:"classAttr",
        definingClass:"class:Operators",
        groups:[
            "i18nMessages"
        ]
    },
    "method:ScriptTask.getInputData":{
        ref:"method:ScriptTask.getInputData",
        flags:"",
        description:" Get the inputs to this task as specified by ${isc.DocUtils.linkForRef('attr:Task.inputField')}.\n <P>\n For a task with a ${isc.DocUtils.linkForRef('attr:Task.inputFieldList','inputFieldList')}, use ${isc.DocUtils.linkForRef('method:ScriptTask.getInputRecord')}\n to get access to other inputs.\n",
        name:"getInputData",
        seeAlso:[
        ],
        returns:{
            description:"input data",
            type:"any"
        },
        type:"method",
        definingClass:"class:ScriptTask",
        groups:[
            "taskIO"
        ]
    },
    "attr:DateChooser.todayButtonTitle":{
        ref:"attr:DateChooser.todayButtonTitle",
        flags:"IRW",
        description:"Title for \"Today\" button.",
        name:"todayButtonTitle",
        seeAlso:[
        ],
        valueType:"string",
        defaultValue:"\"Today\"",
        type:"attr",
        definingClass:"class:DateChooser",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:CubeGrid.facetValueHoverWidth":{
        ref:"attr:CubeGrid.facetValueHoverWidth",
        flags:"IRWA",
        description:"If specified and <code>this.showHover</code> is true, this is the default width to apply\n to hover tips shown for facetValues. If unset, the hover canvas will be sized to \n <code>this.hoverWidth</code> if specified instead.",
        name:"facetValueHoverWidth",
        seeAlso:[
            {
                ref:"attr:Canvas.hoverWidth",
                description:null
            }
        ],
        valueType:"measure",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:CubeGrid",
        groups:[
            "hoverTips"
        ]
    },
    "attr:Canvas.skinImgDir":{
        ref:"attr:Canvas.skinImgDir",
        flags:"IRWA",
        description:"Default directory for skin images (those defined by the class), relative to the\n Page-wide ${isc.DocUtils.linkForRef('classMethod:Page.getSkinDir','skinDir')}.",
        name:"skinImgDir",
        seeAlso:[
        ],
        valueType:"URL",
        defaultValue:"\"images/\"",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "images"
        ]
    },
    "attr:DetailViewerField.hiliteIconRightPadding":{
        ref:"attr:DetailViewerField.hiliteIconRightPadding",
        flags:"IRW",
        description:"How much padding should there be on the right of ${isc.DocUtils.linkForRef('attr:DetailViewer.hiliteIcons','hilite icons')} \n for this field?\n Overrides ${isc.DocUtils.linkForRef('attr:DetailViewer.hiliteIconRightPadding')}",
        name:"hiliteIconRightPadding",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"object:DetailViewerField",
        groups:[
            "hiliting"
        ]
    },
    "classAttr:Dialog.NO_BUTTON_TITLE":{
        ref:"classAttr:Dialog.NO_BUTTON_TITLE",
        flags:"IRW",
        description:"Title for the <code>\"No\"</code> button.",
        name:"NO_BUTTON_TITLE",
        seeAlso:[
            {
                ref:"type:DialogButtons",
                description:null
            }
        ],
        valueType:"HTML",
        defaultValue:"\"No\"",
        type:"classAttr",
        definingClass:"class:Dialog",
        groups:[
            "i18nMessages"
        ]
    },
    "attr:ListGrid.autoFitMaxHeight":{
        ref:"attr:ListGrid.autoFitMaxHeight",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitData')} is set to <code>\"vertical\"</code> or <code>\"both\"</code> this\n property provides an upper limit on how far the ListGrid will expand vertically to accommodate\n its content. If content exceeds this height, scrollbars will be introduced as usual.\n In addition to this property, ${isc.DocUtils.linkForRef('attr:ListGrid.autoFitMaxRecords')} allows you to limit vertical\n expansion based on the number of rows to be rendered.",
        name:"autoFitMaxHeight",
        setter:[
            "setAutoFitMaxHeight"
        ],
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "autoFitData"
        ]
    },
    "method:ImgButton.deselect":{
        ref:"method:ImgButton.deselect",
        flags:"",
        description:" Select this object.\n",
        name:"deselect",
        seeAlso:[
        ],
        type:"method",
        definingClass:"class:ImgButton",
        groups:[
            "state"
        ]
    },
    "attr:RelativeDateItem.showPastOptions":{
        ref:"attr:RelativeDateItem.showPastOptions",
        flags:"IR",
        description:"Should we show time-unit options in the past? If set to false, for each \n ${isc.DocUtils.linkForRef('attr:RelativeDateItem.timeUnitOptions','timeUnitOption')} we will show only future options [for example\n \"N weeks from now\"].\n <P>\n Note: this does not change the ${isc.DocUtils.linkForRef('attr:RelativeDateItem.presetOptions')}, which show up in \n addition to the time-unit options (<i>\"N days from now\"</i>, etc). The default\n preset options include both past and future presets so developers may wish to modify the\n presets to ensure only past options are available.",
        name:"showPastOptions",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"true",
        type:"attr",
        definingClass:"class:RelativeDateItem"
    },
    "attr:TimeItem.ampmItemProperties":{
        ref:"attr:TimeItem.ampmItemProperties",
        flags:"IRA",
        description:"Custom properties to apply to this timeItem's generated \n ${isc.DocUtils.linkForRef('attr:TimeItem.ampmItem','AM/PM picker')}.",
        name:"ampmItemProperties",
        seeAlso:[
        ],
        valueType:"SelectItem properties",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:TimeItem"
    },
    "method:Calendar.getVisibleStartDate":{
        ref:"method:Calendar.getVisibleStartDate",
        flags:"",
        description:" Returns the first visible date in the currently selected calendar view.\n",
        name:"getVisibleStartDate",
        seeAlso:[
        ],
        returns:{
            description:"first visible date",
            type:"Date"
        },
        type:"method",
        definingClass:"class:Calendar"
    },
    "group:sorting":{
        ref:"group:sorting",
        refs:[
            "method:ResultSet.sortByProperty",
            "method:Array.sortByProperty",
            "method:Array.unsort",
            "method:List.sortByProperty",
            "method:ListGridField.sortNormalizer",
            "method:ListGrid.headerClick",
            "method:ListGrid.sorterContextClick",
            "method:ListGrid.sorterClick",
            "method:ListGrid.unsort",
            "method:ListGrid.resort",
            "method:ListGrid.sort",
            "method:ListGrid.getSortField",
            "method:ListGrid.toggleSort",
            "method:ListGrid.getSort",
            "classMethod:Array.compareAscending",
            "classMethod:Array.compareDescending",
            "attr:ListGridField.canSort",
            "attr:ListGridField.sortDirection",
            "attr:ListGrid.canSort",
            "attr:ListGrid.selectHeaderOnSort",
            "attr:ListGrid.sortFieldNum",
            "attr:ListGrid.sortField",
            "attr:ListGrid.sortDirection",
            "attr:ListGrid.showSortArrow",
            "attr:ListGrid.initialSort",
            "attr:PickList.sortField",
            "attr:SelectItem.sortField",
            "attr:ComboBoxItem.sortField",
            "type:SortDirection",
            "type:SortArrow"
        ],
        description:null,
        name:"sorting",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:FacetChart.errorBarWidth":{
        ref:"attr:FacetChart.errorBarWidth",
        flags:"IR",
        description:"Width of the horizontal line of the \"T\"-shape portion of the error bar).",
        name:"errorBarWidth",
        seeAlso:[
        ],
        valueType:"int",
        defaultValue:"6",
        type:"attr",
        definingClass:"class:FacetChart"
    },
    "attr:TileGrid.dragDataAction":{
        ref:"attr:TileGrid.dragDataAction",
        flags:"IRW",
        description:"Indicates what to do with data dragged into another DataBoundComponent. See\n          DragDataAction type for details.",
        name:"dragDataAction",
        seeAlso:[
        ],
        valueType:"DragDataAction",
        defaultValue:"Canvas.MOVE",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('gridsDragMove')}",
            "${isc.DocUtils.linkForExampleId('gridsDragCopy')}"
        ],
        definingClass:"class:TileGrid",
        groups:[
            "dragging"
        ]
    },
    "attr:ListGrid.fieldPickerWindow":{
        ref:"attr:ListGrid.fieldPickerWindow",
        flags:"IR",
        description:"Instance of ${isc.DocUtils.linkForRef('class:FieldPickerWindow')} used if ${isc.DocUtils.linkForRef('attr:ListGrid.useAdvancedFieldPicker')} is set.",
        name:"fieldPickerWindow",
        seeAlso:[
        ],
        valueType:"AutoChild FieldPickerWindow",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "attr:Canvas.animateMoveAcceleration":{
        ref:"attr:Canvas.animateMoveAcceleration",
        flags:"IRWA",
        description:"Default acceleration effect for performing an animated move.  If unset, \n <code>this.animateAcceleration</code> will be used by default instead",
        name:"animateMoveAcceleration",
        seeAlso:[
        ],
        valueType:"AnimationAcceleration",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "method:DateItem.parseEditorValue":{
        ref:"method:DateItem.parseEditorValue",
        flags:"A",
        description:" Convert a text value entered in this item's text field to a final data value \n for storage.\n <P>\n If ${isc.DocUtils.linkForRef('attr:DateItem.useTextField')} is true, entirely custom date formatting and\n parsing logic may be applied via overrides to ${isc.DocUtils.linkForRef('method:DateItem.parseEditorValue')} and\n ${isc.DocUtils.linkForRef('method:DateItem.formatEditorValue')}. These methods apply to this FormItem only - \n system-wide Date and Datetime formatting and parsing may also be customized via\n the APIs on the ${isc.DocUtils.linkForRef('class:Date')} class. See ${isc.DocUtils.linkForRef('group:dateFormatAndStorage')} for more\n on this.\n <P>\n Note: custom parsing for this item may also be achieved by modifying the\n ${isc.DocUtils.linkForRef('attr:DateItem.inputFormat')}. This mechanism provides support many common date formats\n without the need for an entirely custom parser function.\n\n",
        name:"parseEditorValue",
        seeAlso:[
        ],
        params:[
            {
                description:"value as entered by the user",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"string"
            },
            {
                description:"pointer to the dynamicForm containing this item",
                optional:false,
                name:"form",
                defaultValue:null,
                type:"DynamicForm"
            },
            {
                description:"pointer to this item",
                optional:false,
                name:"item",
                defaultValue:null,
                type:"FormItem"
            }
        ],
        returns:{
            description:"Data value to store for this item.",
            type:"any"
        },
        type:"method",
        definingClass:"class:DateItem"
    },
    "method:ListGrid.hideField":{
        ref:"method:ListGrid.hideField",
        flags:"",
        description:" Force a field to be hidden.<br><br>\n\n NOTE: If a field.showIf expression exists, it will be destroyed.\n <P>\n Note also that if multiple fields are to be hidden it is more efficient to\n call ${isc.DocUtils.linkForRef('method:ListGrid.hideFields')} passing in the array of fields to hide rather than to call\n this method repeatedly.\n <P>\n See ${isc.DocUtils.linkForRef('attr:ListGrid.discardEditsOnHideField')} and ${isc.DocUtils.linkForRef('attr:ListGrid.dropCriteriaOnHideField')}\n for behavior when hiding fields while ${isc.DocUtils.linkForRef('attr:ListGrid.canEdit','editing')}.\n \n\n",
        name:"hideField",
        seeAlso:[
        ],
        params:[
            {
                description:"field to hide",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"String | ListGridField"
            },
            {
                description:"if passed, don't relayout non-explicit sized fields                                      to fit the available space",
                optional:true,
                name:"suppressRelayout",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('columnOrder')}"
        ],
        definingClass:"class:ListGrid"
    },
    "method:CubeGrid.resizeFacetValue":{
        ref:"method:CubeGrid.resizeFacetValue",
        flags:"",
        description:" Resizes all columns for the provided facetValueId, which must be a facetValueId from the\n innermost column facet.\n\n",
        name:"resizeFacetValue",
        seeAlso:[
        ],
        params:[
            {
                description:"facetValueId of columns to be resized",
                optional:false,
                name:"facetValueId",
                defaultValue:null,
                type:"id"
            },
            {
                description:"column's new width",
                optional:false,
                name:"newWidth",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid"
    },
    "attr:Canvas.hideUsingDisplayNone":{
        ref:"attr:Canvas.hideUsingDisplayNone",
        flags:"IRA",
        description:"When this widget is hidden (see ${isc.DocUtils.linkForRef('attr:Canvas.visibility')} and ${isc.DocUtils.linkForRef('method:Canvas.hide')}),\n should display:none be applied to the ${isc.DocUtils.linkForRef('method:Canvas.getOuterElement','outer element')}?\n <p>\n This setting is not supported for general use, but in certain cases, it has been shown\n that display:none is a work-around for browser bugs involving burn-through of iframes or\n plugins, where the content of the iframe or plugin may still be visible despite the\n containing widget being hidden.",
        name:"hideUsingDisplayNone",
        seeAlso:[
        ],
        valueType:"boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:Canvas",
        groups:[
            "appearance"
        ]
    },
    "group:orientation":{
        ref:"group:orientation",
        refs:[
            "type:Orientation"
        ],
        name:"orientation",
        seeAlso:[
        ],
        type:"group"
    },
    "attr:AdvancedHiliteEditor.filterBuilder":{
        ref:"attr:AdvancedHiliteEditor.filterBuilder",
        flags:"IR",
        description:"AutoChild ${isc.DocUtils.linkForRef('class:FilterBuilder')} for configuring the criteria for this Hilite.\n <P>\n This component is an ${isc.DocUtils.linkForRef('type:AutoChild')} and as such may be customized via \n <code>advancedHiliteEditor.filterBuilderProperties</code>.",
        name:"filterBuilder",
        seeAlso:[
        ],
        valueType:"AutoChild FilterBuilder",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:AdvancedHiliteEditor"
    },
    "attr:GaugeSector.value":{
        ref:"attr:GaugeSector.value",
        flags:"IR",
        description:null,
        name:"value",
        seeAlso:[
        ],
        valueType:"float",
        defaultValue:"0",
        type:"attr",
        definingClass:"object:GaugeSector"
    },
    "classAttr:Array.CASE_INSENSITIVE":{
        ref:"classAttr:Array.CASE_INSENSITIVE",
        flags:null,
        description:"This is a built-in comparator for the ${isc.DocUtils.linkForRef('method:Array.find','find')} and ${isc.DocUtils.linkForRef('method:Array.findIndex','findIndex')}\n methods of Array.  Passing this comparator to those methods will find case-insensitively,\n so, eg, <code>find(\"foo\", \"bar\")</code> would find objects with a \"foo\" property set to \n \"Bar\", \"BAR\" or \"bar\"",
        name:"CASE_INSENSITIVE",
        seeAlso:[
        ],
        valueType:"Function",
        defaultValue:"See below",
        type:"classAttr",
        definingClass:"object:Array"
    },
    "method:DynamicForm.editNewRecord":{
        ref:"method:DynamicForm.editNewRecord",
        flags:"",
        description:"\n Prepare to edit a new record by clearing the current set of values (or replacing them \n with initialValues if specified).\n <br>\n This method will also call ${isc.DocUtils.linkForRef('method:DynamicForm.setSaveOperationType')} to ensure\n subsequent calls to <code>saveData()</code> will use an <code>add</code> rather than\n an <code>update</code> operation.\n\n",
        name:"editNewRecord",
        seeAlso:[
            {
                ref:"method:DynamicForm.saveData",
                description:null
            }
        ],
        params:[
            {
                description:"initial set of values for the editor as a map of field names to their corresponding\n     values",
                optional:true,
                name:"initialValues",
                defaultValue:null,
                type:"Object | Record"
            }
        ],
        type:"method",
        definingClass:"class:DynamicForm",
        groups:[
            "dataBoundComponentMethods"
        ]
    },
    "classMethod:Page.getScrollLeft":{
        ref:"classMethod:Page.getScrollLeft",
        flags:"",
        description:"\t\tGet the amount that the browser window has been scrolled horizontally.\n",
        name:"getScrollLeft",
        seeAlso:[
        ],
        returns:{
            description:"horizontal scroll amount",
            type:"number"
        },
        type:"classMethod",
        definingClass:"class:Page",
        groups:[
            "sizing"
        ]
    },
    "class:SectionItem":{
        methods:[
            "method:SectionItem.isExpanded",
            "method:SectionItem.expandSection",
            "method:SectionItem.collapseSection"
        ],
        exampleConfig:"SectionItem.xml",
        ref:"class:SectionItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Forms/Form Items"
        ],
        attrs:[
            "attr:SectionItem.defaultValue",
            "attr:SectionItem.itemIds",
            "attr:SectionItem.sectionVisible",
            "attr:SectionItem.sectionExpanded",
            "attr:SectionItem.sectionHeaderClass",
            "attr:SectionItem.canCollapse",
            "attr:SectionItem.canTabToHeader"
        ],
        description:"Header item for a collapsible section in a ${isc.DocUtils.linkForRef('class:DynamicForm')}.  Each <code>SectionItem</code>\n is associated with a number of other <code>item</code>s in the form, which will be shown or\n hidden as a group when the section is expanded or collapsed.  Clicking on a\n <code>SectionItem</code> will expand or collapse the section.\n <P>\n To make a form where only one section is expanded at a time, set\n ${isc.DocUtils.linkForRef('attr:DynamicForm.sectionVisibilityMode')} to \"mutex\".",
        name:"SectionItem",
        seeAlso:[
            {
                ref:"attr:DynamicForm.sectionVisibilityMode",
                description:null
            }
        ],
        type:"class",
        examples:[
            "${isc.DocUtils.linkForExampleId('formSections')}"
        ]
    },
    "attr:TabSet.canEditTabTitles":{
        ref:"attr:TabSet.canEditTabTitles",
        flags:"IRW",
        description:"If true, users can edit the titles of tabs in this TabSet when the \n ${isc.DocUtils.linkForRef('attr:TabSet.titleEditEvent','titleEditEvent')} fires.  You can override this behavior per tab \n with the ${isc.DocUtils.linkForRef('attr:Tab.canEditTitle')} property.\n <p>\n Note that this TabSet's ${isc.DocUtils.linkForRef('attr:TabSet.titleEditEvent','titleEditEvent')} must be set to a\n supported ${isc.DocUtils.linkForRef('type:TabTitleEditEvent')} in order for users to be able to edit the titles of\n tabs.",
        name:"canEditTabTitles",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        examples:[
            "${isc.DocUtils.linkForExampleId('userEditableTitles')}"
        ],
        definingClass:"class:TabSet"
    },
    "method:Layout.reflow":{
        ref:"method:Layout.reflow",
        flags:"A",
        description:" Layout members according to current settings.\n <P>\n Members will reflow automatically when the layout is resized, members resize, the list of\n members changes or members change visibility.  It is only necessary to manually call\n <code>reflow()</code> after changing settings on the layout, for example,\n <code>layout.reverseOrder</code>.\n\n",
        name:"reflow",
        seeAlso:[
        ],
        params:[
            {
                description:"reason reflow() had to be called (appear in logs if enabled)",
                optional:true,
                name:"reason",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Layout"
    },
    "attr:DateChooser.nextMonthButton":{
        ref:"attr:DateChooser.nextMonthButton",
        flags:"IR",
        description:"A button shown in the ${isc.DocUtils.linkForRef('attr:DateChooser.navigationLayout','navigation layout')} that shifts\n the calendar view forward by a month.",
        name:"nextMonthButton",
        seeAlso:[
        ],
        valueType:"AutoChild IButton",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DateChooser"
    },
    "method:TabSet.closeClick":{
        ref:"method:TabSet.closeClick",
        flags:"",
        description:" When ${isc.DocUtils.linkForRef('attr:TabSet.canCloseTabs')} is set, method fired when the user clicks the \"close\" icon for a\n tab.\n <P>\n Default implementation will remove the tab from the tabSet via ${isc.DocUtils.linkForRef('method:TabSet.removeTab')}.\n\n",
        name:"closeClick",
        seeAlso:[
        ],
        params:[
            {
                description:"tab to close",
                optional:false,
                name:"tab",
                defaultValue:null,
                type:"Tab"
            }
        ],
        type:"method",
        definingClass:"class:TabSet"
    },
    "attr:DetailViewer.timeFormatter":{
        ref:"attr:DetailViewer.timeFormatter",
        flags:"IRW",
        description:"Display format to use for fields specified as type 'time'.  May also be specified at \n the field level via ${isc.DocUtils.linkForRef('attr:DetailViewerField.timeFormatter')}.<br>\n If unset, time fields will be formatted based on the system wide \n ${isc.DocUtils.linkForRef('classMethod:Time.setNormalDisplayFormat')}",
        name:"timeFormatter",
        seeAlso:[
        ],
        valueType:"TimeDisplayFormat",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:DetailViewer",
        groups:[
            "appearance"
        ]
    },
    "method:DataSourceField.getFieldValue":{
        ref:"method:DataSourceField.getFieldValue",
        flags:"A",
        description:" Function or JavaScript expression used to retrieve the field's value from the XML element or\n JSON record returned from a web service.\n <P>\n This is an advanced API for use when a ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath','valueXPath')} setting\n is insufficient to derive a field's value, yet an implementation of\n ${isc.DocUtils.linkForRef('method:DataSource.transformResponse')} is overkill.\n\n",
        name:"getFieldValue",
        seeAlso:[
        ],
        params:[
            {
                description:"record object selected from web service response data                                      by ${isc.DocUtils.linkForRef('attr:OperationBinding.recordXPath','recordXPath')}",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"Object or XMLElement"
            },
            {
                description:"default value derived by the method described in                    ${isc.DocUtils.linkForRef('attr:DataSourceField.valueXPath')}",
                optional:false,
                name:"value",
                defaultValue:null,
                type:"any"
            },
            {
                description:"DataSourceField definition",
                optional:false,
                name:"field",
                defaultValue:null,
                type:"DataSourceField"
            },
            {
                description:"name of the DataSource field",
                optional:false,
                name:"fieldName",
                defaultValue:null,
                type:"String"
            }
        ],
        type:"method",
        serverDS:"allowed",
        definingClass:"class:DataSourceField",
        groups:[
            "clientDataIntegration"
        ]
    },
    "type:ArrowStyle":{
        ref:"type:ArrowStyle",
        values:[
            {
                description:"Solid triangle",
                value:"\"block\""
            },
            {
                description:"arrow rendered as an open triangle. Only applies to  ${isc.DocUtils.linkForRef('class:DrawLinePath','DrawLinePaths')} - for other items this will be treated as\n  <code>\"block\"</code>",
                value:"\"open\""
            },
            {
                description:"Don't render an arrowhead at all",
                value:"null"
            }
        ],
        description:"Supported styles for arrowheads",
        name:"ArrowStyle",
        seeAlso:[
        ],
        type:"type"
    },
    "class:ServiceTask":{
        methods:[
        ],
        ref:"class:ServiceTask",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Workflow"
        ],
        attrs:[
            "attr:ServiceTask.dataSource",
            "attr:ServiceTask.operationType",
            "attr:ServiceTask.criteria",
            "attr:ServiceTask.values",
            "attr:ServiceTask.fixedCriteria",
            "attr:ServiceTask.fixedValues"
        ],
        description:"A ServiceTask is an element of a ${isc.DocUtils.linkForRef('class:Process')} which calls a DataSource operation, \n optionally using part of the ${isc.DocUtils.linkForRef('attr:Process.state','process state')} as inputs or storing outputs\n in the process state.\n <P>\n By default a ServiceTask takes the data indicated by ${isc.DocUtils.linkForRef('attr:Task.inputField')} and uses it as\n ${isc.DocUtils.linkForRef('attr:DSRequest.data')}.  This means the input data becomes ${isc.DocUtils.linkForRef('type:Criteria')} for a \"fetch\"\n operation, new record values for an \"add\" operation, etc.\n <P>\n Alternatively, you can set ${isc.DocUtils.linkForRef('attr:ServiceTask.criteria')} for a \"fetch\" operation, or\n ${isc.DocUtils.linkForRef('attr:ServiceTask.values')} for other operationTypes.  In both cases, you have the ability to\n use simple expressions like $input.<i>fieldName</i> to take portions of the input data and\n use it as part of the criteria or values.\n <P>\n As a special case, if the <code>inputField</code> is an atomic value (just a String or\n Number rather than a Record) and operationType is \"fetch\", it will be assumed to be value\n for the primary key field of the target DataSource if ${isc.DocUtils.linkForRef('attr:ServiceTask.criteria','criteria')}\n is not explicitly specified\n <P>\n OutputData and outputFieldList work as filters. You should determine which properties should\n be fetched into the process state. If you want to load all data without defining every\n property manually you can pass a name started with '$' and fetched record or records will be \n placed as a record or an array of records by the name without this specific symbol.\n <P>\n For example if you specify 'id' and 'name' in outputFieldList, only these properties will be\n fetched in the process state. If you pass '$record' in outputField a whole record will be \n stored in process state under the 'record' key. Also you can use javascript syntax there.\n For example '$record.item[0]'.",
        name:"ServiceTask",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:MultiComboBoxItem.autoFetchData":{
        ref:"attr:MultiComboBoxItem.autoFetchData",
        flags:"IR",
        description:"Should the MultiComboBoxItem fetch data from the ${isc.DocUtils.linkForRef('attr:MultiComboBoxItem.optionDataSource','data source')}\n immediately or wait until the user first opens the pickList.",
        name:"autoFetchData",
        seeAlso:[
            {
                ref:"attr:ComboBoxItem.autoFetchData",
                description:null
            }
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:MultiComboBoxItem"
    },
    "method:ListGrid.rowEditorEnter":{
        ref:"method:ListGrid.rowEditorEnter",
        flags:"",
        description:" Callback fired when the user starts editing a new row.\n\n",
        name:"rowEditorEnter",
        seeAlso:[
            {
                ref:"method:ListGrid.editorEnter",
                description:null
            }
        ],
        params:[
            {
                description:"record for the cell being edited",
                optional:false,
                name:"record",
                defaultValue:null,
                type:"ListGridField"
            },
            {
                description:"edit values for the current row",
                optional:false,
                name:"editValues",
                defaultValue:null,
                type:"object"
            },
            {
                description:"row number for the cell",
                optional:false,
                name:"rowNum",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:ListGrid",
        groups:[
            "editing"
        ]
    },
    "method:Class.setLogPriority":{
        ref:"method:Class.setLogPriority",
        flags:"",
        description:" Set the priority of messages that will be visible for some log category, when logged on\n this Class or Instance object.<br>\n If called with no category, this priority will be applied to every logged message on this\n object<br>\n To set the visible log priority for some category across the entire page, use\n <code>isc.Log.setPriority()</code> instead.\n",
        name:"setLogPriority",
        seeAlso:[
            {
                ref:"classMethod:Log.setPriority",
                description:null
            }
        ],
        params:[
            {
                description:"Category for which the log priority will be updated. If not                          all logs on this canvas will be logged at the priority passed in.",
                optional:false,
                name:"category",
                defaultValue:null,
                type:"string"
            },
            {
                description:"priority level",
                optional:false,
                name:"priority",
                defaultValue:null,
                type:"LogPriority"
            }
        ],
        type:"method",
        definingClass:"class:Class"
    },
    "attr:Calendar.canRemoveField":{
        ref:"attr:Calendar.canRemoveField",
        flags:"IR",
        description:"Name of the field on each ${isc.DocUtils.linkForRef('object:CalendarEvent')} that determines whether an event shows a\n remove button.",
        name:"canRemoveField",
        seeAlso:[
            {
                ref:"object:CalendarEvent",
                description:null
            }
        ],
        valueType:"String",
        defaultValue:"\"canRemove\"",
        type:"attr",
        definingClass:"class:Calendar",
        groups:[
            "calendarEvent"
        ]
    },
    "attr:FormItem.dataPath":{
        ref:"attr:FormItem.dataPath",
        flags:"IR",
        getter:[
            "getDataPath"
        ],
        description:"dataPath for this item. Allows the user to edit details nested data structures in a\n flat set of form fields",
        name:"dataPath",
        seeAlso:[
        ],
        valueType:"DataPath",
        defaultValue:"null",
        type:"attr",
        definingClass:"class:FormItem"
    },
    "method:Canvas.mouseUp":{
        ref:"method:Canvas.mouseUp",
        flags:"A",
        description:"\n Executed when the left mouse is released on this widget.  No default implementation.\n\n",
        name:"mouseUp",
        seeAlso:[
            {
                ref:"method:Canvas.getOffsetX",
                description:null
            },
            {
                ref:"method:Canvas.getOffsetY",
                description:null
            }
        ],
        returns:{
            description:"false to prevent this event from bubbling to this widget's parent, true or undefined to bubble.",
            type:"Boolean"
        },
        type:"method",
        examples:[
            "${isc.DocUtils.linkForExampleId('customMouseEvents')}"
        ],
        definingClass:"class:Canvas",
        groups:[
            "widgetEvents"
        ]
    },
    "method:Slider.setTrackWidth":{
        ref:"method:Slider.setTrackWidth",
        flags:"",
        description:" Sets the ${isc.DocUtils.linkForRef('attr:Slider.trackWidth')} property of the slider\n\n",
        name:"setTrackWidth",
        seeAlso:[
        ],
        params:[
            {
                description:"new trackWidth",
                optional:false,
                name:"newWidth",
                defaultValue:null,
                type:"number"
            }
        ],
        type:"method",
        definingClass:"class:Slider"
    },
    "method:WebService.getOutputHeaderSchema":{
        ref:"method:WebService.getOutputHeaderSchema",
        flags:"",
        description:" Get the schema for each part of the SOAP header for the output message of a given\n operation, as a mapping from part name to schema.  For example, given WSDL like:\n <pre>\n     &lt;soap:header part=\"SessionHeader\"/&gt;\n     &lt;soap:header part=\"CallOptions\"/&gt;\n </pre>\n The following schema would be returned:\n <pre>\n     { SessionHeader : <i>sessionHeaderPartSchema</i>,\n       CallOptions : <i>callOptionsPartSchema</i> }\n </pre>\n The schema are instances of ${isc.DocUtils.linkForRef('class:DataSource')} that can be inspected to discover the\n elements and types that are legal in that header part, and can construct a valid SOAP\n header part if ${isc.DocUtils.linkForRef('method:DataSource.xmlSerialize')} is invoked.\n\n",
        name:"getOutputHeaderSchema",
        seeAlso:[
        ],
        params:[
            {
                description:"name of an operation from this web service",
                optional:false,
                name:"operationName",
                defaultValue:null,
                type:"String"
            }
        ],
        returns:{
            description:"mapping from partName to schema",
            type:"Object"
        },
        type:"method",
        definingClass:"class:WebService"
    },
    "attr:ListGrid.booleanImageWidth":{
        ref:"attr:ListGrid.booleanImageWidth",
        flags:"IRWA",
        description:"Width for the ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')}, ${isc.DocUtils.linkForRef('attr:ListGrid.booleanFalseImage')}\n and ${isc.DocUtils.linkForRef('attr:ListGrid.booleanPartialImage')}.\n Note: If ${isc.DocUtils.linkForRef('attr:ListGrid.booleanTrueImage')} is unset, the ${isc.DocUtils.linkForRef('attr:CheckboxItem.checkedImage')}\n will be used to indicate a true value in a boolean field. In this case this property is\n ignored in favor of ${isc.DocUtils.linkForRef('attr:CheckboxItem.valueIconWidth')}.",
        name:"booleanImageWidth",
        seeAlso:[
        ],
        valueType:"number",
        defaultValue:"16",
        type:"attr",
        definingClass:"class:ListGrid",
        groups:[
            "imageColumns"
        ]
    },
    "object:FormItemIcon":{
        methods:[
            "method:FormItemIcon.click",
            "method:FormItemIcon.keyPress",
            "method:FormItemIcon.showIf"
        ],
        ref:"object:FormItemIcon",
        classAttrs:[
        ],
        classMethods:[
        ],
        treeLocation:[
            "Client Reference/Forms/Form Items/FormItem"
        ],
        attrs:[
            "attr:FormItemIcon.baseStyle",
            "attr:FormItemIcon.name",
            "attr:FormItemIcon.src",
            "attr:FormItemIcon.showOver",
            "attr:FormItemIcon.showFocused",
            "attr:FormItemIcon.showRTL",
            "attr:FormItemIcon.showFocusedWithItem",
            "attr:FormItemIcon.neverDisable",
            "attr:FormItemIcon.disableOnReadOnly",
            "attr:FormItemIcon.tabIndex",
            "attr:FormItemIcon.width",
            "attr:FormItemIcon.height",
            "attr:FormItemIcon.prompt",
            "attr:FormItemIcon.hspace"
        ],
        description:"Form item icon descriptor objects used by Form Items to specify the appearance and\n  behavior of icons displayed after the item in the page flow.",
        name:"FormItemIcon",
        seeAlso:[
            {
                ref:"attr:FormItem.icons",
                description:null
            }
        ],
        type:"object",
        examples:[
            "${isc.DocUtils.linkForExampleId('formIcons')}"
        ],
        groups:[
            "formIcons"
        ]
    },
    "class:HiddenItem":{
        methods:[
        ],
        ref:"class:HiddenItem",
        classAttrs:[
        ],
        classMethods:[
        ],
        attrs:[
            "attr:HiddenItem.showTitle",
            "attr:HiddenItem.colSpan",
            "attr:HiddenItem.rowSpan"
        ],
        description:"HiddenItems track a value but have no visible appearance and do not take up space in the form\n layout.\n <P>\n When using SmartClient databinding it is usually not necessary to use a HiddenItem, since\n the DynamicForm will track values for which no actual form control exists, and will submit\n these 'extra' values when ${isc.DocUtils.linkForRef('method:DynamicForm.saveData')} is called.  HiddenItems only apply\n to forms that are submitted like ordinary HTML forms, via the\n ${isc.DocUtils.linkForRef('method:DynamicForm.submitForm')} method.",
        name:"HiddenItem",
        seeAlso:[
        ],
        type:"class"
    },
    "attr:ListGrid.applyFormulaAfterSummary":{
        ref:"attr:ListGrid.applyFormulaAfterSummary",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:ListGridField.userFormula')} is set for some field, and this grid is showing\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGroupSummary','group summaries')} or a\n ${isc.DocUtils.linkForRef('attr:ListGrid.showGridSummary','grid summary')}, this property determines what field value\n should be present in those summary rows. Should the field apply the user-formula to the\n calculated summary row, or should it apply a standard grid or group summary to the\n user-formula values displayed in the grid?\n <P>\n May be overridden at the field level via ${isc.DocUtils.linkForRef('attr:ListGridField.applyAfterSummary')}",
        name:"applyFormulaAfterSummary",
        seeAlso:[
        ],
        valueType:"Boolean",
        defaultValue:"false",
        type:"attr",
        definingClass:"class:ListGrid"
    },
    "method:CubeGrid.deselectFacetValues":{
        ref:"method:CubeGrid.deselectFacetValues",
        flags:"",
        description:" Deselect the header showing a given set of facet values.\n\n  <br><i>methodType</i> action\n",
        name:"deselectFacetValues",
        seeAlso:[
        ],
        params:[
            {
                description:"facetValues to deselect",
                optional:false,
                name:"facetValues",
                defaultValue:null,
                type:"FacetValueMap"
            }
        ],
        type:"method",
        definingClass:"class:CubeGrid",
        groups:[
            "selection"
        ]
    },
    "method:Canvas.layoutChildren":{
        ref:"method:Canvas.layoutChildren",
        flags:"A",
        description:"\n <code>layoutChildren()</code> is where a Canvas should implement a sizing policy for it's\n Canvas children.  Since <code>layoutChildren</code> calls parentResized() on its children,\n ${isc.DocUtils.linkForRef('method:Canvas.parentResized')} is a good place for a child to implement a layout policy that\n can be used within any parent.\n <P>\n Recommended practice for a Canvas that manages Canvas children is to create those children\n without any initial coordinate or size settings and do all sizing when layoutChildren() is\n called.\n <P>\n layoutChildren() is always called at least once before children are drawn, and is called\n automatically whenever the viewport size changes (which includes both resizing and\n introduction/removal of scrolling).  layoutChildren() can also be manually invoked in any\n other component-specific situation which changes the layout.\n <P>\n NOTE: layoutChildren() may be called before draw() if a widget is resized before draw(), so\n be sure to avoid errors such as assuming that any children you automatically create have\n already been created.\n <P>\n NOTE: auto-sizing: layoutChildren() is also called once during the initial draw(), before\n children are drawn, with a \"reason\" of \"initial draw\".  During this invocation of\n layoutChildren() it is legal to directly draw children (call child.draw()), which is\n otherwise never allowed.  This allows a Canvas to implement an auto-sizing layout policy by\n drawing some children before deciding on the sizes of remaining children, which is far more\n efficient than drawing all children and resizing some of them after they are drawn.\n",
        name:"layoutChildren",
        seeAlso:[
        ],
        params:[
            {
                description:"reason why layoutChildren() is being called, passed when framework                        code invokes layoutChildren()",
                optional:false,
                name:"reason",
                defaultValue:null,
                type:"string"
            }
        ],
        type:"method",
        definingClass:"class:Canvas",
        groups:[
            "sizing"
        ]
    },
    "method:Selection.selectList":{
        ref:"method:Selection.selectList",
        flags:"",
        description:" Select an array of items (subset of the entire list)\n",
        name:"selectList",
        seeAlso:[
        ],
        params:[
            {
                description:"array of objects to select",
                optional:false,
                name:"list",
                defaultValue:null,
                type:"object[]"
            }
        ],
        returns:{
            description:"true == selection actually changed, false == no change",
            type:"boolean"
        },
        type:"method",
        definingClass:"class:Selection",
        groups:[
            "selection"
        ]
    },
    "method:IMenuButton.setShowMenuBelow":{
        ref:"method:IMenuButton.setShowMenuBelow",
        flags:"",
        description:" Setter for the 'showMenuButtonBelow' property - determines whether the menu will be\n shown above or below the menubutton.\n",
        name:"setShowMenuBelow",
        seeAlso:[
        ],
        params:[
            {
                description:"True if the menu should be shown below the menubutton.",
                optional:false,
                name:"below",
                defaultValue:null,
                type:"boolean"
            }
        ],
        type:"method",
        definingClass:"class:IMenuButton"
    },
    "method:PortalLayout.portletMinimized":{
        ref:"method:PortalLayout.portletMinimized",
        flags:"",
        description:" Notification method called after a portlet has been minimized (whether by\n user action or programmatically).\n\n",
        name:"portletMinimized",
        seeAlso:[
            {
                ref:"method:PortalLayout.willMinimizePortlet",
                description:null
            }
        ],
        params:[
            {
                description:"the Portlet which was minimized",
                optional:false,
                name:"portlet",
                defaultValue:null,
                type:"Portlet"
            }
        ],
        type:"method",
        definingClass:"class:PortalLayout"
    },
    "method:FormItem.getIconWidth":{
        ref:"method:FormItem.getIconWidth",
        flags:"A",
        description:"\tTakes an icon definition object, and returns the width for that icon in px.\n",
        name:"getIconWidth",
        seeAlso:[
        ],
        params:[
            {
                description:"icon definition object for this item.",
                optional:false,
                name:"icon",
                defaultValue:null,
                type:"object"
            }
        ],
        returns:{
            description:"width of the form item icon in px",
            type:"number"
        },
        type:"method",
        definingClass:"class:FormItem",
        groups:[
            "sizing"
        ]
    },
    "classMethod:Log.getLogPriorities":{
        ref:"classMethod:Log.getLogPriorities",
        flags:"",
        description:" Get all priority settings as an object mapping category names to priority levels.\n\n",
        name:"getLogPriorities",
        seeAlso:[
        ],
        params:[
            {
                description:"Optional param to get priorities specific to                                            some ISC class or instance.",
                optional:true,
                name:"object",
                defaultValue:null,
                type:"Class or Instance object"
            },
            {
                description:"If this method is retrieving the priorities specific                                   to logging for some class or instance, this parameter\n                                  can be used to view only the overrides to the default\n                                  log priorities on this object.",
                optional:true,
                name:"overridesOnly",
                defaultValue:null,
                type:"boolean"
            }
        ],
        returns:{
            description:"priority settings",
            type:"Object"
        },
        type:"classMethod",
        definingClass:"class:Log"
    },
    "method:StatefulCanvas.setBaseStyle":{
        ref:"method:StatefulCanvas.setBaseStyle",
        flags:"",
        description:" Sets the base CSS style.  As the component changes state and/or is selected, suffixes will be\n added to the base style.\n",
        name:"setBaseStyle",
        seeAlso:[
        ],
        params:[
            {
                description:"new base style",
                optional:false,
                name:"style",
                defaultValue:null,
                type:"className"
            }
        ],
        type:"method",
        definingClass:"class:StatefulCanvas"
    },
    "attr:RecordEditor.baseStyle":{
        ref:"attr:RecordEditor.baseStyle",
        flags:"IR",
        description:"${isc.DocUtils.linkForRef('attr:GridRenderer.baseStyle','base cell style')} for this listGrid.\n If this property is unset, base style may be derived from ${isc.DocUtils.linkForRef('attr:ListGrid.normalBaseStyle')}\n or ${isc.DocUtils.linkForRef('attr:ListGrid.tallBaseStyle')} as described in\n ${isc.DocUtils.linkForRef('method:ListGrid.getBaseStyle')}.",
        name:"baseStyle",
        seeAlso:[
        ],
        valueType:"CSSStyleName",
        defaultValue:"\"recordEditorCell\"",
        type:"attr",
        definingClass:"class:RecordEditor",
        groups:[
            "appearance"
        ]
    },
    "attr:TreeMenuButton.pathSeparatorString":{
        ref:"attr:TreeMenuButton.pathSeparatorString",
        flags:"IRW",
        description:"If ${isc.DocUtils.linkForRef('attr:TreeMenuButton.showPath','showPath')} is true, this property specifies what will \n appear between the folders in the selected value's path.",
        name:"pathSeparatorString",
        seeAlso:[
        ],
        valueType:"HTML",
        defaultValue:"\"&amp;nbsp;&amp;gt;&amp;nbsp;\"",
        type:"attr",
        definingClass:"class:TreeMenuButton"
    },
    "classAttr:Canvas.loadingImageSize":{
        ref:"classAttr:Canvas.loadingImageSize",
        flags:"RWA",
        description:"Specifies the width and height of ${isc.DocUtils.linkForRef('classAttr:Canvas.loadingImageSrc')}.",
        name:"loadingImageSize",
        seeAlso:[
        ],
        valueType:"integer",
        defaultValue:"16",
        type:"classAttr",
        definingClass:"class:Canvas",
        groups:[
            "animation"
        ]
    },
    "classAttr:Operators.matchesPat