/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.js;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCBinaryValue;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.IJSParser;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.SequenceReader;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.IContextBeanFilter;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.IToJavaScript;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.util.LocaleMessage;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JSTranslater
extends Base {
    private static Logger log = new Logger(JSTranslater.class.getName());
    public static boolean globalPrettyPrinting = config.getBoolean((Object)"jsTranslater.prettyPrint", false);
    public static boolean collapseSmallContainers = config.getBoolean((Object)"jsTranslater.prettyPrint.collapseSmallContainers", false);
    public static boolean globalOmitNullMapValues = config.getBoolean((Object)"jsTranslater.omitNullMapValues", false);
    public static boolean writeNativeDate = config.getBoolean((Object)"jsTranslater.writeNativeDate", false);
    public static boolean bigIntegerAsString = config.getBoolean((Object)"jsTranslater.bigIntegerAsString", false);
    public static boolean bigDecimalAsString = config.getBoolean((Object)"jsTranslater.bigDecimalAsString", false);
    public static String datetimeOutputFormat = config.getString("jsTranslater.datetimeOutputFormat", null);
    public boolean writePrefixedDate = false;
    public Map obfuscateMapKeys = config.getSubtree("map.obfuscateKeys");
    private boolean obfuscation = true;
    private boolean writeXMLSchemaDate = false;
    private boolean trimMilliseconds = false;
    public static final String DEFAULT_ENUM_TRANSLATE_STRATEGY = "string";
    public static final String DEFAULT_ENUM_CONSTANT_PROPERTY = "_constant";
    public static final String DEFAULT_ENUM_ORDINAL_PROPERTY = "_ordinal";
    private String enumTranslateStrategy = "string";
    private String constantProperty = "_constant";
    private String ordinalProperty = "_ordinal";
    static final Perl5Util regex = new Perl5Util();
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd kk:mm:ss";
    public static final String DATETIME_MILLIS_FORMAT = "yyyy-MM-dd kk:mm:ss.SSS";
    public static final String XMLSCHEMA_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String XMLSCHEMA_DATETIME_MILLIS_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String XMLSCHEMA_TIME_FORMAT = "HH:mm:ss";
    public static final String XMLSCHEMA_TIME_MILLIS_FORMAT = "HH:mm:ss.SSS";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat xmlSchemaTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private DateFormat datetimeFormat;
    private static final DateFormat sharedDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat sharedDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");
    private static final DateFormat sharedDateTimeMillisFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss.SSS");
    private static final DateFormat sharedXmlSchemaDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat sharedXmlSchemaTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat sharedXmlSchemaDateTimeMillisFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateFormat sharedXmlSchemaTimeMillisFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final Object[] EMPTY_ARRAY;
    public static final HashMap types;
    static final HashSet safeToString;
    static final HashSet sendAsJSString;
    static final HashSet reservedWords;
    boolean prettyPrinting = globalPrettyPrinting;
    boolean omitNullMapValues = globalOmitNullMapValues;
    private final Calendar cacheCalendar;
    int currentIndentDepth = 0;
    boolean alwaysToString = false;
    int propNameIndent = 0;
    String path = "";
    boolean quoteForXML = false;
    boolean quoteForTextArea = false;
    ValidationContext validationContext = null;
    boolean useSchema = true;
    boolean preserveLiteralNulls = false;
    ValidationContext typeLookupVC = null;
    boolean strictJSONMode = false;
    Locale locale;
    Locale defaultLocale;
    boolean defaultLocaleWarningLogged = false;
    List recursedList;
    int recursionCount = 0;

    public void setObfuscation(boolean enabled) {
        this.obfuscation = enabled;
    }

    public boolean shouldWriteXMLSchemaDate() {
        return this.writeXMLSchemaDate;
    }

    public void setWriteXMLSchemaDate(boolean value) {
        this.writeXMLSchemaDate = value;
    }

    public boolean shouldUseUTCInXMLSchemaDates() {
        return this.datetimeFormat.getTimeZone().getOffset(0L) == 0;
    }

    public void setUseUTCInXMLSchemaDates(boolean value) {
        this.datetimeFormat.setTimeZone(value ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault());
    }

    public boolean shouldTrimMilliseconds() {
        return this.trimMilliseconds;
    }

    public void setTrimMilliseconds(boolean value) {
        this.trimMilliseconds = value;
        DateFormat old = this.datetimeFormat;
        if (!value) {
            this.xmlSchemaTimeFormat = new SimpleDateFormat(XMLSCHEMA_TIME_FORMAT);
            this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_MILLIS_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_MILLIS_FORMAT);
        } else {
            this.xmlSchemaTimeFormat = new SimpleDateFormat(XMLSCHEMA_TIME_FORMAT);
            this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_FORMAT);
        }
        if (old != null) {
            this.datetimeFormat.setTimeZone(old.getTimeZone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String format, String text) throws ParseException {
        DateFormat df = null;
        if (DATE_FORMAT == format) {
            df = sharedDateFormat;
        } else if (DATETIME_FORMAT == format) {
            df = sharedDateTimeFormat;
        } else if (XMLSCHEMA_DATETIME_FORMAT == format) {
            df = sharedXmlSchemaDateTimeFormat;
        } else if (XMLSCHEMA_TIME_FORMAT == format) {
            df = sharedXmlSchemaTimeFormat;
        } else if (DATETIME_MILLIS_FORMAT == format) {
            df = sharedDateTimeMillisFormat;
        } else if (XMLSCHEMA_DATETIME_MILLIS_FORMAT == format) {
            df = sharedXmlSchemaDateTimeMillisFormat;
        } else if (XMLSCHEMA_TIME_MILLIS_FORMAT == format) {
            df = sharedXmlSchemaTimeMillisFormat;
        }
        if (df != null) {
            DateFormat dateFormat = df;
            synchronized (dateFormat) {
                return df.parse(text);
            }
        }
        df = new SimpleDateFormat(format);
        return df.parse(text);
    }

    public ValidationContext getTypeLookupVC() {
        return this.typeLookupVC;
    }

    public void setTypeLookupVC(ValidationContext typeLookupVC) {
        this.typeLookupVC = typeLookupVC;
    }

    public static JSTranslater instance() {
        return new JSTranslater();
    }

    public JSTranslater() {
        this.datetimeFormat = "original".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_FORMAT) : ("xmlSchema".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(XMLSCHEMA_DATETIME_FORMAT) : ("originalMillis".equalsIgnoreCase(datetimeOutputFormat) ? new SimpleDateFormat(DATETIME_MILLIS_FORMAT) : new SimpleDateFormat(XMLSCHEMA_DATETIME_MILLIS_FORMAT)));
        this.setUseUTCInXMLSchemaDates(true);
        this.cacheCalendar = Calendar.getInstance();
    }

    public static JSTranslater get() {
        JSTranslater jsTrans = new JSTranslater();
        return jsTrans;
    }

    public JSTranslater enablePrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public JSTranslater enablePrettyPrinting(boolean value) {
        this.prettyPrinting = value;
        return this;
    }

    public JSTranslater omitNullMapValues(boolean value) {
        this.omitNullMapValues = value;
        return this;
    }

    public JSTranslater collapseSmallContainers(boolean value) {
        collapseSmallContainers = value;
        return this;
    }

    public void quoteForTextArea() {
        this.quoteForTextArea = true;
        this.quoteForXML = false;
    }

    public void quoteForXML() {
        this.quoteForXML = true;
        this.quoteForTextArea = false;
    }

    public void strictJSONMode() {
        this.strictJSONMode = true;
    }

    public void setStrictJSONMode(boolean value) {
        this.strictJSONMode = value;
    }

    public boolean getStrictJSONMode() {
        return this.strictJSONMode;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.getDefaultLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getDefaultLocale() {
        if (this.defaultLocale != null) {
            return this.defaultLocale;
        }
        String localeName = config.getString("defaultLocale");
        if (localeName == null) {
            if (!this.defaultLocaleWarningLogged) {
                log.warn("defaultLocale could not be read from server.properties");
            }
            this.defaultLocaleWarningLogged = true;
            this.defaultLocale = null;
            return null;
        }
        String[] localeElements = localeName.split("_");
        if (localeElements.length == 1) {
            this.defaultLocale = new Locale(localeElements[0]);
            return this.defaultLocale;
        }
        if (localeElements.length == 2) {
            this.defaultLocale = new Locale(localeElements[0], localeElements[1]);
            return this.defaultLocale;
        }
        if (localeElements.length == 3) {
            this.defaultLocale = new Locale(localeElements[0], localeElements[1], localeElements[2]);
            return this.defaultLocale;
        }
        if (!this.defaultLocaleWarningLogged) {
            log.warn("The defaultLocale read from server.properties is '" + localeName + "', which is not a valid value");
        }
        this.defaultLocaleWarningLogged = true;
        this.defaultLocale = null;
        return null;
    }

    public void alwaysToString() {
        this.alwaysToString = true;
    }

    public void alwaysToString(boolean toString) {
        this.alwaysToString = toString;
    }

    public void setUseSchema() {
        this.useSchema = true;
    }

    public void setUseSchema(boolean value) {
        this.useSchema = value;
    }

    public void indent(int numChars, Writer out) throws IOException {
        for (int ii = 0; ii < numChars; ++ii) {
            out.write(" ");
        }
    }

    public void indentToCurrentDepth(Writer out) throws IOException {
        for (int ii = 0; ii < this.currentIndentDepth; ++ii) {
            out.write("    ");
        }
    }

    public boolean safeToString(Object javaObj) {
        String className = javaObj.getClass().getName();
        return safeToString.contains(className);
    }

    public void preserveLiteralNulls(boolean b) {
        this.preserveLiteralNulls = b;
    }

    public String toJS(Object javaObj) throws UnconvertableException {
        try {
            StringWriter out = new StringWriter();
            this.toJS(javaObj, out);
            return out.toString();
        }
        catch (IOException e) {
            log.error("IOException from StringWriter on toJS (should be impossible)");
            throw new UnconvertableException("IOException from StringWriter");
        }
    }

    public synchronized void toJS(Object javaObj, Writer out) throws UnconvertableException, IOException {
        long start = System.currentTimeMillis();
        if (this.recursedList == null) {
            this.recursionCount = 0;
        }
        if (this.recursionCount == 0) {
            this.recursedList = new ArrayList();
        }
        ++this.recursionCount;
        try {
            this.convert(javaObj, out);
        }
        catch (IOException ioe) {
            this.recursionCount = 1;
            throw ioe;
        }
        catch (UnconvertableException ue) {
            this.recursionCount = 1;
            throw ue;
        }
        finally {
            --this.recursionCount;
            if (this.recursionCount == 0) {
                this.recursedList = null;
            }
        }
        if (javaObj != null && !this.isLeaf(javaObj)) {
            long end = System.currentTimeMillis();
            Logger.timing.debug("Time to convert " + javaObj.getClass().getName() + " to JS Object: " + (end - start) + "ms");
        }
    }

    private String convert(Object javaObj) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        this.convert(javaObj, out);
        return out.toString();
    }

    private void convert(Object javaObj, Writer out) throws UnconvertableException, IOException {
        this.convert(javaObj, out, null);
    }

    private void convert(Object javaObj, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        Object obj;
        int i;
        boolean validationContextWasNull = false;
        if (this.validationContext == null) {
            this.validationContext = new ValidationContext();
            this.validationContext.setUseSchema(this.useSchema);
            validationContextWasNull = true;
        }
        if (javaObj instanceof JSONFilter) {
            JSONFilter filter = (JSONFilter)javaObj;
            javaObj = filter.getObj();
            beanFilter = filter.getBeanFilter();
        }
        if (this.convertSimple(javaObj, out)) {
            if (validationContextWasNull) {
                this.validationContext.freeResources();
                this.validationContext = null;
            }
            return;
        }
        ArrayList<Object> recursedList = this.recursedList;
        if (recursedList == null) {
            log.warn("can't find current recursion set - recursion check disabled for this call.");
            log.debug((Object)"Stack trace for recursedList not found", new Exception());
            recursedList = new ArrayList<Object>();
        }
        if (javaObj != null) {
            for (i = recursedList.size() - 1; i >= 0; --i) {
                obj = recursedList.get(i);
                if (javaObj != obj) continue;
                log.warn(javaObj.getClass().getName() + " contains a (potentially indirect) looping" + " reference to itself.  Returning null for recursed value.");
                out.write("null /* loop to object of type: " + javaObj.getClass().getName() + " */");
                if (validationContextWasNull) {
                    this.validationContext.freeResources();
                    this.validationContext = null;
                }
                return;
            }
        }
        recursedList.add(javaObj);
        if (javaObj instanceof IToJSON) {
            ((IToJSON)javaObj).toJSON(out, this);
        } else if (javaObj instanceof IToJavaScript) {
            ((IToJavaScript)javaObj).toJavaScript(out);
        } else if (javaObj instanceof Map) {
            this.convertMap((Map)javaObj, out, beanFilter);
        } else if (javaObj instanceof Collection) {
            this.convertCollection((Collection)javaObj, out, beanFilter);
        } else if (javaObj instanceof Object[]) {
            this.convertArray((Object[])javaObj, out, beanFilter);
        } else if (javaObj != null && javaObj.getClass().isArray()) {
            this.convertPrimitiveArray(javaObj, out, beanFilter);
        } else if (javaObj instanceof Iterator) {
            this.convertIterator((Iterator)javaObj, out, beanFilter);
        } else if (javaObj instanceof Enumeration) {
            this.convertEnumeration((Enumeration)javaObj, out, beanFilter);
        } else {
            if (javaObj instanceof Element) {
                try {
                    Element element = (Element)javaObj;
                    if (log.isDebugEnabled()) {
                        log.debug("XML Element '" + element.getTagName() + "' being transformed as part of JS translation");
                    }
                    this.convert(DataSource.recordsFromXML(element, this.validationContext), out, beanFilter);
                }
                catch (Exception e) {
                    if (validationContextWasNull) {
                        this.validationContext.freeResources();
                        this.validationContext = null;
                    }
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
            if (javaObj instanceof Document) {
                this.convert(((Document)javaObj).getDocumentElement(), out, beanFilter);
            } else if ("org.codehaus.groovy.runtime.GStringImpl".equals(javaObj.getClass().getName())) {
                this.convert(javaObj.toString(), out, beanFilter);
            } else {
                try {
                    Map propertyMap = null;
                    propertyMap = beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(javaObj, this.typeLookupVC) : (beanFilter != null ? beanFilter.filter(javaObj) : DataTools.getProperties(javaObj));
                    if (propertyMap.containsKey("class")) {
                        propertyMap.remove("class");
                    }
                    this.convertMap(propertyMap, out, null);
                }
                catch (Exception e) {
                    if (validationContextWasNull) {
                        this.validationContext.freeResources();
                        this.validationContext = null;
                    }
                    throw new UnconvertableException(DataTools.getStackTrace(e));
                }
            }
        }
        for (i = recursedList.size() - 1; i >= 0; --i) {
            obj = recursedList.get(i);
            if (obj != javaObj) continue;
            recursedList.remove(i);
            break;
        }
        if (validationContextWasNull) {
            this.validationContext.freeResources();
            this.validationContext = null;
        }
    }

    private String convertSimple(Object javaObj) throws UnconvertableException, IOException {
        StringWriter out = new StringWriter();
        if (this.convertSimple(javaObj, out)) {
            return out.toString();
        }
        return null;
    }

    private boolean convertSimple(Object javaObj, Writer out) throws UnconvertableException, IOException {
        if (javaObj instanceof String) {
            this.convertString((String)javaObj, out);
        } else if (javaObj instanceof Character) {
            this.convertString(String.valueOf((Character)javaObj), out);
        } else if (javaObj instanceof LocaleMessage) {
            this.convertString(((LocaleMessage)javaObj).getMessage(this.getLocale()), out);
        } else if (javaObj instanceof Clob) {
            this.convertSqlClob((Clob)javaObj, out);
        } else if (javaObj instanceof Date) {
            this.convertDate((Date)javaObj, out);
        } else if (javaObj instanceof Calendar) {
            this.convertDate(((Calendar)javaObj).getTime(), out);
        } else if (javaObj instanceof Number) {
            if (bigIntegerAsString && javaObj instanceof Long) {
                long l = (Long)javaObj;
                if (l < -9007199254740992L || l > 0x20000000000000L) {
                    out.write("\"");
                    out.write(javaObj.toString());
                    out.write("\"");
                } else {
                    out.write(javaObj.toString());
                }
            } else if (bigIntegerAsString && javaObj instanceof BigInteger) {
                BigInteger l = (BigInteger)javaObj;
                if (l.compareTo(new BigInteger("-9007199254740992")) < 0 || l.compareTo(new BigInteger("9007199254740992")) > 0) {
                    out.write("\"");
                    out.write(javaObj.toString());
                    out.write("\"");
                } else {
                    out.write(javaObj.toString());
                }
            } else if (bigDecimalAsString && javaObj instanceof BigDecimal) {
                out.write("\"");
                out.write(javaObj.toString());
                out.write("\"");
            } else {
                out.write(javaObj.toString());
            }
        } else if (javaObj instanceof Boolean) {
            out.write((Boolean)javaObj != false ? "true" : "false");
        } else if (javaObj instanceof Class) {
            this.convertString(((Class)javaObj).getName(), out);
        } else if (javaObj == null) {
            out.write("null");
        } else if (javaObj instanceof byte[]) {
            this.convertByteBuffer((byte[])javaObj, out);
        } else if (javaObj instanceof Reader) {
            this.convertReader((Reader)javaObj, out);
        } else if (VersionSafeChecker.isEnum(javaObj)) {
            this.convertEnum((Enum)javaObj, out);
        } else {
            if ("oracle.sql.TIMESTAMP".equals(javaObj.getClass().getName())) {
                try {
                    return this.convertSimple(Reflection.invokeMethod(javaObj, "timestampValue"), out);
                }
                catch (Exception e) {
                    throw new UnconvertableException(e.getMessage());
                }
            }
            String className = javaObj.getClass().getName();
            if (sendAsJSString.contains(className)) {
                this.convertString(javaObj.toString(), out);
                return true;
            }
            if (this.alwaysToString || safeToString.contains(className)) {
                out.write(javaObj.toString());
                return true;
            }
            return false;
        }
        return true;
    }

    private String convertMapKey(Object javaObj) throws UnconvertableException, IOException {
        String convertedKey;
        if (javaObj instanceof Date) {
            return null;
        }
        String string = convertedKey = javaObj instanceof String ? (String)javaObj : this.convertSimple(javaObj);
        if (convertedKey == null) {
            return null;
        }
        if (!(convertedKey.startsWith("\"") || convertedKey.startsWith("'") || !this.strictJSONMode && !reservedWords.contains(convertedKey) && JSTranslater.isValidJSIdentifier(convertedKey))) {
            convertedKey = this.convertSimple(convertedKey);
        }
        return convertedKey;
    }

    boolean isAList(Object obj) {
        return obj instanceof Object[] || obj instanceof Collection || obj instanceof Iterator || obj instanceof Enumeration;
    }

    void convertByteBuffer(byte[] buf, Writer out) throws UnconvertableException, IOException {
        String theString = new String(buf);
        out.write("\"");
        if (theString != null) {
            out.write(theString);
        }
        out.write("\"");
    }

    void convertReader(Reader reader, Writer out) throws UnconvertableException, IOException {
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(reader, sw);
        this.convertString(sw.toString(), out);
    }

    void convertEnum(Enum e, Writer out) throws UnconvertableException, IOException {
        if (this.enumTranslateStrategy == null) {
            out.write("\"" + e.toString() + "\"");
        } else if (this.enumTranslateStrategy.toLowerCase().equals("name")) {
            out.write("\"" + e.name() + "\"");
        } else if (this.enumTranslateStrategy.toLowerCase().equals("ordinal")) {
            out.write(String.valueOf(e.ordinal()));
        } else if (this.enumTranslateStrategy.toLowerCase().equals("bean")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.ordinalProperty, new Integer(e.ordinal()));
            map.put(this.constantProperty, e.toString());
            Map<String, PropertyDescriptor> propMap = null;
            try {
                propMap = DataTools.getPropertyDescriptors(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (propMap != null) {
                for (String propName : propMap.keySet()) {
                    Method readMethod;
                    PropertyDescriptor prop;
                    if ("class".equals(propName) || "declaringClass".equals(propName) || (prop = propMap.get(propName)) == null || (readMethod = prop.getReadMethod()) == null) continue;
                    try {
                        Object value = readMethod.invoke((Object)e, null);
                        map.put(propName, value);
                    }
                    catch (Exception ex) {
                        log.warn(e);
                    }
                }
            }
            this.convertMap(map, out, null);
        } else {
            out.write("\"" + e.toString() + "\"");
        }
    }

    boolean isLeaf(Object value) {
        if (value == null || value instanceof String) {
            return true;
        }
        if (value instanceof Collection || value instanceof Map || value instanceof Object[]) {
            return false;
        }
        return value instanceof Integer || value instanceof Boolean || value instanceof Float || value instanceof Date || value instanceof Time || this.safeToString(value);
    }

    boolean containsOnlyLeaves(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            if (this.isLeaf(i.next())) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyLeaves(Map map) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (this.isLeaf(key) && this.isLeaf(value)) continue;
            return false;
        }
        return true;
    }

    void convertMap(Map inputMap, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        Object constructorObj;
        Object map = inputMap.getClass().getName().equals("org.hibernate.util.IdentityMap") || inputMap.getClass().getName().equals("org.hibernate.internal.util.collections.IdentityMap") ? new LinkedMap(inputMap) : inputMap;
        boolean collapse = false;
        if (this.prettyPrinting && collapseSmallContainers) {
            if (this.containsOnlyLeaves((Map)map)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        String constructor = null;
        if (map.containsKey("__autoConstruct") && (constructorObj = map.get("__autoConstruct")) != null) {
            constructor = constructorObj.toString();
            if (constructor.contains(".")) {
                out.write("isc.ClassFactory.newInstance(\"" + constructor + "\", ");
            } else {
                out.write("isc." + constructor + ".create(");
            }
        }
        if (map.containsKey("isDSResponse") && DataTools.getBoolean((Map)map, "isDSResponse", false) && map.containsKey("dataSource")) {
            DataSource ds = null;
            try {
                ds = DataSourceManager.get((String)map.get("dataSource"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ds != null) {
                this.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
                this.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
                this.setEnumConstantProperty(ds.getEnumConstantProperty());
                DataSourceManager.free(ds);
            }
        }
        out.write("{");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int elemLength = 0;
        boolean dropLine = true;
        boolean startingLine = true;
        if (beanFilter != null) {
            try {
                map = beanFilter instanceof IContextBeanFilter ? ((IContextBeanFilter)beanFilter).filter(map, this.typeLookupVC) : beanFilter.filter(map);
            }
            catch (Exception e) {
                log.warn((Object)"Error in convertMap trying to filter bean", e);
                throw new UnconvertableException("Error in convertMap trying to filter bean: " + e.getMessage());
            }
        }
        Set mapKeys = map.keySet();
        if (constructor != null) {
            mapKeys = new LinkedHashSet(mapKeys);
            mapKeys.remove("__autoConstruct");
        }
        Object obfuscatedValueInAdvancedCriteria = null;
        if (this.obfuscation && this.obfuscateMapKeys != null && mapKeys.contains("fieldName") && mapKeys.contains("operator") && mapKeys.contains("value")) {
            obfuscatedValueInAdvancedCriteria = this.obfuscateMapKeys.get(map.get("fieldName"));
        }
        boolean hadOneKey = false;
        for (Object key : mapKeys) {
            String convertedKey;
            Object obfuscatedValue;
            Object value = map.get(key);
            if (this.omitNullMapValues && value == null || ISCBinaryValue.isBinary(value)) continue;
            if (this.obfuscation && this.obfuscateMapKeys != null && value != null && (value instanceof String || DataTools.isNumberType(value.getClass())) && (obfuscatedValue = this.obfuscateMapKeys.get(key)) != null) {
                value = obfuscatedValue;
            }
            if ("value".equals(key) && value instanceof String && obfuscatedValueInAdvancedCriteria != null) {
                value = obfuscatedValueInAdvancedCriteria;
            }
            if ((convertedKey = this.convertMapKey(key)) == null) {
                log.info("Ignoring unconvertible Map key of type: " + key.getClass().getName());
                continue;
            }
            String convertedValue = this.convert(value);
            if (collapse) {
                elemLength = convertedKey.length() + convertedValue.length() + 2;
                boolean bl = dropLine = !collapse || !startingLine && elemLength + linePos > 100;
            }
            if (hadOneKey) {
                out.write(",");
                if (!dropLine) {
                    out.write(" ");
                }
            } else {
                hadOneKey = true;
            }
            if (this.prettyPrinting) {
                if (dropLine) {
                    out.write("\n");
                    this.indentToCurrentDepth(out);
                    startingLine = true;
                    if (collapse) {
                        this.indent(this.propNameIndent + 1, out);
                        linePos = this.currentIndentDepth * 4 + this.propNameIndent + 1;
                    }
                } else {
                    startingLine = false;
                }
                linePos += elemLength;
            }
            out.write(convertedKey);
            if (this.prettyPrinting && !collapse) {
                this.propNameIndent = convertedKey.length() + 1;
            }
            out.write(":");
            out.write(convertedValue);
            if (!this.prettyPrinting || collapse) continue;
            this.propNameIndent = 0;
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("}");
        } else {
            out.write("}");
        }
        if (constructor != null) {
            out.write(")\n");
        }
    }

    void convertArray(Object[] array, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertCollection(Arrays.asList(array), out, beanFilter);
    }

    void convertPrimitiveArray(Object array, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        if (array instanceof boolean[]) {
            this.convertArray(ArrayUtils.toObject((boolean[])((boolean[])array)), out, beanFilter);
        } else if (array instanceof char[]) {
            this.convertArray(ArrayUtils.toObject((char[])((char[])array)), out, beanFilter);
        } else if (array instanceof byte[]) {
            this.convertArray(ArrayUtils.toObject((byte[])((byte[])array)), out, beanFilter);
        } else if (array instanceof double[]) {
            this.convertArray(ArrayUtils.toObject((double[])((double[])array)), out, beanFilter);
        } else if (array instanceof float[]) {
            this.convertArray(ArrayUtils.toObject((float[])((float[])array)), out, beanFilter);
        } else if (array instanceof int[]) {
            this.convertArray(ArrayUtils.toObject((int[])((int[])array)), out, beanFilter);
        } else if (array instanceof short[]) {
            this.convertArray(ArrayUtils.toObject((short[])((short[])array)), out, beanFilter);
        } else if (array instanceof long[]) {
            this.convertArray(ArrayUtils.toObject((long[])((long[])array)), out, beanFilter);
        } else {
            String error = "Unknown array of primitive type." + (array == null ? "null" : array.getClass().getName());
            log.error(error);
            throw new UnconvertableException(error);
        }
    }

    void convertCollection(Collection collection, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        boolean collapse = false;
        if (this.prettyPrinting && collapseSmallContainers) {
            if (this.containsOnlyLeaves(collection)) {
                collapse = true;
            } else {
                this.propNameIndent = 0;
            }
        }
        this.convertIterator(collection.iterator(), out, beanFilter, collapse);
    }

    void convertIterator(Iterator list, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertIterator(list, out, beanFilter, false);
    }

    void convertIterator(Iterator iterator, Writer out, IBeanFilter beanFilter, boolean collapse) throws UnconvertableException, IOException {
        out.write("[");
        if (this.prettyPrinting && !collapse) {
            ++this.currentIndentDepth;
        }
        int linePos = this.currentIndentDepth * 4;
        int itemLength = 0;
        boolean dropLine = true;
        boolean typeLookupVCWasNull = false;
        if (this.typeLookupVC == null) {
            this.typeLookupVC = new ValidationContext();
            typeLookupVCWasNull = true;
        }
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (collapse) {
                itemLength = this.convert(item).length() + 2;
                boolean bl = dropLine = itemLength + linePos > 100;
            }
            if (this.prettyPrinting && dropLine) {
                out.write("\n");
                this.indentToCurrentDepth(out);
                if (collapse) {
                    this.indent(this.propNameIndent + 1, out);
                }
                linePos = this.currentIndentDepth * 4 + this.propNameIndent;
            } else {
                linePos += itemLength;
            }
            this.convert(item, out, this.isAList(item) ? null : beanFilter);
            if (!iterator.hasNext()) continue;
            out.write(",");
            if (dropLine) continue;
            out.write(" ");
        }
        if (this.prettyPrinting) {
            if (!collapse) {
                out.write("\n");
                --this.currentIndentDepth;
                this.indentToCurrentDepth(out);
            }
            out.write("]");
        } else {
            out.write("]");
        }
        if (typeLookupVCWasNull) {
            this.typeLookupVC.freeResources();
            this.typeLookupVC = null;
        }
    }

    void convertEnumeration(final Enumeration e, Writer out, IBeanFilter beanFilter) throws UnconvertableException, IOException {
        this.convertIterator(new Iterator(){

            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            public void remove() {
            }
        }, out, beanFilter);
    }

    void convertDate(Date date, Writer out) throws UnconvertableException, IOException {
        if (this.writeXMLSchemaDate) {
            if (date instanceof ISCDate) {
                out.write("\"" + this.dateFormat.format(date) + "\"");
            } else if (date instanceof ISCTime) {
                out.write("\"" + this.xmlSchemaTimeFormat.format(date) + "\"");
            } else {
                out.write("\"" + this.datetimeFormat.format(date) + "\"");
            }
        } else if (this.writePrefixedDate) {
            out.write("\"$$DATE$$:");
            out.write(DataTools.fastDateFormat(date, false, false, this.cacheCalendar, this.trimMilliseconds));
            out.write("\"");
        } else if (this.strictJSONMode) {
            if (date instanceof ISCDate) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                out.write("\"$$DATE$$:" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + "\"");
            } else if (date instanceof ISCTime) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                String output = "\"$$TIME$$:" + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
                if (!this.trimMilliseconds) {
                    output = output + "." + calendar.get(14);
                }
                output = output + "\"";
                out.write(output);
            } else {
                out.write("\"$$DATESTAMP$$:");
                long millis = date.getTime();
                if (this.trimMilliseconds) {
                    millis /= 1000L;
                    millis *= 1000L;
                }
                out.write(String.valueOf(millis));
                out.write("\"");
            }
        } else if (date instanceof ISCDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String dateArgs = calendar.get(1) + "," + calendar.get(2) + "," + calendar.get(5);
            if (writeNativeDate) {
                out.write("new Date(" + dateArgs + ")");
            } else {
                out.write("Date.parseServerDate(" + dateArgs + ")");
            }
        } else if (date instanceof ISCTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            String timeArgs = calendar.get(11) + "," + calendar.get(12) + "," + calendar.get(13);
            if (!this.trimMilliseconds) {
                timeArgs = timeArgs + "," + calendar.get(14);
            }
            out.write("Date.parseServerTime(" + timeArgs + ")");
        } else {
            long millis = date.getTime();
            if (this.trimMilliseconds) {
                millis /= 1000L;
                millis *= 1000L;
            }
            out.write("new Date(" + millis + ")");
        }
    }

    void convertSqlClob(Clob clob, Writer out) throws UnconvertableException, IOException {
        try {
            this.convertString(clob.getSubString(1L, (int)clob.length()), out);
        }
        catch (SQLException se) {
            log.error((Object)"Error converting Clob", se);
            throw new UnconvertableException(se.toString());
        }
    }

    void convertString(String value, Writer out) throws UnconvertableException, IOException {
        out.write("\"");
        boolean substituting = false;
        int copiedFrom = 0;
        int length = value.length();
        block13: for (int i = 0; i < length; ++i) {
            char quote = value.charAt(i);
            switch (quote) {
                case '<': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&lt;");
                        copiedFrom = i + 1;
                        continue block13;
                    }
                    if (length <= i + 8 || value.charAt(i + 1) != '/') continue block13;
                    if (!this.quoteForTextArea && value.regionMatches(true, i + 2, "script>", 0, 7)) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("<\\");
                        out.write(value.substring(i + 1, i + 9));
                        copiedFrom = i + 9;
                        i += 8;
                        continue block13;
                    }
                    if (!this.quoteForTextArea || !value.regionMatches(true, i + 2, "textarea>", 0, 9)) continue block13;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("<\\");
                    out.write(value.substring(i + 1, i + 11));
                    copiedFrom = i + 11;
                    i += 10;
                    continue block13;
                }
                case '>': {
                    if (!this.quoteForXML) continue block13;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&gt;");
                    copiedFrom = i + 1;
                    continue block13;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    switch (quote) {
                        case '\r': {
                            out.write("\\r");
                            break;
                        }
                        case '\n': {
                            out.write("\\n");
                            break;
                        }
                        case '\"': {
                            out.write("\\\"");
                            break;
                        }
                        case '\\': {
                            out.write("\\\\");
                            break;
                        }
                        case '\t': {
                            out.write("\\t");
                        }
                    }
                    copiedFrom = i + 1;
                    continue block13;
                }
                case '&': {
                    if (this.quoteForXML) {
                        substituting = true;
                        out.write(value.substring(copiedFrom, i));
                        out.write("&amp;");
                        copiedFrom = i + 1;
                        continue block13;
                    }
                    if (!this.quoteForTextArea || value.length() > i + 1 && " \n\r".indexOf(value.charAt(i + 1)) != -1) continue block13;
                    substituting = true;
                    out.write(value.substring(copiedFrom, i));
                    out.write("&amp;");
                    copiedFrom = i + 1;
                }
            }
        }
        if (substituting) {
            out.write(value.substring(copiedFrom));
        } else {
            out.write(value);
        }
        out.write("\"");
    }

    public void toJSVariableInScript(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("<SCRIPT>\n");
        this.toJSVariable(javaObj, variableName, out);
        out.write("</SCRIPT>\n");
    }

    public void toJSVariable(Object javaObj, String variableName, Writer out) throws UnconvertableException, IOException {
        if (variableName == null) {
            return;
        }
        out.write("var " + variableName + " = ");
        this.toJS(javaObj, out);
        out.write(";\n");
    }

    public Map fromJS(Map params) {
        LinkedMap result = new LinkedMap();
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            if (value == null || value.length() == 0 || value.equals("null")) continue;
            try {
                result.put(key, this.fromJS(value));
            }
            catch (UnconvertableException ue) {
                log.error("Value " + value + " for key " + key + " is unconvertable, ignoring.");
            }
        }
        return result;
    }

    public Object fromJS(String jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        return this.fromJS(new StringReader(jsData));
    }

    public Object fromJS(InputStream jsData) throws UnconvertableException {
        return this.fromJS(new InputStreamReader(jsData));
    }

    public Object fromJS(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            parser.preserveLiteralNulls(this.preserveLiteralNulls);
            return parser.parseDataStruct(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error(error);
            throw new UnconvertableException(error, pe);
        }
    }

    public Object fromJSMap(String jsData) throws UnconvertableException {
        return this.fromJSMap(new StringReader(jsData));
    }

    public Object fromJSMap(InputStream jsData) throws UnconvertableException {
        return this.fromJSMap(new InputStreamReader(jsData));
    }

    public Object fromJSMap(Reader jsData) throws UnconvertableException {
        if (jsData == null) {
            return null;
        }
        try {
            IJSParser parser = (IJSParser)InterfaceProvider.load("IJSParser");
            return parser.parseDataMap(this.getEOFReader(jsData));
        }
        catch (Exception pe) {
            String error = "parse failure: \n" + pe.toString();
            log.error((Object)error, pe);
            throw new UnconvertableException(error);
        }
    }

    private Reader getEOFReader(Reader in) throws IOException {
        return new SequenceReader(in, "//>START PARSING\n");
    }

    public static boolean isValidJSIdentifier(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        int length = str.length();
        if (!JSTranslater.isJSIdentifierStart(c)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = str.charAt(i);
            if (JSTranslater.isJSIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isJSIdentifierPart(char c) {
        return JSTranslater.isJSIdentifierStart(c) || Character.isDigit(c);
    }

    public static boolean isJSIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    public static boolean isJSReservedWord(String s) {
        return reservedWords.contains(s);
    }

    public String getEnumTranslateStrategy() {
        return this.enumTranslateStrategy;
    }

    public void setEnumTranslateStrategy(String newValue) {
        if (newValue != null) {
            this.enumTranslateStrategy = newValue;
        }
    }

    public String getEnumOrdinalProperty() {
        return this.ordinalProperty;
    }

    public String getEnumConstantProperty() {
        return this.enumTranslateStrategy;
    }

    public void setEnumOrdinalProperty(String newValue) {
        if (newValue != null) {
            this.ordinalProperty = newValue;
        }
    }

    public void setEnumConstantProperty(String newValue) {
        if (newValue != null) {
            this.constantProperty = newValue;
        }
    }

    static {
        TimeZone z = TimeZone.getTimeZone("UTC");
        sharedDateTimeFormat.setTimeZone(z);
        sharedXmlSchemaDateTimeFormat.setTimeZone(z);
        EMPTY_ARRAY = new Object[0];
        types = new HashMap();
        safeToString = new HashSet();
        sendAsJSString = new HashSet();
        sendAsJSString.addAll(Arrays.asList("java.net.URL", "java.net.URI"));
        reservedWords = new HashSet();
        reservedWords.addAll(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with", "debugger", "undefined"));
    }
}

