/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;

public class ISCHttpClient
extends Base {
    private static Logger log = new Logger(ISCHttpClient.class.getName());
    private static boolean acceptInvalidSSL = config.getBoolean((Object)"HttpProxyServlet.acceptInvalidAndExpiredSSLCertificates", false);
    private boolean _warnOnStatusNotOk = false;
    HttpClient httpClient = new HttpClient();
    HttpMethod httpMethod;

    public ISCHttpClient setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ISCHttpClient setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public ISCHttpClient warnOnStatusNotOk(boolean value) {
        this._warnOnStatusNotOk = value;
        return this;
    }

    public ByteArrayInputStream GET(String url) throws Exception {
        if (this.httpMethod == null) {
            this.httpMethod = new GetMethod(url);
        }
        this.httpMethod.setFollowRedirects(true);
        ((HttpMethodBase)this.httpMethod).setHttp11(true);
        byte[] responseBody = this._httpExecute(this.httpClient, this.httpMethod);
        return responseBody != null ? new ByteArrayInputStream(responseBody) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] _httpExecute(HttpClient httpClient, HttpMethod httpMethod) {
        byte[] responseBody = null;
        try {
            int statusCode = httpClient.executeMethod(httpMethod);
            if (statusCode == 200) {
                responseBody = httpMethod.getResponseBody();
            } else if (this._warnOnStatusNotOk) {
                log.warn(httpMethod.getName() + " " + httpMethod.getURI() + " failed with http code: " + statusCode);
            }
            byte[] byArray = responseBody;
            return byArray;
        }
        catch (HttpException e) {
            log.warn((Object)"Fatal protocol violation", e);
        }
        catch (IOException e) {
            log.warn((Object)"Fatal transport error: ", e);
        }
        finally {
            try {
                httpMethod.releaseConnection();
            }
            catch (Exception e) {}
        }
        return null;
    }
}

