/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.xml;

import com.isomorphic.js.JSTranslater;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.util.IOUtil;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;

public class XMLSelectServlet
extends BaseServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Reader requestReader = request.getReader();
            if (this.log.isDebugEnabled()) {
                StringWriter requestBuffer = new StringWriter();
                IOUtil.copyCharacterStreams(requestReader, requestBuffer);
                this.log.debug("Parsing SOAP message: " + requestBuffer.toString());
                requestReader = new StringReader(requestBuffer.toString());
            }
            Object soapMessage = XML.toDSRecords(requestReader);
            this.log.debug(soapMessage.toString());
            JXPathContext jxpathContext = JXPathContext.newContext((Object)soapMessage);
            jxpathContext.setLenient(true);
            String fileName = (String)jxpathContext.getValue("/fileName");
            String selector = (String)jxpathContext.getValue("/selection");
            String outputType = (String)jxpathContext.getValue("/outputType");
            if (outputType == null) {
                outputType = "XML";
            }
            HashMap namespaces = new HashMap();
            this.log.debug("Slicing out: " + selector + " from: " + fileName);
            Document document = XML.getXMLDocument(fileName);
            List xmlSlice = XML.selectNodes(document, selector, namespaces);
            if ("JS".equals(outputType)) {
                response.setContentType("text/javascript; charset=UTF-8");
                PrintWriter out = response.getWriter();
                JSTranslater jsTrans = JSTranslater.instance();
                jsTrans.setObfuscation(false);
                Iterator i = xmlSlice.iterator();
                while (i.hasNext()) {
                    jsTrans.toJS(i.next(), out);
                }
            } else {
                response.setContentType("text/xml; charset=UTF-8");
                PrintWriter out = response.getWriter();
                ((Writer)out).write("<?xml version='1.0' encoding='UTF-8'?>");
                ((Writer)out).write("<response>");
                XML.toXML((Writer)out, xmlSlice, XML.getUnchangedTransformer());
                ((Writer)out).write("</response>");
            }
        }
        catch (Exception e) {
            this.handleError(response, e);
        }
        finally {
            try {
                response.flushBuffer();
            }
            catch (Exception exception) {}
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

