/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.base.Config;
import com.isomorphic.log.ANSIColorizedPatternLayout;
import com.isomorphic.log.ILogger;
import com.isomorphic.log.Level;
import com.isomorphic.log.Log4jLogger;
import com.isomorphic.log.Slf4jLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Logger {
    public static Logger auth;
    public static Logger timing;
    public static Logger validation;
    public static Logger fileSandbox;
    public static Logger resultData;
    public static Logger download;
    public static Logger global;
    public static final Level OFF;
    public static final Level FATAL;
    public static final Level ERROR;
    public static final Level WARN;
    public static final Level INFO;
    public static final Level DEBUG;
    public static final Level ALL;
    protected static boolean logEnabled;
    private static boolean prefixWithPackage;
    private static Map threadContext;
    private static boolean useSlf4j;
    private static boolean useLog4jConfig;
    public static Set ignoreThreads;
    private static final String DEFAULT_SUBSYSTEM = "Undefined Subsystem";
    private ILogger log;
    private String packageName;
    private String packagePrefix;
    private String messagePrefix;
    public Level level;
    private static Map<String, Level> savedThresholds;

    public static Object getLoggerRepository() {
        return Log4jLogger.getLoggerRepository();
    }

    public static void setLoggerRepository(Object newRepos) {
        Log4jLogger.setLoggerRepository(newRepos);
    }

    public static boolean useLog4j() {
        return useLog4jConfig;
    }

    public static Throwable getRealTargetException(Throwable ite) {
        if (ite instanceof InvocationTargetException) {
            return Logger.getRealTargetException(((InvocationTargetException)ite).getTargetException());
        }
        return ite;
    }

    public static void initialize() {
        Config config = Config.getGlobal();
        if (Logger.useLog4j()) {
            ANSIColorizedPatternLayout.initialize();
        }
        Logger log = new Logger(Logger.class.getName());
        log.info("Logging system started.");
        auth = new Logger("com.isomorphic.auth.Auth");
        timing = new Logger("com.isomorphic.timing.Timing");
        validation = new Logger("com.isomorphic.validation.Validation");
        fileSandbox = new Logger("com.isomorphic.fileSandbox.FileSandbox");
        resultData = new Logger("com.isomorphic.resultData.ResultData");
        download = new Logger("com.isomorphic.download.Download");
        global = new Logger("GLOBAL");
    }

    public static void ignoreThread() {
        if (ignoreThreads == null) {
            ignoreThreads = new HashSet();
        }
        if (!Logger.threadIgnored()) {
            ignoreThreads.add(Thread.currentThread());
        }
    }

    public static void observeThread() {
        if (ignoreThreads != null) {
            ignoreThreads.remove(Thread.currentThread());
        }
    }

    public static boolean threadIgnored() {
        return ignoreThreads != null && ignoreThreads.contains(Thread.currentThread());
    }

    public static Level getLevelForCategory(String category) {
        return Log4jLogger.getLevelForCategory(category);
    }

    public static void setLevelForCategory(String category, Level level) {
        Log4jLogger.setLevelForCategory(category, level);
    }

    public static void setLevelForCategory(String category, String level) {
        Log4jLogger.setLevelForCategory(category, level);
    }

    public static List getCurrentLoggers() {
        return Log4jLogger.getCurrentLoggers();
    }

    private static String prependContext(Object message) {
        Stack s = Logger.getStackForCurrentThread();
        if (s.empty()) {
            return message.toString();
        }
        return s.toString() + " " + message.toString();
    }

    private String prefixMessage(Object message) {
        if (message != null) {
            message = Logger.prependContext(message);
            if (prefixWithPackage) {
                message = this.packagePrefix + message.toString();
            }
            if (this.messagePrefix != null) {
                message = this.messagePrefix + message.toString();
            }
        } else {
            message = "null";
        }
        return message.toString();
    }

    public Logger(Class objClass) {
        this(objClass.getName());
    }

    public Logger(Object obj) {
        this(obj.getClass().getName());
    }

    public Logger(String subsystem) {
        this(subsystem, null);
    }

    public Logger(String subsystem, String messagePrefix) {
        int start = 0;
        int end = 0;
        if (subsystem == null) {
            subsystem = DEFAULT_SUBSYSTEM;
        }
        if (subsystem.indexOf(".") != -1) {
            end = subsystem.lastIndexOf(".");
            start = subsystem.lastIndexOf(".", end - 1);
        }
        this.packageName = start > 0 && end > start ? subsystem.substring(start + 1, end).toUpperCase() : subsystem;
        this.packagePrefix = this.packageName + " - ";
        this.log = !useSlf4j ? new Log4jLogger(subsystem) : new Slf4jLogger(subsystem);
        if (messagePrefix != null) {
            this.messagePrefix = messagePrefix + " - ";
        }
    }

    public Logger() {
        this(DEFAULT_SUBSYSTEM);
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            this.log.fatal(this.prefixMessage(message));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            this.log.fatal(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void fatal(Object message, Object o) {
        if (this.isFatalEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.fatal(message.toString() + ": " + ostring);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            this.log.error(this.prefixMessage(message));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            this.log.error(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void error(Object message, Object o) {
        if (this.isErrorEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.error(message.toString() + ": " + ostring);
        }
    }

    public void warning(Object message) {
        this.warn(message);
    }

    public void warning(Object message, Throwable t) {
        this.warn(message, t);
    }

    public void warning(Object message, Object o) {
        this.warn(message, o);
    }

    public void warn(Object message) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            this.log.warn(this.prefixMessage(message));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            this.log.warn(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void warn(Object message, Object o) {
        if (this.isWarnEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.warn(message.toString() + ": " + ostring);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            this.log.info(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            this.log.info(this.prefixMessage(message));
        }
    }

    public void info(Object message, Object o) {
        if (this.isInfoEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.info(message.toString() + ": " + ostring);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            this.log.debug(this.prefixMessage(message));
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            this.log.debug(this.prefixMessage(message), Logger.getRealTargetException(t));
        }
    }

    public void debug(Object message, Object o) {
        if (this.isDebugEnabled() && !Logger.threadIgnored()) {
            String ostring = "null";
            if (o != null) {
                ostring = o.toString();
            }
            this.debug(message.toString() + ": " + ostring);
        }
    }

    public boolean isFatalEnabled() {
        return this.isEnabledFor(FATAL);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(INFO);
    }

    public boolean isWarnEnabled() {
        return this.isEnabledFor(WARN);
    }

    public boolean isErrorEnabled() {
        return this.isEnabledFor(ERROR);
    }

    public boolean isEnabledFor(Level level) {
        if (!logEnabled) {
            return false;
        }
        if (this.level != null) {
            return level.isGreaterOrEqual(this.level);
        }
        if (FATAL.equals(level)) {
            return this.log.isFatalEnabled();
        }
        if (ERROR.equals(level)) {
            return this.log.isErrorEnabled();
        }
        if (WARN.equals(level)) {
            return this.log.isWarnEnabled();
        }
        if (INFO.equals(level)) {
            return this.log.isInfoEnabled();
        }
        return this.log.isDebugEnabled();
    }

    private static Stack getStackForCurrentThread() {
        Stack s = (Stack)threadContext.get(Thread.currentThread().getName());
        if (s == null) {
            s = new Stack();
            threadContext.put(Thread.currentThread().getName(), s);
        }
        return s;
    }

    public static void pushContext(String message) {
        Stack s = Logger.getStackForCurrentThread();
        s.push(message);
    }

    public static boolean containsContext(String message) {
        Stack s = Logger.getStackForCurrentThread();
        return s.contains(message);
    }

    public static boolean pushUniqueContext(String message) {
        Stack s = Logger.getStackForCurrentThread();
        if (!Logger.containsContext(message)) {
            s.push(message);
            return true;
        }
        return false;
    }

    public static void popContext() {
        Stack s = Logger.getStackForCurrentThread();
        try {
            s.pop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String peekContext() {
        Stack s = Logger.getStackForCurrentThread();
        if (s.empty()) {
            return null;
        }
        return s.toString();
    }

    public static void removeContext() {
        threadContext.remove(Thread.currentThread().getName());
    }

    public Level getLevel() {
        if (Logger.useLog4j()) {
            return this.log.getLevel();
        }
        return null;
    }

    public void setLevel(Level level) {
        if (Logger.useLog4j()) {
            this.log.setLevel(level);
        }
    }

    public Level getInstanceLevel() {
        if (this.level != null) {
            return this.level;
        }
        return this.getLevel();
    }

    public void setInstanceLevel(Level level) {
        this.level = level;
    }

    public static void saveCurrentThreshold(String category) {
        if (Logger.useLog4j()) {
            Level level = Log4jLogger.getLevelForCategory(category);
            savedThresholds.put(category, level);
        }
    }

    public static void restoreSavedThresholds() {
        if (Logger.useLog4j()) {
            for (Map.Entry<String, Level> entry : savedThresholds.entrySet()) {
                Log4jLogger.setLevelForCategory(entry.getKey(), entry.getValue());
            }
            savedThresholds.clear();
        }
    }

    static {
        OFF = new Level(0);
        FATAL = new Level(0);
        ERROR = new Level(3);
        WARN = new Level(4);
        INFO = new Level(6);
        DEBUG = new Level(7);
        ALL = new Level(7);
        logEnabled = true;
        prefixWithPackage = false;
        threadContext = Collections.synchronizedMap(new HashMap());
        useSlf4j = false;
        useLog4jConfig = true;
        try {
            String sUseLog4jConfig;
            String sUseSlf4j;
            String sLogEnabled = System.getProperty("iscLogEnabled");
            if ("false".equals(sLogEnabled)) {
                logEnabled = false;
            }
            if ("true".equals(sUseSlf4j = System.getProperty("iscUseSlf4j"))) {
                useSlf4j = true;
            }
            if (useSlf4j && "false".equals(sUseLog4jConfig = System.getProperty("iscUseLog4jConfig"))) {
                useLog4jConfig = false;
            }
            if (useLog4jConfig) {
                Log4jLogger.init(logEnabled);
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            try {
                sw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("ISC: ERROR: Unable to configure log4j - logging may not be available.\r\n" + sw.toString());
        }
        savedThresholds = Collections.synchronizedMap(new HashMap());
    }
}

