/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferView;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(isJSObject=false)
public class ArrayBufferViewBase
extends ArrayBufferView {
    public void constructor(Object object, Object byteOffset, Object length) {
        if (object instanceof Number) {
            this.constructor(((Number)object).intValue());
        } else if (object instanceof NativeArray) {
            this.constructor((NativeArray)object);
        } else if (object instanceof ArrayBufferViewBase) {
            this.constructor((ArrayBufferViewBase)object);
        } else if (object instanceof ArrayBuffer) {
            double dbLength;
            ArrayBuffer array = (ArrayBuffer)object;
            double dbByteOffset = Context.toNumber((Object)byteOffset);
            if (dbByteOffset != dbByteOffset) {
                dbByteOffset = 0.0;
            }
            if ((dbLength = Context.toNumber((Object)length)) != dbLength) {
                dbLength = array.getByteLength();
            }
            super.constructor(array, (int)dbByteOffset, (int)dbLength);
        } else if (object == Undefined.instance || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TYPED_ARRAYS_NULL)) {
            this.constructor(0);
        } else {
            throw ScriptRuntime.typeError((String)"invalid arguments");
        }
    }

    private void constructor(int length) {
        int byteLength = length * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
    }

    private void constructor(NativeArray array) {
        int byteLength = (int)array.getLength() * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
        this.set((ScriptableObject)array, 0);
    }

    private void constructor(ArrayBufferViewBase array) {
        int byteLength = array.getLength() * this.getBytesPerElement();
        this.setByteLength(byteLength);
        this.initBuffer(byteLength);
        this.set(array, 0);
    }

    private void initBuffer(int lengthInBytes) {
        ArrayBuffer buffer = new ArrayBuffer();
        buffer.constructor(lengthInBytes);
        buffer.setPrototype(this.getPrototype(buffer.getClass()));
        buffer.setParentScope(this.getParentScope());
        this.setBuffer(buffer);
    }

    @JsxGetter
    public int getLength() {
        return this.getByteLength() / this.getBytesPerElement();
    }

    @JsxFunction
    public void set(ScriptableObject sourceArray, int offset) {
        Object lengthProperty = ScriptableObject.getProperty((Scriptable)sourceArray, (String)"length");
        if (lengthProperty instanceof Number) {
            int length = ((Number)lengthProperty).intValue();
            for (int i = 0; i < length; ++i) {
                this.put(i + offset, (Scriptable)this, sourceArray.get((Object)i));
            }
        }
    }

    public Object get(int index, Scriptable start) {
        int offset = index * this.getBytesPerElement() + this.getByteOffset();
        ArrayBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return Scriptable.NOT_FOUND;
        }
        return this.fromArray(buffer.getBytes(), offset);
    }

    public void put(int index, Scriptable start, Object value) {
        this.getBuffer().setBytes(index * this.getBytesPerElement() + this.getByteOffset(), value == null ? this.toArray(null) : this.toArray(Context.toNumber((Object)value)));
    }

    protected byte[] toArray(Number number) {
        return null;
    }

    protected Object fromArray(byte[] array, int offset) {
        return null;
    }

    @JsxFunction
    public ArrayBufferView subarray(int begin, Object end) {
        if (end == Undefined.instance) {
            end = this.getLength();
        }
        try {
            ArrayBufferView object = (ArrayBufferView)this.getClass().newInstance();
            object.setPrototype(this.getPrototype());
            object.setParentScope(this.getParentScope());
            object.constructor(this.getBuffer(), begin, ((Number)end).intValue() - begin);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int getBytesPerElement() {
        return 1;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            int length = this.getLength();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                builder.append(this.get(i, (Scriptable)this));
                if (i >= length - 1) continue;
                builder.append(',');
            }
            return builder.toString();
        }
        return super.getDefaultValue(hint);
    }
}

