/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class History
extends SimpleScriptable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public History() {
    }

    @JsxGetter
    public int getLength() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getLength();
    }

    @JsxGetter
    public Object getState() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getCurrentState();
    }

    @JsxFunction
    public void back() {
        try {
            this.getWindow().getWebWindow().getHistory().back();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void forward() {
        try {
            this.getWindow().getWebWindow().getHistory().forward();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void go(int relativeIndex) {
        try {
            this.getWindow().getWebWindow().getHistory().go(relativeIndex);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void replaceState(Object object, String title, String url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            URL newStateUrl = null;
            HtmlPage page = (HtmlPage)w.getEnclosedPage();
            if (StringUtils.isNotBlank((CharSequence)url)) {
                newStateUrl = page.getFullyQualifiedUrl(url);
            }
            w.getHistory().replaceState(object, newStateUrl);
        }
        catch (MalformedURLException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void pushState(Object object, String title, String url) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            URL newStateUrl = null;
            HtmlPage page = (HtmlPage)w.getEnclosedPage();
            if (StringUtils.isNotBlank((CharSequence)url)) {
                newStateUrl = page.getFullyQualifiedUrl(url);
            }
            w.getHistory().pushState(object, newStateUrl);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF52})
    public String getScrollRestoration() {
        return "auto";
    }
}

