/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.gae.GAEUtils;
import com.gargoylesoftware.htmlunit.protocol.AnyHandler;
import com.gargoylesoftware.htmlunit.protocol.javascript.Handler;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

abstract class URLCreator {
    URLCreator() {
    }

    abstract URL toUrlUnsafeClassic(String var1) throws MalformedURLException;

    abstract String getProtocol(URL var1);

    protected URL toNormalUrl(String url) throws MalformedURLException {
        URL response = new URL(url);
        if (response.getProtocol().startsWith("http") && StringUtils.isEmpty((CharSequence)response.getHost())) {
            throw new MalformedURLException("Missing host name in url: " + url);
        }
        return response;
    }

    static URLCreator getCreator() {
        if (!GAEUtils.isGaeMode()) {
            return new URLCreatorStandard();
        }
        return new URLCreatorGAE();
    }

    static class URLCreatorGAE
    extends URLCreator {
        private static final String PREFIX = "http://gaeHack_";

        URLCreatorGAE() {
        }

        @Override
        URL toUrlUnsafeClassic(String url) throws MalformedURLException {
            if (WebClient.URL_ABOUT_BLANK != null && StringUtils.equalsIgnoreCase((CharSequence)WebClient.URL_ABOUT_BLANK.toExternalForm(), (CharSequence)url)) {
                return WebClient.URL_ABOUT_BLANK;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"javascript:")) {
                return new URL(PREFIX + url.replaceFirst(":", "/"));
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"about:")) {
                return new URL(PREFIX + url.replaceFirst(":", "/"));
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"data:")) {
                return new URL(PREFIX + url.replaceFirst(":", "/"));
            }
            return this.toNormalUrl(url);
        }

        @Override
        String getProtocol(URL url) {
            String stringUrl = url.toString();
            if (stringUrl.startsWith(PREFIX)) {
                int begin = PREFIX.length();
                int end = stringUrl.indexOf("/", begin);
                return stringUrl.substring(begin, end);
            }
            return url.getProtocol();
        }
    }

    static class URLCreatorStandard
    extends URLCreator {
        private static final URLStreamHandler JS_HANDLER = new Handler();
        private static final URLStreamHandler ABOUT_HANDLER = new com.gargoylesoftware.htmlunit.protocol.about.Handler();
        private static final URLStreamHandler DATA_HANDLER = new com.gargoylesoftware.htmlunit.protocol.data.Handler();

        URLCreatorStandard() {
        }

        @Override
        URL toUrlUnsafeClassic(String url) throws MalformedURLException {
            String protocol = StringUtils.substringBefore((String)url, (String)":").toLowerCase(Locale.ROOT);
            if (protocol.isEmpty() || UrlUtils.isNormalUrlProtocol(protocol)) {
                return this.toNormalUrl(url);
            }
            if ("javascript:".equals(protocol + ":")) {
                return new URL(null, url, JS_HANDLER);
            }
            if ("about".equals(protocol)) {
                if (WebClient.URL_ABOUT_BLANK != null && StringUtils.equalsIgnoreCase((CharSequence)WebClient.URL_ABOUT_BLANK.toExternalForm(), (CharSequence)url)) {
                    return WebClient.URL_ABOUT_BLANK;
                }
                return new URL(null, url, ABOUT_HANDLER);
            }
            if ("data".equals(protocol)) {
                return new URL(null, url, DATA_HANDLER);
            }
            return new URL(null, url, AnyHandler.INSTANCE);
        }

        @Override
        String getProtocol(URL url) {
            return url.getProtocol();
        }
    }
}

