/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.base;

import com.isomorphic.base.Config;
import com.isomorphic.base.IConfigLoader;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigLoader
implements IConfigLoader {
    private static Logger log = new Logger(ConfigLoader.class.getName());
    public static String framework = "framework.properties";
    public static String frameworkDevenv = "devenv.framework.properties";
    public static String project = "project.properties";
    public static String devenv = "devenv.properties";
    public static String interfaces = "isc_interfaces.properties";
    public static String server = "server.properties";
    protected static ClassLoader ourClassLoader = Config.class.getClassLoader();
    private static final Pattern VALID_CONFIG_LINE_PATTERN = Pattern.compile("\\s*(.*?)\\s*(:|=)(.*)");

    protected void loadAndMerge(String fileName, String fileLocation, Map accumulator) throws Exception {
        this.loadAndMerge(fileName, fileLocation, accumulator, false, false);
    }

    private static String readSplitLine(BufferedReader reader, StringBuilder sb) throws IOException {
        String line = reader.readLine();
        if (line == null || line.length() <= 0 || line.charAt(line.length() - 1) != '\\') {
            return line;
        }
        sb.setLength(0);
        sb.append(line, 0, line.length() - 1);
        while ((line = reader.readLine()) != null && line.length() > 0 && line.charAt(line.length() - 1) == '\\') {
            sb.append(line, 0, line.length() - 1);
        }
        if (line == null) {
            if (sb.length() == 0) {
                return null;
            }
            return sb.toString();
        }
        return sb.append(line).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAndMerge(String fileName, String fileLocation, Map accumulator, boolean suppressLog, boolean useJavaPropertyLoader) throws Exception {
        if (fileLocation == null) {
            fileLocation = "";
        }
        if (!suppressLog) {
            log.info("Attempting to load " + fileName + " from " + fileLocation);
        }
        InputStream is = null;
        String loadedFromLocation = fileLocation;
        String loadedFilename = fileName;
        ISCFile file = null;
        if (fileLocation.equals("CLASSPATH")) {
            file = ISCFile.newInstance(DataTools.resourceFromClassLoader(fileName));
        } else {
            String path = fileName;
            if (!"".equals(fileLocation)) {
                path = fileLocation + "/" + fileName;
            } else {
                loadedFromLocation = fileName;
            }
            file = ISCFile.newInstance(path);
        }
        if (!file.exists()) {
            if (!suppressLog) {
                log.info("Unable to locate " + fileName + " in " + fileLocation);
            }
            throw new Exception("File not found: " + fileName);
        }
        loadedFilename = file.getCanonicalPath();
        is = file.getInputStream();
        loadedFromLocation = loadedFromLocation + " at location: " + loadedFilename;
        try {
            Map<Object, Object> thisConfig = null;
            if (useJavaPropertyLoader) {
                Properties props = new Properties();
                props.load(is);
                thisConfig = props;
            } else {
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
                StringBuilder sb = new StringBuilder();
                String line = null;
                thisConfig = new ConcurrentHashMap();
                Matcher matcher = VALID_CONFIG_LINE_PATTERN.matcher("");
                while ((line = ConfigLoader.readSplitLine(reader, sb)) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    if (!matcher.reset(line).find()) {
                        log.warn("Ignoring invalid config line: " + line);
                        continue;
                    }
                    String key = matcher.group(1).trim();
                    String value = matcher.group(3).trim();
                    thisConfig.put(key, value);
                }
            }
            DataTools.mapMerge(thisConfig, accumulator);
            LinkedHashMap<String, Object> configInfo = new LinkedHashMap<String, Object>();
            configInfo.put("name", fileName);
            configInfo.put("location", fileLocation);
            configInfo.put("loaded_from", loadedFromLocation);
            configInfo.put("filename", loadedFilename);
            configInfo.put("contents", new TreeMap<Object, Object>(thisConfig));
            configInfo.put("type", useJavaPropertyLoader ? "java" : "isomorphic");
            Config.loadedConfigFiles.add(configInfo);
            log.info("Successfully loaded " + fileName + " from " + loadedFromLocation);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Map load(InputStream is) throws IOException {
        return ConfigLoader.load(is, new ConcurrentHashMap());
    }

    public static Map load(InputStream is, Map accumulator) throws IOException {
        return ConfigLoader.load(new InputStreamReader(is, Charset.forName("UTF-8")), accumulator);
    }

    public static Map load(Reader r, Map accumulator) throws IOException {
        LineNumberReader reader = new LineNumberReader(r);
        StringBuilder sb = new StringBuilder();
        String line = null;
        ConcurrentHashMap<String, String> thisConfig = new ConcurrentHashMap<String, String>();
        Matcher matcher = VALID_CONFIG_LINE_PATTERN.matcher("");
        boolean inMultiline = false;
        String multilineValue = null;
        String multilineKey = null;
        ArrayList<String> keysEncountered = new ArrayList<String>();
        while ((line = ConfigLoader.readSplitLine(reader, sb)) != null) {
            if (multilineValue != null && line.trim().endsWith("\"\"\"")) {
                multilineValue = multilineValue + line.trim().substring(0, line.trim().length() - 3);
                thisConfig.put(multilineKey, multilineValue);
                keysEncountered.add(multilineKey);
                multilineValue = null;
                multilineKey = null;
                continue;
            }
            if (multilineValue != null) {
                multilineValue = multilineValue + line + "\n";
                continue;
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (!matcher.reset(line).find()) {
                log.warn("Ignoring invalid config line: " + line);
                continue;
            }
            String key = matcher.group(1).trim();
            String value = matcher.group(3);
            keysEncountered.add(key);
            if (value != null && value.startsWith("\"\"\"")) {
                if (value.trim().endsWith("\"\"\"")) {
                    value = value.substring(3, value.trim().length() - 3);
                    thisConfig.put(key, value);
                    continue;
                }
                multilineKey = key;
                multilineValue = value.substring(3) + "\n";
                continue;
            }
            if ((value = value.trim()).length() == 0) {
                value = null;
            }
            if (value == null) {
                accumulator.remove(key);
                continue;
            }
            thisConfig.put(key, value);
        }
        ConcurrentHashMap<String, String> resultingConfig = new ConcurrentHashMap<String, String>();
        for (String key : thisConfig.keySet()) {
            String value = (String)thisConfig.get(key);
            if (value != null) {
                value = value.replaceAll("\\\\\"\\\\\"\\\\\"", "\"\"\"");
            }
            resultingConfig.put(key, value);
        }
        if (accumulator != null) {
            DataTools.mapMerge(resultingConfig, accumulator);
        }
        return resultingConfig;
    }

    @Override
    public void loadConfig(Config accumulator) throws Exception {
        String configPath;
        String webRoot;
        try {
            this.loadAndMerge(framework, "CLASSPATH", (Map)((Object)accumulator));
        }
        catch (Exception e) {
            throw new Error("Can't find framework.properties - unable to proceed.  Please add this file to your classpath and try again.  Actual error: " + e.toString());
        }
        try {
            this.loadAndMerge(frameworkDevenv, "CLASSPATH", (Map)((Object)accumulator), true, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadAndMerge(project, "CLASSPATH", (Map)((Object)accumulator));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadAndMerge(devenv, "CLASSPATH", (Map)((Object)accumulator), true, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadAndMerge(interfaces, "CLASSPATH", (Map)((Object)accumulator), true, false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.loadAndMerge(server, "CLASSPATH", (Map)((Object)accumulator));
        }
        catch (Exception ignored) {
            webRoot = accumulator.getString("webRoot");
            if ("__AUTODETECT__".equals(webRoot)) {
                webRoot = "__USE_CONTAINER__";
            }
            configPath = webRoot + "/WEB-INF/classes";
            try {
                this.loadAndMerge(server, configPath, (Map)((Object)accumulator));
            }
            catch (Exception ignored2) {
                configPath = webRoot + "/isomorphicConfig";
                try {
                    this.loadAndMerge(server, configPath, (Map)((Object)accumulator));
                }
                catch (Exception ignored3) {
                    log.info("Unable to load " + server);
                }
            }
        }
        String deploymentClassName = "com.isomorphic.internal.Deployment";
        Class<?> deploymentClass = null;
        try {
            deploymentClass = Class.forName(deploymentClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            try {
                deploymentClass = Class.forName(deploymentClassName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deploymentClass != null && accumulator.get("isomorphic.internal") == null) {
            accumulator.put("isomorphic.internal", "true");
            String deploymentMode = (String)accumulator.get("deployment.mode");
            if (deploymentMode == null) {
                Method m = deploymentClass.getMethod("mode", new Class[0]);
                deploymentMode = (String)m.invoke(deploymentClass, new Object[0]);
                accumulator.put("deployment.mode", deploymentMode);
            }
            log.info("Isomorphic internal - starting in deployment mode: " + deploymentMode);
            String serverMode = "server-" + deploymentMode + ".properties";
            try {
                this.loadAndMerge(serverMode, "CLASSPATH", (Map)((Object)accumulator));
            }
            catch (Exception ignored) {
                webRoot = accumulator.getString("webRoot");
                if ("__AUTODETECT__".equals(webRoot)) {
                    webRoot = "__USE_CONTAINER__";
                }
                configPath = webRoot + "/WEB-INF/classes";
                try {
                    this.loadAndMerge(serverMode, configPath, (Map)((Object)accumulator));
                }
                catch (Exception ignored2) {
                    configPath = webRoot + "/isomorphicConfig";
                    try {
                        this.loadAndMerge(serverMode, configPath, (Map)((Object)accumulator));
                    }
                    catch (Exception ignored3) {
                        log.info("Unable to load " + serverMode);
                    }
                }
            }
        }
        List configOverrides = accumulator.getList("loadConfigOverrides", new ArrayList());
        for (String override : configOverrides) {
            try {
                this.loadAndMerge(override, "CLASSPATH", (Map)((Object)accumulator), false, true);
            }
            catch (Exception e) {
                log.warning("Could not load override: " + override + " via CLASSPATH.");
            }
            try {
                this.loadAndMerge(override, "", (Map)((Object)accumulator), false, true);
            }
            catch (Exception e) {
                log.warning("Could not load override: " + override + " via filesystem - skipping.");
            }
        }
        String cliOverride = null;
        try {
            cliOverride = System.getProperty("isc_config.override");
        }
        catch (Exception e) {
            log.warn("Can't check for command-line config override because system's security won't alow access to isc_config.override property.");
        }
        if (cliOverride != null) {
            try {
                this.loadAndMerge(cliOverride, "", (Map)((Object)accumulator), false, true);
            }
            catch (Exception e) {
                try {
                    this.loadAndMerge(cliOverride, "CLASSPATH", (Map)((Object)accumulator), false, true);
                }
                catch (Exception ee) {
                    log.warning("Could not load command-line specified override: " + cliOverride + " via explicit path or CLASSPATH - skipping.");
                }
            }
        }
        Properties systemProps = System.getProperties();
        for (Object key : systemProps.keySet()) {
            if (!key.toString().startsWith("isc_config:")) continue;
            String overrideProp = key.toString().substring("isc_config:".length());
            String value = (String)systemProps.get(key);
            accumulator.put(overrideProp, value);
            log.info("Command line config override -> " + overrideProp + ": " + value);
        }
    }
}

