/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.MessagePart;
import com.google.api.services.gmail.model.MessagePartBody;
import com.google.api.services.gmail.model.MessagePartHeader;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.GmailService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GmailMessageDataSource
extends BasicDataSource {
    private static Logger log = new Logger(GmailMessageDataSource.class.getName());
    private static final long MAX_RESULTS = 100L;

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        ListMessagesResponse listResponse;
        ArrayList messages;
        Map criteria = req.getCriteria();
        ArrayList<Map> records = new ArrayList<Map>();
        String userId = (String)criteria.get("userId");
        Gmail service = GmailService.getGmailService(userId);
        String user = "me";
        long maxResults = 100L;
        if (req.isPaged()) {
            maxResults = req.getEndRow() - req.getStartRow();
        }
        if ((messages = (listResponse = (ListMessagesResponse)service.users().messages().list(user).setMaxResults(Long.valueOf(maxResults)).setQ((String)criteria.get("q")).execute()).getMessages()) == null) {
            messages = new ArrayList();
        }
        log.warn(listResponse.getNextPageToken());
        log.warn(listResponse.getResultSizeEstimate());
        for (Message message : messages) {
            message = (Message)service.users().messages().get(user, message.getId()).setFormat("full").execute();
            Map record = this.getRecord(message);
            record.put("userId", userId);
            records.add(record);
        }
        DSResponse dsResponse = new DSResponse();
        dsResponse.setData(records);
        return dsResponse;
    }

    protected Map getRecord(Message message) throws Exception {
        HashMap<String, Object> record = new HashMap<String, Object>();
        MessagePart payload = message.getPayload();
        List headers = payload.getHeaders();
        record.put("messageId", message.getId());
        record.put("snippet", message.getSnippet());
        for (MessagePartHeader header : headers) {
            String name = header.getName();
            if (!"From".equals(name) && !"To".equals(name) && !"Subject".equals(name) && !"Date".equals(name)) continue;
            record.put(name.toLowerCase(), header.getValue());
        }
        String mimeType = payload.getMimeType();
        record.put("mimeType", mimeType);
        MessagePartBody body = payload.getBody();
        if (body.getData() != null) {
            record.put("body", new String(body.decodeData(), "UTF-8"));
        }
        if (mimeType == null || !mimeType.startsWith("multipart")) {
            return record;
        }
        List parts = payload.getParts();
        log.debug("ID: " + message.getId());
        for (MessagePart part : parts) {
            String filename = part.getFilename();
            body = part.getBody();
            if (filename != null && filename.length() > 0) {
                record.put("hasAttachments", true);
                log.debug(filename + ": " + body.getAttachmentId());
                continue;
            }
            if (body.getData() != null) {
                record.put("body", new String(body.decodeData(), "UTF-8"));
                continue;
            }
            mimeType = part.getMimeType();
            if (mimeType == null || !mimeType.startsWith("multipart")) continue;
            List nestedParts = part.getParts();
            log.debug("# parts: " + nestedParts.size());
            body = ((MessagePart)nestedParts.get(0)).getBody();
            if (body.getData() == null) continue;
            record.put("body", new String(body.decodeData(), "UTF-8"));
        }
        return record;
    }
}

