/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages.desktop;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum DesktopUtilsMessage implements Message
{
    GET_STRING(1),
    GET_OPERA_PATH(2),
    GET_LARGE_PREFERENCES_PATH(3),
    GET_SMALL_PREFERENCES_PATH(4),
    GET_CACHE_PREFERENCES_PATH(5),
    GET_OPERA_PID(6),
    DEFAULT(-1);

    private static final Map<Integer, DesktopUtilsMessage> lookup;
    private final int code;

    private DesktopUtilsMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "desktop-utils";
    }

    public static DesktopUtilsMessage get(int code) {
        DesktopUtilsMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])DesktopUtilsMessage.values()), (Function)new Function<DesktopUtilsMessage, Integer>(){

            public Integer apply(DesktopUtilsMessage message) {
                return message.getID();
            }
        });
    }
}

