package ${package}.client;

import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import org.apache.commons.io.IOUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleClient {

    private static final MediaType MEDIA_TYPE_XML = MediaType.parse("text/xml; charset=utf-8");
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleClient.class);

    public static void main(String[] args) throws IOException {

        String url = "http://localhost:8080/${module-short-name}/sc/RESTHandler";
        String resource = "/fetch-request.xml";

        if (System.getProperty("url") != null) {
            url = System.getProperty("url");
        }
        if (System.getProperty("xml") != null) {
            resource = System.getProperty("xml");
        }

        LOGGER.info("Posting content of the resource at '{}' to '{}'", resource, url);

        String xml = IOUtils.toString(SampleClient.class.getResource(resource), "UTF-8");

        Request request = new Request.Builder()
            .url(url)
            .post(RequestBody.create(MEDIA_TYPE_XML, xml))
            .build();

        OkHttpClient client = new OkHttpClient();
        Response response = client.newCall(request).execute();

        if (!response.isSuccessful()) {
            throw new IOException("Request Failed with response:\n" + response);
        }

        LOGGER.info("Server response: \n{}", response.body().string());
    }
}