/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.resources.css.ast.CssCharset;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssFontFace;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssPageRule;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssUnknownAtRule;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.HasNodes;
import com.google.gwt.resources.css.ast.HasProperties;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.flute.parser.Parser;

public class GenerateCssAst {
    private static final String LITERAL_FUNCTION_NAME = "literal";
    private static final Map<List<URL>, SoftReference<CachedStylesheet>> SHEETS = Collections.synchronizedMap(new HashMap());
    private static final String VALUE_FUNCTION_NAME = "value";

    public static CssStylesheet exec(TreeLogger logger, URL ... stylesheets) throws UnableToCompleteException {
        CachedStylesheet toReturn;
        long mtime = ResourceGeneratorUtil.getLastModified(stylesheets, logger);
        List<URL> sheets = Arrays.asList(stylesheets);
        SoftReference<CachedStylesheet> ref = SHEETS.get(sheets);
        CachedStylesheet cachedStylesheet = toReturn = ref == null ? null : ref.get();
        if (toReturn != null) {
            if (mtime != 0L && mtime <= toReturn.getTimestamp()) {
                logger.log(TreeLogger.DEBUG, "Using cached result");
                return toReturn.getCopyOfStylesheet();
            }
            logger.log(TreeLogger.DEBUG, "Invalidating cached stylesheet");
        }
        Parser p = new Parser();
        Errors errors = new Errors(logger);
        GenerationHandler g = new GenerationHandler(errors);
        p.setDocumentHandler((DocumentHandler)g);
        p.setErrorHandler((ErrorHandler)errors);
        for (URL stylesheet : sheets) {
            TreeLogger branchLogger = logger.branch(TreeLogger.DEBUG, "Parsing CSS stylesheet " + stylesheet.toExternalForm());
            try {
                p.parseStyleSheet(stylesheet.toURI().toString());
                continue;
            }
            catch (CSSException e) {
                branchLogger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            }
            catch (IOException e) {
                branchLogger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            }
            catch (URISyntaxException e) {
                branchLogger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            }
            throw new UnableToCompleteException();
        }
        if (errors.fatalErrorEncountered) {
            throw new UnableToCompleteException();
        }
        toReturn = new CachedStylesheet(g.css, mtime);
        SHEETS.put(new ArrayList<URL>(sheets), new SoftReference<CachedStylesheet>(toReturn));
        return toReturn.getCopyOfStylesheet();
    }

    private static CssProperty.Value colorValue(LexicalUnit colors) {
        String sb;
        String sg;
        LexicalUnit red = colors;
        int r = GenerateCssAst.getRgbComponentValue(red);
        LexicalUnit green = red.getNextLexicalUnit().getNextLexicalUnit();
        int g = GenerateCssAst.getRgbComponentValue(green);
        LexicalUnit blue = green.getNextLexicalUnit().getNextLexicalUnit();
        int b = GenerateCssAst.getRgbComponentValue(blue);
        String sr = Integer.toHexString(r);
        if (sr.length() == 1) {
            sr = "0" + sr;
        }
        if ((sg = Integer.toHexString(g)).length() == 1) {
            sg = "0" + sg;
        }
        if ((sb = Integer.toHexString(b)).length() == 1) {
            sb = "0" + sb;
        }
        if (sr.charAt(0) == sr.charAt(1) && sg.charAt(0) == sg.charAt(1) && sb.charAt(0) == sb.charAt(1)) {
            sr = sr.substring(1);
            sg = sg.substring(1);
            sb = sb.substring(1);
        }
        return new CssProperty.IdentValue("#" + sr + sg + sb);
    }

    private static String escapeIdent(String selector) {
        assert (selector.length() > 0);
        StringBuilder toReturn = new StringBuilder();
        if (selector.charAt(0) == '-') {
            selector = selector.substring(1);
            toReturn.append('-');
        }
        if (!GenerateCssAst.isIdentStart(selector.charAt(0))) {
            toReturn.append('\\');
        }
        toReturn.append(selector.charAt(0));
        if (selector.length() > 1) {
            for (char c : selector.substring(1).toCharArray()) {
                if (!GenerateCssAst.isIdentPart(c)) {
                    toReturn.append('\\');
                }
                toReturn.append(c);
            }
        }
        return toReturn.toString();
    }

    private static void extractValueOf(List<CssProperty.Value> accumulator, LexicalUnit value) {
        do {
            accumulator.add(GenerateCssAst.valueOf(value));
        } while ((value = value.getNextLexicalUnit()) != null);
    }

    private static CssIf findLastIfInChain(List<CssNode> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        CssNode lastNode = nodes.get(nodes.size() - 1);
        if (lastNode instanceof CssIf) {
            CssIf asIf = (CssIf)lastNode;
            if (asIf.getElseNodes().isEmpty()) {
                return asIf;
            }
            return GenerateCssAst.findLastIfInChain(asIf.getElseNodes());
        }
        return null;
    }

    private static int getRgbComponentValue(LexicalUnit color) {
        switch (color.getLexicalUnitType()) {
            case 13: {
                return Math.min(color.getIntegerValue(), 255);
            }
            case 23: {
                return (int)Math.min(color.getFloatValue() * 255.0f, 255.0f);
            }
        }
        throw new CSSException(2, "RGB component value must be integer or percentage, was " + color, null);
    }

    private static boolean isIdentPart(char c) {
        return Character.isLetterOrDigit(c) || c == '\\' || c == '-' || c == '_';
    }

    private static boolean isIdentStart(char c) {
        return Character.isLetter(c) || c == '\\' || c == '_';
    }

    private static String join(Iterable<CssProperty.Value> elements, String separator) {
        StringBuilder b = new StringBuilder();
        Iterator<CssProperty.Value> i = elements.iterator();
        while (i.hasNext()) {
            b.append(i.next().toCss());
            if (!i.hasNext()) continue;
            b.append(separator);
        }
        return b.toString();
    }

    private static String maybeUnquote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static String unescapeLiteral(String s) {
        s = s.replaceAll(Pattern.quote("\\\""), "\"");
        s = s.replaceAll(Pattern.quote("\\\\"), Matcher.quoteReplacement("\\"));
        return s;
    }

    private static String valueOf(Condition condition) {
        if (condition instanceof AttributeCondition) {
            AttributeCondition c = (AttributeCondition)condition;
            switch (c.getConditionType()) {
                case 4: {
                    return "[" + c.getLocalName() + (c.getValue() != null ? "=\"" + c.getValue() + '\"' : "") + "]";
                }
                case 7: {
                    return "[" + c.getLocalName() + "~=\"" + c.getValue() + "\"]";
                }
                case 8: {
                    return "[" + c.getLocalName() + "|=\"" + c.getValue() + "\"]";
                }
                case 5: {
                    return "#" + c.getValue();
                }
                case 9: {
                    return "." + c.getValue();
                }
                case 10: {
                    return ":" + c.getValue();
                }
            }
        } else if (condition instanceof CombinatorCondition) {
            CombinatorCondition c = (CombinatorCondition)condition;
            switch (condition.getConditionType()) {
                case 0: {
                    return GenerateCssAst.valueOf(c.getFirstCondition()) + GenerateCssAst.valueOf(c.getSecondCondition());
                }
            }
        } else if (!(condition instanceof ContentCondition)) {
            if (condition instanceof LangCondition) {
                LangCondition c = (LangCondition)condition;
                return ":lang(" + c.getLang() + ")";
            }
            if (condition instanceof NegativeCondition || condition instanceof PositionalCondition) {
                // empty if block
            }
        }
        throw new RuntimeException("Unhandled condition of type " + condition.getConditionType() + " " + condition.getClass().getName());
    }

    private static CssProperty.Value valueOf(LexicalUnit value) {
        switch (value.getLexicalUnitType()) {
            case 37: {
                return new CssProperty.IdentValue("attr(" + value.getStringValue() + ")");
            }
            case 35: {
                return new CssProperty.IdentValue(GenerateCssAst.escapeIdent(value.getStringValue()));
            }
            case 36: {
                return new CssProperty.StringValue(value.getStringValue());
            }
            case 27: {
                return GenerateCssAst.colorValue(value.getParameters());
            }
            case 13: {
                return new CssProperty.NumberValue(value.getIntegerValue());
            }
            case 14: {
                return new CssProperty.NumberValue(value.getFloatValue());
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return new CssProperty.NumberValue(value.getFloatValue(), value.getDimensionUnitText());
            }
            case 24: {
                return new CssProperty.IdentValue("url(" + value.getStringValue() + ")");
            }
            case 0: {
                return new CssProperty.TokenValue(",");
            }
            case 25: 
            case 26: 
            case 41: {
                if (value.getFunctionName().equals(VALUE_FUNCTION_NAME)) {
                    ArrayList<CssProperty.Value> params = new ArrayList<CssProperty.Value>();
                    GenerateCssAst.extractValueOf(params, value.getParameters());
                    if (params.size() != 1 && params.size() != 3) {
                        throw new CSSException(2, "Incorrect number of parameters to value", null);
                    }
                    CssProperty.Value dotPathValue = (CssProperty.Value)params.get(0);
                    String dotPath = GenerateCssAst.maybeUnquote(((CssProperty.StringValue)dotPathValue).getValue());
                    String suffix = params.size() == 3 ? GenerateCssAst.maybeUnquote(((CssProperty.StringValue)params.get(2)).getValue()) : "";
                    return new CssProperty.DotPathValue(dotPath, suffix);
                }
                if (value.getFunctionName().equals(LITERAL_FUNCTION_NAME)) {
                    ArrayList<CssProperty.Value> params = new ArrayList<CssProperty.Value>();
                    GenerateCssAst.extractValueOf(params, value.getParameters());
                    if (params.size() != 1) {
                        throw new CSSException(2, "Incorrect number of parameters to literal", null);
                    }
                    CssProperty.Value expression = (CssProperty.Value)params.get(0);
                    if (!(expression instanceof CssProperty.StringValue)) {
                        throw new CSSException(2, "The single argument to literal must be a string value", null);
                    }
                    String s = GenerateCssAst.maybeUnquote(((CssProperty.StringValue)expression).getValue());
                    s = GenerateCssAst.unescapeLiteral(s);
                    return new CssProperty.IdentValue(s);
                }
                ArrayList<CssProperty.Value> parameters = new ArrayList<CssProperty.Value>();
                GenerateCssAst.extractValueOf(parameters, value.getParameters());
                return new CssProperty.FunctionValue(value.getFunctionName(), new CssProperty.ListValue(parameters));
            }
            case 12: {
                return new CssProperty.IdentValue("inherit");
            }
            case 6: {
                return new CssProperty.TokenValue("^");
            }
            case 10: {
                return new CssProperty.TokenValue(">=");
            }
            case 8: {
                return new CssProperty.TokenValue(">");
            }
            case 9: {
                return new CssProperty.TokenValue("<=");
            }
            case 7: {
                return new CssProperty.TokenValue("<");
            }
            case 2: {
                return new CssProperty.TokenValue("-");
            }
            case 5: {
                return new CssProperty.TokenValue("%");
            }
            case 3: {
                return new CssProperty.TokenValue("*");
            }
            case 1: {
                return new CssProperty.TokenValue("+");
            }
            case 4: {
                return new CssProperty.TokenValue("/");
            }
            case 11: {
                return new CssProperty.IdentValue("~");
            }
            case 38: {
                ArrayList<CssProperty.Value> parameters = new ArrayList<CssProperty.Value>();
                GenerateCssAst.extractValueOf(parameters, value.getParameters());
                return new CssProperty.IdentValue("rect(" + GenerateCssAst.join(parameters, "") + ")");
            }
        }
        throw new RuntimeException("Unhandled LexicalUnit type " + value.getLexicalUnitType());
    }

    private static String valueOf(Selector selector) {
        if (!(selector instanceof CharacterDataSelector)) {
            if (selector instanceof ConditionalSelector) {
                ConditionalSelector s = (ConditionalSelector)selector;
                String simpleSelector = GenerateCssAst.valueOf((Selector)s.getSimpleSelector());
                if ("*".equals(simpleSelector)) {
                    return GenerateCssAst.valueOf(s.getCondition());
                }
                return simpleSelector + GenerateCssAst.valueOf(s.getCondition());
            }
            if (selector instanceof DescendantSelector) {
                DescendantSelector s = (DescendantSelector)selector;
                switch (s.getSelectorType()) {
                    case 11: {
                        if (s.getSimpleSelector().getSelectorType() == 9) {
                            return GenerateCssAst.valueOf(s.getAncestorSelector()) + ":" + GenerateCssAst.valueOf((Selector)s.getSimpleSelector());
                        }
                        return GenerateCssAst.valueOf(s.getAncestorSelector()) + ">" + GenerateCssAst.valueOf((Selector)s.getSimpleSelector());
                    }
                    case 10: {
                        return GenerateCssAst.valueOf(s.getAncestorSelector()) + " " + GenerateCssAst.valueOf((Selector)s.getSimpleSelector());
                    }
                }
            } else {
                if (selector instanceof ElementSelector) {
                    ElementSelector s = (ElementSelector)selector;
                    if (s.getLocalName() == null) {
                        return "*";
                    }
                    return GenerateCssAst.escapeIdent(s.getLocalName());
                }
                if (!(selector instanceof NegativeSelector) && !(selector instanceof ProcessingInstructionSelector) && selector instanceof SiblingSelector) {
                    SiblingSelector s = (SiblingSelector)selector;
                    return GenerateCssAst.valueOf(s.getSelector()) + "+" + GenerateCssAst.valueOf((Selector)s.getSiblingSelector());
                }
            }
        }
        throw new RuntimeException("Unhandled selector of type " + selector.getClass().getName());
    }

    private GenerateCssAst() {
    }

    private static class CachedStylesheet {
        private final CssStylesheet sheet;
        private final long timestamp;

        public CachedStylesheet(CssStylesheet sheet, long timestamp) {
            this.sheet = sheet;
            this.timestamp = timestamp;
        }

        public CssStylesheet getCopyOfStylesheet() {
            return new CssStylesheet(this.sheet);
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private static class PropertyExtractor
    implements DocumentHandler {
        private final List<CssProperty.Value> values;

        private PropertyExtractor(List<CssProperty.Value> values) {
            this.values = values;
        }

        public void comment(String text) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void endFontFace() throws CSSException {
        }

        public void endMedia(SACMediaList media) throws CSSException {
        }

        public void endPage(String name, String pseudoPage) throws CSSException {
        }

        public void endSelector(SelectorList selectors) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            GenerateCssAst.extractValueOf(this.values, value);
        }

        public void startDocument(InputSource source) throws CSSException {
        }

        public void startFontFace() throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
        }

        public void startPage(String name, String pseudoPage) throws CSSException {
        }

        public void startSelector(SelectorList selectors) throws CSSException {
        }
    }

    private static class GenerationHandler
    implements DocumentHandler {
        private final CssStylesheet css = new CssStylesheet();
        private final Stack<HasNodes> currentParent = new Stack();
        private HasProperties currentRule;
        private final Map<String, CssDef> defs = new HashMap<String, CssDef>();
        private final Errors errors;
        private boolean nextSelectorCreatesRule = true;

        public GenerationHandler(Errors errors) {
            this.errors = errors;
            this.currentParent.push(this.css);
        }

        public void comment(String text) throws CSSException {
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void endFontFace() throws CSSException {
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.currentParent.pop();
        }

        public void endPage(String name, String pseudoPage) throws CSSException {
        }

        public void endSelector(SelectorList selectors) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            int idx = atRule.indexOf(" ");
            if (idx == -1) {
                this.addNode(new CssUnknownAtRule(atRule));
                return;
            }
            String ruleName = atRule.substring(1, idx);
            String methodName = "parse" + Character.toUpperCase(ruleName.charAt(0)) + ruleName.substring(1).toLowerCase(Locale.ROOT);
            try {
                Method parseMethod = this.getClass().getDeclaredMethod(methodName, String.class);
                parseMethod.invoke((Object)this, atRule);
            }
            catch (NoSuchMethodException e) {
                this.addNode(new CssUnknownAtRule(atRule));
            }
            catch (IllegalAccessException e) {
                this.errors.log(TreeLogger.ERROR, "Unable to invoke parse method ", e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CSSException) {
                    throw (CSSException)cause;
                }
                if (cause != null) {
                    TreeLogger details = this.errors.branch(TreeLogger.ERROR, cause.getMessage());
                    details.log(TreeLogger.DEBUG, "Full stack trace", cause);
                }
                TreeLogger details = this.errors.branch(TreeLogger.ERROR, "Unknown failure parsing " + ruleName);
                details.log(TreeLogger.DEBUG, "Full stack trace", (Throwable)e);
            }
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            ArrayList<CssProperty.Value> values = new ArrayList<CssProperty.Value>();
            if (value != null) {
                GenerateCssAst.extractValueOf(values, value);
            }
            this.currentRule.getProperties().add(new CssProperty(GenerateCssAst.escapeIdent(name), new CssProperty.ListValue(values), important));
        }

        public void startDocument(InputSource source) throws CSSException {
            if (source.getEncoding() != null && !"ASCII".equals(source.getEncoding())) {
                CssCharset charset = new CssCharset(source.getEncoding());
                this.addNode(charset);
            }
        }

        public void startFontFace() throws CSSException {
            CssFontFace rule = new CssFontFace();
            this.addNode(rule);
            this.currentRule = rule;
        }

        public void startMedia(SACMediaList media) throws CSSException {
            CssMediaRule r = new CssMediaRule();
            for (int i = 0; i < media.getLength(); ++i) {
                r.getMedias().add(media.item(i));
            }
            this.pushParent(r);
        }

        public void startPage(String name, String pseudoPage) throws CSSException {
            CssPageRule r = new CssPageRule();
            r.setPseudoPage(pseudoPage);
            this.addNode(r);
            this.currentRule = r;
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            CssRule r;
            if (this.nextSelectorCreatesRule) {
                r = new CssRule();
                this.addNode(r);
                this.currentRule = r;
            } else {
                r = (CssRule)this.currentRule;
                this.nextSelectorCreatesRule = true;
            }
            for (int i = 0; i < selectors.getLength(); ++i) {
                r.getSelectors().add(new CssSelector(GenerateCssAst.valueOf(selectors.item(i))));
            }
        }

        void parseCharset(String atRule) {
            this.errors.log(TreeLogger.WARN, "Charset declaration detected. A charset at-rule is not relevant inside a style element");
        }

        void parseDef(String atRule) {
            ArrayList values;
            block6: {
                String value = atRule.substring(4, atRule.length()).trim();
                InputSource s = new InputSource();
                s.setCharacterStream((Reader)new StringReader(value));
                Parser parser = new Parser();
                parser.setErrorHandler((ErrorHandler)this.errors);
                values = new ArrayList();
                parser.setDocumentHandler((DocumentHandler)new PropertyExtractor(values));
                try {
                    String dummy = "* { prop : " + value + "}";
                    parser.parseStyleSheet(new InputSource((Reader)new StringReader(dummy)));
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)"Should never happen");
                }
            }
            if (values.size() < 2) {
                throw new CSSException(2, "@def rules must specify an identifier and one or more values", null);
            }
            CssProperty.IdentValue defName = ((CssProperty.Value)values.get(0)).isIdentValue();
            if (defName == null) {
                throw new CSSException(2, "First lexical unit must be an identifier", null);
            }
            ListIterator<CssProperty.Value> it = values.listIterator(1);
            while (it.hasNext()) {
                CssDef previousDef;
                CssProperty.IdentValue maybeDefReference = ((CssProperty.Value)it.next()).isIdentValue();
                if (maybeDefReference == null || (previousDef = this.defs.get(maybeDefReference.getIdent())) == null) continue;
                it.remove();
                for (CssProperty.Value previousValue : previousDef.getValues()) {
                    it.add(previousValue);
                }
            }
            CssDef def = new CssDef(defName.getIdent());
            def.getValues().addAll(values.subList(1, values.size()));
            this.addNode(def);
            this.defs.put(defName.getIdent(), def);
        }

        void parseElif(String atRule) throws CSSException {
            List<CssNode> nodes = this.currentParent.peek().getNodes();
            CssIf lastIf = GenerateCssAst.findLastIfInChain(nodes);
            if (lastIf == null) {
                throw new CSSException(2, "@elif must immediately follow an @if or @elif", null);
            }
            assert (lastIf.getElseNodes().isEmpty());
            this.parseIf(atRule.substring(2));
            lastIf.getElseNodes().add(nodes.remove(nodes.size() - 1));
        }

        void parseElse(String atRule) throws CSSException {
            CssIf lastIf = GenerateCssAst.findLastIfInChain(this.currentParent.peek().getNodes());
            if (lastIf == null) {
                throw new CSSException(2, "@else must immediately follow an @if or @elif", null);
            }
            String fakeElif = "@elif (true) " + atRule.substring(atRule.indexOf("{"));
            this.parseElif(fakeElif);
            CssIf elseIf = GenerateCssAst.findLastIfInChain(this.currentParent.peek().getNodes());
            assert (lastIf.getElseNodes().size() == 1 && lastIf.getElseNodes().get(0) == elseIf);
            assert (elseIf.getElseNodes().isEmpty());
            lastIf.getElseNodes().clear();
            lastIf.getElseNodes().addAll(elseIf.getNodes());
        }

        void parseEval(String atRule) throws CSSException {
            String[] parts = atRule.substring(0, atRule.length() - 1).split("\\s");
            if (parts.length != 3) {
                throw new CSSException(2, "Incorrect number of parts for @eval", null);
            }
            CssEval eval = new CssEval(parts[1], parts[2]);
            this.addNode(eval);
        }

        void parseExternal(String atRule) throws CSSException {
            String[] parts = atRule.substring("@external ".length(), atRule.length() - 1).replaceAll("(,|\\s)\\s*", " ").replaceAll("\\.", "").split(" ");
            CssExternalSelectors externals = new CssExternalSelectors();
            Collections.addAll(externals.getClasses(), parts);
            this.addNode(externals);
        }

        void parseIf(String atRule) throws CSSException {
            String predicate = atRule.substring(3, atRule.indexOf(123) - 1).trim();
            String blockContents = atRule.substring(atRule.indexOf(123) + 1, atRule.length() - 1);
            CssIf cssIf = new CssIf();
            if (predicate.startsWith("(") && predicate.endsWith(")")) {
                cssIf.setExpression(predicate);
            } else {
                String[] predicateParts = predicate.split("\\s");
                switch (predicateParts.length) {
                    case 0: {
                        throw new CSSException(2, "Incorrect format for @if predicate", null);
                    }
                    case 1: {
                        if (predicateParts[0].length() == 0) {
                            throw new CSSException(2, "Incorrect format for @if predicate", null);
                        }
                        this.errors.log(TreeLogger.WARN, "Deprecated syntax for Java expression detected. Enclose the expression in parentheses");
                        cssIf.setExpression(predicateParts[0]);
                        break;
                    }
                    default: {
                        if (predicateParts[0].startsWith("!")) {
                            cssIf.setNegated(true);
                            cssIf.setProperty(predicateParts[0].substring(1));
                        } else {
                            cssIf.setProperty(predicateParts[0]);
                        }
                        String[] values = new String[predicateParts.length - 1];
                        System.arraycopy(predicateParts, 1, values, 0, values.length);
                        cssIf.setPropertyValues(values);
                    }
                }
            }
            this.parseInnerStylesheet("@if", cssIf, blockContents);
        }

        void parseNoflip(String atRule) throws CSSException {
            String blockContents = atRule.substring(atRule.indexOf(123) + 1, atRule.length() - 1);
            this.parseInnerStylesheet("@noflip", new CssNoFlip(), blockContents);
        }

        void parseSprite(String atRule) throws CSSException {
            CssSprite sprite = new CssSprite();
            this.currentRule = sprite;
            this.addNode(sprite);
            this.nextSelectorCreatesRule = false;
            InputSource s = new InputSource();
            s.setCharacterStream((Reader)new StringReader(atRule.substring(7)));
            Parser parser = new Parser();
            parser.setDocumentHandler((DocumentHandler)this);
            parser.setErrorHandler((ErrorHandler)this.errors);
            try {
                parser.parseRule(s);
            }
            catch (IOException e) {
                throw new CSSException(2, "Unable to parse @sprite", (Exception)e);
            }
        }

        void parseUrl(String atRule) throws CSSException {
            String[] parts = atRule.substring(0, atRule.length() - 1).split("\\s");
            if (parts.length != 3) {
                throw new CSSException(2, "Incorrect number of parts for @url", null);
            }
            CssUrl url = new CssUrl(parts[1], parts[2]);
            this.addNode(url);
        }

        private void addNode(CssNode node) {
            this.currentParent.peek().getNodes().add(node);
        }

        private <T extends CssNode> void parseInnerStylesheet(String tagName, T parent, String blockContents) {
            this.pushParent(parent);
            InputSource s = new InputSource();
            s.setCharacterStream((Reader)new StringReader(blockContents));
            Parser parser = new Parser();
            parser.setDocumentHandler((DocumentHandler)this);
            parser.setErrorHandler((ErrorHandler)this.errors);
            try {
                parser.parseStyleSheet(s);
            }
            catch (IOException e) {
                throw new CSSException(2, "Unable to parse " + tagName, (Exception)e);
            }
            if (this.currentParent.pop() != parent) {
                throw new RuntimeException("Incorrect element popped");
            }
        }

        private <T extends CssNode> void pushParent(T newParent) {
            this.addNode(newParent);
            this.currentParent.push((HasNodes)((Object)newParent));
        }
    }

    private static class Errors
    implements ErrorHandler {
        private boolean fatalErrorEncountered;
        private TreeLogger logger;
        private final TreeLogger parentLogger;

        public Errors(TreeLogger parentLogger) {
            this.parentLogger = parentLogger;
        }

        public TreeLogger branch(TreeLogger.Type type, String message) {
            return this.branch(type, message, null);
        }

        public TreeLogger branch(TreeLogger.Type type, String message, Throwable t) {
            return this.logOrBranch(type, message, t, true);
        }

        public void error(CSSParseException exception) throws CSSException {
            this.log(TreeLogger.WARN, exception);
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            this.log(TreeLogger.ERROR, exception);
        }

        public void log(TreeLogger.Type type, String message) {
            this.log(type, message, null);
        }

        public void log(TreeLogger.Type type, String message, Throwable t) {
            this.logOrBranch(type, message, t, false);
        }

        public void warning(CSSParseException exception) throws CSSException {
            this.log(TreeLogger.DEBUG, exception);
        }

        private void log(TreeLogger.Type type, CSSParseException e) {
            this.log(type, "Line " + e.getLineNumber() + " column " + e.getColumnNumber() + ": " + e.getMessage());
        }

        private TreeLogger logOrBranch(TreeLogger.Type type, String message, Throwable t, boolean branch) {
            this.fatalErrorEncountered |= type == TreeLogger.ERROR;
            if (this.parentLogger.isLoggable(type)) {
                this.maybeBranch();
                if (branch) {
                    return this.logger.branch(type, message, t);
                }
                this.logger.log(type, message, t);
                return null;
            }
            return TreeLogger.NULL;
        }

        private void maybeBranch() {
            if (this.logger == null) {
                this.logger = this.parentLogger.branch(TreeLogger.INFO, "The following problems were detected");
            }
        }
    }
}

