package com.smartgwt.client.widgets.calendar;

import java.util.Date;

/**
 * Called to determine the hover text to show during drag operations in Calendars
 */
public abstract class DragHoverCustomizer {
    
    private Calendar calendar;

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }    

    /**
     * Returns the Calendar over which the hover occurred
     * @return Calendar over which the hover occurred
     */
    public Calendar getCalendar() {
        return this.calendar;
    }
    
    /**
     * getHoverHTML() should be implemented and return the string of HTML to display in the hover during a drag operation
     * @param calendarEvent CalendarEvent the existing event being dragged, or the details of the current drag-select range, representing a new event
     * @param defaultValue String the default hover text as generated by the Timeline
     * @param calendarView CalendarView a reference to the calendarView containing the drag
     * @return String The formatted hover text for the values passed in
     */
    public abstract String getHoverHTML(CalendarEvent event, String defaultValue, CalendarView view);
}
